from __future__ import annotations

import logging
from dataclasses import dataclass, field
from enum import Enum
from typing import Optional

from cimgraph.data_profile.identity import Identity, stereotype
from cimgraph.data_profile.units import CIMUnit, UnitMultiplier, UnitSymbol

_log = logging.getLogger(__name__)
'''
Annotated CIMantic Graphs data profile for Asset
Generated by CIMTool http://cimtool.org
'''

class CIMStereotype(Enum):
    Attribute = 'Attribute'
    ByReference = 'ByReference'
    CIMDatatype = 'CIMDatatype'
    Concrete = 'Concrete'
    Description = 'Description'
    Primitive = 'Primitive'
    ShadowExtension = 'ShadowExtension'
    enumeration = 'enumeration'
    gmdm = 'gmdm'

BASE_URI = 'http://www.ucaiug.org/gmdm/asset#'
ONTOLOGY_URI = 'http://cim.ucaiug.io/CIM101/draft#'


@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a class that provides common identification for all classes needing
    identification and naming attributes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The description is a free human readable text describing or naming the
            object. It may be non unique and may not correlate to a naming hierarchy.
            '''

        })
    '''
    The description is a free human readable text describing or naming
    the object. It may be non unique and may not correlate to a naming
    hierarchy.
    '''

    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The name is any free human readable and possibly non unique text naming
            the object.
            '''

        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''

@dataclass(repr=False)
class AssetInfo(IdentifiedObject):
    '''
    Set of attributes of an asset, representing typical datasheet information
    of a physical device that can be instantiated and shared in different data
    exchange contexts:
    - as attributes of an asset instance (installed or in stock)
    - as attributes of an asset model (product by a manufacturer)
    - as attributes of a type asset (generic type of an asset as used in designs/extension
    planning).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.AssetDatasheet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All power system resources with this datasheet information.
            '''

        })
    '''
    All power system resources with this datasheet information.
    '''

@dataclass(repr=False)
class ConductingAssetInfo(AssetInfo):
    '''
    Generic information for conducting asset
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated current.
            '''

        })
    '''
    Rated current.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage.
            '''

        })
    '''
    Rated voltage.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerEndInfo(ConductingAssetInfo):
    '''
    Transformer end data.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    EnergisedEndNoLoadTests: list[NoLoadTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NoLoadTest.EnergisedEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All no-load test measurements in which this transformer end was energised.
            '''

        })
    '''
    All no-load test measurements in which this transformer end was energised.
    '''

    EnergisedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShortCircuitTest.EnergisedEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All short-circuit test measurements in which this transformer end was energised.
            '''

        })
    '''
    All short-circuit test measurements in which this transformer end was
    energised.
    '''

    GroundedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShortCircuitTest.GroundedEnds',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All short-circuit test measurements in which this transformer end was short-circuited.
            '''

        })
    '''
    All short-circuit test measurements in which this transformer end was
    short-circuited.
    '''

    endNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number for this transformer end, corresponding to the end's order in the
            PowerTransformer.vectorGroup attribute. Highest voltage winding should
            be 1.
            '''

        })
    '''
    Number for this transformer end, corresponding to the end's order in
    the PowerTransformer.vectorGroup attribute. Highest voltage winding
    should be 1.
    '''

    phaseAngleClock: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Winding phase angle where 360 degrees are represented with clock hours,
            so the valid values are {0, ..., 11}. For example, to express the second
            winding in code 'Dyn11', set attributes as follows: 'endNumber'=2, 'connectionKind'
            = Yn and 'phaseAngleClock' = 11.
            '''

        })
    '''
    Winding phase angle where 360 degrees are represented with clock hours,
    so the valid values are {0, ..., 11}. For example, to express the second
    winding in code 'Dyn11', set attributes as follows: 'endNumber'=2,
    'connectionKind' = Yn and 'phaseAngleClock' = 11.
    '''

    connectionKind: Optional[ WindingConnection ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of connection.
            '''

        })
    '''
    Kind of connection.
    '''

    emergencyS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Apparent power that the winding can carry under emergency conditions (also
            called long-term emergency power).
            '''

        })
    '''
    Apparent power that the winding can carry under emergency conditions
    (also called long-term emergency power).
    '''

    insulationU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Basic insulation level voltage rating.
            '''

        })
    '''
    Basic insulation level voltage rating.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC resistance.
            '''

        })
    '''
    DC resistance.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal apparent power rating.
            '''

        })
    '''
    Normal apparent power rating.
    '''

    shortTermS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Apparent power that this winding can carry for a short period of time (in
            emergency).
            '''

        })
    '''
    Apparent power that this winding can carry for a short period of time
    (in emergency).
    '''

    TransformerTankInfo: Optional[TransformerTankInfo] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension gmdm ByReference',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerTankInfo.TransformerEndInfos',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer tank data that this end description is part of.
            '''

        })
    '''
    Transformer tank data that this end description is part of.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerTransformerInfo(AssetInfo):
    '''
    Set of power transformer data, from an equipment library.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TransformerTankInfos: list[TransformerTankInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '1',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTankInfo.PowerTransformerInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Data for all the tanks described by this power transformer data.
            '''

        })
    '''
    Data for all the tanks described by this power transformer data.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerTankInfo(AssetInfo):
    '''
    Set of transformer tank data, from an equipment library.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TransformerEndInfos: list[TransformerEndInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEndInfo.TransformerTankInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Data for all the ends described by this transformer tank data.
            '''

        })
    '''
    Data for all the ends described by this transformer tank data.
    '''

    TransformerTanks: list[TransformerTank] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTank.TransformerTankInfo',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PowerTransformerInfo: Optional[PowerTransformerInfo] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'PowerTransformerInfo.TransformerTankInfos',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power transformer data that this tank description is part of.
            '''

        })
    '''
    Power transformer data that this tank description is part of.
    '''

@dataclass(repr=False)
class PowerSystemResource(IdentifiedObject):
    '''
    A power system resource (PSR) can be an item of equipment such as a switch,
    an equipment container containing many individual items of equipment such
    as a substation, or an organisational entity such as sub-control area.
    Power system resources can have measurements associated.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AssetDatasheet: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.PowerSystemResources',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Datasheet information for this power system resource.
            '''

        })
    '''
    Datasheet information for this power system resource.
    '''

@dataclass(repr=False)
class Equipment(PowerSystemResource):
    '''
    The parts of a power system that are physical devices, electronic or mechanical.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerTank(Equipment):
    '''
    An assembly of two or more coupled windings that transform electrical power
    between voltage levels. These windings are bound on a common core and placed
    in the same tank. Transformer tank can be used to model both single-phase
    and 3-phase transformers.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TransformerTankInfo: Optional[TransformerTankInfo] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension gmdm ByReference',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerTankInfo.TransformerTanks',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class TransformerTest(IdentifiedObject):
    '''
    Test result for transformer ends, such as short-circuit, open-circuit (excitation)
    or no-load test.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    basePower: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Base power at which the tests are conducted, usually equal to the rateds
            of one of the involved transformer ends.
            '''

        })
    '''
    Base power at which the tests are conducted, usually equal to the rateds
    of one of the involved transformer ends.
    '''

    temperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Temperature at which the test is conducted.
            '''

        })
    '''
    Temperature at which the test is conducted.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class NoLoadTest(TransformerTest):
    '''
    No-load test results determine core admittance parameters. They include
    exciting current and core loss measurements from applying voltage to one
    winding. The excitation may be positive sequence or zero sequence. The
    test may be repeated at different voltages to measure saturation.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    energisedEndVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Voltage applied to the winding (end) during test.
            '''

        })
    '''
    Voltage applied to the winding (end) during test.
    '''

    excitingCurrent: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exciting current measured from a positive-sequence or single-phase excitation
            test.
            '''

        })
    '''
    Exciting current measured from a positive-sequence or single-phase
    excitation test.
    '''

    excitingCurrentZero: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exciting current measured from a zero-sequence open-circuit excitation
            test.
            '''

        })
    '''
    Exciting current measured from a zero-sequence open-circuit excitation
    test.
    '''

    loss: Optional[ float | KiloActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Losses measured from a positive-sequence or single-phase excitation test.
            '''

        })
    '''
    Losses measured from a positive-sequence or single-phase excitation
    test.
    '''

    lossZero: Optional[ float | KiloActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Losses measured from a zero-sequence excitation test.
            '''

        })
    '''
    Losses measured from a zero-sequence excitation test.
    '''

    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.EnergisedEndNoLoadTests',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer end that current is applied to in this no-load test.
            '''

        })
    '''
    Transformer end that current is applied to in this no-load test.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ShortCircuitTest(TransformerTest):
    '''
    Short-circuit test results determine mesh impedance parameters. They include
    load losses and leakage impedances. For three-phase windings, the excitation
    can be a positive sequence (the default) or a zero sequence. There shall
    be at least one grounded winding.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    energisedEndStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Tap step number for the energised end of the test pair.
            '''

        })
    '''
    Tap step number for the energised end of the test pair.
    '''

    groundedEndStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Tap step number for the grounded end of the test pair.
            '''

        })
    '''
    Tap step number for the grounded end of the test pair.
    '''

    leakageImpedance: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Leakage impedance measured from a positive-sequence or single-phase short-circuit
            test.
            '''

        })
    '''
    Leakage impedance measured from a positive-sequence or single-phase
    short-circuit test.
    '''

    leakageImpedanceZero: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Leakage impedance measured from a zero-sequence short-circuit test.
            '''

        })
    '''
    Leakage impedance measured from a zero-sequence short-circuit test.
    '''

    loss: Optional[ float | KiloActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Load losses from a positive-sequence or single-phase short-circuit test.
            '''

        })
    '''
    Load losses from a positive-sequence or single-phase short-circuit
    test.
    '''

    lossZero: Optional[ float | KiloActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Load losses from a zero-sequence short-circuit test.
            '''

        })
    '''
    Load losses from a zero-sequence short-circuit test.
    '''

    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.EnergisedEndShortCircuitTests',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer end that voltage is applied to in this short-circuit test.
            The test voltage is chosen to induce rated current in the energised end.
            '''

        })
    '''
    Transformer end that voltage is applied to in this short-circuit test.
    The test voltage is chosen to induce rated current in the energised
    end.
    '''

    GroundedEnds: list[TransformerEndInfo] = field(
        default_factory=list,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEndInfo.GroundedEndShortCircuitTests',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All ends short-circuited in this short-circuit test.
            '''

        })
    '''
    All ends short-circuited in this short-circuit test.
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class PhaseCountKind(Enum):
    '''
    Number of phases supported by a device.
    '''

    other = 'other'
    '''
    Other
    '''

    singlePhase = 'singlePhase'
    '''
    Single phase
    '''

    threePhase = 'threePhase'
    '''
    Three phases
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class WindingConnection(Enum):
    '''
    Winding connection type.
    '''

    A = 'A'
    '''
    Autotransformer common winding.
    '''

    D = 'D'
    '''
    Delta.
    '''

    I = 'I'
    '''
    Independent winding, for single-phase connections.
    '''

    Y = 'Y'
    '''
    Wye.
    '''

    Yn = 'Yn'
    '''
    Wye, with neutral brought out for grounding.
    '''

    Z = 'Z'
    '''
    ZigZag.
    '''

    Zn = 'Zn'
    '''
    ZigZag, with neutral brought out for grounding.
    '''

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ApparentPower(CIMUnit):
    '''
    Product of the RMS value of the voltage and the RMS value of the current.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.VA
    def __init__(self, value, input_unit: str='VA', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class CurrentFlow(CIMUnit):
    '''
    Electrical current with sign convention: positive flow is out of the conducting
    equipment into the connectivity node. Can be both AC and DC.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.A
    def __init__(self, value, input_unit: str='A', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Impedance(CIMUnit):
    '''
    Ratio of voltage to current.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohm
    def __init__(self, value, input_unit: str='ohm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class KiloActivePower(CIMUnit):
    '''
    Active power in kilowatts.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.k)
    @property # read-only
    def unit(self):
        return UnitSymbol.W
    def __init__(self, value, input_unit: str='W', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class PerCent(CIMUnit):
    '''
    Percentage on a defined base. For example, specify as 100 to indicate at
    the defined base.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.none
    def __init__(self, value, input_unit: str='none', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Resistance(CIMUnit):
    '''
    Resistance (real part of impedance).
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohm
    def __init__(self, value, input_unit: str='ohm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Temperature(CIMUnit):
    '''
    Value of temperature in degrees Celsius.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.degC
    def __init__(self, value, input_unit: str='degC', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Voltage(CIMUnit):
    '''
    Electrical voltage, can be both AC and DC.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.V
    def __init__(self, value, input_unit: str='V', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
