from __future__ import annotations

import logging
from dataclasses import dataclass, field
from enum import Enum
from typing import Optional

from cimgraph.data_profile.identity import Identity, stereotype
from cimgraph.data_profile.units import CIMUnit, UnitMultiplier, UnitSymbol

_log = logging.getLogger(__name__)
'''
Annotated CIMantic Graphs data profile for Profile
Generated by CIMTool http://cimtool.org
'''

class CIMStereotype(Enum):
    AggregateOf = 'AggregateOf'
    Attribute = 'Attribute'
    CIMDatatype = 'CIMDatatype'
    Compound = 'Compound'
    Concrete = 'Concrete'
    European = 'European'
    NC = 'NC'
    NeedsWork = 'NeedsWork'
    OfAggregate = 'OfAggregate'
    Part3Ext = 'Part3Ext'
    Primitive = 'Primitive'
    ShadowExtension = 'ShadowExtension'
    add = 'add'
    archive = 'archive'
    deprecated = 'deprecated'
    enumeration = 'enumeration'
    gmdm = 'gmdm'
    harmonization = 'harmonization'
    informative = 'informative'
    modify = 'modify'
    moved = 'moved'

BASE_URI = 'http://www.ucaiug.org/gmdm/global#'
ONTOLOGY_URI = 'http://cim.ucaiug.io/CIM101/draft#'

@dataclass(repr=False)
class AdditionalAddressInformation(Identity):
    '''
    Address information which cannot be specified through the other attributes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    addressInformationText: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Text for the additional address information.
            '''

        })
    '''
    Text for the additional address information.
    '''

    addressInformationType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Identifies the type of the additional address information (e.g. mail stop,
            attention to).
            '''

        })
    '''
    Identifies the type of the additional address information (e.g. mail
    stop, attention to).
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            For an address having multiple instances of additional address information,
            this specifies the sequence in which the instances should be ordered.
            '''

        })
    '''
    For an address having multiple instances of additional address information,
    this specifies the sequence in which the instances should be ordered.
    '''

    Address: Optional[Address] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Address.AdditionalAddressInformation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The address for which there is additional infomation.
            '''

        })
    '''
    The address for which there is additional infomation.
    '''

@dataclass(repr=False)
class AgentCapability(Identity):
    '''
    Capabilities that are held by a person, organisation or automated agent.
    This can be individual sills, traits and qualities that give indication
    on the agent ability to perform various tasks to archive relevant goals.
    However, this is primarily refer to license and certification held by the
    agent.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    CertificationOrganisation: Optional[Organisation] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Organisation.AgentCapability',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    otherCapabilityKind: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute should be used to specify the Agent's capability requirement
            when the value for the attribute AgentCapability.kind is "other."
            '''

        })
    '''
    This attribute should be used to specify the Agent's capability requirement
    when the value for the attribute AgentCapability.kind is "other."
    '''

    otherSkillLevel: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute should be used to specify the kind of agent capability skill
            level when the value for the attribute AgentCapability.skillLevel is "other."
            '''

        })
    '''
    This attribute should be used to specify the kind of agent capability
    skill level when the value for the attribute AgentCapability.skillLevel
    is "other."
    '''

    reference: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reference to the concrete capability, e.g. license number, certificate
            or training reference.
            '''

        })
    '''
    Reference to the concrete capability, e.g. license number, certificate
    or training reference.
    '''

    kind: Optional[CapabilityRequirementKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of capability reference.
            '''

        })
    '''
    Kind of capability reference.
    '''

    skillLevel: Optional[SkillLevelKind] = field(
        default=None,
        metadata={
        'type': 'enumeration deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Proficiency level of an Agent to operate or maintain a particular type
            of asset and/or perform certain types of work.
            '''

        })
    '''
    Proficiency level of an Agent to operate or maintain a particular type
    of asset and/or perform certain types of work.
    '''

    Agent: Optional[Agent] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Agent.AgentCapability',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    CertificationOrganisation: Optional[Organisation] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Organisation.AgentCapability',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    effectivePeriod: Optional[DateTimeInterval] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Effective period for the capability.
            '''

        })
    '''
    Effective period for the capability.
    '''

@dataclass(repr=False)
class AgentRoleQualification(Identity):
    '''
    A qualification required for an agent to play an agent role. For example,
    certain skills are required and must be certified in order for a person
    (typically a member of a crew) to be qualified to perform a task.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    otherQualificationKind: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute should be used to specify the kind of qualification when
            the value for the attribute AgentRoleQualification.qualificationKind is
            "other."
            '''

        })
    '''
    This attribute should be used to specify the kind of qualification
    when the value for the attribute AgentRoleQualification.qualificationKind
    is "other."
    '''

    otherSkillLevelKind: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute should be used to specify the qualifying skill level when
            the value for the attribute AgentRoleQualification.skillLevel is "other."
            '''

        })
    '''
    This attribute should be used to specify the qualifying skill level
    when the value for the attribute AgentRoleQualification.skillLevel
    is "other."
    '''

    qualificationReference: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A reference to the description of the qualification.
            '''

        })
    '''
    A reference to the description of the qualification.
    '''

    status: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The status of a qualification (the status of a license, for example).
            '''

        })
    '''
    The status of a qualification (the status of a license, for example).
    '''

    qualificationKind: Optional[CapabilityRequirementKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The kind of qualification required to play an agent role.
            '''

        })
    '''
    The kind of qualification required to play an agent role.
    '''

    skillLevel: Optional[SkillLevelKind] = field(
        default=None,
        metadata={
        'type': 'enumeration deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A defined level of skill required to qualify for an agent role.
            '''

        })
    '''
    A defined level of skill required to qualify for an agent role.
    '''

    AgentRole: Optional[AgentRole] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AgentRole.AgentRoleQualification',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    effectiveDatePeriod: Optional[DateTimeInterval] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The time period when the status of a qualification is in effect.
            '''

        })
    '''
    The time period when the status of a qualification is in effect.
    '''

@dataclass(repr=False)
class BranchEndFlow(Identity):
    '''
    Dynamic flows and ratings associated with a branch end.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ExternalInputs'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    MktPowerTransformerEndAFlow: list[MktPowerTransformer] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MktPowerTransformer.EndAFlow',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    MktPowerTransformerEndBFlow: list[MktPowerTransformer] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MktPowerTransformer.EndBFlow',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class BranchGroupTerminal(Identity):
    '''
    A specific directed terminal flow for a branch group.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'OperationalLimits'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    positiveFlowIn: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The flow into the terminal is summed if set true. The flow out of the terminal
            is summed if set false.
            '''

        })
    '''
    The flow into the terminal is summed if set true. The flow out of the
    terminal is summed if set false.
    '''

    BranchGroup: Optional[BranchGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BranchGroup.BranchGroupTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The branch group to which the directed branch group terminals belong.
            '''

        })
    '''
    The branch group to which the directed branch group terminals belong.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.BranchGroupTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The terminal to be summed.
            '''

        })
    '''
    The terminal to be summed.
    '''

@dataclass(repr=False)
class BusinessHours(Identity):
    '''
    The designated days and times during which a business or organisation is
    officially open and available to conduct its operations, provide services,
    or interact with customers and clients.
    The business is open if the opens attribute is specified, and closed otherwise.
    If the value for the closes attribute is less than the value for the opens
    attribute then the hour range is assumed to span over the next day.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    mRID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Master resource identifier issued by a model authority. The mRID is unique
            within an exchange context. Global uniqueness is easily achieved by using
            a UUID, as specified in IETF RFC 4122, for the mRID. The use of UUID is
            strongly recommended.
            For CIMXML data files in RDF syntax conforming to IEC 61970-552, the mRID
            is mapped to rdf:ID or rdf:about attributes that identify CIM object elements.
            '''

        })
    '''
    Master resource identifier issued by a model authority. The mRID is
    unique within an exchange context. Global uniqueness is easily achieved
    by using a UUID, as specified in IETF RFC 4122, for the mRID. The use
    of UUID is strongly recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552, the
    mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
    object elements.
    '''

    closes: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Closing hour of the place or service on the given day(s) of the week.
            '''

        })
    '''
    Closing hour of the place or service on the given day(s) of the week.
    '''

    opens: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Opening hour of the place or service on the given day(s) of the week.
            '''

        })
    '''
    Opening hour of the place or service on the given day(s) of the week.
    '''

    validFrom: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The date when the item becomes valid.
            '''

        })
    '''
    The date when the item becomes valid.
    '''

    validThrough: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Date after when the item is not valid. For example the end of an offer,
            salary period, or a period of opening hours.
            '''

        })
    '''
    Date after when the item is not valid. For example the end of an offer,
    salary period, or a period of opening hours.
    '''

    dayOfWeek: Optional[DayOfWeek] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The day of the week for which these opening hours are valid.
            '''

        })
    '''
    The day of the week for which these opening hours are valid.
    '''

    ContactPoint: Optional[ContactPoint] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ContactPoint.BusinessHours',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class ComModuleInfo(Identity):
    '''
    Communication module asset informtion
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    direction: Optional[ComDirectionKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Communication direction.
            '''

        })
    '''
    Communication direction.
    '''

    technology: Optional[ComTechnologyKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Communication technology.
            '''

        })
    '''
    Communication technology.
    '''

@dataclass(repr=False)
class ContactPoint(Identity):
    '''
    Contact Point represents a snapshot of summary contact information about
    an Agent in relation to a particular Agent Role being played.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    BusinessHours: list[BusinessHours] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BusinessHours.ContactPoint',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    agentIdentifier: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A unique identifier for the Agent
            '''

        })
    '''
    A unique identifier for the Agent
    '''

    availableLanguage: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Language someone may use with or at the item, service or place. Please
            use one of the language codes from the IETF BCP 47 standard.
            IETF language tags combine subtags from other standards such as ISO 639,
            ISO 15924, ISO 3166-1, and UN M.49. The tag structure has been standardized
            by the IETF in Best Current Practice (BCP) 47; the subtags are maintained
            by the IANA Language Subtag Registry.
            '''

        })
    '''
    Language someone may use with or at the item, service or place. Please
    use one of the language codes from the IETF BCP 47 standard.
    IETF language tags combine subtags from other standards such as ISO
    639, ISO 15924, ISO 3166-1, and UN M.49. The tag structure has been
    standardized by the IETF in Best Current Practice (BCP) 47; the subtags
    are maintained by the IANA Language Subtag Registry.
    '''

    chatAddress: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Address to a chat service. Example Skype, WhatsApp etc
            '''

        })
    '''
    Address to a chat service. Example Skype, WhatsApp etc
    '''

    emailAddress: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The email address to be used to contact the Agent in the context of the
            Agent Role being played.
            '''

        })
    '''
    The email address to be used to contact the Agent in the context of
    the Agent Role being played.
    '''

    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The name to be used for the Agent in the context of the Agent Role being
            played.
            '''

        })
    '''
    The name to be used for the Agent in the context of the Agent Role
    being played.
    '''

    roleIdentifier: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A unique identifier for the Agent Role.
            '''

        })
    '''
    A unique identifier for the Agent Role.
    '''

    webAddress: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Address to a web service.
            '''

        })
    '''
    Address to a web service.
    '''

    preferredMethodOfContact: Optional[ContactMethodKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The communication method by which the Agent prefers to be contacted.
            '''

        })
    '''
    The communication method by which the Agent prefers to be contacted.
    '''

    address: Optional[PostalAddress] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The mailing address to be used for the Agent in the context of the Agent
            Role being played.
            '''

        })
    '''
    The mailing address to be used for the Agent in the context of the
    Agent Role being played.
    '''

    Agent: Optional[Agent] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Agent.ContactPoint',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    faxNumber: Optional[TelephoneNumber] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fax number. A number assigned to a particular fax machine and used in making
            connections to it.
            '''

        })
    '''
    Fax number. A number assigned to a particular fax machine and used
    in making connections to it.
    '''

    telephoneNumber: Optional[TelephoneNumber] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The telephone number to be used to contact the Agent in the context of
            the Agent Role being played.
            '''

        })
    '''
    The telephone number to be used to contact the Agent in the context
    of the Agent Role being played.
    '''

@dataclass(repr=False)
class CrewMembership(Identity):
    '''
    Identifies the time period for which an individual crew member was assigned
    to a specific crew.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    effectiveDateTimeInterval: Optional[DateTimeInterval] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The date and time interval a crew member was assigned to a specific crew.
            '''

        })
    '''
    The date and time interval a crew member was assigned to a specific
    crew.
    '''

@dataclass(repr=False)
class CurrentDroopOverride(Identity):
    '''
    Current droop override uses the following logic:
    - When the current exceeds a threshold the device executes the following
    transitions: 1) When injecting an inductive voltage or in monitoring mode
    the device tends to inject a voltage proportional to the difference between
    the line current and the aforementioned threshold. 2) When injecting a
    capacitive voltage the device transitions to monitoring mode.
    - If the aforementioned proportional voltage is lower than the initial
    one, the voltage injection remains unchanged.
    Current droop override is not applied when the device operates in currentDroop
    mode.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'FACTS'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    SSSCController: Optional[SSSCController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SSSCController.CurrentDroopOverride',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SSSC controller to which this CurrentDroopOverride applies to.
            '''

        })
    '''
    The SSSC controller to which this CurrentDroopOverride applies to.
    '''

    mRID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Master resource identifier issued by a model authority. The mRID is unique
            within an exchange context. Global uniqueness is easily achieved by using
            a UUID, as specified in RFC 4122, for the mRID. The use of UUID is strongly
            recommended.
            For CIMXML data files in RDF syntax conforming to IEC 61970-552, the mRID
            is mapped to rdf:ID or rdf:about attributes that identify CIM object elements.
            '''

        })
    '''
    Master resource identifier issued by a model authority. The mRID is
    unique within an exchange context. Global uniqueness is easily achieved
    by using a UUID, as specified in RFC 4122, for the mRID. The use of
    UUID is strongly recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552, the
    mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
    object elements.
    '''

    droopCapacitive: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Droop in capacitive region. The unit is V/A.
            '''

        })
    '''
    Droop in capacitive region. The unit is V/A.
    '''

    droopInductive: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Droop in inductive region. The unit is V/A.
            '''

        })
    '''
    Droop in inductive region. The unit is V/A.
    '''

    enabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True, if the current droop override is enabled (active). Otherwise false.
            '''

        })
    '''
    True, if the current droop override is enabled (active). Otherwise
    false.
    '''

    offsetCapacitiveI: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Offset in capacitive region.
            '''

        })
    '''
    Offset in capacitive region.
    '''

    offsetInductiveI: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Offset in capacitive region.
            '''

        })
    '''
    Offset in capacitive region.
    '''

    targetValueCapacitiveI: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Setpoint when control is active in capacitive region.
            '''

        })
    '''
    Setpoint when control is active in capacitive region.
    '''

    targetValueInductiveI: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Setpoint when control is active in inductive region.
            '''

        })
    '''
    Setpoint when control is active in inductive region.
    '''

    SSSCController: Optional[SSSCController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SSSCController.CurrentDroopOverride',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SSSC controller to which this CurrentDroopOverride applies to.
            '''

        })
    '''
    The SSSC controller to which this CurrentDroopOverride applies to.
    '''

@dataclass(repr=False)
class CurveData(Identity):
    '''
    Multi-purpose data points for defining a curve. The use of this generic
    class is discouraged if a more specific class can be used to specify the
    X and Y axis values along with their specific data types.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    xvalue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The data value of the X-axis variable, depending on the X-axis units.
            '''

        })
    '''
    The data value of the X-axis variable, depending on the X-axis units.
    '''

    y1value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The data value of the first Y-axis variable, depending on the Y-axis units.
            '''

        })
    '''
    The data value of the first Y-axis variable, depending on the Y-axis
    units.
    '''

    y2value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The data value of the second Y-axis variable (if present), depending on
            the Y-axis units.
            '''

        })
    '''
    The data value of the second Y-axis variable (if present), depending
    on the Y-axis units.
    '''

    y3value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The data value of the third Y-axis variable (if present), depending on
            the Y-axis units.
            '''

        })
    '''
    The data value of the third Y-axis variable (if present), depending
    on the Y-axis units.
    '''

    Curve: Optional[Curve] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Curve.CurveDatas',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The curve of this curve data point.
            '''

        })
    '''
    The curve of this curve data point.
    '''

@dataclass(repr=False)
class DiagramObjectGluePoint1(Identity):
    '''
    This is used for grouping diagram object points from different diagram
    objects that are considered to be glued together in a diagram even if they
    are not at the exact same coordinates.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DiagramLayoutEXT'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class DiagramObjectPoint1(Identity):
    '''
    A point in a given space defined by 3 coordinates and associated to a diagram
    object. The coordinates may be positive or negative as the origin does
    not have to be in the corner of a diagram.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DiagramLayout'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The sequence position of the point, used for defining the order of points
            for diagram objects acting as a polyline or polygon with more than one
            point. The attribute shall be a positive value.
            '''

        })
    '''
    The sequence position of the point, used for defining the order of
    points for diagram objects acting as a polyline or polygon with more
    than one point. The attribute shall be a positive value.
    '''

    xPosition: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The X coordinate of this point.
            '''

        })
    '''
    The X coordinate of this point.
    '''

    yPosition: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Y coordinate of this point.
            '''

        })
    '''
    The Y coordinate of this point.
    '''

    zPosition: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Z coordinate of this point.
            '''

        })
    '''
    The Z coordinate of this point.
    '''

    DiagramObject: Optional[DiagramObject] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiagramObject.DiagramObjectPoints',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The diagram object with which the points are associated.
            '''

        })
    '''
    The diagram object with which the points are associated.
    '''

    DiagramObjectGluePoint: Optional[DiagramObjectGluePoint] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiagramObjectGluePoint.DiagramObjectPoints',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The 'glue' point to which this point is associated.
            '''

        })
    '''
    The 'glue' point to which this point is associated.
    '''

@dataclass(repr=False)
class DocumentRole(Identity):
    '''
    An Organisation or Person role with respect to documents.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.deprecated)
@dataclass(repr=False)
class Approver(DocumentRole):
    '''
    Person who accepted/signed or rejected the document.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Documents: list[Document] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Document.Approver',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All documents for this approver.
            '''

        })
    '''
    All documents for this approver.
    '''

@stereotype(CIMStereotype.deprecated)
@dataclass(repr=False)
class Author(DocumentRole):
    '''
    Person who created document or activity record.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ActivityRecords: list[ActivityRecord] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ActivityRecord.Author',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All activity records with this author.
            '''

        })
    '''
    All activity records with this author.
    '''

    Documents: list[Document] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Document.Author',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All documents of this this author.
            '''

        })
    '''
    All documents of this this author.
    '''

@stereotype(CIMStereotype.deprecated)
@dataclass(repr=False)
class Editor(DocumentRole):
    '''
    Person who modified the document.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Documents: list[Document] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Document.Editor',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All documents for this editor.
            '''

        })
    '''
    All documents for this editor.
    '''

@stereotype(CIMStereotype.deprecated)
@dataclass(repr=False)
class Issuer(DocumentRole):
    '''
    Person who issued the document and is responsible for its content.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Documents: list[Document] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Document.Issuer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All documents for this issuer.
            '''

        })
    '''
    All documents for this issuer.
    '''

@dataclass(repr=False)
class FieldDispatchStep(Identity):
    '''
    Details of the step in the field dispatch history.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    occurredDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The date and time at which the dispatch status occurred.
            '''

        })
    '''
    The date and time at which the dispatch status occurred.
    '''

    remarks: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            freeform comments related to the dispatch to perform field work.
            '''

        })
    '''
    freeform comments related to the dispatch to perform field work.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The sequence number of the field dispatch step within the field dispatch
            history. Begins with 1 and increments up.
            '''

        })
    '''
    The sequence number of the field dispatch step within the field dispatch
    history. Begins with 1 and increments up.
    '''

    dispatchStatus: Optional[CrewStatusKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The status of one or more crews dispatched to perform field work at one
            or more work sites
            '''

        })
    '''
    The status of one or more crews dispatched to perform field work at
    one or more work sites
    '''

    FieldDispatchHistory: Optional[FieldDispatchHistory] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FieldDispatchHistory.FieldDispatchStep',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class Fuel(Identity):
    '''
    A class indicating the origin of the fuel used at the related object.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    fuel: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An indication of the fuel used for the energy production, or part of the
            energy production, that is potentially fed into the grid at the related
            object.
            '''

        })
    '''
    An indication of the fuel used for the energy production, or part of
    the energy production, that is potentially fed into the grid at the
    related object.
    '''

    fuelSource: Optional[FuelSource] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An indication of the fuel used for the energy production, or part of the
            energy production, that is potentially fed into the grid at the related
            object.
            '''

        })
    '''
    An indication of the fuel used for the energy production, or part of
    the energy production, that is potentially fed into the grid at the
    related object.
    '''

@dataclass(repr=False)
class GeometricElement(Identity):
    '''
    Exists solely as the parent of the separate geometry types (Point, Line,
    Circle, Polygon) in order to create an xsd Choice between the types.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Geometry: Optional[Geometry] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Geometry.GeometricElement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Circle(GeometricElement):
    '''
    A circular area in space, described by a center point and radius. Any circle
    object must have a center and an outer radius and may have an inner radius.
    If an inner radius is specified, the area within the inner radius is to
    be excluded from the area within the outer radius, forming a ring shape.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    innerRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A circle may have an inner radius. If specified the area described by the
            inner radius is to be excluded from the area within the outer radius, forming
            a ring shape.
            '''

        })
    '''
    A circle may have an inner radius. If specified the area described
    by the inner radius is to be excluded from the area within the outer
    radius, forming a ring shape.
    '''

    outerRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Every circle must have an outer radius which describes the outer limit
            of the circular area.
            '''

        })
    '''
    Every circle must have an outer radius which describes the outer limit
    of the circular area.
    '''

    CircleCenterPositionPoint: Optional[PositionPoint] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PositionPoint.Circle',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A point representing the center of a circular area. Any circle object must
            have one CircleCenter.
            '''

        })
    '''
    A point representing the center of a circular area. Any circle object
    must have one CircleCenter.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class LineElement(GeometricElement):
    '''
    A geometric line segment, described by 2 or more coordinate tuples with
    linear interpolation between them. A line must contain at least 2 linear
    coordinates.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Polygon: Optional[Polygon] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Polygon.OuterBoundaryLineElement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A polygon for which an inner boundary is defined.
            '''

        })
    '''
    A polygon for which an inner boundary is defined.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Polygon(GeometricElement):
    '''
    One or more self-closing line segments representing a polygonal area. In
    order to be self-closing, the first and last linear coordinates of each
    line segment must be identical. A polygon must have one outer boundary
    and may have one or more inner boundaries. If an inner boundary is specified,
    the area within the inner boundary is to be excluded from the area within
    the outer boundary. Each line description within a polygon (both outer
    and inner boundaries) must contain at least 4 linear coordinates.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    OuterBoundaryLineElement: list[LineElement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LineElement.Polygon',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            One or more self-closing line segments representing a polygonal area. In
            order to be self-closing, the first and last linear coordinates of each
            line segment must be identical. A polygon must have one outer boundary
            and may have one or more inner boundaries. If an inner boundary is specified,
            the area within the inner boundary is to be excluded from the area within
            the outer boundary. Each line description within a polygon (both outer
            and inner boundaries) must contain at least 4 linear coordinates.
            '''

        })
    '''
    One or more self-closing line segments representing a polygonal area.
    In order to be self-closing, the first and last linear coordinates
    of each line segment must be identical. A polygon must have one outer
    boundary and may have one or more inner boundaries. If an inner boundary
    is specified, the area within the inner boundary is to be excluded
    from the area within the outer boundary. Each line description within
    a polygon (both outer and inner boundaries) must contain at least 4
    linear coordinates.
    '''

@dataclass(repr=False)
class GeometricElement1(Identity):
    '''
    Exists solely as the parent of the separate geometry types (Point, Line,
    Circle, Polygon) in order to create an xsd Choice between the types.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Geometry: Optional[Geometry] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Geometry.GeometricElement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class DiagramObjectGluePoint(Identity):
    '''
    This is used for grouping diagram object points from different diagram
    objects that are considered to be glued together in a diagram even if they
    are not at the exact same coordinates.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DiagramLayoutEXT'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DiagramObjectPoints: list[DiagramObjectPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiagramObjectPoint.DiagramObjectGluePoint',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A diagram object glue point is associated with 2 or more object points
            that are considered to be 'glued' together.
            '''

        })
    '''
    A diagram object glue point is associated with 2 or more object points
    that are considered to be 'glued' together.
    '''

    DiagramObjectPoints: list[DiagramObjectPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiagramObjectPoint.DiagramObjectGluePoint',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A diagram object glue point is associated with 2 or more object points
            that are considered to be 'glued' together.
            '''

        })
    '''
    A diagram object glue point is associated with 2 or more object points
    that are considered to be 'glued' together.
    '''

@dataclass(repr=False)
class DiagramObjectPoint(Identity):
    '''
    A point in a given space defined by 3 coordinates and associated to a diagram
    object. The coordinates may be positive or negative as the origin does
    not have to be in the corner of a diagram.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DiagramLayout'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The sequence position of the point, used for defining the order of points
            for diagram objects acting as a polyline or polygon with more than one
            point. The attribute shall be a positive value.
            '''

        })
    '''
    The sequence position of the point, used for defining the order of
    points for diagram objects acting as a polyline or polygon with more
    than one point. The attribute shall be a positive value.
    '''

    xPosition: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The X coordinate of this point.
            '''

        })
    '''
    The X coordinate of this point.
    '''

    yPosition: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Y coordinate of this point.
            '''

        })
    '''
    The Y coordinate of this point.
    '''

    zPosition: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Z coordinate of this point.
            '''

        })
    '''
    The Z coordinate of this point.
    '''

    DiagramObject: Optional[DiagramObject] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiagramObject.DiagramObjectPoints',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The diagram object with which the points are associated.
            '''

        })
    '''
    The diagram object with which the points are associated.
    '''

    DiagramObjectGluePoint: Optional[DiagramObjectGluePoint] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiagramObjectGluePoint.DiagramObjectPoints',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The 'glue' point to which this point is associated.
            '''

        })
    '''
    The 'glue' point to which this point is associated.
    '''

@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a class that provides common identification for all classes needing
    identification and naming attributes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DiagramObjects: list[DiagramObject] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiagramObject.IdentifiedObject',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The diagram objects that are associated with the domain object.
            '''

        })
    '''
    The diagram objects that are associated with the domain object.
    '''

    mRID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Master resource identifier issued by a model authority. The mRID is unique
            within an exchange context. Global uniqueness is easily achieved by using
            a UUID, as specified in IETF RFC 4122, for the mRID. The use of UUID is
            strongly recommended.
            For CIMXML data files in RDF syntax conforming to IEC 61970-552, the mRID
            is mapped to rdf:ID or rdf:about attributes that identify CIM object elements.
            '''

        })
    '''
    Master resource identifier issued by a model authority. The mRID is
    unique within an exchange context. Global uniqueness is easily achieved
    by using a UUID, as specified in IETF RFC 4122, for the mRID. The use
    of UUID is strongly recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552, the
    mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
    object elements.
    '''

    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The description is a free human readable text describing or naming the
            object. It may be non unique and may not correlate to a naming hierarchy.
            '''

        })
    '''
    The description is a free human readable text describing or naming
    the object. It may be non unique and may not correlate to a naming
    hierarchy.
    '''

    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The name is any free human readable and possibly non unique text naming
            the object.
            '''

        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''

@dataclass(repr=False)
class ACDCTerminal(IdentifiedObject):
    '''
    An electrical connection point (AC or DC) to a piece of conducting equipment.
    Terminals are connected at physical connection points called connectivity
    nodes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurements associated with this terminal defining where the measurement
            is placed in the network topology. It may be used, for instance, to capture
            the sensor position, such as a voltage transformer (PT) at a busbar or
            a current transformer (CT) at the bar between a breaker and an isolator.
            '''

        })
    '''
    Measurements associated with this terminal defining where the measurement
    is placed in the network topology. It may be used, for instance, to
    capture the sensor position, such as a voltage transformer (PT) at
    a busbar or a current transformer (CT) at the bar between a breaker
    and an isolator.
    '''

    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit sets at the terminal.
            '''

        })
    '''
    The operational limit sets at the terminal.
    '''

    connected: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The connected status is related to a bus-branch model and the topological
            node to terminal relation. True implies the terminal is connected to the
            related topological node and false implies it is not.
            In a bus-branch model, the connected status is used to tell if equipment
            is disconnected without having to change the connectivity described by
            the topological node to terminal relation. A valid case is that conducting
            equipment can be connected in one end and open in the other. In particular
            for an AC line segment, where the reactive line charging can be significant,
            this is a relevant case.
            '''

        })
    '''
    The connected status is related to a bus-branch model and the topological
    node to terminal relation. True implies the terminal is connected to
    the related topological node and false implies it is not.
    In a bus-branch model, the connected status is used to tell if equipment
    is disconnected without having to change the connectivity described
    by the topological node to terminal relation. A valid case is that
    conducting equipment can be connected in one end and open in the other.
    In particular for an AC line segment, where the reactive line charging
    can be significant, this is a relevant case.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The orientation of the terminal connections for a multiple terminal conducting
            equipment. The sequence numbering starts with 1 and additional terminals
            should follow in increasing order. The first terminal is the "starting
            point" for a two terminal branch.
            '''

        })
    '''
    The orientation of the terminal connections for a multiple terminal
    conducting equipment. The sequence numbering starts with 1 and additional
    terminals should follow in increasing order. The first terminal is
    the "starting point" for a two terminal branch.
    '''

    BusNameMarker: Optional[BusNameMarker] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BusNameMarker.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The bus name marker used to name the bus (topological node).
            '''

        })
    '''
    The bus name marker used to name the bus (topological node).
    '''

@dataclass(repr=False)
class DCBaseTerminal(ACDCTerminal):
    '''
    An electrical connection point at a piece of DC conducting equipment. DC
    terminals are connected at one physical DC node that may have multiple
    DC terminals connected. A DC node is similar to an AC connectivity node.
    The model requires that DC connections are distinct from AC connections.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCNode: Optional[DCNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCNode.DCTerminals',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC connectivity node to which this DC base terminal connects with zero
            impedance.
            '''

        })
    '''
    The DC connectivity node to which this DC base terminal connects with
    zero impedance.
    '''

    DCTopologicalNode: Optional[DCTopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCTopologicalNode.DCTerminals',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            See association end Terminal.TopologicalNode.
            '''

        })
    '''
    See association end Terminal.TopologicalNode.
    '''

@dataclass(repr=False)
class ACDCConverterDCTerminal(DCBaseTerminal):
    '''
    A DC electrical connection point at the AC/DC converter. The AC/DC converter
    is electrically connected also to the AC side. The AC connection is inherited
    from the AC conducting equipment in the same way as any other AC equipment.
    The AC/DC converter DC terminal is separate from generic DC terminal to
    restrict the connection with the AC side to AC/DC converter and so that
    no other DC conducting equipment can be connected to the AC side.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    polarity: Optional[DCPolarityKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Represents the normal network polarity condition. Depending on the converter
            configuration the value shall be set as follows:
            - For a monopole with two converter terminals use DCPolarityKind "positive"
            and "negative".
            - For a bi-pole or symmetric monopole with three converter terminals use
            DCPolarityKind "positive", "middle" and "negative".
            '''

        })
    '''
    Represents the normal network polarity condition. Depending on the
    converter configuration the value shall be set as follows:
    - For a monopole with two converter terminals use DCPolarityKind "positive"
    and "negative".
    - For a bi-pole or symmetric monopole with three converter terminals
    use DCPolarityKind "positive", "middle" and "negative".
    '''

    DCConductingEquipment: Optional[ACDCConverter] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCConverter.DCTerminals',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A DC converter terminal belong to an DC converter.
            '''

        })
    '''
    A DC converter terminal belong to an DC converter.
    '''

@dataclass(repr=False)
class DCTerminal(DCBaseTerminal):
    '''
    An electrical connection point to generic DC conducting equipment.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    SvDCPowerFlow: list[SvDCPowerFlow] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvDCPowerFlow.DCTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC power flow state variable associated with the DC terminal.
            '''

        })
    '''
    The DC power flow state variable associated with the DC terminal.
    '''

    polarity: Optional[DCTerminalPolarityKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Represents the normal network polarity condition. Used in DC system configurations
            that have explicit polarity of the terminals, e.g., voltage source converter
            (VSC) technology.
            '''

        })
    '''
    Represents the normal network polarity condition. Used in DC system
    configurations that have explicit polarity of the terminals, e.g.,
    voltage source converter (VSC) technology.
    '''

    DCConductingEquipment: Optional[DCConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCConductingEquipment.DCTerminals',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An DC terminal belong to a DC conducting equipment.
            '''

        })
    '''
    An DC terminal belong to a DC conducting equipment.
    '''

@dataclass(repr=False)
class Terminal(ACDCTerminal):
    '''
    An AC electrical connection point to a piece of conducting equipment. Terminals
    are connected at physical connection points called connectivity nodes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConverterDCSides: list[ACDCConverter] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACDCConverter.PccTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All converters' DC sides linked to this point of common coupling terminal.
            '''

        })
    '''
    All converters' DC sides linked to this point of common coupling terminal.
    '''

    AuxiliaryEquipment: list[AuxiliaryEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AuxiliaryEquipment.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The auxiliary equipment connected to the terminal.
            '''

        })
    '''
    The auxiliary equipment connected to the terminal.
    '''

    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BranchGroupTerminal.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The directed branch group terminals for which this terminal is monitored.
            '''

        })
    '''
    The directed branch group terminals for which this terminal is monitored.
    '''

    HasFirstMutualCoupling: list[MutualCoupling] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MutualCoupling.First_Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Mutual couplings associated with the branch as the first branch.
            '''

        })
    '''
    Mutual couplings associated with the branch as the first branch.
    '''

    HasSecondMutualCoupling: list[MutualCoupling] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MutualCoupling.Second_Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Mutual couplings with the branch associated as the first branch.
            '''

        })
    '''
    Mutual couplings with the branch associated as the first branch.
    '''

    RegulatingControl: list[RegulatingControl] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulatingControl.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The controls regulating this terminal.
            '''

        })
    '''
    The controls regulating this terminal.
    '''

    SvPowerFlow: list[SvPowerFlow] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvPowerFlow.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The power flow state variable associated with the terminal.
            '''

        })
    '''
    The power flow state variable associated with the terminal.
    '''

    TieFlow: list[TieFlow] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TieFlow.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The control area tie flows to which this terminal associates.
            '''

        })
    '''
    The control area tie flows to which this terminal associates.
    '''

    TransformerEnd: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All transformer ends connected at this terminal.
            '''

        })
    '''
    All transformer ends connected at this terminal.
    '''

    UsagePoint: Optional[UsagePoint] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'UsagePoint.Terminal',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    VoltageAngleLimit: list[VoltageAngleLimit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageAngleLimit.AngleReferenceTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage angle limit which has this reference angle terminal.
            '''

        })
    '''
    The voltage angle limit which has this reference angle terminal.
    '''

    phases: Optional[PhaseCode] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Represents the normal network phasing condition. If the attribute is missing,
            three phases (ABC) shall be assumed, except for terminals of grounding
            classes (specializations of EarthFaultCompensator, GroundDisconnector,
            and Ground) which will be assumed to be N. Therefore, phase code ABCN is
            explicitly declared when needed, e.g. for star point grounding equipment.
            The phase code on terminals connecting the same ConnectivityNode or TopologicalNode
            as well as for equipment between two terminals shall be consistent.
            '''

        })
    '''
    Represents the normal network phasing condition. If the attribute is
    missing, three phases (ABC) shall be assumed, except for terminals
    of grounding classes (specializations of EarthFaultCompensator, GroundDisconnector,
    and Ground) which will be assumed to be N. Therefore, phase code ABCN
    is explicitly declared when needed, e.g. for star point grounding equipment.
    The phase code on terminals connecting the same ConnectivityNode or
    TopologicalNode as well as for equipment between two terminals shall
    be consistent.
    '''

    Bushing: Optional[Bushing] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Bushing.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ConductingEquipment: Optional[ConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConductingEquipment.Terminals',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The conducting equipment of the terminal. Conducting equipment have terminals
            that may be connected to other conducting equipment terminals via connectivity
            nodes or topological nodes.
            '''

        })
    '''
    The conducting equipment of the terminal. Conducting equipment have
    terminals that may be connected to other conducting equipment terminals
    via connectivity nodes or topological nodes.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.Terminals',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The connectivity node to which this terminal connects with zero impedance.
            '''

        })
    '''
    The connectivity node to which this terminal connects with zero impedance.
    '''

    HasFromTerminalSVSMO4: Optional[SVSMO4] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SVSMO4.FromTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SVSMO4 model that has this FromTerminal.
            '''

        })
    '''
    The SVSMO4 model that has this FromTerminal.
    '''

    HasToTerminalSVSMO4: Optional[SVSMO4] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SVSMO4.ToTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SVSMO4 model that has this ToTerminal.
            '''

        })
    '''
    The SVSMO4 model that has this ToTerminal.
    '''

    NormalHeadFeeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.NormalHeadTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The feeder that this terminal normally feeds. Only specified for the terminals
            at head of feeders.
            '''

        })
    '''
    The feeder that this terminal normally feeds. Only specified for the
    terminals at head of feeders.
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The topological node associated with the terminal. This can be used as
            an alternative to the connectivity node path to topological node, thus
            making it unnecessary to model connectivity nodes in some cases. Note that
            the if connectivity nodes are in the model, this association would probably
            not be used as an input specification.
            '''

        })
    '''
    The topological node associated with the terminal. This can be used
    as an alternative to the connectivity node path to topological node,
    thus making it unnecessary to model connectivity nodes in some cases.
    Note that the if connectivity nodes are in the model, this association
    would probably not be used as an input specification.
    '''

    WeccREPCC: Optional[WeccREPCC] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WeccREPCC.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The WECC REPCC model that has frequency measured at this Terminal.
            '''

        })
    '''
    The WECC REPCC model that has frequency measured at this Terminal.
    '''

    WeccWTGIBFFRA: Optional[WeccWTGIBFFRA] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WeccWTGIBFFRA.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The WECC WTGIBFFRA model that has frequency measured at this Terminal.
            '''

        })
    '''
    The WECC WTGIBFFRA model that has frequency measured at this Terminal.
    '''

    WindPlantDynamics: Optional[WindPlantDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WindPlantDynamics.PointOfConnection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The wind plant that has point of connection.
            '''

        })
    '''
    The wind plant that has point of connection.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class MktTerminal(Terminal):
    '''
    Subclass of IEC61970:Core:Terminal.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketOpCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Flowgate: Optional[Flowgate] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Flowgate.MktTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class ActivityRecord(IdentifiedObject):
    '''
    Records activity for an entity at a point in time; activity may be for
    an event that has already occurred or for a planned activity.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    createdDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Date and time this activity record has been created (different from the
            'status.dateTime', which is the time of a status change of the associated
            object, if applicable).
            '''

        })
    '''
    Date and time this activity record has been created (different from
    the 'status.dateTime', which is the time of a status change of the
    associated object, if applicable).
    '''

    reason: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reason for event resulting in this activity record, typically supplied
            when user initiated.
            '''

        })
    '''
    Reason for event resulting in this activity record, typically supplied
    when user initiated.
    '''

    severity: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Severity level of event resulting in this activity record.
            '''

        })
    '''
    Severity level of event resulting in this activity record.
    '''

    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of event resulting in this activity record.
            '''

        })
    '''
    Type of event resulting in this activity record.
    '''

    Author: Optional[Author] = field(
        default=None,
        metadata={
        'type': 'deprecated',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Author.ActivityRecords',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Author of this activity record.
            '''

        })
    '''
    Author of this activity record.
    '''

    status: Optional[Status] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Information on consequence of event resulting in this activity record.
            '''

        })
    '''
    Information on consequence of event resulting in this activity record.
    '''

    WorkRequest: Optional[WorkRequest] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WorkRequest.ActivityRecord',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Work request for which activity has been recorded.
            '''

        })
    '''
    Work request for which activity has been recorded.
    '''

@dataclass(repr=False)
class ConfigurationEvent(ActivityRecord):
    '''
    Used to report details on creation, change or deletion of an entity or
    its configuration.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    effectiveDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Date and time this event has or will become effective.
            '''

        })
    '''
    Date and time this event has or will become effective.
    '''

    modifiedBy: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Source/initiator of modification.
            '''

        })
    '''
    Source/initiator of modification.
    '''

    remark: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Free text remarks.
            '''

        })
    '''
    Free text remarks.
    '''

    ChangedAgentRole: Optional[AgentRole] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AgentRole.ConfigurationEvents',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Agent role whose change resulted in this configuration event.
            '''

        })
    '''
    Agent role whose change resulted in this configuration event.
    '''

    ChangedAsset: Optional[Asset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Asset.ConfigurationEvents',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asset whose change resulted in this configuration event.
            '''

        })
    '''
    Asset whose change resulted in this configuration event.
    '''

    ChangedDocument: Optional[Document] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Document.ConfigurationEvents',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Document whose change resulted in this configuration event.
            '''

        })
    '''
    Document whose change resulted in this configuration event.
    '''

    ChangedLocation: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.ConfigurationEvents',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Location whose change resulted in this configuration event.
            '''

        })
    '''
    Location whose change resulted in this configuration event.
    '''

    ChangedServiceCategory: Optional[ServiceCategory] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ServiceCategory.ConfigurationEvents',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Service category whose change resulted in this configuration event.
            '''

        })
    '''
    Service category whose change resulted in this configuration event.
    '''

    ChangedUsagePoint: Optional[UsagePoint] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'UsagePoint.ConfigurationEvents',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Usage point whose change resulted in this configuration event.
            '''

        })
    '''
    Usage point whose change resulted in this configuration event.
    '''

    FaultCauseType: Optional[FaultCauseType] = field(
        default=None,
        metadata={
        'type': 'Part 3 Ext',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FaultCauseType.ConfigurationEvent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Part 3 Ext',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.ConfigurationEvent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class MktActivityRecord(ActivityRecord):
    '''
    Subclass of IEC61968: Common:ActivityRecord.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    MarketParticipant: list[MarketParticipant] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MarketParticipant.MktActivityRecord',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    MktActivityRecord: list[MktActivityRecord] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MktActivityRecord.SelfMktActivityRecord',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    SelfMktActivityRecord: Optional[MktActivityRecord] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MktActivityRecord.MktActivityRecord',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class Address(IdentifiedObject):
    '''
    Fundamental street address information.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AdditionalAddressInformation: list[AdditionalAddressInformation] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AdditionalAddressInformation.Address',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Additional information for a given address.
            '''

        })
    '''
    Additional information for a given address.
    '''

    cityCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            City code.
            '''

        })
    '''
    City code.
    '''

    cityName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Name of the city.
            '''

        })
    '''
    Name of the city.
    '''

    country: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Name of the country in which the address is located. It is recommended
            to use either the 3-letter ISO 3166-1 alpha 3 code such as "SGP," or the
            full country name such as "Singapore."
            '''

        })
    '''
    Name of the country in which the address is located. It is recommended
    to use either the 3-letter ISO 3166-1 alpha 3 code such as "SGP," or
    the full country name such as "Singapore."
    '''

    county: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Name of the second-level Administrative division of a country in which
            the address is located. The term used for the second-level Administrative
            division in a county varies from country to country and between first-level
            Administrative divisions within a country. For example, California has
            counties, Louisiana has parishes, British Columbia, Canada has regional
            districts, and Queensland Australia has shires and regions. Counties are
            usually made up of cities, towns, and rural populations.
            '''

        })
    '''
    Name of the second-level Administrative division of a country in which
    the address is located. The term used for the second-level Administrative
    division in a county varies from country to country and between first-level
    Administrative divisions within a country. For example, California
    has counties, Louisiana has parishes, British Columbia, Canada has
    regional districts, and Queensland Australia has shires and regions.
    Counties are usually made up of cities, towns, and rural populations.
    '''

    fullAddress: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A concatenated string specifying the complete address in a single string
            which may include delimiters.
            '''

        })
    '''
    A concatenated string specifying the complete address in a single string
    which may include delimiters.
    '''

    postalCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Postal code for the address.
            '''

        })
    '''
    Postal code for the address.
    '''

    region: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Name of the first-level Administrative division of a country in which the
            address is located. For example, California, Quebec, and Queensland are
            states and provinces of the United States of America, Canada, and Australia,
            respectively.
            '''

        })
    '''
    Name of the first-level Administrative division of a country in which
    the address is located. For example, California, Quebec, and Queensland
    are states and provinces of the United States of America, Canada, and
    Australia, respectively.
    '''

    streetCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            (if applicable) Utilities often make use of external reference systems,
            such as those of the town-planner's department or surveyor general's mapping
            system, that allocate global reference codes to streets.
            '''

        })
    '''
    (if applicable) Utilities often make use of external reference systems,
    such as those of the town-planner's department or surveyor general's
    mapping system, that allocate global reference codes to streets.
    '''

    streetName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Name of the street.
            '''

        })
    '''
    Name of the street.
    '''

    streetNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Designator of the specific location on the street.
            '''

        })
    '''
    Designator of the specific location on the street.
    '''

    streetPrefix: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Prefix to the street name. For example: North, South, East, West.
            '''

        })
    '''
    Prefix to the street name. For example: North, South, East, West.
    '''

    streetSuffix: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Suffix to the street name. For example: North, South, East, West.
            '''

        })
    '''
    Suffix to the street name. For example: North, South, East, West.
    '''

    suiteNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of the apartment or suite.
            '''

        })
    '''
    Number of the apartment or suite.
    '''

    Cadastre: Optional[Cadastre] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Cadastre.Address',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cadastre encompassing one or more physical addresses.
            '''

        })
    '''
    Cadastre encompassing one or more physical addresses.
    '''

    status: Optional[Status] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Current status of the address e.g. pending, approved
            '''

        })
    '''
    Current status of the address e.g. pending, approved
    '''

@dataclass(repr=False)
class PhysicalAddress(Address):
    '''
    The structured geographic and administrative context of a physical place
    where an organisation, person, or activity is located.
    PhysicalAddress is used for precisely identifying, classifying, and locating
    entities for regulatory, logistical, or informational purposes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Building: Optional[Building] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Building.PhysicalAddress',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Site: Optional[Site] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Site.PhysicalAddress',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    community: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Community in which the locality is, and which is in the municipality, city
            or town.. For example, Anderston, Glasgow City, Scotland or another appropriate
            fourth-level administrative division
            '''

        })
    '''
    Community in which the locality is, and which is in the municipality,
    city or town.. For example, Anderston, Glasgow City, Scotland or another
    appropriate fourth-level administrative division
    '''

    globalLocationNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Global Location Number (GLN, sometimes also referred to as International
            Location Number or ILN) of the respective organization, person, or place.
            The GLN is a 13-digit number used to identify parties and physical locations.
            '''

        })
    '''
    Global Location Number (GLN, sometimes also referred to as International
    Location Number or ILN) of the respective organization, person, or
    place. The GLN is a 13-digit number used to identify parties and physical
    locations.
    '''

    isicV4: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            International Standard of Industrial Classification of All Economic Activities
            (ISIC), Revision 4 code for a particular organization, business person,
            or place.
            '''

        })
    '''
    International Standard of Industrial Classification of All Economic
    Activities (ISIC), Revision 4 code for a particular organization, business
    person, or place.
    '''

    isWithinTownLimits: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If TRUE, this street is within the legal geographical boundaries of the
            specified town (default).
            '''

        })
    '''
    If TRUE, this street is within the legal geographical boundaries of
    the specified town (default).
    '''

    municipality: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Name of the municipality within which the address is located. A municipality
            refers to a village, town, or city that has corporate status and powers
            of self-government or jurisdiction as granted by national and regional
            laws to which it is subordinate.
            '''

        })
    '''
    Name of the municipality within which the address is located. A municipality
    refers to a village, town, or city that has corporate status and powers
    of self-government or jurisdiction as granted by national and regional
    laws to which it is subordinate.
    '''

    nearestIntersection: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The names of streets at the nearest intersection to work area.
            '''

        })
    '''
    The names of streets at the nearest intersection to work area.
    '''

    Building: Optional[Building] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Building.PhysicalAddress',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Site: Optional[Site] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Site.PhysicalAddress',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.Attribute)
@dataclass(repr=False)
class PostalAddress(Address):
    '''
    A reliable, private, and secure mailing address housed within a postal
    facility.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    postOfficeBoxNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Post office box identifier. Typically a numeric or alphanumeric string
            with or without separators (dashes, spaces, or slashes) between numeric
            or alphanumeric characters.
            '''

        })
    '''
    Post office box identifier. Typically a numeric or alphanumeric string
    with or without separators (dashes, spaces, or slashes) between numeric
    or alphanumeric characters.
    '''

@dataclass(repr=False)
class AdjacentCASet(IdentifiedObject):
    '''
    Groups Adjacent Control Areas.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ReferenceData'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    RegisteredResource: list[RegisteredResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegisteredResource.AdjacentCASet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class Agent(IdentifiedObject):
    '''
    An agent is an entity that bears some form of responsibility for an activity
    taking place, for the existence of an entity, or for another agent's activity.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AgentCapability: list[AgentCapability] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AgentCapability.Agent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    AgentRole: list[AgentRole] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AgentRole.Agent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ContactPoint: list[ContactPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ContactPoint.Agent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    url: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            URL of the agent. Uniform Resource Locator (URL), colloquially termed a
            web address, is a reference to a web resource that specifies its location
            on a computer network and a mechanism for retrieving it. A URL is a specific
            type of Uniform Resource Identifier (URI).
            '''

        })
    '''
    URL of the agent. Uniform Resource Locator (URL), colloquially termed
    a web address, is a reference to a web resource that specifies its
    location on a computer network and a mechanism for retrieving it. A
    URL is a specific type of Uniform Resource Identifier (URI).
    '''

@dataclass(repr=False)
class AutonomousAgent(Agent):
    '''
    An inanimate intelligent Thing that acts on behalf of a Person or Organization.
    An Autonomous Agent is a type of Agent.
    Note:An Agent is not a role.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AutonomousFunction: list[AutonomousFunction] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AutonomousFunction.AutonomousAgent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    machineIdentity: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Unique descriptors of an organisations device or workload used to authenticate
            communication and system access. Devices can be phone, mobile device, server,
            desktop computer, Internet of Things (IoT) or Operational Technology (OT).
            Workloads can be containers, virtual machine (VM), application, service,
            Robotic Process Automation (RPA) or script.
            '''

        })
    '''
    Unique descriptors of an organisations device or workload used to authenticate
    communication and system access. Devices can be phone, mobile device,
    server, desktop computer, Internet of Things (IoT) or Operational Technology
    (OT).
    Workloads can be containers, virtual machine (VM), application, service,
    Robotic Process Automation (RPA) or script.
    '''

    otherAutonomousAgentKind: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute should be used to specify the kind of autonomous agent when
            the value for the attribute AutonomousAgent.kind is "other."
            '''

        })
    '''
    This attribute should be used to specify the kind of autonomous agent
    when the value for the attribute AutonomousAgent.kind is "other."
    '''

    kind: Optional[AutonomousAgentKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The kind of autonomous agent.
            '''

        })
    '''
    The kind of autonomous agent.
    '''

@dataclass(repr=False)
class Organisation(Agent):
    '''
    A collection of one or more people organised together into some type of
    structure for a specific purpose.
    An Organisation is a type of Agent.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AgentCapability: Optional[AgentCapability] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AgentCapability.CertificationOrganisation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    isLegalEntity: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If TRUE, the organisation is a legal entity.
            '''

        })
    '''
    If TRUE, the organisation is a legal entity.
    '''

    iso6523Code: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Organisation identifier as defined in ISO 6523(-1). Note that many existing
            organization identifiers such as leiCode, duns and vatID can be expressed
            as an ISO 6523 identifier by setting the ICD part of the ISO 6523 identifier
            accordingly.
            '''

        })
    '''
    Organisation identifier as defined in ISO 6523(-1). Note that many
    existing organization identifiers such as leiCode, duns and vatID can
    be expressed as an ISO 6523 identifier by setting the ICD part of the
    ISO 6523 identifier accordingly.
    '''

    vatID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Value-added Tax ID of the organisation.
            '''

        })
    '''
    The Value-added Tax ID of the organisation.
    '''

    category: Optional[OrganisationCategoryKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The list of the kinds of organisations regarded as having particular shared
            characteristics.
            '''

        })
    '''
    The list of the kinds of organisations regarded as having particular
    shared characteristics.
    '''

    legalEntity: Optional[LegalEntityKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The kind of legal entity the organisation is as defined by its articles
            of incorporation.
            '''

        })
    '''
    The kind of legal entity the organisation is as defined by its articles
    of incorporation.
    '''

    AgentCapability: Optional[AgentCapability] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AgentCapability.CertificationOrganisation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ParentOrganisation: Optional[ParentOrganization] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Organisation.SubordinateOrganisation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Parent organisation of this organisation.
            '''

        })
    '''
    Parent organisation of this organisation.
    '''

@dataclass(repr=False)
class Crew(Organisation):
    '''
    Group of people with specific skills, tools, and vehicles.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    CrewMembers: list[CrewMember] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CrewMember.Crew',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All members of this crew.
            '''

        })
    '''
    All members of this crew.
    '''

    FieldDispatchHistory: list[FieldDispatchHistory] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FieldDispatchHistory.Crew',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    CrewType: Optional[CrewType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CrewType.Crews',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of this crew.
            '''

        })
    '''
    Type of this crew.
    '''

    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.Crew',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    status: Optional[Status] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Status of this crew.
            '''

        })
    '''
    Status of this crew.
    '''

    SwitchingAction: Optional[SwitchingAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SwitchingAction.Crew',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WorkCapability: Optional[WorkCapability] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WorkCapability.Crew',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WorkManager: Optional[WorkManager] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WorkManager.Crew',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The work organisation to which crews are assigned.
            '''

        })
    '''
    The work organisation to which crews are assigned.
    '''

    WorkOrganisation: Optional[WorkOrganisation] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WorkOrganisation.Crew',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The work organisation to which crews are assigned.
            '''

        })
    '''
    The work organisation to which crews are assigned.
    '''

@dataclass(repr=False)
class MarketParticipant(Organisation):
    '''
    An identification of a party acting in a electricity market business process.
    This class is used to identify organisations that can participate in market
    management and/or market operations.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    RegisteredResource: list[RegisteredResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegisteredResource.MarketParticipant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    MktActivityRecord: Optional[MktActivityRecord] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MktActivityRecord.MarketParticipant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class RTO(MarketParticipant):
    '''
    Regional transmission operator.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ReferenceData'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AggregateNode: list[AggregateNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AggregateNode.RTO',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    EnergyMarkets: list[EnergyMarket] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyMarket.RTO',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    MktConnectivityNode: list[MktConnectivityNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MktConnectivityNode.RTO',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class ParentOrganization(Organisation):
    '''
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    SubordinateOrganisation: list[Organisation] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Organisation.ParentOrganisation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class WorkOrganisation(Organisation):
    '''
    Identifies an organisation that will be responsible for planning, scheduling
    and performing the work.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Work'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Crew: list[Crew] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Crew.WorkOrganisation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Crews assigned to a given work organisation.
            '''

        })
    '''
    Crews assigned to a given work organisation.
    '''

@dataclass(repr=False)
class Person(Agent):
    '''
    General purpose information for name and other information to contact people.
    The inherited attribute Person.name shall be the concatenation of prefix,
    firstName, middleName, lastName, generationIdentifier, and suffix with
    the space character as the delimiter between each element of the person's
    name.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PersonRole: list[PersonRole] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PersonRole.Person',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All roles of this person.
            '''

        })
    '''
    All roles of this person.
    '''

    firstName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Person's first name.
            '''

        })
    '''
    Person's first name.
    '''

    lastName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Person's last (family, sir) name.
            '''

        })
    '''
    Person's last (family, sir) name.
    '''

    middleName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Middle name(s) or initial(s).
            '''

        })
    '''
    Middle name(s) or initial(s).
    '''

    preferredName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The name the person prefers to be used in communications and when spoken
            to.
            '''

        })
    '''
    The name the person prefers to be used in communications and when spoken
    to.
    '''

    prefix: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A prefix or title for the person's name, such as Miss, Mister, Doctor,
            etc.
            '''

        })
    '''
    A prefix or title for the person's name, such as Miss, Mister, Doctor,
    etc.
    '''

    suffix: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A suffix for the person's name
            '''

        })
    '''
    A suffix for the person's name
    '''

    generationalSuffix: Optional[GenerationalSuffixKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A suffix used to distinguish persons who share the same name within a family,
            such as II, III, etc..
            '''

        })
    '''
    A suffix used to distinguish persons who share the same name within
    a family, such as II, III, etc..
    '''

@stereotype(CIMStereotype.deprecated)
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class OldPerson(Person):
    '''
    General purpose information for name and other information to contact people.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    MeasurementValues: list[MeasurementValue] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeasurementValue.ErpPerson',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Skills: list[Skill] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Skill.ErpPerson',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Utility-specific classification for this person, according to the utility's
            corporate standards and practices. Examples include employee, contractor,
            agent, not affiliated, etc.
            Note that this field is not used to indicate whether this person is a customer
            of the utility. Often an employee or contractor is also a customer. Customer
            information is gained with relationship to Organisation and CustomerData.
            In similar fashion, this field does not indicate the various roles this
            person may fill as part of utility operations.
            '''

        })
    '''
    Utility-specific classification for this person, according to the utility's
    corporate standards and practices. Examples include employee, contractor,
    agent, not affiliated, etc.
    Note that this field is not used to indicate whether this person is
    a customer of the utility. Often an employee or contractor is also
    a customer. Customer information is gained with relationship to Organisation
    and CustomerData. In similar fashion, this field does not indicate
    the various roles this person may fill as part of utility operations.
    '''

    CustomerData: Optional[Customer] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Customer.ErpPersons',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ErpCompetency: Optional[ErpCompetency] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ErpCompetency.ErpPersons',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ErpPersonnel: Optional[ErpPersonnel] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ErpPersonnel.ErpPersons',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    status: Optional[Status] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class AgentRole(IdentifiedObject):
    '''
    The agent role captures the semantics of the role played by an agent in
    a particular agent relationship. The semantics are captured in the IdentifiedObject.description
    attribute.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AgentRoleQualification: list[AgentRoleQualification] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AgentRoleQualification.AgentRole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConfigurationEvent.ChangedAgentRole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All configuration events created for this agent role.
            '''

        })
    '''
    All configuration events created for this agent role.
    '''

    globalLocationNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Global Location Number (GLN, sometimes also referred to as International
            Location Number or ILN) of the respective organization, person, or place.
            The GLN is a 13-digit number used to identify parties and physical locations.
            '''

        })
    '''
    Global Location Number (GLN, sometimes also referred to as International
    Location Number or ILN) of the respective organization, person, or
    place. The GLN is a 13-digit number used to identify parties and physical
    locations.
    '''

    isicV4: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            International Standard of Industrial Classification of All Economic Activities
            (ISIC), Revision 4 code for a particular organization, business person,
            or place.
            '''

        })
    '''
    International Standard of Industrial Classification of All Economic
    Activities (ISIC), Revision 4 code for a particular organization, business
    person, or place.
    '''

    kind: Optional[AgentRoleKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute when used applies a restriction on the type of Agent that
            can play the role. For example, only a Person can play the role of Employee.
            If this attribute is not used then the role can be played by any type of
            Agent.
            '''

        })
    '''
    This attribute when used applies a restriction on the type of Agent
    that can play the role. For example, only a Person can play the role
    of Employee. If this attribute is not used then the role can be played
    by any type of Agent.
    '''

    Agent: Optional[Agent] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Agent.AgentRole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class Customer(AgentRole):
    '''
    An Organisation or Person receiving services from service supplier.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Customers'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ErpPersons: list[OldPerson] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OldPerson.CustomerData',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class OrganisationRole(AgentRole):
    '''
    Identifies a way in which an organisation may participate in the utility
    enterprise (e.g., contractor, manufacturer, etc).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class AssetOwner(OrganisationRole):
    '''
    Owner of the asset.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Assets'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Ownerships: list[Ownership] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Ownership.AssetOwner',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All ownerships of this owner.
            '''

        })
    '''
    All ownerships of this owner.
    '''

@dataclass(repr=False)
class MarketRole(OrganisationRole):
    '''
    The external intended behavior played by a party within the electricity
    market.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The kind of market roles that can be played by parties for given domains
            within the electricity market. Types are flexible using dataType of string
            for free-entry of role types.
            '''

        })
    '''
    The kind of market roles that can be played by parties for given domains
    within the electricity market. Types are flexible using dataType of
    string for free-entry of role types.
    '''

@dataclass(repr=False)
class PersonRole(AgentRole):
    '''
    Identifies a way in which a person may participate in the utility enterprise
    (e.g., contractor, crew member, etc).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Person: Optional[Person] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Person.PersonRole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Person having this role.
            '''

        })
    '''
    Person having this role.
    '''

@dataclass(repr=False)
class CrewMember(PersonRole):
    '''
    Member of a crew.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Crew: Optional[Crew] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Crew.CrewMembers',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Crew to which this crew member belongs.
            '''

        })
    '''
    Crew to which this crew member belongs.
    '''

@dataclass(repr=False)
class WorkManager(AgentRole):
    '''
    Identifies an organization or person that will be responsible for planning,
    scheduling and performing the work.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Crew: list[Crew] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Crew.WorkManager',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Crews assigned to a given work organisation.
            '''

        })
    '''
    Crews assigned to a given work organisation.
    '''

    workOrganisationType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of work organisation e.g. electrical contractor, maintenance department,
            engineering department, etc.
            '''

        })
    '''
    The type of work organisation e.g. electrical contractor, maintenance
    department, engineering department, etc.
    '''

    WorkRequest: Optional[WorkRequest] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WorkRequest.WorkManager',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Work requests assigned to a work organization.
            '''

        })
    '''
    Work requests assigned to a work organization.
    '''

@dataclass(repr=False)
class AggregateNode(IdentifiedObject):
    '''
    An aggregated node can define a typed grouping further defined by the AnodeType
    enumeration. Types range from System Zone/Regions to Market Energy Regions
    to Aggregated Loads and Aggregated Generators.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    RegisteredResource: list[RegisteredResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegisteredResource.AggregateNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A RegisteredResource can be associated to only one AggregateNode if not
            connected to a Pnode or MktConnectivityNode.
            '''

        })
    '''
    A RegisteredResource can be associated to only one AggregateNode if
    not connected to a Pnode or MktConnectivityNode.
    '''

    qualifASOrder: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Processing Order for AS self-provisions for this region. The priority of
            this attribute directs the awards of any resource that resides in overlapping
            regions. The regions are processed in priority manner.
            '''

        })
    '''
    Processing Order for AS self-provisions for this region. The priority
    of this attribute directs the awards of any resource that resides in
    overlapping regions. The regions are processed in priority manner.
    '''

    anodeType: Optional[AnodeType] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of aggregated node
            '''

        })
    '''
    Type of aggregated node
    '''

    AggregatedPnode: Optional[AggregatedPnode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AggregatedPnode.AggregateNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    RTO: Optional[RTO] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RTO.AggregateNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class AltGeneratingUnitMeas(IdentifiedObject):
    '''
    A prioritized measurement to be used for the generating unit in the control
    area specification.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ControlArea'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Priority of a measurement usage. Lower numbers have first priority.
            '''

        })
    '''
    Priority of a measurement usage. Lower numbers have first priority.
    '''

    AnalogValue: Optional[AnalogValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogValue.AltGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The specific analog value used as a source.
            '''

        })
    '''
    The specific analog value used as a source.
    '''

    ControlAreaGeneratingUnit: Optional[ControlAreaGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlAreaGeneratingUnit.AltGeneratingUnitMeas',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The control area generating unit to which the prioritized measurement assignment
            is applied.
            '''

        })
    '''
    The control area generating unit to which the prioritized measurement
    assignment is applied.
    '''

@dataclass(repr=False)
class AltTieMeas(IdentifiedObject):
    '''
    A prioritized measurement to be used for the tie flow as part of the control
    area specification.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ControlArea'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Priority of a measurement usage. Lower numbers have first priority.
            '''

        })
    '''
    Priority of a measurement usage. Lower numbers have first priority.
    '''

    AnalogValue: Optional[AnalogValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogValue.AltTieMeas',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The specific analog value used as a source.
            '''

        })
    '''
    The specific analog value used as a source.
    '''

    TieFlow: Optional[TieFlow] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TieFlow.AltTieMeas',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The tie flow of the alternate measurements.
            '''

        })
    '''
    The tie flow of the alternate measurements.
    '''

@dataclass(repr=False)
class Appointment(IdentifiedObject):
    '''
    Meeting time and location.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    callAhead: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if requested to call customer when someone is about to arrive at their
            premises.
            '''

        })
    '''
    True if requested to call customer when someone is about to arrive
    at their premises.
    '''

    meetingInterval: Optional[DateTimeInterval] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Date and time reserved for appointment.
            '''

        })
    '''
    Date and time reserved for appointment.
    '''

@dataclass(repr=False)
class Asset(IdentifiedObject):
    '''
    Tangible resource of the utility, including power system equipment, various
    end devices, cabinets, buildings, etc. For electrical network equipment,
    the role of the asset is defined through PowerSystemResource and its subclasses,
    defined mainly in the Wires model (refer to IEC61970-301 and model package
    IEC61970::Wires). Asset description places emphasis on the physical characteristics
    of the equipment fulfilling that role.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Assets'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConfigurationEvent.ChangedAsset',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All configuration events created for this asset.
            '''

        })
    '''
    All configuration events created for this asset.
    '''

    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Asset',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement related to this asset.
            '''

        })
    '''
    Measurement related to this asset.
    '''

    Ownerships: list[Ownership] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Ownership.Asset',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All ownerships of this asset.
            '''

        })
    '''
    All ownerships of this asset.
    '''

@dataclass(repr=False)
class Bushing(Asset):
    '''
    Bushing asset.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Assets'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.Bushing',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Terminal to which this bushing is attached.
            '''

        })
    '''
    Terminal to which this bushing is attached.
    '''

@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class DuctBank(Asset):
    '''
    A duct contains individual wires in the layout as specified with associated
    wire spacing instances; number of them gives the number of conductors in
    this duct.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Assets'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    WireSpacingInfos: list[WireSpacingInfo] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'IntraphaseSpacing.DuctBank',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireSpacingInfos: list[WireSpacingInfo] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireSpacingInfo.DuctBank',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class AssetInfo(IdentifiedObject):
    '''
    Set of attributes of an asset, representing typical datasheet information
    of a physical device that can be instantiated and shared in different data
    exchange contexts:
    - as attributes of an asset instance (installed or in stock)
    - as attributes of an asset model (product by a manufacturer)
    - as attributes of a type asset (generic type of an asset as used in designs/extension
    planning).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ParentAssetInfoComponent: Optional[AssetInfoComponent] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfoComponent.ChildAssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ChildAssetInfoComponent: Optional[AssetInfoComponent] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfoComponent.ParentAssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.AssetDatasheet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All power system resources with this datasheet information.
            '''

        })
    '''
    All power system resources with this datasheet information.
    '''

    AssetRequirement: Optional[AssetRequirement] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetRequirement.AssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    CatalogAssetType: Optional[CatalogAssetType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CatalogAssetType.AssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asset information (nameplate) for this catalog asset type.
            '''

        })
    '''
    Asset information (nameplate) for this catalog asset type.
    '''

    ChildAssetInfoComponent: Optional[AssetInfoComponent] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfoComponent.ParentAssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ParentAssetInfoComponent: Optional[AssetInfoComponent] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfoComponent.ChildAssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ProductAssetModel: Optional[ProductAssetModel] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ProductAssetModel.AssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Product asset model which conforms to this catalog asset type.
            '''

        })
    '''
    Product asset model which conforms to this catalog asset type.
    '''

@dataclass(repr=False)
class CapacitorBankInfo(AssetInfo):
    '''
    Capacitor bank asset information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class ConductingAssetInfo(AssetInfo):
    '''
    Generic information for conducting asset
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ShortCircuitRespone: list[ShortCircuitResponse] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShortCircuitResponse.ConductingAssetInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated current.
            '''

        })
    '''
    Rated current.
    '''

    ratedFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated frequency such as 50Hz or 60Hz
            '''

        })
    '''
    Rated frequency such as 50Hz or 60Hz
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage.
            '''

        })
    '''
    Rated voltage.
    '''

    phaseCount: Optional[PhaseCountKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of phases
            '''

        })
    '''
    Number of phases
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BundledCableInfo(ConductingAssetInfo):
    '''
    Bundling two or more conductors, at most one bare wire.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    additionalConductorCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Additional conductor count
            '''

        })
    '''
    Additional conductor count
    '''

    hasNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if neutral
            '''

        })
    '''
    True if neutral
    '''

    insulatedNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if neutral wire is insulated
            '''

        })
    '''
    True if neutral wire is insulated
    '''

    neutralSizeDescription: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Neutral wire size description
            '''

        })
    '''
    Neutral wire size description
    '''

    neutralStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Neutral wire strand count
            '''

        })
    '''
    Neutral wire strand count
    '''

    neutralStrandRDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Neutral strand DC resistance per unit length of the conductor at 20 &#176;C
            '''

        })
    '''
    Neutral strand DC resistance per unit length of the conductor at 20
    &#176;C
    '''

@dataclass(repr=False)
class BusbarSectionInfo(ConductingAssetInfo):
    '''
    Busbar section data.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class BushingInfo(ConductingAssetInfo):
    '''
    Bushing datasheet information.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    c1Capacitance: Optional[ float | Capacitance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Factory measured capacitance, measured between the power factor tap and
            the bushing conductor.
            '''

        })
    '''
    Factory measured capacitance, measured between the power factor tap
    and the bushing conductor.
    '''

    c1PowerFactor: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Factory measured insulation power factor, measured between the power factor
            tap and the bushing conductor.
            '''

        })
    '''
    Factory measured insulation power factor, measured between the power
    factor tap and the bushing conductor.
    '''

    c2Capacitance: Optional[ float | Capacitance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Factory measured capacitance measured between the power factor tap and
            ground.
            '''

        })
    '''
    Factory measured capacitance measured between the power factor tap
    and ground.
    '''

    c2PowerFactor: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Factory measured insulation power factor, measured between the power factor
            tap and ground.
            '''

        })
    '''
    Factory measured insulation power factor, measured between the power
    factor tap and ground.
    '''

    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
            '''

        })
    '''
    Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
    '''

    ratedLineToGroundVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated line-to-ground voltage. Also referred to as Uy on bushing nameplate.
            '''

        })
    '''
    Rated line-to-ground voltage. Also referred to as Uy on bushing nameplate.
    '''

    insulationKind: Optional[BushingInsulationKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of insulation.
            '''

        })
    '''
    Kind of insulation.
    '''

@dataclass(repr=False)
class CapacitorCanInfo(ConductingAssetInfo):
    '''
    A CapacitorCan info class is used to store asset info data for the small
    2.4 - 25 KV capacitor units which make up a capacitor bank. These cans
    are connected in series to equal the energized voltage and connected in
    parallel groups to create the desired Mvar ratings.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    dielectricFluidType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of dielectric fluid used for the capacitors (ex. WEMCOL, DPO, AROCLOR,
            etc.).
            '''

        })
    '''
    Type of dielectric fluid used for the capacitors (ex. WEMCOL, DPO,
    AROCLOR, etc.).
    '''

    dielectricFluidVolume: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Volume of dielectric fluid (oil) in litres.
            '''

        })
    '''
    Volume of dielectric fluid (oil) in litres.
    '''

    ratedCapacitance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The factory rating of the capacitor cans in uF (Farads). All the capacitors
            in a capacitor bank have more or less equal capacitance coming out of factory.
            '''

        })
    '''
    The factory rating of the capacitor cans in uF (Farads). All the capacitors
    in a capacitor bank have more or less equal capacitance coming out
    of factory.
    '''

    ratedReactiveRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reactive power rating of the capacitor cans in KVAR at the can rated
            voltage.
            '''

        })
    '''
    The reactive power rating of the capacitor cans in KVAR at the can
    rated voltage.
    '''

    weight: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total weight of one capacitor can (i.e., 20kG).
            '''

        })
    '''
    Total weight of one capacitor can (i.e., 20kG).
    '''

    dischargeResistorType: Optional[DischargeResistorKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            discharge resister installed, what type is it? (i.e. internal, external
            or not installed)
            '''

        })
    '''
    discharge resister installed, what type is it? (i.e. internal, external
    or not installed)
    '''

    fusingType: Optional[CapacitorCanFusingKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of fusing used (i.e. internal or external). Fuses may be included
            inside the can or attached to the external terminal of the can.
            '''

        })
    '''
    The type of fusing used (i.e. internal or external). Fuses may be included
    inside the can or attached to the external terminal of the can.
    '''

    terminalConnectionType: Optional[TerminalConnectionKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The terminal connection of the capacitor cans (i.e. single bushing double
            bushing or triple bushing).
            '''

        })
    '''
    The terminal connection of the capacitor cans (i.e. single bushing
    double bushing or triple bushing).
    '''

    rated10PctVoltTime: Optional[TimeInterval] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The time it takes to discharge to one tenth of the capacitor cans voltage
            rating.
            '''

        })
    '''
    The time it takes to discharge to one tenth of the capacitor cans voltage
    rating.
    '''

@dataclass(repr=False)
class CompensatorInfo(ConductingAssetInfo):
    '''
    Data sheet for compensation devices which can be used in a shunt or series
    application.
    Compensator can be specialized to Capacitor or Reactor.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    maxPowerLoss: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum allowed apparent power loss.
            '''

        })
    '''
    Maximum allowed apparent power loss.
    '''

    ratedReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive Power produced by the bank at rated voltage
            '''

        })
    '''
    Reactive Power produced by the bank at rated voltage
    '''

@dataclass(repr=False)
class CapacitorInfo(CompensatorInfo):
    '''
    Common properties of capacitor asset which can be used in a shunt or series
    application.
    Also named as capacitor bank by IEC 60050
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    maxAmbientTempRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum Operating ambient temperature (i.e., +85 DEG C).
            '''

        })
    '''
    Maximum Operating ambient temperature (i.e., +85 DEG C).
    '''

    minAmbientTempRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum Operating ambient temperature (i.e., -40 DEG C).
            '''

        })
    '''
    Minimum Operating ambient temperature (i.e., -40 DEG C).
    '''

    numberOfCansPerPhase: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total number of cans per phase in the capacitor bank
            '''

        })
    '''
    Total number of cans per phase in the capacitor bank
    '''

    parallelUnitsPerPhase: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Per phase how many elements are connected in parallel units per series
            group.
            '''

        })
    '''
    Per phase how many elements are connected in parallel units per series
    group.
    '''

    seriesGroupsPerPhase: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Per phase how many series groups (or sections) in the capacitor unit are
            connected.
            '''

        })
    '''
    Per phase how many series groups (or sections) in the capacitor unit
    are connected.
    '''

    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Basic Insulation Level voltage in kilovolts (lightening impulse withstand
            voltage).
            '''

        })
    '''
    Basic Insulation Level voltage in kilovolts (lightening impulse withstand
    voltage).
    '''

    capacitorRackType: Optional[CapacitorRackKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rack type used (ie. Enclosed Rack or Open Rack).
            '''

        })
    '''
    Rack type used (ie. Enclosed Rack or Open Rack).
    '''

@dataclass(repr=False)
class SeriesCapacitorInfo(CapacitorInfo):
    '''
    Class for specializing CapacitorInfo when used as in a series application.
    This specialization does not require any attributes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class ShuntCapacitorInfo(CapacitorInfo):
    '''
    Class for specializing CapacitorInfo when used as in a shunt application
    and adding attributes for this specialization.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    connectionKind: Optional[CompensatorConnectionKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Connection type of the capacitor bank (i.e. wye, grounded wye or delta).
            '''

        })
    '''
    Connection type of the capacitor bank (i.e. wye, grounded wye or delta).
    '''

@dataclass(repr=False)
class FACTSInfo(CompensatorInfo):
    '''
    Flexible alternating current transmission system
    High speed reactive compensation device
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    appliedHarmonicFiltering: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Description of the harmonic filtering applied in the FACTS (5th order,
            7th order, etc.) There may be multiple harmonics which are filtered
            '''

        })
    '''
    Description of the harmonic filtering applied in the FACTS (5th order,
    7th order, etc.) There may be multiple harmonics which are filtered
    '''

    coolingType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The cooling type of the FACTS Device Thyristors
            ex. Air Cooled, Water Cooled
            '''

        })
    '''
    The cooling type of the FACTS Device Thyristors
    ex. Air Cooled, Water Cooled
    '''

    capacitorHarmonicFilterRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total Capacitor Harmonic Filter Rating in Reactance (imaginary part of
            impedance), at rated frequency provided in the applied harmonic filtering
            '''

        })
    '''
    Total Capacitor Harmonic Filter Rating in Reactance (imaginary part
    of impedance), at rated frequency provided in the applied harmonic
    filtering
    '''

    maxCapacitiveReactance: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Capacitive Reactance - Maximum Capacitive reactive impedance the FACTS
            can supply
            '''

        })
    '''
    Capacitive Reactance - Maximum Capacitive reactive impedance the FACTS
    can supply
    '''

    maxInductiveReactance: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive Reactance - Maximum inductive reactive impedance the FACTS can
            supply
            '''

        })
    '''
    Reactive Reactance - Maximum inductive reactive impedance the FACTS
    can supply
    '''

    maxMechanicalSwitchedCapacitance: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total capacitor's reactive impedance of mechanically switched Capacitors
            under the control of the FACTS. Capacitors may be switched by breakers
            or circuit switchers.
            '''

        })
    '''
    Total capacitor's reactive impedance of mechanically switched Capacitors
    under the control of the FACTS. Capacitors may be switched by breakers
    or circuit switchers.
    '''

    maxMechanicalSwitchedReactance: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total inductor's reactive impedance of mechanically switched Reactors under
            the control of the FACTS. Reactors may be switched by breakers or circuit
            switchers.
            '''

        })
    '''
    Total inductor's reactive impedance of mechanically switched Reactors
    under the control of the FACTS. Reactors may be switched by breakers
    or circuit switchers.
    '''

    nomU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated Voltage for the shunt capacitors and reactors in the FACTS device.
            '''

        })
    '''
    Rated Voltage for the shunt capacitors and reactors in the FACTS device.
    '''

    reactorHarmonicFilterRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total Reactor Harmonic Filter Rating in Reactance (imaginary part of impedance),
            at rated frequency provided in the applied harmonic filtering.
            '''

        })
    '''
    Total Reactor Harmonic Filter Rating in Reactance (imaginary part of
    impedance), at rated frequency provided in the applied harmonic filtering.
    '''

@dataclass(repr=False)
class SVCInfo(FACTSInfo):
    '''
    Static Var Compensator - High speed switched reactor and capacitor.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    tcrRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rating in reactance if the Static Var Compensator has a Thyristor Switched
            Reactor
            '''

        })
    '''
    Rating in reactance if the Static Var Compensator has a Thyristor Switched
    Reactor
    '''

    tscRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rating in reactance if the Static Var Compensator has a Thyristor Switched
            Capacitor
            '''

        })
    '''
    Rating in reactance if the Static Var Compensator has a Thyristor Switched
    Capacitor
    '''

    svcReactiveControlType: Optional[SVCReactiveControlKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An SVC can either be set to control the voltage of a bus or provide contant
            Mvar to the bus.
            '''

        })
    '''
    An SVC can either be set to control the voltage of a bus or provide
    contant Mvar to the bus.
    '''

@dataclass(repr=False)
class SelfSaturatedReactorInfo(SVCInfo):
    '''
    Inductor made up of a transformer like core. The secondary winding is driven
    by a DC source to saturate the AC winding.
    Shunt Capacitor in addition to saturated inductor provide Mvars to increase
    and decrease voltage.
    This is pretty old technology.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    fixedSeriesCapacitance: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Slope correcting capacitor rating in reactance which is connected in series
            with the self saturated reactor.
            '''

        })
    '''
    Slope correcting capacitor rating in reactance which is connected in
    series with the self saturated reactor.
    '''

    fixedShuntCapacitance: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Shunt connected capacitors rating in reactance which are used to provide
            negative reactance for voltage support.
            '''

        })
    '''
    Shunt connected capacitors rating in reactance which are used to provide
    negative reactance for voltage support.
    '''

@dataclass(repr=False)
class StatComInfo(FACTSInfo):
    '''
    StatCom - Static Synchronous Compensator High speed continuous reactor
    and capacitor.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    maxNegativeMW: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If an active power source is available in the STATCOM, the Maximum MW that
            the STATCOM can absorb from the grid
            '''

        })
    '''
    If an active power source is available in the STATCOM, the Maximum
    MW that the STATCOM can absorb from the grid
    '''

    maxPositiveMW: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If an active power source is available in the STATCOM, the Maximum MW that
            the STATCOM can provide to the grid
            '''

        })
    '''
    If an active power source is available in the STATCOM, the Maximum
    MW that the STATCOM can provide to the grid
    '''

    activePowerSourceType: Optional[ActivePowerSourceKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Enumeration used to designate the type of Active power source used by the
            STATCOM.
            '''

        })
    '''
    Enumeration used to designate the type of Active power source used
    by the STATCOM.
    '''

    dcConverterType: Optional[STATCOMKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type DC to AC converter unit providing the AC compensation
            '''

        })
    '''
    The type DC to AC converter unit providing the AC compensation
    '''

    powerElectronicsGateType: Optional[PowerElectronicsGateKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of electronics used for the series gates.
            '''

        })
    '''
    Type of electronics used for the series gates.
    '''

@dataclass(repr=False)
class ReactorInfo(CompensatorInfo):
    '''
    Common properties of reactor asset which can be used in a shunt or series
    application. Reactors may be dry type or oil filled.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    coreCoilsWeight: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Weight of the core and coils of the device in kilograms.
            '''

        })
    '''
    Weight of the core and coils of the device in kilograms.
    '''

    oilType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type or designation of oil used for the dielectric medium (ex. VoltEsso,
            Nynas, Luminol, etc.).
            '''

        })
    '''
    Type or designation of oil used for the dielectric medium (ex. VoltEsso,
    Nynas, Luminol, etc.).
    '''

    oilWeight: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Weight of all the oil in the device in kilograms.
            '''

        })
    '''
    Weight of all the oil in the device in kilograms.
    '''

    ratedInductance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Inductance of device in mH - Milli-Henry.
            '''

        })
    '''
    Inductance of device in mH - Milli-Henry.
    '''

    ratedMechanicalCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The amount of current that creates the maximum allowable force in the conductor
            of a reactor.
            '''

        })
    '''
    The amount of current that creates the maximum allowable force in the
    conductor of a reactor.
    '''

    ratedThermalCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'NeedsWork Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum current the device can withstand for a period of one second.
            '''

        })
    '''
    Maximum current the device can withstand for a period of one second.
    '''

    tankAndFittingsWeight: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Weight of the tanks and fittings of the device in kilograms.
            '''

        })
    '''
    Weight of the tanks and fittings of the device in kilograms.
    '''

    temperatureClass: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Insulation class based on temperature (ie: Y, A, E, B, F, N, H, C).
            '''

        })
    '''
    Insulation class based on temperature (ie: Y, A, E, B, F, N, H, C).
    '''

    temperatureRise: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Temperature rise of equipment over ambient in degrees Celsius.
            '''

        })
    '''
    Temperature rise of equipment over ambient in degrees Celsius.
    '''

    volumeOfOil: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Volume of oil in litres.
            '''

        })
    '''
    Volume of oil in litres.
    '''

    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Basic Insulation Level voltage in kilovolts (lightening impulse withstand
            voltage).
            '''

        })
    '''
    Basic Insulation Level voltage in kilovolts (lightening impulse withstand
    voltage).
    '''

    circulationAndCoolingType: Optional[CirculationAndCoolingKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The method used to cool the shunt reactor, O: oil; A: air; N: natural;
            F: forced (ie: ON, ONAN, ONAF or OFAF).
            '''

        })
    '''
    The method used to cool the shunt reactor, O: oil; A: air; N: natural;
    F: forced (ie: ON, ONAN, ONAF or OFAF).
    '''

    coreType: Optional[ReactorCoreKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of core of the reactor. Example Air, steel, concrete
            '''

        })
    '''
    The type of core of the reactor. Example Air, steel, concrete
    '''

    insulationMedium: Optional[ReactorInsulationMediumKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This property denotes whether the reactor is air or oil.
            '''

        })
    '''
    This property denotes whether the reactor is air or oil.
    '''

    oilPreservationType: Optional[OilPreservationKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of oil preservation.
            '''

        })
    '''
    Kind of oil preservation.
    '''

@dataclass(repr=False)
class SeriesReactorInfo(ReactorInfo):
    '''
    Class for specializing ReactorInfo when used as in a series application.
    This specialization does not require any attributes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class ShuntReactorInfo(ReactorInfo):
    '''
    Class for specializing ReactorInfo when used as in a shunt application
    and adding attributes for this specialization.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TapChangerInfo: Optional[TapChangerInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TapChangerInfo.ShuntReactorInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class CompositeSwitchInfo(ConductingAssetInfo):
    '''
    Properties of a composite switch.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ganged: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if multi-phase switch controls all phases concurrently.
            '''

        })
    '''
    True if multi-phase switch controls all phases concurrently.
    '''

    initOpMode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Initial operating mode, with the following values: Automatic, Manual.
            '''

        })
    '''
    Initial operating mode, with the following values: Automatic, Manual.
    '''

    phaseCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Supported number of phases, typically 0, 1 or 3.
            '''

        })
    '''
    Supported number of phases, typically 0, 1 or 3.
    '''

    remote: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if device is capable of being operated by remote control.
            '''

        })
    '''
    True if device is capable of being operated by remote control.
    '''

    switchStateCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of switch states represented by the composite switch.
            '''

        })
    '''
    Number of switch states represented by the composite switch.
    '''

    interruptingRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Breaking capacity, or short circuit rating, is the maximum rated current
            which the device can safely interrupt at the rated voltage.
            '''

        })
    '''
    Breaking capacity, or short circuit rating, is the maximum rated current
    which the device can safely interrupt at the rated voltage.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage.
            '''

        })
    '''
    Rated voltage.
    '''

    kind: Optional[CompositeSwitchKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of composite switch.
            '''

        })
    '''
    Kind of composite switch.
    '''

    phaseCode: Optional[PhaseCode] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phases carried, if applicable.
            '''

        })
    '''
    Phases carried, if applicable.
    '''

@dataclass(repr=False)
class ConductorInfo(ConductingAssetInfo):
    '''
    Common class for rigid and flexible conductors.
    [IEC 826-14-06]: Conductive part intended to carry a specified electric
    current
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    purpose: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase, neutral, lighting, or something else
            '''

        })
    '''
    Phase, neutral, lighting, or something else
    '''

    crossSection: Optional[ float | Area ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Area of conducting material cross section
            '''

        })
    '''
    Area of conducting material cross section
    '''

    massPerLength: Optional[ float | MassPerLength ] = field(
        default=None,
        metadata={
        'type': 'NeedsWork Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Area of conducting material cross section
            '''

        })
    '''
    Area of conducting material cross section
    '''

    rAC25: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            AC resistance per unit length of the conductor at 25 �C.
            '''

        })
    '''
    AC resistance per unit length of the conductor at 25 �C.
    '''

    rAC50: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            AC resistance per unit length of the conductor at 50 �C.
            '''

        })
    '''
    AC resistance per unit length of the conductor at 50 �C.
    '''

    rAC75: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            AC resistance per unit length of the conductor at 75 �C.
            '''

        })
    '''
    AC resistance per unit length of the conductor at 75 �C.
    '''

    rDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC resistance per unit length of the conductor at 20 �C.
            '''

        })
    '''
    DC resistance per unit length of the conductor at 20 �C.
    '''

    material: Optional[WireMaterialKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conductor material.
            '''

        })
    '''
    Conductor material.
    '''

@dataclass(repr=False)
class RigidBusbarInfo(ConductorInfo):
    '''
    Rigid busbar information.
    <u>Definition</u>
    [IEC 605-02-21]: A substation busbar which is made up with metallic tubes
    or bars and which is supported by insulator posts
    https://www.electropedia.org/iev/iev.nsf/display?openform&amp;ievref=605-02-21
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class AngleBusbarInfo(RigidBusbarInfo):
    '''
    L-shape bar with both legs of uniform thickness and same width
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    crossSectionWidth: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cross section width of the conductor
            '''

        })
    '''
    Cross section width of the conductor
    '''

    thickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Thickness of the angle bus bar
            '''

        })
    '''
    Thickness of the angle bus bar
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BarBusbarInfo(RigidBusbarInfo):
    '''
    One rectangular slab with uniform thickness and width
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    crossSectionWidth: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cross section width of the conductor
            '''

        })
    '''
    Cross section width of the conductor
    '''

    thickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Thickness of bar busbar
            '''

        })
    '''
    Thickness of bar busbar
    '''

@dataclass(repr=False)
class IntegralWebBusbarInfo(RigidBusbarInfo):
    '''
    I-beam type of conductor with the outer edges, turned into each other.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    crossSectionHeight: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cross section width of the conductor
            '''

        })
    '''
    Cross section width of the conductor
    '''

    crossSectionWidth: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cross section width of the conductor
            '''

        })
    '''
    Cross section width of the conductor
    '''

    thickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Thickness
            '''

        })
    '''
    Thickness
    '''

@dataclass(repr=False)
class TubeBusbarInfo(RigidBusbarInfo):
    '''
    Tube busbar information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    outerDiameter: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Outer diameter
            '''

        })
    '''
    Outer diameter
    '''

    wallThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Wall thickness
            '''

        })
    '''
    Wall thickness
    '''

@dataclass(repr=False)
class PipeBusbarInfo(TubeBusbarInfo):
    '''
    Pipe busbar information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    pipeType: Optional[PipeBusbarKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            For cylindrical hollow rigid conductor only. Rigid cylindrical conductor
            comes in two types. Pipe Type cylindrical bus is based around schedule
            types such as Schedule 40 and schedule 80. The wall thickness is determined
            by the schedule number. Currently schedule 40 and schedule 80 are commonly
            used.
            '''

        })
    '''
    For cylindrical hollow rigid conductor only. Rigid cylindrical conductor
    comes in two types. Pipe Type cylindrical bus is based around schedule
    types such as Schedule 40 and schedule 80. The wall thickness is determined
    by the schedule number. Currently schedule 40 and schedule 80 are commonly
    used.
    '''

@dataclass(repr=False)
class WireInfo(ConductorInfo):
    '''
    Wire data that can be specified per line segment phase, or for the line
    segment as a whole in case its phases all have the same wire characteristics.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ACLineSegmentPhase: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.WireInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Wire phase information associated with this wire information.
            '''

        })
    '''
    Wire phase information associated with this wire information.
    '''

    coreStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            (if used) Number of strands in the steel core.
            '''

        })
    '''
    (if used) Number of strands in the steel core.
    '''

    sizeDescription: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
            '''

        })
    '''
    Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
    '''

    strandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of strands in the conductor.
            '''

        })
    '''
    Number of strands in the conductor.
    '''

    coreRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            (if there is a different core material) Radius of the central core.
            '''

        })
    '''
    (if there is a different core material) Radius of the central core.
    '''

    gmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Geometric mean radius. If we replace the conductor by a thin walled tube
            of radius GMR, then its reactance is identical to the reactance of the
            actual conductor.
            '''

        })
    '''
    Geometric mean radius. If we replace the conductor by a thin walled
    tube of radius GMR, then its reactance is identical to the reactance
    of the actual conductor.
    '''

    radius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Outside radius of the wire.
            '''

        })
    '''
    Outside radius of the wire.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class BareWireInfo(WireInfo):
    '''
    Bare wire data.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    wireConstructionKind: Optional[WireConstructionKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of wire construction
            '''

        })
    '''
    Kind of wire construction
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class CableInfo(WireInfo):
    '''
    Cable data.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    InsulationInfo: Optional[InsulationInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'InsulationInfo.CableInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    isStrandFill: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if wire strands are extruded in a way to fill the voids in the cable.
            '''

        })
    '''
    True if wire strands are extruded in a way to fill the voids in the
    cable.
    '''

    sheathAsNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if sheath / shield is used as a neutral (i.e., bonded).
            '''

        })
    '''
    True if sheath / shield is used as a neutral (i.e., bonded).
    '''

    diameterOverCore: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Diameter over the core, including any semi-con screen; should be the insulating
            layer's inside diameter.
            '''

        })
    '''
    Diameter over the core, including any semi-con screen; should be the
    insulating layer's inside diameter.
    '''

    diameterOverInsulation: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Diameter over the insulating layer, excluding outer screen.
            '''

        })
    '''
    Diameter over the insulating layer, excluding outer screen.
    '''

    diameterOverJacket: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Diameter over the outermost jacketing layer.
            '''

        })
    '''
    Diameter over the outermost jacketing layer.
    '''

    diameterOverScreen: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Diameter over the outer screen; should be the shield's inside diameter.
            '''

        })
    '''
    Diameter over the outer screen; should be the shield's inside diameter.
    '''

    nominalTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum nominal design operating temperature.
            '''

        })
    '''
    Maximum nominal design operating temperature.
    '''

    constructionKind: Optional[CableConstructionKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of construction of this cable.
            '''

        })
    '''
    Kind of construction of this cable.
    '''

    outerJacketKind: Optional[CableOuterJacketKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of outer jacket of this cable.
            '''

        })
    '''
    Kind of outer jacket of this cable.
    '''

    shieldMaterial: Optional[CableShieldMaterialKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Material of the shield.
            '''

        })
    '''
    Material of the shield.
    '''

    InsulationInfo: Optional[InsulationInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'InsulationInfo.CableInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class ConcentricNeutralCableInfo(CableInfo):
    '''
    Concentric neutral cable data.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    neutralStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of concentric neutral strands.
            '''

        })
    '''
    Number of concentric neutral strands.
    '''

    diameterOverNeutral: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Diameter over the concentric neutral strands.
            '''

        })
    '''
    Diameter over the concentric neutral strands.
    '''

    neutralStrandGmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Geometric mean radius of the neutral strand.
            '''

        })
    '''
    Geometric mean radius of the neutral strand.
    '''

    neutralStrandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Outside radius of the neutral strand.
            '''

        })
    '''
    Outside radius of the neutral strand.
    '''

    neutralStrandRDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC resistance per unit length of the neutral strand at 20 �C.
            '''

        })
    '''
    DC resistance per unit length of the neutral strand at 20 �C.
    '''

@dataclass(repr=False)
class MultiCoreCableInfo(CableInfo):
    '''
    Multi core cable information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    hasNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if neutral is included
            '''

        })
    '''
    True if neutral is included
    '''

    neutralSizeDescription: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Neutral wire size description
            '''

        })
    '''
    Neutral wire size description
    '''

    neutralStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Neutral wire strand count
            '''

        })
    '''
    Neutral wire strand count
    '''

    phaseCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase count
            '''

        })
    '''
    Phase count
    '''

    neutralStrandRDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Neutral strand DC resistance per unit length of the conductor at 20 &#176;C
            '''

        })
    '''
    Neutral strand DC resistance per unit length of the conductor at 20
    &#176;C
    '''

@dataclass(repr=False)
class TapeShieldCableInfo(CableInfo):
    '''
    Tape shield cable data.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    tapeLap: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Percentage of the tape shield width that overlaps in each wrap, typically
            10% to 25%.
            '''

        })
    '''
    Percentage of the tape shield width that overlaps in each wrap, typically
    10% to 25%.
    '''

    tapeThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Thickness of the tape shield, before wrapping.
            '''

        })
    '''
    Thickness of the tape shield, before wrapping.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class OverheadWireInfo(WireInfo):
    '''
    Overhead wire data.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    wireConstructionKind: Optional[WireConstructionKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute add',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class GridEdgeDeviceInfo(ConductingAssetInfo):
    '''
    A Grid Edge Device is any device that is connected to the power grid with
    the ability to produce, store, and/or variably consume electricity. This
    include devices like local generation (solar photovoltaic and wind), storage
    (chemical or electrical batteries), flexible loads (heading, cooling, lighting
    systems), and electric vehicles (essentially a combination of storage and
    flexible load)
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    apparentPowerMaximum: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Apparent power maximum rating</i>
            <i>
            </i>Maximum apparent power rating in voltamperes
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Apparent power maximum rating</i>
    <i>
    </i>Maximum apparent power rating in voltamperes
    '''

    ratedVoltageMax: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>AC voltage maximum rating</i>
            Maximum AC voltage rating in RMS volts
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>AC voltage maximum rating</i>
    Maximum AC voltage rating in RMS volts
    '''

    ratedVoltageMin: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>AC voltage minimum rating</i>
            Minimum AC voltage rating in RMS volts
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>AC voltage minimum rating</i>
    Minimum AC voltage rating in RMS volts
    '''

@dataclass(repr=False)
class InverterInfo(GridEdgeDeviceInfo):
    '''
    Inverter-based devices are a type of Grid Edge Device which convert DC
    sources (and/or sinks) into AC sources (and/or sinks) allowing for the
    power to be synchronized to the grid.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    operatingCategoryAbnormal: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Abnormal operating performance category</i>
            Indication of voltage and frequency ride-through capability
            Values = Category I, Category II, Category III
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Abnormal operating performance category</i>
    Indication of voltage and frequency ride-through capability
    Values = Category I, Category II, Category III
    '''

    operatingCategoryNormal: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Normal operating performance category</i>
            Indication of reactive power and voltage/power control capability.
            Values = Category A, Category B
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Normal operating performance category</i>
    Indication of reactive power and voltage/power control capability.
    Values = Category A, Category B
    '''

    powerFactorOverExcited: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Specified over-excited power factor</i>
            Over-excited power factor
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Specified over-excited power factor</i>
    Over-excited power factor
    '''

    powerFactorUnderExcited: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Specified under-excited power factor</i>
            Under-excited power factor
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Specified under-excited power factor</i>
    Under-excited power factor
    '''

    activePowerRatingOverExcited: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Active power rating at specified over-excited power factor</i>
            Active power rating in watts at specified over-excited power factor
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Active power rating at specified over-excited power factor</i>
    Active power rating in watts at specified over-excited power factor
    '''

    activePowerRatingUnderExcited: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Active power rating at specified under-excited power factor</i>
            Active power rating in watts at specified under-excited power factor
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Active power rating at specified under-excited power factor</i>
    Active power rating in watts at specified under-excited power factor
    '''

    activePowerRatingUnityPowerFactor: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Active power rating at unity power factor (nameplate active power rating)</i>
            Active power rating in watts at unity power factor
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Active power rating at unity power factor (nameplate active power
    rating)</i>
    Active power rating in watts at unity power factor
    '''

    reactivePowerAbsorbedMax: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Reactive power absorbed maximum rating</i>
            Maximum absorbed reactive power rating in vars
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Reactive power absorbed maximum rating</i>
    Maximum absorbed reactive power rating in vars
    '''

    reactivePowerInjectedMax: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Reactive power injected maximum rating</i>
            Maximum injected reactive power rating in vars
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Reactive power injected maximum rating</i>
    Maximum injected reactive power rating in vars
    '''

    susceptanceOffline: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Reactive susceptance that remains connected to the Area EPS in the cease
            to energize and trip state</i>
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Reactive susceptance that remains connected to the Area EPS in the
    cease to energize and trip state</i>
    '''

    InverterCapabilites: Optional[InverterCapabilities] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'InverterCapabilities.IntervalInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class GenerationInverterInfo(InverterInfo):
    '''
    A Generation Inverter is an inverter backed by a source that is capable
    of generating electricity from an external source such as solar radiation,
    wind, or other fuels.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    generationCategory: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of Distribution Generation.
            Examples include:
            <ul>
            <li>Photovoltaic (PV)</li>
            <li>Combined Heat Power (CHP)</li>
            <li>Fuel Cells</li>
            <li>Small Wind Power</li>
            </ul>
            '''

        })
    '''
    Type of Distribution Generation.
    Examples include:
    <ul>
    <li>Photovoltaic (PV)</li>
    <li>Combined Heat Power (CHP)</li>
    <li>Fuel Cells</li>
    <li>Small Wind Power</li>
    </ul>
    '''

@dataclass(repr=False)
class StorageInverterInfo(InverterInfo):
    '''
    A Storage Inverter is an inverter backed by a device that is capable of
    storing and later discharging electric energy.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    storageCategory: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of Distribution Storage.
            Examples include:
            <ul>
            <li>Lead�Acid Battery</li>
            <li>Nickel�Cadmium (NiCd) Battery</li>
            <li>Nickel�Metal Hydride (NiMH) Battery</li>
            <li>Lithium-Ion Battery</li>
            <li>Lithium-Ion Polymer (LiPo) Battery</li>
            <li>Aluminum-Sulfur Battery</li>
            <li>Flow Battery</li>
            <li>Mechanical Flywheel</li>
            <li>Mechanical Gravitational</li>
            </ul>
            '''

        })
    '''
    Type of Distribution Storage.
    Examples include:
    <ul>
    <li>Lead�Acid Battery</li>
    <li>Nickel�Cadmium (NiCd) Battery</li>
    <li>Nickel�Metal Hydride (NiMH) Battery</li>
    <li>Lithium-Ion Battery</li>
    <li>Lithium-Ion Polymer (LiPo) Battery</li>
    <li>Aluminum-Sulfur Battery</li>
    <li>Flow Battery</li>
    <li>Mechanical Flywheel</li>
    <li>Mechanical Gravitational</li>
    </ul>
    '''

    chargeRateActiveMax: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Active power charge maximum rating</i>
            Maximum active power charge rating in watts
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Active power charge maximum rating</i>
    Maximum active power charge rating in watts
    '''

    chargeRateReactiveMax: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Based on IEEE 1547-2018 Table 28:
            <i>Apparent power charge maximum rating</i>
            Maximum apparent power charge rating in voltamperes. May differ from the
            apparent power maximum rating
            '''

        })
    '''
    Based on IEEE 1547-2018 Table 28:
    <i>Apparent power charge maximum rating</i>
    Maximum apparent power charge rating in voltamperes. May differ from
    the apparent power maximum rating
    '''

    storageCapacity: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class SwitchInfo(ConductingAssetInfo):
    '''
    Switch datasheet information.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    isSinglePhase: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, it is a single phase switch.
            '''

        })
    '''
    If true, it is a single phase switch.
    '''

    isUnganged: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, the switch is not ganged (i.e., a switch phase may be operated
            separately from other phases).
            '''

        })
    '''
    If true, the switch is not ganged (i.e., a switch phase may be operated
    separately from other phases).
    '''

    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum fault current a breaking device can break safely under prescribed
            conditions of use.
            '''

        })
    '''
    The maximum fault current a breaking device can break safely under
    prescribed conditions of use.
    '''

    gasWeightPerTank: Optional[ float | Mass ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Weight of gas in each tank of SF6 dead tank breaker.
            '''

        })
    '''
    Weight of gas in each tank of SF6 dead tank breaker.
    '''

    lowPressureAlarm: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Gas or air pressure at or below which a low pressure alarm is generated.
            '''

        })
    '''
    Gas or air pressure at or below which a low pressure alarm is generated.
    '''

    lowPressureLockOut: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Gas or air pressure below which the breaker will not open.
            '''

        })
    '''
    Gas or air pressure below which the breaker will not open.
    '''

    oilVolumePerTank: Optional[ float | Volume ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Volume of oil in each tank of bulk oil breaker.
            '''

        })
    '''
    Volume of oil in each tank of bulk oil breaker.
    '''

    ratedFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Frequency for which switch is rated.
            '''

        })
    '''
    Frequency for which switch is rated.
    '''

    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
            '''

        })
    '''
    Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
    '''

    ratedInterruptingTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Switch rated interrupting time in seconds.
            '''

        })
    '''
    Switch rated interrupting time in seconds.
    '''

@dataclass(repr=False)
class TapChangerInfo(ConductingAssetInfo):
    '''
    Tap changer data.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ShuntReactorInfo: list[ShuntReactorInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShuntReactorInfo.TapChangerInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ctRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Built-in current transducer ratio.
            '''

        })
    '''
    Built-in current transducer ratio.
    '''

    highStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Highest possible tap step position, advance from neutral.
            '''

        })
    '''
    Highest possible tap step position, advance from neutral.
    '''

    isTcul: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Whether this tap changer has under load tap changing capabilities.
            '''

        })
    '''
    Whether this tap changer has under load tap changing capabilities.
    '''

    lowStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Lowest possible tap step position, retard from neutral.
            '''

        })
    '''
    Lowest possible tap step position, retard from neutral.
    '''

    neutralStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The neutral tap step position for the winding.
            '''

        })
    '''
    The neutral tap step position for the winding.
    '''

    ptRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Built-in voltage transducer ratio.
            '''

        })
    '''
    Built-in voltage transducer ratio.
    '''

    bil: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Basic Insulation Level (BIL) expressed as the impulse crest voltage of
            a nominal wave, typically 1.2 X 50 microsecond. This is a measure of the
            ability of the insulation to withstand very high voltage surges.
            '''

        })
    '''
    Basic Insulation Level (BIL) expressed as the impulse crest voltage
    of a nominal wave, typically 1.2 X 50 microsecond. This is a measure
    of the ability of the insulation to withstand very high voltage surges.
    '''

    ctRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Built-in current transformer primary rating.
            '''

        })
    '''
    Built-in current transformer primary rating.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Frequency at which the ratings apply.
            '''

        })
    '''
    Frequency at which the ratings apply.
    '''

    neutralU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Voltage at which the winding operates at the neutral tap setting.
            '''

        })
    '''
    Voltage at which the winding operates at the neutral tap setting.
    '''

    ratedApparentPower: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated apparent power.
            '''

        })
    '''
    Rated apparent power.
    '''

    stepPhaseIncrement: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase shift per step position.
            '''

        })
    '''
    Phase shift per step position.
    '''

    stepReactiveIncrement: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Tap step increment, in per cent of rated Mvar, per step position.
            '''

        })
    '''
    Tap step increment, in per cent of rated Mvar, per step position.
    '''

    stepVoltageIncrement: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Tap step increment, in per cent of rated voltage, per step position.
            '''

        })
    '''
    Tap step increment, in per cent of rated voltage, per step position.
    '''

@dataclass(repr=False)
class TransformerEndInfo(ConductingAssetInfo):
    '''
    Transformer end data.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    EnergisedEndNoLoadTests: list[NoLoadTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NoLoadTest.EnergisedEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All no-load test measurements in which this transformer end was energised.
            '''

        })
    '''
    All no-load test measurements in which this transformer end was energised.
    '''

    EnergisedEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OpenCircuitTest.EnergisedEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All open-circuit test measurements in which this transformer end was excited.
            '''

        })
    '''
    All open-circuit test measurements in which this transformer end was
    excited.
    '''

    OpenEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OpenCircuitTest.OpenEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All open-circuit test measurements in which this transformer end was not
            excited.
            '''

        })
    '''
    All open-circuit test measurements in which this transformer end was
    not excited.
    '''

    EnergisedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShortCircuitTest.EnergisedEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All short-circuit test measurements in which this transformer end was energised.
            '''

        })
    '''
    All short-circuit test measurements in which this transformer end was
    energised.
    '''

    GroundedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShortCircuitTest.GroundedEnds',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All short-circuit test measurements in which this transformer end was short-circuited.
            '''

        })
    '''
    All short-circuit test measurements in which this transformer end was
    short-circuited.
    '''

    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEndInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Core admittance calculated from this transformer end datasheet, representing
            magnetising current and core losses. The full values of the transformer
            should be supplied for one transformer end info only.
            '''

        })
    '''
    Core admittance calculated from this transformer end datasheet, representing
    magnetising current and core losses. The full values of the transformer
    should be supplied for one transformer end info only.
    '''

    FromMeshImpedances: list[TransformerMeshImpedance] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerMeshImpedance.FromTransformerEndInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All mesh impedances between this 'to' and other 'from' transformer ends.
            '''

        })
    '''
    All mesh impedances between this 'to' and other 'from' transformer
    ends.
    '''

    TransformerStarImpedance: Optional[TransformerStarImpedance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerStarImpedance.TransformerEndInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer star impedance calculated from this transformer end datasheet.
            '''

        })
    '''
    Transformer star impedance calculated from this transformer end datasheet.
    '''

    endNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number for this transformer end, corresponding to the end's order in the
            PowerTransformer.vectorGroup attribute. Highest voltage winding should
            be 1.
            '''

        })
    '''
    Number for this transformer end, corresponding to the end's order in
    the PowerTransformer.vectorGroup attribute. Highest voltage winding
    should be 1.
    '''

    phaseAngleClock: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Winding phase angle where 360 degrees are represented with clock hours,
            so the valid values are {0, ..., 11}. For example, to express the second
            winding in code 'Dyn11', set attributes as follows: 'endNumber'=2, 'connectionKind'
            = Yn and 'phaseAngleClock' = 11.
            '''

        })
    '''
    Winding phase angle where 360 degrees are represented with clock hours,
    so the valid values are {0, ..., 11}. For example, to express the second
    winding in code 'Dyn11', set attributes as follows: 'endNumber'=2,
    'connectionKind' = Yn and 'phaseAngleClock' = 11.
    '''

    emergencyS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Apparent power that the winding can carry under emergency conditions (also
            called long-term emergency power).
            '''

        })
    '''
    Apparent power that the winding can carry under emergency conditions
    (also called long-term emergency power).
    '''

    insulationU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Basic insulation level voltage rating.
            '''

        })
    '''
    Basic insulation level voltage rating.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC resistance.
            '''

        })
    '''
    DC resistance.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal apparent power rating.
            '''

        })
    '''
    Normal apparent power rating.
    '''

    shortTermS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Apparent power that this winding can carry for a short period of time (in
            emergency).
            '''

        })
    '''
    Apparent power that this winding can carry for a short period of time
    (in emergency).
    '''

    connectionKind: Optional[WindingConnection] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of connection.
            '''

        })
    '''
    Kind of connection.
    '''

    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEndInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Core admittance calculated from this transformer end datasheet, representing
            magnetising current and core losses. The full values of the transformer
            should be supplied for one transformer end info only.
            '''

        })
    '''
    Core admittance calculated from this transformer end datasheet, representing
    magnetising current and core losses. The full values of the transformer
    should be supplied for one transformer end info only.
    '''

    TransformerStarImpedance: Optional[TransformerStarImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerStarImpedance.TransformerEndInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer star impedance calculated from this transformer end datasheet.
            '''

        })
    '''
    Transformer star impedance calculated from this transformer end datasheet.
    '''

    TransformerTankInfo: Optional[TransformerTankInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerTankInfo.TransformerEndInfos',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer tank data that this end description is part of.
            '''

        })
    '''
    Transformer tank data that this end description is part of.
    '''

@dataclass(repr=False)
class CoolingInfo(AssetInfo):
    '''
    Cooling information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    typeOfCooling: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of cooling.
            '''

        })
    '''
    Type of cooling.
    '''

    Specification: Optional[Specification] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Specification.CoolingInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class CrossarmInfo(AssetInfo):
    '''
    Cross arm information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class DamperInfo(AssetInfo):
    '''
    Damper asset information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class InsulationInfo(AssetInfo):
    '''
    Wire data that can be specified per line segment phase, or for the line
    segment as a whole in case its phases all have the same wire characteristics.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    CableInfo: Optional[CableInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CableInfo.InsulationInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    insulated: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if conductor is insulated.
            '''

        })
    '''
    True if conductor is insulated.
    '''

    insulationThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            (if insulated conductor) Thickness of the insulation.
            '''

        })
    '''
    (if insulated conductor) Thickness of the insulation.
    '''

    insulationMaterial: Optional[WireInsulationKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            (if insulated conductor) Material used for insulation.
            '''

        })
    '''
    (if insulated conductor) Material used for insulation.
    '''

    CableInfo: Optional[CableInfo] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CableInfo.InsulationInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class InsulatorInfo(AssetInfo):
    '''
    Insulator information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class InterrupterUnitInfo(AssetInfo):
    '''
    Interrupter datasheet information.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    interruptingMedium: Optional[InterruptingMediumKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Interrupting medium.
            '''

        })
    '''
    Interrupting medium.
    '''

@dataclass(repr=False)
class OperatingMechanismInfo(AssetInfo):
    '''
    Breaker operating mechanism datasheet information.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    closeAmps: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Close current (nominal).
            '''

        })
    '''
    Close current (nominal).
    '''

    closeVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Close voltage in volts DC.
            '''

        })
    '''
    Close voltage in volts DC.
    '''

    motorRunCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated motor run current in amps.
            '''

        })
    '''
    Rated motor run current in amps.
    '''

    motorStartCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated motor start current in amps.
            '''

        })
    '''
    Rated motor start current in amps.
    '''

    motorVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nominal motor voltage in volts DC.
            '''

        })
    '''
    Nominal motor voltage in volts DC.
    '''

    tripAmps: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Trip current (nominal).
            '''

        })
    '''
    Trip current (nominal).
    '''

    tripVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Trip voltage in volts DC.
            '''

        })
    '''
    Trip voltage in volts DC.
    '''

    mechanismKind: Optional[OperatingMechanismKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of breaker operating mechanism.
            '''

        })
    '''
    Kind of breaker operating mechanism.
    '''

@dataclass(repr=False)
class PoleAssetInfo(AssetInfo):
    '''
    Pole asset data sheet.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class PowerTransformerInfo(AssetInfo):
    '''
    Set of power transformer data, from an equipment library.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TransformerTankInfos: list[TransformerTankInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTankInfo.PowerTransformerInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Data for all the tanks described by this power transformer data.
            '''

        })
    '''
    Data for all the tanks described by this power transformer data.
    '''

@dataclass(repr=False)
class ShuntCompensatorInfo(AssetInfo):
    '''
    Properties of shunt capacitor, shunt reactor or switchable bank of shunt
    capacitor or reactor assets.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    maxPowerLoss: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum allowed apparent power loss.
            '''

        })
    '''
    Maximum allowed apparent power loss.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated current.
            '''

        })
    '''
    Rated current.
    '''

    ratedReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated reactive power.
            '''

        })
    '''
    Rated reactive power.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage.
            '''

        })
    '''
    Rated voltage.
    '''

    ShuntCompensatorControl: Optional[ShuntCompensatorControl] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensatorControl.ShuntCompensatorInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class SoundInfo(AssetInfo):
    '''
    Sound information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    minSoundPressureLevel: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum sound pressure level.
            '''

        })
    '''
    Minimum sound pressure level.
    '''

    Specification: Optional[Specification] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Specification.SoundInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class StructureInfo(AssetInfo):
    '''
    Structure information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    hasTemperatureMeasurement: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if structure includes a temperature measurement.
            '''

        })
    '''
    True if structure includes a temperature measurement.
    '''

    hasVentilation: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if vault is ventilating.
            '''

        })
    '''
    True if vault is ventilating.
    '''

    material: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Material this structure is made of.
            '''

        })
    '''
    Material this structure is made of.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum rated voltage of the equipment that can be mounted on/contained
            within the structure.
            '''

        })
    '''
    Maximum rated voltage of the equipment that can be mounted on/contained
    within the structure.
    '''

    materialKind: Optional[StructureMaterialKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Material this structure is made of.
            '''

        })
    '''
    Material this structure is made of.
    '''

@dataclass(repr=False)
class MarineStructureInfo(StructureInfo):
    '''
    Marine structure information.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    kind: Optional[MarineStructureKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of submarine structure.
            '''

        })
    '''
    Type of submarine structure.
    '''

@dataclass(repr=False)
class OverheadStructureInfo(StructureInfo):
    '''
    Overhead structure information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class UndergroundStructureInfo(StructureInfo):
    '''
    Underground structure information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    kind: Optional[UndergroundStructureKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of underground structure
            '''

        })
    '''
    Kind of underground structure
    '''

@dataclass(repr=False)
class SurfaceTreatmentInfo(AssetInfo):
    '''
    Surface treatment information
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    galvanizationThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Galvanization thickness.
            '''

        })
    '''
    Galvanization thickness.
    '''

    paintThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Paint thickness.
            '''

        })
    '''
    Paint thickness.
    '''

    Specification: Optional[Specification] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Specification.SurfaceTreatmentInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class ToolInfo(AssetInfo):
    '''
    Type of tool needed to perform a certain type of work.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    toolType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of the tool
            '''

        })
    '''
    Type of the tool
    '''

@dataclass(repr=False)
class TransformerTankInfo(AssetInfo):
    '''
    Set of transformer tank data, from an equipment library.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TransformerEndInfos: list[TransformerEndInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEndInfo.TransformerTankInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Data for all the ends described by this transformer tank data.
            '''

        })
    '''
    Data for all the ends described by this transformer tank data.
    '''

    TransformerTanks: list[TransformerTank] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTank.TransformerTankInfo',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PowerTransformerInfo: Optional[PowerTransformerInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerTransformerInfo.TransformerTankInfos',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power transformer data that this tank description is part of.
            '''

        })
    '''
    Power transformer data that this tank description is part of.
    '''

@dataclass(repr=False)
class VehicleInfo(AssetInfo):
    '''
    Type of vehicle needed to perform certain type of work.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    vehicleType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of vehicle.
            '''

        })
    '''
    Type of vehicle.
    '''

@dataclass(repr=False)
class WireAssemblyInfo(AssetInfo):
    '''
    Describes the construction of a multi-conductor wire.<-NOTE: period missing.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PerLengthLineParameter: list[PerLengthLineParameter] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PerLengthLineParameter.WireAssemblyInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Per length line parameter associated with this wire assembly.
            '''

        })
    '''
    Per length line parameter associated with this wire assembly.
    '''

    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireAssemblyInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Wire phase information associated with this wire assembly.
            '''

        })
    '''
    Wire phase information associated with this wire assembly.
    '''

@stereotype(CIMStereotype.deprecated)
@dataclass(repr=False)
class WireSpacingInfo(AssetInfo):
    '''
    Wire spacing data that associates multiple wire positions with the line
    segment, and allows to calculate line segment impedances. Number of phases
    can be derived from the number of associated wire positions whose phase
    is not neutral.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ACLineSegment: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.WireSpacingInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WirePositions: list[WirePosition] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePosition.WireSpacingInfo',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All positions of single wires (phase or neutral) making the conductor.
            '''

        })
    '''
    All positions of single wires (phase or neutral) making the conductor.
    '''

    isCable: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, this spacing data describes a cable.
            '''

        })
    '''
    If true, this spacing data describes a cable.
    '''

    phaseWireCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'modify Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of wire sub-conductors in the symmetrical bundle (typically between
            1 and 4).
            '''

        })
    '''
    Number of wire sub-conductors in the symmetrical bundle (typically
    between 1 and 4).
    '''

    phaseWireSpacing: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'modify Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Distance between wire sub-conductors in a symmetrical bundle.
            '''

        })
    '''
    Distance between wire sub-conductors in a symmetrical bundle.
    '''

    usage: Optional[WireUsageKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Usage of the associated wires.
            '''

        })
    '''
    Usage of the associated wires.
    '''

    DuctBank: Optional[DuctBank] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DuctBank.WireSpacingInfos',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class AssetInfoComponent(IdentifiedObject):
    '''
    Components of an asset info
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ParentAssetInfo: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.ChildAssetInfoComponent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ChildAssetInfo: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.ParentAssetInfoComponent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of component
            '''

        })
    '''
    Type of component
    '''

    ChildAssetInfo: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.ParentAssetInfoComponent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ParentAssetInfo: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.ChildAssetInfoComponent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class AssetRequirement(IdentifiedObject):
    '''
    This is an asset requirement information defined by designed (product procurer).
    It is related to AssetInfo.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Assets'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AssetInfo: list[AssetInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AssetInfo.AssetRequirement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class AsynchronousMachineDynamics(IdentifiedObject):
    '''
    Asynchronous machine whose behaviour is described by reference to a standard
    model expressed in either time constant reactance form or equivalent circuit
    form <font color="#0f0f0f">or by definition of a user-defined model.</font>
    Parameter details:
    <ol>
    <li>Asynchronous machine parameters such as <i>Xl, Xs,</i> etc. are actually
    used as inductances in the model, but are commonly referred to as reactances
    since, at nominal frequency, the PU values are the same. However, some
    references use the symbol <i>L</i> instead of <i>X</i>.</li>
    </ol>
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AsynchronousMachineDynamics'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AsynchronousMachine: Optional[AsynchronousMachine] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AsynchronousMachine.AsynchronousMachineDynamics',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asynchronous machine to which this asynchronous machine dynamics model
            applies.
            '''

        })
    '''
    Asynchronous machine to which this asynchronous machine dynamics model
    applies.
    '''

@dataclass(repr=False)
class AutonomousFunction(IdentifiedObject):
    '''
    Autonomous function performed by an autonomous agent or other devices that
    can before decision making in an autonomous way. Example are robot or a
    bot program.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AutonomousAgent: Optional[AutonomousAgent] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AutonomousAgent.AutonomousFunction',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BaseFrequency(IdentifiedObject):
    '''
    The BaseFrequency class describes a base frequency for a power system network.
    In case of multiple power networks with different frequencies, e.g. 50
    Hz or 60 Hz each network will have its own base frequency class. Hence
    it is assumed that power system objects having different base frequencies
    appear in separate documents where each document has a single base frequency
    instance.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The base frequency.
            '''

        })
    '''
    The base frequency.
    '''

@dataclass(repr=False)
class BasePower(IdentifiedObject):
    '''
    The BasePower class defines the base power used in the per unit calculations.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    basePower: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value used as base power.
            '''

        })
    '''
    Value used as base power.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BaseVoltage(IdentifiedObject):
    '''
    Defines a system base voltage which is referenced. This may be different
    than the rated voltage.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConductingEquipment: list[ConductingEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConductingEquipment.BaseVoltage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All conducting equipment with this base voltage. Use only when there is
            no voltage level container used and only one base voltage applies. For
            example, not used for transformers.
            '''

        })
    '''
    All conducting equipment with this base voltage. Use only when there
    is no voltage level container used and only one base voltage applies.
    For example, not used for transformers.
    '''

    TopologicalNode: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.BaseVoltage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The topological nodes at the base voltage.
            '''

        })
    '''
    The topological nodes at the base voltage.
    '''

    TransformerEnds: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.BaseVoltage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer ends at the base voltage. This is essential for PU calculation.
            '''

        })
    '''
    Transformer ends at the base voltage. This is essential for PU calculation.
    '''

    VoltageLevel: list[VoltageLevel] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageLevel.BaseVoltage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage levels having this base voltage.
            '''

        })
    '''
    The voltage levels having this base voltage.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The power system resource's base voltage, expressed on a phase-to-phase
            (line-to-line) basis. Shall be a positive value and not zero.
            '''

        })
    '''
    The power system resource's base voltage, expressed on a phase-to-phase
    (line-to-line) basis. Shall be a positive value and not zero.
    '''

@dataclass(repr=False)
class BasicIntervalSchedule(IdentifiedObject):
    '''
    Schedule of values at points in time.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    startTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The time for the first time point. The value can be a time of day, not
            a specific date.
            '''

        })
    '''
    The time for the first time point. The value can be a time of day,
    not a specific date.
    '''

    value1Description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Description for value1.
            '''

        })
    '''
    Description for value1.
    '''

    value2Description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Description for value2.
            '''

        })
    '''
    Description for value2.
    '''

    value3Description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Description for value3.
            '''

        })
    '''
    Description for value3.
    '''

    value1Multiplier: Optional[UnitMultiplier] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for value1.
            '''

        })
    '''
    Multiplier for value1.
    '''

    value1Unit: Optional[UnitSymbol] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value1 units of measure.
            '''

        })
    '''
    Value1 units of measure.
    '''

    value2Multiplier: Optional[UnitMultiplier] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for value2.
            '''

        })
    '''
    Multiplier for value2.
    '''

    value2Unit: Optional[UnitSymbol] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value2 units of measure.
            '''

        })
    '''
    Value2 units of measure.
    '''

    value3Multiplier: Optional[UnitMultiplier] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for value3.
            '''

        })
    '''
    Multiplier for value3.
    '''

    value3Unit: Optional[UnitSymbol] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value3 units of measure.
            '''

        })
    '''
    Value3 units of measure.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class IrregularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them varies.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TimePoints: list[IrregularTimePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'IrregularTimePoint.IntervalSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The point data values that define a curve.
            '''

        })
    '''
    The point data values that define a curve.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class RegularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them is constant.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TimePoints: list[RegularTimePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegularTimePoint.IntervalSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The regular interval time point data values that define this schedule.
            '''

        })
    '''
    The regular interval time point data values that define this schedule.
    '''

    endTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The time for the last time point. The value can be a time of day, not a
            specific date.
            '''

        })
    '''
    The time for the last time point. The value can be a time of day, not
    a specific date.
    '''

    timeStep: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The time between each pair of subsequent regular time points in sequence
            order.
            '''

        })
    '''
    The time between each pair of subsequent regular time points in sequence
    order.
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class GenUnitOpSchedule(RegularIntervalSchedule):
    '''
    The generating unit's Operator-approved current operating schedule (or
    plan), typically produced with the aid of unit commitment type analyses.
    The X-axis represents absolute time. The Y1-axis represents the status
    (0=off-line and unavailable: 1=available: 2=must run: 3=must run at fixed
    power value: etc.). The Y2-axis represents the must run fixed power value
    where required.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''

        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''

        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HydroPumpOpSchedule(RegularIntervalSchedule):
    '''
    The hydro pump's Operator-approved current operating schedule (or plan),
    typically produced with the aid of unit commitment type analyses. The unit's
    operating schedule status is typically given as: (0=unavailable) (1=available
    to startup or shutdown) (2=must pump).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.HydroPumpOpSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''

        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''

    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.HydroPumpOpSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''

        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''

@dataclass(repr=False)
class InflowForecast(RegularIntervalSchedule):
    '''
    Natural water inflow to a reservoir, usually forecasted from predicted
    rain and snowmelt. Typically in one hour increments for up to 10 days.
    The forecast is given in average cubic meters per second over the time
    increment.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.InflowForecasts',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A reservoir may have a "natural" inflow forecast.
            '''

        })
    '''
    A reservoir may have a "natural" inflow forecast.
    '''

@dataclass(repr=False)
class SeasonDayTypeSchedule(RegularIntervalSchedule):
    '''
    A time schedule covering a 24 hour period, with curve data for a specific
    type of season and day.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DayType: Optional[DayType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DayType.SeasonDayTypeSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DayType for the Schedule.
            '''

        })
    '''
    DayType for the Schedule.
    '''

    Season: Optional[Season] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Season.SeasonDayTypeSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Season for the Schedule.
            '''

        })
    '''
    Season for the Schedule.
    '''

@dataclass(repr=False)
class ConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    A curve of load versus time (X-axis) showing the active power values (Y1-axis)
    and reactive power (Y2-axis) for each unit of the period covered. This
    curve represents a typical pattern of load over the time period for a given
    day type and season.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConformLoadGroup: Optional[ConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConformLoadGroup.ConformLoadSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ConformLoadGroup where the ConformLoadSchedule belongs.
            '''

        })
    '''
    The ConformLoadGroup where the ConformLoadSchedule belongs.
    '''

@dataclass(repr=False)
class NonConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    An active power (Y1-axis) and reactive power (Y2-axis) schedule (curves)
    versus time (X-axis) for non-conforming loads, e.g., large industrial load
    or power station service (where modelled).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    NonConformLoadGroup: Optional[NonConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NonConformLoadGroup.NonConformLoadSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The NonConformLoadGroup where the NonConformLoadSchedule belongs.
            '''

        })
    '''
    The NonConformLoadGroup where the NonConformLoadSchedule belongs.
    '''

@dataclass(repr=False)
class RegulationSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a controlled variable, e.g., busbar
    voltage.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    VoltageControlZones: list[VoltageControlZone] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageControlZone.RegulationSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A VoltageControlZone may have a voltage regulation schedule.
            '''

        })
    '''
    A VoltageControlZone may have a voltage regulation schedule.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegulatingControl.RegulationSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Regulating controls that have this schedule.
            '''

        })
    '''
    Regulating controls that have this schedule.
    '''

@dataclass(repr=False)
class SwitchSchedule(SeasonDayTypeSchedule):
    '''
    A schedule of switch positions. If RegularTimePoint.value1 is 0, the switch
    is open. If 1, the switch is closed.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Switch: Optional[Switch] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Switch.SwitchSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A SwitchSchedule is associated with a Switch.
            '''

        })
    '''
    A SwitchSchedule is associated with a Switch.
    '''

@dataclass(repr=False)
class TapSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a tap step.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TapChanger: Optional[TapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TapChanger.TapSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A TapSchedule is associated with a TapChanger.
            '''

        })
    '''
    A TapSchedule is associated with a TapChanger.
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class SteamSendoutSchedule(RegularIntervalSchedule):
    '''
    The cogeneration plant's steam sendout schedule in volume per time unit.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.SteamSendoutSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''

        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''

    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.SteamSendoutSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''

        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class BranchGroup(IdentifiedObject):
    '''
    A group of branch terminals whose directed flow summation is to be monitored.
    A branch group need not form a cutset of the network.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'OperationalLimits'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BranchGroupTerminal.BranchGroup',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The directed branch group terminals to be summed.
            '''

        })
    '''
    The directed branch group terminals to be summed.
    '''

    monitorActivePower: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Monitor the active power flow.
            '''

        })
    '''
    Monitor the active power flow.
    '''

    monitorReactivePower: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Monitor the reactive power flow.
            '''

        })
    '''
    Monitor the reactive power flow.
    '''

    maximumActivePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum active power flow.
            '''

        })
    '''
    The maximum active power flow.
    '''

    maximumReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum reactive power flow.
            '''

        })
    '''
    The maximum reactive power flow.
    '''

    minimumActivePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum active power flow.
            '''

        })
    '''
    The minimum active power flow.
    '''

    minimumReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum reactive power flow.
            '''

        })
    '''
    The minimum reactive power flow.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Building(IdentifiedObject):
    '''
    A representation of the spatial structural characteristics of any built
    or constructed asset, including buildings, infrastructure, and other engineered
    structures (e.g., roads, fences, bridges).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    BuildingSpace: list[BuildingSpace] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BuildingSpace.Building',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PhysicalAddress: Optional[PhysicalAddress] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhysicalAddress.Building',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    buildingNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Building number refers to a unique numeric or alphanumeric identifier assigned
            to a building within a property or site, primarily for administrative,
            legal, or logistical purposes, which may differ from the building�s commonly
            known name or descriptive label.
            '''

        })
    '''
    Building number refers to a unique numeric or alphanumeric identifier
    assigned to a building within a property or site, primarily for administrative,
    legal, or logistical purposes, which may differ from the building�s
    commonly known name or descriptive label.
    '''

    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.Building',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PhysicalAddress: Optional[PhysicalAddress] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhysicalAddress.Building',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Site: Optional[Site] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Site.Building',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BuildingSpace(IdentifiedObject):
    '''
    A defined, delimited area or volume within or around any built or constructed
    asset, including enclosed spaces such as: 1) rooms in a building, 2) open
    linear spaces such as areas along a fence, or segments of a road, or 3)
    zones within infrastructure structures.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    LocationAccess: Optional[LocationAccess] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LocationAccess.BuildingSpace',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    floor: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Floor is referring to the vertical position or designation of the space
            within a building, indicating its relationship to other levels, typically
            represented by a numeric or descriptive value (e.g., "Ground Floor," "1st
            Floor," "Basement")
            '''

        })
    '''
    Floor is referring to the vertical position or designation of the space
    within a building, indicating its relationship to other levels, typically
    represented by a numeric or descriptive value (e.g., "Ground Floor,"
    "1st Floor," "Basement")
    '''

    spaceNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Space Number refers to the floor or building numerical identifier assigned
            to a specific space within a building, typically represented by a alphanumeric
            code, used to distinguish the space from others on the same or different
            floors, e.g Room 101, Office A12 or 2-203 (Floor 2, Space 203).
            '''

        })
    '''
    Space Number refers to the floor or building numerical identifier assigned
    to a specific space within a building, typically represented by a alphanumeric
    code, used to distinguish the space from others on the same or different
    floors, e.g Room 101, Office A12 or 2-203 (Floor 2, Space 203).
    '''

    spaceType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Space type is the classification of the space, e.g. Residential, Commercial,
            Industrial, Storage etc.
            '''

        })
    '''
    Space type is the classification of the space, e.g. Residential, Commercial,
    Industrial, Storage etc.
    '''

    Building: Optional[Building] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Building.BuildingSpace',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    LocationAccess: Optional[LocationAccess] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LocationAccess.BuildingSpace',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class BusNameMarker(IdentifiedObject):
    '''
    Used to apply user standard names to TopologicalNodes. Associated with
    one or more terminals that are normally connected with the bus name. The
    associated terminals are normally connected by non-retained switches. For
    a ring bus station configuration, all BusbarSection terminals in the ring
    are typically associated. For a breaker and a half scheme, both BusbarSections
    would normally be associated. For a ring bus, all BusbarSections would
    normally be associated. For a "straight" busbar configuration, normally
    only the main terminal at the BusbarSection would be associated.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Topology'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Terminal: list[ACDCTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACDCTerminal.BusNameMarker',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The terminals associated with this bus name marker.
            '''

        })
    '''
    The terminals associated with this bus name marker.
    '''

    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Priority of bus name marker for use as topology bus name. Use 0 for do
            not care. Use 1 for highest priority. Use 2 as priority is less than 1
            and so on.
            '''

        })
    '''
    Priority of bus name marker for use as topology bus name. Use 0 for
    do not care. Use 1 for highest priority. Use 2 as priority is less
    than 1 and so on.
    '''

    ReportingGroup: Optional[ReportingGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReportingGroup.BusNameMarker',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reporting group to which this bus name marker belongs.
            '''

        })
    '''
    The reporting group to which this bus name marker belongs.
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.BusNameMarker',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A user defined topological node that was originally defined in a planning
            model not yet having topology described by ConnectivityNodes. Once ConnectivityNodes
            have been created they may be linked to user defined ToplogicalNodes using
            BusNameMarkers.
            '''

        })
    '''
    A user defined topological node that was originally defined in a planning
    model not yet having topology described by ConnectivityNodes. Once
    ConnectivityNodes have been created they may be linked to user defined
    ToplogicalNodes using BusNameMarkers.
    '''

@dataclass(repr=False)
class CSCDynamics(IdentifiedObject):
    '''
    CSC function block whose behaviour is described by reference to a standard
    model <font color="#0f0f0f">or by definition of a user-defined model.</font>
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'HVDCDynamics'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    CSConverter: Optional[CsConverter] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CsConverter.CSCDynamics',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Current source converter to which current source converter dynamics model
            applies.
            '''

        })
    '''
    Current source converter to which current source converter dynamics
    model applies.
    '''

@dataclass(repr=False)
class Cadastre(IdentifiedObject):
    '''
    A singular complete record of all land parcels within some hierarchical
    level of administrative jurisdiction. The cadastre provides the ability
    to find the results of land parcel surveys typically used for land management
    and planning.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Address: list[Address] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Address.Cadastre',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Physical addresses encompassed within a given cadastre.
            '''

        })
    '''
    Physical addresses encompassed within a given cadastre.
    '''

    Location: list[Location] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Location.Cadastre',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Location within a cadastre.
            '''

        })
    '''
    Location within a cadastre.
    '''

    administrationLevel: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Administrative level is referring to the organisation that is administrative
            authority for managing the a hierarchical division of a geographic area
            into land, property groups. This typically established by government that
            has the responsibility of managing governance, services, taxation, and
            legal jurisdiction, such as municipalities, townships, counties, or regions.
            '''

        })
    '''
    Administrative level is referring to the organisation that is administrative
    authority for managing the a hierarchical division of a geographic
    area into land, property groups. This typically established by government
    that has the responsibility of managing governance, services, taxation,
    and legal jurisdiction, such as municipalities, townships, counties,
    or regions.
    '''

    cadastralReference: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Local or national unique identification reference for the cadastral for
            land parcel, ensuring effective land management, ownership tracking, and
            legal compliance.
            '''

        })
    '''
    Local or national unique identification reference for the cadastral
    for land parcel, ensuring effective land management, ownership tracking,
    and legal compliance.
    '''

    levelFourDivision: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Level Four Division refers to a further subdivision of a Level Three Division
            within a cadastral hierarchy, typically used to represent specific units
            or sections within a shared property or structure, such as apartments,
            condominiums, or co-owned facilities.
            '''

        })
    '''
    Level Four Division refers to a further subdivision of a Level Three
    Division within a cadastral hierarchy, typically used to represent
    specific units or sections within a shared property or structure, such
    as apartments, condominiums, or co-owned facilities.
    '''

    levelOneDivision: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Level One Division refers to the highest organizational or reference unit
            within a cadastral hierarchy, typically representing a primary division
            of land, such as a farm or property group, which can be further subdivided
            into smaller parcels.
            '''

        })
    '''
    Level One Division refers to the highest organizational or reference
    unit within a cadastral hierarchy, typically representing a primary
    division of land, such as a farm or property group, which can be further
    subdivided into smaller parcels.
    '''

    levelThreeDivision: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Level Three Division refers to a further subdivision of a Level Two Division
            within a cadastral hierarchy, typically used to represent specialized land
            units such as leased parcels, easements, or other secondary divisions associated
            with distinct legal or usage rights.
            '''

        })
    '''
    Level Three Division refers to a further subdivision of a Level Two
    Division within a cadastral hierarchy, typically used to represent
    specialized land units such as leased parcels, easements, or other
    secondary divisions associated with distinct legal or usage rights.
    '''

    levelTwoDivision: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Level Two Division refers to a subdivision of a Level One Parcel within
            a cadastral hierarchy, representing smaller, distinct land units typically
            used for individual ownership, usage, or development, such as specific
            plots or lots within a farm or property group.
            '''

        })
    '''
    Level Two Division refers to a subdivision of a Level One Parcel within
    a cadastral hierarchy, representing smaller, distinct land units typically
    used for individual ownership, usage, or development, such as specific
    plots or lots within a farm or property group.
    '''

    CadastreType: Optional[CadastreType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CadastreType.Cadastre',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Site: Optional[Site] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Site.Cadastre',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class CadastreType(IdentifiedObject):
    '''
    Cadastre type specifies the labels associated with each administrative
    level within the administrative system used by the land management governing
    authority.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Cadastre: list[Cadastre] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Cadastre.CadastreType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    administrationLabel: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Label for the administrative level of a property cadastral, e.g. municipalities,
            townships, counties, or regions.
            '''

        })
    '''
    Label for the administrative level of a property cadastral, e.g. municipalities,
    townships, counties, or regions.
    '''

    levelFourLabel: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Label for level four of a property cadastral, e.g. [need example(s)].
            '''

        })
    '''
    Label for level four of a property cadastral, e.g. [need example(s)].
    '''

    levelOneLabel: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Label for level one of a property cadastral, e.g. [need example(s)].
            '''

        })
    '''
    Label for level one of a property cadastral, e.g. [need example(s)].
    '''

    levelThreeLabel: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Label for level three of a property cadastral, e.g. [need example(s)].
            '''

        })
    '''
    Label for level three of a property cadastral, e.g. [need example(s)].
    '''

    levelTwoLabel: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Label for level two of a property cadastral, e.g. [need example(s)].
            '''

        })
    '''
    Label for level two of a property cadastral, e.g. [need example(s)].
    '''

@stereotype(CIMStereotype.harmonization)
@dataclass(repr=False)
class CalculationMethodHierarchy(IdentifiedObject):
    '''
    The hierarchy of calculation methods used to derive this measurement.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetMeas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Measurement: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.CalculationMethodHierarchy',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement to which this calculation method hierarchy applies.
            '''

        })
    '''
    Measurement to which this calculation method hierarchy applies.
    '''

    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'harmonization',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.CalculationMethodHierarchy',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement value to which this calculation method hierarchy applies.
            '''

        })
    '''
    Measurement value to which this calculation method hierarchy applies.
    '''

@dataclass(repr=False)
class CatalogAssetType(IdentifiedObject):
    '''
    a Assets that may be used for planning, work or design purposes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Assets'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AssetInfo: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.CatalogAssetType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generic nameplate information associated with this catalog asset type.
            '''

        })
    '''
    Generic nameplate information associated with this catalog asset type.
    '''

@stereotype(CIMStereotype.European)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ConnectivityNode(IdentifiedObject):
    '''
    Connectivity nodes are points where terminals of AC conducting equipment
    are connected together with zero impedance.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ACPointOfCommonCoupling: Optional[ACPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACPointOfCommonCoupling.ConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Identifies this ConnectivityNode as a point of common coupling AC.
            '''

        })
    '''
    Identifies this ConnectivityNode as a point of common coupling AC.
    '''

    BoundaryPoint: Optional[BoundaryPoint] = field(
        default=None,
        metadata={
        'type': 'European',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BoundaryPoint.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The boundary point associated with the connectivity node.
            '''

        })
    '''
    The boundary point associated with the connectivity node.
    '''

    RegisteredResource: list[RegisteredResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegisteredResource.ConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Terminals interconnected with zero impedance at a this connectivity node.
            '''

        })
    '''
    Terminals interconnected with zero impedance at a this connectivity
    node.
    '''

    ACPointOfCommonCoupling: Optional[ACPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACPointOfCommonCoupling.ConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Identifies this ConnectivityNode as a point of common coupling AC.
            '''

        })
    '''
    Identifies this ConnectivityNode as a point of common coupling AC.
    '''

    BoundaryPoint: Optional[BoundaryPoint] = field(
        default=None,
        metadata={
        'type': 'European',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BoundaryPoint.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The boundary point associated with the connectivity node.
            '''

        })
    '''
    The boundary point associated with the connectivity node.
    '''

    ConnectivityNodeContainer: Optional[ConnectivityNodeContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNodeContainer.ConnectivityNodes',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Container of this connectivity node.
            '''

        })
    '''
    Container of this connectivity node.
    '''

    IndividualPnode: Optional[IndividualPnode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IndividualPnode.ConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.ConnectivityNodes',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The topological node to which this connectivity node is assigned. May depend
            on the current state of switches in the network.
            '''

        })
    '''
    The topological node to which this connectivity node is assigned. May
    depend on the current state of switches in the network.
    '''

@dataclass(repr=False)
class MktConnectivityNode(ConnectivityNode):
    '''
    Subclass of IEC61970:Topology:ConnectivityNode.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketOpCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    RTO: Optional[RTO] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RTO.MktConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    SysLoadDistribuFactor: Optional[SysLoadDistributionFactor] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SysLoadDistributionFactor.MktConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ControlAreaGeneratingUnit(IdentifiedObject):
    '''
    A control area generating unit. This class is needed so that alternate
    control area definitions may include the same generating unit. It should
    be noted that only one instance within a control area should reference
    a specific generating unit.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ControlArea'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AltGeneratingUnitMeas: list[AltGeneratingUnitMeas] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AltGeneratingUnitMeas.ControlAreaGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The link to prioritized measurements for this GeneratingUnit.
            '''

        })
    '''
    The link to prioritized measurements for this GeneratingUnit.
    '''

    ControlArea: Optional[ControlArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlArea.ControlAreaGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The parent control area for the generating unit specifications.
            '''

        })
    '''
    The parent control area for the generating unit specifications.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.ControlAreaGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The generating unit specified for this control area. Note that a control
            area should include a GeneratingUnit only once.
            '''

        })
    '''
    The generating unit specified for this control area. Note that a control
    area should include a GeneratingUnit only once.
    '''

@dataclass(repr=False)
class ControlAreaPowerElectronicsUnit(IdentifiedObject):
    '''
    A control area power electronics unit. This class is needed so that alternate
    control area definitions may include the same power electronics unit. It
    should be noted that only one instance within a control area should reference
    a specific power electronics unit.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ControlArea'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ControlArea: Optional[ControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlArea.ControlAreaPowerElectronicsUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The power electronics unit specifications for the control area.
            '''

        })
    '''
    The power electronics unit specifications for the control area.
    '''

    PowerElectronicsUnit: Optional[PowerElectronicsUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsUnit.ControlAreaPowerElectronicsUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The power electronics unit specified for this control area. Note that a
            control area should include a PowerElectronicsUnit only once.
            '''

        })
    '''
    The power electronics unit specified for this control area. Note that
    a control area should include a PowerElectronicsUnit only once.
    '''

@dataclass(repr=False)
class CoordinateSystem(IdentifiedObject):
    '''
    Coordinate reference system.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Geometry: list[Geometry] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Geometry.CoordinateSystem',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The geometry which uses a given coordinate system.
            '''

        })
    '''
    The geometry which uses a given coordinate system.
    '''

    Location: list[Location] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Location.CoordinateSystem',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All locations described with position points in this coordinate system.
            '''

        })
    '''
    All locations described with position points in this coordinate system.
    '''

    crsUrn: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A Uniform Resource Name (URN) for the coordinate reference system (crs)
            used to define 'Location.PositionPoints'.
            An example would be the European Petroleum Survey Group (EPSG) code for
            a coordinate reference system, defined in URN under the Open Geospatial
            Consortium (OGC) namespace as: urn:ogc:def:crs:EPSG::XXXX, where XXXX is
            an EPSG code (a full list of codes can be found at the EPSG Registry web
            site http://www.epsg-registry.org/). To define the coordinate system as
            being WGS84 (latitude, longitude) using an EPSG OGC, this attribute would
            be urn:ogc:def:crs:EPSG::4236.
            A profile should limit this code to a set of allowed URNs agreed to by
            all sending and receiving parties.
            '''

        })
    '''
    A Uniform Resource Name (URN) for the coordinate reference system (crs)
    used to define 'Location.PositionPoints'.
    An example would be the European Petroleum Survey Group (EPSG) code
    for a coordinate reference system, defined in URN under the Open Geospatial
    Consortium (OGC) namespace as: urn:ogc:def:crs:EPSG::XXXX, where XXXX
    is an EPSG code (a full list of codes can be found at the EPSG Registry
    web site http://www.epsg-registry.org/). To define the coordinate system
    as being WGS84 (latitude, longitude) using an EPSG OGC, this attribute
    would be urn:ogc:def:crs:EPSG::4236.
    A profile should limit this code to a set of allowed URNs agreed to
    by all sending and receiving parties.
    '''

@dataclass(repr=False)
class CoupledLineSegmentGroup(IdentifiedObject):
    '''
    Aggregates a set of line segments that are on the same tower, or in the
    same right-of-way, close enough that mutual coupling impedances between
    the lines need to be included in network analysis.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    LineSegmentCoupling: list[LineSegmentCoupling] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LineSegmentCoupling.CoupledLineSegmentGroup',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A coupled line in this coupled group of lines.
            '''

        })
    '''
    A coupled line in this coupled group of lines.
    '''

@dataclass(repr=False)
class CrewType(IdentifiedObject):
    '''
    Custom description of the type of crew. This may be used to determine the
    type of work the crew can be assigned to. Examples include repair, tree
    trimming, switching, etc.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Crews: list[Crew] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Crew.CrewType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All crews of this type.
            '''

        })
    '''
    All crews of this type.
    '''

@dataclass(repr=False)
class CurrentDroopControlFunction(IdentifiedObject):
    '''
    Current droop control function is a function block that calculates the
    operating point of the controlled equipment to achieve the target current.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'FACTS'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    droopCapacitive: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Droop in capacitive region. The unit is V/A.
            '''

        })
    '''
    Droop in capacitive region. The unit is V/A.
    '''

    droopInductive: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Droop in inductive region. The unit is V/A.
            '''

        })
    '''
    Droop in inductive region. The unit is V/A.
    '''

    offsetCapacitive: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Offset in capacitive region.
            '''

        })
    '''
    Offset in capacitive region.
    '''

    offsetInductive: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Offset in capacitive region.
            '''

        })
    '''
    Offset in capacitive region.
    '''

    targetValueCapacitive: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Setpoint when control is active in capacitive region.
            '''

        })
    '''
    Setpoint when control is active in capacitive region.
    '''

    targetValueInductive: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Setpoint when control is active in inductive region.
            '''

        })
    '''
    Setpoint when control is active in inductive region.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Curve(IdentifiedObject):
    '''
    A multi-purpose curve or functional relationship between an independent
    variable (X-axis) and dependent (Y-axis) variables.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    CurveDatas: list[CurveData] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CurveData.Curve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The point data values that define this curve.
            '''

        })
    '''
    The point data values that define this curve.
    '''

    curveStyle: Optional[CurveStyle] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The style or shape of the curve.
            '''

        })
    '''
    The style or shape of the curve.
    '''

    xMultiplier: Optional[UnitMultiplier] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for X-axis.
            '''

        })
    '''
    Multiplier for X-axis.
    '''

    xUnit: Optional[UnitSymbol] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The X-axis units of measure.
            '''

        })
    '''
    The X-axis units of measure.
    '''

    y1Multiplier: Optional[UnitMultiplier] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for Y1-axis.
            '''

        })
    '''
    Multiplier for Y1-axis.
    '''

    y1Unit: Optional[UnitSymbol] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Y1-axis units of measure.
            '''

        })
    '''
    The Y1-axis units of measure.
    '''

    y2Multiplier: Optional[UnitMultiplier] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for Y2-axis.
            '''

        })
    '''
    Multiplier for Y2-axis.
    '''

    y2Unit: Optional[UnitSymbol] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Y2-axis units of measure.
            '''

        })
    '''
    The Y2-axis units of measure.
    '''

    y3Multiplier: Optional[UnitMultiplier] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Multiplier for Y3-axis.
            '''

        })
    '''
    Multiplier for Y3-axis.
    '''

    y3Unit: Optional[UnitSymbol] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Y3-axis units of measure.
            '''

        })
    '''
    The Y3-axis units of measure.
    '''

@dataclass(repr=False)
class AmbientTemperatureDependencyCurve(Curve):
    '''
    A curve or functional relationship between the ambient temperature independent
    variable (X-axis) and relative temperature dependent (Y-axis) variables.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'SecurityLimit'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    OperationalLimitType: list[OperationalLimitType] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitType.PermanentAmbientTemperatureDependencyCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit type that has this permanent ambient temperature
            dependency curve.
            '''

        })
    '''
    The operational limit type that has this permanent ambient temperature
    dependency curve.
    '''

@dataclass(repr=False)
class BaseOverloadLimitCurve(Curve):
    '''
    A curve or functional relationship between
    - the relative loading - current loading over permanent loading (PATL)
    independent variable (X-axis), and
    - temporary overloading (TATL) limiting dependent (Y-axis) variables.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'SecurityLimit'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    OperationalLimitType: list[OperationalLimitType] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitType.TemporaryBaseOverloadLimitCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit type that has this temporary base overload limit
            curve.
            '''

        })
    '''
    The operational limit type that has this temporary base overload limit
    curve.
    '''

@dataclass(repr=False)
class ConductorCharacteristicCurve(Curve):
    '''
    Class to associate damage curves to conductors or to their datasheets.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Protection'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Conductor: list[Conductor] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Conductor.DamageCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A conductor can have a damage curve associated to it.
            '''

        })
    '''
    A conductor can have a damage curve associated to it.
    '''

@dataclass(repr=False)
class DurationOverloadLimitCurve(Curve):
    '''
    A curve or functional relationship between
    - the overload duration independent variable (X-axis), and
    - temporary overloading (TATL) limiting dependent (Y-axis) variables.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'SecurityLimit'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    OperationalLimitType: list[OperationalLimitType] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitType.TemporaryDurationOverloadLimitCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit type that has this temporary duration overload limit
            curve.
            '''

        })
    '''
    The operational limit type that has this temporary duration overload
    limit curve.
    '''

@dataclass(repr=False)
class EmissionAccount(Curve):
    '''
    Accounts for tracking emissions usage and credits for thermal generating
    units. A unit may have zero or more emission accounts, and will typically
    have one for tracking usage and one for tracking credits.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    emissionType: Optional[EmissionType] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of emission, for example sulfur dioxide (SO2). The y1AxisUnits
            of the curve contains the unit of measure (e.g. kg) and the emissionType
            is the type of emission (e.g. sulfur dioxide).
            '''

        })
    '''
    The type of emission, for example sulfur dioxide (SO2). The y1AxisUnits
    of the curve contains the unit of measure (e.g. kg) and the emissionType
    is the type of emission (e.g. sulfur dioxide).
    '''

    emissionValueSource: Optional[EmissionValueSource] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The source of the emission value.
            '''

        })
    '''
    The source of the emission value.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.EmmissionAccounts',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more emission allowance accounts.
            '''

        })
    '''
    A thermal generating unit may have one or more emission allowance accounts.
    '''

@dataclass(repr=False)
class EmissionCurve(Curve):
    '''
    Relationship between the unit's emission rate in units of mass per hour
    (Y-axis) and output active power (X-axis) for a given type of emission.
    This curve applies when only one type of fuel is being burned.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''

        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    emissionContent: Optional[ float | Emission ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The emission content per quantity of fuel burned.
            '''

        })
    '''
    The emission content per quantity of fuel burned.
    '''

    emissionType: Optional[EmissionType] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of emission, which also gives the production rate measurement
            unit. The y1AxisUnits of the curve contains the unit of measure (e.g. kg)
            and the emissionType is the type of emission (e.g. sulfur dioxide).
            '''

        })
    '''
    The type of emission, which also gives the production rate measurement
    unit. The y1AxisUnits of the curve contains the unit of measure (e.g.
    kg) and the emissionType is the type of emission (e.g. sulfur dioxide).
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.EmissionCurves',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more emission curves.
            '''

        })
    '''
    A thermal generating unit may have one or more emission curves.
    '''

@dataclass(repr=False)
class FuelAllocationSchedule(Curve):
    '''
    The amount of fuel of a given type which is allocated for consumption over
    a specified period of time.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    fuelAllocationEndDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The end time and date of the fuel allocation schedule.
            '''

        })
    '''
    The end time and date of the fuel allocation schedule.
    '''

    fuelAllocationStartDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The start time and date of the fuel allocation schedule.
            '''

        })
    '''
    The start time and date of the fuel allocation schedule.
    '''

    maxFuelAllocation: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum amount of fuel that is allocated for consumption for the scheduled
            time period.
            '''

        })
    '''
    The maximum amount of fuel that is allocated for consumption for the
    scheduled time period.
    '''

    minFuelAllocation: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum amount of fuel that is allocated for consumption for the scheduled
            time period, e.g., based on a "take-or-pay" contract.
            '''

        })
    '''
    The minimum amount of fuel that is allocated for consumption for the
    scheduled time period, e.g., based on a "take-or-pay" contract.
    '''

    fuelType: Optional[FuelType] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of fuel, which also indicates the corresponding measurement unit.
            '''

        })
    '''
    The type of fuel, which also indicates the corresponding measurement
    unit.
    '''

    FossilFuel: Optional[FossilFuel] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FossilFuel.FuelAllocationSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A fuel allocation schedule shall have a fossil fuel.
            '''

        })
    '''
    A fuel allocation schedule shall have a fossil fuel.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.FuelAllocationSchedules',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more fuel allocation schedules.
            '''

        })
    '''
    A thermal generating unit may have one or more fuel allocation schedules.
    '''

@dataclass(repr=False)
class FuseCharacteristicCurve(Curve):
    '''
    This class represents the characteristic curve of fuse.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Protection'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    FuseMinimumMelt: Optional[Fuse] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Fuse.MiinimumMeltCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fuse this curve is associated to.
            '''

        })
    '''
    Fuse this curve is associated to.
    '''

    FuseTotalClearing: Optional[Fuse] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Fuse.TotalClearingTimeCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fuse this curve is associated to.
            '''

        })
    '''
    Fuse this curve is associated to.
    '''

@dataclass(repr=False)
class GenUnitOpCostCurve(Curve):
    '''
    Relationship between unit operating cost (Y-axis) and unit output active
    power (X-axis). The operating cost curve for thermal units is derived from
    heat input and fuel costs. The operating cost curve for hydro units is
    derived from water flow rates and equivalent water costs.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''

        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpCostCurves',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have one or more cost curves, depending upon fuel
            mixture and fuel cost.
            '''

        })
    '''
    A generating unit may have one or more cost curves, depending upon
    fuel mixture and fuel cost.
    '''

@dataclass(repr=False)
class GrossToNetActivePowerCurve(Curve):
    '''
    Relationship between the generating unit's gross active power output on
    the X-axis (measured at the terminals of the machine(s)) and the generating
    unit's net active power output on the Y-axis (based on utility-defined
    measurements at the power station). Station service loads, when modelled,
    should be treated as non-conforming bus loads. There may be more than one
    curve, depending on the auxiliary equipment that is in service.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GrossToNetActivePowerCurves',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A generating unit may have a gross active power to net active power curve,
            describing the losses and auxiliary power requirements of the unit.
            '''

        })
    '''
    A generating unit may have a gross active power to net active power
    curve, describing the losses and auxiliary power requirements of the
    unit.
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HeatInputCurve(Curve):
    '''
    Relationship between unit heat input in energy per time for main fuel (Y1-axis)
    and supplemental fuel (Y2-axis) versus unit output in active power (X-axis).
    The quantity of main fuel used to sustain generation at this output level
    is prorated for throttling between definition points. The quantity of supplemental
    fuel used at this output level is fixed and not prorated.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''

        })
    '''
    A thermal generating unit may have a heat input curve.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''

        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    auxPowerMult: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power output - auxiliary power multiplier adjustment factor.
            '''

        })
    '''
    Power output - auxiliary power multiplier adjustment factor.
    '''

    auxPowerOffset: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power output - auxiliary power offset adjustment factor.
            '''

        })
    '''
    Power output - auxiliary power offset adjustment factor.
    '''

    heatInputEff: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Heat input - efficiency multiplier adjustment factor.
            '''

        })
    '''
    Heat input - efficiency multiplier adjustment factor.
    '''

    heatInputOffset: Optional[ float | HeatRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Heat input - offset adjustment factor.
            '''

        })
    '''
    Heat input - offset adjustment factor.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''

        })
    '''
    A thermal generating unit may have a heat input curve.
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HeatRateCurve(Curve):
    '''
    Relationship between unit heat rate per active power (Y-axis) and unit
    output (X-axis). The heat input is from all fuels.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatRateCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''

        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''

        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatRateCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''

        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''

@dataclass(repr=False)
class HydroGeneratingEfficiencyCurve(Curve):
    '''
    Relationship between unit efficiency as percentage and unit output active
    power for a given net head in meters. The relationship between efficiency,
    discharge, head, and power output is expressed as follows: E =KP/HQ
    where: E is the efficiency, as a percentage; P is the active power; H is
    the height; Q is the discharge, volume/time unit; K is a constant.
    For example, a curve instance for a given net head could show efficiency
    (Y-axis) versus active power output (X-axis) or versus discharge on the
    X-axis.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.HydroGeneratingEfficiencyCurves',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A hydro generating unit has an efficiency curve.
            '''

        })
    '''
    A hydro generating unit has an efficiency curve.
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class IncrementalHeatRateCurve(Curve):
    '''
    Relationship between unit incremental heat rate in (delta energy/time)
    per (delta active power) and unit output in active power. The IHR curve
    represents the slope of the HeatInputCurve. Note that the "incremental
    heat rate" and the "heat rate" have the same engineering units.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.IncrementalHeatRateCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''

        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''

        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.IncrementalHeatRateCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''

        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''

@dataclass(repr=False)
class LevelVsVolumeCurve(Curve):
    '''
    Relationship between reservoir volume and reservoir level. The volume is
    at the Y-axis and the reservoir level at the X-axis.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.LevelVsVolumeCurves',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A reservoir may have a level versus volume relationship.
            '''

        })
    '''
    A reservoir may have a level versus volume relationship.
    '''

@dataclass(repr=False)
class LossCurve(Curve):
    '''
    Represents the losses in the equipment due to operation position.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'FACTS'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    FACTSEquipment: Optional[FACTSEquipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FACTSEquipment.LossCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The FACTS equipment which has a loss curve.
            '''

        })
    '''
    The FACTS equipment which has a loss curve.
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class PenstockLossCurve(Curve):
    '''
    Relationship between penstock head loss (in meters) and total discharge
    through the penstock (in cubic meters per second). One or more turbines
    may be connected to the same penstock.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.PenstockLossCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''

        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.PenstockLossCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''

        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''

@dataclass(repr=False)
class ReactiveCapabilityCurve(Curve):
    '''
    Reactive power rating envelope versus the synchronous machine's active
    power, in both the generating and motoring modes. For each active power
    value there is a corresponding high and low reactive power limit value.
    Typically there will be a separate curve for each coolant condition, such
    as hydrogen pressure. The Y1 axis values represent reactive minimum and
    the Y2 axis values represent reactive maximum.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    InitiallyUsedBySynchronousMachine: list[SynchronousMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SynchronousMachine.InitialReactiveCapabilityCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Synchronous machines using this curve as default.
            '''

        })
    '''
    Synchronous machines using this curve as default.
    '''

    coolantTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The machine's coolant temperature (e.g., ambient air or stator circulating
            water).
            '''

        })
    '''
    The machine's coolant temperature (e.g., ambient air or stator circulating
    water).
    '''

    hydrogenPressure: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hydrogen coolant pressure.
            '''

        })
    '''
    The hydrogen coolant pressure.
    '''

    referenceVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reference voltage for which the capability curve is valid.
            '''

        })
    '''
    The reference voltage for which the capability curve is valid.
    '''

    ExtendedWardEquivalent: Optional[ExtendedWardEquivalent] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ExtendedWardEquivalent.ReactiveCapabilityCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The extended ward equivalent using this reactive capability curve.
            '''

        })
    '''
    The extended ward equivalent using this reactive capability curve.
    '''

    SynchronousMachine: Optional[SynchronousMachine] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SynchronousMachine.ReactiveCapabilityCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The synchronous machine using this curve.
            '''

        })
    '''
    The synchronous machine using this curve.
    '''

@dataclass(repr=False)
class RecoveryOverloadLimitCurve(Curve):
    '''
    The relation between the recovery time and an overload limit.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'SecurityLimit'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    OperationalLimitType: list[OperationalLimitType] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitType.RecoveryOverloadLimitCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit type which has recovery time characteristic.
            '''

        })
    '''
    The operational limit type which has recovery time characteristic.
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class ShutdownCurve(Curve):
    '''
    Relationship between the rate in gross active power/minute (Y-axis) at
    which a unit should be shutdown and its present gross MW output (X-axis).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.ShutdownCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''

        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''

    shutdownDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The date and time of the most recent generating unit shutdown.
            '''

        })
    '''
    The date and time of the most recent generating unit shutdown.
    '''

    shutdownCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fixed shutdown cost.
            '''

        })
    '''
    Fixed shutdown cost.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.ShutdownCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''

        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''

@dataclass(repr=False)
class SolarRadiationDependencyCurve(Curve):
    '''
    A curve or functional relationship between
    - the solar radiation independent variable (X-axis), and
    - relative dependent (Y-axis) variables.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'SecurityLimit'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    OperationalLimitType: list[OperationalLimitType] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitType.PermanentSolarRadiationCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit type that has this permanent solar radiation curve.
            '''

        })
    '''
    The operational limit type that has this permanent solar radiation
    curve.
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartIgnFuelCurve(Curve):
    '''
    The quantity of ignition fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartIgnFuelCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''

        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''

    ignitionFuelType: Optional[FuelType] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of ignition fuel.
            '''

        })
    '''
    Type of ignition fuel.
    '''

    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartIgnFuelCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''

        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartMainFuelCurve(Curve):
    '''
    The quantity of main fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartMainFuelCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''

        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''

    mainFuelType: Optional[FuelType] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of main fuel.
            '''

        })
    '''
    Type of main fuel.
    '''

    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartMainFuelCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''

        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartRampCurve(Curve):
    '''
    Rate in gross active power per minute (Y-axis) at which a unit can be loaded
    versus the number of hours (X-axis) the unit was off line.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartRampCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''

        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''

    hotStandbyRamp: Optional[ float | ActivePowerChangeRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The startup ramp rate in gross for a unit that is on hot standby.
            '''

        })
    '''
    The startup ramp rate in gross for a unit that is on hot standby.
    '''

    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartRampCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''

        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''

@dataclass(repr=False)
class TailbayLossCurve(Curve):
    '''
    Relationship between tailbay head loss height (Y-axis) and the total discharge
    into the power station's tailbay volume per time unit (X-axis) . There
    could be more than one curve depending on the level of the tailbay reservoir
    or river level.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.TailbayLossCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A hydro generating unit has a tailbay loss curve.
            '''

        })
    '''
    A hydro generating unit has a tailbay loss curve.
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class TargetLevelSchedule(Curve):
    '''
    Reservoir water level targets from advanced studies or "rule curves". Typically
    in one hour increments for up to 10 days.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.TargetLevelSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''

        })
    '''
    A reservoir may have a water level target schedule.
    '''

    highLevelLimit: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            High target level limit, above which the reservoir operation will be penalized.
            '''

        })
    '''
    High target level limit, above which the reservoir operation will be
    penalized.
    '''

    lowLevelLimit: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Low target level limit, below which the reservoir operation will be penalized.
            '''

        })
    '''
    Low target level limit, below which the reservoir operation will be
    penalized.
    '''

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.TargetLevelSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''

        })
    '''
    A reservoir may have a water level target schedule.
    '''

@dataclass(repr=False)
class VsCapabilityCurve(Curve):
    '''
    The P-Q capability curve for a voltage source converter, with P on X-axis
    and Qmin and Qmax on Y1-axis and Y2-axis.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    referenceVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reference voltage for which the capability curve is valid.
            '''

        })
    '''
    The reference voltage for which the capability curve is valid.
    '''

    VsConverter: Optional[VsConverter] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VsConverter.CapabilityCurve',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage source vonverters with this capability curve.
            '''

        })
    '''
    The voltage source vonverters with this capability curve.
    '''

@dataclass(repr=False)
class DCNode(IdentifiedObject):
    '''
    DC nodes are points where terminals of DC conducting equipment are connected
    together with zero impedance.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCTerminals: list[DCBaseTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCBaseTerminal.DCNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC base terminals interconnected with zero impedance at a this DC connectivity
            node.
            '''

        })
    '''
    DC base terminals interconnected with zero impedance at a this DC connectivity
    node.
    '''

    DCPointOfCommonCoupling: Optional[DCPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCPointOfCommonCoupling.DCNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Identifies that this DC node is a point of common coupling DC.
            '''

        })
    '''
    Identifies that this DC node is a point of common coupling DC.
    '''

    DCEquipmentContainer: Optional[DCEquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCEquipmentContainer.DCNodes',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC container for the DC nodes.
            '''

        })
    '''
    The DC container for the DC nodes.
    '''

    DCPointOfCommonCoupling: Optional[DCPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCPointOfCommonCoupling.DCNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Identifies that this DC node is a point of common coupling DC.
            '''

        })
    '''
    Identifies that this DC node is a point of common coupling DC.
    '''

    DCTopologicalNode: Optional[DCTopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCTopologicalNode.DCNodes',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC topological node to which this DC connectivity node is assigned.
            May depend on the current state of switches in the network.
            '''

        })
    '''
    The DC topological node to which this DC connectivity node is assigned.
    May depend on the current state of switches in the network.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class DCTopologicalIsland(IdentifiedObject):
    '''
    An electrically connected subset of the network. DC topological islands
    can change as the current network state changes, e.g. due to:
    - disconnect switches or breakers changing state in a SCADA/EMS.
    - manual creation, change or deletion of topological nodes in a planning
    tool.
    Only energised TopologicalNode-s shall be part of the topological island.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCTopologicalNodes: list[DCTopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCTopologicalNode.DCTopologicalIsland',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC topological nodes in a DC topological island.
            '''

        })
    '''
    The DC topological nodes in a DC topological island.
    '''

@dataclass(repr=False)
class DCTopologicalNode(IdentifiedObject):
    '''
    DC bus.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCTerminals: list[DCBaseTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCBaseTerminal.DCTopologicalNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            See association end TopologicalNode.Terminal.
            '''

        })
    '''
    See association end TopologicalNode.Terminal.
    '''

    DCNodes: list[DCNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCNode.DCTopologicalNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC connectivity nodes combined together to form this DC topological
            node. May depend on the current state of switches in the network.
            '''

        })
    '''
    The DC connectivity nodes combined together to form this DC topological
    node. May depend on the current state of switches in the network.
    '''

    SvDCVoltage: list[SvDCVoltage] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvDCVoltage.DCTopologicalNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The state DC voltage associated with the DC topological node.
            '''

        })
    '''
    The state DC voltage associated with the DC topological node.
    '''

    DCEquipmentContainer: Optional[DCEquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCEquipmentContainer.DCTopologicalNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The connectivity node container to which the topological node belongs.
            '''

        })
    '''
    The connectivity node container to which the topological node belongs.
    '''

    DCTopologicalIsland: Optional[DCTopologicalIsland] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCTopologicalIsland.DCTopologicalNodes',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A DC topological node belongs to a DC topological island.
            '''

        })
    '''
    A DC topological node belongs to a DC topological island.
    '''

@dataclass(repr=False)
class DERDynamics(IdentifiedObject):
    '''
    Parent class supporting relationships to DER dynamics models.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'IEEE1547Dynamics'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AsynchronousMachine: list[AsynchronousMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AsynchronousMachine.DERDynamics',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asynchronous machine model with which this DER dynamics model is associated.
            '''

        })
    '''
    Asynchronous machine model with which this DER dynamics model is associated.
    '''

    PowerElectronicsConnection: list[PowerElectronicsConnection] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsConnection.DERDynamics',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power electronics connection with which this DER dynamics model is associated.
            '''

        })
    '''
    Power electronics connection with which this DER dynamics model is
    associated.
    '''

    SynchronousMachine: list[SynchronousMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SynchronousMachine.DERDynamics',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Synchronous machine model with which this DER dynamics model is associated.
            '''

        })
    '''
    Synchronous machine model with which this DER dynamics model is associated.
    '''

@dataclass(repr=False)
class DayType(IdentifiedObject):
    '''
    Group of similar days. For example it could be used to represent weekdays,
    weekend, or holidays.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    SeasonDayTypeSchedules: list[SeasonDayTypeSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SeasonDayTypeSchedule.DayType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Schedules that use this DayType.
            '''

        })
    '''
    Schedules that use this DayType.
    '''

@dataclass(repr=False)
class DesignElement(IdentifiedObject):
    '''
    An element of a design that places a compatible unit or an asset at a specific
    design location
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Design'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.DesignElement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An existing or future PSR affected by the conceptual design
            '''

        })
    '''
    An existing or future PSR affected by the conceptual design
    '''

@dataclass(repr=False)
class Diagram(IdentifiedObject):
    '''
    The diagram being exchanged. The coordinate system is a standard Cartesian
    coordinate system and the orientation attribute defines the orientation.
    The initial view related attributes can be used to specify an initial view
    with the x,y coordinates of the diagonal points.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DiagramLayout'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DiagramElements: list[DiagramObject] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiagramObject.Diagram',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A diagram is made up of multiple diagram objects.
            '''

        })
    '''
    A diagram is made up of multiple diagram objects.
    '''

    x1InitialView: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            X coordinate of the first corner of the initial view.
            '''

        })
    '''
    X coordinate of the first corner of the initial view.
    '''

    x2InitialView: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            X coordinate of the second corner of the initial view.
            '''

        })
    '''
    X coordinate of the second corner of the initial view.
    '''

    y1InitialView: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Y coordinate of the first corner of the initial view.
            '''

        })
    '''
    Y coordinate of the first corner of the initial view.
    '''

    y2InitialView: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Y coordinate of the second corner of the initial view.
            '''

        })
    '''
    Y coordinate of the second corner of the initial view.
    '''

    orientation: Optional[OrientationKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Coordinate system orientation of the diagram. A positive orientation gives
            standard "right-hand" orientation, with negative orientation indicating
            a "left-hand" orientation. For 2D diagrams, a positive orientation will
            result in X values increasing from left to right and Y values increasing
            from bottom to top. A negative orientation gives the "left-hand" orientation
            (favoured by computer graphics displays) with X values increasing from
            left to right and Y values increasing from top to bottom.
            '''

        })
    '''
    Coordinate system orientation of the diagram. A positive orientation
    gives standard "right-hand" orientation, with negative orientation
    indicating a "left-hand" orientation. For 2D diagrams, a positive orientation
    will result in X values increasing from left to right and Y values
    increasing from bottom to top. A negative orientation gives the "left-hand"
    orientation (favoured by computer graphics displays) with X values
    increasing from left to right and Y values increasing from top to bottom.
    '''

    DiagramStyle: Optional[DiagramStyle] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiagramStyle.Diagram',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A Diagram may have a DiagramStyle.
            '''

        })
    '''
    A Diagram may have a DiagramStyle.
    '''

@dataclass(repr=False)
class DiagramObject(IdentifiedObject):
    '''
    An object that defines one or more points in a given space. This object
    can be associated with anything that specializes IdentifiedObject. For
    single line diagrams such objects typically include such items as analog
    values, breakers, disconnectors, power transformers, and transmission lines.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DiagramLayout'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DiagramObjectPoints: list[DiagramObjectPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiagramObjectPoint.DiagramObject',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A diagram object can have 0 or more points to reflect its layout position,
            routing (for polylines) or boundary (for polygons).
            '''

        })
    '''
    A diagram object can have 0 or more points to reflect its layout position,
    routing (for polylines) or boundary (for polygons).
    '''

    DiagramObjectPoints: list[DiagramObjectPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiagramObjectPoint.DiagramObject',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A diagram object can have 0 or more points to reflect its layout position,
            routing (for polylines) or boundary (for polygons).
            '''

        })
    '''
    A diagram object can have 0 or more points to reflect its layout position,
    routing (for polylines) or boundary (for polygons).
    '''

    drawingOrder: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The drawing order of this element. The higher the number, the later the
            element is drawn in sequence. This is used to ensure that elements that
            overlap are rendered in the correct order.
            '''

        })
    '''
    The drawing order of this element. The higher the number, the later
    the element is drawn in sequence. This is used to ensure that elements
    that overlap are rendered in the correct order.
    '''

    isPolygon: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Defines whether or not the diagram objects points define the boundaries
            of a polygon or the routing of a polyline. If this value is true then a
            receiving application should consider the first and last points to be connected.
            '''

        })
    '''
    Defines whether or not the diagram objects points define the boundaries
    of a polygon or the routing of a polyline. If this value is true then
    a receiving application should consider the first and last points to
    be connected.
    '''

    offsetX: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The offset in the X direction. This is used for defining the offset from
            centre for rendering an icon (the default is that a single point specifies
            the centre of the icon).
            The offset is in per-unit with 0 indicating there is no offset from the
            horizontal centre of the icon. -0.5 indicates it is offset by 50% to the
            left and 0.5 indicates an offset of 50% to the right.
            '''

        })
    '''
    The offset in the X direction. This is used for defining the offset
    from centre for rendering an icon (the default is that a single point
    specifies the centre of the icon).
    The offset is in per-unit with 0 indicating there is no offset from
    the horizontal centre of the icon. -0.5 indicates it is offset by 50%
    to the left and 0.5 indicates an offset of 50% to the right.
    '''

    offsetY: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The offset in the Y direction. This is used for defining the offset from
            centre for rendering an icon (the default is that a single point specifies
            the centre of the icon).
            The offset is in per-unit with 0 indicating there is no offset from the
            vertical centre of the icon. The offset direction is dependent on the orientation
            of the diagram, with -0.5 and 0.5 indicating an offset of +/- 50% on the
            vertical axis.
            '''

        })
    '''
    The offset in the Y direction. This is used for defining the offset
    from centre for rendering an icon (the default is that a single point
    specifies the centre of the icon).
    The offset is in per-unit with 0 indicating there is no offset from
    the vertical centre of the icon. The offset direction is dependent
    on the orientation of the diagram, with -0.5 and 0.5 indicating an
    offset of +/- 50% on the vertical axis.
    '''

    rotation: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Sets the angle of rotation of the diagram object. Zero degrees is pointing
            to the top of the diagram. Rotation is clockwise. DiagramObject.rotation=0
            has the following meaning: The connection point of an element which has
            one terminal is pointing to the top side of the diagram. The connection
            point "From side" of an element which has more than one terminal is pointing
            to the top side of the diagram.
            DiagramObject.rotation=90 has the following meaning: The connection point
            of an element which has one terminal is pointing to the right hand side
            of the diagram. The connection point "From side" of an element which has
            more than one terminal is pointing to the right hand side of the diagram.
            '''

        })
    '''
    Sets the angle of rotation of the diagram object. Zero degrees is pointing
    to the top of the diagram. Rotation is clockwise. DiagramObject.rotation=0
    has the following meaning: The connection point of an element which
    has one terminal is pointing to the top side of the diagram. The connection
    point "From side" of an element which has more than one terminal is
    pointing to the top side of the diagram.
    DiagramObject.rotation=90 has the following meaning: The connection
    point of an element which has one terminal is pointing to the right
    hand side of the diagram. The connection point "From side" of an element
    which has more than one terminal is pointing to the right hand side
    of the diagram.
    '''

    Diagram: Optional[Diagram] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Diagram.DiagramElements',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A diagram object is part of a diagram.
            '''

        })
    '''
    A diagram object is part of a diagram.
    '''

    DiagramObjectStyle: Optional[DiagramObjectStyle] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiagramObjectStyle.StyledObjects',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A diagram object has a style associated that provides a reference for the
            style used in the originating system.
            '''

        })
    '''
    A diagram object has a style associated that provides a reference for
    the style used in the originating system.
    '''

    IdentifiedObject: Optional[IdentifiedObject] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IdentifiedObject.DiagramObjects',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The domain object to which this diagram object is associated.
            '''

        })
    '''
    The domain object to which this diagram object is associated.
    '''

@dataclass(repr=False)
class TextDiagramObject(DiagramObject):
    '''
    A diagram object for placing free-text or text derived from an associated
    domain object.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DiagramLayout'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    text: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The text that is displayed by this text diagram object.
            '''

        })
    '''
    The text that is displayed by this text diagram object.
    '''

@dataclass(repr=False)
class DiagramObjectStyle(IdentifiedObject):
    '''
    A reference to a style used by the originating system for a diagram object.
    A diagram object style describes information such as line thickness, shape
    such as circle or rectangle etc, and colour.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DiagramLayout'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    StyledObjects: list[DiagramObject] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiagramObject.DiagramObjectStyle',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A style can be assigned to multiple diagram objects.
            '''

        })
    '''
    A style can be assigned to multiple diagram objects.
    '''

@dataclass(repr=False)
class DiagramStyle(IdentifiedObject):
    '''
    The diagram style refers to a style used by the originating system for
    a diagram. A diagram style describes information such as schematic, geographic,
    etc.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DiagramLayout'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Diagram: list[Diagram] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Diagram.DiagramStyle',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A DiagramStyle can be used by many Diagrams.
            '''

        })
    '''
    A DiagramStyle can be used by many Diagrams.
    '''

@dataclass(repr=False)
class DimensionsInfo(IdentifiedObject):
    '''
    As applicable, the basic linear, area, or volume dimensions of an asset,
    asset type (AssetModel) or other type of object (such as land area). Units
    and multipliers are specified per dimension.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'InfAssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class Document(IdentifiedObject):
    '''
    Parent class for different groupings of information collected and managed
    as a part of a business process. It will frequently contain references
    to other objects, such as assets, people and power system resources.
    A Document will only have one valid version. A document gets updated by
    creating a new version that supersedes the old version.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConfigurationEvent.ChangedDocument',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All configuration events created for this document.
            '''

        })
    '''
    All configuration events created for this document.
    '''

    RelatedDocument: list[Document] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Document.Document',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    comment: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Free text comment.
            '''

        })
    '''
    Free text comment.
    '''

    createdDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Date and time that this document was created.
            '''

        })
    '''
    Date and time that this document was created.
    '''

    lastModifiedDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Date and time this document was last modified. Documents may potentially
            be modified many times during their lifetime.
            '''

        })
    '''
    Date and time this document was last modified. Documents may potentially
    be modified many times during their lifetime.
    '''

    revisionNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Revision number for this document.
            '''

        })
    '''
    Revision number for this document.
    '''

    subject: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Document subject.
            '''

        })
    '''
    Document subject.
    '''

    title: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Document title.
            '''

        })
    '''
    Document title.
    '''

    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Utility-specific classification of this document, according to its corporate
            standards, practices, and existing IT systems (e.g., for management of
            assets, maintenance, work, outage, customers, etc.).
            '''

        })
    '''
    Utility-specific classification of this document, according to its
    corporate standards, practices, and existing IT systems (e.g., for
    management of assets, maintenance, work, outage, customers, etc.).
    '''

    url: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Electronic address specifying where a document can be found.
            '''

        })
    '''
    Electronic address specifying where a document can be found.
    '''

    Approver: Optional[Approver] = field(
        default=None,
        metadata={
        'type': 'deprecated',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Approver.Documents',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Approver of this document.
            '''

        })
    '''
    Approver of this document.
    '''

    Author: Optional[Author] = field(
        default=None,
        metadata={
        'type': 'deprecated',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Author.Documents',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Author of this document.
            '''

        })
    '''
    Author of this document.
    '''

    docStatus: Optional[Status] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Status of this document. For status of subject matter this document represents
            (e.g., Agreement, Work), use 'status' attribute.
            Example values for 'docStatus.status' are draft, approved, cancelled, etc.
            '''

        })
    '''
    Status of this document. For status of subject matter this document
    represents (e.g., Agreement, Work), use 'status' attribute.
    Example values for 'docStatus.status' are draft, approved, cancelled,
    etc.
    '''

    Document: Optional[Document] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Document.RelatedDocument',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Editor: Optional[Editor] = field(
        default=None,
        metadata={
        'type': 'deprecated',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Editor.Documents',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Editor of this document.
            '''

        })
    '''
    Editor of this document.
    '''

    Issuer: Optional[Issuer] = field(
        default=None,
        metadata={
        'type': 'deprecated',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Issuer.Documents',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Issuer of this document.
            '''

        })
    '''
    Issuer of this document.
    '''

    status: Optional[Status] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Status of subject matter (e.g., Agreement, Work) this document represents.
            For status of the document itself, use 'docStatus' attribute.
            '''

        })
    '''
    Status of subject matter (e.g., Agreement, Work) this document represents.
    For status of the document itself, use 'docStatus' attribute.
    '''

@dataclass(repr=False)
class Agreement(Document):
    '''
    Formal agreement between two parties defining the terms and conditions
    for a set of services. The specifics of the services are, in turn, defined
    via one or more service agreements.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    pricingOther: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This attribute should be used to specify the kind of pricing when the value
            for the attribute Agreement.pricingKind is "other."
            '''

        })
    '''
    This attribute should be used to specify the kind of pricing when the
    value for the attribute Agreement.pricingKind is "other."
    '''

    signDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Date this agreement was consummated among associated persons and/or organisations.
            '''

        })
    '''
    Date this agreement was consummated among associated persons and/or
    organisations.
    '''

    pricingKind: Optional[AgreementPricingKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of pricing for a contractual agreement where goods and services
            are exchanged for money.
            '''

        })
    '''
    The type of pricing for a contractual agreement where goods and services
    are exchanged for money.
    '''

    validityInterval: Optional[DateTimeInterval] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Date and time interval this agreement is valid (from going into effect
            to termination).
            '''

        })
    '''
    Date and time interval this agreement is valid (from going into effect
    to termination).
    '''

@dataclass(repr=False)
class ChargeType(Document):
    '''
    Charge Type is the basic level configuration for settlement to process
    specific charges for invoicing purpose. Examples such as: Day Ahead Spinning
    Reserve Default Invoice Interest Charge, etc.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    chargeOrder: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Sequence of calculation.
            '''

        })
    '''
    Sequence of calculation.
    '''

    chargeVersion: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Charge version.
            '''

        })
    '''
    Charge version.
    '''

    effectiveDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Charge type effective date.
            '''

        })
    '''
    Charge type effective date.
    '''

    factor: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Adjustment factor.
            '''

        })
    '''
    Adjustment factor.
    '''

    frequencyType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Frequency of calculation.
            '''

        })
    '''
    Frequency of calculation.
    '''

    terminationDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Charge type termination date.
            '''

        })
    '''
    Charge type termination date.
    '''

    totalInterval: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Total number of intervals to indicate if charge is 5 minute (300), 10 minute
            (150) hourly (25) or daily or monthly (1).
            '''

        })
    '''
    Total number of intervals to indicate if charge is 5 minute (300),
    10 minute (150) hourly (25) or daily or monthly (1).
    '''

@dataclass(repr=False)
class DefaultBid(Document):
    '''
    DefaultBid is a generic class to hold Default Energy Bid, Default Startup
    Bid, and Default Minimum Load Bid:
    Default Energy Bid
    A Default Energy Bid is a monotonically increasing staircase function consisting
    at maximum 10 economic bid segments, or 10 ($/MW, MW) pairs. There are
    three methods for determining the Default Energy Bid:
    <ul>
    <li>Cost Based: derived from the Heat Rate or Average Cost multiplied by
    the Gas Price Index plus 10%.</li>
    <li>LMP Based: a weighted average of LMPs in the preceding 90 days.</li>
    <li>Negotiated: an amount negotiated with the designated Independent Entity.</li>
    </ul>
    Default Startup Bid
    A Default Startup Bid (DSUB) shall be calculated for each RMR unit based
    on the Startup Cost stored in the Master File and the applicable GPI and
    EPI.
    Default Minimum Load Bid
    A Default Minimum Load Bid (DMLB) shall be calculated for each RMR unit
    based on the Minimum Load Cost stored in the Master File and the applicable
    GPI.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ExternalInputs'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    RegisteredResource: Optional[RegisteredResource] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegisteredResource.DefaultBid',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class Incident(Document):
    '''
    Description of a problem in the field that may be reported in a trouble
    ticket or come from another source. It may have to do with an outage.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Operations'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.Incident',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Location of this incident.
            '''

        })
    '''
    Location of this incident.
    '''

@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class InspectionDataSet(Document):
    '''
    Documents the result of one inspection, for a given attribute of an asset.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Assets'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AccordingToSchedules: list[ScheduledEventData] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ScheduledEventData.InspectionDataSet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class Outage(Document):
    '''
    Document describing details of an active or planned outage in a part of
    the electrical network.
    A non-planned outage may be created upon:
    - a breaker trip,
    - a fault indicator status change,
    - a meter event indicating customer outage,
    - a reception of one or more customer trouble calls, or
    - an operator command, reflecting information obtained from the field crew.
    Outage restoration may be performed using a switching plan which complements
    the outage information with detailed switching activities, including the
    relationship to the crew and work.
    A planned outage may be created upon:
    - a request for service, maintenance or construction work in the field,
    or
    - an operator-defined outage for what-if/contingency network analysis.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Operations'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    OutageIsolationEquipment: list[ConductingEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConductingEquipment.Outage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class PlannedOutage(Outage):
    '''
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Operations'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    FieldDispatchHistory: Optional[FieldDispatchHistory] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FieldDispatchHistory.PlannedOutage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class UnplannedOutage(Outage):
    '''
    Document describing the consequence of an unplanned outage in a part of
    the electrical network. For the purposes of this model, an unplanned outage
    refers to a state where energy is not delivered; such as, customers out
    of service, a street light is not served, etc.
    A unplanned outage may be created upon:
    - impacts the SAIDI calculation
    - a breaker trip,
    - a fault indicator status change,
    - a meter event indicating customer outage,
    - a reception of one or more customer trouble calls, or
    - an operator command, reflecting information obtained from the field crew.
    Outage restoration may be performed using a switching plan which complements
    the outage information with detailed switching activities, including the
    relationship to the crew and work.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Operations'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    FieldDispatchHistory: Optional[FieldDispatchHistory] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FieldDispatchHistory.UnplannedOutage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class Skill(Document):
    '''
    Proficiency level of a craft, which is required to operate or maintain
    a particular type of asset and/or perform certain types of work.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    effectiveDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Date and time the skill became effective.
            '''

        })
    '''
    Date and time the skill became effective.
    '''

    level: Optional[SkillLevelKind] = field(
        default=None,
        metadata={
        'type': 'enumeration deprecated Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Level of skill for a Craft.
            '''

        })
    '''
    Level of skill for a Craft.
    '''

    certificationPeriod: Optional[DateTimeInterval] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Interval between the certification and its expiry.
            '''

        })
    '''
    Interval between the certification and its expiry.
    '''

    ErpPerson: Optional[OldPerson] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OldPerson.Skills',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class Specification(Document):
    '''
    Specification can be used for various purposes relative to an asset, a
    logical device (PowerSystemResource), location, etc. Examples include documents
    supplied by manufacturers such as asset installation instructions, asset
    maintenance instructions, etc.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'InfAssets'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    CoolingInfo: list[CoolingInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CoolingInfo.Specification',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    SoundInfo: list[SoundInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SoundInfo.Specification',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    SurfaceTreatmentInfo: list[SurfaceTreatmentInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SurfaceTreatmentInfo.Specification',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    AssetProperites: list[UserAttribute] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'UserAttribute.PropertySpecification',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            UserAttributes used to specify further properties of the asset covered
            with this specification. Use 'name' to specify what kind of property it
            is, and 'value.value' attribute for the actual value.
            '''

        })
    '''
    UserAttributes used to specify further properties of the asset covered
    with this specification. Use 'name' to specify what kind of property
    it is, and 'value.value' attribute for the actual value.
    '''

    Ratings: list[UserAttribute] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'UserAttribute.RatingSpecification',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            UserAttributes used to specify ratings of the asset covered by this specification.
            Ratings also can be used to set the initial value of operational measurement
            limits. Use 'name' to specify what kind of rating it is (e.g., voltage,
            current), and 'value' attribute for the actual value and unit information
            of the rating.
            '''

        })
    '''
    UserAttributes used to specify ratings of the asset covered by this
    specification. Ratings also can be used to set the initial value of
    operational measurement limits. Use 'name' to specify what kind of
    rating it is (e.g., voltage, current), and 'value' attribute for the
    actual value and unit information of the rating.
    '''

@dataclass(repr=False)
class SwitchingOrder(Document):
    '''
    Transmits a switching plan to a crew in order for the plan to be executed.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Operations'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Location: list[Location] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Location.SwitchingOrder',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class TimeSchedule(Document):
    '''
    Description of anything that changes through time. Time schedule is used
    to perform a single-valued function of time. Use inherited 'type' attribute
    to give additional information on this schedule, such as: periodic (hourly,
    daily, weekly, monthly, etc.), day of the month, by date, calendar (specific
    times and dates).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TimePoints: list[TimePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TimePoint.TimeSchedule',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Sequence of time points belonging to this time schedule.
            '''

        })
    '''
    Sequence of time points belonging to this time schedule.
    '''

    dayOfWeek: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The day of the week associated with a schedule.
            '''

        })
    '''
    The day of the week associated with a schedule.
    '''

    disabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if this schedule is deactivated (disabled).
            '''

        })
    '''
    True if this schedule is deactivated (disabled).
    '''

    recurrencePattern: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Interval at which the scheduled action repeats (e.g., first Monday of every
            month, last day of the month, etc.).
            '''

        })
    '''
    Interval at which the scheduled action repeats (e.g., first Monday
    of every month, last day of the month, etc.).
    '''

    scheduleDayOccurrence: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    scheduleFrequency: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The defined interval or regularity at which a task, event, or process is
            planned to occur within a schedule.
            '''

        })
    '''
    The defined interval or regularity at which a task, event, or process
    is planned to occur within a schedule.
    '''

    scheduleMonth: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The month in which a schedule occurs.
            '''

        })
    '''
    The month in which a schedule occurs.
    '''

    scheduleMonthDay: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The day of the month associated with a schedule.
            '''

        })
    '''
    The day of the month associated with a schedule.
    '''

    scheduleWeekNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The week number associated with a schedule.
            '''

        })
    '''
    The week number associated with a schedule.
    '''

    scheduleYear: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The year associated with a schedule.
            '''

        })
    '''
    The year associated with a schedule.
    '''

    scheduleYearDay: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The day of the year associated with a schedule.
            '''

        })
    '''
    The day of the year associated with a schedule.
    '''

    offset: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The offset from midnight (i.e., 0 h, 0 min, 0 s) for the periodic time
            points to begin. For example, for an interval meter that is set up for
            five minute intervals ('recurrencePeriod'=300=5 min), setting 'offset'=120=2
            min would result in scheduled events to read the meter executing at 2 min,
            7 min, 12 min, 17 min, 22 min, 27 min, 32 min, 37 min, 42 min, 47 min,
            52 min, and 57 min past each hour.
            '''

        })
    '''
    The offset from midnight (i.e., 0 h, 0 min, 0 s) for the periodic time
    points to begin. For example, for an interval meter that is set up
    for five minute intervals ('recurrencePeriod'=300=5 min), setting 'offset'=120=2
    min would result in scheduled events to read the meter executing at
    2 min, 7 min, 12 min, 17 min, 22 min, 27 min, 32 min, 37 min, 42 min,
    47 min, 52 min, and 57 min past each hour.
    '''

    recurrencePeriod: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Duration between time points, from the beginning of one period to the beginning
            of the next period. Note that a device like a meter may have multiple interval
            periods (e.g., 1 min, 5 min, 15 min, 30 min, or 60 min).
            '''

        })
    '''
    Duration between time points, from the beginning of one period to the
    beginning of the next period. Note that a device like a meter may have
    multiple interval periods (e.g., 1 min, 5 min, 15 min, 30 min, or 60
    min).
    '''

    scheduleHour: Optional[ float | Hours ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The hour of the day associated with a schedule.
            '''

        })
    '''
    The hour of the day associated with a schedule.
    '''

    scheduleMinute: Optional[ float | Minutes ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minute(s) after the hour associated with a schedule.
            '''

        })
    '''
    The minute(s) after the hour associated with a schedule.
    '''

    scheduleInterval: Optional[DateTimeInterval] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Schedule date and time interval.
            '''

        })
    '''
    Schedule date and time interval.
    '''

@dataclass(repr=False)
class TroubleOrder(Document):
    '''
    Trouble order sends an incident to a crew to initiate a response to an
    unplanned outage.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Operations'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.TroubleOrder',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class WorkRequest(Document):
    '''
    Document used to plan or initiate work
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Work'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ActivityRecord: list[ActivityRecord] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ActivityRecord.WorkRequest',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Record of activity on a work request.
            '''

        })
    '''
    Record of activity on a work request.
    '''

    WorkManager: list[WorkManager] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WorkManager.WorkRequest',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Work organization assigned to process the work request.
            '''

        })
    '''
    Work organization assigned to process the work request.
    '''

@stereotype(CIMStereotype.Attribute)
@dataclass(repr=False)
class ElectronicAddress(IdentifiedObject):
    '''
    Electronic address information.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    email: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Primary email address.
            '''

        })
    '''
    Primary email address.
    '''

    email1: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Primary email address.
            '''

        })
    '''
    Primary email address.
    '''

    email2: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Alternate email address.
            '''

        })
    '''
    Alternate email address.
    '''

    ipv4: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Internet address using internet protocol version 4 format.
            '''

        })
    '''
    Internet address using internet protocol version 4 format.
    '''

    ipv6: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Internet address using internet protocol version 6 format.
            '''

        })
    '''
    Internet address using internet protocol version 6 format.
    '''

    lan: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Address on local area network.
            '''

        })
    '''
    Address on local area network.
    '''

    mac: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            MAC (Media Access Control) address.
            '''

        })
    '''
    MAC (Media Access Control) address.
    '''

    password: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Password needed to log in.
            '''

        })
    '''
    Password needed to log in.
    '''

    radio: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unique identifier assigned to a wireless communication device. For
            example, Bluetooth Address, RFID Tag Address, Zigbee Network Address.
            '''

        })
    '''
    The unique identifier assigned to a wireless communication device.
    For example, Bluetooth Address, RFID Tag Address, Zigbee Network Address.
    '''

    text: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unique identifier assigned to a device capable of sending SMS messages.
            '''

        })
    '''
    The unique identifier assigned to a device capable of sending SMS messages.
    '''

    userID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            User ID needed to log in, which can be for an individual person, an organisation,
            a location, etc.
            '''

        })
    '''
    User ID needed to log in, which can be for an individual person, an
    organisation, a location, etc.
    '''

    web: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            World wide web address.
            '''

        })
    '''
    World wide web address.
    '''

@dataclass(repr=False)
class EnergyArea(IdentifiedObject):
    '''
    Describes an area having energy production or consumption. Specializations
    are intended to support the load allocation function as typically required
    in energy management systems or planning studies to allocate hypothesized
    load levels to individual load points for power flow analysis. Often the
    energy area can be linked to both measured and forecast load levels.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ControlArea: Optional[ControlArea] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlArea.EnergyArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The control area specification that is used for the load forecast.
            '''

        })
    '''
    The control area specification that is used for the load forecast.
    '''

    ControlArea: Optional[ControlArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlArea.EnergyArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The control area specification that is used for the load forecast.
            '''

        })
    '''
    The control area specification that is used for the load forecast.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class LoadArea(EnergyArea):
    '''
    The class is the root or first level in a hierarchical structure for grouping
    of loads for the purpose of load flow load scaling.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    SubLoadAreas: list[SubLoadArea] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SubLoadArea.LoadArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SubLoadAreas in the LoadArea.
            '''

        })
    '''
    The SubLoadAreas in the LoadArea.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class SubLoadArea(EnergyArea):
    '''
    The class is the second level in a hierarchical structure for grouping
    of loads for the purpose of load flow load scaling.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    LoadGroups: list[LoadGroup] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LoadGroup.SubLoadArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Loadgroups in the SubLoadArea.
            '''

        })
    '''
    The Loadgroups in the SubLoadArea.
    '''

    LoadArea: Optional[LoadArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LoadArea.SubLoadAreas',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The LoadArea where the SubLoadArea belongs.
            '''

        })
    '''
    The LoadArea where the SubLoadArea belongs.
    '''

@dataclass(repr=False)
class EnergySchedulingType(IdentifiedObject):
    '''
    Used to define the type of generation for scheduling purposes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    EnergySource: list[EnergySource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergySource.EnergySchedulingType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Energy Source of a particular Energy Scheduling Type.
            '''

        })
    '''
    Energy Source of a particular Energy Scheduling Type.
    '''

@dataclass(repr=False)
class EnvironmentalMonitoringStation(IdentifiedObject):
    '''
    An environmental monitoring station, examples of which could be a weather
    station or a seismic monitoring station.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    dstObserved: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Whether this station is currently reporting using daylight saving time.
            Intended to aid a utility Weather Service in interpreting information coming
            from a station and has no direct relationship to the manner in which time
            is expressed in EnvironmentalValueSet.
            '''

        })
    '''
    Whether this station is currently reporting using daylight saving time.
    Intended to aid a utility Weather Service in interpreting information
    coming from a station and has no direct relationship to the manner
    in which time is expressed in EnvironmentalValueSet.
    '''

    isNetworked: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indication that station is part of a network of stations used to monitor
            weather phenomena covering a large geographical area.
            '''

        })
    '''
    Indication that station is part of a network of stations used to monitor
    weather phenomena covering a large geographical area.
    '''

    timeZoneOffset: Optional[ float | Minutes ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The time offset from UTC (a.k.a. GMT) configured in the station "clock",
            not (necessarily) the time zone in which the station is physically located.
            This attribute exists to support management of utility monitoring stations
            and has no direct relationship to the manner in which time is expressed
            in EnvironmentalValueSet.
            '''

        })
    '''
    The time offset from UTC (a.k.a. GMT) configured in the station "clock",
    not (necessarily) the time zone in which the station is physically
    located.
    This attribute exists to support management of utility monitoring stations
    and has no direct relationship to the manner in which time is expressed
    in EnvironmentalValueSet.
    '''

    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.EnvironmentalMonitoringStation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Location of this monitoring station.
            '''

        })
    '''
    Location of this monitoring station.
    '''

@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class ErpCompetency(IdentifiedObject):
    '''
    Information that describes aptitudes of a utility employee. Unlike Skills
    that an ErpPerson must be certified to perform before undertaking certain
    type of assignments (to be able to perfrom a Craft), ErpCompetency has
    more to do with typical Human Resource (HR) matters such as schooling,
    training, etc.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'InfERPSupport'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ErpPersons: list[OldPerson] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OldPerson.ErpCompetency',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class ErpPersonnel(IdentifiedObject):
    '''
    Information that applies to the basic data about a utility person, used
    by ERP applications to transfer Personnel data for a worker.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'InfERPSupport'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ErpPersons: list[OldPerson] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OldPerson.ErpPersonnel',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.Part3Ext)
@dataclass(repr=False)
class FaultCauseType(IdentifiedObject):
    '''
    Type of cause of the fault.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Faults'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConfigurationEvent: list[ConfigurationEvent] = field(
        default_factory=list,
        metadata={
        'type': 'Part 3 Ext',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConfigurationEvent.FaultCauseType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class FieldDispatchHistory(IdentifiedObject):
    '''
    The history of field dispatch statuses for this work.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    FieldDispatchStep: list[FieldDispatchStep] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FieldDispatchStep.FieldDispatchHistory',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Crew: Optional[Crew] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Crew.FieldDispatchHistory',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PlannedOutage: Optional[PlannedOutage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PlannedOutage.FieldDispatchHistory',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    UnplannedOutage: Optional[UnplannedOutage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'UnplannedOutage.FieldDispatchHistory',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class FossilFuel(IdentifiedObject):
    '''
    The fossil fuel consumed by the non-nuclear thermal generating unit. For
    example, coal, oil, gas, etc. These are the specific fuels that the generating
    unit can consume.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    FuelAllocationSchedules: list[FuelAllocationSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FuelAllocationSchedule.FossilFuel',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A fuel allocation schedule shall have a fossil fuel.
            '''

        })
    '''
    A fuel allocation schedule shall have a fossil fuel.
    '''

    PowerElectronicsThermalUnit: list[PowerElectronicsThermalUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsThermalUnit.FossilFuels',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    fuelHeatContent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The amount of heat per weight (or volume) of the given type of fuel.
            '''

        })
    '''
    The amount of heat per weight (or volume) of the given type of fuel.
    '''

    fuelCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The cost in terms of heat value for the given type of fuel.
            '''

        })
    '''
    The cost in terms of heat value for the given type of fuel.
    '''

    fuelDispatchCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The cost of fuel used for economic dispatching which includes: fuel cost,
            transportation cost, and incremental maintenance cost.
            '''

        })
    '''
    The cost of fuel used for economic dispatching which includes: fuel
    cost, transportation cost, and incremental maintenance cost.
    '''

    fuelEffFactor: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The efficiency factor for the fuel (per unit) in terms of the effective
            energy absorbed.
            '''

        })
    '''
    The efficiency factor for the fuel (per unit) in terms of the effective
    energy absorbed.
    '''

    fuelHandlingCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Handling and processing cost associated with this fuel.
            '''

        })
    '''
    Handling and processing cost associated with this fuel.
    '''

    fuelMixture: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Relative amount of the given type of fuel, when multiple fuels are being
            consumed.
            '''

        })
    '''
    Relative amount of the given type of fuel, when multiple fuels are
    being consumed.
    '''

    fuelSulfur: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The fuel's fraction of pollution credit per unit of heat content.
            '''

        })
    '''
    The fuel's fraction of pollution credit per unit of heat content.
    '''

    highBreakpointP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The active power output level of the unit at which the given type of fuel
            is switched on. This fuel (e.g., oil) is sometimes used to supplement the
            base fuel (e.g., coal) at high active power output levels.
            '''

        })
    '''
    The active power output level of the unit at which the given type of
    fuel is switched on. This fuel (e.g., oil) is sometimes used to supplement
    the base fuel (e.g., coal) at high active power output levels.
    '''

    lowBreakpointP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The active power output level of the unit at which the given type of fuel
            is switched off. This fuel (e.g., oil) is sometimes used to stabilize the
            base fuel (e.g., coal) at low active power output levels.
            '''

        })
    '''
    The active power output level of the unit at which the given type of
    fuel is switched off. This fuel (e.g., oil) is sometimes used to stabilize
    the base fuel (e.g., coal) at low active power output levels.
    '''

    fossilFuelType: Optional[FuelType] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of fossil fuel, such as coal, oil, or gas.
            '''

        })
    '''
    The type of fossil fuel, such as coal, oil, or gas.
    '''

    FuelStorage: Optional[FuelStorage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FuelStorage.FossilFuel',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fuel storage that store fossil fuels.
            '''

        })
    '''
    Fuel storage that store fossil fuels.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.FossilFuels',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more fossil fuels.
            '''

        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class GeographicalRegion(IdentifiedObject):
    '''
    A geographical region of a power system network model.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Regions: list[SubGeographicalRegion] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SubGeographicalRegion.Region',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All sub-geographical regions within this geographical region.
            '''

        })
    '''
    All sub-geographical regions within this geographical region.
    '''

@dataclass(repr=False)
class Geometry(IdentifiedObject):
    '''
    Geo-spatial representation of a physical location. A location may be represented
    as a Point, Line, Polygon, or Circle.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    GeometricElement: list[GeometricElement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GeometricElement.Geometry',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    GeometricElement: list[GeometricElement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GeometricElement.Geometry',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    spatialFeatureType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A reference to the type of GIS spatial feature represented by this geometry.
            '''

        })
    '''
    A reference to the type of GIS spatial feature represented by this
    geometry.
    '''

    CoordinateSystem: Optional[CoordinateSystem] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CoordinateSystem.Geometry',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The coordinate system used for a given geometry.
            '''

        })
    '''
    The coordinate system used for a given geometry.
    '''

    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.Geometry',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The location for which a geometry is specified.
            '''

        })
    '''
    The location for which a geometry is specified.
    '''

@dataclass(repr=False)
class HVDCInterconnectionDynamics(IdentifiedObject):
    '''
    HVDC interconnection function block whose behaviour is described by reference
    to a standard model <font color="#0f0f0f">or by definition of a user-defined
    model.</font>
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'HVDCDynamics'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCEquipmentContainer: list[DCEquipmentContainer] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCEquipmentContainer.HVDCInterconnectionDynamics',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC equipment container to which HVDC interconnection dynamics model applies.
            '''

        })
    '''
    DC equipment container to which HVDC interconnection dynamics model
    applies.
    '''

@dataclass(repr=False)
class Hazard(IdentifiedObject):
    '''
    An object or a condition that is a danger for causing loss or perils to
    an asset and/or people.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of this hazard.
            '''

        })
    '''
    Type of this hazard.
    '''

    status: Optional[Status] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Status of this hazard.
            '''

        })
    '''
    Status of this hazard.
    '''

@dataclass(repr=False)
class IOPoint(IdentifiedObject):
    '''
    The class describe a measurement or control value. The purpose is to enable
    having attributes and associations common for measurement and control.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    IOPointSource: Optional[IOPointSource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IOPointSource.IOPoint',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Local merasurement value source for an ICCP point.
            '''

        })
    '''
    Local merasurement value source for an ICCP point.
    '''

@dataclass(repr=False)
class Control(IOPoint):
    '''
    Control is used for supervisory/device control. It represents control outputs
    that are used to change the state in a process, e.g. close or open breaker,
    a set point value or a raise lower command.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    controlType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the type of Control. For example, this specifies if the Control
            represents BreakerOpen, BreakerClose, GeneratorVoltageSetPoint, GeneratorRaise,
            GeneratorLower, etc.
            '''

        })
    '''
    Specifies the type of Control. For example, this specifies if the Control
    represents BreakerOpen, BreakerClose, GeneratorVoltageSetPoint, GeneratorRaise,
    GeneratorLower, etc.
    '''

    operationInProgress: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates that a client is currently sending control commands that has
            not completed.
            '''

        })
    '''
    Indicates that a client is currently sending control commands that
    has not completed.
    '''

    timeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The last time a control output was sent.
            '''

        })
    '''
    The last time a control output was sent.
    '''

    unitMultiplier: Optional[UnitMultiplier] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit multiplier of the controlled quantity.
            '''

        })
    '''
    The unit multiplier of the controlled quantity.
    '''

    unitSymbol: Optional[UnitSymbol] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit of measure of the controlled quantity.
            '''

        })
    '''
    The unit of measure of the controlled quantity.
    '''

    ControlAction: Optional[ControlAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlAction.Control',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.Controls',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Regulating device governed by this control output.
            '''

        })
    '''
    Regulating device governed by this control output.
    '''

    RemoteControl: Optional[RemoteControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RemoteControl.Control',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The remote point controlling the physical actuator.
            '''

        })
    '''
    The remote point controlling the physical actuator.
    '''

@dataclass(repr=False)
class AccumulatorReset(Control):
    '''
    This command resets the counter value to zero.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AccumulatorValue: Optional[AccumulatorValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorValue.AccumulatorReset',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The accumulator value that is reset by the command.
            '''

        })
    '''
    The accumulator value that is reset by the command.
    '''

    AccumulatorValue: Optional[AccumulatorValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorValue.AccumulatorReset',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The accumulator value that is reset by the command.
            '''

        })
    '''
    The accumulator value that is reset by the command.
    '''

@dataclass(repr=False)
class AnalogControl(Control):
    '''
    An analog control used for supervisory control.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AnalogValue: Optional[AnalogValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogValue.AnalogControl',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''

        })
    '''
    The MeasurementValue that is controlled.
    '''

    maxValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range maximum for any of the Control.value. Used for scaling,
            e.g. in bar graphs.
            '''

        })
    '''
    Normal value range maximum for any of the Control.value. Used for scaling,
    e.g. in bar graphs.
    '''

    minValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range minimum for any of the Control.value. Used for scaling,
            e.g. in bar graphs.
            '''

        })
    '''
    Normal value range minimum for any of the Control.value. Used for scaling,
    e.g. in bar graphs.
    '''

    AnalogValue: Optional[AnalogValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogValue.AnalogControl',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''

        })
    '''
    The MeasurementValue that is controlled.
    '''

@dataclass(repr=False)
class RaiseLowerCommand(AnalogControl):
    '''
    An analog control that increases or decreases a set point value with pulses.
    Unless otherwise specified, one pulse moves the set point by one.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.RaiseLowerCommands',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ValueAliasSet used for translation of a Control value to a name.
            '''

        })
    '''
    The ValueAliasSet used for translation of a Control value to a name.
    '''

@dataclass(repr=False)
class SetPoint(AnalogControl):
    '''
    An analog control that issues a set point value.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    normalValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value for Control.value e.g. used for percentage scaling.
            '''

        })
    '''
    Normal value for Control.value e.g. used for percentage scaling.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value representing the actuator output.
            '''

        })
    '''
    The value representing the actuator output.
    '''

@dataclass(repr=False)
class Command(Control):
    '''
    A Command is a discrete control used for supervisory control.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DiscreteValue: Optional[DiscreteValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiscreteValue.Command',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''

        })
    '''
    The MeasurementValue that is controlled.
    '''

    normalValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value for Control.value e.g. used for percentage scaling.
            '''

        })
    '''
    Normal value for Control.value e.g. used for percentage scaling.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value representing the actuator output.
            '''

        })
    '''
    The value representing the actuator output.
    '''

    DiscreteValue: Optional[DiscreteValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiscreteValue.Command',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''

        })
    '''
    The MeasurementValue that is controlled.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.Commands',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ValueAliasSet used for translation of a Control value to a name.
            '''

        })
    '''
    The ValueAliasSet used for translation of a Control value to a name.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class MeasurementValue(IOPoint):
    '''
    The current state for a measurement. A state value is an instance of a
    measurement from a specific source. Measurements can be associated with
    many state values, each representing a different source for the measurement.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    MeasurementValueQuality: Optional[MeasurementValueQuality] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueQuality.MeasurementValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''

        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''

    timeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The time when the value was last updated.
            '''

        })
    '''
    The time when the value was last updated.
    '''

    sensorAccuracy: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The limit, expressed as a percentage of the sensor maximum, that errors
            will not exceed when the sensor is used under reference conditions.
            '''

        })
    '''
    The limit, expressed as a percentage of the sensor maximum, that errors
    will not exceed when the sensor is used under reference conditions.
    '''

    CalculationMethodHierarchy: Optional[CalculationMethodHierarchy] = field(
        default=None,
        metadata={
        'type': 'harmonization',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CalculationMethodHierarchy.MeasurementValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ErpPerson: Optional[OldPerson] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OldPerson.MeasurementValues',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    MeasurementValueQuality: Optional[MeasurementValueQuality] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueQuality.MeasurementValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''

        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''

    MeasurementValueSource: Optional[MeasurementValueSource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueSource.MeasurementValues',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A reference to the type of source that updates the MeasurementValue, e.g.
            SCADA, CCLink, manual, etc. User conventions for the names of sources are
            contained in the introduction to IEC 61970-301.
            '''

        })
    '''
    A reference to the type of source that updates the MeasurementValue,
    e.g. SCADA, CCLink, manual, etc. User conventions for the names of
    sources are contained in the introduction to IEC 61970-301.
    '''

    RemoteSource: Optional[RemoteSource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RemoteSource.MeasurementValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Link to the physical telemetered point associated with this measurement.
            '''

        })
    '''
    Link to the physical telemetered point associated with this measurement.
    '''

@dataclass(repr=False)
class AccumulatorValue(MeasurementValue):
    '''
    AccumulatorValue represents an accumulated (counted) MeasurementValue.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AccumulatorReset: Optional[AccumulatorReset] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorReset.AccumulatorValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The command that resets the accumulator value.
            '''

        })
    '''
    The command that resets the accumulator value.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value to supervise. The value is positive.
            '''

        })
    '''
    The value to supervise. The value is positive.
    '''

    Accumulator: Optional[Accumulator] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Accumulator.AccumulatorValues',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement to which this value is connected.
            '''

        })
    '''
    Measurement to which this value is connected.
    '''

    AccumulatorReset: Optional[AccumulatorReset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorReset.AccumulatorValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The command that resets the accumulator value.
            '''

        })
    '''
    The command that resets the accumulator value.
    '''

@dataclass(repr=False)
class AnalogValue(MeasurementValue):
    '''
    AnalogValue represents an analog MeasurementValue.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AltGeneratingUnit: list[AltGeneratingUnitMeas] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AltGeneratingUnitMeas.AnalogValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The alternate generating unit for which this measurement value applies.
            '''

        })
    '''
    The alternate generating unit for which this measurement value applies.
    '''

    AltTieMeas: list[AltTieMeas] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AltTieMeas.AnalogValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The usage of the measurement within the control area specification.
            '''

        })
    '''
    The usage of the measurement within the control area specification.
    '''

    AnalogControl: Optional[AnalogControl] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogControl.AnalogValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''

        })
    '''
    The Control variable associated with the MeasurementValue.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value to supervise.
            '''

        })
    '''
    The value to supervise.
    '''

    Analog: Optional[Analog] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Analog.AnalogValues',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement to which this value is connected.
            '''

        })
    '''
    Measurement to which this value is connected.
    '''

    AnalogControl: Optional[AnalogControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogControl.AnalogValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''

        })
    '''
    The Control variable associated with the MeasurementValue.
    '''

@dataclass(repr=False)
class DiscreteValue(MeasurementValue):
    '''
    DiscreteValue represents a discrete MeasurementValue.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Command: Optional[Command] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Command.DiscreteValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''

        })
    '''
    The Control variable associated with the MeasurementValue.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value to supervise.
            '''

        })
    '''
    The value to supervise.
    '''

    Command: Optional[Command] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Command.DiscreteValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''

        })
    '''
    The Control variable associated with the MeasurementValue.
    '''

    Discrete: Optional[Discrete] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Discrete.DiscreteValues',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement to which this value is connected.
            '''

        })
    '''
    Measurement to which this value is connected.
    '''

@dataclass(repr=False)
class StringMeasurementValue(MeasurementValue):
    '''
    StringMeasurementValue represents a measurement value of type string.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    value: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value to supervise.
            '''

        })
    '''
    The value to supervise.
    '''

    StringMeasurement: Optional[StringMeasurement] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StringMeasurement.StringMeasurementValues',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Measurement to which this value is connected.
            '''

        })
    '''
    Measurement to which this value is connected.
    '''

@dataclass(repr=False)
class ImpedanceTapChangerTable(IdentifiedObject):
    '''
    Describes a curve for how the power transformer end impedance varies with
    the tap step.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ImpedanceTapChangerTablePoint: list[ImpedanceTapChangerTablePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ImpedanceTapChangerTablePoint.ImpedanceTapChangerTable',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The points of this table.
            '''

        })
    '''
    The points of this table.
    '''

    ImpedanceTapChangerTabular: list[ImpedanceTapChangerTabular] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ImpedanceTapChangerTabular.ImpedanceTapChangerTable',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The impedance tap changer to which this impedance tap table applies.
            '''

        })
    '''
    The impedance tap changer to which this impedance tap table applies.
    '''

@dataclass(repr=False)
class InternalLocation(IdentifiedObject):
    '''
    Description of location internal to a building.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    buildingName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Name of building where location is.
            '''

        })
    '''
    Name of building where location is.
    '''

    buildingNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of building where location is.
            '''

        })
    '''
    Number of building where location is.
    '''

    floor: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Floor of location.
            '''

        })
    '''
    Floor of location.
    '''

    roomNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Room number of location.
            '''

        })
    '''
    Room number of location.
    '''

    suiteNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.InternalLocation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class IntraphaseSpacing(IdentifiedObject):
    '''
    Wire spacing data that associates multiple wire positions with the line
    segment, and allows to calculate line segment impedances. Number of phases
    can be derived from the number of associated wire positions whose phase
    is not neutral.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AssetInfo'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ACLineSegmentPhase: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.IntraphaseSpacing',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    isCable: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, this spacing data describes a cable.
            '''

        })
    '''
    If true, this spacing data describes a cable.
    '''

    wireCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of wire sub-conductors in the symmetrical bundle (typically between
            1 and 4).
            '''

        })
    '''
    Number of wire sub-conductors in the symmetrical bundle (typically
    between 1 and 4).
    '''

    wireSpacing: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Distance between wire sub-conductors in a symmetrical bundle.
            '''

        })
    '''
    Distance between wire sub-conductors in a symmetrical bundle.
    '''

    usage: Optional[WireUsageKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Usage of the associated wires.
            '''

        })
    '''
    Usage of the associated wires.
    '''

    DuctBank: Optional[DuctBank] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DuctBank.WireSpacingInfos',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class Limit(IdentifiedObject):
    '''
    Specifies one limit value for a Measurement. A Measurement typically has
    several limits that are kept together by the LimitSet class. The actual
    meaning and use of a Limit instance (i.e., if it is an alarm or warning
    limit or if it is a high or low limit) is not captured in the Limit class.
    However the name of a Limit instance may indicate both meaning and use.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class AccumulatorLimit(Limit):
    '''
    Limit values for Accumulator measurements.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value to supervise against. The value is positive.
            '''

        })
    '''
    The value to supervise against. The value is positive.
    '''

    LimitSet: Optional[AccumulatorLimitSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorLimitSet.Limits',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The set of limits.
            '''

        })
    '''
    The set of limits.
    '''

@dataclass(repr=False)
class AnalogLimit(Limit):
    '''
    Limit values for Analog measurements.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The value to supervise against.
            '''

        })
    '''
    The value to supervise against.
    '''

    LimitSet: Optional[AnalogLimitSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogLimitSet.Limits',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The set of limits.
            '''

        })
    '''
    The set of limits.
    '''

@dataclass(repr=False)
class LimitSet(IdentifiedObject):
    '''
    Specifies a set of Limits that are associated with a Measurement. A Measurement
    may have several LimitSets corresponding to seasonal or other changing
    conditions. The condition is captured in the name and description attributes.
    The same LimitSet may be used for several Measurements. In particular percentage
    limits are used this way.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    isPercentageLimits: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Tells if the limit values are in percentage of normalValue or the specified
            Unit for Measurements and Controls.
            '''

        })
    '''
    Tells if the limit values are in percentage of normalValue or the specified
    Unit for Measurements and Controls.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class AccumulatorLimitSet(LimitSet):
    '''
    An AccumulatorLimitSet specifies a set of Limits that are associated with
    an Accumulator measurement.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Limits: list[AccumulatorLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AccumulatorLimit.LimitSet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The limit values used for supervision of Measurements.
            '''

        })
    '''
    The limit values used for supervision of Measurements.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class AnalogLimitSet(LimitSet):
    '''
    An AnalogLimitSet specifies a set of Limits that are associated with an
    Analog measurement.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Limits: list[AnalogLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AnalogLimit.LimitSet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The limit values used for supervision of Measurements.
            '''

        })
    '''
    The limit values used for supervision of Measurements.
    '''

@dataclass(repr=False)
class LineSegmentCoupling(IdentifiedObject):
    '''
    Describes the relationship of a line in a coupled group to the reference
    line in the group. (Reference line has a coupledLineNumber = 1.)
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.LineSegmentCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line whose relationship in a coupled group is described.
            '''

        })
    '''
    The line whose relationship in a coupled group is described.
    '''

    coupledLineNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Sequence number of coupled line. Value of 1 indicates that line is the
            reference line. Valid value range is from 1 to number of coupled lines
            in the group.
            '''

        })
    '''
    Sequence number of coupled line. Value of 1 indicates that line is
    the reference line. Valid value range is from 1 to number of coupled
    lines in the group.
    '''

    reverseFlow: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indication of whether the reference end of a line in a coupled group is
            the same as the reference end of the reference line.
            Set reverseFlow to True for any lines that do not have their Terminal with
            sequenceNumber = 1 at the same end as the reference line.
            Set reverseFlow to False for the reference line and for any lines that
            have their Terminal with sequenceNumber = 1 at the same end as the reference
            line.
            The sign of the coupled voltage drop of an ACLineSegment reverses when
            two coupled lines have their Terminals with sequenceNumber = 1 at opposite
            ends.
            '''

        })
    '''
    Indication of whether the reference end of a line in a coupled group
    is the same as the reference end of the reference line.
    Set reverseFlow to True for any lines that do not have their Terminal
    with sequenceNumber = 1 at the same end as the reference line.
    Set reverseFlow to False for the reference line and for any lines that
    have their Terminal with sequenceNumber = 1 at the same end as the
    reference line.
    The sign of the coupled voltage drop of an ACLineSegment reverses when
    two coupled lines have their Terminals with sequenceNumber = 1 at opposite
    ends.
    '''

    xOffset: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The horizontal offset between the horizontal reference point of a coupled
            line and the horizontal reference point of the reference line in the group.
            The horizontal reference point for a line is established by the line's
            WireAssembly. It is the zero x position on which the xCoord values of WirePositions
            in the WireAssembly are based.
            '''

        })
    '''
    The horizontal offset between the horizontal reference point of a coupled
    line and the horizontal reference point of the reference line in the
    group.
    The horizontal reference point for a line is established by the line's
    WireAssembly. It is the zero x position on which the xCoord values
    of WirePositions in the WireAssembly are based.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.LineSegmentCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line whose relationship in a coupled group is described.
            '''

        })
    '''
    The line whose relationship in a coupled group is described.
    '''

    CoupledLineSegmentGroup: Optional[CoupledLineSegmentGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CoupledLineSegmentGroup.LineSegmentCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The coupled group of lines with which this coupled line has relationships.
            '''

        })
    '''
    The coupled group of lines with which this coupled line has relationships.
    '''

@dataclass(repr=False)
class LoadDynamics(IdentifiedObject):
    '''
    Load whose behaviour is described by reference to a standard model <font
    color="#0f0f0f">or by definition of a user-defined model.</font>
    A standard feature of dynamic load behaviour modelling is the ability to
    associate the same behaviour to multiple energy consumers by means of a
    single load definition. The load model is always applied to individual
    bus loads (energy consumers).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadDynamics'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    EnergyConsumer: list[EnergyConsumer] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumer.LoadDynamics',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Energy consumer to which this dynamics load model applies.
            '''

        })
    '''
    Energy consumer to which this dynamics load model applies.
    '''

@dataclass(repr=False)
class LoadGroup(IdentifiedObject):
    '''
    The class is the third level in a hierarchical structure for grouping of
    loads for the purpose of load flow load scaling.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    SubLoadArea: Optional[SubLoadArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubLoadArea.LoadGroups',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SubLoadArea where the Loadgroup belongs.
            '''

        })
    '''
    The SubLoadArea where the Loadgroup belongs.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ConformLoadGroup(LoadGroup):
    '''
    A group of loads conforming to an allocation pattern.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    EnergyConsumers: list[ConformLoad] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConformLoad.LoadGroup',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conform loads assigned to this ConformLoadGroup.
            '''

        })
    '''
    Conform loads assigned to this ConformLoadGroup.
    '''

    ConformLoadSchedules: list[ConformLoadSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConformLoadSchedule.ConformLoadGroup',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ConformLoadSchedules in the ConformLoadGroup.
            '''

        })
    '''
    The ConformLoadSchedules in the ConformLoadGroup.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class NonConformLoadGroup(LoadGroup):
    '''
    Loads that do not follow a daily and seasonal load variation pattern.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    EnergyConsumers: list[NonConformLoad] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonConformLoad.LoadGroup',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conform loads assigned to this ConformLoadGroup.
            '''

        })
    '''
    Conform loads assigned to this ConformLoadGroup.
    '''

    NonConformLoadSchedules: list[NonConformLoadSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonConformLoadSchedule.NonConformLoadGroup',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The NonConformLoadSchedules in the NonConformLoadGroup.
            '''

        })
    '''
    The NonConformLoadSchedules in the NonConformLoadGroup.
    '''

@dataclass(repr=False)
class LoadResponseCharacteristic(IdentifiedObject):
    '''
    Models the characteristic response of the load demand due to changes in
    system conditions such as voltage and frequency. It is not related to demand
    response.
    If LoadResponseCharacteristic.exponentModel is True, the exponential voltage
    or frequency dependent models are specified and used as to calculate active
    and reactive power components of the load model.
    The equations to calculate active and reactive power components of the
    load model are internal to the power flow calculation, hence they use different
    quantities depending on the use case of the data exchange.
    The equations for exponential voltage dependent load model injected power
    are:
    pInjection= Pnominal* (Voltage/cim:BaseVoltage.nominalVoltage) ** cim:LoadResponseCharacteristic.pVoltageExponent
    qInjection= Qnominal* (Voltage/cim:BaseVoltage.nominalVoltage) ** cim:LoadResponseCharacteristic.qVoltageExponent
    pInjection = Pnominal* (Frequency/(Nominal frequency))**cim:LoadResponseCharacteristic.pFrequencyExponent
    qInjection = Qnominal* (Frequency/(Nominal frequency))**cim:LoadResponseCharacteristic.qFrequencyExponent
    Note that both voltage and frequency exponents could be used together so
    the full equation would be:
    pInjection = Pnominal* (Voltage/(cim:BaseVoltage.nominalVoltage))**cim:LoadResponseCharacteristic.pVoltageExponent
    * (Frequency/(base frequency))**cim:LoadResponseCharacteristic.pFrequencyExponent
    qInjection = Qnominal* (Voltage/(cim:BaseVoltage.nominalVoltage))**cim:LoadResponseCharacteristic.qVoltageExponent
    * (Frequency/(base frequency))**cim:LoadResponseCharacteristic.qFrequencyExponent
    The voltage and frequency expressed in the equation are values obtained
    from solved power flow. Base voltage and base frequency are those derived
    from the connectivity of the static network model.
    Where:
    1) * means "multiply" and ** is "raised to the power of";
    2) Pnominal and Qnominal represent the active power and reactive power
    at nominal voltage as any load described by the voltage exponential model
    shall be given at nominal voltage. This means that EnergyConsumer.p and
    EnergyConsumer.q are at nominal voltage.
    3) After power flow is solved:
    -pInjection and qInjection correspond to SvPowerflow.p and SvPowerflow.q
    respectively.
    - Voltage corresponds to SvVoltage.v at the TopologicalNode where the load
    is connected.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    EnergyConsumer: list[EnergyConsumer] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumer.LoadResponse',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The set of loads that have the response characteristics.
            '''

        })
    '''
    The set of loads that have the response characteristics.
    '''

    exponentModel: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates the exponential voltage dependency model is to be used. If false,
            the coefficient model is to be used.
            The exponential voltage dependency model consist of the attributes:
            - pVoltageExponent
            - qVoltageExponent
            - pFrequencyExponent
            - qFrequencyExponent.
            The coefficient model consist of the attributes:
            - pConstantImpedance
            - pConstantCurrent
            - pConstantPower
            - qConstantImpedance
            - qConstantCurrent
            - qConstantPower.
            The sum of pConstantImpedance, pConstantCurrent and pConstantPower shall
            equal 1.
            The sum of qConstantImpedance, qConstantCurrent and qConstantPower shall
            equal 1.
            '''

        })
    '''
    Indicates the exponential voltage dependency model is to be used. If
    false, the coefficient model is to be used.
    The exponential voltage dependency model consist of the attributes:
    - pVoltageExponent
    - qVoltageExponent
    - pFrequencyExponent
    - qFrequencyExponent.
    The coefficient model consist of the attributes:
    - pConstantImpedance
    - pConstantCurrent
    - pConstantPower
    - qConstantImpedance
    - qConstantCurrent
    - qConstantPower.
    The sum of pConstantImpedance, pConstantCurrent and pConstantPower
    shall equal 1.
    The sum of qConstantImpedance, qConstantCurrent and qConstantPower
    shall equal 1.
    '''

    pConstantCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of active power load modelled as constant current.
            '''

        })
    '''
    Portion of active power load modelled as constant current.
    '''

    pConstantImpedance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of active power load modelled as constant impedance.
            '''

        })
    '''
    Portion of active power load modelled as constant impedance.
    '''

    pConstantPower: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of active power load modelled as constant power.
            '''

        })
    '''
    Portion of active power load modelled as constant power.
    '''

    pFrequencyExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exponent of per unit frequency effecting active power.
            '''

        })
    '''
    Exponent of per unit frequency effecting active power.
    '''

    pVoltageExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exponent of per unit voltage effecting real power.
            '''

        })
    '''
    Exponent of per unit voltage effecting real power.
    '''

    qConstantCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of reactive power load modelled as constant current.
            '''

        })
    '''
    Portion of reactive power load modelled as constant current.
    '''

    qConstantImpedance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of reactive power load modelled as constant impedance.
            '''

        })
    '''
    Portion of reactive power load modelled as constant impedance.
    '''

    qConstantPower: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of reactive power load modelled as constant power.
            '''

        })
    '''
    Portion of reactive power load modelled as constant power.
    '''

    qFrequencyExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exponent of per unit frequency effecting reactive power.
            '''

        })
    '''
    Exponent of per unit frequency effecting reactive power.
    '''

    qVoltageExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exponent of per unit voltage effecting reactive power.
            '''

        })
    '''
    Exponent of per unit voltage effecting reactive power.
    '''

@dataclass(repr=False)
class Location(IdentifiedObject):
    '''
    The place, scene, or point of something where someone or something has
    been, is, and/or will be at a given moment in time. It can be defined with
    one or more position points (coordinates) in a given coordinate system.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Building: list[Building] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Building.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConfigurationEvent.ChangedLocation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All configuration events created for this location.
            '''

        })
    '''
    All configuration events created for this location.
    '''

    Crew: list[Crew] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Crew.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    EnvironmentalMonitoringStation: list[EnvironmentalMonitoringStation] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnvironmentalMonitoringStation.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Monitoring station located at this location.
            '''

        })
    '''
    Monitoring station located at this location.
    '''

    Geometry: list[Geometry] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Geometry.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The geometry for a given location.
            '''

        })
    '''
    The geometry for a given location.
    '''

    InternalLocation: list[InternalLocation] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'InternalLocation.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    SubLocation: list[Location] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Location.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    LocationAccess: Optional[LocationAccess] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LocationAccess.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PositionPoints: list[PositionPoint] = field(
        default_factory=list,
        metadata={
        'type': 'gmdm',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PositionPoint.Location',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All power system resources at this location.
            '''

        })
    '''
    All power system resources at this location.
    '''

    Site: Optional[Site] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Site.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    direction: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            (if applicable) Direction that allows field crews to quickly find a given
            asset. For a given location, such as a street address, this is the relative
            direction in which to find the asset. For example, a streetlight may be
            located at the 'NW' (northwest) corner of the customer's site, or a usage
            point may be located on the second floor of an apartment building.
            '''

        })
    '''
    (if applicable) Direction that allows field crews to quickly find a
    given asset. For a given location, such as a street address, this is
    the relative direction in which to find the asset. For example, a streetlight
    may be located at the 'NW' (northwest) corner of the customer's site,
    or a usage point may be located on the second floor of an apartment
    building.
    '''

    geoInfoReference: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            (if applicable) Reference to geographical information source, often external
            to the utility.
            '''

        })
    '''
    (if applicable) Reference to geographical information source, often
    external to the utility.
    '''

    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Classification by utility's corporate standards and practices, relative
            to the location itself (e.g., geographical, functional accounting, etc.,
            not a given property that happens to exist at that location).
            '''

        })
    '''
    Classification by utility's corporate standards and practices, relative
    to the location itself (e.g., geographical, functional accounting,
    etc., not a given property that happens to exist at that location).
    '''

    Cadastre: Optional[Cadastre] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Cadastre.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cadastre encompassing a location.
            '''

        })
    '''
    Cadastre encompassing a location.
    '''

    CoordinateSystem: Optional[CoordinateSystem] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CoordinateSystem.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Coordinate system used to describe position points of this location.
            '''

        })
    '''
    Coordinate system used to describe position points of this location.
    '''

    electronicAddress: Optional[ElectronicAddress] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            Electronic address.
            '''

        })
    '''
    Electronic address.
    '''

    Incident: Optional[Incident] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Incident.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Incident at this location.
            '''

        })
    '''
    Incident at this location.
    '''

    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.SubLocation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    LocationAccess: Optional[LocationAccess] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LocationAccess.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    mainAddress: Optional[StreetAddress] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            Main address of the location.
            '''

        })
    '''
    Main address of the location.
    '''

    phone1: Optional[TelephoneNumber] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            Phone number.
            '''

        })
    '''
    Phone number.
    '''

    phone2: Optional[TelephoneNumber] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            Additional phone number.
            '''

        })
    '''
    Additional phone number.
    '''

    secondaryAddress: Optional[StreetAddress] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            Secondary address of the location. For example, PO Box address may have
            different ZIP code than that in the 'mainAddress'.
            '''

        })
    '''
    Secondary address of the location. For example, PO Box address may
    have different ZIP code than that in the 'mainAddress'.
    '''

    Site: Optional[Site] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Site.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    status: Optional[Status] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            Status of this location.
            '''

        })
    '''
    Status of this location.
    '''

    SwitchingOrder: Optional[SwitchingOrder] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SwitchingOrder.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    TroubleOrder: Optional[TroubleOrder] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TroubleOrder.Location',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class MarketOccurrence(IdentifiedObject):
    '''
    Represents an occurrence of a market. For example a planned DA/HA/RT market
    with a defined market start and end time.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketPlan'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    MarketProducts: list[MarketProduct] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MarketProduct.Market',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class EnergyMarket(MarketOccurrence):
    '''
    Energy and Ancillary Market (e.g. Energy, Spinning Reserve, Non-Spinning
    Reserve) with a description of the Market operation control parameters.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    timeframe: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A specified period of time in which something occurs or is planned to take
            place.
            '''

        })
    '''
    A specified period of time in which something occurs or is planned
    to take place.
    '''

    MarketResults: Optional[MarketResults] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MarketResults.EnergyMarket',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    RTO: Optional[RTO] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RTO.EnergyMarkets',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class MarketProduct(IdentifiedObject):
    '''
    A product traded by an RTO (e.g. energy, 10 minute spinning reserve). Ancillary
    service product examples include: Regulation, Regulation Up, Regulation
    Down, Spinning Reserve, Non-Spinning Reserve, etc.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    rampInterval: Optional[ float | Minutes ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Ramping time interval for the specific market product type specified by
            marketProductType attribute. For example, if marketProductType = RU (from
            enumeration MarketProductType), then the rampInterval is the time in which
            the service must become available.
            The rampInterval is used for market products that have a minimum ramp requirement.
            For example, rampInterval = 10 (minutes) for a contingency reserve marketProductType
            vs a rampInterval = 30 (minutes) for a replacement reserve marketProductType.
            '''

        })
    '''
    Ramping time interval for the specific market product type specified
    by marketProductType attribute. For example, if marketProductType =
    RU (from enumeration MarketProductType), then the rampInterval is the
    time in which the service must become available.
    The rampInterval is used for market products that have a minimum ramp
    requirement. For example, rampInterval = 10 (minutes) for a contingency
    reserve marketProductType vs a rampInterval = 30 (minutes) for a replacement
    reserve marketProductType.
    '''

    marketProductType: Optional[MarketProductType] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Market product type examples:
            EN (Energy)
            RU (Regulation Up)
            RD (Regulation Dn)
            SR (Spinning Reserve)
            NR (Non-Spinning Reserve)
            RC (RUC)
            '''

        })
    '''
    Market product type examples:
    EN (Energy)
    RU (Regulation Up)
    RD (Regulation Dn)
    SR (Spinning Reserve)
    NR (Non-Spinning Reserve)
    RC (RUC)
    '''

    Market: Optional[MarketOccurrence] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MarketOccurrence.MarketProducts',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    MarketRegionResults: Optional[MarketRegionResults] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MarketRegionResults.MarketProduct',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class Measurement(IdentifiedObject):
    '''
    A Measurement represents any measured, calculated or non-measured non-calculated
    quantity. Any piece of equipment may contain Measurements, e.g. a substation
    may have temperature measurements and door open indications, a transformer
    may have oil temperature and tank pressure measurements, a bay may contain
    a number of power flow measurements and a Breaker may contain a switch
    status measurement.
    The PSR - Measurement association is intended to capture this use of Measurement
    and is included in the naming hierarchy based on EquipmentContainer. The
    naming hierarchy typically has Measurements as leaves, e.g. Substation-VoltageLevel-Bay-Switch-Measurement.
    Some Measurements represent quantities related to a particular sensor location
    in the network, e.g. a voltage transformer (VT) or potential transformer
    (PT) at a busbar or a current transformer (CT) at the bar between a breaker
    and an isolator. The sensing position is not captured in the PSR - Measurement
    association. Instead it is captured by the Measurement - Terminal association
    that is used to define the sensing location in the network topology. The
    location is defined by the connection of the Terminal to ConductingEquipment.
    If both a Terminal and PSR are associated, and the PSR is of type ConductingEquipment,
    the associated Terminal should belong to that ConductingEquipment instance.
    When the sensor location is needed both Measurement-PSR and Measurement-Terminal
    are used. The Measurement-Terminal association is never used alone.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    measurementType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the type of measurement. For example, this specifies if the measurement
            represents an indoor temperature, outdoor temperature, bus voltage, line
            flow, etc.
            When the measurementType is set to "Specialization", the type of Measurement
            is defined in more detail by the specialized class which inherits from
            Measurement.
            '''

        })
    '''
    Specifies the type of measurement. For example, this specifies if the
    measurement represents an indoor temperature, outdoor temperature,
    bus voltage, line flow, etc.
    When the measurementType is set to "Specialization", the type of Measurement
    is defined in more detail by the specialized class which inherits from
    Measurement.
    '''

    phases: Optional[PhaseCode] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates to which phases the measurement applies and avoids the need to
            use 'measurementType' to also encode phase information (which would explode
            the types). The phase information in Measurement, along with 'measurementType'
            and 'phases' uniquely defines a Measurement for a device, based on normal
            network phase. Their meaning will not change when the computed energizing
            phasing is changed due to jumpers or other reasons.
            If the attribute is missing three phases (ABC) shall be assumed.
            '''

        })
    '''
    Indicates to which phases the measurement applies and avoids the need
    to use 'measurementType' to also encode phase information (which would
    explode the types). The phase information in Measurement, along with
    'measurementType' and 'phases' uniquely defines a Measurement for a
    device, based on normal network phase. Their meaning will not change
    when the computed energizing phasing is changed due to jumpers or other
    reasons.
    If the attribute is missing three phases (ABC) shall be assumed.
    '''

    unitMultiplier: Optional[UnitMultiplier] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit multiplier of the measured quantity.
            '''

        })
    '''
    The unit multiplier of the measured quantity.
    '''

    unitSymbol: Optional[UnitSymbol] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit of measure of the measured quantity.
            '''

        })
    '''
    The unit of measure of the measured quantity.
    '''

    Asset: Optional[Asset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Asset.Measurements',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    CalculationMethodHierarchy: Optional[CalculationMethodHierarchy] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CalculationMethodHierarchy.Measurement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Calculation method hierarchy which applies to this analog.
            '''

        })
    '''
    Calculation method hierarchy which applies to this analog.
    '''

    MeasurementAction: Optional[MeasurementAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementAction.Measurement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.Measurements',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The power system resource that contains the measurement.
            '''

        })
    '''
    The power system resource that contains the measurement.
    '''

    Terminal: Optional[ACDCTerminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCTerminal.Measurements',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            One or more measurements may be associated with a terminal in the network.
            '''

        })
    '''
    One or more measurements may be associated with a terminal in the network.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Accumulator(Measurement):
    '''
    Accumulator represents an accumulated (counted) Measurement, e.g. an energy
    value.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AccumulatorValues: list[AccumulatorValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AccumulatorValue.Accumulator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The values connected to this measurement.
            '''

        })
    '''
    The values connected to this measurement.
    '''

    maxValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''

        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Analog(Measurement):
    '''
    Analog represents an analog Measurement.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AnalogValues: list[AnalogValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AnalogValue.Analog',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The values connected to this measurement.
            '''

        })
    '''
    The values connected to this measurement.
    '''

    maxValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''

        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    minValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range minimum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''

        })
    '''
    Normal value range minimum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    normalValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal measurement value, e.g., used for percentage calculations.
            '''

        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''

    positiveFlowIn: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates the direction of positive flow relative to the primary equipment
            connectivity.
            The attribute is applicable for measurements of flow such as active power,
            reactive power or current.
            TRUE means a positive measurement value at the terminal, where the measurement
            is located, indicates power is flowing into the related PowerSystemResource.
            FALSE means a positive measurement value at the terminal, where the measurement
            is located, indicates power is flowing out of the related PowerSystemResource.
            '''

        })
    '''
    Indicates the direction of positive flow relative to the primary equipment
    connectivity.
    The attribute is applicable for measurements of flow such as active
    power, reactive power or current.
    TRUE means a positive measurement value at the terminal, where the
    measurement is located, indicates power is flowing into the related
    PowerSystemResource.
    FALSE means a positive measurement value at the terminal, where the
    measurement is located, indicates power is flowing out of the related
    PowerSystemResource.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Discrete(Measurement):
    '''
    Discrete represents a discrete Measurement, i.e. a Measurement representing
    discrete values, e.g. a Breaker position.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DiscreteValues: list[DiscreteValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiscreteValue.Discrete',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The values connected to this measurement.
            '''

        })
    '''
    The values connected to this measurement.
    '''

    maxValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''

        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    minValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal value range minimum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''

        })
    '''
    Normal value range minimum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    normalValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal measurement value, e.g., used for percentage calculations.
            '''

        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.Discretes',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ValueAliasSet used for translation of a MeasurementValue.value to a
            name.
            '''

        })
    '''
    The ValueAliasSet used for translation of a MeasurementValue.value
    to a name.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class MktMeasurement(Measurement):
    '''
    Subclass of IEC61970:Meas:Measurement.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketOpCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ByTiePoint: Optional[TiePoint] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TiePoint.ByMktMeasurement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A measurement is made on the B side of a tie point
            '''

        })
    '''
    A measurement is made on the B side of a tie point
    '''

    ForTiePoint: Optional[TiePoint] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TiePoint.ForMktMeasurement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A measurement is made on the A side of a tie point
            '''

        })
    '''
    A measurement is made on the A side of a tie point
    '''

    Pnode: Optional[Pnode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Pnode.MktMeasurement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Allows Pnode an association to aggregated resources external DC ties or
            psuedo tie measurements.
            '''

        })
    '''
    Allows Pnode an association to aggregated resources external DC ties
    or psuedo tie measurements.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class StringMeasurement(Measurement):
    '''
    StringMeasurement represents a measurement with values of type string.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    StringMeasurementValues: list[StringMeasurementValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'StringMeasurementValue.StringMeasurement',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The values connected to this measurement.
            '''

        })
    '''
    The values connected to this measurement.
    '''

@dataclass(repr=False)
class MeasurementValueSource(IdentifiedObject):
    '''
    MeasurementValueSource describes the alternative sources updating a MeasurementValue.
    User conventions for how to use the MeasurementValueSource attributes are
    defined in IEC 61970-301.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Meas'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    MeasurementValues: list[MeasurementValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeasurementValue.MeasurementValueSource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The MeasurementValues updated by the source.
            '''

        })
    '''
    The MeasurementValues updated by the source.
    '''

@dataclass(repr=False)
class IOPointSource(MeasurementValueSource):
    '''
    Indicates the point source for an IO Point.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ICCPConfiguration'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    IOPoint: list[IOPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'IOPoint.IOPointSource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            ICCP point for a local measurement value source.
            '''

        })
    '''
    ICCP point for a local measurement value source.
    '''

@dataclass(repr=False)
class MutualCoupling(IdentifiedObject):
    '''
    This class represents the zero sequence line mutual coupling.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    b0ch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence mutual coupling shunt (charging) susceptance, uniformly distributed,
            of the entire line section.
            '''

        })
    '''
    Zero sequence mutual coupling shunt (charging) susceptance, uniformly
    distributed, of the entire line section.
    '''

    distance11: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Distance to the start of the coupled region from the first line's terminal
            having sequence number equal to 1.
            '''

        })
    '''
    Distance to the start of the coupled region from the first line's terminal
    having sequence number equal to 1.
    '''

    distance12: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Distance to the end of the coupled region from the first line's terminal
            with sequence number equal to 1.
            '''

        })
    '''
    Distance to the end of the coupled region from the first line's terminal
    with sequence number equal to 1.
    '''

    distance21: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Distance to the start of coupled region from the second line's terminal
            with sequence number equal to 1.
            '''

        })
    '''
    Distance to the start of coupled region from the second line's terminal
    with sequence number equal to 1.
    '''

    distance22: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Distance to the end of coupled region from the second line's terminal with
            sequence number equal to 1.
            '''

        })
    '''
    Distance to the end of coupled region from the second line's terminal
    with sequence number equal to 1.
    '''

    g0ch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence mutual coupling shunt (charging) conductance, uniformly distributed,
            of the entire line section.
            '''

        })
    '''
    Zero sequence mutual coupling shunt (charging) conductance, uniformly
    distributed, of the entire line section.
    '''

    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence branch-to-branch mutual impedance coupling, resistance.
            '''

        })
    '''
    Zero sequence branch-to-branch mutual impedance coupling, resistance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence branch-to-branch mutual impedance coupling, reactance.
            '''

        })
    '''
    Zero sequence branch-to-branch mutual impedance coupling, reactance.
    '''

    First_Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.HasFirstMutualCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The starting terminal for the calculation of distances along the first
            branch of the mutual coupling. Normally MutualCoupling would only be used
            for terminals of AC line segments. The first and second terminals of a
            mutual coupling should point to different AC line segments.
            '''

        })
    '''
    The starting terminal for the calculation of distances along the first
    branch of the mutual coupling. Normally MutualCoupling would only be
    used for terminals of AC line segments. The first and second terminals
    of a mutual coupling should point to different AC line segments.
    '''

    Second_Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.HasSecondMutualCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The starting terminal for the calculation of distances along the second
            branch of the mutual coupling.
            '''

        })
    '''
    The starting terminal for the calculation of distances along the second
    branch of the mutual coupling.
    '''

@dataclass(repr=False)
class OperatingParticipant(IdentifiedObject):
    '''
    An operator of multiple power system resource objects. Note multiple operating
    participants may operate the same power system resource object. This can
    be used for modeling jointly owned units where each owner operates as a
    contractual share.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    OperatingShare: list[OperatingShare] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperatingShare.OperatingParticipant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operating shares of this operating participant. An operating participant
            can be resused for any number of power system resources.
            '''

        })
    '''
    The operating shares of this operating participant. An operating participant
    can be resused for any number of power system resources.
    '''

@dataclass(repr=False)
class OperationalLimit(IdentifiedObject):
    '''
    A value and normal value associated with a specific kind of limit.
    The sub class value and normalValue attributes vary inversely to the associated
    OperationalLimitType.acceptableDuration (acceptableDuration for short).
    If a particular piece of equipment has multiple operational limits of the
    same kind (apparent power, current, etc.), the limit with the greatest
    acceptableDuration shall have the smallest limit value and the limit with
    the smallest acceptableDuration shall have the largest limit value. Note:
    A large current can only be allowed to flow through a piece of equipment
    for a short duration without causing damage, but a lesser current can be
    allowed to flow for a longer duration.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'OperationalLimits'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    OperationalLimitSet: Optional[OperationalLimitSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OperationalLimitSet.OperationalLimitValue',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The limit set to which the limit values belong.
            '''

        })
    '''
    The limit set to which the limit values belong.
    '''

    OperationalLimitType: Optional[OperationalLimitType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OperationalLimitType.OperationalLimit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The limit type associated with this limit.
            '''

        })
    '''
    The limit type associated with this limit.
    '''

    StepOperationalLimitTable: Optional[StepOperationalLimitTable] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StepOperationalLimitTable.OperationalLimit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The step operational limit table for this operational limit.
            '''

        })
    '''
    The step operational limit table for this operational limit.
    '''

@dataclass(repr=False)
class ActivePowerLimit(OperationalLimit):
    '''
    Limit on active power flow.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'OperationalLimits'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    normalValue: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal value of active power limit. The attribute shall be a positive
            value or zero.
            '''

        })
    '''
    The normal value of active power limit. The attribute shall be a positive
    value or zero.
    '''

    value: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Value of active power limit. The attribute shall be a positive value or
            zero.
            '''

        })
    '''
    Value of active power limit. The attribute shall be a positive value
    or zero.
    '''

@dataclass(repr=False)
class ApparentPowerLimit(OperationalLimit):
    '''
    Apparent power limit.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'OperationalLimits'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    normalValue: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal apparent power limit. The attribute shall be a positive value
            or zero.
            '''

        })
    '''
    The normal apparent power limit. The attribute shall be a positive
    value or zero.
    '''

    value: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The apparent power limit. The attribute shall be a positive value or zero.
            '''

        })
    '''
    The apparent power limit. The attribute shall be a positive value or
    zero.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class CurrentLimit(OperationalLimit):
    '''
    Operational limit on current.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'OperationalLimits'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    normalValue: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal value for limit on current flow. The attribute shall be a positive
            value or zero.
            '''

        })
    '''
    The normal value for limit on current flow. The attribute shall be
    a positive value or zero.
    '''

    value: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Limit on current flow. The attribute shall be a positive value or zero.
            '''

        })
    '''
    Limit on current flow. The attribute shall be a positive value or zero.
    '''

@dataclass(repr=False)
class VoltageAngleLimit(OperationalLimit):
    '''
    Voltage angle limit between two terminals. The association end OperationalLimitSet.Terminal
    defines one end and the host of the limit. The association end VoltageAngleLimit.AngleReferenceTerminal
    defines the reference terminal.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'OperationalLimits'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    isFlowToRefTerminal: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if the flow is from the operating limit terminal to the angle reference
            terminal. False means that the flow is the other direction. When it is
            not given, the limit is the same for both directions.
            '''

        })
    '''
    True if the flow is from the operating limit terminal to the angle
    reference terminal. False means that the flow is the other direction.
    When it is not given, the limit is the same for both directions.
    '''

    normalValue: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The difference in angle degrees between referenced by the association end
            OperationalLimitSet.Terminal and the Terminal referenced by the association
            end VoltageAngleLimit.AngleReferenceTerminal. The value shall be positive
            (greater than zero).
            '''

        })
    '''
    The difference in angle degrees between referenced by the association
    end OperationalLimitSet.Terminal and the Terminal referenced by the
    association end VoltageAngleLimit.AngleReferenceTerminal. The value
    shall be positive (greater than zero).
    '''

    value: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The difference in angle degrees between referenced by the association end
            OperationalLimitSet.Terminal and the Terminal referenced by the association
            end VoltageAngleLimit.AngleReferenceTerminal. The value shall be positive
            (greater than zero).
            '''

        })
    '''
    The difference in angle degrees between referenced by the association
    end OperationalLimitSet.Terminal and the Terminal referenced by the
    association end VoltageAngleLimit.AngleReferenceTerminal. The value
    shall be positive (greater than zero).
    '''

    AngleReferenceTerminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.VoltageAngleLimit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The angle reference terminal for the voltage angle limit.
            '''

        })
    '''
    The angle reference terminal for the voltage angle limit.
    '''

@dataclass(repr=False)
class VoltageLimit(OperationalLimit):
    '''
    Operational limit applied to voltage.
    The use of operational VoltageLimit is preferred instead of limits defined
    at VoltageLevel. The operational VoltageLimits are used, if present.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'OperationalLimits'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    normalValue: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal limit on voltage. High or low limit nature of the limit depends
            upon the properties of the operational limit type. The attribute shall
            be a positive value or zero.
            '''

        })
    '''
    The normal limit on voltage. High or low limit nature of the limit
    depends upon the properties of the operational limit type. The attribute
    shall be a positive value or zero.
    '''

    value: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Limit on voltage. High or low limit nature of the limit depends upon the
            properties of the operational limit type. The attribute shall be a positive
            value or zero.
            '''

        })
    '''
    Limit on voltage. High or low limit nature of the limit depends upon
    the properties of the operational limit type. The attribute shall be
    a positive value or zero.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class OperationalLimitSet(IdentifiedObject):
    '''
    A set of limits associated with equipment. Sets of limits might apply to
    a specific temperature, or season for example. A set of limits may contain
    different severities of limit levels that would apply to the same equipment.
    The set may contain limits of different types such as apparent power and
    current limits or high and low voltage limits that are logically applied
    together as a set.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'OperationalLimits'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    OperationalLimitValue: list[OperationalLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimit.OperationalLimitSet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Values of equipment limits.
            '''

        })
    '''
    Values of equipment limits.
    '''

    Equipment: Optional[Equipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Equipment.OperationalLimitSet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The equipment to which the limit set applies.
            '''

        })
    '''
    The equipment to which the limit set applies.
    '''

    Terminal: Optional[ACDCTerminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCTerminal.OperationalLimitSet',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The terminal where the operational limit set apply.
            '''

        })
    '''
    The terminal where the operational limit set apply.
    '''

@dataclass(repr=False)
class OperationalLimitType(IdentifiedObject):
    '''
    The operational meaning of a category of limits.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'OperationalLimits'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    OperationalLimit: list[OperationalLimit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimit.OperationalLimitType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limits associated with this type of limit.
            '''

        })
    '''
    The operational limits associated with this type of limit.
    '''

    isInfiniteDuration: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Defines if the operational limit type has infinite duration. If true, the
            limit has infinite duration. If false, the limit has definite duration
            which is defined by the attribute acceptableDuration.
            '''

        })
    '''
    Defines if the operational limit type has infinite duration. If true,
    the limit has infinite duration. If false, the limit has definite duration
    which is defined by the attribute acceptableDuration.
    '''

    isMinimum: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'NC Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://entsoe.eu/ns/nc#',
        'docstring':
            '''
            Defines if the operational limit type is minimum. If true, the value is
            a minimum value of the same kind. This applies to stability and PATL. If
            false, the limit has the normal behaviour. OperationalLimitType.direction
            attribute shall be absoluteValue.
            '''

        })
    '''
    Defines if the operational limit type is minimum. If true, the value
    is a minimum value of the same kind. This applies to stability and
    PATL. If false, the limit has the normal behaviour. OperationalLimitType.direction
    attribute shall be absoluteValue.
    '''

    acceptableDuration: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The nominal acceptable duration of the limit. Limits are commonly expressed
            in terms of the time limit for which the limit is normally acceptable.
            The actual acceptable duration of a specific limit may depend on other
            local factors such as temperature or wind speed. The attribute has meaning
            only if the flag isInfiniteDuration is set to false, hence it shall not
            be exchanged when isInfiniteDuration is set to true.
            '''

        })
    '''
    The nominal acceptable duration of the limit. Limits are commonly expressed
    in terms of the time limit for which the limit is normally acceptable.
    The actual acceptable duration of a specific limit may depend on other
    local factors such as temperature or wind speed. The attribute has
    meaning only if the flag isInfiniteDuration is set to false, hence
    it shall not be exchanged when isInfiniteDuration is set to true.
    '''

    direction: Optional[OperationalLimitDirectionKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The direction of the limit.
            '''

        })
    '''
    The direction of the limit.
    '''

    kind: Optional[LimitKind] = field(
        default=None,
        metadata={
        'type': 'European enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            Types of limits defined in the ENTSO-E Operational Handbook Policy 3.
            '''

        })
    '''
    Types of limits defined in the ENTSO-E Operational Handbook Policy
    3.
    '''

    PermanentAmbientTemperatureDependencyCurve: Optional[AmbientTemperatureDependencyCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AmbientTemperatureDependencyCurve.OperationalLimitType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The permanent ambient temperature dependency curve for this operational
            limit type.
            '''

        })
    '''
    The permanent ambient temperature dependency curve for this operational
    limit type.
    '''

    PermanentSolarRadiationCurve: Optional[SolarRadiationDependencyCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SolarRadiationDependencyCurve.OperationalLimitType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The permanent solar radiation curve for this operational limit type.
            '''

        })
    '''
    The permanent solar radiation curve for this operational limit type.
    '''

    RecoveryOverloadLimitCurve: Optional[RecoveryOverloadLimitCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RecoveryOverloadLimitCurve.OperationalLimitType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This is the curve which provides the recovery time information for this
            limit type.
            '''

        })
    '''
    This is the curve which provides the recovery time information for
    this limit type.
    '''

    TemporaryBaseOverloadLimitCurve: Optional[BaseOverloadLimitCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseOverloadLimitCurve.OperationalLimitType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The temporary base overload limit curve for this operational limit type.
            '''

        })
    '''
    The temporary base overload limit curve for this operational limit
    type.
    '''

    TemporaryDurationOverloadLimitCurve: Optional[DurationOverloadLimitCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DurationOverloadLimitCurve.OperationalLimitType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The temporary duration overload limit curve for this operational limit
            type.
            '''

        })
    '''
    The temporary duration overload limit curve for this operational limit
    type.
    '''

@dataclass(repr=False)
class Ownership(IdentifiedObject):
    '''
    Ownership of e.g. asset.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Common'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    share: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Share of this ownership.
            '''

        })
    '''
    Share of this ownership.
    '''

    Asset: Optional[Asset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Asset.Ownerships',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asset that is object of this ownership.
            '''

        })
    '''
    Asset that is object of this ownership.
    '''

    AssetOwner: Optional[AssetOwner] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetOwner.Ownerships',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asset owner that is subject in this ownership.
            '''

        })
    '''
    Asset owner that is subject in this ownership.
    '''

@dataclass(repr=False)
class PSRType(IdentifiedObject):
    '''
    Classifying instances of the same class, e.g. overhead and underground
    ACLineSegments. This classification mechanism is intended to provide flexibility
    outside the scope of this document, i.e. provide customisation that is
    non standard.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.PSRType',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power system resources classified with this power system resource type.
            '''

        })
    '''
    Power system resources classified with this power system resource type.
    '''

@dataclass(repr=False)
class PerLengthLineParameter(IdentifiedObject):
    '''
    Common type for per-length electrical line parameters.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.PerLengthLineParameter',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class PerLengthDCLineParameter(PerLengthLineParameter):
    '''
    Common type for per-length electrical catalogues describing DC line parameters.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCLineSegments: list[DCLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCLineSegment.PerLengthParameter',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All line segments described by this set of per-length parameters.
            '''

        })
    '''
    All line segments described by this set of per-length parameters.
    '''

    capacitance: Optional[ float | CapacitancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Capacitance per unit of length of the DC line segment; significant for
            cables only.
            '''

        })
    '''
    Capacitance per unit of length of the DC line segment; significant
    for cables only.
    '''

    inductance: Optional[ float | InductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Inductance per unit of length of the DC line segment.
            '''

        })
    '''
    Inductance per unit of length of the DC line segment.
    '''

    resistance: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Resistance per length of the DC line segment.
            '''

        })
    '''
    Resistance per length of the DC line segment.
    '''

@dataclass(repr=False)
class PerLengthImpedance(PerLengthLineParameter):
    '''
    Common type for per-length electrical impedances.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ACLineSegments: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.PerLengthImpedance',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All line segments described by this per-length impedance.
            '''

        })
    '''
    All line segments described by this per-length impedance.
    '''

@dataclass(repr=False)
class PerLengthPhaseImpedance(PerLengthImpedance):
    '''
    The per length phase impedance matrix expresses impedance and admittance
    parameters per unit length for n-conductor unbalanced line segments. A
    phase impedance matrix contains both self impedances for each phase and
    mutual impedances between pairs of phases. The matrix is stored in symmetric
    lower triangular format where the diagonal entries represent self-impedances
    (and have the same value in row and column) and the off diagonal entries
    represent phase-to-phase impedances (and have different row and column
    values).
    The matrix can be use to express impedances for both non-coupled and coupled
    line segments. Coupled line segments share a single per length phase impedance
    matrix whose entries reflect the self and mutual impedances of all the
    phases of all the wires.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PhaseImpedanceData: list[PhaseImpedanceData] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseImpedanceData.PhaseImpedance',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All data that belong to this conductor phase impedance.
            '''

        })
    '''
    All data that belong to this conductor phase impedance.
    '''

    PhaseImpedanceData: list[PhaseImpedanceData] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseImpedanceData.PhaseImpedance',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All data that belong to this conductor phase impedance.
            '''

        })
    '''
    All data that belong to this conductor phase impedance.
    '''

    conductorCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conductor count identifies the number of phase, neutral, and other wires
            represented in the phase impedance matrix and constrains the number of
            elements in the matrix. Typically, Kron reduction is used for incorporating
            effects of neutral impedance in the phase conductor values (so conductor
            count only considers phase wires), but neutrals can be included in the
            matrix (in which case conductor count would include the neutral wire(s)).
            For a phase impedance matrix associated with the lines of a coupled line
            segment group, the conductor count reflects the total of the conductors
            associated with all the coupled line segments in the group.
            '''

        })
    '''
    Conductor count identifies the number of phase, neutral, and other
    wires represented in the phase impedance matrix and constrains the
    number of elements in the matrix. Typically, Kron reduction is used
    for incorporating effects of neutral impedance in the phase conductor
    values (so conductor count only considers phase wires), but neutrals
    can be included in the matrix (in which case conductor count would
    include the neutral wire(s)). For a phase impedance matrix associated
    with the lines of a coupled line segment group, the conductor count
    reflects the total of the conductors associated with all the coupled
    line segments in the group.
    '''

@dataclass(repr=False)
class PerLengthSequenceImpedance(PerLengthImpedance):
    '''
    Sequence impedance and admittance parameters per unit length, for transposed
    line segments of 1, 2, or 3 phases. For 1-phase line segments, define x
    = x0 = xself. For 2-phase line segments, define x = xself - xmutual and
    x0 = xself + xmutual.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    b0ch: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance, per unit of length.
            '''

        })
    '''
    Zero sequence shunt (charging) susceptance, per unit of length.
    '''

    bch: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance, per unit of length.
            '''

        })
    '''
    Positive sequence shunt (charging) susceptance, per unit of length.
    '''

    g0ch: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence shunt (charging) conductance, per unit of length.
            '''

        })
    '''
    Zero sequence shunt (charging) conductance, per unit of length.
    '''

    gch: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance, per unit of length.
            '''

        })
    '''
    Positive sequence shunt (charging) conductance, per unit of length.
    '''

    r: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence series resistance, per unit of length.
            '''

        })
    '''
    Positive sequence series resistance, per unit of length.
    '''

    r0: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence series resistance, per unit of length.
            '''

        })
    '''
    Zero sequence series resistance, per unit of length.
    '''

    x: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence series reactance, per unit of length.
            '''

        })
    '''
    Positive sequence series reactance, per unit of length.
    '''

    x0: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence series reactance, per unit of length.
            '''

        })
    '''
    Zero sequence series reactance, per unit of length.
    '''

@dataclass(repr=False)
class PhaseTapChangerTable(IdentifiedObject):
    '''
    Describes a tabular curve for how the phase angle difference and impedance
    varies with the tap step.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PhaseTapChangerTablePoint: list[PhaseTapChangerTablePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseTapChangerTablePoint.PhaseTapChangerTable',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The points of this table.
            '''

        })
    '''
    The points of this table.
    '''

    PhaseTapChangerTabular: list[PhaseTapChangerTabular] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseTapChangerTabular.PhaseTapChangerTable',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The phase tap changers to which this phase tap table applies.
            '''

        })
    '''
    The phase tap changers to which this phase tap table applies.
    '''

@dataclass(repr=False)
class ConnectionAngleTapChangerTable(PhaseTapChangerTable):
    '''
    Describes a tabular curve for how the connection angle varies with the
    tap step. This table is used when its winding connection angle matches
    the operating angle of the tap changer. There must be an instance of this
    table for each winding connection angle that can be used.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    windingConnectionAngle: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The phase angle between the in-phase winding and the out-of -phase winding
            used for creating phase shift. The out-of-phase winding produces what is
            known as the difference voltage. Setting this angle to 90 degrees is not
            the same as a symmetrical transformer. In this scenario you will still
            treat the 90-degree angle as a phase shifting transformer. The attribute
            can only be multiples of 30 degrees. When 0 degree is used the asymmetrical
            phase tap changer acts as ratio tap changer controlling voltage.
            '''

        })
    '''
    The phase angle between the in-phase winding and the out-of -phase
    winding used for creating phase shift. The out-of-phase winding produces
    what is known as the difference voltage. Setting this angle to 90 degrees
    is not the same as a symmetrical transformer. In this scenario you
    will still treat the 90-degree angle as a phase shifting transformer.
    The attribute can only be multiples of 30 degrees. When 0 degree is
    used the asymmetrical phase tap changer acts as ratio tap changer controlling
    voltage.
    '''

    ConnectionAngleTapChanger: Optional[ConnectionAngleTapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectionAngleTapChanger.ConnectionAngleTapChangerTable',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The connection angle tap changer that has this connection angle tap changer
            table.
            '''

        })
    '''
    The connection angle tap changer that has this connection angle tap
    changer table.
    '''

@dataclass(repr=False)
class Pnode(IdentifiedObject):
    '''
    A pricing node is directly associated with a connectivity node. It is a
    pricing location for which market participants submit their bids, offers,
    buy/sell CRRs, and settle.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ReferenceData'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    MktMeasurement: list[MktMeasurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MktMeasurement.Pnode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Allows Measurements to be associated to Pnodes.
            '''

        })
    '''
    Allows Measurements to be associated to Pnodes.
    '''

    RegisteredResources: list[RegisteredResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegisteredResource.Pnode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A registered resource injects power at one or more connectivity nodes related
            to a pnode
            '''

        })
    '''
    A registered resource injects power at one or more connectivity nodes
    related to a pnode
    '''

@dataclass(repr=False)
class AggregatedPnode(Pnode):
    '''
    An aggregated pricing node is a specialized type of pricing node used to
    model items such as System Zone, Default Price Zone, Custom Price Zone,
    Control Area, Aggregated Generation, Aggregated Particpating Load, Aggregated
    Non-Participating Load, Trading Hub, Designated Control Area(DCA) Zone.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ReferenceData'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AggregateNode: Optional[AggregateNode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AggregateNode.AggregatedPnode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class IndividualPnode(Pnode):
    '''
    Individual pricing node based on Pnode.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ReferenceData'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.IndividualPnode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class PointOfCommonCoupling(IdentifiedObject):
    '''
    Point of Common Coupling (PCC) refers to the location where multiple electrical
    sources or loads are electrically connected and provide a reference point
    where the voltages and currents from different parts of the system are
    considered to be common. The PCC is used to support system analysis, control,
    and monitoring, as it provides a reference for understanding the interactions
    and power flow between various components within the system. It is also
    relevant to define the requirement and responsibility between different
    actors in operating a power system.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class ACPointOfCommonCoupling(PointOfCommonCoupling):
    '''
    Point of interconnection of the DC converter station to the adjacent AC
    system (IEC 60633).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.ACPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Connectivity node which is a point of common coupling AC.
            '''

        })
    '''
    Connectivity node which is a point of common coupling AC.
    '''

    DCConverterUnit: Optional[DCConverterUnit] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCConverterUnit.ACPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC converter unit that has AC point of common coupling.
            '''

        })
    '''
    DC converter unit that has AC point of common coupling.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.ACPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Connectivity node which is a point of common coupling AC.
            '''

        })
    '''
    Connectivity node which is a point of common coupling AC.
    '''

    DCConverterUnit: Optional[DCConverterUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCConverterUnit.ACPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC converter unit that has AC point of common coupling.
            '''

        })
    '''
    DC converter unit that has AC point of common coupling.
    '''

@dataclass(repr=False)
class DCPointOfCommonCoupling(PointOfCommonCoupling):
    '''
    Point of interconnection of the DC converter station to the DC transmission
    line (IEC 60633).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCConverterUnit: Optional[DCConverterUnit] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCConverterUnit.DCPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC converter unit that has DC point of common coupling.
            '''

        })
    '''
    DC converter unit that has DC point of common coupling.
    '''

    DCNode: Optional[DCNode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCNode.DCPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DCNode that is a point of common coupling DC.
            '''

        })
    '''
    The DCNode that is a point of common coupling DC.
    '''

    DCConverterUnit: Optional[DCConverterUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCConverterUnit.DCPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC converter unit that has DC point of common coupling.
            '''

        })
    '''
    DC converter unit that has DC point of common coupling.
    '''

    DCNode: Optional[DCNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCNode.DCPointOfCommonCoupling',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DCNode that is a point of common coupling DC.
            '''

        })
    '''
    The DCNode that is a point of common coupling DC.
    '''

@stereotype(CIMStereotype.Part3Ext)
@dataclass(repr=False)
class PowerSystemResource(IdentifiedObject):
    '''
    A power system resource (PSR) can be an item of equipment such as a switch,
    an equipment container containing many individual items of equipment such
    as a substation, or an organisational entity such as sub-control area.
    Power system resources can have measurements associated.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConfigurationEvent: list[ConfigurationEvent] = field(
        default_factory=list,
        metadata={
        'type': 'Part 3 Ext',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConfigurationEvent.PowerSystemResource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    Controls: list[Control] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Control.PowerSystemResource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The controller outputs used to actually govern a regulating device, e.g.
            the magnetization of a synchronous machine or capacitor bank breaker actuator.
            '''

        })
    '''
    The controller outputs used to actually govern a regulating device,
    e.g. the magnetization of a synchronous machine or capacitor bank breaker
    actuator.
    '''

    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.PowerSystemResource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The measurements associated with this power system resource.
            '''

        })
    '''
    The measurements associated with this power system resource.
    '''

    OperatingShare: list[OperatingShare] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperatingShare.PowerSystemResource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operating shares of this power system resource.
            '''

        })
    '''
    The operating shares of this power system resource.
    '''

    AssetDatasheet: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.PowerSystemResources',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Datasheet information for this power system resource.
            '''

        })
    '''
    Datasheet information for this power system resource.
    '''

    DesignElement: Optional[DesignElement] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DesignElement.PowerSystemResource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Operation to be performed with the resource in context of a particular
            design
            '''

        })
    '''
    Operation to be performed with the resource in context of a particular
    design
    '''

    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.PowerSystemResources',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Location of this power system resource.
            '''

        })
    '''
    Location of this power system resource.
    '''

    PSRType: Optional[PSRType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PSRType.PowerSystemResources',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Custom classification for this power system resource.
            '''

        })
    '''
    Custom classification for this power system resource.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ACLineSegmentPhase(PowerSystemResource):
    '''
    A line segment phase represents one phase (or optionally the neutral) of
    an alternating current line segment.
    Under most circumstances there is not a line segment phase for the neutral.
    However, if a wire assembly is being used and it does not specify phase,
    a line segment phase must exist for each position in the assembly (including
    the neutral).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Sequence number provides the numbering for this line segment phase. When
            impedance is directly described, sequence number binds the phase to the
            column and row for entries in the per length phase impedance matrix (PhaseImpedanceData
            of PerLengthPhaseImpedance). When used in conjunction with a wire assembly
            description, sequence number associates the line segment phase to a position.
            For a line segment not a part of a parallel line segment group, sequence
            number starts at one and increments by one through each line segment phase
            associated with the line segment. If there is a line segment phase for
            neutral, it is numbered last.
            '''

        })
    '''
    Sequence number provides the numbering for this line segment phase.
    When impedance is directly described, sequence number binds the phase
    to the column and row for entries in the per length phase impedance
    matrix (PhaseImpedanceData of PerLengthPhaseImpedance). When used in
    conjunction with a wire assembly description, sequence number associates
    the line segment phase to a position.
    For a line segment not a part of a parallel line segment group, sequence
    number starts at one and increments by one through each line segment
    phase associated with the line segment. If there is a line segment
    phase for neutral, it is numbered last.
    '''

    phase: Optional[SinglePhaseKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase identifies the phase or neutral connection of the conductor at both
            ends.
            '''

        })
    '''
    Phase identifies the phase or neutral connection of the conductor at
    both ends.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.ACLineSegmentPhases',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line segment to which the phase belongs.
            '''

        })
    '''
    The line segment to which the phase belongs.
    '''

    IntraphaseSpacing: Optional[IntraphaseSpacing] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IntraphaseSpacing.ACLineSegmentPhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    WireInfo: Optional[WireInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireInfo.ACLineSegmentPhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class AirCompressor(PowerSystemResource):
    '''
    Combustion turbine air compressor which is an integral part of a compressed
    air energy storage (CAES) plant.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.AirCompressor',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''

        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''

    airCompressorRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rating of the CAES air compressor.
            '''

        })
    '''
    Rating of the CAES air compressor.
    '''

    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.AirCompressor',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''

        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''

    CombustionTurbine: Optional[CombustionTurbine] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CombustionTurbine.AirCompressor',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A CAES air compressor is driven by combustion turbine.
            '''

        })
    '''
    A CAES air compressor is driven by combustion turbine.
    '''

@dataclass(repr=False)
class AreaInterchangeController(PowerSystemResource):
    '''
    Area interchange control is set to control active power of an area.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Control'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ControlArea: Optional[ControlArea] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ControlArea.AreaInterchangeController',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Control area that has a area interchange controller.
            '''

        })
    '''
    Control area that has a area interchange controller.
    '''

@stereotype(CIMStereotype.European)
@dataclass(repr=False)
class BoundaryPoint(PowerSystemResource):
    '''
    Designates a connection point at which one or more model authority sets
    shall connect to. The location of the connection point as well as other
    properties are agreed between organisations responsible for the interconnection,
    hence all attributes of the class represent this agreement. It is primarily
    used in a boundary model authority set which can contain one or many BoundaryPoint-s
    among other Equipment-s and their connections.
    '''

    __namespace__ = 'http://iec.ch/TC57/CIM100-European#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'European',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.BoundaryPoint',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The connectivity node that is designated as a boundary point.
            '''

        })
    '''
    The connectivity node that is designated as a boundary point.
    '''

    fromEndIsoCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The ISO code of the region which the "From" side of the Boundary point
            belongs to or it is connected to.
            The ISO code is a two-character country code as defined by ISO 3166 (http://www.iso.org/iso/country_codes).
            The length of the string is 2 characters maximum.
            '''

        })
    '''
    The ISO code of the region which the "From" side of the Boundary point
    belongs to or it is connected to.
    The ISO code is a two-character country code as defined by ISO 3166
    (http://www.iso.org/iso/country_codes). The length of the string is
    2 characters maximum.
    '''

    fromEndName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            A human readable name with length of the string 64 characters maximum.
            It covers the following two cases:
            -if the Boundary point is placed on a tie-line, it is the name (IdentifiedObject.name)
            of the substation at which the "From" side of the tie-line is connected
            to.
            -if the Boundary point is placed in a substation, it is the name (IdentifiedObject.name)
            of the element (e.g. PowerTransformer, ACLineSegment, Switch, etc.) at
            which the "From" side of the Boundary point is connected to.
            '''

        })
    '''
    A human readable name with length of the string 64 characters maximum.
    It covers the following two cases:
    -if the Boundary point is placed on a tie-line, it is the name (IdentifiedObject.name)
    of the substation at which the "From" side of the tie-line is connected
    to.
    -if the Boundary point is placed in a substation, it is the name (IdentifiedObject.name)
    of the element (e.g. PowerTransformer, ACLineSegment, Switch, etc.)
    at which the "From" side of the Boundary point is connected to.
    '''

    fromEndNameTso: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            Identifies the name of the transmission system operator, distribution system
            operator or other entity at which the "From" side of the interconnection
            is connected to. The length of the string is 64 characters maximum.
            '''

        })
    '''
    Identifies the name of the transmission system operator, distribution
    system operator or other entity at which the "From" side of the interconnection
    is connected to. The length of the string is 64 characters maximum.
    '''

    isDirectCurrent: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            If true, this boundary point is a point of common coupling (PCC) of a direct
            current (DC) interconnection, otherwise the interconnection is AC (default).
            '''

        })
    '''
    If true, this boundary point is a point of common coupling (PCC) of
    a direct current (DC) interconnection, otherwise the interconnection
    is AC (default).
    '''

    isExcludedFromAreaInterchange: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            If true, this boundary point is on the interconnection that is excluded
            from control area interchange calculation and consequently has no related
            tie flows. Otherwise, the interconnection is included in control area interchange
            and a TieFlow is required at all sides of the boundary point (default).
            '''

        })
    '''
    If true, this boundary point is on the interconnection that is excluded
    from control area interchange calculation and consequently has no related
    tie flows. Otherwise, the interconnection is included in control area
    interchange and a TieFlow is required at all sides of the boundary
    point (default).
    '''

    toEndIsoCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The ISO code of the region which the "To" side of the Boundary point belongs
            to or is connected to.
            The ISO code is a two-character country code as defined by ISO 3166 (http://www.iso.org/iso/country_codes).
            The length of the string is 2 characters maximum.
            '''

        })
    '''
    The ISO code of the region which the "To" side of the Boundary point
    belongs to or is connected to.
    The ISO code is a two-character country code as defined by ISO 3166
    (http://www.iso.org/iso/country_codes). The length of the string is
    2 characters maximum.
    '''

    toEndName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            A human readable name with length of the string 64 characters maximum.
            It covers the following two cases:
            -if the Boundary point is placed on a tie-line, it is the name (IdentifiedObject.name)
            of the substation at which the "To" side of the tie-line is connected to.
            -if the Boundary point is placed in a substation, it is the name (IdentifiedObject.name)
            of the element (e.g. PowerTransformer, ACLineSegment, Switch, etc.) at
            which the "To" side of the Boundary point is connected to.
            '''

        })
    '''
    A human readable name with length of the string 64 characters maximum.
    It covers the following two cases:
    -if the Boundary point is placed on a tie-line, it is the name (IdentifiedObject.name)
    of the substation at which the "To" side of the tie-line is connected
    to.
    -if the Boundary point is placed in a substation, it is the name (IdentifiedObject.name)
    of the element (e.g. PowerTransformer, ACLineSegment, Switch, etc.)
    at which the "To" side of the Boundary point is connected to.
    '''

    toEndNameTso: Optional[str] = field(
        default=None,
        metadata={
        'type': 'European Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            Identifies the name of the transmission system operator, distribution system
            operator or other entity at which the "To" side of the interconnection
            is connected to. The length of the string is 64 characters maximum.
            '''

        })
    '''
    Identifies the name of the transmission system operator, distribution
    system operator or other entity at which the "To" side of the interconnection
    is connected to. The length of the string is 64 characters maximum.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'European',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.BoundaryPoint',
        'namespace': 'http://iec.ch/TC57/CIM100-European#',
        'docstring':
            '''
            The connectivity node that is designated as a boundary point.
            '''

        })
    '''
    The connectivity node that is designated as a boundary point.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CAESPlant(PowerSystemResource):
    '''
    Compressed air energy storage plant.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AirCompressor: Optional[AirCompressor] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AirCompressor.CAESPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''

        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.CAESPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''

        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''

    energyStorageCapacity: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The rated energy storage capacity. The attribute shall be a positive value.
            '''

        })
    '''
    The rated energy storage capacity. The attribute shall be a positive
    value.
    '''

    ratedCapacityP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The CAES plant's gross rated generating capacity. The attribute shall be
            a positive value.
            '''

        })
    '''
    The CAES plant's gross rated generating capacity. The attribute shall
    be a positive value.
    '''

    AirCompressor: Optional[AirCompressor] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AirCompressor.CAESPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''

        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.CAESPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''

        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CogenerationPlant(PowerSystemResource):
    '''
    A set of thermal generating units for the production of electrical energy
    and process steam (usually from the output of the steam turbines). The
    steam sendout is typically used for industrial purposes or for municipal
    heating and cooling.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    SteamSendoutSchedule: Optional[SteamSendoutSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SteamSendoutSchedule.CogenerationPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''

        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''

    ThermalGeneratingUnits: list[ThermalGeneratingUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ThermalGeneratingUnit.CogenerationPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may be a member of a cogeneration plant.
            '''

        })
    '''
    A thermal generating unit may be a member of a cogeneration plant.
    '''

    cogenHPSendoutRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The high pressure steam sendout.
            '''

        })
    '''
    The high pressure steam sendout.
    '''

    cogenHPSteamRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The high pressure steam rating.
            '''

        })
    '''
    The high pressure steam rating.
    '''

    cogenLPSendoutRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The low pressure steam sendout.
            '''

        })
    '''
    The low pressure steam sendout.
    '''

    cogenLPSteamRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The low pressure steam rating.
            '''

        })
    '''
    The low pressure steam rating.
    '''

    ratedP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The rated output active power of the cogeneration plant.
            The attribute shall be a positive value.
            '''

        })
    '''
    The rated output active power of the cogeneration plant.
    The attribute shall be a positive value.
    '''

    SteamSendoutSchedule: Optional[SteamSendoutSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SteamSendoutSchedule.CogenerationPlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''

        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''

@dataclass(repr=False)
class CombinedCyclePlant(PowerSystemResource):
    '''
    A set of combustion turbines and steam turbines where the exhaust heat
    from the combustion turbines is recovered to make steam for the steam turbines,
    resulting in greater overall plant efficiency.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ThermalGeneratingUnits: list[ThermalGeneratingUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ThermalGeneratingUnit.CombinedCyclePlant',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may be a member of a combined cycle plant.
            '''

        })
    '''
    A thermal generating unit may be a member of a combined cycle plant.
    '''

    combCyclePlantRating: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The combined cycle plant's active power output rating.
            '''

        })
    '''
    The combined cycle plant's active power output rating.
    '''

@dataclass(repr=False)
class CombustionTurbine(PowerSystemResource):
    '''
    A prime mover that is typically fuelled by gas or light oil.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'GenerationTrainingSimulation'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AirCompressor: Optional[AirCompressor] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AirCompressor.CombustionTurbine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A CAES air compressor is driven by combustion turbine.
            '''

        })
    '''
    A CAES air compressor is driven by combustion turbine.
    '''

@dataclass(repr=False)
class ConnectivityNodeContainer(PowerSystemResource):
    '''
    A base class for all objects that may contain connectivity nodes or topological
    nodes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConnectivityNodes: list[ConnectivityNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConnectivityNode.ConnectivityNodeContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Connectivity nodes which belong to this connectivity node container.
            '''

        })
    '''
    Connectivity nodes which belong to this connectivity node container.
    '''

    TopologicalNode: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.ConnectivityNodeContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The topological nodes which belong to this connectivity node container.
            '''

        })
    '''
    The topological nodes which belong to this connectivity node container.
    '''

@dataclass(repr=False)
class EquipmentContainer(ConnectivityNodeContainer):
    '''
    A modelling construct to provide a root class for containing equipment.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AdditionalGroupedEquipment: list[Equipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Equipment.AdditionalEquipmentContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The additonal contained equipment. The equipment belong to the equipment
            container. The equipment is contained in another equipment container, but
            also grouped with this equipment container. Examples include when a switch
            contained in a substation is also desired to be grouped with a line contianer
            or when a switch is included in a secondary substation and also grouped
            in a feeder.
            '''

        })
    '''
    The additonal contained equipment. The equipment belong to the equipment
    container. The equipment is contained in another equipment container,
    but also grouped with this equipment container. Examples include when
    a switch contained in a substation is also desired to be grouped with
    a line contianer or when a switch is included in a secondary substation
    and also grouped in a feeder.
    '''

    Equipments: list[Equipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Equipment.EquipmentContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Contained equipment.
            '''

        })
    '''
    Contained equipment.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Bay(EquipmentContainer):
    '''
    A collection of power system resources (within a given substation) including
    conducting equipment, protection relays, measurements, and telemetry. A
    bay typically represents a physical grouping related to modularization
    of equipment.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    bayEnergyMeasFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates the presence/absence of energy measurements.
            '''

        })
    '''
    Indicates the presence/absence of energy measurements.
    '''

    bayPowerMeasFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates the presence/absence of active/reactive power measurements.
            '''

        })
    '''
    Indicates the presence/absence of active/reactive power measurements.
    '''

    breakerConfiguration: Optional[BreakerConfiguration] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Breaker configuration.
            '''

        })
    '''
    Breaker configuration.
    '''

    busBarConfiguration: Optional[BusbarConfiguration] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Busbar configuration.
            '''

        })
    '''
    Busbar configuration.
    '''

    Substation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.Bays',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Substation containing the bay.
            '''

        })
    '''
    Substation containing the bay.
    '''

    VoltageLevel: Optional[VoltageLevel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VoltageLevel.Bays',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage level containing this bay.
            '''

        })
    '''
    The voltage level containing this bay.
    '''

@dataclass(repr=False)
class DCEquipmentContainer(EquipmentContainer):
    '''
    A modelling construct to provide a root class for containment of DC as
    well as AC equipment. The class differ from the EquipmentContainer for
    AC in that it may also contain DCNode(-s). Hence it can contain both AC
    and DC equipment.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCNodes: list[DCNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCNode.DCEquipmentContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC nodes contained in the DC equipment container.
            '''

        })
    '''
    The DC nodes contained in the DC equipment container.
    '''

    DCTopologicalNode: list[DCTopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCTopologicalNode.DCEquipmentContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The topological nodes which belong to this connectivity node container.
            '''

        })
    '''
    The topological nodes which belong to this connectivity node container.
    '''

    HVDCInterconnectionDynamics: Optional[HVDCInterconnectionDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HVDCInterconnectionDynamics.DCEquipmentContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            HVDC interconnection dynamics model used to describe dynamic behaviour
            of this HVDC interconnection.
            '''

        })
    '''
    HVDC interconnection dynamics model used to describe dynamic behaviour
    of this HVDC interconnection.
    '''

@dataclass(repr=False)
class DCConverterUnit(DCEquipmentContainer):
    '''
    Indivisible operative unit comprising all equipment between the point of
    common coupling on the AC side and the point of common coupling � DC side,
    essentially one or more converters, together with one or more converter
    transformers, converter control equipment, essential protective and switching
    devices and auxiliaries, if any, used for conversion.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ACPointOfCommonCoupling: Optional[ACPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACPointOfCommonCoupling.DCConverterUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            AC point of common coupling for this DC converter unit.
            '''

        })
    '''
    AC point of common coupling for this DC converter unit.
    '''

    DCPointOfCommonCoupling: Optional[DCPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCPointOfCommonCoupling.DCConverterUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DCNode that is the point of common coupling at DC side of this DCConverterUnit.
            '''

        })
    '''
    DCNode that is the point of common coupling at DC side of this DCConverterUnit.
    '''

    operationMode: Optional[DCConverterOperatingModeKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operating mode of an DC bipole (bipolar, monopolar metallic return,
            etc.).
            '''

        })
    '''
    The operating mode of an DC bipole (bipolar, monopolar metallic return,
    etc.).
    '''

    ACPointOfCommonCoupling: Optional[ACPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACPointOfCommonCoupling.DCConverterUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            AC point of common coupling for this DC converter unit.
            '''

        })
    '''
    AC point of common coupling for this DC converter unit.
    '''

    DCPointOfCommonCoupling: Optional[DCPointOfCommonCoupling] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCPointOfCommonCoupling.DCConverterUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DCNode that is the point of common coupling at DC side of this DCConverterUnit.
            '''

        })
    '''
    DCNode that is the point of common coupling at DC side of this DCConverterUnit.
    '''

    DCPole: Optional[DCPole] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCPole.DCConverterUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC pole that has this DC converter unit.
            '''

        })
    '''
    The DC pole that has this DC converter unit.
    '''

    DCSubstation: Optional[DCSubstation] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCSubstation.DCConverterUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation that has one or more DC converter units.
            '''

        })
    '''
    DC substation that has one or more DC converter units.
    '''

    Substation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.DCConverterUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The containing substation of the DC converter unit.
            '''

        })
    '''
    The containing substation of the DC converter unit.
    '''

@dataclass(repr=False)
class DCLine(DCEquipmentContainer):
    '''
    Overhead lines and/or cables connecting two or more DC substations.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCPole: Optional[DCPole] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCPole.DCLine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC pole that has this DC line.
            '''

        })
    '''
    The DC pole that has this DC line.
    '''

    DCPole: Optional[DCPole] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCPole.DCLine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC pole that has this DC line.
            '''

        })
    '''
    The DC pole that has this DC line.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubGeographicalRegion.DCLines',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SubGeographicalRegion containing the DC line.
            '''

        })
    '''
    The SubGeographicalRegion containing the DC line.
    '''

@dataclass(repr=False)
class DCSubstation(DCEquipmentContainer):
    '''
    DC substation or DC converter station (IEC 60633) is part of an DC system
    which consists of one or more converter units installed in a single location
    together with buildings, reactors, filters, reactive power supply, control,
    monitoring, protective, measuring and auxiliary equipment. A DC substation
    forming part of an DC transmission system may be referred to as an DC transmission
    substation.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCConverterUnit: list[DCConverterUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCConverterUnit.DCSubstation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC converter unit that belongs to this DC substation.
            '''

        })
    '''
    DC converter unit that belongs to this DC substation.
    '''

    DCSubstationBipole: list[DCSubstationBipole] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCSubstationBipole.DCSubstation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation bipole which is part of the DC substation.
            '''

        })
    '''
    DC substation bipole which is part of the DC substation.
    '''

    DCSubstationPole: list[DCSubstationPole] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCSubstationPole.DCSubstation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation pole which is part of the DC substation.
            '''

        })
    '''
    DC substation pole which is part of the DC substation.
    '''

    isTapping: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC tapping substation (IEC 60633) is a DC substation, mainly used for inversion,
            with a rating which is a small fraction of that of the rectifier(s) in
            the system.
            '''

        })
    '''
    DC tapping substation (IEC 60633) is a DC substation, mainly used for
    inversion, with a rating which is a small fraction of that of the rectifier(s)
    in the system.
    '''

    Substation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.DCSubstation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Substation that contains this DC susbstation.
            '''

        })
    '''
    Substation that contains this DC susbstation.
    '''

@dataclass(repr=False)
class DCSubstationBipole(DCEquipmentContainer):
    '''
    Part of a bipolar DC system (IEC 60633) contained within a DC substation.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCSubstation: Optional[DCSubstation] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCSubstation.DCSubstationBipole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation that contains this DC substation bipole part.
            '''

        })
    '''
    DC substation that contains this DC substation bipole part.
    '''

    DirectCurrentSubstationBipoleController: Optional[DirectCurrentSubstationBipoleController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DirectCurrentSubstationBipoleController.DCSubstationBipole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation bipole controller controlling this DC substation bipole.
            '''

        })
    '''
    DC substation bipole controller controlling this DC substation bipole.
    '''

@dataclass(repr=False)
class DCSubstationPole(DCEquipmentContainer):
    '''
    Part of an DC system pole (IEC 60633) which is contained within a DC substation.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCSubstation: Optional[DCSubstation] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCSubstation.DCSubstationPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation that contains this DC substation pole part.
            '''

        })
    '''
    DC substation that contains this DC substation pole part.
    '''

    DirectCurrentSubstationPoleController: Optional[DirectCurrentSubstationPoleController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DirectCurrentSubstationPoleController.DCSubstationPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation pole controller controlling this DC substation pole.
            '''

        })
    '''
    DC substation pole controller controlling this DC substation pole.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Feeder(EquipmentContainer):
    '''
    A collection of equipment for organizational purposes, used for grouping
    distribution resources.
    The organization a feeder does not necessarily reflect connectivity or
    current operation state.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    NamingSecondarySubstation: list[Substation] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Substation.NamingFeeder',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The secondary substations that are normally energized from the feeder.
            Used for naming purposes. Should be consistent with the other associations
            for energizing terminal specification and the feeder energization specification.
            '''

        })
    '''
    The secondary substations that are normally energized from the feeder.
    Used for naming purposes. Should be consistent with the other associations
    for energizing terminal specification and the feeder energization specification.
    '''

    NormalHeadTerminal: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.NormalHeadFeeder',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal head terminal or terminals of the feeder.
            '''

        })
    '''
    The normal head terminal or terminals of the feeder.
    '''

    NormalEnergizingSubstation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.NormalEnergizedFeeder',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The substation that nominally energizes the feeder. Also used for naming
            purposes.
            '''

        })
    '''
    The substation that nominally energizes the feeder. Also used for naming
    purposes.
    '''

@dataclass(repr=False)
class Line(EquipmentContainer):
    '''
    Contains equipment beyond a substation belonging to a power transmission
    line.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ACTieCorridor: Optional[ACTieCorridor] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACTieCorridor.Line',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            ACTieCorridor that the line is part of.
            '''

        })
    '''
    ACTieCorridor that the line is part of.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubGeographicalRegion.Lines',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The sub-geographical region of the line.
            '''

        })
    '''
    The sub-geographical region of the line.
    '''

@dataclass(repr=False)
class MktLine(Line):
    '''
    Subclass for IEC61970:Wires:Line.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketOpCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TransmissionRightOfWay: Optional[TransmissionRightOfWay] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransmissionRightOfWay.MktLine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class Plant(EquipmentContainer):
    '''
    A Plant is a collection of equipment for purposes of generation.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Substation(EquipmentContainer):
    '''
    A collection of equipment for purposes other than generation or utilization,
    through which electric energy in bulk is passed for the purposes of switching
    or modifying its characteristics.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Bays: list[Bay] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Bay.Substation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Bays contained in the substation.
            '''

        })
    '''
    Bays contained in the substation.
    '''

    DCConverterUnit: list[DCConverterUnit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCConverterUnit.Substation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC converter unit belonging of the substation.
            '''

        })
    '''
    The DC converter unit belonging of the substation.
    '''

    DCSubstation: list[DCSubstation] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCSubstation.Substation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC substation that is part of AC and DC substation.
            '''

        })
    '''
    DC substation that is part of AC and DC substation.
    '''

    NormalEnergizedFeeder: list[Feeder] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Feeder.NormalEnergizingSubstation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal energized feeders of the substation. Also used for naming purposes.
            '''

        })
    '''
    The normal energized feeders of the substation. Also used for naming
    purposes.
    '''

    VoltageLevels: list[VoltageLevel] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageLevel.Substation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage levels within this substation.
            '''

        })
    '''
    The voltage levels within this substation.
    '''

    NamingFeeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.NamingSecondarySubstation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The primary feeder that normally energizes the secondary substation. Used
            for naming purposes. Either this association or the substation to subgeographical
            region should be used for hierarchical containment specification.
            '''

        })
    '''
    The primary feeder that normally energizes the secondary substation.
    Used for naming purposes. Either this association or the substation
    to subgeographical region should be used for hierarchical containment
    specification.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubGeographicalRegion.Substations',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The SubGeographicalRegion containing the substation.
            '''

        })
    '''
    The SubGeographicalRegion containing the substation.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class VoltageLevel(EquipmentContainer):
    '''
    A collection of equipment at one common system voltage forming a switchgear.
    The equipment typically consists of breakers, busbars, instrumentation,
    control, regulation and protection devices as well as assemblies of all
    these.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Bays: list[Bay] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Bay.VoltageLevel',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The bays within this voltage level.
            '''

        })
    '''
    The bays within this voltage level.
    '''

    highVoltageLimit: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The bus bar's high voltage limit.
            The limit applies to all equipment and nodes contained in a given VoltageLevel.
            It is not required that it is exchanged in pair with lowVoltageLimit. It
            is preferable to use operational VoltageLimit, which prevails, if present.
            '''

        })
    '''
    The bus bar's high voltage limit.
    The limit applies to all equipment and nodes contained in a given VoltageLevel.
    It is not required that it is exchanged in pair with lowVoltageLimit.
    It is preferable to use operational VoltageLimit, which prevails, if
    present.
    '''

    lowVoltageLimit: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The bus bar's low voltage limit.
            The limit applies to all equipment and nodes contained in a given VoltageLevel.
            It is not required that it is exchanged in pair with highVoltageLimit.
            It is preferable to use operational VoltageLimit, which prevails, if present.
            '''

        })
    '''
    The bus bar's low voltage limit.
    The limit applies to all equipment and nodes contained in a given VoltageLevel.
    It is not required that it is exchanged in pair with highVoltageLimit.
    It is preferable to use operational VoltageLimit, which prevails, if
    present.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.VoltageLevel',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The base voltage used for all equipment within the voltage level.
            '''

        })
    '''
    The base voltage used for all equipment within the voltage level.
    '''

    Substation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.VoltageLevels',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The substation of the voltage level.
            '''

        })
    '''
    The substation of the voltage level.
    '''

@stereotype(CIMStereotype.Concrete)
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ControlArea(PowerSystemResource):
    '''
    A control area is a grouping of generating units and/or loads and a cutset
    of tie lines (as terminals) which may be used for a variety of purposes
    including automatic generation control, power flow solution area interchange
    control specification, and input to load forecasting. All generation and
    load within the area defined by the terminals on the border are considered
    in the area interchange control. Note that any number of overlapping control
    area specifications may be superimposed on the physical model. The following
    general principles apply to ControlArea:
    1. The control area orientation for net interchange is positive for an
    import, negative for an export.
    2. The control area net interchange is determined by summing flows in Terminals.
    The Terminals are identified by creating a set of TieFlow objects associated
    with a ControlArea object. Each TieFlow object identifies one Terminal.
    3. In a single network model, a tie between two control areas must be modelled
    in both control area specifications, such that the two representations
    of the tie flow sum to zero.
    4. The normal orientation of Terminal flow is positive for flow into the
    conducting equipment that owns the Terminal. (i.e. flow from a bus into
    a device is positive.) However, the orientation of each flow in the control
    area specification must align with the control area convention, i.e. import
    is positive. If the orientation of the Terminal flow referenced by a TieFlow
    is positive into the control area, then this is confirmed by setting TieFlow.positiveFlowIn
    flag TRUE. If not, the orientation must be reversed by setting the TieFlow.positiveFlowIn
    flag FALSE.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ControlArea'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ControlAreaGeneratingUnit: list[ControlAreaGeneratingUnit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ControlAreaGeneratingUnit.ControlArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The generating unit specifications for the control area.
            '''

        })
    '''
    The generating unit specifications for the control area.
    '''

    ControlAreaPowerElectronicsUnit: list[ControlAreaPowerElectronicsUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ControlAreaPowerElectronicsUnit.ControlArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The parent control area for the power electronics unit specifications.
            '''

        })
    '''
    The parent control area for the power electronics unit specifications.
    '''

    EnergyArea: Optional[EnergyArea] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyArea.ControlArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The energy area that is forecast from this control area specification.
            '''

        })
    '''
    The energy area that is forecast from this control area specification.
    '''

    TieFlow: list[TieFlow] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TieFlow.ControlArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The tie flows associated with the control area.
            '''

        })
    '''
    The tie flows associated with the control area.
    '''

    netInterchange: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The specified positive net interchange into the control area, i.e. positive
            sign means flow into the area.
            '''

        })
    '''
    The specified positive net interchange into the control area, i.e.
    positive sign means flow into the area.
    '''

    pTolerance: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power net interchange tolerance. The attribute shall be a positive
            value or zero.
            '''

        })
    '''
    Active power net interchange tolerance. The attribute shall be a positive
    value or zero.
    '''

    type: Optional[ControlAreaTypeKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The primary type of control area definition used to determine if this is
            used for automatic generation control, for planning interchange control,
            or other purposes. A control area specified with primary type of automatic
            generation control could still be forecast and used as an interchange area
            in power flow analysis.
            '''

        })
    '''
    The primary type of control area definition used to determine if this
    is used for automatic generation control, for planning interchange
    control, or other purposes. A control area specified with primary type
    of automatic generation control could still be forecast and used as
    an interchange area in power flow analysis.
    '''

    AreaInterchangeController: Optional[AreaInterchangeController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AreaInterchangeController.ControlArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Area interchange controller for this control area.
            '''

        })
    '''
    Area interchange controller for this control area.
    '''

    EnergyArea: Optional[EnergyArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyArea.ControlArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The energy area that is forecast from this control area specification.
            '''

        })
    '''
    The energy area that is forecast from this control area specification.
    '''

    PowerFrequencyController: Optional[PowerFrequencyController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerFrequencyController.ControlArea',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power frequency controller for this control area.
            '''

        })
    '''
    Power frequency controller for this control area.
    '''

@dataclass(repr=False)
class DCBiPole(PowerSystemResource):
    '''
    DC system bipole (IEC 60633), which is part of an DC system consisting
    of two independently operable DC system poles, which during normal operation,
    exhibit opposite direct voltage polarities with respect to earth.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    BipolarDCSystem: Optional[BipolarDCSystem] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BipolarDCSystem.DCBiPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Bipolar DC system that has this DC bipole.
            '''

        })
    '''
    Bipolar DC system that has this DC bipole.
    '''

    DCPole: list[DCPole] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCPole.DCBiPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC pole part of the DC system bipole.
            '''

        })
    '''
    DC pole part of the DC system bipole.
    '''

    BipolarDCSystem: Optional[BipolarDCSystem] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BipolarDCSystem.DCBiPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Bipolar DC system that has this DC bipole.
            '''

        })
    '''
    Bipolar DC system that has this DC bipole.
    '''

@dataclass(repr=False)
class DCPole(PowerSystemResource):
    '''
    The direct current (DC) system pole (IEC 60633) is part of a DC system
    consisting of all the equipment in the DC substations and the interconnecting
    transmission lines, if any, which during normal operation exhibit a common
    direct voltage polarity with respect to earth.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCConverterUnit: list[DCConverterUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DCConverterUnit.DCPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC converter unit that relates to this DC pole.
            '''

        })
    '''
    The DC converter unit that relates to this DC pole.
    '''

    DCLine: Optional[DCLine] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCLine.DCPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC line that is related to this DC pole.
            '''

        })
    '''
    The DC line that is related to this DC pole.
    '''

    AsymmetricMonopolarDCSystem: Optional[MonopolarDCSystem] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MonopolarDCSystem.DCPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asymmetric monopolar DC system that has this DC pole.
            '''

        })
    '''
    Asymmetric monopolar DC system that has this DC pole.
    '''

    normalParticipationFactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal participation factor describing the entity part of the active power
            provided by a collection of entities (e.g. an active power forecast to
            a collection of entities is divided to each of the member entity according
            to the participation factor). Must be a positive value.
            In the case of a sharing strategy, the distribution is following entities
            value (V) equals aggregated value (T) divided by sum of participation factors
            (PF), i.e. V=T/sum(PF).
            In the case of priority strategy, the item with the lowest number gets
            allocated energy first.
            '''

        })
    '''
    Normal participation factor describing the entity part of the active
    power provided by a collection of entities (e.g. an active power forecast
    to a collection of entities is divided to each of the member entity
    according to the participation factor). Must be a positive value.
    In the case of a sharing strategy, the distribution is following entities
    value (V) equals aggregated value (T) divided by sum of participation
    factors (PF), i.e. V=T/sum(PF).
    In the case of priority strategy, the item with the lowest number gets
    allocated energy first.
    '''

    participationFactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Participation factor describing the entity part of the active power provided
            by a collection of entities (e.g. an active power forecast to a collection
            of entities is divided to each of the member entity according to the participation
            factor). Must be a positive value.
            In the case of a sharing strategy, the distribution is following entities
            value (V) equals aggregated value (T) divided by sum of participation factors
            (PF), i.e. V=T/sum(PF).
            In the case of priority strategy, the item with the lowest number gets
            allocated energy first.
            '''

        })
    '''
    Participation factor describing the entity part of the active power
    provided by a collection of entities (e.g. an active power forecast
    to a collection of entities is divided to each of the member entity
    according to the participation factor). Must be a positive value.
    In the case of a sharing strategy, the distribution is following entities
    value (V) equals aggregated value (T) divided by sum of participation
    factors (PF), i.e. V=T/sum(PF).
    In the case of priority strategy, the item with the lowest number gets
    allocated energy first.
    '''

    maxEconomicP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum high economic active power limit, that should not exceed the maximum
            operating active power limit.
            '''

        })
    '''
    Maximum high economic active power limit, that should not exceed the
    maximum operating active power limit.
    '''

    minEconomicP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Low economic active power limit that shall be greater than or equal to
            the minimum operating active power limit.
            '''

        })
    '''
    Low economic active power limit that shall be greater than or equal
    to the minimum operating active power limit.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            '''

        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    '''

    AsymmetricMonopolarDCSystem: Optional[MonopolarDCSystem] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MonopolarDCSystem.DCPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asymmetric monopolar DC system that has this DC pole.
            '''

        })
    '''
    Asymmetric monopolar DC system that has this DC pole.
    '''

    DCBiPole: Optional[DCBiPole] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCBiPole.DCPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC system bipole that has two independently operatable DC system poles.
            '''

        })
    '''
    DC system bipole that has two independently operatable DC system poles.
    '''

    DCLine: Optional[DCLine] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCLine.DCPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC line that is related to this DC pole.
            '''

        })
    '''
    The DC line that is related to this DC pole.
    '''

    DCTieCorridor: Optional[DCTieCorridor] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCTieCorridor.DCPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DCTieCorridor that has this DC pole.
            '''

        })
    '''
    The DCTieCorridor that has this DC pole.
    '''

    DirectCurrentPoleController: Optional[DirectCurrentPoleController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DirectCurrentPoleController.DCPole',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC pole controller that controls this DC pole.
            '''

        })
    '''
    DC pole controller that controls this DC pole.
    '''

@dataclass(repr=False)
class DCSystem(PowerSystemResource):
    '''
    Electrical power system which transfers energy in the form of direct current
    between two or more AC buses (defined in IEC 60633).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    directionKind: Optional[DCSystemDirectionKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Direction kind of the DC system.
            '''

        })
    '''
    Direction kind of the DC system.
    '''

    transmissionKind: Optional[DCSystemTransmissionKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transmission kind of the DC system.
            '''

        })
    '''
    Transmission kind of the DC system.
    '''

@dataclass(repr=False)
class BipolarDCSystem(DCSystem):
    '''
    Bipolar DC system (IEC 60633) consists of two poles of opposite polarity
    with respect to earth. The overhead lines, if any, of the two poles may
    be carried on common or separate towers.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCBiPole: Optional[DCBiPole] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCBiPole.BipolarDCSystem',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC bipole that belongs to a bipolar DC system.
            '''

        })
    '''
    DC bipole that belongs to a bipolar DC system.
    '''

    isRigid: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, the bipolar DC system is a rigid DC current bipolar system (IEC
            60633). It is a bipolar DC system without neutral connection between both
            converter stations. Since only two (pole) conductors exist, no unbalance
            current between both poles is possible. In case of interruption of power
            transfer of one converter pole, the current of the other pole has to be
            interrupted as well (at least for a limited time to allow reconfiguration
            of the DC circuit).
            '''

        })
    '''
    If true, the bipolar DC system is a rigid DC current bipolar system
    (IEC 60633). It is a bipolar DC system without neutral connection between
    both converter stations. Since only two (pole) conductors exist, no
    unbalance current between both poles is possible. In case of interruption
    of power transfer of one converter pole, the current of the other pole
    has to be interrupted as well (at least for a limited time to allow
    reconfiguration of the DC circuit).
    '''

    DCBiPole: Optional[DCBiPole] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCBiPole.BipolarDCSystem',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC bipole that belongs to a bipolar DC system.
            '''

        })
    '''
    DC bipole that belongs to a bipolar DC system.
    '''

@dataclass(repr=False)
class MonopolarDCSystem(DCSystem):
    '''
    Monopolar DC system (IEC 60633) is a DC system with only one pole.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCPole: Optional[DCPole] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCPole.AsymmetricMonopolarDCSystem',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC pole part of the asymmetric DC system.
            '''

        })
    '''
    DC pole part of the asymmetric DC system.
    '''

    isSymmetrical: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            if true, the monopolar DC system is symmetrical monopolar DC system (IEC
            60633). It is a DC system with only one symmetrical monopole. A symmetrical
            monopole is part of an DC system consisting of all the equipment in the
            DC substations and the interconnecting transmission lines, if any, which
            during normal operation exhibits equal and opposite direct voltage polarities
            with respect to earth but without series connection of converters in each
            converter station. The term "symmetrical monopole" is used even though
            there are two polarities with DC voltages, because with only one converter
            it is not possible to provide the redundancy which is normally associated
            with the term "bipole".
            '''

        })
    '''
    if true, the monopolar DC system is symmetrical monopolar DC system
    (IEC 60633). It is a DC system with only one symmetrical monopole.
    A symmetrical monopole is part of an DC system consisting of all the
    equipment in the DC substations and the interconnecting transmission
    lines, if any, which during normal operation exhibits equal and opposite
    direct voltage polarities with respect to earth but without series
    connection of converters in each converter station. The term "symmetrical
    monopole" is used even though there are two polarities with DC voltages,
    because with only one converter it is not possible to provide the redundancy
    which is normally associated with the term "bipole".
    '''

    DCPole: Optional[DCPole] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DCPole.AsymmetricMonopolarDCSystem',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC pole part of the asymmetric DC system.
            '''

        })
    '''
    DC pole part of the asymmetric DC system.
    '''

@dataclass(repr=False)
class EnergyConsumerPhase(PowerSystemResource):
    '''
    A single phase of an energy consumer.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power of the load. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''

        })
    '''
    Active power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    pfixed: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power of the load that is a fixed quantity. Load sign convention
            is used, i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Active power of the load that is a fixed quantity. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    pfixedPct: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fixed active power as per cent of load group fixed active power. Load sign
            convention is used, i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Fixed active power as per cent of load group fixed active power. Load
    sign convention is used, i.e. positive sign means flow out from a node.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power of the load. Load sign convention is used, i.e. positive
            sign means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''

        })
    '''
    Reactive power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    qfixed: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power of the load that is a fixed quantity. Load sign convention
            is used, i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Reactive power of the load that is a fixed quantity. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    qfixedPct: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fixed reactive power as per cent of load group fixed reactive power. Load
            sign convention is used, i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Fixed reactive power as per cent of load group fixed reactive power.
    Load sign convention is used, i.e. positive sign means flow out from
    a node.
    '''

    phase: Optional[SinglePhaseKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase of this energy consumer component. If the energy consumer is wye
            connected, the connection is from the indicated phase to the central ground
            or neutral point. If the energy consumer is delta connected, the phase
            indicates an energy consumer connected from the indicated phase to the
            next logical non-neutral phase.
            '''

        })
    '''
    Phase of this energy consumer component. If the energy consumer is
    wye connected, the connection is from the indicated phase to the central
    ground or neutral point. If the energy consumer is delta connected,
    the phase indicates an energy consumer connected from the indicated
    phase to the next logical non-neutral phase.
    '''

    EnergyConsumer: Optional[EnergyConsumer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumer.EnergyConsumerPhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The energy consumer to which this phase belongs.
            '''

        })
    '''
    The energy consumer to which this phase belongs.
    '''

@dataclass(repr=False)
class EnergySourcePhase(PowerSystemResource):
    '''
    Represents the single phase information of an unbalanced energy source.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    phase: Optional[SinglePhaseKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase of this energy source component. If the energy source wye connected,
            the connection is from the indicated phase to the central ground or neutral
            point. If the energy source is delta connected, the phase indicates an
            energy source connected from the indicated phase to the next logical non-neutral
            phase.
            '''

        })
    '''
    Phase of this energy source component. If the energy source wye connected,
    the connection is from the indicated phase to the central ground or
    neutral point. If the energy source is delta connected, the phase indicates
    an energy source connected from the indicated phase to the next logical
    non-neutral phase.
    '''

    EnergySource: Optional[EnergySource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergySource.EnergySourcePhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The energy sourceto which the phase belongs.
            '''

        })
    '''
    The energy sourceto which the phase belongs.
    '''

@dataclass(repr=False)
class Equipment(PowerSystemResource):
    '''
    The parts of a power system that are physical devices, electronic or mechanical.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.Equipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The operational limit sets associated with this equipment.
            '''

        })
    '''
    The operational limit sets associated with this equipment.
    '''

    aggregate: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The aggregate flag provides an alternative way of representing an aggregated
            (equivalent) element. It is applicable in cases when the dedicated classes
            for equivalent equipment do not have all of the attributes necessary to
            represent the required level of detail. In case the flag is set to "true"
            the single instance of equipment represents multiple pieces of equipment
            that have been modelled together as an aggregate equivalent obtained by
            a network reduction procedure. Examples would be power transformers or
            synchronous machines operating in parallel modelled as a single aggregate
            power transformer or aggregate synchronous machine.
            The attribute is not used for EquivalentBranch, EquivalentShunt, EquivalentInjection
            and ExternalNetworkInjection.
            '''

        })
    '''
    The aggregate flag provides an alternative way of representing an aggregated
    (equivalent) element. It is applicable in cases when the dedicated
    classes for equivalent equipment do not have all of the attributes
    necessary to represent the required level of detail. In case the flag
    is set to "true" the single instance of equipment represents multiple
    pieces of equipment that have been modelled together as an aggregate
    equivalent obtained by a network reduction procedure. Examples would
    be power transformers or synchronous machines operating in parallel
    modelled as a single aggregate power transformer or aggregate synchronous
    machine.
    The attribute is not used for EquivalentBranch, EquivalentShunt, EquivalentInjection
    and ExternalNetworkInjection.
    '''

    inService: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the availability of the equipment. True means the equipment is
            available for topology processing, which determines if the equipment is
            energized or not. False means that the equipment is treated by network
            applications as if it is not in the model.
            '''

        })
    '''
    Specifies the availability of the equipment. True means the equipment
    is available for topology processing, which determines if the equipment
    is energized or not. False means that the equipment is treated by network
    applications as if it is not in the model.
    '''

    networkAnalysisEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The equipment is enabled to participate in network analysis. If unspecified,
            the value is assumed to be true.
            '''

        })
    '''
    The equipment is enabled to participate in network analysis. If unspecified,
    the value is assumed to be true.
    '''

    normallyInService: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the availability of the equipment under normal operating conditions.
            True means the equipment is available for topology processing, which determines
            if the equipment is energized or not. False means that the equipment is
            treated by network applications as if it is not in the model.
            '''

        })
    '''
    Specifies the availability of the equipment under normal operating
    conditions. True means the equipment is available for topology processing,
    which determines if the equipment is energized or not. False means
    that the equipment is treated by network applications as if it is not
    in the model.
    '''

    AdditionalEquipmentContainer: list[EquipmentContainer] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EquipmentContainer.AdditionalGroupedEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Additional equipment container beyond the primary equipment container.
            The equipment is contained in another equipment container, but also grouped
            with this equipment container.
            '''

        })
    '''
    Additional equipment container beyond the primary equipment container.
    The equipment is contained in another equipment container, but also
    grouped with this equipment container.
    '''

    EquipmentContainer: Optional[EquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EquipmentContainer.Equipments',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Container of this equipment.
            '''

        })
    '''
    Container of this equipment.
    '''

@dataclass(repr=False)
class AuxiliaryEquipment(Equipment):
    '''
    AuxiliaryEquipment describe equipment that is not performing any primary
    functions but support for the equipment performing the primary function.
    AuxiliaryEquipment is attached to primary equipment via an association
    with Terminal.
    This class is for AC equipment only.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AuxiliaryEquipment'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.AuxiliaryEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The Terminal at the equipment where the AuxiliaryEquipment is attached.
            '''

        })
    '''
    The Terminal at the equipment where the AuxiliaryEquipment is attached.
    '''

@dataclass(repr=False)
class FaultIndicator(AuxiliaryEquipment):
    '''
    A FaultIndicator is typically only an indicator (which may or may not be
    remotely monitored), and not a piece of equipment that actually initiates
    a protection event. It is used for FLISR (Fault Location, Isolation and
    Restoration) purposes, assisting with the dispatch of crews to "most likely"
    part of the network (i.e. assists with determining circuit section where
    the fault most likely happened).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AuxiliaryEquipment'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class Sensor(AuxiliaryEquipment):
    '''
    This class describe devices that transform a measured quantity into signals
    that can be presented at displays, used in control or be recorded.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AuxiliaryEquipment'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class CurrentTransformer(Sensor):
    '''
    Instrument transformer used to measure electrical qualities of the circuit
    that is being protected and/or monitored. Typically used as current transducer
    for the purpose of metering or protection. A typical secondary current
    rating would be 5A.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AuxiliaryEquipment'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    usage: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Intended usage of the CT; i.e. metering, protection.
            '''

        })
    '''
    Intended usage of the CT; i.e. metering, protection.
    '''

    accuracyLimit: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Percent of rated current for which the CT remains accurate within specified
            limits.
            '''

        })
    '''
    Percent of rated current for which the CT remains accurate within specified
    limits.
    '''

    coreBurden: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power burden of the CT core.
            '''

        })
    '''
    Power burden of the CT core.
    '''

@dataclass(repr=False)
class PostLineSensor(Sensor):
    '''
    A sensor used mainly in overhead distribution networks as the source of
    both current and voltage measurements.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AuxiliaryEquipment'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class PotentialTransformer(Sensor):
    '''
    Instrument transformer (also known as Voltage Transformer) used to measure
    electrical qualities of the circuit that is being protected and/or monitored.
    Typically used as voltage transducer for the purpose of metering, protection,
    or sometimes auxiliary substation supply. A typical secondary voltage rating
    would be 120V.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AuxiliaryEquipment'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    nominalRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nominal ratio between the primary and secondary voltage.
            '''

        })
    '''
    Nominal ratio between the primary and secondary voltage.
    '''

    type: Optional[PotentialTransformerKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Potential transformer construction type.
            '''

        })
    '''
    Potential transformer construction type.
    '''

@dataclass(repr=False)
class SurgeArrester(AuxiliaryEquipment):
    '''
    Shunt device, installed on the network, usually in the proximity of electrical
    equipment in order to protect the said equipment against transient voltage
    transients caused by lightning or switching activity.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AuxiliaryEquipment'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class WaveTrap(AuxiliaryEquipment):
    '''
    Wave traps are devices that impede high frequency power line carrier signals
    yet present a negligible impedance at the main power frequency.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'AuxiliaryEquipment'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CompositeSwitch(Equipment):
    '''
    A model of a set of individual Switches normally enclosed within the same
    cabinet and possibly with interlocks that restrict the combination of switch
    positions. These are typically found in medium voltage distribution networks.
    A CompositeSwitch could represent a Ring-Main-Unit (RMU), or pad-mounted
    switchgear, with primitive internal devices such as an internal bus-bar
    plus 3 or 4 internal switches each of which may individually be open or
    closed. A CompositeSwitch and a set of contained Switches can also be used
    to represent a multi-position switch e.g. a switch that can connect a circuit
    to Ground, Open or Busbar.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Switches: list[Switch] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Switch.CompositeSwitch',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Switches contained in this Composite switch.
            '''

        })
    '''
    Switches contained in this Composite switch.
    '''

    compositeSwitchType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An alphanumeric code that can be used as a reference to extra information
            such as the description of the interlocking scheme if any.
            '''

        })
    '''
    An alphanumeric code that can be used as a reference to extra information
    such as the description of the interlocking scheme if any.
    '''

@dataclass(repr=False)
class ConductingEquipment(Equipment):
    '''
    The parts of the AC power system that are designed to carry current or
    that are conductively connected through terminals.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    SvStatus: list[SvStatus] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvStatus.ConductingEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The status state variable associated with this conducting equipment.
            '''

        })
    '''
    The status state variable associated with this conducting equipment.
    '''

    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConductingEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conducting equipment have terminals that may be connected to other conducting
            equipment terminals via connectivity nodes or topological nodes.
            '''

        })
    '''
    Conducting equipment have terminals that may be connected to other
    conducting equipment terminals via connectivity nodes or topological
    nodes.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.ConductingEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Base voltage of this conducting equipment. Use only when there is no voltage
            level container used and only one base voltage applies. For example, not
            used for transformers.
            '''

        })
    '''
    Base voltage of this conducting equipment. Use only when there is no
    voltage level container used and only one base voltage applies. For
    example, not used for transformers.
    '''

    GroundingAction: Optional[GroundAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GroundAction.GroundedEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Action involving grounding operation on this conducting equipment.
            '''

        })
    '''
    Action involving grounding operation on this conducting equipment.
    '''

    JumpingAction: Optional[JumperAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'JumperAction.JumpedEquipments',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Jumper action involving jumping operation on this conducting equipment.
            '''

        })
    '''
    Jumper action involving jumping operation on this conducting equipment.
    '''

    Outage: Optional[Outage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Outage.OutageIsolationEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class ACDCConverter(ConductingEquipment):
    '''
    A unit with valves for three phases, together with unit control equipment,
    essential protective and switching devices, DC storage capacitors, phase
    reactors and auxiliaries, if any, used for conversion.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    DCTerminals: list[ACDCConverterDCTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACDCConverterDCTerminal.DCConductingEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A DC converter have DC converter terminals. A converter has two DC converter
            terminals.
            '''

        })
    '''
    A DC converter have DC converter terminals. A converter has two DC
    converter terminals.
    '''

    numberOfValves: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of valves in the converter. Used in loss calculations.
            '''

        })
    '''
    Number of valves in the converter. Used in loss calculations.
    '''

    baseS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Base apparent power of the converter pole. The attribute shall be a positive
            value.
            '''

        })
    '''
    Base apparent power of the converter pole. The attribute shall be a
    positive value.
    '''

    idc: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Converter DC current, also called Id. It is converter's state variable,
            result from power flow.
            '''

        })
    '''
    Converter DC current, also called Id. It is converter's state variable,
    result from power flow.
    '''

    idleLoss: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power loss in pole at no power transfer. It is the converter's configuration
            data used in power flow. The attribute shall be a positive value.
            '''

        })
    '''
    Active power loss in pole at no power transfer. It is the converter's
    configuration data used in power flow. The attribute shall be a positive
    value.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum active power limit. The value is overwritten by values of VsCapabilityCurve,
            if present.
            '''

        })
    '''
    Maximum active power limit. The value is overwritten by values of VsCapabilityCurve,
    if present.
    '''

    maxUdc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum voltage on the DC side at which the converter should operate.
            It is the converter's configuration data used in power flow. The attribute
            shall be a positive value.
            '''

        })
    '''
    The maximum voltage on the DC side at which the converter should operate.
    It is the converter's configuration data used in power flow. The attribute
    shall be a positive value.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum active power limit. The value is overwritten by values of VsCapabilityCurve,
            if present.
            '''

        })
    '''
    Minimum active power limit. The value is overwritten by values of VsCapabilityCurve,
    if present.
    '''

    minUdc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum voltage on the DC side at which the converter should operate.
            It is the converter's configuration data used in power flow. The attribute
            shall be a positive value.
            '''

        })
    '''
    The minimum voltage on the DC side at which the converter should operate.
    It is the converter's configuration data used in power flow. The attribute
    shall be a positive value.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power at the point of common coupling. Load sign convention is used,
            i.e. positive sign means flow out from a node.
            Starting value for a steady state solution in the case a simplified power
            flow model is used.
            '''

        })
    '''
    Active power at the point of common coupling. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    Starting value for a steady state solution in the case a simplified
    power flow model is used.
    '''

    poleLossP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The active power loss at a DC Pole
            = idleLoss + switchingLoss*|Idc| + resitiveLoss*Idc^2.
            For lossless operation Pdc=Pac.
            For rectifier operation with losses Pdc=Pac-lossP.
            For inverter operation with losses Pdc=Pac+lossP.
            It is converter's state variable used in power flow. The attribute shall
            be a positive value.
            '''

        })
    '''
    The active power loss at a DC Pole
    = idleLoss + switchingLoss*|Idc| + resitiveLoss*Idc^2.
    For lossless operation Pdc=Pac.
    For rectifier operation with losses Pdc=Pac-lossP.
    For inverter operation with losses Pdc=Pac+lossP.
    It is converter's state variable used in power flow. The attribute
    shall be a positive value.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power at the point of common coupling. Load sign convention is
            used, i.e. positive sign means flow out from a node.
            Starting value for a steady state solution in the case a simplified power
            flow model is used.
            '''

        })
    '''
    Reactive power at the point of common coupling. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    Starting value for a steady state solution in the case a simplified
    power flow model is used.
    '''

    ratedUdc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated converter DC voltage, also called UdN. The attribute shall be a positive
            value. It is the converter's configuration data used in power flow. For
            instance a bipolar DC link with value 200 kV has a 400kV difference between
            the dc lines.
            '''

        })
    '''
    Rated converter DC voltage, also called UdN. The attribute shall be
    a positive value. It is the converter's configuration data used in
    power flow. For instance a bipolar DC link with value 200 kV has a
    400kV difference between the dc lines.
    '''

    resistiveLoss: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            It is the converter's configuration data used in power flow. Refer to poleLossP.
            The attribute shall be a positive value.
            '''

        })
    '''
    It is the converter's configuration data used in power flow. Refer
    to poleLossP. The attribute shall be a positive value.
    '''

    switchingLoss: Optional[ float | ActivePowerPerCurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Switching losses, relative to the base apparent power 'baseS'. Refer to
            poleLossP. The attribute shall be a positive value.
            '''

        })
    '''
    Switching losses, relative to the base apparent power 'baseS'. Refer
    to poleLossP. The attribute shall be a positive value.
    '''

    targetPpcc: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Real power injection target in AC grid, at point of common coupling. Load
            sign convention is used, i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Real power injection target in AC grid, at point of common coupling.
    Load sign convention is used, i.e. positive sign means flow out from
    a node.
    '''

    targetUdc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target value for DC voltage magnitude. The attribute shall be a positive
            value.
            '''

        })
    '''
    Target value for DC voltage magnitude. The attribute shall be a positive
    value.
    '''

    uc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Line-to-line converter voltage, the voltage at the AC side of the valve.
            It is converter's state variable, result from power flow. The attribute
            shall be a positive value.
            '''

        })
    '''
    Line-to-line converter voltage, the voltage at the AC side of the valve.
    It is converter's state variable, result from power flow. The attribute
    shall be a positive value.
    '''

    udc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Converter voltage at the DC side, also called Ud. It is converter's state
            variable, result from power flow. The attribute shall be a positive value.
            '''

        })
    '''
    Converter voltage at the DC side, also called Ud. It is converter's
    state variable, result from power flow. The attribute shall be a positive
    value.
    '''

    valveU0: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Valve threshold voltage, also called Uvalve. Forward voltage drop when
            the valve is conducting. Used in loss calculations, i.e. the switchLoss
            depend on numberOfValves*valveU0.
            '''

        })
    '''
    Valve threshold voltage, also called Uvalve. Forward voltage drop when
    the valve is conducting. Used in loss calculations, i.e. the switchLoss
    depend on numberOfValves*valveU0.
    '''

    ACDCConverterController: Optional[ACDCConverterController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCConverterController.ACDCConverter',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Direct current controller which controls the ACDC converter.
            '''

        })
    '''
    Direct current controller which controls the ACDC converter.
    '''

    PccTerminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.ConverterDCSides',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Point of common coupling terminal for this converter DC side. It is typically
            the terminal on the power transformer (or switch) closest to the AC network.
            '''

        })
    '''
    Point of common coupling terminal for this converter DC side. It is
    typically the terminal on the power transformer (or switch) closest
    to the AC network.
    '''

@dataclass(repr=False)
class CsConverter(ACDCConverter):
    '''
    DC side of the current source converter (CSC).
    The firing angle controls the dc voltage at the converter, both for rectifier
    and inverter. The difference between the dc voltages of the rectifier and
    inverter determines the dc current. The extinction angle is used to limit
    the dc voltage at the inverter, if needed, and is not used in active power
    control. The firing angle, transformer tap position and number of connected
    filters are the primary means to control a current source dc line. Higher
    level controls are built on top, e.g. DC voltage, dc current and active
    power. From a steady state perspective it is sufficient to specify the
    desired active power transfer (ACDCConverter.targetPpcc) and the control
    functions will set the dc voltage, dc current, firing angle, transformer
    tap position and number of connected filters to meet this. Therefore attributes
    targetAlpha and targetGamma are not applicable in this case.
    Attributes targetAlpha and targetGamma are mutually exclusive therefore
    only one of them can be defined to describe an operating target.
    The reactive power consumed by the converter is a function of the firing
    angle, transformer tap position and number of connected filter, which can
    be approximated with half of the active power. The losses are a function
    of the dc voltage and dc current.
    The attributes minAlpha and maxAlpha define the range of firing angles
    for rectifier operation between which no discrete tap changer action takes
    place. The range is typically 10 to 18 degrees.
    The attributes minGamma and maxGamma define the range of extinction angles
    for inverter operation between which no discrete tap changer action takes
    place. The range is typically 17 to 20 degrees.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    alpha: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Firing angle that determines the DC voltage at the converter DC terminal.
            Typical value between 10 degrees and 18 degrees for a rectifier. It is
            converter's state variable, result from power flow. The attribute shall
            be a positive value.
            '''

        })
    '''
    Firing angle that determines the DC voltage at the converter DC terminal.
    Typical value between 10 degrees and 18 degrees for a rectifier. It
    is converter's state variable, result from power flow. The attribute
    shall be a positive value.
    '''

    gamma: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Extinction angle. It is used to limit the DC voltage at the inverter if
            needed. Typical value between 17 degrees and 20 degrees for an inverter.
            It is converter's state variable, result from power flow. The attribute
            shall be a positive value.
            '''

        })
    '''
    Extinction angle. It is used to limit the DC voltage at the inverter
    if needed. Typical value between 17 degrees and 20 degrees for an inverter.
    It is converter's state variable, result from power flow. The attribute
    shall be a positive value.
    '''

    maxAlpha: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum firing angle. It is the converter's configuration data used in
            power flow. The attribute shall be a positive value.
            '''

        })
    '''
    Maximum firing angle. It is the converter's configuration data used
    in power flow. The attribute shall be a positive value.
    '''

    maxGamma: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum extinction angle. It is the converter's configuration data used
            in power flow. The attribute shall be a positive value.
            '''

        })
    '''
    Maximum extinction angle. It is the converter's configuration data
    used in power flow. The attribute shall be a positive value.
    '''

    maxIdc: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum direct current (Id) on the DC side at which the converter should
            operate. It is the converter's configuration data use in power flow. The
            attribute shall be a positive value.
            '''

        })
    '''
    The maximum direct current (Id) on the DC side at which the converter
    should operate. It is the converter's configuration data use in power
    flow. The attribute shall be a positive value.
    '''

    minAlpha: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum firing angle. It is the converter's configuration data used in
            power flow. The attribute shall be a positive value.
            '''

        })
    '''
    Minimum firing angle. It is the converter's configuration data used
    in power flow. The attribute shall be a positive value.
    '''

    minGamma: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum extinction angle. It is the converter's configuration data used
            in power flow. The attribute shall be a positive value.
            '''

        })
    '''
    Minimum extinction angle. It is the converter's configuration data
    used in power flow. The attribute shall be a positive value.
    '''

    minIdc: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum direct current (Id) on the DC side at which the converter should
            operate. It is the converter's configuration data used in power flow. The
            attribute shall be a positive value.
            '''

        })
    '''
    The minimum direct current (Id) on the DC side at which the converter
    should operate. It is the converter's configuration data used in power
    flow. The attribute shall be a positive value.
    '''

    ratedIdc: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated converter DC current, also called IdN. The attribute shall be a positive
            value. It is the converter's configuration data used in power flow.
            '''

        })
    '''
    Rated converter DC current, also called IdN. The attribute shall be
    a positive value. It is the converter's configuration data used in
    power flow.
    '''

    targetAlpha: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target firing angle. It is converter's control variable used in power flow.
            It is only applicable for rectifier control. Allowed values are within
            the range minAlpha&lt;=targetAlpha&lt;=maxAlpha. The attribute shall be
            a positive value.
            '''

        })
    '''
    Target firing angle. It is converter's control variable used in power
    flow. It is only applicable for rectifier control. Allowed values are
    within the range minAlpha&lt;=targetAlpha&lt;=maxAlpha. The attribute
    shall be a positive value.
    '''

    targetGamma: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Target extinction angle. It is converter's control variable used in power
            flow. It is only applicable for inverter control. Allowed values are within
            the range minGamma&lt;=targetGamma&lt;=maxGamma. The attribute shall be
            a positive value.
            '''

        })
    '''
    Target extinction angle. It is converter's control variable used in
    power flow. It is only applicable for inverter control. Allowed values
    are within the range minGamma&lt;=targetGamma&lt;=maxGamma. The attribute
    shall be a positive value.
    '''

    targetIdc: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DC current target value. It is converter's control variable used in power
            flow. The attribute shall be a positive value.
            '''

        })
    '''
    DC current target value. It is converter's control variable used in
    power flow. The attribute shall be a positive value.
    '''

    operatingMode: Optional[CsOperatingModeKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates whether the DC pole is operating as an inverter or as a rectifier.
            It is converter's control variable used in power flow.
            '''

        })
    '''
    Indicates whether the DC pole is operating as an inverter or as a rectifier.
    It is converter's control variable used in power flow.
    '''

    pPccControl: Optional[CsPpccControlKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of active power control.
            '''

        })
    '''
    Kind of active power control.
    '''

    CSCDynamics: Optional[CSCDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CSCDynamics.CSConverter',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Current source converter dynamics model used to describe dynamic behaviour
            of this converter.
            '''

        })
    '''
    Current source converter dynamics model used to describe dynamic behaviour
    of this converter.
    '''

@dataclass(repr=False)
class VsConverter(ACDCConverter):
    '''
    DC side of the voltage source converter (VSC).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'DC'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    CapabilityCurve: list[VsCapabilityCurve] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VsCapabilityCurve.VsConverter',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Capability curve of this converter.
            '''

        })
    '''
    Capability curve of this converter.
    '''

    maxModulationIndex: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum quotient between the AC converter voltage (Uc) and DC voltage
            (Ud). A factor typically less than 1. It is converter's configuration data
            used in power flow.
            '''

        })
    '''
    The maximum quotient between the AC converter voltage (Uc) and DC voltage
    (Ud). A factor typically less than 1. It is converter's configuration
    data used in power flow.
    '''

    targetPowerFactorPcc: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power factor target at the AC side, at point of common coupling. The attribute
            shall be a positive value.
            '''

        })
    '''
    Power factor target at the AC side, at point of common coupling. The
    attribute shall be a positive value.
    '''

    targetPWMfactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Magnitude of pulse-modulation factor. The attribute shall be a positive
            value.
            '''

        })
    '''
    Magnitude of pulse-modulation factor. The attribute shall be a positive
    value.
    '''

    delta: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Angle between VsConverter.uv and ACDCConverter.uc. It is converter's state
            variable used in power flow. The attribute shall be a positive value or
            zero.
            '''

        })
    '''
    Angle between VsConverter.uv and ACDCConverter.uc. It is converter's
    state variable used in power flow. The attribute shall be a positive
    value or zero.
    '''

    droop: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Droop constant. The pu value is obtained as D [kV/MW] * Sb / Ubdc. The
            attribute shall be a positive value.
            '''

        })
    '''
    Droop constant. The pu value is obtained as D [kV/MW] * Sb / Ubdc.
    The attribute shall be a positive value.
    '''

    droopCompensation: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Compensation constant. Used to compensate for voltage drop when controlling
            voltage at a distant bus. The attribute shall be a positive value.
            '''

        })
    '''
    Compensation constant. Used to compensate for voltage drop when controlling
    voltage at a distant bus. The attribute shall be a positive value.
    '''

    maxValveCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum current through a valve. It is converter's configuration data.
            '''

        })
    '''
    The maximum current through a valve. It is converter's configuration
    data.
    '''

    qShare: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power sharing factor among parallel converters on Uac control.
            The attribute shall be a positive value or zero.
            '''

        })
    '''
    Reactive power sharing factor among parallel converters on Uac control.
    The attribute shall be a positive value or zero.
    '''

    targetPhasePcc: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase target at AC side, at point of common coupling. The attribute shall
            be a positive value.
            '''

        })
    '''
    Phase target at AC side, at point of common coupling. The attribute
    shall be a positive value.
    '''

    targetQpcc: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power injection target in AC grid, at point of common coupling.
            Load sign convention is used, i.e. positive sign means flow out from a
            node.
            '''

        })
    '''
    Reactive power injection target in AC grid, at point of common coupling.
    Load sign convention is used, i.e. positive sign means flow out from
    a node.
    '''

    targetUpcc: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Voltage target in AC grid, at point of common coupling. The attribute shall
            be a positive value.
            '''

        })
    '''
    Voltage target in AC grid, at point of common coupling. The attribute
    shall be a positive value.
    '''

    uv: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Line-to-line voltage on the valve side of the converter transformer. It
            is converter's state variable, result from power flow. The attribute shall
            be a positive value.
            '''

        })
    '''
    Line-to-line voltage on the valve side of the converter transformer.
    It is converter's state variable, result from power flow. The attribute
    shall be a positive value.
    '''

    pPccControl: Optional[VsPpccControlKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of control of real power and/or DC voltage.
            '''

        })
    '''
    Kind of control of real power and/or DC voltage.
    '''

    qPccControl: Optional[VsQpccControlKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of reactive power control.
            '''

        })
    '''
    Kind of reactive power control.
    '''

    VSCDynamics: Optional[VSCDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VSCDynamics.VsConverter',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Voltage source converter dynamics model used to describe dynamic behaviour
            of this converter.
            '''

        })
    '''
    Voltage source converter dynamics model used to describe dynamic behaviour
    of this converter.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Clamp(ConductingEquipment):
    '''
    A Clamp is a galvanic connection at a line segment where other equipment
    is connected. A Clamp does not cut the line segment.
    A Clamp is ConductingEquipment and has one Terminal with an associated
    ConnectivityNode. Any other ConductingEquipment can be connected to the
    Clamp ConnectivityNode.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The length to the place where the clamp is located starting from side one
            of the line segment, i.e. the line segment terminal with sequence number
            equal to 1.
            '''

        })
    '''
    The length to the place where the clamp is located starting from side
    one of the line segment, i.e. the line segment terminal with sequence
    number equal to 1.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.Clamp',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line segment to which the clamp is connected.
            '''

        })
    '''
    The line segment to which the clamp is connected.
    '''

    ClampAction: Optional[ClampAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ClampAction.Clamp',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    JumperAction: Optional[JumperAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'JumperAction.Clamp',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Conductor(ConductingEquipment):
    '''
    Combination of conducting material with consistent electrical characteristics,
    building a single electrical system, used to carry current between points
    in the power system.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    length: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Segment length for calculating line segment capabilities.
            '''

        })
    '''
    Segment length for calculating line segment capabilities.
    '''

    DamageCurve: Optional[ConductorCharacteristicCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConductorCharacteristicCurve.Conductor',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Damage curve associated to a conductor.
            '''

        })
    '''
    Damage curve associated to a conductor.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ACLineSegment(Conductor):
    '''
    A line segment is a conductor or combination of conductors, with consistent
    electrical characteristics along its length, building a single electrical
    system that carries alternating current between two points in the power
    system.
    The BaseVoltage at the two ends of a line segment shall have the same BaseVoltage.nominalVoltage.
    However, boundary lines may have slightly different BaseVoltage.nominalVoltages
    and variation is allowed. Larger voltage difference in general requires
    use of an equivalent branch.
    Line segment impedances can be either directly described in electrical
    terms or physical line detail can be provided from which impedances can
    be calculated.
    <b>Directly described impedances</b>
    For symmetrical, transposed three phase line segments, it is sufficient
    to use attributes of the line segment, which describe impedances and admittances
    for the entire length of the line segment. Additionally, line segment impedances
    can be computed by using line segment length and associated per length
    impedances.
    Unbalanced modeling of impedances is supported by the per length phase
    impedance matrix (PerLengthPhaseImpedance) in conjunction with phase-to-sequence
    number mapping supplied by either ACLineSegmentPhase or WirePosition. The
    sequence numbers are referenced by the row and column attributes of the
    per length phase impedance matrix. This method enables single-phase and
    two-phase line segments, and transpositions of phases, to be described
    using the same per length phase impedance matrix. The length of the line
    segment is used in the computation of total impedance values for the line
    segment.
    <b>Line detail characteristics</b>
    There are three approaches to providing line detail and all use WireAssembly
    to supply line positions:
    <ul>
    <li>Option 1 - WireAssembly supplies only line positions. ACLineSegmentPhase
    points to wire type and intraphase spacing and supplies the phase-to-sequence
    number mapping.</li>
    <li>Option 2 - WireAssembly supplies line position and, for each position,
    also supplies wire type and intraphase spacing. ACLineSegmentPhase supplies
    the phase-to-sequence number mapping.</li>
    <li>Option 3 - WireAssembly supplies line position and, for each position,
    also supplies wire type and intraphase spacing and phase. WireAssembly
    therefore supplies the phase-to-sequence number mapping and ACLineSegmentPhase
    is not needed.</li>
    </ul>
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ACLineSegmentPhases: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.ACLineSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line segment phases which belong to the line segment.
            '''

        })
    '''
    The line segment phases which belong to the line segment.
    '''

    Clamp: list[Clamp] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Clamp.ACLineSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The clamps connected to the line segment.
            '''

        })
    '''
    The clamps connected to the line segment.
    '''

    Cut: list[Cut] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Cut.ACLineSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Cuts applied to the line segment.
            '''

        })
    '''
    Cuts applied to the line segment.
    '''

    LineSegmentCoupling: Optional[LineSegmentCoupling] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LineSegmentCoupling.ACLineSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The description of this line's coupling with other lines in a coupled group.
            '''

        })
    '''
    The description of this line's coupling with other lines in a coupled
    group.
    '''

    b0ch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance, uniformly distributed, of the
            entire line segment.
            '''

        })
    '''
    Zero sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line segment.
    '''

    bch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance, uniformly distributed,
            of the entire line segment. This value represents the full charging over
            the full length of the line segment.
            '''

        })
    '''
    Positive sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line segment. This value represents the full charging
    over the full length of the line segment.
    '''

    g0ch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence shunt (charging) conductance, uniformly distributed, of the
            entire line segment.
            '''

        })
    '''
    Zero sequence shunt (charging) conductance, uniformly distributed,
    of the entire line segment.
    '''

    gch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance, uniformly distributed,
            of the entire line segment.
            '''

        })
    '''
    Positive sequence shunt (charging) conductance, uniformly distributed,
    of the entire line segment.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence series resistance of the entire line segment.
            '''

        })
    '''
    Positive sequence series resistance of the entire line segment.
    '''

    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence series resistance of the entire line segment.
            '''

        })
    '''
    Zero sequence series resistance of the entire line segment.
    '''

    shortCircuitEndTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum permitted temperature at the end of SC for the calculation of minimum
            short-circuit currents. Used for short circuit data exchange according
            to IEC 60909.
            '''

        })
    '''
    Maximum permitted temperature at the end of SC for the calculation
    of minimum short-circuit currents. Used for short circuit data exchange
    according to IEC 60909.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence series reactance of the entire line segment.
            '''

        })
    '''
    Positive sequence series reactance of the entire line segment.
    '''

    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence series reactance of the entire line segment.
            '''

        })
    '''
    Zero sequence series reactance of the entire line segment.
    '''

    LineGroundingAction: Optional[GroundAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GroundAction.AlongACLineSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Ground action involving clamp usage (for the case when the ground is applied
            along the line segment instead of at its terminals).
            '''

        })
    '''
    Ground action involving clamp usage (for the case when the ground is
    applied along the line segment instead of at its terminals).
    '''

    LineJumpingAction: Optional[JumperAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'JumperAction.ACLineSegments',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Jumper action involving clamp usage (for the case when the jumper is applied
            along the line segment instead of at its terminals).
            '''

        })
    '''
    Jumper action involving clamp usage (for the case when the jumper is
    applied along the line segment instead of at its terminals).
    '''

    LineSegmentCoupling: Optional[LineSegmentCoupling] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LineSegmentCoupling.ACLineSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The description of this line's coupling with other lines in a coupled group.
            '''

        })
    '''
    The description of this line's coupling with other lines in a coupled
    group.
    '''

    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthImpedance.ACLineSegments',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Per-length impedance of this line segment.
            '''

        })
    '''
    Per-length impedance of this line segment.
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IntraphaseSpacing.ACLineSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class BusSegment(Conductor):
    '''
    A segment of bus conductor between connections to breaker strings, line
    bays, etc
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Assets'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Retain: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            True if retain
            '''

        })
    '''
    True if retain
    '''

    retained: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Bus segment is retained in the topological solution. The flow through retained
            bus sections will normally be calculated in power flow.
            '''

        })
    '''
    Bus segment is retained in the topological solution. The flow through
    retained bus sections will normally be calculated in power flow.
    '''

@dataclass(repr=False)
class WireSegment(Conductor):
    '''
    A two terminal and power conducting device of negligible impedance and
    length represented as zero impedance device that can be used to connect
    auxiliary equipment to its terminals.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    WireSegmentPhases: list[WireSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireSegmentPhase.WireSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The wire segment phases which belong to the wire segment.
            '''

        })
    '''
    The wire segment phases which belong to the wire segment.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Connector(ConductingEquipment):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation and are
    modelled with a single logical terminal.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BusbarSection(Connector):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation. The BusbarSection
    class is intended to represent physical parts of bus bars no matter how
    that bus bar is constructed.
    Voltage measurements are typically obtained from voltage transformers that
    are connected to busbar sections. A bus bar section may have many physical
    terminals but for analysis is modelled with exactly one logical terminal.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    VoltageControlZone: Optional[VoltageControlZone] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VoltageControlZone.BusbarSection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A VoltageControlZone is controlled by a designated BusbarSection.
            '''

        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''

    ipMax: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum allowable peak short-circuit current of busbar (Ipmax in IEC 60909-0).
            Mechanical limit of the busbar in the substation itself. Used for short
            circuit data exchange according to IEC 60909.
            '''

        })
    '''
    Maximum allowable peak short-circuit current of busbar (Ipmax in IEC
    60909-0).
    Mechanical limit of the busbar in the substation itself. Used for short
    circuit data exchange according to IEC 60909.
    '''

    VoltageControlZone: Optional[VoltageControlZone] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VoltageControlZone.BusbarSection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A VoltageControlZone is controlled by a designated BusbarSection.
            '''

        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''

@dataclass(repr=False)
class Junction(Connector):
    '''
    A point where one or more conducting equipments are connected with zero
    resistance.
    The Junction class is intended to provide a place to associate additional
    information to a connectivity node which connects two or more equipment
    terminals. Examples include a tee-point or the connection point between
    two switches.
    The Junction class is intended to provide a method to associate additional
    information, for instance Location, to a ConnectivityNode. Examples include
    a T-point or the connection point between two switches. Typically, BusbarSection
    objects and Junction objects are represented by different symbols on diagrams.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class EarthFaultCompensator(ConductingEquipment):
    '''
    A conducting equipment used to represent a connection to ground which is
    typically used to compensate earth faults. An earth fault compensator device
    modelled with a single terminal implies a second terminal solidly connected
    to ground. If two terminals are modelled, the ground is not assumed and
    normal connection rules apply.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nominal resistance of device.
            '''

        })
    '''
    Nominal resistance of device.
    '''

@dataclass(repr=False)
class GroundingImpedance(EarthFaultCompensator):
    '''
    A fixed impedance device used for grounding.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactance of device.
            '''

        })
    '''
    Reactance of device.
    '''

@dataclass(repr=False)
class PetersenCoil(EarthFaultCompensator):
    '''
    A variable impedance device normally used to offset line charging during
    single line faults in an ungrounded section of network.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    nominalU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The nominal voltage for which the coil is designed.
            '''

        })
    '''
    The nominal voltage for which the coil is designed.
    '''

    offsetCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The offset current that the Petersen coil controller is operating from
            the resonant point. This is normally a fixed amount for which the controller
            is configured and could be positive or negative. Typically 0 to 60 A depending
            on voltage and resonance conditions.
            '''

        })
    '''
    The offset current that the Petersen coil controller is operating from
    the resonant point. This is normally a fixed amount for which the controller
    is configured and could be positive or negative. Typically 0 to 60
    A depending on voltage and resonance conditions.
    '''

    positionCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The control current used to control the Petersen coil also known as the
            position current. Typically in the range of 20 mA to 200 mA.
            '''

        })
    '''
    The control current used to control the Petersen coil also known as
    the position current. Typically in the range of 20 mA to 200 mA.
    '''

    xGroundMax: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum reactance.
            '''

        })
    '''
    The maximum reactance.
    '''

    xGroundMin: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum reactance.
            '''

        })
    '''
    The minimum reactance.
    '''

    xGroundNominal: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The nominal reactance. This is the operating point (normally over compensation)
            that is defined based on the resonance point in the healthy network condition.
            The impedance is calculated based on nominal voltage divided by position
            current.
            '''

        })
    '''
    The nominal reactance. This is the operating point (normally over compensation)
    that is defined based on the resonance point in the healthy network
    condition. The impedance is calculated based on nominal voltage divided
    by position current.
    '''

    mode: Optional[PetersenCoilModeKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The mode of operation of the Petersen coil.
            '''

        })
    '''
    The mode of operation of the Petersen coil.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class EnergyConnection(ConductingEquipment):
    '''
    A connection of energy generation or consumption on the power system model.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class EnergyConsumer(EnergyConnection):
    '''
    Generic user of energy - a point of consumption on the power system model.
    EnergyConsumer.pfixed, .qfixed, .pfixedPct and .qfixedPct have meaning
    only if there is no LoadResponseCharacteristic associated with EnergyConsumer
    or if LoadResponseCharacteristic.exponentModel is set to False.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    EnergyConsumerPhase: list[EnergyConsumerPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumerPhase.EnergyConsumer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The individual phase models for this energy consumer.
            '''

        })
    '''
    The individual phase models for this energy consumer.
    '''

    customerCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of individual customers represented by this demand.
            '''

        })
    '''
    Number of individual customers represented by this demand.
    '''

    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Required for Yn and I connections (as represented by EnergyConsumer.phaseConnection).
            True if the neutral is solidly grounded.
            '''

        })
    '''
    Required for Yn and I connections (as represented by EnergyConsumer.phaseConnection).
    True if the neutral is solidly grounded.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power of the load. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''

        })
    '''
    Active power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    pfixed: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power of the load that is a fixed quantity and does not vary as
            load group value varies. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            '''

        })
    '''
    Active power of the load that is a fixed quantity and does not vary
    as load group value varies. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    '''

    pfixedPct: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fixed active power as a percentage of load group fixed active power. Used
            to represent the time-varying components. Load sign convention is used,
            i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Fixed active power as a percentage of load group fixed active power.
    Used to represent the time-varying components. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power of the load. Load sign convention is used, i.e. positive
            sign means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''

        })
    '''
    Reactive power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    qfixed: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power of the load that is a fixed quantity and does not vary as
            load group value varies. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            '''

        })
    '''
    Reactive power of the load that is a fixed quantity and does not vary
    as load group value varies. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    '''

    qfixedPct: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Fixed reactive power as a percentage of load group fixed reactive power.
            Used to represent the time-varying components. Load sign convention is
            used, i.e. positive sign means flow out from a node.
            '''

        })
    '''
    Fixed reactive power as a percentage of load group fixed reactive power.
    Used to represent the time-varying components. Load sign convention
    is used, i.e. positive sign means flow out from a node.
    '''

    phaseConnection: Optional[PhaseShuntConnectionKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of phase connection, such as wye or delta.
            '''

        })
    '''
    The type of phase connection, such as wye or delta.
    '''

    EnergyConsumerAction: Optional[EnergyConsumerAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumerAction.EnergyConsumer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    LoadDynamics: Optional[LoadDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LoadDynamics.EnergyConsumer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Load dynamics model used to describe dynamic behaviour of this energy consumer.
            '''

        })
    '''
    Load dynamics model used to describe dynamic behaviour of this energy
    consumer.
    '''

    LoadResponse: Optional[LoadResponseCharacteristic] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LoadResponseCharacteristic.EnergyConsumer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The load response characteristic of this load. If missing, this load is
            assumed to be constant power.
            '''

        })
    '''
    The load response characteristic of this load. If missing, this load
    is assumed to be constant power.
    '''

    PowerCutZone: Optional[PowerCutZone] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerCutZone.EnergyConsumers',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The energy consumer is assigned to this power cut zone.
            '''

        })
    '''
    The energy consumer is assigned to this power cut zone.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ConformLoad(EnergyConsumer):
    '''
    ConformLoad represents loads that follow a daily load change pattern where
    the pattern can be used to scale the load with a system load.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    LoadGroup: Optional[ConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConformLoadGroup.EnergyConsumers',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Group of this ConformLoad.
            '''

        })
    '''
    Group of this ConformLoad.
    '''

@dataclass(repr=False)
class NonConformLoad(EnergyConsumer):
    '''
    NonConformLoad represents loads that do not follow a daily load change
    pattern and whose changes are not correlated with the daily load change
    pattern.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    LoadGroup: Optional[NonConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NonConformLoadGroup.EnergyConsumers',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Group of this ConformLoad.
            '''

        })
    '''
    Group of this ConformLoad.
    '''

@dataclass(repr=False)
class StationSupply(EnergyConsumer):
    '''
    Station supply with load derived from the station output.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class EnergySource(EnergyConnection):
    '''
    A generic equivalent for an energy supplier on a transmission or distribution
    voltage level.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    EnergySourcePhase: list[EnergySourcePhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergySourcePhase.EnergySource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The individual phase information of the energy source.
            '''

        })
    '''
    The individual phase information of the energy source.
    '''

    activePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            High voltage source active injection. Load sign convention is used, i.e.
            positive sign means flow out from a node.
            Starting value for steady state solutions.
            '''

        })
    '''
    High voltage source active injection. Load sign convention is used,
    i.e. positive sign means flow out from a node.
    Starting value for steady state solutions.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase-to-phase nominal voltage.
            '''

        })
    '''
    Phase-to-phase nominal voltage.
    '''

    pMax: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This is the maximum active power that can be produced by the source. Load
            sign convention is used, i.e. positive sign means flow out from a TopologicalNode
            (bus) into the conducting equipment.
            '''

        })
    '''
    This is the maximum active power that can be produced by the source.
    Load sign convention is used, i.e. positive sign means flow out from
    a TopologicalNode (bus) into the conducting equipment.
    '''

    pMin: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This is the minimum active power that can be produced by the source. Load
            sign convention is used, i.e. positive sign means flow out from a TopologicalNode
            (bus) into the conducting equipment.
            '''

        })
    '''
    This is the minimum active power that can be produced by the source.
    Load sign convention is used, i.e. positive sign means flow out from
    a TopologicalNode (bus) into the conducting equipment.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence Thevenin resistance.
            '''

        })
    '''
    Positive sequence Thevenin resistance.
    '''

    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence Thevenin resistance.
            '''

        })
    '''
    Zero sequence Thevenin resistance.
    '''

    r2: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Negative sequence Thevenin resistance.
            '''

        })
    '''
    Negative sequence Thevenin resistance.
    '''

    reactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            High voltage source reactive injection. Load sign convention is used, i.e.
            positive sign means flow out from a node.
            Starting value for steady state solutions.
            '''

        })
    '''
    High voltage source reactive injection. Load sign convention is used,
    i.e. positive sign means flow out from a node.
    Starting value for steady state solutions.
    '''

    voltageAngle: Optional[ float | AngleRadians ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase angle of a-phase open circuit used when voltage characteristics need
            to be imposed at the node associated with the terminal of the energy source,
            such as when voltages and angles from the transmission level are used as
            input to the distribution network. The attribute shall be a positive value
            or zero.
            '''

        })
    '''
    Phase angle of a-phase open circuit used when voltage characteristics
    need to be imposed at the node associated with the terminal of the
    energy source, such as when voltages and angles from the transmission
    level are used as input to the distribution network. The attribute
    shall be a positive value or zero.
    '''

    voltageMagnitude: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase-to-phase open circuit voltage magnitude used when voltage characteristics
            need to be imposed at the node associated with the terminal of the energy
            source, such as when voltages and angles from the transmission level are
            used as input to the distribution network. The attribute shall be a positive
            value or zero.
            '''

        })
    '''
    Phase-to-phase open circuit voltage magnitude used when voltage characteristics
    need to be imposed at the node associated with the terminal of the
    energy source, such as when voltages and angles from the transmission
    level are used as input to the distribution network. The attribute
    shall be a positive value or zero.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence Thevenin reactance.
            '''

        })
    '''
    Positive sequence Thevenin reactance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence Thevenin reactance.
            '''

        })
    '''
    Zero sequence Thevenin reactance.
    '''

    x2: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Negative sequence Thevenin reactance.
            '''

        })
    '''
    Negative sequence Thevenin reactance.
    '''

    EnergySchedulingType: Optional[EnergySchedulingType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergySchedulingType.EnergySource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Energy Scheduling Type of an Energy Source.
            '''

        })
    '''
    Energy Scheduling Type of an Energy Source.
    '''

    EnergySourceAction: Optional[EnergySourceAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergySourceAction.EnergySource',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Action taken with this energy source.
            '''

        })
    '''
    Action taken with this energy source.
    '''

@dataclass(repr=False)
class RegulatingCondEq(EnergyConnection):
    '''
    A type of conducting equipment that can regulate a quantity (i.e. voltage
    or flow) at a specific point in the network.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    controlEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the regulation status of the equipment. True is regulating, false
            is not regulating.
            '''

        })
    '''
    Specifies the regulation status of the equipment. True is regulating,
    false is not regulating.
    '''

    EquipmentController: Optional[EquipmentController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EquipmentController.RegulatingCondEq',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The equipment controller for this regulating conducting equipment.
            '''

        })
    '''
    The equipment controller for this regulating conducting equipment.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegulatingControl.RegulatingCondEq',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The regulating control scheme in which this equipment participates.
            '''

        })
    '''
    The regulating control scheme in which this equipment participates.
    '''

@dataclass(repr=False)
class ExternalNetworkInjection(RegulatingCondEq):
    '''
    This class represents the external network for use in power flow and short-circuit
    calculations.
    In the power flow domain the external network is modelled as a power injection
    with power limits and a power-frequency bias. For short-circuit calculations
    the external network is modelled as the �network feeders� element defined
    in section 6.2 of IEC60909-0:2016. Boolean flag ikSecond allows short-circuit
    calculations using the superposition method to detect that the maximum
    and minimum initial symmetrical short-circuit currents have to be corrected
    for the fact that they were calculated according the IEC60909-0 method.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ikSecond: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates whether the maximum and minimum initial symmetrical short-circuit
            currents (Ik� max and Ik� min) have been calculated according to the IEC
            60909-0 method. Is only used in short-circuit calculations done according
            to the superposition method.
            '''

        })
    '''
    Indicates whether the maximum and minimum initial symmetrical short-circuit
    currents (Ik� max and Ik� min) have been calculated according to the
    IEC 60909-0 method. Is only used in short-circuit calculations done
    according to the superposition method.
    '''

    maxR0ToX0Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum ratio of zero sequence resistance to zero sequence reactance (R(0)/X(0)
            max). R0 and X0 are the real and imaginary parts of the zero sequence short-circuit
            impedance Z0 defined in clause 3.19.3 of IEC 60909-0:2016.
            '''

        })
    '''
    Maximum ratio of zero sequence resistance to zero sequence reactance
    (R(0)/X(0) max). R0 and X0 are the real and imaginary parts of the
    zero sequence short-circuit impedance Z0 defined in clause 3.19.3 of
    IEC 60909-0:2016.
    '''

    maxR1ToX1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum ratio of positive sequence resistance to positive sequence reactance
            (R(1)/X(1) max). R1 and X1 are the real and imaginary parts of the positive
            sequence short-circuit impedance Z1 defined in clause 3.19.1 of IEC 60909-0:2016.
            '''

        })
    '''
    Maximum ratio of positive sequence resistance to positive sequence
    reactance (R(1)/X(1) max). R1 and X1 are the real and imaginary parts
    of the positive sequence short-circuit impedance Z1 defined in clause
    3.19.1 of IEC 60909-0:2016.
    '''

    maxZ0ToZ1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum ratio of zero sequence impedance to its positive sequence impedance
            (Z(0)/Z(1) max). Z0 is the zero sequence short-circuit impedance defined
            in clause 3.19.3 of IEC 60909-0:2016. Z1 is the positive sequence short-circuit
            impedance defined in clause 3.19.1 of IEC 60909-0:2016.
            '''

        })
    '''
    Maximum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) max). Z0 is the zero sequence short-circuit impedance defined
    in clause 3.19.3 of IEC 60909-0:2016. Z1 is the positive sequence short-circuit
    impedance defined in clause 3.19.1 of IEC 60909-0:2016.
    '''

    minR0ToX0Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum ratio of zero sequence resistance to zero sequence reactance (R(0)/X(0)
            min). R0 and X0 are the real and imaginary parts of the zero sequence short-circuit
            impedance Z0 defined in clause 3.19.3 of IEC 60909-0:2016.
            '''

        })
    '''
    Minimum ratio of zero sequence resistance to zero sequence reactance
    (R(0)/X(0) min). R0 and X0 are the real and imaginary parts of the
    zero sequence short-circuit impedance Z0 defined in clause 3.19.3 of
    IEC 60909-0:2016.
    '''

    minR1ToX1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum ratio of positive sequence resistance to positive sequence reactance
            (R(1)/X(1) min). R1 and X1 are the real and imaginary parts of the positive
            sequence short-circuit impedance Z1 defined in clause 3.19.1 of IEC 60909-0:2016.
            '''

        })
    '''
    Minimum ratio of positive sequence resistance to positive sequence
    reactance (R(1)/X(1) min). R1 and X1 are the real and imaginary parts
    of the positive sequence short-circuit impedance Z1 defined in clause
    3.19.1 of IEC 60909-0:2016.
    '''

    minZ0ToZ1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum ratio of zero sequence impedance to its positive sequence impedance
            (Z(0)/Z(1) min). Z0 is the zero sequence short-circuit impedance defined
            in clause 3.19.3 of IEC 60909-0:2016. Z1 is the positive sequence short-circuit
            impedance defined in clause 3.19.1 of IEC 60909-0:2016.
            '''

        })
    '''
    Minimum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) min). Z0 is the zero sequence short-circuit impedance defined
    in clause 3.19.3 of IEC 60909-0:2016. Z1 is the positive sequence short-circuit
    impedance defined in clause 3.19.1 of IEC 60909-0:2016.
    '''

    referencePriority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Priority of unit for use as powerflow voltage phase angle reference bus
            selection. 0 = don t care (default) 1 = highest priority. 2 is less than
            1 and so on.
            '''

        })
    '''
    Priority of unit for use as powerflow voltage phase angle reference
    bus selection. 0 = don t care (default) 1 = highest priority. 2 is
    less than 1 and so on.
    '''

    governorSCD: Optional[ float | ActivePowerPerFrequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power Frequency Bias. This is the change in power injection divided by
            the change in frequency and negated. A positive value of the power frequency
            bias provides additional power injection upon a drop in frequency.
            '''

        })
    '''
    Power Frequency Bias. This is the change in power injection divided
    by the change in frequency and negated. A positive value of the power
    frequency bias provides additional power injection upon a drop in frequency.
    '''

    maxInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum initial symmetrical short-circuit current (Ik" max) in A. Ik� is
            defined in clause 3.5 of IEC 60909-0:2016.
            '''

        })
    '''
    Maximum initial symmetrical short-circuit current (Ik" max) in A. Ik�
    is defined in clause 3.5 of IEC 60909-0:2016.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum active power of the injection.
            '''

        })
    '''
    Maximum active power of the injection.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum reactive power of the injection. Used for modelling of infeed for
            load flow exchange. Not used for short-circuit modelling.
            '''

        })
    '''
    Maximum reactive power of the injection. Used for modelling of infeed
    for load flow exchange. Not used for short-circuit modelling.
    '''

    minInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum initial symmetrical short-circuit current (Ik" min) in A. Ik� is
            defined in clause 3.5 of IEC 60909-0:2016.
            '''

        })
    '''
    Minimum initial symmetrical short-circuit current (Ik" min) in A. Ik�
    is defined in clause 3.5 of IEC 60909-0:2016.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum active power of the injection.
            '''

        })
    '''
    Minimum active power of the injection.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum reactive power of the injection. Used for modelling of infeed for
            load flow exchange. Not used for short-circuit modelling.
            '''

        })
    '''
    Minimum reactive power of the injection. Used for modelling of infeed
    for load flow exchange. Not used for short-circuit modelling.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for steady state solutions.
            '''

        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for steady state solutions.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for steady state solutions.
            '''

        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for steady state solutions.
    '''

    voltageFactor: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Voltage factor (c) in pu which has been used to calculate the maximum and
            minimum initial symmetrical short-circuit currents (Ik� max and Ik� min).
            Is only used in short-circuit calculations done according to the superposition
            method. The voltage factor is defined in clause 3.15 of IEC 60909-0:2016.
            '''

        })
    '''
    Voltage factor (c) in pu which has been used to calculate the maximum
    and minimum initial symmetrical short-circuit currents (Ik� max and
    Ik� min). Is only used in short-circuit calculations done according
    to the superposition method. The voltage factor is defined in clause
    3.15 of IEC 60909-0:2016.
    '''

@dataclass(repr=False)
class FACTSEquipment(RegulatingCondEq):
    '''
    Flexible Alternating Current Transmission System regulating equipment.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'FACTS'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    LossCurve: list[LossCurve] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LossCurve.FACTSEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The loss curve for the FACTS equipment.
            '''

        })
    '''
    The loss curve for the FACTS equipment.
    '''

    maxC: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Capacitive reactance at maximum reactive power. Shall always be positive.
            '''

        })
    '''
    Capacitive reactance at maximum reactive power. Shall always be positive.
    '''

    maxL: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Inductive rating at maximum inductive reactive power. Shall always be negative.
            '''

        })
    '''
    Inductive rating at maximum inductive reactive power. Shall always
    be negative.
    '''

    minC: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Capacitive reactance at minimum reactive power. Shall always be positive.
            '''

        })
    '''
    Capacitive reactance at minimum reactive power. Shall always be positive.
    '''

    minL: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Inductive rating at minimum inductive reactive power. Shall always be negative.
            '''

        })
    '''
    Inductive rating at minimum inductive reactive power. Shall always
    be negative.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''

        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''

    ratedC: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Capacitive reactance at maximum reactive power. Shall always be positive.
            '''

        })
    '''
    Capacitive reactance at maximum reactive power. Shall always be positive.
    '''

    ratedI: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated current of the FACTS equipment.
            '''

        })
    '''
    Rated current of the FACTS equipment.
    '''

    ratedL: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Inductive rating at maximum inductive reactive power. Shall always be negative.
            '''

        })
    '''
    Inductive rating at maximum inductive reactive power. Shall always
    be negative.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage of the FACTS equipment.
            '''

        })
    '''
    Rated voltage of the FACTS equipment.
    '''

    slope: Optional[ float | VoltagePerReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The characteristics slope which defines how the reactive power output changes
            in proportion to the difference between the regulated bus voltage and the
            voltage setpoint.
            The attribute shall be a positive value or zero.
            '''

        })
    '''
    The characteristics slope which defines how the reactive power output
    changes in proportion to the difference between the regulated bus voltage
    and the voltage setpoint.
    The attribute shall be a positive value or zero.
    '''

@dataclass(repr=False)
class ModularStaticSynchronousSeriesCompensator(FACTSEquipment):
    '''
    Modular static synchronous series compensator (MSSSC) is a type of flexible
    AC transmission system regulating equipment which consists of solid-state
    voltage source inverter connected in series with a transmission line. This
    is similar to static synchronous series compensator (SSSC), but without
    injection transformer. This enables the MSSSC to be truly modular with
    the ability to simply install a number of equipment in series to provide
    a desired maximum level of impedance. MSSSC can be dispersed into multiple
    location in a circuit working collectively under the same controller scheme.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'FACTS'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class StaticSynchronousCompensator(FACTSEquipment):
    '''
    Static synchronous compensator (STATCOM), also known as a static synchronous
    condenser (STATCON), is a type of flexible AC transmission system regulating
    equipment used on alternating current electricity transmission networks.
    It is based on a power electronics voltage-source converter and can act
    as either a source or sink of reactive AC power to an electricity network.
    If connected to a source of power it can also provide active AC power.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'FACTS'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class StaticVarCompensator(FACTSEquipment):
    '''
    A facility for providing variable and controllable shunt reactive power.
    The SVC typically consists of a stepdown transformer, filter, thyristor-controlled
    reactor, and thyristor-switched capacitor arms.
    The SVC may operate in fixed MVar output mode or in voltage control mode.
    When in voltage control mode, the output of the SVC will be proportional
    to the deviation of voltage at the controlled bus from the voltage setpoint.
    The SVC characteristic slope defines the proportion. If the voltage at
    the controlled bus is equal to the voltage setpoint, the SVC MVar output
    is zero.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'FACTS'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    capacitiveRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Capacitive reactance at maximum capacitive reactive power. Shall always
            be positive.
            '''

        })
    '''
    Capacitive reactance at maximum capacitive reactive power. Shall always
    be positive.
    '''

    inductiveRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Inductive reactance at maximum inductive reactive power. Shall always be
            negative.
            '''

        })
    '''
    Inductive reactance at maximum inductive reactive power. Shall always
    be negative.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''

        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''

    slope: Optional[ float | VoltagePerReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The characteristics slope of an SVC defines how the reactive power output
            changes in proportion to the difference between the regulated bus voltage
            and the voltage setpoint.
            The attribute shall be a positive value or zero.
            '''

        })
    '''
    The characteristics slope of an SVC defines how the reactive power
    output changes in proportion to the difference between the regulated
    bus voltage and the voltage setpoint.
    The attribute shall be a positive value or zero.
    '''

    voltageSetPoint: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reactive power output of the SVC is proportional to the difference
            between the voltage at the regulated bus and the voltage setpoint. When
            the regulated bus voltage is equal to the voltage setpoint, the reactive
            power output is zero.
            '''

        })
    '''
    The reactive power output of the SVC is proportional to the difference
    between the voltage at the regulated bus and the voltage setpoint.
    When the regulated bus voltage is equal to the voltage setpoint, the
    reactive power output is zero.
    '''

    sVCControlMode: Optional[SVCControlMode] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            SVC control mode.
            '''

        })
    '''
    SVC control mode.
    '''

    StaticVarCompensatorDynamics: Optional[StaticVarCompensatorDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StaticVarCompensatorDynamics.StaticVarCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Static Var Compensator dynamics model used to describe dynamic behaviour
            of this Static Var Compensator.
            '''

        })
    '''
    Static Var Compensator dynamics model used to describe dynamic behaviour
    of this Static Var Compensator.
    '''

@dataclass(repr=False)
class ThyristorControlledSeriesCompensator(FACTSEquipment):
    '''
    Thyristor-controlled series capacitors (TCSC) is a type of flexible AC
    transmission system regulating equipment that is configured with controlled
    reactors in parallel with sections of a capacitor bank. This combination
    allows smooth control of the fundamental frequency capacitive reactance
    over a wide range. The thyristor valve contains a string of series connected
    high power thyristors. TCSC can control power flows in order to achieve
    eliminating of line overloads, reducing loop flows and minimising system
    losses.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'FACTS'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TCSCCompensationPoint: list[TCSCCompensationPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TCSCCompensationPoint.ThyristorControlledSeriesCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Compensation point for this TCSC.
            '''

        })
    '''
    Compensation point for this TCSC.
    '''

    currentSection: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The current section on which the TCSC is operating.
            '''

        })
    '''
    The current section on which the TCSC is operating.
    '''

    compensationZ: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The actual compensation impedance provided by the compensator. The attribute
            value shall be positive if compensation is in the capacitive range. The
            attribute value shall be negative if compensation is in the inductive rating.
            '''

        })
    '''
    The actual compensation impedance provided by the compensator. The
    attribute value shall be positive if compensation is in the capacitive
    range. The attribute value shall be negative if compensation is in
    the inductive rating.
    '''

    flexibleCapacitiveZ: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Flexible impedance that can be controlled by the compensator when operating
            in the capacitive range. Shall always be positive.
            '''

        })
    '''
    Flexible impedance that can be controlled by the compensator when operating
    in the capacitive range. Shall always be positive.
    '''

    flexibleInductiveZ: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Flexible impedance that can be controlled by the compensator when operating
            in the inductive range. Shall always be negative.
            '''

        })
    '''
    Flexible impedance that can be controlled by the compensator when operating
    in the inductive range. Shall always be negative.
    '''

    minI: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum current below which the device bypassed.
            '''

        })
    '''
    Minimum current below which the device bypassed.
    '''

    reconnectionI: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The current for which the TCSC returns back to operation after bypass.
            '''

        })
    '''
    The current for which the TCSC returns back to operation after bypass.
    '''

@dataclass(repr=False)
class FrequencyConverter(RegulatingCondEq):
    '''
    A device to convert from one frequency to another (e.g., frequency F1 to
    F2) comprises a pair of FrequencyConverter instances. One converts from
    F1 to DC, the other converts the DC to F2.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Frequency on the AC side.
            '''

        })
    '''
    Frequency on the AC side.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum active power on the DC side at which the frequency converter
            should operate.
            '''

        })
    '''
    The maximum active power on the DC side at which the frequency converter
    should operate.
    '''

    maxU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum voltage on the DC side at which the frequency converter should
            operate.
            '''

        })
    '''
    The maximum voltage on the DC side at which the frequency converter
    should operate.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum active power on the DC side at which the frequency converter
            should operate.
            '''

        })
    '''
    The minimum active power on the DC side at which the frequency converter
    should operate.
    '''

    minU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum voltage on the DC side at which the frequency converter should
            operate.
            '''

        })
    '''
    The minimum voltage on the DC side at which the frequency converter
    should operate.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerElectronicsConnection(RegulatingCondEq):
    '''
    A connection to the AC network for energy production or consumption that
    uses power electronics rather than rotating machines.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PowerElectronicsConnectionPhase: list[PowerElectronicsConnectionPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsConnectionPhase.PowerElectronicsConnection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The individual phases models for the power electronics connection.
            '''

        })
    '''
    The individual phases models for the power electronics connection.
    '''

    PowerElectronicsUnit: list[PowerElectronicsUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsUnit.PowerElectronicsConnection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An AC network connection may have several power electronics units connecting
            through it.
            '''

        })
    '''
    An AC network connection may have several power electronics units connecting
    through it.
    '''

    maxIFault: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum fault current this device will contribute, in per-unit of rated
            current, before the converter protection will trip or bypass.
            '''

        })
    '''
    Maximum fault current this device will contribute, in per-unit of rated
    current, before the converter protection will trip or bypass.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum reactive power limit. This is the maximum (nameplate) limit for
            the unit.
            '''

        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit
    for the unit.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum reactive power limit for the unit. This is the minimum (nameplate)
            limit for the unit.
            '''

        })
    '''
    Minimum reactive power limit for the unit. This is the minimum (nameplate)
    limit for the unit.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''

        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''

        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nameplate apparent power rating for the unit.
            The attribute shall have a positive value.
            '''

        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
            for short circuit data exchange according to IEC 60909.
            The attribute shall be a positive value.
            '''

        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily
    used for short circuit data exchange according to IEC 60909.
    The attribute shall be a positive value.
    '''

    controlMode: Optional[ConverterControlModeKind] = field(
        default=None,
        metadata={
        'type': 'gmdm enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            Inverter control mode indicating whether reactive power output is based
            on constant PF or constant Q
            '''

        })
    '''
    Inverter control mode indicating whether reactive power output is based
    on constant PF or constant Q
    '''

    DERDynamics: Optional[DERDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DERDynamics.PowerElectronicsConnection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DER dynamics model associated with this power electronics connection model.
            '''

        })
    '''
    DER dynamics model associated with this power electronics connection
    model.
    '''

    StatcomDynamics: Optional[StatcomDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StatcomDynamics.PowerElectronicsConnection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The statcom dynamics model associated with this power electronics connection.
            '''

        })
    '''
    The statcom dynamics model associated with this power electronics connection.
    '''

    WindTurbineType3or4Dynamics: Optional[WindTurbineType3or4Dynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WindTurbineType3or4Dynamics.PowerElectronicsConnection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The wind turbine type 3 or type 4 dynamics model associated with this power
            electronics connection.
            '''

        })
    '''
    The wind turbine type 3 or type 4 dynamics model associated with this
    power electronics connection.
    '''

@dataclass(repr=False)
class RotatingMachine(RegulatingCondEq):
    '''
    A rotating machine which may be used as a generator or motor.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.RotatingMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''

        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''

    ratedPowerFactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power factor (nameplate data). It is primarily used for short circuit data
            exchange according to IEC 60909. The attribute cannot be a negative value.
            '''

        })
    '''
    Power factor (nameplate data). It is primarily used for short circuit
    data exchange according to IEC 60909. The attribute cannot be a negative
    value.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''

        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''

        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nameplate apparent power rating for the unit.
            The attribute shall have a positive value.
            '''

        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
            for short circuit data exchange according to IEC 60909.
            The attribute shall be a positive value.
            '''

        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily
    used for short circuit data exchange according to IEC 60909.
    The attribute shall be a positive value.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.RotatingMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A synchronous machine may operate as a generator and as such becomes a
            member of a generating unit.
            '''

        })
    '''
    A synchronous machine may operate as a generator and as such becomes
    a member of a generating unit.
    '''

    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.RotatingMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''

        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class AsynchronousMachine(RotatingMachine):
    '''
    A rotating machine whose shaft rotates asynchronously with the electrical
    field. Also known as an induction machine with no external connection to
    the rotor windings, e.g. squirrel-cage induction machine.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    converterFedDrive: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates whether the machine is a converter fed drive. Used for short
            circuit data exchange according to IEC 60909.
            '''

        })
    '''
    Indicates whether the machine is a converter fed drive. Used for short
    circuit data exchange according to IEC 60909.
    '''

    iaIrRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Ratio of locked-rotor current to the rated current of the motor (Ia/Ir).
            Used for short circuit data exchange according to IEC 60909.
            '''

        })
    '''
    Ratio of locked-rotor current to the rated current of the motor (Ia/Ir).
    Used for short circuit data exchange according to IEC 60909.
    '''

    polePairNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of pole pairs of stator. Used for short circuit data exchange according
            to IEC 60909.
            '''

        })
    '''
    Number of pole pairs of stator. Used for short circuit data exchange
    according to IEC 60909.
    '''

    reversible: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates for converter drive motors if the power can be reversible. Used
            for short circuit data exchange according to IEC 60909.
            '''

        })
    '''
    Indicates for converter drive motors if the power can be reversible.
    Used for short circuit data exchange according to IEC 60909.
    '''

    rxLockedRotorRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Locked rotor ratio (R/X). Used for short circuit data exchange according
            to IEC 60909.
            '''

        })
    '''
    Locked rotor ratio (R/X). Used for short circuit data exchange according
    to IEC 60909.
    '''

    efficiency: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Efficiency of the asynchronous machine at nominal operation as a percentage.
            Indicator for converter drive motors. Used for short circuit data exchange
            according to IEC 60909.
            '''

        })
    '''
    Efficiency of the asynchronous machine at nominal operation as a percentage.
    Indicator for converter drive motors. Used for short circuit data exchange
    according to IEC 60909.
    '''

    nominalFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nameplate data indicates if the machine is 50 Hz or 60 Hz.
            '''

        })
    '''
    Nameplate data indicates if the machine is 50 Hz or 60 Hz.
    '''

    nominalSpeed: Optional[ float | RotationSpeed ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nameplate data. Depends on the slip and number of pole pairs.
            '''

        })
    '''
    Nameplate data. Depends on the slip and number of pole pairs.
    '''

    ratedMechanicalPower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated mechanical power (Pr in IEC 60909-0). Used for short circuit data
            exchange according to IEC 60909.
            '''

        })
    '''
    Rated mechanical power (Pr in IEC 60909-0). Used for short circuit
    data exchange according to IEC 60909.
    '''

    rr1: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Damper 1 winding resistance.
            '''

        })
    '''
    Damper 1 winding resistance.
    '''

    rr2: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Damper 2 winding resistance.
            '''

        })
    '''
    Damper 2 winding resistance.
    '''

    tpo: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transient rotor time constant (greater than tppo).
            '''

        })
    '''
    Transient rotor time constant (greater than tppo).
    '''

    tppo: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Sub-transient rotor time constant (greater than 0).
            '''

        })
    '''
    Sub-transient rotor time constant (greater than 0).
    '''

    xlr1: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Damper 1 winding leakage reactance.
            '''

        })
    '''
    Damper 1 winding leakage reactance.
    '''

    xlr2: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Damper 2 winding leakage reactance.
            '''

        })
    '''
    Damper 2 winding leakage reactance.
    '''

    xm: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Magnetizing reactance.
            '''

        })
    '''
    Magnetizing reactance.
    '''

    xp: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transient reactance (unsaturated) (greater than or equal to xpp).
            '''

        })
    '''
    Transient reactance (unsaturated) (greater than or equal to xpp).
    '''

    xpp: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Sub-transient reactance (unsaturated).
            '''

        })
    '''
    Sub-transient reactance (unsaturated).
    '''

    xs: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Synchronous reactance (greater than xp).
            '''

        })
    '''
    Synchronous reactance (greater than xp).
    '''

    asynchronousMachineType: Optional[AsynchronousMachineKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates the type of Asynchronous Machine (motor or generator).
            '''

        })
    '''
    Indicates the type of Asynchronous Machine (motor or generator).
    '''

    AsynchronousMachineDynamics: Optional[AsynchronousMachineDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AsynchronousMachineDynamics.AsynchronousMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Asynchronous machine dynamics model used to describe dynamic behaviour
            of this asynchronous machine.
            '''

        })
    '''
    Asynchronous machine dynamics model used to describe dynamic behaviour
    of this asynchronous machine.
    '''

    DERDynamics: Optional[DERDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DERDynamics.AsynchronousMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DER dynamics model associated with this asynchronous machine model.
            '''

        })
    '''
    DER dynamics model associated with this asynchronous machine model.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class SynchronousMachine(RotatingMachine):
    '''
    An electromechanical device that operates with shaft rotating synchronously
    with the network. It is a single machine operating either as a generator
    or synchronous condenser or pump.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ReactiveCapabilityCurve: list[ReactiveCapabilityCurve] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ReactiveCapabilityCurve.SynchronousMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reactive capability curve for this synchronous machine.
            '''

        })
    '''
    The reactive capability curve for this synchronous machine.
    '''

    coolantCondition: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Temperature or pressure of coolant medium.
            '''

        })
    '''
    Temperature or pressure of coolant medium.
    '''

    earthing: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates whether or not the generator is earthed. Used for short circuit
            data exchange according to IEC 60909.
            '''

        })
    '''
    Indicates whether or not the generator is earthed. Used for short circuit
    data exchange according to IEC 60909.
    '''

    mu: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Factor to calculate the breaking current (4.5.2.1 in IEC 60909-0).
            Used only for single fed short circuit on a generator (4.3.4.2. in IEC
            60909-0).
            '''

        })
    '''
    Factor to calculate the breaking current (4.5.2.1 in IEC 60909-0).
    Used only for single fed short circuit on a generator (4.3.4.2. in
    IEC 60909-0).
    '''

    referencePriority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Priority of unit for use as powerflow voltage phase angle reference bus
            selection. 0 = don t care (default) 1 = highest priority. 2 is less than
            1 and so on.
            '''

        })
    '''
    Priority of unit for use as powerflow voltage phase angle reference
    bus selection. 0 = don t care (default) 1 = highest priority. 2 is
    less than 1 and so on.
    '''

    aVRToManualLag: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Time delay required when switching from Automatic Voltage Regulation (AVR)
            to Manual for a lagging MVAr violation.
            '''

        })
    '''
    Time delay required when switching from Automatic Voltage Regulation
    (AVR) to Manual for a lagging MVAr violation.
    '''

    aVRToManualLead: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Time delay required when switching from Automatic Voltage Regulation (AVR)
            to Manual for a leading MVAr violation.
            '''

        })
    '''
    Time delay required when switching from Automatic Voltage Regulation
    (AVR) to Manual for a leading MVAr violation.
    '''

    baseQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Default base reactive power value. This value represents the initial reactive
            power that can be used by any application function.
            '''

        })
    '''
    Default base reactive power value. This value represents the initial
    reactive power that can be used by any application function.
    '''

    condenserP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Active power consumed when in condenser mode operation.
            '''

        })
    '''
    Active power consumed when in condenser mode operation.
    '''

    earthingStarPointR: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generator star point earthing resistance (Re). Used for short circuit data
            exchange according to IEC 60909.
            '''

        })
    '''
    Generator star point earthing resistance (Re). Used for short circuit
    data exchange according to IEC 60909.
    '''

    earthingStarPointX: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Generator star point earthing reactance (Xe). Used for short circuit data
            exchange according to IEC 60909.
            '''

        })
    '''
    Generator star point earthing reactance (Xe). Used for short circuit
    data exchange according to IEC 60909.
    '''

    ikk: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Steady-state short-circuit current (in A for the profile) of generator
            with compound excitation during 3-phase short circuit.
            - Ikk=0: Generator with no compound excitation.
            - Ikk&lt;&gt;0: Generator with compound excitation.
            Ikk is used to calculate the minimum steady-state short-circuit current
            for generators with compound excitation.
            (4.6.1.2 in IEC 60909-0:2001).
            Used only for single fed short circuit on a generator. (4.3.4.2. in IEC
            60909-0:2001).
            '''

        })
    '''
    Steady-state short-circuit current (in A for the profile) of generator
    with compound excitation during 3-phase short circuit.
    - Ikk=0: Generator with no compound excitation.
    - Ikk&lt;&gt;0: Generator with compound excitation.
    Ikk is used to calculate the minimum steady-state short-circuit current
    for generators with compound excitation.
    (4.6.1.2 in IEC 60909-0:2001).
    Used only for single fed short circuit on a generator. (4.3.4.2. in
    IEC 60909-0:2001).
    '''

    manualToAVR: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Time delay required when switching from Manual to Automatic Voltage Regulation.
            This value is used in the accelerating power reference frame for powerflow
            solutions.
            '''

        })
    '''
    Time delay required when switching from Manual to Automatic Voltage
    Regulation. This value is used in the accelerating power reference
    frame for powerflow solutions.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum reactive power limit. This is the maximum (nameplate) limit for
            the unit.
            '''

        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit
    for the unit.
    '''

    maxU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum voltage limit for the unit.
            '''

        })
    '''
    Maximum voltage limit for the unit.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum reactive power limit for the unit.
            '''

        })
    '''
    Minimum reactive power limit for the unit.
    '''

    minU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum voltage limit for the unit.
            '''

        })
    '''
    Minimum voltage limit for the unit.
    '''

    qPercent: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Part of the coordinated reactive control that comes from this machine.
            The attribute is used as a participation factor not necessarily summing
            up to 100 % for the participating devices in the control.
            '''

        })
    '''
    Part of the coordinated reactive control that comes from this machine.
    The attribute is used as a participation factor not necessarily summing
    up to 100 % for the participating devices in the control.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Equivalent resistance (RG) of generator. RG is considered for the calculation
            of all currents, except for the calculation of the peak current ip. Used
            for short circuit data exchange according to IEC 60909.
            '''

        })
    '''
    Equivalent resistance (RG) of generator. RG is considered for the calculation
    of all currents, except for the calculation of the peak current ip.
    Used for short circuit data exchange according to IEC 60909.
    '''

    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence resistance of the synchronous machine.
            '''

        })
    '''
    Zero sequence resistance of the synchronous machine.
    '''

    r2: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Negative sequence resistance.
            '''

        })
    '''
    Negative sequence resistance.
    '''

    satDirectSubtransX: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Direct-axis subtransient reactance saturated, also known as Xd"sat.
            '''

        })
    '''
    Direct-axis subtransient reactance saturated, also known as Xd"sat.
    '''

    satDirectSyncX: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Direct-axes saturated synchronous reactance (xdsat); reciprocal of short-circuit
            ration. Used for short circuit data exchange, only for single fed short
            circuit on a generator. (4.3.4.2. in IEC 60909-0:2001).
            '''

        })
    '''
    Direct-axes saturated synchronous reactance (xdsat); reciprocal of
    short-circuit ration. Used for short circuit data exchange, only for
    single fed short circuit on a generator. (4.3.4.2. in IEC 60909-0:2001).
    '''

    satDirectTransX: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Saturated Direct-axis transient reactance. The attribute is primarily used
            for short circuit calculations according to ANSI.
            '''

        })
    '''
    Saturated Direct-axis transient reactance. The attribute is primarily
    used for short circuit calculations according to ANSI.
    '''

    voltageRegulationRange: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Range of generator voltage regulation (PG in IEC 60909-0) used for calculation
            of the impedance correction factor KG defined in IEC 60909-0.
            This attribute is used to describe the operating voltage of the generating
            unit.
            '''

        })
    '''
    Range of generator voltage regulation (PG in IEC 60909-0) used for
    calculation of the impedance correction factor KG defined in IEC 60909-0.
    This attribute is used to describe the operating voltage of the generating
    unit.
    '''

    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence reactance of the synchronous machine.
            '''

        })
    '''
    Zero sequence reactance of the synchronous machine.
    '''

    x2: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Negative sequence reactance.
            '''

        })
    '''
    Negative sequence reactance.
    '''

    coolantType: Optional[CoolantType] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Method of cooling the machine.
            '''

        })
    '''
    Method of cooling the machine.
    '''

    operatingMode: Optional[SynchronousMachineOperatingMode] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Current mode of operation.
            '''

        })
    '''
    Current mode of operation.
    '''

    shortCircuitRotorType: Optional[ShortCircuitRotorKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Type of rotor, used by short circuit applications, only for single fed
            short circuit according to IEC 60909.
            '''

        })
    '''
    Type of rotor, used by short circuit applications, only for single
    fed short circuit according to IEC 60909.
    '''

    type: Optional[SynchronousMachineKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Modes that this synchronous machine can operate in.
            '''

        })
    '''
    Modes that this synchronous machine can operate in.
    '''

    DERDynamics: Optional[DERDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DERDynamics.SynchronousMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            DER dynamics model associated with this synchronous machine model.
            '''

        })
    '''
    DER dynamics model associated with this synchronous machine model.
    '''

    InitialReactiveCapabilityCurve: Optional[ReactiveCapabilityCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReactiveCapabilityCurve.InitiallyUsedBySynchronousMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The default reactive capability curve for use by a synchronous machine.
            The reference voltage (exchanged by ReactiveCapabilityCurve.referenceVoltage)
            for this ReactiveCapabilityCurve shall be equal to the BaseVoltage.nominalVoltage
            of the ConnectivityNode to which the Equipment is connected to. The information
            is obtained via the containment of the Equipment or the ConnectivityNode.
            '''

        })
    '''
    The default reactive capability curve for use by a synchronous machine.
    The reference voltage (exchanged by ReactiveCapabilityCurve.referenceVoltage)
    for this ReactiveCapabilityCurve shall be equal to the BaseVoltage.nominalVoltage
    of the ConnectivityNode to which the Equipment is connected to. The
    information is obtained via the containment of the Equipment or the
    ConnectivityNode.
    '''

    SynchronousMachineDynamics: Optional[SynchronousMachineDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SynchronousMachineDynamics.SynchronousMachine',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Synchronous machine dynamics model used to describe dynamic behaviour of
            this synchronous machine.
            '''

        })
    '''
    Synchronous machine dynamics model used to describe dynamic behaviour
    of this synchronous machine.
    '''

@dataclass(repr=False)
class ShuntCompensator(RegulatingCondEq):
    '''
    A shunt capacitor or reactor or switchable bank of shunt capacitors or
    reactors. A section of a shunt compensator is an individual capacitor or
    reactor. A negative value for bPerSection indicates that the compensator
    is a reactor. ShuntCompensator is a single terminal device. Ground is implied.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ShuntCompensatorPhase: list[ShuntCompensatorPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShuntCompensatorPhase.ShuntCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The individual phases models for the shunt compensator.
            '''

        })
    '''
    The individual phases models for the shunt compensator.
    '''

    SvShuntCompensatorSections: list[SvShuntCompensatorSections] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvShuntCompensatorSections.ShuntCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The state for the number of shunt compensator sections in service.
            '''

        })
    '''
    The state for the number of shunt compensator sections in service.
    '''

    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Required for Yn and I connections (as represented by ShuntCompensator.phaseConnection).
            True if the neutral is solidly grounded.
            '''

        })
    '''
    Required for Yn and I connections (as represented by ShuntCompensator.phaseConnection).
    True if the neutral is solidly grounded.
    '''

    maximumSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum number of sections that may be switched in.
            '''

        })
    '''
    The maximum number of sections that may be switched in.
    '''

    normalSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal number of sections switched in. The value shall be between zero
            and ShuntCompensator.maximumSections.
            '''

        })
    '''
    The normal number of sections switched in. The value shall be between
    zero and ShuntCompensator.maximumSections.
    '''

    sections: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Shunt compensator sections in use. Starting value for steady state solution.
            The attribute shall be a positive value or zero. Non integer values are
            allowed to support continuous variables. The reasons for continuous value
            are to support study cases where no discrete shunt compensators has yet
            been designed, a solutions where a narrow voltage band force the sections
            to oscillate or accommodate for a continuous solution as input.
            For LinearShuntConpensator the value shall be between zero and ShuntCompensator.maximumSections.
            At value zero the shunt compensator conductance and admittance is zero.
            Linear interpolation of conductance and admittance between the previous
            and next integer section is applied in case of non-integer values.
            For NonlinearShuntCompensator(-s) shall only be set to one of the NonlinearShuntCompenstorPoint.sectionNumber.
            There is no interpolation between NonlinearShuntCompenstorPoint(-s).
            '''

        })
    '''
    Shunt compensator sections in use. Starting value for steady state
    solution. The attribute shall be a positive value or zero. Non integer
    values are allowed to support continuous variables. The reasons for
    continuous value are to support study cases where no discrete shunt
    compensators has yet been designed, a solutions where a narrow voltage
    band force the sections to oscillate or accommodate for a continuous
    solution as input.
    For LinearShuntConpensator the value shall be between zero and ShuntCompensator.maximumSections.
    At value zero the shunt compensator conductance and admittance is zero.
    Linear interpolation of conductance and admittance between the previous
    and next integer section is applied in case of non-integer values.
    For NonlinearShuntCompensator(-s) shall only be set to one of the NonlinearShuntCompenstorPoint.sectionNumber.
    There is no interpolation between NonlinearShuntCompenstorPoint(-s).
    '''

    aVRDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An automatic voltage regulation delay (AVRDelay) which is the time delay
            from a change in voltage to when the capacitor is allowed to change state.
            This filters out temporary changes in voltage.
            '''

        })
    '''
    An automatic voltage regulation delay (AVRDelay) which is the time
    delay from a change in voltage to when the capacitor is allowed to
    change state. This filters out temporary changes in voltage.
    '''

    nomU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage at which the nominal reactive power may be calculated. This
            should normally be within 10% of the voltage at which the capacitor is
            connected to the network.
            '''

        })
    '''
    The voltage at which the nominal reactive power may be calculated.
    This should normally be within 10% of the voltage at which the capacitor
    is connected to the network.
    '''

    voltageSensitivity: Optional[ float | VoltagePerReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Voltage sensitivity required for the device to regulate the bus voltage,
            in voltage/reactive power.
            '''

        })
    '''
    Voltage sensitivity required for the device to regulate the bus voltage,
    in voltage/reactive power.
    '''

    phaseConnection: Optional[PhaseShuntConnectionKind] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of phase connection, such as wye or delta.
            '''

        })
    '''
    The type of phase connection, such as wye or delta.
    '''

    ShuntCompensatorAction: Optional[ShuntCompensatorAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensatorAction.ShuntCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ShuntCompensatorDynamics: Optional[ShuntCompensatorDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensatorDynamics.ShuntCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Shunt compensator dynamics model used to describe dynamic behaviour of
            this shunt compensator.
            '''

        })
    '''
    Shunt compensator dynamics model used to describe dynamic behaviour
    of this shunt compensator.
    '''

    StaticVarCompensatorSystemDynamics: Optional[StaticVarCompensatorSystemDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StaticVarCompensatorSystemDynamics.ShuntCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Static Var Compensator system dynamics model used to describe dynamic behaviour
            of this Static Var Compensator system.
            '''

        })
    '''
    Static Var Compensator system dynamics model used to describe dynamic
    behaviour of this Static Var Compensator system.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class LinearShuntCompensator(ShuntCompensator):
    '''
    A linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    b0PerSection: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance per section.
            '''

        })
    '''
    Zero sequence shunt (charging) susceptance per section.
    '''

    bPerSection: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance per section.
            '''

        })
    '''
    Positive sequence shunt (charging) susceptance per section.
    '''

    g0PerSection: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence shunt (charging) conductance per section.
            '''

        })
    '''
    Zero sequence shunt (charging) conductance per section.
    '''

    gPerSection: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance per section.
            '''

        })
    '''
    Positive sequence shunt (charging) conductance per section.
    '''

@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class NonlinearShuntCompensator(ShuntCompensator):
    '''
    A non linear shunt compensator has bank or section admittance values that
    differ. The attributes gTotal, bTotal, g0Total and b0Total of the associated
    NonlinearShuntCompensatorPoint describe the total conductance and admittance
    of a NonlinearShuntCompensatorPoint at a section number specified by NonlinearShuntCompensatorPoint.sectionNumber.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    NonlinearShuntCompensatorPoints: list[NonlinearShuntCompensatorPoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonlinearShuntCompensatorPoint.NonlinearShuntCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All points of the non-linear shunt compensator.
            '''

        })
    '''
    All points of the non-linear shunt compensator.
    '''

@dataclass(repr=False)
class VariableShuntCompensator(NonlinearShuntCompensator):
    '''
    A variable shunt compensator (VSR) is an oil-filled reactor with discrete
    on-line regulation of reactive power. The regulation range typically varies
    between 30% and 100% of the rated reactive power. When energized VSR cannot
    have a reactive output of 0 Mvar, so minimal valid section number is 1
    with reactive power output at either 100% or at minimal reactive power
    output. Note that reactive power can increase or decrease with increasing
    of the section number (NonlinearShuntCompensatorPoint.sectionNumber).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class ExtendedWardEquivalent(ConductingEquipment):
    '''
    An extended ward equivalent is a combination of an impedance load, a PQ
    load and as voltage source with an internal impedance.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Equivalents'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ReactiveCapabilityCurve: list[ReactiveCapabilityCurve] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ReactiveCapabilityCurve.ExtendedWardEquivalent',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The reactive capability curve used by this extended ward equivalent.
            '''

        })
    '''
    The reactive capability curve used by this extended ward equivalent.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Ground(ConductingEquipment):
    '''
    A point where the system is grounded used for connecting conducting equipment
    to ground. The power system model can have any number of grounds.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    GroundAction: Optional[GroundAction] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GroundAction.Ground',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Action taken with this ground.
            '''

        })
    '''
    Action taken with this ground.
    '''

@stereotype(CIMStereotype.Concrete)
@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class PowerTransformer(ConductingEquipment):
    '''
    An electrical device consisting of two or more coupled windings, with or
    without a magnetic core, for introducing mutual coupling between electric
    circuits. Transformers can be used to control voltage and phase shift (active
    power flow).
    A power transformer may be composed of separate transformer tanks that
    need not be identical.
    A power transformer can be modelled with or without tanks and is intended
    for use in both balanced and unbalanced representations. A power transformer
    typically has two terminals, but may have one (grounding), three or more
    terminals.
    The inherited association ConductingEquipment.BaseVoltage should not be
    used. The association from TransformerEnd to BaseVoltage should be used
    instead.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PowerTransformerEnd: list[PowerTransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerTransformerEnd.PowerTransformer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ends of this power transformer.
            '''

        })
    '''
    The ends of this power transformer.
    '''

    TransformerTanks: list[TransformerTank] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTank.PowerTransformer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All transformers that belong to this bank.
            '''

        })
    '''
    All transformers that belong to this bank.
    '''

    isPartOfGeneratorUnit: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates whether the machine is part of a power station unit. Used for
            short circuit data exchange according to IEC 60909. It has an impact on
            how the correction factors are calculated for transformers, since the transformer
            is not necessarily part of a synchronous machine and generating unit. It
            is not always possible to derive this information from the model. This
            is why the attribute is necessary.
            '''

        })
    '''
    Indicates whether the machine is part of a power station unit. Used
    for short circuit data exchange according to IEC 60909. It has an impact
    on how the correction factors are calculated for transformers, since
    the transformer is not necessarily part of a synchronous machine and
    generating unit. It is not always possible to derive this information
    from the model. This is why the attribute is necessary.
    '''

    operationalValuesConsidered: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            It is used to define if the data (other attributes related to short circuit
            data exchange) defines long term operational conditions or not. Used for
            short circuit data exchange according to IEC 60909.
            '''

        })
    '''
    It is used to define if the data (other attributes related to short
    circuit data exchange) defines long term operational conditions or
    not. Used for short circuit data exchange according to IEC 60909.
    '''

    vectorGroup: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Vector group of the transformer for protective relaying, e.g., Dyn1. For
            unbalanced transformers, this may not be simply determined from the constituent
            winding connections and phase angle displacements.
            The vectorGroup string consists of the following components in the order
            listed: high voltage winding connection, mid voltage winding connection
            (for three winding transformers), phase displacement clock number from
            0 to 11, low voltage winding connection
            phase displacement clock number from 0 to 11. The winding connections are
            D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag with
            neutral), A (auto transformer). Upper case means the high voltage, lower
            case mid or low. The high voltage winding always has clock position 0 and
            is not included in the vector group string. Some examples: YNy0 (two winding
            wye to wye with no phase displacement), YNd11 (two winding wye to delta
            with 330 degrees phase displacement), YNyn0d5 (three winding transformer
            wye with neutral high voltage, wye with neutral mid voltage and no phase
            displacement, delta low voltage with 150 degrees displacement).
            Phase displacement is defined as the angular difference between the phasors
            representing the voltages between the neutral point (real or imaginary)
            and the corresponding terminals of two windings, a positive sequence voltage
            system being applied to the high-voltage terminals, following each other
            in alphabetical sequence if they are lettered, or in numerical sequence
            if they are numbered: the phasors are assumed to rotate in a counter-clockwise
            sense.
            '''

        })
    '''
    Vector group of the transformer for protective relaying, e.g., Dyn1.
    For unbalanced transformers, this may not be simply determined from
    the constituent winding connections and phase angle displacements.
    The vectorGroup string consists of the following components in the
    order listed: high voltage winding connection, mid voltage winding
    connection (for three winding transformers), phase displacement clock
    number from 0 to 11, low voltage winding connection
    phase displacement clock number from 0 to 11. The winding connections
    are D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag
    with neutral), A (auto transformer). Upper case means the high voltage,
    lower case mid or low. The high voltage winding always has clock position
    0 and is not included in the vector group string. Some examples: YNy0
    (two winding wye to wye with no phase displacement), YNd11 (two winding
    wye to delta with 330 degrees phase displacement), YNyn0d5 (three winding
    transformer wye with neutral high voltage, wye with neutral mid voltage
    and no phase displacement, delta low voltage with 150 degrees displacement).
    Phase displacement is defined as the angular difference between the
    phasors representing the voltages between the neutral point (real or
    imaginary) and the corresponding terminals of two windings, a positive
    sequence voltage system being applied to the high-voltage terminals,
    following each other in alphabetical sequence if they are lettered,
    or in numerical sequence if they are numbered: the phasors are assumed
    to rotate in a counter-clockwise sense.
    '''

    beforeShCircuitHighestOperatingCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The highest operating current (Ib in IEC 60909-0) before short circuit
            (depends on network configuration and relevant reliability philosophy).
            It is used for calculation of the impedance correction factor KT defined
            in IEC 60909-0.
            '''

        })
    '''
    The highest operating current (Ib in IEC 60909-0) before short circuit
    (depends on network configuration and relevant reliability philosophy).
    It is used for calculation of the impedance correction factor KT defined
    in IEC 60909-0.
    '''

    beforeShCircuitHighestOperatingVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The highest operating voltage (Ub in IEC 60909-0) before short circuit.
            It is used for calculation of the impedance correction factor KT defined
            in IEC 60909-0. This is worst case voltage on the low side winding (3.7.1
            of IEC 60909:2001). Used to define operating conditions.
            '''

        })
    '''
    The highest operating voltage (Ub in IEC 60909-0) before short circuit.
    It is used for calculation of the impedance correction factor KT defined
    in IEC 60909-0. This is worst case voltage on the low side winding
    (3.7.1 of IEC 60909:2001). Used to define operating conditions.
    '''

    beforeShortCircuitAnglePf: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The angle of power factor before short circuit (phib in IEC 60909-0). It
            is used for calculation of the impedance correction factor KT defined in
            IEC 60909-0. This is the worst case power factor. Used to define operating
            conditions.
            '''

        })
    '''
    The angle of power factor before short circuit (phib in IEC 60909-0).
    It is used for calculation of the impedance correction factor KT defined
    in IEC 60909-0. This is the worst case power factor. Used to define
    operating conditions.
    '''

    highSideMinOperatingU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The minimum operating voltage (uQmin in IEC 60909-0) at the high voltage
            side (Q side) of the unit transformer of the power station unit. A value
            well established from long-term operating experience of the system. It
            is used for calculation of the impedance correction factor KG defined in
            IEC 60909-0.
            '''

        })
    '''
    The minimum operating voltage (uQmin in IEC 60909-0) at the high voltage
    side (Q side) of the unit transformer of the power station unit. A
    value well established from long-term operating experience of the system.
    It is used for calculation of the impedance correction factor KG defined
    in IEC 60909-0.
    '''

@dataclass(repr=False)
class MktPowerTransformer(PowerTransformer):
    '''
    Subclass of IEC61970:Wires:PowerTransformer.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'MarketOpCommon'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    EndAFlow: Optional[BranchEndFlow] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BranchEndFlow.MktPowerTransformerEndAFlow',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    EndBFlow: Optional[BranchEndFlow] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BranchEndFlow.MktPowerTransformerEndBFlow',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class SeriesCompensator(ConductingEquipment):
    '''
    A Series Compensator is a series capacitor or reactor or an AC transmission
    line without charging susceptance. It is a two terminal device.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    varistorPresent: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Describe if a metal oxide varistor (mov) for over voltage protection is
            configured in parallel with the series compensator. It is used for short
            circuit calculations.
            '''

        })
    '''
    Describe if a metal oxide varistor (mov) for over voltage protection
    is configured in parallel with the series compensator. It is used for
    short circuit calculations.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence resistance.
            '''

        })
    '''
    Positive sequence resistance.
    '''

    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence resistance.
            '''

        })
    '''
    Zero sequence resistance.
    '''

    varistorRatedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum current the varistor is designed to handle at specified duration.
            It is used for short circuit calculations and exchanged only if SeriesCompensator.varistorPresent
            is true.
            The attribute shall be a positive value.
            '''

        })
    '''
    The maximum current the varistor is designed to handle at specified
    duration. It is used for short circuit calculations and exchanged only
    if SeriesCompensator.varistorPresent is true.
    The attribute shall be a positive value.
    '''

    varistorVoltageThreshold: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The DC voltage at which the varistor starts conducting. It is used for
            short circuit calculations and exchanged only if SeriesCompensator.varistorPresent
            is true.
            '''

        })
    '''
    The DC voltage at which the varistor starts conducting. It is used
    for short circuit calculations and exchanged only if SeriesCompensator.varistorPresent
    is true.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence reactance.
            '''

        })
    '''
    Positive sequence reactance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Zero sequence reactance.
            '''

        })
    '''
    Zero sequence reactance.
    '''

@stereotype(CIMStereotype.ShadowExtension)
@dataclass(repr=False)
class Switch(ConductingEquipment):
    '''
    A generic device designed to close, or open, or both, one or more electric
    circuits. All switches are two terminal devices including grounding switches.
    The ACDCTerminal.connected at the two sides of the switch shall not be
    considered for assessing switch connectivity, i.e. only Switch.open, .normalOpen
    and .locked are relevant.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    SvSwitch: list[SvSwitch] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvSwitch.Switch',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The switch state associated with the switch.
            '''

        })
    '''
    The switch state associated with the switch.
    '''

    SwitchPhase: list[SwitchPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SwitchPhase.Switch',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#