from __future__ import annotations

import logging
from dataclasses import dataclass, field
from enum import Enum
from typing import Optional

from cimgraph.data_profile.identity import Identity, stereotype
from cimgraph.data_profile.units import CIMUnit, UnitMultiplier, UnitSymbol

_log = logging.getLogger(__name__)
'''
Annotated CIMantic Graphs data profile for UnbalancedConnectivity
Generated by CIMTool http://cimtool.org
'''

class CIMStereotype(Enum):
    AggregateOf = 'AggregateOf'
    Attribute = 'Attribute'
    ByReference = 'ByReference'
    CIMDatatype = 'CIMDatatype'
    Concrete = 'Concrete'
    OfAggregate = 'OfAggregate'
    Primitive = 'Primitive'
    ShadowExtension = 'ShadowExtension'
    enumeration = 'enumeration'
    gmdm = 'gmdm'

BASE_URI = 'http://www.ucaiug.org/gmdm/connectivity/unbalanced#'
ONTOLOGY_URI = 'http://cim.ucaiug.io/CIM101/draft#'

@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a class that provides common identification for all classes needing
    identification and naming attributes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The description is a free human readable text describing or naming the
            object. It may be non unique and may not correlate to a naming hierarchy.
            '''

        })
    '''
    The description is a free human readable text describing or naming
    the object. It may be non unique and may not correlate to a naming
    hierarchy.
    '''

    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The name is any free human readable and possibly non unique text naming
            the object.
            '''

        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''

@dataclass(repr=False)
class ACDCTerminal(IdentifiedObject):
    '''
    An electrical connection point (AC or DC) to a piece of conducting equipment.
    Terminals are connected at physical connection points called connectivity
    nodes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The orientation of the terminal connections for a multiple terminal conducting
            equipment. The sequence numbering starts with 1 and additional terminals
            should follow in increasing order. The first terminal is the "starting
            point" for a two terminal branch.
            '''

        })
    '''
    The orientation of the terminal connections for a multiple terminal
    conducting equipment. The sequence numbering starts with 1 and additional
    terminals should follow in increasing order. The first terminal is
    the "starting point" for a two terminal branch.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Terminal(ACDCTerminal):
    '''
    An AC electrical connection point to a piece of conducting equipment. Terminals
    are connected at physical connection points called connectivity nodes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TransformerEnd: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All transformer ends connected at this terminal.
            '''

        })
    '''
    All transformer ends connected at this terminal.
    '''

    UsagePoint: Optional[UsagePoint] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'UsagePoint.Terminal',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    ConductingEquipment: Optional[ConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ConductingEquipment.Terminals',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The conducting equipment of the terminal. Conducting equipment have terminals
            that may be connected to other conducting equipment terminals via connectivity
            nodes or topological nodes.
            '''

        })
    '''
    The conducting equipment of the terminal. Conducting equipment have
    terminals that may be connected to other conducting equipment terminals
    via connectivity nodes or topological nodes.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.Terminals',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The connectivity node to which this terminal connects with zero impedance.
            '''

        })
    '''
    The connectivity node to which this terminal connects with zero impedance.
    '''

    NormalHeadFeeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.NormalHeadTerminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The feeder that this terminal normally feeds. Only specified for the terminals
            at head of feeders.
            '''

        })
    '''
    The feeder that this terminal normally feeds. Only specified for the
    terminals at head of feeders.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BaseVoltage(IdentifiedObject):
    '''
    Defines a system base voltage which is referenced. This may be different
    than the rated voltage.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConductingEquipment: list[ConductingEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConductingEquipment.BaseVoltage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All conducting equipment with this base voltage. Use only when there is
            no voltage level container used and only one base voltage applies. For
            example, not used for transformers.
            '''

        })
    '''
    All conducting equipment with this base voltage. Use only when there
    is no voltage level container used and only one base voltage applies.
    For example, not used for transformers.
    '''

    TransformerEnds: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.BaseVoltage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer ends at the base voltage. This is essential for PU calculation.
            '''

        })
    '''
    Transformer ends at the base voltage. This is essential for PU calculation.
    '''

    VoltageLevel: list[VoltageLevel] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageLevel.BaseVoltage',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage levels having this base voltage.
            '''

        })
    '''
    The voltage levels having this base voltage.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The power system resource's base voltage, expressed on a phase-to-phase
            (line-to-line) basis. Shall be a positive value and not zero.
            '''

        })
    '''
    The power system resource's base voltage, expressed on a phase-to-phase
    (line-to-line) basis. Shall be a positive value and not zero.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ConnectivityNode(IdentifiedObject):
    '''
    Connectivity nodes are points where terminals of AC conducting equipment
    are connected together with zero impedance.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Terminals interconnected with zero impedance at a this connectivity node.
            '''

        })
    '''
    Terminals interconnected with zero impedance at a this connectivity
    node.
    '''

    ConnectivityNodeContainer: Optional[ConnectivityNodeContainer] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNodeContainer.ConnectivityNodes',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Container of this connectivity node.
            '''

        })
    '''
    Container of this connectivity node.
    '''

@dataclass(repr=False)
class PowerSystemResource(IdentifiedObject):
    '''
    A power system resource (PSR) can be an item of equipment such as a switch,
    an equipment container containing many individual items of equipment such
    as a substation, or an organisational entity such as sub-control area.
    Power system resources can have measurements associated.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ACLineSegmentPhase(PowerSystemResource):
    '''
    A line segment phase represents one phase (or optionally the neutral) of
    an alternating current line segment.
    Under most circumstances there is not a line segment phase for the neutral.
    However, if a wire assembly is being used and it does not specify phase,
    a line segment phase must exist for each position in the assembly (including
    the neutral).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase identifies the phase or neutral connection of the conductor at both
            ends.
            '''

        })
    '''
    Phase identifies the phase or neutral connection of the conductor at
    both ends.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.ACLineSegmentPhases',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line segment to which the phase belongs.
            '''

        })
    '''
    The line segment to which the phase belongs.
    '''

@dataclass(repr=False)
class ConnectivityNodeContainer(PowerSystemResource):
    '''
    A base class for all objects that may contain connectivity nodes or topological
    nodes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConnectivityNodes: list[ConnectivityNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConnectivityNode.ConnectivityNodeContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Connectivity nodes which belong to this connectivity node container.
            '''

        })
    '''
    Connectivity nodes which belong to this connectivity node container.
    '''

@dataclass(repr=False)
class EquipmentContainer(ConnectivityNodeContainer):
    '''
    A modelling construct to provide a root class for containing equipment.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    AdditionalGroupedEquipment: list[Equipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Equipment.AdditionalEquipmentContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The additonal contained equipment. The equipment belong to the equipment
            container. The equipment is contained in another equipment container, but
            also grouped with this equipment container. Examples include when a switch
            contained in a substation is also desired to be grouped with a line contianer
            or when a switch is included in a secondary substation and also grouped
            in a feeder.
            '''

        })
    '''
    The additonal contained equipment. The equipment belong to the equipment
    container. The equipment is contained in another equipment container,
    but also grouped with this equipment container. Examples include when
    a switch contained in a substation is also desired to be grouped with
    a line contianer or when a switch is included in a secondary substation
    and also grouped in a feeder.
    '''

    Equipments: list[Equipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Equipment.EquipmentContainer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Contained equipment.
            '''

        })
    '''
    Contained equipment.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Feeder(EquipmentContainer):
    '''
    A collection of equipment for organizational purposes, used for grouping
    distribution resources.
    The organization a feeder does not necessarily reflect connectivity or
    current operation state.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    NormalHeadTerminal: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.NormalHeadFeeder',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal head terminal or terminals of the feeder.
            '''

        })
    '''
    The normal head terminal or terminals of the feeder.
    '''

    NormalEnergizingSubstation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Substation.NormalEnergizedFeeder',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The substation that nominally energizes the feeder. Also used for naming
            purposes.
            '''

        })
    '''
    The substation that nominally energizes the feeder. Also used for naming
    purposes.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Line(EquipmentContainer):
    '''
    Contains equipment beyond a substation belonging to a power transmission
    line.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Substation(EquipmentContainer):
    '''
    A collection of equipment for purposes other than generation or utilization,
    through which electric energy in bulk is passed for the purposes of switching
    or modifying its characteristics.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    NormalEnergizedFeeder: list[Feeder] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Feeder.NormalEnergizingSubstation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal energized feeders of the substation. Also used for naming purposes.
            '''

        })
    '''
    The normal energized feeders of the substation. Also used for naming
    purposes.
    '''

    VoltageLevels: list[VoltageLevel] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageLevel.Substation',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage levels within this substation.
            '''

        })
    '''
    The voltage levels within this substation.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class VoltageLevel(EquipmentContainer):
    '''
    A collection of equipment at one common system voltage forming a switchgear.
    The equipment typically consists of breakers, busbars, instrumentation,
    control, regulation and protection devices as well as assemblies of all
    these.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.VoltageLevel',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The base voltage used for all equipment within the voltage level.
            '''

        })
    '''
    The base voltage used for all equipment within the voltage level.
    '''

    Substation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate ByReference',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.VoltageLevels',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The substation of the voltage level.
            '''

        })
    '''
    The substation of the voltage level.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class EnergyConsumerPhase(PowerSystemResource):
    '''
    A single phase of an energy consumer.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase of this energy consumer component. If the energy consumer is wye
            connected, the connection is from the indicated phase to the central ground
            or neutral point. If the energy consumer is delta connected, the phase
            indicates an energy consumer connected from the indicated phase to the
            next logical non-neutral phase.
            '''

        })
    '''
    Phase of this energy consumer component. If the energy consumer is
    wye connected, the connection is from the indicated phase to the central
    ground or neutral point. If the energy consumer is delta connected,
    the phase indicates an energy consumer connected from the indicated
    phase to the next logical non-neutral phase.
    '''

    EnergyConsumer: Optional[EnergyConsumer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumer.EnergyConsumerPhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The energy consumer to which this phase belongs.
            '''

        })
    '''
    The energy consumer to which this phase belongs.
    '''

@dataclass(repr=False)
class Equipment(PowerSystemResource):
    '''
    The parts of a power system that are physical devices, electronic or mechanical.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    aggregate: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The aggregate flag provides an alternative way of representing an aggregated
            (equivalent) element. It is applicable in cases when the dedicated classes
            for equivalent equipment do not have all of the attributes necessary to
            represent the required level of detail. In case the flag is set to "true"
            the single instance of equipment represents multiple pieces of equipment
            that have been modelled together as an aggregate equivalent obtained by
            a network reduction procedure. Examples would be power transformers or
            synchronous machines operating in parallel modelled as a single aggregate
            power transformer or aggregate synchronous machine.
            The attribute is not used for EquivalentBranch, EquivalentShunt, EquivalentInjection
            and ExternalNetworkInjection.
            '''

        })
    '''
    The aggregate flag provides an alternative way of representing an aggregated
    (equivalent) element. It is applicable in cases when the dedicated
    classes for equivalent equipment do not have all of the attributes
    necessary to represent the required level of detail. In case the flag
    is set to "true" the single instance of equipment represents multiple
    pieces of equipment that have been modelled together as an aggregate
    equivalent obtained by a network reduction procedure. Examples would
    be power transformers or synchronous machines operating in parallel
    modelled as a single aggregate power transformer or aggregate synchronous
    machine.
    The attribute is not used for EquivalentBranch, EquivalentShunt, EquivalentInjection
    and ExternalNetworkInjection.
    '''

    normallyInService: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the availability of the equipment under normal operating conditions.
            True means the equipment is available for topology processing, which determines
            if the equipment is energized or not. False means that the equipment is
            treated by network applications as if it is not in the model.
            '''

        })
    '''
    Specifies the availability of the equipment under normal operating
    conditions. True means the equipment is available for topology processing,
    which determines if the equipment is energized or not. False means
    that the equipment is treated by network applications as if it is not
    in the model.
    '''

    AdditionalEquipmentContainer: Optional[EquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EquipmentContainer.AdditionalGroupedEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Additional equipment container beyond the primary equipment container.
            The equipment is contained in another equipment container, but also grouped
            with this equipment container.
            '''

        })
    '''
    Additional equipment container beyond the primary equipment container.
    The equipment is contained in another equipment container, but also
    grouped with this equipment container.
    '''

    EquipmentContainer: Optional[EquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'EquipmentContainer.Equipments',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Container of this equipment.
            '''

        })
    '''
    Container of this equipment.
    '''

@dataclass(repr=False)
class ConductingEquipment(Equipment):
    '''
    The parts of the AC power system that are designed to carry current or
    that are conductively connected through terminals.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConductingEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conducting equipment have terminals that may be connected to other conducting
            equipment terminals via connectivity nodes or topological nodes.
            '''

        })
    '''
    Conducting equipment have terminals that may be connected to other
    conducting equipment terminals via connectivity nodes or topological
    nodes.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.ConductingEquipment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Base voltage of this conducting equipment. Use only when there is no voltage
            level container used and only one base voltage applies. For example, not
            used for transformers.
            '''

        })
    '''
    Base voltage of this conducting equipment. Use only when there is no
    voltage level container used and only one base voltage applies. For
    example, not used for transformers.
    '''

@dataclass(repr=False)
class Conductor(ConductingEquipment):
    '''
    Combination of conducting material with consistent electrical characteristics,
    building a single electrical system, used to carry current between points
    in the power system.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ACLineSegment(Conductor):
    '''
    A line segment is a conductor or combination of conductors, with consistent
    electrical characteristics along its length, building a single electrical
    system that carries alternating current between two points in the power
    system.
    The BaseVoltage at the two ends of a line segment shall have the same BaseVoltage.nominalVoltage.
    However, boundary lines may have slightly different BaseVoltage.nominalVoltages
    and variation is allowed. Larger voltage difference in general requires
    use of an equivalent branch.
    Line segment impedances can be either directly described in electrical
    terms or physical line detail can be provided from which impedances can
    be calculated.
    <b>Directly described impedances</b>
    For symmetrical, transposed three phase line segments, it is sufficient
    to use attributes of the line segment, which describe impedances and admittances
    for the entire length of the line segment. Additionally, line segment impedances
    can be computed by using line segment length and associated per length
    impedances.
    Unbalanced modeling of impedances is supported by the per length phase
    impedance matrix (PerLengthPhaseImpedance) in conjunction with phase-to-sequence
    number mapping supplied by either ACLineSegmentPhase or WirePosition. The
    sequence numbers are referenced by the row and column attributes of the
    per length phase impedance matrix. This method enables single-phase and
    two-phase line segments, and transpositions of phases, to be described
    using the same per length phase impedance matrix. The length of the line
    segment is used in the computation of total impedance values for the line
    segment.
    <b>Line detail characteristics</b>
    There are three approaches to providing line detail and all use WireAssembly
    to supply line positions:
    <ul>
    <li>Option 1 - WireAssembly supplies only line positions. ACLineSegmentPhase
    points to wire type and intraphase spacing and supplies the phase-to-sequence
    number mapping.</li>
    <li>Option 2 - WireAssembly supplies line position and, for each position,
    also supplies wire type and intraphase spacing. ACLineSegmentPhase supplies
    the phase-to-sequence number mapping.</li>
    <li>Option 3 - WireAssembly supplies line position and, for each position,
    also supplies wire type and intraphase spacing and phase. WireAssembly
    therefore supplies the phase-to-sequence number mapping and ACLineSegmentPhase
    is not needed.</li>
    </ul>
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ACLineSegmentPhases: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '4',
        'inverse': 'ACLineSegmentPhase.ACLineSegment',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The line segment phases which belong to the line segment.
            '''

        })
    '''
    The line segment phases which belong to the line segment.
    '''

@dataclass(repr=False)
class Connector(ConductingEquipment):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation and are
    modelled with a single logical terminal.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BusbarSection(Connector):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation. The BusbarSection
    class is intended to represent physical parts of bus bars no matter how
    that bus bar is constructed.
    Voltage measurements are typically obtained from voltage transformers that
    are connected to busbar sections. A bus bar section may have many physical
    terminals but for analysis is modelled with exactly one logical terminal.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class EnergyConnection(ConductingEquipment):
    '''
    A connection of energy generation or consumption on the power system model.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class EnergyConsumer(EnergyConnection):
    '''
    Generic user of energy - a point of consumption on the power system model.
    EnergyConsumer.pfixed, .qfixed, .pfixedPct and .qfixedPct have meaning
    only if there is no LoadResponseCharacteristic associated with EnergyConsumer
    or if LoadResponseCharacteristic.exponentModel is set to False.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    EnergyConsumerPhase: list[EnergyConsumerPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '3',
        'inverse': 'EnergyConsumerPhase.EnergyConsumer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The individual phase models for this energy consumer.
            '''

        })
    '''
    The individual phase models for this energy consumer.
    '''

    customerCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number of individual customers represented by this demand.
            '''

        })
    '''
    Number of individual customers represented by this demand.
    '''

    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Required for Yn and I connections (as represented by EnergyConsumer.phaseConnection).
            True if the neutral is solidly grounded.
            '''

        })
    '''
    Required for Yn and I connections (as represented by EnergyConsumer.phaseConnection).
    True if the neutral is solidly grounded.
    '''

    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of phase connection, such as wye or delta.
            '''

        })
    '''
    The type of phase connection, such as wye or delta.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class EnergySource(EnergyConnection):
    '''
    A generic equivalent for an energy supplier on a transmission or distribution
    voltage level.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class RegulatingCondEq(EnergyConnection):
    '''
    A type of conducting equipment that can regulate a quantity (i.e. voltage
    or flow) at a specific point in the network.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerElectronicsConnection(RegulatingCondEq):
    '''
    A connection to the AC network for energy production or consumption that
    uses power electronics rather than rotating machines.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PowerElectronicsConnectionPhase: list[PowerElectronicsConnectionPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsConnectionPhase.PowerElectronicsConnection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The individual phases models for the power electronics connection.
            '''

        })
    '''
    The individual phases models for the power electronics connection.
    '''

@dataclass(repr=False)
class RotatingMachine(RegulatingCondEq):
    '''
    A rotating machine which may be used as a generator or motor.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class AsynchronousMachine(RotatingMachine):
    '''
    A rotating machine whose shaft rotates asynchronously with the electrical
    field. Also known as an induction machine with no external connection to
    the rotor windings, e.g. squirrel-cage induction machine.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class SynchronousMachine(RotatingMachine):
    '''
    An electromechanical device that operates with shaft rotating synchronously
    with the network. It is a single machine operating either as a generator
    or synchronous condenser or pump.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class ShuntCompensator(RegulatingCondEq):
    '''
    A shunt capacitor or reactor or switchable bank of shunt capacitors or
    reactors. A section of a shunt compensator is an individual capacitor or
    reactor. A negative value for bPerSection indicates that the compensator
    is a reactor. ShuntCompensator is a single terminal device. Ground is implied.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ShuntCompensatorPhase: list[ShuntCompensatorPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '3',
        'inverse': 'ShuntCompensatorPhase.ShuntCompensator',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The individual phases models for the shunt compensator.
            '''

        })
    '''
    The individual phases models for the shunt compensator.
    '''

    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Required for Yn and I connections (as represented by ShuntCompensator.phaseConnection).
            True if the neutral is solidly grounded.
            '''

        })
    '''
    Required for Yn and I connections (as represented by ShuntCompensator.phaseConnection).
    True if the neutral is solidly grounded.
    '''

    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of phase connection, such as wye or delta.
            '''

        })
    '''
    The type of phase connection, such as wye or delta.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class LinearShuntCompensator(ShuntCompensator):
    '''
    A linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerTransformer(ConductingEquipment):
    '''
    An electrical device consisting of two or more coupled windings, with or
    without a magnetic core, for introducing mutual coupling between electric
    circuits. Transformers can be used to control voltage and phase shift (active
    power flow).
    A power transformer may be composed of separate transformer tanks that
    need not be identical.
    A power transformer can be modelled with or without tanks and is intended
    for use in both balanced and unbalanced representations. A power transformer
    typically has two terminals, but may have one (grounding), three or more
    terminals.
    The inherited association ConductingEquipment.BaseVoltage should not be
    used. The association from TransformerEnd to BaseVoltage should be used
    instead.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PowerTransformerEnd: list[PowerTransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '3',
        'inverse': 'PowerTransformerEnd.PowerTransformer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The ends of this power transformer.
            '''

        })
    '''
    The ends of this power transformer.
    '''

    TransformerTanks: list[TransformerTank] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTank.PowerTransformer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All transformers that belong to this bank.
            '''

        })
    '''
    All transformers that belong to this bank.
    '''

    vectorGroup: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Vector group of the transformer for protective relaying, e.g., Dyn1. For
            unbalanced transformers, this may not be simply determined from the constituent
            winding connections and phase angle displacements.
            The vectorGroup string consists of the following components in the order
            listed: high voltage winding connection, mid voltage winding connection
            (for three winding transformers), phase displacement clock number from
            0 to 11, low voltage winding connection
            phase displacement clock number from 0 to 11. The winding connections are
            D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag with
            neutral), A (auto transformer). Upper case means the high voltage, lower
            case mid or low. The high voltage winding always has clock position 0 and
            is not included in the vector group string. Some examples: YNy0 (two winding
            wye to wye with no phase displacement), YNd11 (two winding wye to delta
            with 330 degrees phase displacement), YNyn0d5 (three winding transformer
            wye with neutral high voltage, wye with neutral mid voltage and no phase
            displacement, delta low voltage with 150 degrees displacement).
            Phase displacement is defined as the angular difference between the phasors
            representing the voltages between the neutral point (real or imaginary)
            and the corresponding terminals of two windings, a positive sequence voltage
            system being applied to the high-voltage terminals, following each other
            in alphabetical sequence if they are lettered, or in numerical sequence
            if they are numbered: the phasors are assumed to rotate in a counter-clockwise
            sense.
            '''

        })
    '''
    Vector group of the transformer for protective relaying, e.g., Dyn1.
    For unbalanced transformers, this may not be simply determined from
    the constituent winding connections and phase angle displacements.
    The vectorGroup string consists of the following components in the
    order listed: high voltage winding connection, mid voltage winding
    connection (for three winding transformers), phase displacement clock
    number from 0 to 11, low voltage winding connection
    phase displacement clock number from 0 to 11. The winding connections
    are D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag
    with neutral), A (auto transformer). Upper case means the high voltage,
    lower case mid or low. The high voltage winding always has clock position
    0 and is not included in the vector group string. Some examples: YNy0
    (two winding wye to wye with no phase displacement), YNd11 (two winding
    wye to delta with 330 degrees phase displacement), YNyn0d5 (three winding
    transformer wye with neutral high voltage, wye with neutral mid voltage
    and no phase displacement, delta low voltage with 150 degrees displacement).
    Phase displacement is defined as the angular difference between the
    phasors representing the voltages between the neutral point (real or
    imaginary) and the corresponding terminals of two windings, a positive
    sequence voltage system being applied to the high-voltage terminals,
    following each other in alphabetical sequence if they are lettered,
    or in numerical sequence if they are numbered: the phasors are assumed
    to rotate in a counter-clockwise sense.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class SeriesCompensator(ConductingEquipment):
    '''
    A Series Compensator is a series capacitor or reactor or an AC transmission
    line without charging susceptance. It is a two terminal device.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class Switch(ConductingEquipment):
    '''
    A generic device designed to close, or open, or both, one or more electric
    circuits. All switches are two terminal devices including grounding switches.
    The ACDCTerminal.connected at the two sides of the switch shall not be
    considered for assessing switch connectivity, i.e. only Switch.open, .normalOpen
    and .locked are relevant.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    SwitchPhase: list[SwitchPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '3',
        'inverse': 'SwitchPhase.Switch',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The individual switch phases for the switch.
            '''

        })
    '''
    The individual switch phases for the switch.
    '''

    locked: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, the switch is locked. The resulting switch state is a combination
            of locked and Switch.open attributes as follows:
            <ul>
            <li>locked=true and Switch.open=true. The resulting state is open and locked;</li>
            <li>locked=false and Switch.open=true. The resulting state is open;</li>
            <li>locked=false and Switch.open=false. The resulting state is closed.</li>
            </ul>
            '''

        })
    '''
    If true, the switch is locked. The resulting switch state is a combination
    of locked and Switch.open attributes as follows:
    <ul>
    <li>locked=true and Switch.open=true. The resulting state is open and
    locked;</li>
    <li>locked=false and Switch.open=true. The resulting state is open;</li>
    <li>locked=false and Switch.open=false. The resulting state is closed.</li>
    </ul>
    '''

    normalOpen: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The attribute is used in cases when no Measurement for the status value
            is present. If the Switch has a status measurement the Discrete.normalValue
            is expected to match with the Switch.normalOpen.
            '''

        })
    '''
    The attribute is used in cases when no Measurement for the status value
    is present. If the Switch has a status measurement the Discrete.normalValue
    is expected to match with the Switch.normalOpen.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Disconnector(Switch):
    '''
    A mechanical switching device which provides, in the open position, an
    isolating distance in accordance with specified requirements.
    A disconnector is capable of opening and closing a circuit when either
    negligible current is broken or made, or when no significant change in
    the voltage across the terminals of each of the poles of the disconnector
    occurs. It is also capable of carrying currents under normal circuit conditions
    and carrying for a specified time currents under abnormal conditions such
    as those of short circuit.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Fuse(Switch):
    '''
    An overcurrent protective device with a circuit opening fusible part that
    is heated and severed by the passage of overcurrent through it. A fuse
    is considered a switching device because it breaks current.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class ProtectedSwitch(Switch):
    '''
    A ProtectedSwitch is a switching device that can be operated by ProtectionEquipment.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Breaker(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal circuit conditions and also making, carrying for
    a specified time, and breaking currents under specified abnormal circuit
    conditions e.g. those of short circuit.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class LoadBreakSwitch(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal operating conditions.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Recloser(ProtectedSwitch):
    '''
    Pole-mounted fault interrupter with built-in phase and ground relays, current
    transformer (CT), and supplemental controls.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Sectionaliser(Switch):
    '''
    Automatic switch that will lock open to isolate a faulted section. It may,
    or may not, have load breaking capability. Its primary purpose is to provide
    fault sectionalising at locations where the fault current is either too
    high, or too low, for proper coordination of fuses.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerTank(Equipment):
    '''
    An assembly of two or more coupled windings that transform electrical power
    between voltage levels. These windings are bound on a common core and placed
    in the same tank. Transformer tank can be used to model both single-phase
    and 3-phase transformers.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    TransformerTankEnds: list[TransformerTankEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTankEnd.TransformerTank',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All windings of this transformer.
            '''

        })
    '''
    All windings of this transformer.
    '''

    PowerTransformer: Optional[PowerTransformer] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'PowerTransformer.TransformerTanks',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Bank this transformer belongs to.
            '''

        })
    '''
    Bank this transformer belongs to.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerElectronicsConnectionPhase(PowerSystemResource):
    '''
    A single phase of a power electronics connection.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase of this energy producer component. If the energy producer is wye
            connected, the connection is from the indicated phase to the central ground
            or neutral point. If the energy producer is delta connected, the phase
            indicates an energy producer connected from the indicated phase to the
            next logical non-neutral phase.
            '''

        })
    '''
    Phase of this energy producer component. If the energy producer is
    wye connected, the connection is from the indicated phase to the central
    ground or neutral point. If the energy producer is delta connected,
    the phase indicates an energy producer connected from the indicated
    phase to the next logical non-neutral phase.
    '''

    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsConnection.PowerElectronicsConnectionPhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Power electronics connection of this power electronics connection phase.
            '''

        })
    '''
    Power electronics connection of this power electronics connection phase.
    '''

@dataclass(repr=False)
class ShuntCompensatorPhase(PowerSystemResource):
    '''
    Single phase of a multi-phase shunt compensator when its attributes might
    be different per phase.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase of this shunt compensator component. If the shunt compensator is
            wye connected, the connection is from the indicated phase to the central
            ground or neutral point. If the shunt compensator is delta connected, the
            phase indicates a shunt compensator connected from the indicated phase
            to the next logical non-neutral phase.
            '''

        })
    '''
    Phase of this shunt compensator component. If the shunt compensator
    is wye connected, the connection is from the indicated phase to the
    central ground or neutral point. If the shunt compensator is delta
    connected, the phase indicates a shunt compensator connected from the
    indicated phase to the next logical non-neutral phase.
    '''

    ShuntCompensator: Optional[ShuntCompensator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensator.ShuntCompensatorPhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Shunt compensator of this shunt compensator phase.
            '''

        })
    '''
    Shunt compensator of this shunt compensator phase.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class LinearShuntCompensatorPhase(ShuntCompensatorPhase):
    '''
    A per phase linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class SwitchPhase(PowerSystemResource):
    '''
    Single phase of a multi-phase switch when its attributes might be different
    per phase.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    normalOpen: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Used in cases when no Measurement for the status value is present. If the
            SwitchPhase has a status measurement the Discrete.normalValue is expected
            to match with this value.
            '''

        })
    '''
    Used in cases when no Measurement for the status value is present.
    If the SwitchPhase has a status measurement the Discrete.normalValue
    is expected to match with this value.
    '''

    phaseSide1: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase of this SwitchPhase on the side with terminal sequence number equal
            to 1. Should be a phase contained in that terminal's phases attribute.
            '''

        })
    '''
    Phase of this SwitchPhase on the side with terminal sequence number
    equal to 1. Should be a phase contained in that terminal's phases attribute.
    '''

    phaseSide2: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase of this SwitchPhase on the side with terminal sequence number equal
            to 2. Should be a phase contained in that terminal's Terminal.phases attribute.
            '''

        })
    '''
    Phase of this SwitchPhase on the side with terminal sequence number
    equal to 2. Should be a phase contained in that terminal's Terminal.phases
    attribute.
    '''

    Switch: Optional[Switch] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Switch.SwitchPhase',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The switch of the switch phase.
            '''

        })
    '''
    The switch of the switch phase.
    '''

@dataclass(repr=False)
class TransformerEnd(IdentifiedObject):
    '''
    A conducting connection point of a power transformer. It corresponds to
    a physical transformer winding terminal. In earlier CIM versions, the TransformerWinding
    class served a similar purpose, but this class is more flexible because
    it associates to terminal but is not a specialization of ConductingEquipment.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    endNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Number for this transformer end, corresponding to the end's order in the
            power transformer vector group or phase angle clock number. Highest voltage
            winding should be 1. Each end within a power transformer should have a
            unique subsequent end number. Note the transformer end number need not
            match the terminal sequence number.
            '''

        })
    '''
    Number for this transformer end, corresponding to the end's order in
    the power transformer vector group or phase angle clock number. Highest
    voltage winding should be 1. Each end within a power transformer should
    have a unique subsequent end number. Note the transformer end number
    need not match the terminal sequence number.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.TransformerEnds',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Base voltage of the transformer end. This is essential for PU calculation.
            '''

        })
    '''
    Base voltage of the transformer end. This is essential for PU calculation.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Terminal.TransformerEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Terminal of the power transformer to which this transformer end belongs.
            '''

        })
    '''
    Terminal of the power transformer to which this transformer end belongs.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerTransformerEnd(TransformerEnd):
    '''
    A PowerTransformerEnd is associated with each Terminal of a PowerTransformer.
    The impedance values r, r0, x, and x0 of a PowerTransformerEnd represents
    a star equivalent as follows.
    1) two PowerTransformerEnd-s shall be defined for a two Terminal PowerTransformer
    even if the two PowerTransformerEnd-s have the same rated voltage. The
    high voltage PowerTransformerEnd (TransformerEnd.endNumber=1) is the one
    used to exchange resistances (r, r0) and reactances (x, x0) of the PowerTransformer
    while the low voltage PowerTransformerEnd (TransformerEnd.endNumber=2)
    shall have zero impedance values.
    2) for a three Terminal PowerTransformer the three PowerTransformerEnds
    represent a star equivalent with each leg in the star represented by r,
    r0, x, and x0 values.
    3) For a three Terminal transformer each PowerTransformerEnd shall have
    g, g0, b and b0 values corresponding to the no load losses distributed
    on the three PowerTransformerEnds. The total no load loss shunt impedances
    may also be placed at one of the PowerTransformerEnds, preferably the end
    numbered 1, having the shunt values on end 1. This is the preferred way.
    4) for a PowerTransformer with more than three Terminals the PowerTransformerEnd
    impedance values cannot be used. Instead use the TransformerMeshImpedance
    or split the transformer into multiple PowerTransformers.
    Each PowerTransformerEnd must be contained by a PowerTransformer. Because
    a PowerTransformerEnd (or any other object) can not be contained by more
    than one parent, a PowerTransformerEnd can not have an association to an
    EquipmentContainer (Substation, VoltageLevel, etc).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    connectionKind: Optional[ WindingConnection ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Kind of connection.
            '''

        })
    '''
    Kind of connection.
    '''

    PowerTransformer: Optional[PowerTransformer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'PowerTransformer.PowerTransformerEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The power transformer of this power transformer end.
            '''

        })
    '''
    The power transformer of this power transformer end.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerTankEnd(TransformerEnd):
    '''
    Transformer tank end represents an individual winding for unbalanced models
    or for transformer tanks connected into a bank (and bank is modelled with
    the PowerTransformer).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    orderedPhases: Optional[ OrderedPhaseCodeKind ] = field(
        default=None,
        metadata={
        'type': 'gmdm enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''

        })
    '''
    '''

    TransformerTank: Optional[TransformerTank] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'TransformerTank.TransformerTankEnds',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer this winding belongs to.
            '''

        })
    '''
    Transformer this winding belongs to.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class UsagePoint(IdentifiedObject):
    '''
    Logical or physical point in the network to which readings or events may
    be attributed. Used at the place where a physical or virtual meter may
    be located; however, it is not required that a meter be present.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Metering'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    phaseCode: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase code. Number of wires and specific nominal phases can be deduced
            from enumeration literal values. For example, ABCN is three-phase, four-wire,
            s12n (splitSecondary12N) is single-phase, three-wire, and s1n and s2n are
            single-phase, two-wire.
            '''

        })
    '''
    Phase code. Number of wires and specific nominal phases can be deduced
    from enumeration literal values. For example, ABCN is three-phase,
    four-wire, s12n (splitSecondary12N) is single-phase, three-wire, and
    s1n and s2n are single-phase, two-wire.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'ShadowExtension gmdm ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Terminal.UsagePoint',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@stereotype(CIMStereotype.gmdm)
@stereotype(CIMStereotype.enumeration)
class OrderedPhaseCodeKind(Enum):
    '''
    In some use cases, the ordering of phases is important. The PhaseCode class
    does not represent order, but this class addresses such use cases. When
    two or more phases are present, the individual phases may occur in any
    order, but the neutral must always occur last. When only one phase and
    the neutral is present, that phase and the neutral may be re-ordered.
    '''

    A = 'A'
    '''
    '''

    AB = 'AB'
    '''
    '''

    ABC = 'ABC'
    '''
    '''

    ABCN = 'ABCN'
    '''
    '''

    ABN = 'ABN'
    '''
    '''

    AC = 'AC'
    '''
    '''

    ACB = 'ACB'
    '''
    '''

    ACBN = 'ACBN'
    '''
    '''

    ACN = 'ACN'
    '''
    '''

    AN = 'AN'
    '''
    '''

    B = 'B'
    '''
    '''

    BA = 'BA'
    '''
    '''

    BAC = 'BAC'
    '''
    '''

    BACN = 'BACN'
    '''
    '''

    BAN = 'BAN'
    '''
    '''

    BC = 'BC'
    '''
    '''

    BCA = 'BCA'
    '''
    '''

    BCAN = 'BCAN'
    '''
    '''

    BCN = 'BCN'
    '''
    '''

    BN = 'BN'
    '''
    '''

    C = 'C'
    '''
    '''

    CA = 'CA'
    '''
    '''

    CAB = 'CAB'
    '''
    '''

    CABN = 'CABN'
    '''
    '''

    CAN = 'CAN'
    '''
    '''

    CB = 'CB'
    '''
    '''

    CBA = 'CBA'
    '''
    '''

    CBAN = 'CBAN'
    '''
    '''

    CBN = 'CBN'
    '''
    '''

    CN = 'CN'
    '''
    '''

    NA = 'NA'
    '''
    '''

    NB = 'NB'
    '''
    '''

    NC = 'NC'
    '''
    '''

    Ns1 = 'Ns1'
    '''
    '''

    Ns2 = 'Ns2'
    '''
    '''

    X = 'X'
    '''
    '''

    XN = 'XN'
    '''
    '''

    XY = 'XY'
    '''
    '''

    XYN = 'XYN'
    '''
    '''

    none = 'none'
    '''
    '''

    s1 = 's1'
    '''
    '''

    s12 = 's12'
    '''
    '''

    s12N = 's12N'
    '''
    '''

    s1N = 's1N'
    '''
    '''

    s2 = 's2'
    '''
    '''

    s21 = 's21'
    '''
    '''

    s21N = 's21N'
    '''
    '''

    s2N = 's2N'
    '''
    '''

@stereotype(CIMStereotype.enumeration)
class PhaseCode(Enum):
    '''
    Enumeration of phase identifiers used to designate the combination of phase
    and/or neutral conductors at a terminal, measurement or equipment modelled
    as a single-line balanced equivalent.
    This is an unordered enumeration of phase identifiers. Allows designation
    of phases for both transmission and distribution equipment, circuits and
    loads. The enumeration, by itself, does not describe how the phases are
    connected together or connected to ground. Ground is not explicitly denoted
    as a phase.
    Residential and small commercial loads are often served from single-phase,
    or split-phase, secondary circuits. For the example of s12N, phases 1 and
    2 refer to hot wires that are 180 degrees out of phase, while N refers
    to the neutral wire. Through single-phase transformer connections, these
    secondary circuits may be served from one or two of the primary phases
    A, B, and C. For three-phase loads, use the A, B, C phase codes instead
    of s12N.
    The integer values are from IEC 61968-9 to support revenue metering applications.
    '''

    A = 'A'
    '''
    Phase A.
    '''

    AB = 'AB'
    '''
    Phases A and B.
    '''

    ABC = 'ABC'
    '''
    Phases A, B, and C.
    '''

    ABCN = 'ABCN'
    '''
    Phases A, B, C, and N.
    '''

    ABN = 'ABN'
    '''
    Phases A, B, and neutral.
    '''

    AC = 'AC'
    '''
    Phases A and C.
    '''

    ACN = 'ACN'
    '''
    Phases A, C and neutral.
    '''

    AN = 'AN'
    '''
    Phases A and neutral.
    '''

    B = 'B'
    '''
    Phase B.
    '''

    BC = 'BC'
    '''
    Phases B and C.
    '''

    BCN = 'BCN'
    '''
    Phases B, C, and neutral.
    '''

    BN = 'BN'
    '''
    Phases B and neutral.
    '''

    C = 'C'
    '''
    Phase C.
    '''

    CN = 'CN'
    '''
    Phases C and neutral.
    '''

    N = 'N'
    '''
    Neutral phase.
    '''

    X = 'X'
    '''
    Unknown non-neutral phase.
    '''

    XN = 'XN'
    '''
    Unknown non-neutral phase plus neutral.
    '''

    XY = 'XY'
    '''
    Two unknown non-neutral phases.
    '''

    XYN = 'XYN'
    '''
    Two unknown non-neutral phases plus neutral.
    '''

    none = 'none'
    '''
    No phases specified.
    '''

    s1 = 's1'
    '''
    Secondary phase 1.
    '''

    s12 = 's12'
    '''
    Secondary phase 1 and 2.
    '''

    s12N = 's12N'
    '''
    Secondary phases 1, 2, and neutral.
    '''

    s1N = 's1N'
    '''
    Secondary phase 1 and neutral.
    '''

    s2 = 's2'
    '''
    Secondary phase 2.
    '''

    s2N = 's2N'
    '''
    Secondary phase 2 and neutral.
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class PhaseShuntConnectionKind(Enum):
    '''
    The configuration of phase connections for a single terminal device such
    as a load or capacitor.
    '''

    D = 'D'
    '''
    Delta connection.
    '''

    G = 'G'
    '''
    Ground connection; use when explicit connection to ground needs to
    be expressed in combination with the phase code, such as for electrical
    wire/cable or for meters.
    '''

    I = 'I'
    '''
    Independent winding, for single-phase connections.
    '''

    Y = 'Y'
    '''
    Wye connection.
    '''

    Yn = 'Yn'
    '''
    Wye, with neutral brought out for grounding.
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class SinglePhaseKind(Enum):
    '''
    Enumeration of phase identifiers used to designate the specific phase of
    conducting equipment modelled as individual unbalanced phases.
    Allows designation of specific phases for transmission and distribution
    equipment, circuits and loads.
    '''

    A = 'A'
    '''
    Phase A.
    '''

    B = 'B'
    '''
    Phase B.
    '''

    C = 'C'
    '''
    Phase C.
    '''

    N = 'N'
    '''
    Neutral.
    '''

    s1 = 's1'
    '''
    Secondary phase 1.
    '''

    s2 = 's2'
    '''
    Secondary phase 2.
    '''

@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class WindingConnection(Enum):
    '''
    Winding connection type.
    '''

    A = 'A'
    '''
    Autotransformer common winding.
    '''

    D = 'D'
    '''
    Delta.
    '''

    I = 'I'
    '''
    Independent winding, for single-phase connections.
    '''

    Y = 'Y'
    '''
    Wye.
    '''

    Yn = 'Yn'
    '''
    Wye, with neutral brought out for grounding.
    '''

    Z = 'Z'
    '''
    ZigZag.
    '''

    Zn = 'Zn'
    '''
    ZigZag, with neutral brought out for grounding.
    '''

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Voltage(CIMUnit):
    '''
    Electrical voltage, can be both AC and DC.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.V
    def __init__(self, value, input_unit: str='V', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
