from __future__ import annotations

import logging
from dataclasses import dataclass, field
from enum import Enum
from typing import Optional

from cimgraph.data_profile.identity import CIMStereotype, Identity, stereotype
from cimgraph.data_profile.units import CIMUnit, UnitMultiplier, UnitSymbol

_log = logging.getLogger(__name__)
'''
Annotated CIMantic Graphs data profile for UnbalancedElectrical
Generated by CIMTool http://cimtool.org
'''

class CIMStereotype(Enum):
    Attribute = "Attribute"
    ByReference = "ByReference"
    CIMDatatype = "CIMDatatype"
    Concrete = "Concrete"
    Description = "Description"
    Primitive = "Primitive"
    ShadowExtension = "ShadowExtension"
    enumeration = "enumeration"
    gmdm = "gmdm"

BASE_URI = 'http://www.ucaiug.org/gmdm/electrical/unbalanced#'
ONTOLOGY_URI = 'http://cim.ucaiug.io/CIM101/draft#'


@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a class that provides common identification for all classes needing
    identification and naming attributes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The description is a free human readable text describing or naming the
            object. It may be non unique and may not correlate to a naming hierarchy.
            '''
        
        })
    '''
    The description is a free human readable text describing or naming
    the object. It may be non unique and may not correlate to a naming
    hierarchy.
    '''

    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The name is any free human readable and possibly non unique text naming
            the object.
            '''
        
        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''

@dataclass(repr=False)
class ACDCTerminal(IdentifiedObject):
    '''
    An electrical connection point (AC or DC) to a piece of conducting equipment.
    Terminals are connected at physical connection points called connectivity
    nodes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Terminal(ACDCTerminal):
    '''
    An AC electrical connection point to a piece of conducting equipment. Terminals
    are connected at physical connection points called connectivity nodes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    RegulatingControl: list[RegulatingControl] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulatingControl.Terminal',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The controls regulating this terminal.
            '''
        
        })
    '''
    The controls regulating this terminal.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class FossilFuel(IdentifiedObject):
    '''
    The fossil fuel consumed by the non-nuclear thermal generating unit. For
    example, coal, oil, gas, etc. These are the specific fuels that the generating
    unit can consume.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PowerElectronicsThermalUnit: list[PowerElectronicsThermalUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsThermalUnit.FossilFuels',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''
        
        })
    fossilFuelType: Optional[FuelType] = field(
        default=None,
        metadata={
        'type': 'enumeration',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': '',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The type of fossil fuel, such as coal, oil, or gas.
            '''
        
        })
    '''
    The type of fossil fuel, such as coal, oil, or gas.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.FossilFuels',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more fossil fuels.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class LoadResponseCharacteristic(IdentifiedObject):
    '''
    Models the characteristic response of the load demand due to changes in
    system conditions such as voltage and frequency. It is not related to demand
    response.
    If LoadResponseCharacteristic.exponentModel is True, the exponential voltage
    or frequency dependent models are specified and used as to calculate active
    and reactive power components of the load model.
    The equations to calculate active and reactive power components of the
    load model are internal to the power flow calculation, hence they use different
    quantities depending on the use case of the data exchange.
    The equations for exponential voltage dependent load model injected power
    are:
    pInjection= Pnominal* (Voltage/cim:BaseVoltage.nominalVoltage) ** cim:LoadResponseCharacteristic.pVoltageExponent
    qInjection= Qnominal* (Voltage/cim:BaseVoltage.nominalVoltage) ** cim:LoadResponseCharacteristic.qVoltageExponent
    pInjection = Pnominal* (Frequency/(Nominal frequency))**cim:LoadResponseCharacteristic.pFrequencyExponent
    qInjection = Qnominal* (Frequency/(Nominal frequency))**cim:LoadResponseCharacteristic.qFrequencyExponent
    Note that both voltage and frequency exponents could be used together so
    the full equation would be:
    pInjection = Pnominal* (Voltage/(cim:BaseVoltage.nominalVoltage))**cim:LoadResponseCharacteristic.pVoltageExponent
    * (Frequency/(base frequency))**cim:LoadResponseCharacteristic.pFrequencyExponent
    qInjection = Qnominal* (Voltage/(cim:BaseVoltage.nominalVoltage))**cim:LoadResponseCharacteristic.qVoltageExponent
    * (Frequency/(base frequency))**cim:LoadResponseCharacteristic.qFrequencyExponent
    The voltage and frequency expressed in the equation are values obtained
    from solved power flow. Base voltage and base frequency are those derived
    from the connectivity of the static network model.
    Where:
    1) * means "multiply" and ** is "raised to the power of";
    2) Pnominal and Qnominal represent the active power and reactive power
    at nominal voltage as any load described by the voltage exponential model
    shall be given at nominal voltage. This means that EnergyConsumer.p and
    EnergyConsumer.q are at nominal voltage.
    3) After power flow is solved:
    -pInjection and qInjection correspond to SvPowerflow.p and SvPowerflow.q
    respectively.
    - Voltage corresponds to SvVoltage.v at the TopologicalNode where the load
    is connected.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'LoadModel'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'
    exponentModel: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Indicates the exponential voltage dependency model is to be used. If false,
            the coefficient model is to be used.
            The exponential voltage dependency model consist of the attributes:
            - pVoltageExponent
            - qVoltageExponent
            - pFrequencyExponent
            - qFrequencyExponent.
            The coefficient model consist of the attributes:
            - pConstantImpedance
            - pConstantCurrent
            - pConstantPower
            - qConstantImpedance
            - qConstantCurrent
            - qConstantPower.
            The sum of pConstantImpedance, pConstantCurrent and pConstantPower shall
            equal 1.
            The sum of qConstantImpedance, qConstantCurrent and qConstantPower shall
            equal 1.
            '''
        
        })
    '''
    Indicates the exponential voltage dependency model is to be used. If
    false, the coefficient model is to be used.
    The exponential voltage dependency model consist of the attributes:
    - pVoltageExponent
    - qVoltageExponent
    - pFrequencyExponent
    - qFrequencyExponent.
    The coefficient model consist of the attributes:
    - pConstantImpedance
    - pConstantCurrent
    - pConstantPower
    - qConstantImpedance
    - qConstantCurrent
    - qConstantPower.
    The sum of pConstantImpedance, pConstantCurrent and pConstantPower
    shall equal 1.
    The sum of qConstantImpedance, qConstantCurrent and qConstantPower
    shall equal 1.
    '''

    pConstantCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of active power load modelled as constant current.
            '''
        
        })
    '''
    Portion of active power load modelled as constant current.
    '''

    pConstantImpedance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of active power load modelled as constant impedance.
            '''
        
        })
    '''
    Portion of active power load modelled as constant impedance.
    '''

    pConstantPower: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of active power load modelled as constant power.
            '''
        
        })
    '''
    Portion of active power load modelled as constant power.
    '''

    pFrequencyExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exponent of per unit frequency effecting active power.
            '''
        
        })
    '''
    Exponent of per unit frequency effecting active power.
    '''

    pVoltageExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exponent of per unit voltage effecting real power.
            '''
        
        })
    '''
    Exponent of per unit voltage effecting real power.
    '''

    qConstantCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of reactive power load modelled as constant current.
            '''
        
        })
    '''
    Portion of reactive power load modelled as constant current.
    '''

    qConstantImpedance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of reactive power load modelled as constant impedance.
            '''
        
        })
    '''
    Portion of reactive power load modelled as constant impedance.
    '''

    qConstantPower: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Portion of reactive power load modelled as constant power.
            '''
        
        })
    '''
    Portion of reactive power load modelled as constant power.
    '''

    qFrequencyExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exponent of per unit frequency effecting reactive power.
            '''
        
        })
    '''
    Exponent of per unit frequency effecting reactive power.
    '''

    qVoltageExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Exponent of per unit voltage effecting reactive power.
            '''
        
        })
    '''
    Exponent of per unit voltage effecting reactive power.
    '''

@dataclass(repr=False)
class PerLengthLineParameter(IdentifiedObject):
    '''
    Common type for per-length electrical line parameters.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.ByReference)
@dataclass(repr=False)
class PerLengthImpedance(PerLengthLineParameter):
    '''
    Common type for per-length electrical impedances.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'
@stereotype(CIMStereotype.Concrete)
@stereotype(CIMStereotype.ByReference)
@dataclass(repr=False)
class PerLengthPhaseImpedance(PerLengthImpedance):
    '''
    The per length phase impedance matrix expresses impedance and admittance
    parameters per unit length for n-conductor unbalanced line segments. A
    phase impedance matrix contains both self impedances for each phase and
    mutual impedances between pairs of phases. The matrix is stored in symmetric
    lower triangular format where the diagonal entries represent self-impedances
    (and have the same value in row and column) and the off diagonal entries
    represent phase-to-phase impedances (and have different row and column
    values).
    The matrix can be use to express impedances for both non-coupled and coupled
    line segments. Coupled line segments share a single per length phase impedance
    matrix whose entries reflect the self and mutual impedances of all the
    phases of all the wires.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'
    conductorCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conductor count identifies the number of phase, neutral, and other wires
            represented in the phase impedance matrix and constrains the number of
            elements in the matrix. Typically, Kron reduction is used for incorporating
            effects of neutral impedance in the phase conductor values (so conductor
            count only considers phase wires), but neutrals can be included in the
            matrix (in which case conductor count would include the neutral wire(s)).
            For a phase impedance matrix associated with the lines of a coupled line
            segment group, the conductor count reflects the total of the conductors
            associated with all the coupled line segments in the group.
            '''
        
        })
    '''
    Conductor count identifies the number of phase, neutral, and other
    wires represented in the phase impedance matrix and constrains the
    number of elements in the matrix. Typically, Kron reduction is used
    for incorporating effects of neutral impedance in the phase conductor
    values (so conductor count only considers phase wires), but neutrals
    can be included in the matrix (in which case conductor count would
    include the neutral wire(s)). For a phase impedance matrix associated
    with the lines of a coupled line segment group, the conductor count
    reflects the total of the conductors associated with all the coupled
    line segments in the group.
    '''

@dataclass(repr=False)
class PowerSystemResource(IdentifiedObject):
    '''
    A power system resource (PSR) can be an item of equipment such as a switch,
    an equipment container containing many individual items of equipment such
    as a substation, or an organisational entity such as sub-control area.
    Power system resources can have measurements associated.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ACLineSegmentPhase(PowerSystemResource):
    '''
    A line segment phase represents one phase (or optionally the neutral) of
    an alternating current line segment.
    Under most circumstances there is not a line segment phase for the neutral.
    However, if a wire assembly is being used and it does not specify phase,
    a line segment phase must exist for each position in the assembly (including
    the neutral).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Sequence number provides the numbering for this line segment phase. When
            impedance is directly described, sequence number binds the phase to the
            column and row for entries in the per length phase impedance matrix (PhaseImpedanceData
            of PerLengthPhaseImpedance). When used in conjunction with a wire assembly
            description, sequence number associates the line segment phase to a position.
            For a line segment not a part of a parallel line segment group, sequence
            number starts at one and increments by one through each line segment phase
            associated with the line segment. If there is a line segment phase for
            neutral, it is numbered last.
            '''
        
        })
    '''
    Sequence number provides the numbering for this line segment phase.
    When impedance is directly described, sequence number binds the phase
    to the column and row for entries in the per length phase impedance
    matrix (PhaseImpedanceData of PerLengthPhaseImpedance). When used in
    conjunction with a wire assembly description, sequence number associates
    the line segment phase to a position.
    For a line segment not a part of a parallel line segment group, sequence
    number starts at one and increments by one through each line segment
    phase associated with the line segment. If there is a line segment
    phase for neutral, it is numbered last.
    '''

@dataclass(repr=False)
class ConnectivityNodeContainer(PowerSystemResource):
    '''
    A base class for all objects that may contain connectivity nodes or topological
    nodes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class Equipment(PowerSystemResource):
    '''
    The parts of a power system that are physical devices, electronic or mechanical.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class ConductingEquipment(Equipment):
    '''
    The parts of the AC power system that are designed to carry current or
    that are conductively connected through terminals.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class Conductor(ConductingEquipment):
    '''
    Combination of conducting material with consistent electrical characteristics,
    building a single electrical system, used to carry current between points
    in the power system.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    length: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Segment length for calculating line segment capabilities.
            '''
        
        })
    '''
    Segment length for calculating line segment capabilities.
    '''

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ACLineSegment(Conductor):
    '''
    A line segment is a conductor or combination of conductors, with consistent
    electrical characteristics along its length, building a single electrical
    system that carries alternating current between two points in the power
    system.
    The BaseVoltage at the two ends of a line segment shall have the same BaseVoltage.nominalVoltage.
    However, boundary lines may have slightly different BaseVoltage.nominalVoltages
    and variation is allowed. Larger voltage difference in general requires
    use of an equivalent branch.
    Line segment impedances can be either directly described in electrical
    terms or physical line detail can be provided from which impedances can
    be calculated.
    <b>Directly described impedances</b>
    For symmetrical, transposed three phase line segments, it is sufficient
    to use attributes of the line segment, which describe impedances and admittances
    for the entire length of the line segment. Additionally, line segment impedances
    can be computed by using line segment length and associated per length
    impedances.
    Unbalanced modeling of impedances is supported by the per length phase
    impedance matrix (PerLengthPhaseImpedance) in conjunction with phase-to-sequence
    number mapping supplied by either ACLineSegmentPhase or WirePosition. The
    sequence numbers are referenced by the row and column attributes of the
    per length phase impedance matrix. This method enables single-phase and
    two-phase line segments, and transpositions of phases, to be described
    using the same per length phase impedance matrix. The length of the line
    segment is used in the computation of total impedance values for the line
    segment.
    <b>Line detail characteristics</b>
    There are three approaches to providing line detail and all use WireAssembly
    to supply line positions:
    <ul>
    <li>Option 1 - WireAssembly supplies only line positions. ACLineSegmentPhase
    points to wire type and intraphase spacing and supplies the phase-to-sequence
    number mapping.</li>
    <li>Option 2 - WireAssembly supplies line position and, for each position,
    also supplies wire type and intraphase spacing. ACLineSegmentPhase supplies
    the phase-to-sequence number mapping.</li>
    <li>Option 3 - WireAssembly supplies line position and, for each position,
    also supplies wire type and intraphase spacing and phase. WireAssembly
    therefore supplies the phase-to-sequence number mapping and ACLineSegmentPhase
    is not needed.</li>
    </ul>
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'PerLengthImpedance.ACLineSegments',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Per-length impedance of this line segment.
            '''
        
        })
    '''
    Per-length impedance of this line segment.
    '''

@dataclass(repr=False)
class EnergyConnection(ConductingEquipment):
    '''
    A connection of energy generation or consumption on the power system model.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class EnergyConsumer(EnergyConnection):
    '''
    Generic user of energy - a point of consumption on the power system model.
    EnergyConsumer.pfixed, .qfixed, .pfixedPct and .qfixedPct have meaning
    only if there is no LoadResponseCharacteristic associated with EnergyConsumer
    or if LoadResponseCharacteristic.exponentModel is set to False.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    LoadResponse: Optional[LoadResponseCharacteristic] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LoadResponseCharacteristic.EnergyConsumer',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The load response characteristic of this load. If missing, this load is
            assumed to be constant power.
            '''
        
        })
    '''
    The load response characteristic of this load. If missing, this load
    is assumed to be constant power.
    '''

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class EnergySource(EnergyConnection):
    '''
    A generic equivalent for an energy supplier on a transmission or distribution
    voltage level.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    nominalVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase-to-phase nominal voltage.
            '''
        
        })
    '''
    Phase-to-phase nominal voltage.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence Thevenin resistance.
            '''
        
        })
    '''
    Positive sequence Thevenin resistance.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence Thevenin reactance.
            '''
        
        })
    '''
    Positive sequence Thevenin reactance.
    '''

@dataclass(repr=False)
class RegulatingCondEq(EnergyConnection):
    '''
    A type of conducting equipment that can regulate a quantity (i.e. voltage
    or flow) at a specific point in the network.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    RegulatingControl: Optional[RegulatingControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegulatingControl.RegulatingCondEq',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The regulating control scheme in which this equipment participates.
            '''
        
        })
    '''
    The regulating control scheme in which this equipment participates.
    '''
@stereotype(CIMStereotype.Description)
@dataclass(repr=False)
class PowerElectronicsConnection(RegulatingCondEq):
    '''
    A connection to the AC network for energy production or consumption that
    uses power electronics rather than rotating machines.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    PowerElectronicsUnit: list[PowerElectronicsUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsUnit.PowerElectronicsConnection',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An AC network connection may have several power electronics units connecting
            through it.
            '''
        
        })
    '''
    An AC network connection may have several power electronics units connecting
    through it.
    '''

    controlMode: Optional[ ConverterControlModeKind ] = field(
        default=None,
        metadata={
        'type': 'gmdm enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            Inverter control mode indicating whether reactive power output is based
            on constant PF or constant Q
            '''
        
        })
    '''
    Inverter control mode indicating whether reactive power output is based
    on constant PF or constant Q
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum reactive power limit. This is the maximum (nameplate) limit for
            the unit.
            '''
        
        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit
    for the unit.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum reactive power limit for the unit. This is the minimum (nameplate)
            limit for the unit.
            '''
        
        })
    '''
    Minimum reactive power limit for the unit. This is the minimum (nameplate)
    limit for the unit.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nameplate apparent power rating for the unit.
            The attribute shall have a positive value.
            '''
        
        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
            for short circuit data exchange according to IEC 60909.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily
    used for short circuit data exchange according to IEC 60909.
    The attribute shall be a positive value.
    '''

@dataclass(repr=False)
class RotatingMachine(RegulatingCondEq):
    '''
    A rotating machine which may be used as a generator or motor.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Nameplate apparent power rating for the unit.
            The attribute shall have a positive value.
            '''
        
        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
            for short circuit data exchange according to IEC 60909.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily
    used for short circuit data exchange according to IEC 60909.
    The attribute shall be a positive value.
    '''
@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class AsynchronousMachine(RotatingMachine):
    '''
    A rotating machine whose shaft rotates asynchronously with the electrical
    field. Also known as an induction machine with no external connection to
    the rotor windings, e.g. squirrel-cage induction machine.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class SynchronousMachine(RotatingMachine):
    '''
    An electromechanical device that operates with shaft rotating synchronously
    with the network. It is a single machine operating either as a generator
    or synchronous condenser or pump.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class ShuntCompensator(RegulatingCondEq):
    '''
    A shunt capacitor or reactor or switchable bank of shunt capacitors or
    reactors. A section of a shunt compensator is an individual capacitor or
    reactor. A negative value for bPerSection indicates that the compensator
    is a reactor. ShuntCompensator is a single terminal device. Ground is implied.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    maximumSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum number of sections that may be switched in.
            '''
        
        })
    '''
    The maximum number of sections that may be switched in.
    '''

    normalSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The normal number of sections switched in. The value shall be between zero
            and ShuntCompensator.maximumSections.
            '''
        
        })
    '''
    The normal number of sections switched in. The value shall be between
    zero and ShuntCompensator.maximumSections.
    '''

    aVRDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            An automatic voltage regulation delay (AVRDelay) which is the time delay
            from a change in voltage to when the capacitor is allowed to change state.
            This filters out temporary changes in voltage.
            '''
        
        })
    '''
    An automatic voltage regulation delay (AVRDelay) which is the time
    delay from a change in voltage to when the capacitor is allowed to
    change state. This filters out temporary changes in voltage.
    '''

    nomU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The voltage at which the nominal reactive power may be calculated. This
            should normally be within 10% of the voltage at which the capacitor is
            connected to the network.
            '''
        
        })
    '''
    The voltage at which the nominal reactive power may be calculated.
    This should normally be within 10% of the voltage at which the capacitor
    is connected to the network.
    '''

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class LinearShuntCompensator(ShuntCompensator):
    '''
    A linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    bPerSection: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance per section.
            '''
        
        })
    '''
    Positive sequence shunt (charging) susceptance per section.
    '''

    gPerSection: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance per section.
            '''
        
        })
    '''
    Positive sequence shunt (charging) conductance per section.
    '''

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerTransformer(ConductingEquipment):
    '''
    An electrical device consisting of two or more coupled windings, with or
    without a magnetic core, for introducing mutual coupling between electric
    circuits. Transformers can be used to control voltage and phase shift (active
    power flow).
    A power transformer may be composed of separate transformer tanks that
    need not be identical.
    A power transformer can be modelled with or without tanks and is intended
    for use in both balanced and unbalanced representations. A power transformer
    typically has two terminals, but may have one (grounding), three or more
    terminals.
    The inherited association ConductingEquipment.BaseVoltage should not be
    used. The association from TransformerEnd to BaseVoltage should be used
    instead.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class SeriesCompensator(ConductingEquipment):
    '''
    A Series Compensator is a series capacitor or reactor or an AC transmission
    line without charging susceptance. It is a two terminal device.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence resistance.
            '''
        
        })
    '''
    Positive sequence resistance.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence reactance.
            '''
        
        })
    '''
    Positive sequence reactance.
    '''

@dataclass(repr=False)
class Switch(ConductingEquipment):
    '''
    A generic device designed to close, or open, or both, one or more electric
    circuits. All switches are two terminal devices including grounding switches.
    The ACDCTerminal.connected at the two sides of the switch shall not be
    considered for assessing switch connectivity, i.e. only Switch.open, .normalOpen
    and .locked are relevant.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum continuous current carrying capacity in amps governed by the
            device material and construction.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    The maximum continuous current carrying capacity in amps governed by
    the device material and construction.
    The attribute shall be a positive value.
    '''

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Disconnector(Switch):
    '''
    A mechanical switching device which provides, in the open position, an
    isolating distance in accordance with specified requirements.
    A disconnector is capable of opening and closing a circuit when either
    negligible current is broken or made, or when no significant change in
    the voltage across the terminals of each of the poles of the disconnector
    occurs. It is also capable of carrying currents under normal circuit conditions
    and carrying for a specified time currents under abnormal conditions such
    as those of short circuit.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Fuse(Switch):
    '''
    An overcurrent protective device with a circuit opening fusible part that
    is heated and severed by the passage of overcurrent through it. A fuse
    is considered a switching device because it breaks current.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class ProtectedSwitch(Switch):
    '''
    A ProtectedSwitch is a switching device that can be operated by ProtectionEquipment.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum fault current a breaking device can break safely under prescribed
            conditions of use.
            '''
        
        })
    '''
    The maximum fault current a breaking device can break safely under
    prescribed conditions of use.
    '''

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Breaker(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal circuit conditions and also making, carrying for
    a specified time, and breaking currents under specified abnormal circuit
    conditions e.g. those of short circuit.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class LoadBreakSwitch(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal operating conditions.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Recloser(ProtectedSwitch):
    '''
    Pole-mounted fault interrupter with built-in phase and ground relays, current
    transformer (CT), and supplemental controls.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Sectionaliser(Switch):
    '''
    Automatic switch that will lock open to isolate a faulted section. It may,
    or may not, have load breaking capability. Its primary purpose is to provide
    fault sectionalising at locations where the fault current is either too
    high, or too low, for proper coordination of fuses.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class GeneratingUnit(Equipment):
    '''
    A single or set of synchronous machines for converting mechanical power
    into alternating-current power. For example, individual machines within
    a set may be defined for scheduling purposes while a single control signal
    is derived for the set. In this case there would be a GeneratingUnit for
    each member of the set and an additional GeneratingUnit corresponding to
    the set.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'
    ratedGrossMaxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The unit's gross rated maximum capacity (book value).
            The attribute shall be a positive value.
            '''
        
        })
    '''
    The unit's gross rated maximum capacity (book value).
    The attribute shall be a positive value.
    '''

    RotatingMachine: Optional[RotatingMachine] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'RotatingMachine.GeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#'
        })
    '''
    A synchronous machine may operate as a generator and as such becomes
    a member of a generating unit.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ThermalGeneratingUnit(GeneratingUnit):
    '''
    A generating unit whose prime mover could be a steam turbine, combustion
    turbine, or diesel engine.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = '1'

    FossilFuels: list[FossilFuel] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FossilFuel.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more fossil fuels.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''

    FossilFuels: list[FossilFuel] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FossilFuel.ThermalGeneratingUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A thermal generating unit may have one or more fossil fuels.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class WindGeneratingUnit(GeneratingUnit):
    '''
    A wind driven generating unit, connected to the grid by means of a rotating
    machine. May be used to represent a single turbine or an aggregation.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    windGenUnitType: Optional[ WindGenUnitKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The kind of wind generating unit.
            '''
        
        })
    '''
    The kind of wind generating unit.
    '''

@dataclass(repr=False)
class PowerElectronicsUnit(Equipment):
    '''
    A generating unit or battery or aggregation that connects to the AC network
    using power electronics rather than rotating machines.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum active power limit. This is the maximum (nameplate) limit for the
            unit.
            '''
        
        })
    '''
    Maximum active power limit. This is the maximum (nameplate) limit for
    the unit.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum active power limit. This is the minimum (nameplate) limit for the
            unit.
            '''
        
        })
    '''
    Minimum active power limit. This is the minimum (nameplate) limit for
    the unit.
    '''

    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsConnection.PowerElectronicsUnit',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            A power electronics unit has a connection to the AC network.
            '''
        
        })
    '''
    A power electronics unit has a connection to the AC network.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BatteryUnit(PowerElectronicsUnit):
    '''
    An electrochemical energy storage device.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ratedE: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Full energy storage capacity of the battery. The attribute shall be a positive
            value.
            '''
        
        })
    '''
    Full energy storage capacity of the battery. The attribute shall be
    a positive value.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PhotoVoltaicUnit(PowerElectronicsUnit):
    '''
    A photovoltaic device or an aggregation of such devices.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerElectronicsThermalUnit(PowerElectronicsUnit):
    '''
    A thermal unit that is connected via an inverter such as through a back-to-back
    converter
    '''

    __namespace__ = 'http://epri.com/gmdm/2025#'
    __package__ = 'ProductionEXT'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    FossilFuels: Optional[FossilFuel] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FossilFuel.PowerElectronicsThermalUnit',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''
        
        })
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerElectronicsWindUnit(PowerElectronicsUnit):
    '''
    A wind generating unit that connects to the AC network with power electronics
    rather than rotating machines or an aggregation of such units.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Production'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.ByReference)
@dataclass(repr=False)
class RegulatingControl(PowerSystemResource):
    '''
    Specifies a set of equipment that works together to control a power system
    quantity such as voltage or flow.
    Remote bus voltage control is possible by specifying the controlled terminal
    located at some place remote from the controlling equipment.
    The specified terminal shall be associated with the connectivity node of
    the controlled point. The most specific subtype of RegulatingControl shall
    be used in case such equipment participate in the control, e.g. TapChangerControl
    for tap changers.
    For flow control, load sign convention is used, i.e. positive sign means
    flow out from a TopologicalNode (bus) into the conducting equipment.
    The attribute minAllowedTargetValue and maxAllowedTargetValue are required
    in the following cases:
    - For a power generating module operated in power factor control mode to
    specify maximum and minimum power factor values;
    - Whenever it is necessary to have an off center target voltage for the
    tap changer regulator. For instance, due to long cables to off shore wind
    farms and the need to have a simpler setup at the off shore transformer
    platform, the voltage is controlled from the land at the connection point
    for the off shore wind farm. Since there usually is a voltage rise along
    the cable, there is typical and overvoltage of up 3 to 4 kV compared to
    the on shore station. Thus in normal operation the tap changer on the on
    shore station is operated with a target set point, which is in the lower
    parts of the dead band.
    The attributes minAllowedTargetValue and maxAllowedTargetValue are not
    related to the attribute targetDeadband and thus they are not treated as
    an alternative of the targetDeadband. They are needed due to limitations
    in the local substation controller. The attribute targetDeadband is used
    to prevent the power flow from moving the tap position in circles (hunting)
    that is to be used regardless of the attributes minAllowedTargetValue and
    maxAllowedTargetValue.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'
    discrete: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, indicates that regulation is performed in the simulation in a
            discrete mode. If false, indicates that non-discrete regulation is used
            in the simulation. This applies to equipment with discrete controls, e.g.
            tap changers and shunt compensators.
            '''
        
        })
    '''
    If true, indicates that regulation is performed in the simulation in
    a discrete mode. If false, indicates that non-discrete regulation is
    used in the simulation. This applies to equipment with discrete controls,
    e.g. tap changers and shunt compensators.
    '''

    enabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The flag tells if regulation is enabled.
            '''
        
        })
    '''
    The flag tells if regulation is enabled.
    '''

    targetDeadband: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            This is the deadband set on the controller. It is used with discrete control
            to avoid excessive tap changes in tap changers and state changes in shunt
            compensator banks while regulating. The units in which deadband is expressed
            are based on RegulatingControl.mode. The attribute shall be a positive
            value or zero. If RegulatingControl.discrete is set to "false", the RegulatingControl.targetDeadband
            is to be ignored in simulations. If TapChanger.ctRatio or TapChanger.ptRatio
            are populated, deadband shall be expressed in secondary units.
            Note that for instance, if the targetValue is 100 kV and the targetDeadband
            is 2 kV the range is from 99 to 101 kV.
            '''
        
        })
    '''
    This is the deadband set on the controller. It is used with discrete
    control to avoid excessive tap changes in tap changers and state changes
    in shunt compensator banks while regulating. The units in which deadband
    is expressed are based on RegulatingControl.mode. The attribute shall
    be a positive value or zero. If RegulatingControl.discrete is set to
    "false", the RegulatingControl.targetDeadband is to be ignored in simulations.
    If TapChanger.ctRatio or TapChanger.ptRatio are populated, deadband
    shall be expressed in secondary units.
    Note that for instance, if the targetValue is 100 kV and the targetDeadband
    is 2 kV the range is from 99 to 101 kV.
    '''

    targetValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The target value set on the controller. It is the starting value for a
            steady state solution. This value can be used for the target value without
            the use of schedules. The value has the units appropriate to the mode attribute.
            If used for a TapChangerControl and if TapChanger.ctRatio or TapChanger.ptRatio
            are populated, the target value shall be expressed in secondary units.
            As an example, with PT ratio of 60 on a 12.47 KV distribution system, a
            phase to ground PT has a ratio of 7200 volts primary to 120 volts secondary.
            If the required primary target is 7128 volts for a single phase tap changer
            then the value of targetValue would equal 118.8 volts secondary (7128/60).
            '''
        
        })
    '''
    The target value set on the controller. It is the starting value for
    a steady state solution. This value can be used for the target value
    without the use of schedules. The value has the units appropriate to
    the mode attribute.
    If used for a TapChangerControl and if TapChanger.ctRatio or TapChanger.ptRatio
    are populated, the target value shall be expressed in secondary units.
    As an example, with PT ratio of 60 on a 12.47 KV distribution system,
    a phase to ground PT has a ratio of 7200 volts primary to 120 volts
    secondary. If the required primary target is 7128 volts for a single
    phase tap changer then the value of targetValue would equal 118.8 volts
    secondary (7128/60).
    '''

    mode: Optional[ RegulatingControlModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The regulating control mode presently available. This specification allows
            for determining the kind of regulation without need for obtaining the units
            from a schedule.
            '''
        
        })
    '''
    The regulating control mode presently available. This specification
    allows for determining the kind of regulation without need for obtaining
    the units from a schedule.
    '''

    monitoredPhase: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Phase voltage controlling this regulator, measured at regulator location.
            '''
        
        })
    '''
    Phase voltage controlling this regulator, measured at regulator location.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'Terminal.RegulatingControl',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The terminal associated with this regulating control. The terminal is associated
            instead of a node, since the terminal could connect into either a topological
            node or a connectivity node. Sometimes it is useful to model regulation
            at a terminal of a bus bar object.
            '''
        
        })
    '''
    The terminal associated with this regulating control. The terminal
    is associated instead of a node, since the terminal could connect into
    either a topological node or a connectivity node. Sometimes it is useful
    to model regulation at a terminal of a bus bar object.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TapChangerControl(RegulatingControl):
    '''
    Describes behaviour specific to tap changers, e.g. how the voltage at the
    end of a line varies with the load level and compensation of the voltage
    drop by tap adjustment. When TapChanger.ctRatio and .ptRatio are present,
    RegulatingControl.targetVoltage RegulatingControl.targetDeadband, RegulatingControl.maxAllowedTargetValue,
    RegulatingControl.minAllowedTargetValue as well as TapChangerControl.maxLimitVoltage
    and TapChangerControl.minLimitVoltage shall be expressed in terms of secondary
    CT currents and PT voltages.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'
    lineDropCompensation: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            If true, the line drop compensation is to be applied.
            '''
        
        })
    '''
    If true, the line drop compensation is to be applied.
    '''

    reverseToNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'gmdm Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''
        
        })
    reversible: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'gmdm Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''
        
        })
    lineDropR: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Line drop compensator resistance setting for normal (forward) power flow.
            '''
        
        })
    '''
    Line drop compensator resistance setting for normal (forward) power
    flow.
    '''

    lineDropX: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Line drop compensator reactance setting for normal (forward) power flow.
            '''
        
        })
    '''
    Line drop compensator reactance setting for normal (forward) power
    flow.
    '''

    maxLimitVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Maximum allowed regulated voltage on the PT secondary. This is the locally
            measured secondary voltage, including the effect of any line drop compensation.
            Typically used for distribution circuit voltage regulator. Sometimes referred
            to as first-house protection. If utilized, then TapChanger.ptRatio must
            be supplied.
            '''
        
        })
    '''
    Maximum allowed regulated voltage on the PT secondary. This is the
    locally measured secondary voltage, including the effect of any line
    drop compensation. Typically used for distribution circuit voltage
    regulator. Sometimes referred to as first-house protection. If utilized,
    then TapChanger.ptRatio must be supplied.
    '''

    minLimitVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Minimum allowed regulated voltage on the PT secondary. This is the locally
            measured secondary voltage, including the effect of any line drop compensation.
            Typically used for distribution circuit voltage regulator. Sometimes referred
            to as last-house protection. If utilized, then TapChanger.ptRatio must
            be supplied.
            '''
        
        })
    '''
    Minimum allowed regulated voltage on the PT secondary. This is the
    locally measured secondary voltage, including the effect of any line
    drop compensation. Typically used for distribution circuit voltage
    regulator. Sometimes referred to as last-house protection. If utilized,
    then TapChanger.ptRatio must be supplied.
    '''

    reverseLineDropR: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Line drop compensator resistance setting for reverse power flow.
            '''
        
        })
    '''
    Line drop compensator resistance setting for reverse power flow.
    '''

    reverseLineDropX: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Line drop compensator reactance setting for reverse power flow.
            '''
        
        })
    '''
    Line drop compensator reactance setting for reverse power flow.
    '''

    reverseTargetDeadband: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'gmdm Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''
        
        })
    reverseTargetValue: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'gmdm Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''
        
        })
    reversingDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'gmdm Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''
        
        })
    reversingPowerThreshold: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'gmdm Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''
        
        })
@dataclass(repr=False)
class ShuntCompensatorPhase(PowerSystemResource):
    '''
    Single phase of a multi-phase shunt compensator when its attributes might
    be different per phase.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    maximumSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The maximum number of sections that may be switched in for this phase.
            '''
        
        })
    '''
    The maximum number of sections that may be switched in for this phase.
    '''

    normalSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            For the capacitor phase, the normal number of sections switched in. The
            value shall be between zero and ShuntCompensatorPhase.maximumSections.
            '''
        
        })
    '''
    For the capacitor phase, the normal number of sections switched in.
    The value shall be between zero and ShuntCompensatorPhase.maximumSections.
    '''
@stereotype(CIMStereotype.Description)
@dataclass(repr=False)
class LinearShuntCompensatorPhase(ShuntCompensatorPhase):
    '''
    A per phase linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    bPerSection: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Susceptance per section of the phase if shunt compensator is wye connected.
            Susceptance per section phase to phase if shunt compensator is delta connected.
            '''
        
        })
    '''
    Susceptance per section of the phase if shunt compensator is wye connected.
    Susceptance per section phase to phase if shunt compensator is delta
    connected.
    '''

    gPerSection: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conductance per section for this phase if shunt compensator is wye connected.
            Conductance per section phase to phase if shunt compensator is delta connected.
            '''
        
        })
    '''
    Conductance per section for this phase if shunt compensator is wye
    connected. Conductance per section phase to phase if shunt compensator
    is delta connected.
    '''

@dataclass(repr=False)
class TapChanger(PowerSystemResource):
    '''
    Mechanism for changing transformer winding tap positions.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    controlEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies the regulation status of the equipment. True is regulating, false
            is not regulating.
            '''
        
        })
    '''
    Specifies the regulation status of the equipment. True is regulating,
    false is not regulating.
    '''

    ctRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'gmdm Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://epri.com/gmdm/2025#',
        'docstring':
            '''
            '''
        
        })
    ctRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Built-in current transformer ratio. If a value is specified, then RegulatingControl.targetValue
            (and RegulatingControl.targetDeadband, RegulatingControl.maxAllowedTargetValue
            and RegulatingControl.minAllowedTargetValue) are expressed in secondary
            units.
            '''
        
        })
    '''
    Built-in current transformer ratio. If a value is specified, then RegulatingControl.targetValue
    (and RegulatingControl.targetDeadband, RegulatingControl.maxAllowedTargetValue
    and RegulatingControl.minAllowedTargetValue) are expressed in secondary
    units.
    '''

    highStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Highest possible tap step position, advance from neutral.
            The attribute shall be greater than lowStep.
            '''
        
        })
    '''
    Highest possible tap step position, advance from neutral.
    The attribute shall be greater than lowStep.
    '''

    lowStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Lowest possible tap step position, retard from neutral.
            '''
        
        })
    '''
    Lowest possible tap step position, retard from neutral.
    '''

    ltcFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Specifies whether or not a TapChanger has load tap changing capabilities.
            '''
        
        })
    '''
    Specifies whether or not a TapChanger has load tap changing capabilities.
    '''

    neutralStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The neutral tap step position for this winding.
            The attribute shall be equal to or greater than lowStep and equal or less
            than highStep.
            It is the step position where the voltage is neutralU when the other terminals
            of the transformer are at the ratedU. If there are other tap changers on
            the transformer those taps are kept constant at their neutralStep.
            '''
        
        })
    '''
    The neutral tap step position for this winding.
    The attribute shall be equal to or greater than lowStep and equal or
    less than highStep.
    It is the step position where the voltage is neutralU when the other
    terminals of the transformer are at the ratedU. If there are other
    tap changers on the transformer those taps are kept constant at their
    neutralStep.
    '''

    ptRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Built-in potential (voltage) transformer ratio. If a value is specified,
            then RegulatingControl.targetValue (and RegulatingControl.targetDeadband,
            RegulatingControl.maxAllowedTargetValue, RegulatingControl.minAllowedTargetValue
            as well as TapChangerControl.maxLimitVoltage and TapChangerControl.minLimitVoltage)
            are expressed in secondary units.
            '''
        
        })
    '''
    Built-in potential (voltage) transformer ratio. If a value is specified,
    then RegulatingControl.targetValue (and RegulatingControl.targetDeadband,
    RegulatingControl.maxAllowedTargetValue, RegulatingControl.minAllowedTargetValue
    as well as TapChangerControl.maxLimitVoltage and TapChangerControl.minLimitVoltage)
    are expressed in secondary units.
    '''

    initialDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            For an LTC, the delay for initial tap changer operation (first step change).
            '''
        
        })
    '''
    For an LTC, the delay for initial tap changer operation (first step
    change).
    '''

    neutralU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Voltage at which the winding operates at the neutral tap setting. It is
            the voltage at the terminal of the PowerTransformerEnd associated with
            the tap changer when all tap changers on the transformer are at their neutralStep
            position. Normally neutralU of the tap changer is the same as ratedU of
            the PowerTransformerEnd, but it can differ in special cases such as when
            the tapping mechanism is separate from the winding more common on lower
            voltage transformers.
            This attribute is not relevant for PhaseTapChangerAsymmetrical, PhaseTapChangerSymmetrical
            and PhaseTapChangerLinear.
            '''
        
        })
    '''
    Voltage at which the winding operates at the neutral tap setting. It
    is the voltage at the terminal of the PowerTransformerEnd associated
    with the tap changer when all tap changers on the transformer are at
    their neutralStep position. Normally neutralU of the tap changer is
    the same as ratedU of the PowerTransformerEnd, but it can differ in
    special cases such as when the tapping mechanism is separate from the
    winding more common on lower voltage transformers.
    This attribute is not relevant for PhaseTapChangerAsymmetrical, PhaseTapChangerSymmetrical
    and PhaseTapChangerLinear.
    '''

    subsequentDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            For an LTC, the delay for subsequent tap changer operation (second and
            later step changes).
            '''
        
        })
    '''
    For an LTC, the delay for subsequent tap changer operation (second
    and later step changes).
    '''

    TapChangerControl: Optional[TapChangerControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TapChangerControl.TapChanger',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The regulating control scheme in which this tap changer participates.
            '''
        
        })
    '''
    The regulating control scheme in which this tap changer participates.
    '''

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class RatioTapChanger(TapChanger):
    '''
    A tap changer that changes the voltage ratio impacting the voltage magnitude
    but not the phase angle across the transformer.
    Angle sign convention (general): Positive value indicates a positive phase
    shift from the winding where the tap is located to the other winding (for
    a two-winding transformer).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    stepVoltageIncrement: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Tap step increment, in per cent of rated voltage of the power transformer
            end, per step position.
            When the increment is negative, the voltage decreases when the tap step
            increases.
            '''
        
        })
    '''
    Tap step increment, in per cent of rated voltage of the power transformer
    end, per step position.
    When the increment is negative, the voltage decreases when the tap
    step increases.
    '''

    TransformerEnd: Optional[TransformerEnd] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'TransformerEnd.RatioTapChanger',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Transformer end to which this ratio tap changer belongs.
            '''
        
        })
    '''
    Transformer end to which this ratio tap changer belongs.
    '''

@stereotype(CIMStereotype.Concrete)
@stereotype(CIMStereotype.ByReference)
@dataclass(repr=False)
class TransformerCoreAdmittance(IdentifiedObject):
    '''
    The transformer core admittance. Used to specify the core admittance of
    a transformer in a manner that can be shared among power transformers.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'
    b: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Magnetizing branch susceptance (B mag). The value can be positive or negative.
            '''
        
        })
    '''
    Magnetizing branch susceptance (B mag). The value can be positive or
    negative.
    '''

    g: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Magnetizing branch conductance (G mag).
            '''
        
        })
    '''
    Magnetizing branch conductance (G mag).
    '''

@stereotype(CIMStereotype.ByReference)
@dataclass(repr=False)
class TransformerEnd(IdentifiedObject):
    '''
    A conducting connection point of a power transformer. It corresponds to
    a physical transformer winding terminal. In earlier CIM versions, the TransformerWinding
    class served a similar purpose, but this class is more flexible because
    it associates to terminal but is not a specialization of ConductingEquipment.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    RatioTapChanger: Optional[RatioTapChanger] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RatioTapChanger.TransformerEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Ratio tap changer associated with this transformer end.
            '''
        
        })
    '''
    Ratio tap changer associated with this transformer end.
    '''
    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Used only for Yn and Zn connections indicated by PowerTransformerEnd.connectionKind.
            If true, the neutral is grounded and attributes TransformerEnd.rground
            and TransformerEnd.xground are required. If false, the attributes TransformerEnd.rground
            and TransformerEnd.xground are not considered.
            '''
        
        })
    '''
    Used only for Yn and Zn connections indicated by PowerTransformerEnd.connectionKind.
    If true, the neutral is grounded and attributes TransformerEnd.rground
    and TransformerEnd.xground are required. If false, the attributes TransformerEnd.rground
    and TransformerEnd.xground are not considered.
    '''

    rground: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Resistance part of neutral impedance. Zero indicates solidly grounded or
            grounded through a reactor.
            '''
        
        })
    '''
    Resistance part of neutral impedance. Zero indicates solidly grounded
    or grounded through a reactor.
    '''

    xground: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactance part of neutral impedance. Zero indicates solidly grounded or
            grounded through a reactor.
            '''
        
        })
    '''
    Reactance part of neutral impedance. Zero indicates solidly grounded
    or grounded through a reactor.
    '''

    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEnd',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Core admittance of this transformer end, representing magnetising current
            and core losses. The full values of the transformer should be supplied
            for one transformer end only.
            '''
        
        })
    '''
    Core admittance of this transformer end, representing magnetising current
    and core losses. The full values of the transformer should be supplied
    for one transformer end only.
    '''
@stereotype(CIMStereotype.Description)
@dataclass(repr=False)
class PowerTransformerEnd(TransformerEnd):
    '''
    A PowerTransformerEnd is associated with each Terminal of a PowerTransformer.
    The impedance values r, r0, x, and x0 of a PowerTransformerEnd represents
    a star equivalent as follows.
    1) two PowerTransformerEnd-s shall be defined for a two Terminal PowerTransformer
    even if the two PowerTransformerEnd-s have the same rated voltage. The
    high voltage PowerTransformerEnd (TransformerEnd.endNumber=1) is the one
    used to exchange resistances (r, r0) and reactances (x, x0) of the PowerTransformer
    while the low voltage PowerTransformerEnd (TransformerEnd.endNumber=2)
    shall have zero impedance values.
    2) for a three Terminal PowerTransformer the three PowerTransformerEnds
    represent a star equivalent with each leg in the star represented by r,
    r0, x, and x0 values.
    3) For a three Terminal transformer each PowerTransformerEnd shall have
    g, g0, b and b0 values corresponding to the no load losses distributed
    on the three PowerTransformerEnds. The total no load loss shunt impedances
    may also be placed at one of the PowerTransformerEnds, preferably the end
    numbered 1, having the shunt values on end 1. This is the preferred way.
    4) for a PowerTransformer with more than three Terminals the PowerTransformerEnd
    impedance values cannot be used. Instead use the TransformerMeshImpedance
    or split the transformer into multiple PowerTransformers.
    Each PowerTransformerEnd must be contained by a PowerTransformer. Because
    a PowerTransformerEnd (or any other object) can not be contained by more
    than one parent, a PowerTransformerEnd can not have an association to an
    EquipmentContainer (Substation, VoltageLevel, etc).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    phaseAngleClock: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Terminal voltage phase angle displacement where 360 degrees are represented
            with clock hours. The valid values are 0 to 11. For example, for the secondary
            side end of a transformer with vector group code of 'Dyn11', specify the
            connection kind as wye with neutral and specify the phase angle of the
            clock as 11. The clock value of the transformer end number specified as
            1, is assumed to be zero. Note the transformer end number is not assumed
            to be the same as the terminal sequence number.
            '''
        
        })
    '''
    Terminal voltage phase angle displacement where 360 degrees are represented
    with clock hours. The valid values are 0 to 11. For example, for the
    secondary side end of a transformer with vector group code of 'Dyn11',
    specify the connection kind as wye with neutral and specify the phase
    angle of the clock as 11. The clock value of the transformer end number
    specified as 1, is assumed to be zero. Note the transformer end number
    is not assumed to be the same as the terminal sequence number.
    '''

    b: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Magnetizing branch susceptance (B mag). The value can be positive or negative.
            '''
        
        })
    '''
    Magnetizing branch susceptance (B mag). The value can be positive or
    negative.
    '''

    g: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Magnetizing branch conductance.
            '''
        
        })
    '''
    Magnetizing branch conductance.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Resistance (star-model) of the transformer end.
            The attribute shall be equal to or greater than zero for non-equivalent
            transformers.
            '''
        
        })
    '''
    Resistance (star-model) of the transformer end.
    The attribute shall be equal to or greater than zero for non-equivalent
    transformers.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Normal apparent power rating.
            The attribute shall be a positive value. For a two-winding transformer
            the values for the high and low voltage sides shall be identical.
            '''
        
        })
    '''
    Normal apparent power rating.
    The attribute shall be a positive value. For a two-winding transformer
    the values for the high and low voltage sides shall be identical.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Rated voltage: phase-phase for three-phase windings, and either phase-phase
            or phase-neutral for single-phase windings.
            A high voltage side, as given by TransformerEnd.endNumber, shall have a
            ratedU that is greater than or equal to ratedU for the lower voltage sides.
            The attribute shall be a positive value.
            '''
        
        })
    '''
    Rated voltage: phase-phase for three-phase windings, and either phase-phase
    or phase-neutral for single-phase windings.
    A high voltage side, as given by TransformerEnd.endNumber, shall have
    a ratedU that is greater than or equal to ratedU for the lower voltage
    sides.
    The attribute shall be a positive value.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Positive sequence series reactance (star-model) of the transformer end.
            '''
        
        })
    '''
    Positive sequence series reactance (star-model) of the transformer
    end.
    '''

@stereotype(CIMStereotype.Description)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerTankEnd(TransformerEnd):
    '''
    Transformer tank end represents an individual winding for unbalanced models
    or for transformer tanks connected into a bank (and bank is modelled with
    the PowerTransformer).
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerMeshImpedance(IdentifiedObject):
    '''
    Transformer mesh impedance (Delta-model) between transformer ends.
    The typical case is that this class describes the impedance between two
    transformer ends pair-wise, i.e. the cardinalities at both transformer
    end associations are 1. However, in cases where two or more transformer
    ends are modelled the cardinalities are larger than 1.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Resistance between the 'from' and the 'to' end, seen from the 'from' end.
            '''
        
        })
    '''
    Resistance between the 'from' and the 'to' end, seen from the 'from'
    end.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactance between the 'from' and the 'to' end, seen from the 'from' end.
            '''
        
        })
    '''
    Reactance between the 'from' and the 'to' end, seen from the 'from'
    end.
    '''

    FromTransformerEnd: Optional[TransformerEnd] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEnd.FromMeshImpedance',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            From end this mesh impedance is connected to. It determines the voltage
            reference.
            '''
        
        })
    '''
    From end this mesh impedance is connected to. It determines the voltage
    reference.
    '''

    ToTransformerEnd: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.ToMeshImpedance',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            All transformer ends this mesh impedance is connected to.
            '''
        
        })
    '''
    All transformer ends this mesh impedance is connected to.
    '''
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PhaseImpedanceData(Identity):
    '''
    Per length phase impedance matrix entry describes impedance and conductance
    matrix element values for a specific row and column of the matrix.
    The phases to which each entry applies can be determined by means of the
    row and column attributes which bind to a sequence number provided in either
    ACLineSegmentPhase or WirePosition (which also specify phase). Due to physical
    symmetry that is reflected in the matrix, only the lower triangle of the
    matrix is populated with the row and column method. That is, the column
    attribute is always less than or equal to the row attribute.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Wires'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    column: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The matrix entry's column number has a range of possible values from 1
            to the conductor count of the matrix, but due to symmetry, only entries
            in the lower triangle (including diagonal) of the matrix need be defined.
            Column number binds to the sequence number in either ACLineSegmentPhase
            or WirePosition, which then identifies the phase for this entry.
            '''
        
        })
    '''
    The matrix entry's column number has a range of possible values from
    1 to the conductor count of the matrix, but due to symmetry, only entries
    in the lower triangle (including diagonal) of the matrix need be defined.
    Column number binds to the sequence number in either ACLineSegmentPhase
    or WirePosition, which then identifies the phase for this entry.
    '''

    row: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The matrix entry's row number has a range of possible values from 1 to
            the conductor count of the matrix, but due to symmetry, only entries in
            the lower triangle (including diagonal) of the matrix need be defined.
            Row number binds to the sequence number in either ACLineSegmentPhase or
            WirePosition, which then identifies the phase for this entry.
            '''
        
        })
    '''
    The matrix entry's row number has a range of possible values from 1
    to the conductor count of the matrix, but due to symmetry, only entries
    in the lower triangle (including diagonal) of the matrix need be defined.
    Row number binds to the sequence number in either ACLineSegmentPhase
    or WirePosition, which then identifies the phase for this entry.
    '''

    b: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Susceptance matrix entry value, per length of unit.
            '''
        
        })
    '''
    Susceptance matrix entry value, per length of unit.
    '''

    r: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Resistance matrix entry value, per length of unit.
            '''
        
        })
    '''
    Resistance matrix entry value, per length of unit.
    '''

    x: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '1',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Reactance matrix entry value, per length of unit.
            '''
        
        })
    '''
    Reactance matrix entry value, per length of unit.
    '''

    PhaseImpedance: Optional[PerLengthPhaseImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthPhaseImpedance.PhaseImpedanceData',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            Conductor phase impedance to which this data belongs.
            '''
        
        })
    '''
    Conductor phase impedance to which this data belongs.
    '''

@stereotype(CIMStereotype.Enumeration)
class ConverterControlModeKind(Enum):
    '''
    '''

    constantPowerFactor = 'constantPowerFactor'

    constantReactivePower = 'constantReactivePower'

    dynamic = 'dynamic'

@stereotype(CIMStereotype.Enumeration)
class FuelType(Enum):
    '''
    Type of fuel.
    '''

    brownCoalLignite = 'brownCoalLignite'
    '''
    Brown coal lignite.
    '''

    coal = 'coal'
    '''
    Generic coal, not including lignite type.
    '''

    coalDerivedGas = 'coalDerivedGas'
    '''
    Coal derived gas.
    '''

    diesel = 'diesel'
    '''
    Diesel
    '''

    gas = 'gas'
    '''
    Natural gas.
    '''

    hardCoal = 'hardCoal'
    '''
    Hard coal.
    '''

    lignite = 'lignite'
    '''
    The fuel is lignite coal. Note that this is a special type of coal,
    so the other enum of coal is reserved for hard coal types or if the
    exact type of coal is not known.
    '''

    oil = 'oil'
    '''
    Oil.
    '''

    oilShale = 'oilShale'
    '''
    Oil Shale.
    '''

    other = 'other'
    '''
    Any fuel type not included in the rest of the enumerated value.
    '''

    peat = 'peat'
    '''
    Peat.
    '''

@stereotype(CIMStereotype.Enumeration)
class PhaseCode(Enum):
    '''
    Enumeration of phase identifiers used to designate the combination of phase
    and/or neutral conductors at a terminal, measurement or equipment modelled
    as a single-line balanced equivalent.
    This is an unordered enumeration of phase identifiers. Allows designation
    of phases for both transmission and distribution equipment, circuits and
    loads. The enumeration, by itself, does not describe how the phases are
    connected together or connected to ground. Ground is not explicitly denoted
    as a phase.
    Residential and small commercial loads are often served from single-phase,
    or split-phase, secondary circuits. For the example of s12N, phases 1 and
    2 refer to hot wires that are 180 degrees out of phase, while N refers
    to the neutral wire. Through single-phase transformer connections, these
    secondary circuits may be served from one or two of the primary phases
    A, B, and C. For three-phase loads, use the A, B, C phase codes instead
    of s12N.
    The integer values are from IEC 61968-9 to support revenue metering applications.
    '''

    A = 'A'
    '''
    Phase A.
    '''

    AB = 'AB'
    '''
    Phases A and B.
    '''

    ABC = 'ABC'
    '''
    Phases A, B, and C.
    '''

    ABCN = 'ABCN'
    '''
    Phases A, B, C, and N.
    '''

    ABN = 'ABN'
    '''
    Phases A, B, and neutral.
    '''

    AC = 'AC'
    '''
    Phases A and C.
    '''

    ACN = 'ACN'
    '''
    Phases A, C and neutral.
    '''

    AN = 'AN'
    '''
    Phases A and neutral.
    '''

    B = 'B'
    '''
    Phase B.
    '''

    BC = 'BC'
    '''
    Phases B and C.
    '''

    BCN = 'BCN'
    '''
    Phases B, C, and neutral.
    '''

    BN = 'BN'
    '''
    Phases B and neutral.
    '''

    C = 'C'
    '''
    Phase C.
    '''

    CN = 'CN'
    '''
    Phases C and neutral.
    '''

    N = 'N'
    '''
    Neutral phase.
    '''

    X = 'X'
    '''
    Unknown non-neutral phase.
    '''

    XN = 'XN'
    '''
    Unknown non-neutral phase plus neutral.
    '''

    XY = 'XY'
    '''
    Two unknown non-neutral phases.
    '''

    XYN = 'XYN'
    '''
    Two unknown non-neutral phases plus neutral.
    '''

    none = 'none'
    '''
    No phases specified.
    '''

    s1 = 's1'
    '''
    Secondary phase 1.
    '''

    s12 = 's12'
    '''
    Secondary phase 1 and 2.
    '''

    s12N = 's12N'
    '''
    Secondary phases 1, 2, and neutral.
    '''

    s1N = 's1N'
    '''
    Secondary phase 1 and neutral.
    '''

    s2 = 's2'
    '''
    Secondary phase 2.
    '''

    s2N = 's2N'
    '''
    Secondary phase 2 and neutral.
    '''

@stereotype(CIMStereotype.Enumeration)
class RegulatingControlModeKind(Enum):
    '''
    The kind of regulation model. For example regulating voltage, reactive
    power, active power, etc.
    '''

    activePower = 'activePower'
    '''
    Active power is specified.
    '''

    admittance = 'admittance'
    '''
    Admittance is specified.
    '''

    currentFlow = 'currentFlow'
    '''
    Current flow is specified.
    '''

    powerFactor = 'powerFactor'
    '''
    Power factor is specified.
    '''

    reactivePower = 'reactivePower'
    '''
    Reactive power is specified.
    '''

    temperature = 'temperature'
    '''
    Control switches on/off based on the local temperature (i.e., a thermostat).
    '''

    timeScheduled = 'timeScheduled'
    '''
    Control switches on/off by time of day. The times may change on the
    weekend, or in different seasons.
    '''

    voltage = 'voltage'
    '''
    Voltage is specified.
    '''

@stereotype(CIMStereotype.Enumeration)
class WindGenUnitKind(Enum):
    '''
    Kind of wind generating unit.
    '''

    offshore = 'offshore'
    '''
    The wind generating unit is located offshore.
    '''

    onshore = 'onshore'
    '''
    The wind generating unit is located onshore.
    '''

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ActivePower(CIMUnit):
    '''
    Product of RMS value of the voltage and the RMS value of the in-phase component
    of the current.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.W
    def __init__(self, value, input_unit: str='W', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ApparentPower(CIMUnit):
    '''
    Product of the RMS value of the voltage and the RMS value of the current.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.VA
    def __init__(self, value, input_unit: str='VA', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Conductance(CIMUnit):
    '''
    Factor by which voltage must be multiplied to give corresponding power
    lost from a circuit. Real part of admittance.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.S
    def __init__(self, value, input_unit: str='S', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class CurrentFlow(CIMUnit):
    '''
    Electrical current with sign convention: positive flow is out of the conducting
    equipment into the connectivity node. Can be both AC and DC.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.A
    def __init__(self, value, input_unit: str='A', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Length(CIMUnit):
    '''
    Unit of length. It shall be a positive value or zero.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.m
    def __init__(self, value, input_unit: str='m', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class PerCent(CIMUnit):
    '''
    Percentage on a defined base. For example, specify as 100 to indicate at
    the defined base.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.none
    def __init__(self, value, input_unit: str='none', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Reactance(CIMUnit):
    '''
    Reactance (imaginary part of impedance), at rated frequency.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohm
    def __init__(self, value, input_unit: str='ohm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ReactancePerLength(CIMUnit):
    '''
    Reactance (imaginary part of impedance) per unit of length, at rated frequency.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohmPerm
    def __init__(self, value, input_unit: str='ohmPerm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ReactivePower(CIMUnit):
    '''
    Product of RMS value of the voltage and the RMS value of the quadrature
    component of the current.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.VAr
    def __init__(self, value, input_unit: str='VAr', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class RealEnergy(CIMUnit):
    '''
    Real electrical energy.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.Wh
    def __init__(self, value, input_unit: str='Wh', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Resistance(CIMUnit):
    '''
    Resistance (real part of impedance).
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohm
    def __init__(self, value, input_unit: str='ohm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ResistancePerLength(CIMUnit):
    '''
    Resistance (real part of impedance) per unit of length.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohmPerm
    def __init__(self, value, input_unit: str='ohmPerm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Seconds(CIMUnit):
    '''
    Time, in seconds.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.s
    def __init__(self, value, input_unit: str='s', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Susceptance(CIMUnit):
    '''
    Imaginary part of admittance.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.S
    def __init__(self, value, input_unit: str='S', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class SusceptancePerLength(CIMUnit):
    '''
    Imaginary part of admittance per unit of length.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.SPerm
    def __init__(self, value, input_unit: str='SPerm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Voltage(CIMUnit):
    '''
    Electrical voltage, can be both AC and DC.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.V
    def __init__(self, value, input_unit: str='V', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
