from __future__ import annotations

import logging
from dataclasses import dataclass, field
from enum import Enum
from typing import Optional

from cimgraph.data_profile.identity import Identity, stereotype
from cimgraph.data_profile.units import CIMUnit, UnitMultiplier, UnitSymbol

_log = logging.getLogger(__name__)
'''
Annotated CIMantic Graphs data profile for MarketNode
Generated by CIMTool http://cimtool.org
'''

class CIMStereotype(Enum):
    Attribute = 'Attribute'
    ByReference = 'ByReference'
    Primitive = 'Primitive'

BASE_URI = 'http://www.ucaiug.org/gmdm/marketnode#'
ONTOLOGY_URI = 'http://cim.ucaiug.io/CIM101/draft#'

@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a class that provides common identification for all classes needing
    identification and naming attributes.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The description is a free human readable text describing or naming the
            object. It may be non unique and may not correlate to a naming hierarchy.
            '''

        })
    '''
    The description is a free human readable text describing or naming
    the object. It may be non unique and may not correlate to a naming
    hierarchy.
    '''

    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            The name is any free human readable and possibly non unique text naming
            the object.
            '''

        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''

@stereotype(CIMStereotype.ByReference)
@dataclass(repr=False)
class ConnectivityNode(IdentifiedObject):
    '''
    Connectivity nodes are points where terminals of AC conducting equipment
    are connected together with zero impedance.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'Core'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    IndividualPnode: Optional[IndividualPnode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IndividualPnode.ConnectivityNode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

@dataclass(repr=False)
class Pnode(IdentifiedObject):
    '''
    A pricing node is directly associated with a connectivity node. It is a
    pricing location for which market participants submit their bids, offers,
    buy/sell CRRs, and settle.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ReferenceData'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

@dataclass(repr=False)
class IndividualPnode(Pnode):
    '''
    Individual pricing node based on Pnode.
    '''

    __namespace__ = 'http://cim.ucaiug.io/CIM101/draft#'
    __package__ = 'ReferenceData'
    __minOccurs__ = '0'
    __maxOccurs__ = 'unbounded'

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'ByReference',
        'minOccurs': '1',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.IndividualPnode',
        'namespace': 'http://cim.ucaiug.io/CIM101/draft#',
        'docstring':
            '''
            '''

        })
    '''
    '''

