from __future__ import annotations
import logging
from dataclasses import dataclass, field
from typing import Optional
from enum import Enum
from cimgraph.data_profile.identity import Identity, stereotype
from cimgraph.data_profile.units import CIMUnit, UnitSymbol, UnitMultiplier
_log = logging.getLogger(__name__)
'''
Annotated CIMantic Graphs data profile for Profile
Generated by CIMTool http://cimtool.org
'''

class CIMStereotype(Enum):
    AggregateOf = "AggregateOf"
    Attribute = "Attribute"
    CIMDatatype = "CIMDatatype"
    Compound = "Compound"
    Concrete = "Concrete"
    OfAggregate = "OfAggregate"
    Primitive = "Primitive"
    enumeration = "enumeration"
    informative = "informative"

BASE_URI = 'http://gridappsd.org/cimhub/2023#'
ONTOLOGY_URI = 'http://iec.ch/TC57/CIM100#'

@dataclass(repr=False)
class AreaConfiguration(Identity):
    '''
    Alternate configurations for abnormal feeder switching conditions. The
    distribution feeder can be segmented into source and sink SubSchedulingArea
    to represent upstream and downstream sections relative to the head terminal.
    '''

    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Value 0 means ignore priority. 1 means the highest priority, 2 is the second
            highest priority.
            '''
        
        })
    '''
    Value 0 means ignore priority. 1 means the highest priority, 2 is the
    second highest priority.
    '''
    
    EnergizedArea: Optional[SubSchedulingArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubSchedulingArea.SinkConfiguration',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The sink area being energized by the source area.
            '''
        
        })
    '''
    The sink area being energized by the source area.
    '''
    
    EnergizingArea: Optional[SubSchedulingArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubSchedulingArea.SourceConfiguration',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The source area which is energizing the sink area
            '''
        
        })
    '''
    The source area which is energizing the sink area
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Containment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AssetOwner(Identity):
    '''
    Owner of the asset.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    Ownerships: list[Ownership] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Ownership.AssetOwner',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All ownerships of this owner.
            '''
        
        })
    '''
    All ownerships of this owner.
    '''
    
@dataclass(repr=False)
class BranchGroupTerminal(Identity):
    '''
    A specific directed terminal flow for a branch group.
    '''

    positiveFlowIn: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The flow into the terminal is summed if set true. The flow out of the terminanl
            is summed if set false.
            '''
        
        })
    '''
    The flow into the terminal is summed if set true. The flow out of the
    terminanl is summed if set false.
    '''
    
    BranchGroup: Optional[BranchGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BranchGroup.BranchGroupTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The branch group to which the directed branch group terminals belong.
            '''
        
        })
    '''
    The branch group to which the directed branch group terminals belong.
    '''
    
    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.BranchGroupTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The terminal to be summed.
            '''
        
        })
    '''
    The terminal to be summed.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CurveData(Identity):
    '''
    Multi-purpose data points for defining a curve. The use of this generic
    class is discouraged if a more specific class can be used to specify the
    x and y axis values along with their specific data types.
    '''

    xvalue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The data value of the X-axis variable, depending on the X-axis units.
            '''
        
        })
    '''
    The data value of the X-axis variable, depending on the X-axis units.
    '''
    
    y1value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The data value of the first Y-axis variable, depending on the Y-axis units.
            '''
        
        })
    '''
    The data value of the first Y-axis variable, depending on the Y-axis
    units.
    '''
    
    y2value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The data value of the second Y-axis variable (if present), depending on
            the Y-axis units.
            '''
        
        })
    '''
    The data value of the second Y-axis variable (if present), depending
    on the Y-axis units.
    '''
    
    y3value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The data value of the third Y-axis variable (if present), depending on
            the Y-axis units.
            '''
        
        })
    '''
    The data value of the third Y-axis variable (if present), depending
    on the Y-axis units.
    '''
    
    Curve: Optional[Curve] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Curve.CurveDatas',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The curve of this curve data point.
            '''
        
        })
    '''
    The curve of this curve data point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DERDynamics(Identity):
    '''
    Parent class supporting relationships to DER dynamics models.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'IEEE1547Dynamics'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    AsynchronousMachine: list[AsynchronousMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AsynchronousMachine.DERDynamics',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Asynchronous machine model with which this DER dynamics model is associated.
            '''
        
        })
    '''
    Asynchronous machine model with which this DER dynamics model is associated.
    '''
    
    PowerElectronicsConnection: list[PowerElectronicsConnection] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsConnection.DERDynamics',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Power electronics connection with which this DER dynamics model is associated.
            '''
        
        })
    '''
    Power electronics connection with which this DER dynamics model is
    associated.
    '''
    
    SynchronousMachine: list[SynchronousMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SynchronousMachine.DERDynamics',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Synchronous machine model with which this DER dynamics model is associated.
            '''
        
        })
    '''
    Synchronous machine model with which this DER dynamics model is associated.
    '''
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class EV(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class EVCharger(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Estimate(Identity):
    '''
    '''

    timeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    SvEstVoltages: list[SvEstVoltage] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvEstVoltage.Estimate',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class IEC61968CIMVersion(Identity):
    '''
    IEC 61968 version number assigned to this UML model.
    '''

    date: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Form is YYYY-MM-DD for example for January 5, 2009 it is 2009-01-05.
            '''
        
        })
    '''
    Form is YYYY-MM-DD for example for January 5, 2009 it is 2009-01-05.
    '''
    
    version: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Form is IEC61968CIMXXvYY where XX is the major CIM package version and
            the YY is the minor version. For example IEC61968CIM10v17.
            '''
        
        })
    '''
    Form is IEC61968CIMXXvYY where XX is the major CIM package version
    and the YY is the minor version. For example IEC61968CIM10v17.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'IEC61968'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IEC61970CIMVersion(Identity):
    '''
    This is the IEC 61970 CIM version number assigned to this UML model.
    '''

    date: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Form is YYYY-MM-DD for example for January 5, 2009 it is 2009-01-05.
            '''
        
        })
    '''
    Form is YYYY-MM-DD for example for January 5, 2009 it is 2009-01-05.
    '''
    
    version: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Form is IEC61970CIMXXvYY where XX is the major CIM package version and
            the YY is the minor version. For example IEC61970CIM13v18.
            '''
        
        })
    '''
    Form is IEC61970CIMXXvYY where XX is the major CIM package version
    and the YY is the minor version. For example IEC61970CIM13v18.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'IEC61970'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IEEE1547ControlSettings(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DER'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    PowerElectronicsConnections: list[PowerElectronicsConnection] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsConnection.IEEE1547ControlSettings',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RotatingMachines: list[RotatingMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RotatingMachine.IEEE1547ControlSettings',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class IEEE1547Setting(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DER'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    PowerElectronicsConnections: list[PowerElectronicsConnection] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsConnection.IEEE1547Setting',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RotatingMachines: list[RotatingMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RotatingMachine.IEEE1547Setting',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class IEEE1547TripSettings(Identity):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'DER'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    PowerElectronicsConnections: list[PowerElectronicsConnection] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsConnection.IEEE1547TripSettings',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RotatingMachines: list[RotatingMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RotatingMachine.IEEE1547TripSettings',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a root class to provide common identification for all classes needing
    identification and naming attributes.
    '''

    mRID: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Master resource identifier issued by a model authority. The mRID is unique
            within an exchange context. Global uniqueness is easily achieved by using
            a UUID, as specified in RFC 4122, for the mRID. The use of UUID is strongly
            recommended.
            For CIMXML data files in RDF syntax conforming to IEC 61970-552 Edition
            1, the mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
            object elements.
            '''
        
        })
    '''
    Master resource identifier issued by a model authority. The mRID is
    unique within an exchange context. Global uniqueness is easily achieved
    by using a UUID, as specified in RFC 4122, for the mRID. The use of
    UUID is strongly recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552 Edition
    1, the mRID is mapped to rdf:ID or rdf:about attributes that identify
    CIM object elements.
    '''
    
    aliasName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The aliasName is free text human readable name of the object alternative
            to IdentifiedObject.name. It may be non unique and may not correlate to
            a naming hierarchy.
            The attribute aliasName is retained because of backwards compatibility
            between CIM relases. It is however recommended to replace aliasName with
            the Name class as aliasName is planned for retirement at a future time.
            '''
        
        })
    '''
    The aliasName is free text human readable name of the object alternative
    to IdentifiedObject.name. It may be non unique and may not correlate
    to a naming hierarchy.
    The attribute aliasName is retained because of backwards compatibility
    between CIM relases. It is however recommended to replace aliasName
    with the Name class as aliasName is planned for retirement at a future
    time.
    '''
    
    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The description is a free human readable text describing or naming the
            object. It may be non unique and may not correlate to a naming hierarchy.
            '''
        
        })
    '''
    The description is a free human readable text describing or naming
    the object. It may be non unique and may not correlate to a naming
    hierarchy.
    '''
    
    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The name is any free human readable and possibly non unique text naming
            the object.
            '''
        
        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    Names: list[Name] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Name.IdentifiedObject',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All names of this identified object.
            '''
        
        })
    '''
    All names of this identified object.
    '''
    
@dataclass(repr=False)
class ACDCTerminal(IdentifiedObject):
    '''
    An electrical connection point (AC or DC) to a piece of conducting equipment.
    Terminals are connected at physical connection points called connectivity
    nodes.
    '''

    connected: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The connected status is related to a bus-branch model and the topological
            node to terminal relation. True implies the terminal is connected to the
            related topological node and false implies it is not.
            In a bus-branch model, the connected status is used to tell if equipment
            is disconnected without having to change the connectivity described by
            the topological node to terminal relation. A valid case is that conducting
            equipment can be connected in one end and open in the other. In particular
            for an AC line segment, where the reactive line charging can be significant,
            this is a relevant case.
            '''
        
        })
    '''
    The connected status is related to a bus-branch model and the topological
    node to terminal relation. True implies the terminal is connected to
    the related topological node and false implies it is not.
    In a bus-branch model, the connected status is used to tell if equipment
    is disconnected without having to change the connectivity described
    by the topological node to terminal relation. A valid case is that
    conducting equipment can be connected in one end and open in the other.
    In particular for an AC line segment, where the reactive line charging
    can be significant, this is a relevant case.
    '''
    
    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The orientation of the terminal connections for a multiple terminal conducting
            equipment. The sequence numbering starts with 1 and additional terminals
            should follow in increasing order. The first terminal is the "starting
            point" for a two terminal branch.
            '''
        
        })
    '''
    The orientation of the terminal connections for a multiple terminal
    conducting equipment. The sequence numbering starts with 1 and additional
    terminals should follow in increasing order. The first terminal is
    the "starting point" for a two terminal branch.
    '''
    
    BusNameMarker: Optional[BusNameMarker] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BusNameMarker.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The bus name marker used to name the bus (topological node).
            '''
        
        })
    '''
    The bus name marker used to name the bus (topological node).
    '''
    
    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Measurements associated with this terminal defining where the measurement
            is placed in the network topology. It may be used, for instance, to capture
            the sensor position, such as a voltage transformer (PT) at a busbar or
            a current transformer (CT) at the bar between a breaker and an isolator.
            '''
        
        })
    '''
    Measurements associated with this terminal defining where the measurement
    is placed in the network topology. It may be used, for instance, to
    capture the sensor position, such as a voltage transformer (PT) at
    a busbar or a current transformer (CT) at the bar between a breaker
    and an isolator.
    '''
    
    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Terminal(ACDCTerminal):
    '''
    An AC electrical connection point to a piece of conducting equipment. Terminals
    are connected at physical connection points called connectivity nodes.
    '''

    BoundedSchedulingArea: Optional[SubSchedulingArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubSchedulingArea.BoundaryTerminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The SubSchedulingArea bounded by the specific Terminal
            '''
        
        })
    '''
    The SubSchedulingArea bounded by the specific Terminal
    '''
    
    Bushing: Optional[Bushing] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Bushing.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ConductingEquipment: Optional[ConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConductingEquipment.Terminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The conducting equipment of the terminal. Conducting equipment have terminals
            that may be connected to other conducting equipment terminals via connectivity
            nodes or topological nodes.
            '''
        
        })
    '''
    The conducting equipment of the terminal. Conducting equipment have
    terminals that may be connected to other conducting equipment terminals
    via connectivity nodes or topological nodes.
    '''
    
    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.Terminals',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The connectivity node to which this terminal connects with zero impedance.
            '''
        
        })
    '''
    The connectivity node to which this terminal connects with zero impedance.
    '''
    
    NormalHeadFeeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.NormalHeadTerminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The feeder that this terminal normally feeds. Only specifed for the terminals
            at head of feeders.
            '''
        
        })
    '''
    The feeder that this terminal normally feeds. Only specifed for the
    terminals at head of feeders.
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The topological node associated with the terminal. This can be used as
            an alternative to the connectivity node path to topological node, thus
            making it unneccesary to model connectivity nodes in some cases. Note that
            the if connectivity nodes are in the model, this association would probably
            not be used as an input specification.
            '''
        
        })
    '''
    The topological node associated with the terminal. This can be used
    as an alternative to the connectivity node path to topological node,
    thus making it unneccesary to model connectivity nodes in some cases.
    Note that the if connectivity nodes are in the model, this association
    would probably not be used as an input specification.
    '''
    
    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BranchGroupTerminal.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The directed branch group terminals for which this terminal is monitored.
            '''
        
        })
    '''
    The directed branch group terminals for which this terminal is monitored.
    '''
    
    EquipmentFaults: list[EquipmentFault] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EquipmentFault.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The equipment faults at this terminal.
            '''
        
        })
    '''
    The equipment faults at this terminal.
    '''
    
    HasFirstMutualCoupling: list[MutualCoupling] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MutualCoupling.First_Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Mutual couplings associated with the branch as the first branch.
            '''
        
        })
    '''
    Mutual couplings associated with the branch as the first branch.
    '''
    
    HasSecondMutualCoupling: list[MutualCoupling] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MutualCoupling.Second_Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Mutual couplings with the branch associated as the first branch.
            '''
        
        })
    '''
    Mutual couplings with the branch associated as the first branch.
    '''
    
    RegulatingControl: list[RegulatingControl] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulatingControl.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The controls regulating this terminal.
            '''
        
        })
    '''
    The controls regulating this terminal.
    '''
    
    SvPowerFlow: list[SvPowerFlow] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvPowerFlow.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The power flow state variable associated with the terminal.
            '''
        
        })
    '''
    The power flow state variable associated with the terminal.
    '''
    
    TransformerEnd: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.Terminal',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All transformer ends connected at this terminal.
            '''
        
        })
    '''
    All transformer ends connected at this terminal.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Asset(IdentifiedObject):
    '''
    Tangible resource of the utility, including power system equipment, various
    end devices, cabinets, buildings, etc. For electrical network equipment,
    the role of the asset is defined through PowerSystemResource and its subclasses,
    defined mainly in the Wires model (refer to IEC61970-301 and model package
    IEC61970::Wires). Asset description places emphasis on the physical characteristics
    of the equipment fulfilling that role.
    '''

    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Ownerships: list[Ownership] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Ownership.Asset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All ownerships of this asset.
            '''
        
        })
    '''
    All ownerships of this asset.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Bushing(Asset):
    '''
    Bushing asset.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.Bushing',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.informative)
@dataclass(repr=False)
class DuctBank(Asset):
    '''
    A duct contains individual wires in the layout as specified with associated
    wire spacing instances; number of them gives the number of conductors in
    this duct.
    '''

    WireSpacingInfos: list[WireSpacingInfo] = field(
        default_factory=list,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireSpacingInfo.DuctBank',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AssetInfo(IdentifiedObject):
    '''
    Set of attributes of an asset, representing typical datasheet information
    of a physical device that can be instantiated and shared in different data
    exchange contexts:
    - as attributes of an asset instance (installed or in stock)
    - as attributes of an asset model (product by a manufacturer)
    - as attributes of a type asset (generic type of an asset as used in designs/extension
    planning).
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.AssetDatasheet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All power system resources with this datasheet information.
            '''
        
        })
    '''
    All power system resources with this datasheet information.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Assets'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BusbarSectionInfo(AssetInfo):
    '''
    Busbar section data.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated current.
            '''
        
        })
    '''
    Rated current.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BushingInfo(AssetInfo):
    '''
    Bushing datasheet information.
    '''

    c1Capacitance: Optional[ float | Capacitance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Factory measured capacitance, measured between the power factor tap and
            the bushing conductor.
            '''
        
        })
    '''
    Factory measured capacitance, measured between the power factor tap
    and the bushing conductor.
    '''
    
    c1PowerFactor: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Factory measured insulation power factor, measured between the power factor
            tap and the bushing conductor.
            '''
        
        })
    '''
    Factory measured insulation power factor, measured between the power
    factor tap and the bushing conductor.
    '''
    
    c2Capacitance: Optional[ float | Capacitance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Factory measured capacitance measured between the power factor tap and
            ground.
            '''
        
        })
    '''
    Factory measured capacitance measured between the power factor tap
    and ground.
    '''
    
    c2PowerFactor: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Factory measured insulation power factor, measured between the power factor
            tap and ground.
            '''
        
        })
    '''
    Factory measured insulation power factor, measured between the power
    factor tap and ground.
    '''
    
    insulationKind: Optional[ BushingInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Kind of insulation.
            '''
        
        })
    '''
    Kind of insulation.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated current for bushing as installed.
            '''
        
        })
    '''
    Rated current for bushing as installed.
    '''
    
    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
            '''
        
        })
    '''
    Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
    '''
    
    ratedLineToGroundVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated line-to-ground voltage. Also referred to as U<sub>y</sub> on bushing
            nameplate.
            '''
        
        })
    '''
    Rated line-to-ground voltage. Also referred to as U<sub>y</sub> on
    bushing nameplate.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated voltage. Can be referred to as U<sub>m</sub>, system voltage or class
            on bushing nameplate.
            '''
        
        })
    '''
    Rated voltage. Can be referred to as U<sub>m</sub>, system voltage
    or class on bushing nameplate.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IEEE1547Info(AssetInfo):
    '''
    '''

    manufacturer: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    model: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    overExcitedPF: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    serialNumber: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    supportsDynamicReactiveCurrent: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    supportsIEC61850: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    supportsIEEE1815: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    supportsIEEE20305: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    supportsIslanding: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    supportsSunSpecModBusEthernet: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    supportsSunSpecModBusRS485: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    supportsVoltWatt: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    supportsWattVar: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    underExcitedPF: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    version: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    abnormalPerformanceCategory: Optional[ IEEE1547AbnormalPerfomanceCategory ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    islandingCategory: Optional[ IEEE1547IslandingCategory ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    maximumU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    minimumU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    normalPerformanceCategory: Optional[ IEEE1547NormalPerformanceCategory ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ratedPatUnityPF: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ratedPcharge: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ratedPoverExcited: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ratedPunderExcited: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ratedQabsorbed: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ratedQinjected: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ratedScharge: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    susceptanceCeaseToEnergize: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PowerElectronicsConnections: list[PowerElectronicsConnection] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsConnection.IEEE1547Info',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RotatingMachines: list[RotatingMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RotatingMachine.IEEE1547Info',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class InterrupterUnitInfo(AssetInfo):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OperatingMechanismInfo(AssetInfo):
    '''
    Breaker operating mechanism datasheet information.
    '''

    closeAmps: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Close current (nominal).
            '''
        
        })
    '''
    Close current (nominal).
    '''
    
    closeVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Close voltage in volts DC.
            '''
        
        })
    '''
    Close voltage in volts DC.
    '''
    
    mechanismKind: Optional[ OperatingMechanismKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Kind of breaker operating mechanism.
            '''
        
        })
    '''
    Kind of breaker operating mechanism.
    '''
    
    motorRunCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated motor run current in amps.
            '''
        
        })
    '''
    Rated motor run current in amps.
    '''
    
    motorStartCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated motor start current in amps.
            '''
        
        })
    '''
    Rated motor start current in amps.
    '''
    
    motorVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Nominal motor voltage in volts DC.
            '''
        
        })
    '''
    Nominal motor voltage in volts DC.
    '''
    
    tripAmps: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Trip current (nominal).
            '''
        
        })
    '''
    Trip current (nominal).
    '''
    
    tripVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Trip voltage in volts DC.
            '''
        
        })
    '''
    Trip voltage in volts DC.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerTransformerInfo(AssetInfo):
    '''
    Set of power transformer data, from an equipment library.
    '''

    TransformerTankInfos: list[TransformerTankInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTankInfo.PowerTransformerInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Data for all the tanks described by this power transformer data.
            '''
        
        })
    '''
    Data for all the tanks described by this power transformer data.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ShuntCompensatorInfo(AssetInfo):
    '''
    Properties of shunt capacitor, shunt reactor or switchable bank of shunt
    capacitor or reactor assets.
    '''

    maxPowerLoss: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum allowed apparent power loss.
            '''
        
        })
    '''
    Maximum allowed apparent power loss.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated current.
            '''
        
        })
    '''
    Rated current.
    '''
    
    ratedReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated reactive power.
            '''
        
        })
    '''
    Rated reactive power.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SwitchInfo(AssetInfo):
    '''
    &lt;was Switch data.&gt;
    Switch datasheet information.
    '''

    isSinglePhase: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            If true, it is a single phase switch.
            '''
        
        })
    '''
    If true, it is a single phase switch.
    '''
    
    isUnganged: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            If true, the switch is not ganged (i.e., a switch phase may be operated
            separately from other phases).
            '''
        
        })
    '''
    If true, the switch is not ganged (i.e., a switch phase may be operated
    separately from other phases).
    '''
    
    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum fault current a breaking device can break safely under prescribed
            conditions of use.
            '''
        
        })
    '''
    The maximum fault current a breaking device can break safely under
    prescribed conditions of use.
    '''
    
    lowPressureAlarm: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Gas or air pressure at or below which a low pressure alarm is generated.
            '''
        
        })
    '''
    Gas or air pressure at or below which a low pressure alarm is generated.
    '''
    
    lowPressureLockOut: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Gas or air pressure below which the breaker will not open.
            '''
        
        })
    '''
    Gas or air pressure below which the breaker will not open.
    '''
    
    oilVolumePerTank: Optional[ float | Volume ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Volume of oil in each tank of bulk oil breaker.
            '''
        
        })
    '''
    Volume of oil in each tank of bulk oil breaker.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated current.
            '''
        
        })
    '''
    Rated current.
    '''
    
    ratedFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Frequency for which switch is rated.
            '''
        
        })
    '''
    Frequency for which switch is rated.
    '''
    
    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
            '''
        
        })
    '''
    Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
    '''
    
    ratedInterruptingTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Switch rated interrupting time in seconds.
            '''
        
        })
    '''
    Switch rated interrupting time in seconds.
    '''
    
    ratedVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated voltage.
            '''
        
        })
    '''
    Rated voltage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TapChangerInfo(AssetInfo):
    '''
    Tap changer data.
    '''

    ctRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Built-in current transducer ratio.
            '''
        
        })
    '''
    Built-in current transducer ratio.
    '''
    
    ptRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Built-in voltage transducer ratio.
            '''
        
        })
    '''
    Built-in voltage transducer ratio.
    '''
    
    ctRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Built-in current transformer primary rating.
            '''
        
        })
    '''
    Built-in current transformer primary rating.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerEndInfo(AssetInfo):
    '''
    Transformer end data.
    '''

    endNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Number for this transformer end, corresponding to the end's order in the
            PowerTransformer.vectorGroup attribute. Highest voltage winding should
            be 1.
            '''
        
        })
    '''
    Number for this transformer end, corresponding to the end's order in
    the PowerTransformer.vectorGroup attribute. Highest voltage winding
    should be 1.
    '''
    
    phaseAngleClock: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Winding phase angle where 360 degrees are represented with clock hours,
            so the valid values are {0, ..., 11}. For example, to express the second
            winding in code 'Dyn11', set attributes as follows: 'endNumber'=2, 'connectionKind'
            = Yn and 'phaseAngleClock' = 11.
            '''
        
        })
    '''
    Winding phase angle where 360 degrees are represented with clock hours,
    so the valid values are {0, ..., 11}. For example, to express the second
    winding in code 'Dyn11', set attributes as follows: 'endNumber'=2,
    'connectionKind' = Yn and 'phaseAngleClock' = 11.
    '''
    
    connectionKind: Optional[ WindingConnection ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Kind of connection.
            '''
        
        })
    '''
    Kind of connection.
    '''
    
    emergencyS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Apparent power that the winding can carry under emergency conditions (also
            called long-term emergency power).
            '''
        
        })
    '''
    Apparent power that the winding can carry under emergency conditions
    (also called long-term emergency power).
    '''
    
    insulationU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Basic insulation level voltage rating.
            '''
        
        })
    '''
    Basic insulation level voltage rating.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            DC resistance.
            '''
        
        })
    '''
    DC resistance.
    '''
    
    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal apparent power rating.
            '''
        
        })
    '''
    Normal apparent power rating.
    '''
    
    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated voltage: phase-phase for three-phase windings, and either phase-phase
            or phase-neutral for single-phase windings.
            '''
        
        })
    '''
    Rated voltage: phase-phase for three-phase windings, and either phase-phase
    or phase-neutral for single-phase windings.
    '''
    
    shortTermS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Apparent power that this winding can carry for a short period of time (in
            emergency).
            '''
        
        })
    '''
    Apparent power that this winding can carry for a short period of time
    (in emergency).
    '''
    
    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Core admittance calculated from this transformer end datasheet, representing
            magnetising current and core losses. The full values of the transformer
            should be supplied for one transformer end info only.
            '''
        
        })
    '''
    Core admittance calculated from this transformer end datasheet, representing
    magnetising current and core losses. The full values of the transformer
    should be supplied for one transformer end info only.
    '''
    
    TransformerStarImpedance: Optional[TransformerStarImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerStarImpedance.TransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer star impedance calculated from this transformer end datasheet.
            '''
        
        })
    '''
    Transformer star impedance calculated from this transformer end datasheet.
    '''
    
    TransformerTankInfo: Optional[TransformerTankInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerTankInfo.TransformerEndInfos',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer tank data that this end description is part of.
            '''
        
        })
    '''
    Transformer tank data that this end description is part of.
    '''
    
    EnergisedEndNoLoadTests: list[NoLoadTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NoLoadTest.EnergisedEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All no-load test measurements in which this transformer end was energised.
            '''
        
        })
    '''
    All no-load test measurements in which this transformer end was energised.
    '''
    
    EnergisedEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OpenCircuitTest.EnergisedEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All open-circuit test measurements in which this transformer end was excited.
            '''
        
        })
    '''
    All open-circuit test measurements in which this transformer end was
    excited.
    '''
    
    OpenEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OpenCircuitTest.OpenEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All open-circuit test measurements in which this transformer end was not
            excited.
            '''
        
        })
    '''
    All open-circuit test measurements in which this transformer end was
    not excited.
    '''
    
    EnergisedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShortCircuitTest.EnergisedEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All short-circuit test measurements in which this transformer end was energised.
            '''
        
        })
    '''
    All short-circuit test measurements in which this transformer end was
    energised.
    '''
    
    GroundedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShortCircuitTest.GroundedEnds',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All short-circuit test measurements in which this transformer end was short-circuited.
            '''
        
        })
    '''
    All short-circuit test measurements in which this transformer end was
    short-circuited.
    '''
    
    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Core admittance calculated from this transformer end datasheet, representing
            magnetising current and core losses. The full values of the transformer
            should be supplied for one transformer end info only.
            '''
        
        })
    '''
    Core admittance calculated from this transformer end datasheet, representing
    magnetising current and core losses. The full values of the transformer
    should be supplied for one transformer end info only.
    '''
    
    FromMeshImpedances: list[TransformerMeshImpedance] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerMeshImpedance.FromTransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All mesh impedances between this 'to' and other 'from' transformer ends.
            '''
        
        })
    '''
    All mesh impedances between this 'to' and other 'from' transformer
    ends.
    '''
    
    TransformerStarImpedance: Optional[TransformerStarImpedance] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerStarImpedance.TransformerEndInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer star impedance calculated from this transformer end datasheet.
            '''
        
        })
    '''
    Transformer star impedance calculated from this transformer end datasheet.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerTankInfo(AssetInfo):
    '''
    Set of transformer tank data, from an equipment library.
    '''

    PowerTransformerInfo: Optional[PowerTransformerInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerTransformerInfo.TransformerTankInfos',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Power transformer data that this tank description is part of.
            '''
        
        })
    '''
    Power transformer data that this tank description is part of.
    '''
    
    TransformerEndInfos: list[TransformerEndInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEndInfo.TransformerTankInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Data for all the ends described by this transformer tank data.
            '''
        
        })
    '''
    Data for all the ends described by this transformer tank data.
    '''
    
    TransformerTanks: list[TransformerTank] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTank.TransformerTankInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WireAssemblyInfo(AssetInfo):
    '''
    Describes the construction of a multi-conductor wire
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.WireAssemblyInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PerLengthLineParameter: list[PerLengthLineParameter] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PerLengthLineParameter.WireAssemblyInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireAssemblyInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WireInfo(AssetInfo):
    '''
    Wire data that can be specified per line segment phase, or for the line
    segment as a whole in case its phases all have the same wire characteristics.
    '''

    coreStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            (if used) Number of strands in the steel core.
            '''
        
        })
    '''
    (if used) Number of strands in the steel core.
    '''
    
    insulated: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            True if conductor is insulated.
            '''
        
        })
    '''
    True if conductor is insulated.
    '''
    
    sizeDescription: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
            '''
        
        })
    '''
    Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
    '''
    
    strandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Number of strands in the conductor.
            '''
        
        })
    '''
    Number of strands in the conductor.
    '''
    
    coreRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            (if there is a different core material) Radius of the central core.
            '''
        
        })
    '''
    (if there is a different core material) Radius of the central core.
    '''
    
    gmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Geometric mean radius. If we replace the conductor by a thin walled tube
            of radius GMR, then its reactance is identical to the reactance of the
            actual conductor.
            '''
        
        })
    '''
    Geometric mean radius. If we replace the conductor by a thin walled
    tube of radius GMR, then its reactance is identical to the reactance
    of the actual conductor.
    '''
    
    insulationMaterial: Optional[ WireInsulationKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            (if insulated conductor) Material used for insulation.
            '''
        
        })
    '''
    (if insulated conductor) Material used for insulation.
    '''
    
    insulationThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            (if insulated conductor) Thickness of the insulation.
            '''
        
        })
    '''
    (if insulated conductor) Thickness of the insulation.
    '''
    
    material: Optional[ WireMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Conductor material.
            '''
        
        })
    '''
    Conductor material.
    '''
    
    rAC25: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            AC resistance per unit length of the conductor at 25 �C.
            '''
        
        })
    '''
    AC resistance per unit length of the conductor at 25 �C.
    '''
    
    rAC50: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            AC resistance per unit length of the conductor at 50 �C.
            '''
        
        })
    '''
    AC resistance per unit length of the conductor at 50 �C.
    '''
    
    rAC75: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            AC resistance per unit length of the conductor at 75 �C.
            '''
        
        })
    '''
    AC resistance per unit length of the conductor at 75 �C.
    '''
    
    radius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Outside radius of the wire.
            '''
        
        })
    '''
    Outside radius of the wire.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Current carrying capacity of the wire under stated thermal conditions.
            '''
        
        })
    '''
    Current carrying capacity of the wire under stated thermal conditions.
    '''
    
    rDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            DC resistance per unit length of the conductor at 20 �C.
            '''
        
        })
    '''
    DC resistance per unit length of the conductor at 20 �C.
    '''
    
    ACLineSegmentPhases: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.WireInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WireInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CableInfo(WireInfo):
    '''
    Cable data.
    '''

    isStrandFill: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            True if wire strands are extruded in a way to fill the voids in the cable.
            '''
        
        })
    '''
    True if wire strands are extruded in a way to fill the voids in the
    cable.
    '''
    
    relativePermittivity: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    sheathAsNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            True if sheath / shield is used as a neutral (i.e., bonded).
            '''
        
        })
    '''
    True if sheath / shield is used as a neutral (i.e., bonded).
    '''
    
    constructionKind: Optional[ CableConstructionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Kind of construction of this cable.
            '''
        
        })
    '''
    Kind of construction of this cable.
    '''
    
    diameterOverCore: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Diameter over the core, including any semi-con screen; should be the insulating
            layer's inside diameter.
            '''
        
        })
    '''
    Diameter over the core, including any semi-con screen; should be the
    insulating layer's inside diameter.
    '''
    
    diameterOverInsulation: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Diameter over the insulating layer, excluding outer screen.
            '''
        
        })
    '''
    Diameter over the insulating layer, excluding outer screen.
    '''
    
    diameterOverJacket: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Diameter over the outermost jacketing layer.
            '''
        
        })
    '''
    Diameter over the outermost jacketing layer.
    '''
    
    diameterOverScreen: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Diameter over the outer screen; should be the shield's inside diameter.
            '''
        
        })
    '''
    Diameter over the outer screen; should be the shield's inside diameter.
    '''
    
    nominalTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum nominal design operating temperature.
            '''
        
        })
    '''
    Maximum nominal design operating temperature.
    '''
    
    outerJacketKind: Optional[ CableOuterJacketKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Kind of outer jacket of this cable.
            '''
        
        })
    '''
    Kind of outer jacket of this cable.
    '''
    
    shieldMaterial: Optional[ CableShieldMaterialKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Material of the shield.
            '''
        
        })
    '''
    Material of the shield.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ConcentricNeutralCableInfo(CableInfo):
    '''
    Concentric neutral cable data.
    '''

    neutralStrandCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Number of concentric neutral strands.
            '''
        
        })
    '''
    Number of concentric neutral strands.
    '''
    
    diameterOverNeutral: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Diameter over the concentric neutral strands.
            '''
        
        })
    '''
    Diameter over the concentric neutral strands.
    '''
    
    neutralStrandGmr: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Geometric mean radius of the neutral strand.
            '''
        
        })
    '''
    Geometric mean radius of the neutral strand.
    '''
    
    neutralStrandRadius: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Outside radius of the neutral strand.
            '''
        
        })
    '''
    Outside radius of the neutral strand.
    '''
    
    neutralStrandRDC20: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            DC resistance per unit length of the neutral strand at 20 �C.
            '''
        
        })
    '''
    DC resistance per unit length of the neutral strand at 20 �C.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapeShieldCableInfo(CableInfo):
    '''
    Tape shield cable data.
    '''

    tapeLap: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Percentage of the tape shield width that overlaps in each wrap, typically
            10% to 25%.
            '''
        
        })
    '''
    Percentage of the tape shield width that overlaps in each wrap, typically
    10% to 25%.
    '''
    
    tapeThickness: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Thickness of the tape shield, before wrapping.
            '''
        
        })
    '''
    Thickness of the tape shield, before wrapping.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class OverheadWireInfo(WireInfo):
    '''
    Overhead wire data.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class WireSpacingInfo(AssetInfo):
    '''
    Wire spacing data that associates multiple wire positions with the line
    segment, and allows to calculate line segment impedances. Number of phases
    can be derived from the number of associated wire positions whose phase
    is not neutral.
    '''

    isCable: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            If true, this spacing data describes a cable.
            '''
        
        })
    '''
    If true, this spacing data describes a cable.
    '''
    
    phaseWireCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Number of wire sub-conductors in the symmetrical bundle (typically between
            1 and 4).
            '''
        
        })
    '''
    Number of wire sub-conductors in the symmetrical bundle (typically
    between 1 and 4).
    '''
    
    phaseWireSpacing: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Distance between wire sub-conductors in a symmetrical bundle.
            '''
        
        })
    '''
    Distance between wire sub-conductors in a symmetrical bundle.
    '''
    
    usage: Optional[ WireUsageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Usage of the associated wires.
            '''
        
        })
    '''
    Usage of the associated wires.
    '''
    
    DuctBank: Optional[DuctBank] = field(
        default=None,
        metadata={
        'type': 'informative',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DuctBank.WireSpacingInfos',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ACLineSegments: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.WireSpacingInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WireAssemblyInfo: list[WireAssemblyInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WireAssemblyInfo.WireSpacingInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WirePositions: list[WirePosition] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePosition.WireSpacingInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All positions of single wires (phase or neutral) making the conductor.
            '''
        
        })
    '''
    All positions of single wires (phase or neutral) making the conductor.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BaseFrequency(IdentifiedObject):
    '''
    The class describe a base frequency for a power system network. In case
    of multiple power networks with different frequencies, e.g. 50 or 60 Hertz
    each network will have it's own base frequency class. Hence it is assumed
    that power system objects having different base frequencies appear in separate
    documents where each document has a single base frequency instance.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The base frequency.
            '''
        
        })
    '''
    The base frequency.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BasePower(IdentifiedObject):
    '''
    The BasePower class defines the base power used in the per unit calculations.
    '''

    basePower: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Value used as base power.
            '''
        
        })
    '''
    Value used as base power.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BaseVoltage(IdentifiedObject):
    '''
    Defines a system base voltage which is referenced.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The power system resource's base voltage.
            '''
        
        })
    '''
    The power system resource's base voltage.
    '''
    
    ConductingEquipment: list[ConductingEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConductingEquipment.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All conducting equipment with this base voltage. Use only when there is
            no voltage level container used and only one base voltage applies. For
            example, not used for transformers.
            '''
        
        })
    '''
    All conducting equipment with this base voltage. Use only when there
    is no voltage level container used and only one base voltage applies.
    For example, not used for transformers.
    '''
    
    TopologicalNode: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The topological nodes at the base voltage.
            '''
        
        })
    '''
    The topological nodes at the base voltage.
    '''
    
    TransformerEnds: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer ends at the base voltage. This is essential for PU calculation.
            '''
        
        })
    '''
    Transformer ends at the base voltage. This is essential for PU calculation.
    '''
    
    VoltageLevel: list[VoltageLevel] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageLevel.BaseVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The voltage levels having this base voltage.
            '''
        
        })
    '''
    The voltage levels having this base voltage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class BasicIntervalSchedule(IdentifiedObject):
    '''
    Schedule of values at points in time.
    '''

    startTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The time for the first time point. The value can be a time of day, not
            a specific date.
            '''
        
        })
    '''
    The time for the first time point. The value can be a time of day,
    not a specific date.
    '''
    
    value1Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Multiplier for value1.
            '''
        
        })
    '''
    Multiplier for value1.
    '''
    
    value1Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Value1 units of measure.
            '''
        
        })
    '''
    Value1 units of measure.
    '''
    
    value2Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Multiplier for value2.
            '''
        
        })
    '''
    Multiplier for value2.
    '''
    
    value2Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Value2 units of measure.
            '''
        
        })
    '''
    Value2 units of measure.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class IrregularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them varies.
    '''

    TimePoints: list[IrregularTimePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'IrregularTimePoint.IntervalSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The point data values that define a curve.
            '''
        
        })
    '''
    The point data values that define a curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class RegularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them is constant.
    '''

    endTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The time for the last time point. The value can be a time of day, not a
            specific date.
            '''
        
        })
    '''
    The time for the last time point. The value can be a time of day, not
    a specific date.
    '''
    
    timeStep: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The time between each pair of subsequent regular time points in sequence
            order.
            '''
        
        })
    '''
    The time between each pair of subsequent regular time points in sequence
    order.
    '''
    
    TimePoints: list[RegularTimePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegularTimePoint.IntervalSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The regular interval time point data values that define this schedule.
            '''
        
        })
    '''
    The regular interval time point data values that define this schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class GenUnitOpSchedule(RegularIntervalSchedule):
    '''
    The generating unit's Operator-approved current operating schedule (or
    plan), typically produced with the aid of unit commitment type analyses.
    The X-axis represents absolute time. The Y1-axis represents the status
    (0=off-line and unavailable: 1=available: 2=must run: 3=must run at fixed
    power value: etc.). The Y2-axis represents the must run fixed power value
    where required.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''
        
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''
    
    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''
        
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HydroPumpOpSchedule(RegularIntervalSchedule):
    '''
    The hydro pump's Operator-approved current operating schedule (or plan),
    typically produced with the aid of unit commitment type analyses.The unit's
    operating schedule status is typically given as: (0=unavailable) (1=avilable
    to startup or shutdown) (2=must pump).
    '''

    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.HydroPumpOpSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''
        
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''
    
    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.HydroPumpOpSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''
        
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class InflowForecast(RegularIntervalSchedule):
    '''
    Natural water inflow to a reservoir, usually forecasted from predicted
    rain and snowmelt. Typically in one hour increments for up to 10 days.
    The forecast is given in average cubic meters per second over the time
    increment.
    '''

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.InflowForecasts',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A reservoir may have a "natural" inflow forecast.
            '''
        
        })
    '''
    A reservoir may have a "natural" inflow forecast.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SeasonDayTypeSchedule(RegularIntervalSchedule):
    '''
    A time schedule covering a 24 hour period, with curve data for a specific
    type of season and day.
    '''

    DayType: Optional[DayType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DayType.SeasonDayTypeSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            DayType for the Schedule.
            '''
        
        })
    '''
    DayType for the Schedule.
    '''
    
    Season: Optional[Season] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Season.SeasonDayTypeSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Season for the Schedule.
            '''
        
        })
    '''
    Season for the Schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    A curve of load versus time (X-axis) showing the active power values (Y1-axis)
    and reactive power (Y2-axis) for each unit of the period covered. This
    curve represents a typical pattern of load over the time period for a given
    day type and season.
    '''

    ConformLoadGroup: Optional[ConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConformLoadGroup.ConformLoadSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The ConformLoadGroup where the ConformLoadSchedule belongs.
            '''
        
        })
    '''
    The ConformLoadGroup where the ConformLoadSchedule belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class NonConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    An active power (Y1-axis) and reactive power (Y2-axis) schedule (curves)
    versus time (X-axis) for non-conforming loads, e.g., large industrial load
    or power station service (where modeled).
    '''

    NonConformLoadGroup: Optional[NonConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NonConformLoadGroup.NonConformLoadSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The NonConformLoadGroup where the NonConformLoadSchedule belongs.
            '''
        
        })
    '''
    The NonConformLoadGroup where the NonConformLoadSchedule belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RegulationSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a controlled variable, e.g., busbar
    voltage.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegulatingControl.RegulationSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Regulating controls that have this Schedule.
            '''
        
        })
    '''
    Regulating controls that have this Schedule.
    '''
    
    VoltageControlZones: list[VoltageControlZone] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageControlZone.RegulationSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A VoltageControlZone may have a voltage regulation schedule.
            '''
        
        })
    '''
    A VoltageControlZone may have a voltage regulation schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SwitchSchedule(SeasonDayTypeSchedule):
    '''
    A schedule of switch positions. If RegularTimePoint.value1 is 0, the switch
    is open. If 1, the switch is closed.
    '''

    Switch: Optional[Switch] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Switch.SwitchSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A SwitchSchedule is associated with a Switch.
            '''
        
        })
    '''
    A SwitchSchedule is associated with a Switch.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a tap step.
    '''

    TapChanger: Optional[TapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TapChanger.TapSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A TapSchedule is associated with a TapChanger.
            '''
        
        })
    '''
    A TapSchedule is associated with a TapChanger.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class SteamSendoutSchedule(RegularIntervalSchedule):
    '''
    The cogeneration plant's steam sendout schedule in volume per time unit.
    '''

    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.SteamSendoutSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''
        
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''
    
    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.SteamSendoutSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''
        
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class BranchGroup(IdentifiedObject):
    '''
    A group of branch terminals whose directed flow summation is to be monitored.
    A branch group need not form a cutset of the network.
    '''

    monitorActivePower: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Monitor the active power flow.
            '''
        
        })
    '''
    Monitor the active power flow.
    '''
    
    monitorReactivePower: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Monitor the reactive power flow.
            '''
        
        })
    '''
    Monitor the reactive power flow.
    '''
    
    maximumActivePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum active power flow.
            '''
        
        })
    '''
    The maximum active power flow.
    '''
    
    maximumReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum reactive power flow.
            '''
        
        })
    '''
    The maximum reactive power flow.
    '''
    
    minimumActivePower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The minimum active power flow.
            '''
        
        })
    '''
    The minimum active power flow.
    '''
    
    minimumReactivePower: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The minimum reactive power flow.
            '''
        
        })
    '''
    The minimum reactive power flow.
    '''
    
    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BranchGroupTerminal.BranchGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The directed branch group terminals to be summed.
            '''
        
        })
    '''
    The directed branch group terminals to be summed.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BusNameMarker(IdentifiedObject):
    '''
    Used to apply user standard names to topology buses. Typically used for
    "bus/branch" case generation. Associated with one or more terminals that
    are normally connected with the bus name. The associated terminals are
    normally connected by non-retained switches. For a ring bus station configuration,
    all busbar terminals in the ring are typically associated. For a breaker
    and a half scheme, both busbars would normally be associated. For a ring
    bus, all busbars would normally be associated. For a "straight" busbar
    configuration, normally only the main terminal at the busbar would be associated.
    '''

    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Priority of bus name marker for use as topology bus name. Use 0 for don
            t care. Use 1 for highest priority. Use 2 as priority is less than 1 and
            so on.
            '''
        
        })
    '''
    Priority of bus name marker for use as topology bus name. Use 0 for
    don t care. Use 1 for highest priority. Use 2 as priority is less than
    1 and so on.
    '''
    
    ReportingGroup: Optional[ReportingGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReportingGroup.BusNameMarker',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reporting group to which this bus name marker belongs.
            '''
        
        })
    '''
    The reporting group to which this bus name marker belongs.
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.BusNameMarker',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A user defined topological node that was originally defined in a planning
            model not yet having topology described by ConnectivityNodes. Once ConnectivityNodes
            has been created they may linked to user defined ToplogicalNdes using BusNameMarkers.
            '''
        
        })
    '''
    A user defined topological node that was originally defined in a planning
    model not yet having topology described by ConnectivityNodes. Once
    ConnectivityNodes has been created they may linked to user defined
    ToplogicalNdes using BusNameMarkers.
    '''
    
    Terminal: list[ACDCTerminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACDCTerminal.BusNameMarker',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The terminals associated with this bus name marker.
            '''
        
        })
    '''
    The terminals associated with this bus name marker.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Topology'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ConnectivityNode(IdentifiedObject):
    '''
    Connectivity nodes are points where terminals of AC conducting equipment
    are connected together with zero impedance.
    '''

    ConnectivityNodeContainer: Optional[ConnectivityNodeContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNodeContainer.ConnectivityNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Container of this connectivity node.
            '''
        
        })
    '''
    Container of this connectivity node.
    '''
    
    SvVoltage: Optional[SvVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SvVoltage.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.ConnectivityNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The topological node to which this connectivity node is assigned. May depend
            on the current state of switches in the network.
            '''
        
        })
    '''
    The topological node to which this connectivity node is assigned. May
    depend on the current state of switches in the network.
    '''
    
    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SvInjection: list[SvInjection] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvInjection.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    SvVoltage: Optional[SvVoltage] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SvVoltage.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConnectivityNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Terminals interconnected with zero impedance at a this connectivity node.
            '''
        
        })
    '''
    Terminals interconnected with zero impedance at a this connectivity
    node.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Contingency(IdentifiedObject):
    '''
    An event threatening system reliability, consisting of one or more contingency
    elements.
    '''

    mustStudy: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Set true if must study this contingency.
            '''
        
        })
    '''
    Set true if must study this contingency.
    '''
    
    ContingencyElement: list[ContingencyElement] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ContingencyElement.Contingency',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A contingency can have any number of contingency elements.
            '''
        
        })
    '''
    A contingency can have any number of contingency elements.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Contingency'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ContingencyElement(IdentifiedObject):
    '''
    An element of a system event to be studied by contingency analysis, representing
    a change in status of a single piece of equipment.
    '''

    Contingency: Optional[Contingency] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Contingency.ContingencyElement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A contingency element belongs to one contingency.
            '''
        
        })
    '''
    A contingency element belongs to one contingency.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Contingency'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ContingencyEquipment(ContingencyElement):
    '''
    Equipment whose in service status is to change, such as a power transformer
    or AC line segment.
    '''

    contingentStatus: Optional[ ContingencyEquipmentStatusKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The status for the associated equipment when in the contingency state.
            This status is independent of the case to which the contingency is originally
            applied, but defines the equipment status when the contingency is applied.
            '''
        
        })
    '''
    The status for the associated equipment when in the contingency state.
    This status is independent of the case to which the contingency is
    originally applied, but defines the equipment status when the contingency
    is applied.
    '''
    
    Equipment: Optional[Equipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Equipment.ContingencyEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The single piece of equipment to which to apply the contingency.
            '''
        
        })
    '''
    The single piece of equipment to which to apply the contingency.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Contingency'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CoordinateSystem(IdentifiedObject):
    '''
    Coordinate reference system.
    '''

    crsUrn: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A Uniform Resource Name (URN) for the coordinate reference system (crs)
            used to define 'Location.PositionPoints'.
            An example would be the European Petroleum Survey Group (EPSG) code for
            a coordinate reference system, defined in URN under the Open Geospatial
            Consortium (OGC) namespace as: urn:ogc:def:uom:EPSG::XXXX, where XXXX is
            an EPSG code (a full list of codes can be found at the EPSG Registry web
            site http://www.epsg-registry.org/). To define the coordinate system as
            being WGS84 (latitude, longitude) using an EPSG OGC, this attribute would
            be urn:ogc:def:uom:EPSG::4236.
            A profile should limit this code to a set of allowed URNs agreed to by
            all sending and receiving parties.
            '''
        
        })
    '''
    A Uniform Resource Name (URN) for the coordinate reference system (crs)
    used to define 'Location.PositionPoints'.
    An example would be the European Petroleum Survey Group (EPSG) code
    for a coordinate reference system, defined in URN under the Open Geospatial
    Consortium (OGC) namespace as: urn:ogc:def:uom:EPSG::XXXX, where XXXX
    is an EPSG code (a full list of codes can be found at the EPSG Registry
    web site http://www.epsg-registry.org/). To define the coordinate system
    as being WGS84 (latitude, longitude) using an EPSG OGC, this attribute
    would be urn:ogc:def:uom:EPSG::4236.
    A profile should limit this code to a set of allowed URNs agreed to
    by all sending and receiving parties.
    '''
    
    Locations: list[Location] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Location.CoordinateSystem',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All locations described with position points in this coordinate system.
            '''
        
        })
    '''
    All locations described with position points in this coordinate system.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Curve(IdentifiedObject):
    '''
    A multi-purpose curve or functional relationship between an independent
    variable (X-axis) and dependent (Y-axis) variables.
    '''

    curveStyle: Optional[ CurveStyle ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The style or shape of the curve.
            '''
        
        })
    '''
    The style or shape of the curve.
    '''
    
    xMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Multiplier for X-axis.
            '''
        
        })
    '''
    Multiplier for X-axis.
    '''
    
    xUnit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The X-axis units of measure.
            '''
        
        })
    '''
    The X-axis units of measure.
    '''
    
    y1Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Multiplier for Y1-axis.
            '''
        
        })
    '''
    Multiplier for Y1-axis.
    '''
    
    y1Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Y1-axis units of measure.
            '''
        
        })
    '''
    The Y1-axis units of measure.
    '''
    
    y2Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Multiplier for Y2-axis.
            '''
        
        })
    '''
    Multiplier for Y2-axis.
    '''
    
    y2Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Y2-axis units of measure.
            '''
        
        })
    '''
    The Y2-axis units of measure.
    '''
    
    y3Multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Multiplier for Y3-axis.
            '''
        
        })
    '''
    Multiplier for Y3-axis.
    '''
    
    y3Unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Y3-axis units of measure.
            '''
        
        })
    '''
    The Y3-axis units of measure.
    '''
    
    CurveDatas: list[CurveData] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'CurveData.Curve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The point data values that define this curve.
            '''
        
        })
    '''
    The point data values that define this curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EmissionAccount(Curve):
    '''
    Accounts for tracking emissions usage and credits for thermal generating
    units. A unit may have zero or more emission accounts, and will typically
    have one for tracking usage and one for tracking credits.
    '''

    emissionType: Optional[ EmissionType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The type of emission, for example sulfur dioxide (SO2). The y1AxisUnits
            of the curve contains the unit of measure (e.g. kg) and the emissionType
            is the type of emission (e.g. sulfer dioxide).
            '''
        
        })
    '''
    The type of emission, for example sulfur dioxide (SO2). The y1AxisUnits
    of the curve contains the unit of measure (e.g. kg) and the emissionType
    is the type of emission (e.g. sulfer dioxide).
    '''
    
    emissionValueSource: Optional[ EmissionValueSource ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The source of the emission value.
            '''
        
        })
    '''
    The source of the emission value.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.EmmissionAccounts',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have one or more emission allowance accounts.
            '''
        
        })
    '''
    A thermal generating unit may have one or more emission allowance accounts.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EmissionCurve(Curve):
    '''
    Relationship between the unit's emission rate in units of mass per hour
    (Y-axis) and output active power (X-axis) for a given type of emission.
    This curve applies when only one type of fuel is being burned.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    emissionContent: Optional[ float | Emission ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The emission content per quantity of fuel burned.
            '''
        
        })
    '''
    The emission content per quantity of fuel burned.
    '''
    
    emissionType: Optional[ EmissionType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The type of emission, which also gives the production rate measurement
            unit. The y1AxisUnits of the curve contains the unit of measure (e.g. kg)
            and the emissionType is the type of emission (e.g. sulfer dioxide).
            '''
        
        })
    '''
    The type of emission, which also gives the production rate measurement
    unit. The y1AxisUnits of the curve contains the unit of measure (e.g.
    kg) and the emissionType is the type of emission (e.g. sulfer dioxide).
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.EmissionCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have one or more emission curves.
            '''
        
        })
    '''
    A thermal generating unit may have one or more emission curves.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FuelAllocationSchedule(Curve):
    '''
    The amount of fuel of a given type which is allocated for consumption over
    a specified period of time.
    '''

    fuelAllocationEndDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The end time and date of the fuel allocation schedule.
            '''
        
        })
    '''
    The end time and date of the fuel allocation schedule.
    '''
    
    fuelAllocationStartDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The start time and date of the fuel allocation schedule.
            '''
        
        })
    '''
    The start time and date of the fuel allocation schedule.
    '''
    
    maxFuelAllocation: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum amount fuel that is allocated for consumption for the scheduled
            time period.
            '''
        
        })
    '''
    The maximum amount fuel that is allocated for consumption for the scheduled
    time period.
    '''
    
    minFuelAllocation: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The minimum amount fuel that is allocated for consumption for the scheduled
            time period, e.g., based on a "take-or-pay" contract.
            '''
        
        })
    '''
    The minimum amount fuel that is allocated for consumption for the scheduled
    time period, e.g., based on a "take-or-pay" contract.
    '''
    
    fuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The type of fuel, which also indicates the corresponding measurement unit.
            '''
        
        })
    '''
    The type of fuel, which also indicates the corresponding measurement
    unit.
    '''
    
    FossilFuel: Optional[FossilFuel] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FossilFuel.FuelAllocationSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A fuel allocation schedule must have a fossil fuel.
            '''
        
        })
    '''
    A fuel allocation schedule must have a fossil fuel.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.FuelAllocationSchedules',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have one or more fuel allocation schedules.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fuel allocation schedules.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GenUnitOpCostCurve(Curve):
    '''
    Relationship between unit operating cost (Y-axis) and unit output active
    power (X-axis). The operating cost curve for thermal units is derived from
    heat input and fuel costs. The operating cost curve for hydro units is
    derived from water flow rates and equivalent water costs.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GenUnitOpCostCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A generating unit may have one or more cost curves, depending upon fuel
            mixture and fuel cost.
            '''
        
        })
    '''
    A generating unit may have one or more cost curves, depending upon
    fuel mixture and fuel cost.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GrossToNetActivePowerCurve(Curve):
    '''
    Relationship between the generating unit's gross active power output on
    the X-axis (measured at the terminals of the machine(s)) and the generating
    unit's net active power output on the Y-axis (based on utility-defined
    measurements at the power station). Station service loads, when modeled,
    should be treated as non-conforming bus loads. There may be more than one
    curve, depending on the auxiliary equipment that is in service.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.GrossToNetActivePowerCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A generating unit may have a gross active power to net active power curve,
            describing the losses and auxiliary power requirements of the unit.
            '''
        
        })
    '''
    A generating unit may have a gross active power to net active power
    curve, describing the losses and auxiliary power requirements of the
    unit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HeatInputCurve(Curve):
    '''
    Relationship between unit heat input in energy per time for main fuel (Y1-axis)
    and supplemental fuel (Y2-axis) versus unit output in active power (X-axis).
    The quantity of main fuel used to sustain generation at this output level
    is prorated for throttling between definition points. The quantity of supplemental
    fuel used at this output level is fixed and not prorated.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    auxPowerMult: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Power output - auxiliary power multiplier adjustment factor.
            '''
        
        })
    '''
    Power output - auxiliary power multiplier adjustment factor.
    '''
    
    auxPowerOffset: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Power output - auxiliary power offset adjustment factor.
            '''
        
        })
    '''
    Power output - auxiliary power offset adjustment factor.
    '''
    
    heatInputEff: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Heat input - efficiency multiplier adjustment factor.
            '''
        
        })
    '''
    Heat input - efficiency multiplier adjustment factor.
    '''
    
    heatInputOffset: Optional[ float | HeatRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Heat input - offset adjustment factor.
            '''
        
        })
    '''
    Heat input - offset adjustment factor.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class HeatRateCurve(Curve):
    '''
    Relationship between unit heat rate per active power (Y-axis) and unit
    output (X-axis). The heat input is from all fuels.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.HeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class HydroGeneratingEfficiencyCurve(Curve):
    '''
    Relationship between unit efficiency in percent and unit output active
    power for a given net head in meters. The relationship between efficiency,
    discharge, head, and power output is expressed as follows: E =KP/HQ
    Where: (E=percentage) (P=active power) (H=height) (Q=volume/time unit)
    (K=constant)
    For example, a curve instance for a given net head could relate efficiency
    (Y-axis) versus active power output (X-axis) or versus discharge on the
    X-axis.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.HydroGeneratingEfficiencyCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A hydro generating unit has an efficiency curve.
            '''
        
        })
    '''
    A hydro generating unit has an efficiency curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class IncrementalHeatRateCurve(Curve):
    '''
    Relationship between unit incremental heat rate in (delta energy/time)
    per (delta active power) and unit output in active power. The IHR curve
    represents the slope of the HeatInputCurve. Note that the "incremental
    heat rate" and the "heat rate" have the same engineering units.
    '''

    isNetGrossP: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Flag is set to true when output is expressed in net active power.
            '''
        
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.IncrementalHeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.IncrementalHeatRateCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LevelVsVolumeCurve(Curve):
    '''
    Relationship between reservoir volume and reservoir level. The volume is
    at the y-axis and the reservoir level at the x-axis.
    '''

    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.LevelVsVolumeCurves',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A reservoir may have a level versus volume relationship.
            '''
        
        })
    '''
    A reservoir may have a level versus volume relationship.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class PenstockLossCurve(Curve):
    '''
    Relationship between penstock head loss (in meters) and total discharge
    through the penstock (in cubic meters per second). One or more turbines
    may be connected to the same penstock.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.PenstockLossCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.PenstockLossCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ReactiveCapabilityCurve(Curve):
    '''
    Reactive power rating envelope versus the synchronous machine's active
    power, in both the generating and motoring modes. For each active power
    value there is a corresponding high and low reactive power limit value.
    Typically there will be a separate curve for each coolant condition, such
    as hydrogen pressure. The Y1 axis values represent reactive minimum and
    the Y2 axis values represent reactive maximum.
    '''

    coolantTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The machine's coolant temperature (e.g., ambient air or stator circulating
            water).
            '''
        
        })
    '''
    The machine's coolant temperature (e.g., ambient air or stator circulating
    water).
    '''
    
    hydrogenPressure: Optional[ float | Pressure ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The hydrogen coolant pressure
            '''
        
        })
    '''
    The hydrogen coolant pressure
    '''
    
    InitiallyUsedBySynchronousMachines: list[SynchronousMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SynchronousMachine.InitialReactiveCapabilityCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Synchronous machines using this curve as default.
            '''
        
        })
    '''
    Synchronous machines using this curve as default.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class ShutdownCurve(Curve):
    '''
    Relationship between the rate in gross active power/minute (Y-axis) at
    which a unit should be shutdown and its present gross MW output (X-axis).
    '''

    shutdownDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The date and time of the most recent generating unit shutdown.
            '''
        
        })
    '''
    The date and time of the most recent generating unit shutdown.
    '''
    
    shutdownCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Fixed shutdown cost.
            '''
        
        })
    '''
    Fixed shutdown cost.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.ShutdownCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''
        
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.ShutdownCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''
        
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartIgnFuelCurve(Curve):
    '''
    The quantity of ignition fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    ignitionFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Type of ignition fuel.
            '''
        
        })
    '''
    Type of ignition fuel.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartIgnFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartIgnFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartMainFuelCurve(Curve):
    '''
    The quantity of main fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    mainFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Type of main fuel.
            '''
        
        })
    '''
    Type of main fuel.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartMainFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartMainFuelCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class StartRampCurve(Curve):
    '''
    Rate in gross active power/minute (Y-axis) at which a unit can be loaded
    versus the number of hours (X-axis) the unit was off line.
    '''

    hotStandbyRamp: Optional[ float | ActivePowerChangeRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The startup ramp rate in gross for a unit that is on hot standby.
            '''
        
        })
    '''
    The startup ramp rate in gross for a unit that is on hot standby.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartRampCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.StartRampCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TailbayLossCurve(Curve):
    '''
    Relationship between tailbay head loss hight (y-axis) and the total discharge
    into the power station's tailbay volume per time unit (x-axis) . There
    could be more than one curve depending on the level of the tailbay reservoir
    or river level.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroGeneratingUnit.TailbayLossCurve',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A hydro generating unit has a tailbay loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a tailbay loss curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class TargetLevelSchedule(Curve):
    '''
    Reservoir water level targets from advanced studies or "rule curves". Typically
    in one hour increments for up to 10 days.
    '''

    highLevelLimit: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            High target level limit, above which the reservoir operation will be penalized.
            '''
        
        })
    '''
    High target level limit, above which the reservoir operation will be
    penalized.
    '''
    
    lowLevelLimit: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Low target level limit, below which the reservoir operation will be penalized.
            '''
        
        })
    '''
    Low target level limit, below which the reservoir operation will be
    penalized.
    '''
    
    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.TargetLevelSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''
        
        })
    '''
    A reservoir may have a water level target schedule.
    '''
    
    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.TargetLevelSchedule',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''
        
        })
    '''
    A reservoir may have a water level target schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DayType(IdentifiedObject):
    '''
    Group of similar days. For example it could be used to represent weekdays,
    weekend, or holidays.
    '''

    SeasonDayTypeSchedules: list[SeasonDayTypeSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SeasonDayTypeSchedule.DayType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Schedules that use this DayType.
            '''
        
        })
    '''
    Schedules that use this DayType.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergyArea(IdentifiedObject):
    '''
    Describes an area having energy production or consumption. Specializations
    are intended to support the load allocation function as typically required
    in energy management systems or planning studies to allocate hypothesized
    load levels to individual load points for power flow analysis. Often the
    energy area can be linked to both measured and forecast load levels.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class LoadArea(EnergyArea):
    '''
    The class is the root or first level in a hierarchical structure for grouping
    of loads for the purpose of load flow load scaling.
    '''

    SubLoadAreas: list[SubLoadArea] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SubLoadArea.LoadArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The SubLoadAreas in the LoadArea.
            '''
        
        })
    '''
    The SubLoadAreas in the LoadArea.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class SubLoadArea(EnergyArea):
    '''
    The class is the second level in a hierarchical structure for grouping
    of loads for the purpose of load flow load scaling.
    '''

    LoadArea: Optional[LoadArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LoadArea.SubLoadAreas',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The LoadArea where the SubLoadArea belongs.
            '''
        
        })
    '''
    The LoadArea where the SubLoadArea belongs.
    '''
    
    LoadGroups: list[LoadGroup] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LoadGroup.SubLoadArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Loadgroups in the SubLoadArea.
            '''
        
        })
    '''
    The Loadgroups in the SubLoadArea.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergyConnectionProfile(IdentifiedObject):
    '''
    Optional references to shapes for OpenDSS, and players or schedules for
    GridLAB-D. See attribute documentation for applicability. The shapes, players,
    and schedules are not maintained in CIM, i.e., they must be made available
    to the simulator from an external source.
    '''

    dssDaily: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reference to OpenDSS Daily curve, for Load, Storage, PVSystem, Generator,
            and WindGen power
            '''
        
        })
    '''
    Reference to OpenDSS Daily curve, for Load, Storage, PVSystem, Generator,
    and WindGen power
    '''
    
    dssDuty: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reference to OpenDSS Duty Cycle curve, for Load, Storage, PVSystem, Generator,
            and WindGen power
            '''
        
        })
    '''
    Reference to OpenDSS Duty Cycle curve, for Load, Storage, PVSystem,
    Generator, and WindGen power
    '''
    
    dssLoadCvrCurve: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reference to OpenDSS CvrCurve, for Load objects
            '''
        
        })
    '''
    Reference to OpenDSS CvrCurve, for Load objects
    '''
    
    dssLoadGrowth: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reference to OpenDSS Growth curve, for Load objects
            '''
        
        })
    '''
    Reference to OpenDSS Growth curve, for Load objects
    '''
    
    dssPVTDaily: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reference to OpenDSS Daily curve, for PVSystem temperature
            '''
        
        })
    '''
    Reference to OpenDSS Daily curve, for PVSystem temperature
    '''
    
    dssPVTDuty: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reference to OpenDSS Duty Cycle curve, for PVSystem temperature
            '''
        
        })
    '''
    Reference to OpenDSS Duty Cycle curve, for PVSystem temperature
    '''
    
    dssPVTYearly: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reference to OpenDSS Yearly curve, for PVSystem temperature
            '''
        
        })
    '''
    Reference to OpenDSS Yearly curve, for PVSystem temperature
    '''
    
    dssSpectrum: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reference to OpenDSS harmonic current Spectrum, for Load, Storage, PVSystem,
            Generator, and WindGen power
            '''
        
        })
    '''
    Reference to OpenDSS harmonic current Spectrum, for Load, Storage,
    PVSystem, Generator, and WindGen power
    '''
    
    dssYearly: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reference to OpenDSS Yearly curve, for Load, Storage, PVSystem, Generator,
            and WindGen power
            '''
        
        })
    '''
    Reference to OpenDSS Yearly curve, for Load, Storage, PVSystem, Generator,
    and WindGen power
    '''
    
    gldPlayer: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            GridLAB-D Player for base_power attributes on Load and Triplex_Load objects,
            and P_Out for Battery objects. Netlisted as player.value.
            '''
        
        })
    '''
    GridLAB-D Player for base_power attributes on Load and Triplex_Load
    objects, and P_Out for Battery objects. Netlisted as player.value.
    '''
    
    gldSchedule: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            GridLAB-D schedule for base_power attributes on Load and Triplex_Load objects,
            and P_Out attributes on Battery objects.
            '''
        
        })
    '''
    GridLAB-D schedule for base_power attributes on Load and Triplex_Load
    objects, and P_Out attributes on Battery objects.
    '''
    
    EnergyConnections: list[EnergyConnection] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConnection.EnergyConnectionProfile',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Houses'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Fault(IdentifiedObject):
    '''
    Abnormal condition causing current flow through conducting equipment, such
    as caused by equipment failure or short circuits from objects not typically
    modeled (for example, a tree falling on a line).
    '''

    occurredDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The date and time at which the fault occurred.
            '''
        
        })
    '''
    The date and time at which the fault occurred.
    '''
    
    stopDateTime: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Time when the fault is repaired. If not specified, the fault is temporary
            and will clear itself as soon as it's deenergized.
            '''
        
        })
    '''
    Time when the fault is repaired. If not specified, the fault is temporary
    and will clear itself as soon as it's deenergized.
    '''
    
    kind: Optional[ PhaseConnectedFaultKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The kind of phase fault.
            '''
        
        })
    '''
    The kind of phase fault.
    '''
    
    phases: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The phases participating in the fault. The fault connections into these
            phases are further specified by the type of fault.
            '''
        
        })
    '''
    The phases participating in the fault. The fault connections into these
    phases are further specified by the type of fault.
    '''
    
    FaultyEquipment: Optional[Equipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Equipment.Faults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Equipment carrying this fault.
            '''
        
        })
    '''
    Equipment carrying this fault.
    '''
    
    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.Fault',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Faults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EquipmentFault(Fault):
    '''
    A fault applied at the terminal, external to the equipment. This class
    is not used to specify faults internal to the equipment.
    '''

    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.EquipmentFaults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The terminal connecting to the bus to which the fault is applied.
            '''
        
        })
    '''
    The terminal connecting to the bus to which the fault is applied.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Faults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LineFault(Fault):
    '''
    A fault that occurs on an AC line segment at some point along the length.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The length to the place where the fault is located starting from terminal
            with sequence number 1 of the faulted line segment.
            '''
        
        })
    '''
    The length to the place where the fault is located starting from terminal
    with sequence number 1 of the faulted line segment.
    '''
    
    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.LineFaults',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The line segment of this line fault.
            '''
        
        })
    '''
    The line segment of this line fault.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Faults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FaultCauseType(IdentifiedObject):
    '''
    Type of cause of the fault.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Faults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FossilFuel(IdentifiedObject):
    '''
    The fossil fuel consumed by the non-nuclear thermal generating unit. For
    example, coal, oil, gas, etc. This a the specific fuels that the generating
    unit can consume.
    '''

    fuelHeatContent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The amount of heat per weight (or volume) of the given type of fuel.
            '''
        
        })
    '''
    The amount of heat per weight (or volume) of the given type of fuel.
    '''
    
    fossilFuelType: Optional[ FuelType ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The type of fossil fuel, such as coal, oil, or gas.
            '''
        
        })
    '''
    The type of fossil fuel, such as coal, oil, or gas.
    '''
    
    fuelCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The cost in terms of heat value for the given type of fuel.
            '''
        
        })
    '''
    The cost in terms of heat value for the given type of fuel.
    '''
    
    fuelDispatchCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The cost of fuel used for economic dispatching which includes: fuel cost,
            transportation cost, and incremental maintenance cost.
            '''
        
        })
    '''
    The cost of fuel used for economic dispatching which includes: fuel
    cost, transportation cost, and incremental maintenance cost.
    '''
    
    fuelEffFactor: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The efficiency factor for the fuel (per unit) in terms of the effective
            energy absorbed.
            '''
        
        })
    '''
    The efficiency factor for the fuel (per unit) in terms of the effective
    energy absorbed.
    '''
    
    fuelHandlingCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Handling and processing cost associated with this fuel.
            '''
        
        })
    '''
    Handling and processing cost associated with this fuel.
    '''
    
    fuelMixture: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Relative amount of the given type of fuel, when multiple fuels are being
            consumed.
            '''
        
        })
    '''
    Relative amount of the given type of fuel, when multiple fuels are
    being consumed.
    '''
    
    fuelSulfur: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The fuel's fraction of pollution credit per unit of heat content.
            '''
        
        })
    '''
    The fuel's fraction of pollution credit per unit of heat content.
    '''
    
    highBreakpointP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The active power output level of the unit at which the given type of fuel
            is switched on. This fuel (e.g., oil) is sometimes used to supplement the
            base fuel (e.g., coal) at high active power output levels.
            '''
        
        })
    '''
    The active power output level of the unit at which the given type of
    fuel is switched on. This fuel (e.g., oil) is sometimes used to supplement
    the base fuel (e.g., coal) at high active power output levels.
    '''
    
    lowBreakpointP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The active power output level of the unit at which the given type of fuel
            is switched off. This fuel (e.g., oil) is sometimes used to stabilize the
            base fuel (e.g., coal) at low active power output levels.
            '''
        
        })
    '''
    The active power output level of the unit at which the given type of
    fuel is switched off. This fuel (e.g., oil) is sometimes used to stabilize
    the base fuel (e.g., coal) at low active power output levels.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.FossilFuels',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have one or more fossil fuels.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''
    
    FuelAllocationSchedules: list[FuelAllocationSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FuelAllocationSchedule.FossilFuel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A fuel allocation schedule must have a fossil fuel.
            '''
        
        })
    '''
    A fuel allocation schedule must have a fossil fuel.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class FunctionBlock(IdentifiedObject):
    '''
    Function block is a function described as a set of elementary blocks. The
    blocks describe the function between input variables and output variables.
    '''

    enabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            True, if the function block is enabled (active). Otherwise false.
            '''
        
        })
    '''
    True, if the function block is enabled (active). Otherwise false.
    '''
    
    priority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Value 0 means ignore priority. 1 means the highest priority, 2 is the second
            highest priority.
            '''
        
        })
    '''
    Value 0 means ignore priority. 1 means the highest priority, 2 is the
    second highest priority.
    '''
    
    Input: list[FunctionInputVariable] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FunctionInputVariable.Function',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Function input variable describe the input or domain to the function block.
            '''
        
        })
    '''
    Function input variable describe the input or domain to the function
    block.
    '''
    
    FunctionOutputVariable: list[FunctionOutputVariable] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FunctionOutputVariable.FunctionBlock',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Function output variable describe the output or codomain to the function
            block.
            '''
        
        })
    '''
    Function output variable describe the output or codomain to the function
    block.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ProtectionFunctionBlock(FunctionBlock):
    '''
    '''

    isEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    usage: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    operateDelayTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    operateTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    resetDelayTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    resetTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    startTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ProtectedSwitch: Optional[ProtectedSwitch] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ProtectedSwitch.ProtectionRelayFunction',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ProtectionEquipment: Optional[ProtectionEquipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ProtectionEquipment.ProtectionFunctionBlock',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WideAreaProtectionFunctionBlock(ProtectionFunctionBlock):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FrequencyProtectionFunctionBlock(WideAreaProtectionFunctionBlock):
    '''
    '''

    voltageBlockValue: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class UnderFrequencyProtectionFunctionBlock(FrequencyProtectionFunctionBlock):
    '''
    '''

    operateValue: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FunctionInputVariable(IdentifiedObject):
    '''
    Functional input variable defines the domain of the function.
    '''

    Function: Optional[FunctionBlock] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FunctionBlock.Input',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Function block describe the function that function input variable provides
            the domain for.
            '''
        
        })
    '''
    Function block describe the function that function input variable provides
    the domain for.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FunctionOutputVariable(IdentifiedObject):
    '''
    Functional output variable defines the codomain of the function.
    '''

    FunctionBlock: Optional[FunctionBlock] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FunctionBlock.FunctionOutputVariable',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Function block describe the function that function output variable provides
            the codomain for.
            '''
        
        })
    '''
    Function block describe the function that function output variable
    provides the codomain for.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class GeographicalRegion(IdentifiedObject):
    '''
    A geographical region of a power system network model.
    '''

    Regions: list[SubGeographicalRegion] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SubGeographicalRegion.Region',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All sub-geograhpical regions within this geographical region.
            '''
        
        })
    '''
    All sub-geograhpical regions within this geographical region.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class House(IdentifiedObject):
    '''
    In GridLAB-D, a single-family residence with building envelope represented
    by the equivalent thermal parameter (ETP) model, heating, ventilating and
    air conditioning (HVAC), other appliances, lights and plug loads. In power
    flow, these house loads aggregate into ZIP loads. These house parameters
    are the minimal set required to consistently initialize or repeat a GridLAB-D
    simulation.
    '''

    coolingSetpoint: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    coolingSystem: Optional[ HouseCooling ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    floorArea: Optional[ float | Area ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    heatingSetpoint: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    heatingSystem: Optional[ HouseHeating ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    thermalIntegrity: Optional[ HouseThermalIntegrity ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    EnergyConsumer: Optional[EnergyConsumer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumer.House',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ThermostatController: Optional[ThermostatController] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermostatController.House',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    EnergyConsumer: Optional[EnergyConsumer] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumer.House',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ThermostatController: Optional[ThermostatController] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermostatController.House',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Houses'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IOPoint(IdentifiedObject):
    '''
    The class describe a measurement or control value. The purpose is to enable
    having attributes and associations common for measurement and control.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Control(IOPoint):
    '''
    Control is used for supervisory/device control. It represents control outputs
    that are used to change the state in a process, e.g. close or open breaker,
    a set point value or a raise lower command.
    '''

    controlType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Specifies the type of Control, e.g. BreakerOn/Off, GeneratorVoltageSetPoint,
            TieLineFlow etc. The ControlType.name shall be unique among all specified
            types and describe the type.
            '''
        
        })
    '''
    Specifies the type of Control, e.g. BreakerOn/Off, GeneratorVoltageSetPoint,
    TieLineFlow etc. The ControlType.name shall be unique among all specified
    types and describe the type.
    '''
    
    operationInProgress: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Indicates that a client is currently sending control commands that has
            not completed.
            '''
        
        })
    '''
    Indicates that a client is currently sending control commands that
    has not completed.
    '''
    
    timeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The last time a control output was sent.
            '''
        
        })
    '''
    The last time a control output was sent.
    '''
    
    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit multiplier of the controlled quantity.
            '''
        
        })
    '''
    The unit multiplier of the controlled quantity.
    '''
    
    unitSymbol: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit of measure of the controlled quantity.
            '''
        
        })
    '''
    The unit of measure of the controlled quantity.
    '''
    
    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.Controls',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Regulating device governed by this control output.
            '''
        
        })
    '''
    Regulating device governed by this control output.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AccumulatorReset(Control):
    '''
    This command reset the counter value to zero.
    '''

    AccumulatorValue: Optional[AccumulatorValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorValue.AccumulatorReset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The accumulator value that is reset by the command.
            '''
        
        })
    '''
    The accumulator value that is reset by the command.
    '''
    
    AccumulatorValue: Optional[AccumulatorValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorValue.AccumulatorReset',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The accumulator value that is reset by the command.
            '''
        
        })
    '''
    The accumulator value that is reset by the command.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AnalogControl(Control):
    '''
    An analog control used for supervisory control.
    '''

    maxValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal value range maximum for any of the Control.value. Used for scaling,
            e.g. in bar graphs.
            '''
        
        })
    '''
    Normal value range maximum for any of the Control.value. Used for scaling,
    e.g. in bar graphs.
    '''
    
    minValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal value range minimum for any of the Control.value. Used for scaling,
            e.g. in bar graphs.
            '''
        
        })
    '''
    Normal value range minimum for any of the Control.value. Used for scaling,
    e.g. in bar graphs.
    '''
    
    AnalogValue: Optional[AnalogValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogValue.AnalogControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''
        
        })
    '''
    The MeasurementValue that is controlled.
    '''
    
    AnalogValue: Optional[AnalogValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogValue.AnalogControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''
        
        })
    '''
    The MeasurementValue that is controlled.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RaiseLowerCommand(AnalogControl):
    '''
    An analog control that increase or decrease a set point value with pulses.
    Unless otherwise specified, one pulse moves the set point by one.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.RaiseLowerCommands',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The ValueAliasSet used for translation of a Control value to a name.
            '''
        
        })
    '''
    The ValueAliasSet used for translation of a Control value to a name.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SetPoint(AnalogControl):
    '''
    An analog control that issue a set point value.
    '''

    normalValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal value for Control.value e.g. used for percentage scaling.
            '''
        
        })
    '''
    Normal value for Control.value e.g. used for percentage scaling.
    '''
    
    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The value representing the actuator output.
            '''
        
        })
    '''
    The value representing the actuator output.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Command(Control):
    '''
    A Command is a discrete control used for supervisory control.
    '''

    normalValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal value for Control.value e.g. used for percentage scaling.
            '''
        
        })
    '''
    Normal value for Control.value e.g. used for percentage scaling.
    '''
    
    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The value representing the actuator output.
            '''
        
        })
    '''
    The value representing the actuator output.
    '''
    
    DiscreteValue: Optional[DiscreteValue] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiscreteValue.Command',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''
        
        })
    '''
    The MeasurementValue that is controlled.
    '''
    
    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.Commands',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The ValueAliasSet used for translation of a Control value to a name.
            '''
        
        })
    '''
    The ValueAliasSet used for translation of a Control value to a name.
    '''
    
    DiscreteValue: Optional[DiscreteValue] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DiscreteValue.Command',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The MeasurementValue that is controlled.
            '''
        
        })
    '''
    The MeasurementValue that is controlled.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DiscreteCommand(Command):
    '''
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class MeasurementValue(IOPoint):
    '''
    The current state for a measurement. A state value is an instance of a
    measurement from a specific source. Measurements can be associated with
    many state values, each representing a different source for the measurement.
    '''

    timeStamp: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The time when the value was last updated
            '''
        
        })
    '''
    The time when the value was last updated
    '''
    
    sensorAccuracy: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The limit, expressed as a percentage of the sensor maximum, that errors
            will not exceed when the sensor is used under reference conditions.
            '''
        
        })
    '''
    The limit, expressed as a percentage of the sensor maximum, that errors
    will not exceed when the sensor is used under reference conditions.
    '''
    
    MeasurementValueQuality: Optional[MeasurementValueQuality] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueQuality.MeasurementValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''
        
        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''
    
    MeasurementValueSource: Optional[MeasurementValueSource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueSource.MeasurementValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A reference to the type of source that updates the MeasurementValue, e.g.
            SCADA, CCLink, manual, etc. User conventions for the names of sources are
            contained in the introduction to IEC 61970-301.
            '''
        
        })
    '''
    A reference to the type of source that updates the MeasurementValue,
    e.g. SCADA, CCLink, manual, etc. User conventions for the names of
    sources are contained in the introduction to IEC 61970-301.
    '''
    
    MeasurementValueQuality: Optional[MeasurementValueQuality] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValueQuality.MeasurementValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''
        
        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AccumulatorValue(MeasurementValue):
    '''
    AccumulatorValue represents an accumulated (counted) MeasurementValue.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The value to supervise. The value is positive.
            '''
        
        })
    '''
    The value to supervise. The value is positive.
    '''
    
    Accumulator: Optional[Accumulator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Accumulator.AccumulatorValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Measurement to which this value is connected.
            '''
        
        })
    '''
    Measurement to which this value is connected.
    '''
    
    AccumulatorReset: Optional[AccumulatorReset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorReset.AccumulatorValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The command that reset the accumulator value.
            '''
        
        })
    '''
    The command that reset the accumulator value.
    '''
    
    AccumulatorReset: Optional[AccumulatorReset] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorReset.AccumulatorValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The command that reset the accumulator value.
            '''
        
        })
    '''
    The command that reset the accumulator value.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AnalogValue(MeasurementValue):
    '''
    AnalogValue represents an analog MeasurementValue.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The value to supervise.
            '''
        
        })
    '''
    The value to supervise.
    '''
    
    Analog: Optional[Analog] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Analog.AnalogValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Measurement to which this value is connected.
            '''
        
        })
    '''
    Measurement to which this value is connected.
    '''
    
    AnalogControl: Optional[AnalogControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogControl.AnalogValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''
        
        })
    '''
    The Control variable associated with the MeasurementValue.
    '''
    
    AnalogControl: Optional[AnalogControl] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogControl.AnalogValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''
        
        })
    '''
    The Control variable associated with the MeasurementValue.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DiscreteValue(MeasurementValue):
    '''
    DiscreteValue represents a discrete MeasurementValue.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The value to supervise.
            '''
        
        })
    '''
    The value to supervise.
    '''
    
    Command: Optional[Command] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Command.DiscreteValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''
        
        })
    '''
    The Control variable associated with the MeasurementValue.
    '''
    
    Discrete: Optional[Discrete] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Discrete.DiscreteValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Measurement to which this value is connected.
            '''
        
        })
    '''
    Measurement to which this value is connected.
    '''
    
    Command: Optional[Command] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Command.DiscreteValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Control variable associated with the MeasurementValue.
            '''
        
        })
    '''
    The Control variable associated with the MeasurementValue.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StringMeasurementValue(MeasurementValue):
    '''
    StringMeasurementValue represents a measurement value of type string.
    '''

    value: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The value to supervise.
            '''
        
        })
    '''
    The value to supervise.
    '''
    
    StringMeasurement: Optional[StringMeasurement] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StringMeasurement.StringMeasurementValues',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Measurement to which this value is connected.
            '''
        
        })
    '''
    Measurement to which this value is connected.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Limit(IdentifiedObject):
    '''
    Specifies one limit value for a Measurement. A Measurement typically has
    several limits that are kept together by the LimitSet class. The actual
    meaning and use of a Limit instance (i.e., if it is an alarm or warning
    limit or if it is a high or low limit) is not captured in the Limit class.
    However the name of a Limit instance may indicate both meaning and use.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AccumulatorLimit(Limit):
    '''
    Limit values for Accumulator measurements.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The value to supervise against. The value is positive.
            '''
        
        })
    '''
    The value to supervise against. The value is positive.
    '''
    
    LimitSet: Optional[AccumulatorLimitSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AccumulatorLimitSet.Limits',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The set of limits.
            '''
        
        })
    '''
    The set of limits.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class AnalogLimit(Limit):
    '''
    Limit values for Analog measurements.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The value to supervise against.
            '''
        
        })
    '''
    The value to supervise against.
    '''
    
    LimitSet: Optional[AnalogLimitSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AnalogLimitSet.Limits',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The set of limits.
            '''
        
        })
    '''
    The set of limits.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LimitSet(IdentifiedObject):
    '''
    Specifies a set of Limits that are associated with a Measurement. A Measurement
    may have several LimitSets corresponding to seasonal or other changing
    conditions. The condition is captured in the name and description attributes.
    The same LimitSet may be used for several Measurements. In particular percentage
    limits are used this way.
    '''

    isPercentageLimits: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Tells if the limit values are in percentage of normalValue or the specified
            Unit for Measurements and Controls.
            '''
        
        })
    '''
    Tells if the limit values are in percentage of normalValue or the specified
    Unit for Measurements and Controls.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class AccumulatorLimitSet(LimitSet):
    '''
    An AccumulatorLimitSet specifies a set of Limits that are associated with
    an Accumulator measurement.
    '''

    Limits: list[AccumulatorLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AccumulatorLimit.LimitSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The limit values used for supervision of Measurements.
            '''
        
        })
    '''
    The limit values used for supervision of Measurements.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class AnalogLimitSet(LimitSet):
    '''
    An AnalogLimitSet specifies a set of Limits that are associated with an
    Analog measurement.
    '''

    Limits: list[AnalogLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AnalogLimit.LimitSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The limit values used for supervision of Measurements.
            '''
        
        })
    '''
    The limit values used for supervision of Measurements.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LoadGroup(IdentifiedObject):
    '''
    The class is the third level in a hierarchical structure for grouping of
    loads for the purpose of load flow load scaling.
    '''

    SubLoadArea: Optional[SubLoadArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubLoadArea.LoadGroups',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The SubLoadArea where the Loadgroup belongs.
            '''
        
        })
    '''
    The SubLoadArea where the Loadgroup belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ConformLoadGroup(LoadGroup):
    '''
    A group of loads conforming to an allocation pattern.
    '''

    EnergyConsumers: list[ConformLoad] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConformLoad.LoadGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Conform loads assigned to this ConformLoadGroup.
            '''
        
        })
    '''
    Conform loads assigned to this ConformLoadGroup.
    '''
    
    ConformLoadSchedules: list[ConformLoadSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConformLoadSchedule.ConformLoadGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The ConformLoadSchedules in the ConformLoadGroup.
            '''
        
        })
    '''
    The ConformLoadSchedules in the ConformLoadGroup.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class NonConformLoadGroup(LoadGroup):
    '''
    Loads that do not follow a daily and seasonal load variation pattern.
    '''

    EnergyConsumers: list[NonConformLoad] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonConformLoad.LoadGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Conform loads assigned to this ConformLoadGroup.
            '''
        
        })
    '''
    Conform loads assigned to this ConformLoadGroup.
    '''
    
    NonConformLoadSchedules: list[NonConformLoadSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonConformLoadSchedule.NonConformLoadGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The NonConformLoadSchedules in the NonConformLoadGroup.
            '''
        
        })
    '''
    The NonConformLoadSchedules in the NonConformLoadGroup.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LoadResponseCharacteristic(IdentifiedObject):
    '''
    Models the characteristic response of the load demand due to changes in
    system conditions such as voltage and frequency. This is not related to
    demand response.
    If LoadResponseCharacteristic.exponentModel is True, the voltage exponents
    are specified and used as to calculate:
    Active power component = Pnominal * (Voltage/cim:BaseVoltage.nominalVoltage)
    ** cim:LoadResponseCharacteristic.pVoltageExponent
    Reactive power component = Qnominal * (Voltage/cim:BaseVoltage.nominalVoltage)**
    cim:LoadResponseCharacteristic.qVoltageExponent
    Where * means "multiply" and ** is "raised to power of".
    '''

    exponentModel: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Indicates the exponential voltage dependency model is to be used. If false,
            the coefficient model is to be used.
            The exponential voltage dependency model consist of the attributes
            - pVoltageExponent
            - qVoltageExponent.
            The coefficient model consist of the attributes
            - pConstantImpedance
            - pConstantCurrent
            - pConstantPower
            - qConstantImpedance
            - qConstantCurrent
            - qConstantPower.
            The sum of pConstantImpedance, pConstantCurrent and pConstantPower shall
            equal 1.
            The sum of qConstantImpedance, qConstantCurrent and qConstantPower shall
            equal 1.
            '''
        
        })
    '''
    Indicates the exponential voltage dependency model is to be used. If
    false, the coefficient model is to be used.
    The exponential voltage dependency model consist of the attributes
    - pVoltageExponent
    - qVoltageExponent.
    The coefficient model consist of the attributes
    - pConstantImpedance
    - pConstantCurrent
    - pConstantPower
    - qConstantImpedance
    - qConstantCurrent
    - qConstantPower.
    The sum of pConstantImpedance, pConstantCurrent and pConstantPower
    shall equal 1.
    The sum of qConstantImpedance, qConstantCurrent and qConstantPower
    shall equal 1.
    '''
    
    pConstantCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Portion of active power load modeled as constant current.
            '''
        
        })
    '''
    Portion of active power load modeled as constant current.
    '''
    
    pConstantImpedance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Portion of active power load modeled as constant impedance.
            '''
        
        })
    '''
    Portion of active power load modeled as constant impedance.
    '''
    
    pConstantPower: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Portion of active power load modeled as constant power.
            '''
        
        })
    '''
    Portion of active power load modeled as constant power.
    '''
    
    pFrequencyExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    pVoltageExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Exponent of per unit voltage effecting real power.
            '''
        
        })
    '''
    Exponent of per unit voltage effecting real power.
    '''
    
    qConstantCurrent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Portion of reactive power load modeled as constant current.
            '''
        
        })
    '''
    Portion of reactive power load modeled as constant current.
    '''
    
    qConstantImpedance: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Portion of reactive power load modeled as constant impedance.
            '''
        
        })
    '''
    Portion of reactive power load modeled as constant impedance.
    '''
    
    qConstantPower: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Portion of reactive power load modeled as constant power.
            '''
        
        })
    '''
    Portion of reactive power load modeled as constant power.
    '''
    
    qFrequencyExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    qVoltageExponent: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Exponent of per unit voltage effecting reactive power.
            '''
        
        })
    '''
    Exponent of per unit voltage effecting reactive power.
    '''
    
    EnergyConsumer: list[EnergyConsumer] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumer.LoadResponse',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The set of loads that have the response characteristics.
            '''
        
        })
    '''
    The set of loads that have the response characteristics.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Location(IdentifiedObject):
    '''
    The place, scene, or point of something where someone or something has
    been, is, and/or will be at a given moment in time. It can be defined with
    one or more postition points (coordinates) in a given coordinate system.
    '''

    direction: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            (if applicable) Direction that allows field crews to quickly find a given
            asset. For a given location, such as a street address, this is the relative
            direction in which to find the asset. For example, a streetlight may be
            located at the 'NW' (northwest) corner of the customer's site, or a usage
            point may be located on the second floor of an apartment building.
            '''
        
        })
    '''
    (if applicable) Direction that allows field crews to quickly find a
    given asset. For a given location, such as a street address, this is
    the relative direction in which to find the asset. For example, a streetlight
    may be located at the 'NW' (northwest) corner of the customer's site,
    or a usage point may be located on the second floor of an apartment
    building.
    '''
    
    geoInfoReference: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            (if applicable) Reference to geographical information source, often external
            to the utility.
            '''
        
        })
    '''
    (if applicable) Reference to geographical information source, often
    external to the utility.
    '''
    
    type: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Classification by utility's corporate standards and practices, relative
            to the location itself (e.g., geographical, functional accounting, etc.,
            not a given property that happens to exist at that location).
            '''
        
        })
    '''
    Classification by utility's corporate standards and practices, relative
    to the location itself (e.g., geographical, functional accounting,
    etc., not a given property that happens to exist at that location).
    '''
    
    CoordinateSystem: Optional[CoordinateSystem] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CoordinateSystem.Locations',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Coordinate system used to describe position points of this location.
            '''
        
        })
    '''
    Coordinate system used to describe position points of this location.
    '''
    
    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.Locations',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Fault: list[Fault] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Fault.Location',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PositionPoints: list[PositionPoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PositionPoint.Location',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Sequence of position points describing this location, expressed in coordinate
            system 'Location.CoordinateSystem'.
            '''
        
        })
    '''
    Sequence of position points describing this location, expressed in
    coordinate system 'Location.CoordinateSystem'.
    '''
    
    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.Location',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All power system resources at this location.
            '''
        
        })
    '''
    All power system resources at this location.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Measurement(IdentifiedObject):
    '''
    A Measurement represents any measured, calculated or non-measured non-calculated
    quantity. Any piece of equipment may contain Measurements, e.g. a substation
    may have temperature measurements and door open indications, a transformer
    may have oil temperature and tank pressure measurements, a bay may contain
    a number of power flow measurements and a Breaker may contain a switch
    status measurement.
    The PSR - Measurement association is intended to capture this use of Measurement
    and is included in the naming hierarchy based on EquipmentContainer. The
    naming hierarchy typically has Measurements as leafs, e.g. Substation-VoltageLevel-Bay-Switch-Measurement.
    Some Measurements represent quantities related to a particular sensor location
    in the network, e.g. a voltage transformer (PT) at a busbar or a current
    transformer (CT) at the bar between a breaker and an isolator. The sensing
    position is not captured in the PSR - Measurement association. Instead
    it is captured by the Measurement - Terminal association that is used to
    define the sensing location in the network topology. The location is defined
    by the connection of the Terminal to ConductingEquipment.
    If both a Terminal and PSR are associated, and the PSR is of type ConductingEquipment,
    the associated Terminal should belong to that ConductingEquipment instance.
    When the sensor location is needed both Measurement-PSR and Measurement-Terminal
    are used. The Measurement-Terminal association is never used alone.
    '''

    measurementType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Specifies the type of measurement. For example, this specifies if the measurement
            represents an indoor temperature, outdoor temperature, bus voltage, line
            flow, etc.
            When the measurementType is set to "Specialization", the type of Measurement
            is defined in more detail by the specialized class which inherits from
            Measurement.
            '''
        
        })
    '''
    Specifies the type of measurement. For example, this specifies if the
    measurement represents an indoor temperature, outdoor temperature,
    bus voltage, line flow, etc.
    When the measurementType is set to "Specialization", the type of Measurement
    is defined in more detail by the specialized class which inherits from
    Measurement.
    '''
    
    phases: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Indicates to which phases the measurement applies and avoids the need to
            use 'measurementType' to also encode phase information (which would explode
            the types). The phase information in Measurement, along with 'measurementType'
            and 'phases' uniquely defines a Measurement for a device, based on normal
            network phase. Their meaning will not change when the computed energizing
            phasing is changed due to jumpers or other reasons.
            If the attribute is missing three phases (ABC) shall be assumed.
            '''
        
        })
    '''
    Indicates to which phases the measurement applies and avoids the need
    to use 'measurementType' to also encode phase information (which would
    explode the types). The phase information in Measurement, along with
    'measurementType' and 'phases' uniquely defines a Measurement for a
    device, based on normal network phase. Their meaning will not change
    when the computed energizing phasing is changed due to jumpers or other
    reasons.
    If the attribute is missing three phases (ABC) shall be assumed.
    '''
    
    Asset: Optional[Asset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Asset.Measurements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.Measurements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The power system resource that contains the measurement.
            '''
        
        })
    '''
    The power system resource that contains the measurement.
    '''
    
    Terminal: Optional[ACDCTerminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCTerminal.Measurements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            One or more measurements may be associated with a terminal in the network.
            '''
        
        })
    '''
    One or more measurements may be associated with a terminal in the network.
    '''
    
    Locations: list[Location] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Location.Measurements',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Accumulator(Measurement):
    '''
    Accumulator represents an accumulated (counted) Measurement, e.g. an energy
    value.
    '''

    maxValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''
        
        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''
    
    AccumulatorValues: list[AccumulatorValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AccumulatorValue.Accumulator',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The values connected to this measurement.
            '''
        
        })
    '''
    The values connected to this measurement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Analog(Measurement):
    '''
    Analog represents an analog Measurement.
    '''

    maxValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''
        
        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''
    
    minValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal value range minimum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''
        
        })
    '''
    Normal value range minimum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''
    
    normalValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal measurement value, e.g., used for percentage calculations.
            '''
        
        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''
    
    positiveFlowIn: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            If true then this measurement is an active power, reactive power or current
            with the convention that a positive value measured at the Terminal means
            power is flowing into the related PowerSystemResource.
            '''
        
        })
    '''
    If true then this measurement is an active power, reactive power or
    current with the convention that a positive value measured at the Terminal
    means power is flowing into the related PowerSystemResource.
    '''
    
    AnalogValues: list[AnalogValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AnalogValue.Analog',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The values connected to this measurement.
            '''
        
        })
    '''
    The values connected to this measurement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Discrete(Measurement):
    '''
    Discrete represents a discrete Measurement, i.e. a Measurement representing
    discrete values, e.g. a Breaker position.
    '''

    maxValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal value range maximum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''
        
        })
    '''
    Normal value range maximum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''
    
    minValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal value range minimum for any of the MeasurementValue.values. Used
            for scaling, e.g. in bar graphs or of telemetered raw values.
            '''
        
        })
    '''
    Normal value range minimum for any of the MeasurementValue.values.
    Used for scaling, e.g. in bar graphs or of telemetered raw values.
    '''
    
    normalValue: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal measurement value, e.g., used for percentage calculations.
            '''
        
        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''
    
    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.Discretes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The ValueAliasSet used for translation of a MeasurementValue.value to a
            name.
            '''
        
        })
    '''
    The ValueAliasSet used for translation of a MeasurementValue.value
    to a name.
    '''
    
    DiscreteValues: list[DiscreteValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'DiscreteValue.Discrete',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The values connected to this measurement.
            '''
        
        })
    '''
    The values connected to this measurement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StringMeasurement(Measurement):
    '''
    StringMeasurement represents a measurement with values of type string.
    '''

    StringMeasurementValues: list[StringMeasurementValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'StringMeasurementValue.StringMeasurement',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The values connected to this measurement.
            '''
        
        })
    '''
    The values connected to this measurement.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MeasurementValueSource(IdentifiedObject):
    '''
    MeasurementValueSource describes the alternative sources updating a MeasurementValue.
    User conventions for how to use the MeasurementValueSource attributes are
    described in the introduction to IEC 61970-301.
    '''

    MeasurementValues: list[MeasurementValue] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'MeasurementValue.MeasurementValueSource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The MeasurementValues updated by the source.
            '''
        
        })
    '''
    The MeasurementValues updated by the source.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MutualCoupling(IdentifiedObject):
    '''
    This class represents the zero sequence line mutual coupling.
    '''

    b0ch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence mutual coupling shunt (charging) susceptance, uniformly distributed,
            of the entire line section.
            '''
        
        })
    '''
    Zero sequence mutual coupling shunt (charging) susceptance, uniformly
    distributed, of the entire line section.
    '''
    
    distance11: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Distance to the start of the coupled region from the first line's terminal
            having sequence number equal to 1.
            '''
        
        })
    '''
    Distance to the start of the coupled region from the first line's terminal
    having sequence number equal to 1.
    '''
    
    distance12: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Distance to the end of the coupled region from the first line's terminal
            with sequence number equal to 1.
            '''
        
        })
    '''
    Distance to the end of the coupled region from the first line's terminal
    with sequence number equal to 1.
    '''
    
    distance21: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Distance to the start of coupled region from the second line's terminal
            with sequence number equal to 1.
            '''
        
        })
    '''
    Distance to the start of coupled region from the second line's terminal
    with sequence number equal to 1.
    '''
    
    distance22: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Distance to the end of coupled region from the second line's terminal with
            sequence number equal to 1.
            '''
        
        })
    '''
    Distance to the end of coupled region from the second line's terminal
    with sequence number equal to 1.
    '''
    
    g0ch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence mutual coupling shunt (charging) conductance, uniformly distributed,
            of the entire line section.
            '''
        
        })
    '''
    Zero sequence mutual coupling shunt (charging) conductance, uniformly
    distributed, of the entire line section.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence branch-to-branch mutual impedance coupling, resistance.
            '''
        
        })
    '''
    Zero sequence branch-to-branch mutual impedance coupling, resistance.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence branch-to-branch mutual impedance coupling, reactance.
            '''
        
        })
    '''
    Zero sequence branch-to-branch mutual impedance coupling, reactance.
    '''
    
    First_Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.HasFirstMutualCoupling',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The starting terminal for the calculation of distances along the first
            branch of the mutual coupling. Normally MutualCoupling would only be used
            for terminals of AC line segments. The first and second terminals of a
            mutual coupling should point to different AC line segments.
            '''
        
        })
    '''
    The starting terminal for the calculation of distances along the first
    branch of the mutual coupling. Normally MutualCoupling would only be
    used for terminals of AC line segments. The first and second terminals
    of a mutual coupling should point to different AC line segments.
    '''
    
    Second_Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.HasSecondMutualCoupling',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The starting terminal for the calculation of distances along the second
            branch of the mutual coupling.
            '''
        
        })
    '''
    The starting terminal for the calculation of distances along the second
    branch of the mutual coupling.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OperatingParticipant(IdentifiedObject):
    '''
    An operator of multiple power system resource objects. Note multple operating
    participants may operate the same power system resource object. This can
    be used for modeling jointly owned units where each owner operates as a
    contractual share.
    '''

    OperatingShare: list[OperatingShare] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperatingShare.OperatingParticipant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The operating shares of this operating participant. An operating participant
            can be resused for any number of power system resources.
            '''
        
        })
    '''
    The operating shares of this operating participant. An operating participant
    can be resused for any number of power system resources.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OperationalLimit(IdentifiedObject):
    '''
    A value associated with a specific kind of limit.
    The sub class value attribute shall be positive.
    The sub class value attribute is inversely proportional to OperationalLimitType.acceptableDuration
    (acceptableDuration for short). A pair of value_x and acceptableDuration_x
    are related to each other as follows:
    if value_1 &gt; value_2 &gt; value_3 &gt;... then
    acceptableDuration_1 &lt; acceptableDuration_2 &lt; acceptableDuration_3
    &lt; ...
    A value_x with direction="high" shall be greater than a value_y with direction="low".
    '''

    OperationalLimitSet: Optional[OperationalLimitSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OperationalLimitSet.OperationalLimitValue',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The limit set to which the limit values belong.
            '''
        
        })
    '''
    The limit set to which the limit values belong.
    '''
    
    OperationalLimitType: Optional[OperationalLimitType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OperationalLimitType.OperationalLimit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The limit type associated with this limit.
            '''
        
        })
    '''
    The limit type associated with this limit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ActivePowerLimit(OperationalLimit):
    '''
    Limit on active power flow.
    '''

    normalValue: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The normal value of active power limit.
            '''
        
        })
    '''
    The normal value of active power limit.
    '''
    
    value: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Value of active power limit.
            '''
        
        })
    '''
    Value of active power limit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ApparentPowerLimit(OperationalLimit):
    '''
    Apparent power limit.
    '''

    normalValue: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The normal apparent power limit.
            '''
        
        })
    '''
    The normal apparent power limit.
    '''
    
    value: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The apparent power limit.
            '''
        
        })
    '''
    The apparent power limit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class CurrentLimit(OperationalLimit):
    '''
    Operational limit on current.
    '''

    normalValue: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The normal value for limit on current flow.
            '''
        
        })
    '''
    The normal value for limit on current flow.
    '''
    
    value: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Limit on current flow.
            '''
        
        })
    '''
    Limit on current flow.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class VoltageLimit(OperationalLimit):
    '''
    Operational limit applied to voltage.
    '''

    normalValue: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The normal limit on voltage. High or low limit nature of the limit depends
            upon the properties of the operational limit type.
            '''
        
        })
    '''
    The normal limit on voltage. High or low limit nature of the limit
    depends upon the properties of the operational limit type.
    '''
    
    value: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Limit on voltage. High or low limit nature of the limit depends upon the
            properties of the operational limit type.
            '''
        
        })
    '''
    Limit on voltage. High or low limit nature of the limit depends upon
    the properties of the operational limit type.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class OperationalLimitSet(IdentifiedObject):
    '''
    A set of limits associated with equipment. Sets of limits might apply to
    a specific temperature, or season for example. A set of limits may contain
    different severities of limit levels that would apply to the same equipment.
    The set may contain limits of different types such as apparent power and
    current limits or high and low voltage limits that are logically applied
    together as a set.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.OperationalLimitSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Equipment: Optional[Equipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Equipment.OperationalLimitSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The equipment to which the limit set applies.
            '''
        
        })
    '''
    The equipment to which the limit set applies.
    '''
    
    Terminal: Optional[ACDCTerminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACDCTerminal.OperationalLimitSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    OperationalLimitValue: list[OperationalLimit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimit.OperationalLimitSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Values of equipment limits.
            '''
        
        })
    '''
    Values of equipment limits.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class OperationalLimitType(IdentifiedObject):
    '''
    The operational meaning of a category of limits.
    '''

    acceptableDuration: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The nominal acceptable duration of the limit. Limits are commonly expressed
            in terms of the a time limit for which the limit is normally acceptable.
            The actual acceptable duration of a specific limit may depend on other
            local factors such as temperature or wind speed.
            '''
        
        })
    '''
    The nominal acceptable duration of the limit. Limits are commonly expressed
    in terms of the a time limit for which the limit is normally acceptable.
    The actual acceptable duration of a specific limit may depend on other
    local factors such as temperature or wind speed.
    '''
    
    direction: Optional[ OperationalLimitDirectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The direction of the limit.
            '''
        
        })
    '''
    The direction of the limit.
    '''
    
    OperationalLimit: list[OperationalLimit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimit.OperationalLimitType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The operational limits associated with this type of limit.
            '''
        
        })
    '''
    The operational limits associated with this type of limit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Ownership(IdentifiedObject):
    '''
    Ownership of e.g. asset.
    '''

    share: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Share of this ownership.
            '''
        
        })
    '''
    Share of this ownership.
    '''
    
    Asset: Optional[Asset] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Asset.Ownerships',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Asset that is object of this ownership.
            '''
        
        })
    '''
    Asset that is object of this ownership.
    '''
    
    AssetOwner: Optional[AssetOwner] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetOwner.Ownerships',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Asset owner that is subject in this ownership.
            '''
        
        })
    '''
    Asset owner that is subject in this ownership.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PSRType(IdentifiedObject):
    '''
    Classifying instances of the same class, e.g. overhead and underground
    ACLineSegments. This classification mechanism is intended to provide flexibility
    outside the scope of this standard, i.e. provide customisation that is
    non standard.
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerSystemResource.PSRType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Power system resources classified with this power system resource type.
            '''
        
        })
    '''
    Power system resources classified with this power system resource type.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ParallelLineSegment(IdentifiedObject):
    '''
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.ParallelLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    RightOfWay: Optional[RightOfWay] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RightOfWay.ParallelLineSegments',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.ParallelLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PerLengthLineParameter(IdentifiedObject):
    '''
    Common type for per-length electrical catalogues describing line parameters.
    '''

    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.PerLengthLineParameter',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PerLengthImpedance(PerLengthLineParameter):
    '''
    Common type for per-length impedance electrical catalogues.
    '''

    ACLineSegments: list[ACLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegment.PerLengthImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All line segments described by this per-length impedance.
            '''
        
        })
    '''
    All line segments described by this per-length impedance.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PerLengthPhaseImpedance(PerLengthImpedance):
    '''
    Impedance and admittance parameters per unit length for n-wire unbalanced
    lines, in matrix form.
    '''

    conductorCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Number of phase, neutral, and other wires retained. Constrains the number
            of matrix elements and the phase codes that can be used with this matrix.
            '''
        
        })
    '''
    Number of phase, neutral, and other wires retained. Constrains the
    number of matrix elements and the phase codes that can be used with
    this matrix.
    '''
    
    PhaseImpedanceData: list[PhaseImpedanceData] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseImpedanceData.PhaseImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All data that belong to this conductor phase impedance.
            '''
        
        })
    '''
    All data that belong to this conductor phase impedance.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PerLengthSequenceImpedance(PerLengthImpedance):
    '''
    Sequence impedance and admittance parameters per unit length, for transposed
    lines of 1, 2, or 3 phases. For 1-phase lines, define x=x0=xself. For 2-phase
    lines, define x=xs-xm and x0=xs+xm.
    '''

    b0ch: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance, per unit of length.
            '''
        
        })
    '''
    Zero sequence shunt (charging) susceptance, per unit of length.
    '''
    
    bch: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance, per unit of length.
            '''
        
        })
    '''
    Positive sequence shunt (charging) susceptance, per unit of length.
    '''
    
    g0ch: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence shunt (charging) conductance, per unit of length.
            '''
        
        })
    '''
    Zero sequence shunt (charging) conductance, per unit of length.
    '''
    
    gch: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance, per unit of length.
            '''
        
        })
    '''
    Positive sequence shunt (charging) conductance, per unit of length.
    '''
    
    r: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence series resistance, per unit of length.
            '''
        
        })
    '''
    Positive sequence series resistance, per unit of length.
    '''
    
    r0: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence series resistance, per unit of length.
            '''
        
        })
    '''
    Zero sequence series resistance, per unit of length.
    '''
    
    x: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence series reactance, per unit of length.
            '''
        
        })
    '''
    Positive sequence series reactance, per unit of length.
    '''
    
    x0: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence series reactance, per unit of length.
            '''
        
        })
    '''
    Zero sequence series reactance, per unit of length.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerTable(IdentifiedObject):
    '''
    Describes a tabular curve for how the phase angle difference and impedance
    varies with the tap step.
    '''

    PhaseTapChangerTablePoint: list[PhaseTapChangerTablePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseTapChangerTablePoint.PhaseTapChangerTable',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The points of this table.
            '''
        
        })
    '''
    The points of this table.
    '''
    
    PhaseTapChangerTabular: list[PhaseTapChangerTabular] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PhaseTapChangerTabular.PhaseTapChangerTable',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The phase tap changers to which this phase tap table applies.
            '''
        
        })
    '''
    The phase tap changers to which this phase tap table applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class PowerSystemResource(IdentifiedObject):
    '''
    A power system resource can be an item of equipment such as a switch, an
    equipment container containing many individual items of equipment such
    as a substation, or an organisational entity such as sub-control area.
    Power system resources can have measurements associated.
    '''

    AssetDatasheet: Optional[AssetInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AssetInfo.PowerSystemResources',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Datasheet information for this power system resource.
            '''
        
        })
    '''
    Datasheet information for this power system resource.
    '''
    
    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.PowerSystemResources',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Location of this power system resource.
            '''
        
        })
    '''
    Location of this power system resource.
    '''
    
    PSRType: Optional[PSRType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PSRType.PowerSystemResources',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Custom classification for this power system resource.
            '''
        
        })
    '''
    Custom classification for this power system resource.
    '''
    
    Controls: list[Control] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Control.PowerSystemResource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The controller outputs used to actually govern a regulating device, e.g.
            the magnetization of a synchronous machine or capacitor bank breaker actuator.
            '''
        
        })
    '''
    The controller outputs used to actually govern a regulating device,
    e.g. the magnetization of a synchronous machine or capacitor bank breaker
    actuator.
    '''
    
    Measurements: list[Measurement] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Measurement.PowerSystemResource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The measurements associated with this power system resource.
            '''
        
        })
    '''
    The measurements associated with this power system resource.
    '''
    
    OperatingShare: list[OperatingShare] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperatingShare.PowerSystemResource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The operating shares of this power system resource.
            '''
        
        })
    '''
    The operating shares of this power system resource.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ACLineSegmentPhase(PowerSystemResource):
    '''
    Represents a single wire of an alternating current line segment.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Number designation for this line segment phase. Each line segment phase
            within a line segment should have a unique sequence number. This is useful
            for unbalanced modeling to bind the mathematical model (PhaseImpedanceData
            of PerLengthPhaseImpedance) with the connectivity model (this class) and
            the physical model (WirePosition, WirePhaseInfo) without tight coupling.
            Multiple circuits on the same pole, tower or right-of-way can be included
            with unique sequence numbers for the phases, and identical sequence numbers
            for any shared neutrals.
            '''
        
        })
    '''
    Number designation for this line segment phase. Each line segment phase
    within a line segment should have a unique sequence number. This is
    useful for unbalanced modeling to bind the mathematical model (PhaseImpedanceData
    of PerLengthPhaseImpedance) with the connectivity model (this class)
    and the physical model (WirePosition, WirePhaseInfo) without tight
    coupling. Multiple circuits on the same pole, tower or right-of-way
    can be included with unique sequence numbers for the phases, and identical
    sequence numbers for any shared neutrals.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The phase connection of the wire at both ends.
            '''
        
        })
    '''
    The phase connection of the wire at both ends.
    '''
    
    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.ACLineSegmentPhases',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The line segment to which the phase belongs.
            '''
        
        })
    '''
    The line segment to which the phase belongs.
    '''
    
    WireInfo: Optional[WireInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireInfo.ACLineSegmentPhases',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class AirCompressor(PowerSystemResource):
    '''
    Combustion turbine air compressor which is an integral part of a compressed
    air energy storage (CAES) plant.
    '''

    airCompressorRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rating of the CAES air compressor.
            '''
        
        })
    '''
    Rating of the CAES air compressor.
    '''
    
    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.AirCompressor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''
        
        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''
    
    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.AirCompressor',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''
        
        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CAESPlant(PowerSystemResource):
    '''
    Compressed air energy storage plant.
    '''

    energyStorageCapacity: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The rated energy storage capacity.
            '''
        
        })
    '''
    The rated energy storage capacity.
    '''
    
    ratedCapacityP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The CAES plant's gross rated generating capacity.
            '''
        
        })
    '''
    The CAES plant's gross rated generating capacity.
    '''
    
    AirCompressor: Optional[AirCompressor] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AirCompressor.CAESPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''
        
        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.CAESPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''
    
    AirCompressor: Optional[AirCompressor] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'AirCompressor.CAESPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            An air compressor may be a member of a compressed air energy storage plant.
            '''
        
        })
    '''
    An air compressor may be a member of a compressed air energy storage
    plant.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.CAESPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CogenerationPlant(PowerSystemResource):
    '''
    A set of thermal generating units for the production of electrical energy
    and process steam (usually from the output of the steam turbines). The
    steam sendout is typically used for industrial purposes or for municipal
    heating and cooling.
    '''

    cogenHPSendoutRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The high pressure steam sendout.
            '''
        
        })
    '''
    The high pressure steam sendout.
    '''
    
    cogenHPSteamRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The high pressure steam rating.
            '''
        
        })
    '''
    The high pressure steam rating.
    '''
    
    cogenLPSendoutRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The low pressure steam sendout.
            '''
        
        })
    '''
    The low pressure steam sendout.
    '''
    
    cogenLPSteamRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The low pressure steam rating.
            '''
        
        })
    '''
    The low pressure steam rating.
    '''
    
    ratedP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The rated output active power of the cogeneration plant.
            '''
        
        })
    '''
    The rated output active power of the cogeneration plant.
    '''
    
    SteamSendoutSchedule: Optional[SteamSendoutSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SteamSendoutSchedule.CogenerationPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''
        
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''
    
    SteamSendoutSchedule: Optional[SteamSendoutSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SteamSendoutSchedule.CogenerationPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A cogeneration plant has a steam sendout schedule.
            '''
        
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''
    
    ThermalGeneratingUnits: list[ThermalGeneratingUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ThermalGeneratingUnit.CogenerationPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may be a member of a cogeneration plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a cogeneration plant.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class CombinedCyclePlant(PowerSystemResource):
    '''
    A set of combustion turbines and steam turbines where the exhaust heat
    from the combustion turbines is recovered to make steam for the steam turbines,
    resulting in greater overall plant efficiency.
    '''

    combCyclePlantRating: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The combined cycle plant's active power output rating.
            '''
        
        })
    '''
    The combined cycle plant's active power output rating.
    '''
    
    ThermalGeneratingUnits: list[ThermalGeneratingUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ThermalGeneratingUnit.CombinedCyclePlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may be a member of a combined cycle plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a combined cycle plant.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConnectivityNodeContainer(PowerSystemResource):
    '''
    A base class for all objects that may contain connectivity nodes or topological
    nodes.
    '''

    ConnectivityNodes: list[ConnectivityNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConnectivityNode.ConnectivityNodeContainer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Connectivity nodes which belong to this connectivity node container.
            '''
        
        })
    '''
    Connectivity nodes which belong to this connectivity node container.
    '''
    
    TopologicalNode: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.ConnectivityNodeContainer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The topological nodes which belong to this connectivity node container.
            '''
        
        })
    '''
    The topological nodes which belong to this connectivity node container.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class EquipmentContainer(ConnectivityNodeContainer):
    '''
    A modeling construct to provide a root class for containing equipment.
    '''

    Equipments: list[Equipment] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Equipment.EquipmentContainer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Contained equipment.
            '''
        
        })
    '''
    Contained equipment.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Bay(EquipmentContainer):
    '''
    A collection of power system resources (within a given substation) including
    conducting equipment, protection relays, measurements, and telemetry. A
    bay typically represents a physical grouping related to modularization
    of equipment.
    '''

    bayEnergyMeasFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Indicates the presence/absence of energy measurements.
            '''
        
        })
    '''
    Indicates the presence/absence of energy measurements.
    '''
    
    bayPowerMeasFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Indicates the presence/absence of active/reactive power measurements.
            '''
        
        })
    '''
    Indicates the presence/absence of active/reactive power measurements.
    '''
    
    breakerConfiguration: Optional[ BreakerConfiguration ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Breaker configuration.
            '''
        
        })
    '''
    Breaker configuration.
    '''
    
    busBarConfiguration: Optional[ BusbarConfiguration ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Bus bar configuration.
            '''
        
        })
    '''
    Bus bar configuration.
    '''
    
    Substation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.Bays',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Substation containing the bay.
            '''
        
        })
    '''
    Substation containing the bay.
    '''
    
    VoltageLevel: Optional[VoltageLevel] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VoltageLevel.Bays',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The voltage level containing this bay.
            '''
        
        })
    '''
    The voltage level containing this bay.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Feeder(EquipmentContainer):
    '''
    A collection of equipment for organizational purposes, used for grouping
    distribution resources.
    The organization a feeder does not necessarily reflect connectivity or
    current operation state.
    '''

    DistributionArea: Optional[DistributionArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DistributionArea.Feeders',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The DistributionArea to which the feeder belongs
            '''
        
        })
    '''
    The DistributionArea to which the feeder belongs
    '''
    
    FeederArea: Optional[FeederArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FeederArea.Feeder',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The FeederArea (which contains Equipment not contained in
            '''
        
        })
    '''
    The FeederArea (which contains Equipment not contained in
    '''
    
    NormalEnergizingSubstation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.NormalEnergizedFeeder',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The substation that nominally energizes the feeder. Also used for naming
            purposes.
            '''
        
        })
    '''
    The substation that nominally energizes the feeder. Also used for naming
    purposes.
    '''
    
    FeederArea: Optional[FeederArea] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FeederArea.Feeder',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The FeederArea (which contains Equipment not contained in
            '''
        
        })
    '''
    The FeederArea (which contains Equipment not contained in
    '''
    
    NamingSecondarySubstation: list[Substation] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Substation.NamingFeeder',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The secondary substations that are normally energized from the feeder.
            Used for naming purposes. Should be consistent with the other associations
            for energizing terminal specification and the feeder energization specification.
            '''
        
        })
    '''
    The secondary substations that are normally energized from the feeder.
    Used for naming purposes. Should be consistent with the other associations
    for energizing terminal specification and the feeder energization specification.
    '''
    
    NormalHeadTerminal: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.NormalHeadFeeder',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The normal head terminal or terminals of the feeder.
            '''
        
        })
    '''
    The normal head terminal or terminals of the feeder.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Line(EquipmentContainer):
    '''
    Contains equipment beyond a substation belonging to a power transmission
    line.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubGeographicalRegion.Lines',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The sub-geographical region of the line.
            '''
        
        })
    '''
    The sub-geographical region of the line.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Plant(EquipmentContainer):
    '''
    A Plant is a collection of equipment for purposes of generation.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Substation(EquipmentContainer):
    '''
    A collection of equipment for purposes other than generation or utilization,
    through which electric energy in bulk is passed for the purposes of switching
    or modifying its characteristics.
    '''

    NamingFeeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.NamingSecondarySubstation',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The primary feeder that normally energizes the secondary substation. Used
            for naming purposes. Either this association or the substation to subgeographical
            region should be used for hiearchical containment specification.
            '''
        
        })
    '''
    The primary feeder that normally energizes the secondary substation.
    Used for naming purposes. Either this association or the substation
    to subgeographical region should be used for hiearchical containment
    specification.
    '''
    
    Region: Optional[SubGeographicalRegion] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubGeographicalRegion.Substations',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The SubGeographicalRegion containing the substation.
            '''
        
        })
    '''
    The SubGeographicalRegion containing the substation.
    '''
    
    SchedulingArea: Optional[SchedulingArea] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SchedulingArea.Substations',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The SchedulingArea to which the substation is assigned. The highest-level
            area (e.g. DistributionArea) should be used.
            '''
        
        })
    '''
    The SchedulingArea to which the substation is assigned. The highest-level
    area (e.g. DistributionArea) should be used.
    '''
    
    Bays: list[Bay] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Bay.Substation',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Bays contained in the substation.
            '''
        
        })
    '''
    Bays contained in the substation.
    '''
    
    NormalEnergizedFeeder: list[Feeder] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Feeder.NormalEnergizingSubstation',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The normal energized feeders of the substation. Also used for naming purposes.
            '''
        
        })
    '''
    The normal energized feeders of the substation. Also used for naming
    purposes.
    '''
    
    VoltageLevels: list[VoltageLevel] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'VoltageLevel.Substation',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The voltage levels within this substation.
            '''
        
        })
    '''
    The voltage levels within this substation.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class VoltageLevel(EquipmentContainer):
    '''
    A collection of equipment at one common system voltage forming a switchgear.
    The equipment typically consist of breakers, busbars, instrumentation,
    control, regulation and protection devices as well as assemblies of all
    these.
    '''

    highVoltageLimit: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The bus bar's high voltage limit
            '''
        
        })
    '''
    The bus bar's high voltage limit
    '''
    
    lowVoltageLimit: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The bus bar's low voltage limit
            '''
        
        })
    '''
    The bus bar's low voltage limit
    '''
    
    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.VoltageLevel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The base voltage used for all equipment within the voltage level.
            '''
        
        })
    '''
    The base voltage used for all equipment within the voltage level.
    '''
    
    Substation: Optional[Substation] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Substation.VoltageLevels',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The substation of the voltage level.
            '''
        
        })
    '''
    The substation of the voltage level.
    '''
    
    Bays: list[Bay] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Bay.VoltageLevel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The bays within this voltage level.
            '''
        
        })
    '''
    The bays within this voltage level.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class EnergyConsumerPhase(PowerSystemResource):
    '''
    A single phase of an energy consumer.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Active power of the load. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Active power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase of this energy consumer component. If the energy consumer is wye
            connected, the connection is from the indicated phase to the central ground
            or neutral point. If the energy consumer is delta connected, the phase
            indicates an energy consumer connected from the indicated phase to the
            next logical non-neutral phase.
            '''
        
        })
    '''
    Phase of this energy consumer component. If the energy consumer is
    wye connected, the connection is from the indicated phase to the central
    ground or neutral point. If the energy consumer is delta connected,
    the phase indicates an energy consumer connected from the indicated
    phase to the next logical non-neutral phase.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reactive power of the load. Load sign convention is used, i.e. positive
            sign means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Reactive power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''
    
    EnergyConsumer: Optional[EnergyConsumer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyConsumer.EnergyConsumerPhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The energy consumer to which this phase belongs.
            '''
        
        })
    '''
    The energy consumer to which this phase belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class EnergySourcePhase(PowerSystemResource):
    '''
    Represents the single phase information of an unbalanced energy source.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase of this energy source component. If the energy source wye connected,
            the connection is from the indicated phase to the central ground or neutral
            point. If the energy source is delta connected, the phase indicates an
            energy source connected from the indicated phase to the next logical non-neutral
            phase.
            '''
        
        })
    '''
    Phase of this energy source component. If the energy source wye connected,
    the connection is from the indicated phase to the central ground or
    neutral point. If the energy source is delta connected, the phase indicates
    an energy source connected from the indicated phase to the next logical
    non-neutral phase.
    '''
    
    EnergySource: Optional[EnergySource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergySource.EnergySourcePhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The energy sourceto which the phase belongs.
            '''
        
        })
    '''
    The energy sourceto which the phase belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Equipment(PowerSystemResource):
    '''
    The parts of a power system that are physical devices, electronic or mechanical.
    '''

    aggregate: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The single instance of equipment represents multiple pieces of equipment
            that have been modeled together as an aggregate. Examples would be power
            transformers or synchronous machines operating in parallel modeled as a
            single aggregate power transformer or aggregate synchronous machine. This
            is not to be used to indicate equipment that is part of a group of interdependent
            equipment produced by a network production program.
            '''
        
        })
    '''
    The single instance of equipment represents multiple pieces of equipment
    that have been modeled together as an aggregate. Examples would be
    power transformers or synchronous machines operating in parallel modeled
    as a single aggregate power transformer or aggregate synchronous machine.
    This is not to be used to indicate equipment that is part of a group
    of interdependent equipment produced by a network production program.
    '''
    
    inService: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            If true, the equipment is in service.
            '''
        
        })
    '''
    If true, the equipment is in service.
    '''
    
    networkAnalysisEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The equipment is enabled to participate in network analysis. If unspecified,
            the value is assumed to be true.
            '''
        
        })
    '''
    The equipment is enabled to participate in network analysis. If unspecified,
    the value is assumed to be true.
    '''
    
    normallyInService: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            If true, the equipment is normally in service.
            '''
        
        })
    '''
    If true, the equipment is normally in service.
    '''
    
    EquipmentContainer: Optional[EquipmentContainer] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EquipmentContainer.Equipments',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Container of this equipment.
            '''
        
        })
    '''
    Container of this equipment.
    '''
    
    SubSchedulingArea: Optional[SubSchedulingArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SubSchedulingArea.ContainedEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The SubSchedulingArea in which the equipment is contained and controlled.
            '''
        
        })
    '''
    The SubSchedulingArea in which the equipment is contained and controlled.
    '''
    
    UsagePoints: Optional[UsagePoint] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'UsagePoint.Equipments',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All usage points connected to the electrical grid through this equipment.
            '''
        
        })
    '''
    All usage points connected to the electrical grid through this equipment.
    '''
    
    ContingencyEquipment: list[ContingencyEquipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ContingencyEquipment.Equipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The contingency equipments in which this equipment participates.
            '''
        
        })
    '''
    The contingency equipments in which this equipment participates.
    '''
    
    Faults: list[Fault] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Fault.FaultyEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All faults on this equipment.
            '''
        
        })
    '''
    All faults on this equipment.
    '''
    
    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'OperationalLimitSet.Equipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The operational limit sets associated with this equipment.
            '''
        
        })
    '''
    The operational limit sets associated with this equipment.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class CompositeSwitch(Equipment):
    '''
    A model of a set of individual Switches normally enclosed within the same
    cabinet and possibly with interlocks that restrict the combination of switch
    positions. These are typically found in medium voltage distribution networks.
    A CompositeSwitch could represent a Ring-Main-Unit (RMU), or pad-mounted
    switchgear, with primitive internal devices such as an internal bus-bar
    plus 3 or 4 internal switches each of which may individually be open or
    closed. A CompositeSwitch and a set of contained Switches can also be used
    to represent a multi-position switch e.g. a switch that can connect a circuit
    to Ground, Open or Busbar.
    '''

    compositeSwitchType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            An alphanumeric code that can be used as a reference to extra information
            such as the description of the interlocking scheme if any.
            '''
        
        })
    '''
    An alphanumeric code that can be used as a reference to extra information
    such as the description of the interlocking scheme if any.
    '''
    
    Switches: list[Switch] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Switch.CompositeSwitch',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Switches contained in this Composite switch.
            '''
        
        })
    '''
    Switches contained in this Composite switch.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConductingEquipment(Equipment):
    '''
    The parts of the AC power system that are designed to carry current or
    that are conductively connected through terminals.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.ConductingEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Base voltage of this conducting equipment. Use only when there is no voltage
            level container used and only one base voltage applies. For example, not
            used for transformers.
            '''
        
        })
    '''
    Base voltage of this conducting equipment. Use only when there is no
    voltage level container used and only one base voltage applies. For
    example, not used for transformers.
    '''
    
    SvStatus: list[SvStatus] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvStatus.ConductingEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The status state variable associated with this conducting equipment.
            '''
        
        })
    '''
    The status state variable associated with this conducting equipment.
    '''
    
    Terminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.ConductingEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Conducting equipment have terminals that may be connected to other conducting
            equipment terminals via connectivity nodes or topological nodes.
            '''
        
        })
    '''
    Conducting equipment have terminals that may be connected to other
    conducting equipment terminals via connectivity nodes or topological
    nodes.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Clamp(ConductingEquipment):
    '''
    A Clamp is a galvanic connection at a line segment where other equipment
    is connected. A Clamp does not cut the line segment.
    A Clamp is ConductingEquipment and has one Terminal with an associated
    ConnectivityNode. Any other ConductingEquipment can be connected to the
    Clamp ConnectivityNode.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The length to the place where the clamp is located starting from side one
            of the line segment, i.e. the line segment terminal with sequence number
            equal to 1.
            '''
        
        })
    '''
    The length to the place where the clamp is located starting from side
    one of the line segment, i.e. the line segment terminal with sequence
    number equal to 1.
    '''
    
    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.Clamp',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The line segment to which the clamp is connected.
            '''
        
        })
    '''
    The line segment to which the clamp is connected.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Conductor(ConductingEquipment):
    '''
    Combination of conducting material with consistent electrical characteristics,
    building a single electrical system, used to carry current between points
    in the power system.
    '''

    length: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Segment length for calculating line section capabilities
            '''
        
        })
    '''
    Segment length for calculating line section capabilities
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ACLineSegment(Conductor):
    '''
    A wire or combination of wires, with consistent electrical characteristics,
    building a single electrical system, used to carry alternating current
    between points in the power system.
    For symmetrical, transposed 3ph lines, it is sufficient to use attributes
    of the line segment, which describe impedances and admittances for the
    entire length of the segment. Additionally impedances can be computed by
    using length and associated per length impedances.
    The BaseVoltage at the two ends of ACLineSegments in a Line shall have
    the same BaseVoltage.nominalVoltage. However, boundary lines may have slightly
    different BaseVoltage.nominalVoltages and variation is allowed. Larger
    voltage difference in general requires use of an equivalent branch.
    '''

    b0ch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance, uniformly distributed, of the
            entire line section.
            '''
        
        })
    '''
    Zero sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line section.
    '''
    
    bch: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance, uniformly distributed,
            of the entire line section. This value represents the full charging over
            the full length of the line.
            '''
        
        })
    '''
    Positive sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line section. This value represents the full charging
    over the full length of the line.
    '''
    
    g0ch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence shunt (charging) conductance, uniformly distributed, of the
            entire line section.
            '''
        
        })
    '''
    Zero sequence shunt (charging) conductance, uniformly distributed,
    of the entire line section.
    '''
    
    gch: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance, uniformly distributed,
            of the entire line section.
            '''
        
        })
    '''
    Positive sequence shunt (charging) conductance, uniformly distributed,
    of the entire line section.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence series resistance of the entire line section.
            '''
        
        })
    '''
    Positive sequence series resistance of the entire line section.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence series resistance of the entire line section.
            '''
        
        })
    '''
    Zero sequence series resistance of the entire line section.
    '''
    
    shortCircuitEndTemperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum permitted temperature at the end of SC for the calculation of minimum
            short-circuit currents. Used for short circuit data exchange according
            to IEC 60909
            '''
        
        })
    '''
    Maximum permitted temperature at the end of SC for the calculation
    of minimum short-circuit currents. Used for short circuit data exchange
    according to IEC 60909
    '''
    
    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence series reactance of the entire line section.
            '''
        
        })
    '''
    Positive sequence series reactance of the entire line section.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence series reactance of the entire line section.
            '''
        
        })
    '''
    Zero sequence series reactance of the entire line section.
    '''
    
    ParallelLineSegment: Optional[ParallelLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ParallelLineSegment.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthImpedance.ACLineSegments',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Per-length impedance of this line segment.
            '''
        
        })
    '''
    Per-length impedance of this line segment.
    '''
    
    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.ACLineSegments',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    ACLineSegmentPhases: list[ACLineSegmentPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ACLineSegmentPhase.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The line segment phases which belong to the line segment.
            '''
        
        })
    '''
    The line segment phases which belong to the line segment.
    '''
    
    Clamp: list[Clamp] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Clamp.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The clamps connected to the line segment.
            '''
        
        })
    '''
    The clamps connected to the line segment.
    '''
    
    Cut: list[Cut] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Cut.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Cuts applied to the line segment.
            '''
        
        })
    '''
    Cuts applied to the line segment.
    '''
    
    LineFaults: list[LineFault] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LineFault.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The line faults of the line segment.
            '''
        
        })
    '''
    The line faults of the line segment.
    '''
    
    ParallelLineSegment: Optional[ParallelLineSegment] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ParallelLineSegment.ACLineSegment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Connector(ConductingEquipment):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation and are
    modelled with a single logical terminal.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BusbarSection(Connector):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation.
    Voltage measurements are typically obtained from VoltageTransformers that
    are connected to busbar sections. A bus bar section may have many physical
    terminals but for analysis is modelled with exactly one logical terminal.
    '''

    ipMax: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum allowable peak short-circuit current of busbar (Ipmax in the IEC
            60909-0).
            Mechanical limit of the busbar in the substation itself. Used for short
            circuit data exchange according to IEC 60909
            '''
        
        })
    '''
    Maximum allowable peak short-circuit current of busbar (Ipmax in the
    IEC 60909-0).
    Mechanical limit of the busbar in the substation itself. Used for short
    circuit data exchange according to IEC 60909
    '''
    
    VoltageControlZone: Optional[VoltageControlZone] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VoltageControlZone.BusbarSection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A VoltageControlZone is controlled by a designated BusbarSection.
            '''
        
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''
    
    VoltageControlZone: Optional[VoltageControlZone] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'VoltageControlZone.BusbarSection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A VoltageControlZone is controlled by a designated BusbarSection.
            '''
        
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Junction(Connector):
    '''
    A point where one or more conducting equipments are connected with zero
    resistance.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EarthFaultCompensator(ConductingEquipment):
    '''
    A conducting equipment used to represent a connection to ground which is
    typically used to compensate earth faults.. An earth fault compensator
    device modeled with a single terminal implies a second terminal solidly
    connected to ground. If two terminals are modeled, the ground is not assumed
    and normal connection rules apply.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Nominal resistance of device.
            '''
        
        })
    '''
    Nominal resistance of device.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GroundingImpedance(EarthFaultCompensator):
    '''
    A fixed impedance device used for grounding.
    '''

    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reactance of device.
            '''
        
        })
    '''
    Reactance of device.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PetersenCoil(EarthFaultCompensator):
    '''
    A tunable impedance device normally used to offset line charging during
    single line faults in an ungrounded section of network.
    '''

    mode: Optional[ PetersenCoilModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The mode of operation of the Petersen coil.
            '''
        
        })
    '''
    The mode of operation of the Petersen coil.
    '''
    
    nominalU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The nominal voltage for which the coil is designed.
            '''
        
        })
    '''
    The nominal voltage for which the coil is designed.
    '''
    
    offsetCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The offset current that the Petersen coil controller is operating from
            the resonant point. This is normally a fixed amount for which the controller
            is configured and could be positive or negative. Typically 0 to 60 Amperes
            depending on voltage and resonance conditions.
            '''
        
        })
    '''
    The offset current that the Petersen coil controller is operating from
    the resonant point. This is normally a fixed amount for which the controller
    is configured and could be positive or negative. Typically 0 to 60
    Amperes depending on voltage and resonance conditions.
    '''
    
    positionCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The control current used to control the Petersen coil also known as the
            position current. Typically in the range of 20-200mA.
            '''
        
        })
    '''
    The control current used to control the Petersen coil also known as
    the position current. Typically in the range of 20-200mA.
    '''
    
    xGroundMax: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum reactance.
            '''
        
        })
    '''
    The maximum reactance.
    '''
    
    xGroundMin: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The minimum reactance.
            '''
        
        })
    '''
    The minimum reactance.
    '''
    
    xGroundNominal: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The nominal reactance. This is the operating point (normally over compensation)
            that is defined based on the resonance point in the healthy network condition.
            The impedance is calculated based on nominal voltage divided by position
            current.
            '''
        
        })
    '''
    The nominal reactance. This is the operating point (normally over compensation)
    that is defined based on the resonance point in the healthy network
    condition. The impedance is calculated based on nominal voltage divided
    by position current.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class EnergyConnection(ConductingEquipment):
    '''
    '''

    EnergyConnectionProfile: Optional[EnergyConnectionProfile] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'EnergyConnectionProfile.EnergyConnections',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class EnergyConsumer(EnergyConnection):
    '''
    Generic user of energy - a point of consumption on the power system model.
    '''

    customerCount: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Number of individual customers represented by this demand.
            '''
        
        })
    '''
    Number of individual customers represented by this demand.
    '''
    
    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Used for Yn and Zn connections. True if the neutral is solidly grounded.
            '''
        
        })
    '''
    Used for Yn and Zn connections. True if the neutral is solidly grounded.
    '''
    
    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Active power of the load. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Active power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''
    
    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The type of phase connection, such as wye or delta.
            '''
        
        })
    '''
    The type of phase connection, such as wye or delta.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reactive power of the load. Load sign convention is used, i.e. positive
            sign means flow out from a node.
            For voltage dependent loads the value is at rated voltage.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Reactive power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''
    
    House: Optional[House] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'House.EnergyConsumer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    LoadResponse: Optional[LoadResponseCharacteristic] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'LoadResponseCharacteristic.EnergyConsumer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The load response characteristic of this load. If missing, this load is
            assumed to be constant power.
            '''
        
        })
    '''
    The load response characteristic of this load. If missing, this load
    is assumed to be constant power.
    '''
    
    PowerCutZone: Optional[PowerCutZone] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerCutZone.EnergyConsumers',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The energy consumer is assigned to this power cut zone.
            '''
        
        })
    '''
    The energy consumer is assigned to this power cut zone.
    '''
    
    EnergyConsumerPhase: list[EnergyConsumerPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumerPhase.EnergyConsumer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The individual phase models for this energy consumer.
            '''
        
        })
    '''
    The individual phase models for this energy consumer.
    '''
    
    House: Optional[House] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'House.EnergyConsumer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ConformLoad(EnergyConsumer):
    '''
    ConformLoad represent loads that follow a daily load change pattern where
    the pattern can be used to scale the load with a system load.
    '''

    LoadGroup: Optional[ConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConformLoadGroup.EnergyConsumers',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Group of this ConformLoad.
            '''
        
        })
    '''
    Group of this ConformLoad.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class NonConformLoad(EnergyConsumer):
    '''
    NonConformLoad represent loads that do not follow a daily load change pattern
    and changes are not correlated with the daily load change pattern.
    '''

    LoadGroup: Optional[NonConformLoadGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NonConformLoadGroup.EnergyConsumers',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Group of this ConformLoad.
            '''
        
        })
    '''
    Group of this ConformLoad.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StationSupply(EnergyConsumer):
    '''
    Station supply with load derived from the station output.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class EnergySource(EnergyConnection):
    '''
    A generic equivalent for an energy supplier on a transmission or distribution
    voltage level.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase-to-phase nominal voltage.
            '''
        
        })
    '''
    Phase-to-phase nominal voltage.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence Thevenin resistance.
            '''
        
        })
    '''
    Positive sequence Thevenin resistance.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence Thevenin resistance.
            '''
        
        })
    '''
    Zero sequence Thevenin resistance.
    '''
    
    voltageAngle: Optional[ float | AngleRadians ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase angle of a-phase open circuit.
            '''
        
        })
    '''
    Phase angle of a-phase open circuit.
    '''
    
    voltageMagnitude: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase-to-phase open circuit voltage magnitude.
            '''
        
        })
    '''
    Phase-to-phase open circuit voltage magnitude.
    '''
    
    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence Thevenin reactance.
            '''
        
        })
    '''
    Positive sequence Thevenin reactance.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence Thevenin reactance.
            '''
        
        })
    '''
    Zero sequence Thevenin reactance.
    '''
    
    EnergySourcePhase: list[EnergySourcePhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergySourcePhase.EnergySource',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The individual phase information of the energy source.
            '''
        
        })
    '''
    The individual phase information of the energy source.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RegulatingCondEq(EnergyConnection):
    '''
    A type of conducting equipment that can regulate a quantity (i.e. voltage
    or flow) at a specific point in the network.
    '''

    controlEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Specifies the regulation status of the equipment. True is regulating, false
            is not regulating.
            '''
        
        })
    '''
    Specifies the regulation status of the equipment. True is regulating,
    false is not regulating.
    '''
    
    RegulatingControl: Optional[RegulatingControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegulatingControl.RegulatingCondEq',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The regulating control scheme in which this equipment participates.
            '''
        
        })
    '''
    The regulating control scheme in which this equipment participates.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ExternalNetworkInjection(RegulatingCondEq):
    '''
    This class represents external network and it is used for IEC 60909 calculations.
    '''

    ikSecond: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Indicates whether initial symmetrical short-circuit current and power have
            been calculated according to IEC (Ik").
            '''
        
        })
    '''
    Indicates whether initial symmetrical short-circuit current and power
    have been calculated according to IEC (Ik").
    '''
    
    maxR0ToX0Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum ratio of zero sequence resistance of Network Feeder to its zero
            sequence reactance (R(0)/X(0) max). Used for short circuit data exchange
            according to IEC 60909
            '''
        
        })
    '''
    Maximum ratio of zero sequence resistance of Network Feeder to its
    zero sequence reactance (R(0)/X(0) max). Used for short circuit data
    exchange according to IEC 60909
    '''
    
    maxR1ToX1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum ratio of positive sequence resistance of Network Feeder to its
            positive sequence reactance (R(1)/X(1) max). Used for short circuit data
            exchange according to IEC 60909
            '''
        
        })
    '''
    Maximum ratio of positive sequence resistance of Network Feeder to
    its positive sequence reactance (R(1)/X(1) max). Used for short circuit
    data exchange according to IEC 60909
    '''
    
    maxZ0ToZ1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum ratio of zero sequence impedance to its positive sequence impedance
            (Z(0)/Z(1) max). Used for short circuit data exchange according to IEC
            60909
            '''
        
        })
    '''
    Maximum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) max). Used for short circuit data exchange according to
    IEC 60909
    '''
    
    minR0ToX0Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Indicates whether initial symmetrical short-circuit current and power have
            been calculated according to IEC (Ik"). Used for short circuit data exchange
            according to IEC 6090
            '''
        
        })
    '''
    Indicates whether initial symmetrical short-circuit current and power
    have been calculated according to IEC (Ik"). Used for short circuit
    data exchange according to IEC 6090
    '''
    
    minR1ToX1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Minimum ratio of positive sequence resistance of Network Feeder to its
            positive sequence reactance (R(1)/X(1) min). Used for short circuit data
            exchange according to IEC 60909
            '''
        
        })
    '''
    Minimum ratio of positive sequence resistance of Network Feeder to
    its positive sequence reactance (R(1)/X(1) min). Used for short circuit
    data exchange according to IEC 60909
    '''
    
    minZ0ToZ1Ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Minimum ratio of zero sequence impedance to its positive sequence impedance
            (Z(0)/Z(1) min). Used for short circuit data exchange according to IEC
            60909
            '''
        
        })
    '''
    Minimum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) min). Used for short circuit data exchange according to
    IEC 60909
    '''
    
    referencePriority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Priority of unit for use as powerflow voltage phase angle reference bus
            selection. 0 = don t care (default) 1 = highest priority. 2 is less than
            1 and so on.
            '''
        
        })
    '''
    Priority of unit for use as powerflow voltage phase angle reference
    bus selection. 0 = don t care (default) 1 = highest priority. 2 is
    less than 1 and so on.
    '''
    
    governorSCD: Optional[ float | ActivePowerPerFrequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Power Frequency Bias. This is the change in power injection divided by
            the change in frequency and negated. A positive value of the power frequency
            bias provides additional power injection upon a drop in frequency.
            '''
        
        })
    '''
    Power Frequency Bias. This is the change in power injection divided
    by the change in frequency and negated. A positive value of the power
    frequency bias provides additional power injection upon a drop in frequency.
    '''
    
    maxInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum initial symmetrical short-circuit currents (Ik" max) in A (Ik"
            = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according to
            IEC 60909
            '''
        
        })
    '''
    Maximum initial symmetrical short-circuit currents (Ik" max) in A (Ik"
    = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according
    to IEC 60909
    '''
    
    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum active power of the injection.
            '''
        
        })
    '''
    Maximum active power of the injection.
    '''
    
    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Not for short circuit modelling; It is used for modelling of infeed for
            load flow exchange. If maxQ and minQ are not used ReactiveCapabilityCurve
            can be used
            '''
        
        })
    '''
    Not for short circuit modelling; It is used for modelling of infeed
    for load flow exchange. If maxQ and minQ are not used ReactiveCapabilityCurve
    can be used
    '''
    
    minInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Minimum initial symmetrical short-circuit currents (Ik" min) in A (Ik"
            = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according to
            IEC 60909
            '''
        
        })
    '''
    Minimum initial symmetrical short-circuit currents (Ik" min) in A (Ik"
    = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according
    to IEC 60909
    '''
    
    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Minimum active power of the injection.
            '''
        
        })
    '''
    Minimum active power of the injection.
    '''
    
    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Not for short circuit modelling; It is used for modelling of infeed for
            load flow exchange. If maxQ and minQ are not used ReactiveCapabilityCurve
            can be used
            '''
        
        })
    '''
    Not for short circuit modelling; It is used for modelling of infeed
    for load flow exchange. If maxQ and minQ are not used ReactiveCapabilityCurve
    can be used
    '''
    
    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for steady state solutions.
            '''
        
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for steady state solutions.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for steady state solutions.
            '''
        
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for steady state solutions.
    '''
    
    voltageFactor: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Voltage factor in pu, which was used to calculate short-circuit current
            Ik" and power Sk".
            '''
        
        })
    '''
    Voltage factor in pu, which was used to calculate short-circuit current
    Ik" and power Sk".
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FrequencyConverter(RegulatingCondEq):
    '''
    A device to convert from one frequency to another (e.g., frequency F1 to
    F2) comprises a pair of FrequencyConverter instances. One converts from
    F1 to DC, the other converts the DC to F2.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Frequency on the AC side.
            '''
        
        })
    '''
    Frequency on the AC side.
    '''
    
    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum active power on the DC side at which the frequence converter
            should operate.
            '''
        
        })
    '''
    The maximum active power on the DC side at which the frequence converter
    should operate.
    '''
    
    maxU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum voltage on the DC side at which the frequency converter should
            operate.
            '''
        
        })
    '''
    The maximum voltage on the DC side at which the frequency converter
    should operate.
    '''
    
    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The minimum active power on the DC side at which the frequence converter
            should operate.
            '''
        
        })
    '''
    The minimum active power on the DC side at which the frequence converter
    should operate.
    '''
    
    minU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The minimum voltage on the DC side at which the frequency converter should
            operate.
            '''
        
        })
    '''
    The minimum voltage on the DC side at which the frequency converter
    should operate.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerElectronicsConnection(RegulatingCondEq):
    '''
    A connection to the AC network for energy production or consumption that
    uses power electronics rather than rotating machines.
    '''

    controlMode: Optional[ ConverterControlModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    maxIFault: Optional[ float | PU ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum fault current this device will contribute, in per-unit of rated
            current, before the converter protection will trip or bypass.
            '''
        
        })
    '''
    Maximum fault current this device will contribute, in per-unit of rated
    current, before the converter protection will trip or bypass.
    '''
    
    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum reactive power limit. This is the maximum (nameplate) limit for
            the unit.
            '''
        
        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit
    for the unit.
    '''
    
    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Minimum reactive power limit for the unit. This is the minimum (nameplate)
            limit for the unit.
            '''
        
        })
    '''
    Minimum reactive power limit for the unit. This is the minimum (nameplate)
    limit for the unit.
    '''
    
    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''
    
    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Nameplate apparent power rating for the unit.
            The attribute shall have a positive value.
            '''
        
        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''
    
    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
            for short circuit data exchange according to IEC 60909.
            '''
        
        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily
    used for short circuit data exchange according to IEC 60909.
    '''
    
    DERDynamics: Optional[DERDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DERDynamics.PowerElectronicsConnection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            DER dynamics model associated with this power electronics connection model.
            '''
        
        })
    '''
    DER dynamics model associated with this power electronics connection
    model.
    '''
    
    IEEE1547ControlSettings: Optional[IEEE1547ControlSettings] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IEEE1547ControlSettings.PowerElectronicsConnections',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    IEEE1547Info: Optional[IEEE1547Info] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IEEE1547Info.PowerElectronicsConnections',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    IEEE1547Setting: Optional[IEEE1547Setting] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IEEE1547Setting.PowerElectronicsConnections',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    IEEE1547TripSettings: Optional[IEEE1547TripSettings] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IEEE1547TripSettings.PowerElectronicsConnections',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PowerElectronicsConnectionPhases: list[PowerElectronicsConnectionPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsConnectionPhase.PowerElectronicsConnection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    PowerElectronicsUnit: list[PowerElectronicsUnit] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerElectronicsUnit.PowerElectronicsConnection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RotatingMachine(RegulatingCondEq):
    '''
    A rotating machine which may be used as a generator or motor.
    '''

    ratedPowerFactor: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Power factor (nameplate data). It is primarily used for short circuit data
            exchange according to IEC 60909.
            '''
        
        })
    '''
    Power factor (nameplate data). It is primarily used for short circuit
    data exchange according to IEC 60909.
    '''
    
    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''
    
    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Nameplate apparent power rating for the unit.
            The attribute shall have a positive value.
            '''
        
        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''
    
    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
            for short circuit data exchange according to IEC 60909.
            '''
        
        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily
    used for short circuit data exchange according to IEC 60909.
    '''
    
    GeneratingUnit: Optional[GeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeneratingUnit.RotatingMachine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A synchronous machine may operate as a generator and as such becomes a
            member of a generating unit.
            '''
        
        })
    '''
    A synchronous machine may operate as a generator and as such becomes
    a member of a generating unit.
    '''
    
    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.RotatingMachine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''
        
        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''
    
    IEEE1547ControlSettings: Optional[IEEE1547ControlSettings] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IEEE1547ControlSettings.RotatingMachines',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    IEEE1547Info: Optional[IEEE1547Info] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IEEE1547Info.RotatingMachines',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    IEEE1547Setting: Optional[IEEE1547Setting] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IEEE1547Setting.RotatingMachines',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    IEEE1547TripSettings: Optional[IEEE1547TripSettings] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IEEE1547TripSettings.RotatingMachines',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    HydroPump: Optional[HydroPump] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPump.RotatingMachine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''
        
        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class AsynchronousMachine(RotatingMachine):
    '''
    A rotating machine whose shaft rotates asynchronously with the electrical
    field. Also known as an induction machine with no external connection to
    the rotor windings, e.g squirrel-cage induction machine.
    '''

    converterFedDrive: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Indicates whether the machine is a converter fed drive. Used for short
            circuit data exchange according to IEC 60909
            '''
        
        })
    '''
    Indicates whether the machine is a converter fed drive. Used for short
    circuit data exchange according to IEC 60909
    '''
    
    iaIrRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Ratio of locked-rotor current to the rated current of the motor (Ia/Ir).
            Used for short circuit data exchange according to IEC 60909
            '''
        
        })
    '''
    Ratio of locked-rotor current to the rated current of the motor (Ia/Ir).
    Used for short circuit data exchange according to IEC 60909
    '''
    
    polePairNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Number of pole pairs of stator. Used for short circuit data exchange according
            to IEC 60909
            '''
        
        })
    '''
    Number of pole pairs of stator. Used for short circuit data exchange
    according to IEC 60909
    '''
    
    reversible: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Indicates for converter drive motors if the power can be reversible. Used
            for short circuit data exchange according to IEC 60909
            '''
        
        })
    '''
    Indicates for converter drive motors if the power can be reversible.
    Used for short circuit data exchange according to IEC 60909
    '''
    
    rxLockedRotorRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Locked rotor ratio (R/X). Used for short circuit data exchange according
            to IEC 60909
            '''
        
        })
    '''
    Locked rotor ratio (R/X). Used for short circuit data exchange according
    to IEC 60909
    '''
    
    asynchronousMachineType: Optional[ AsynchronousMachineKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Indicates the type of Asynchronous Machine (motor or generator).
            '''
        
        })
    '''
    Indicates the type of Asynchronous Machine (motor or generator).
    '''
    
    efficiency: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Efficiency of the asynchronous machine at nominal operation in percent.
            Indicator for converter drive motors. Used for short circuit data exchange
            according to IEC 60909
            '''
        
        })
    '''
    Efficiency of the asynchronous machine at nominal operation in percent.
    Indicator for converter drive motors. Used for short circuit data exchange
    according to IEC 60909
    '''
    
    nominalFrequency: Optional[ float | Frequency ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Nameplate data indicates if the machine is 50 or 60 Hz.
            '''
        
        })
    '''
    Nameplate data indicates if the machine is 50 or 60 Hz.
    '''
    
    nominalSpeed: Optional[ float | RotationSpeed ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Nameplate data. Depends on the slip and number of pole pairs.
            '''
        
        })
    '''
    Nameplate data. Depends on the slip and number of pole pairs.
    '''
    
    ratedMechanicalPower: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated mechanical power (Pr in the IEC 60909-0). Used for short circuit
            data exchange according to IEC 60909.
            '''
        
        })
    '''
    Rated mechanical power (Pr in the IEC 60909-0). Used for short circuit
    data exchange according to IEC 60909.
    '''
    
    DERDynamics: Optional[DERDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DERDynamics.AsynchronousMachine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            DER dynamics model associated with this asynchronous machine model.
            '''
        
        })
    '''
    DER dynamics model associated with this asynchronous machine model.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class SynchronousMachine(RotatingMachine):
    '''
    An electromechanical device that operates with shaft rotating synchronously
    with the network. It is a single machine operating either as a generator
    or synchronous condenser or pump.
    '''

    ikk: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Steady-state short-circuit current (in A for the profile) of generator
            with compound excitation during 3-phase short circuit.
            - Ikk=0: Generator with no compound excitation.
            - Ikk?0: Generator with compound excitation.
            Ikk is used to calculate the minimum steady-state short-circuit current
            for generators with compound excitation
            (Section 4.6.1.2 in the IEC 60909-0)
            Used only for single fed short circuit on a generator. (Section 4.3.4.2.
            in the IEC 60909-0)
            '''
        
        })
    '''
    Steady-state short-circuit current (in A for the profile) of generator
    with compound excitation during 3-phase short circuit.
    - Ikk=0: Generator with no compound excitation.
    - Ikk?0: Generator with compound excitation.
    Ikk is used to calculate the minimum steady-state short-circuit current
    for generators with compound excitation
    (Section 4.6.1.2 in the IEC 60909-0)
    Used only for single fed short circuit on a generator. (Section 4.3.4.2.
    in the IEC 60909-0)
    '''
    
    maxQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum reactive power limit. This is the maximum (nameplate) limit for
            the unit.
            '''
        
        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit
    for the unit.
    '''
    
    minQ: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Minimum reactive power limit for the unit.
            '''
        
        })
    '''
    Minimum reactive power limit for the unit.
    '''
    
    operatingMode: Optional[ SynchronousMachineOperatingMode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Current mode of operation.
            '''
        
        })
    '''
    Current mode of operation.
    '''
    
    type: Optional[ SynchronousMachineKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Modes that this synchronous machine can operate in.
            '''
        
        })
    '''
    Modes that this synchronous machine can operate in.
    '''
    
    DERDynamics: Optional[DERDynamics] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DERDynamics.SynchronousMachine',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            DER dynamics model associated with this synchronous machine model.
            '''
        
        })
    '''
    DER dynamics model associated with this synchronous machine model.
    '''
    
    InitialReactiveCapabilityCurve: Optional[ReactiveCapabilityCurve] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReactiveCapabilityCurve.InitiallyUsedBySynchronousMachines',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The default reactive capability curve for use by a synchronous machine.
            '''
        
        })
    '''
    The default reactive capability curve for use by a synchronous machine.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ShuntCompensator(RegulatingCondEq):
    '''
    A shunt capacitor or reactor or switchable bank of shunt capacitors or
    reactors. A section of a shunt compensator is an individual capacitor or
    reactor. A negative value for reactivePerSection indicates that the compensator
    is a reactor. ShuntCompensator is a single terminal device. Ground is implied.
    '''

    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Used for Yn and Zn connections. True if the neutral is solidly grounded.
            '''
        
        })
    '''
    Used for Yn and Zn connections. True if the neutral is solidly grounded.
    '''
    
    maximumSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum number of sections that may be switched in.
            '''
        
        })
    '''
    The maximum number of sections that may be switched in.
    '''
    
    normalSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The normal number of sections switched in.
            '''
        
        })
    '''
    The normal number of sections switched in.
    '''
    
    sections: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Shunt compensator sections in use.
            Starting value for steady state solution. Non integer values are allowed
            to support continuous variables. The reasons for continuous value are to
            support study cases where no discrete shunt compensators has yet been designed,
            a solutions where a narrow voltage band force the sections to oscillate
            or accommodate for a continuous solution as input.
            '''
        
        })
    '''
    Shunt compensator sections in use.
    Starting value for steady state solution. Non integer values are allowed
    to support continuous variables. The reasons for continuous value are
    to support study cases where no discrete shunt compensators has yet
    been designed, a solutions where a narrow voltage band force the sections
    to oscillate or accommodate for a continuous solution as input.
    '''
    
    aVRDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Time delay required for the device to be connected or disconnected by automatic
            voltage regulation (AVR).
            '''
        
        })
    '''
    Time delay required for the device to be connected or disconnected
    by automatic voltage regulation (AVR).
    '''
    
    nomU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The voltage at which the nominal reactive power may be calculated. This
            should normally be within 10% of the voltage at which the capacitor is
            connected to the network.
            '''
        
        })
    '''
    The voltage at which the nominal reactive power may be calculated.
    This should normally be within 10% of the voltage at which the capacitor
    is connected to the network.
    '''
    
    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The type of phase connection, such as wye or delta.
            '''
        
        })
    '''
    The type of phase connection, such as wye or delta.
    '''
    
    SvShuntCompensatorSections: Optional[SvShuntCompensatorSections] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SvShuntCompensatorSections.ShuntCompensator',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The state for the number of shunt compensator sections in service.
            '''
        
        })
    '''
    The state for the number of shunt compensator sections in service.
    '''
    
    ShuntCompensatorPhase: list[ShuntCompensatorPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ShuntCompensatorPhase.ShuntCompensator',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The individual phases models for the shunt compensator.
            '''
        
        })
    '''
    The individual phases models for the shunt compensator.
    '''
    
    SvShuntCompensatorSections: Optional[SvShuntCompensatorSections] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SvShuntCompensatorSections.ShuntCompensator',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The state for the number of shunt compensator sections in service.
            '''
        
        })
    '''
    The state for the number of shunt compensator sections in service.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class LinearShuntCompensator(ShuntCompensator):
    '''
    A linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    b0PerSection: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance per section
            '''
        
        })
    '''
    Zero sequence shunt (charging) susceptance per section
    '''
    
    bPerSection: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance per section
            '''
        
        })
    '''
    Positive sequence shunt (charging) susceptance per section
    '''
    
    g0PerSection: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence shunt (charging) conductance per section
            '''
        
        })
    '''
    Zero sequence shunt (charging) conductance per section
    '''
    
    gPerSection: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance per section
            '''
        
        })
    '''
    Positive sequence shunt (charging) conductance per section
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class NonlinearShuntCompensator(ShuntCompensator):
    '''
    A non linear shunt compensator has bank or section admittance values that
    differs.
    '''

    NonlinearShuntCompensatorPoints: list[NonlinearShuntCompensatorPoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonlinearShuntCompensatorPoint.NonlinearShuntCompensator',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All points of the non-linear shunt compensator.
            '''
        
        })
    '''
    All points of the non-linear shunt compensator.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StaticVarCompensator(RegulatingCondEq):
    '''
    A facility for providing variable and controllable shunt reactive power.
    The SVC typically consists of a stepdown transformer, filter, thyristor-controlled
    reactor, and thyristor-switched capacitor arms.
    The SVC may operate in fixed MVar output mode or in voltage control mode.
    When in voltage control mode, the output of the SVC will be proportional
    to the deviation of voltage at the controlled bus from the voltage setpoint.
    The SVC characteristic slope defines the proportion. If the voltage at
    the controlled bus is equal to the voltage setpoint, the SVC MVar output
    is zero.
    '''

    capacitiveRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum available capacitive reactance.
            '''
        
        })
    '''
    Maximum available capacitive reactance.
    '''
    
    inductiveRating: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum available inductive reactance.
            '''
        
        })
    '''
    Maximum available inductive reactance.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow out from a node.
            Starting value for a steady state solution.
            '''
        
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    Starting value for a steady state solution.
    '''
    
    slope: Optional[ float | VoltagePerReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The characteristics slope of an SVC defines how the reactive power output
            changes in proportion to the difference between the regulated bus voltage
            and the voltage setpoint.
            '''
        
        })
    '''
    The characteristics slope of an SVC defines how the reactive power
    output changes in proportion to the difference between the regulated
    bus voltage and the voltage setpoint.
    '''
    
    sVCControlMode: Optional[ SVCControlMode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            SVC control mode.
            '''
        
        })
    '''
    SVC control mode.
    '''
    
    voltageSetPoint: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reactive power output of the SVC is proportional to the difference
            between the voltage at the regulated bus and the voltage setpoint. When
            the regulated bus voltage is equal to the voltage setpoint, the reactive
            power output is zero.
            '''
        
        })
    '''
    The reactive power output of the SVC is proportional to the difference
    between the voltage at the regulated bus and the voltage setpoint.
    When the regulated bus voltage is equal to the voltage setpoint, the
    reactive power output is zero.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Ground(ConductingEquipment):
    '''
    A point where the system is grounded used for connecting conducting equipment
    to ground. The power system model can have any number of grounds.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerTransformer(ConductingEquipment):
    '''
    An electrical device consisting of two or more coupled windings, with or
    without a magnetic core, for introducing mutual coupling between electric
    circuits. Transformers can be used to control voltage and phase shift (active
    power flow).
    A power transformer may be composed of separate transformer tanks that
    need not be identical.
    A power transformer can be modeled with or without tanks and is intended
    for use in both balanced and unbalanced representations. A power transformer
    typically has two terminals, but may have one (grounding), three or more
    terminals.
    The inherited association ConductingEquipment.BaseVoltage should not be
    used. The association from TransformerEnd to BaseVoltage should be used
    instead.
    '''

    vectorGroup: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Vector group of the transformer for protective relaying, e.g., Dyn1. For
            unbalanced transformers, this may not be simply determined from the constituent
            winding connections and phase angle dispacements.
            The vectorGroup string consists of the following components in the order
            listed: high voltage winding connection, mid voltage winding connection
            (for three winding transformers), phase displacement clock number from
            0 to 11, low voltage winding connection
            phase displacement clock number from 0 to 11. The winding connections are
            D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag with
            neutral), A (auto transformer). Upper case means the high voltage, lower
            case mid or low. The high voltage winding always has clock postion 0 and
            is not included in the vector group string. Some examples: YNy0 (two winding
            wye to wye with no phase displacement), YNd11 (two winding wye to delta
            with 330 degrees phase displacement), YNyn0d5 (three winding transformer
            wye with neutral high voltgage, wye with neutral mid voltgage and no phase
            displacement, delta low voltage with 150 degrees displacement).
            Phase displacement is defined as the angular difference between the phasors
            representing the voltages between the neutral point (real or imaginary)
            and the corresponding terminals of two windings, a positive sequence voltage
            system being applied to the high-voltage terminals, following each other
            in alphabetical sequence if they are lettered, or in numerical sequence
            if they are numbered: the phasors are assumed to rotate in a counter-clockwise
            sense.
            '''
        
        })
    '''
    Vector group of the transformer for protective relaying, e.g., Dyn1.
    For unbalanced transformers, this may not be simply determined from
    the constituent winding connections and phase angle dispacements.
    The vectorGroup string consists of the following components in the
    order listed: high voltage winding connection, mid voltage winding
    connection (for three winding transformers), phase displacement clock
    number from 0 to 11, low voltage winding connection
    phase displacement clock number from 0 to 11. The winding connections
    are D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag
    with neutral), A (auto transformer). Upper case means the high voltage,
    lower case mid or low. The high voltage winding always has clock postion
    0 and is not included in the vector group string. Some examples: YNy0
    (two winding wye to wye with no phase displacement), YNd11 (two winding
    wye to delta with 330 degrees phase displacement), YNyn0d5 (three winding
    transformer wye with neutral high voltgage, wye with neutral mid voltgage
    and no phase displacement, delta low voltage with 150 degrees displacement).
    Phase displacement is defined as the angular difference between the
    phasors representing the voltages between the neutral point (real or
    imaginary) and the corresponding terminals of two windings, a positive
    sequence voltage system being applied to the high-voltage terminals,
    following each other in alphabetical sequence if they are lettered,
    or in numerical sequence if they are numbered: the phasors are assumed
    to rotate in a counter-clockwise sense.
    '''
    
    PowerTransformerEnd: list[PowerTransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'PowerTransformerEnd.PowerTransformer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The ends of this power transformer.
            '''
        
        })
    '''
    The ends of this power transformer.
    '''
    
    TransformerTanks: list[TransformerTank] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTank.PowerTransformer',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All transformers that belong to this bank.
            '''
        
        })
    '''
    All transformers that belong to this bank.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class SeriesCompensator(ConductingEquipment):
    '''
    A Series Compensator is a series capacitor or reactor or an AC transmission
    line without charging susceptance. It is a two terminal device.
    '''

    varistorPresent: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Describe if a metal oxide varistor (mov) for over voltage protection is
            configured at the series compensator.
            '''
        
        })
    '''
    Describe if a metal oxide varistor (mov) for over voltage protection
    is configured at the series compensator.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence resistance.
            '''
        
        })
    '''
    Positive sequence resistance.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence resistance.
            '''
        
        })
    '''
    Zero sequence resistance.
    '''
    
    varistorRatedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum current the varistor is designed to handle at specified duration.
            '''
        
        })
    '''
    The maximum current the varistor is designed to handle at specified
    duration.
    '''
    
    varistorVoltageThreshold: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The dc voltage at which the varistor start conducting.
            '''
        
        })
    '''
    The dc voltage at which the varistor start conducting.
    '''
    
    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence reactance.
            '''
        
        })
    '''
    Positive sequence reactance.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence reactance.
            '''
        
        })
    '''
    Zero sequence reactance.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Switch(ConductingEquipment):
    '''
    A generic device designed to close, or open, or both, one or more electric
    circuits. All switches are two terminal devices including grounding switches.
    '''

    normalOpen: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The attribute is used in cases when no Measurement for the status value
            is present. If the Switch has a status measurement the Discrete.normalValue
            is expected to match with the Switch.normalOpen.
            '''
        
        })
    '''
    The attribute is used in cases when no Measurement for the status value
    is present. If the Switch has a status measurement the Discrete.normalValue
    is expected to match with the Switch.normalOpen.
    '''
    
    open: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The attribute tells if the switch is considered open when used as input
            to topology processing.
            '''
        
        })
    '''
    The attribute tells if the switch is considered open when used as input
    to topology processing.
    '''
    
    retained: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Branch is retained in a bus branch model. The flow through retained switches
            will normally be calculated in power flow.
            '''
        
        })
    '''
    Branch is retained in a bus branch model. The flow through retained
    switches will normally be calculated in power flow.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum continuous current carrying capacity in amps governed by the
            device material and construction.
            '''
        
        })
    '''
    The maximum continuous current carrying capacity in amps governed by
    the device material and construction.
    '''
    
    CompositeSwitch: Optional[CompositeSwitch] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CompositeSwitch.Switches',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Composite switch to which this Switch belongs.
            '''
        
        })
    '''
    Composite switch to which this Switch belongs.
    '''
    
    SvSwitch: list[SvSwitch] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvSwitch.Switch',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The switch state associated with the switch.
            '''
        
        })
    '''
    The switch state associated with the switch.
    '''
    
    SwitchPhase: list[SwitchPhase] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SwitchPhase.Switch',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The individual switch phases for the switch.
            '''
        
        })
    '''
    The individual switch phases for the switch.
    '''
    
    SwitchSchedules: list[SwitchSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SwitchSchedule.Switch',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A Switch can be associated with SwitchSchedules.
            '''
        
        })
    '''
    A Switch can be associated with SwitchSchedules.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Cut(Switch):
    '''
    A cut separates a line segment into two parts. The cut appears as a switch
    inserted between these two parts and connects them together. As the cut
    is normally open there is no galvanic connection between the two line segment
    parts. But it is possible to close the cut to get galvanic connection.
    The cut terminals are oriented towards the line segment terminals with
    the same sequence number. Hence the cut terminal with sequence number equal
    to 1 is oriented to the line segment's terminal with sequence number equal
    to 1.
    The cut terminals also act as connection points for jumpers and other equipment,
    e.g. a mobile generator. To enable this, connectivity nodes are placed
    at the cut terminals. Once the connectivity nodes are in place any conducting
    equipment can be connected at them.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The length to the place where the cut is located starting from side one
            of the cut line segment, i.e. the line segment Terminal with sequenceNumber
            equal to 1.
            '''
        
        })
    '''
    The length to the place where the cut is located starting from side
    one of the cut line segment, i.e. the line segment Terminal with sequenceNumber
    equal to 1.
    '''
    
    ACLineSegment: Optional[ACLineSegment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ACLineSegment.Cut',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The line segment to which the cut is applied.
            '''
        
        })
    '''
    The line segment to which the cut is applied.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Disconnector(Switch):
    '''
    A manually operated or motor operated mechanical switching device used
    for changing the connections in a circuit, or for isolating a circuit or
    equipment from a source of power. It is required to open or close circuits
    when negligible current is broken or made.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Fuse(Switch):
    '''
    An overcurrent protective device with a circuit opening fusible part that
    is heated and severed by the passage of overcurrent through it. A fuse
    is considered a switching device because it breaks current.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class GroundDisconnector(Switch):
    '''
    A manually operated or motor operated mechanical switching device used
    for isolating a circuit or equipment from ground.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Jumper(Switch):
    '''
    A short section of conductor with negligible impedance which can be manually
    removed and replaced if the circuit is de-energized. Note that zero-impedance
    branches can potentially be modeled by other equipment types.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ProtectedSwitch(Switch):
    '''
    A ProtectedSwitch is a switching device that can be operated by ProtectionEquipment.
    '''

    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum fault current a breaking device can break safely under prescribed
            conditions of use.
            '''
        
        })
    '''
    The maximum fault current a breaking device can break safely under
    prescribed conditions of use.
    '''
    
    ProtectionRelayFunction: list[ProtectionFunctionBlock] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProtectionFunctionBlock.ProtectedSwitch',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Breaker(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal circuit conditions and also making, carrying for
    a specified time, and breaking currents under specified abnormal circuit
    conditions e.g. those of short circuit.
    '''

    inTransitTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The transition time from open to close.
            '''
        
        })
    '''
    The transition time from open to close.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class LoadBreakSwitch(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal operating conditions.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Recloser(ProtectedSwitch):
    '''
    Pole-mounted fault interrupter with built-in phase and ground relays, current
    transformer (CT), and supplemental controls.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class Sectionaliser(Switch):
    '''
    Automatic switch that will lock open to isolate a faulted section. It may,
    or may not, have load breaking capability. Its primary purpose is to provide
    fault sectionalising at locations where the fault current is either too
    high, or too low, for proper coordination of fuses.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class GeneratingUnit(Equipment):
    '''
    A single or set of synchronous machines for converting mechanical power
    into alternating-current power. For example, individual machines within
    a set may be defined for scheduling purposes while a single control signal
    is derived for the set. In this case there would be a GeneratingUnit for
    each member of the set and an additional GeneratingUnit corresponding to
    the set.
    '''

    maxOperatingP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            This is the maximum operating active power limit the dispatcher can enter
            for this unit.
            '''
        
        })
    '''
    This is the maximum operating active power limit the dispatcher can
    enter for this unit.
    '''
    
    minOperatingP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            This is the minimum operating active power limit the dispatcher can enter
            for this unit.
            '''
        
        })
    '''
    This is the minimum operating active power limit the dispatcher can
    enter for this unit.
    '''
    
    GenUnitOpSchedule: Optional[GenUnitOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GenUnitOpSchedule.GeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''
        
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''
    
    GenUnitOpCostCurves: list[GenUnitOpCostCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GenUnitOpCostCurve.GeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A generating unit may have one or more cost curves, depending upon fuel
            mixture and fuel cost.
            '''
        
        })
    '''
    A generating unit may have one or more cost curves, depending upon
    fuel mixture and fuel cost.
    '''
    
    GenUnitOpSchedule: Optional[GenUnitOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GenUnitOpSchedule.GeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A generating unit may have an operating schedule, indicating the planned
            operation of the unit.
            '''
        
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''
    
    GrossToNetActivePowerCurves: list[GrossToNetActivePowerCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'GrossToNetActivePowerCurve.GeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A generating unit may have a gross active power to net active power curve,
            describing the losses and auxiliary power requirements of the unit.
            '''
        
        })
    '''
    A generating unit may have a gross active power to net active power
    curve, describing the losses and auxiliary power requirements of the
    unit.
    '''
    
    RotatingMachine: list[RotatingMachine] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RotatingMachine.GeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A synchronous machine may operate as a generator and as such becomes a
            member of a generating unit.
            '''
        
        })
    '''
    A synchronous machine may operate as a generator and as such becomes
    a member of a generating unit.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class HydroGeneratingUnit(GeneratingUnit):
    '''
    A generating unit whose prime mover is a hydraulic turbine (e.g., Francis,
    Pelton, Kaplan).
    '''

    energyConversionCapability: Optional[ HydroEnergyConversionKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Energy conversion capability for generating.
            '''
        
        })
    '''
    Energy conversion capability for generating.
    '''
    
    hydroUnitWaterCost: Optional[ float | CostPerVolume ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The equivalent cost of water that drives the hydro turbine.
            '''
        
        })
    '''
    The equivalent cost of water that drives the hydro turbine.
    '''
    
    HydroPowerPlant: Optional[HydroPowerPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPowerPlant.HydroGeneratingUnits',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The hydro generating unit belongs to a hydro power plant.
            '''
        
        })
    '''
    The hydro generating unit belongs to a hydro power plant.
    '''
    
    PenstockLossCurve: Optional[PenstockLossCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PenstockLossCurve.HydroGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
    HydroGeneratingEfficiencyCurves: list[HydroGeneratingEfficiencyCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroGeneratingEfficiencyCurve.HydroGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A hydro generating unit has an efficiency curve.
            '''
        
        })
    '''
    A hydro generating unit has an efficiency curve.
    '''
    
    PenstockLossCurve: Optional[PenstockLossCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PenstockLossCurve.HydroGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A hydro generating unit has a penstock loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''
    
    TailbayLossCurve: list[TailbayLossCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TailbayLossCurve.HydroGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A hydro generating unit has a tailbay loss curve.
            '''
        
        })
    '''
    A hydro generating unit has a tailbay loss curve.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class NuclearGeneratingUnit(GeneratingUnit):
    '''
    A nuclear generating unit.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class SolarGeneratingUnit(GeneratingUnit):
    '''
    A solar thermal generating unit, connected to the grid by means of a rotating
    machine. This class does not represent photovoltaic (PV) generation.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ThermalGeneratingUnit(GeneratingUnit):
    '''
    A generating unit whose prime mover could be a steam turbine, combustion
    turbine, or diesel engine.
    '''

    oMCost: Optional[ float | CostPerHeatUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Operating and maintenance cost for the thermal unit.
            '''
        
        })
    '''
    Operating and maintenance cost for the thermal unit.
    '''
    
    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''
    
    CogenerationPlant: Optional[CogenerationPlant] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CogenerationPlant.ThermalGeneratingUnits',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may be a member of a cogeneration plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a cogeneration plant.
    '''
    
    CombinedCyclePlant: Optional[CombinedCyclePlant] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CombinedCyclePlant.ThermalGeneratingUnits',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may be a member of a combined cycle plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a combined cycle plant.
    '''
    
    HeatInputCurve: Optional[HeatInputCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HeatInputCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''
    
    HeatRateCurve: Optional[HeatRateCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HeatRateCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''
    
    IncrementalHeatRateCurve: Optional[IncrementalHeatRateCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IncrementalHeatRateCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''
    
    ShutdownCurve: Optional[ShutdownCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShutdownCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''
        
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a startup model.
            '''
        
        })
    '''
    A thermal generating unit may have a startup model.
    '''
    
    CAESPlant: Optional[CAESPlant] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'CAESPlant.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may be a member of a compressed air energy storage
            plant.
            '''
        
        })
    '''
    A thermal generating unit may be a member of a compressed air energy
    storage plant.
    '''
    
    EmmissionAccounts: list[EmissionAccount] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EmissionAccount.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have one or more emission allowance accounts.
            '''
        
        })
    '''
    A thermal generating unit may have one or more emission allowance accounts.
    '''
    
    EmissionCurves: list[EmissionCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EmissionCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have one or more emission curves.
            '''
        
        })
    '''
    A thermal generating unit may have one or more emission curves.
    '''
    
    FossilFuels: list[FossilFuel] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FossilFuel.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have one or more fossil fuels.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''
    
    FuelAllocationSchedules: list[FuelAllocationSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FuelAllocationSchedule.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have one or more fuel allocation schedules.
            '''
        
        })
    '''
    A thermal generating unit may have one or more fuel allocation schedules.
    '''
    
    HeatInputCurve: Optional[HeatInputCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HeatInputCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a heat input curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''
    
    HeatRateCurve: Optional[HeatRateCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HeatRateCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''
    
    IncrementalHeatRateCurve: Optional[IncrementalHeatRateCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IncrementalHeatRateCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have an incremental heat rate curve.
            '''
        
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''
    
    ShutdownCurve: Optional[ShutdownCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShutdownCurve.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a shutdown curve.
            '''
        
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''
    
    StartupModel: Optional[StartupModel] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartupModel.ThermalGeneratingUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a startup model.
            '''
        
        })
    '''
    A thermal generating unit may have a startup model.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class WindGeneratingUnit(GeneratingUnit):
    '''
    A wind driven generating unit, connected to the grid by means of a rotating
    machine. May be used to represent a single turbine or an aggregation.
    '''

    windGenUnitType: Optional[ WindGenUnitKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The kind of wind generating unit
            '''
        
        })
    '''
    The kind of wind generating unit
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class HydroPump(Equipment):
    '''
    A synchronous motor-driven pump, typically associated with a pumped storage
    plant.
    '''

    pumpDischAtMaxHead: Optional[ float | VolumeFlowRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The pumping discharge under maximum head conditions, usually at full gate.
            '''
        
        })
    '''
    The pumping discharge under maximum head conditions, usually at full
    gate.
    '''
    
    pumpDischAtMinHead: Optional[ float | VolumeFlowRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The pumping discharge under minimum head conditions, usually at full gate.
            '''
        
        })
    '''
    The pumping discharge under minimum head conditions, usually at full
    gate.
    '''
    
    pumpPowerAtMaxHead: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The pumping power under maximum head conditions, usually at full gate.
            '''
        
        })
    '''
    The pumping power under maximum head conditions, usually at full gate.
    '''
    
    pumpPowerAtMinHead: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The pumping power under minimum head conditions, usually at full gate.
            '''
        
        })
    '''
    The pumping power under minimum head conditions, usually at full gate.
    '''
    
    HydroPowerPlant: Optional[HydroPowerPlant] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPowerPlant.HydroPumps',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The hydro pump may be a member of a pumped storage plant or a pump for
            distributing water.
            '''
        
        })
    '''
    The hydro pump may be a member of a pumped storage plant or a pump
    for distributing water.
    '''
    
    HydroPumpOpSchedule: Optional[HydroPumpOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPumpOpSchedule.HydroPump',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''
        
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''
    
    RotatingMachine: Optional[RotatingMachine] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RotatingMachine.HydroPump',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''
        
        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''
    
    HydroPumpOpSchedule: Optional[HydroPumpOpSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'HydroPumpOpSchedule.HydroPump',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The hydro pump has a pumping schedule over time, indicating when pumping
            is to occur.
            '''
        
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''
    
    RotatingMachine: Optional[RotatingMachine] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RotatingMachine.HydroPump',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The synchronous machine drives the turbine which moves the water from a
            low elevation to a higher elevation. The direction of machine rotation
            for pumping may or may not be the same as for generating.
            '''
        
        })
    '''
    The synchronous machine drives the turbine which moves the water from
    a low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PowerElectronicsUnit(Equipment):
    '''
    A generating unit or battery or aggregation that connects to the AC network
    using power electronics rather than rotating machines.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum active power limit. This is the maximum (nameplate) limit for the
            unit.
            '''
        
        })
    '''
    Maximum active power limit. This is the maximum (nameplate) limit for
    the unit.
    '''
    
    minP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Minimum active power limit. This is the minimum (nameplate) limit for the
            unit.
            '''
        
        })
    '''
    Minimum active power limit. This is the minimum (nameplate) limit for
    the unit.
    '''
    
    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsConnection.PowerElectronicsUnit',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class BatteryUnit(PowerElectronicsUnit):
    '''
    An electrochemical energy storage device
    '''

    batteryState: Optional[ BatteryStateKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            indicates whether the battery is charging, discharging or idle
            '''
        
        })
    '''
    indicates whether the battery is charging, discharging or idle
    '''
    
    ratedE: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            full energy storage capacity of the battery
            '''
        
        })
    '''
    full energy storage capacity of the battery
    '''
    
    storedE: Optional[ float | RealEnergy ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            amount of energy currently stored; no more than ratedE
            '''
        
        })
    '''
    amount of energy currently stored; no more than ratedE
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PhotovoltaicUnit(PowerElectronicsUnit):
    '''
    A photovoltaic device or an aggregation of such devices
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerElectronicsWindUnit(PowerElectronicsUnit):
    '''
    A wind generating unit that connects to the AC network with power electronics
    rather than rotating machines or an aggregation of such units.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ProtectionEquipment(Equipment):
    '''
    An electrical device designed to respond to input conditions in a prescribed
    manner and after specified conditions are met to cause contact operation
    or similar abrupt change in associated electric control circuits, or simply
    to display the detected condition. Protection equipment is associated with
    conducting equipment and usually operate circuit breakers.
    '''

    highLimit: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum allowable value.
            '''
        
        })
    '''
    The maximum allowable value.
    '''
    
    lowLimit: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The minimum allowable value.
            '''
        
        })
    '''
    The minimum allowable value.
    '''
    
    powerDirectionFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Direction same as positive active power flow value.
            '''
        
        })
    '''
    Direction same as positive active power flow value.
    '''
    
    relayDelayTime: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The time delay from detection of abnormal conditions to relay operation.
            '''
        
        })
    '''
    The time delay from detection of abnormal conditions to relay operation.
    '''
    
    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit multiplier of the value.
            '''
        
        })
    '''
    The unit multiplier of the value.
    '''
    
    unitSymbol: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit of measure of the value.
            '''
        
        })
    '''
    The unit of measure of the value.
    '''
    
    ProtectionFunctionBlock: list[ProtectionFunctionBlock] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ProtectionFunctionBlock.ProtectionEquipment',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerTank(Equipment):
    '''
    An assembly of two or more coupled windings that transform electrical power
    between voltage levels. These windings are bound on a common core and place
    in the same tank. Transformer tank can be used to model both single-phase
    and 3-phase transformers.
    '''

    PowerTransformer: Optional[PowerTransformer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerTransformer.TransformerTanks',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Bank this transformer belongs to.
            '''
        
        })
    '''
    Bank this transformer belongs to.
    '''
    
    TransformerTankInfo: Optional[TransformerTankInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerTankInfo.TransformerTanks',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TransformerTankEnds: list[TransformerTankEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerTankEnd.TransformerTank',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All windings of this transformer.
            '''
        
        })
    '''
    All windings of this transformer.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class HydroPowerPlant(PowerSystemResource):
    '''
    A hydro power station which can generate or pump. When generating, the
    generator turbines receive water from an upper reservoir. When pumping,
    the pumps receive their water from a lower reservoir.
    '''

    penstockType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Type and configuration of hydro plant penstock(s).
            '''
        
        })
    '''
    Type and configuration of hydro plant penstock(s).
    '''
    
    surgeTankCode: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A code describing the type (or absence) of surge tank that is associated
            with the hydro power plant.
            '''
        
        })
    '''
    A code describing the type (or absence) of surge tank that is associated
    with the hydro power plant.
    '''
    
    dischargeTravelDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Water travel delay from tailbay to next downstream hydro power station.
            '''
        
        })
    '''
    Water travel delay from tailbay to next downstream hydro power station.
    '''
    
    genRatedP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The hydro plant's generating rating active power for rated head conditions.
            '''
        
        })
    '''
    The hydro plant's generating rating active power for rated head conditions.
    '''
    
    hydroPlantStorageType: Optional[ HydroPlantStorageKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The type of hydro power plant water storage.
            '''
        
        })
    '''
    The type of hydro power plant water storage.
    '''
    
    plantDischargeCapacity: Optional[ float | VolumeFlowRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Total plant discharge capacity.
            '''
        
        })
    '''
    Total plant discharge capacity.
    '''
    
    plantRatedHead: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The plant's rated gross head.
            '''
        
        })
    '''
    The plant's rated gross head.
    '''
    
    pumpRatedP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The hydro plant's pumping rating active power for rated head conditions.
            '''
        
        })
    '''
    The hydro plant's pumping rating active power for rated head conditions.
    '''
    
    surgeTankCrestLevel: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The level at which the surge tank spills.
            '''
        
        })
    '''
    The level at which the surge tank spills.
    '''
    
    GenSourcePumpDischargeReservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.UpstreamFromHydroPowerPlants',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Generators are supplied water from or pumps discharge water to an upstream
            reservoir.
            '''
        
        })
    '''
    Generators are supplied water from or pumps discharge water to an upstream
    reservoir.
    '''
    
    Reservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.HydroPowerPlants',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Generators discharge water to or pumps are supplied water from a downstream
            reservoir.
            '''
        
        })
    '''
    Generators discharge water to or pumps are supplied water from a downstream
    reservoir.
    '''
    
    HydroGeneratingUnits: list[HydroGeneratingUnit] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroGeneratingUnit.HydroPowerPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The hydro generating unit belongs to a hydro power plant.
            '''
        
        })
    '''
    The hydro generating unit belongs to a hydro power plant.
    '''
    
    HydroPumps: list[HydroPump] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroPump.HydroPowerPlant',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The hydro pump may be a member of a pumped storage plant or a pump for
            distributing water.
            '''
        
        })
    '''
    The hydro pump may be a member of a pumped storage plant or a pump
    for distributing water.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerCutZone(PowerSystemResource):
    '''
    An area or zone of the power system which is used for load shedding purposes.
    '''

    cutLevel1: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            First level (amount) of load to cut as a percentage of total zone load.
            '''
        
        })
    '''
    First level (amount) of load to cut as a percentage of total zone load.
    '''
    
    cutLevel2: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Second level (amount) of load to cut as a percentage of total zone load.
            '''
        
        })
    '''
    Second level (amount) of load to cut as a percentage of total zone
    load.
    '''
    
    EnergyConsumers: list[EnergyConsumer] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'EnergyConsumer.PowerCutZone',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Energy consumer is assigned to the power cut zone.
            '''
        
        })
    '''
    Energy consumer is assigned to the power cut zone.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerElectronicsConnectionPhase(PowerSystemResource):
    '''
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Active power injection. Load sign convention is used, i.e. positive sign
            means flow into the equipment from the network.
            '''
        
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive
    sign means flow into the equipment from the network.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase of this energy producer component. If the energy producer is wye
            connected, the connection is from the indicated phase to the central ground
            or neutral point. If the energy producer is delta connected, the phase
            indicates an energy producer connected from the indicated phase to the
            next logical non-neutral phase.
            '''
        
        })
    '''
    Phase of this energy producer component. If the energy producer is
    wye connected, the connection is from the indicated phase to the central
    ground or neutral point. If the energy producer is delta connected,
    the phase indicates an energy producer connected from the indicated
    phase to the next logical non-neutral phase.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reactive power injection. Load sign convention is used, i.e. positive sign
            means flow into the equipment from the network.
            '''
        
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive
    sign means flow into the equipment from the network.
    '''
    
    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerElectronicsConnection.PowerElectronicsConnectionPhases',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RegulatingControl(PowerSystemResource):
    '''
    Specifies a set of equipment that works together to control a power system
    quantity such as voltage or flow.
    Remote bus voltage control is possible by specifying the controlled terminal
    located at some place remote from the controlling equipment.
    In case multiple equipment, possibly of different types, control same terminal
    there must be only one RegulatingControl at that terminal. The most specific
    subtype of RegulatingControl shall be used in case such equipment participate
    in the control, e.g. TapChangerControl for tap changers.
    For flow control load sign convention is used, i.e. positive sign means
    flow out from a TopologicalNode (bus) into the conducting equipment.
    '''

    discrete: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The regulation is performed in a discrete mode. This applies to equipment
            with discrete controls, e.g. tap changers and shunt compensators.
            '''
        
        })
    '''
    The regulation is performed in a discrete mode. This applies to equipment
    with discrete controls, e.g. tap changers and shunt compensators.
    '''
    
    enabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The flag tells if regulation is enabled.
            '''
        
        })
    '''
    The flag tells if regulation is enabled.
    '''
    
    reverseTargetDeadband: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    reverseTargetValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    targetDeadband: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            This is a deadband used with discrete control to avoid excessive update
            of controls like tap changers and shunt compensator banks while regulating.
            The units of those appropriate for the mode.
            '''
        
        })
    '''
    This is a deadband used with discrete control to avoid excessive update
    of controls like tap changers and shunt compensator banks while regulating.
    The units of those appropriate for the mode.
    '''
    
    targetValue: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The target value specified for case input. This value can be used for the
            target value without the use of schedules. The value has the units appropriate
            to the mode attribute.
            '''
        
        })
    '''
    The target value specified for case input. This value can be used for
    the target value without the use of schedules. The value has the units
    appropriate to the mode attribute.
    '''
    
    mode: Optional[ RegulatingControlModeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The regulating control mode presently available. This specification allows
            for determining the kind of regulation without need for obtaining the units
            from a schedule.
            '''
        
        })
    '''
    The regulating control mode presently available. This specification
    allows for determining the kind of regulation without need for obtaining
    the units from a schedule.
    '''
    
    monitoredPhase: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase voltage controlling this regulator, measured at regulator location.
            '''
        
        })
    '''
    Phase voltage controlling this regulator, measured at regulator location.
    '''
    
    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.RegulatingControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The terminal associated with this regulating control. The terminal is associated
            instead of a node, since the terminal could connect into either a topological
            node (bus in bus-branch model) or a connectivity node (detailed switch
            model). Sometimes it is useful to model regulation at a terminal of a bus
            bar object since the bus bar can be present in both a bus-branch model
            or a model with switch detail.
            '''
        
        })
    '''
    The terminal associated with this regulating control. The terminal
    is associated instead of a node, since the terminal could connect into
    either a topological node (bus in bus-branch model) or a connectivity
    node (detailed switch model). Sometimes it is useful to model regulation
    at a terminal of a bus bar object since the bus bar can be present
    in both a bus-branch model or a model with switch detail.
    '''
    
    RegulatingCondEq: list[RegulatingCondEq] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulatingCondEq.RegulatingControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The equipment that participates in this regulating control scheme.
            '''
        
        })
    '''
    The equipment that participates in this regulating control scheme.
    '''
    
    RegulationSchedule: list[RegulationSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RegulationSchedule.RegulatingControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Schedule for this Regulating regulating control.
            '''
        
        })
    '''
    Schedule for this Regulating regulating control.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapChangerControl(RegulatingControl):
    '''
    Describes behavior specific to tap changers, e.g. how the voltage at the
    end of a line varies with the load level and compensation of the voltage
    drop by tap adjustment.
    '''

    lineDropCompensation: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            If true, the line drop compensation is to be applied.
            '''
        
        })
    '''
    If true, the line drop compensation is to be applied.
    '''
    
    reverseToNeutral: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    reversible: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    lineDropR: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Line drop compensator resistance setting for normal (forward) power flow.
            '''
        
        })
    '''
    Line drop compensator resistance setting for normal (forward) power
    flow.
    '''
    
    lineDropX: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Line drop compensator reactance setting for normal (forward) power flow.
            '''
        
        })
    '''
    Line drop compensator reactance setting for normal (forward) power
    flow.
    '''
    
    maxLimitVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Maximum allowed regulated voltage on the PT secondary, regardless of line
            drop compensation. Sometimes referred to as first-house protection.
            '''
        
        })
    '''
    Maximum allowed regulated voltage on the PT secondary, regardless of
    line drop compensation. Sometimes referred to as first-house protection.
    '''
    
    minLimitVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    reverseLineDropR: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Line drop compensator resistance setting for reverse power flow.
            '''
        
        })
    '''
    Line drop compensator resistance setting for reverse power flow.
    '''
    
    reverseLineDropX: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Line drop compensator reactance setting for reverse power flow.
            '''
        
        })
    '''
    Line drop compensator reactance setting for reverse power flow.
    '''
    
    reversingDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    reversingPowerThreshold: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TapChanger: list[TapChanger] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TapChanger.TapChangerControl',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The tap changers that participates in this regulating tap control scheme.
            '''
        
        })
    '''
    The tap changers that participates in this regulating tap control scheme.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class Reservoir(PowerSystemResource):
    '''
    A water storage facility within a hydro system, including: ponds, lakes,
    lagoons, and rivers. The storage is usually behind some type of dam.
    '''

    energyStorageRating: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reservoir's energy storage rating in energy for given head conditions.
            '''
        
        })
    '''
    The reservoir's energy storage rating in energy for given head conditions.
    '''
    
    riverOutletWorks: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            River outlet works for riparian right releases or other purposes.
            '''
        
        })
    '''
    River outlet works for riparian right releases or other purposes.
    '''
    
    spillwayCapacity: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The flow capacity of the spillway in cubic meters per second.
            '''
        
        })
    '''
    The flow capacity of the spillway in cubic meters per second.
    '''
    
    spillWayGateType: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Type of spillway gate, including parameters.
            '''
        
        })
    '''
    Type of spillway gate, including parameters.
    '''
    
    activeStorageCapacity: Optional[ float | Volume ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Storage volume between the full supply level and the normal minimum operating
            level.
            '''
        
        })
    '''
    Storage volume between the full supply level and the normal minimum
    operating level.
    '''
    
    fullSupplyLevel: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Full supply level, above which water will spill. This can be the spillway
            crest level or the top of closed gates.
            '''
        
        })
    '''
    Full supply level, above which water will spill. This can be the spillway
    crest level or the top of closed gates.
    '''
    
    grossCapacity: Optional[ float | Volume ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Total capacity of reservoir.
            '''
        
        })
    '''
    Total capacity of reservoir.
    '''
    
    normalMinOperateLevel: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal minimum operating level below which the penstocks will draw air.
            '''
        
        })
    '''
    Normal minimum operating level below which the penstocks will draw
    air.
    '''
    
    spillTravelDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The spillway water travel delay to the next downstream reservoir.
            '''
        
        })
    '''
    The spillway water travel delay to the next downstream reservoir.
    '''
    
    spillwayCrestLength: Optional[ float | Length ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The length of the spillway crest.
            '''
        
        })
    '''
    The length of the spillway crest.
    '''
    
    spillwayCrestLevel: Optional[ float | WaterLevel ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Spillway crest level above which water will spill.
            '''
        
        })
    '''
    Spillway crest level above which water will spill.
    '''
    
    SpillsFromReservoir: Optional[Reservoir] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Reservoir.SpillsIntoReservoirs',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A reservoir may spill into a downstream reservoir.
            '''
        
        })
    '''
    A reservoir may spill into a downstream reservoir.
    '''
    
    TargetLevelSchedule: Optional[TargetLevelSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TargetLevelSchedule.Reservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''
        
        })
    '''
    A reservoir may have a water level target schedule.
    '''
    
    UpstreamFromHydroPowerPlants: list[HydroPowerPlant] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroPowerPlant.GenSourcePumpDischargeReservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Generators are supplied water from or pumps discharge water to an upstream
            reservoir.
            '''
        
        })
    '''
    Generators are supplied water from or pumps discharge water to an upstream
    reservoir.
    '''
    
    HydroPowerPlants: list[HydroPowerPlant] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'HydroPowerPlant.Reservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Generators discharge water to or pumps are supplied water from a downstream
            reservoir.
            '''
        
        })
    '''
    Generators discharge water to or pumps are supplied water from a downstream
    reservoir.
    '''
    
    InflowForecasts: list[InflowForecast] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'InflowForecast.Reservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A reservoir may have a "natural" inflow forecast.
            '''
        
        })
    '''
    A reservoir may have a "natural" inflow forecast.
    '''
    
    LevelVsVolumeCurves: list[LevelVsVolumeCurve] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'LevelVsVolumeCurve.Reservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A reservoir may have a level versus volume relationship.
            '''
        
        })
    '''
    A reservoir may have a level versus volume relationship.
    '''
    
    SpillsIntoReservoirs: list[Reservoir] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Reservoir.SpillsFromReservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A reservoir may spill into a downstream reservoir.
            '''
        
        })
    '''
    A reservoir may spill into a downstream reservoir.
    '''
    
    TargetLevelSchedule: Optional[TargetLevelSchedule] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TargetLevelSchedule.Reservoir',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A reservoir may have a water level target schedule.
            '''
        
        })
    '''
    A reservoir may have a water level target schedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SchedulingArea(PowerSystemResource):
    '''
    '''

    Substations: list[Substation] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Substation.SchedulingArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The substations contained within the SchedulingArea.
            '''
        
        })
    '''
    The substations contained within the SchedulingArea.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Containment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class SubSchedulingArea(SchedulingArea):
    '''
    A persistent connectivity-based containment of ConductingEquipment objects
    with clearly-defined electrical boundaries forming a local power system
    with one or more points of common coupling. Each piece of ConductingEquipment
    can be associated with one ResourceContainer. The boundaries of the ResourceContainer
    are specified through the Terminals of equipment forming the boundary (such
    as a Recloser or PowerTransformer)
    '''

    SinkConfiguration: list[AreaConfiguration] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AreaConfiguration.EnergizedArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Set of possible configurations for the sink area.
            '''
        
        })
    '''
    Set of possible configurations for the sink area.
    '''
    
    SourceConfiguration: list[AreaConfiguration] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'AreaConfiguration.EnergizingArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The set of possible configurations for the source area
            '''
        
        })
    '''
    The set of possible configurations for the source area
    '''
    
    ContainedEquipment: list[Equipment] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Equipment.SubSchedulingArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Equipment contained within the SubSchedulingArea.
            '''
        
        })
    '''
    The Equipment contained within the SubSchedulingArea.
    '''
    
    BoundaryTerminals: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.BoundedSchedulingArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The set of terminals that define the persistent boundaries of the SubSchedulingArea
            '''
        
        })
    '''
    The set of terminals that define the persistent boundaries of the SubSchedulingArea
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Containment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class DistributionArea(SubSchedulingArea):
    '''
    A persistent connectivity-based containment of medium-voltage and high-voltage
    distribution ConductingEquipment with clearly defined electrical boundaries
    based on electrical connectivity of a distribution substation or multiple
    substations.
    '''

    Feeders: list[Feeder] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Feeder.DistributionArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Feeders within the service territory of the DistributionArea of a particular
            Distribution System Operator (DSO)
            '''
        
        })
    '''
    Feeders within the service territory of the DistributionArea of a particular
    Distribution System Operator (DSO)
    '''
    
    FeederAreas: list[FeederArea] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'FeederArea.DistributionArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Containment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class FeederArea(SubSchedulingArea):
    '''
    A persistent connectivity-based containment of medium-voltage distribution
    ConductingEquipment with clearly defined electrical boundaries based on
    electrical connectivity of a distribution feeder.
    The FeederArea contains all medium voltage equipment not contained in a
    SwitchArea or Substation / Bay. It also includes all Sectionalisers, Reclosers,
    and all other poletop and pad-mounted switchgear that form the boundary
    of a SwitchArea.
    '''

    DistributionArea: Optional[DistributionArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'DistributionArea.FeederAreas',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Feeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.FeederArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Feeder (which contains the ConnectivityNode and all Equipment) associated
            with the FeeederArea
            '''
        
        })
    '''
    The Feeder (which contains the ConnectivityNode and all Equipment)
    associated with the FeeederArea
    '''
    
    Feeder: Optional[Feeder] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Feeder.FeederArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Feeder (which contains the ConnectivityNode and all Equipment) associated
            with the FeeederArea
            '''
        
        })
    '''
    The Feeder (which contains the ConnectivityNode and all Equipment)
    associated with the FeeederArea
    '''
    
    SwitchAreas: list[SwitchArea] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SwitchArea.FeederArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The set of SwitchArea normally energized by the FeederArea
            '''
        
        })
    '''
    The set of SwitchArea normally energized by the FeederArea
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Containment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class SecondaryArea(SubSchedulingArea):
    '''
    A persistent connectivity-based containment of low-voltage distribution
    ConductingEquipment with clearly defined electrical boundaries formed by
    one or more PowerTransformer objects.
    '''

    primaryPhase: Optional[ PhaseCode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Used to represent the ABC phase to which the secondary split-phase transformer
            is connected in North American systems. For secondary areas served by a
            center-tap transformer, the phase connection of equipment will generally
            be SinglePhaseKind.s1 or SinglePhaseKind.s2, and it is not readily apparent
            what phase serves the loads at the medium voltage level.
            '''
        
        })
    '''
    Used to represent the ABC phase to which the secondary split-phase
    transformer is connected in North American systems. For secondary areas
    served by a center-tap transformer, the phase connection of equipment
    will generally be SinglePhaseKind.s1 or SinglePhaseKind.s2, and it
    is not readily apparent what phase serves the loads at the medium voltage
    level.
    '''
    
    SwitchArea: Optional[SwitchArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SwitchArea.SecondaryAreas',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The SwitchArea that normally energizes the SecondaryArea
            '''
        
        })
    '''
    The SwitchArea that normally energizes the SecondaryArea
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Containment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class SwitchArea(SubSchedulingArea):
    '''
    A persistent connectivity-based containment of medium-voltage distribution
    ConductingEquipment with clearly defined electrical boundaries formed by
    one or more Switch objects.
    The SwitchArea contains all conductors, fuses, poletop equipment, and vault
    equipment. It also contains all secondary service transformers not contained
    in a SecondarySubstation.
    '''

    FeederArea: Optional[FeederArea] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'FeederArea.SwitchAreas',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The FeederArea that normally energizes the SwitchArea
            '''
        
        })
    '''
    The FeederArea that normally energizes the SwitchArea
    '''
    
    SecondaryAreas: list[SecondaryArea] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SecondaryArea.SwitchArea',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The set of SecondAreas normally energized by the SwitchArea
            '''
        
        })
    '''
    The set of SecondAreas normally energized by the SwitchArea
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Containment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Microgrid(SwitchArea):
    '''
    A persistent connectivity-based containment of distribution ConductingEquipment
    that 1) has clearly-defined electrical boundaries formed by one or more
    point of common coupling Switch objects and 2) that acts as a single controllable
    entity which can be operated in grid-connected or islanded mode.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Containment'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ShuntCompensatorPhase(PowerSystemResource):
    '''
    Single phase of a multi-phase shunt compensator when its attributes might
    be different per phase.
    '''

    maximumSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The maximum number of sections that may be switched in for this phase.
            '''
        
        })
    '''
    The maximum number of sections that may be switched in for this phase.
    '''
    
    normalSections: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            For the capacitor phase, the normal number of sections switched in.
            '''
        
        })
    '''
    For the capacitor phase, the normal number of sections switched in.
    '''
    
    sections: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Number of sections in use for this phase, when controlled independently
            from the other phases. If not provided, may default to the parent ShuntCompensator.sections
            value (see ShuntCompensator documentation for more details).
            '''
        
        })
    '''
    Number of sections in use for this phase, when controlled independently
    from the other phases. If not provided, may default to the parent ShuntCompensator.sections
    value (see ShuntCompensator documentation for more details).
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase of this shunt compensator component. If the shunt compensator is
            wye connected, the connection is from the indicated phase to the central
            ground or neutral point. If the shunt compensator is delta connected, the
            phase indicates a shunt compensator connected from the indicated phase
            to the next logical non-neutral phase.
            '''
        
        })
    '''
    Phase of this shunt compensator component. If the shunt compensator
    is wye connected, the connection is from the indicated phase to the
    central ground or neutral point. If the shunt compensator is delta
    connected, the phase indicates a shunt compensator connected from the
    indicated phase to the next logical non-neutral phase.
    '''
    
    ShuntCompensator: Optional[ShuntCompensator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensator.ShuntCompensatorPhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Shunt compensator of this shunt compensator phase.
            '''
        
        })
    '''
    Shunt compensator of this shunt compensator phase.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class LinearShuntCompensatorPhase(ShuntCompensatorPhase):
    '''
    A per phase linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    bPerSection: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Susceptance per section of the phase if shunt compensator is wye connected.
            Susceptance per section phase to phase if shunt compensator is delta connected.
            '''
        
        })
    '''
    Susceptance per section of the phase if shunt compensator is wye connected.
    Susceptance per section phase to phase if shunt compensator is delta
    connected.
    '''
    
    gPerSection: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Conductance per section for this phase if shunt compensator is wye connected.
            Conductance per section phase to phase if shunt compensator is delta connected.
            '''
        
        })
    '''
    Conductance per section for this phase if shunt compensator is wye
    connected. Conductance per section phase to phase if shunt compensator
    is delta connected.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class NonlinearShuntCompensatorPhase(ShuntCompensatorPhase):
    '''
    A per phase non linear shunt compensator has bank or section admittance
    values that differs.
    '''

    NonlinearShuntCompensatorPhasePoints: list[NonlinearShuntCompensatorPhasePoint] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NonlinearShuntCompensatorPhasePoint.NonlinearShuntCompensatorPhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All points of the non-linear shunt compensator phase.
            '''
        
        })
    '''
    All points of the non-linear shunt compensator phase.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class SwitchPhase(PowerSystemResource):
    '''
    Single phase of a multi-phase switch when its attributes might be different
    per phase.
    '''

    closed: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The attribute tells if the switch is considered closed when used as input
            to topology processing.
            '''
        
        })
    '''
    The attribute tells if the switch is considered closed when used as
    input to topology processing.
    '''
    
    normalOpen: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Used in cases when no Measurement for the status value is present. If the
            SwitchPhase has a status measurement the Discrete.normalValue is expected
            to match with this value.
            '''
        
        })
    '''
    Used in cases when no Measurement for the status value is present.
    If the SwitchPhase has a status measurement the Discrete.normalValue
    is expected to match with this value.
    '''
    
    phaseSide1: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase of this SwitchPhase on the side with terminal sequence number equal
            1. Should be a phase contained in that terminal&rsquo;s phases attribute.
            '''
        
        })
    '''
    Phase of this SwitchPhase on the side with terminal sequence number
    equal 1. Should be a phase contained in that terminal&rsquo;s phases
    attribute.
    '''
    
    phaseSide2: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase of this SwitchPhase on the side with terminal sequence number equal
            2. Should be a phase contained in that terminal&rsquo;s Terminal.phases
            attribute.
            '''
        
        })
    '''
    Phase of this SwitchPhase on the side with terminal sequence number
    equal 2. Should be a phase contained in that terminal&rsquo;s Terminal.phases
    attribute.
    '''
    
    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated current through this phase, if different from the others.
            '''
        
        })
    '''
    Rated current through this phase, if different from the others.
    '''
    
    Switch: Optional[Switch] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Switch.SwitchPhase',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The switch of the switch phase.
            '''
        
        })
    '''
    The switch of the switch phase.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapChanger(PowerSystemResource):
    '''
    Mechanism for changing transformer winding tap positions.
    '''

    controlEnabled: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Specifies the regulation status of the equipment. True is regulating, false
            is not regulating.
            '''
        
        })
    '''
    Specifies the regulation status of the equipment. True is regulating,
    false is not regulating.
    '''
    
    ctRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    highStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Highest possible tap step position, advance from neutral.
            The attribute shall be greater than lowStep.
            '''
        
        })
    '''
    Highest possible tap step position, advance from neutral.
    The attribute shall be greater than lowStep.
    '''
    
    lowStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Lowest possible tap step position, retard from neutral
            '''
        
        })
    '''
    Lowest possible tap step position, retard from neutral
    '''
    
    ltcFlag: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Specifies whether or not a TapChanger has load tap changing capabilities.
            '''
        
        })
    '''
    Specifies whether or not a TapChanger has load tap changing capabilities.
    '''
    
    neutralStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The neutral tap step position for this winding.
            The attribute shall be equal or greater than lowStep and equal or less
            than highStep.
            '''
        
        })
    '''
    The neutral tap step position for this winding.
    The attribute shall be equal or greater than lowStep and equal or less
    than highStep.
    '''
    
    normalStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The tap step position used in "normal" network operation for this winding.
            For a "Fixed" tap changer indicates the current physical tap setting.
            The attribute shall be equal or greater than lowStep and equal or less
            than highStep.
            '''
        
        })
    '''
    The tap step position used in "normal" network operation for this winding.
    For a "Fixed" tap changer indicates the current physical tap setting.
    The attribute shall be equal or greater than lowStep and equal or less
    than highStep.
    '''
    
    ptRatio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    step: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Tap changer position.
            Starting step for a steady state solution. Non integer values are allowed
            to support continuous tap variables. The reasons for continuous value are
            to support study cases where no discrete tap changers has yet been designed,
            a solutions where a narrow voltage band force the tap step to oscillate
            or accommodate for a continuous solution as input.
            The attribute shall be equal or greater than lowStep and equal or less
            than highStep.
            '''
        
        })
    '''
    Tap changer position.
    Starting step for a steady state solution. Non integer values are allowed
    to support continuous tap variables. The reasons for continuous value
    are to support study cases where no discrete tap changers has yet been
    designed, a solutions where a narrow voltage band force the tap step
    to oscillate or accommodate for a continuous solution as input.
    The attribute shall be equal or greater than lowStep and equal or less
    than highStep.
    '''
    
    ctRating: Optional[ float | CurrentFlow ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    initialDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            For an LTC, the delay for initial tap changer operation (first step change)
            '''
        
        })
    '''
    For an LTC, the delay for initial tap changer operation (first step
    change)
    '''
    
    neutralU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Voltage at which the winding operates at the neutral tap setting.
            '''
        
        })
    '''
    Voltage at which the winding operates at the neutral tap setting.
    '''
    
    subsequentDelay: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            For an LTC, the delay for subsequent tap changer operation (second and
            later step changes)
            '''
        
        })
    '''
    For an LTC, the delay for subsequent tap changer operation (second
    and later step changes)
    '''
    
    SvTapStep: Optional[SvTapStep] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SvTapStep.TapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The tap step state associated with the tap changer.
            '''
        
        })
    '''
    The tap step state associated with the tap changer.
    '''
    
    TapChangerControl: Optional[TapChangerControl] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TapChangerControl.TapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The regulating control scheme in which this tap changer participates.
            '''
        
        })
    '''
    The regulating control scheme in which this tap changer participates.
    '''
    
    SvTapStep: Optional[SvTapStep] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'SvTapStep.TapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The tap step state associated with the tap changer.
            '''
        
        })
    '''
    The tap step state associated with the tap changer.
    '''
    
    TapSchedules: list[TapSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TapSchedule.TapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A TapChanger can have TapSchedules.
            '''
        
        })
    '''
    A TapChanger can have TapSchedules.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PhaseTapChanger(TapChanger):
    '''
    A transformer phase shifting tap model that controls the phase angle difference
    across the power transformer and potentially the active power flow through
    the power transformer. This phase tap model may also impact the voltage
    magnitude.
    '''

    TransformerEnd: Optional[TransformerEnd] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEnd.PhaseTapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer end to which this phase tap changer belongs.
            '''
        
        })
    '''
    Transformer end to which this phase tap changer belongs.
    '''
    
    TransformerEnd: Optional[TransformerEnd] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEnd.PhaseTapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer end to which this phase tap changer belongs.
            '''
        
        })
    '''
    Transformer end to which this phase tap changer belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerLinear(PhaseTapChanger):
    '''
    Describes a tap changer with a linear relation between the tap step and
    the phase angle difference across the transformer. This is a mathematical
    model that is an approximation of a real phase tap changer.
    The phase angle is computed as stepPhaseShitfIncrement times the tap position.
    The secondary side voltage magnitude is the same as at the primary side.
    '''

    stepPhaseShiftIncrement: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase shift per step position. A positive value indicates a positive phase
            shift from the winding where the tap is located to the other winding (for
            a two-winding transformer).
            The actual phase shift increment might be more accurately computed from
            the symmetrical or asymmetrical models or a tap step table lookup if those
            are available.
            '''
        
        })
    '''
    Phase shift per step position. A positive value indicates a positive
    phase shift from the winding where the tap is located to the other
    winding (for a two-winding transformer).
    The actual phase shift increment might be more accurately computed
    from the symmetrical or asymmetrical models or a tap step table lookup
    if those are available.
    '''
    
    xMax: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reactance depend on the tap position according to a "u" shaped curve.
            The maximum reactance (xMax) appear at the low and high tap positions.
            '''
        
        })
    '''
    The reactance depend on the tap position according to a "u" shaped
    curve. The maximum reactance (xMax) appear at the low and high tap
    positions.
    '''
    
    xMin: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reactance depend on the tap position according to a "u" shaped curve.
            The minimum reactance (xMin) appear at the mid tap position.
            '''
        
        })
    '''
    The reactance depend on the tap position according to a "u" shaped
    curve. The minimum reactance (xMin) appear at the mid tap position.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerNonLinear(PhaseTapChanger):
    '''
    The non-linear phase tap changer describes the non-linear behavior of a
    phase tap changer. This is a base class for the symmetrical and asymmetrical
    phase tap changer models. The details of these models can be found in the
    IEC 61970-301 document.
    '''

    voltageStepIncrement: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The voltage step increment on the out of phase winding specified in percent
            of neutral voltage of the tap changer.
            When the increment is negative, the voltage decreases when the tap step
            increases.
            '''
        
        })
    '''
    The voltage step increment on the out of phase winding specified in
    percent of neutral voltage of the tap changer.
    When the increment is negative, the voltage decreases when the tap
    step increases.
    '''
    
    xMax: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reactance depend on the tap position according to a "u" shaped curve.
            The maximum reactance (xMax) appear at the low and high tap positions.
            '''
        
        })
    '''
    The reactance depend on the tap position according to a "u" shaped
    curve. The maximum reactance (xMax) appear at the low and high tap
    positions.
    '''
    
    xMin: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reactance depend on the tap position according to a "u" shaped curve.
            The minimum reactance (xMin) appear at the mid tap position.
            '''
        
        })
    '''
    The reactance depend on the tap position according to a "u" shaped
    curve. The minimum reactance (xMin) appear at the mid tap position.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerAsymmetrical(PhaseTapChangerNonLinear):
    '''
    Describes the tap model for an asymmetrical phase shifting transformer
    in which the difference voltage vector adds to the primary side voltage.
    The angle between the primary side voltage and the difference voltage is
    named the winding connection angle. The phase shift depends on both the
    difference voltage magnitude and the winding connection angle.
    '''

    windingConnectionAngle: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The phase angle between the in-phase winding and the out-of -phase winding
            used for creating phase shift. The out-of-phase winding produces what is
            known as the difference voltage. Setting this angle to 90 degrees is not
            the same as a symmetrical transformer.
            '''
        
        })
    '''
    The phase angle between the in-phase winding and the out-of -phase
    winding used for creating phase shift. The out-of-phase winding produces
    what is known as the difference voltage. Setting this angle to 90 degrees
    is not the same as a symmetrical transformer.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerSymmetrical(PhaseTapChangerNonLinear):
    '''
    Describes a symmetrical phase shifting transformer tap model in which the
    secondary side voltage magnitude is the same as at the primary side. The
    difference voltage magnitude is the base in an equal-sided triangle where
    the sides corresponds to the primary and secondary voltages. The phase
    angle difference corresponds to the top angle and can be expressed as twice
    the arctangent of half the total difference voltage.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerTabular(PhaseTapChanger):
    '''
    '''

    PhaseTapChangerTable: Optional[PhaseTapChangerTable] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhaseTapChangerTable.PhaseTapChangerTabular',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The phase tap changer table for this phase tap changer.
            '''
        
        })
    '''
    The phase tap changer table for this phase tap changer.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class RatioTapChanger(TapChanger):
    '''
    A tap changer that changes the voltage ratio impacting the voltage magnitude
    but not the phase angle across the transformer.
    '''

    stepVoltageIncrement: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Tap step increment, in per cent of neutral voltage, per step position.
            When the increment is negative, the voltage decreases when the tap step
            increases.
            '''
        
        })
    '''
    Tap step increment, in per cent of neutral voltage, per step position.
    When the increment is negative, the voltage decreases when the tap
    step increases.
    '''
    
    RatioTapChangerTable: Optional[RatioTapChangerTable] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RatioTapChangerTable.RatioTapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The tap ratio table for this ratio tap changer.
            '''
        
        })
    '''
    The tap ratio table for this ratio tap changer.
    '''
    
    TransformerEnd: Optional[TransformerEnd] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEnd.RatioTapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer end to which this ratio tap changer belongs.
            '''
        
        })
    '''
    Transformer end to which this ratio tap changer belongs.
    '''
    
    TransformerEnd: Optional[TransformerEnd] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEnd.RatioTapChanger',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer end to which this ratio tap changer belongs.
            '''
        
        })
    '''
    Transformer end to which this ratio tap changer belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class VoltageControlZone(PowerSystemResource):
    '''
    An area of the power system network which is defined for secondary voltage
    control purposes. A voltage control zone consists of a collection of substations
    with a designated bus bar section whose voltage will be controlled.
    '''

    BusbarSection: Optional[BusbarSection] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BusbarSection.VoltageControlZone',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A VoltageControlZone is controlled by a designated BusbarSection.
            '''
        
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''
    
    RegulationSchedule: Optional[RegulationSchedule] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegulationSchedule.VoltageControlZones',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A VoltageControlZone may have a voltage regulation schedule.
            '''
        
        })
    '''
    A VoltageControlZone may have a voltage regulation schedule.
    '''
    
    BusbarSection: Optional[BusbarSection] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BusbarSection.VoltageControlZone',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A VoltageControlZone is controlled by a designated BusbarSection.
            '''
        
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ProtectionSettingsGroup(IdentifiedObject):
    '''
    '''

    caseName: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    groupNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    inService: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Protection'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RatioTapChangerTable(IdentifiedObject):
    '''
    Describes a curve for how the voltage magnitude and impedance varies with
    the tap step.
    '''

    RatioTapChanger: list[RatioTapChanger] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RatioTapChanger.RatioTapChangerTable',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The ratio tap changer of this tap ratio table.
            '''
        
        })
    '''
    The ratio tap changer of this tap ratio table.
    '''
    
    RatioTapChangerTablePoint: list[RatioTapChangerTablePoint] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RatioTapChangerTablePoint.RatioTapChangerTable',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Points of this table.
            '''
        
        })
    '''
    Points of this table.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ReportingGroup(IdentifiedObject):
    '''
    A reporting group is used for various ad-hoc groupings used for reporting.
    '''

    ReportingSuperGroup: Optional[ReportingSuperGroup] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReportingSuperGroup.ReportingGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reporting super group to which this reporting group belongs.
            '''
        
        })
    '''
    Reporting super group to which this reporting group belongs.
    '''
    
    BusNameMarker: list[BusNameMarker] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BusNameMarker.ReportingGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The bus name markers that belong to this reporting group.
            '''
        
        })
    '''
    The bus name markers that belong to this reporting group.
    '''
    
    TopologicalNode: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.ReportingGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The topological nodes that belong to the reporting group.
            '''
        
        })
    '''
    The topological nodes that belong to the reporting group.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ReportingSuperGroup(IdentifiedObject):
    '''
    A reporting super group, groups reporting groups for a higher level report.
    '''

    ReportingGroup: list[ReportingGroup] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ReportingGroup.ReportingSuperGroup',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reporting groups that are grouped under this super group.
            '''
        
        })
    '''
    Reporting groups that are grouped under this super group.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RightOfWay(IdentifiedObject):
    '''
    '''

    ParallelLineSegments: list[ParallelLineSegment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ParallelLineSegment.RightOfWay',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Season(IdentifiedObject):
    '''
    A specified time period of the year.
    '''

    endDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Date season ends.
            '''
        
        })
    '''
    Date season ends.
    '''
    
    startDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Date season starts.
            '''
        
        })
    '''
    Date season starts.
    '''
    
    SeasonDayTypeSchedules: list[SeasonDayTypeSchedule] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SeasonDayTypeSchedule.Season',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Schedules that use this Season.
            '''
        
        })
    '''
    Schedules that use this Season.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'LoadModel'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class StartupModel(IdentifiedObject):
    '''
    Unit start up characteristics depending on how long the unit has been off
    line.
    '''

    startupDate: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The date and time of the most recent generating unit startup.
            '''
        
        })
    '''
    The date and time of the most recent generating unit startup.
    '''
    
    startupPriority: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Startup priority within control area where lower numbers indicate higher
            priorities. More than one unit in an area may be assigned the same priority.
            '''
        
        })
    '''
    Startup priority within control area where lower numbers indicate higher
    priorities. More than one unit in an area may be assigned the same
    priority.
    '''
    
    fixedMaintCost: Optional[ float | CostRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Fixed maintenance cost.
            '''
        
        })
    '''
    Fixed maintenance cost.
    '''
    
    hotStandbyHeat: Optional[ float | HeatRate ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The amount of heat input per time uint required for hot standby operation.
            '''
        
        })
    '''
    The amount of heat input per time uint required for hot standby operation.
    '''
    
    incrementalMaintCost: Optional[ float | CostPerEnergyUnit ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Incremental maintenance cost.
            '''
        
        })
    '''
    Incremental maintenance cost.
    '''
    
    minimumDownTime: Optional[ float | Hours ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The minimum number of hours the unit must be down before restart.
            '''
        
        })
    '''
    The minimum number of hours the unit must be down before restart.
    '''
    
    minimumRunTime: Optional[ float | Hours ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The minimum number of hours the unit must be operating before being allowed
            to shut down.
            '''
        
        })
    '''
    The minimum number of hours the unit must be operating before being
    allowed to shut down.
    '''
    
    riskFactorCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The opportunity cost associated with the return in monetary unit. This
            represents the restart's "share" of the unit depreciation and risk of an
            event which would damage the unit.
            '''
        
        })
    '''
    The opportunity cost associated with the return in monetary unit. This
    represents the restart's "share" of the unit depreciation and risk
    of an event which would damage the unit.
    '''
    
    startupCost: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Total miscellaneous start up costs.
            '''
        
        })
    '''
    Total miscellaneous start up costs.
    '''
    
    stbyAuxP: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's auxiliary active power consumption to maintain standby mode.
            '''
        
        })
    '''
    The unit's auxiliary active power consumption to maintain standby mode.
    '''
    
    StartIgnFuelCurve: Optional[StartIgnFuelCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartIgnFuelCurve.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''
    
    StartMainFuelCurve: Optional[StartMainFuelCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartMainFuelCurve.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''
    
    StartRampCurve: Optional[StartRampCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartRampCurve.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a startup model.
            '''
        
        })
    '''
    A thermal generating unit may have a startup model.
    '''
    
    StartIgnFuelCurve: Optional[StartIgnFuelCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartIgnFuelCurve.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's startup model may have a startup ignition fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''
    
    StartMainFuelCurve: Optional[StartMainFuelCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartMainFuelCurve.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's startup model may have a startup main fuel curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''
    
    StartRampCurve: Optional[StartRampCurve] = field(
        default=None,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'StartRampCurve.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The unit's startup model may have a startup ramp curve.
            '''
        
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''
    
    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ThermalGeneratingUnit.StartupModel',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A thermal generating unit may have a startup model.
            '''
        
        })
    '''
    A thermal generating unit may have a startup model.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class SubGeographicalRegion(IdentifiedObject):
    '''
    A subset of a geographical region of a power system network model.
    '''

    Region: Optional[GeographicalRegion] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'GeographicalRegion.Regions',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The geographical region to which this sub-geographical region is within.
            '''
        
        })
    '''
    The geographical region to which this sub-geographical region is within.
    '''
    
    Lines: list[Line] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Line.Region',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The lines within the sub-geographical region.
            '''
        
        })
    '''
    The lines within the sub-geographical region.
    '''
    
    Substations: list[Substation] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Substation.Region',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The substations in this sub-geographical region.
            '''
        
        })
    '''
    The substations in this sub-geographical region.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ThermostatController(IdentifiedObject):
    '''
    a price-responsive or bidding smart thermostat
    '''

    baseSetpoint: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            user's desired thermostat setpoint, including the effects of pre-programmed
            schedule
            '''
        
        })
    '''
    user's desired thermostat setpoint, including the effects of pre-programmed
    schedule
    '''
    
    controlMode: Optional[ ThermostatControlMode ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    priceCap: Optional[ Money ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            maximum price per kwh that the controller will bid, regardless of the market's
            price cap
            '''
        
        })
    '''
    maximum price per kwh that the controller will bid, regardless of the
    market's price cap
    '''
    
    rangeHigh: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            maximum postive offset to the thermostat setpoint
            '''
        
        })
    '''
    maximum postive offset to the thermostat setpoint
    '''
    
    rangeLow: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            maximum negative offset to the thermostat setpoint
            '''
        
        })
    '''
    maximum negative offset to the thermostat setpoint
    '''
    
    House: Optional[House] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'House.ThermostatController',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    House: Optional[House] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'House.ThermostatController',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Houses'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TopologicalIsland(IdentifiedObject):
    '''
    An electrically connected subset of the network. Topological islands can
    change as the current network state changes: e.g. due to
    - disconnect switches or breakers change state in a SCADA/EMS
    - manual creation, change or deletion of topological nodes in a planning
    tool.
    '''

    AngleRefTopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.AngleRefTopologicalIsland',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The angle reference for the island. Normally there is one TopologicalNode
            that is selected as the angle reference for each island. Other reference
            schemes exist, so the association is typically optional.
            '''
        
        })
    '''
    The angle reference for the island. Normally there is one TopologicalNode
    that is selected as the angle reference for each island. Other reference
    schemes exist, so the association is typically optional.
    '''
    
    AngleRefTopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.AngleRefTopologicalIsland',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The angle reference for the island. Normally there is one TopologicalNode
            that is selected as the angle reference for each island. Other reference
            schemes exist, so the association is typically optional.
            '''
        
        })
    '''
    The angle reference for the island. Normally there is one TopologicalNode
    that is selected as the angle reference for each island. Other reference
    schemes exist, so the association is typically optional.
    '''
    
    TopologicalNodes: list[TopologicalNode] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TopologicalNode.TopologicalIsland',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A topological node belongs to a topological island.
            '''
        
        })
    '''
    A topological node belongs to a topological island.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Topology'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class TopologicalNode(IdentifiedObject):
    '''
    For a detailed substation model a topological node is a set of connectivity
    nodes that, in the current network state, are connected together through
    any type of closed switches, including jumpers. Topological nodes change
    as the current network state changes (i.e., switches, breakers, etc. change
    state).
    For a planning model, switch statuses are not used to form topological
    nodes. Instead they are manually created or deleted in a model builder
    tool. Topological nodes maintained this way are also called "busses".
    '''

    pInjection: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The active power injected into the bus at this location in addition to
            injections from equipment. Positive sign means injection into the TopologicalNode
            (bus).
            Starting value for a steady state solution.
            '''
        
        })
    '''
    The active power injected into the bus at this location in addition
    to injections from equipment. Positive sign means injection into the
    TopologicalNode (bus).
    Starting value for a steady state solution.
    '''
    
    qInjection: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reactive power injected into the bus at this location in addition to
            injections from equipment. Positive sign means injection into the TopologicalNode
            (bus).
            Starting value for a steady state solution.
            '''
        
        })
    '''
    The reactive power injected into the bus at this location in addition
    to injections from equipment. Positive sign means injection into the
    TopologicalNode (bus).
    Starting value for a steady state solution.
    '''
    
    AngleRefTopologicalIsland: Optional[TopologicalIsland] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalIsland.AngleRefTopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The island for which the node is an angle reference. Normally there is
            one angle reference node for each island.
            '''
        
        })
    '''
    The island for which the node is an angle reference. Normally there
    is one angle reference node for each island.
    '''
    
    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The base voltage of the topologocial node.
            '''
        
        })
    '''
    The base voltage of the topologocial node.
    '''
    
    ConnectivityNodeContainer: Optional[ConnectivityNodeContainer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNodeContainer.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The connectivity node container to which the toplogical node belongs.
            '''
        
        })
    '''
    The connectivity node container to which the toplogical node belongs.
    '''
    
    ReportingGroup: Optional[ReportingGroup] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ReportingGroup.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reporting group to which the topological node belongs.
            '''
        
        })
    '''
    The reporting group to which the topological node belongs.
    '''
    
    TopologicalIsland: Optional[TopologicalIsland] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalIsland.TopologicalNodes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A topological node belongs to a topological island.
            '''
        
        })
    '''
    A topological node belongs to a topological island.
    '''
    
    BusNameMarker: list[BusNameMarker] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'BusNameMarker.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            BusnameMarkers that may refer to a pre defined TopologicalNode.
            '''
        
        })
    '''
    BusnameMarkers that may refer to a pre defined TopologicalNode.
    '''
    
    ConnectivityNodes: list[ConnectivityNode] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ConnectivityNode.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The connectivity nodes combine together to form this topological node.
            May depend on the current state of switches in the network.
            '''
        
        })
    '''
    The connectivity nodes combine together to form this topological node.
    May depend on the current state of switches in the network.
    '''
    
    SvInjection: list[SvInjection] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvInjection.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The injection flows state variables associated with the topological node.
            '''
        
        })
    '''
    The injection flows state variables associated with the topological
    node.
    '''
    
    SvVoltage: list[SvVoltage] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'SvVoltage.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The state voltage associated with the topological node.
            '''
        
        })
    '''
    The state voltage associated with the topological node.
    '''
    
    Terminal: list[Terminal] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Terminal.TopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The terminals associated with the topological node. This can be used as
            an alternative to the connectivity node path to terminal, thus making it
            unneccesary to model connectivity nodes in some cases. Note that if connectivity
            nodes are in the model, this association would probably not be used as
            an input specification.
            '''
        
        })
    '''
    The terminals associated with the topological node. This can be used
    as an alternative to the connectivity node path to terminal, thus making
    it unneccesary to model connectivity nodes in some cases. Note that
    if connectivity nodes are in the model, this association would probably
    not be used as an input specification.
    '''
    
    AngleRefTopologicalIsland: Optional[TopologicalIsland] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalIsland.AngleRefTopologicalNode',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The island for which the node is an angle reference. Normally there is
            one angle reference node for each island.
            '''
        
        })
    '''
    The island for which the node is an angle reference. Normally there
    is one angle reference node for each island.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Topology'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerCoreAdmittance(IdentifiedObject):
    '''
    The transformer core admittance. Used to specify the core admittance of
    a transformer in a manner that can be shared among power transformers.
    '''

    b: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Magnetizing branch susceptance (B mag). The value can be positive or negative.
            '''
        
        })
    '''
    Magnetizing branch susceptance (B mag). The value can be positive or
    negative.
    '''
    
    b0: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence magnetizing branch susceptance.
            '''
        
        })
    '''
    Zero sequence magnetizing branch susceptance.
    '''
    
    g: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Magnetizing branch conductance (G mag).
            '''
        
        })
    '''
    Magnetizing branch conductance (G mag).
    '''
    
    g0: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence magnetizing branch conductance.
            '''
        
        })
    '''
    Zero sequence magnetizing branch conductance.
    '''
    
    TransformerEndInfo: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.CoreAdmittance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer end datasheet used to calculate this core admittance.
            '''
        
        })
    '''
    Transformer end datasheet used to calculate this core admittance.
    '''
    
    TransformerEnd: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.CoreAdmittance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All transformer ends having this core admittance.
            '''
        
        })
    '''
    All transformer ends having this core admittance.
    '''
    
    TransformerEndInfo: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.CoreAdmittance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer end datasheet used to calculate this core admittance.
            '''
        
        })
    '''
    Transformer end datasheet used to calculate this core admittance.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerEnd(IdentifiedObject):
    '''
    A conducting connection point of a power transformer. It corresponds to
    a physical transformer winding terminal. In earlier CIM versions, the TransformerWinding
    class served a similar purpose, but this class is more flexible because
    it associates to terminal but is not a specialization of ConductingEquipment.
    '''

    endNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Number for this transformer end, corresponding to the end's order in the
            power transformer vector group or phase angle clock number. Highest voltage
            winding should be 1. Each end within a power transformer should have a
            unique subsequent end number. Note the transformer end number need not
            match the terminal sequence number.
            '''
        
        })
    '''
    Number for this transformer end, corresponding to the end's order in
    the power transformer vector group or phase angle clock number. Highest
    voltage winding should be 1. Each end within a power transformer should
    have a unique subsequent end number. Note the transformer end number
    need not match the terminal sequence number.
    '''
    
    grounded: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            (for Yn and Zn connections) True if the neutral is solidly grounded.
            '''
        
        })
    '''
    (for Yn and Zn connections) True if the neutral is solidly grounded.
    '''
    
    rground: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            (for Yn and Zn connections) Resistance part of neutral impedance where
            'grounded' is true.
            '''
        
        })
    '''
    (for Yn and Zn connections) Resistance part of neutral impedance where
    'grounded' is true.
    '''
    
    xground: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            (for Yn and Zn connections) Reactive part of neutral impedance where 'grounded'
            is true.
            '''
        
        })
    '''
    (for Yn and Zn connections) Reactive part of neutral impedance where
    'grounded' is true.
    '''
    
    BaseVoltage: Optional[BaseVoltage] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'BaseVoltage.TransformerEnds',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Base voltage of the transformer end. This is essential for PU calculation.
            '''
        
        })
    '''
    Base voltage of the transformer end. This is essential for PU calculation.
    '''
    
    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerCoreAdmittance.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Core admittance of this transformer end, representing magnetising current
            and core losses. The full values of the transformer should be supplied
            for one transformer end only.
            '''
        
        })
    '''
    Core admittance of this transformer end, representing magnetising current
    and core losses. The full values of the transformer should be supplied
    for one transformer end only.
    '''
    
    PhaseTapChanger: Optional[PhaseTapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhaseTapChanger.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase tap changer associated with this transformer end.
            '''
        
        })
    '''
    Phase tap changer associated with this transformer end.
    '''
    
    RatioTapChanger: Optional[RatioTapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RatioTapChanger.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Ratio tap changer associated with this transformer end.
            '''
        
        })
    '''
    Ratio tap changer associated with this transformer end.
    '''
    
    StarImpedance: Optional[TransformerStarImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerStarImpedance.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            (accurate for 2- or 3-winding transformers only) Pi-model impedances of
            this transformer end. By convention, for a two winding transformer, the
            full values of the transformer should be entered on the high voltage end
            (endNumber=1).
            '''
        
        })
    '''
    (accurate for 2- or 3-winding transformers only) Pi-model impedances
    of this transformer end. By convention, for a two winding transformer,
    the full values of the transformer should be entered on the high voltage
    end (endNumber=1).
    '''
    
    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Terminal of the power transformer to which this transformer end belongs.
            '''
        
        })
    '''
    Terminal of the power transformer to which this transformer end belongs.
    '''
    
    PhaseTapChanger: Optional[PhaseTapChanger] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhaseTapChanger.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase tap changer associated with this transformer end.
            '''
        
        })
    '''
    Phase tap changer associated with this transformer end.
    '''
    
    RatioTapChanger: Optional[RatioTapChanger] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RatioTapChanger.TransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Ratio tap changer associated with this transformer end.
            '''
        
        })
    '''
    Ratio tap changer associated with this transformer end.
    '''
    
    FromMeshImpedance: list[TransformerMeshImpedance] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerMeshImpedance.FromTransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All mesh impedances between this 'to' and other 'from' transformer ends.
            '''
        
        })
    '''
    All mesh impedances between this 'to' and other 'from' transformer
    ends.
    '''
    
    ToMeshImpedance: list[TransformerMeshImpedance] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerMeshImpedance.ToTransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All mesh impedances between this 'from' and other 'to' transformer ends.
            '''
        
        })
    '''
    All mesh impedances between this 'from' and other 'to' transformer
    ends.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PowerTransformerEnd(TransformerEnd):
    '''
    A PowerTransformerEnd is associated with each Terminal of a PowerTransformer.
    The impedance values r, r0, x, and x0 of a PowerTransformerEnd represents
    a star equivalent as follows
    1) for a two Terminal PowerTransformer the high voltage (TransformerEnd.endNumber=1)
    PowerTransformerEnd has non zero values on r, r0, x, and x0 while the low
    voltage (TransformerEnd.endNumber=0) PowerTransformerEnd has zero values
    for r, r0, x, and x0.
    2) for a three Terminal PowerTransformer the three PowerTransformerEnds
    represents a star equivalent with each leg in the star represented by r,
    r0, x, and x0 values.
    3) For a three Terminal transformer each PowerTransformerEnd shall have
    g, g0, b and b0 values corresponding the no load losses distributed on
    the three PowerTransformerEnds. The total no load loss shunt impedances
    may also be placed at one of the PowerTransformerEnds, preferably the end
    numbered 1, having the shunt values on end 1 is the preferred way.
    4) for a PowerTransformer with more than three Terminals the PowerTransformerEnd
    impedance values cannot be used. Instead use the TransformerMeshImpedance
    or split the transformer into multiple PowerTransformers.
    '''

    phaseAngleClock: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Terminal voltage phase angle displacement where 360 degrees are represented
            with clock hours. The valid values are 0 to 11. For example, for the secondary
            side end of a transformer with vector group code of 'Dyn11', specify the
            connection kind as wye with neutral and specify the phase angle of the
            clock as 11. The clock value of the transformer end number specified as
            1, is assumed to be zero. Note the transformer end number is not assumed
            to be the same as the terminal sequence number.
            '''
        
        })
    '''
    Terminal voltage phase angle displacement where 360 degrees are represented
    with clock hours. The valid values are 0 to 11. For example, for the
    secondary side end of a transformer with vector group code of 'Dyn11',
    specify the connection kind as wye with neutral and specify the phase
    angle of the clock as 11. The clock value of the transformer end number
    specified as 1, is assumed to be zero. Note the transformer end number
    is not assumed to be the same as the terminal sequence number.
    '''
    
    connectionKind: Optional[ WindingConnection ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Kind of connection.
            '''
        
        })
    '''
    Kind of connection.
    '''
    
    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Resistance (star-model) of the transformer end.
            The attribute shall be equal or greater than zero for non-equivalent transformers.
            '''
        
        })
    '''
    Resistance (star-model) of the transformer end.
    The attribute shall be equal or greater than zero for non-equivalent
    transformers.
    '''
    
    ratedS: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Normal apparent power rating.
            The attribute shall be a positive value. For a two-winding transformer
            the values for the high and low voltage sides shall be identical.
            '''
        
        })
    '''
    Normal apparent power rating.
    The attribute shall be a positive value. For a two-winding transformer
    the values for the high and low voltage sides shall be identical.
    '''
    
    ratedU: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Rated voltage: phase-phase for three-phase windings, and either phase-phase
            or phase-neutral for single-phase windings.
            A high voltage side, as given by TransformerEnd.endNumber, shall have a
            ratedU that is greater or equal than ratedU for the lower voltage sides.
            '''
        
        })
    '''
    Rated voltage: phase-phase for three-phase windings, and either phase-phase
    or phase-neutral for single-phase windings.
    A high voltage side, as given by TransformerEnd.endNumber, shall have
    a ratedU that is greater or equal than ratedU for the lower voltage
    sides.
    '''
    
    PowerTransformer: Optional[PowerTransformer] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerTransformer.PowerTransformerEnd',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The power transformer of this power transformer end.
            '''
        
        })
    '''
    The power transformer of this power transformer end.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerTankEnd(TransformerEnd):
    '''
    Transformer tank end represents an individual winding for unbalanced models
    or for transformer tanks connected into a bank (and bank is modelled with
    the PowerTransformer).
    '''

    orderedPhases: Optional[ OrderedPhaseCodeKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Identifies the phases present and the order of their connection on this
            winding (end) of the transformer. In some use cases, such as open-wye,
            open-delta transformers and single-phase, center-tap secondary transformers,
            the order of phase connection is important, so the OrderedPhaseCodeKind
            enumeration is used instead of PhaseCode.
            '''
        
        })
    '''
    Identifies the phases present and the order of their connection on
    this winding (end) of the transformer. In some use cases, such as open-wye,
    open-delta transformers and single-phase, center-tap secondary transformers,
    the order of phase connection is important, so the OrderedPhaseCodeKind
    enumeration is used instead of PhaseCode.
    '''
    
    TransformerTank: Optional[TransformerTank] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerTank.TransformerTankEnds',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer this winding belongs to.
            '''
        
        })
    '''
    Transformer this winding belongs to.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerMeshImpedance(IdentifiedObject):
    '''
    Transformer mesh impedance (Delta-model) between transformer ends.
    The typical case is that this class describes the impedance between two
    transformer ends pair-wise, i.e. the cardinalities at both tranformer end
    associations are 1. But in cases where two or more transformer ends are
    modeled the cardinalities are larger than 1.
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Resistance between the 'from' and the 'to' end, seen from the 'from' end.
            '''
        
        })
    '''
    Resistance between the 'from' and the 'to' end, seen from the 'from'
    end.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero-sequence resistance between the 'from' and the 'to' end, seen from
            the 'from' end.
            '''
        
        })
    '''
    Zero-sequence resistance between the 'from' and the 'to' end, seen
    from the 'from' end.
    '''
    
    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reactance between the 'from' and the 'to' end, seen from the 'from' end.
            '''
        
        })
    '''
    Reactance between the 'from' and the 'to' end, seen from the 'from'
    end.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero-sequence reactance between the 'from' and the 'to' end, seen from
            the 'from' end.
            '''
        
        })
    '''
    Zero-sequence reactance between the 'from' and the 'to' end, seen from
    the 'from' end.
    '''
    
    FromTransformerEnd: Optional[TransformerEnd] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEnd.FromMeshImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            From end this mesh impedance is connected to. It determines the voltage
            reference.
            '''
        
        })
    '''
    From end this mesh impedance is connected to. It determines the voltage
    reference.
    '''
    
    FromTransformerEndInfo: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.FromMeshImpedances',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            'from' transformer end datasheet this mesh impedance is calculated from.
            It determines the voltage reference.
            '''
        
        })
    '''
    'from' transformer end datasheet this mesh impedance is calculated
    from. It determines the voltage reference.
    '''
    
    ToTransformerEnd: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.ToMeshImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All transformer ends this mesh impedance is connected to.
            '''
        
        })
    '''
    All transformer ends this mesh impedance is connected to.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class TransformerStarImpedance(IdentifiedObject):
    '''
    Transformer star impedance (Pi-model) that accurately reflects impedance
    for transformers with 2 or 3 windings. For transformers with 4 or more
    windings, you must use TransformerMeshImpedance class.
    For transmission networks use PowerTransformerEnd impedances (r, r0, x,
    x0, b, b0, g and g0).
    '''

    r: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Resistance of the transformer end.
            '''
        
        })
    '''
    Resistance of the transformer end.
    '''
    
    r0: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    x: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence series reactance of the transformer end.
            '''
        
        })
    '''
    Positive sequence series reactance of the transformer end.
    '''
    
    x0: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence series reactance of the transformer end.
            '''
        
        })
    '''
    Zero sequence series reactance of the transformer end.
    '''
    
    TransformerEndInfo: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.TransformerStarImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer end datasheet used to calculate this transformer star impedance.
            '''
        
        })
    '''
    Transformer end datasheet used to calculate this transformer star impedance.
    '''
    
    TransformerEnd: list[TransformerEnd] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEnd.StarImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All transformer ends having this star impedance.
            '''
        
        })
    '''
    All transformer ends having this star impedance.
    '''
    
    TransformerEndInfo: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.TransformerStarImpedance',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer end datasheet used to calculate this transformer star impedance.
            '''
        
        })
    '''
    Transformer end datasheet used to calculate this transformer star impedance.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TransformerTest(IdentifiedObject):
    '''
    Test result for transformer ends, such as short-circuit, open-circuit (excitation)
    or no-load test.
    '''

    basePower: Optional[ float | ApparentPower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Base power at which the tests are conducted, usually equal to the rateds
            of one of the involved transformer ends.
            '''
        
        })
    '''
    Base power at which the tests are conducted, usually equal to the rateds
    of one of the involved transformer ends.
    '''
    
    temperature: Optional[ float | Temperature ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Temperature at which the test is conducted.
            '''
        
        })
    '''
    Temperature at which the test is conducted.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class NoLoadTest(TransformerTest):
    '''
    No-load test results determine core admittance parameters. They include
    exciting current and core loss measurements from applying voltage to one
    winding. The excitation may be positive sequence or zero sequence. The
    test may be repeated at different voltages to measure saturation.
    '''

    energisedEndVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Voltage applied to the winding (end) during test.
            '''
        
        })
    '''
    Voltage applied to the winding (end) during test.
    '''
    
    excitingCurrent: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Exciting current measured from a positive-sequence or single-phase excitation
            test.
            '''
        
        })
    '''
    Exciting current measured from a positive-sequence or single-phase
    excitation test.
    '''
    
    excitingCurrentZero: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Exciting current measured from a zero-sequence open-circuit excitation
            test.
            '''
        
        })
    '''
    Exciting current measured from a zero-sequence open-circuit excitation
    test.
    '''
    
    loss: Optional[ float | KiloActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Losses measured from a positive-sequence or single-phase excitation test.
            '''
        
        })
    '''
    Losses measured from a positive-sequence or single-phase excitation
    test.
    '''
    
    lossZero: Optional[ float | KiloActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Losses measured from a zero-sequence excitation test.
            '''
        
        })
    '''
    Losses measured from a zero-sequence excitation test.
    '''
    
    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.EnergisedEndNoLoadTests',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer end that current is applied to in this no-load test.
            '''
        
        })
    '''
    Transformer end that current is applied to in this no-load test.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class OpenCircuitTest(TransformerTest):
    '''
    Open-circuit test results verify winding turn ratios and phase shifts.
    They include induced voltage and phase shift measurements on open-circuit
    windings, with voltage applied to the energised end. For three-phase windings,
    the excitation can be a positive sequence (the default) or a zero sequence.
    '''

    energisedEndStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Tap step number for the energised end of the test pair.
            '''
        
        })
    '''
    Tap step number for the energised end of the test pair.
    '''
    
    openEndStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Tap step number for the open end of the test pair.
            '''
        
        })
    '''
    Tap step number for the open end of the test pair.
    '''
    
    energisedEndVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Voltage applied to the winding (end) during test.
            '''
        
        })
    '''
    Voltage applied to the winding (end) during test.
    '''
    
    openEndVoltage: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Voltage measured at the open-circuited end, with the energised end set
            to rated voltage and all other ends open.
            '''
        
        })
    '''
    Voltage measured at the open-circuited end, with the energised end
    set to rated voltage and all other ends open.
    '''
    
    phaseShift: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Phase shift measured at the open end with the energised end set to rated
            voltage and all other ends open.
            '''
        
        })
    '''
    Phase shift measured at the open end with the energised end set to
    rated voltage and all other ends open.
    '''
    
    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.EnergisedEndOpenCircuitTests',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer end that current is applied to in this open-circuit test.
            '''
        
        })
    '''
    Transformer end that current is applied to in this open-circuit test.
    '''
    
    OpenEnd: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.OpenEndOpenCircuitTests',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer end measured for induced voltage and angle in this open-circuit
            test.
            '''
        
        })
    '''
    Transformer end measured for induced voltage and angle in this open-circuit
    test.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class ShortCircuitTest(TransformerTest):
    '''
    Short-circuit test results determine mesh impedance parameters. They include
    load losses and leakage impedances. For three-phase windings, the excitation
    can be a positive sequence (the default) or a zero sequence. There shall
    be at least one grounded winding.
    '''

    energisedEndStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Tap step number for the energised end of the test pair.
            '''
        
        })
    '''
    Tap step number for the energised end of the test pair.
    '''
    
    groundedEndStep: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Tap step number for the grounded end of the test pair.
            '''
        
        })
    '''
    Tap step number for the grounded end of the test pair.
    '''
    
    leakageImpedance: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Leakage impedance measured from a positive-sequence or single-phase short-circuit
            test.
            '''
        
        })
    '''
    Leakage impedance measured from a positive-sequence or single-phase
    short-circuit test.
    '''
    
    leakageImpedanceZero: Optional[ float | Impedance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Leakage impedance measured from a zero-sequence short-circuit test.
            '''
        
        })
    '''
    Leakage impedance measured from a zero-sequence short-circuit test.
    '''
    
    loss: Optional[ float | KiloActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Load losses from a positive-sequence or single-phase short-circuit test.
            '''
        
        })
    '''
    Load losses from a positive-sequence or single-phase short-circuit
    test.
    '''
    
    lossZero: Optional[ float | KiloActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Load losses from a zero-sequence short-circuit test.
            '''
        
        })
    '''
    Load losses from a zero-sequence short-circuit test.
    '''
    
    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TransformerEndInfo.EnergisedEndShortCircuitTests',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Transformer end that voltage is applied to in this short-circuit test.
            The test voltage is chosen to induce rated current in the energised end.
            '''
        
        })
    '''
    Transformer end that voltage is applied to in this short-circuit test.
    The test voltage is chosen to induce rated current in the energised
    end.
    '''
    
    GroundedEnds: list[TransformerEndInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'TransformerEndInfo.GroundedEndShortCircuitTests',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All ends short-circuited in this short-circuit test.
            '''
        
        })
    '''
    All ends short-circuited in this short-circuit test.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class UsagePoint(IdentifiedObject):
    '''
    Logical or physical point in the network to which readings or events may
    be attributed. Used at the place where a physical or virtual meter may
    be located; however, it is not required that a meter be present.
    '''

    Equipments: list[Equipment] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Equipment.UsagePoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All equipment connecting this usage point to the electrical grid.
            '''
        
        })
    '''
    All equipment connecting this usage point to the electrical grid.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Metering'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.OfAggregate)
@dataclass(repr=False)
class ValueAliasSet(IdentifiedObject):
    '''
    Describes the translation of a set of values into a name and is intendend
    to facilitate cusom translations. Each ValueAliasSet has a name, description
    etc. A specific Measurement may represent a discrete state like Open, Closed,
    Intermediate etc. This requires a translation from the MeasurementValue.value
    number to a string, e.g. 0-&gt;"Invalid", 1-&gt;"Open", 2-&gt;"Closed",
    3-&gt;"Intermediate". Each ValueToAlias member in ValueAliasSet.Value describe
    a mapping for one particular value to a name.
    '''

    Commands: list[Command] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Command.ValueAliasSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Commands using the set for translation.
            '''
        
        })
    '''
    The Commands using the set for translation.
    '''
    
    Discretes: list[Discrete] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Discrete.ValueAliasSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Measurements using the set for translation.
            '''
        
        })
    '''
    The Measurements using the set for translation.
    '''
    
    RaiseLowerCommands: list[RaiseLowerCommand] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'RaiseLowerCommand.ValueAliasSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The Commands using the set for translation.
            '''
        
        })
    '''
    The Commands using the set for translation.
    '''
    
    Values: list[ValueToAlias] = field(
        default_factory=list,
        metadata={
        'type': 'AggregateOf',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'ValueToAlias.ValueAliasSet',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The ValueToAlias mappings included in the set.
            '''
        
        })
    '''
    The ValueToAlias mappings included in the set.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class ValueToAlias(IdentifiedObject):
    '''
    Describes the translation of one particular value into a name, e.g. 1 as
    "Open".
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The value that is mapped.
            '''
        
        })
    '''
    The value that is mapped.
    '''
    
    ValueAliasSet: Optional[ValueAliasSet] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ValueAliasSet.Values',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The ValueAliasSet having the ValueToAlias mappings.
            '''
        
        })
    '''
    The ValueAliasSet having the ValueToAlias mappings.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class WirePosition(IdentifiedObject):
    '''
    Identification, spacing and configuration of the wires of a conductor with
    respect to a structure.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Numbering for wires on a WireSpacingInfo. Neutrals should be numbered last.
            Multiple circuits on the same pole, tower or right-of-way can be included
            with unique sequence numbers for the phases, and identical sequence numbers
            for any shared neutrals.
            '''
        
        })
    '''
    Numbering for wires on a WireSpacingInfo. Neutrals should be numbered
    last. Multiple circuits on the same pole, tower or right-of-way can
    be included with unique sequence numbers for the phases, and identical
    sequence numbers for any shared neutrals.
    '''
    
    xCoord: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Signed horizontal distance from the wire at this position to a common reference
            point.
            '''
        
        })
    '''
    Signed horizontal distance from the wire at this position to a common
    reference point.
    '''
    
    yCoord: Optional[ float | Displacement ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Signed vertical distance from the wire at this position: above ground (positive
            value) or burial depth below ground (negative value).
            '''
        
        })
    '''
    Signed vertical distance from the wire at this position: above ground
    (positive value) or burial depth below ground (negative value).
    '''
    
    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireSpacingInfo.WirePositions',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Wire spacing data this wire position belongs to.
            '''
        
        })
    '''
    Wire spacing data this wire position belongs to.
    '''
    
    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'WirePhaseInfo.WirePosition',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IrregularTimePoint(Identity):
    '''
    TimePoints for a schedule where the time between the points varies.
    '''

    value1: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The first value at the time. The meaning of the value is defined by the
            derived type of the associated schedule.
            '''
        
        })
    '''
    The first value at the time. The meaning of the value is defined by
    the derived type of the associated schedule.
    '''
    
    value2: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The second value at the time. The meaning of the value is defined by the
            derived type of the associated schedule.
            '''
        
        })
    '''
    The second value at the time. The meaning of the value is defined by
    the derived type of the associated schedule.
    '''
    
    time: Optional[ float | Seconds ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The time is relative to the schedule starting time.
            '''
        
        })
    '''
    The time is relative to the schedule starting time.
    '''
    
    IntervalSchedule: Optional[IrregularIntervalSchedule] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IrregularIntervalSchedule.TimePoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            An IrregularTimePoint belongs to an IrregularIntervalSchedule.
            '''
        
        })
    '''
    An IrregularTimePoint belongs to an IrregularIntervalSchedule.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Name(Identity):
    '''
    The Name class provides the means to define any number of human readable
    names for an object. A name is <b>not</b> to be used for defining inter-object
    relationships. For inter-object relationships instead use the object identification
    'mRID'.
    '''

    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Any free text that name the object.
            '''
        
        })
    '''
    Any free text that name the object.
    '''
    
    IdentifiedObject: Optional[IdentifiedObject] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'IdentifiedObject.Names',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Identified object that this name designates.
            '''
        
        })
    '''
    Identified object that this name designates.
    '''
    
    NameType: Optional[NameType] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NameType.Names',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Type of this name.
            '''
        
        })
    '''
    Type of this name.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class NameType(Identity):
    '''
    Type of name. Possible values for attribute 'name' are implementation dependent
    but standard profiles may specify types. An enterprise may have multiple
    IT systems each having its own local name for the same object, e.g. a planning
    system may have different names from an EMS. An object may also have different
    names within the same IT system, e.g. localName as defined in CIM version
    14. The definition from CIM14 is:
    The localName is a human readable name of the object. It is a free text
    name local to a node in a naming hierarchy similar to a file directory
    structure. A power system related naming hierarchy may be: Substation,
    VoltageLevel, Equipment etc. Children of the same parent in such a hierarchy
    have names that typically are unique among them.
    '''

    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Description of the name type.
            '''
        
        })
    '''
    Description of the name type.
    '''
    
    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Name of the name type.
            '''
        
        })
    '''
    Name of the name type.
    '''
    
    NameTypeAuthority: Optional[NameTypeAuthority] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NameTypeAuthority.NameTypes',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Authority responsible for managing names of this type.
            '''
        
        })
    '''
    Authority responsible for managing names of this type.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    Names: list[Name] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'Name.NameType',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All names of this type.
            '''
        
        })
    '''
    All names of this type.
    '''
    
@dataclass(repr=False)
class NameTypeAuthority(Identity):
    '''
    Authority responsible for creation and management of names of a given type;
    typically an organization or an enterprise system.
    '''

    description: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Description of the name type authority.
            '''
        
        })
    '''
    Description of the name type authority.
    '''
    
    name: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Name of the name type authority.
            '''
        
        })
    '''
    Name of the name type authority.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
    NameTypes: list[NameType] = field(
        default_factory=list,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': 'unbounded',
        'inverse': 'NameType.NameTypeAuthority',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            All name types managed by this authority.
            '''
        
        })
    '''
    All name types managed by this authority.
    '''
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class NonlinearShuntCompensatorPhasePoint(Identity):
    '''
    A per phase non linear shunt compensator bank or section admittance value.
    '''

    sectionNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The number of the section.
            '''
        
        })
    '''
    The number of the section.
    '''
    
    b: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance per section
            '''
        
        })
    '''
    Positive sequence shunt (charging) susceptance per section
    '''
    
    g: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance per section
            '''
        
        })
    '''
    Positive sequence shunt (charging) conductance per section
    '''
    
    NonlinearShuntCompensatorPhase: Optional[NonlinearShuntCompensatorPhase] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NonlinearShuntCompensatorPhase.NonlinearShuntCompensatorPhasePoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Non-linear shunt compensator phase owning this point.
            '''
        
        })
    '''
    Non-linear shunt compensator phase owning this point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class NonlinearShuntCompensatorPoint(Identity):
    '''
    A non linear shunt compensator bank or section admittance value.
    '''

    sectionNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The number of the section.
            '''
        
        })
    '''
    The number of the section.
    '''
    
    b: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence shunt (charging) susceptance per section
            '''
        
        })
    '''
    Positive sequence shunt (charging) susceptance per section
    '''
    
    b0: Optional[ float | Susceptance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence shunt (charging) susceptance per section
            '''
        
        })
    '''
    Zero sequence shunt (charging) susceptance per section
    '''
    
    g: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Positive sequence shunt (charging) conductance per section
            '''
        
        })
    '''
    Positive sequence shunt (charging) conductance per section
    '''
    
    g0: Optional[ float | Conductance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero sequence shunt (charging) conductance per section
            '''
        
        })
    '''
    Zero sequence shunt (charging) conductance per section
    '''
    
    NonlinearShuntCompensator: Optional[NonlinearShuntCompensator] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'NonlinearShuntCompensator.NonlinearShuntCompensatorPoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Non-linear shunt compensator owning this point.
            '''
        
        })
    '''
    Non-linear shunt compensator owning this point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class OperatingShare(Identity):
    '''
    Specifies the operations contract relationship between a power system resource
    and a contract participant.
    '''

    percentage: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Percentage operational ownership between the pair (power system resource
            and operatging participant) associated with this share. The total percentage
            ownership for a power system resource should add to 100%.
            '''
        
        })
    '''
    Percentage operational ownership between the pair (power system resource
    and operatging participant) associated with this share. The total percentage
    ownership for a power system resource should add to 100%.
    '''
    
    OperatingParticipant: Optional[OperatingParticipant] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'OperatingParticipant.OperatingShare',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The operating participant having this share with the associated power system
            resource.
            '''
        
        })
    '''
    The operating participant having this share with the associated power
    system resource.
    '''
    
    PowerSystemResource: Optional[PowerSystemResource] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PowerSystemResource.OperatingShare',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The power system resource to which the share applies.
            '''
        
        })
    '''
    The power system resource to which the share applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Concrete)
@dataclass(repr=False)
class PhaseImpedanceData(Identity):
    '''
    Impedance and conductance matrix element values.
    The diagonal elements are described by the elements having the same toPhase
    and fromPhase value and the off diagonal elements have different toPhase
    and fromPhase values. The matrix can also be stored in symmetric lower
    triangular format using the row and column attributes, which map to ACLineSegmentPhase.sequenceNumber.
    '''

    column: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            This matrix element's column number, in the range 1 to row. Only the lower
            triangle needs to be stored. Neutrals should be numbered last. Multiple
            circuits on the same pole, tower or right-of-way can be included with unique
            sequence numbers for the phases, and identical sequence numbers for any
            shared neutrals. This solumn number matches ACLineSegmentPhase.sequenceNumber,
            WirePosition.sequenceNumber and WirePhaseInfo.sequenceNumber as applicable..
            '''
        
        })
    '''
    This matrix element's column number, in the range 1 to row. Only the
    lower triangle needs to be stored. Neutrals should be numbered last.
    Multiple circuits on the same pole, tower or right-of-way can be included
    with unique sequence numbers for the phases, and identical sequence
    numbers for any shared neutrals. This solumn number matches ACLineSegmentPhase.sequenceNumber,
    WirePosition.sequenceNumber and WirePhaseInfo.sequenceNumber as applicable..
    '''
    
    row: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            This matrix element's row number, in the range 1 to PerLengthPhaseImpedance.conductorCount.
            Only the lower triangle needs to be stored. Neutrals should be numbered
            last. Multiple circuits on the same pole, tower or right-of-way can be
            included with unique sequence numbers for the phases, and identical sequence
            numbers for any shared neutrals. This row number matches ACLineSegmentPhase.sequenceNumber,
            WirePosition.sequenceNumber and WirePhaseInfo.sequenceNumber as applicable..
            '''
        
        })
    '''
    This matrix element's row number, in the range 1 to PerLengthPhaseImpedance.conductorCount.
    Only the lower triangle needs to be stored. Neutrals should be numbered
    last. Multiple circuits on the same pole, tower or right-of-way can
    be included with unique sequence numbers for the phases, and identical
    sequence numbers for any shared neutrals. This row number matches ACLineSegmentPhase.sequenceNumber,
    WirePosition.sequenceNumber and WirePhaseInfo.sequenceNumber as applicable..
    '''
    
    b: Optional[ float | SusceptancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Susceptance matrix element value, per length of unit.
            '''
        
        })
    '''
    Susceptance matrix element value, per length of unit.
    '''
    
    g: Optional[ float | ConductancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Conductance matrix element value, per length of unit.
            '''
        
        })
    '''
    Conductance matrix element value, per length of unit.
    '''
    
    r: Optional[ float | ResistancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Resistance matrix element value, per length of unit.
            '''
        
        })
    '''
    Resistance matrix element value, per length of unit.
    '''
    
    x: Optional[ float | ReactancePerLength ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Reactance matrix element value, per length of unit.
            '''
        
        })
    '''
    Reactance matrix element value, per length of unit.
    '''
    
    PhaseImpedance: Optional[PerLengthPhaseImpedance] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PerLengthPhaseImpedance.PhaseImpedanceData',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Conductor phase impedance to which this data belongs.
            '''
        
        })
    '''
    Conductor phase impedance to which this data belongs.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PositionPoint(Identity):
    '''
    Set of spatial coordinates that determine a point, defined in the coordinate
    system specified in 'Location.CoordinateSystem'. Use a single position
    point instance to desribe a point-oriented location. Use a sequence of
    position points to describe a line-oriented object (physical location of
    non-point oriented objects like cables or lines), or area of an object
    (like a substation or a geographical zone - in this case, have first and
    last position point with the same values).
    '''

    groupNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero-relative sequence number of this group within a series of points;
            used when there is a need to express disjoint groups of points that are
            considered to be part of a single location.
            '''
        
        })
    '''
    Zero-relative sequence number of this group within a series of points;
    used when there is a need to express disjoint groups of points that
    are considered to be part of a single location.
    '''
    
    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Zero-relative sequence number of this point within a series of points.
            '''
        
        })
    '''
    Zero-relative sequence number of this point within a series of points.
    '''
    
    xPosition: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            X axis position.
            '''
        
        })
    '''
    X axis position.
    '''
    
    yPosition: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Y axis position.
            '''
        
        })
    '''
    Y axis position.
    '''
    
    zPosition: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            (if applicable) Z axis position.
            '''
        
        })
    '''
    (if applicable) Z axis position.
    '''
    
    Location: Optional[Location] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Location.PositionPoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Location described by this position point.
            '''
        
        })
    '''
    Location described by this position point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Common'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class Quality61850(Identity):
    '''
    Quality flags in this class are as defined in IEC 61850, except for estimatorReplaced,
    which has been included in this class for convenience.
    '''

    badReference: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Measurement value may be incorrect due to a reference being out of calibration.
            '''
        
        })
    '''
    Measurement value may be incorrect due to a reference being out of
    calibration.
    '''
    
    estimatorReplaced: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Value has been replaced by State Estimator. estimatorReplaced is not an
            IEC61850 quality bit but has been put in this class for convenience.
            '''
        
        })
    '''
    Value has been replaced by State Estimator. estimatorReplaced is not
    an IEC61850 quality bit but has been put in this class for convenience.
    '''
    
    failure: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            This identifier indicates that a supervision function has detected an internal
            or external failure, e.g. communication failure.
            '''
        
        })
    '''
    This identifier indicates that a supervision function has detected
    an internal or external failure, e.g. communication failure.
    '''
    
    oldData: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Measurement value is old and possibly invalid, as it has not been successfully
            updated during a specified time interval.
            '''
        
        })
    '''
    Measurement value is old and possibly invalid, as it has not been successfully
    updated during a specified time interval.
    '''
    
    operatorBlocked: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Measurement value is blocked and hence unavailable for transmission.
            '''
        
        })
    '''
    Measurement value is blocked and hence unavailable for transmission.
    '''
    
    oscillatory: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            To prevent some overload of the communication it is sensible to detect
            and suppress oscillating (fast changing) binary inputs. If a signal changes
            in a defined time (tosc) twice in the same direction (from 0 to 1 or from
            1 to 0) then oscillation is detected and the detail quality identifier
            "oscillatory" is set. If it is detected a configured numbers of transient
            changes could be passed by. In this time the validity status "questionable"
            is set. If after this defined numbers of changes the signal is still in
            the oscillating state the value shall be set either to the opposite state
            of the previous stable value or to a defined default value. In this case
            the validity status "questionable" is reset and "invalid" is set as long
            as the signal is oscillating. If it is configured such that no transient
            changes should be passed by then the validity status "invalid" is set immediately
            in addition to the detail quality identifier "oscillatory" (used for status
            information only).
            '''
        
        })
    '''
    To prevent some overload of the communication it is sensible to detect
    and suppress oscillating (fast changing) binary inputs. If a signal
    changes in a defined time (tosc) twice in the same direction (from
    0 to 1 or from 1 to 0) then oscillation is detected and the detail
    quality identifier "oscillatory" is set. If it is detected a configured
    numbers of transient changes could be passed by. In this time the validity
    status "questionable" is set. If after this defined numbers of changes
    the signal is still in the oscillating state the value shall be set
    either to the opposite state of the previous stable value or to a defined
    default value. In this case the validity status "questionable" is reset
    and "invalid" is set as long as the signal is oscillating. If it is
    configured such that no transient changes should be passed by then
    the validity status "invalid" is set immediately in addition to the
    detail quality identifier "oscillatory" (used for status information
    only).
    '''
    
    outOfRange: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Measurement value is beyond a predefined range of value.
            '''
        
        })
    '''
    Measurement value is beyond a predefined range of value.
    '''
    
    overFlow: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Measurement value is beyond the capability of being represented properly.
            For example, a counter value overflows from maximum count back to a value
            of zero.
            '''
        
        })
    '''
    Measurement value is beyond the capability of being represented properly.
    For example, a counter value overflows from maximum count back to a
    value of zero.
    '''
    
    suspect: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A correlation function has detected that the value is not consitent with
            other values. Typically set by a network State Estimator.
            '''
        
        })
    '''
    A correlation function has detected that the value is not consitent
    with other values. Typically set by a network State Estimator.
    '''
    
    test: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Measurement value is transmitted for test purposes.
            '''
        
        })
    '''
    Measurement value is transmitted for test purposes.
    '''
    
    validity: Optional[ Validity ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Validity of the measurement value.
            '''
        
        })
    '''
    Validity of the measurement value.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.AggregateOf)
@dataclass(repr=False)
class MeasurementValueQuality(Quality61850):
    '''
    Measurement quality flags. Bits 0-10 are defined for substation automation
    in draft IEC 61850 part 7-3. Bits 11-15 are reserved for future expansion
    by that document. Bits 16-31 are reserved for EMS applications.
    '''

    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.MeasurementValueQuality',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''
        
        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''
    
    MeasurementValue: Optional[MeasurementValue] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'MeasurementValue.MeasurementValueQuality',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            A MeasurementValue has a MeasurementValueQuality associated with it.
            '''
        
        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RegularTimePoint(Identity):
    '''
    Time point for a schedule where the time between the consecutive points
    is constant.
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The position of the regular time point in the sequence. Note that time
            points don't have to be sequential, i.e. time points may be omitted. The
            actual time for a RegularTimePoint is computed by multiplying the associated
            regular interval schedule's time step with the regular time point sequence
            number and adding the associated schedules start time.
            '''
        
        })
    '''
    The position of the regular time point in the sequence. Note that time
    points don't have to be sequential, i.e. time points may be omitted.
    The actual time for a RegularTimePoint is computed by multiplying the
    associated regular interval schedule's time step with the regular time
    point sequence number and adding the associated schedules start time.
    '''
    
    value1: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The first value at the time. The meaning of the value is defined by the
            derived type of the associated schedule.
            '''
        
        })
    '''
    The first value at the time. The meaning of the value is defined by
    the derived type of the associated schedule.
    '''
    
    value2: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The second value at the time. The meaning of the value is defined by the
            derived type of the associated schedule.
            '''
        
        })
    '''
    The second value at the time. The meaning of the value is defined by
    the derived type of the associated schedule.
    '''
    
    IntervalSchedule: Optional[RegularIntervalSchedule] = field(
        default=None,
        metadata={
        'type': 'OfAggregate',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RegularIntervalSchedule.TimePoints',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Regular interval schedule containing this time point.
            '''
        
        })
    '''
    Regular interval schedule containing this time point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StateVariable(Identity):
    '''
    An abstract class for state variables.
    '''

    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvInjection(StateVariable):
    '''
    The SvInjection is reporting the calculated bus injection minus the sum
    of the terminal flows. The terminal flow is positive out from the bus (load
    sign convention) and bus injection has positive flow into the bus. SvInjection
    may have the remainder after state estimation or slack after power flow
    calculation.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The terminal phase at which the connection is applied. If missing, the
            injection is assumed to be balanced among non-neutral phases.
            '''
        
        })
    '''
    The terminal phase at which the connection is applied. If missing,
    the injection is assumed to be balanced among non-neutral phases.
    '''
    
    pInjection: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The active power mismatch between calculated injection and initial injection.
            Positive sign means injection into the TopologicalNode (bus).
            '''
        
        })
    '''
    The active power mismatch between calculated injection and initial
    injection. Positive sign means injection into the TopologicalNode (bus).
    '''
    
    qInjection: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reactive power mismatch between calculated injection and initial injection.
            Positive sign means injection into the TopologicalNode (bus).
            '''
        
        })
    '''
    The reactive power mismatch between calculated injection and initial
    injection. Positive sign means injection into the TopologicalNode (bus).
    '''
    
    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.SvInjection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.SvInjection',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The topological node associated with the flow injection state variable.
            '''
        
        })
    '''
    The topological node associated with the flow injection state variable.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvPowerFlow(StateVariable):
    '''
    State variable for power flow. Load convention is used for flow direction.
    This means flow out from the TopologicalNode into the equipment is positive.
    '''

    p: Optional[ float | ActivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The active power flow. Load sign convention is used, i.e. positive sign
            means flow out from a TopologicalNode (bus) into the conducting equipment.
            '''
        
        })
    '''
    The active power flow. Load sign convention is used, i.e. positive
    sign means flow out from a TopologicalNode (bus) into the conducting
    equipment.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The individual phase of the flow. If unspecified, then assumed to be balanced
            among phases.
            '''
        
        })
    '''
    The individual phase of the flow. If unspecified, then assumed to be
    balanced among phases.
    '''
    
    q: Optional[ float | ReactivePower ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reactive power flow. Load sign convention is used, i.e. positive sign
            means flow out from a TopologicalNode (bus) into the conducting equipment.
            '''
        
        })
    '''
    The reactive power flow. Load sign convention is used, i.e. positive
    sign means flow out from a TopologicalNode (bus) into the conducting
    equipment.
    '''
    
    Terminal: Optional[Terminal] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Terminal.SvPowerFlow',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The terminal associated with the power flow state variable.
            '''
        
        })
    '''
    The terminal associated with the power flow state variable.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvShuntCompensatorSections(StateVariable):
    '''
    State variable for the number of sections in service for a shunt compensator.
    '''

    sections: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The number of sections in service as a continous variable. To get integer
            value scale with ShuntCompensator.bPerSection.
            '''
        
        })
    '''
    The number of sections in service as a continous variable. To get integer
    value scale with ShuntCompensator.bPerSection.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The terminal phase at which the connection is applied. If missing, the
            injection is assumed to be balanced among non-neutral phases.
            '''
        
        })
    '''
    The terminal phase at which the connection is applied. If missing,
    the injection is assumed to be balanced among non-neutral phases.
    '''
    
    ShuntCompensator: Optional[ShuntCompensator] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensator.SvShuntCompensatorSections',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The shunt compensator for which the state applies.
            '''
        
        })
    '''
    The shunt compensator for which the state applies.
    '''
    
    ShuntCompensator: Optional[ShuntCompensator] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ShuntCompensator.SvShuntCompensatorSections',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The shunt compensator for which the state applies.
            '''
        
        })
    '''
    The shunt compensator for which the state applies.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvStatus(StateVariable):
    '''
    State variable for status.
    '''

    inService: Optional[bool] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The in service status as a result of topology processing.
            '''
        
        })
    '''
    The in service status as a result of topology processing.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The individual phase status. If the attribute is unspecified, then three
            phase model is assumed.
            '''
        
        })
    '''
    The individual phase status. If the attribute is unspecified, then
    three phase model is assumed.
    '''
    
    ConductingEquipment: Optional[ConductingEquipment] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConductingEquipment.SvStatus',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The conducting equipment associated with the status state variable.
            '''
        
        })
    '''
    The conducting equipment associated with the status state variable.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvSwitch(StateVariable):
    '''
    State variable for switch.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The terminal phase at which the connection is applied. If missing, the
            injection is assumed to be balanced among non-neutral phases.
            '''
        
        })
    '''
    The terminal phase at which the connection is applied. If missing,
    the injection is assumed to be balanced among non-neutral phases.
    '''
    
    Switch: Optional[Switch] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Switch.SvSwitch',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The switch associated with the switch state.
            '''
        
        })
    '''
    The switch associated with the switch state.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvTapStep(StateVariable):
    '''
    State variable for transformer tap step.
    '''

    position: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The floating point tap position. This is not the tap ratio, but rather
            the tap step position as defined by the related tap changer model and normally
            is constrained to be within the range of minimum and maximum tap positions.
            '''
        
        })
    '''
    The floating point tap position. This is not the tap ratio, but rather
    the tap step position as defined by the related tap changer model and
    normally is constrained to be within the range of minimum and maximum
    tap positions.
    '''
    
    TapChanger: Optional[TapChanger] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TapChanger.SvTapStep',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The tap changer associated with the tap step state.
            '''
        
        })
    '''
    The tap changer associated with the tap step state.
    '''
    
    TapChanger: Optional[TapChanger] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TapChanger.SvTapStep',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The tap changer associated with the tap step state.
            '''
        
        })
    '''
    The tap changer associated with the tap step state.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvVoltage(StateVariable):
    '''
    State variable for voltage.
    '''

    angle: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The voltage angle of the topological node complex voltage with respect
            to system reference.
            '''
        
        })
    '''
    The voltage angle of the topological node complex voltage with respect
    to system reference.
    '''
    
    phase: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            If specified the voltage is the line to ground voltage of the individual
            phase. If unspecified, then the voltage is assumed balanced.
            '''
        
        })
    '''
    If specified the voltage is the line to ground voltage of the individual
    phase. If unspecified, then the voltage is assumed balanced.
    '''
    
    v: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The voltage magnitude at the topological node.
            '''
        
        })
    '''
    The voltage magnitude at the topological node.
    '''
    
    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.SvVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    TopologicalNode: Optional[TopologicalNode] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'TopologicalNode.SvVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The topological node associated with the voltage state.
            '''
        
        })
    '''
    The topological node associated with the voltage state.
    '''
    
    ConnectivityNode: Optional[ConnectivityNode] = field(
        default=None,
        metadata={
        'type': 'Association',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'ConnectivityNode.SvVoltage',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class SvEstVoltage(SvVoltage):
    '''
    '''

    angleVariance: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    vVariance: Optional[ float | Voltage ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    Estimate: Optional[Estimate] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'Estimate.SvEstVoltages',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'StateVariables'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TapChangerTablePoint(Identity):
    '''
    '''

    ratio: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The voltage at the tap step divided by rated voltage of the transformer
            end having the tap changer. Hence this is a value close to one.
            For example, if the ratio at step 1 is 1.01, and the rated voltage of the
            transformer end is 110kV, then the voltage obtained by setting the tap
            changer to step 1 to is 111.1kV.
            '''
        
        })
    '''
    The voltage at the tap step divided by rated voltage of the transformer
    end having the tap changer. Hence this is a value close to one.
    For example, if the ratio at step 1 is 1.01, and the rated voltage
    of the transformer end is 110kV, then the voltage obtained by setting
    the tap changer to step 1 to is 111.1kV.
    '''
    
    step: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The tap step.
            '''
        
        })
    '''
    The tap step.
    '''
    
    b: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The magnetizing branch susceptance deviation in percent of nominal value.
            The actual susceptance is calculated as follows:
            calculated magnetizing susceptance = b(nominal) * (1 + b(from this class)/100).
            The b(nominal) is defined as the static magnetizing susceptance on the
            associated power transformer end or ends. This model assumes the star impedance
            (pi model) form.
            '''
        
        })
    '''
    The magnetizing branch susceptance deviation in percent of nominal
    value. The actual susceptance is calculated as follows:
    calculated magnetizing susceptance = b(nominal) * (1 + b(from this
    class)/100). The b(nominal) is defined as the static magnetizing susceptance
    on the associated power transformer end or ends. This model assumes
    the star impedance (pi model) form.
    '''
    
    g: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The magnetizing branch conductance deviation in percent of nominal value.
            The actual conductance is calculated as follows:
            calculated magnetizing conductance = g(nominal) * (1 + g(from this class)/100).
            The g(nominal) is defined as the static magnetizing conductance on the
            associated power transformer end or ends. This model assumes the star impedance
            (pi model) form.
            '''
        
        })
    '''
    The magnetizing branch conductance deviation in percent of nominal
    value. The actual conductance is calculated as follows:
    calculated magnetizing conductance = g(nominal) * (1 + g(from this
    class)/100). The g(nominal) is defined as the static magnetizing conductance
    on the associated power transformer end or ends. This model assumes
    the star impedance (pi model) form.
    '''
    
    r: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The resistance deviation in percent of nominal value. The actual reactance
            is calculated as follows:
            calculated resistance = r(nominal) * (1 + r(from this class)/100). The
            r(nominal) is defined as the static resistance on the associated power
            transformer end or ends. This model assumes the star impedance (pi model)
            form.
            '''
        
        })
    '''
    The resistance deviation in percent of nominal value. The actual reactance
    is calculated as follows:
    calculated resistance = r(nominal) * (1 + r(from this class)/100).
    The r(nominal) is defined as the static resistance on the associated
    power transformer end or ends. This model assumes the star impedance
    (pi model) form.
    '''
    
    x: Optional[ float | PerCent ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The series reactance deviation in percent of nominal value. The actual
            reactance is calculated as follows:
            calculated reactance = x(nominal) * (1 + x(from this class)/100). The x(nominal)
            is defined as the static series reactance on the associated power transformer
            end or ends. This model assumes the star impedance (pi model) form.
            '''
        
        })
    '''
    The series reactance deviation in percent of nominal value. The actual
    reactance is calculated as follows:
    calculated reactance = x(nominal) * (1 + x(from this class)/100). The
    x(nominal) is defined as the static series reactance on the associated
    power transformer end or ends. This model assumes the star impedance
    (pi model) form.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class PhaseTapChangerTablePoint(TapChangerTablePoint):
    '''
    Describes each tap step in the phase tap changer tabular curve.
    '''

    angle: Optional[ float | AngleDegrees ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The angle difference in degrees. A positive value indicates a positive
            phase shift from the winding where the tap is located to the other winding
            (for a two-winding transformer).
            '''
        
        })
    '''
    The angle difference in degrees. A positive value indicates a positive
    phase shift from the winding where the tap is located to the other
    winding (for a two-winding transformer).
    '''
    
    PhaseTapChangerTable: Optional[PhaseTapChangerTable] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'PhaseTapChangerTable.PhaseTapChangerTablePoint',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The table of this point.
            '''
        
        })
    '''
    The table of this point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class RatioTapChangerTablePoint(TapChangerTablePoint):
    '''
    Describes each tap step in the ratio tap changer tabular curve.
    '''

    RatioTapChangerTable: Optional[RatioTapChangerTable] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'RatioTapChangerTable.RatioTapChangerTablePoint',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Table of this point.
            '''
        
        })
    '''
    Table of this point.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class WirePhaseInfo(Identity):
    '''
    '''

    sequenceNumber: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Numbering for wires on a WireSpacingInfo. Neutrals should be numbered last.
            '''
        
        })
    '''
    Numbering for wires on a WireSpacingInfo. Neutrals should be numbered
    last.
    '''
    
    phaseInfo: Optional[ SinglePhaseKind ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireAssemblyInfo.WirePhaseInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WireInfo: Optional[WireInfo] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WireInfo.WirePhaseInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    WirePosition: Optional[WirePosition] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'inverse': 'WirePosition.WirePhaseInfo',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class AsynchronousMachineKind(Enum):
    '''
    Kind of Asynchronous Machine.
    '''

    generator = 'generator'
    '''
    The Asynchronous Machine is a generator.
    '''
    
    motor = 'motor'
    '''
    The Asynchronous Machine is a motor.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class BatteryStateKind(Enum):
    '''
    '''

    charging = 'charging'
    '''
    storedE is increasing
    '''
    
    discharging = 'discharging'
    '''
    storedE is decreasing
    '''
    
    empty = 'empty'
    '''
    unable to Discharge, and not Charging
    '''
    
    full = 'full'
    '''
    unable to Charge, and not Discharging
    '''
    
    waiting = 'waiting'
    '''
    neither Charging nor Discharging, but able to do so
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class BreakerConfiguration(Enum):
    '''
    Switching arrangement for bay.
    '''

    breakerAndAHalf = 'breakerAndAHalf'
    '''
    Breaker and a half.
    '''
    
    doubleBreaker = 'doubleBreaker'
    '''
    Double breaker.
    '''
    
    noBreaker = 'noBreaker'
    '''
    No breaker.
    '''
    
    singleBreaker = 'singleBreaker'
    '''
    Single breaker.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class BusbarConfiguration(Enum):
    '''
    Busbar layout for bay.
    '''

    doubleBus = 'doubleBus'
    '''
    Double bus.
    '''
    
    mainWithTransfer = 'mainWithTransfer'
    '''
    Main bus with transfer bus.
    '''
    
    ringBus = 'ringBus'
    '''
    Ring bus.
    '''
    
    singleBus = 'singleBus'
    '''
    Single bus.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class BushingInsulationKind(Enum):
    '''
    Insulation kind for bushings.
    '''

    compound = 'compound'
    '''
    '''
    
    oilImpregnatedPaper = 'oilImpregnatedPaper'
    '''
    &lt;was paperoil&gt;.
    '''
    
    other = 'other'
    '''
    '''
    
    resinBondedPaper = 'resinBondedPaper'
    '''
    '''
    
    resinImpregnatedPaper = 'resinImpregnatedPaper'
    '''
    '''
    
    solidPorcelain = 'solidPorcelain'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class CableConstructionKind(Enum):
    '''
    Kind of cable construction.
    '''

    compacted = 'compacted'
    '''
    Compacted cable.
    '''
    
    compressed = 'compressed'
    '''
    Compressed cable.
    '''
    
    other = 'other'
    '''
    Other kind of cable construction.
    '''
    
    sector = 'sector'
    '''
    Sector cable.
    '''
    
    segmental = 'segmental'
    '''
    Segmental cable.
    '''
    
    solid = 'solid'
    '''
    Solid cable.
    '''
    
    stranded = 'stranded'
    '''
    Stranded cable.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class CableOuterJacketKind(Enum):
    '''
    Kind of cable outer jacket.
    '''

    insulating = 'insulating'
    '''
    Insulating cable outer jacket.
    '''
    
    linearLowDensityPolyethylene = 'linearLowDensityPolyethylene'
    '''
    Linear low density polyethylene cable outer jacket.
    '''
    
    none = 'none'
    '''
    Cable has no outer jacket.
    '''
    
    other = 'other'
    '''
    Pther kind of cable outer jacket.
    '''
    
    polyethylene = 'polyethylene'
    '''
    Polyethylene cable outer jacket.
    '''
    
    pvc = 'pvc'
    '''
    PVC cable outer jacket.
    '''
    
    semiconducting = 'semiconducting'
    '''
    Semiconducting cable outer jacket.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class CableShieldMaterialKind(Enum):
    '''
    Kind of cable shield material.
    '''

    aluminum = 'aluminum'
    '''
    Aluminum cable shield.
    '''
    
    copper = 'copper'
    '''
    Copper cable shield.
    '''
    
    lead = 'lead'
    '''
    Lead cable shield.
    '''
    
    other = 'other'
    '''
    Other kind of cable shield material.
    '''
    
    steel = 'steel'
    '''
    Steel cable shield.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class ContingencyEquipmentStatusKind(Enum):
    '''
    Indicates the state which the contingency equipment is to be in when the
    contingency is applied.
    '''

    inService = 'inService'
    '''
    The equipment is to be put into service.
    '''
    
    outOfService = 'outOfService'
    '''
    The equipment is to be taken out of service.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Contingency'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class ConverterControlModeKind(Enum):
    '''
    '''

    constantPowerFactor = 'constantPowerFactor'
    '''
    hold q/p constant
    '''
    
    constantReactivePower = 'constantReactivePower'
    '''
    Holds constant Q; may change both P and Q by dispatch commands
    '''
    
    dynamic = 'dynamic'
    '''
    use association with DERIEEEType1
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
class CoolantType(Enum):
    '''
    Method of cooling a machine.
    '''

    air = 'air'
    '''
    Air.
    '''
    
    hydrogenGas = 'hydrogenGas'
    '''
    Hydrogen gas.
    '''
    
    water = 'water'
    '''
    Water.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class Currency(Enum):
    '''
    Monetary currencies. ISO 4217 standard including 3-character currency code.
    '''

    AED = 'AED'
    '''
    United Arab Emirates dirham.
    '''
    
    AFN = 'AFN'
    '''
    Afghan afghani.
    '''
    
    ALL = 'ALL'
    '''
    Albanian lek.
    '''
    
    AMD = 'AMD'
    '''
    Armenian dram.
    '''
    
    ANG = 'ANG'
    '''
    Netherlands Antillean guilder.
    '''
    
    AOA = 'AOA'
    '''
    Angolan kwanza.
    '''
    
    ARS = 'ARS'
    '''
    Argentine peso.
    '''
    
    AUD = 'AUD'
    '''
    Australian dollar.
    '''
    
    AWG = 'AWG'
    '''
    Aruban florin.
    '''
    
    AZN = 'AZN'
    '''
    Azerbaijani manat.
    '''
    
    BAM = 'BAM'
    '''
    Bosnia and Herzegovina convertible mark.
    '''
    
    BBD = 'BBD'
    '''
    Barbados dollar.
    '''
    
    BDT = 'BDT'
    '''
    Bangladeshi taka.
    '''
    
    BGN = 'BGN'
    '''
    Bulgarian lev.
    '''
    
    BHD = 'BHD'
    '''
    Bahraini dinar.
    '''
    
    BIF = 'BIF'
    '''
    Burundian franc.
    '''
    
    BMD = 'BMD'
    '''
    Bermudian dollar (customarily known as Bermuda dollar).
    '''
    
    BND = 'BND'
    '''
    Brunei dollar.
    '''
    
    BOB = 'BOB'
    '''
    Boliviano.
    '''
    
    BOV = 'BOV'
    '''
    Bolivian Mvdol (funds code).
    '''
    
    BRL = 'BRL'
    '''
    Brazilian real.
    '''
    
    BSD = 'BSD'
    '''
    Bahamian dollar.
    '''
    
    BTN = 'BTN'
    '''
    Bhutanese ngultrum.
    '''
    
    BWP = 'BWP'
    '''
    Botswana pula.
    '''
    
    BYR = 'BYR'
    '''
    Belarusian ruble.
    '''
    
    BZD = 'BZD'
    '''
    Belize dollar.
    '''
    
    CAD = 'CAD'
    '''
    Canadian dollar
    '''
    
    CDF = 'CDF'
    '''
    Congolese franc.
    '''
    
    CHF = 'CHF'
    '''
    Swiss franc.
    '''
    
    CLF = 'CLF'
    '''
    Unidad de Fomento (funds code), Chile.
    '''
    
    CLP = 'CLP'
    '''
    Chilean peso.
    '''
    
    CNY = 'CNY'
    '''
    Chinese yuan.
    '''
    
    COP = 'COP'
    '''
    Colombian peso.
    '''
    
    COU = 'COU'
    '''
    Unidad de Valor Real.
    '''
    
    CRC = 'CRC'
    '''
    Costa Rican colon.
    '''
    
    CUC = 'CUC'
    '''
    Cuban convertible peso.
    '''
    
    CUP = 'CUP'
    '''
    Cuban peso.
    '''
    
    CVE = 'CVE'
    '''
    Cape Verde escudo.
    '''
    
    CZK = 'CZK'
    '''
    Czech koruna.
    '''
    
    DJF = 'DJF'
    '''
    Djiboutian franc.
    '''
    
    DKK = 'DKK'
    '''
    Danish krone.
    '''
    
    DOP = 'DOP'
    '''
    Dominican peso.
    '''
    
    DZD = 'DZD'
    '''
    Algerian dinar.
    '''
    
    EEK = 'EEK'
    '''
    Estonian kroon.
    '''
    
    EGP = 'EGP'
    '''
    Egyptian pound.
    '''
    
    ERN = 'ERN'
    '''
    Eritrean nakfa.
    '''
    
    ETB = 'ETB'
    '''
    Ethiopian birr.
    '''
    
    EUR = 'EUR'
    '''
    Euro.
    '''
    
    FJD = 'FJD'
    '''
    Fiji dollar.
    '''
    
    FKP = 'FKP'
    '''
    Falkland Islands pound.
    '''
    
    GBP = 'GBP'
    '''
    Pound sterling.
    '''
    
    GEL = 'GEL'
    '''
    Georgian lari.
    '''
    
    GHS = 'GHS'
    '''
    Ghanaian cedi.
    '''
    
    GIP = 'GIP'
    '''
    Gibraltar pound.
    '''
    
    GMD = 'GMD'
    '''
    Gambian dalasi.
    '''
    
    GNF = 'GNF'
    '''
    Guinean franc.
    '''
    
    GTQ = 'GTQ'
    '''
    Guatemalan quetzal.
    '''
    
    GYD = 'GYD'
    '''
    Guyanese dollar.
    '''
    
    HKD = 'HKD'
    '''
    Hong Kong dollar.
    '''
    
    HNL = 'HNL'
    '''
    Honduran lempira.
    '''
    
    HRK = 'HRK'
    '''
    Croatian kuna.
    '''
    
    HTG = 'HTG'
    '''
    Haitian gourde.
    '''
    
    HUF = 'HUF'
    '''
    Hungarian forint.
    '''
    
    IDR = 'IDR'
    '''
    Indonesian rupiah.
    '''
    
    ILS = 'ILS'
    '''
    Israeli new sheqel.
    '''
    
    INR = 'INR'
    '''
    Indian rupee.
    '''
    
    IQD = 'IQD'
    '''
    Iraqi dinar.
    '''
    
    IRR = 'IRR'
    '''
    Iranian rial.
    '''
    
    ISK = 'ISK'
    '''
    Icelandic kr�na.
    '''
    
    JMD = 'JMD'
    '''
    Jamaican dollar.
    '''
    
    JOD = 'JOD'
    '''
    Jordanian dinar.
    '''
    
    JPY = 'JPY'
    '''
    Japanese yen.
    '''
    
    KES = 'KES'
    '''
    Kenyan shilling.
    '''
    
    KGS = 'KGS'
    '''
    Kyrgyzstani som.
    '''
    
    KHR = 'KHR'
    '''
    Cambodian riel.
    '''
    
    KMF = 'KMF'
    '''
    Comoro franc.
    '''
    
    KPW = 'KPW'
    '''
    North Korean won.
    '''
    
    KRW = 'KRW'
    '''
    South Korean won.
    '''
    
    KWD = 'KWD'
    '''
    Kuwaiti dinar.
    '''
    
    KYD = 'KYD'
    '''
    Cayman Islands dollar.
    '''
    
    KZT = 'KZT'
    '''
    Kazakhstani tenge.
    '''
    
    LAK = 'LAK'
    '''
    Lao kip.
    '''
    
    LBP = 'LBP'
    '''
    Lebanese pound.
    '''
    
    LKR = 'LKR'
    '''
    Sri Lanka rupee.
    '''
    
    LRD = 'LRD'
    '''
    Liberian dollar.
    '''
    
    LSL = 'LSL'
    '''
    Lesotho loti.
    '''
    
    LTL = 'LTL'
    '''
    Lithuanian litas.
    '''
    
    LVL = 'LVL'
    '''
    Latvian lats.
    '''
    
    LYD = 'LYD'
    '''
    Libyan dinar.
    '''
    
    MAD = 'MAD'
    '''
    Moroccan dirham.
    '''
    
    MDL = 'MDL'
    '''
    Moldovan leu.
    '''
    
    MGA = 'MGA'
    '''
    Malagasy ariary.
    '''
    
    MKD = 'MKD'
    '''
    Macedonian denar.
    '''
    
    MMK = 'MMK'
    '''
    Myanma kyat.
    '''
    
    MNT = 'MNT'
    '''
    Mongolian tugrik.
    '''
    
    MOP = 'MOP'
    '''
    Macanese pataca.
    '''
    
    MRO = 'MRO'
    '''
    Mauritanian ouguiya.
    '''
    
    MUR = 'MUR'
    '''
    Mauritian rupee.
    '''
    
    MVR = 'MVR'
    '''
    Maldivian rufiyaa.
    '''
    
    MWK = 'MWK'
    '''
    Malawian kwacha.
    '''
    
    MXN = 'MXN'
    '''
    Mexican peso.
    '''
    
    MYR = 'MYR'
    '''
    Malaysian ringgit.
    '''
    
    MZN = 'MZN'
    '''
    Mozambican metical.
    '''
    
    NAD = 'NAD'
    '''
    Namibian dollar.
    '''
    
    NGN = 'NGN'
    '''
    Nigerian naira.
    '''
    
    NIO = 'NIO'
    '''
    Cordoba oro.
    '''
    
    NOK = 'NOK'
    '''
    Norwegian krone.
    '''
    
    NPR = 'NPR'
    '''
    Nepalese rupee.
    '''
    
    NZD = 'NZD'
    '''
    New Zealand dollar.
    '''
    
    OMR = 'OMR'
    '''
    Omani rial.
    '''
    
    PAB = 'PAB'
    '''
    Panamanian balboa.
    '''
    
    PEN = 'PEN'
    '''
    Peruvian nuevo sol.
    '''
    
    PGK = 'PGK'
    '''
    Papua New Guinean kina.
    '''
    
    PHP = 'PHP'
    '''
    Philippine peso.
    '''
    
    PKR = 'PKR'
    '''
    Pakistani rupee.
    '''
    
    PLN = 'PLN'
    '''
    Polish zloty.
    '''
    
    PYG = 'PYG'
    '''
    Paraguayan guaran�.
    '''
    
    QAR = 'QAR'
    '''
    Qatari rial.
    '''
    
    RON = 'RON'
    '''
    Romanian new leu.
    '''
    
    RSD = 'RSD'
    '''
    Serbian dinar.
    '''
    
    RUB = 'RUB'
    '''
    Russian rouble.
    '''
    
    RWF = 'RWF'
    '''
    Rwandan franc.
    '''
    
    SAR = 'SAR'
    '''
    Saudi riyal.
    '''
    
    SBD = 'SBD'
    '''
    Solomon Islands dollar.
    '''
    
    SCR = 'SCR'
    '''
    Seychelles rupee.
    '''
    
    SDG = 'SDG'
    '''
    Sudanese pound.
    '''
    
    SEK = 'SEK'
    '''
    Swedish krona/kronor.
    '''
    
    SGD = 'SGD'
    '''
    Singapore dollar.
    '''
    
    SHP = 'SHP'
    '''
    Saint Helena pound.
    '''
    
    SLL = 'SLL'
    '''
    Sierra Leonean leone.
    '''
    
    SOS = 'SOS'
    '''
    Somali shilling.
    '''
    
    SRD = 'SRD'
    '''
    Surinamese dollar.
    '''
    
    STD = 'STD'
    '''
    S�o Tom� and Pr�ncipe dobra.
    '''
    
    SYP = 'SYP'
    '''
    Syrian pound.
    '''
    
    SZL = 'SZL'
    '''
    Lilangeni.
    '''
    
    THB = 'THB'
    '''
    Thai baht.
    '''
    
    TJS = 'TJS'
    '''
    Tajikistani somoni.
    '''
    
    TMT = 'TMT'
    '''
    Turkmenistani manat.
    '''
    
    TND = 'TND'
    '''
    Tunisian dinar.
    '''
    
    TOP = 'TOP'
    '''
    Tongan pa?anga.
    '''
    
    TRY = 'TRY'
    '''
    Turkish lira.
    '''
    
    TTD = 'TTD'
    '''
    Trinidad and Tobago dollar.
    '''
    
    TWD = 'TWD'
    '''
    New Taiwan dollar.
    '''
    
    TZS = 'TZS'
    '''
    Tanzanian shilling.
    '''
    
    UAH = 'UAH'
    '''
    Ukrainian hryvnia.
    '''
    
    UGX = 'UGX'
    '''
    Ugandan shilling.
    '''
    
    USD = 'USD'
    '''
    United States dollar.
    '''
    
    UYU = 'UYU'
    '''
    Uruguayan peso.
    '''
    
    UZS = 'UZS'
    '''
    Uzbekistan som.
    '''
    
    VEF = 'VEF'
    '''
    Venezuelan bol�var fuerte.
    '''
    
    VND = 'VND'
    '''
    Vietnamese Dong.
    '''
    
    VUV = 'VUV'
    '''
    Vanuatu vatu.
    '''
    
    WST = 'WST'
    '''
    Samoan tala.
    '''
    
    XAF = 'XAF'
    '''
    CFA franc BEAC.
    '''
    
    XCD = 'XCD'
    '''
    East Caribbean dollar.
    '''
    
    XOF = 'XOF'
    '''
    CFA Franc BCEAO.
    '''
    
    XPF = 'XPF'
    '''
    CFP franc.
    '''
    
    YER = 'YER'
    '''
    Yemeni rial.
    '''
    
    ZAR = 'ZAR'
    '''
    South African rand.
    '''
    
    ZMK = 'ZMK'
    '''
    Zambian kwacha.
    '''
    
    ZWL = 'ZWL'
    '''
    Zimbabwe dollar.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class CurveStyle(Enum):
    '''
    Style or shape of curve.
    '''

    constantYValue = 'constantYValue'
    '''
    The Y-axis values are assumed constant until the next curve point and
    prior to the first curve point.
    '''
    
    straightLineYValues = 'straightLineYValues'
    '''
    The Y-axis values are assumed to be a straight line between values.
    Also known as linear interpolation.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class EmissionType(Enum):
    '''
    The type of emission.
    '''

    carbonDioxide = 'carbonDioxide'
    '''
    Carbon diaoxide.
    '''
    
    carbonDisulfide = 'carbonDisulfide'
    '''
    Carbon disulfide.
    '''
    
    chlorine = 'chlorine'
    '''
    Clorine.
    '''
    
    hydrogenSulfide = 'hydrogenSulfide'
    '''
    Hydrogen sulfide.
    '''
    
    nitrogenOxide = 'nitrogenOxide'
    '''
    Nitrogen oxide.
    '''
    
    sulfurDioxide = 'sulfurDioxide'
    '''
    Sulfer dioxide.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class EmissionValueSource(Enum):
    '''
    The source of the emission value.
    '''

    calculated = 'calculated'
    '''
    Calculated.
    '''
    
    measured = 'measured'
    '''
    Measured.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class FuelType(Enum):
    '''
    Type of fuel.
    '''

    coal = 'coal'
    '''
    Generic coal, not including lignite type.
    '''
    
    gas = 'gas'
    '''
    Natural gas.
    '''
    
    hardCoal = 'hardCoal'
    '''
    Hard coal
    '''
    
    lignite = 'lignite'
    '''
    The fuel is lignite coal. Note that this is a special type of coal,
    so the other enum of coal is reserved for hard coal types or if the
    exact type of coal is not known.
    '''
    
    oil = 'oil'
    '''
    Oil.
    '''
    
    oilShale = 'oilShale'
    '''
    Oil Shale
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
class GeneratorControlMode(Enum):
    '''
    Unit control modes.
    '''

    pulse = 'pulse'
    '''
    Pulse control mode.
    '''
    
    setpoint = 'setpoint'
    '''
    Setpoint control mode.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
class GeneratorControlSource(Enum):
    '''
    The source of controls for a generating unit.
    '''

    offAGC = 'offAGC'
    '''
    Off of automatic generation control (AGC).
    '''
    
    onAGC = 'onAGC'
    '''
    On automatic generation control (AGC).
    '''
    
    plantControl = 'plantControl'
    '''
    Plant is controlling.
    '''
    
    unavailable = 'unavailable'
    '''
    Not available.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class HouseCooling(Enum):
    '''
    '''

    electric = 'electric'
    '''
    '''
    
    heatPump = 'heatPump'
    '''
    '''
    
    none = 'none'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Houses'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class HouseHeating(Enum):
    '''
    '''

    gas = 'gas'
    '''
    '''
    
    heatPump = 'heatPump'
    '''
    '''
    
    none = 'none'
    '''
    '''
    
    resistance = 'resistance'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Houses'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class HouseThermalIntegrity(Enum):
    '''
    '''

    aboveNormal = 'aboveNormal'
    '''
    '''
    
    belowNormal = 'belowNormal'
    '''
    '''
    
    good = 'good'
    '''
    '''
    
    little = 'little'
    '''
    '''
    
    normal = 'normal'
    '''
    '''
    
    unknown = 'unknown'
    '''
    '''
    
    veryGood = 'veryGood'
    '''
    '''
    
    veryLittle = 'veryLittle'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Houses'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class HydroEnergyConversionKind(Enum):
    '''
    Specifies the capability of the hydro generating unit to convert energy
    as a generator or pump.
    '''

    generator = 'generator'
    '''
    Able to generate power, but not able to pump water for energy storage.
    '''
    
    pumpAndGenerator = 'pumpAndGenerator'
    '''
    Able to both generate power and pump water for energy storage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class HydroPlantStorageKind(Enum):
    '''
    The type of hydro power plant.
    '''

    pumpedStorage = 'pumpedStorage'
    '''
    Pumped storage.
    '''
    
    runOfRiver = 'runOfRiver'
    '''
    Run of river.
    '''
    
    storage = 'storage'
    '''
    Storage.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class IEEE1547AbnormalPerfomanceCategory(Enum):
    '''
    '''

    CategoryI = 'CategoryI'
    '''
    '''
    
    CategoryII = 'CategoryII'
    '''
    '''
    
    CategoryIII = 'CategoryIII'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class IEEE1547IslandingCategory(Enum):
    '''
    See clause 8.2
    '''

    BlackStart = 'BlackStart'
    '''
    '''
    
    Capable = 'Capable'
    '''
    '''
    
    Isochronous = 'Isochronous'
    '''
    '''
    
    Uncategorized = 'Uncategorized'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class IEEE1547NormalPerformanceCategory(Enum):
    '''
    '''

    CategoryA = 'CategoryA'
    '''
    '''
    
    CategoryB = 'CategoryB'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class OperatingMechanismKind(Enum):
    '''
    '''

    capacitorTrip = 'capacitorTrip'
    '''
    '''
    
    hydraulic = 'hydraulic'
    '''
    '''
    
    pneudraulic = 'pneudraulic'
    '''
    '''
    
    pneumatic = 'pneumatic'
    '''
    '''
    
    solenoid = 'solenoid'
    '''
    '''
    
    spring = 'spring'
    '''
    '''
    
    springHandCrank = 'springHandCrank'
    '''
    '''
    
    springHydraulic = 'springHydraulic'
    '''
    '''
    
    springMotor = 'springMotor'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class OperationalLimitDirectionKind(Enum):
    '''
    The direction attribute describes the side of a limit that is a violation.
    '''

    absoluteValue = 'absoluteValue'
    '''
    An absoluteValue limit means that a monitored absolute value above
    the limit value is a violation.
    '''
    
    high = 'high'
    '''
    High means that a monitored value above the limit value is a violation.
    If applied to a terminal flow, the positive direction is into the terminal.
    '''
    
    low = 'low'
    '''
    Low means a monitored value below the limit is a violation. If applied
    to a terminal flow, the positive direction is into the terminal.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'OperationalLimits'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class OrderedPhaseCodeKind(Enum):
    '''
    In some use cases, the ordering of phases is important. The PhaseCode class
    does not represent order, but this class addresses such use cases. When
    two or more phases are present, the individual phases may occur in any
    order, but the neutral must always occur last. When only one phase and
    the neutral is present, that phase and the neutral may be re-ordered.
    '''

    A = 'A'
    '''
    '''
    
    AB = 'AB'
    '''
    '''
    
    ABC = 'ABC'
    '''
    '''
    
    ABCN = 'ABCN'
    '''
    '''
    
    ABN = 'ABN'
    '''
    '''
    
    AC = 'AC'
    '''
    '''
    
    ACB = 'ACB'
    '''
    '''
    
    ACBN = 'ACBN'
    '''
    '''
    
    ACN = 'ACN'
    '''
    '''
    
    AN = 'AN'
    '''
    '''
    
    B = 'B'
    '''
    '''
    
    BA = 'BA'
    '''
    '''
    
    BAC = 'BAC'
    '''
    '''
    
    BACN = 'BACN'
    '''
    '''
    
    BAN = 'BAN'
    '''
    '''
    
    BC = 'BC'
    '''
    '''
    
    BCA = 'BCA'
    '''
    '''
    
    BCAN = 'BCAN'
    '''
    '''
    
    BCN = 'BCN'
    '''
    '''
    
    BN = 'BN'
    '''
    '''
    
    C = 'C'
    '''
    '''
    
    CA = 'CA'
    '''
    '''
    
    CAB = 'CAB'
    '''
    '''
    
    CABN = 'CABN'
    '''
    '''
    
    CAN = 'CAN'
    '''
    '''
    
    CB = 'CB'
    '''
    '''
    
    CBA = 'CBA'
    '''
    '''
    
    CBAN = 'CBAN'
    '''
    '''
    
    CBN = 'CBN'
    '''
    '''
    
    CN = 'CN'
    '''
    '''
    
    NA = 'NA'
    '''
    '''
    
    NB = 'NB'
    '''
    '''
    
    NC = 'NC'
    '''
    '''
    
    Ns1 = 'Ns1'
    '''
    '''
    
    Ns2 = 'Ns2'
    '''
    '''
    
    X = 'X'
    '''
    '''
    
    XN = 'XN'
    '''
    '''
    
    XY = 'XY'
    '''
    '''
    
    XYN = 'XYN'
    '''
    '''
    
    none = 'none'
    '''
    '''
    
    s1 = 's1'
    '''
    '''
    
    s12 = 's12'
    '''
    '''
    
    s12N = 's12N'
    '''
    '''
    
    s1N = 's1N'
    '''
    '''
    
    s2 = 's2'
    '''
    '''
    
    s21 = 's21'
    '''
    '''
    
    s21N = 's21N'
    '''
    '''
    
    s2N = 's2N'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class PetersenCoilModeKind(Enum):
    '''
    The mode of operation for a Petersen coil.
    '''

    automaticPositioning = 'automaticPositioning'
    '''
    Automatic positioning.
    '''
    
    fixed = 'fixed'
    '''
    Fixed position.
    '''
    
    manual = 'manual'
    '''
    Manual positioning.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class PhaseCode(Enum):
    '''
    An unordered enumeration of phase identifiers. Allows designation of phases
    for both transmission and distribution equipment, circuits and loads. The
    enumeration, by itself, does not describe how the phases are connected
    together or connected to ground. Ground is not explicitly denoted as a
    phase.
    Residential and small commercial loads are often served from single-phase,
    or split-phase, secondary circuits. For example of s12N, phases 1 and 2
    refer to hot wires that are 180 degrees out of phase, while N refers to
    the neutral wire. Through single-phase transformer connections, these secondary
    circuits may be served from one or two of the primary phases A, B, and
    C. For three-phase loads, use the A, B, C phase codes instead of s12N.
    '''

    A = 'A'
    '''
    Phase A.
    '''
    
    AB = 'AB'
    '''
    Phases A and B.
    '''
    
    ABC = 'ABC'
    '''
    Phases A, B, and C.
    '''
    
    ABCN = 'ABCN'
    '''
    Phases A, B, C, and N.
    '''
    
    ABN = 'ABN'
    '''
    Phases A, B, and neutral.
    '''
    
    AC = 'AC'
    '''
    Phases A and C.
    '''
    
    ACN = 'ACN'
    '''
    Phases A, C and neutral.
    '''
    
    AN = 'AN'
    '''
    Phases A and neutral.
    '''
    
    B = 'B'
    '''
    Phase B.
    '''
    
    BC = 'BC'
    '''
    Phases B and C.
    '''
    
    BCN = 'BCN'
    '''
    Phases B, C, and neutral.
    '''
    
    BN = 'BN'
    '''
    Phases B and neutral.
    '''
    
    C = 'C'
    '''
    Phase C.
    '''
    
    CN = 'CN'
    '''
    Phases C and neutral.
    '''
    
    N = 'N'
    '''
    Neutral phase.
    '''
    
    X = 'X'
    '''
    Unknown non-neutral phase.
    '''
    
    XN = 'XN'
    '''
    Unknown non-neutral phase plus neutral.
    '''
    
    XY = 'XY'
    '''
    Two unknown non-neutral phases.
    '''
    
    XYN = 'XYN'
    '''
    Two unknown non-neutral phases plus neutral.
    '''
    
    none = 'none'
    '''
    No phases specified.
    '''
    
    s1 = 's1'
    '''
    Secondary phase 1.
    '''
    
    s12 = 's12'
    '''
    Secondary phase 1 and 2.
    '''
    
    s12N = 's12N'
    '''
    Secondary phases 1, 2, and neutral.
    '''
    
    s1N = 's1N'
    '''
    Secondary phase 1 and neutral.
    '''
    
    s2 = 's2'
    '''
    Secondary phase 2.
    '''
    
    s2N = 's2N'
    '''
    Secondary phase 2 and neutral.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Core'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class PhaseConnectedFaultKind(Enum):
    '''
    The type of fault connection among phases.
    '''

    lineOpen = 'lineOpen'
    '''
    The fault is when the conductor path is broken between two terminals.
    Additional coexisting faults may be required if the broken conductor
    also causes connections to grounds or other lines or phases.
    '''
    
    lineToGround = 'lineToGround'
    '''
    The fault connects the indicated phases to ground. The line to line
    fault impedance is not used and assumed infinite. The full ground impedance
    is connected between each phase specified in the fault and ground,
    but not between the phases.
    '''
    
    lineToLine = 'lineToLine'
    '''
    The fault connects the specified phases together without a connection
    to ground. The ground impedance of this fault is ignored. The line
    to line impedance is connected between each of the phases specified
    in the fault. For example three times for a three phase fault, one
    time for a two phase fault. A single phase fault should not be specified.
    '''
    
    lineToLineToGround = 'lineToLineToGround'
    '''
    The fault connects the indicated phases to ground and to each other.
    The line to line impedance is connected between each of the phases
    specified in the fault in a full mesh. For example three times for
    a three phase fault, one time for a two phase fault. A single phase
    fault should not be specified. The full ground impedance is connected
    between each phase specified in the fault and ground.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Faults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class PhaseShuntConnectionKind(Enum):
    '''
    The configuration of phase connections for a single terminal device such
    as a load or capacitor.
    '''

    D = 'D'
    '''
    Delta connection.
    '''
    
    G = 'G'
    '''
    Ground connection; use when explicit connection to ground needs to
    be expressed in combination with the phase code, such as for electrical
    wire/cable or for meters.
    '''
    
    I = 'I'
    '''
    Independent winding, for single-phase connections.
    '''
    
    Y = 'Y'
    '''
    Wye connection.
    '''
    
    Yn = 'Yn'
    '''
    Wye, with neutral brought out for grounding.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class RegulatingControlModeKind(Enum):
    '''
    The kind of regulation model. For example regulating voltage, reactive
    power, active power, etc.
    '''

    activePower = 'activePower'
    '''
    Active power is specified.
    '''
    
    admittance = 'admittance'
    '''
    Admittance is specified.
    '''
    
    currentFlow = 'currentFlow'
    '''
    Current flow is specified.
    '''
    
    powerFactor = 'powerFactor'
    '''
    Power factor is specified.
    '''
    
    reactivePower = 'reactivePower'
    '''
    Reactive power is specified.
    '''
    
    temperature = 'temperature'
    '''
    Control switches on/off based on the local temperature (i.e., a thermostat).
    '''
    
    timeScheduled = 'timeScheduled'
    '''
    Control switches on/off by time of day. The times may change on the
    weekend, or in different seasons.
    '''
    
    voltage = 'voltage'
    '''
    Voltage is specified.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class SVCControlMode(Enum):
    '''
    Static VAr Compensator control mode.
    '''

    reactivePower = 'reactivePower'
    '''
    '''
    
    voltage = 'voltage'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
class ShortCircuitRotorKind(Enum):
    '''
    Type of rotor, used by short circuit applications.
    '''

    salientPole1 = 'salientPole1'
    '''
    Salient pole 1 in the IEC 60909
    '''
    
    salientPole2 = 'salientPole2'
    '''
    Salient pole 2 in IEC 60909
    '''
    
    turboSeries1 = 'turboSeries1'
    '''
    Turbo Series 1 in the IEC 60909
    '''
    
    turboSeries2 = 'turboSeries2'
    '''
    Turbo series 2 in IEC 60909
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class SinglePhaseKind(Enum):
    '''
    Enumeration of single phase identifiers. Allows designation of single phases
    for both transmission and distribution equipment, circuits and loads.
    '''

    A = 'A'
    '''
    Phase A.
    '''
    
    B = 'B'
    '''
    Phase B.
    '''
    
    C = 'C'
    '''
    Phase C.
    '''
    
    N = 'N'
    '''
    Neutral.
    '''
    
    s1 = 's1'
    '''
    Secondary phase 1.
    '''
    
    s2 = 's2'
    '''
    Secondary phase 2.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class SynchronousMachineKind(Enum):
    '''
    Synchronous machine type.
    '''

    condenser = 'condenser'
    '''
    '''
    
    generator = 'generator'
    '''
    '''
    
    generatorOrCondenser = 'generatorOrCondenser'
    '''
    '''
    
    generatorOrCondenserOrMotor = 'generatorOrCondenserOrMotor'
    '''
    '''
    
    generatorOrMotor = 'generatorOrMotor'
    '''
    '''
    
    motor = 'motor'
    '''
    '''
    
    motorOrCondenser = 'motorOrCondenser'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class SynchronousMachineOperatingMode(Enum):
    '''
    Synchronous machine operating mode.
    '''

    condenser = 'condenser'
    '''
    '''
    
    generator = 'generator'
    '''
    '''
    
    motor = 'motor'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class ThermostatControlMode(Enum):
    '''
    '''

    Cooling = 'Cooling'
    '''
    '''
    
    Heating = 'Heating'
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Houses'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
class TransformerControlMode(Enum):
    '''
    Control modes for a transformer.
    '''

    reactive = 'reactive'
    '''
    Reactive power flow control
    '''
    
    volt = 'volt'
    '''
    Voltage control
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class UnitMultiplier(Enum):
    '''
    The unit multipliers defined for the CIM. When applied to unit symbols,
    the unit symbol is treated as a derived unit. Regardless of the contents
    of the unit symbol text, the unit symbol shall be treated as if it were
    a single-character unit symbol. Unit symbols should not contain multipliers,
    and it should be left to the multiplier to define the multiple for an entire
    data type.
    For example, if a unit symbol is "A2Perh" and the multiplier is "k", then
    the value is k(A^2/h), and the multiplier applies to the entire final value,
    not to any individual part of the value. This can be conceptualized by
    substituting a derived unit symbol for the unit type. If one imagines that
    the symbol "�" represents the derived unit "A2Perh", then applying the
    multiplier "k" can be conceptualized simply as "k�".
    For example, the SI unit for mass is "kg" and not "g". If the unit symbol
    is defined as "kg", then the multiplier is applied to "kg" as a whole and
    does not replace the "k" in front of the "g". In this case, the multiplier
    of "m" would be used with the unit symbol of "kg" to represent one gram.
    As a text string, this violates the instructions in IEC 80000-1. However,
    because the unit symbol in CIM is treated as a derived unit instead of
    as an SI unit, it makes more sense to conceptualize the "kg" as if it were
    replaced by one of the proposed replacements for the SI mass symbol. If
    one imagines that the "kg" were replaced by a symbol "�", then it is easier
    to conceptualize the multiplier "m" as creating the proper unit "m�", and
    not the forbidden unit "mkg".
    '''

    E = 'E'
    '''
    Exa 10**18.
    '''
    
    G = 'G'
    '''
    Giga 10**9.
    '''
    
    M = 'M'
    '''
    Mega 10**6.
    '''
    
    P = 'P'
    '''
    Peta 10**15
    '''
    
    T = 'T'
    '''
    Tera 10**12.
    '''
    
    Y = 'Y'
    '''
    Yotta 10**24
    '''
    
    Z = 'Z'
    '''
    Zetta 10**21
    '''
    
    a = 'a'
    '''
    atto 10**-18.
    '''
    
    c = 'c'
    '''
    Centi 10**-2.
    '''
    
    d = 'd'
    '''
    Deci 10**-1.
    '''
    
    da = 'da'
    '''
    deca 10**1.
    '''
    
    f = 'f'
    '''
    femto 10**-15.
    '''
    
    h = 'h'
    '''
    hecto 10**2.
    '''
    
    k = 'k'
    '''
    Kilo 10**3.
    '''
    
    m = 'm'
    '''
    Milli 10**-3.
    '''
    
    micro = 'micro'
    '''
    Micro 10**-6.
    '''
    
    n = 'n'
    '''
    Nano 10**-9.
    '''
    
    none = 'none'
    '''
    No multiplier or equivalently multiply by 1.
    '''
    
    p = 'p'
    '''
    Pico 10**-12.
    '''
    
    y = 'y'
    '''
    yocto 10**-24.
    '''
    
    z = 'z'
    '''
    zepto 10**-21.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class UnitSymbol(Enum):
    '''
    The derived units defined for usage in the CIM. In some cases, the derived
    unit is equal to an SI unit. Whenever possible, the standard derived symbol
    is used instead of the formula for the derived unit. For example, the unit
    symbol Farad is defined as "F" instead of "CPerV". In cases where a standard
    symbol does not exist for a derived unit, the formula for the unit is used
    as the unit symbol. For example, density does not have a standard symbol
    and so it is represented as "kgPerm3". With the exception of the "kg",
    which is an SI unit, the unit symbols do not contain multipliers and therefore
    represent the base derived unit to which a multiplier can be applied as
    a whole.
    Every unit symbol is treated as an unparseable text as if it were a single-letter
    symbol. The meaning of each unit symbol is defined by the accompanying
    descriptive text and not by the text contents of the unit symbol.
    To allow the widest possible range of serializations without requiring
    special character handling, several substitutions are made which deviate
    from the format described in IEC 80000-1. The division symbol "/" is replaced
    by the letters"Per". Exponents are written in plain text after the unit
    as "m3" instead of being formatted as in "m<sup>3</sup>" or introducing
    a symbol as in "m^3". The degree symbol "�" is replaced with the letters
    "deg". Any clarification of the meaning for a substitution is included
    in the description for the unit symbol.
    Non-SI units are included in list of unit symbols to allow sources of data
    to be correctly labeled with their non-SI units (for example, a GPS sensor
    that is reporting numbers that represent feet instead of meters). This
    allows software to use the unit symbol information correctly convert and
    scale the raw data of those sources into SI-based units.
    '''

    A = 'A'
    '''
    Current in Ampere.
    '''
    
    A2 = 'A2'
    '''
    Ampere squared (A�).
    '''
    
    A2h = 'A2h'
    '''
    ampere-squared hour, Ampere-squared hour.
    '''
    
    A2s = 'A2s'
    '''
    Ampere squared time in square ampere (A�s).
    '''
    
    APerA = 'APerA'
    '''
    Current, Ratio of Amperages Note: Users may need to supply a prefix
    such as �m� to show rates such as �mA/A�.
    '''
    
    APerm = 'APerm'
    '''
    A/m, magnetic field strength, Ampere per metre.
    '''
    
    Ah = 'Ah'
    '''
    Ampere-hours, Ampere-hours.
    '''
    
    As = 'As'
    '''
    Ampere seconds (A�s).
    '''
    
    Bq = 'Bq'
    '''
    Radioactivity in Becquerel (1/s).
    '''
    
    Btu = 'Btu'
    '''
    Energy, British Thermal Unit.
    '''
    
    C = 'C'
    '''
    Electric charge in Coulomb (A�s).
    '''
    
    CPerkg = 'CPerkg'
    '''
    exposure (x rays), Coulomb per kilogram.
    '''
    
    CPerm2 = 'CPerm2'
    '''
    surface charge density, Coulomb per square metre.
    '''
    
    CPerm3 = 'CPerm3'
    '''
    electric charge density, Coulomb per cubic metre.
    '''
    
    F = 'F'
    '''
    Electric capacitance in Farad (C/V).
    '''
    
    FPerm = 'FPerm'
    '''
    permittivity, Farad per metre.
    '''
    
    G = 'G'
    '''
    Magnetic flux density, Gauss (1 G = 10-4 T).
    '''
    
    Gy = 'Gy'
    '''
    Absorbed dose in Gray (J/kg).
    '''
    
    GyPers = 'GyPers'
    '''
    absorbed dose rate, Gray per second.
    '''
    
    H = 'H'
    '''
    Electric inductance in Henry (Wb/A).
    '''
    
    HPerm = 'HPerm'
    '''
    permeability, Henry per metre.
    '''
    
    Hz = 'Hz'
    '''
    Frequency in Hertz (1/s).
    '''
    
    HzPerHz = 'HzPerHz'
    '''
    Frequency, Rate of frequency change Note: Users may need to supply
    a prefix such as �m� to show rates such as �mHz/Hz�.
    '''
    
    HzPers = 'HzPers'
    '''
    Rate of change of frequency in Hertz per second.
    '''
    
    J = 'J'
    '''
    Energy in joule (N�m = C�V = W�s).
    '''
    
    JPerK = 'JPerK'
    '''
    Heat capacity in Joule/Kelvin.
    '''
    
    JPerkg = 'JPerkg'
    '''
    Specific energy, Joule / kg.
    '''
    
    JPerkgK = 'JPerkgK'
    '''
    Specific heat capacity, specific entropy, Joule per kilogram Kelvin.
    '''
    
    JPerm2 = 'JPerm2'
    '''
    Insulation energy density, Joule per square metre or watt second per
    square metre.
    '''
    
    JPerm3 = 'JPerm3'
    '''
    energy density, Joule per cubic metre.
    '''
    
    JPermol = 'JPermol'
    '''
    molar energy, Joule per mole.
    '''
    
    JPermolK = 'JPermolK'
    '''
    molar entropy, molar heat capacity, Joule per mole kelvin.
    '''
    
    JPers = 'JPers'
    '''
    Energy rate joule per second (J/s),
    '''
    
    K = 'K'
    '''
    Temperature in Kelvin.
    '''
    
    KPers = 'KPers'
    '''
    Temperature change rate in Kelvin per second.
    '''
    
    M = 'M'
    '''
    Length, nautical mile (1 M = 1852 m).
    '''
    
    Mx = 'Mx'
    '''
    Magnetic flux, Maxwell (1 Mx = 10-8 Wb).
    '''
    
    N = 'N'
    '''
    Force in Newton (kg�m/s�).
    '''
    
    NPerm = 'NPerm'
    '''
    Surface tension, Newton per metre.
    '''
    
    Nm = 'Nm'
    '''
    Moment of force, Newton metre.
    '''
    
    Oe = 'Oe'
    '''
    Magnetic field, �rsted (1 Oe = (103/4p) A/m).
    '''
    
    Pa = 'Pa'
    '''
    Pressure in Pascal (N/m�). Note: the absolute or relative measurement
    of pressure is implied with this entry. See below for more explicit
    forms.
    '''
    
    PaPers = 'PaPers'
    '''
    Pressure change rate in Pascal per second.
    '''
    
    Pas = 'Pas'
    '''
    Dynamic viscosity, Pascal second.
    '''
    
    Q = 'Q'
    '''
    Quantity power, Q.
    '''
    
    Qh = 'Qh'
    '''
    Quantity energy, Qh.
    '''
    
    S = 'S'
    '''
    Conductance in Siemens.
    '''
    
    SPerm = 'SPerm'
    '''
    Conductance per length (F/m).
    '''
    
    Sv = 'Sv'
    '''
    Dose equivalent in Sievert (J/kg).
    '''
    
    T = 'T'
    '''
    Magnetic flux density in Tesla (Wb/m2).
    '''
    
    V = 'V'
    '''
    Electric potential in Volt (W/A).
    '''
    
    V2 = 'V2'
    '''
    Volt squared (W�/A�).
    '''
    
    V2h = 'V2h'
    '''
    volt-squared hour, Volt-squared-hours.
    '''
    
    VA = 'VA'
    '''
    Apparent power in Volt Ampere (See also real power and reactive power.)
    '''
    
    VAh = 'VAh'
    '''
    Apparent energy in Volt Ampere hours.
    '''
    
    VAr = 'VAr'
    '''
    Reactive power in Volt Ampere reactive. The �reactive� or �imaginary�
    component of electrical power (VIsin(phi)). (See also real power and
    apparent power).
    Note: Different meter designs use different methods to arrive at their
    results. Some meters may compute reactive power as an arithmetic value,
    while others compute the value vectorially. The data consumer should
    determine the method in use and the suitability of the measurement
    for the intended purpose.
    '''
    
    VArh = 'VArh'
    '''
    Reactive energy in Volt Ampere reactive hours.
    '''
    
    VPerHz = 'VPerHz'
    '''
    Magnetic flux in Volt per Hertz.
    '''
    
    VPerV = 'VPerV'
    '''
    Voltage, Ratio of voltages Note: Users may need to supply a prefix
    such as �m� to show rates such as �mV/V�.
    '''
    
    VPerVA = 'VPerVA'
    '''
    Power factor, PF, the ratio of the active power to the apparent power.
    Note: The sign convention used for power factor will differ between
    IEC meters and EEI (ANSI) meters. It is assumed that the data consumers
    understand the type of meter being used and agree on the sign convention
    in use at any given utility.
    '''
    
    VPerVAr = 'VPerVAr'
    '''
    Power factor, PF, the ratio of the active power to the apparent power.
    Note: The sign convention used for power factor will differ between
    IEC meters and EEI (ANSI) meters. It is assumed that the data consumers
    understand the type of meter being used and agree on the sign convention
    in use at any given utility.
    '''
    
    VPerm = 'VPerm'
    '''
    electric field strength, Volt per metre.
    '''
    
    Vh = 'Vh'
    '''
    Volt-hour, Volt hours.
    '''
    
    Vs = 'Vs'
    '''
    Volt second (Ws/A).
    '''
    
    W = 'W'
    '''
    Real power in Watt (J/s). Electrical power may have real and reactive
    components. The real portion of electrical power (I�R or VIcos(phi)),
    is expressed in Watts. (See also apparent power and reactive power.)
    '''
    
    WPerA = 'WPerA'
    '''
    Active power per current flow, watt per Ampere.
    '''
    
    WPerW = 'WPerW'
    '''
    Signal Strength, Ratio of power Note: Users may need to supply a prefix
    such as �m� to show rates such as �mW/W�.
    '''
    
    WPerm2 = 'WPerm2'
    '''
    Heat flux density, irradiance, Watt per square metre.
    '''
    
    WPerm2sr = 'WPerm2sr'
    '''
    radiance, Watt per square metre steradian.
    '''
    
    WPermK = 'WPermK'
    '''
    Thermal conductivity in Watt/metre Kelvin.
    '''
    
    WPers = 'WPers'
    '''
    Ramp rate in Watt per second.
    '''
    
    WPersr = 'WPersr'
    '''
    Radiant intensity, Watt per steradian.
    '''
    
    Wb = 'Wb'
    '''
    Magnetic flux in Weber (V�s).
    '''
    
    Wh = 'Wh'
    '''
    Real energy in Watt hours.
    '''
    
    anglemin = 'anglemin'
    '''
    Plane angle, minute.
    '''
    
    anglesec = 'anglesec'
    '''
    Plane angle, second.
    '''
    
    bar = 'bar'
    '''
    Pressure, bar (1 bar = 100 kPa).
    '''
    
    cd = 'cd'
    '''
    Luminous intensity in candela.
    '''
    
    charPers = 'charPers'
    '''
    Data rate (baud) in characters per second.
    '''
    
    character = 'character'
    '''
    Number of characters.
    '''
    
    cosPhi = 'cosPhi'
    '''
    Power factor, dimensionless.
    Note 1: This definition of power factor only holds for balanced systems.
    See the alternative definition under code 153.
    Note 2�: Beware of differing sign conventions in use between the IEC
    and EEI. It is assumed that the data consumer understands the type
    of meter in use and the sign convention in use by the utility.
    '''
    
    count = 'count'
    '''
    Amount of substance, Counter value.
    '''
    
    d = 'd'
    '''
    Time, day = 24 h = 86400 s.
    '''
    
    dB = 'dB'
    '''
    Sound pressure level in decibel. Note: multiplier �d� is included in
    this unit symbol for compatibility with IEC 61850-7-3.
    '''
    
    dBm = 'dBm'
    '''
    Power level (logrithmic ratio of signal strength , Bel-mW), normalized
    to 1mW. Note: multiplier �d� is included in this unit symbol for compatibility
    with IEC 61850-7-3.
    '''
    
    deg = 'deg'
    '''
    Plane angle in degrees.
    '''
    
    degC = 'degC'
    '''
    Relative temperature in degrees Celsius.
    In the SI unit system the symbol is �C. Electric charge is measured
    in coulomb that has the unit symbol C. To distinguish degree Celsius
    form coulomb the symbol used in the UML is degC. Reason for not using
    �C is the special character � is difficult to manage in software.
    '''
    
    ft3 = 'ft3'
    '''
    Volume, cubic foot.
    '''
    
    gPerg = 'gPerg'
    '''
    Concentration, The ratio of the mass of a solute divided by the mass
    of the solution. Note: Users may need use a prefix such a ��� to express
    a quantity such as ��g/g�.
    '''
    
    gal = 'gal'
    '''
    Volume, US gallon (1 gal = 231 in3 = 128 fl ounce).
    '''
    
    h = 'h'
    '''
    Time, hour = 60 min = 3600 s.
    '''
    
    ha = 'ha'
    '''
    Area, hectare.
    '''
    
    kat = 'kat'
    '''
    Catalytic activity, katal = mol / s.
    '''
    
    katPerm3 = 'katPerm3'
    '''
    catalytic activity concentration, katal per cubic metre.
    '''
    
    kg = 'kg'
    '''
    Mass in kilogram. Note: multiplier �k� is included in this unit symbol
    for compatibility with IEC 61850-7-3.
    '''
    
    kgPerJ = 'kgPerJ'
    '''
    Weigh per energy in kilogram/joule (kg/J). Note: multiplier �k� is
    included in this unit symbol for compatibility with IEC 61850-7-3.
    '''
    
    kgPerm3 = 'kgPerm3'
    '''
    Density in kilogram/cubic metre (kg/m�). Note: multiplier �k� is included
    in this unit symbol for compatibility with IEC 61850-7-3.
    '''
    
    kgm = 'kgm'
    '''
    Moment of mass in kilogram metre (kg�m) (first moment of mass). Note:
    multiplier �k� is included in this unit symbol for compatibility with
    IEC 61850-7-3.
    '''
    
    kgm2 = 'kgm2'
    '''
    Moment of mass in kilogram square metre (kg�m�) (Second moment of mass,
    commonly called the moment of inertia). Note: multiplier �k� is included
    in this unit symbol for compatibility with IEC 61850-7-3.
    '''
    
    kn = 'kn'
    '''
    Speed, knot (1 kn = 1852/3600) m/s.
    '''
    
    l = 'l'
    '''
    Volume, litre = dm3 = m3/1000.
    '''
    
    lPerh = 'lPerh'
    '''
    Volumetric flow rate, litre per hour.
    '''
    
    lPerl = 'lPerl'
    '''
    Concentration, The ratio of the volume of a solute divided by the volume
    of the solution. Note: Users may need use a prefix such a ��� to express
    a quantity such as ��L/L�.
    '''
    
    lPers = 'lPers'
    '''
    Volumetric flow rate in litre per second.
    '''
    
    lm = 'lm'
    '''
    Luminous flux in lumen (cd�sr).
    '''
    
    lx = 'lx'
    '''
    Illuminance in lux (lm/m�).
    '''
    
    m = 'm'
    '''
    Length in meter.
    '''
    
    m2 = 'm2'
    '''
    Area in square metre (m�).
    '''
    
    m2Pers = 'm2Pers'
    '''
    Viscosity in metre square / second (m�/s).
    '''
    
    m3 = 'm3'
    '''
    Volume in cubic metre (m�).
    '''
    
    m3Compensated = 'm3Compensated'
    '''
    Volume, cubic metre, with the value compensated for weather effects.
    '''
    
    m3Perh = 'm3Perh'
    '''
    Volumetric flow rate, cubic metre per hour.
    '''
    
    m3Perkg = 'm3Perkg'
    '''
    Specific volume, cubic metre per kilogram, v.
    '''
    
    m3Pers = 'm3Pers'
    '''
    Volumetric flow rate in cubic metres per second (m�/s).
    '''
    
    m3Uncompensated = 'm3Uncompensated'
    '''
    Volume, cubic metre, with the value uncompensated for weather effects.
    '''
    
    mPerm3 = 'mPerm3'
    '''
    Fuel efficiency in metre per cubic metre (m/m�).
    '''
    
    mPers = 'mPers'
    '''
    Velocity in metre per second (m/s).
    '''
    
    mPers2 = 'mPers2'
    '''
    Acceleration in metre per second squared (m/s�).
    '''
    
    min = 'min'
    '''
    Time, minute = 60 s.
    '''
    
    mmHg = 'mmHg'
    '''
    Pressure, millimeter of mercury (1 mmHg is approximately 133.3 Pa).
    '''
    
    mol = 'mol'
    '''
    Amount of substance in mole.
    '''
    
    molPerkg = 'molPerkg'
    '''
    Concentration, Molality, the amount of solute in moles and the amount
    of solvent in kilograms.
    '''
    
    molPerm3 = 'molPerm3'
    '''
    Concentration, The amount of substance concentration, (c), the amount
    of solvent in moles divided by the volume of solution in m�.
    '''
    
    molPermol = 'molPermol'
    '''
    Concentration, Molar fraction (?), the ratio of the molar amount of
    a solute divided by the molar amount of the solution.
    '''
    
    none = 'none'
    '''
    Dimension less quantity, e.g. count, per unit, etc.
    '''
    
    ohm = 'ohm'
    '''
    Electric resistance in ohm (V/A).
    '''
    
    ohmPerm = 'ohmPerm'
    '''
    Electric resistance per length in ohm per metre ((V/A)/m).
    '''
    
    ohmm = 'ohmm'
    '''
    resistivity, Ohm metre, (rho).
    '''
    
    onePerHz = 'onePerHz'
    '''
    Reciprocal of frequency (1/Hz).
    '''
    
    onePerm = 'onePerm'
    '''
    Wavenumber, reciprocal metre, (1/m).
    '''
    
    ppm = 'ppm'
    '''
    Concentration in parts per million.
    '''
    
    rad = 'rad'
    '''
    Plane angle in radian (m/m).
    '''
    
    radPers = 'radPers'
    '''
    Angular velocity in radians per second (rad/s).
    '''
    
    radPers2 = 'radPers2'
    '''
    Angular acceleration, radian per second squared.
    '''
    
    rev = 'rev'
    '''
    Amount of rotation, Revolutions.
    '''
    
    rotPers = 'rotPers'
    '''
    Rotations per second (1/s). See also Hz (1/s).
    '''
    
    s = 's'
    '''
    Time in seconds.
    '''
    
    sPers = 'sPers'
    '''
    Time, Ratio of time Note: Users may need to supply a prefix such as
    ��� to show rates such as ��s/s�
    '''
    
    sr = 'sr'
    '''
    Solid angle in steradian (m2/m2).
    '''
    
    therm = 'therm'
    '''
    Energy, Therm.
    '''
    
    tonne = 'tonne'
    '''
    mass, �tonne� or �metric ton� (1000 kg = 1 Mg).
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class Validity(Enum):
    '''
    Validity for MeasurementValue.
    '''

    GOOD = 'GOOD'
    '''
    The value is marked good if no abnormal condition of the acquisition
    function or the information source is detected.
    '''
    
    INVALID = 'INVALID'
    '''
    The value is marked invalid when a supervision function recognises
    abnormal conditions of the acquisition function or the information
    source (missing or non-operating updating devices). The value is not
    defined under this condition. The mark invalid is used to indicate
    to the client that the value may be incorrect and shall not be used.
    '''
    
    QUESTIONABLE = 'QUESTIONABLE'
    '''
    The value is marked questionable if a supervision function detects
    an abnormal behaviour, however the value could still be valid. The
    client is responsible for determining whether or not values marked
    "questionable" should be used.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Meas'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class WindGenUnitKind(Enum):
    '''
    Kind of wind generating unit.
    '''

    offshore = 'offshore'
    '''
    The wind generating unit is located offshore.
    '''
    
    onshore = 'onshore'
    '''
    The wind generating unit is located onshore.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class WindingConnection(Enum):
    '''
    Winding connection type.
    '''

    A = 'A'
    '''
    Autotransformer common winding
    '''
    
    D = 'D'
    '''
    Delta
    '''
    
    I = 'I'
    '''
    Independent winding, for single-phase connections
    '''
    
    Y = 'Y'
    '''
    Wye
    '''
    
    Yn = 'Yn'
    '''
    Wye, with neutral brought out for grounding.
    '''
    
    Z = 'Z'
    '''
    ZigZag
    '''
    
    Zn = 'Zn'
    '''
    ZigZag, with neutral brought out for grounding.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Wires'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class WireInsulationKind(Enum):
    '''
    Kind of wire insulation.
    '''

    asbestosAndVarnishedCambric = 'asbestosAndVarnishedCambric'
    '''
    Asbestos and varnished cambric wire insulation.
    '''
    
    beltedPilc = 'beltedPilc'
    '''
    Belted pilc wire insulation.
    '''
    
    butyl = 'butyl'
    '''
    Butyl wire insulation.
    '''
    
    crosslinkedPolyethylene = 'crosslinkedPolyethylene'
    '''
    Crosslinked polyethylene wire insulation.
    '''
    
    ethylenePropyleneRubber = 'ethylenePropyleneRubber'
    '''
    Ethylene propylene rubber wire insulation.
    '''
    
    highMolecularWeightPolyethylene = 'highMolecularWeightPolyethylene'
    '''
    High nolecular weight polyethylene wire insulation.
    '''
    
    highPressureFluidFilled = 'highPressureFluidFilled'
    '''
    High pressure fluid filled wire insulation.
    '''
    
    lowCapacitanceRubber = 'lowCapacitanceRubber'
    '''
    Low capacitance rubber wire insulation.
    '''
    
    oilPaper = 'oilPaper'
    '''
    Oil paper wire insulation.
    '''
    
    other = 'other'
    '''
    Other kind of wire insulation.
    '''
    
    ozoneResistantRubber = 'ozoneResistantRubber'
    '''
    Ozone resistant rubber wire insulation.
    '''
    
    rubber = 'rubber'
    '''
    Rubber wire insulation.
    '''
    
    siliconRubber = 'siliconRubber'
    '''
    Silicon rubber wire insulation.
    '''
    
    treeResistantHighMolecularWeightPolyethylene = 'treeResistantHighMolecularWeightPolyethylene'
    '''
    Tree resistant high molecular weight polyethylene wire insulation.
    '''
    
    treeRetardantCrosslinkedPolyethylene = 'treeRetardantCrosslinkedPolyethylene'
    '''
    Tree retardant crosslinked polyethylene wire insulation.
    '''
    
    unbeltedPilc = 'unbeltedPilc'
    '''
    Unbelted pilc wire insulation.
    '''
    
    varnishedCambricCloth = 'varnishedCambricCloth'
    '''
    Varnished cambric cloth wire insulation.
    '''
    
    varnishedDacronGlass = 'varnishedDacronGlass'
    '''
    Varnished dacron glass wire insulation.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class WireMaterialKind(Enum):
    '''
    Kind of wire material.
    '''

    aaac = 'aaac'
    '''
    Aluminum-alloy conductor steel reinforced.
    '''
    
    acsr = 'acsr'
    '''
    Aluminum conductor steel reinforced.
    '''
    
    aluminum = 'aluminum'
    '''
    Aluminum wire.
    '''
    
    aluminumAlloy = 'aluminumAlloy'
    '''
    Aluminum-alloy wire.
    '''
    
    aluminumAlloySteel = 'aluminumAlloySteel'
    '''
    Aluminum-alloy-steel wire.
    '''
    
    aluminumSteel = 'aluminumSteel'
    '''
    Aluminum-steel wire.
    '''
    
    copper = 'copper'
    '''
    Copper wire.
    '''
    
    other = 'other'
    '''
    Other wire material.
    '''
    
    steel = 'steel'
    '''
    Steel wire.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.enumeration)
@stereotype(CIMStereotype.Attribute)
class WireUsageKind(Enum):
    '''
    Kind of wire usage.
    '''

    distribution = 'distribution'
    '''
    Wire is used in medium voltage network.
    '''
    
    other = 'other'
    '''
    Other kind of wire usage.
    '''
    
    secondary = 'secondary'
    '''
    Wire is used in low voltage circuit.
    '''
    
    transmission = 'transmission'
    '''
    Wire is used in extra-high voltage or high voltage network.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'AssetInfo'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ActivePower(CIMUnit):
    '''
    Product of RMS value of the voltage and the RMS value of the in-phase component
    of the current.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.W
    def __init__(self, value, input_unit: str='W', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ActivePowerChangeRate(CIMUnit):
    '''
    Rate of change of active power per time.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.WPers
    def __init__(self, value, input_unit: str='WPers', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ActivePowerPerFrequency(CIMUnit):
    '''
    Active power variation with frequency.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.WPers
    def __init__(self, value, input_unit: str='WPers', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class AngleDegrees(CIMUnit):
    '''
    Measurement of angle in degrees.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.deg
    def __init__(self, value, input_unit: str='deg', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class AngleRadians(CIMUnit):
    '''
    Phase angle in radians.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.rad
    def __init__(self, value, input_unit: str='rad', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ApparentPower(CIMUnit):
    '''
    Product of the RMS value of the voltage and the RMS value of the current.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.VA
    def __init__(self, value, input_unit: str='VA', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Area(CIMUnit):
    '''
    Area.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.m2
    def __init__(self, value, input_unit: str='m2', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Capacitance(CIMUnit):
    '''
    Capacitive part of reactance (imaginary part of impedance), at rated frequency.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.F
    def __init__(self, value, input_unit: str='F', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Conductance(CIMUnit):
    '''
    Factor by which voltage must be multiplied to give corresponding power
    lost from a circuit. Real part of admittance.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.S
    def __init__(self, value, input_unit: str='S', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ConductancePerLength(CIMUnit):
    '''
    Real part of admittance per unit of length.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.SPerm
    def __init__(self, value, input_unit: str='SPerm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class CostPerEnergyUnit(CIMUnit):
    '''
    Cost, in units of currency, per quantity of electrical energy generated.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.none
    def __init__(self, value, input_unit: str='none', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class CostPerHeatUnit(CIMUnit):
    '''
    Cost, in units of currency, per quantity of heat generated.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.none
    def __init__(self, value, input_unit: str='none', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class CostPerVolume(CIMUnit):
    '''
    Cost per unit volume.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.none
    def __init__(self, value, input_unit: str='none', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class CostRate(CIMUnit):
    '''
    Cost, in units of currency, per elapsed time.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.none
    def __init__(self, value, input_unit: str='none', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class CurrentFlow(CIMUnit):
    '''
    Electrical current with sign convention: positive flow is out of the conducting
    equipment into the connectivity node. Can be both AC and DC.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.A
    def __init__(self, value, input_unit: str='A', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Displacement(CIMUnit):
    '''
    Unit of displacement relative a reference position, hence can be negative.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.m
    def __init__(self, value, input_unit: str='m', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Emission(CIMUnit):
    '''
    Quantity of emission per fuel heat content.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.kgPerJ
    def __init__(self, value, input_unit: str='kgPerJ', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Frequency(CIMUnit):
    '''
    Cycles per second.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.Hz
    def __init__(self, value, input_unit: str='Hz', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class HeatRate(CIMUnit):
    '''
    Heat generated, in energy pertime unit of elapsed time.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.J
    def __init__(self, value, input_unit: str='J', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Production'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Hours(CIMUnit):
    '''
    Time specified in hours.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.h
    def __init__(self, value, input_unit: str='h', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Impedance(CIMUnit):
    '''
    Ratio of voltage to current.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohm
    def __init__(self, value, input_unit: str='ohm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class KiloActivePower(CIMUnit):
    '''
    Active power in kilowatts.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.k)
    @property # read-only
    def unit(self):
        return UnitSymbol.W
    def __init__(self, value, input_unit: str='W', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Length(CIMUnit):
    '''
    Unit of length. Never negative.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.m
    def __init__(self, value, input_unit: str='m', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Money(CIMUnit):
    '''
    Amount of money.
    '''

    value: str = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.none
    def __init__(self, value, input_unit: str='none', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class PU(CIMUnit):
    '''
    Per Unit - a positive or negative value referred to a defined base. Values
    typically range from -10 to +10.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.none
    def __init__(self, value, input_unit: str='none', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class PerCent(CIMUnit):
    '''
    Percentage on a defined base. For example, specify as 100 to indicate at
    the defined base.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.none
    def __init__(self, value, input_unit: str='none', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Pressure(CIMUnit):
    '''
    Pressure in Pascal.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.Pa
    def __init__(self, value, input_unit: str='Pa', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Reactance(CIMUnit):
    '''
    Reactance (imaginary part of impedance), at rated frequency.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohm
    def __init__(self, value, input_unit: str='ohm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ReactancePerLength(CIMUnit):
    '''
    Reactance (imaginary part of impedance) per unit of length, at rated frequency.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohmPerm
    def __init__(self, value, input_unit: str='ohmPerm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ReactivePower(CIMUnit):
    '''
    Product of RMS value of the voltage and the RMS value of the quadrature
    component of the current.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.VAr
    def __init__(self, value, input_unit: str='VAr', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class RealEnergy(CIMUnit):
    '''
    Real electrical energy.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.Wh
    def __init__(self, value, input_unit: str='Wh', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Resistance(CIMUnit):
    '''
    Resistance (real part of impedance).
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohm
    def __init__(self, value, input_unit: str='ohm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class ResistancePerLength(CIMUnit):
    '''
    Resistance (real part of impedance) per unit of length.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.ohmPerm
    def __init__(self, value, input_unit: str='ohmPerm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class RotationSpeed(CIMUnit):
    '''
    Number of revolutions per second.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.Hz
    def __init__(self, value, input_unit: str='Hz', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Seconds(CIMUnit):
    '''
    Time, in seconds.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.s
    def __init__(self, value, input_unit: str='s', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Susceptance(CIMUnit):
    '''
    Imaginary part of admittance.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.S
    def __init__(self, value, input_unit: str='S', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class SusceptancePerLength(CIMUnit):
    '''
    Imaginary part of admittance per unit of length.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.SPerm
    def __init__(self, value, input_unit: str='SPerm', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Temperature(CIMUnit):
    '''
    Value of temperature in degrees Celsius.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.degC
    def __init__(self, value, input_unit: str='degC', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Voltage(CIMUnit):
    '''
    Electrical voltage, can be both AC and DC.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.V
    def __init__(self, value, input_unit: str='V', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class VoltagePerReactivePower(CIMUnit):
    '''
    Voltage variation with reactive power.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.VPerVAr
    def __init__(self, value, input_unit: str='VPerVAr', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class Volume(CIMUnit):
    '''
    Volume.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.m3
    def __init__(self, value, input_unit: str='m3', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class VolumeFlowRate(CIMUnit):
    '''
    Volume per time.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.m3Pers
    def __init__(self, value, input_unit: str='m3Pers', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@stereotype(CIMStereotype.CIMDatatype)
@dataclass(repr=False)
class WaterLevel(CIMUnit):
    '''
    Reservoir water level referred to a given datum such as mean sea level.
    '''

    value: float = field(default=None)
    multiplier: UnitMultiplier = field(default=UnitMultiplier.none)
    @property # read-only
    def unit(self):
        return UnitSymbol.m
    def __init__(self, value, input_unit: str='m', input_multiplier: str=None):
        self.__pint__(value=value, input_unit=input_unit, input_multiplier=input_multiplier)
    @property
    def __namespace__(self):
        return '#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return '1'
    

@dataclass(repr=False)
class DateInterval(Identity):
    '''
    Interval between two dates.
    '''

    end: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            End date of this interval.
            '''
        
        })
    '''
    End date of this interval.
    '''
    
    start: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Start date of this interval.
            '''
        
        })
    '''
    Start date of this interval.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DateTimeInterval(Identity):
    '''
    Interval between two date and time points.
    '''

    end: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            End date and time of this interval.
            '''
        
        })
    '''
    End date and time of this interval.
    '''
    
    start: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Start date and time of this interval.
            '''
        
        })
    '''
    Start date and time of this interval.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class DecimalQuantity(Identity):
    '''
    '''

    value: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    currency: Optional[ Currency ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Quantity with decimal value and associated unit or currency information.
            '''
        
        })
    '''
    Quantity with decimal value and associated unit or currency information.
    '''
    
    multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@stereotype(CIMStereotype.Compound)
@stereotype(CIMStereotype.Attribute)
@dataclass(repr=False)
class FaultImpedance(Identity):
    '''
    Impedance description for the fault.
    '''

    rGround: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The resistance of the fault between phases and ground.
            '''
        
        })
    '''
    The resistance of the fault between phases and ground.
    '''
    
    rLineToLine: Optional[ float | Resistance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The resistance of the fault between phases.
            '''
        
        })
    '''
    The resistance of the fault between phases.
    '''
    
    xGround: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reactance of the fault between phases and ground.
            '''
        
        })
    '''
    The reactance of the fault between phases and ground.
    '''
    
    xLineToLine: Optional[ float | Reactance ] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            The reactance of the fault between phases.
            '''
        
        })
    '''
    The reactance of the fault between phases.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Faults'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class FloatQuantity(Identity):
    '''
    Quantity with float value and associated unit information.
    '''

    value: Optional[float] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class IntegerQuantity(Identity):
    '''
    Quantity with integer value and associated unit information.
    '''

    value: Optional[int] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class MonthDayInterval(Identity):
    '''
    Interval between two times specified as mont and date.
    '''

    end: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            End time of this interval.
            '''
        
        })
    '''
    End time of this interval.
    '''
    
    start: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Start time of this interval.
            '''
        
        })
    '''
    Start time of this interval.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class StringQuantity(Identity):
    '''
    Quantity with string value (when it is not important whether it is an integral
    or a floating point number) and associated unit information.
    '''

    value: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    multiplier: Optional[ UnitMultiplier ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    unit: Optional[ UnitSymbol ] = field(
        default=None,
        metadata={
        'type': 'enumeration Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            '''
        
        })
    '''
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
@dataclass(repr=False)
class TimeInterval(Identity):
    '''
    Interval between two times.
    '''

    end: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            End time of this interval.
            '''
        
        })
    '''
    End time of this interval.
    '''
    
    start: Optional[str] = field(
        default=None,
        metadata={
        'type': 'Attribute',
        'minOccurs': '0',
        'maxOccurs': '1',
        'namespace': 'http://iec.ch/TC57/CIM100#',
        'docstring':
            '''
            Start time of this interval.
            '''
        
        })
    '''
    Start time of this interval.
    '''
    
    @property
    def __namespace__(self):
        return 'http://iec.ch/TC57/CIM100#'
    @property
    def __package__(self):
        return 'Domain'
    @property
    def __minOccurs__(self):
        return '0'
    @property
    def __maxOccurs__(self):
        return 'unbounded'
    
