from __future__ import annotations

from dataclasses import dataclass, field


@dataclass
class ClassesWithoutMRID:
    def __init__(self):
        self.classes=[
            'IEC61968CIMVersion',
            'WirePhaseInfo',
            'CalculationMethodOrder',
            'FieldDispatchStep',
            'PositionPoint',
            'ScheduledEventData',
            'UserAttribute',
            'AccountNotification',
            'CustomerNotification',
            'DERCurveData',
            'DERFunction',
            'DERMonitorableParameter',
            'DispatchablePowerCapability',
            'DispatchSchedule',
            'EndDeviceAction',
            'EndDeviceEventDetail',
            'IntervalBlock',
            'PanDemandResponse',
            'PanDisplay',
            'PanPricing',
            'PanPricingDetail',
            'PendingCalculation',
            'ReadingQuality',
            'EstimatedRestorationTime',
            'OutageArea',
            'SwitchingStep',
            'SwitchingStepGroup',
            'Card',
            'Cheque',
            'ConsumptionTariffInterval',
            'TimeTariffInterval',
            'RepairItem',
            'IEC61970CIMVersion',
            'CurveData',
            'IrregularTimePoint',
            'Name',
            'NameType',
            'NameTypeAuthority',
            'OperatingShare',
            'RegularTimePoint',
            'DiagramObjectGluePoint',
            'DiagramObjectPoint',
            'PublicX509Certificate',
            'MeasurementValueQuality',
            'Quality61850',
            'BranchGroupTerminal',
            'StateVariable',
            'SvInjection',
            'SvPowerFlow',
            'SvShuntCompensatorSections',
            'SvStatus',
            'SvSwitch',
            'SvTapStep',
            'SvVoltage',
            'NonlinearShuntCompensatorPhasePoint',
            'NonlinearShuntCompensatorPoint',
            'PhaseImpedanceData',
            'PhaseTapChangerTablePoint',
            'RatioTapChangerTablePoint',
            'TapChangerTablePoint',
            'ProprietaryParameterDynamics',
            'IEC62325CIMVersion',
            'AtmosphericPhenomenon',
            'CloudCondition',
            'Cyclone',
            'Earthquake',
            'EnvironmentalLocationType',
            'EnvironmentalPhenomenon',
            'Fire',
            'Flood',
            'GeosphericPhenomenon',
            'Hurricane',
            'HydrosphericPhenomenon',
            'Landslide',
            'LightningStrike',
            'MagneticStorm',
            'ReportingCapability',
            'SpacePhenomenon',
            'Tornado',
            'TropicalCycloneAustralia',
            'Tsunami',
            'VolcanicAshCloud',
            'Whirlpool',
            'ResourceCapacity',
            'AceTariffType',
            'AttributeInstanceComponent',
            'ConstraintDuration',
            'DateAndOrTime',
            'FlowDirection',
            'MarketObjectStatus',
            'Period',
            'Point',
            'Price',
            'Quantity',
            'Reason',
            'Unit',
            'MarketInvoice',
            'MarketInvoiceLineItem',
            'MarketLedger',
            'MarketLedgerEntry',
            'MktUserAttribute',
            'PlannedMarket',
            'AllocationResult',
            'AllocationResultValues',
            'AuxiliaryCost',
            'AuxiliaryObject',
            'AuxiliaryValues',
            'ExpectedEnergy',
            'ExpectedEnergyValues',
            'FiveMinAuxiliaryData',
            'TenMinAuxiliaryData',
            'TradingHubPrice',
            'TradingHubValues',
            'AnalogMeasurementValueQuality',
            'ASRequirements',
            'BranchEndFlow',
            'ControlAreaSolutionData',
            'DefaultBidCurveData',
            'DiscreteMeasurementValueQuality',
            'DistributionFactorSet',
            'GenDistributionFactor',
            'GeneratingUnitDynamicValues',
            'InterchangeETCData',
            'LoadDistributionFactor',
            'MWLimitSchedule',
            'ProfileData',
            'SCADAInformation',
            'ShuntCompensatorDynamicData',
            'SwitchStatus',
            'SysLoadDistributionFactor',
            'TapChangerDynamicData',
            'TransferInterfaceSolution',
            'TransmissionCapacity',
            'TransmissionInterfaceRightEntitlement',
            'TransmissionReservation',
            'TREntitlement',
            'ChargeProfileData',
            'Commitments',
            'CommodityPrice',
            'DopInstruction',
            'DotInstruction',
            'ExPostLossResults',
            'ExPostMarketRegionResults',
            'ExPostPricingResults',
            'ExPostResourceResults',
            'GeneralClearingResults',
            'Instructions',
            'LoadFollowingOperatorInput',
            'LossClearingResults',
            'MarketRegionResults',
            'MarketResults',
            'MitigatedBidSegment',
            'MPMResourceStatus',
            'MPMTestResults',
            'PnodeResults',
            'PriceDescriptor',
            'ResourceAwardInstruction',
            'ResourceDeploymentStatus',
            'ResourceDispatchResults',
            'ResourceLoadFollowingInst',
            'RMRDetermination',
            'RUCAwardInstruction',
            'SelfScheduleBreakdown',
            'ActionRequest',
            'AttributeProperty',
            'BidDistributionFactor',
            'EnergyPriceCurve',
            'InterTieDispatchResponse',
            'LoadFollowingInst',
            'TradeProduct',
            'BidPriceCap',
            'CombinedCycleTransitionState',
            'ContractDistributionFactor',
            'ControlAreaDesignation',
            'FlowgateRelief',
            'FlowgateValue',
            'GasPrice',
            'LoadRatio',
            'MPMTestThreshold',
            'OilPrice',
            'PnodeDistributionFactor',
            'ResourceCertification',
            'ResourceStartupCost',
            'ResourceVerifiableCosts',
            'SchedulingCoordinatorUser',
            'SubstitutionResourceList',
            'PackageDependenciesCIMVersion',
            'WorkTimeScheduleKind' ]
        self.units = [
            'WPerHz',
            'g'
        ]

@dataclass
class ClassesWithManytoMany:
    def __init__(self):
        self.attributes=[
            'ConnectivityNode.OperationalLimitSet',
            'ACDCTerminal.OperationalLimitSet',
            'ShortCircuitTest.GroundedEnds',
            'TransformerMeshImpedance.ToTransformerEnd',
            'TransformerMeshImpedance.ToTransformerEndInfos',
            'Equipment.AdditionalEquipmentContainer'
        ]
