from __future__ import annotations

import logging
from dataclasses import dataclass, field
from enum import Enum
from typing import Optional

from cimgraph.data_profile.identity import Identity

_log = logging.getLogger(__name__)
'''
    Annotated CIMantic Graphs data profile for Profile
    Generated by CIMTool http://cimtool.org
'''

BASE_URI = 'http://iec.ch/TC57/2007/profile#'
ONTOLOGY_URI = 'http://iec.ch/TC57/CIM100#'

@dataclass(repr=False)
class AccountNotification(Identity):
    '''
    Notifications for move-in, move-out, delinquencies, etc.
    '''

    customerNotificationType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    methodType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    note: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    time: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    CustomerAccount: Optional[CustomerAccount] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CustomerAccount.AccountNotification',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class BranchGroupTerminal(Identity):
    '''
    A specific directed terminal flow for a branch group.
    '''

    positiveFlowIn: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The flow into the terminal is summed if set true. The flow out of the terminanl
    is summed if set false.
    '''

    BranchGroup: Optional[BranchGroup] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BranchGroup.BranchGroupTerminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The branch group to which the directed branch group terminals belong.
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.BranchGroupTerminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The terminal to be summed.
    '''

@dataclass(repr=False)
class CurveData(Identity):
    '''
    Multi-purpose data points for defining a curve. The use of this generic
    class is discouraged if a more specific class can be used to specify the
    x and y axis values along with their specific data types.
    '''

    xvalue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The data value of the X-axis variable, depending on the X-axis units.
    '''

    y1value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The data value of the first Y-axis variable, depending on the Y-axis units.
    '''

    y2value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The data value of the second Y-axis variable (if present), depending on
    the Y-axis units.
    '''

    y3value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The data value of the third Y-axis variable (if present), depending on
    the Y-axis units.
    '''

    Curve: Optional[Curve] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Curve.CurveDatas',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The curve of this curve data point.
    '''

@dataclass(repr=False)
class CustomerNotification(Identity):
    '''
    Conditions for notifying the customer about the changes in the status of
    their service (e.g., outage restore, estimated restoration time, tariff
    or service level change, etc.)
    '''

    contactType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of contact (e.g., phone, email, etc.).
    '''

    contactValue: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Value of contact type (e.g., phone number, email address, etc.).
    '''

    earliestDateTimeToCall: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Earliest date time to call the customer.
    '''

    latestDateTimeToCall: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Latest date time to call the customer.
    '''

    trigger: Optional[ NotificationTriggerKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Trigger for this notification.
    '''

    Customer: Optional[Customer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Customer.CustomerNotifications',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Customer requiring this notification.
    '''

    TroubleTickets: list[TroubleTicket] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TroubleTicket.Notification',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All trouble tickets with this notification.
    '''

@dataclass(repr=False)
class DERCurveData(Identity):
    '''
    '''

    intervalNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    maxYValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    minYValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    nominalYValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    timeStamp: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    DERMonitorableParameter: Optional[DERMonitorableParameter] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DERMonitorableParameter.DERCurveData',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    DispatchSchedule: Optional[DispatchSchedule] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DispatchSchedule.DERCurveData',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class DERFunction(Identity):
    '''
    '''

    connectDisconnect: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    frequencyWattCurveFunction: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    maxRealPowerLimiting: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    rampRateControl: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    reactivePowerDispatch: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    realPowerDispatch: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltageRegulation: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltVarCurveFunction: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltWattCurveFunction: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    EndDeviceGroup: list[EndDeviceGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceGroup.DERFunction',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class DERMonitorableParameter(Identity):
    '''
    '''

    yUnitInstalledMax: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    yUnitInstalledMin: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    DERParameter: Optional[ DERParameterKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    flowDirection: Optional[ FlowDirectionKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    yMultiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    yUnit: Optional[ DERUnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    DERCurveData: Optional[DERCurveData] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DERCurveData.DERMonitorableParameter',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    DispatchSchedule: list[DispatchSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DispatchSchedule.DERMonitorableParameter',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    EndDeviceGroup: list[EndDeviceGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceGroup.DERMonitorableParameter',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class DispatchSchedule(Identity):
    '''
    '''

    numberOfIntervals: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Used to specify the number of intervals when requesting a forecast or a
    dispatch.
    '''

    startTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The start time of the first interval in the dispatch schedule
    '''

    timeIntervalDuration: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The length of time for each interval in the dispatch schedule.
    '''

    confidence: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    curveStyleKind: Optional[ CurveStyle ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Used to specify whether the values over an interval are constant (constantYValue)
    or linearly interpolated (straightLineYValues)
    '''

    timeIntervalUnit: Optional[ TimeIntervalKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The unit of measure for the time axis of the dispatch schedule.
    '''

    DERCurveData: list[DERCurveData] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DERCurveData.DispatchSchedule',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    DERMonitorableParameter: Optional[DERMonitorableParameter] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DERMonitorableParameter.DispatchSchedule',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class DispatchablePowerCapability(Identity):
    '''
    '''

    currentActivePower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Product of RMS value of the voltage and the RMS value of the in-phase component
    of the current
    '''

    currentApparentPower: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Product of the RMS value of the voltage and the RMS value of the current
    '''

    currentReactivePower: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Product of RMS value of the voltage and the RMS value of the quadrature
    component of the current
    '''

    maxActivePower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Product of RMS value of the voltage and the RMS value of the in-phase component
    of the current
    '''

    maxApparentPower: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Product of the RMS value of the voltage and the RMS value of the current
    '''

    maxReactivePower: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Product of RMS value of the voltage and the RMS value of the quadrature
    component of the current
    '''

    minActivePower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Product of RMS value of the voltage and the RMS value of the in-phase component
    of the current
    '''

    minApparentPower: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Product of the RMS value of the voltage and the RMS value of the current
    '''

    minReactivePower: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Product of RMS value of the voltage and the RMS value of the quadrature
    component of the current
    '''

    EndDevice: Optional[EndDevice] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EndDevice.DispatchablePowerCapability',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    EndDeviceGroup: Optional[EndDeviceGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EndDeviceGroup.DispatchablePowerCapability',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class EndDeviceAction(Identity):
    '''
    Action/command performed by an end device on a device other than the end
    device.
    '''

    command: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Command text.
    '''

    durationIndefinite: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if the action of this control is indefinite.
    '''

    startDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Start date and time for action of this control.
    '''

    duration: Optional[ float | Minutes ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Amount of time the action of this control is to remain active.
    '''

    EndDeviceControl: Optional[EndDeviceControl] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EndDeviceControl.EndDeviceAction',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    End device control issuing this end device action.
    '''

@dataclass(repr=False)
class EndDeviceEventDetail(Identity):
    '''
    Name-value pair, specific to end device events.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Name.
    '''

    EndDeviceEvent: Optional[EndDeviceEvent] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EndDeviceEvent.EndDeviceEventDetails',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    End device owning this detail.
    '''

    value: Optional[StringQuantity] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Value, including unit information.
    '''

@dataclass(repr=False)
class EnvironmentalLocationType(Identity):
    '''
    Kind of environmental location. Used when an environmental alert or phenomenon
    has multiple locations associated with it.
    '''

    kind: Optional[ LocationKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The kind of location. Typical values might be center, extent, primary,
    secondary, etc.
    '''

    EnvironmentalAlert: list[EnvironmentalAlert] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalAlert.EnvironmentalLocationKind',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Environmental alert applying to location of this type.
    '''

    EnvironmentalPhenomenon: list[EnvironmentalPhenomenon] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalPhenomenon.EnvironmentalLocationKind',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Environmental phenomenon for which this location is of relevance.
    '''

    Location: Optional[Location] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Location.EnvironmentalLocationKind',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Location of this instance of ths kind of environmental location.
    '''

@dataclass(repr=False)
class Estimate(Identity):
    '''
    '''

    timeStamp: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    SvEstVoltages: list[SvEstVoltage] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SvEstVoltage.Estimate',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class FieldDispatchStep(Identity):
    '''
    Details of the step in the field dispatch history.
    '''

    occurredDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The date and time at which the dispatch status occurred.
    '''

    remarks: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    freeform comments related to the dispatch to perform field work.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The sequence number of the field dispatch step within the field dispatch
    history. Begins with 1 and increments up.
    '''

    dispatchStatus: Optional[ CrewStatusKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The status of one or more crews dispatched to perform field work at one
    or more work sites
    '''

    FieldDispatchHistory: Optional[FieldDispatchHistory] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'FieldDispatchHistory.FieldDispatchStep',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class IEC61970CIMVersion(Identity):
    '''
    This is the IEC 61970 CIM version number assigned to this UML model.
    '''

    date: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Form is YYYY-MM-DD for example for January 5, 2009 it is 2009-01-05.
    '''

    version: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Form is IEC61970CIMXXvYY where XX is the major CIM package version and
    the YY is the minor version. For example IEC61970CIM13v18.
    '''

@dataclass(repr=False)
class IEEE1547ControlSettings(Identity):
    '''
    '''

    constantPowerFactor: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    constantReactivePower: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    enterServiceIntentionalDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    enterServiceMaxFrequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    enterServiceMaxVoltage: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    enterServiceMinFrequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    enterServiceMinVoltage: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    frequencyDroopResponseTime: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    openLoopResponseTimeP: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    overFrequencyDeadband: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    overFrequencyDroop: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    timeConstantOpenLoop: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    timeConstantReferenceVoltage: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    underFrequencyDeadband: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    underFrequencyDroop: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltVarQ1: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltVarQ2: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltVarQ3: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltVarQ4: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltVarV1: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltVarV2: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltVarV3: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltVarV4: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltWattP1: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltWattP2: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltWattV1: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    voltWattV2: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    wattVarP1: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    wattVarP2: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    wattVarP3: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    wattVarP4: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    wattVarQ1: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    wattVarQ2: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    wattVarQ3: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    wattVarQ4: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    PowerElectronicsConnections: list[PowerElectronicsConnection] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerElectronicsConnection.IEEE1547ControlSettings',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    RotatingMachines: list[RotatingMachine] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RotatingMachine.IEEE1547ControlSettings',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class IEEE1547Setting(Identity):
    '''
    '''

    constantPowerFactor: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    constantReactivePower: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    enterServiceIntentionalDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    enterServiceMaxFrequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    enterServiceMaxVoltage: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    enterServiceMinFrequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    enterServiceMinVoltage: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    frequencyDroopResponseTime: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    islandClearingTime: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    openLoopResponseTimeP: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    overFrequencyDeadband: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    overFrequencyDroop: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    timeConstantOpenLoop: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    timeConstantReferenceVoltage: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    underFrequencyDeadband: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    underFrequencyDroop: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    OvervoltageTripCurve: Optional[OvervoltageTripCurve] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EAID_26DFC4B4_9E7F_488d_82B7_26E18A2E54E2-B',
            'namespace': 'http://langdale.com.au/2005/xuid#'
        })
    '''
    '''

    UndervoltageTripCurve: Optional[UndervoltageTripCurve] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EAID_29648B78_9038_4314_89F8_6A07D6158A80-B',
            'namespace': 'http://langdale.com.au/2005/xuid#'
        })
    '''
    '''

    UnderfrequencyTripCurve: Optional[UnderfrequencyTripCurve] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EAID_315D7D6E_DEAA_4999_AB90_B9C449ED6363-B',
            'namespace': 'http://langdale.com.au/2005/xuid#'
        })
    '''
    '''

    OverfrequencyTripCurve: Optional[OverfrequencyTripCurve] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EAID_36815FB1_4B85_4e53_807D_FF942E1679D3-B',
            'namespace': 'http://langdale.com.au/2005/xuid#'
        })
    '''
    '''

    VoltWattCurve: Optional[VoltWattCurve] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EAID_6F7B070E_B26B_498f_9B1D_37815DE7C15F-B',
            'namespace': 'http://langdale.com.au/2005/xuid#'
        })
    '''
    '''

    WattVarCurve: Optional[WattVarCurve] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EAID_8895BCB7_5009_4d7e_9792_506CF9FBDFAA-B',
            'namespace': 'http://langdale.com.au/2005/xuid#'
        })
    '''
    '''

    VoltVarCurve: Optional[VoltVarCurve] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EAID_AE55D6FB_BD98_4281_8F54_97938E525070-B',
            'namespace': 'http://langdale.com.au/2005/xuid#'
        })
    '''
    '''

    PowerElectronicsConnections: list[PowerElectronicsConnection] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerElectronicsConnection.IEEE1547Setting',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    RotatingMachines: list[RotatingMachine] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RotatingMachine.IEEE1547Setting',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class IEEE1547TripSettings(Identity):
    '''
    '''

    OF1frequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    OF1time: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    OF2frequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    OF2time: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    OV1time: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    OV1voltage: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    OV2time: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    OV2voltage: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    UF1frequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    UF1time: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    UF2frequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    UF2time: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    UV1time: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    UV1voltage: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    UV2time: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    UV2voltage: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    PowerElectronicsConnections: list[PowerElectronicsConnection] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerElectronicsConnection.IEEE1547TripSettings',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    RotatingMachines: list[RotatingMachine] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RotatingMachine.IEEE1547TripSettings',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class IdentifiedObject(Identity):
    '''
    This is a root class to provide common identification for all classes needing
    identification and naming attributes.
    '''

    mRID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Master resource identifier issued by a model authority. The mRID is unique
    within an exchange context. Global uniqueness is easily achieved by using
    a UUID, as specified in RFC 4122, for the mRID. The use of UUID is strongly
    recommended.
    For CIMXML data files in RDF syntax conforming to IEC 61970-552 Edition
    1, the mRID is mapped to rdf:ID or rdf:about attributes that identify CIM
    object elements.
    '''

    aliasName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The aliasName is free text human readable name of the object alternative
    to IdentifiedObject.name. It may be non unique and may not correlate to
    a naming hierarchy.
    The attribute aliasName is retained because of backwards compatibility
    between CIM relases. It is however recommended to replace aliasName with
    the Name class as aliasName is planned for retirement at a future time.
    '''

    description: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The description is a free human readable text describing or naming the
    object. It may be non unique and may not correlate to a naming hierarchy.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The name is any free human readable and possibly non unique text naming
    the object.
    '''

    Names: list[Name] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Name.IdentifiedObject',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All names of this identified object.
    '''

@dataclass(repr=False)
class ACDCTerminal(IdentifiedObject):
    '''
    An electrical connection point (AC or DC) to a piece of conducting equipment.
    Terminals are connected at physical connection points called connectivity
    nodes.
    '''

    connected: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The connected status is related to a bus-branch model and the topological
    node to terminal relation. True implies the terminal is connected to the
    related topological node and false implies it is not.
    In a bus-branch model, the connected status is used to tell if equipment
    is disconnected without having to change the connectivity described by
    the topological node to terminal relation. A valid case is that conducting
    equipment can be connected in one end and open in the other. In particular
    for an AC line segment, where the reactive line charging can be significant,
    this is a relevant case.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The orientation of the terminal connections for a multiple terminal conducting
    equipment. The sequence numbering starts with 1 and additional terminals
    should follow in increasing order. The first terminal is the "starting
    point" for a two terminal branch.
    '''

    BusNameMarker: Optional[BusNameMarker] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BusNameMarker.Terminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The bus name marker used to name the bus (topological node).
    '''

    Measurements: list[Measurement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Measurement.Terminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Measurements associated with this terminal defining where the measurement
    is placed in the network topology. It may be used, for instance, to capture
    the sensor position, such as a voltage transformer (PT) at a busbar or
    a current transformer (CT) at the bar between a breaker and an isolator.
    '''

    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperationalLimitSet.Terminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class Terminal(ACDCTerminal):
    '''
    An AC electrical connection point to a piece of conducting equipment. Terminals
    are connected at physical connection points called connectivity nodes.
    '''

    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'BranchGroupTerminal.Terminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The directed branch group terminals for which this terminal is monitored.
    '''

    Bushing: Optional[Bushing] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Bushing.Terminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ConductingEquipment: Optional[ConductingEquipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConductingEquipment.Terminals',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The conducting equipment of the terminal. Conducting equipment have terminals
    that may be connected to other conducting equipment terminals via connectivity
    nodes or topological nodes.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConnectivityNode.Terminals',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The connectivity node to which this terminal connects with zero impedance.
    '''

    EquipmentFaults: list[EquipmentFault] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EquipmentFault.Terminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The equipment faults at this terminal.
    '''

    HasFirstMutualCoupling: list[MutualCoupling] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MutualCoupling.First_Terminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Mutual couplings associated with the branch as the first branch.
    '''

    HasSecondMutualCoupling: list[MutualCoupling] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MutualCoupling.Second_Terminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Mutual couplings with the branch associated as the first branch.
    '''

    NormalHeadFeeder: Optional[Feeder] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Feeder.NormalHeadTerminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The feeder that this terminal normally feeds. Only specifed for the terminals
    at head of feeders.
    '''

    RegulatingControl: list[RegulatingControl] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RegulatingControl.Terminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The controls regulating this terminal.
    '''

    SvPowerFlow: list[SvPowerFlow] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SvPowerFlow.Terminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The power flow state variable associated with the terminal.
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalNode.Terminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The topological node associated with the terminal. This can be used as
    an alternative to the connectivity node path to topological node, thus
    making it unneccesary to model connectivity nodes in some cases. Note that
    the if connectivity nodes are in the model, this association would probably
    not be used as an input specification.
    '''

    TransformerEnd: list[TransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEnd.Terminal',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All transformer ends connected at this terminal.
    '''

@dataclass(repr=False)
class ActivityRecord(IdentifiedObject):
    '''
    Records activity for an entity at a point in time; activity may be for
    an event that has already occurred or for a planned activity.
    '''

    createdDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time this activity record has been created (different from the
    'status.dateTime', which is the time of a status change of the associated
    object, if applicable).
    '''

    reason: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reason for event resulting in this activity record, typically supplied
    when user initiated.
    '''

    severity: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Severity level of event resulting in this activity record.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of event resulting in this activity record.
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.ActivityRecords',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All assets for which this activity record has been created.
    '''

    Author: Optional[Author] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Author.ActivityRecords',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Author of this activity record.
    '''

    status: Optional[Status] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Information on consequence of event resulting in this activity record.
    '''

@dataclass(repr=False)
class AssetHealthEvent(ActivityRecord):
    '''
    An asset health-related event that is created by an analytic. The event
    is a record of a change in asset health.
    '''

    actionRecommendation: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Recommendation for action.
    '''

    actionTimeline: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Time horizon for action.
    '''

    effectiveDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The date and time when the event is effective.
    '''

    Analytic: Optional[Analytic] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Analytic.AssetHealthEvent',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class ConfigurationEvent(ActivityRecord):
    '''
    Used to report details on creation, change or deletion of an entity or
    its configuration.
    '''

    effectiveDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time this event has or will become effective.
    '''

    modifiedBy: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Source/initiator of modification.
    '''

    remark: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Free text remarks.
    '''

    ChangedAsset: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Asset whose change resulted in this configuration event.
    '''

    ChangedDocument: Optional[Document] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Document.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Document whose change resulted in this configuration event.
    '''

    ChangedLocation: Optional[Location] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Location.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Location whose change resulted in this configuration event.
    '''

    ChangedOrganisationRole: Optional[OrganisationRole] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'OrganisationRole.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Organisation role whose change resulted in this configuration event.
    '''

    ChangedPersonRole: Optional[PersonRole] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PersonRole.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Person role whose change resulted in this configuration event.
    '''

    ChangedServiceCategory: Optional[ServiceCategory] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ServiceCategory.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Service category whose change resulted in this configuration event.
    '''

    ChangedUsagePoint: Optional[UsagePoint] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'UsagePoint.ConfigurationEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Usage point whose change resulted in this configuration event.
    '''

    FaultCauseType: Optional[FaultCauseType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'FaultCauseType.ConfigurationEvent',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerSystemResource.ConfigurationEvent',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class EndDeviceEvent(ActivityRecord):
    '''
    Event detected by a device function associated with the end device.
    '''

    issuerID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Unique identifier of the business entity originating an end device control.
    '''

    issuerTrackingID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Identifier assigned by the initiator (e.g. retail electric provider) of
    an end device control action to uniquely identify the demand response event,
    text message, or other subject of the control action. Can be used when
    cancelling an event or text message request or to identify the originating
    event or text message in a consequential end device event.
    '''

    userID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if user initiated) ID of user who initiated this end device event.
    '''

    EndDevice: Optional[EndDevice] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EndDevice.EndDeviceEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    End device that reported this end device event.
    '''

    EndDeviceEventDetails: list[EndDeviceEventDetail] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceEventDetail.EndDeviceEvent',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All details of this end device event.
    '''

    EndDeviceEventType: Optional[EndDeviceEventType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EndDeviceEventType.EndDeviceEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of this end device event.
    '''

    MeterReading: Optional[MeterReading] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'MeterReading.EndDeviceEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Set of measured values to which this event applies.
    '''

    UsagePoint: Optional[UsagePoint] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'UsagePoint.EndDeviceEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Usage point for which this end device event is reported.
    '''

@dataclass(repr=False)
class EnvironmentalAlert(ActivityRecord):
    '''
    An environmental alert issued by a provider or system.
    '''

    alertType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The type of the issued alert which is drawn from the specified alert type
    list.
    '''

    cancelledDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Time and date alert cancelled. Used only if alert is cancelled before it
    expires.
    '''

    headline: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    An abbreviated textual description of the alert issued.
    Note: the full text of the alert appears in the .description attribute
    (inherited from IdentifiedObject).
    '''

    AlertTypeList: Optional[AlertTypeList] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AlertTypeList.EnvironmentalAlert',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The list of alert types from which the type of this alert is drawn.
    '''

    EnvironmentalDataProvider: Optional[EnvironmentalDataProvider] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnvironmentalDataProvider.EnvironmentalAlert',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Environmental data provider for this alert.
    '''

    EnvironmentalLocationKind: list[EnvironmentalLocationType] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalLocationType.EnvironmentalAlert',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of location to which this environmental alert applies.
    '''

    inEffect: Optional[DateTimeInterval] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The interval for which this weather alert is in effect.
    '''

@dataclass(repr=False)
class AlertTypeList(IdentifiedObject):
    '''
    A named list of alert types.
    Note: the name of the list is reflected in the .name attribute (inherited
    from IdentifiedObject).
    '''

    version: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The version of the named list of alert types.
    '''

    EnvironmentalAlert: list[EnvironmentalAlert] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalAlert.AlertTypeList',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    An alert whose type is drawn from this alert type list.
    '''

    EnvironmentalDataAuthority: Optional[EnvironmentalDataAuthority] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnvironmentalDataAuthority.AlertTypeList',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The environmental data authority responsible for publishing this list of
    alert types.
    '''

@dataclass(repr=False)
class AnalyticScore(IdentifiedObject):
    '''
    An indicative scoring by an analytic that can be used to characterize the
    health of or the risk associated with one or more assets. The analytic
    score reflects the results of an execution of an analytic against an asset
    or group of assets.
    '''

    calculationDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Timestamp of when the score was calculated.
    '''

    effectiveDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date-time for when the score applies.
    '''

    value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Asset health score value.
    '''

    Analytic: Optional[Analytic] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Analytic.AnalyticScore',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Asset: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.AnalyticScore',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    AssetAggregateScore: Optional[AggregateScore] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AggregateScore.AnalyticScore',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    AssetGroup: Optional[AssetGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetGroup.AnalyticScore',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class AggregateScore(AnalyticScore):
    '''
    An aggregated indicative scoring by an analytic, which is based on other
    analytic scores, that can be used to characterize the health of or the
    risk associated with one or more assets.
    '''

    AnalyticScore: list[AnalyticScore] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AnalyticScore.AssetAggregateScore',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class Appointment(IdentifiedObject):
    '''
    Meeting time and location.
    '''

    callAhead: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if requested to call customer when someone is about to arrive at their
    premises.
    '''

    meetingInterval: Optional[DateTimeInterval] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time reserved for appointment.
    '''

    Persons: list[PersonRole] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PersonRole.Appointments',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All persons for this appointment.
    '''

@dataclass(repr=False)
class Asset(IdentifiedObject):
    '''
    Tangible resource of the utility, including power system equipment, various
    end devices, cabinets, buildings, etc. For electrical network equipment,
    the role of the asset is defined through PowerSystemResource and its subclasses,
    defined mainly in the Wires model (refer to IEC61970-301 and model package
    IEC61970::Wires). Asset description places emphasis on the physical characteristics
    of the equipment fulfilling that role.
    '''

    ActivityRecords: list[ActivityRecord] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ActivityRecord.Assets',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All activity records created for this asset.
    '''

    Analytic: list[Analytic] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Analytic.Asset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    AnalyticScore: list[AnalyticScore] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AnalyticScore.Asset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    AssetContainer: Optional[AssetContainer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetContainer.Assets',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Container of this asset.
    '''

    AssetDeployment: Optional[AssetDeployment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetDeployment.Asset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    This asset's deployment.
    '''

    AssetFunction: list[AssetFunction] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AssetFunction.Asset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    AssetGroup: list[AssetGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AssetGroup.Asset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    AssetInfo: Optional[AssetInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetInfo.Assets',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Data applicable to this asset.
    '''

    BreakerOperation: Optional[SwitchOperationSummary] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SwitchOperationSummary.Breaker',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Breaker operation information for this breaker.
    '''

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConfigurationEvent.ChangedAsset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All configuration events created for this asset.
    '''

    FinancialInfo: Optional[FinancialInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'FinancialInfo.Asset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Location: Optional[Location] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Location.Assets',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Location of this asset.
    '''

    Measurements: list[Measurement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Measurement.Asset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Medium: list[Medium] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Medium.Asset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    OrganisationRoles: list[AssetOrganisationRole] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AssetOrganisationRole.Assets',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All roles an organisation plays for this asset.
    '''

    Ownerships: list[Ownership] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Ownership.Asset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All ownerships of this asset.
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerSystemResource.Assets',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All power system resources used to electrically model this asset. For example,
    transformer asset is electrically modelled with a transformer and its windings
    and tap changer.
    '''

    ProcedureDataSet: list[ProcedureDataSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProcedureDataSet.Asset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Procedure data set that applies to this asset.
    '''

    Procedures: list[Procedure] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Procedure.Assets',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All procedures applicable to this asset.
    '''

    ProductAssetModel: Optional[ProductAssetModel] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ProductAssetModel.Asset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The model of this asset.
    '''

    ScheduledEvents: list[ScheduledEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ScheduledEvent.Assets',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class AssetContainer(Asset):
    '''
    Asset that is aggregation of other assets such as conductors, transformers,
    switchgear, land, fences, buildings, equipment, vehicles, etc.
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.AssetContainer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All assets within this container asset.
    '''

    Seals: list[Seal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Seal.AssetContainer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All seals applied to this asset container.
    '''

@dataclass(repr=False)
class DuctBank(AssetContainer):
    '''
    A duct contains individual wires in the layout as specified with associated
    wire spacing instances; number of them gives the number of conductors in
    this duct.
    '''

    circuitCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of circuits in duct bank. Refer to associations between a duct (ConductorAsset)
    and an ACLineSegment to understand which circuits are in which ducts.
    '''

    WireSpacingInfos: list[WireSpacingInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WireSpacingInfo.DuctBank',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class EndDevice(AssetContainer):
    '''
    Asset container that performs one or more end device functions. One type
    of end device is a meter which can perform metering, load management, connect/disconnect,
    accounting functions, etc. Some end devices, such as ones monitoring and
    controlling air conditioners, refrigerators, pool pumps may be connected
    to a meter. All end devices may have communication capability defined by
    the associated communication function(s). An end device may be owned by
    a consumer, a service provider, utility or otherwise.
    There may be a related end device function that identifies a sensor or
    control point within a metering application or communications systems (e.g.,
    water, gas, electricity).
    Some devices may use an optical port that conforms to the ANSI C12.18 standard
    for communications.
    '''

    amrSystem: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Automated meter reading (AMR) or other communication system responsible
    for communications to this end device.
    '''

    installCode: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Installation code.
    '''

    isPan: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, this is a premises area network (PAN) device.
    '''

    isSmartInverter: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    isVirtual: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, there is no physical device. As an example, a virtual meter can
    be defined to aggregate the consumption for two or more physical meters.
    Otherwise, this is a physical hardware device.
    '''

    timeZoneOffset: Optional[ float | Minutes ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Time zone offset relative to GMT for the location of this end device.
    '''

    Customer: Optional[Customer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Customer.EndDevices',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Customer owning this end device.
    '''

    DispatchablePowerCapability: list[DispatchablePowerCapability] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DispatchablePowerCapability.EndDevice',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    EndDeviceControls: list[EndDeviceControl] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceControl.EndDevices',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end device controls sending commands to this end device.
    '''

    EndDeviceEvents: list[EndDeviceEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceEvent.EndDevice',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All events reported by this end device.
    '''

    EndDeviceFunctions: list[EndDeviceFunction] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceFunction.EndDevice',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end device functions this end device performs.
    '''

    EndDeviceGroups: Optional[EndDeviceGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EndDeviceGroup.EndDevices',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end device groups referring to this end device.
    '''

    EndDeviceInfo: Optional[EndDeviceInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EndDeviceInfo.EndDevices',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    End device data.
    '''

    ServiceLocation: Optional[ServiceLocation] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ServiceLocation.EndDevices',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Service location whose service delivery is measured by this end device.
    '''

    UsagePoint: Optional[UsagePoint] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'UsagePoint.EndDevices',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Usage point to which this end device belongs.
    '''

@dataclass(repr=False)
class Meter(EndDevice):
    '''
    Physical asset that performs the metering role of the usage point. Used
    for measuring consumption and detection of events.
    '''

    formNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Meter form designation per ANSI C12.10 or other applicable standard. An
    alphanumeric designation denoting the circuit arrangement for which the
    meter is applicable and its specific terminal arrangement.
    '''

    MeterMultipliers: list[MeterMultiplier] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeterMultiplier.Meter',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All multipliers applied at this meter.
    '''

    MeterReadings: list[MeterReading] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeterReading.Meter',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All meter readings provided by this meter.
    '''

    MeterReplacementWorkTasks: list[MeterWorkTask] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeterWorkTask.OldMeter',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All work tasks on replacement of this old meter.
    '''

    MeterServiceWorkTask: list[MeterWorkTask] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeterWorkTask.Meter',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All non-replacement work tasks on this meter.
    '''

@dataclass(repr=False)
class Structure(AssetContainer):
    '''
    Construction holding assets such as conductors, transformers, switchgear,
    etc. Where applicable, number of conductors can be derived from the number
    of associated wire spacing instances.
    '''

    fumigantAppliedDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date fumigant was last applied.
    '''

    fumigantName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Name of fumigant.
    '''

    removeWeed: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if weeds are to be removed around asset.
    '''

    weedRemovedDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date weed were last removed.
    '''

    height: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Visible height of structure above ground level for overhead construction
    (e.g., Pole or Tower) or below ground level for an underground vault, manhole,
    etc. Refer to associated DimensionPropertiesInfo for other types of dimensions.
    '''

    materialKind: Optional[ StructureMaterialKind ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Material this structure is made of.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum rated voltage of the equipment that can be mounted on/contained
    within the structure.
    '''

    StructureSupports: list[StructureSupport] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'StructureSupport.SecuredStructure',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    WireSpacingInfos: list[WireSpacingInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WireSpacingInfo.Structures',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class Bushing(Asset):
    '''
    Bushing asset.
    '''

    FixedContact: Optional[InterrupterUnit] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'InterrupterUnit.Bushing',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Fixed contact of interrupter to which this bushing is attached.
    '''

    MovingContact: Optional[InterrupterUnit] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'InterrupterUnit.Bushing',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Moving contact of interrupter to which this bushing is attached.
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.Bushing',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class InterrupterUnit(Asset):
    '''
    Breaker interrupter.
    Some interrupters have one fixed and one moving contact, some have 2 fixed
    contacts, some 2 moving contacts. An interrupter will have relationships
    with 2 bushings and those relationships may be any combination of the FixedContact
    and MovingContact associations.
    '''

    Bushing: list[Bushing] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Bushing.MovingContact',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Bushing(s) to which the fixed contact(s) of this interrupter is(are) attached.
    Some interrupters have one fixed and one moving contact, some have 2 fixed
    contacts, some 2 moving contacts. An interrupter will have relationships
    with 2 bushings and those relationships may be any combination of the FixedContact
    and MovingContact associations.
    '''

    OperatingMechanism: Optional[OperatingMechanism] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'OperatingMechanism.InterrupterUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Breaker mechanism controlling this interrupter.
    '''

@dataclass(repr=False)
class OperatingMechanism(Asset):
    '''
    Breaker mechanism.
    '''

    InterrupterUnit: list[InterrupterUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'InterrupterUnit.OperatingMechanism',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Interrupter controlled by this mechanism.
    '''

@dataclass(repr=False)
class StructureSupport(Asset):
    '''
    Support for structure assets.
    '''

    anchorRodCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if anchor) Number of rods used.
    '''

    size: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Size of this support structure.
    '''

    anchorKind: Optional[ AnchorKind ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if anchor) Kind of anchor.
    '''

    anchorRodLength: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if anchor) Length of rod used.
    '''

    direction: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Direction of this support structure.
    '''

    kind: Optional[ StructureSupportKind ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of structure support.
    '''

    length: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Length of this support structure.
    '''

    SecuredStructure: Optional[Structure] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Structure.StructureSupports',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class AssetDeployment(IdentifiedObject):
    '''
    Deployment of asset deployment in a power system resource role.
    '''

    likelihoodOfFailure: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Likelihood of asset failure on a scale of 1(low) to 100 (high).
    '''

    breakerApplication: Optional[ BreakerApplicationKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of network role breaker is playing in this deployment (applies to
    breaker assets only).
    '''

    deploymentState: Optional[ DeploymentStateKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Current deployment state of asset.
    '''

    facilityKind: Optional[ FacilityKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of facility (like substation or pole or building or plant or service
    center) at which asset deployed.
    '''

    transformerApplication: Optional[ TransformerApplicationKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of network role transformer is playing in this deployment (applies
    to transformer assets only).
    '''

    Asset: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.AssetDeployment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Asset in this deployment.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BaseVoltage.NetworkAssetDeployment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Base voltage of this network asset deployment.
    '''

    deploymentDate: Optional[DeploymentDate] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Dates of asset deployment.
    '''

@dataclass(repr=False)
class AssetFunction(IdentifiedObject):
    '''
    Function performed by an asset.
    '''

    configID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Configuration specified for this function.
    '''

    firmwareID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Firmware version.
    '''

    hardwareID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Hardware version.
    '''

    password: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Password needed to access this function.
    '''

    programID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Name of program.
    '''

    Asset: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.AssetFunction',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class EndDeviceFunction(AssetFunction):
    '''
    Function performed by an end device such as a meter, communication equipment,
    controllers, etc.
    '''

    enabled: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if the function is enabled.
    '''

    EndDevice: Optional[EndDevice] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EndDevice.EndDeviceFunctions',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    End device that performs this function.
    '''

    Registers: list[Register] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Register.EndDeviceFunction',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All registers for quantities metered by this end device function.
    '''

@dataclass(repr=False)
class AssetInfo(IdentifiedObject):
    '''
    Set of attributes of an asset, representing typical datasheet information
    of a physical device that can be instantiated and shared in different data
    exchange contexts:
    - as attributes of an asset instance (installed or in stock)
    - as attributes of an asset model (product by a manufacturer)
    - as attributes of a type asset (generic type of an asset as used in designs/extension
    planning).
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.AssetInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All assets described by this data.
    '''

    CatalogAssetType: Optional[CatalogAssetType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CatalogAssetType.AssetInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerSystemResource.AssetDatasheet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All power system resources with this datasheet information.
    '''

    ProductAssetModel: Optional[ProductAssetModel] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ProductAssetModel.AssetInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class BusbarSectionInfo(AssetInfo):
    '''
    Busbar section data.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated current.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated voltage.
    '''

@dataclass(repr=False)
class BushingInfo(AssetInfo):
    '''
    Bushing datasheet information.
    '''

    c1Capacitance: Optional[ float | Capacitance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Factory measured capacitance, measured between the power factor tap and
    the bushing conductor.
    '''

    c1PowerFactor: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Factory measured insulation power factor, measured between the power factor
    tap and the bushing conductor.
    '''

    c2Capacitance: Optional[ float | Capacitance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Factory measured capacitance measured between the power factor tap and
    ground.
    '''

    c2PowerFactor: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Factory measured insulation power factor, measured between the power factor
    tap and ground.
    '''

    insulationKind: Optional[ BushingInsulationKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of insulation.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated current for bushing as installed.
    '''

    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
    '''

    ratedLineToGroundVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated line-to-ground voltage. Also referred to as U<sub>y</sub> on bushing
    nameplate.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated voltage. Can be referred to as U<sub>m</sub>, system voltage or class
    on bushing nameplate.
    '''

@dataclass(repr=False)
class EndDeviceInfo(AssetInfo):
    '''
    End device data.
    '''

    isSolidState: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, this is a solid state end device (as opposed to a mechanical or
    electromechanical device).
    '''

    phaseCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of potential phases the end device supports, typically 0, 1 or 3.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated current.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated voltage.
    '''

    capability: Optional[EndDeviceCapability] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Inherent capabilities of the device (i.e., the functions it supports).
    '''

    EndDevices: list[EndDevice] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDevice.EndDeviceInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end devices described with this data.
    '''

@dataclass(repr=False)
class IEEE1547Info(AssetInfo):
    '''
    '''

    manufacturer: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    model: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    overExcitedPF: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    serialNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    supportsDynamicReactiveCurrent: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    supportsIEC61850: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    supportsIEEE1815: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    supportsIEEE20305: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    supportsIslanding: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    supportsSunSpecModBusEthernet: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    supportsSunSpecModBusRS485: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    supportsVoltWatt: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    supportsWattVar: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    underExcitedPF: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    version: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    abnormalPerformanceCategory: Optional[ IEEE1547AbnormalPerfomanceCategory ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    islandingCategory: Optional[ IEEE1547IslandingCategory ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    maximumU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    minimumU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    normalPerformanceCategory: Optional[ IEEE1547NormalPerformanceCategory ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ratedPatUnityPF: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ratedPcharge: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ratedPoverExcited: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ratedPunderExcited: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ratedQabsorbed: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ratedQinjected: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ratedScharge: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    susceptanceCeaseToEnergize: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    PowerElectronicsConnections: list[PowerElectronicsConnection] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerElectronicsConnection.IEEE1547Info',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    RotatingMachines: list[RotatingMachine] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RotatingMachine.IEEE1547Info',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class InterrupterUnitInfo(AssetInfo):
    '''
    '''

    interruptingMedium: Optional[ InterruptingMediumKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Interrupting medium.
    '''

@dataclass(repr=False)
class OperatingMechanismInfo(AssetInfo):
    '''
    Breaker operating mechanism datasheet information.
    '''

    closeAmps: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Close current (nominal).
    '''

    closeVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Close voltage in volts DC.
    '''

    mechanismKind: Optional[ OperatingMechanismKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of breaker operating mechanism.
    '''

    motorRunCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated motor run current in amps.
    '''

    motorStartCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated motor start current in amps.
    '''

    motorVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Nominal motor voltage in volts DC.
    '''

    tripAmps: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Trip current (nominal).
    '''

    tripVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Trip voltage in volts DC.
    '''

@dataclass(repr=False)
class PowerTransformerInfo(AssetInfo):
    '''
    Set of power transformer data, from an equipment library.
    '''

    TransformerTankInfos: list[TransformerTankInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerTankInfo.PowerTransformerInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Data for all the tanks described by this power transformer data.
    '''

@dataclass(repr=False)
class ShuntCompensatorInfo(AssetInfo):
    '''
    Properties of shunt capacitor, shunt reactor or switchable bank of shunt
    capacitor or reactor assets.
    '''

    maxPowerLoss: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum allowed apparent power loss.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated current.
    '''

    ratedReactivePower: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated reactive power.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated voltage.
    '''

@dataclass(repr=False)
class SwitchInfo(AssetInfo):
    '''
    &lt;was Switch data.&gt;
    Switch datasheet information.
    '''

    isSinglePhase: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, it is a single phase switch.
    '''

    isUnganged: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, the switch is not ganged (i.e., a switch phase may be operated
    separately from other phases).
    '''

    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum fault current a breaking device can break safely under prescribed
    conditions of use.
    '''

    gasWeightPerTank: Optional[ Mass ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Weight of gas in each tank of SF<sub>6</sub> dead tank breaker.
    '''

    lowPressureAlarm: Optional[ float | Pressure ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Gas or air pressure at or below which a low pressure alarm is generated.
    '''

    lowPressureLockOut: Optional[ float | Pressure ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Gas or air pressure below which the breaker will not open.
    '''

    oilVolumePerTank: Optional[ float | Volume ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Volume of oil in each tank of bulk oil breaker.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated current.
    '''

    ratedFrequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Frequency for which switch is rated.
    '''

    ratedImpulseWithstandVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated impulse withstand voltage, also known as BIL (Basic Impulse Level).
    '''

    ratedInterruptingTime: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Switch rated interrupting time in seconds.
    '''

    ratedVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated voltage.
    '''

@dataclass(repr=False)
class TapChangerInfo(AssetInfo):
    '''
    Tap changer data.
    '''

    ctRatio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Built-in current transducer ratio.
    '''

    ptRatio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Built-in voltage transducer ratio.
    '''

    ctRating: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Built-in current transformer primary rating.
    '''

@dataclass(repr=False)
class TransformerEndInfo(AssetInfo):
    '''
    Transformer end data.
    '''

    endNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number for this transformer end, corresponding to the end's order in the
    PowerTransformer.vectorGroup attribute. Highest voltage winding should
    be 1.
    '''

    phaseAngleClock: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Winding phase angle where 360 degrees are represented with clock hours,
    so the valid values are {0, ..., 11}. For example, to express the second
    winding in code 'Dyn11', set attributes as follows: 'endNumber'=2, 'connectionKind'
    = Yn and 'phaseAngleClock' = 11.
    '''

    connectionKind: Optional[ WindingConnection ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of connection.
    '''

    emergencyS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Apparent power that the winding can carry under emergency conditions (also
    called long-term emergency power).
    '''

    insulationU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Basic insulation level voltage rating.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    DC resistance.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal apparent power rating.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated voltage: phase-phase for three-phase windings, and either phase-phase
    or phase-neutral for single-phase windings.
    '''

    shortTermS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Apparent power that this winding can carry for a short period of time (in
    emergency).
    '''

    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerCoreAdmittance.TransformerEndInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Core admittance calculated from this transformer end datasheet, representing
    magnetising current and core losses. The full values of the transformer
    should be supplied for one transformer end info only.
    '''

    EnergisedEndNoLoadTests: list[NoLoadTest] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NoLoadTest.EnergisedEnd',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All no-load test measurements in which this transformer end was energised.
    '''

    EnergisedEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OpenCircuitTest.EnergisedEnd',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All open-circuit test measurements in which this transformer end was excited.
    '''

    EnergisedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ShortCircuitTest.EnergisedEnd',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All short-circuit test measurements in which this transformer end was energised.
    '''

    FromMeshImpedances: list[TransformerMeshImpedance] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerMeshImpedance.FromTransformerEndInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All mesh impedances between this 'to' and other 'from' transformer ends.
    '''

    GroundedEndShortCircuitTests: list[ShortCircuitTest] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ShortCircuitTest.GroundedEnds',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All short-circuit test measurements in which this transformer end was short-circuited.
    '''

    OpenEndOpenCircuitTests: list[OpenCircuitTest] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OpenCircuitTest.OpenEnd',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All open-circuit test measurements in which this transformer end was not
    excited.
    '''

    ToMeshImpedances: list[TransformerMeshImpedance] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerMeshImpedance.ToTransformerEndInfos',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All mesh impedances between this 'from' and other 'to' transformer ends.
    '''

    TransformerStarImpedance: Optional[TransformerStarImpedance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerStarImpedance.TransformerEndInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Transformer star impedance calculated from this transformer end datasheet.
    '''

    TransformerTankInfo: Optional[TransformerTankInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerTankInfo.TransformerEndInfos',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Transformer tank data that this end description is part of.
    '''

@dataclass(repr=False)
class TransformerTankInfo(AssetInfo):
    '''
    Set of transformer tank data, from an equipment library.
    '''

    PowerTransformerInfo: Optional[PowerTransformerInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerTransformerInfo.TransformerTankInfos',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Power transformer data that this tank description is part of.
    '''

    TransformerEndInfos: list[TransformerEndInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEndInfo.TransformerTankInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Data for all the ends described by this transformer tank data.
    '''

@dataclass(repr=False)
class WireAssemblyInfo(AssetInfo):
    '''
    Describes the construction of a multi-conductor wire
    '''

    PerLengthLineParameter: list[PerLengthLineParameter] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PerLengthLineParameter.WireAssemblyInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A WireAssemblyInfo is used to compute the PerLengthParameter data in the
    Wires package
    '''

    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WirePhaseInfo.WireAssemblyInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'WireSpacingInfo.WireAssemblyInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class WireInfo(AssetInfo):
    '''
    Wire data that can be specified per line segment phase, or for the line
    segment as a whole in case its phases all have the same wire characteristics.
    '''

    coreStrandCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if used) Number of strands in the steel core.
    '''

    insulated: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if conductor is insulated.
    '''

    sizeDescription: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Describes the wire gauge or cross section (e.g., 4/0, #2, 336.5).
    '''

    strandCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of strands in the conductor.
    '''

    coreRadius: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if there is a different core material) Radius of the central core.
    '''

    gmr: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Geometric mean radius. If we replace the conductor by a thin walled tube
    of radius GMR, then its reactance is identical to the reactance of the
    actual conductor.
    '''

    insulationMaterial: Optional[ WireInsulationKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if insulated conductor) Material used for insulation.
    '''

    insulationThickness: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if insulated conductor) Thickness of the insulation.
    '''

    material: Optional[ WireMaterialKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Conductor material.
    '''

    rAC25: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    AC resistance per unit length of the conductor at 25 °C.
    '''

    rAC50: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    AC resistance per unit length of the conductor at 50 °C.
    '''

    rAC75: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    AC resistance per unit length of the conductor at 75 °C.
    '''

    radius: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Outside radius of the wire.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Current carrying capacity of the wire under stated thermal conditions.
    '''

    rDC20: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    DC resistance per unit length of the conductor at 20 °C.
    '''

    ACLineSegmentPhases: list[ACLineSegmentPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ACLineSegmentPhase.WireInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WirePhaseInfo.WireInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class CableInfo(WireInfo):
    '''
    Cable data.
    '''

    isStrandFill: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if wire strands are extruded in a way to fill the voids in the cable.
    '''

    sheathAsNeutral: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if sheath / shield is used as a neutral (i.e., bonded).
    '''

    constructionKind: Optional[ CableConstructionKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of construction of this cable.
    '''

    diameterOverCore: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Diameter over the core, including any semi-con screen; should be the insulating
    layer's inside diameter.
    '''

    diameterOverInsulation: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Diameter over the insulating layer, excluding outer screen.
    '''

    diameterOverJacket: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Diameter over the outermost jacketing layer.
    '''

    diameterOverScreen: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Diameter over the outer screen; should be the shield's inside diameter.
    '''

    nominalTemperature: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum nominal design operating temperature.
    '''

    outerJacketKind: Optional[ CableOuterJacketKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of outer jacket of this cable.
    '''

    shieldMaterial: Optional[ CableShieldMaterialKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Material of the shield.
    '''

@dataclass(repr=False)
class ConcentricNeutralCableInfo(CableInfo):
    '''
    Concentric neutral cable data.
    '''

    neutralStrandCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of concentric neutral strands.
    '''

    diameterOverNeutral: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Diameter over the concentric neutral strands.
    '''

    neutralStrandGmr: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Geometric mean radius of the neutral strand.
    '''

    neutralStrandRadius: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Outside radius of the neutral strand.
    '''

    neutralStrandRDC20: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    DC resistance per unit length of the neutral strand at 20 °C.
    '''

@dataclass(repr=False)
class TapeShieldCableInfo(CableInfo):
    '''
    Tape shield cable data.
    '''

    tapeLap: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Percentage of the tape shield width that overlaps in each wrap, typically
    10% to 25%.
    '''

    tapeThickness: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Thickness of the tape shield, before wrapping.
    '''

@dataclass(repr=False)
class OverheadWireInfo(WireInfo):
    '''
    Overhead wire data.
    '''

@dataclass(repr=False)
class WireSpacingInfo(AssetInfo):
    '''
    Wire spacing data that associates multiple wire positions with the line
    segment, and allows to calculate line segment impedances. Number of phases
    can be derived from the number of associated wire positions whose phase
    is not neutral.
    '''

    isCable: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, this spacing data describes a cable.
    '''

    phaseWireCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of wire sub-conductors in the symmetrical bundle (typically between
    1 and 4).
    '''

    phaseWireSpacing: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Distance between wire sub-conductors in a symmetrical bundle.
    '''

    usage: Optional[ WireUsageKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Usage of the associated wires.
    '''

    ACLineSegments: list[ACLineSegment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ACLineSegment.WireSpacingInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    DuctBank: Optional[DuctBank] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DuctBank.WireSpacingInfos',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Structures: list[Structure] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Structure.WireSpacingInfos',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    WireAssemblyInfo: list[WireAssemblyInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WireAssemblyInfo.WireSpacingInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    WirePositions: list[WirePosition] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WirePosition.WireSpacingInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All positions of single wires (phase or neutral) making the conductor.
    '''

@dataclass(repr=False)
class AssetLocationHazard(IdentifiedObject):
    '''
    Potential hazard related to the location of an asset. Examples are trees
    growing under overhead power lines, a park being located by a substation
    (i.e., children climb fence to recover a ball), a lake near an overhead
    distribution line (fishing pole/line contacting power lines), dangerous
    neighbour, etc.
    '''

    kind: Optional[ AssetHazardKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of hazard.
    '''

    Locations: list[Location] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Location.Hazards',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The location of this hazard.
    '''

@dataclass(repr=False)
class BaseFrequency(IdentifiedObject):
    '''
    The class describe a base frequency for a power system network. In case
    of multiple power networks with different frequencies, e.g. 50 or 60 Hertz
    each network will have it's own base frequency class. Hence it is assumed
    that power system objects having different base frequencies appear in separate
    documents where each document has a single base frequency instance.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The base frequency.
    '''

@dataclass(repr=False)
class BasePower(IdentifiedObject):
    '''
    The BasePower class defines the base power used in the per unit calculations.
    '''

    basePower: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Value used as base power.
    '''

@dataclass(repr=False)
class BaseVoltage(IdentifiedObject):
    '''
    Defines a system base voltage which is referenced.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The power system resource's base voltage.
    '''

    ConductingEquipment: list[ConductingEquipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConductingEquipment.BaseVoltage',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All conducting equipment with this base voltage. Use only when there is
    no voltage level container used and only one base voltage applies. For
    example, not used for transformers.
    '''

    NetworkAssetDeployment: list[AssetDeployment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AssetDeployment.BaseVoltage',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A network asset deployment at this base voltage level.
    '''

    TopologicalNode: list[TopologicalNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TopologicalNode.BaseVoltage',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The topological nodes at the base voltage.
    '''

    TransformerEnds: list[TransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEnd.BaseVoltage',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Transformer ends at the base voltage. This is essential for PU calculation.
    '''

    VoltageLevel: list[VoltageLevel] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'VoltageLevel.BaseVoltage',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The voltage levels having this base voltage.
    '''

@dataclass(repr=False)
class BasicIntervalSchedule(IdentifiedObject):
    '''
    Schedule of values at points in time.
    '''

    startTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The time for the first time point. The value can be a time of day, not
    a specific date.
    '''

    value1Multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Multiplier for value1.
    '''

    value1Unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Value1 units of measure.
    '''

    value2Multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Multiplier for value2.
    '''

    value2Unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Value2 units of measure.
    '''

@dataclass(repr=False)
class IrregularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them varies.
    '''

    TimePoints: list[IrregularTimePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'IrregularTimePoint.IntervalSchedule',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The point data values that define a curve.
    '''

@dataclass(repr=False)
class RegularIntervalSchedule(BasicIntervalSchedule):
    '''
    The schedule has time points where the time between them is constant.
    '''

    endTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The time for the last time point. The value can be a time of day, not a
    specific date.
    '''

    timeStep: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The time between each pair of subsequent regular time points in sequence
    order.
    '''

    TimePoints: list[RegularTimePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RegularTimePoint.IntervalSchedule',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The regular interval time point data values that define this schedule.
    '''

@dataclass(repr=False)
class GenUnitOpSchedule(RegularIntervalSchedule):
    '''
    The generating unit's Operator-approved current operating schedule (or
    plan), typically produced with the aid of unit commitment type analyses.
    The X-axis represents absolute time. The Y1-axis represents the status
    (0=off-line and unavailable: 1=available: 2=must run: 3=must run at fixed
    power value: etc.). The Y2-axis represents the must run fixed power value
    where required.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GeneratingUnit.GenUnitOpSchedule',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''

@dataclass(repr=False)
class HydroPumpOpSchedule(RegularIntervalSchedule):
    '''
    The hydro pump's Operator-approved current operating schedule (or plan),
    typically produced with the aid of unit commitment type analyses.The unit's
    operating schedule status is typically given as: (0=unavailable) (1=avilable
    to startup or shutdown) (2=must pump).
    '''

    HydroPump: Optional[HydroPump] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroPump.HydroPumpOpSchedule',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''

@dataclass(repr=False)
class InflowForecast(RegularIntervalSchedule):
    '''
    Natural water inflow to a reservoir, usually forecasted from predicted
    rain and snowmelt. Typically in one hour increments for up to 10 days.
    The forecast is given in average cubic meters per second over the time
    increment.
    '''

    Reservoir: Optional[Reservoir] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Reservoir.InflowForecasts',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A reservoir may have a "natural" inflow forecast.
    '''

@dataclass(repr=False)
class SeasonDayTypeSchedule(RegularIntervalSchedule):
    '''
    A time schedule covering a 24 hour period, with curve data for a specific
    type of season and day.
    '''

    DayType: Optional[DayType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DayType.SeasonDayTypeSchedules',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    DayType for the Schedule.
    '''

    Season: Optional[Season] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Season.SeasonDayTypeSchedules',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Season for the Schedule.
    '''

@dataclass(repr=False)
class ConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    A curve of load versus time (X-axis) showing the active power values (Y1-axis)
    and reactive power (Y2-axis) for each unit of the period covered. This
    curve represents a typical pattern of load over the time period for a given
    day type and season.
    '''

    ConformLoadGroup: Optional[ConformLoadGroup] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConformLoadGroup.ConformLoadSchedules',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The ConformLoadGroup where the ConformLoadSchedule belongs.
    '''

@dataclass(repr=False)
class NonConformLoadSchedule(SeasonDayTypeSchedule):
    '''
    An active power (Y1-axis) and reactive power (Y2-axis) schedule (curves)
    versus time (X-axis) for non-conforming loads, e.g., large industrial load
    or power station service (where modeled).
    '''

    NonConformLoadGroup: Optional[NonConformLoadGroup] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NonConformLoadGroup.NonConformLoadSchedules',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The NonConformLoadGroup where the NonConformLoadSchedule belongs.
    '''

@dataclass(repr=False)
class RegulationSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a controlled variable, e.g., busbar
    voltage.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RegulatingControl.RegulationSchedule',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Regulating controls that have this Schedule.
    '''

    VoltageControlZones: list[VoltageControlZone] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'VoltageControlZone.RegulationSchedule',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A VoltageControlZone may have a voltage regulation schedule.
    '''

@dataclass(repr=False)
class SwitchSchedule(SeasonDayTypeSchedule):
    '''
    A schedule of switch positions. If RegularTimePoint.value1 is 0, the switch
    is open. If 1, the switch is closed.
    '''

    Switch: Optional[Switch] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Switch.SwitchSchedules',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A SwitchSchedule is associated with a Switch.
    '''

@dataclass(repr=False)
class TapSchedule(SeasonDayTypeSchedule):
    '''
    A pre-established pattern over time for a tap step.
    '''

    TapChanger: Optional[TapChanger] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TapChanger.TapSchedules',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A TapSchedule is associated with a TapChanger.
    '''

@dataclass(repr=False)
class SteamSendoutSchedule(RegularIntervalSchedule):
    '''
    The cogeneration plant's steam sendout schedule in volume per time unit.
    '''

    CogenerationPlant: Optional[CogenerationPlant] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CogenerationPlant.SteamSendoutSchedule',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''

@dataclass(repr=False)
class BranchGroup(IdentifiedObject):
    '''
    A group of branch terminals whose directed flow summation is to be monitored.
    A branch group need not form a cutset of the network.
    '''

    monitorActivePower: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Monitor the active power flow.
    '''

    monitorReactivePower: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Monitor the reactive power flow.
    '''

    maximumActivePower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum active power flow.
    '''

    maximumReactivePower: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum reactive power flow.
    '''

    minimumActivePower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The minimum active power flow.
    '''

    minimumReactivePower: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The minimum reactive power flow.
    '''

    BranchGroupTerminal: list[BranchGroupTerminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'BranchGroupTerminal.BranchGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The directed branch group terminals to be summed.
    '''

@dataclass(repr=False)
class BusNameMarker(IdentifiedObject):
    '''
    Used to apply user standard names to topology buses. Typically used for
    "bus/branch" case generation. Associated with one or more terminals that
    are normally connected with the bus name. The associated terminals are
    normally connected by non-retained switches. For a ring bus station configuration,
    all busbar terminals in the ring are typically associated. For a breaker
    and a half scheme, both busbars would normally be associated. For a ring
    bus, all busbars would normally be associated. For a "straight" busbar
    configuration, normally only the main terminal at the busbar would be associated.
    '''

    priority: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Priority of bus name marker for use as topology bus name. Use 0 for don
    t care. Use 1 for highest priority. Use 2 as priority is less than 1 and
    so on.
    '''

    ReportingGroup: Optional[ReportingGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReportingGroup.BusNameMarker',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reporting group to which this bus name marker belongs.
    '''

    Terminal: list[ACDCTerminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ACDCTerminal.BusNameMarker',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The terminals associated with this bus name marker.
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalNode.BusNameMarker',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A user defined topological node that was originally defined in a planning
    model not yet having topology described by ConnectivityNodes. Once ConnectivityNodes
    has been created they may linked to user defined ToplogicalNdes using BusNameMarkers.
    '''

@dataclass(repr=False)
class CatalogAssetType(IdentifiedObject):
    '''
    assets that may be used for planning, work or design purposes.
    '''

    stockItem: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if item is a stock item (default).
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    estimatedUnitCost: Optional[ Money ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Estimated unit cost (or cost per unit length) of this type of asset. It
    does not include labor to install, construct or configure it.
    '''

    kind: Optional[ AssetKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    AssetInfo: Optional[AssetInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetInfo.CatalogAssetType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ProductAssetModel: list[ProductAssetModel] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProductAssetModel.CatalogAssetType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    quantity: Optional[StringQuantity] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The value, unit of measure, and multiplier for the quantity.
    '''

@dataclass(repr=False)
class Channel(IdentifiedObject):
    '''
    A single path for the collection or reporting of register values over a
    period of time. For example, a register which measures forward energy can
    have two channels, one providing bulk quantity readings and the other providing
    interval readings of a fixed interval size.
    '''

    isVirtual: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, the data is being calculated by an enterprise system rather than
    metered directly.
    '''

@dataclass(repr=False)
class ClassificationCondition(IdentifiedObject):
    '''
    A classification condition used to define preconditions that must be met
    by a phenomena classification.
    '''

    duration: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The duration of the of the condition in seconds
    '''

    test: Optional[ TestKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The test applied to the value.
    '''

@dataclass(repr=False)
class ConnectivityNode(IdentifiedObject):
    '''
    Connectivity nodes are points where terminals of AC conducting equipment
    are connected together with zero impedance.
    '''

    ConnectivityNodeContainer: Optional[ConnectivityNodeContainer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConnectivityNodeContainer.ConnectivityNodes',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Container of this connectivity node.
    '''

    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperationalLimitSet.ConnectivityNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    SvInjection: list[SvInjection] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SvInjection.ConnectivityNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    SvVoltage: Optional[SvVoltage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SvVoltage.ConnectivityNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Terminals: list[Terminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Terminal.ConnectivityNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Terminals interconnected with zero impedance at a this connectivity node.
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalNode.ConnectivityNodes',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The topological node to which this connectivity node is assigned. May depend
    on the current state of switches in the network.
    '''

@dataclass(repr=False)
class CoordinateSystem(IdentifiedObject):
    '''
    Coordinate reference system.
    '''

    crsUrn: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A Uniform Resource Name (URN) for the coordinate reference system (crs)
    used to define 'Location.PositionPoints'.
    An example would be the European Petroleum Survey Group (EPSG) code for
    a coordinate reference system, defined in URN under the Open Geospatial
    Consortium (OGC) namespace as: urn:ogc:def:uom:EPSG::XXXX, where XXXX is
    an EPSG code (a full list of codes can be found at the EPSG Registry web
    site http://www.epsg-registry.org/). To define the coordinate system as
    being WGS84 (latitude, longitude) using an EPSG OGC, this attribute would
    be urn:ogc:def:uom:EPSG::4236.
    A profile should limit this code to a set of allowed URNs agreed to by
    all sending and receiving parties.
    '''

    Locations: list[Location] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Location.CoordinateSystem',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All locations described with position points in this coordinate system.
    '''

@dataclass(repr=False)
class Crew(IdentifiedObject):
    '''
    Group of people with specific skills, tools, and vehicles.
    '''

    CrewMembers: list[CrewMember] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CrewMember.Crew',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All members of this crew.
    '''

    CrewType: Optional[CrewType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CrewType.Crews',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of this crew.
    '''

    FieldDispatchHistory: list[FieldDispatchHistory] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'FieldDispatchHistory.Crew',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Location: Optional[Location] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Location.Crew',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    status: Optional[Status] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Status of this crew.
    '''

@dataclass(repr=False)
class CrewType(IdentifiedObject):
    '''
    Custom description of the type of crew. This may be used to determine the
    type of work the crew can be assigned to. Examples include repair, tree
    trimming, switching, etc.
    '''

    Crews: list[Crew] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Crew.CrewType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All crews of this type.
    '''

@dataclass(repr=False)
class Curve(IdentifiedObject):
    '''
    A multi-purpose curve or functional relationship between an independent
    variable (X-axis) and dependent (Y-axis) variables.
    '''

    curveStyle: Optional[ CurveStyle ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The style or shape of the curve.
    '''

    xMultiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Multiplier for X-axis.
    '''

    xUnit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The X-axis units of measure.
    '''

    y1Multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Multiplier for Y1-axis.
    '''

    y1Unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The Y1-axis units of measure.
    '''

    y2Multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Multiplier for Y2-axis.
    '''

    y2Unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The Y2-axis units of measure.
    '''

    y3Multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Multiplier for Y3-axis.
    '''

    y3Unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The Y3-axis units of measure.
    '''

    CurveDatas: list[CurveData] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CurveData.Curve',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The point data values that define this curve.
    '''

@dataclass(repr=False)
class EmissionAccount(Curve):
    '''
    Accounts for tracking emissions usage and credits for thermal generating
    units. A unit may have zero or more emission accounts, and will typically
    have one for tracking usage and one for tracking credits.
    '''

    emissionType: Optional[ EmissionType ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The type of emission, for example sulfur dioxide (SO2). The y1AxisUnits
    of the curve contains the unit of measure (e.g. kg) and the emissionType
    is the type of emission (e.g. sulfer dioxide).
    '''

    emissionValueSource: Optional[ EmissionValueSource ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The source of the emission value.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.EmmissionAccounts',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have one or more emission allowance accounts.
    '''

@dataclass(repr=False)
class EmissionCurve(Curve):
    '''
    Relationship between the unit's emission rate in units of mass per hour
    (Y-axis) and output active power (X-axis) for a given type of emission.
    This curve applies when only one type of fuel is being burned.
    '''

    isNetGrossP: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    emissionContent: Optional[ float | Emission ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The emission content per quantity of fuel burned.
    '''

    emissionType: Optional[ EmissionType ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The type of emission, which also gives the production rate measurement
    unit. The y1AxisUnits of the curve contains the unit of measure (e.g. kg)
    and the emissionType is the type of emission (e.g. sulfer dioxide).
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.EmissionCurves',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have one or more emission curves.
    '''

@dataclass(repr=False)
class FuelAllocationSchedule(Curve):
    '''
    The amount of fuel of a given type which is allocated for consumption over
    a specified period of time.
    '''

    fuelAllocationEndDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The end time and date of the fuel allocation schedule.
    '''

    fuelAllocationStartDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The start time and date of the fuel allocation schedule.
    '''

    maxFuelAllocation: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum amount fuel that is allocated for consumption for the scheduled
    time period.
    '''

    minFuelAllocation: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The minimum amount fuel that is allocated for consumption for the scheduled
    time period, e.g., based on a "take-or-pay" contract.
    '''

    fuelType: Optional[ FuelType ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The type of fuel, which also indicates the corresponding measurement unit.
    '''

    FossilFuel: Optional[FossilFuel] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'FossilFuel.FuelAllocationSchedules',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A fuel allocation schedule must have a fossil fuel.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.FuelAllocationSchedules',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have one or more fuel allocation schedules.
    '''

@dataclass(repr=False)
class GenUnitOpCostCurve(Curve):
    '''
    Relationship between unit operating cost (Y-axis) and unit output active
    power (X-axis). The operating cost curve for thermal units is derived from
    heat input and fuel costs. The operating cost curve for hydro units is
    derived from water flow rates and equivalent water costs.
    '''

    isNetGrossP: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GeneratingUnit.GenUnitOpCostCurves',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A generating unit may have one or more cost curves, depending upon fuel
    mixture and fuel cost.
    '''

@dataclass(repr=False)
class GrossToNetActivePowerCurve(Curve):
    '''
    Relationship between the generating unit's gross active power output on
    the X-axis (measured at the terminals of the machine(s)) and the generating
    unit's net active power output on the Y-axis (based on utility-defined
    measurements at the power station). Station service loads, when modeled,
    should be treated as non-conforming bus loads. There may be more than one
    curve, depending on the auxiliary equipment that is in service.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GeneratingUnit.GrossToNetActivePowerCurves',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A generating unit may have a gross active power to net active power curve,
    describing the losses and auxiliary power requirements of the unit.
    '''

@dataclass(repr=False)
class HeatInputCurve(Curve):
    '''
    Relationship between unit heat input in energy per time for main fuel (Y1-axis)
    and supplemental fuel (Y2-axis) versus unit output in active power (X-axis).
    The quantity of main fuel used to sustain generation at this output level
    is prorated for throttling between definition points. The quantity of supplemental
    fuel used at this output level is fixed and not prorated.
    '''

    isNetGrossP: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    auxPowerMult: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Power output - auxiliary power multiplier adjustment factor.
    '''

    auxPowerOffset: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Power output - auxiliary power offset adjustment factor.
    '''

    heatInputEff: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Heat input - efficiency multiplier adjustment factor.
    '''

    heatInputOffset: Optional[ float | HeatRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Heat input - offset adjustment factor.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.HeatInputCurve',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''

@dataclass(repr=False)
class HeatRateCurve(Curve):
    '''
    Relationship between unit heat rate per active power (Y-axis) and unit
    output (X-axis). The heat input is from all fuels.
    '''

    isNetGrossP: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.HeatRateCurve',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''

@dataclass(repr=False)
class HydroGeneratingEfficiencyCurve(Curve):
    '''
    Relationship between unit efficiency in percent and unit output active
    power for a given net head in meters. The relationship between efficiency,
    discharge, head, and power output is expressed as follows: E =KP/HQ
    Where: (E=percentage) (P=active power) (H=height) (Q=volume/time unit)
    (K=constant)
    For example, a curve instance for a given net head could relate efficiency
    (Y-axis) versus active power output (X-axis) or versus discharge on the
    X-axis.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroGeneratingUnit.HydroGeneratingEfficiencyCurves',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A hydro generating unit has an efficiency curve.
    '''

@dataclass(repr=False)
class IncrementalHeatRateCurve(Curve):
    '''
    Relationship between unit incremental heat rate in (delta energy/time)
    per (delta active power) and unit output in active power. The IHR curve
    represents the slope of the HeatInputCurve. Note that the "incremental
    heat rate" and the "heat rate" have the same engineering units.
    '''

    isNetGrossP: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Flag is set to true when output is expressed in net active power.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.IncrementalHeatRateCurve',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''

@dataclass(repr=False)
class LevelVsVolumeCurve(Curve):
    '''
    Relationship between reservoir volume and reservoir level. The volume is
    at the y-axis and the reservoir level at the x-axis.
    '''

    Reservoir: Optional[Reservoir] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Reservoir.LevelVsVolumeCurves',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A reservoir may have a level versus volume relationship.
    '''

@dataclass(repr=False)
class OverfrequencyTripCurve(Curve):
    '''
    '''

@dataclass(repr=False)
class OvervoltageTripCurve(Curve):
    '''
    '''

@dataclass(repr=False)
class PenstockLossCurve(Curve):
    '''
    Relationship between penstock head loss (in meters) and total discharge
    through the penstock (in cubic meters per second). One or more turbines
    may be connected to the same penstock.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroGeneratingUnit.PenstockLossCurve',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''

@dataclass(repr=False)
class ReactiveCapabilityCurve(Curve):
    '''
    Reactive power rating envelope versus the synchronous machine's active
    power, in both the generating and motoring modes. For each active power
    value there is a corresponding high and low reactive power limit value.
    Typically there will be a separate curve for each coolant condition, such
    as hydrogen pressure. The Y1 axis values represent reactive minimum and
    the Y2 axis values represent reactive maximum.
    '''

    coolantTemperature: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The machine's coolant temperature (e.g., ambient air or stator circulating
    water).
    '''

    hydrogenPressure: Optional[ float | Pressure ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The hydrogen coolant pressure
    '''

    SynchronousMachines: list[SynchronousMachine] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SynchronousMachine.ReactiveCapabilityCurves',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Synchronous machines using this curve.
    '''

@dataclass(repr=False)
class ShutdownCurve(Curve):
    '''
    Relationship between the rate in gross active power/minute (Y-axis) at
    which a unit should be shutdown and its present gross MW output (X-axis).
    '''

    shutdownDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The date and time of the most recent generating unit shutdown.
    '''

    shutdownCost: Optional[ Money ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Fixed shutdown cost.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.ShutdownCurve',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''

@dataclass(repr=False)
class StartIgnFuelCurve(Curve):
    '''
    The quantity of ignition fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    ignitionFuelType: Optional[ FuelType ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of ignition fuel.
    '''

    StartupModel: Optional[StartupModel] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartupModel.StartIgnFuelCurve',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''

@dataclass(repr=False)
class StartMainFuelCurve(Curve):
    '''
    The quantity of main fuel (Y-axis) used to restart and repay the auxiliary
    power consumed versus the number of hours (X-axis) the unit was off line.
    '''

    mainFuelType: Optional[ FuelType ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of main fuel.
    '''

    StartupModel: Optional[StartupModel] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartupModel.StartMainFuelCurve',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''

@dataclass(repr=False)
class StartRampCurve(Curve):
    '''
    Rate in gross active power/minute (Y-axis) at which a unit can be loaded
    versus the number of hours (X-axis) the unit was off line.
    '''

    hotStandbyRamp: Optional[ float | ActivePowerChangeRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The startup ramp rate in gross for a unit that is on hot standby.
    '''

    StartupModel: Optional[StartupModel] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartupModel.StartRampCurve',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''

@dataclass(repr=False)
class TailbayLossCurve(Curve):
    '''
    Relationship between tailbay head loss hight (y-axis) and the total discharge
    into the power station's tailbay volume per time unit (x-axis) . There
    could be more than one curve depending on the level of the tailbay reservoir
    or river level.
    '''

    HydroGeneratingUnit: Optional[HydroGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroGeneratingUnit.TailbayLossCurve',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A hydro generating unit has a tailbay loss curve.
    '''

@dataclass(repr=False)
class TargetLevelSchedule(Curve):
    '''
    Reservoir water level targets from advanced studies or "rule curves". Typically
    in one hour increments for up to 10 days.
    '''

    highLevelLimit: Optional[ float | WaterLevel ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    High target level limit, above which the reservoir operation will be penalized.
    '''

    lowLevelLimit: Optional[ float | WaterLevel ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Low target level limit, below which the reservoir operation will be penalized.
    '''

    Reservoir: Optional[Reservoir] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Reservoir.TargetLevelSchedule',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A reservoir may have a water level target schedule.
    '''

@dataclass(repr=False)
class UnderfrequencyTripCurve(Curve):
    '''
    '''

@dataclass(repr=False)
class UndervoltageTripCurve(Curve):
    '''
    '''

@dataclass(repr=False)
class VoltVarCurve(Curve):
    '''
    '''

@dataclass(repr=False)
class VoltWattCurve(Curve):
    '''
    '''

@dataclass(repr=False)
class WattVarCurve(Curve):
    '''
    '''

@dataclass(repr=False)
class DERGroupDispatch(IdentifiedObject):
    '''
    '''

    EndDeviceGroup: list[EndDeviceGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceGroup.DERGroupDispatch',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class DERGroupForecast(IdentifiedObject):
    '''
    '''

    predictionCreationDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    EndDeviceGroup: list[EndDeviceGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceGroup.DERGroupForecast',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class DayType(IdentifiedObject):
    '''
    Group of similar days. For example it could be used to represent weekdays,
    weekend, or holidays.
    '''

    SeasonDayTypeSchedules: list[SeasonDayTypeSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SeasonDayTypeSchedule.DayType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Schedules that use this DayType.
    '''

@dataclass(repr=False)
class DemandResponseProgram(IdentifiedObject):
    '''
    Demand response program.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of demand response program; examples are CPP (critical-peak pricing),
    RTP (real-time pricing), DLC (direct load control), DBP (demand bidding
    program), BIP (base interruptible program). Note that possible types change
    a lot and it would be impossible to enumerate them all.
    '''

    CustomerAgreements: list[CustomerAgreement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CustomerAgreement.DemandResponsePrograms',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All customer agreements through which the customer is enrolled in this
    demand response program.
    '''

    EndDeviceGroups: list[EndDeviceGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceGroup.DemandResponsePrograms',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All groups of end devices enrolled in this demand response program.
    '''

    UsagePointGroups: list[UsagePointGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UsagePointGroup.DemandResponsePrograms',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All usage point groups enrolled in this demand response program.
    '''

    validityInterval: Optional[DateTimeInterval] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Interval within which the program is valid.
    '''

@dataclass(repr=False)
class Document(IdentifiedObject):
    '''
    Parent class for different groupings of information collected and managed
    as a part of a business process. It will frequently contain references
    to other objects, such as assets, people and power system resources.
    '''

    authorName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Name of the author of this document.
    '''

    comment: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Free text comment.
    '''

    createdDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time that this document was created.
    '''

    lastModifiedDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time this document was last modified. Documents may potentially
    be modified many times during their lifetime.
    '''

    revisionNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Revision number for this document.
    '''

    subject: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Document subject.
    '''

    title: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Document title.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Utility-specific classification of this document, according to its corporate
    standards, practices, and existing IT systems (e.g., for management of
    assets, maintenance, work, outage, customers, etc.).
    '''

    Approver: Optional[Approver] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Approver.Documents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Approver of this document.
    '''

    Author: Optional[Author] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Author.Documents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Author of this document.
    '''

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConfigurationEvent.ChangedDocument',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All configuration events created for this document.
    '''

    docStatus: Optional[Status] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Status of this document. For status of subject matter this document represents
    (e.g., Agreement, Work), use 'status' attribute.
    Example values for 'docStatus.status' are draft, approved, cancelled, etc.
    '''

    Editor: Optional[Editor] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Editor.Documents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Editor of this document.
    '''

    electronicAddress: Optional[ElectronicAddress] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Electronic address.
    '''

    Issuer: Optional[Issuer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Issuer.Documents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Issuer of this document.
    '''

    status: Optional[Status] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Status of subject matter (e.g., Agreement, Work) this document represents.
    For status of the document itself, use 'docStatus' attribute.
    '''

@dataclass(repr=False)
class Analytic(Document):
    '''
    An algorithm or calculation for making an assessment about an asset or
    asset grouping for lifecycle decision making.
    '''

    bestValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Value that indicates best possible numeric value.
    '''

    worstValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Value that indicates worst possible numeric value.
    '''

    kind: Optional[ AnalyticKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of analytic this analytic is.
    '''

    scaleKind: Optional[ ScaleKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The scoring scale kind.
    '''

    AnalyticScore: list[AnalyticScore] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AnalyticScore.Analytic',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Asset: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.Analytic',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    AssetGroup: list[AssetGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AssetGroup.Analytic',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    AssetHealthEvent: list[AssetHealthEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AssetHealthEvent.Analytic',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class AssetGroup(Document):
    '''
    A grouping of assets created for a purpose such as fleet analytics, inventory
    or compliance management.
    '''

    kind: Optional[ AssetGroupKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of asset group this asset group is.
    '''

    Analytic: list[Analytic] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Analytic.AssetGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    AnalyticScore: list[AnalyticScore] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AnalyticScore.AssetGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Asset: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.AssetGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class CustomerAccount(Document):
    '''
    Assignment of a group of products and services purchased by the customer
    through a customer agreement, used as a mechanism for customer billing
    and payment. It contains common information from the various types of customer
    agreements to create billings (invoices) for a customer and receive payment.
    '''

    billingCycle: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Cycle day on which the associated customer account will normally be billed,
    used to determine when to produce the billing.
    '''

    budgetBill: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Budget bill code.
    '''

    lastBillAmount: Optional[ Money ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The last amount that will be billed to the customer prior to shut off of
    the account.
    '''

    AccountNotification: list[AccountNotification] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AccountNotification.CustomerAccount',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Customer: Optional[Customer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Customer.CustomerAccounts',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Customer owning this account.
    '''

    CustomerAgreements: list[CustomerAgreement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CustomerAgreement.CustomerAccount',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All agreements for this customer account.
    '''

@dataclass(repr=False)
class CustomerAgreement(Document):
    '''
    Agreement between the customer and the service supplier to pay for service
    at a specific service location. It records certain billing information
    about the type of service provided at the service location and is used
    during charge creation to determine the type of service.
    '''

    isPrePay: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, the customer is a pre-pay customer for the specified service.
    '''

    loadMgmt: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Load management code.
    '''

    shutOffDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Final date and time the service will be billed to the previous customer.
    '''

    Customer: Optional[Customer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Customer.CustomerAgreements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Customer for this agreement.
    '''

    CustomerAccount: Optional[CustomerAccount] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CustomerAccount.CustomerAgreements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Customer account owning this agreement.
    '''

    DemandResponsePrograms: list[DemandResponseProgram] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DemandResponseProgram.CustomerAgreements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All demand response programs the customer is enrolled in through this customer
    agreement.
    '''

    MeterReadings: list[MeterReading] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeterReading.CustomerAgreement',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (could be deprecated in the future) All meter readings for this customer
    agreement.
    '''

    PricingStructures: list[PricingStructure] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PricingStructure.CustomerAgreements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All pricing structures applicable to this customer agreement.
    '''

    ServiceCategory: Optional[ServiceCategory] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ServiceCategory.CustomerAgreements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Service category for this agreement.
    '''

    ServiceLocations: list[ServiceLocation] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ServiceLocation.CustomerAgreements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All service locations regulated by this customer agreement.
    '''

    UsagePoints: list[UsagePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UsagePoint.CustomerAgreement',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All service delivery points regulated by this customer agreement.
    '''

@dataclass(repr=False)
class PricingStructure(Document):
    '''
    Grouping of pricing components and prices used in the creation of customer
    charges and the eligibility criteria under which these terms may be offered
    to a customer. The reasons for grouping include state, customer classification,
    site characteristics, classification (i.e. fee price structure, deposit
    price structure, electric service price structure, etc.) and accounting
    requirements.
    '''

@dataclass(repr=False)
class Procedure(Document):
    '''
    Documented procedure for various types of work or work tasks on assets.
    '''

    instruction: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Textual description of this procedure.
    '''

    sequenceNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Sequence number in a sequence of procedures being performed.
    '''

    kind: Optional[ ProcedureKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of procedure.
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.Procedures',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All assets to which this procedure applies.
    '''

    Limits: list[Limit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Limit.Procedures',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Measurements: list[Measurement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Measurement.Procedures',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Document containing this measurement.
    '''

    ProcedureDataSets: list[ProcedureDataSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProcedureDataSet.Procedure',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All data sets captured by this procedure.
    '''

@dataclass(repr=False)
class ProcedureDataSet(Document):
    '''
    A data set recorded each time a procedure is executed. Observed results
    are captured in associated measurement values and/or values for properties
    relevant to the type of procedure performed.
    '''

    completedDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time procedure was completed.
    '''

    Asset: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.ProcedureDataSet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Asset to which this procedure data set applies.
    '''

    MeasurementValue: list[MeasurementValue] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeasurementValue.ProcedureDataSet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Procedure: Optional[Procedure] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Procedure.ProcedureDataSets',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Procedure capturing this data set.
    '''

    Properties: list[UserAttribute] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UserAttribute.ProcedureDataSets',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    UserAttributes used to specify further properties of this procedure data
    set. Use 'name' to specify what kind of property it is, and 'value.value'
    attribute for the actual value.
    '''

@dataclass(repr=False)
class InspectionDataSet(ProcedureDataSet):
    '''
    Documents the result of one inspection, for a given attribute of an asset.
    '''

    locationCondition: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Description of the conditions of the location where the asset resides.
    '''

@dataclass(repr=False)
class TroubleTicket(Document):
    '''
    '''

@dataclass(repr=False)
class EndDeviceControl(IdentifiedObject):
    '''
    Instructs an end device (or an end device group) to perform a specified
    action.
    '''

    drProgramLevel: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Level of a demand response program request, where 0=emergency. Note: Attribute
    is not defined on DemandResponseProgram as it is not its inherent property
    (it serves to control it).
    '''

    drProgramMandatory: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Whether a demand response program request is mandatory. Note: Attribute
    is not defined on DemandResponseProgram as it is not its inherent property
    (it serves to control it).
    '''

    issuerID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Unique identifier of the business entity originating an end device control.
    '''

    issuerTrackingID: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Identifier assigned by the initiator (e.g. retail electric provider) of
    an end device control action to uniquely identify the demand response event,
    text message, or other subject of the control action. Can be used when
    cancelling an event or text message request or to identify the originating
    event or text message in a consequential end device event.
    '''

    reason: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reason for the control action that allows to determine how to continue
    processing. For example, disconnect meter command may require different
    processing by the receiving system if it has been issued for a network-related
    reason (protection) or for a payment-related reason.
    '''

    EndDeviceAction: Optional[EndDeviceAction] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EndDeviceAction.EndDeviceControl',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    End device action issued by this end device control.
    '''

    EndDeviceControlType: Optional[EndDeviceControlType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EndDeviceControlType.EndDeviceControls',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of this end device control.
    '''

    EndDeviceGroups: list[EndDeviceGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceGroup.EndDeviceControls',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end device groups receiving commands from this end device control.
    '''

    EndDevices: list[EndDevice] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDevice.EndDeviceControls',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end devices receiving commands from this end device control.
    '''

    priceSignal: Optional[FloatQuantity] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Price signal used as parameter for this end device control.
    '''

    primaryDeviceTiming: Optional[EndDeviceTiming] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Timing for the control actions performed on the device identified in the
    end device control.
    '''

    scheduledInterval: Optional[DateTimeInterval] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if control has scheduled duration) Date and time interval the control
    has been scheduled to execute within.
    '''

    secondaryDeviceTiming: Optional[EndDeviceTiming] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Timing for the control actions performed by devices that are responding
    to event related information sent to the primary device indicated in the
    end device control. For example, load control actions performed by a PAN
    device in response to demand response event information sent to a PAN gateway
    server.
    '''

    UsagePointGroups: list[UsagePointGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UsagePointGroup.EndDeviceControls',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All usage point groups receiving commands from this end device control.
    '''

    UsagePoints: list[UsagePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UsagePoint.EndDeviceControls',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All usage points receiving commands from this end device control.
    '''

@dataclass(repr=False)
class EndDeviceControlType(IdentifiedObject):
    '''
    Detailed description for a control produced by an end device. Values in
    attributes allow for creation of recommended codes to be used for identifying
    end device controls as follows: &lt;type&gt;.&lt;domain&gt;.&lt;subDomain&gt;.&lt;eventOrAction&gt;.
    '''

    domain: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    High-level nature of the control.
    '''

    eventOrAction: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The most specific part of this control type. It is mainly in the form of
    a verb that gives action to the control that just occurred.
    '''

    subDomain: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    More specific nature of the control, as a further sub-categorisation of
    'domain'.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of physical device from which the control was created. A value of
    zero (0) can be used when the source is unknown.
    '''

    EndDeviceControls: list[EndDeviceControl] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceControl.EndDeviceControlType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end device controls of this type.
    '''

@dataclass(repr=False)
class EndDeviceEventType(IdentifiedObject):
    '''
    Detailed description for an event produced by an end device. Values in
    attributes allow for creation of recommended codes to be used for identifying
    end device events as follows: &lt;type&gt;.&lt;domain&gt;.&lt;subDomain&gt;.&lt;eventOrAction&gt;.
    '''

    domain: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    High-level nature of the event. By properly classifying events by a small
    set of domain codes, a system can more easily run reports based on the
    types of events that have occurred or been received.
    '''

    eventOrAction: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The most specific part of this event type. It is mainly in the form of
    a verb that gives action to the event that just occurred.
    '''

    subDomain: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    More specific nature of the event, as a further sub-categorisation of 'domain'.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of physical device from which the event was created. A value of zero
    (0) can be used when the source is unknown.
    '''

    EndDeviceEvents: list[EndDeviceEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceEvent.EndDeviceEventType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end device events of this type.
    '''

@dataclass(repr=False)
class EndDeviceGroup(IdentifiedObject):
    '''
    Abstraction for management of group communications within a two-way AMR
    system or the data for a group of related end devices. Commands can be
    issued to all of the end devices that belong to the group using a defined
    group address and the underlying AMR communication infrastructure. A DERGroup
    and a PANDeviceGroup is an EndDeviceGroup.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of this group.
    '''

    DemandResponsePrograms: list[DemandResponseProgram] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DemandResponseProgram.EndDeviceGroups',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All demand response programs this group of end devices is enrolled in.
    '''

    DERFunction: Optional[DERFunction] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DERFunction.EndDeviceGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    DERGroupDispatch: list[DERGroupDispatch] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DERGroupDispatch.EndDeviceGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    DERGroupForecast: list[DERGroupForecast] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DERGroupForecast.EndDeviceGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    DERMonitorableParameter: list[DERMonitorableParameter] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DERMonitorableParameter.EndDeviceGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    DispatchablePowerCapability: Optional[DispatchablePowerCapability] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DispatchablePowerCapability.EndDeviceGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    EndDeviceControls: list[EndDeviceControl] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceControl.EndDeviceGroups',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end device controls sending commands to this end device group.
    '''

    EndDevices: list[EndDevice] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDevice.EndDeviceGroups',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end devices this end device group refers to.
    '''

    status: Optional[Status] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    version: Optional[Version] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class EnergyArea(IdentifiedObject):
    '''
    Describes an area having energy production or consumption. Specializations
    are intended to support the load allocation function as typically required
    in energy management systems or planning studies to allocate hypothesized
    load levels to individual load points for power flow analysis. Often the
    energy area can be linked to both measured and forecast load levels.
    '''

@dataclass(repr=False)
class LoadArea(EnergyArea):
    '''
    The class is the root or first level in a hierarchical structure for grouping
    of loads for the purpose of load flow load scaling.
    '''

    SubLoadAreas: list[SubLoadArea] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SubLoadArea.LoadArea',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The SubLoadAreas in the LoadArea.
    '''

@dataclass(repr=False)
class SubLoadArea(EnergyArea):
    '''
    The class is the second level in a hierarchical structure for grouping
    of loads for the purpose of load flow load scaling.
    '''

    LoadArea: Optional[LoadArea] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'LoadArea.SubLoadAreas',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The LoadArea where the SubLoadArea belongs.
    '''

    LoadGroups: list[LoadGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'LoadGroup.SubLoadArea',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The Loadgroups in the SubLoadArea.
    '''

@dataclass(repr=False)
class EnvironmentalInformation(IdentifiedObject):
    '''
    Abstract class (with concrete child classes of Observation and Forecast)
    that groups phenomenon and/or environmental value sets.
    '''

    created: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The timestamp of when the forecast was created
    '''

    EnvironmentalAnalog: list[EnvironmentalAnalog] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalAnalog.EnvironmentalInformation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Environmental analog associated with this observation or forecast.
    '''

    EnvironmentalDataProvider: Optional[EnvironmentalDataProvider] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnvironmentalDataProvider.EnvironmentalInformation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Environmental data provider supplying this environmental information.
    '''

    EnvironmentalPhenomenon: list[EnvironmentalPhenomenon] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalPhenomenon.EnvironmentalInformation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    EnvironmentalStringMeasurement: list[EnvironmentalStringMeasurement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalStringMeasurement.EnvironmentalInformation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Environmental string measurement associated with this forecast or observation.
    '''

@dataclass(repr=False)
class EnvironmentalPhenomenon(IdentifiedObject):
    '''
    The actual or forecast occurrence of an environmental phenomenon at a specific
    point in time (or during a specific time interval) that may have both a
    center and area/line location. Named events (like Hurricane Andrew or the
    ash cloud associated with the St. Helens eruption) are intended to be modeled
    using an instance of IdentifiedPhenomenon (where the event name is recorded)
    related with one or more EnvironmentalPhenomenon instances in one or more
    Observations or Forecasts) which describe the event over time.
    '''

    EnvironmentalInformation: list[EnvironmentalInformation] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalInformation.EnvironmentalPhenomenon',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    EnvironmentalLocationKind: list[EnvironmentalLocationType] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalLocationType.EnvironmentalPhenomenon',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Location of relevance to this environmental phenomenon.
    '''

    NamedPhenomenon: Optional[NamedPhenomenon] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NamedPhenomenon.EnvironmentalPhenomenon',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The identified phenomenon to which this environmental phenomenon is associated.
    '''

    PhenomenonClassification: Optional[PhenomenonClassification] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PhenomenonClassification.EnvironmentalPhenomenon',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    timeInterval: Optional[DateTimeInterval] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The timestamp of the phenomenon as a single point or time interval.
    '''

@dataclass(repr=False)
class Fault(IdentifiedObject):
    '''
    Abnormal condition causing current flow through conducting equipment, such
    as caused by equipment failure or short circuits from objects not typically
    modeled (for example, a tree falling on a line).
    '''

    occurredDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The date and time at which the fault occurred.
    '''

    stopDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Time when the fault is repaired. If not specified, the fault is temporary
    and will clear itself as soon as it's deenergized.
    '''

    kind: Optional[ PhaseConnectedFaultKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The kind of phase fault.
    '''

    phases: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The phases participating in the fault. The fault connections into these
    phases are further specified by the type of fault.
    '''

    FaultCauseTypes: list[FaultCauseType] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'FaultCauseType.Faults',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All types of fault cause.
    '''

    FaultyEquipment: Optional[Equipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Equipment.Faults',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Equipment carrying this fault.
    '''

    impedance: Optional[FaultImpedance] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Fault impedance. Its usage is described by 'kind'.
    '''

    Location: Optional[Location] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Location.Fault',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class EquipmentFault(Fault):
    '''
    A fault applied at the terminal, external to the equipment. This class
    is not used to specify faults internal to the equipment.
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.EquipmentFaults',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The terminal connecting to the bus to which the fault is applied.
    '''

@dataclass(repr=False)
class LineFault(Fault):
    '''
    A fault that occurs on an AC line segment at some point along the length.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The length to the place where the fault is located starting from terminal
    with sequence number 1 of the faulted line segment.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACLineSegment.LineFaults',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The line segment of this line fault.
    '''

@dataclass(repr=False)
class FaultCauseType(IdentifiedObject):
    '''
    Type of cause of the fault.
    '''

    ConfigurationEvent: list[ConfigurationEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConfigurationEvent.FaultCauseType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Faults: list[Fault] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Fault.FaultCauseTypes',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All faults with this cause type.
    '''

@dataclass(repr=False)
class FieldDispatchHistory(IdentifiedObject):
    '''
    The history of field dispatch statuses for this work.
    '''

    Crew: Optional[Crew] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Crew.FieldDispatchHistory',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    FieldDispatchStep: list[FieldDispatchStep] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'FieldDispatchStep.FieldDispatchHistory',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class FinancialInfo(IdentifiedObject):
    '''
    Various current financial properties associated with a particular asset.
    Historical properties may be determined by ActivityRecords associated with
    the asset.
    '''

@dataclass(repr=False)
class FossilFuel(IdentifiedObject):
    '''
    The fossil fuel consumed by the non-nuclear thermal generating unit. For
    example, coal, oil, gas, etc. This a the specific fuels that the generating
    unit can consume.
    '''

    fuelHeatContent: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The amount of heat per weight (or volume) of the given type of fuel.
    '''

    fossilFuelType: Optional[ FuelType ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The type of fossil fuel, such as coal, oil, or gas.
    '''

    fuelCost: Optional[ float | CostPerHeatUnit ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The cost in terms of heat value for the given type of fuel.
    '''

    fuelDispatchCost: Optional[ float | CostPerHeatUnit ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The cost of fuel used for economic dispatching which includes: fuel cost,
    transportation cost, and incremental maintenance cost.
    '''

    fuelEffFactor: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The efficiency factor for the fuel (per unit) in terms of the effective
    energy absorbed.
    '''

    fuelHandlingCost: Optional[ float | CostPerHeatUnit ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Handling and processing cost associated with this fuel.
    '''

    fuelMixture: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Relative amount of the given type of fuel, when multiple fuels are being
    consumed.
    '''

    fuelSulfur: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The fuel's fraction of pollution credit per unit of heat content.
    '''

    highBreakpointP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The active power output level of the unit at which the given type of fuel
    is switched on. This fuel (e.g., oil) is sometimes used to supplement the
    base fuel (e.g., coal) at high active power output levels.
    '''

    lowBreakpointP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The active power output level of the unit at which the given type of fuel
    is switched off. This fuel (e.g., oil) is sometimes used to stabilize the
    base fuel (e.g., coal) at low active power output levels.
    '''

    FuelAllocationSchedules: list[FuelAllocationSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'FuelAllocationSchedule.FossilFuel',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A fuel allocation schedule must have a fossil fuel.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.FossilFuels',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''

@dataclass(repr=False)
class GeographicalRegion(IdentifiedObject):
    '''
    A geographical region of a power system network model.
    '''

    Regions: list[SubGeographicalRegion] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SubGeographicalRegion.Region',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All sub-geograhpical regions within this geographical region.
    '''

@dataclass(repr=False)
class House(IdentifiedObject):
    '''
    In GridLAB-D, a single-family residence with building envelope represented
    by the equivalent thermal parameter (ETP) model, heating, ventilating and
    air conditioning (HVAC), other appliances, lights and plug loads. In power
    flow, these house loads aggregate into ZIP loads. These house parameters
    are the minimal set required to consistently initialize or repeat a GridLAB-D
    simulation.
    '''

    hvacPowerFactor: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    numberOfStories: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    coolingSetpoint: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    coolingSystem: Optional[ HouseCooling ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    floorArea: Optional[ float | Area ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    heatingSetpoint: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    heatingSystem: Optional[ HouseHeating ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    EnergyConsumer: Optional[EnergyConsumer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnergyConsumer.House',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ThermostatController: Optional[ThermostatController] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermostatController.House',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class IOPoint(IdentifiedObject):
    '''
    The class describe a measurement or control value. The purpose is to enable
    having attributes and associations common for measurement and control.
    '''

@dataclass(repr=False)
class Control(IOPoint):
    '''
    Control is used for supervisory/device control. It represents control outputs
    that are used to change the state in a process, e.g. close or open breaker,
    a set point value or a raise lower command.
    '''

    controlType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Specifies the type of Control, e.g. BreakerOn/Off, GeneratorVoltageSetPoint,
    TieLineFlow etc. The ControlType.name shall be unique among all specified
    types and describe the type.
    '''

    operationInProgress: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates that a client is currently sending control commands that has
    not completed.
    '''

    timeStamp: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The last time a control output was sent.
    '''

    unitMultiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The unit multiplier of the controlled quantity.
    '''

    unitSymbol: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The unit of measure of the controlled quantity.
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerSystemResource.Controls',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Regulating device governed by this control output.
    '''

@dataclass(repr=False)
class AccumulatorReset(Control):
    '''
    This command reset the counter value to zero.
    '''

    AccumulatorValue: Optional[AccumulatorValue] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AccumulatorValue.AccumulatorReset',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The accumulator value that is reset by the command.
    '''

@dataclass(repr=False)
class AnalogControl(Control):
    '''
    An analog control used for supervisory control.
    '''

    maxValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal value range maximum for any of the Control.value. Used for scaling,
    e.g. in bar graphs.
    '''

    minValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal value range minimum for any of the Control.value. Used for scaling,
    e.g. in bar graphs.
    '''

    AnalogValue: Optional[AnalogValue] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AnalogValue.AnalogControl',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The MeasurementValue that is controlled.
    '''

@dataclass(repr=False)
class RaiseLowerCommand(AnalogControl):
    '''
    An analog control that increase or decrease a set point value with pulses.
    Unless otherwise specified, one pulse moves the set point by one.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ValueAliasSet.RaiseLowerCommands',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The ValueAliasSet used for translation of a Control value to a name.
    '''

@dataclass(repr=False)
class SetPoint(AnalogControl):
    '''
    An analog control that issue a set point value.
    '''

    normalValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal value for Control.value e.g. used for percentage scaling.
    '''

    value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The value representing the actuator output.
    '''

@dataclass(repr=False)
class Command(Control):
    '''
    A Command is a discrete control used for supervisory control.
    '''

    normalValue: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal value for Control.value e.g. used for percentage scaling.
    '''

    value: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The value representing the actuator output.
    '''

    DiscreteValue: Optional[DiscreteValue] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'DiscreteValue.Command',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The MeasurementValue that is controlled.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ValueAliasSet.Commands',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The ValueAliasSet used for translation of a Control value to a name.
    '''

@dataclass(repr=False)
class DiscreteCommand(Command):
    '''
    '''

@dataclass(repr=False)
class MeasurementValue(IOPoint):
    '''
    The current state for a measurement. A state value is an instance of a
    measurement from a specific source. Measurements can be associated with
    many state values, each representing a different source for the measurement.
    '''

    timeStamp: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The time when the value was last updated
    '''

    sensorAccuracy: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The limit, expressed as a percentage of the sensor maximum, that errors
    will not exceed when the sensor is used under reference conditions.
    '''

    MeasurementValueQuality: Optional[MeasurementValueQuality] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'MeasurementValueQuality.MeasurementValue',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''

    MeasurementValueSource: Optional[MeasurementValueSource] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'MeasurementValueSource.MeasurementValues',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A reference to the type of source that updates the MeasurementValue, e.g.
    SCADA, CCLink, manual, etc. User conventions for the names of sources are
    contained in the introduction to IEC 61970-301.
    '''

    ProcedureDataSet: list[ProcedureDataSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProcedureDataSet.MeasurementValue',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class AccumulatorValue(MeasurementValue):
    '''
    AccumulatorValue represents an accumulated (counted) MeasurementValue.
    '''

    value: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The value to supervise. The value is positive.
    '''

    Accumulator: Optional[Accumulator] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Accumulator.AccumulatorValues',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Measurement to which this value is connected.
    '''

    AccumulatorReset: Optional[AccumulatorReset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AccumulatorReset.AccumulatorValue',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The command that reset the accumulator value.
    '''

@dataclass(repr=False)
class AnalogValue(MeasurementValue):
    '''
    AnalogValue represents an analog MeasurementValue.
    '''

    value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The value to supervise.
    '''

    Analog: Optional[Analog] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Analog.AnalogValues',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Measurement to which this value is connected.
    '''

    AnalogControl: Optional[AnalogControl] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AnalogControl.AnalogValue',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The Control variable associated with the MeasurementValue.
    '''

@dataclass(repr=False)
class DiscreteValue(MeasurementValue):
    '''
    DiscreteValue represents a discrete MeasurementValue.
    '''

    value: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The value to supervise.
    '''

    Command: Optional[Command] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Command.DiscreteValue',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The Control variable associated with the MeasurementValue.
    '''

    Discrete: Optional[Discrete] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Discrete.DiscreteValues',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Measurement to which this value is connected.
    '''

@dataclass(repr=False)
class IntervalReading(MeasurementValue):
    '''
    Data captured at regular intervals of time. Interval data could be captured
    as incremental data, absolute data, or relative data. The source for the
    data is usually a tariff quantity or an engineering quantity. Data is typically
    captured in time-tagged, uniform, fixed-length intervals of 5 min, 10 min,
    15 min, 30 min, or 60 min.
    Note: Interval Data is sometimes also called "Interval Data Readings" (IDR).
    '''

    IntervalBlocks: list[IntervalBlock] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'IntervalBlock.IntervalReadings',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All blocks containing this interval reading.
    '''

@dataclass(repr=False)
class Reading(MeasurementValue):
    '''
    Specific value measured by a meter or other asset, or calculated by a system.
    Each Reading is associated with a specific ReadingType.
    '''

    reason: Optional[ ReadingReasonKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reason for this reading being taken.
    '''

    MeterReadings: list[MeterReading] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeterReading.Readings',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All meter readings (sets of values) containing this reading value.
    '''

    ReadingType: Optional[ReadingType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReadingType.Readings',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type information for this reading value.
    '''

@dataclass(repr=False)
class StringMeasurementValue(MeasurementValue):
    '''
    StringMeasurementValue represents a measurement value of type string.
    '''

    value: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The value to supervise.
    '''

    StringMeasurement: Optional[StringMeasurement] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StringMeasurement.StringMeasurementValues',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Measurement to which this value is connected.
    '''

@dataclass(repr=False)
class Limit(IdentifiedObject):
    '''
    Specifies one limit value for a Measurement. A Measurement typically has
    several limits that are kept together by the LimitSet class. The actual
    meaning and use of a Limit instance (i.e., if it is an alarm or warning
    limit or if it is a high or low limit) is not captured in the Limit class.
    However the name of a Limit instance may indicate both meaning and use.
    '''

    Procedures: list[Procedure] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Procedure.Limits',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class AccumulatorLimit(Limit):
    '''
    Limit values for Accumulator measurements.
    '''

    value: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The value to supervise against. The value is positive.
    '''

    LimitSet: Optional[AccumulatorLimitSet] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AccumulatorLimitSet.Limits',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The set of limits.
    '''

@dataclass(repr=False)
class AnalogLimit(Limit):
    '''
    Limit values for Analog measurements.
    '''

    value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The value to supervise against.
    '''

    LimitSet: Optional[AnalogLimitSet] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AnalogLimitSet.Limits',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The set of limits.
    '''

@dataclass(repr=False)
class LimitSet(IdentifiedObject):
    '''
    Specifies a set of Limits that are associated with a Measurement. A Measurement
    may have several LimitSets corresponding to seasonal or other changing
    conditions. The condition is captured in the name and description attributes.
    The same LimitSet may be used for several Measurements. In particular percentage
    limits are used this way.
    '''

    isPercentageLimits: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Tells if the limit values are in percentage of normalValue or the specified
    Unit for Measurements and Controls.
    '''

@dataclass(repr=False)
class AccumulatorLimitSet(LimitSet):
    '''
    An AccumulatorLimitSet specifies a set of Limits that are associated with
    an Accumulator measurement.
    '''

    Limits: list[AccumulatorLimit] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AccumulatorLimit.LimitSet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The limit values used for supervision of Measurements.
    '''

    Measurements: list[Accumulator] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Accumulator.LimitSets',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The Measurements using the LimitSet.
    '''

@dataclass(repr=False)
class AnalogLimitSet(LimitSet):
    '''
    An AnalogLimitSet specifies a set of Limits that are associated with an
    Analog measurement.
    '''

    Limits: list[AnalogLimit] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AnalogLimit.LimitSet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The limit values used for supervision of Measurements.
    '''

    Measurements: list[Analog] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Analog.LimitSets',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The Measurements using the LimitSet.
    '''

@dataclass(repr=False)
class LoadGroup(IdentifiedObject):
    '''
    The class is the third level in a hierarchical structure for grouping of
    loads for the purpose of load flow load scaling.
    '''

    SubLoadArea: Optional[SubLoadArea] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SubLoadArea.LoadGroups',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The SubLoadArea where the Loadgroup belongs.
    '''

@dataclass(repr=False)
class ConformLoadGroup(LoadGroup):
    '''
    A group of loads conforming to an allocation pattern.
    '''

    ConformLoadSchedules: list[ConformLoadSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConformLoadSchedule.ConformLoadGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The ConformLoadSchedules in the ConformLoadGroup.
    '''

    EnergyConsumers: list[ConformLoad] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConformLoad.LoadGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Conform loads assigned to this ConformLoadGroup.
    '''

@dataclass(repr=False)
class NonConformLoadGroup(LoadGroup):
    '''
    Loads that do not follow a daily and seasonal load variation pattern.
    '''

    EnergyConsumers: list[NonConformLoad] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NonConformLoad.LoadGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Conform loads assigned to this ConformLoadGroup.
    '''

    NonConformLoadSchedules: list[NonConformLoadSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NonConformLoadSchedule.NonConformLoadGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The NonConformLoadSchedules in the NonConformLoadGroup.
    '''

@dataclass(repr=False)
class LoadResponseCharacteristic(IdentifiedObject):
    '''
    Models the characteristic response of the load demand due to changes in
    system conditions such as voltage and frequency. This is not related to
    demand response.
    If LoadResponseCharacteristic.exponentModel is True, the voltage exponents
    are specified and used as to calculate:
    Active power component = Pnominal * (Voltage/cim:BaseVoltage.nominalVoltage)
    ** cim:LoadResponseCharacteristic.pVoltageExponent
    Reactive power component = Qnominal * (Voltage/cim:BaseVoltage.nominalVoltage)**
    cim:LoadResponseCharacteristic.qVoltageExponent
    Where * means "multiply" and ** is "raised to power of".
    '''

    exponentModel: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates the exponential voltage dependency model is to be used. If false,
    the coefficient model is to be used.
    The exponential voltage dependency model consist of the attributes
    - pVoltageExponent
    - qVoltageExponent.
    The coefficient model consist of the attributes
    - pConstantImpedance
    - pConstantCurrent
    - pConstantPower
    - qConstantImpedance
    - qConstantCurrent
    - qConstantPower.
    The sum of pConstantImpedance, pConstantCurrent and pConstantPower shall
    equal 1.
    The sum of qConstantImpedance, qConstantCurrent and qConstantPower shall
    equal 1.
    '''

    pConstantCurrent: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Portion of active power load modeled as constant current.
    '''

    pConstantImpedance: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Portion of active power load modeled as constant impedance.
    '''

    pConstantPower: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Portion of active power load modeled as constant power.
    '''

    pVoltageExponent: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Exponent of per unit voltage effecting real power.
    '''

    qConstantCurrent: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Portion of reactive power load modeled as constant current.
    '''

    qConstantImpedance: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Portion of reactive power load modeled as constant impedance.
    '''

    qConstantPower: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Portion of reactive power load modeled as constant power.
    '''

    qVoltageExponent: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Exponent of per unit voltage effecting reactive power.
    '''

    EnergyConsumer: list[EnergyConsumer] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnergyConsumer.LoadResponse',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The set of loads that have the response characteristics.
    '''

@dataclass(repr=False)
class Location(IdentifiedObject):
    '''
    The place, scene, or point of something where someone or something has
    been, is, and/or will be at a given moment in time. It can be defined with
    one or more postition points (coordinates) in a given coordinate system.
    '''

    direction: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Direction that allows field crews to quickly find a given
    asset. For a given location, such as a street address, this is the relative
    direction in which to find the asset. For example, a streetlight may be
    located at the 'NW' (northwest) corner of the customer's site, or a usage
    point may be located on the second floor of an apartment building.
    '''

    geoInfoReference: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Reference to geographical information source, often external
    to the utility.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Classification by utility's corporate standards and practices, relative
    to the location itself (e.g., geographical, functional accounting, etc.,
    not a given property that happens to exist at that location).
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.Location',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All assets at this location.
    '''

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConfigurationEvent.ChangedLocation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All configuration events created for this location.
    '''

    CoordinateSystem: Optional[CoordinateSystem] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CoordinateSystem.Locations',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Coordinate system used to describe position points of this location.
    '''

    Crew: list[Crew] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Crew.Location',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    electronicAddress: Optional[ElectronicAddress] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Electronic address.
    '''

    EnvironmentalLocationKind: list[EnvironmentalLocationType] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalLocationType.Location',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of environmental location which this location is.
    '''

    Fault: list[Fault] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Fault.Location',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Hazards: list[AssetLocationHazard] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AssetLocationHazard.Locations',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All asset hazards at this location.
    '''

    mainAddress: Optional[StreetAddress] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Main address of the location.
    '''

    Measurements: list[Measurement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Measurement.Locations',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    phone1: Optional[TelephoneNumber] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phone number.
    '''

    phone2: Optional[TelephoneNumber] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Additional phone number.
    '''

    PositionPoints: list[PositionPoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PositionPoint.Location',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Sequence of position points describing this location, expressed in coordinate
    system 'Location.CoordinateSystem'.
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerSystemResource.Location',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All power system resources at this location.
    '''

    secondaryAddress: Optional[StreetAddress] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Secondary address of the location. For example, PO Box address may have
    different ZIP code than that in the 'mainAddress'.
    '''

    status: Optional[Status] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Status of this location.
    '''

@dataclass(repr=False)
class UsagePointLocation(Location):
    '''
    Location of an individual usage point.
    '''

    accessMethod: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Method for the service person to access this usage point location. For
    example, a description of where to obtain a key if the facility is unmanned
    and secured.
    '''

    remark: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Remarks about this location.
    '''

    siteAccessProblem: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Problems previously encountered when visiting or performing work at this
    location. Examples include: bad dog, violent customer, verbally abusive
    occupant, obstructions, safety hazards, etc.
    '''

    UsagePoints: list[UsagePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UsagePoint.UsagePointLocation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All usage points at this location.
    '''

@dataclass(repr=False)
class Measurement(IdentifiedObject):
    '''
    A Measurement represents any measured, calculated or non-measured non-calculated
    quantity. Any piece of equipment may contain Measurements, e.g. a substation
    may have temperature measurements and door open indications, a transformer
    may have oil temperature and tank pressure measurements, a bay may contain
    a number of power flow measurements and a Breaker may contain a switch
    status measurement.
    The PSR - Measurement association is intended to capture this use of Measurement
    and is included in the naming hierarchy based on EquipmentContainer. The
    naming hierarchy typically has Measurements as leafs, e.g. Substation-VoltageLevel-Bay-Switch-Measurement.
    Some Measurements represent quantities related to a particular sensor location
    in the network, e.g. a voltage transformer (PT) at a busbar or a current
    transformer (CT) at the bar between a breaker and an isolator. The sensing
    position is not captured in the PSR - Measurement association. Instead
    it is captured by the Measurement - Terminal association that is used to
    define the sensing location in the network topology. The location is defined
    by the connection of the Terminal to ConductingEquipment.
    If both a Terminal and PSR are associated, and the PSR is of type ConductingEquipment,
    the associated Terminal should belong to that ConductingEquipment instance.
    When the sensor location is needed both Measurement-PSR and Measurement-Terminal
    are used. The Measurement-Terminal association is never used alone.
    '''

    measurementType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Specifies the type of measurement. For example, this specifies if the measurement
    represents an indoor temperature, outdoor temperature, bus voltage, line
    flow, etc.
    When the measurementType is set to "Specialization", the type of Measurement
    is defined in more detail by the specialized class which inherits from
    Measurement.
    '''

    phases: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates to which phases the measurement applies and avoids the need to
    use 'measurementType' to also encode phase information (which would explode
    the types). The phase information in Measurement, along with 'measurementType'
    and 'phases' uniquely defines a Measurement for a device, based on normal
    network phase. Their meaning will not change when the computed energizing
    phasing is changed due to jumpers or other reasons.
    If the attribute is missing three phases (ABC) shall be assumed.
    '''

    Asset: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.Measurements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Locations: list[Location] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Location.Measurements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerSystemResource.Measurements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The power system resource that contains the measurement.
    '''

    Procedures: list[Procedure] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Procedure.Measurements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Measurements are specified in types of documents, such as procedures.
    '''

    Terminal: Optional[ACDCTerminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACDCTerminal.Measurements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    One or more measurements may be associated with a terminal in the network.
    '''

@dataclass(repr=False)
class Accumulator(Measurement):
    '''
    Accumulator represents an accumulated (counted) Measurement, e.g. an energy
    value.
    '''

    maxValue: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal value range maximum for any of the MeasurementValue.values. Used
    for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    AccumulatorValues: list[AccumulatorValue] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AccumulatorValue.Accumulator',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The values connected to this measurement.
    '''

    LimitSets: list[AccumulatorLimitSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AccumulatorLimitSet.Measurements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A measurement may have zero or more limit ranges defined for it.
    '''

@dataclass(repr=False)
class Analog(Measurement):
    '''
    Analog represents an analog Measurement.
    '''

    maxValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal value range maximum for any of the MeasurementValue.values. Used
    for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    minValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal value range minimum for any of the MeasurementValue.values. Used
    for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    normalValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''

    positiveFlowIn: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true then this measurement is an active power, reactive power or current
    with the convention that a positive value measured at the Terminal means
    power is flowing into the related PowerSystemResource.
    '''

    AnalogValues: list[AnalogValue] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AnalogValue.Analog',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The values connected to this measurement.
    '''

    LimitSets: list[AnalogLimitSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AnalogLimitSet.Measurements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A measurement may have zero or more limit ranges defined for it.
    '''

@dataclass(repr=False)
class EnvironmentalAnalog(Analog):
    '''
    Analog measurement of relevance in the environmental domain.
    '''

    ClassificationCondition: Optional[ClassificationCondition] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ClassificationCondition.EnvironmentalAnalog',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Classification condition which this analog helps define.
    '''

    EnvironmentalInformation: Optional[EnvironmentalInformation] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnvironmentalInformation.EnvironmentalAnalog',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Observation or forecast with which this environmental analog measurement
    is associated.
    '''

    ReportingCapability: Optional[ReportingCapability] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReportingCapability.EnvironmentalAnalog',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reporting capability this environmental value set helps define.
    '''

@dataclass(repr=False)
class Discrete(Measurement):
    '''
    Discrete represents a discrete Measurement, i.e. a Measurement representing
    discrete values, e.g. a Breaker position.
    '''

    maxValue: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal value range maximum for any of the MeasurementValue.values. Used
    for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    minValue: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal value range minimum for any of the MeasurementValue.values. Used
    for scaling, e.g. in bar graphs or of telemetered raw values.
    '''

    normalValue: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal measurement value, e.g., used for percentage calculations.
    '''

    DiscreteValues: list[DiscreteValue] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DiscreteValue.Discrete',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The values connected to this measurement.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ValueAliasSet.Discretes',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The ValueAliasSet used for translation of a MeasurementValue.value to a
    name.
    '''

@dataclass(repr=False)
class StringMeasurement(Measurement):
    '''
    StringMeasurement represents a measurement with values of type string.
    '''

    StringMeasurementValues: list[StringMeasurementValue] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'StringMeasurementValue.StringMeasurement',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The values connected to this measurement.
    '''

@dataclass(repr=False)
class EnvironmentalStringMeasurement(StringMeasurement):
    '''
    String measurement of relevance in the environmental domain.
    '''

    ClassificationCondition: Optional[ClassificationCondition] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ClassificationCondition.EnvironmentalStringMeasurement',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Classification condition which this string measurement helps define.
    '''

    EnvironmentalInformation: Optional[EnvironmentalInformation] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnvironmentalInformation.EnvironmentalStringMeasurement',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Observation or forecast with which this environmental string is associated.
    '''

@dataclass(repr=False)
class MeasurementValueSource(IdentifiedObject):
    '''
    MeasurementValueSource describes the alternative sources updating a MeasurementValue.
    User conventions for how to use the MeasurementValueSource attributes are
    described in the introduction to IEC 61970-301.
    '''

    MeasurementValues: list[MeasurementValue] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeasurementValue.MeasurementValueSource',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The MeasurementValues updated by the source.
    '''

@dataclass(repr=False)
class Medium(IdentifiedObject):
    '''
    A substance that either (1) provides the means of transmission of a force
    or effect, such as hydraulic fluid, or (2) is used for a surrounding or
    enveloping substance, such as oil in a transformer or circuit breaker.
    '''

    kind: Optional[ MediumKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of this medium.
    '''

    volumeSpec: Optional[ float | Volume ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The volume of the medium specified for this application. Note that the
    actual volume is a type of measurement associated witht the asset.
    '''

    Asset: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.Medium',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class MeterMultiplier(IdentifiedObject):
    '''
    Multiplier applied at the meter.
    '''

    value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Multiplier value.
    '''

    kind: Optional[ MeterMultiplierKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of multiplier.
    '''

    Meter: Optional[Meter] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Meter.MeterMultipliers',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Meter applying this multiplier.
    '''

@dataclass(repr=False)
class MeterReading(IdentifiedObject):
    '''
    Set of values obtained from the meter.
    '''

    isCoincidentTrigger: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, this meter reading is the meter reading for which other coincident
    meter readings are requested or provided.
    '''

    CustomerAgreement: Optional[CustomerAgreement] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CustomerAgreement.MeterReadings',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (could be deprecated in the future) Customer agreement for this meter reading.
    '''

    EndDeviceEvents: list[EndDeviceEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceEvent.MeterReading',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end device events associated with this set of measured values.
    '''

    IntervalBlocks: list[IntervalBlock] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'IntervalBlock.MeterReading',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All interval blocks contained in this meter reading.
    '''

    Meter: Optional[Meter] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Meter.MeterReadings',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Meter providing this reading.
    '''

    Readings: list[Reading] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Reading.MeterReadings',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All reading values contained within this meter reading.
    '''

    UsagePoint: Optional[UsagePoint] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'UsagePoint.MeterReadings',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Usage point from which this meter reading (set of values) has been obtained.
    '''

    valuesInterval: Optional[DateTimeInterval] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time interval of the data items contained within this meter reading.
    '''

@dataclass(repr=False)
class MetrologyRequirement(IdentifiedObject):
    '''
    A specification of the metering requirements for a particular point within
    a network.
    '''

    reason: Optional[ ReadingReasonKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reason for this metrology requirement being specified.
    '''

    ReadingTypes: list[ReadingType] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ReadingType.MetrologyRequirements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All reading types required to be collected by this metrology requirement.
    '''

    UsagePoints: list[UsagePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UsagePoint.MetrologyRequirements',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All usage points having this metrology requirement.
    '''

@dataclass(repr=False)
class MutualCoupling(IdentifiedObject):
    '''
    This class represents the zero sequence line mutual coupling.
    '''

    b0ch: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence mutual coupling shunt (charging) susceptance, uniformly distributed,
    of the entire line section.
    '''

    distance11: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Distance to the start of the coupled region from the first line's terminal
    having sequence number equal to 1.
    '''

    distance12: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Distance to the end of the coupled region from the first line's terminal
    with sequence number equal to 1.
    '''

    distance21: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Distance to the start of coupled region from the second line's terminal
    with sequence number equal to 1.
    '''

    distance22: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Distance to the end of coupled region from the second line's terminal with
    sequence number equal to 1.
    '''

    g0ch: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence mutual coupling shunt (charging) conductance, uniformly distributed,
    of the entire line section.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence branch-to-branch mutual impedance coupling, resistance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence branch-to-branch mutual impedance coupling, reactance.
    '''

    First_Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.HasFirstMutualCoupling',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The starting terminal for the calculation of distances along the first
    branch of the mutual coupling. Normally MutualCoupling would only be used
    for terminals of AC line segments. The first and second terminals of a
    mutual coupling should point to different AC line segments.
    '''

    Second_Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.HasSecondMutualCoupling',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The starting terminal for the calculation of distances along the second
    branch of the mutual coupling.
    '''

@dataclass(repr=False)
class NamedPhenomenon(IdentifiedObject):
    '''
    Supports designating multiple environmental phenomenon (in different Observations
    or Forecasts) as all related to the same identified phenomenon (a specific
    hurricane or tornado or flood, or example).
    '''

    EnvironmentalPhenomenon: list[EnvironmentalPhenomenon] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalPhenomenon.NamedPhenomenon',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    An occurence of an environmental phenomenon associated with this identified
    phenomenon.
    '''

@dataclass(repr=False)
class OperatingParticipant(IdentifiedObject):
    '''
    An operator of multiple power system resource objects. Note multple operating
    participants may operate the same power system resource object. This can
    be used for modeling jointly owned units where each owner operates as a
    contractual share.
    '''

    OperatingShare: list[OperatingShare] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperatingShare.OperatingParticipant',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The operating shares of this operating participant. An operating participant
    can be resused for any number of power system resources.
    '''

@dataclass(repr=False)
class OperationalLimit(IdentifiedObject):
    '''
    A value associated with a specific kind of limit.
    The sub class value attribute shall be positive.
    The sub class value attribute is inversely proportional to OperationalLimitType.acceptableDuration
    (acceptableDuration for short). A pair of value_x and acceptableDuration_x
    are related to each other as follows:
    if value_1 &gt; value_2 &gt; value_3 &gt;... then
    acceptableDuration_1 &lt; acceptableDuration_2 &lt; acceptableDuration_3
    &lt; ...
    A value_x with direction="high" shall be greater than a value_y with direction="low".
    '''

    OperationalLimitSet: Optional[OperationalLimitSet] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'OperationalLimitSet.OperationalLimitValue',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The limit set to which the limit values belong.
    '''

    OperationalLimitType: Optional[OperationalLimitType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'OperationalLimitType.OperationalLimit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The limit type associated with this limit.
    '''

@dataclass(repr=False)
class ActivePowerLimit(OperationalLimit):
    '''
    Limit on active power flow.
    '''

    normalValue: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The normal value of active power limit.
    '''

    value: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Value of active power limit.
    '''

@dataclass(repr=False)
class ApparentPowerLimit(OperationalLimit):
    '''
    Apparent power limit.
    '''

    normalValue: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The normal apparent power limit.
    '''

    value: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The apparent power limit.
    '''

@dataclass(repr=False)
class CurrentLimit(OperationalLimit):
    '''
    Operational limit on current.
    '''

    normalValue: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The normal value for limit on current flow.
    '''

    value: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Limit on current flow.
    '''

@dataclass(repr=False)
class VoltageLimit(OperationalLimit):
    '''
    Operational limit applied to voltage.
    '''

    normalValue: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The normal limit on voltage. High or low limit nature of the limit depends
    upon the properties of the operational limit type.
    '''

    value: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Limit on voltage. High or low limit nature of the limit depends upon the
    properties of the operational limit type.
    '''

@dataclass(repr=False)
class OperationalLimitSet(IdentifiedObject):
    '''
    A set of limits associated with equipment. Sets of limits might apply to
    a specific temperature, or season for example. A set of limits may contain
    different severities of limit levels that would apply to the same equipment.
    The set may contain limits of different types such as apparent power and
    current limits or high and low voltage limits that are logically applied
    together as a set.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConnectivityNode.OperationalLimitSet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Equipment: Optional[Equipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Equipment.OperationalLimitSet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The equipment to which the limit set applies.
    '''

    OperationalLimitValue: list[OperationalLimit] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperationalLimit.OperationalLimitSet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Values of equipment limits.
    '''

    Terminal: Optional[ACDCTerminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACDCTerminal.OperationalLimitSet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class OperationalLimitType(IdentifiedObject):
    '''
    The operational meaning of a category of limits.
    '''

    acceptableDuration: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The nominal acceptable duration of the limit. Limits are commonly expressed
    in terms of the a time limit for which the limit is normally acceptable.
    The actual acceptable duration of a specific limit may depend on other
    local factors such as temperature or wind speed.
    '''

    direction: Optional[ OperationalLimitDirectionKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The direction of the limit.
    '''

    OperationalLimit: list[OperationalLimit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperationalLimit.OperationalLimitType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The operational limits associated with this type of limit.
    '''

@dataclass(repr=False)
class Organisation(IdentifiedObject):
    '''
    Organisation that might have roles as utility, contractor, supplier, manufacturer,
    customer, etc.
    '''

    electronicAddress: Optional[ElectronicAddress] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Electronic address.
    '''

    ParentOrganisation: Optional[ParentOrganization] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ParentOrganization.Organisation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Parent organisation of this organisation.
    '''

    phone1: Optional[TelephoneNumber] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phone number.
    '''

    phone2: Optional[TelephoneNumber] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Additional phone number.
    '''

    postalAddress: Optional[StreetAddress] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Postal address, potentially different than 'streetAddress' (e.g., another
    city).
    '''

    Roles: list[OrganisationRole] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OrganisationRole.Organisation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All roles of this organisation.
    '''

    streetAddress: Optional[StreetAddress] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Street address.
    '''

@dataclass(repr=False)
class ParentOrganization(Organisation):
    '''
    '''

    Organisation: list[Organisation] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Organisation.ParentOrganisation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Organisation that is part of this parent organisation.
    '''

@dataclass(repr=False)
class OrganisationRole(IdentifiedObject):
    '''
    Identifies a way in which an organisation may participate in the utility
    enterprise (e.g., customer, manufacturer, etc).
    '''

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConfigurationEvent.ChangedOrganisationRole',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All configuration events created for this organisation role.
    '''

    Organisation: Optional[Organisation] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Organisation.Roles',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Organisation having this role.
    '''

@dataclass(repr=False)
class AssetOrganisationRole(OrganisationRole):
    '''
    Role an organisation plays with respect to asset.
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.OrganisationRoles',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All assets for this organisation role.
    '''

@dataclass(repr=False)
class AssetOwner(AssetOrganisationRole):
    '''
    Owner of the asset.
    '''

    Ownerships: list[Ownership] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Ownership.AssetOwner',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All ownerships of this owner.
    '''

@dataclass(repr=False)
class Customer(OrganisationRole):
    '''
    Organisation receiving services from service supplier.
    '''

    locale: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Locale designating language to use in communications with this customer.
    '''

    pucNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Public utilities commission (PUC) identification number.
    '''

    specialNeed: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if customer organisation has special service needs such as life support,
    hospitals, etc.
    '''

    vip: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'deprecated',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (use 'priority' instead) True if this is an important customer. Importance
    is for matters different than those in 'specialNeed' attribute.
    '''

    kind: Optional[ CustomerKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of customer.
    '''

    CustomerAccounts: list[CustomerAccount] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CustomerAccount.Customer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All accounts of this customer.
    '''

    CustomerAgreements: list[CustomerAgreement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CustomerAgreement.Customer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All agreements of this customer.
    '''

    CustomerNotifications: list[CustomerNotification] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CustomerNotification.Customer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All notifications required by this customer.
    '''

    EndDevices: list[EndDevice] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDevice.Customer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end devices of this customer.
    '''

    priority: Optional[Priority] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Priority of the customer.
    '''

    status: Optional[Status] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Status of this customer.
    '''

    TroubleTickets: list[TroubleTicket] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TroubleTicket.Customer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All trouble tickets for this customer.
    '''

@dataclass(repr=False)
class EnvironmentalDataAuthority(OrganisationRole):
    '''
    An entity defining classifications or categories of environmental information,
    like phenomena or alerts.
    '''

    AlertTypeList: list[AlertTypeList] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'AlertTypeList.EnvironmentalDataAuthority',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A specific version of a list of alerts published by this environmental
    data authority.
    '''

    PhenomenonClassification: list[PhenomenonClassification] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PhenomenonClassification.EnvironmentalDataAuthority',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phenomenon classification defined by this environmental data authority.
    '''

@dataclass(repr=False)
class EnvironmentalDataProvider(OrganisationRole):
    '''
    Entity providing environmental data. Could be an observed weather data
    provider, an entity providing forecasts, an authority providing alerts,
    etc.
    '''

    EnvironmentalAlert: list[EnvironmentalAlert] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalAlert.EnvironmentalDataProvider',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Alert issued by this environmental data provider.
    '''

    EnvironmentalInformation: list[EnvironmentalInformation] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalInformation.EnvironmentalDataProvider',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Environmental information provided by this environmental data provider.
    '''

@dataclass(repr=False)
class Manufacturer(OrganisationRole):
    '''
    Organisation that manufactures asset products.
    '''

    ProductAssetModels: list[ProductAssetModel] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProductAssetModel.Manufacturer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All asset models by this manufacturer.
    '''

@dataclass(repr=False)
class Ownership(IdentifiedObject):
    '''
    Ownership of e.g. asset.
    '''

    share: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Share of this ownership.
    '''

    Asset: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.Ownerships',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Asset that is object of this ownership.
    '''

    AssetOwner: Optional[AssetOwner] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetOwner.Ownerships',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Asset owner that is subject in this ownership.
    '''

@dataclass(repr=False)
class PSRType(IdentifiedObject):
    '''
    Classifying instances of the same class, e.g. overhead and underground
    ACLineSegments. This classification mechanism is intended to provide flexibility
    outside the scope of this standard, i.e. provide customisation that is
    non standard.
    '''

    PowerSystemResources: list[PowerSystemResource] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerSystemResource.PSRType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Power system resources classified with this power system resource type.
    '''

@dataclass(repr=False)
class ParallelLineSegment(IdentifiedObject):
    '''
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACLineSegment.ParallelLineSegment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    RightOfWay: Optional[RightOfWay] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RightOfWay.ParallelLineSegments',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class PerLengthLineParameter(IdentifiedObject):
    '''
    Common type for per-length electrical catalogues describing line parameters.
    '''

    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'WireAssemblyInfo.PerLengthLineParameter',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A WireAssemblyInfo is used to compute the PerLengthParameter data in the
    Wires package
    '''

@dataclass(repr=False)
class PerLengthImpedance(PerLengthLineParameter):
    '''
    Common type for per-length impedance electrical catalogues.
    '''

    ACLineSegments: list[ACLineSegment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ACLineSegment.PerLengthImpedance',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All line segments described by this per-length impedance.
    '''

@dataclass(repr=False)
class PerLengthPhaseImpedance(PerLengthImpedance):
    '''
    Impedance and admittance parameters per unit length for n-wire unbalanced
    lines, in matrix form.
    '''

    conductorCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of phase, neutral, and other wires retained. Constrains the number
    of matrix elements and the phase codes that can be used with this matrix.
    '''

    PhaseImpedanceData: list[PhaseImpedanceData] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PhaseImpedanceData.PhaseImpedance',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All data that belong to this conductor phase impedance.
    '''

@dataclass(repr=False)
class PerLengthSequenceImpedance(PerLengthImpedance):
    '''
    Sequence impedance and admittance parameters per unit length, for transposed
    lines of 1, 2, or 3 phases. For 1-phase lines, define x=x0=xself. For 2-phase
    lines, define x=xs-xm and x0=xs+xm.
    '''

    b0ch: Optional[ float | SusceptancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence shunt (charging) susceptance, per unit of length.
    '''

    bch: Optional[ float | SusceptancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) susceptance, per unit of length.
    '''

    g0ch: Optional[ float | ConductancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence shunt (charging) conductance, per unit of length.
    '''

    gch: Optional[ float | ConductancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) conductance, per unit of length.
    '''

    r: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence series resistance, per unit of length.
    '''

    r0: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence series resistance, per unit of length.
    '''

    x: Optional[ float | ReactancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence series reactance, per unit of length.
    '''

    x0: Optional[ float | ReactancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence series reactance, per unit of length.
    '''

@dataclass(repr=False)
class Person(IdentifiedObject):
    '''
    General purpose information for name and other information to contact people.
    '''

    firstName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Person's first name.
    '''

    lastName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Person's last (family, sir) name.
    '''

    mName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Middle name(s) or initial(s).
    '''

    prefix: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A prefix or title for the person's name, such as Miss, Mister, Doctor,
    etc.
    '''

    specialNeed: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Special service needs for the person (contact) are described; examples
    include life support, etc.
    '''

    suffix: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A suffix for the person's name, such as II, III, etc.
    '''

    electronicAddress: Optional[ElectronicAddress] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Electronic address.
    '''

    landlinePhone: Optional[TelephoneNumber] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Landline phone number.
    '''

    mobilePhone: Optional[TelephoneNumber] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Mobile phone number.
    '''

    Roles: list[PersonRole] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PersonRole.Person',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All roles of this person.
    '''

@dataclass(repr=False)
class PersonRole(IdentifiedObject):
    '''
    '''

    Appointments: list[Appointment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Appointment.Persons',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All appointments for this person.
    '''

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConfigurationEvent.ChangedPersonRole',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All configuration events created for this person role.
    '''

    Person: Optional[Person] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Person.Roles',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Person having this role.
    '''

@dataclass(repr=False)
class Approver(PersonRole):
    '''
    Person who accepted/signed or rejected the document.
    '''

    Documents: list[Document] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Document.Approver',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All documents for this approver.
    '''

@dataclass(repr=False)
class Author(PersonRole):
    '''
    Person who created document or activity record.
    '''

    ActivityRecords: list[ActivityRecord] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ActivityRecord.Author',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All activity records with this author.
    '''

    Documents: list[Document] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Document.Author',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All documents of this this author.
    '''

@dataclass(repr=False)
class CrewMember(PersonRole):
    '''
    Member of a crew.
    '''

    Crew: Optional[Crew] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Crew.CrewMembers',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Crew to which this crew member belongs.
    '''

@dataclass(repr=False)
class Editor(PersonRole):
    '''
    Person who modified the document.
    '''

    Documents: list[Document] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Document.Editor',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All documents for this editor.
    '''

@dataclass(repr=False)
class Issuer(PersonRole):
    '''
    Person who issued the document and is responsible for its content.
    '''

    Documents: list[Document] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Document.Issuer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All documents for this issuer.
    '''

@dataclass(repr=False)
class PhaseImpedanceData(IdentifiedObject):
    '''
    Impedance and conductance matrix element values.
    The diagonal elements are described by the elements having the same toPhase
    and fromPhase value and the off diagonal elements have different toPhase
    and fromPhase values. The matrix can also be stored in symmetric lower
    triangular format using the row and column attributes, which map to ACLineSegmentPhase.sequenceNumber.
    '''

    column: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    This matrix element's column number, in the range 1 to row. Only the lower
    triangle needs to be stored. Neutrals should be numbered last. Multiple
    circuits on the same pole, tower or right-of-way can be included with unique
    sequence numbers for the phases, and identical sequence numbers for any
    shared neutrals. This solumn number matches ACLineSegmentPhase.sequenceNumber,
    WirePosition.sequenceNumber and WirePhaseInfo.sequenceNumber as applicable..
    '''

    row: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    This matrix element's row number, in the range 1 to PerLengthPhaseImpedance.conductorCount.
    Only the lower triangle needs to be stored. Neutrals should be numbered
    last. Multiple circuits on the same pole, tower or right-of-way can be
    included with unique sequence numbers for the phases, and identical sequence
    numbers for any shared neutrals. This row number matches ACLineSegmentPhase.sequenceNumber,
    WirePosition.sequenceNumber and WirePhaseInfo.sequenceNumber as applicable..
    '''

    b: Optional[ float | SusceptancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Susceptance matrix element value, per length of unit.
    '''

    g: Optional[ float | ConductancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Conductance matrix element value, per length of unit.
    '''

    r: Optional[ float | ResistancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Resistance matrix element value, per length of unit.
    '''

    x: Optional[ float | ReactancePerLength ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactance matrix element value, per length of unit.
    '''

    PhaseImpedance: Optional[PerLengthPhaseImpedance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PerLengthPhaseImpedance.PhaseImpedanceData',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Conductor phase impedance to which this data belongs.
    '''

@dataclass(repr=False)
class PhaseTapChangerTable(IdentifiedObject):
    '''
    Describes a tabular curve for how the phase angle difference and impedance
    varies with the tap step.
    '''

    PhaseTapChangerTablePoint: list[PhaseTapChangerTablePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PhaseTapChangerTablePoint.PhaseTapChangerTable',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The points of this table.
    '''

    PhaseTapChangerTabular: list[PhaseTapChangerTabular] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PhaseTapChangerTabular.PhaseTapChangerTable',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The phase tap changers to which this phase tap table applies.
    '''

@dataclass(repr=False)
class PhenomenonClassification(IdentifiedObject):
    '''
    A pre-defined phenomenon classification as defined by a particular authority.
    '''

@dataclass(repr=False)
class PowerSystemResource(IdentifiedObject):
    '''
    A power system resource can be an item of equipment such as a switch, an
    equipment container containing many individual items of equipment such
    as a substation, or an organisational entity such as sub-control area.
    Power system resources can have measurements associated.
    '''

    AssetDatasheet: Optional[AssetInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetInfo.PowerSystemResources',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Datasheet information for this power system resource.
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.PowerSystemResources',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All assets represented by this power system resource. For example, multiple
    conductor assets are electrically modelled as a single AC line segment.
    '''

    ConfigurationEvent: list[ConfigurationEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConfigurationEvent.PowerSystemResource',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Controls: list[Control] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Control.PowerSystemResource',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The controller outputs used to actually govern a regulating device, e.g.
    the magnetization of a synchronous machine or capacitor bank breaker actuator.
    '''

    Location: Optional[Location] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Location.PowerSystemResources',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Location of this power system resource.
    '''

    Measurements: list[Measurement] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Measurement.PowerSystemResource',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The measurements associated with this power system resource.
    '''

    OperatingShare: list[OperatingShare] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperatingShare.PowerSystemResource',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The operating shares of this power system resource.
    '''

    PSRType: Optional[PSRType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PSRType.PowerSystemResources',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Custom classification for this power system resource.
    '''

    ReportingGroup: list[ReportingGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ReportingGroup.PowerSystemResource',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reporting groups to which this power system resource belongs.
    '''

@dataclass(repr=False)
class ACLineSegmentPhase(PowerSystemResource):
    '''
    Represents a single wire of an alternating current line segment.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number designation for this line segment phase. Each line segment phase
    within a line segment should have a unique sequence number. This is useful
    for unbalanced modeling to bind the mathematical model (PhaseImpedanceData
    of PerLengthPhaseImpedance) with the connectivity model (this class) and
    the physical model (WirePosition, WirePhaseInfo) without tight coupling.
    Multiple circuits on the same pole, tower or right-of-way can be included
    with unique sequence numbers for the phases, and identical sequence numbers
    for any shared neutrals.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The phase connection of the wire at both ends.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACLineSegment.ACLineSegmentPhases',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The line segment to which the phase belongs.
    '''

    WireInfo: Optional[WireInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'WireInfo.ACLineSegmentPhases',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class AirCompressor(PowerSystemResource):
    '''
    Combustion turbine air compressor which is an integral part of a compressed
    air energy storage (CAES) plant.
    '''

    airCompressorRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rating of the CAES air compressor.
    '''

    CAESPlant: Optional[CAESPlant] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CAESPlant.AirCompressor',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    An air compressor may be a member of a compressed air energy storage plant.
    '''

@dataclass(repr=False)
class CAESPlant(PowerSystemResource):
    '''
    Compressed air energy storage plant.
    '''

    energyStorageCapacity: Optional[ float | RealEnergy ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The rated energy storage capacity.
    '''

    ratedCapacityP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The CAES plant's gross rated generating capacity.
    '''

    AirCompressor: Optional[AirCompressor] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AirCompressor.CAESPlant',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    An air compressor may be a member of a compressed air energy storage plant.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.CAESPlant',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may be a member of a compressed air energy storage
    plant.
    '''

@dataclass(repr=False)
class CogenerationPlant(PowerSystemResource):
    '''
    A set of thermal generating units for the production of electrical energy
    and process steam (usually from the output of the steam turbines). The
    steam sendout is typically used for industrial purposes or for municipal
    heating and cooling.
    '''

    cogenHPSendoutRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The high pressure steam sendout.
    '''

    cogenHPSteamRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The high pressure steam rating.
    '''

    cogenLPSendoutRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The low pressure steam sendout.
    '''

    cogenLPSteamRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The low pressure steam rating.
    '''

    ratedP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The rated output active power of the cogeneration plant.
    '''

    SteamSendoutSchedule: Optional[SteamSendoutSchedule] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SteamSendoutSchedule.CogenerationPlant',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A cogeneration plant has a steam sendout schedule.
    '''

    ThermalGeneratingUnits: list[ThermalGeneratingUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ThermalGeneratingUnit.CogenerationPlant',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may be a member of a cogeneration plant.
    '''

@dataclass(repr=False)
class CombinedCyclePlant(PowerSystemResource):
    '''
    A set of combustion turbines and steam turbines where the exhaust heat
    from the combustion turbines is recovered to make steam for the steam turbines,
    resulting in greater overall plant efficiency.
    '''

    combCyclePlantRating: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The combined cycle plant's active power output rating.
    '''

    ThermalGeneratingUnits: list[ThermalGeneratingUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ThermalGeneratingUnit.CombinedCyclePlant',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may be a member of a combined cycle plant.
    '''

@dataclass(repr=False)
class ConnectivityNodeContainer(PowerSystemResource):
    '''
    A base class for all objects that may contain connectivity nodes or topological
    nodes.
    '''

    ConnectivityNodes: list[ConnectivityNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConnectivityNode.ConnectivityNodeContainer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Connectivity nodes which belong to this connectivity node container.
    '''

    TopologicalNode: list[TopologicalNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TopologicalNode.ConnectivityNodeContainer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The topological nodes which belong to this connectivity node container.
    '''

@dataclass(repr=False)
class EquipmentContainer(ConnectivityNodeContainer):
    '''
    A modeling construct to provide a root class for containing equipment.
    '''

    AdditionalGroupedEquipment: list[Equipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Equipment.AdditionalEquipmentContainer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The additonal contained equipment. The equipment belong to the equipment
    container. The equipment is contained in another equipment container, but
    also grouped with this equipment container. Examples include when a switch
    contained in a substation is also desired to be grouped with a line contianer
    or when a switch is included in a secondary substation and also grouped
    in a feeder.
    '''

    Equipments: list[Equipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Equipment.EquipmentContainer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Contained equipment.
    '''

@dataclass(repr=False)
class Bay(EquipmentContainer):
    '''
    A collection of power system resources (within a given substation) including
    conducting equipment, protection relays, measurements, and telemetry. A
    bay typically represents a physical grouping related to modularization
    of equipment.
    '''

    bayEnergyMeasFlag: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates the presence/absence of energy measurements.
    '''

    bayPowerMeasFlag: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates the presence/absence of active/reactive power measurements.
    '''

    breakerConfiguration: Optional[ BreakerConfiguration ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Breaker configuration.
    '''

    busBarConfiguration: Optional[ BusbarConfiguration ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Bus bar configuration.
    '''

    Substation: Optional[Substation] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Substation.Bays',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Substation containing the bay.
    '''

    VoltageLevel: Optional[VoltageLevel] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'VoltageLevel.Bays',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The voltage level containing this bay.
    '''

@dataclass(repr=False)
class Feeder(EquipmentContainer):
    '''
    A collection of equipment for organizational purposes, used for grouping
    distribution resources.
    The organization a feeder does not necessarily reflect connectivity or
    current operation state.
    '''

    NamingSecondarySubstation: list[Substation] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Substation.NamingFeeder',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The secondary substations that are normally energized from the feeder.
    Used for naming purposes. Should be consistent with the other associations
    for energizing terminal specification and the feeder energization specification.
    '''

    NormalEnergizedSubstation: list[Substation] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Substation.NormalEnergizingFeeder',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The substations that are normally energized by the feeder.
    '''

    NormalEnergizingSubstation: Optional[Substation] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Substation.NormalEnergizedFeeder',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The substation that nominally energizes the feeder. Also used for naming
    purposes.
    '''

    NormalHeadTerminal: list[Terminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Terminal.NormalHeadFeeder',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The normal head terminal or terminals of the feeder.
    '''

@dataclass(repr=False)
class Line(EquipmentContainer):
    '''
    Contains equipment beyond a substation belonging to a power transmission
    line.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SubGeographicalRegion.Lines',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The sub-geographical region of the line.
    '''

@dataclass(repr=False)
class Plant(EquipmentContainer):
    '''
    A Plant is a collection of equipment for purposes of generation.
    '''

@dataclass(repr=False)
class Substation(EquipmentContainer):
    '''
    A collection of equipment for purposes other than generation or utilization,
    through which electric energy in bulk is passed for the purposes of switching
    or modifying its characteristics.
    '''

    Bays: list[Bay] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Bay.Substation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Bays contained in the substation.
    '''

    NamingFeeder: Optional[Feeder] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Feeder.NamingSecondarySubstation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The primary feeder that normally energizes the secondary substation. Used
    for naming purposes. Either this association or the substation to subgeographical
    region should be used for hiearchical containment specification.
    '''

    NormalEnergizedFeeder: list[Feeder] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Feeder.NormalEnergizingSubstation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The normal energized feeders of the substation. Also used for naming purposes.
    '''

    NormalEnergizingFeeder: list[Feeder] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Feeder.NormalEnergizedSubstation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The feeders that potentially energize the downstream substation. Should
    be consistent with the associations that describe the naming hiearchy.
    '''

    Region: Optional[SubGeographicalRegion] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SubGeographicalRegion.Substations',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The SubGeographicalRegion containing the substation.
    '''

    VoltageLevels: list[VoltageLevel] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'VoltageLevel.Substation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The voltage levels within this substation.
    '''

@dataclass(repr=False)
class VoltageLevel(EquipmentContainer):
    '''
    A collection of equipment at one common system voltage forming a switchgear.
    The equipment typically consist of breakers, busbars, instrumentation,
    control, regulation and protection devices as well as assemblies of all
    these.
    '''

    highVoltageLimit: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The bus bar's high voltage limit
    '''

    lowVoltageLimit: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The bus bar's low voltage limit
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BaseVoltage.VoltageLevel',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The base voltage used for all equipment within the voltage level.
    '''

    Bays: list[Bay] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Bay.VoltageLevel',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The bays within this voltage level.
    '''

    Substation: Optional[Substation] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Substation.VoltageLevels',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The substation of the voltage level.
    '''

@dataclass(repr=False)
class EnergyConsumerPhase(PowerSystemResource):
    '''
    A single phase of an energy consumer.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Active power of the load. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase of this energy consumer component. If the energy consumer is wye
    connected, the connection is from the indicated phase to the central ground
    or neutral point. If the energy consumer is delta connected, the phase
    indicates an energy consumer connected from the indicated phase to the
    next logical non-neutral phase.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactive power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    EnergyConsumer: Optional[EnergyConsumer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnergyConsumer.EnergyConsumerPhase',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The energy consumer to which this phase belongs.
    '''

@dataclass(repr=False)
class EnergySourcePhase(PowerSystemResource):
    '''
    Represents the single phase information of an unbalanced energy source.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase of this energy source component. If the energy source wye connected,
    the connection is from the indicated phase to the central ground or neutral
    point. If the energy source is delta connected, the phase indicates an
    energy source connected from the indicated phase to the next logical non-neutral
    phase.
    '''

    EnergySource: Optional[EnergySource] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EnergySource.EnergySourcePhase',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The energy sourceto which the phase belongs.
    '''

@dataclass(repr=False)
class Equipment(PowerSystemResource):
    '''
    The parts of a power system that are physical devices, electronic or mechanical.
    '''

    aggregate: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The single instance of equipment represents multiple pieces of equipment
    that have been modeled together as an aggregate. Examples would be power
    transformers or synchronous machines operating in parallel modeled as a
    single aggregate power transformer or aggregate synchronous machine. This
    is not to be used to indicate equipment that is part of a group of interdependent
    equipment produced by a network production program.
    '''

    inService: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, the equipment is in service.
    '''

    networkAnalysisEnabled: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The equipment is enabled to participate in network analysis. If unspecified,
    the value is assumed to be true.
    '''

    normallyInService: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, the equipment is normally in service.
    '''

    AdditionalEquipmentContainer: list[EquipmentContainer] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EquipmentContainer.AdditionalGroupedEquipment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Additional equipment container beyond the primary equipment container.
    The equipment is contained in another equipment container, but also grouped
    with this equipment container.
    '''

    EquipmentContainer: Optional[EquipmentContainer] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'EquipmentContainer.Equipments',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Container of this equipment.
    '''

    Faults: list[Fault] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Fault.FaultyEquipment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All faults on this equipment.
    '''

    OperationalLimitSet: list[OperationalLimitSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'OperationalLimitSet.Equipment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The operational limit sets associated with this equipment.
    '''

    UsagePoints: Optional[UsagePoint] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'UsagePoint.Equipments',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All usage points connected to the electrical grid through this equipment.
    '''

@dataclass(repr=False)
class CompositeSwitch(Equipment):
    '''
    A model of a set of individual Switches normally enclosed within the same
    cabinet and possibly with interlocks that restrict the combination of switch
    positions. These are typically found in medium voltage distribution networks.
    A CompositeSwitch could represent a Ring-Main-Unit (RMU), or pad-mounted
    switchgear, with primitive internal devices such as an internal bus-bar
    plus 3 or 4 internal switches each of which may individually be open or
    closed. A CompositeSwitch and a set of contained Switches can also be used
    to represent a multi-position switch e.g. a switch that can connect a circuit
    to Ground, Open or Busbar.
    '''

    compositeSwitchType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    An alphanumeric code that can be used as a reference to extra information
    such as the description of the interlocking scheme if any.
    '''

    Switches: list[Switch] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Switch.CompositeSwitch',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Switches contained in this Composite switch.
    '''

@dataclass(repr=False)
class ConductingEquipment(Equipment):
    '''
    The parts of the AC power system that are designed to carry current or
    that are conductively connected through terminals.
    '''

    controlEnabled: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Specifies the regulation status of the equipment. True is regulating, false
    is not regulating.
    '''

    converterFedDrive: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates whether the machine is a converter fed drive. Used for short
    circuit data exchange according to IEC 60909
    '''

    customerCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of individual customers represented by this demand.
    '''

    grounded: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Used for Yn and Zn connections. True if the neutral is solidly grounded.
    '''

    grounded: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Used for Yn and Zn connections. True if the neutral is solidly grounded.
    '''

    iaIrRatio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Ratio of locked-rotor current to the rated current of the motor (Ia/Ir).
    Used for short circuit data exchange according to IEC 60909
    '''

    ikSecond: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates whether initial symmetrical short-circuit current and power have
    been calculated according to IEC (Ik").
    '''

    maximumSections: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum number of sections that may be switched in.
    '''

    maxR0ToX0Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum ratio of zero sequence resistance of Network Feeder to its zero
    sequence reactance (R(0)/X(0) max). Used for short circuit data exchange
    according to IEC 60909
    '''

    maxR1ToX1Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum ratio of positive sequence resistance of Network Feeder to its
    positive sequence reactance (R(1)/X(1) max). Used for short circuit data
    exchange according to IEC 60909
    '''

    maxZ0ToZ1Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) max). Used for short circuit data exchange according to IEC
    60909
    '''

    minR0ToX0Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates whether initial symmetrical short-circuit current and power have
    been calculated according to IEC (Ik"). Used for short circuit data exchange
    according to IEC 6090
    '''

    minR1ToX1Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum ratio of positive sequence resistance of Network Feeder to its
    positive sequence reactance (R(1)/X(1) min). Used for short circuit data
    exchange according to IEC 60909
    '''

    minZ0ToZ1Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) min). Used for short circuit data exchange according to IEC
    60909
    '''

    normalOpen: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The attribute is used in cases when no Measurement for the status value
    is present. If the Switch has a status measurement the Discrete.normalValue
    is expected to match with the Switch.normalOpen.
    '''

    normalSections: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The normal number of sections switched in.
    '''

    open: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The attribute tells if the switch is considered open when used as input
    to topology processing.
    '''

    polePairNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of pole pairs of stator. Used for short circuit data exchange according
    to IEC 60909
    '''

    ratedPowerFactor: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Power factor (nameplate data). It is primarily used for short circuit data
    exchange according to IEC 60909.
    '''

    referencePriority: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Priority of unit for use as powerflow voltage phase angle reference bus
    selection. 0 = don t care (default) 1 = highest priority. 2 is less than
    1 and so on.
    '''

    retained: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Branch is retained in a bus branch model. The flow through retained switches
    will normally be calculated in power flow.
    '''

    reversible: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates for converter drive motors if the power can be reversible. Used
    for short circuit data exchange according to IEC 60909
    '''

    rxLockedRotorRatio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Locked rotor ratio (R/X). Used for short circuit data exchange according
    to IEC 60909
    '''

    sections: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Shunt compensator sections in use.
    Starting value for steady state solution. Non integer values are allowed
    to support continuous variables. The reasons for continuous value are to
    support study cases where no discrete shunt compensators has yet been designed,
    a solutions where a narrow voltage band force the sections to oscillate
    or accommodate for a continuous solution as input.
    '''

    varistorPresent: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Describe if a metal oxide varistor (mov) for over voltage protection is
    configured at the series compensator.
    '''

    vectorGroup: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Vector group of the transformer for protective relaying, e.g., Dyn1. For
    unbalanced transformers, this may not be simply determined from the constituent
    winding connections and phase angle dispacements.
    The vectorGroup string consists of the following components in the order
    listed: high voltage winding connection, mid voltage winding connection
    (for three winding transformers), phase displacement clock number from
    0 to 11, low voltage winding connection
    phase displacement clock number from 0 to 11. The winding connections are
    D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag with
    neutral), A (auto transformer). Upper case means the high voltage, lower
    case mid or low. The high voltage winding always has clock postion 0 and
    is not included in the vector group string. Some examples: YNy0 (two winding
    wye to wye with no phase displacement), YNd11 (two winding wye to delta
    with 330 degrees phase displacement), YNyn0d5 (three winding transformer
    wye with neutral high voltgage, wye with neutral mid voltgage and no phase
    displacement, delta low voltage with 150 degrees displacement).
    Phase displacement is defined as the angular difference between the phasors
    representing the voltages between the neutral point (real or imaginary)
    and the corresponding terminals of two windings, a positive sequence voltage
    system being applied to the high-voltage terminals, following each other
    in alphabetical sequence if they are lettered, or in numerical sequence
    if they are numbered: the phasors are assumed to rotate in a counter-clockwise
    sense.
    '''

    asynchronousMachineType: Optional[ AsynchronousMachineKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates the type of Asynchronous Machine (motor or generator).
    '''

    aVRDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Time delay required for the device to be connected or disconnected by automatic
    voltage regulation (AVR).
    '''

    b0ch: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence shunt (charging) susceptance, uniformly distributed, of the
    entire line section.
    '''

    b0PerSection: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence shunt (charging) susceptance per section
    '''

    bch: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line section. This value represents the full charging over
    the full length of the line.
    '''

    bPerSection: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) susceptance per section
    '''

    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum fault current a breaking device can break safely under prescribed
    conditions of use.
    '''

    capacitiveRating: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum available capacitive reactance.
    '''

    efficiency: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Efficiency of the asynchronous machine at nominal operation in percent.
    Indicator for converter drive motors. Used for short circuit data exchange
    according to IEC 60909
    '''

    frequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Frequency on the AC side.
    '''

    g0ch: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence shunt (charging) conductance, uniformly distributed, of the
    entire line section.
    '''

    g0PerSection: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence shunt (charging) conductance per section
    '''

    gch: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) conductance, uniformly distributed,
    of the entire line section.
    '''

    governorSCD: Optional[ float | ActivePowerPerFrequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Power Frequency Bias. This is the change in power injection divided by
    the change in frequency and negated. A positive value of the power frequency
    bias provides additional power injection upon a drop in frequency.
    '''

    gPerSection: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) conductance per section
    '''

    ikk: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Steady-state short-circuit current (in A for the profile) of generator
    with compound excitation during 3-phase short circuit.
    - Ikk=0: Generator with no compound excitation.
    - Ikk?0: Generator with compound excitation.
    Ikk is used to calculate the minimum steady-state short-circuit current
    for generators with compound excitation
    (Section 4.6.1.2 in the IEC 60909-0)
    Used only for single fed short circuit on a generator. (Section 4.3.4.2.
    in the IEC 60909-0)
    '''

    inductiveRating: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum available inductive reactance.
    '''

    inTransitTime: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The transition time from open to close.
    '''

    inverterMode: Optional[ SmartInverterMode ] = field(
        default = None,
        metadata = {
            'type': 'exception',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ipMax: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum allowable peak short-circuit current of busbar (Ipmax in the IEC
    60909-0).
    Mechanical limit of the busbar in the substation itself. Used for short
    circuit data exchange according to IEC 60909
    '''

    length: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Segment length for calculating line section capabilities
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The length to the place where the clamp is located starting from side one
    of the line segment, i.e. the line segment terminal with sequence number
    equal to 1.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The length to the place where the cut is located starting from side one
    of the cut line segment, i.e. the line segment Terminal with sequenceNumber
    equal to 1.
    '''

    maxIFault: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum fault current this device will contribute, in per-unit of rated
    current, before the converter protection will trip or bypass.
    '''

    maxInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum initial symmetrical short-circuit currents (Ik" max) in A (Ik"
    = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according to
    IEC 60909
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum active power on the DC side at which the frequence converter
    should operate.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum active power of the injection.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit for
    the unit.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit for
    the unit.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Not for short circuit modelling; It is used for modelling of infeed for
    load flow exchange. If maxQ and minQ are not used ReactiveCapabilityCurve
    can be used
    '''

    maxU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum voltage on the DC side at which the frequency converter should
    operate.
    '''

    minInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum initial symmetrical short-circuit currents (Ik" min) in A (Ik"
    = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according to
    IEC 60909
    '''

    minP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum active power of the injection.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The minimum active power on the DC side at which the frequence converter
    should operate.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Not for short circuit modelling; It is used for modelling of infeed for
    load flow exchange. If maxQ and minQ are not used ReactiveCapabilityCurve
    can be used
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum reactive power limit for the unit.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum reactive power limit for the unit. This is the minimum (nameplate)
    limit for the unit.
    '''

    minU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The minimum voltage on the DC side at which the frequency converter should
    operate.
    '''

    mode: Optional[ PetersenCoilModeKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The mode of operation of the Petersen coil.
    '''

    nominalFrequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Nameplate data indicates if the machine is 50 or 60 Hz.
    '''

    nominalSpeed: Optional[ float | RotationSpeed ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Nameplate data. Depends on the slip and number of pole pairs.
    '''

    nominalU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The nominal voltage for which the coil is designed.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase-to-phase nominal voltage.
    '''

    nomU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The voltage at which the nominal reactive power may be calculated. This
    should normally be within 10% of the voltage at which the capacitor is
    connected to the network.
    '''

    offsetCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The offset current that the Petersen coil controller is operating from
    the resonant point. This is normally a fixed amount for which the controller
    is configured and could be positive or negative. Typically 0 to 60 Amperes
    depending on voltage and resonance conditions.
    '''

    operatingMode: Optional[ SynchronousMachineOperatingMode ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Current mode of operation.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for steady state solutions.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Active power of the load. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The type of phase connection, such as wye or delta.
    '''

    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The type of phase connection, such as wye or delta.
    '''

    positionCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The control current used to control the Petersen coil also known as the
    position current. Typically in the range of 20-200mA.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for steady state solutions.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactive power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence series resistance of the entire line section.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Nominal resistance of device.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence resistance.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence Thevenin resistance.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence Thevenin resistance.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence resistance.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence series resistance of the entire line section.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum continuous current carrying capacity in amps governed by the
    device material and construction.
    '''

    ratedMechanicalPower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated mechanical power (Pr in the IEC 60909-0). Used for short circuit
    data exchange according to IEC 60909.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
    for short circuit data exchange according to IEC 60909.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
    for short circuit data exchange according to IEC 60909.
    '''

    shortCircuitEndTemperature: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum permitted temperature at the end of SC for the calculation of minimum
    short-circuit currents. Used for short circuit data exchange according
    to IEC 60909
    '''

    slope: Optional[ float | VoltagePerReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The characteristics slope of an SVC defines how the reactive power output
    changes in proportion to the difference between the regulated bus voltage
    and the voltage setpoint.
    '''

    sVCControlMode: Optional[ SVCControlMode ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    SVC control mode.
    '''

    type: Optional[ SynchronousMachineKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Modes that this synchronous machine can operate in.
    '''

    varistorRatedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum current the varistor is designed to handle at specified duration.
    '''

    varistorVoltageThreshold: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The dc voltage at which the varistor start conducting.
    '''

    voltageAngle: Optional[ float | AngleRadians ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase angle of a-phase open circuit.
    '''

    voltageFactor: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Voltage factor in pu, which was used to calculate short-circuit current
    Ik" and power Sk".
    '''

    voltageMagnitude: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase-to-phase open circuit voltage magnitude.
    '''

    voltageSetPoint: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reactive power output of the SVC is proportional to the difference
    between the voltage at the regulated bus and the voltage setpoint. When
    the regulated bus voltage is equal to the voltage setpoint, the reactive
    power output is zero.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence Thevenin reactance.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence series reactance of the entire line section.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactance of device.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence reactance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence reactance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence series reactance of the entire line section.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence Thevenin reactance.
    '''

    xGroundMax: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum reactance.
    '''

    xGroundMin: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The minimum reactance.
    '''

    xGroundNominal: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The nominal reactance. This is the operating point (normally over compensation)
    that is defined based on the resonance point in the healthy network condition.
    The impedance is calculated based on nominal voltage divided by position
    current.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACLineSegment.Clamp',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The line segment to which the clamp is connected.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACLineSegment.Cut',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The line segment to which the cut is applied.
    '''

    ACLineSegmentPhases: list[ACLineSegmentPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ACLineSegmentPhase.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The line segment phases which belong to the line segment.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BaseVoltage.ConductingEquipment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Base voltage of this conducting equipment. Use only when there is no voltage
    level container used and only one base voltage applies. For example, not
    used for transformers.
    '''

    Clamp: list[Clamp] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Clamp.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The clamps connected to the line segment.
    '''

    CompositeSwitch: Optional[CompositeSwitch] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CompositeSwitch.Switches',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Composite switch to which this Switch belongs.
    '''

    Cut: list[Cut] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Cut.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Cuts applied to the line segment.
    '''

    EnergyConsumerPhase: list[EnergyConsumerPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnergyConsumerPhase.EnergyConsumer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The individual phase models for this energy consumer.
    '''

    EnergySourcePhase: list[EnergySourcePhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnergySourcePhase.EnergySource',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The individual phase information of the energy source.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GeneratingUnit.RotatingMachine',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A synchronous machine may operate as a generator and as such becomes a
    member of a generating unit.
    '''

    House: Optional[House] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'House.EnergyConsumer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    HydroPump: Optional[HydroPump] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroPump.RotatingMachine',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The synchronous machine drives the turbine which moves the water from a
    low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''

    IEEE1547ControlSettings: Optional[IEEE1547ControlSettings] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547ControlSettings.PowerElectronicsConnections',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547ControlSettings: Optional[IEEE1547ControlSettings] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547ControlSettings.RotatingMachines',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547Info: Optional[IEEE1547Info] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547Info.PowerElectronicsConnections',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547Info: Optional[IEEE1547Info] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547Info.RotatingMachines',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547Setting: Optional[IEEE1547Setting] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547Setting.RotatingMachines',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547Setting: Optional[IEEE1547Setting] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547Setting.PowerElectronicsConnections',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547TripSettings: Optional[IEEE1547TripSettings] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547TripSettings.PowerElectronicsConnections',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547TripSettings: Optional[IEEE1547TripSettings] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547TripSettings.RotatingMachines',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    InitialReactiveCapabilityCurve: Optional[ReactiveCapabilityCurve] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReactiveCapabilityCurve.InitiallyUsedBySynchronousMachines',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The default reactive capability curve for use by a synchronous machine.
    '''

    LineFaults: list[LineFault] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'LineFault.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The line faults of the line segment.
    '''

    LoadGroup: Optional[NonConformLoadGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NonConformLoadGroup.EnergyConsumers',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Group of this ConformLoad.
    '''

    LoadGroup: Optional[ConformLoadGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConformLoadGroup.EnergyConsumers',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Group of this ConformLoad.
    '''

    LoadResponse: Optional[LoadResponseCharacteristic] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'LoadResponseCharacteristic.EnergyConsumer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The load response characteristic of this load. If missing, this load is
    assumed to be constant power.
    '''

    NonlinearShuntCompensatorPoints: list[NonlinearShuntCompensatorPoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NonlinearShuntCompensatorPoint.NonlinearShuntCompensator',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All points of the non-linear shunt compensator.
    '''

    ParallelLineSegment: Optional[ParallelLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ParallelLineSegment.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PerLengthImpedance.ACLineSegments',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Per-length impedance of this line segment.
    '''

    PowerCutZone: Optional[PowerCutZone] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerCutZone.EnergyConsumers',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The energy consumer is assigned to this power cut zone.
    '''

    PowerElectronicsConnectionPhases: list[PowerElectronicsConnectionPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerElectronicsConnectionPhase.PowerElectronicsConnection',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    PowerElectronicsUnit: list[PowerElectronicsUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerElectronicsUnit.PowerElectronicsConnection',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    PowerTransformerEnd: list[PowerTransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerTransformerEnd.PowerTransformer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The ends of this power transformer.
    '''

    ReactiveCapabilityCurves: list[ReactiveCapabilityCurve] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ReactiveCapabilityCurve.SynchronousMachines',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All available reactive capability curves for this synchronous machine.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RegulatingControl.RegulatingCondEq',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The regulating control scheme in which this equipment participates.
    '''

    ShuntCompensatorPhase: list[ShuntCompensatorPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ShuntCompensatorPhase.ShuntCompensator',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The individual phases models for the shunt compensator.
    '''

    SvShuntCompensatorSections: Optional[SvShuntCompensatorSections] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SvShuntCompensatorSections.ShuntCompensator',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The state for the number of shunt compensator sections in service.
    '''

    SvStatus: list[SvStatus] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SvStatus.ConductingEquipment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The status state variable associated with this conducting equipment.
    '''

    SvSwitch: list[SvSwitch] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SvSwitch.Switch',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The switch state associated with the switch.
    '''

    SwitchPhase: list[SwitchPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SwitchPhase.Switch',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The individual switch phases for the switch.
    '''

    SwitchSchedules: list[SwitchSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SwitchSchedule.Switch',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A Switch can be associated with SwitchSchedules.
    '''

    Terminals: list[Terminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Terminal.ConductingEquipment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Conducting equipment have terminals that may be connected to other conducting
    equipment terminals via connectivity nodes or topological nodes.
    '''

    TransformerTanks: list[TransformerTank] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerTank.PowerTransformer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All transformers that belong to this bank.
    '''

    VoltageControlZone: Optional[VoltageControlZone] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'VoltageControlZone.BusbarSection',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'WireSpacingInfo.ACLineSegments',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class Clamp(ConductingEquipment):
    '''
    A Clamp is a galvanic connection at a line segment where other equipment
    is connected. A Clamp does not cut the line segment.
    A Clamp is ConductingEquipment and has one Terminal with an associated
    ConnectivityNode. Any other ConductingEquipment can be connected to the
    Clamp ConnectivityNode.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The length to the place where the clamp is located starting from side one
    of the line segment, i.e. the line segment terminal with sequence number
    equal to 1.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACLineSegment.Clamp',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The line segment to which the clamp is connected.
    '''

@dataclass(repr=False)
class Conductor(ConductingEquipment):
    '''
    Combination of conducting material with consistent electrical characteristics,
    building a single electrical system, used to carry current between points
    in the power system.
    '''

    length: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Segment length for calculating line section capabilities
    '''

@dataclass(repr=False)
class ACLineSegment(Conductor):
    '''
    A wire or combination of wires, with consistent electrical characteristics,
    building a single electrical system, used to carry alternating current
    between points in the power system.
    For symmetrical, transposed 3ph lines, it is sufficient to use attributes
    of the line segment, which describe impedances and admittances for the
    entire length of the segment. Additionally impedances can be computed by
    using length and associated per length impedances.
    The BaseVoltage at the two ends of ACLineSegments in a Line shall have
    the same BaseVoltage.nominalVoltage. However, boundary lines may have slightly
    different BaseVoltage.nominalVoltages and variation is allowed. Larger
    voltage difference in general requires use of an equivalent branch.
    '''

    b0ch: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence shunt (charging) susceptance, uniformly distributed, of the
    entire line section.
    '''

    bch: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) susceptance, uniformly distributed,
    of the entire line section. This value represents the full charging over
    the full length of the line.
    '''

    g0ch: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence shunt (charging) conductance, uniformly distributed, of the
    entire line section.
    '''

    gch: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) conductance, uniformly distributed,
    of the entire line section.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence series resistance of the entire line section.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence series resistance of the entire line section.
    '''

    shortCircuitEndTemperature: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum permitted temperature at the end of SC for the calculation of minimum
    short-circuit currents. Used for short circuit data exchange according
    to IEC 60909
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence series reactance of the entire line section.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence series reactance of the entire line section.
    '''

    ACLineSegmentPhases: list[ACLineSegmentPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ACLineSegmentPhase.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The line segment phases which belong to the line segment.
    '''

    Clamp: list[Clamp] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Clamp.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The clamps connected to the line segment.
    '''

    Cut: list[Cut] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Cut.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Cuts applied to the line segment.
    '''

    LineFaults: list[LineFault] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'LineFault.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The line faults of the line segment.
    '''

    ParallelLineSegment: Optional[ParallelLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ParallelLineSegment.ACLineSegment',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    PerLengthImpedance: Optional[PerLengthImpedance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PerLengthImpedance.ACLineSegments',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Per-length impedance of this line segment.
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'WireSpacingInfo.ACLineSegments',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class Connector(ConductingEquipment):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation and are
    modelled with a single logical terminal.
    '''

@dataclass(repr=False)
class BusbarSection(Connector):
    '''
    A conductor, or group of conductors, with negligible impedance, that serve
    to connect other conducting equipment within a single substation.
    Voltage measurements are typically obtained from VoltageTransformers that
    are connected to busbar sections. A bus bar section may have many physical
    terminals but for analysis is modelled with exactly one logical terminal.
    '''

    ipMax: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum allowable peak short-circuit current of busbar (Ipmax in the IEC
    60909-0).
    Mechanical limit of the busbar in the substation itself. Used for short
    circuit data exchange according to IEC 60909
    '''

    VoltageControlZone: Optional[VoltageControlZone] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'VoltageControlZone.BusbarSection',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''

@dataclass(repr=False)
class Junction(Connector):
    '''
    A point where one or more conducting equipments are connected with zero
    resistance.
    '''

@dataclass(repr=False)
class EarthFaultCompensator(ConductingEquipment):
    '''
    A conducting equipment used to represent a connection to ground which is
    typically used to compensate earth faults.. An earth fault compensator
    device modeled with a single terminal implies a second terminal solidly
    connected to ground. If two terminals are modeled, the ground is not assumed
    and normal connection rules apply.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Nominal resistance of device.
    '''

@dataclass(repr=False)
class GroundingImpedance(EarthFaultCompensator):
    '''
    A fixed impedance device used for grounding.
    '''

@dataclass(repr=False)
class PetersenCoil(EarthFaultCompensator):
    '''
    A tunable impedance device normally used to offset line charging during
    single line faults in an ungrounded section of network.
    '''

    mode: Optional[ PetersenCoilModeKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The mode of operation of the Petersen coil.
    '''

    nominalU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The nominal voltage for which the coil is designed.
    '''

    offsetCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The offset current that the Petersen coil controller is operating from
    the resonant point. This is normally a fixed amount for which the controller
    is configured and could be positive or negative. Typically 0 to 60 Amperes
    depending on voltage and resonance conditions.
    '''

    positionCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The control current used to control the Petersen coil also known as the
    position current. Typically in the range of 20-200mA.
    '''

    xGroundMax: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum reactance.
    '''

    xGroundMin: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The minimum reactance.
    '''

    xGroundNominal: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The nominal reactance. This is the operating point (normally over compensation)
    that is defined based on the resonance point in the healthy network condition.
    The impedance is calculated based on nominal voltage divided by position
    current.
    '''

@dataclass(repr=False)
class EnergyConnection(ConductingEquipment):
    '''
    '''

@dataclass(repr=False)
class EnergyConsumer(EnergyConnection):
    '''
    Generic user of energy - a point of consumption on the power system model.
    '''

    customerCount: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of individual customers represented by this demand.
    '''

    grounded: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Used for Yn and Zn connections. True if the neutral is solidly grounded.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Active power of the load. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The type of phase connection, such as wye or delta.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactive power of the load. Load sign convention is used, i.e. positive
    sign means flow out from a node.
    For voltage dependent loads the value is at rated voltage.
    Starting value for a steady state solution.
    '''

    EnergyConsumerPhase: list[EnergyConsumerPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnergyConsumerPhase.EnergyConsumer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The individual phase models for this energy consumer.
    '''

    House: Optional[House] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'House.EnergyConsumer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    LoadResponse: Optional[LoadResponseCharacteristic] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'LoadResponseCharacteristic.EnergyConsumer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The load response characteristic of this load. If missing, this load is
    assumed to be constant power.
    '''

    PowerCutZone: Optional[PowerCutZone] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerCutZone.EnergyConsumers',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The energy consumer is assigned to this power cut zone.
    '''

@dataclass(repr=False)
class ConformLoad(EnergyConsumer):
    '''
    ConformLoad represent loads that follow a daily load change pattern where
    the pattern can be used to scale the load with a system load.
    '''

@dataclass(repr=False)
class NonConformLoad(EnergyConsumer):
    '''
    NonConformLoad represent loads that do not follow a daily load change pattern
    and changes are not correlated with the daily load change pattern.
    '''

    LoadGroup: Optional[NonConformLoadGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NonConformLoadGroup.EnergyConsumers',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Group of this ConformLoad.
    '''

@dataclass(repr=False)
class StationSupply(EnergyConsumer):
    '''
    Station supply with load derived from the station output.
    '''

@dataclass(repr=False)
class EnergySource(EnergyConnection):
    '''
    A generic equivalent for an energy supplier on a transmission or distribution
    voltage level.
    '''

    nominalVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase-to-phase nominal voltage.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence Thevenin resistance.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence Thevenin resistance.
    '''

    voltageAngle: Optional[ float | AngleRadians ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase angle of a-phase open circuit.
    '''

    voltageMagnitude: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase-to-phase open circuit voltage magnitude.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence Thevenin reactance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence Thevenin reactance.
    '''

    EnergySourcePhase: list[EnergySourcePhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnergySourcePhase.EnergySource',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The individual phase information of the energy source.
    '''

@dataclass(repr=False)
class RegulatingCondEq(EnergyConnection):
    '''
    A type of conducting equipment that can regulate a quantity (i.e. voltage
    or flow) at a specific point in the network.
    '''

    controlEnabled: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Specifies the regulation status of the equipment. True is regulating, false
    is not regulating.
    '''

    RegulatingControl: Optional[RegulatingControl] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RegulatingControl.RegulatingCondEq',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The regulating control scheme in which this equipment participates.
    '''

@dataclass(repr=False)
class ExternalNetworkInjection(RegulatingCondEq):
    '''
    This class represents external network and it is used for IEC 60909 calculations.
    '''

    ikSecond: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates whether initial symmetrical short-circuit current and power have
    been calculated according to IEC (Ik").
    '''

    maxR0ToX0Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum ratio of zero sequence resistance of Network Feeder to its zero
    sequence reactance (R(0)/X(0) max). Used for short circuit data exchange
    according to IEC 60909
    '''

    maxR1ToX1Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum ratio of positive sequence resistance of Network Feeder to its
    positive sequence reactance (R(1)/X(1) max). Used for short circuit data
    exchange according to IEC 60909
    '''

    maxZ0ToZ1Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) max). Used for short circuit data exchange according to IEC
    60909
    '''

    minR0ToX0Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates whether initial symmetrical short-circuit current and power have
    been calculated according to IEC (Ik"). Used for short circuit data exchange
    according to IEC 6090
    '''

    minR1ToX1Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum ratio of positive sequence resistance of Network Feeder to its
    positive sequence reactance (R(1)/X(1) min). Used for short circuit data
    exchange according to IEC 60909
    '''

    minZ0ToZ1Ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum ratio of zero sequence impedance to its positive sequence impedance
    (Z(0)/Z(1) min). Used for short circuit data exchange according to IEC
    60909
    '''

    referencePriority: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Priority of unit for use as powerflow voltage phase angle reference bus
    selection. 0 = don t care (default) 1 = highest priority. 2 is less than
    1 and so on.
    '''

    governorSCD: Optional[ float | ActivePowerPerFrequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Power Frequency Bias. This is the change in power injection divided by
    the change in frequency and negated. A positive value of the power frequency
    bias provides additional power injection upon a drop in frequency.
    '''

    maxInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum initial symmetrical short-circuit currents (Ik" max) in A (Ik"
    = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according to
    IEC 60909
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum active power of the injection.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Not for short circuit modelling; It is used for modelling of infeed for
    load flow exchange. If maxQ and minQ are not used ReactiveCapabilityCurve
    can be used
    '''

    minInitialSymShCCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum initial symmetrical short-circuit currents (Ik" min) in A (Ik"
    = Sk"/(SQRT(3) Un)). Used for short circuit data exchange according to
    IEC 60909
    '''

    minP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum active power of the injection.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Not for short circuit modelling; It is used for modelling of infeed for
    load flow exchange. If maxQ and minQ are not used ReactiveCapabilityCurve
    can be used
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for steady state solutions.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for steady state solutions.
    '''

    voltageFactor: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Voltage factor in pu, which was used to calculate short-circuit current
    Ik" and power Sk".
    '''

@dataclass(repr=False)
class FrequencyConverter(RegulatingCondEq):
    '''
    A device to convert from one frequency to another (e.g., frequency F1 to
    F2) comprises a pair of FrequencyConverter instances. One converts from
    F1 to DC, the other converts the DC to F2.
    '''

    frequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Frequency on the AC side.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum active power on the DC side at which the frequence converter
    should operate.
    '''

    maxU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum voltage on the DC side at which the frequency converter should
    operate.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The minimum active power on the DC side at which the frequence converter
    should operate.
    '''

    minU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The minimum voltage on the DC side at which the frequency converter should
    operate.
    '''

@dataclass(repr=False)
class PowerElectronicsConnection(RegulatingCondEq):
    '''
    A connection to the AC network for energy production or consumption that
    uses power electronics rather than rotating machines.
    '''

    inverterMode: Optional[ SmartInverterMode ] = field(
        default = None,
        metadata = {
            'type': 'exception',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    maxIFault: Optional[ float | PU ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum fault current this device will contribute, in per-unit of rated
    current, before the converter protection will trip or bypass.
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit for
    the unit.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum reactive power limit for the unit. This is the minimum (nameplate)
    limit for the unit.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
    for short circuit data exchange according to IEC 60909.
    '''

    IEEE1547ControlSettings: Optional[IEEE1547ControlSettings] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547ControlSettings.PowerElectronicsConnections',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547Info: Optional[IEEE1547Info] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547Info.PowerElectronicsConnections',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547Setting: Optional[IEEE1547Setting] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547Setting.PowerElectronicsConnections',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547TripSettings: Optional[IEEE1547TripSettings] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547TripSettings.PowerElectronicsConnections',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    PowerElectronicsConnectionPhases: list[PowerElectronicsConnectionPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerElectronicsConnectionPhase.PowerElectronicsConnection',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    PowerElectronicsUnit: list[PowerElectronicsUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerElectronicsUnit.PowerElectronicsConnection',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class RotatingMachine(RegulatingCondEq):
    '''
    A rotating machine which may be used as a generator or motor.
    '''

    ratedPowerFactor: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Power factor (nameplate data). It is primarily used for short circuit data
    exchange according to IEC 60909.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Nameplate apparent power rating for the unit.
    The attribute shall have a positive value.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated voltage (nameplate data, Ur in IEC 60909-0). It is primarily used
    for short circuit data exchange according to IEC 60909.
    '''

    GeneratingUnit: Optional[GeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GeneratingUnit.RotatingMachine',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A synchronous machine may operate as a generator and as such becomes a
    member of a generating unit.
    '''

    HydroPump: Optional[HydroPump] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroPump.RotatingMachine',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The synchronous machine drives the turbine which moves the water from a
    low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''

    IEEE1547ControlSettings: Optional[IEEE1547ControlSettings] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547ControlSettings.RotatingMachines',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547Info: Optional[IEEE1547Info] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547Info.RotatingMachines',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547Setting: Optional[IEEE1547Setting] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547Setting.RotatingMachines',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    IEEE1547TripSettings: Optional[IEEE1547TripSettings] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IEEE1547TripSettings.RotatingMachines',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class AsynchronousMachine(RotatingMachine):
    '''
    A rotating machine whose shaft rotates asynchronously with the electrical
    field. Also known as an induction machine with no external connection to
    the rotor windings, e.g squirrel-cage induction machine.
    '''

    converterFedDrive: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates whether the machine is a converter fed drive. Used for short
    circuit data exchange according to IEC 60909
    '''

    iaIrRatio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Ratio of locked-rotor current to the rated current of the motor (Ia/Ir).
    Used for short circuit data exchange according to IEC 60909
    '''

    polePairNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of pole pairs of stator. Used for short circuit data exchange according
    to IEC 60909
    '''

    reversible: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates for converter drive motors if the power can be reversible. Used
    for short circuit data exchange according to IEC 60909
    '''

    rxLockedRotorRatio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Locked rotor ratio (R/X). Used for short circuit data exchange according
    to IEC 60909
    '''

    asynchronousMachineType: Optional[ AsynchronousMachineKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates the type of Asynchronous Machine (motor or generator).
    '''

    efficiency: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Efficiency of the asynchronous machine at nominal operation in percent.
    Indicator for converter drive motors. Used for short circuit data exchange
    according to IEC 60909
    '''

    nominalFrequency: Optional[ float | Frequency ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Nameplate data indicates if the machine is 50 or 60 Hz.
    '''

    nominalSpeed: Optional[ float | RotationSpeed ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Nameplate data. Depends on the slip and number of pole pairs.
    '''

    ratedMechanicalPower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated mechanical power (Pr in the IEC 60909-0). Used for short circuit
    data exchange according to IEC 60909.
    '''

@dataclass(repr=False)
class SynchronousMachine(RotatingMachine):
    '''
    An electromechanical device that operates with shaft rotating synchronously
    with the network. It is a single machine operating either as a generator
    or synchronous condenser or pump.
    '''

    ikk: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Steady-state short-circuit current (in A for the profile) of generator
    with compound excitation during 3-phase short circuit.
    - Ikk=0: Generator with no compound excitation.
    - Ikk?0: Generator with compound excitation.
    Ikk is used to calculate the minimum steady-state short-circuit current
    for generators with compound excitation
    (Section 4.6.1.2 in the IEC 60909-0)
    Used only for single fed short circuit on a generator. (Section 4.3.4.2.
    in the IEC 60909-0)
    '''

    maxQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum reactive power limit. This is the maximum (nameplate) limit for
    the unit.
    '''

    minQ: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum reactive power limit for the unit.
    '''

    operatingMode: Optional[ SynchronousMachineOperatingMode ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Current mode of operation.
    '''

    type: Optional[ SynchronousMachineKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Modes that this synchronous machine can operate in.
    '''

    ReactiveCapabilityCurves: list[ReactiveCapabilityCurve] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ReactiveCapabilityCurve.SynchronousMachines',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All available reactive capability curves for this synchronous machine.
    '''

@dataclass(repr=False)
class ShuntCompensator(RegulatingCondEq):
    '''
    A shunt capacitor or reactor or switchable bank of shunt capacitors or
    reactors. A section of a shunt compensator is an individual capacitor or
    reactor. A negative value for reactivePerSection indicates that the compensator
    is a reactor. ShuntCompensator is a single terminal device. Ground is implied.
    '''

    grounded: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Used for Yn and Zn connections. True if the neutral is solidly grounded.
    '''

    maximumSections: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum number of sections that may be switched in.
    '''

    normalSections: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The normal number of sections switched in.
    '''

    sections: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Shunt compensator sections in use.
    Starting value for steady state solution. Non integer values are allowed
    to support continuous variables. The reasons for continuous value are to
    support study cases where no discrete shunt compensators has yet been designed,
    a solutions where a narrow voltage band force the sections to oscillate
    or accommodate for a continuous solution as input.
    '''

    aVRDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Time delay required for the device to be connected or disconnected by automatic
    voltage regulation (AVR).
    '''

    nomU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The voltage at which the nominal reactive power may be calculated. This
    should normally be within 10% of the voltage at which the capacitor is
    connected to the network.
    '''

    phaseConnection: Optional[ PhaseShuntConnectionKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The type of phase connection, such as wye or delta.
    '''

    ShuntCompensatorPhase: list[ShuntCompensatorPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ShuntCompensatorPhase.ShuntCompensator',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The individual phases models for the shunt compensator.
    '''

    SvShuntCompensatorSections: Optional[SvShuntCompensatorSections] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SvShuntCompensatorSections.ShuntCompensator',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The state for the number of shunt compensator sections in service.
    '''

@dataclass(repr=False)
class LinearShuntCompensator(ShuntCompensator):
    '''
    A linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    b0PerSection: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence shunt (charging) susceptance per section
    '''

    bPerSection: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) susceptance per section
    '''

    g0PerSection: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence shunt (charging) conductance per section
    '''

    gPerSection: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) conductance per section
    '''

@dataclass(repr=False)
class NonlinearShuntCompensator(ShuntCompensator):
    '''
    A non linear shunt compensator has bank or section admittance values that
    differs.
    '''

    NonlinearShuntCompensatorPoints: list[NonlinearShuntCompensatorPoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NonlinearShuntCompensatorPoint.NonlinearShuntCompensator',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All points of the non-linear shunt compensator.
    '''

@dataclass(repr=False)
class StaticVarCompensator(RegulatingCondEq):
    '''
    A facility for providing variable and controllable shunt reactive power.
    The SVC typically consists of a stepdown transformer, filter, thyristor-controlled
    reactor, and thyristor-switched capacitor arms.
    The SVC may operate in fixed MVar output mode or in voltage control mode.
    When in voltage control mode, the output of the SVC will be proportional
    to the deviation of voltage at the controlled bus from the voltage setpoint.
    The SVC characteristic slope defines the proportion. If the voltage at
    the controlled bus is equal to the voltage setpoint, the SVC MVar output
    is zero.
    '''

    capacitiveRating: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum available capacitive reactance.
    '''

    inductiveRating: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum available inductive reactance.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow out from a node.
    Starting value for a steady state solution.
    '''

    slope: Optional[ float | VoltagePerReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The characteristics slope of an SVC defines how the reactive power output
    changes in proportion to the difference between the regulated bus voltage
    and the voltage setpoint.
    '''

    sVCControlMode: Optional[ SVCControlMode ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    SVC control mode.
    '''

    voltageSetPoint: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reactive power output of the SVC is proportional to the difference
    between the voltage at the regulated bus and the voltage setpoint. When
    the regulated bus voltage is equal to the voltage setpoint, the reactive
    power output is zero.
    '''

@dataclass(repr=False)
class Ground(ConductingEquipment):
    '''
    A point where the system is grounded used for connecting conducting equipment
    to ground. The power system model can have any number of grounds.
    '''

@dataclass(repr=False)
class PowerTransformer(ConductingEquipment):
    '''
    An electrical device consisting of two or more coupled windings, with or
    without a magnetic core, for introducing mutual coupling between electric
    circuits. Transformers can be used to control voltage and phase shift (active
    power flow).
    A power transformer may be composed of separate transformer tanks that
    need not be identical.
    A power transformer can be modeled with or without tanks and is intended
    for use in both balanced and unbalanced representations. A power transformer
    typically has two terminals, but may have one (grounding), three or more
    terminals.
    The inherited association ConductingEquipment.BaseVoltage should not be
    used. The association from TransformerEnd to BaseVoltage should be used
    instead.
    '''

    vectorGroup: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Vector group of the transformer for protective relaying, e.g., Dyn1. For
    unbalanced transformers, this may not be simply determined from the constituent
    winding connections and phase angle dispacements.
    The vectorGroup string consists of the following components in the order
    listed: high voltage winding connection, mid voltage winding connection
    (for three winding transformers), phase displacement clock number from
    0 to 11, low voltage winding connection
    phase displacement clock number from 0 to 11. The winding connections are
    D (delta), Y (wye), YN (wye with neutral), Z (zigzag), ZN (zigzag with
    neutral), A (auto transformer). Upper case means the high voltage, lower
    case mid or low. The high voltage winding always has clock postion 0 and
    is not included in the vector group string. Some examples: YNy0 (two winding
    wye to wye with no phase displacement), YNd11 (two winding wye to delta
    with 330 degrees phase displacement), YNyn0d5 (three winding transformer
    wye with neutral high voltgage, wye with neutral mid voltgage and no phase
    displacement, delta low voltage with 150 degrees displacement).
    Phase displacement is defined as the angular difference between the phasors
    representing the voltages between the neutral point (real or imaginary)
    and the corresponding terminals of two windings, a positive sequence voltage
    system being applied to the high-voltage terminals, following each other
    in alphabetical sequence if they are lettered, or in numerical sequence
    if they are numbered: the phasors are assumed to rotate in a counter-clockwise
    sense.
    '''

    PowerTransformerEnd: list[PowerTransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerTransformerEnd.PowerTransformer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The ends of this power transformer.
    '''

    TransformerTanks: list[TransformerTank] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerTank.PowerTransformer',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All transformers that belong to this bank.
    '''

@dataclass(repr=False)
class SeriesCompensator(ConductingEquipment):
    '''
    A Series Compensator is a series capacitor or reactor or an AC transmission
    line without charging susceptance. It is a two terminal device.
    '''

    varistorPresent: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Describe if a metal oxide varistor (mov) for over voltage protection is
    configured at the series compensator.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence resistance.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence resistance.
    '''

    varistorRatedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum current the varistor is designed to handle at specified duration.
    '''

    varistorVoltageThreshold: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The dc voltage at which the varistor start conducting.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence reactance.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence reactance.
    '''

@dataclass(repr=False)
class Switch(ConductingEquipment):
    '''
    A generic device designed to close, or open, or both, one or more electric
    circuits. All switches are two terminal devices including grounding switches.
    '''

    normalOpen: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The attribute is used in cases when no Measurement for the status value
    is present. If the Switch has a status measurement the Discrete.normalValue
    is expected to match with the Switch.normalOpen.
    '''

    open: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The attribute tells if the switch is considered open when used as input
    to topology processing.
    '''

    retained: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Branch is retained in a bus branch model. The flow through retained switches
    will normally be calculated in power flow.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum continuous current carrying capacity in amps governed by the
    device material and construction.
    '''

    CompositeSwitch: Optional[CompositeSwitch] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CompositeSwitch.Switches',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Composite switch to which this Switch belongs.
    '''

    SvSwitch: list[SvSwitch] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SvSwitch.Switch',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The switch state associated with the switch.
    '''

    SwitchPhase: list[SwitchPhase] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SwitchPhase.Switch',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The individual switch phases for the switch.
    '''

    SwitchSchedules: list[SwitchSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SwitchSchedule.Switch',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A Switch can be associated with SwitchSchedules.
    '''

@dataclass(repr=False)
class Cut(Switch):
    '''
    A cut separates a line segment into two parts. The cut appears as a switch
    inserted between these two parts and connects them together. As the cut
    is normally open there is no galvanic connection between the two line segment
    parts. But it is possible to close the cut to get galvanic connection.
    The cut terminals are oriented towards the line segment terminals with
    the same sequence number. Hence the cut terminal with sequence number equal
    to 1 is oriented to the line segment's terminal with sequence number equal
    to 1.
    The cut terminals also act as connection points for jumpers and other equipment,
    e.g. a mobile generator. To enable this, connectivity nodes are placed
    at the cut terminals. Once the connectivity nodes are in place any conducting
    equipment can be connected at them.
    '''

    lengthFromTerminal1: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The length to the place where the cut is located starting from side one
    of the cut line segment, i.e. the line segment Terminal with sequenceNumber
    equal to 1.
    '''

    ACLineSegment: Optional[ACLineSegment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ACLineSegment.Cut',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The line segment to which the cut is applied.
    '''

@dataclass(repr=False)
class Disconnector(Switch):
    '''
    A manually operated or motor operated mechanical switching device used
    for changing the connections in a circuit, or for isolating a circuit or
    equipment from a source of power. It is required to open or close circuits
    when negligible current is broken or made.
    '''

@dataclass(repr=False)
class Fuse(Switch):
    '''
    An overcurrent protective device with a circuit opening fusible part that
    is heated and severed by the passage of overcurrent through it. A fuse
    is considered a switching device because it breaks current.
    '''

@dataclass(repr=False)
class GroundDisconnector(Switch):
    '''
    A manually operated or motor operated mechanical switching device used
    for isolating a circuit or equipment from ground.
    '''

@dataclass(repr=False)
class Jumper(Switch):
    '''
    A short section of conductor with negligible impedance which can be manually
    removed and replaced if the circuit is de-energized. Note that zero-impedance
    branches can potentially be modeled by other equipment types.
    '''

@dataclass(repr=False)
class ProtectedSwitch(Switch):
    '''
    A ProtectedSwitch is a switching device that can be operated by ProtectionEquipment.
    '''

    breakingCapacity: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum fault current a breaking device can break safely under prescribed
    conditions of use.
    '''

@dataclass(repr=False)
class Breaker(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal circuit conditions and also making, carrying for
    a specified time, and breaking currents under specified abnormal circuit
    conditions e.g. those of short circuit.
    '''

    inTransitTime: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The transition time from open to close.
    '''

@dataclass(repr=False)
class LoadBreakSwitch(ProtectedSwitch):
    '''
    A mechanical switching device capable of making, carrying, and breaking
    currents under normal operating conditions.
    '''

@dataclass(repr=False)
class Recloser(ProtectedSwitch):
    '''
    Pole-mounted fault interrupter with built-in phase and ground relays, current
    transformer (CT), and supplemental controls.
    '''

@dataclass(repr=False)
class Sectionaliser(Switch):
    '''
    Automatic switch that will lock open to isolate a faulted section. It may,
    or may not, have load breaking capability. Its primary purpose is to provide
    fault sectionalising at locations where the fault current is either too
    high, or too low, for proper coordination of fuses.
    '''

@dataclass(repr=False)
class GeneratingUnit(Equipment):
    '''
    A single or set of synchronous machines for converting mechanical power
    into alternating-current power. For example, individual machines within
    a set may be defined for scheduling purposes while a single control signal
    is derived for the set. In this case there would be a GeneratingUnit for
    each member of the set and an additional GeneratingUnit corresponding to
    the set.
    '''

    maxOperatingP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    This is the maximum operating active power limit the dispatcher can enter
    for this unit.
    '''

    minOperatingP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    This is the minimum operating active power limit the dispatcher can enter
    for this unit.
    '''

    GenUnitOpCostCurves: list[GenUnitOpCostCurve] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'GenUnitOpCostCurve.GeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A generating unit may have one or more cost curves, depending upon fuel
    mixture and fuel cost.
    '''

    GenUnitOpSchedule: Optional[GenUnitOpSchedule] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GenUnitOpSchedule.GeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A generating unit may have an operating schedule, indicating the planned
    operation of the unit.
    '''

    GrossToNetActivePowerCurves: list[GrossToNetActivePowerCurve] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'GrossToNetActivePowerCurve.GeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A generating unit may have a gross active power to net active power curve,
    describing the losses and auxiliary power requirements of the unit.
    '''

    RotatingMachine: list[RotatingMachine] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RotatingMachine.GeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A synchronous machine may operate as a generator and as such becomes a
    member of a generating unit.
    '''

@dataclass(repr=False)
class HydroGeneratingUnit(GeneratingUnit):
    '''
    A generating unit whose prime mover is a hydraulic turbine (e.g., Francis,
    Pelton, Kaplan).
    '''

    energyConversionCapability: Optional[ HydroEnergyConversionKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Energy conversion capability for generating.
    '''

    hydroUnitWaterCost: Optional[ float | CostPerVolume ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The equivalent cost of water that drives the hydro turbine.
    '''

    HydroGeneratingEfficiencyCurves: list[HydroGeneratingEfficiencyCurve] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'HydroGeneratingEfficiencyCurve.HydroGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A hydro generating unit has an efficiency curve.
    '''

    HydroPowerPlant: Optional[HydroPowerPlant] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroPowerPlant.HydroGeneratingUnits',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The hydro generating unit belongs to a hydro power plant.
    '''

    PenstockLossCurve: Optional[PenstockLossCurve] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PenstockLossCurve.HydroGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A hydro generating unit has a penstock loss curve.
    '''

    TailbayLossCurve: list[TailbayLossCurve] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TailbayLossCurve.HydroGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A hydro generating unit has a tailbay loss curve.
    '''

@dataclass(repr=False)
class NuclearGeneratingUnit(GeneratingUnit):
    '''
    A nuclear generating unit.
    '''

@dataclass(repr=False)
class SolarGeneratingUnit(GeneratingUnit):
    '''
    A solar thermal generating unit, connected to the grid by means of a rotating
    machine. This class does not represent photovoltaic (PV) generation.
    '''

@dataclass(repr=False)
class ThermalGeneratingUnit(GeneratingUnit):
    '''
    A generating unit whose prime mover could be a steam turbine, combustion
    turbine, or diesel engine.
    '''

    oMCost: Optional[ float | CostPerHeatUnit ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Operating and maintenance cost for the thermal unit.
    '''

    CAESPlant: Optional[CAESPlant] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CAESPlant.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may be a member of a compressed air energy storage
    plant.
    '''

    CogenerationPlant: Optional[CogenerationPlant] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CogenerationPlant.ThermalGeneratingUnits',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may be a member of a cogeneration plant.
    '''

    CombinedCyclePlant: Optional[CombinedCyclePlant] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CombinedCyclePlant.ThermalGeneratingUnits',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may be a member of a combined cycle plant.
    '''

    EmissionCurves: list[EmissionCurve] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EmissionCurve.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have one or more emission curves.
    '''

    EmmissionAccounts: list[EmissionAccount] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EmissionAccount.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have one or more emission allowance accounts.
    '''

    FossilFuels: list[FossilFuel] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'FossilFuel.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have one or more fossil fuels.
    '''

    FuelAllocationSchedules: list[FuelAllocationSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'FuelAllocationSchedule.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have one or more fuel allocation schedules.
    '''

    HeatInputCurve: Optional[HeatInputCurve] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HeatInputCurve.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have a heat input curve.
    '''

    HeatRateCurve: Optional[HeatRateCurve] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HeatRateCurve.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have a heat rate curve.
    '''

    IncrementalHeatRateCurve: Optional[IncrementalHeatRateCurve] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IncrementalHeatRateCurve.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have an incremental heat rate curve.
    '''

    ShutdownCurve: Optional[ShutdownCurve] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ShutdownCurve.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have a shutdown curve.
    '''

    StartupModel: Optional[StartupModel] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartupModel.ThermalGeneratingUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have a startup model.
    '''

@dataclass(repr=False)
class WindGeneratingUnit(GeneratingUnit):
    '''
    A wind driven generating unit, connected to the grid by means of a rotating
    machine. May be used to represent a single turbine or an aggregation.
    '''

    windGenUnitType: Optional[ WindGenUnitKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The kind of wind generating unit
    '''

@dataclass(repr=False)
class HydroPump(Equipment):
    '''
    A synchronous motor-driven pump, typically associated with a pumped storage
    plant.
    '''

    pumpDischAtMaxHead: Optional[ float | VolumeFlowRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The pumping discharge under maximum head conditions, usually at full gate.
    '''

    pumpDischAtMinHead: Optional[ float | VolumeFlowRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The pumping discharge under minimum head conditions, usually at full gate.
    '''

    pumpPowerAtMaxHead: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The pumping power under maximum head conditions, usually at full gate.
    '''

    pumpPowerAtMinHead: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The pumping power under minimum head conditions, usually at full gate.
    '''

    HydroPowerPlant: Optional[HydroPowerPlant] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroPowerPlant.HydroPumps',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The hydro pump may be a member of a pumped storage plant or a pump for
    distributing water.
    '''

    HydroPumpOpSchedule: Optional[HydroPumpOpSchedule] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'HydroPumpOpSchedule.HydroPump',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The hydro pump has a pumping schedule over time, indicating when pumping
    is to occur.
    '''

    RotatingMachine: Optional[RotatingMachine] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RotatingMachine.HydroPump',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The synchronous machine drives the turbine which moves the water from a
    low elevation to a higher elevation. The direction of machine rotation
    for pumping may or may not be the same as for generating.
    '''

@dataclass(repr=False)
class PowerElectronicsUnit(Equipment):
    '''
    A generating unit or battery or aggregation that connects to the AC network
    using power electronics rather than rotating machines.
    '''

    maxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum active power limit. This is the maximum (nameplate) limit for the
    unit.
    '''

    minP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Minimum active power limit. This is the minimum (nameplate) limit for the
    unit.
    '''

    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerElectronicsConnection.PowerElectronicsUnit',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class BatteryUnit(PowerElectronicsUnit):
    '''
    An electrochemical energy storage device
    '''

    batteryState: Optional[ BatteryState ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    indicates whether the battery is charging, discharging or idle
    '''

    ratedE: Optional[ float | RealEnergy ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    full energy storage capacity of the battery
    '''

    storedE: Optional[ float | RealEnergy ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    amount of energy currently stored; no more than ratedE
    '''

@dataclass(repr=False)
class PhotovoltaicUnit(PowerElectronicsUnit):
    '''
    A photovoltaic device or an aggregation of such devices
    '''

@dataclass(repr=False)
class PowerElectronicsWindUnit(PowerElectronicsUnit):
    '''
    A wind generating unit that connects to the AC network with power electronics
    rather than rotating machines or an aggregation of such units.
    '''

@dataclass(repr=False)
class TransformerTank(Equipment):
    '''
    An assembly of two or more coupled windings that transform electrical power
    between voltage levels. These windings are bound on a common core and place
    in the same tank. Transformer tank can be used to model both single-phase
    and 3-phase transformers.
    '''

    PowerTransformer: Optional[PowerTransformer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerTransformer.TransformerTanks',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Bank this transformer belongs to.
    '''

    TransformerTankEnds: list[TransformerTankEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerTankEnd.TransformerTank',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All windings of this transformer.
    '''

@dataclass(repr=False)
class HydroPowerPlant(PowerSystemResource):
    '''
    A hydro power station which can generate or pump. When generating, the
    generator turbines receive water from an upper reservoir. When pumping,
    the pumps receive their water from a lower reservoir.
    '''

    penstockType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type and configuration of hydro plant penstock(s).
    '''

    surgeTankCode: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A code describing the type (or absence) of surge tank that is associated
    with the hydro power plant.
    '''

    dischargeTravelDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Water travel delay from tailbay to next downstream hydro power station.
    '''

    genRatedP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The hydro plant's generating rating active power for rated head conditions.
    '''

    hydroPlantStorageType: Optional[ HydroPlantStorageKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The type of hydro power plant water storage.
    '''

    plantDischargeCapacity: Optional[ float | VolumeFlowRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Total plant discharge capacity.
    '''

    plantRatedHead: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The plant's rated gross head.
    '''

    pumpRatedP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The hydro plant's pumping rating active power for rated head conditions.
    '''

    surgeTankCrestLevel: Optional[ float | WaterLevel ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The level at which the surge tank spills.
    '''

    GenSourcePumpDischargeReservoir: Optional[Reservoir] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Reservoir.UpstreamFromHydroPowerPlants',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Generators are supplied water from or pumps discharge water to an upstream
    reservoir.
    '''

    HydroGeneratingUnits: list[HydroGeneratingUnit] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'HydroGeneratingUnit.HydroPowerPlant',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The hydro generating unit belongs to a hydro power plant.
    '''

    HydroPumps: list[HydroPump] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'HydroPump.HydroPowerPlant',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The hydro pump may be a member of a pumped storage plant or a pump for
    distributing water.
    '''

    Reservoir: Optional[Reservoir] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Reservoir.HydroPowerPlants',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Generators discharge water to or pumps are supplied water from a downstream
    reservoir.
    '''

@dataclass(repr=False)
class PowerCutZone(PowerSystemResource):
    '''
    An area or zone of the power system which is used for load shedding purposes.
    '''

    cutLevel1: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    First level (amount) of load to cut as a percentage of total zone load.
    '''

    cutLevel2: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Second level (amount) of load to cut as a percentage of total zone load.
    '''

    EnergyConsumers: list[EnergyConsumer] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnergyConsumer.PowerCutZone',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Energy consumer is assigned to the power cut zone.
    '''

@dataclass(repr=False)
class PowerElectronicsConnectionPhase(PowerSystemResource):
    '''
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Active power injection. Load sign convention is used, i.e. positive sign
    means flow into the equipment from the network.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase of this energy producer component. If the energy producer is wye
    connected, the connection is from the indicated phase to the central ground
    or neutral point. If the energy producer is delta connected, the phase
    indicates an energy producer connected from the indicated phase to the
    next logical non-neutral phase.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactive power injection. Load sign convention is used, i.e. positive sign
    means flow into the equipment from the network.
    '''

    PowerElectronicsConnection: Optional[PowerElectronicsConnection] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerElectronicsConnection.PowerElectronicsConnectionPhases',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class RegulatingControl(PowerSystemResource):
    '''
    Specifies a set of equipment that works together to control a power system
    quantity such as voltage or flow.
    Remote bus voltage control is possible by specifying the controlled terminal
    located at some place remote from the controlling equipment.
    In case multiple equipment, possibly of different types, control same terminal
    there must be only one RegulatingControl at that terminal. The most specific
    subtype of RegulatingControl shall be used in case such equipment participate
    in the control, e.g. TapChangerControl for tap changers.
    For flow control load sign convention is used, i.e. positive sign means
    flow out from a TopologicalNode (bus) into the conducting equipment.
    '''

    discrete: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The regulation is performed in a discrete mode. This applies to equipment
    with discrete controls, e.g. tap changers and shunt compensators.
    '''

    enabled: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The flag tells if regulation is enabled.
    '''

    targetDeadband: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    This is a deadband used with discrete control to avoid excessive update
    of controls like tap changers and shunt compensator banks while regulating.
    The units of those appropriate for the mode.
    '''

    targetValue: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The target value specified for case input. This value can be used for the
    target value without the use of schedules. The value has the units appropriate
    to the mode attribute.
    '''

    mode: Optional[ RegulatingControlModeKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The regulating control mode presently available. This specification allows
    for determining the kind of regulation without need for obtaining the units
    from a schedule.
    '''

    monitoredPhase: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase voltage controlling this regulator, measured at regulator location.
    '''

    RegulatingCondEq: list[RegulatingCondEq] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RegulatingCondEq.RegulatingControl',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The equipment that participates in this regulating control scheme.
    '''

    RegulationSchedule: list[RegulationSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RegulationSchedule.RegulatingControl',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Schedule for this Regulating regulating control.
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.RegulatingControl',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The terminal associated with this regulating control. The terminal is associated
    instead of a node, since the terminal could connect into either a topological
    node (bus in bus-branch model) or a connectivity node (detailed switch
    model). Sometimes it is useful to model regulation at a terminal of a bus
    bar object since the bus bar can be present in both a bus-branch model
    or a model with switch detail.
    '''

@dataclass(repr=False)
class TapChangerControl(RegulatingControl):
    '''
    Describes behavior specific to tap changers, e.g. how the voltage at the
    end of a line varies with the load level and compensation of the voltage
    drop by tap adjustment.
    '''

    lineDropCompensation: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, the line drop compensation is to be applied.
    '''

    limitVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Maximum allowed regulated voltage on the PT secondary, regardless of line
    drop compensation. Sometimes referred to as first-house protection.
    '''

    lineDropR: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Line drop compensator resistance setting for normal (forward) power flow.
    '''

    lineDropX: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Line drop compensator reactance setting for normal (forward) power flow.
    '''

    reverseLineDropR: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Line drop compensator resistance setting for reverse power flow.
    '''

    reverseLineDropX: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Line drop compensator reactance setting for reverse power flow.
    '''

    TapChanger: list[TapChanger] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TapChanger.TapChangerControl',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The tap changers that participates in this regulating tap control scheme.
    '''

@dataclass(repr=False)
class Reservoir(PowerSystemResource):
    '''
    A water storage facility within a hydro system, including: ponds, lakes,
    lagoons, and rivers. The storage is usually behind some type of dam.
    '''

    energyStorageRating: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reservoir's energy storage rating in energy for given head conditions.
    '''

    riverOutletWorks: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    River outlet works for riparian right releases or other purposes.
    '''

    spillwayCapacity: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The flow capacity of the spillway in cubic meters per second.
    '''

    spillWayGateType: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of spillway gate, including parameters.
    '''

    activeStorageCapacity: Optional[ float | Volume ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Storage volume between the full supply level and the normal minimum operating
    level.
    '''

    fullSupplyLevel: Optional[ float | WaterLevel ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Full supply level, above which water will spill. This can be the spillway
    crest level or the top of closed gates.
    '''

    grossCapacity: Optional[ float | Volume ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Total capacity of reservoir.
    '''

    normalMinOperateLevel: Optional[ float | WaterLevel ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal minimum operating level below which the penstocks will draw air.
    '''

    spillTravelDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The spillway water travel delay to the next downstream reservoir.
    '''

    spillwayCrestLength: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The length of the spillway crest.
    '''

    spillwayCrestLevel: Optional[ float | WaterLevel ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Spillway crest level above which water will spill.
    '''

    HydroPowerPlants: list[HydroPowerPlant] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'HydroPowerPlant.Reservoir',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Generators discharge water to or pumps are supplied water from a downstream
    reservoir.
    '''

    InflowForecasts: list[InflowForecast] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'InflowForecast.Reservoir',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A reservoir may have a "natural" inflow forecast.
    '''

    LevelVsVolumeCurves: list[LevelVsVolumeCurve] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'LevelVsVolumeCurve.Reservoir',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A reservoir may have a level versus volume relationship.
    '''

    SpillsFromReservoir: Optional[Reservoir] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Reservoir.SpillsIntoReservoirs',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A reservoir may spill into a downstream reservoir.
    '''

    SpillsIntoReservoirs: list[Reservoir] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Reservoir.SpillsFromReservoir',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A reservoir may spill into a downstream reservoir.
    '''

    TargetLevelSchedule: Optional[TargetLevelSchedule] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TargetLevelSchedule.Reservoir',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A reservoir may have a water level target schedule.
    '''

    UpstreamFromHydroPowerPlants: list[HydroPowerPlant] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'HydroPowerPlant.GenSourcePumpDischargeReservoir',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Generators are supplied water from or pumps discharge water to an upstream
    reservoir.
    '''

@dataclass(repr=False)
class ShuntCompensatorPhase(PowerSystemResource):
    '''
    Single phase of a multi-phase shunt compensator when its attributes might
    be different per phase.
    '''

    maximumSections: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The maximum number of sections that may be switched in for this phase.
    '''

    normalSections: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    For the capacitor phase, the normal number of sections switched in.
    '''

    sections: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of sections in use for this phase, when controlled independently
    from the other phases. If not provided, may default to the parent ShuntCompensator.sections
    value (see ShuntCompensator documentation for more details).
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase of this shunt compensator component. If the shunt compensator is
    wye connected, the connection is from the indicated phase to the central
    ground or neutral point. If the shunt compensator is delta connected, the
    phase indicates a shunt compensator connected from the indicated phase
    to the next logical non-neutral phase.
    '''

    ShuntCompensator: Optional[ShuntCompensator] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ShuntCompensator.ShuntCompensatorPhase',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Shunt compensator of this shunt compensator phase.
    '''

@dataclass(repr=False)
class LinearShuntCompensatorPhase(ShuntCompensatorPhase):
    '''
    A per phase linear shunt compensator has banks or sections with equal admittance
    values.
    '''

    bPerSection: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Susceptance per section of the phase if shunt compensator is wye connected.
    Susceptance per section phase to phase if shunt compensator is delta connected.
    '''

    gPerSection: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Conductance per section for this phase if shunt compensator is wye connected.
    Conductance per section phase to phase if shunt compensator is delta connected.
    '''

@dataclass(repr=False)
class NonlinearShuntCompensatorPhase(ShuntCompensatorPhase):
    '''
    A per phase non linear shunt compensator has bank or section admittance
    values that differs.
    '''

    NonlinearShuntCompensatorPhasePoints: list[NonlinearShuntCompensatorPhasePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NonlinearShuntCompensatorPhasePoint.NonlinearShuntCompensatorPhase',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All points of the non-linear shunt compensator phase.
    '''

@dataclass(repr=False)
class SwitchPhase(PowerSystemResource):
    '''
    Single phase of a multi-phase switch when its attributes might be different
    per phase.
    '''

    closed: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The attribute tells if the switch is considered closed when used as input
    to topology processing.
    '''

    normalOpen: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Used in cases when no Measurement for the status value is present. If the
    SwitchPhase has a status measurement the Discrete.normalValue is expected
    to match with this value.
    '''

    phaseSide1: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase of this SwitchPhase on the side with terminal sequence number equal
    1. Should be a phase contained in that terminal&rsquo;s phases attribute.
    '''

    phaseSide2: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase of this SwitchPhase on the side with terminal sequence number equal
    2. Should be a phase contained in that terminal&rsquo;s Terminal.phases
    attribute.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated current through this phase, if different from the others.
    '''

    Switch: Optional[Switch] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Switch.SwitchPhase',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The switch of the switch phase.
    '''

@dataclass(repr=False)
class TapChanger(PowerSystemResource):
    '''
    Mechanism for changing transformer winding tap positions.
    '''

    controlEnabled: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Specifies the regulation status of the equipment. True is regulating, false
    is not regulating.
    '''

    highStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Highest possible tap step position, advance from neutral.
    The attribute shall be greater than lowStep.
    '''

    lowStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Lowest possible tap step position, retard from neutral
    '''

    ltcFlag: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Specifies whether or not a TapChanger has load tap changing capabilities.
    '''

    neutralStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The neutral tap step position for this winding.
    The attribute shall be equal or greater than lowStep and equal or less
    than highStep.
    '''

    normalStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The tap step position used in "normal" network operation for this winding.
    For a "Fixed" tap changer indicates the current physical tap setting.
    The attribute shall be equal or greater than lowStep and equal or less
    than highStep.
    '''

    step: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Tap changer position.
    Starting step for a steady state solution. Non integer values are allowed
    to support continuous tap variables. The reasons for continuous value are
    to support study cases where no discrete tap changers has yet been designed,
    a solutions where a narrow voltage band force the tap step to oscillate
    or accommodate for a continuous solution as input.
    The attribute shall be equal or greater than lowStep and equal or less
    than highStep.
    '''

    initialDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    For an LTC, the delay for initial tap changer operation (first step change)
    '''

    neutralU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Voltage at which the winding operates at the neutral tap setting.
    '''

    subsequentDelay: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    For an LTC, the delay for subsequent tap changer operation (second and
    later step changes)
    '''

    SvTapStep: Optional[SvTapStep] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'SvTapStep.TapChanger',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The tap step state associated with the tap changer.
    '''

    TapChangerControl: Optional[TapChangerControl] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TapChangerControl.TapChanger',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The regulating control scheme in which this tap changer participates.
    '''

    TapSchedules: list[TapSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TapSchedule.TapChanger',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A TapChanger can have TapSchedules.
    '''

@dataclass(repr=False)
class PhaseTapChanger(TapChanger):
    '''
    A transformer phase shifting tap model that controls the phase angle difference
    across the power transformer and potentially the active power flow through
    the power transformer. This phase tap model may also impact the voltage
    magnitude.
    '''

    TransformerEnd: Optional[TransformerEnd] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEnd.PhaseTapChanger',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Transformer end to which this phase tap changer belongs.
    '''

@dataclass(repr=False)
class PhaseTapChangerLinear(PhaseTapChanger):
    '''
    Describes a tap changer with a linear relation between the tap step and
    the phase angle difference across the transformer. This is a mathematical
    model that is an approximation of a real phase tap changer.
    The phase angle is computed as stepPhaseShitfIncrement times the tap position.
    The secondary side voltage magnitude is the same as at the primary side.
    '''

    stepPhaseShiftIncrement: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase shift per step position. A positive value indicates a positive phase
    shift from the winding where the tap is located to the other winding (for
    a two-winding transformer).
    The actual phase shift increment might be more accurately computed from
    the symmetrical or asymmetrical models or a tap step table lookup if those
    are available.
    '''

    xMax: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reactance depend on the tap position according to a "u" shaped curve.
    The maximum reactance (xMax) appear at the low and high tap positions.
    '''

    xMin: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reactance depend on the tap position according to a "u" shaped curve.
    The minimum reactance (xMin) appear at the mid tap position.
    '''

@dataclass(repr=False)
class PhaseTapChangerNonLinear(PhaseTapChanger):
    '''
    The non-linear phase tap changer describes the non-linear behavior of a
    phase tap changer. This is a base class for the symmetrical and asymmetrical
    phase tap changer models. The details of these models can be found in the
    IEC 61970-301 document.
    '''

    voltageStepIncrement: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The voltage step increment on the out of phase winding specified in percent
    of neutral voltage of the tap changer.
    When the increment is negative, the voltage decreases when the tap step
    increases.
    '''

    xMax: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reactance depend on the tap position according to a "u" shaped curve.
    The maximum reactance (xMax) appear at the low and high tap positions.
    '''

    xMin: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reactance depend on the tap position according to a "u" shaped curve.
    The minimum reactance (xMin) appear at the mid tap position.
    '''

@dataclass(repr=False)
class PhaseTapChangerAsymmetrical(PhaseTapChangerNonLinear):
    '''
    Describes the tap model for an asymmetrical phase shifting transformer
    in which the difference voltage vector adds to the primary side voltage.
    The angle between the primary side voltage and the difference voltage is
    named the winding connection angle. The phase shift depends on both the
    difference voltage magnitude and the winding connection angle.
    '''

    windingConnectionAngle: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The phase angle between the in-phase winding and the out-of -phase winding
    used for creating phase shift. The out-of-phase winding produces what is
    known as the difference voltage. Setting this angle to 90 degrees is not
    the same as a symmetrical transformer.
    '''

@dataclass(repr=False)
class PhaseTapChangerSymmetrical(PhaseTapChangerNonLinear):
    '''
    Describes a symmetrical phase shifting transformer tap model in which the
    secondary side voltage magnitude is the same as at the primary side. The
    difference voltage magnitude is the base in an equal-sided triangle where
    the sides corresponds to the primary and secondary voltages. The phase
    angle difference corresponds to the top angle and can be expressed as twice
    the arctangent of half the total difference voltage.
    '''

@dataclass(repr=False)
class PhaseTapChangerTabular(PhaseTapChanger):
    '''
    '''

    PhaseTapChangerTable: Optional[PhaseTapChangerTable] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PhaseTapChangerTable.PhaseTapChangerTabular',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The phase tap changer table for this phase tap changer.
    '''

@dataclass(repr=False)
class RatioTapChanger(TapChanger):
    '''
    A tap changer that changes the voltage ratio impacting the voltage magnitude
    but not the phase angle across the transformer.
    '''

    stepVoltageIncrement: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Tap step increment, in per cent of neutral voltage, per step position.
    When the increment is negative, the voltage decreases when the tap step
    increases.
    '''

    RatioTapChangerTable: Optional[RatioTapChangerTable] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RatioTapChangerTable.RatioTapChanger',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The tap ratio table for this ratio tap changer.
    '''

    TransformerEnd: Optional[TransformerEnd] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEnd.RatioTapChanger',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Transformer end to which this ratio tap changer belongs.
    '''

@dataclass(repr=False)
class VoltageControlZone(PowerSystemResource):
    '''
    An area of the power system network which is defined for secondary voltage
    control purposes. A voltage control zone consists of a collection of substations
    with a designated bus bar section whose voltage will be controlled.
    '''

    BusbarSection: Optional[BusbarSection] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BusbarSection.VoltageControlZone',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A VoltageControlZone is controlled by a designated BusbarSection.
    '''

    RegulationSchedule: Optional[RegulationSchedule] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RegulationSchedule.VoltageControlZones',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A VoltageControlZone may have a voltage regulation schedule.
    '''

@dataclass(repr=False)
class ProductAssetModel(IdentifiedObject):
    '''
    Asset model by a specific manufacturer.
    '''

    catalogueNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Catalogue number for asset model.
    '''

    drawingNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Drawing number for asset model.
    '''

    instructionManual: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reference manual or instruction book for this asset model.
    '''

    modelNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Manufacturer's model number.
    '''

    modelVersion: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Version number for product model, which indicates vintage of the product.
    '''

    styleNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Style number of asset model.
    '''

    corporateStandardKind: Optional[ CorporateStandardKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of corporate standard for this asset model.
    '''

    overallLength: Optional[ float | Length ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Overall length of this asset model.
    '''

    usageKind: Optional[ AssetModelUsageKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Intended usage for this asset model.
    '''

    weightTotal: Optional[ Mass ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Total manufactured weight of asset.
    '''

    Asset: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.ProductAssetModel',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    An asset of this model.
    '''

    AssetInfo: Optional[AssetInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetInfo.ProductAssetModel',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    CatalogAssetType: Optional[CatalogAssetType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CatalogAssetType.ProductAssetModel',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Manufacturer: Optional[Manufacturer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Manufacturer.ProductAssetModels',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Manufacturer of this asset model.
    '''

@dataclass(repr=False)
class RatioTapChangerTable(IdentifiedObject):
    '''
    Describes a curve for how the voltage magnitude and impedance varies with
    the tap step.
    '''

    RatioTapChanger: list[RatioTapChanger] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RatioTapChanger.RatioTapChangerTable',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The ratio tap changer of this tap ratio table.
    '''

    RatioTapChangerTablePoint: list[RatioTapChangerTablePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RatioTapChangerTablePoint.RatioTapChangerTable',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Points of this table.
    '''

@dataclass(repr=False)
class ReadingType(IdentifiedObject):
    '''
    Detailed description for a type of a reading value. Values in attributes
    allow for the creation of recommended codes to be used for identifying
    reading value types as follows: &lt;macroPeriod&gt;.&lt;aggregate&gt;.&lt;measuringPeriod&gt;.&lt;accumulation&gt;.&lt;flowDirection&gt;.&lt;commodity&gt;.&lt;measurementKind&gt;.&lt;interharmonic.numerator&gt;.&lt;interharmonic.denominator&gt;.&lt;argument.numerator&gt;.&lt;argument.denominator&gt;.&lt;tou&gt;.&lt;cpp&gt;.&lt;consumptionTier&gt;.&lt;phases&gt;.&lt;multiplier&gt;.&lt;unit&gt;.&lt;currency&gt;.
    '''

    consumptionTier: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    In case of common flat-rate pricing for power, in which all purchases are
    at a given rate, 'consumptionTier'=0. Otherwise, the value indicates the
    consumption tier, which can be used in conjunction with TOU or CPP pricing.
    Consumption tier pricing refers to the method of billing in which a certain
    "block" of energy is purchased/sold at one price, after which the next
    block of energy is purchased at another price, and so on, all throughout
    a defined period. At the start of the defined period, consumption is initially
    zero, and any usage is measured against the first consumption tier ('consumptionTier'=1).
    If this block of energy is consumed before the end of the period, energy
    consumption moves to be reconed against the second consumption tier ('consumptionTier'=2),
    and so on. At the end of the defined period, the consumption accumulator
    is reset, and usage within the 'consumptionTier'=1 restarts.
    '''

    cpp: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Critical peak period (CPP) bucket the reading value is attributed to. Value
    0 means not applicable. Even though CPP is usually considered a specialised
    form of time of use 'tou', this attribute is defined explicitly for flexibility.
    '''

    tou: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Time of use (TOU) bucket the reading value is attributed to. Value 0 means
    not applicable.
    '''

    accumulation: Optional[ AccumulationKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Accumulation behaviour of a reading over time, usually 'measuringPeriod',
    to be used with individual endpoints (as opposed to 'macroPeriod' and 'aggregate'
    that are used to describe aggregations of data from individual endpoints).
    '''

    aggregate: Optional[ AggregateKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Salient attribute of the reading data aggregated from individual endpoints.
    This is mainly used to define a mathematical operation carried out over
    'macroPeriod', but may also be used to describe an attribute of the data
    when the 'macroPeriod' is not defined.
    '''

    commodity: Optional[ CommodityKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Commodity being measured.
    '''

    currency: Optional[ Currency ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Metering-specific currency.
    '''

    flowDirection: Optional[ FlowDirectionKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Flow direction for a reading where the direction of flow of the commodity
    is important (for electricity measurements this includes current, energy,
    power, and demand).
    '''

    macroPeriod: Optional[ MacroPeriodKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Time period of interest that reflects how the reading is viewed or captured
    over a long period of time.
    '''

    measurementKind: Optional[ MeasurementKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Identifies "what" is being measured, as refinement of 'commodity'. When
    combined with 'unit', it provides detail to the unit of measure. For example,
    'energy' with a unit of measure of 'kWh' indicates to the user that active
    energy is being measured, while with 'kVAh' or 'kVArh', it indicates apparent
    energy and reactive energy, respectively. 'power' can be combined in a
    similar way with various power units of measure: Distortion power ('distortionVoltAmperes')
    with 'kVA' is different from 'power' with 'kVA'.
    '''

    measuringPeriod: Optional[ MeasuringPeriodKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Time attribute inherent or fundamental to the reading value (as opposed
    to 'macroPeriod' that supplies an "adjective" to describe aspects of a
    time period with regard to the measurement). It refers to the way the value
    was originally measured and not to the frequency at which it is reported
    or presented. For example, an hourly interval of consumption data would
    have value 'hourly' as an attribute. However in the case of an hourly sampled
    voltage value, the meterReadings schema would carry the 'hourly' interval
    size information.
    It is common for meters to report demand in a form that is measured over
    the course of a portion of an hour, while enterprise applications however
    commonly assume the demand (in kW or kVAr) normalised to 1 hour. The system
    that receives readings directly from the meter therefore shall perform
    this transformation before publishing readings for use by the other enterprise
    systems. The scalar used is chosen based on the block size (not any sub-interval
    size).
    '''

    multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Metering-specific multiplier.
    '''

    phases: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Metering-specific phase code.
    '''

    unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Metering-specific unit.
    '''

    argument: Optional[RationalNumber] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Argument used to introduce numbers into the unit of measure description
    where they are needed (e.g., 4 where the measure needs an argument such
    as CEMI(n=4)). Most arguments used in practice however will be integers
    (i.e., 'denominator'=1).
    Value 0 in 'numerator' and 'denominator' means not applicable.
    '''

    Channel: Optional[Channel] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Channel.ReadingType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Channel reporting/collecting register values with this type information.
    '''

    interharmonic: Optional[ReadingInterharmonic] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indication of a "harmonic" or "interharmonic" basis for the measurement.
    Value 0 in 'numerator' and 'denominator' means not applicable.
    '''

    IntervalBlocks: list[IntervalBlock] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'IntervalBlock.ReadingType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All blocks containing interval reading values with this type information.
    '''

    MetrologyRequirements: list[MetrologyRequirement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MetrologyRequirement.ReadingTypes',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All metrology requirements that require this reading type to be collected.
    '''

    PendingCalculation: Optional[PendingCalculation] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PendingCalculation.ReadingType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Pending calculation that produced this reading type.
    '''

    Readings: list[Reading] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Reading.ReadingType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All reading values with this type information.
    '''

@dataclass(repr=False)
class Register(IdentifiedObject):
    '''
    A device that indicates or records units of the commodity or other quantity
    measured.
    '''

@dataclass(repr=False)
class ReportingGroup(IdentifiedObject):
    '''
    A reporting group is used for various ad-hoc groupings used for reporting.
    '''

    BusNameMarker: list[BusNameMarker] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'BusNameMarker.ReportingGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The bus name markers that belong to this reporting group.
    '''

    PowerSystemResource: list[PowerSystemResource] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PowerSystemResource.ReportingGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Power system resources which belong to this reporting group.
    '''

    ReportingSuperGroup: Optional[ReportingSuperGroup] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReportingSuperGroup.ReportingGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reporting super group to which this reporting group belongs.
    '''

    TopologicalNode: list[TopologicalNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TopologicalNode.ReportingGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The topological nodes that belong to the reporting group.
    '''

@dataclass(repr=False)
class ReportingSuperGroup(IdentifiedObject):
    '''
    A reporting super group, groups reporting groups for a higher level report.
    '''

    ReportingGroup: list[ReportingGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ReportingGroup.ReportingSuperGroup',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reporting groups that are grouped under this super group.
    '''

@dataclass(repr=False)
class RightOfWay(IdentifiedObject):
    '''
    '''

    ParallelLineSegments: list[ParallelLineSegment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ParallelLineSegment.RightOfWay',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class ScheduledEvent(IdentifiedObject):
    '''
    An event to trigger one or more activities, such as reading a meter, recalculating
    a bill, requesting work, when generating units must be scheduled for maintenance,
    when a transformer is scheduled to be refurbished, etc.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of scheduled event.
    '''

    duration: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Duration of the scheduled event, for example, the time to ramp between
    values.
    '''

    Assets: list[Asset] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Asset.ScheduledEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    ScheduledEventData: Optional[ScheduledEventData] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ScheduledEventData.ScheduledEvents',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Specification for this scheduled event.
    '''

    status: Optional[Status] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class Seal(IdentifiedObject):
    '''
    Physically controls access to AssetContainers.
    '''

    appliedDateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time this seal has been applied.
    '''

    sealNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (reserved word) Seal number.
    '''

    condition: Optional[ SealConditionKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Condition of seal.
    '''

    kind: Optional[ SealKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of seal.
    '''

    AssetContainer: Optional[AssetContainer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'AssetContainer.Seals',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Asset container to which this seal is applied.
    '''

@dataclass(repr=False)
class Season(IdentifiedObject):
    '''
    A specified time period of the year.
    '''

    endDate: Optional[ MonthDay ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date season ends.
    '''

    startDate: Optional[ MonthDay ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date season starts.
    '''

    SeasonDayTypeSchedules: list[SeasonDayTypeSchedule] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SeasonDayTypeSchedule.Season',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Schedules that use this Season.
    '''

@dataclass(repr=False)
class ServiceCategory(IdentifiedObject):
    '''
    Category of service provided to the customer.
    '''

    kind: Optional[ ServiceKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of service.
    '''

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConfigurationEvent.ChangedServiceCategory',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All configuration events created for this service category.
    '''

    CustomerAgreements: list[CustomerAgreement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CustomerAgreement.ServiceCategory',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All customer agreements with this service category.
    '''

    PricingStructures: list[PricingStructure] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PricingStructure.ServiceCategory',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All pricing structures applicable to this service category.
    '''

    UsagePoints: list[UsagePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UsagePoint.ServiceCategory',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All usage points that deliver this category of service.
    '''

@dataclass(repr=False)
class ServiceMultiplier(IdentifiedObject):
    '''
    Multiplier applied at the usage point.
    '''

    value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Multiplier value.
    '''

    kind: Optional[ ServiceMultiplierKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of multiplier.
    '''

    UsagePoint: Optional[UsagePoint] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'UsagePoint.ServiceMultipliers',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Usage point applying this multiplier.
    '''

@dataclass(repr=False)
class StartupModel(IdentifiedObject):
    '''
    Unit start up characteristics depending on how long the unit has been off
    line.
    '''

    startupDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The date and time of the most recent generating unit startup.
    '''

    startupPriority: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Startup priority within control area where lower numbers indicate higher
    priorities. More than one unit in an area may be assigned the same priority.
    '''

    fixedMaintCost: Optional[ float | CostRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Fixed maintenance cost.
    '''

    hotStandbyHeat: Optional[ float | HeatRate ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The amount of heat input per time uint required for hot standby operation.
    '''

    incrementalMaintCost: Optional[ float | CostPerEnergyUnit ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Incremental maintenance cost.
    '''

    minimumDownTime: Optional[ float | Hours ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The minimum number of hours the unit must be down before restart.
    '''

    minimumRunTime: Optional[ float | Hours ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The minimum number of hours the unit must be operating before being allowed
    to shut down.
    '''

    riskFactorCost: Optional[ Money ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The opportunity cost associated with the return in monetary unit. This
    represents the restart's "share" of the unit depreciation and risk of an
    event which would damage the unit.
    '''

    startupCost: Optional[ Money ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Total miscellaneous start up costs.
    '''

    stbyAuxP: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The unit's auxiliary active power consumption to maintain standby mode.
    '''

    StartIgnFuelCurve: Optional[StartIgnFuelCurve] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartIgnFuelCurve.StartupModel',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The unit's startup model may have a startup ignition fuel curve.
    '''

    StartMainFuelCurve: Optional[StartMainFuelCurve] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartMainFuelCurve.StartupModel',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The unit's startup model may have a startup main fuel curve.
    '''

    StartRampCurve: Optional[StartRampCurve] = field(
        default = None,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'StartRampCurve.StartupModel',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The unit's startup model may have a startup ramp curve.
    '''

    ThermalGeneratingUnit: Optional[ThermalGeneratingUnit] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ThermalGeneratingUnit.StartupModel',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A thermal generating unit may have a startup model.
    '''

@dataclass(repr=False)
class SubGeographicalRegion(IdentifiedObject):
    '''
    A subset of a geographical region of a power system network model.
    '''

    Lines: list[Line] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Line.Region',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The lines within the sub-geographical region.
    '''

    Region: Optional[GeographicalRegion] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'GeographicalRegion.Regions',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The geographical region to which this sub-geographical region is within.
    '''

    Substations: list[Substation] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Substation.Region',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The substations in this sub-geographical region.
    '''

@dataclass(repr=False)
class SwitchOperationSummary(IdentifiedObject):
    '''
    Up-to-date, of-record summary of switch operation information, distilled
    from a variety of sources (real-time data or real-time data historian,
    field inspections, etc.) of use to asset health analytics.
    '''

    lifetimeFaultOperations: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Total breaker fault operations to date.
    '''

    lifetimeMotorStarts: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Total motor starts to date.
    '''

    lifetimeTotalOperations: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Total breaker operations to date (including fault and non-fault).
    '''

    mostRecentFaultOperationDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date of most recent breaker fault operation.
    '''

    mostRecentMotorStartDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date of most recent motor start.
    '''

    mostRecentOperationDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date of most recent breaker operation (fault or non-fault).
    '''

    Breaker: Optional[Asset] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Asset.BreakerOperation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Breaker asset to which this operation information applies.
    '''

@dataclass(repr=False)
class ThermostatController(IdentifiedObject):
    '''
    a price-responsive or bidding smart thermostat
    '''

    aggregatorName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    name of a market aggregator that collects bid curves for a higher-level
    market
    '''

    rampHigh: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    slope of high-temperature bidding curve, $/degreeC
    '''

    rampLow: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    slope of low-temperature bidding curve, $/degreeC
    '''

    useOverride: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    usePredictive: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    baseSetpoint: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    user's desired thermostat setpoint, including the effects of pre-programmed
    schedule
    '''

    controlMode: Optional[ ThermostatControlMode ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    priceCap: Optional[ Money ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    maximum price per kwh that the controller will bid, regardless of the market's
    price cap
    '''

    rangeHigh: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    maximum postive offset to the thermostat setpoint
    '''

    rangeLow: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    maximum negative offset to the thermostat setpoint
    '''

    House: Optional[House] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'House.ThermostatController',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class TopologicalIsland(IdentifiedObject):
    '''
    An electrically connected subset of the network. Topological islands can
    change as the current network state changes: e.g. due to
    - disconnect switches or breakers change state in a SCADA/EMS
    - manual creation, change or deletion of topological nodes in a planning
    tool.
    '''

    AngleRefTopologicalNode: Optional[TopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalNode.AngleRefTopologicalIsland',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The angle reference for the island. Normally there is one TopologicalNode
    that is selected as the angle reference for each island. Other reference
    schemes exist, so the association is typically optional.
    '''

    TopologicalNodes: list[TopologicalNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TopologicalNode.TopologicalIsland',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A topological node belongs to a topological island.
    '''

@dataclass(repr=False)
class TopologicalNode(IdentifiedObject):
    '''
    For a detailed substation model a topological node is a set of connectivity
    nodes that, in the current network state, are connected together through
    any type of closed switches, including jumpers. Topological nodes change
    as the current network state changes (i.e., switches, breakers, etc. change
    state).
    For a planning model, switch statuses are not used to form topological
    nodes. Instead they are manually created or deleted in a model builder
    tool. Topological nodes maintained this way are also called "busses".
    '''

    pInjection: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The active power injected into the bus at this location in addition to
    injections from equipment. Positive sign means injection into the TopologicalNode
    (bus).
    Starting value for a steady state solution.
    '''

    qInjection: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reactive power injected into the bus at this location in addition to
    injections from equipment. Positive sign means injection into the TopologicalNode
    (bus).
    Starting value for a steady state solution.
    '''

    AngleRefTopologicalIsland: Optional[TopologicalIsland] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalIsland.AngleRefTopologicalNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The island for which the node is an angle reference. Normally there is
    one angle reference node for each island.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BaseVoltage.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The base voltage of the topologocial node.
    '''

    BusNameMarker: list[BusNameMarker] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'BusNameMarker.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    BusnameMarkers that may refer to a pre defined TopologicalNode.
    '''

    ConnectivityNodeContainer: Optional[ConnectivityNodeContainer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConnectivityNodeContainer.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The connectivity node container to which the toplogical node belongs.
    '''

    ConnectivityNodes: list[ConnectivityNode] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConnectivityNode.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The connectivity nodes combine together to form this topological node.
    May depend on the current state of switches in the network.
    '''

    ReportingGroup: Optional[ReportingGroup] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReportingGroup.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reporting group to which the topological node belongs.
    '''

    SvInjection: list[SvInjection] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SvInjection.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The injection flows state variables associated with the topological node.
    '''

    SvVoltage: list[SvVoltage] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'SvVoltage.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The state voltage associated with the topological node.
    '''

    Terminal: list[Terminal] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Terminal.TopologicalNode',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The terminals associated with the topological node. This can be used as
    an alternative to the connectivity node path to terminal, thus making it
    unneccesary to model connectivity nodes in some cases. Note that if connectivity
    nodes are in the model, this association would probably not be used as
    an input specification.
    '''

    TopologicalIsland: Optional[TopologicalIsland] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalIsland.TopologicalNodes',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A topological node belongs to a topological island.
    '''

@dataclass(repr=False)
class TransformerCoreAdmittance(IdentifiedObject):
    '''
    The transformer core admittance. Used to specify the core admittance of
    a transformer in a manner that can be shared among power transformers.
    '''

    b: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Magnetizing branch susceptance (B mag). The value can be positive or negative.
    '''

    b0: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence magnetizing branch susceptance.
    '''

    g: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Magnetizing branch conductance (G mag).
    '''

    g0: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence magnetizing branch conductance.
    '''

    TransformerEnd: list[TransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEnd.CoreAdmittance',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All transformer ends having this core admittance.
    '''

    TransformerEndInfo: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.CoreAdmittance',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Transformer end datasheet used to calculate this core admittance.
    '''

@dataclass(repr=False)
class TransformerEnd(IdentifiedObject):
    '''
    A conducting connection point of a power transformer. It corresponds to
    a physical transformer winding terminal. In earlier CIM versions, the TransformerWinding
    class served a similar purpose, but this class is more flexible because
    it associates to terminal but is not a specialization of ConductingEquipment.
    '''

    endNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number for this transformer end, corresponding to the end's order in the
    power transformer vector group or phase angle clock number. Highest voltage
    winding should be 1. Each end within a power transformer should have a
    unique subsequent end number. Note the transformer end number need not
    match the terminal sequence number.
    '''

    grounded: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (for Yn and Zn connections) True if the neutral is solidly grounded.
    '''

    rground: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (for Yn and Zn connections) Resistance part of neutral impedance where
    'grounded' is true.
    '''

    xground: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (for Yn and Zn connections) Reactive part of neutral impedance where 'grounded'
    is true.
    '''

    BaseVoltage: Optional[BaseVoltage] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'BaseVoltage.TransformerEnds',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Base voltage of the transformer end. This is essential for PU calculation.
    '''

    CoreAdmittance: Optional[TransformerCoreAdmittance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerCoreAdmittance.TransformerEnd',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Core admittance of this transformer end, representing magnetising current
    and core losses. The full values of the transformer should be supplied
    for one transformer end only.
    '''

    FromMeshImpedance: list[TransformerMeshImpedance] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerMeshImpedance.FromTransformerEnd',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All mesh impedances between this 'to' and other 'from' transformer ends.
    '''

    PhaseTapChanger: Optional[PhaseTapChanger] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PhaseTapChanger.TransformerEnd',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase tap changer associated with this transformer end.
    '''

    RatioTapChanger: Optional[RatioTapChanger] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RatioTapChanger.TransformerEnd',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Ratio tap changer associated with this transformer end.
    '''

    StarImpedance: Optional[TransformerStarImpedance] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerStarImpedance.TransformerEnd',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (accurate for 2- or 3-winding transformers only) Pi-model impedances of
    this transformer end. By convention, for a two winding transformer, the
    full values of the transformer should be entered on the high voltage end
    (endNumber=1).
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.TransformerEnd',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Terminal of the power transformer to which this transformer end belongs.
    '''

    ToMeshImpedance: list[TransformerMeshImpedance] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerMeshImpedance.ToTransformerEnd',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All mesh impedances between this 'from' and other 'to' transformer ends.
    '''

@dataclass(repr=False)
class PowerTransformerEnd(TransformerEnd):
    '''
    A PowerTransformerEnd is associated with each Terminal of a PowerTransformer.
    The impedance values r, r0, x, and x0 of a PowerTransformerEnd represents
    a star equivalent as follows
    1) for a two Terminal PowerTransformer the high voltage (TransformerEnd.endNumber=1)
    PowerTransformerEnd has non zero values on r, r0, x, and x0 while the low
    voltage (TransformerEnd.endNumber=0) PowerTransformerEnd has zero values
    for r, r0, x, and x0.
    2) for a three Terminal PowerTransformer the three PowerTransformerEnds
    represents a star equivalent with each leg in the star represented by r,
    r0, x, and x0 values.
    3) For a three Terminal transformer each PowerTransformerEnd shall have
    g, g0, b and b0 values corresponding the no load losses distributed on
    the three PowerTransformerEnds. The total no load loss shunt impedances
    may also be placed at one of the PowerTransformerEnds, preferably the end
    numbered 1, having the shunt values on end 1 is the preferred way.
    4) for a PowerTransformer with more than three Terminals the PowerTransformerEnd
    impedance values cannot be used. Instead use the TransformerMeshImpedance
    or split the transformer into multiple PowerTransformers.
    '''

    phaseAngleClock: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Terminal voltage phase angle displacement where 360 degrees are represented
    with clock hours. The valid values are 0 to 11. For example, for the secondary
    side end of a transformer with vector group code of 'Dyn11', specify the
    connection kind as wye with neutral and specify the phase angle of the
    clock as 11. The clock value of the transformer end number specified as
    1, is assumed to be zero. Note the transformer end number is not assumed
    to be the same as the terminal sequence number.
    '''

    connectionKind: Optional[ WindingConnection ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of connection.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Resistance (star-model) of the transformer end.
    The attribute shall be equal or greater than zero for non-equivalent transformers.
    '''

    ratedS: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Normal apparent power rating.
    The attribute shall be a positive value. For a two-winding transformer
    the values for the high and low voltage sides shall be identical.
    '''

    ratedU: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Rated voltage: phase-phase for three-phase windings, and either phase-phase
    or phase-neutral for single-phase windings.
    A high voltage side, as given by TransformerEnd.endNumber, shall have a
    ratedU that is greater or equal than ratedU for the lower voltage sides.
    '''

    PowerTransformer: Optional[PowerTransformer] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerTransformer.PowerTransformerEnd',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The power transformer of this power transformer end.
    '''

@dataclass(repr=False)
class TransformerTankEnd(TransformerEnd):
    '''
    Transformer tank end represents an individual winding for unbalanced models
    or for transformer tanks connected into a bank (and bank is modelled with
    the PowerTransformer).
    '''

    phases: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Describes the phases carried by a conducting equipment.
    '''

    TransformerTank: Optional[TransformerTank] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerTank.TransformerTankEnds',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Transformer this winding belongs to.
    '''

@dataclass(repr=False)
class TransformerMeshImpedance(IdentifiedObject):
    '''
    Transformer mesh impedance (Delta-model) between transformer ends.
    The typical case is that this class describes the impedance between two
    transformer ends pair-wise, i.e. the cardinalities at both tranformer end
    associations are 1. But in cases where two or more transformer ends are
    modeled the cardinalities are larger than 1.
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Resistance between the 'from' and the 'to' end, seen from the 'from' end.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero-sequence resistance between the 'from' and the 'to' end, seen from
    the 'from' end.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reactance between the 'from' and the 'to' end, seen from the 'from' end.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero-sequence reactance between the 'from' and the 'to' end, seen from
    the 'from' end.
    '''

    FromTransformerEnd: Optional[TransformerEnd] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEnd.FromMeshImpedance',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    From end this mesh impedance is connected to. It determines the voltage
    reference.
    '''

    FromTransformerEndInfo: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.FromMeshImpedances',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    'from' transformer end datasheet this mesh impedance is calculated from.
    It determines the voltage reference.
    '''

    ToTransformerEnd: list[TransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEnd.ToMeshImpedance',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All transformer ends this mesh impedance is connected to.
    '''

    ToTransformerEndInfos: list[TransformerEndInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEndInfo.ToMeshImpedances',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All 'to' transformer end datasheets this mesh impedance for 'from' transformer
    end is calculated from.
    '''

@dataclass(repr=False)
class TransformerStarImpedance(IdentifiedObject):
    '''
    Transformer star impedance (Pi-model) that accurately reflects impedance
    for transformers with 2 or 3 windings. For transformers with 4 or more
    windings, you must use TransformerMeshImpedance class.
    For transmission networks use PowerTransformerEnd impedances (r, r0, x,
    x0, b, b0, g and g0).
    '''

    r: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Resistance of the transformer end.
    '''

    r0: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence series resistance of the transformer end.
    '''

    x: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence series reactance of the transformer end.
    '''

    x0: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence series reactance of the transformer end.
    '''

    TransformerEnd: list[TransformerEnd] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEnd.StarImpedance',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All transformer ends having this star impedance.
    '''

    TransformerEndInfo: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.TransformerStarImpedance',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Transformer end datasheet used to calculate this transformer star impedance.
    '''

@dataclass(repr=False)
class TransformerTest(IdentifiedObject):
    '''
    Test result for transformer ends, such as short-circuit, open-circuit (excitation)
    or no-load test.
    '''

    basePower: Optional[ float | ApparentPower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Base power at which the tests are conducted, usually equal to the rateds
    of one of the involved transformer ends.
    '''

    temperature: Optional[ float | Temperature ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Temperature at which the test is conducted.
    '''

@dataclass(repr=False)
class NoLoadTest(TransformerTest):
    '''
    No-load test results determine core admittance parameters. They include
    exciting current and core loss measurements from applying voltage to one
    winding. The excitation may be positive sequence or zero sequence. The
    test may be repeated at different voltages to measure saturation.
    '''

    energisedEndVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Voltage applied to the winding (end) during test.
    '''

    excitingCurrent: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Exciting current measured from a positive-sequence or single-phase excitation
    test.
    '''

    excitingCurrentZero: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Exciting current measured from a zero-sequence open-circuit excitation
    test.
    '''

    loss: Optional[ float | KiloActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Losses measured from a positive-sequence or single-phase excitation test.
    '''

    lossZero: Optional[ float | KiloActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Losses measured from a zero-sequence excitation test.
    '''

    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.EnergisedEndNoLoadTests',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Transformer end that current is applied to in this no-load test.
    '''

@dataclass(repr=False)
class OpenCircuitTest(TransformerTest):
    '''
    Open-circuit test results verify winding turn ratios and phase shifts.
    They include induced voltage and phase shift measurements on open-circuit
    windings, with voltage applied to the energised end. For three-phase windings,
    the excitation can be a positive sequence (the default) or a zero sequence.
    '''

    energisedEndStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Tap step number for the energised end of the test pair.
    '''

    openEndStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Tap step number for the open end of the test pair.
    '''

    energisedEndVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Voltage applied to the winding (end) during test.
    '''

    openEndVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Voltage measured at the open-circuited end, with the energised end set
    to rated voltage and all other ends open.
    '''

    phaseShift: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase shift measured at the open end with the energised end set to rated
    voltage and all other ends open.
    '''

    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.EnergisedEndOpenCircuitTests',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Transformer end that current is applied to in this open-circuit test.
    '''

    OpenEnd: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.OpenEndOpenCircuitTests',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Transformer end measured for induced voltage and angle in this open-circuit
    test.
    '''

@dataclass(repr=False)
class ShortCircuitTest(TransformerTest):
    '''
    Short-circuit test results determine mesh impedance parameters. They include
    load losses and leakage impedances. For three-phase windings, the excitation
    can be a positive sequence (the default) or a zero sequence. There shall
    be at least one grounded winding.
    '''

    energisedEndStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Tap step number for the energised end of the test pair.
    '''

    groundedEndStep: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Tap step number for the grounded end of the test pair.
    '''

    leakageImpedance: Optional[ float | Impedance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Leakage impedance measured from a positive-sequence or single-phase short-circuit
    test.
    '''

    leakageImpedanceZero: Optional[ float | Impedance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Leakage impedance measured from a zero-sequence short-circuit test.
    '''

    loss: Optional[ float | KiloActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Load losses from a positive-sequence or single-phase short-circuit test.
    '''

    lossZero: Optional[ float | KiloActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Load losses from a zero-sequence short-circuit test.
    '''

    EnergisedEnd: Optional[TransformerEndInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TransformerEndInfo.EnergisedEndShortCircuitTests',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Transformer end that voltage is applied to in this short-circuit test.
    The test voltage is chosen to induce rated current in the energised end.
    '''

    GroundedEnds: list[TransformerEndInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TransformerEndInfo.GroundedEndShortCircuitTests',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All ends short-circuited in this short-circuit test.
    '''

@dataclass(repr=False)
class UsagePoint(IdentifiedObject):
    '''
    Logical or physical point in the network to which readings or events may
    be attributed. Used at the place where a physical or virtual meter may
    be located; however, it is not required that a meter be present.
    '''

    checkBilling: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if as a result of an inspection or otherwise, there is a reason to
    suspect that a previous billing may have been performed with erroneous
    data. Value should be reset once this potential discrepancy has been resolved.
    '''

    grounded: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if grounded.
    '''

    isSdp: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, this usage point is a service delivery point, i.e., a usage point
    where the ownership of the service changes hands.
    '''

    isVirtual: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, this usage point is virtual, i.e., no physical location exists
    in the network where a meter could be located to collect the meter readings.
    For example, one may define a virtual usage point to serve as an aggregation
    of usage for all of a company's premises distributed widely across the
    distribution territory. Otherwise, the usage point is physical, i.e., there
    is a logical point in the network where a meter could be located to collect
    meter readings.
    '''

    minimalUsageExpected: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If true, minimal or zero usage is expected at this usage point for situations
    such as premises vacancy, logical or physical disconnect. It is used for
    readings validation and estimation.
    '''

    outageRegion: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Outage region in which this usage point is located.
    '''

    readCycle: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Cycle day on which the meter for this usage point will normally be read.
    Usually correlated with the billing cycle.
    '''

    readRoute: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Identifier of the route to which this usage point is assigned for purposes
    of meter reading. Typically used to configure hand held meter reading systems
    prior to collection of reads.
    '''

    serviceDeliveryRemark: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Remarks about this usage point, for example the reason for it being rated
    with a non-nominal priority.
    '''

    servicePriority: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Priority of service for this usage point. Note that usage points at the
    same service location can have different priorities.
    '''

    amiBillingReady: Optional[ AmiBillingReadyKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Tracks the lifecycle of the metering installation at a usage point with
    respect to readiness for billing via advanced metering infrastructure reads.
    '''

    connectionState: Optional[ UsagePointConnectedKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    State of the usage point with respect to connection to the network.
    '''

    estimatedLoad: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Estimated load.
    '''

    nominalServiceVoltage: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Nominal service voltage.
    '''

    phaseCode: Optional[ PhaseCode ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phase code. Number of wires and specific nominal phases can be deduced
    from enumeration literal values. For example, ABCN is three-phase, four-wire,
    s12n (splitSecondary12N) is single-phase, three-wire, and s1n and s2n are
    single-phase, two-wire.
    '''

    ratedCurrent: Optional[ float | CurrentFlow ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Current flow that this usage point is configured to deliver.
    '''

    ratedPower: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Active power that this usage point is configured to deliver.
    '''

    ConfigurationEvents: list[ConfigurationEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ConfigurationEvent.ChangedUsagePoint',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All configuration events created for this usage point.
    '''

    CustomerAgreement: Optional[CustomerAgreement] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'CustomerAgreement.UsagePoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Customer agreement regulating this service delivery point.
    '''

    EndDeviceControls: list[EndDeviceControl] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceControl.UsagePoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end device controls sending commands to this usage point.
    '''

    EndDeviceEvents: list[EndDeviceEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceEvent.UsagePoint',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end device events reported for this usage point.
    '''

    EndDevices: list[EndDevice] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDevice.UsagePoint',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end devices at this usage point.
    '''

    Equipments: list[Equipment] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Equipment.UsagePoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All equipment connecting this usage point to the electrical grid.
    '''

    MeterReadings: list[MeterReading] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeterReading.UsagePoint',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All meter readings obtained from this usage point.
    '''

    MeterServiceWorkTasks: list[MeterWorkTask] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MeterWorkTask.UsagePoint',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All meter service work tasks at this usage point.
    '''

    MetrologyRequirements: list[MetrologyRequirement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'MetrologyRequirement.UsagePoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All metrology requirements for this usage point.
    '''

    PricingStructures: list[PricingStructure] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'PricingStructure.UsagePoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All pricing structures applicable to this service delivery point (with
    prepayment meter running as a stand-alone device, with no CustomerAgreement
    or Customer).
    '''

    ServiceCategory: Optional[ServiceCategory] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ServiceCategory.UsagePoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Service category delivered by this usage point.
    '''

    ServiceLocation: Optional[ServiceLocation] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ServiceLocation.UsagePoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Service location where the service delivered by this usage point is consumed.
    '''

    ServiceMultipliers: list[ServiceMultiplier] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ServiceMultiplier.UsagePoint',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All multipliers applied at this usage point.
    '''

    UsagePointGroups: list[UsagePointGroup] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UsagePointGroup.UsagePoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All groups to which this usage point belongs.
    '''

    UsagePointLocation: Optional[UsagePointLocation] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'UsagePointLocation.UsagePoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Location of this usage point.
    '''

@dataclass(repr=False)
class UsagePointGroup(IdentifiedObject):
    '''
    Abstraction for management of group communications within a two-way AMR
    system or the data for a group of related usage points. Commands can be
    issued to all of the usage points that belong to a usage point group using
    a defined group address and the underlying AMR communication infrastructure.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of this group.
    '''

    DemandResponsePrograms: list[DemandResponseProgram] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'DemandResponseProgram.UsagePointGroups',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All demand response programs this usage point group is enrolled in.
    '''

    EndDeviceControls: list[EndDeviceControl] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDeviceControl.UsagePointGroups',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end device controls sending commands to this usage point group.
    '''

    UsagePoints: list[UsagePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UsagePoint.UsagePointGroups',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All usage points in this group.
    '''

@dataclass(repr=False)
class ValueAliasSet(IdentifiedObject):
    '''
    Describes the translation of a set of values into a name and is intendend
    to facilitate cusom translations. Each ValueAliasSet has a name, description
    etc. A specific Measurement may represent a discrete state like Open, Closed,
    Intermediate etc. This requires a translation from the MeasurementValue.value
    number to a string, e.g. 0-&gt;"Invalid", 1-&gt;"Open", 2-&gt;"Closed",
    3-&gt;"Intermediate". Each ValueToAlias member in ValueAliasSet.Value describe
    a mapping for one particular value to a name.
    '''

    Commands: list[Command] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Command.ValueAliasSet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The Commands using the set for translation.
    '''

    Discretes: list[Discrete] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Discrete.ValueAliasSet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The Measurements using the set for translation.
    '''

    RaiseLowerCommands: list[RaiseLowerCommand] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'RaiseLowerCommand.ValueAliasSet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The Commands using the set for translation.
    '''

    Values: list[ValueToAlias] = field(
        default_factory = list,
        metadata = {
            'type': 'Aggregate Of',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ValueToAlias.ValueAliasSet',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The ValueToAlias mappings included in the set.
    '''

@dataclass(repr=False)
class ValueToAlias(IdentifiedObject):
    '''
    Describes the translation of one particular value into a name, e.g. 1 as
    "Open".
    '''

    value: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The value that is mapped.
    '''

    ValueAliasSet: Optional[ValueAliasSet] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ValueAliasSet.Values',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The ValueAliasSet having the ValueToAlias mappings.
    '''

@dataclass(repr=False)
class WirePosition(IdentifiedObject):
    '''
    Identification, spacing and configuration of the wires of a conductor with
    respect to a structure.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Numbering for wires on a WireSpacingInfo. Neutrals should be numbered last.
    Multiple circuits on the same pole, tower or right-of-way can be included
    with unique sequence numbers for the phases, and identical sequence numbers
    for any shared neutrals.
    '''

    xCoord: Optional[ float | Displacement ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Signed horizontal distance from the wire at this position to a common reference
    point.
    '''

    yCoord: Optional[ float | Displacement ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Signed vertical distance from the wire at this position: above ground (positive
    value) or burial depth below ground (negative value).
    '''

    WirePhaseInfo: list[WirePhaseInfo] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'WirePhaseInfo.WirePosition',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    WireSpacingInfo: Optional[WireSpacingInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'WireSpacingInfo.WirePositions',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Wire spacing data this wire position belongs to.
    '''

@dataclass(repr=False)
class IntervalBlock(Identity):
    '''
    Time sequence of readings of the same reading type. Contained interval
    readings may need conversion through the application of an offset and a
    scalar defined in associated pending.
    '''

    IntervalReadings: list[IntervalReading] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'IntervalReading.IntervalBlocks',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Interval reading contained in this block.
    '''

    MeterReading: Optional[MeterReading] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'MeterReading.IntervalBlocks',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Meter reading containing this interval block.
    '''

    PendingCalculation: Optional[PendingCalculation] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PendingCalculation.IntervalBlocks',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Pending calculation to apply to interval reading values contained by this
    block (after which the resulting reading type is different than the original
    because it reflects the conversion result).
    '''

    ReadingType: Optional[ReadingType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReadingType.IntervalBlocks',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type information for interval reading values contained in this block.
    '''

@dataclass(repr=False)
class IrregularTimePoint(Identity):
    '''
    TimePoints for a schedule where the time between the points varies.
    '''

    value1: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The first value at the time. The meaning of the value is defined by the
    derived type of the associated schedule.
    '''

    value2: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The second value at the time. The meaning of the value is defined by the
    derived type of the associated schedule.
    '''

    time: Optional[ float | Seconds ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The time is relative to the schedule starting time.
    '''

    IntervalSchedule: Optional[IrregularIntervalSchedule] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IrregularIntervalSchedule.TimePoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    An IrregularTimePoint belongs to an IrregularIntervalSchedule.
    '''

@dataclass(repr=False)
class MeterWorkTask(Identity):
    '''
    Work task involving meters.
    '''

    Meter: Optional[Meter] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Meter.MeterServiceWorkTask',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Meter on which this non-replacement work task is performed.
    '''

    OldMeter: Optional[Meter] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Meter.MeterReplacementWorkTasks',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Old meter replaced by this work task.
    '''

    UsagePoint: Optional[UsagePoint] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'UsagePoint.MeterServiceWorkTasks',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Usage point to which this meter service work task applies.
    '''

@dataclass(repr=False)
class Name(Identity):
    '''
    The Name class provides the means to define any number of human readable
    names for an object. A name is <b>not</b> to be used for defining inter-object
    relationships. For inter-object relationships instead use the object identification
    'mRID'.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Any free text that name the object.
    '''

    IdentifiedObject: Optional[IdentifiedObject] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'IdentifiedObject.Names',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Identified object that this name designates.
    '''

    NameType: Optional[NameType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NameType.Names',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of this name.
    '''

@dataclass(repr=False)
class NameType(Identity):
    '''
    Type of name. Possible values for attribute 'name' are implementation dependent
    but standard profiles may specify types. An enterprise may have multiple
    IT systems each having its own local name for the same object, e.g. a planning
    system may have different names from an EMS. An object may also have different
    names within the same IT system, e.g. localName as defined in CIM version
    14. The definition from CIM14 is:
    The localName is a human readable name of the object. It is a free text
    name local to a node in a naming hierarchy similar to a file directory
    structure. A power system related naming hierarchy may be: Substation,
    VoltageLevel, Equipment etc. Children of the same parent in such a hierarchy
    have names that typically are unique among them.
    '''

    description: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Description of the name type.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Name of the name type.
    '''

    Names: list[Name] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'Name.NameType',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All names of this type.
    '''

    NameTypeAuthority: Optional[NameTypeAuthority] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NameTypeAuthority.NameTypes',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Authority responsible for managing names of this type.
    '''

@dataclass(repr=False)
class NameTypeAuthority(Identity):
    '''
    Authority responsible for creation and management of names of a given type;
    typically an organization or an enterprise system.
    '''

    description: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Description of the name type authority.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Name of the name type authority.
    '''

    NameTypes: list[NameType] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'NameType.NameTypeAuthority',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All name types managed by this authority.
    '''

@dataclass(repr=False)
class NonlinearShuntCompensatorPhasePoint(Identity):
    '''
    A per phase non linear shunt compensator bank or section admittance value.
    '''

    sectionNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The number of the section.
    '''

    b: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) susceptance per section
    '''

    g: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) conductance per section
    '''

    NonlinearShuntCompensatorPhase: Optional[NonlinearShuntCompensatorPhase] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NonlinearShuntCompensatorPhase.NonlinearShuntCompensatorPhasePoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Non-linear shunt compensator phase owning this point.
    '''

@dataclass(repr=False)
class NonlinearShuntCompensatorPoint(Identity):
    '''
    A non linear shunt compensator bank or section admittance value.
    '''

    sectionNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The number of the section.
    '''

    b: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) susceptance per section
    '''

    b0: Optional[ float | Susceptance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence shunt (charging) susceptance per section
    '''

    g: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Positive sequence shunt (charging) conductance per section
    '''

    g0: Optional[ float | Conductance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero sequence shunt (charging) conductance per section
    '''

    NonlinearShuntCompensator: Optional[NonlinearShuntCompensator] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'NonlinearShuntCompensator.NonlinearShuntCompensatorPoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Non-linear shunt compensator owning this point.
    '''

@dataclass(repr=False)
class OperatingShare(Identity):
    '''
    Specifies the operations contract relationship between a power system resource
    and a contract participant.
    '''

    percentage: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Percentage operational ownership between the pair (power system resource
    and operatging participant) associated with this share. The total percentage
    ownership for a power system resource should add to 100%.
    '''

    OperatingParticipant: Optional[OperatingParticipant] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'OperatingParticipant.OperatingShare',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The operating participant having this share with the associated power system
    resource.
    '''

    PowerSystemResource: Optional[PowerSystemResource] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PowerSystemResource.OperatingShare',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The power system resource to which the share applies.
    '''

@dataclass(repr=False)
class PendingCalculation(Identity):
    '''
    When present, a scalar conversion that needs to be applied to every IntervalReading.value
    contained in IntervalBlock. This conversion results in a new associated
    ReadingType, reflecting the true dimensions of IntervalReading values after
    the conversion.
    '''

    multiplyBeforeAdd: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Whether scalars should be applied before adding the 'offset'.
    '''

    offset: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Offset to be added as well as multiplication using scalars.
    '''

    scalarDenominator: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if scalar is rational number) When 'IntervalReading.value' is multiplied
    by 'scalarNumerator' and divided by this value, it causes a unit of measure
    conversion to occur, resulting in the 'ReadingType.unit'.
    '''

    scalarFloat: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if scalar is floating number) When multiplied with 'IntervalReading.value',
    it causes a unit of measure conversion to occur, according to the 'ReadingType.unit'.
    '''

    scalarNumerator: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if scalar is integer or rational number) When the scalar is a simple integer,
    and this attribute is presented alone and multiplied with 'IntervalReading.value',
    it causes a unit of measure conversion to occur, resulting in the 'ReadingType.unit'.
    It is never used in conjunction with 'scalarFloat', only with 'scalarDenominator'.
    '''

    IntervalBlocks: list[IntervalBlock] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'IntervalBlock.PendingCalculation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All blocks of interval reading values to which this pending conversion
    applies.
    '''

    ReadingType: Optional[ReadingType] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ReadingType.PendingCalculation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reading type resulting from this pending conversion.
    '''

@dataclass(repr=False)
class PositionPoint(Identity):
    '''
    Set of spatial coordinates that determine a point, defined in the coordinate
    system specified in 'Location.CoordinateSystem'. Use a single position
    point instance to desribe a point-oriented location. Use a sequence of
    position points to describe a line-oriented object (physical location of
    non-point oriented objects like cables or lines), or area of an object
    (like a substation or a geographical zone - in this case, have first and
    last position point with the same values).
    '''

    groupNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero-relative sequence number of this group within a series of points;
    used when there is a need to express disjoint groups of points that are
    considered to be part of a single location.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Zero-relative sequence number of this point within a series of points.
    '''

    xPosition: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    X axis position.
    '''

    yPosition: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Y axis position.
    '''

    zPosition: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Z axis position.
    '''

    Location: Optional[Location] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Location.PositionPoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Location described by this position point.
    '''

@dataclass(repr=False)
class Quality61850(Identity):
    '''
    Quality flags in this class are as defined in IEC 61850, except for estimatorReplaced,
    which has been included in this class for convenience.
    '''

    badReference: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Measurement value may be incorrect due to a reference being out of calibration.
    '''

    estimatorReplaced: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Value has been replaced by State Estimator. estimatorReplaced is not an
    IEC61850 quality bit but has been put in this class for convenience.
    '''

    failure: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    This identifier indicates that a supervision function has detected an internal
    or external failure, e.g. communication failure.
    '''

    oldData: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Measurement value is old and possibly invalid, as it has not been successfully
    updated during a specified time interval.
    '''

    operatorBlocked: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Measurement value is blocked and hence unavailable for transmission.
    '''

    oscillatory: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    To prevent some overload of the communication it is sensible to detect
    and suppress oscillating (fast changing) binary inputs. If a signal changes
    in a defined time (tosc) twice in the same direction (from 0 to 1 or from
    1 to 0) then oscillation is detected and the detail quality identifier
    "oscillatory" is set. If it is detected a configured numbers of transient
    changes could be passed by. In this time the validity status "questionable"
    is set. If after this defined numbers of changes the signal is still in
    the oscillating state the value shall be set either to the opposite state
    of the previous stable value or to a defined default value. In this case
    the validity status "questionable" is reset and "invalid" is set as long
    as the signal is oscillating. If it is configured such that no transient
    changes should be passed by then the validity status "invalid" is set immediately
    in addition to the detail quality identifier "oscillatory" (used for status
    information only).
    '''

    outOfRange: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Measurement value is beyond a predefined range of value.
    '''

    overFlow: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Measurement value is beyond the capability of being represented properly.
    For example, a counter value overflows from maximum count back to a value
    of zero.
    '''

    suspect: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A correlation function has detected that the value is not consitent with
    other values. Typically set by a network State Estimator.
    '''

    test: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Measurement value is transmitted for test purposes.
    '''

    source: Optional[ Source ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Source gives information related to the origin of a value. The value may
    be acquired from the process, defaulted or substituted.
    '''

    validity: Optional[ Validity ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Validity of the measurement value.
    '''

@dataclass(repr=False)
class MeasurementValueQuality(Quality61850):
    '''
    Measurement quality flags. Bits 0-10 are defined for substation automation
    in draft IEC 61850 part 7-3. Bits 11-15 are reserved for future expansion
    by that document. Bits 16-31 are reserved for EMS applications.
    '''

    MeasurementValue: Optional[MeasurementValue] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'MeasurementValue.MeasurementValueQuality',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    A MeasurementValue has a MeasurementValueQuality associated with it.
    '''

@dataclass(repr=False)
class RegularTimePoint(Identity):
    '''
    Time point for a schedule where the time between the consecutive points
    is constant.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The position of the regular time point in the sequence. Note that time
    points don't have to be sequential, i.e. time points may be omitted. The
    actual time for a RegularTimePoint is computed by multiplying the associated
    regular interval schedule's time step with the regular time point sequence
    number and adding the associated schedules start time.
    '''

    value1: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The first value at the time. The meaning of the value is defined by the
    derived type of the associated schedule.
    '''

    value2: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The second value at the time. The meaning of the value is defined by the
    derived type of the associated schedule.
    '''

    IntervalSchedule: Optional[RegularIntervalSchedule] = field(
        default = None,
        metadata = {
            'type': 'Of Aggregate',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RegularIntervalSchedule.TimePoints',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Regular interval schedule containing this time point.
    '''

@dataclass(repr=False)
class ReportingCapability(Identity):
    '''
    <font color="#0f0f0f">Definition of one set of reporting capabilities for
    this monitoring station. The associated EnvironmentalValueSets describe
    the maximum range of possible environmental values the station is capable
    of returning via relationships with non-populated AnalogValue child instances.
    This attribute is intended primarily to assist a utility in managing its
    stations. </font>
    '''

    reportingIntervalPeriod: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of units of time making up reporting period.
    '''

    reportingIntervalType: Optional[ CalculationIntervalUnitKind ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Unit of time in which reporting period is expressed.
    '''

    reportingMethod: Optional[ ReportingMethodKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Indicates how the weather station reports observations.
    '''

    EnvironmentalAnalog: list[EnvironmentalAnalog] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EnvironmentalAnalog.ReportingCapability',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    One of the environmental value sets expressing one of the reporting capabilities.
    '''

@dataclass(repr=False)
class ScheduledEventData(Identity):
    '''
    Schedule parameters for an activity that is to occur, is occurring, or
    has completed.
    '''

    estimatedWindow: Optional[DateTimeInterval] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Estimated date and time for activity execution (with earliest possibility
    of activity initiation and latest possibility of activity completion).
    '''

    InspectionDataSet: Optional[InspectionDataSet] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'InspectionDataSet.AccordingToSchedules',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    requestedWindow: Optional[DateTimeInterval] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Requested date and time interval for activity execution.
    '''

    ScheduledEvents: list[ScheduledEvent] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ScheduledEvent.ScheduledEventData',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All scheduled events with this specification.
    '''

    status: Optional[Status] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class ServiceLocation(Identity):
    '''
    A real estate location, commonly referred to as premises.
    '''

    accessMethod: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Method for the service person to access this service location. For example,
    a description of where to obtain a key if the facility is unmanned and
    secured.
    '''

    needsInspection: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if inspection is needed of facilities at this service location. This
    could be requested by a customer, due to suspected tampering, environmental
    concerns (e.g., a fire in the vicinity), or to correct incompatible data.
    '''

    siteAccessProblem: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Problems previously encountered when visiting or performing work on this
    location. Examples include: bad dog, violent customer, verbally abusive
    occupant, obstructions, safety hazards, etc.
    '''

    CustomerAgreements: list[CustomerAgreement] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'CustomerAgreement.ServiceLocations',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All customer agreements regulating this service location.
    '''

    EndDevices: list[EndDevice] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'EndDevice.ServiceLocation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All end devices that measure the service delivered to this service location.
    '''

    TroubleTicket: list[TroubleTicket] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'TroubleTicket.ServiceLocation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    UsagePoints: list[UsagePoint] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'UsagePoint.ServiceLocation',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    All usage points delivering service (of the same type) to this service
    location.
    '''

@dataclass(repr=False)
class StateVariable(Identity):
    '''
    An abstract class for state variables.
    '''

@dataclass(repr=False)
class SvInjection(StateVariable):
    '''
    The SvInjection is reporting the calculated bus injection minus the sum
    of the terminal flows. The terminal flow is positive out from the bus (load
    sign convention) and bus injection has positive flow into the bus. SvInjection
    may have the remainder after state estimation or slack after power flow
    calculation.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The terminal phase at which the connection is applied. If missing, the
    injection is assumed to be balanced among non-neutral phases.
    '''

    pInjection: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The active power mismatch between calculated injection and initial injection.
    Positive sign means injection into the TopologicalNode (bus).
    '''

    qInjection: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reactive power mismatch between calculated injection and initial injection.
    Positive sign means injection into the TopologicalNode (bus).
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConnectivityNode.SvInjection',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalNode.SvInjection',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The topological node associated with the flow injection state variable.
    '''

@dataclass(repr=False)
class SvPowerFlow(StateVariable):
    '''
    State variable for power flow. Load convention is used for flow direction.
    This means flow out from the TopologicalNode into the equipment is positive.
    '''

    p: Optional[ float | ActivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The active power flow. Load sign convention is used, i.e. positive sign
    means flow out from a TopologicalNode (bus) into the conducting equipment.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The individual phase of the flow. If unspecified, then assumed to be balanced
    among phases.
    '''

    q: Optional[ float | ReactivePower ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reactive power flow. Load sign convention is used, i.e. positive sign
    means flow out from a TopologicalNode (bus) into the conducting equipment.
    '''

    Terminal: Optional[Terminal] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Terminal.SvPowerFlow',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The terminal associated with the power flow state variable.
    '''

@dataclass(repr=False)
class SvShuntCompensatorSections(StateVariable):
    '''
    State variable for the number of sections in service for a shunt compensator.
    '''

    sections: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The number of sections in service as a continous variable. To get integer
    value scale with ShuntCompensator.bPerSection.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The terminal phase at which the connection is applied. If missing, the
    injection is assumed to be balanced among non-neutral phases.
    '''

    ShuntCompensator: Optional[ShuntCompensator] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ShuntCompensator.SvShuntCompensatorSections',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The shunt compensator for which the state applies.
    '''

@dataclass(repr=False)
class SvStatus(StateVariable):
    '''
    State variable for status.
    '''

    inService: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The in service status as a result of topology processing.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The individual phase status. If the attribute is unspecified, then three
    phase model is assumed.
    '''

    ConductingEquipment: Optional[ConductingEquipment] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConductingEquipment.SvStatus',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The conducting equipment associated with the status state variable.
    '''

@dataclass(repr=False)
class SvSwitch(StateVariable):
    '''
    State variable for switch.
    '''

    open: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The attribute tells if the computed state of the switch is considered open.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The terminal phase at which the connection is applied. If missing, the
    injection is assumed to be balanced among non-neutral phases.
    '''

    Switch: Optional[Switch] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Switch.SvSwitch',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The switch associated with the switch state.
    '''

@dataclass(repr=False)
class SvTapStep(StateVariable):
    '''
    State variable for transformer tap step.
    '''

    position: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The floating point tap position. This is not the tap ratio, but rather
    the tap step position as defined by the related tap changer model and normally
    is constrained to be within the range of minimum and maximum tap positions.
    '''

    TapChanger: Optional[TapChanger] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TapChanger.SvTapStep',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The tap changer associated with the tap step state.
    '''

@dataclass(repr=False)
class SvVoltage(StateVariable):
    '''
    State variable for voltage.
    '''

    angle: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The voltage angle of the topological node complex voltage with respect
    to system reference.
    '''

    phase: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    If specified the voltage is the line to ground voltage of the individual
    phase. If unspecified, then the voltage is assumed balanced.
    '''

    v: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The voltage magnitude at the topological node.
    '''

    ConnectivityNode: Optional[ConnectivityNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'ConnectivityNode.SvVoltage',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    TopologicalNode: Optional[TopologicalNode] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'TopologicalNode.SvVoltage',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The topological node associated with the voltage state.
    '''

@dataclass(repr=False)
class SvEstVoltage(SvVoltage):
    '''
    '''

    angleVariance: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    vVariance: Optional[ float | Voltage ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    Estimate: Optional[Estimate] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'Estimate.SvEstVoltages',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class TapChangerTablePoint(Identity):
    '''
    '''

    ratio: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The voltage at the tap step divided by rated voltage of the transformer
    end having the tap changer. Hence this is a value close to one.
    For example, if the ratio at step 1 is 1.01, and the rated voltage of the
    transformer end is 110kV, then the voltage obtained by setting the tap
    changer to step 1 to is 111.1kV.
    '''

    step: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The tap step.
    '''

    b: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The magnetizing branch susceptance deviation in percent of nominal value.
    The actual susceptance is calculated as follows:
    calculated magnetizing susceptance = b(nominal) * (1 + b(from this class)/100).
    The b(nominal) is defined as the static magnetizing susceptance on the
    associated power transformer end or ends. This model assumes the star impedance
    (pi model) form.
    '''

    g: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The magnetizing branch conductance deviation in percent of nominal value.
    The actual conductance is calculated as follows:
    calculated magnetizing conductance = g(nominal) * (1 + g(from this class)/100).
    The g(nominal) is defined as the static magnetizing conductance on the
    associated power transformer end or ends. This model assumes the star impedance
    (pi model) form.
    '''

    r: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The resistance deviation in percent of nominal value. The actual reactance
    is calculated as follows:
    calculated resistance = r(nominal) * (1 + r(from this class)/100). The
    r(nominal) is defined as the static resistance on the associated power
    transformer end or ends. This model assumes the star impedance (pi model)
    form.
    '''

    x: Optional[ float | PerCent ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The series reactance deviation in percent of nominal value. The actual
    reactance is calculated as follows:
    calculated reactance = x(nominal) * (1 + x(from this class)/100). The x(nominal)
    is defined as the static series reactance on the associated power transformer
    end or ends. This model assumes the star impedance (pi model) form.
    '''

@dataclass(repr=False)
class PhaseTapChangerTablePoint(TapChangerTablePoint):
    '''
    Describes each tap step in the phase tap changer tabular curve.
    '''

    angle: Optional[ float | AngleDegrees ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The angle difference in degrees. A positive value indicates a positive
    phase shift from the winding where the tap is located to the other winding
    (for a two-winding transformer).
    '''

    PhaseTapChangerTable: Optional[PhaseTapChangerTable] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'PhaseTapChangerTable.PhaseTapChangerTablePoint',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The table of this point.
    '''

@dataclass(repr=False)
class RatioTapChangerTablePoint(TapChangerTablePoint):
    '''
    Describes each tap step in the ratio tap changer tabular curve.
    '''

    RatioTapChangerTable: Optional[RatioTapChangerTable] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'RatioTapChangerTable.RatioTapChangerTablePoint',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Table of this point.
    '''

@dataclass(repr=False)
class UserAttribute(Identity):
    '''
    Generic name-value pair class, with optional sequence number and units
    for value; can be used to model parts of information exchange when concrete
    types are not known in advance.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Name of an attribute.
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Sequence number for this attribute in a list of attributes.
    '''

    ProcedureDataSets: list[ProcedureDataSet] = field(
        default_factory = list,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': 'unbounded',
            'inverse': 'ProcedureDataSet.Properties',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    value: Optional[StringQuantity] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Value of an attribute, including unit information.
    '''

@dataclass(repr=False)
class WirePhaseInfo(Identity):
    '''
    '''

    sequenceNumber: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Numbering for wires on a WireSpacingInfo. Neutrals should be numbered last.
    '''

    phaseInfo: Optional[ SinglePhaseKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    WireAssemblyInfo: Optional[WireAssemblyInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'WireAssemblyInfo.WirePhaseInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    WireInfo: Optional[WireInfo] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'WireInfo.WirePhaseInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    WirePosition: Optional[WirePosition] = field(
        default = None,
        metadata = {
            'type': 'Association',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': 'WirePosition.WirePhaseInfo',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

class AccumulationKind(Enum):
    '''
    Kind of accumulation behaviour for read / measured values from individual
    end points.
    '''

    boundedQuantity = 'boundedQuantity'
    '''
    A time-independent cumulative quantity much like a 'bulkQuantity' or a
    'latchingQuantity', except that the accumulation stops at the maximum or
    minimum values. When the maximum is reached, any additional positive accumulation
    is discarded, but negative accumulation may be accepted (thus lowering
    the counter.) Likewise, when the negative bound is reached, any additional
    negative accumulation is discarded, but positive accumulation is accepted
    (thus increasing the counter.)
    '''

    bulkQuantity = 'bulkQuantity'
    '''
    A value from a register which represents the bulk quantity of a commodity.
    This quantity is computed as the integral of the commodity usage rate.
    This value is typically used as the basis for the dial reading at the meter,
    and as a result, will roll over upon reaching a maximum dial value.
    Note 1: With the metering system, the roll-over behaviour typically implies
    a roll-under behavior so that the value presented is always a positive
    value (e.g. unsigned integer or positive decimal.) However, when communicating
    data between enterprise applications a negative value might occur in a
    case such as net metering.
    Note 2: A 'bulkQuantity' refers primarily to the dial reading and not the
    consumption over a specific period of time.
    '''

    continuousCumulative = 'continuousCumulative'
    '''
    The sum of the previous billing period values and the present period value.
    Note: 'continuousCumulative' is commonly used in conjunction with 'demand',
    and it would represent the cumulative sum of the previous billing period
    maximum demand values (as occurring with each demand reset) summed with
    the present period maximum demand value (which has yet to be reset.)
    '''

    cumulative = 'cumulative'
    '''
    The sum of the previous billing period values.
    Note: 'cumulative' is commonly used in conjunction with “demand.” Each
    demand reset causes the maximum demand value for the present billing period
    (since the last demand reset) to accumulate as an accumulative total of
    all maximum demands. So instead of 'zeroing' the demand register, a demand
    reset has the effect of adding the present maximum demand to this accumulating
    total.
    '''

    deltaData = 'deltaData'
    '''
    The difference between the value at the end of the prescribed interval
    and the beginning of the interval. This is used for incremental interval
    data.
    Note: One common application would be for load profile data, another use
    might be to report the number of events within an interval (such as the
    number of equipment energisations within the specified period of time.)
    '''

    indicating = 'indicating'
    '''
    As if a needle is swung out on the meter face to a value to indicate the
    current value.
    Note: An 'indicating' value is typically measured over hundreds of milliseconds
    or greater, or may imply a “pusher” mechanism to capture a value. Compare
    this to 'instantaneous' which is measured over a shorter period of time.
    '''

    instantaneous = 'instantaneous'
    '''
    Typically measured over the fastest period of time allowed by the definition
    of the metric (usually milliseconds or tens of milliseconds.)
    Note: 'instantaneous' was moved to attribute #3 in Ed.2 of IEC 61968-9,
    from attribute #1 in Ed.1 of IEC 61968-9.
    '''

    latchingQuantity = 'latchingQuantity'
    '''
    When this description is applied to a metered value, it implies that the
    value is a time-independent cumulative quantity much like a 'bulkQuantity',
    except that it latches upon the maximum value upon reaching that value.
    Any additional accumulation (positive or negative) is discarded until a
    reset occurs.
    Note: A 'latchingQuantity' may also occur in the downward direction – upon
    reaching a minimum value. The terms 'maximum' or 'minimum' (for 'aggregate')
    will usually be included when this type of accumulation behaviour is present.
    When this description is applied to an encoded value (UOM= 'Code'), it
    implies that the value has one or more bits which are latching. The condition
    that caused the bit to be set may have long since evaporated.
    In either case, the timestamp that accompanies the value may not coincide
    with the moment the value was initially set.
    In both cases a system will need to perform an operation to clear the latched
    value.
    '''

    none = 'none'
    '''
    Not applicable, or implied by the unit of measure.
    '''

    summation = 'summation'
    '''
    A form of accumulation which is selective with respect to time.
    Note : 'summation' could be considered a specialisation of 'bulkQuantity'
    as it selectively accumulates pulses over a timing pattern (while 'bulkQuantity'
    accumulates pulses all of the time).
    '''

    timeDelay = 'timeDelay'
    '''
    A form of computation which introduces a time delay characteristic to the
    data value.
    '''

class AggregateKind(Enum):
    '''
    Kind of aggregation for read / measured values from multiple end points.
    '''

    average = 'average'
    '''
    The value represents average.
    '''

    excess = 'excess'
    '''
    The value represents an amount over which a threshold was exceeded.
    '''

    fifthMaximum = 'fifthMaximum'
    '''
    The fifth highest value observed.
    '''

    fourthMaximum = 'fourthMaximum'
    '''
    The fourth highest value observed.
    '''

    highThreshold = 'highThreshold'
    '''
    The value represents a programmed high threshold.
    '''

    lowThreshold = 'lowThreshold'
    '''
    The value represents a programmed low threshold.
    '''

    maximum = 'maximum'
    '''
    The highest value observed.
    '''

    minimum = 'minimum'
    '''
    The smallest value observed.
    '''

    nominal = 'nominal'
    '''
    The nominal value.
    '''

    none = 'none'
    '''
    Not applicable.
    '''

    normal = 'normal'
    '''
    The normal value.
    '''

    secondMaximum = 'secondMaximum'
    '''
    The second highest value observed.
    '''

    secondMinimum = 'secondMinimum'
    '''
    The second smallest value observed.
    '''

    sum = 'sum'
    '''
    The accumulated sum.
    '''

    thirdMaximum = 'thirdMaximum'
    '''
    The third highest value observed.
    '''

class AmiBillingReadyKind(Enum):
    '''
    Lifecycle states of the metering installation at a usage point with respect
    to readiness for billing via advanced metering infrastructure reads.
    '''

    amiCapable = 'amiCapable'
    '''
    Usage point is equipped with an AMI capable meter that is not yet currently
    equipped with a communications module.
    '''

    amiDisabled = 'amiDisabled'
    '''
    Usage point is equipped with an AMI capable meter; however, the AMI functionality
    has been disabled or is not being used.
    '''

    billingApproved = 'billingApproved'
    '''
    Usage point is equipped with an operating AMI capable meter and accuracy
    has been certified for billing purposes.
    '''

    enabled = 'enabled'
    '''
    Usage point is equipped with an AMI capable meter having communications
    capability.
    '''

    nonAmi = 'nonAmi'
    '''
    Usage point is equipped with a non AMI capable meter.
    '''

    nonMetered = 'nonMetered'
    '''
    Usage point is not currently equipped with a meter.
    '''

    operable = 'operable'
    '''
    Usage point is equipped with an AMI capable meter that is functioning and
    communicating with the AMI network.
    '''

class AnalyticKind(Enum):
    '''
    Possible kinds of analytics.
    '''

    agingAnalytic = 'agingAnalytic'
    '''
    '''

    faultAnalytic = 'faultAnalytic'
    '''
    '''

    healthAnalytic = 'healthAnalytic'
    '''
    '''

    other = 'other'
    '''
    '''

    replacementAnalytic = 'replacementAnalytic'
    '''
    '''

    riskAnalytic = 'riskAnalytic'
    '''
    '''

class AssetGroupKind(Enum):
    '''
    Possible kinds of asset groups.
    '''

    analysisGroup = 'analysisGroup'
    '''
    '''

    complianceGroup = 'complianceGroup'
    '''
    '''

    functionalGroup = 'functionalGroup'
    '''
    assets grouped together for a particular function - such as a group of
    feeders.
    '''

    inventoryGroup = 'inventoryGroup'
    '''
    '''

    other = 'other'
    '''
    '''

class AssetHazardKind(Enum):
    '''
    Type of hazard that is posed to asset in this location.
    Note: This enumeration provides essential information to asset health analytics.
    The existing list is a starting point and is anticipated to be fleshed
    out further as requirements are better understood (PAB 2016/01/09).
    '''

    ambientTempAbove38 = 'ambientTempAbove38'
    '''
    Subject to ambient temperature above 38 °C.
    '''

    ambientTempBelowMinus12 = 'ambientTempBelowMinus12'
    '''
    Subject to ambient temperature of below -12 °C.
    '''

    childrenAtPlay = 'childrenAtPlay'
    '''
    Children play in area (stray kite/ball hazard).
    '''

    fishingArea = 'fishingArea'
    '''
    Fishing in area (fishing pole/line hazard).
    '''

    other = 'other'
    '''
    If other, look at type field for more information.
    '''

    vegetation = 'vegetation'
    '''
    Vegetation growing below asset that may cause problem.
    '''

class AssetKind(Enum):
    '''
    '''

    breakerAirBlastBreaker = 'breakerAirBlastBreaker'
    '''
    '''

    breakerBulkOilBreaker = 'breakerBulkOilBreaker'
    '''
    '''

    breakerInsulatingStackAssembly = 'breakerInsulatingStackAssembly'
    '''
    '''

    breakerMinimumOilBreaker = 'breakerMinimumOilBreaker'
    '''
    '''

    breakerSF6DeadTankBreaker = 'breakerSF6DeadTankBreaker'
    '''
    '''

    breakerSF6LiveTankBreaker = 'breakerSF6LiveTankBreaker'
    '''
    '''

    breakerTankAssembly = 'breakerTankAssembly'
    '''
    '''

    other = 'other'
    '''
    Other type of Asset. The type attribute may provide more details in this
    case.
    '''

    transformer = 'transformer'
    '''
    '''

    transformerTank = 'transformerTank'
    '''
    '''

class AssetModelUsageKind(Enum):
    '''
    Usage for an asset model.
    '''

    customerSubstation = 'customerSubstation'
    '''
    Asset model is intended for use in customer substation.
    '''

    distributionOverhead = 'distributionOverhead'
    '''
    Asset model is intended for use in distribution overhead network.
    '''

    distributionUnderground = 'distributionUnderground'
    '''
    Asset model is intended for use in underground distribution network.
    '''

    other = 'other'
    '''
    Other kind of asset model usage.
    '''

    streetlight = 'streetlight'
    '''
    Asset model is intended for use as streetlight.
    '''

    substation = 'substation'
    '''
    Asset model is intended for use in substation.
    '''

    transmission = 'transmission'
    '''
    Asset model is intended for use in transmission network.
    '''

    unknown = 'unknown'
    '''
    Usage of the asset model is unknown.
    '''

class AsynchronousMachineKind(Enum):
    '''
    Kind of Asynchronous Machine.
    '''

    generator = 'generator'
    '''
    The Asynchronous Machine is a generator.
    '''

    motor = 'motor'
    '''
    The Asynchronous Machine is a motor.
    '''

class BatteryState(Enum):
    '''
    '''

    Charging = 'Charging'
    '''
    storedE is increasing
    '''

    Discharging = 'Discharging'
    '''
    storedE is decreasing
    '''

    Empty = 'Empty'
    '''
    unable to Discharge, and not Charging
    '''

    Full = 'Full'
    '''
    unable to Charge, and not Discharging
    '''

    Waiting = 'Waiting'
    '''
    neither Charging nor Discharging, but able to do so
    '''

class BreakerApplicationKind(Enum):
    '''
    Classifications of network roles in which breakers can be deployed. The
    classifications are intended to reflect both criticality of breaker in
    network operations and typical usage experienced by breaker.
    Note: This enumeration provides essential information to asset health analytics.
    The existing list is a starting point and is anticipated to be fleshed
    out further as requirements are better understood (PAB 2016/01/09).
    '''

    busBreaker = 'busBreaker'
    '''
    '''

    busTieBreaker = 'busTieBreaker'
    '''
    '''

    capacitorOrReactorBankBreaker = 'capacitorOrReactorBankBreaker'
    '''
    '''

    feederBreaker = 'feederBreaker'
    '''
    '''

    other = 'other'
    '''
    '''

    spare = 'spare'
    '''
    '''

    stepUpTransformerBreakerFossil = 'stepUpTransformerBreakerFossil'
    '''
    '''

    stepUpTransformerBreakerHydro = 'stepUpTransformerBreakerHydro'
    '''
    '''

    stepUpTransformerBreakerNuclear = 'stepUpTransformerBreakerNuclear'
    '''
    '''

    stepUpTransformerBreakerPumpedStorage = 'stepUpTransformerBreakerPumpedStorage'
    '''
    '''

    substationTransformerBreaker = 'substationTransformerBreaker'
    '''
    '''

    transmissionFlowGateLineBreaker = 'transmissionFlowGateLineBreaker'
    '''
    '''

    transmissionLineBreaker = 'transmissionLineBreaker'
    '''
    '''

    transmissionTieLineBreaker = 'transmissionTieLineBreaker'
    '''
    '''

class BreakerConfiguration(Enum):
    '''
    Switching arrangement for bay.
    '''

    breakerAndAHalf = 'breakerAndAHalf'
    '''
    Breaker and a half.
    '''

    doubleBreaker = 'doubleBreaker'
    '''
    Double breaker.
    '''

    noBreaker = 'noBreaker'
    '''
    No breaker.
    '''

    singleBreaker = 'singleBreaker'
    '''
    Single breaker.
    '''

class BusbarConfiguration(Enum):
    '''
    Busbar layout for bay.
    '''

    doubleBus = 'doubleBus'
    '''
    Double bus.
    '''

    mainWithTransfer = 'mainWithTransfer'
    '''
    Main bus with transfer bus.
    '''

    ringBus = 'ringBus'
    '''
    Ring bus.
    '''

    singleBus = 'singleBus'
    '''
    Single bus.
    '''

class BushingInsulationKind(Enum):
    '''
    Insulation kind for bushings.
    '''

    compound = 'compound'
    '''
    '''

    oilImpregnatedPaper = 'oilImpregnatedPaper'
    '''
    &lt;was paperoil&gt;.
    '''

    other = 'other'
    '''
    '''

    resinBondedPaper = 'resinBondedPaper'
    '''
    '''

    resinImpregnatedPaper = 'resinImpregnatedPaper'
    '''
    '''

    solidPorcelain = 'solidPorcelain'
    '''
    '''

class CableConstructionKind(Enum):
    '''
    Kind of cable construction.
    '''

    compacted = 'compacted'
    '''
    Compacted cable.
    '''

    compressed = 'compressed'
    '''
    Compressed cable.
    '''

    other = 'other'
    '''
    Other kind of cable construction.
    '''

    sector = 'sector'
    '''
    Sector cable.
    '''

    segmental = 'segmental'
    '''
    Segmental cable.
    '''

    solid = 'solid'
    '''
    Solid cable.
    '''

    stranded = 'stranded'
    '''
    Stranded cable.
    '''

class CableOuterJacketKind(Enum):
    '''
    Kind of cable outer jacket.
    '''

    insulating = 'insulating'
    '''
    Insulating cable outer jacket.
    '''

    linearLowDensityPolyethylene = 'linearLowDensityPolyethylene'
    '''
    Linear low density polyethylene cable outer jacket.
    '''

    none = 'none'
    '''
    Cable has no outer jacket.
    '''

    other = 'other'
    '''
    Pther kind of cable outer jacket.
    '''

    polyethylene = 'polyethylene'
    '''
    Polyethylene cable outer jacket.
    '''

    pvc = 'pvc'
    '''
    PVC cable outer jacket.
    '''

    semiconducting = 'semiconducting'
    '''
    Semiconducting cable outer jacket.
    '''

class CableShieldMaterialKind(Enum):
    '''
    Kind of cable shield material.
    '''

    aluminum = 'aluminum'
    '''
    Aluminum cable shield.
    '''

    copper = 'copper'
    '''
    Copper cable shield.
    '''

    lead = 'lead'
    '''
    Lead cable shield.
    '''

    other = 'other'
    '''
    Other kind of cable shield material.
    '''

    steel = 'steel'
    '''
    Steel cable shield.
    '''

class Class1(Enum):
    '''
    '''

class CommodityKind(Enum):
    '''
    Perfluorocarbons PFC
    '''

class CoolantType(Enum):
    '''
    Method of cooling a machine.
    '''

    air = 'air'
    '''
    Air.
    '''

    hydrogenGas = 'hydrogenGas'
    '''
    Hydrogen gas.
    '''

    water = 'water'
    '''
    Water.
    '''

class CorporateStandardKind(Enum):
    '''
    Asset model is used as corporate standard.
    '''

class CrewStatusKind(Enum):
    '''
    Indicates that the work at one or more work sites has been completed
    '''

class Currency(Enum):
    '''
    Monetary currencies. ISO 4217 standard including 3-character currency code.
    '''

    AED = 'AED'
    '''
    United Arab Emirates dirham.
    '''

    AFN = 'AFN'
    '''
    Afghan afghani.
    '''

    ALL = 'ALL'
    '''
    Albanian lek.
    '''

    AMD = 'AMD'
    '''
    Armenian dram.
    '''

    ANG = 'ANG'
    '''
    Netherlands Antillean guilder.
    '''

    AOA = 'AOA'
    '''
    Angolan kwanza.
    '''

    ARS = 'ARS'
    '''
    Argentine peso.
    '''

    AUD = 'AUD'
    '''
    Australian dollar.
    '''

    AWG = 'AWG'
    '''
    Aruban florin.
    '''

    AZN = 'AZN'
    '''
    Azerbaijani manat.
    '''

    BAM = 'BAM'
    '''
    Bosnia and Herzegovina convertible mark.
    '''

    BBD = 'BBD'
    '''
    Barbados dollar.
    '''

    BDT = 'BDT'
    '''
    Bangladeshi taka.
    '''

    BGN = 'BGN'
    '''
    Bulgarian lev.
    '''

    BHD = 'BHD'
    '''
    Bahraini dinar.
    '''

    BIF = 'BIF'
    '''
    Burundian franc.
    '''

    BMD = 'BMD'
    '''
    Bermudian dollar (customarily known as Bermuda dollar).
    '''

    BND = 'BND'
    '''
    Brunei dollar.
    '''

    BOB = 'BOB'
    '''
    Boliviano.
    '''

    BOV = 'BOV'
    '''
    Bolivian Mvdol (funds code).
    '''

    BRL = 'BRL'
    '''
    Brazilian real.
    '''

    BSD = 'BSD'
    '''
    Bahamian dollar.
    '''

    BTN = 'BTN'
    '''
    Bhutanese ngultrum.
    '''

    BWP = 'BWP'
    '''
    Botswana pula.
    '''

    BYR = 'BYR'
    '''
    Belarusian ruble.
    '''

    BZD = 'BZD'
    '''
    Belize dollar.
    '''

    CAD = 'CAD'
    '''
    Canadian dollar
    '''

    CDF = 'CDF'
    '''
    Congolese franc.
    '''

    CHF = 'CHF'
    '''
    Swiss franc.
    '''

    CLF = 'CLF'
    '''
    Unidad de Fomento (funds code), Chile.
    '''

    CLP = 'CLP'
    '''
    Chilean peso.
    '''

    CNY = 'CNY'
    '''
    Chinese yuan.
    '''

    COP = 'COP'
    '''
    Colombian peso.
    '''

    COU = 'COU'
    '''
    Unidad de Valor Real.
    '''

    CRC = 'CRC'
    '''
    Costa Rican colon.
    '''

    CUC = 'CUC'
    '''
    Cuban convertible peso.
    '''

    CUP = 'CUP'
    '''
    Cuban peso.
    '''

    CVE = 'CVE'
    '''
    Cape Verde escudo.
    '''

    CZK = 'CZK'
    '''
    Czech koruna.
    '''

    DJF = 'DJF'
    '''
    Djiboutian franc.
    '''

    DKK = 'DKK'
    '''
    Danish krone.
    '''

    DOP = 'DOP'
    '''
    Dominican peso.
    '''

    DZD = 'DZD'
    '''
    Algerian dinar.
    '''

    EEK = 'EEK'
    '''
    Estonian kroon.
    '''

    EGP = 'EGP'
    '''
    Egyptian pound.
    '''

    ERN = 'ERN'
    '''
    Eritrean nakfa.
    '''

    ETB = 'ETB'
    '''
    Ethiopian birr.
    '''

    EUR = 'EUR'
    '''
    Euro.
    '''

    FJD = 'FJD'
    '''
    Fiji dollar.
    '''

    FKP = 'FKP'
    '''
    Falkland Islands pound.
    '''

    GBP = 'GBP'
    '''
    Pound sterling.
    '''

    GEL = 'GEL'
    '''
    Georgian lari.
    '''

    GHS = 'GHS'
    '''
    Ghanaian cedi.
    '''

    GIP = 'GIP'
    '''
    Gibraltar pound.
    '''

    GMD = 'GMD'
    '''
    Gambian dalasi.
    '''

    GNF = 'GNF'
    '''
    Guinean franc.
    '''

    GTQ = 'GTQ'
    '''
    Guatemalan quetzal.
    '''

    GYD = 'GYD'
    '''
    Guyanese dollar.
    '''

    HKD = 'HKD'
    '''
    Hong Kong dollar.
    '''

    HNL = 'HNL'
    '''
    Honduran lempira.
    '''

    HRK = 'HRK'
    '''
    Croatian kuna.
    '''

    HTG = 'HTG'
    '''
    Haitian gourde.
    '''

    HUF = 'HUF'
    '''
    Hungarian forint.
    '''

    IDR = 'IDR'
    '''
    Indonesian rupiah.
    '''

    ILS = 'ILS'
    '''
    Israeli new sheqel.
    '''

    INR = 'INR'
    '''
    Indian rupee.
    '''

    IQD = 'IQD'
    '''
    Iraqi dinar.
    '''

    IRR = 'IRR'
    '''
    Iranian rial.
    '''

    ISK = 'ISK'
    '''
    Icelandic króna.
    '''

    JMD = 'JMD'
    '''
    Jamaican dollar.
    '''

    JOD = 'JOD'
    '''
    Jordanian dinar.
    '''

    JPY = 'JPY'
    '''
    Japanese yen.
    '''

    KES = 'KES'
    '''
    Kenyan shilling.
    '''

    KGS = 'KGS'
    '''
    Kyrgyzstani som.
    '''

    KHR = 'KHR'
    '''
    Cambodian riel.
    '''

    KMF = 'KMF'
    '''
    Comoro franc.
    '''

    KPW = 'KPW'
    '''
    North Korean won.
    '''

    KRW = 'KRW'
    '''
    South Korean won.
    '''

    KWD = 'KWD'
    '''
    Kuwaiti dinar.
    '''

    KYD = 'KYD'
    '''
    Cayman Islands dollar.
    '''

    KZT = 'KZT'
    '''
    Kazakhstani tenge.
    '''

    LAK = 'LAK'
    '''
    Lao kip.
    '''

    LBP = 'LBP'
    '''
    Lebanese pound.
    '''

    LKR = 'LKR'
    '''
    Sri Lanka rupee.
    '''

    LRD = 'LRD'
    '''
    Liberian dollar.
    '''

    LSL = 'LSL'
    '''
    Lesotho loti.
    '''

    LTL = 'LTL'
    '''
    Lithuanian litas.
    '''

    LVL = 'LVL'
    '''
    Latvian lats.
    '''

    LYD = 'LYD'
    '''
    Libyan dinar.
    '''

    MAD = 'MAD'
    '''
    Moroccan dirham.
    '''

    MDL = 'MDL'
    '''
    Moldovan leu.
    '''

    MGA = 'MGA'
    '''
    Malagasy ariary.
    '''

    MKD = 'MKD'
    '''
    Macedonian denar.
    '''

    MMK = 'MMK'
    '''
    Myanma kyat.
    '''

    MNT = 'MNT'
    '''
    Mongolian tugrik.
    '''

    MOP = 'MOP'
    '''
    Macanese pataca.
    '''

    MRO = 'MRO'
    '''
    Mauritanian ouguiya.
    '''

    MUR = 'MUR'
    '''
    Mauritian rupee.
    '''

    MVR = 'MVR'
    '''
    Maldivian rufiyaa.
    '''

    MWK = 'MWK'
    '''
    Malawian kwacha.
    '''

    MXN = 'MXN'
    '''
    Mexican peso.
    '''

    MYR = 'MYR'
    '''
    Malaysian ringgit.
    '''

    MZN = 'MZN'
    '''
    Mozambican metical.
    '''

    NAD = 'NAD'
    '''
    Namibian dollar.
    '''

    NGN = 'NGN'
    '''
    Nigerian naira.
    '''

    NIO = 'NIO'
    '''
    Cordoba oro.
    '''

    NOK = 'NOK'
    '''
    Norwegian krone.
    '''

    NPR = 'NPR'
    '''
    Nepalese rupee.
    '''

    NZD = 'NZD'
    '''
    New Zealand dollar.
    '''

    OMR = 'OMR'
    '''
    Omani rial.
    '''

    PAB = 'PAB'
    '''
    Panamanian balboa.
    '''

    PEN = 'PEN'
    '''
    Peruvian nuevo sol.
    '''

    PGK = 'PGK'
    '''
    Papua New Guinean kina.
    '''

    PHP = 'PHP'
    '''
    Philippine peso.
    '''

    PKR = 'PKR'
    '''
    Pakistani rupee.
    '''

    PLN = 'PLN'
    '''
    Polish zloty.
    '''

    PYG = 'PYG'
    '''
    Paraguayan guaraní.
    '''

    QAR = 'QAR'
    '''
    Qatari rial.
    '''

    RON = 'RON'
    '''
    Romanian new leu.
    '''

    RSD = 'RSD'
    '''
    Serbian dinar.
    '''

    RUB = 'RUB'
    '''
    Russian rouble.
    '''

    RWF = 'RWF'
    '''
    Rwandan franc.
    '''

    SAR = 'SAR'
    '''
    Saudi riyal.
    '''

    SBD = 'SBD'
    '''
    Solomon Islands dollar.
    '''

    SCR = 'SCR'
    '''
    Seychelles rupee.
    '''

    SDG = 'SDG'
    '''
    Sudanese pound.
    '''

    SEK = 'SEK'
    '''
    Swedish krona/kronor.
    '''

    SGD = 'SGD'
    '''
    Singapore dollar.
    '''

    SHP = 'SHP'
    '''
    Saint Helena pound.
    '''

    SLL = 'SLL'
    '''
    Sierra Leonean leone.
    '''

    SOS = 'SOS'
    '''
    Somali shilling.
    '''

    SRD = 'SRD'
    '''
    Surinamese dollar.
    '''

    STD = 'STD'
    '''
    São Tomé and Príncipe dobra.
    '''

    SYP = 'SYP'
    '''
    Syrian pound.
    '''

    SZL = 'SZL'
    '''
    Lilangeni.
    '''

    THB = 'THB'
    '''
    Thai baht.
    '''

    TJS = 'TJS'
    '''
    Tajikistani somoni.
    '''

    TMT = 'TMT'
    '''
    Turkmenistani manat.
    '''

    TND = 'TND'
    '''
    Tunisian dinar.
    '''

    TOP = 'TOP'
    '''
    Tongan pa?anga.
    '''

    TRY = 'TRY'
    '''
    Turkish lira.
    '''

    TTD = 'TTD'
    '''
    Trinidad and Tobago dollar.
    '''

    TWD = 'TWD'
    '''
    New Taiwan dollar.
    '''

    TZS = 'TZS'
    '''
    Tanzanian shilling.
    '''

    UAH = 'UAH'
    '''
    Ukrainian hryvnia.
    '''

    UGX = 'UGX'
    '''
    Ugandan shilling.
    '''

    USD = 'USD'
    '''
    United States dollar.
    '''

    UYU = 'UYU'
    '''
    Uruguayan peso.
    '''

    UZS = 'UZS'
    '''
    Uzbekistan som.
    '''

    VEF = 'VEF'
    '''
    Venezuelan bolívar fuerte.
    '''

    VND = 'VND'
    '''
    Vietnamese Dong.
    '''

    VUV = 'VUV'
    '''
    Vanuatu vatu.
    '''

    WST = 'WST'
    '''
    Samoan tala.
    '''

    XAF = 'XAF'
    '''
    CFA franc BEAC.
    '''

    XCD = 'XCD'
    '''
    East Caribbean dollar.
    '''

    XOF = 'XOF'
    '''
    CFA Franc BCEAO.
    '''

    XPF = 'XPF'
    '''
    CFP franc.
    '''

    YER = 'YER'
    '''
    Yemeni rial.
    '''

    ZAR = 'ZAR'
    '''
    South African rand.
    '''

    ZMK = 'ZMK'
    '''
    Zambian kwacha.
    '''

    ZWL = 'ZWL'
    '''
    Zimbabwe dollar.
    '''

class CurveStyle(Enum):
    '''
    Style or shape of curve.
    '''

    constantYValue = 'constantYValue'
    '''
    The Y-axis values are assumed constant until the next curve point and prior
    to the first curve point.
    '''

    straightLineYValues = 'straightLineYValues'
    '''
    The Y-axis values are assumed to be a straight line between values. Also
    known as linear interpolation.
    '''

class CustomerKind(Enum):
    '''
    Kind of customer.
    '''

    commercialIndustrial = 'commercialIndustrial'
    '''
    Commercial industrial customer.
    '''

    energyServiceScheduler = 'energyServiceScheduler'
    '''
    Customer as energy service scheduler.
    '''

    energyServiceSupplier = 'energyServiceSupplier'
    '''
    Customer as energy service supplier.
    '''

    enterprise = 'enterprise'
    '''
    '''

    internalUse = 'internalUse'
    '''
    Internal use customer.
    '''

    other = 'other'
    '''
    Other kind of customer.
    '''

    pumpingLoad = 'pumpingLoad'
    '''
    Pumping load customer.
    '''

    regionalOperator = 'regionalOperator'
    '''
    '''

    residential = 'residential'
    '''
    Residential customer.
    '''

    residentialAndCommercial = 'residentialAndCommercial'
    '''
    Residential and commercial customer.
    '''

    residentialAndStreetlight = 'residentialAndStreetlight'
    '''
    Residential and streetlight customer.
    '''

    residentialFarmService = 'residentialFarmService'
    '''
    Residential farm service customer.
    '''

    residentialStreetlightOthers = 'residentialStreetlightOthers'
    '''
    Residential streetlight or other related customer.
    '''

    subsidiary = 'subsidiary'
    '''
    '''

    windMachine = 'windMachine'
    '''
    Wind machine customer.
    '''

class DERParameterKind(Enum):
    '''
    '''

    activePower = 'activePower'
    '''
    '''

    apparentPower = 'apparentPower'
    '''
    '''

    decreasingRampRate = 'decreasingRampRate'
    '''
    '''

    highFilterBiDirectionalRegulation = 'highFilterBiDirectionalRegulation'
    '''
    '''

    highFilterDownRegulation = 'highFilterDownRegulation'
    '''
    '''

    highFilterUpRegulation = 'highFilterUpRegulation'
    '''
    '''

    increasingRampRate = 'increasingRampRate'
    '''
    '''

    lowFilterBiDirectionalRegulation = 'lowFilterBiDirectionalRegulation'
    '''
    '''

    lowFilterDownRegulation = 'lowFilterDownRegulation'
    '''
    '''

    lowFilterUpRegulation = 'lowFilterUpRegulation'
    '''
    '''

    reactivePower = 'reactivePower'
    '''
    '''

    voltage = 'voltage'
    '''
    '''

class DERUnitSymbol(Enum):
    '''
    The units defined for usage in the CIM.
    '''

    A = 'A'
    '''
    Current in Ampere.
    '''

    Ah = 'Ah'
    '''
    Ampere-hours, Ampere-hours.
    '''

    As = 'As'
    '''
    Ampere seconds (A·s).
    '''

    Btu = 'Btu'
    '''
    Energy, British Thermal Unit.
    '''

    Hz = 'Hz'
    '''
    Frequency in Hertz (1/s).
    '''

    Q = 'Q'
    '''
    Quantity power, Q.
    '''

    Qh = 'Qh'
    '''
    Quantity energy, Qh.
    '''

    V = 'V'
    '''
    Electric potential in Volt (W/A).
    '''

    VA = 'VA'
    '''
    Apparent power in Volt Ampere (See also real power and reactive power.)
    '''

    VAh = 'VAh'
    '''
    Apparent energy in Volt Ampere hours.
    '''

    VAr = 'VAr'
    '''
    Reactive power in Volt Ampere reactive. The “reactive” or “imaginary” component
    of electrical power (VIsin(phi)). (See also real power and apparent power).
    Note: Different meter designs use different methods to arrive at their
    results. Some meters may compute reactive power as an arithmetic value,
    while others compute the value vectorially. The data consumer should determine
    the method in use and the suitability of the measurement for the intended
    purpose.
    '''

    VArh = 'VArh'
    '''
    Reactive energy in Volt Ampere reactive hours.
    '''

    VPerVA = 'VPerVA'
    '''
    Power factor, PF, the ratio of the active power to the apparent power.
    Note: The sign convention used for power factor will differ between IEC
    meters and EEI (ANSI) meters. It is assumed that the data consumers understand
    the type of meter being used and agree on the sign convention in use at
    any given utility.
    '''

    VPerVAr = 'VPerVAr'
    '''
    Power factor, PF, the ratio of the active power to the apparent power.
    Note: The sign convention used for power factor will differ between IEC
    meters and EEI (ANSI) meters. It is assumed that the data consumers understand
    the type of meter being used and agree on the sign convention in use at
    any given utility.
    '''

    Vh = 'Vh'
    '''
    Volt-hour, Volt hours.
    '''

    Vs = 'Vs'
    '''
    Volt second (Ws/A).
    '''

    W = 'W'
    '''
    Real power in Watt (J/s). Electrical power may have real and reactive components.
    The real portion of electrical power (I²R or VIcos(phi)), is expressed
    in Watts. (See also apparent power and reactive power.)
    '''

    WPerA = 'WPerA'
    '''
    Active power per current flow, watt per Ampere.
    '''

    WPers = 'WPers'
    '''
    Ramp rate in Watt per second.
    '''

    Wh = 'Wh'
    '''
    Real energy in Watt hours.
    '''

    deg = 'deg'
    '''
    Plane angle in degrees.
    '''

    degC = 'degC'
    '''
    Relative temperature in degrees Celsius.
    In the SI unit system the symbol is ºC. Electric charge is measured in
    coulomb that has the unit symbol C. To distinguish degree Celsius form
    coulomb the symbol used in the UML is degC. Reason for not using ºC is
    the special character º is difficult to manage in software.
    '''

    h = 'h'
    '''
    Time, hour = 60 min = 3600 s.
    '''

    min = 'min'
    '''
    Time, minute = 60 s.
    '''

    ohm = 'ohm'
    '''
    Electric resistance in ohm (V/A).
    '''

    ohmPerm = 'ohmPerm'
    '''
    Electric resistance per length in ohm per metre ((V/A)/m).
    '''

    ohmm = 'ohmm'
    '''
    resistivity, Ohm metre, (rho).
    '''

    onePerHz = 'onePerHz'
    '''
    Reciprocal of frequency (1/Hz).
    '''

    s = 's'
    '''
    Time in seconds.
    '''

    therm = 'therm'
    '''
    Energy, Therm.
    '''

class DeploymentStateKind(Enum):
    '''
    Possible states of asset deployment.
    '''

    inService = 'inService'
    '''
    '''

    installed = 'installed'
    '''
    '''

    notYetInstalled = 'notYetInstalled'
    '''
    '''

    outOfService = 'outOfService'
    '''
    '''

    removed = 'removed'
    '''
    '''

class EmissionType(Enum):
    '''
    The type of emission.
    '''

    carbonDioxide = 'carbonDioxide'
    '''
    Carbon diaoxide.
    '''

    carbonDisulfide = 'carbonDisulfide'
    '''
    Carbon disulfide.
    '''

    chlorine = 'chlorine'
    '''
    Clorine.
    '''

    hydrogenSulfide = 'hydrogenSulfide'
    '''
    Hydrogen sulfide.
    '''

    nitrogenOxide = 'nitrogenOxide'
    '''
    Nitrogen oxide.
    '''

    sulfurDioxide = 'sulfurDioxide'
    '''
    Sulfer dioxide.
    '''

class EmissionValueSource(Enum):
    '''
    The source of the emission value.
    '''

    calculated = 'calculated'
    '''
    Calculated.
    '''

    measured = 'measured'
    '''
    Measured.
    '''

class FacilityKind(Enum):
    '''
    Types of facilities at which an asset can be deployed.
    '''

    distributionPoleTop = 'distributionPoleTop'
    '''
    '''

    substationDistribution = 'substationDistribution'
    '''
    '''

    substationFossilPlant = 'substationFossilPlant'
    '''
    '''

    substationHydroPlant = 'substationHydroPlant'
    '''
    '''

    substationNuclearPlant = 'substationNuclearPlant'
    '''
    '''

    substationSubTransmission = 'substationSubTransmission'
    '''
    '''

    substationTransmission = 'substationTransmission'
    '''
    '''

class FlowDirectionKind(Enum):
    '''
    Q2 only
    '''

class FuelType(Enum):
    '''
    Type of fuel.
    '''

    coal = 'coal'
    '''
    Generic coal, not including lignite type.
    '''

    gas = 'gas'
    '''
    Natural gas.
    '''

    hardCoal = 'hardCoal'
    '''
    Hard coal
    '''

    lignite = 'lignite'
    '''
    The fuel is lignite coal. Note that this is a special type of coal, so
    the other enum of coal is reserved for hard coal types or if the exact
    type of coal is not known.
    '''

    oil = 'oil'
    '''
    Oil.
    '''

    oilShale = 'oilShale'
    '''
    Oil Shale
    '''

class GeneratorControlMode(Enum):
    '''
    Unit control modes.
    '''

    pulse = 'pulse'
    '''
    Pulse control mode.
    '''

    setpoint = 'setpoint'
    '''
    Setpoint control mode.
    '''

class GeneratorControlSource(Enum):
    '''
    The source of controls for a generating unit.
    '''

    offAGC = 'offAGC'
    '''
    Off of automatic generation control (AGC).
    '''

    onAGC = 'onAGC'
    '''
    On automatic generation control (AGC).
    '''

    plantControl = 'plantControl'
    '''
    Plant is controlling.
    '''

    unavailable = 'unavailable'
    '''
    Not available.
    '''

class HouseCooling(Enum):
    '''
    '''

    electric = 'electric'
    '''
    '''

    heatPump = 'heatPump'
    '''
    '''

    none = 'none'
    '''
    '''

class HouseHeating(Enum):
    '''
    '''

    gas = 'gas'
    '''
    '''

    heatPump = 'heatPump'
    '''
    '''

    none = 'none'
    '''
    '''

    resistance = 'resistance'
    '''
    '''

class HouseThermalIntegrity(Enum):
    '''
    '''

    aboveNormal = 'aboveNormal'
    '''
    '''

    belowNormal = 'belowNormal'
    '''
    '''

    good = 'good'
    '''
    '''

    little = 'little'
    '''
    '''

    normal = 'normal'
    '''
    '''

    unknown = 'unknown'
    '''
    '''

    veryGood = 'veryGood'
    '''
    '''

    veryLittle = 'veryLittle'
    '''
    '''

class HydroEnergyConversionKind(Enum):
    '''
    Specifies the capability of the hydro generating unit to convert energy
    as a generator or pump.
    '''

    generator = 'generator'
    '''
    Able to generate power, but not able to pump water for energy storage.
    '''

    pumpAndGenerator = 'pumpAndGenerator'
    '''
    Able to both generate power and pump water for energy storage.
    '''

class HydroPlantStorageKind(Enum):
    '''
    The type of hydro power plant.
    '''

    pumpedStorage = 'pumpedStorage'
    '''
    Pumped storage.
    '''

    runOfRiver = 'runOfRiver'
    '''
    Run of river.
    '''

    storage = 'storage'
    '''
    Storage.
    '''

class IEEE1547AbnormalPerfomanceCategory(Enum):
    '''
    '''

    CategoryI = 'CategoryI'
    '''
    '''

    CategoryII = 'CategoryII'
    '''
    '''

    CategoryIII = 'CategoryIII'
    '''
    '''

class IEEE1547IslandingCategory(Enum):
    '''
    See clause 8.2
    '''

    BlackStart = 'BlackStart'
    '''
    '''

    Capable = 'Capable'
    '''
    '''

    Isochronous = 'Isochronous'
    '''
    '''

    Uncategorized = 'Uncategorized'
    '''
    '''

class IEEE1547NormalPerformanceCategory(Enum):
    '''
    '''

    CategoryA = 'CategoryA'
    '''
    '''

    CategoryB = 'CategoryB'
    '''
    '''

class InterruptingMediumKind(Enum):
    '''
    '''

class LocationKind(Enum):
    '''
    '''

    center = 'center'
    '''
    The center of a phenomenon. Will typically be used with a Location with
    a single PositionPoint instance.
    '''

    extent = 'extent'
    '''
    The area or line of a phenomenon, not the center. Will typically be used
    with a Location with multiple PositionPoint instances.
    '''

    primary = 'primary'
    '''
    Primary area to which an environmental alert applies.
    '''

    secondary = 'secondary'
    '''
    Secondary area to which an environmental alert applies.
    '''

class MacroPeriodKind(Enum):
    '''
    Kind of macro period for calculations on read / measured values.
    '''

class MeasurementKind(Enum):
    '''
    Kind of read / measured value.
    '''

    alarm = 'alarm'
    '''
    '''

    apTitle = 'apTitle'
    '''
    '''

    apparentPowerFactor = 'apparentPowerFactor'
    '''
    '''

    applicationContext = 'applicationContext'
    '''
    '''

    assetNumber = 'assetNumber'
    '''
    '''

    audibleVolume = 'audibleVolume'
    '''
    Sound
    '''

    bandwidth = 'bandwidth'
    '''
    '''

    batteryCarryover = 'batteryCarryover'
    '''
    '''

    batteryVoltage = 'batteryVoltage'
    '''
    '''

    billCarryover = 'billCarryover'
    '''
    Customer’s bill for the (Currency)
    '''

    billLastPeriod = 'billLastPeriod'
    '''
    Customer’s bill for the previous billing period (Currency)
    '''

    billToDate = 'billToDate'
    '''
    Customer’s bill, as known thus far within the present billing period (Currency)
    '''

    broadcastAddress = 'broadcastAddress'
    '''
    '''

    connectionFee = 'connectionFee'
    '''
    Monthly fee for connection to commodity.
    '''

    currency = 'currency'
    '''
    funds
    '''

    current = 'current'
    '''
    '''

    currentAngle = 'currentAngle'
    '''
    '''

    currentImbalance = 'currentImbalance'
    '''
    '''

    dataOverflowAlarm = 'dataOverflowAlarm'
    '''
    '''

    date = 'date'
    '''
    '''

    demand = 'demand'
    '''
    '''

    demandLimit = 'demandLimit'
    '''
    '''

    demandReset = 'demandReset'
    '''
    Usually expressed as a count as part of a billing cycle
    '''

    deviceAddressType1 = 'deviceAddressType1'
    '''
    '''

    deviceAddressType2 = 'deviceAddressType2'
    '''
    '''

    deviceAddressType3 = 'deviceAddressType3'
    '''
    '''

    deviceAddressType4 = 'deviceAddressType4'
    '''
    '''

    deviceClass = 'deviceClass'
    '''
    '''

    diagnostic = 'diagnostic'
    '''
    '''

    distance = 'distance'
    '''
    '''

    distortionPowerFactor = 'distortionPowerFactor'
    '''
    '''

    distortionVoltAmp = 'distortionVoltAmp'
    '''
    '''

    electronicSerialNumber = 'electronicSerialNumber'
    '''
    '''

    emergencyLimit = 'emergencyLimit'
    '''
    '''

    encoderTamper = 'encoderTamper'
    '''
    '''

    endDeviceID = 'endDeviceID'
    '''
    '''

    energization = 'energization'
    '''
    '''

    energizationLoadSide = 'energizationLoadSide'
    '''
    '''

    energy = 'energy'
    '''
    '''

    fan = 'fan'
    '''
    '''

    frequency = 'frequency'
    '''
    '''

    frequencyExcursion = 'frequencyExcursion'
    '''
    Usually expressed as a “count”
    '''

    fund = 'fund'
    '''
    Dup with “currency”
    '''

    groupAddressType1 = 'groupAddressType1'
    '''
    '''

    groupAddressType2 = 'groupAddressType2'
    '''
    '''

    groupAddressType3 = 'groupAddressType3'
    '''
    '''

    groupAddressType4 = 'groupAddressType4'
    '''
    '''

    ieee1366ASAI = 'ieee1366ASAI'
    '''
    '''

    ieee1366ASIDI = 'ieee1366ASIDI'
    '''
    '''

    ieee1366ASIFI = 'ieee1366ASIFI'
    '''
    '''

    ieee1366CAIDI = 'ieee1366CAIDI'
    '''
    '''

    ieee1366CAIFI = 'ieee1366CAIFI'
    '''
    '''

    ieee1366CEMIn = 'ieee1366CEMIn'
    '''
    '''

    ieee1366CEMSMIn = 'ieee1366CEMSMIn'
    '''
    '''

    ieee1366CTAIDI = 'ieee1366CTAIDI'
    '''
    '''

    ieee1366MAIFI = 'ieee1366MAIFI'
    '''
    '''

    ieee1366MAIFIe = 'ieee1366MAIFIe'
    '''
    '''

    ieee1366MomentaryInterruption = 'ieee1366MomentaryInterruption'
    '''
    '''

    ieee1366MomentaryInterruptionEvent = 'ieee1366MomentaryInterruptionEvent'
    '''
    '''

    ieee1366SAIDI = 'ieee1366SAIDI'
    '''
    '''

    ieee1366SAIFI = 'ieee1366SAIFI'
    '''
    '''

    ieee1366SustainedInterruption = 'ieee1366SustainedInterruption'
    '''
    '''

    interruptionBehaviour = 'interruptionBehaviour'
    '''
    '''

    inversionTamper = 'inversionTamper'
    '''
    '''

    ipAddress = 'ipAddress'
    '''
    '''

    lineLoss = 'lineLoss'
    '''
    '''

    loadInterrupt = 'loadInterrupt'
    '''
    '''

    loadShed = 'loadShed'
    '''
    '''

    loss = 'loss'
    '''
    '''

    macAddress = 'macAddress'
    '''
    '''

    maintenance = 'maintenance'
    '''
    '''

    mfgAssignedConfigurationID = 'mfgAssignedConfigurationID'
    '''
    '''

    mfgAssignedPhysicalSerialNumber = 'mfgAssignedPhysicalSerialNumber'
    '''
    '''

    mfgAssignedProductNumber = 'mfgAssignedProductNumber'
    '''
    '''

    mfgAssignedUniqueCommunicationAddress = 'mfgAssignedUniqueCommunicationAddress'
    '''
    '''

    multiCastAddress = 'multiCastAddress'
    '''
    '''

    negativeSequence = 'negativeSequence'
    '''
    '''

    none = 'none'
    '''
    Not Applicable
    '''

    oneWayAddress = 'oneWayAddress'
    '''
    '''

    phasorPowerFactor = 'phasorPowerFactor'
    '''
    '''

    phasorReactivePower = 'phasorReactivePower'
    '''
    '''

    physicalTamper = 'physicalTamper'
    '''
    '''

    positiveSequence = 'positiveSequence'
    '''
    '''

    power = 'power'
    '''
    '''

    powerFactor = 'powerFactor'
    '''
    '''

    powerLossTamper = 'powerLossTamper'
    '''
    '''

    powerOutage = 'powerOutage'
    '''
    '''

    powerQuality = 'powerQuality'
    '''
    '''

    powerRestoration = 'powerRestoration'
    '''
    '''

    programmed = 'programmed'
    '''
    '''

    pushbutton = 'pushbutton'
    '''
    '''

    quantityPower = 'quantityPower'
    '''
    '''

    relayActivation = 'relayActivation'
    '''
    '''

    relayCycle = 'relayCycle'
    '''
    Usually expressed as a count
    '''

    removalTamper = 'removalTamper'
    '''
    '''

    reprogrammingTamper = 'reprogrammingTamper'
    '''
    '''

    reverseRotationTamper = 'reverseRotationTamper'
    '''
    '''

    sag = 'sag'
    '''
    or Voltage Dip
    '''

    signalStrength = 'signalStrength'
    '''
    '''

    signaltoNoiseRatio = 'signaltoNoiseRatio'
    '''
    Moved here from Attribute #9 UOM
    '''

    swell = 'swell'
    '''
    '''

    switchArmed = 'switchArmed'
    '''
    '''

    switchDisabled = 'switchDisabled'
    '''
    '''

    switchPosition = 'switchPosition'
    '''
    '''

    tamper = 'tamper'
    '''
    '''

    tapPosition = 'tapPosition'
    '''
    '''

    tariffRate = 'tariffRate'
    '''
    '''

    temperature = 'temperature'
    '''
    '''

    totalHarmonicDistortion = 'totalHarmonicDistortion'
    '''
    '''

    transformerLoss = 'transformerLoss'
    '''
    '''

    twoWayAddress = 'twoWayAddress'
    '''
    '''

    unipedeVoltageDip10to15 = 'unipedeVoltageDip10to15'
    '''
    '''

    unipedeVoltageDip15to30 = 'unipedeVoltageDip15to30'
    '''
    '''

    unipedeVoltageDip30to60 = 'unipedeVoltageDip30to60'
    '''
    '''

    unipedeVoltageDip60to90 = 'unipedeVoltageDip60to90'
    '''
    '''

    unipedeVoltageDip90to100 = 'unipedeVoltageDip90to100'
    '''
    '''

    voltage = 'voltage'
    '''
    '''

    voltageAngle = 'voltageAngle'
    '''
    '''

    voltageExcursion = 'voltageExcursion'
    '''
    '''

    voltageImbalance = 'voltageImbalance'
    '''
    '''

    volume = 'volume'
    '''
    Clarified from Ed. 1. to indicate fluid volume
    '''

    volumetricFlow = 'volumetricFlow'
    '''
    '''

    watchdogTimeout = 'watchdogTimeout'
    '''
    '''

    zeroFlowDuration = 'zeroFlowDuration'
    '''
    '''

    zeroSequence = 'zeroSequence'
    '''
    '''

class MeasuringPeriodKind(Enum):
    '''
    Kind of period for reading / measuring values.
    '''

    fifteenMinute = 'fifteenMinute'
    '''
    15-minute
    '''

    fiveMinute = 'fiveMinute'
    '''
    5-minute
    '''

    fixedBlock10Min = 'fixedBlock10Min'
    '''
    10-minute Fixed Block
    '''

    fixedBlock15Min = 'fixedBlock15Min'
    '''
    15-minute Fixed Block
    '''

    fixedBlock1Min = 'fixedBlock1Min'
    '''
    1-minute Fixed Block
    '''

    fixedBlock20Min = 'fixedBlock20Min'
    '''
    20-minute Fixed Block
    '''

    fixedBlock30Min = 'fixedBlock30Min'
    '''
    30-minute Fixed Block
    '''

    fixedBlock5Min = 'fixedBlock5Min'
    '''
    5-minute Fixed Block
    '''

    fixedBlock60Min = 'fixedBlock60Min'
    '''
    60-minute Fixed Block
    '''

    none = 'none'
    '''
    Not applicable.
    '''

    oneMinute = 'oneMinute'
    '''
    1-minute
    '''

    present = 'present'
    '''
    Within the present period of time
    '''

    previous = 'previous'
    '''
    Shifted within the previous monthly cycle and data set
    '''

    rollingBlock10MinIntvl1MinSubIntvl = 'rollingBlock10MinIntvl1MinSubIntvl'
    '''
    10-minute Rolling Block with 1-minute sub-intervals
    '''

    rollingBlock10MinIntvl2MinSubIntvl = 'rollingBlock10MinIntvl2MinSubIntvl'
    '''
    10-minute Rolling Block with 2-minute sub-intervals
    '''

    rollingBlock10MinIntvl5MinSubIntvl = 'rollingBlock10MinIntvl5MinSubIntvl'
    '''
    10-minute Rolling Block with 5-minute sub-intervals
    '''

    rollingBlock15MinIntvl1MinSubIntvl = 'rollingBlock15MinIntvl1MinSubIntvl'
    '''
    15-minute Rolling Block with 1-minute sub-intervals
    '''

    rollingBlock15MinIntvl3MinSubIntvl = 'rollingBlock15MinIntvl3MinSubIntvl'
    '''
    15-minute Rolling Block with 3-minute sub-intervals
    '''

    rollingBlock15MinIntvl5MinSubIntvl = 'rollingBlock15MinIntvl5MinSubIntvl'
    '''
    15-minute Rolling Block with 5-minute sub-intervals
    '''

    rollingBlock30MinIntvl10MinSubIntvl = 'rollingBlock30MinIntvl10MinSubIntvl'
    '''
    30-minute Rolling Block with 10-minute sub-intervals
    '''

    rollingBlock30MinIntvl15MinSubIntvl = 'rollingBlock30MinIntvl15MinSubIntvl'
    '''
    30-minute Rolling Block with 15-minute sub-intervals
    '''

    rollingBlock30MinIntvl2MinSubIntvl = 'rollingBlock30MinIntvl2MinSubIntvl'
    '''
    30-minute Rolling Block with 2-minute sub-intervals
    '''

    rollingBlock30MinIntvl3MinSubIntvl = 'rollingBlock30MinIntvl3MinSubIntvl'
    '''
    30-minute Rolling Block with 3-minute sub-intervals
    '''

    rollingBlock30MinIntvl5MinSubIntvl = 'rollingBlock30MinIntvl5MinSubIntvl'
    '''
    30-minute Rolling Block with 5-minute sub-intervals.
    '''

    rollingBlock30MinIntvl6MinSubIntvl = 'rollingBlock30MinIntvl6MinSubIntvl'
    '''
    30-minute Rolling Block with 6-minute sub-intervals
    '''

    rollingBlock5MinIntvl1MinSubIntvl = 'rollingBlock5MinIntvl1MinSubIntvl'
    '''
    5-minute Rolling Block with 1-minute sub-intervals
    '''

    rollingBlock60MinIntvl10MinSubIntvl = 'rollingBlock60MinIntvl10MinSubIntvl'
    '''
    60-minute Rolling Block with 10-minute sub-intervals
    '''

    rollingBlock60MinIntvl12MinSubIntvl = 'rollingBlock60MinIntvl12MinSubIntvl'
    '''
    60-minute Rolling Block with 12-minute sub-intervals
    '''

    rollingBlock60MinIntvl15MinSubIntvl = 'rollingBlock60MinIntvl15MinSubIntvl'
    '''
    60-minute Rolling Block with 15-minute sub-intervals
    '''

    rollingBlock60MinIntvl20MinSubIntvl = 'rollingBlock60MinIntvl20MinSubIntvl'
    '''
    60-minute Rolling Block with 20-minute sub-intervals
    '''

    rollingBlock60MinIntvl30MinSubIntvl = 'rollingBlock60MinIntvl30MinSubIntvl'
    '''
    60-minute Rolling Block with 30-minute sub-intervals
    '''

    rollingBlock60MinIntvl4MinSubIntvl = 'rollingBlock60MinIntvl4MinSubIntvl'
    '''
    60-minute Rolling Block with 4-minute sub-intervals
    '''

    rollingBlock60MinIntvl5MinSubIntvl = 'rollingBlock60MinIntvl5MinSubIntvl'
    '''
    60-minute Rolling Block with 5-minute sub-intervals
    '''

    rollingBlock60MinIntvl6MinSubIntvl = 'rollingBlock60MinIntvl6MinSubIntvl'
    '''
    60-minute Rolling Block with 6-minute sub-intervals
    '''

    sixtyMinute = 'sixtyMinute'
    '''
    60-minute
    '''

    tenMinute = 'tenMinute'
    '''
    10-minute
    '''

    thirtyMinute = 'thirtyMinute'
    '''
    30-minute
    '''

    threeMinute = 'threeMinute'
    '''
    3-minute
    '''

    twentyMinute = 'twentyMinute'
    '''
    20-minute interval
    '''

    twentyfourHour = 'twentyfourHour'
    '''
    24-hour
    '''

    twoMinute = 'twoMinute'
    '''
    2-minute
    '''

class MediumKind(Enum):
    '''
    Kind of medium.
    '''

    SF6 = 'SF6'
    '''
    '''

    SF6CF4 = 'SF6CF4'
    '''
    '''

    SF6N2 = 'SF6N2'
    '''
    '''

    air = 'air'
    '''
    '''

    gas = 'gas'
    '''
    '''

    liquid = 'liquid'
    '''
    '''

    mineralOil = 'mineralOil'
    '''
    '''

    solid = 'solid'
    '''
    '''

class MeterMultiplierKind(Enum):
    '''
    Kind of meter multiplier.
    '''

    ctRatio = 'ctRatio'
    '''
    Current transformer ratio used to convert associated quantities to real
    measurements.
    '''

    kE = 'kE'
    '''
    Test constant.
    '''

    kH = 'kH'
    '''
    Meter kh (watthour) constant. The number of watthours that must be applied
    to the meter to cause one disk revolution for an electromechanical meter
    or the number of watthours represented by one increment pulse for an electronic
    meter.
    '''

    kR = 'kR'
    '''
    Register multiplier. The number to multiply the register reading by in
    order to get kWh.
    '''

    ptRatio = 'ptRatio'
    '''
    Potential transformer ratio used to convert associated quantities to real
    measurements.
    '''

    transformerRatio = 'transformerRatio'
    '''
    Product of the CT ratio and PT ratio.
    '''

class NotificationTriggerKind(Enum):
    '''
    Kind of trigger to notify customer.
    '''

class OperatingMechanismKind(Enum):
    '''
    '''

class OperationalLimitDirectionKind(Enum):
    '''
    The direction attribute describes the side of a limit that is a violation.
    '''

    absoluteValue = 'absoluteValue'
    '''
    An absoluteValue limit means that a monitored absolute value above the
    limit value is a violation.
    '''

    high = 'high'
    '''
    High means that a monitored value above the limit value is a violation.
    If applied to a terminal flow, the positive direction is into the terminal.
    '''

    low = 'low'
    '''
    Low means a monitored value below the limit is a violation. If applied
    to a terminal flow, the positive direction is into the terminal.
    '''

class PetersenCoilModeKind(Enum):
    '''
    The mode of operation for a Petersen coil.
    '''

    automaticPositioning = 'automaticPositioning'
    '''
    Automatic positioning.
    '''

    fixed = 'fixed'
    '''
    Fixed position.
    '''

    manual = 'manual'
    '''
    Manual positioning.
    '''

class PhaseCode(Enum):
    '''
    An unordered enumeration of phase identifiers. Allows designation of phases
    for both transmission and distribution equipment, circuits and loads. The
    enumeration, by itself, does not describe how the phases are connected
    together or connected to ground. Ground is not explicitly denoted as a
    phase.
    Residential and small commercial loads are often served from single-phase,
    or split-phase, secondary circuits. For example of s12N, phases 1 and 2
    refer to hot wires that are 180 degrees out of phase, while N refers to
    the neutral wire. Through single-phase transformer connections, these secondary
    circuits may be served from one or two of the primary phases A, B, and
    C. For three-phase loads, use the A, B, C phase codes instead of s12N.
    '''

    A = 'A'
    '''
    Phase A.
    '''

    AB = 'AB'
    '''
    Phases A and B.
    '''

    ABC = 'ABC'
    '''
    Phases A, B, and C.
    '''

    ABCN = 'ABCN'
    '''
    Phases A, B, C, and N.
    '''

    ABN = 'ABN'
    '''
    Phases A, B, and neutral.
    '''

    AC = 'AC'
    '''
    Phases A and C.
    '''

    ACN = 'ACN'
    '''
    Phases A, C and neutral.
    '''

    AN = 'AN'
    '''
    Phases A and neutral.
    '''

    B = 'B'
    '''
    Phase B.
    '''

    BC = 'BC'
    '''
    Phases B and C.
    '''

    BCN = 'BCN'
    '''
    Phases B, C, and neutral.
    '''

    BN = 'BN'
    '''
    Phases B and neutral.
    '''

    C = 'C'
    '''
    Phase C.
    '''

    CN = 'CN'
    '''
    Phases C and neutral.
    '''

    N = 'N'
    '''
    Neutral phase.
    '''

    X = 'X'
    '''
    Unknown non-neutral phase.
    '''

    XN = 'XN'
    '''
    Unknown non-neutral phase plus neutral.
    '''

    XY = 'XY'
    '''
    Two unknown non-neutral phases.
    '''

    XYN = 'XYN'
    '''
    Two unknown non-neutral phases plus neutral.
    '''

    none = 'none'
    '''
    No phases specified.
    '''

    s1 = 's1'
    '''
    Secondary phase 1.
    '''

    s12 = 's12'
    '''
    Secondary phase 1 and 2.
    '''

    s12N = 's12N'
    '''
    Secondary phases 1, 2, and neutral.
    '''

    s1N = 's1N'
    '''
    Secondary phase 1 and neutral.
    '''

    s2 = 's2'
    '''
    Secondary phase 2.
    '''

    s2N = 's2N'
    '''
    Secondary phase 2 and neutral.
    '''

class PhaseConnectedFaultKind(Enum):
    '''
    The type of fault connection among phases.
    '''

    lineOpen = 'lineOpen'
    '''
    The fault is when the conductor path is broken between two terminals. Additional
    coexisting faults may be required if the broken conductor also causes connections
    to grounds or other lines or phases.
    '''

    lineToGround = 'lineToGround'
    '''
    The fault connects the indicated phases to ground. The line to line fault
    impedance is not used and assumed infinite. The full ground impedance is
    connected between each phase specified in the fault and ground, but not
    between the phases.
    '''

    lineToLine = 'lineToLine'
    '''
    The fault connects the specified phases together without a connection to
    ground. The ground impedance of this fault is ignored. The line to line
    impedance is connected between each of the phases specified in the fault.
    For example three times for a three phase fault, one time for a two phase
    fault. A single phase fault should not be specified.
    '''

    lineToLineToGround = 'lineToLineToGround'
    '''
    The fault connects the indicated phases to ground and to each other. The
    line to line impedance is connected between each of the phases specified
    in the fault in a full mesh. For example three times for a three phase
    fault, one time for a two phase fault. A single phase fault should not
    be specified. The full ground impedance is connected between each phase
    specified in the fault and ground.
    '''

class PhaseShuntConnectionKind(Enum):
    '''
    The configuration of phase connections for a single terminal device such
    as a load or capacitor.
    '''

    D = 'D'
    '''
    Delta connection.
    '''

    G = 'G'
    '''
    Ground connection; use when explicit connection to ground needs to be expressed
    in combination with the phase code, such as for electrical wire/cable or
    for meters.
    '''

    I = 'I'
    '''
    Independent winding, for single-phase connections.
    '''

    Y = 'Y'
    '''
    Wye connection.
    '''

    Yn = 'Yn'
    '''
    Wye, with neutral brought out for grounding.
    '''

class ProcedureKind(Enum):
    '''
    Other procedure.
    '''

class RandomisationKind(Enum):
    '''
    End time of an event or control action affecting one or more devices is
    randomised to prevent simultaneous operation.
    '''

class ReadingReasonKind(Enum):
    '''
    Reading(s) taken or to be taken in response to a billing-related inquiry
    by a customer or other party. A variant of 'inquiry'.
    '''

class RegulatingControlModeKind(Enum):
    '''
    The kind of regulation model. For example regulating voltage, reactive
    power, active power, etc.
    '''

    activePower = 'activePower'
    '''
    Active power is specified.
    '''

    admittance = 'admittance'
    '''
    Admittance is specified.
    '''

    currentFlow = 'currentFlow'
    '''
    Current flow is specified.
    '''

    powerFactor = 'powerFactor'
    '''
    Power factor is specified.
    '''

    reactivePower = 'reactivePower'
    '''
    Reactive power is specified.
    '''

    temperature = 'temperature'
    '''
    Control switches on/off based on the local temperature (i.e., a thermostat).
    '''

    timeScheduled = 'timeScheduled'
    '''
    Control switches on/off by time of day. The times may change on the weekend,
    or in different seasons.
    '''

    voltage = 'voltage'
    '''
    Voltage is specified.
    '''

class ReportingMethodKind(Enum):
    '''
    Station must be physically visited to gather observations.
    '''

class SVCControlMode(Enum):
    '''
    Static VAr Compensator control mode.
    '''

    reactivePower = 'reactivePower'
    '''
    '''

    voltage = 'voltage'
    '''
    '''

class ScaleKind(Enum):
    '''
    '''

class SealConditionKind(Enum):
    '''
    Seal is missing.
    '''

class SealKind(Enum):
    '''
    Kind of seal.
    '''

class ServiceKind(Enum):
    '''
    Kind of service.
    '''

    air = 'air'
    '''
    Air service.
    '''

    electricity = 'electricity'
    '''
    Electricity service.
    '''

    gas = 'gas'
    '''
    Gas service.
    '''

    heat = 'heat'
    '''
    Heat service.
    '''

    heatingFluid = 'heatingFluid'
    '''
    Heating fluid service.
    '''

    internet = 'internet'
    '''
    Internet service.
    '''

    naturalGas = 'naturalGas'
    '''
    Natural gas service.
    '''

    other = 'other'
    '''
    Other kind of service.
    '''

    propane = 'propane'
    '''
    Propane service.
    '''

    rates = 'rates'
    '''
    Rates (e.g. tax, charge, toll, duty, tariff, etc.) service.
    '''

    refuse = 'refuse'
    '''
    Refuse (waster) service.
    '''

    sewerage = 'sewerage'
    '''
    Sewerage service.
    '''

    steam = 'steam'
    '''
    Steam service.
    '''

    time = 'time'
    '''
    Time service.
    '''

    tvLicence = 'tvLicence'
    '''
    TV license service.
    '''

    water = 'water'
    '''
    Water service.
    '''

class ServiceMultiplierKind(Enum):
    '''
    Voltage transformer ratio used to convert associated quantities to real
    measurements.
    '''

class ShortCircuitRotorKind(Enum):
    '''
    Type of rotor, used by short circuit applications.
    '''

    salientPole1 = 'salientPole1'
    '''
    Salient pole 1 in the IEC 60909
    '''

    salientPole2 = 'salientPole2'
    '''
    Salient pole 2 in IEC 60909
    '''

    turboSeries1 = 'turboSeries1'
    '''
    Turbo Series 1 in the IEC 60909
    '''

    turboSeries2 = 'turboSeries2'
    '''
    Turbo series 2 in IEC 60909
    '''

class SinglePhaseKind(Enum):
    '''
    Enumeration of single phase identifiers. Allows designation of single phases
    for both transmission and distribution equipment, circuits and loads.
    '''

    A = 'A'
    '''
    Phase A.
    '''

    B = 'B'
    '''
    Phase B.
    '''

    C = 'C'
    '''
    Phase C.
    '''

    N = 'N'
    '''
    Neutral.
    '''

    s1 = 's1'
    '''
    Secondary phase 1.
    '''

    s2 = 's2'
    '''
    Secondary phase 2.
    '''

class SmartInverterMode(Enum):
    '''
    '''

    constantPF = 'constantPF'
    '''
    '''

    constantPQ = 'constantPQ'
    '''
    Required to dispatch P and Q
    '''

    loadFollowing = 'loadFollowing'
    '''
    For batteries
    '''

    voltVar = 'voltVar'
    '''
    Default IEEE 1547-2018
    '''

    voltWatt = 'voltWatt'
    '''
    Default IEEE 1547-2018
    '''

class SynchronousMachineKind(Enum):
    '''
    Synchronous machine type.
    '''

    condenser = 'condenser'
    '''
    '''

    generator = 'generator'
    '''
    '''

    generatorOrCondenser = 'generatorOrCondenser'
    '''
    '''

    generatorOrCondenserOrMotor = 'generatorOrCondenserOrMotor'
    '''
    '''

    generatorOrMotor = 'generatorOrMotor'
    '''
    '''

    motor = 'motor'
    '''
    '''

    motorOrCondenser = 'motorOrCondenser'
    '''
    '''

class SynchronousMachineOperatingMode(Enum):
    '''
    Synchronous machine operating mode.
    '''

    condenser = 'condenser'
    '''
    '''

    generator = 'generator'
    '''
    '''

    motor = 'motor'
    '''
    '''

class TestKind(Enum):
    '''
    The test applied to determine if the condition is met.
    '''

    equalTo = 'equalTo'
    '''
    '''

    greaterThan = 'greaterThan'
    '''
    '''

    greaterThanOrEqualTo = 'greaterThanOrEqualTo'
    '''
    '''

    lessThan = 'lessThan'
    '''
    '''

    lessThanOrEqualTo = 'lessThanOrEqualTo'
    '''
    '''

class ThermostatControlMode(Enum):
    '''
    '''

    Cooling = 'Cooling'
    '''
    '''

    Heating = 'Heating'
    '''
    '''

class TimeIntervalKind(Enum):
    '''
    '''

    D = 'D'
    '''
    '''

    M = 'M'
    '''
    '''

    Y = 'Y'
    '''
    '''

    h = 'h'
    '''
    '''

    m = 'm'
    '''
    '''

    s = 's'
    '''
    '''

class TransformerApplicationKind(Enum):
    '''
    Classifications of network roles in which transformers can be deployed.
    The classifications are intended to reflect both criticality of transformer
    in network operations and typical usage experienced by transformer.
    Note: This enumeration provides essential information to asset health analytics.
    The existing list is a starting point and is anticipated to be fleshed
    out further as requirements are better understood (PAB 2016/01/09).
    '''

    distribution = 'distribution'
    '''
    '''

    generatorStepUp = 'generatorStepUp'
    '''
    '''

    transmissionBusToBus = 'transmissionBusToBus'
    '''
    '''

    transmissionBusToDistribution = 'transmissionBusToDistribution'
    '''
    '''

class TransformerControlMode(Enum):
    '''
    Control modes for a transformer.
    '''

    reactive = 'reactive'
    '''
    Reactive power flow control
    '''

    volt = 'volt'
    '''
    Voltage control
    '''

class UnitMultiplier(Enum):
    '''
    The unit multipliers defined for the CIM. When applied to unit symbols,
    the unit symbol is treated as a derived unit. Regardless of the contents
    of the unit symbol text, the unit symbol shall be treated as if it were
    a single-character unit symbol. Unit symbols should not contain multipliers,
    and it should be left to the multiplier to define the multiple for an entire
    data type.
    For example, if a unit symbol is "A2Perh" and the multiplier is "k", then
    the value is k(A^2/h), and the multiplier applies to the entire final value,
    not to any individual part of the value. This can be conceptualized by
    substituting a derived unit symbol for the unit type. If one imagines that
    the symbol "Þ" represents the derived unit "A2Perh", then applying the
    multiplier "k" can be conceptualized simply as "kÞ".
    For example, the SI unit for mass is "kg" and not "g". If the unit symbol
    is defined as "kg", then the multiplier is applied to "kg" as a whole and
    does not replace the "k" in front of the "g". In this case, the multiplier
    of "m" would be used with the unit symbol of "kg" to represent one gram.
    As a text string, this violates the instructions in IEC 80000-1. However,
    because the unit symbol in CIM is treated as a derived unit instead of
    as an SI unit, it makes more sense to conceptualize the "kg" as if it were
    replaced by one of the proposed replacements for the SI mass symbol. If
    one imagines that the "kg" were replaced by a symbol "Þ", then it is easier
    to conceptualize the multiplier "m" as creating the proper unit "mÞ", and
    not the forbidden unit "mkg".
    '''

    E = 'E'
    '''
    Exa 10**18.
    '''

    G = 'G'
    '''
    Giga 10**9.
    '''

    M = 'M'
    '''
    Mega 10**6.
    '''

    P = 'P'
    '''
    Peta 10**15
    '''

    T = 'T'
    '''
    Tera 10**12.
    '''

    Y = 'Y'
    '''
    Yotta 10**24
    '''

    Z = 'Z'
    '''
    Zetta 10**21
    '''

    a = 'a'
    '''
    atto 10**-18.
    '''

    c = 'c'
    '''
    Centi 10**-2.
    '''

    d = 'd'
    '''
    Deci 10**-1.
    '''

    da = 'da'
    '''
    deca 10**1.
    '''

    f = 'f'
    '''
    femto 10**-15.
    '''

    h = 'h'
    '''
    hecto 10**2.
    '''

    k = 'k'
    '''
    Kilo 10**3.
    '''

    m = 'm'
    '''
    Milli 10**-3.
    '''

    micro = 'micro'
    '''
    Micro 10**-6.
    '''

    n = 'n'
    '''
    Nano 10**-9.
    '''

    none = 'none'
    '''
    No multiplier or equivalently multiply by 1.
    '''

    p = 'p'
    '''
    Pico 10**-12.
    '''

    y = 'y'
    '''
    yocto 10**-24.
    '''

    z = 'z'
    '''
    zepto 10**-21.
    '''

class UnitSymbol(Enum):
    '''
    The derived units defined for usage in the CIM. In some cases, the derived
    unit is equal to an SI unit. Whenever possible, the standard derived symbol
    is used instead of the formula for the derived unit. For example, the unit
    symbol Farad is defined as "F" instead of "CPerV". In cases where a standard
    symbol does not exist for a derived unit, the formula for the unit is used
    as the unit symbol. For example, density does not have a standard symbol
    and so it is represented as "kgPerm3". With the exception of the "kg",
    which is an SI unit, the unit symbols do not contain multipliers and therefore
    represent the base derived unit to which a multiplier can be applied as
    a whole.
    Every unit symbol is treated as an unparseable text as if it were a single-letter
    symbol. The meaning of each unit symbol is defined by the accompanying
    descriptive text and not by the text contents of the unit symbol.
    To allow the widest possible range of serializations without requiring
    special character handling, several substitutions are made which deviate
    from the format described in IEC 80000-1. The division symbol "/" is replaced
    by the letters"Per". Exponents are written in plain text after the unit
    as "m3" instead of being formatted as in "m<sup>3</sup>" or introducing
    a symbol as in "m^3". The degree symbol "°" is replaced with the letters
    "deg". Any clarification of the meaning for a substitution is included
    in the description for the unit symbol.
    Non-SI units are included in list of unit symbols to allow sources of data
    to be correctly labeled with their non-SI units (for example, a GPS sensor
    that is reporting numbers that represent feet instead of meters). This
    allows software to use the unit symbol information correctly convert and
    scale the raw data of those sources into SI-based units.
    '''

    A = 'A'
    '''
    Current in Ampere.
    '''

    A2 = 'A2'
    '''
    Ampere squared (A²).
    '''

    A2h = 'A2h'
    '''
    ampere-squared hour, Ampere-squared hour.
    '''

    A2s = 'A2s'
    '''
    Ampere squared time in square ampere (A²s).
    '''

    APerA = 'APerA'
    '''
    Current, Ratio of Amperages Note: Users may need to supply a prefix such
    as ‘m’ to show rates such as ‘mA/A’.
    '''

    APerm = 'APerm'
    '''
    A/m, magnetic field strength, Ampere per metre.
    '''

    Ah = 'Ah'
    '''
    Ampere-hours, Ampere-hours.
    '''

    As = 'As'
    '''
    Ampere seconds (A·s).
    '''

    Bq = 'Bq'
    '''
    Radioactivity in Becquerel (1/s).
    '''

    Btu = 'Btu'
    '''
    Energy, British Thermal Unit.
    '''

    C = 'C'
    '''
    Electric charge in Coulomb (A·s).
    '''

    CPerkg = 'CPerkg'
    '''
    exposure (x rays), Coulomb per kilogram.
    '''

    CPerm2 = 'CPerm2'
    '''
    surface charge density, Coulomb per square metre.
    '''

    CPerm3 = 'CPerm3'
    '''
    electric charge density, Coulomb per cubic metre.
    '''

    F = 'F'
    '''
    Electric capacitance in Farad (C/V).
    '''

    FPerm = 'FPerm'
    '''
    permittivity, Farad per metre.
    '''

    G = 'G'
    '''
    Magnetic flux density, Gauss (1 G = 10-4 T).
    '''

    Gy = 'Gy'
    '''
    Absorbed dose in Gray (J/kg).
    '''

    GyPers = 'GyPers'
    '''
    absorbed dose rate, Gray per second.
    '''

    H = 'H'
    '''
    Electric inductance in Henry (Wb/A).
    '''

    HPerm = 'HPerm'
    '''
    permeability, Henry per metre.
    '''

    Hz = 'Hz'
    '''
    Frequency in Hertz (1/s).
    '''

    HzPerHz = 'HzPerHz'
    '''
    Frequency, Rate of frequency change Note: Users may need to supply a prefix
    such as ‘m’ to show rates such as ‘mHz/Hz’.
    '''

    HzPers = 'HzPers'
    '''
    Rate of change of frequency in Hertz per second.
    '''

    J = 'J'
    '''
    Energy in joule (N·m = C·V = W·s).
    '''

    JPerK = 'JPerK'
    '''
    Heat capacity in Joule/Kelvin.
    '''

    JPerkg = 'JPerkg'
    '''
    Specific energy, Joule / kg.
    '''

    JPerkgK = 'JPerkgK'
    '''
    Specific heat capacity, specific entropy, Joule per kilogram Kelvin.
    '''

    JPerm2 = 'JPerm2'
    '''
    Insulation energy density, Joule per square metre or watt second per square
    metre.
    '''

    JPerm3 = 'JPerm3'
    '''
    energy density, Joule per cubic metre.
    '''

    JPermol = 'JPermol'
    '''
    molar energy, Joule per mole.
    '''

    JPermolK = 'JPermolK'
    '''
    molar entropy, molar heat capacity, Joule per mole kelvin.
    '''

    JPers = 'JPers'
    '''
    Energy rate joule per second (J/s),
    '''

    K = 'K'
    '''
    Temperature in Kelvin.
    '''

    KPers = 'KPers'
    '''
    Temperature change rate in Kelvin per second.
    '''

    M = 'M'
    '''
    Length, nautical mile (1 M = 1852 m).
    '''

    Mx = 'Mx'
    '''
    Magnetic flux, Maxwell (1 Mx = 10-8 Wb).
    '''

    N = 'N'
    '''
    Force in Newton (kg·m/s²).
    '''

    NPerm = 'NPerm'
    '''
    Surface tension, Newton per metre.
    '''

    Nm = 'Nm'
    '''
    Moment of force, Newton metre.
    '''

    Oe = 'Oe'
    '''
    Magnetic field, Œrsted (1 Oe = (103/4p) A/m).
    '''

    Pa = 'Pa'
    '''
    Pressure in Pascal (N/m²). Note: the absolute or relative measurement of
    pressure is implied with this entry. See below for more explicit forms.
    '''

    PaPers = 'PaPers'
    '''
    Pressure change rate in Pascal per second.
    '''

    Pas = 'Pas'
    '''
    Dynamic viscosity, Pascal second.
    '''

    Q = 'Q'
    '''
    Quantity power, Q.
    '''

    Qh = 'Qh'
    '''
    Quantity energy, Qh.
    '''

    S = 'S'
    '''
    Conductance in Siemens.
    '''

    SPerm = 'SPerm'
    '''
    Conductance per length (F/m).
    '''

    Sv = 'Sv'
    '''
    Dose equivalent in Sievert (J/kg).
    '''

    T = 'T'
    '''
    Magnetic flux density in Tesla (Wb/m2).
    '''

    V = 'V'
    '''
    Electric potential in Volt (W/A).
    '''

    V2 = 'V2'
    '''
    Volt squared (W²/A²).
    '''

    V2h = 'V2h'
    '''
    volt-squared hour, Volt-squared-hours.
    '''

    VA = 'VA'
    '''
    Apparent power in Volt Ampere (See also real power and reactive power.)
    '''

    VAh = 'VAh'
    '''
    Apparent energy in Volt Ampere hours.
    '''

    VAr = 'VAr'
    '''
    Reactive power in Volt Ampere reactive. The “reactive” or “imaginary” component
    of electrical power (VIsin(phi)). (See also real power and apparent power).
    Note: Different meter designs use different methods to arrive at their
    results. Some meters may compute reactive power as an arithmetic value,
    while others compute the value vectorially. The data consumer should determine
    the method in use and the suitability of the measurement for the intended
    purpose.
    '''

    VArh = 'VArh'
    '''
    Reactive energy in Volt Ampere reactive hours.
    '''

    VPerHz = 'VPerHz'
    '''
    Magnetic flux in Volt per Hertz.
    '''

    VPerV = 'VPerV'
    '''
    Voltage, Ratio of voltages Note: Users may need to supply a prefix such
    as ‘m’ to show rates such as ‘mV/V’.
    '''

    VPerVA = 'VPerVA'
    '''
    Power factor, PF, the ratio of the active power to the apparent power.
    Note: The sign convention used for power factor will differ between IEC
    meters and EEI (ANSI) meters. It is assumed that the data consumers understand
    the type of meter being used and agree on the sign convention in use at
    any given utility.
    '''

    VPerVAr = 'VPerVAr'
    '''
    Power factor, PF, the ratio of the active power to the apparent power.
    Note: The sign convention used for power factor will differ between IEC
    meters and EEI (ANSI) meters. It is assumed that the data consumers understand
    the type of meter being used and agree on the sign convention in use at
    any given utility.
    '''

    VPerm = 'VPerm'
    '''
    electric field strength, Volt per metre.
    '''

    Vh = 'Vh'
    '''
    Volt-hour, Volt hours.
    '''

    Vs = 'Vs'
    '''
    Volt second (Ws/A).
    '''

    W = 'W'
    '''
    Real power in Watt (J/s). Electrical power may have real and reactive components.
    The real portion of electrical power (I²R or VIcos(phi)), is expressed
    in Watts. (See also apparent power and reactive power.)
    '''

    WPerA = 'WPerA'
    '''
    Active power per current flow, watt per Ampere.
    '''

    WPerW = 'WPerW'
    '''
    Signal Strength, Ratio of power Note: Users may need to supply a prefix
    such as ‘m’ to show rates such as ‘mW/W’.
    '''

    WPerm2 = 'WPerm2'
    '''
    Heat flux density, irradiance, Watt per square metre.
    '''

    WPerm2sr = 'WPerm2sr'
    '''
    radiance, Watt per square metre steradian.
    '''

    WPermK = 'WPermK'
    '''
    Thermal conductivity in Watt/metre Kelvin.
    '''

    WPers = 'WPers'
    '''
    Ramp rate in Watt per second.
    '''

    WPersr = 'WPersr'
    '''
    Radiant intensity, Watt per steradian.
    '''

    Wb = 'Wb'
    '''
    Magnetic flux in Weber (V·s).
    '''

    Wh = 'Wh'
    '''
    Real energy in Watt hours.
    '''

    anglemin = 'anglemin'
    '''
    Plane angle, minute.
    '''

    anglesec = 'anglesec'
    '''
    Plane angle, second.
    '''

    bar = 'bar'
    '''
    Pressure, bar (1 bar = 100 kPa).
    '''

    cd = 'cd'
    '''
    Luminous intensity in candela.
    '''

    charPers = 'charPers'
    '''
    Data rate (baud) in characters per second.
    '''

    character = 'character'
    '''
    Number of characters.
    '''

    cosPhi = 'cosPhi'
    '''
    Power factor, dimensionless.
    Note 1: This definition of power factor only holds for balanced systems.
    See the alternative definition under code 153.
    Note 2 : Beware of differing sign conventions in use between the IEC and
    EEI. It is assumed that the data consumer understands the type of meter
    in use and the sign convention in use by the utility.
    '''

    count = 'count'
    '''
    Amount of substance, Counter value.
    '''

    d = 'd'
    '''
    Time, day = 24 h = 86400 s.
    '''

    dB = 'dB'
    '''
    Sound pressure level in decibel. Note: multiplier “d” is included in this
    unit symbol for compatibility with IEC 61850-7-3.
    '''

    dBm = 'dBm'
    '''
    Power level (logrithmic ratio of signal strength , Bel-mW), normalized
    to 1mW. Note: multiplier “d” is included in this unit symbol for compatibility
    with IEC 61850-7-3.
    '''

    deg = 'deg'
    '''
    Plane angle in degrees.
    '''

    degC = 'degC'
    '''
    Relative temperature in degrees Celsius.
    In the SI unit system the symbol is ºC. Electric charge is measured in
    coulomb that has the unit symbol C. To distinguish degree Celsius form
    coulomb the symbol used in the UML is degC. Reason for not using ºC is
    the special character º is difficult to manage in software.
    '''

    ft3 = 'ft3'
    '''
    Volume, cubic foot.
    '''

    gPerg = 'gPerg'
    '''
    Concentration, The ratio of the mass of a solute divided by the mass of
    the solution. Note: Users may need use a prefix such a ‘µ’ to express a
    quantity such as ‘µg/g’.
    '''

    gal = 'gal'
    '''
    Volume, US gallon (1 gal = 231 in3 = 128 fl ounce).
    '''

    h = 'h'
    '''
    Time, hour = 60 min = 3600 s.
    '''

    ha = 'ha'
    '''
    Area, hectare.
    '''

    kat = 'kat'
    '''
    Catalytic activity, katal = mol / s.
    '''

    katPerm3 = 'katPerm3'
    '''
    catalytic activity concentration, katal per cubic metre.
    '''

    kg = 'kg'
    '''
    Mass in kilogram. Note: multiplier “k” is included in this unit symbol
    for compatibility with IEC 61850-7-3.
    '''

    kgPerJ = 'kgPerJ'
    '''
    Weigh per energy in kilogram/joule (kg/J). Note: multiplier “k” is included
    in this unit symbol for compatibility with IEC 61850-7-3.
    '''

    kgPerm3 = 'kgPerm3'
    '''
    Density in kilogram/cubic metre (kg/m³). Note: multiplier “k” is included
    in this unit symbol for compatibility with IEC 61850-7-3.
    '''

    kgm = 'kgm'
    '''
    Moment of mass in kilogram metre (kg·m) (first moment of mass). Note: multiplier
    “k” is included in this unit symbol for compatibility with IEC 61850-7-3.
    '''

    kgm2 = 'kgm2'
    '''
    Moment of mass in kilogram square metre (kg·m²) (Second moment of mass,
    commonly called the moment of inertia). Note: multiplier “k” is included
    in this unit symbol for compatibility with IEC 61850-7-3.
    '''

    kn = 'kn'
    '''
    Speed, knot (1 kn = 1852/3600) m/s.
    '''

    l = 'l'
    '''
    Volume, litre = dm3 = m3/1000.
    '''

    lPerh = 'lPerh'
    '''
    Volumetric flow rate, litre per hour.
    '''

    lPerl = 'lPerl'
    '''
    Concentration, The ratio of the volume of a solute divided by the volume
    of the solution. Note: Users may need use a prefix such a ‘µ’ to express
    a quantity such as ‘µL/L’.
    '''

    lPers = 'lPers'
    '''
    Volumetric flow rate in litre per second.
    '''

    lm = 'lm'
    '''
    Luminous flux in lumen (cd·sr).
    '''

    lx = 'lx'
    '''
    Illuminance in lux (lm/m²).
    '''

    m = 'm'
    '''
    Length in meter.
    '''

    m2 = 'm2'
    '''
    Area in square metre (m²).
    '''

    m2Pers = 'm2Pers'
    '''
    Viscosity in metre square / second (m²/s).
    '''

    m3 = 'm3'
    '''
    Volume in cubic metre (m³).
    '''

    m3Compensated = 'm3Compensated'
    '''
    Volume, cubic metre, with the value compensated for weather effects.
    '''

    m3Perh = 'm3Perh'
    '''
    Volumetric flow rate, cubic metre per hour.
    '''

    m3Perkg = 'm3Perkg'
    '''
    Specific volume, cubic metre per kilogram, v.
    '''

    m3Pers = 'm3Pers'
    '''
    Volumetric flow rate in cubic metres per second (m³/s).
    '''

    m3Uncompensated = 'm3Uncompensated'
    '''
    Volume, cubic metre, with the value uncompensated for weather effects.
    '''

    mPerm3 = 'mPerm3'
    '''
    Fuel efficiency in metre per cubic metre (m/m³).
    '''

    mPers = 'mPers'
    '''
    Velocity in metre per second (m/s).
    '''

    mPers2 = 'mPers2'
    '''
    Acceleration in metre per second squared (m/s²).
    '''

    min = 'min'
    '''
    Time, minute = 60 s.
    '''

    mmHg = 'mmHg'
    '''
    Pressure, millimeter of mercury (1 mmHg is approximately 133.3 Pa).
    '''

    mol = 'mol'
    '''
    Amount of substance in mole.
    '''

    molPerkg = 'molPerkg'
    '''
    Concentration, Molality, the amount of solute in moles and the amount of
    solvent in kilograms.
    '''

    molPerm3 = 'molPerm3'
    '''
    Concentration, The amount of substance concentration, (c), the amount of
    solvent in moles divided by the volume of solution in m³.
    '''

    molPermol = 'molPermol'
    '''
    Concentration, Molar fraction (?), the ratio of the molar amount of a solute
    divided by the molar amount of the solution.
    '''

    none = 'none'
    '''
    Dimension less quantity, e.g. count, per unit, etc.
    '''

    ohm = 'ohm'
    '''
    Electric resistance in ohm (V/A).
    '''

    ohmPerm = 'ohmPerm'
    '''
    Electric resistance per length in ohm per metre ((V/A)/m).
    '''

    ohmm = 'ohmm'
    '''
    resistivity, Ohm metre, (rho).
    '''

    onePerHz = 'onePerHz'
    '''
    Reciprocal of frequency (1/Hz).
    '''

    onePerm = 'onePerm'
    '''
    Wavenumber, reciprocal metre, (1/m).
    '''

    ppm = 'ppm'
    '''
    Concentration in parts per million.
    '''

    rad = 'rad'
    '''
    Plane angle in radian (m/m).
    '''

    radPers = 'radPers'
    '''
    Angular velocity in radians per second (rad/s).
    '''

    radPers2 = 'radPers2'
    '''
    Angular acceleration, radian per second squared.
    '''

    rev = 'rev'
    '''
    Amount of rotation, Revolutions.
    '''

    rotPers = 'rotPers'
    '''
    Rotations per second (1/s). See also Hz (1/s).
    '''

    s = 's'
    '''
    Time in seconds.
    '''

    sPers = 'sPers'
    '''
    Time, Ratio of time Note: Users may need to supply a prefix such as ‘µ’
    to show rates such as ‘µs/s’
    '''

    sr = 'sr'
    '''
    Solid angle in steradian (m2/m2).
    '''

    therm = 'therm'
    '''
    Energy, Therm.
    '''

    tonne = 'tonne'
    '''
    mass, “tonne” or “metric ton” (1000 kg = 1 Mg).
    '''

class UsagePointConnectedKind(Enum):
    '''
    State of the usage point with respect to connection to the network.
    '''

    connected = 'connected'
    '''
    The usage point is connected to the network and able to receive or send
    the applicable commodity (electricity, gas, water, etc.).
    '''

    logicallyDisconnected = 'logicallyDisconnected'
    '''
    The usage point has been disconnected through operation of a disconnect
    function within the meter present at the usage point. The usage point is
    unable to receive or send the applicable commodity (electricity, gas, water,
    etc.) A logical disconnect can often be achieved without utilising a field
    crew.
    '''

    physicallyDisconnected = 'physicallyDisconnected'
    '''
    The usage point has been disconnected from the network at a point upstream
    of the meter. The usage point is unable to receive or send the applicable
    commodity (electricity, gas, water, etc.). A physical disconnect is often
    achieved by utilising a field crew.
    '''

class Validity(Enum):
    '''
    Validity for MeasurementValue.
    '''

    GOOD = 'GOOD'
    '''
    The value is marked good if no abnormal condition of the acquisition function
    or the information source is detected.
    '''

    INVALID = 'INVALID'
    '''
    The value is marked invalid when a supervision function recognises abnormal
    conditions of the acquisition function or the information source (missing
    or non-operating updating devices). The value is not defined under this
    condition. The mark invalid is used to indicate to the client that the
    value may be incorrect and shall not be used.
    '''

    QUESTIONABLE = 'QUESTIONABLE'
    '''
    The value is marked questionable if a supervision function detects an abnormal
    behaviour, however the value could still be valid. The client is responsible
    for determining whether or not values marked "questionable" should be used.
    '''

class WindGenUnitKind(Enum):
    '''
    Kind of wind generating unit.
    '''

    offshore = 'offshore'
    '''
    The wind generating unit is located offshore.
    '''

    onshore = 'onshore'
    '''
    The wind generating unit is located onshore.
    '''

class WindingConnection(Enum):
    '''
    Winding connection type.
    '''

    A = 'A'
    '''
    Autotransformer common winding
    '''

    D = 'D'
    '''
    Delta
    '''

    I = 'I'
    '''
    Independent winding, for single-phase connections
    '''

    Y = 'Y'
    '''
    Wye
    '''

    Yn = 'Yn'
    '''
    Wye, with neutral brought out for grounding.
    '''

    Z = 'Z'
    '''
    ZigZag
    '''

    Zn = 'Zn'
    '''
    ZigZag, with neutral brought out for grounding.
    '''

class WireInsulationKind(Enum):
    '''
    Kind of wire insulation.
    '''

    asbestosAndVarnishedCambric = 'asbestosAndVarnishedCambric'
    '''
    Asbestos and varnished cambric wire insulation.
    '''

    beltedPilc = 'beltedPilc'
    '''
    Belted pilc wire insulation.
    '''

    butyl = 'butyl'
    '''
    Butyl wire insulation.
    '''

    crosslinkedPolyethylene = 'crosslinkedPolyethylene'
    '''
    Crosslinked polyethylene wire insulation.
    '''

    ethylenePropyleneRubber = 'ethylenePropyleneRubber'
    '''
    Ethylene propylene rubber wire insulation.
    '''

    highMolecularWeightPolyethylene = 'highMolecularWeightPolyethylene'
    '''
    High nolecular weight polyethylene wire insulation.
    '''

    highPressureFluidFilled = 'highPressureFluidFilled'
    '''
    High pressure fluid filled wire insulation.
    '''

    lowCapacitanceRubber = 'lowCapacitanceRubber'
    '''
    Low capacitance rubber wire insulation.
    '''

    oilPaper = 'oilPaper'
    '''
    Oil paper wire insulation.
    '''

    other = 'other'
    '''
    Other kind of wire insulation.
    '''

    ozoneResistantRubber = 'ozoneResistantRubber'
    '''
    Ozone resistant rubber wire insulation.
    '''

    rubber = 'rubber'
    '''
    Rubber wire insulation.
    '''

    siliconRubber = 'siliconRubber'
    '''
    Silicon rubber wire insulation.
    '''

    treeResistantHighMolecularWeightPolyethylene = 'treeResistantHighMolecularWeightPolyethylene'
    '''
    Tree resistant high molecular weight polyethylene wire insulation.
    '''

    treeRetardantCrosslinkedPolyethylene = 'treeRetardantCrosslinkedPolyethylene'
    '''
    Tree retardant crosslinked polyethylene wire insulation.
    '''

    unbeltedPilc = 'unbeltedPilc'
    '''
    Unbelted pilc wire insulation.
    '''

    varnishedCambricCloth = 'varnishedCambricCloth'
    '''
    Varnished cambric cloth wire insulation.
    '''

    varnishedDacronGlass = 'varnishedDacronGlass'
    '''
    Varnished dacron glass wire insulation.
    '''

class WireMaterialKind(Enum):
    '''
    Kind of wire material.
    '''

    aaac = 'aaac'
    '''
    Aluminum-alloy conductor steel reinforced.
    '''

    acsr = 'acsr'
    '''
    Aluminum conductor steel reinforced.
    '''

    aluminum = 'aluminum'
    '''
    Aluminum wire.
    '''

    aluminumAlloy = 'aluminumAlloy'
    '''
    Aluminum-alloy wire.
    '''

    aluminumAlloySteel = 'aluminumAlloySteel'
    '''
    Aluminum-alloy-steel wire.
    '''

    aluminumSteel = 'aluminumSteel'
    '''
    Aluminum-steel wire.
    '''

    copper = 'copper'
    '''
    Copper wire.
    '''

    other = 'other'
    '''
    Other wire material.
    '''

    steel = 'steel'
    '''
    Steel wire.
    '''

class WireUsageKind(Enum):
    '''
    Kind of wire usage.
    '''

    distribution = 'distribution'
    '''
    Wire is used in medium voltage network.
    '''

    other = 'other'
    '''
    Other kind of wire usage.
    '''

    secondary = 'secondary'
    '''
    Wire is used in low voltage circuit.
    '''

    transmission = 'transmission'
    '''
    Wire is used in extra-high voltage or high voltage network.
    '''

@dataclass
class MonthDay():
    value: str = field(default=None)
    '''
    MonthDay format as "--mm-dd", which conforms with XSD data type gMonthDay.
    '''

@dataclass
class Susceptance():
    value: float = field(default=None)
    '''
    Imaginary part of admittance.
    '''

@dataclass
class Pressure():
    value: float = field(default=None)
    '''
    Pressure in Pascal.
    '''

@dataclass
class Hours():
    value: float = field(default=None)
    '''
    Time specified in hours.
    '''

@dataclass
class Capacitance():
    value: float = field(default=None)
    '''
    Capacitive part of reactance (imaginary part of impedance), at rated frequency.
    '''

@dataclass
class Voltage():
    value: float = field(default=None)
    '''
    Electrical voltage, can be both AC and DC.
    '''

@dataclass
class SusceptancePerLength():
    value: float = field(default=None)
    '''
    Imaginary part of admittance per unit of length.
    '''

@dataclass
class Frequency():
    value: float = field(default=None)
    '''
    Cycles per second.
    '''

@dataclass
class PU():
    value: float = field(default=None)
    '''
    Per Unit - a positive or negative value referred to a defined base. Values
    typically range from -10 to +10.
    '''

@dataclass
class CalculationIntervalUnitKind():
    value: str = field(default=None)
    '''
    '''

@dataclass
class Minutes():
    value: float = field(default=None)
    '''
    Time in minutes.
    '''

@dataclass
class AngleDegrees():
    value: float = field(default=None)
    '''
    Measurement of angle in degrees.
    '''

@dataclass
class ActivePowerChangeRate():
    value: float = field(default=None)
    '''
    Rate of change of active power per time.
    '''

@dataclass
class RotationSpeed():
    value: float = field(default=None)
    '''
    Number of revolutions per second.
    '''

@dataclass
class RealEnergy():
    value: float = field(default=None)
    '''
    Real electrical energy.
    '''

@dataclass
class VolumeFlowRate():
    value: float = field(default=None)
    '''
    Volume per time.
    '''

@dataclass
class StructureMaterialKind():
    value: str = field(default=None)
    '''
    '''

@dataclass
class CostPerHeatUnit():
    value: float = field(default=None)
    '''
    Cost, in units of currency, per quantity of heat generated.
    '''

@dataclass
class Money():
    value: str = field(default=None)
    '''
    Amount of money.
    '''

@dataclass
class Area():
    value: float = field(default=None)
    '''
    Area.
    '''

@dataclass
class AnchorKind():
    value: str = field(default=None)
    '''
    '''

@dataclass
class Volume():
    value: float = field(default=None)
    '''
    Volume.
    '''

@dataclass
class CostPerEnergyUnit():
    value: float = field(default=None)
    '''
    Cost, in units of currency, per quantity of electrical energy generated.
    '''

@dataclass
class KiloActivePower():
    value: float = field(default=None)
    '''
    Active power in kilowatts.
    '''

@dataclass
class Displacement():
    value: float = field(default=None)
    '''
    Unit of displacement relative a reference position, hence can be negative.
    '''

@dataclass
class ApparentPower():
    value: float = field(default=None)
    '''
    Product of the RMS value of the voltage and the RMS value of the current.
    '''

@dataclass
class CurrentFlow():
    value: float = field(default=None)
    '''
    Electrical current with sign convention: positive flow is out of the conducting
    equipment into the connectivity node. Can be both AC and DC.
    '''

@dataclass
class Source():
    value: str = field(default=None)
    '''
    '''

@dataclass
class ReactivePower():
    value: float = field(default=None)
    '''
    Product of RMS value of the voltage and the RMS value of the quadrature
    component of the current.
    '''

@dataclass
class Temperature():
    value: float = field(default=None)
    '''
    Value of temperature in degrees Celsius.
    '''

@dataclass
class Seconds():
    value: float = field(default=None)
    '''
    Time, in seconds.
    '''

@dataclass
class ActivePowerPerFrequency():
    value: float = field(default=None)
    '''
    Active power variation with frequency.
    '''

@dataclass
class Emission():
    value: float = field(default=None)
    '''
    Quantity of emission per fuel heat content.
    '''

@dataclass
class VoltagePerReactivePower():
    value: float = field(default=None)
    '''
    Voltage variation with reactive power.
    '''

@dataclass
class WaterLevel():
    value: float = field(default=None)
    '''
    Reservoir water level referred to a given datum such as mean sea level.
    '''

@dataclass
class ActivePower():
    value: float = field(default=None)
    '''
    Product of RMS value of the voltage and the RMS value of the in-phase component
    of the current.
    '''

@dataclass
class Mass():
    value: str = field(default=None)
    '''
    '''

@dataclass
class ConductancePerLength():
    value: float = field(default=None)
    '''
    Real part of admittance per unit of length.
    '''

@dataclass
class Reactance():
    value: float = field(default=None)
    '''
    Reactance (imaginary part of impedance), at rated frequency.
    '''

@dataclass
class Conductance():
    value: float = field(default=None)
    '''
    Factor by which voltage must be multiplied to give corresponding power
    lost from a circuit. Real part of admittance.
    '''

@dataclass
class ReactancePerLength():
    value: float = field(default=None)
    '''
    Reactance (imaginary part of impedance) per unit of length, at rated frequency.
    '''

@dataclass
class Resistance():
    value: float = field(default=None)
    '''
    Resistance (real part of impedance).
    '''

@dataclass
class CostPerVolume():
    value: float = field(default=None)
    '''
    Cost per unit volume.
    '''

@dataclass
class StructureSupportKind():
    value: str = field(default=None)
    '''
    '''

@dataclass
class CostRate():
    value: float = field(default=None)
    '''
    Cost, in units of currency, per elapsed time.
    '''

@dataclass
class Length():
    value: float = field(default=None)
    '''
    Unit of length. Never negative.
    '''

@dataclass
class ResistancePerLength():
    value: float = field(default=None)
    '''
    Resistance (real part of impedance) per unit of length.
    '''

@dataclass
class PerCent():
    value: float = field(default=None)
    '''
    Percentage on a defined base. For example, specify as 100 to indicate at
    the defined base.
    '''

@dataclass
class AngleRadians():
    value: float = field(default=None)
    '''
    Phase angle in radians.
    '''

@dataclass
class HeatRate():
    value: float = field(default=None)
    '''
    Heat generated, in energy pertime unit of elapsed time.
    '''

@dataclass
class Impedance():
    value: float = field(default=None)
    '''
    Ratio of voltage to current.
    '''

@dataclass(repr=False)
class DateInterval(Identity):
    '''
    Interval between two dates.
    '''

    end: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    End date of this interval.
    '''

    start: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Start date of this interval.
    '''

@dataclass(repr=False)
class DateTimeInterval(Identity):
    '''
    Interval between two date and time points.
    '''

    end: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    End date and time of this interval.
    '''

    start: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Start date and time of this interval.
    '''

@dataclass(repr=False)
class DecimalQuantity(Identity):
    '''
    '''

    value: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    currency: Optional[ Currency ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Quantity with decimal value and associated unit or currency information.
    '''

    multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class DeploymentDate(Identity):
    '''
    Dates for deployment events of an asset. May have multiple deployment type
    dates for this device and a compound type allows a query to return multiple
    dates.
    '''

    inServiceDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time asset most recently put in service.
    '''

    installedDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time asset most recently installed.
    '''

    notYetInstalledDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time of asset deployment transition to not yet installed.
    '''

    outOfServiceDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time asset most recently taken out of service.
    '''

    removedDate: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time asset most recently removed.
    '''

@dataclass(repr=False)
class ElectronicAddress(Identity):
    '''
    Electronic address information.
    '''

@dataclass(repr=False)
class EndDeviceCapability(Identity):
    '''
    Inherent capabilities of an end device (i.e., the functions it supports).
    '''

    autonomousDst: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if autonomous DST (daylight saving time) function is supported.
    '''

    communication: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if communication function is supported.
    '''

    connectDisconnect: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if connect and disconnect function is supported.
    '''

    demandResponse: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if demand response function is supported.
    '''

    electricMetering: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if electric metering function is supported.
    '''

    gasMetering: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if gas metering function is supported.
    '''

    metrology: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if metrology function is supported.
    '''

    onRequestRead: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if on request read function is supported.
    '''

    outageHistory: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if outage history function is supported.
    '''

    pressureCompensation: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if device performs pressure compensation for metered quantities.
    '''

    pricingInfo: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if pricing information is supported.
    '''

    pulseOutput: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if device produces pulse outputs.
    '''

    relaysProgramming: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if relays programming function is supported.
    '''

    reverseFlow: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if reverse flow function is supported.
    '''

    superCompressibilityCompensation: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if device performs super compressibility compensation for metered
    quantities.
    '''

    temperatureCompensation: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if device performs temperature compensation for metered quantities.
    '''

    textMessage: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if the displaying of text messages is supported.
    '''

    waterMetering: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if water metering function is supported.
    '''

@dataclass(repr=False)
class EndDeviceTiming(Identity):
    '''
    Timing for the control actions of end devices.
    '''

    durationIndefinite: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if 'duration' is indefinite.
    '''

    duration: Optional[ float | Minutes ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Duration of the end device control action or the business event that is
    the subject of the end device control.
    '''

    randomisation: Optional[ RandomisationKind ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Kind of randomisation to be applied to the end device control actions to
    be executed.
    '''

    interval: Optional[DateTimeInterval] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Start and end time of an interval during which end device control actions
    are to be executed.
    '''

@dataclass(repr=False)
class FaultImpedance(Identity):
    '''
    Impedance description for the fault.
    '''

    rGround: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The resistance of the fault between phases and ground.
    '''

    rLineToLine: Optional[ float | Resistance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The resistance of the fault between phases.
    '''

    xGround: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reactance of the fault between phases and ground.
    '''

    xLineToLine: Optional[ float | Reactance ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    The reactance of the fault between phases.
    '''

@dataclass(repr=False)
class FloatQuantity(Identity):
    '''
    Quantity with float value and associated unit information.
    '''

    value: Optional[ float ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class IntegerQuantity(Identity):
    '''
    Quantity with integer value and associated unit information.
    '''

    value: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class MonthDayInterval(Identity):
    '''
    Interval between two times specified as mont and date.
    '''

    end: Optional[ MonthDay ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    End time of this interval.
    '''

    start: Optional[ MonthDay ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Start time of this interval.
    '''

@dataclass(repr=False)
class Priority(Identity):
    '''
    Priority definition.
    '''

    justification: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Justification for 'rank'.
    '''

    rank: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Priority level; usually, lower number means high priority, but the details
    are provided in 'type'.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type describing 'rank'; e.g., high, emergency, etc.
    '''

@dataclass(repr=False)
class RationalNumber(Identity):
    '''
    Rational number = 'numerator' / 'denominator'.
    '''

    denominator: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Denominator. Value 1 indicates the number is a simple integer.
    '''

    numerator: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Numerator.
    '''

@dataclass(repr=False)
class ReadingInterharmonic(Identity):
    '''
    Interharmonics are represented as a rational number 'numerator' / 'denominator',
    and harmonics are represented using the same mechanism and identified by
    'denominator'=1.
    '''

    denominator: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '1',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Interharmonic denominator. Value 0 means not applicable. Value 2 is used
    in combination with 'numerator'=1 to represent interharmonic 1/2. Finally,
    value 1 indicates the harmonic of the order specified with 'numerator'.
    '''

    numerator: Optional[ int ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '1',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Interharmonic numerator. Value 0 means not applicable. Value 1 is used
    in combination with 'denominator'=2 to represent interharmonic 1/2, and
    with 'denominator'=1 it represents fundamental frequency. Finally, values
    greater than 1 indicate the harmonic of that order (e.g., 'numerator'=5
    is the fifth harmonic).
    '''

@dataclass(repr=False)
class Status(Identity):
    '''
    Current status information relevant to an entity.
    '''

    dateTime: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Date and time for which status 'value' applies.
    '''

    reason: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Reason code or explanation for why an object went to the current status
    'value'.
    '''

    remark: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Pertinent information regarding the current 'value', as free form text.
    '''

    value: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Status value at 'dateTime'; prior status changes may have been kept in
    instances of activity records associated with the object to which this
    status applies.
    '''

@dataclass(repr=False)
class StreetAddress(Identity):
    '''
    General purpose street and postal address information.
    '''

    poBox: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Post office box.
    '''

    postalCode: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Postal code for the address.
    '''

    status: Optional[Status] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Status of this address.
    '''

    streetDetail: Optional[StreetDetail] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Street detail.
    '''

    townDetail: Optional[TownDetail] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'inverse': '',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Town detail.
    '''

@dataclass(repr=False)
class StreetDetail(Identity):
    '''
    Street details, in the context of address.
    '''

    addressGeneral: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    First line of a free form address or some additional address information
    (for example a mail stop).
    '''

    addressGeneral2: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Second line of a free form address.
    '''

    addressGeneral3: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Third line of a free form address.
    '''

    buildingName: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) In certain cases the physical location of the place of
    interest does not have a direct point of entry from the street, but may
    be located inside a larger structure such as a building, complex, office
    block, apartment, etc.
    '''

    code: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Utilities often make use of external reference systems,
    such as those of the town-planner's department or surveyor general's mapping
    system, that allocate global reference codes to streets.
    '''

    name: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Name of the street.
    '''

    number: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Designator of the specific location on the street.
    '''

    prefix: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Prefix to the street name. For example: North, South, East, West.
    '''

    suffix: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Suffix to the street name. For example: North, South, East, West.
    '''

    suiteNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Number of the apartment or suite.
    '''

    type: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Type of street. Examples include: street, circle, boulevard, avenue, road,
    drive, etc.
    '''

    withinTownLimits: Optional[ bool ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    True if this street is within the legal geographical boundaries of the
    specified town (default).
    '''

@dataclass(repr=False)
class StringQuantity(Identity):
    '''
    Quantity with string value (when it is not important whether it is an integral
    or a floating point number) and associated unit information.
    '''

    value: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    multiplier: Optional[ UnitMultiplier ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

    unit: Optional[ UnitSymbol ] = field(
        default = None,
        metadata = {
            'type': 'Enumeration',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    '''

@dataclass(repr=False)
class TelephoneNumber(Identity):
    '''
    Telephone number.
    '''

    areaCode: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Area or region code.
    '''

    cityCode: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    City code.
    '''

    countryCode: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Country code.
    '''

    dialOut: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Dial out code, for instance to call outside an enterprise.
    '''

    extension: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Extension for this telephone number.
    '''

    internationalPrefix: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    (if applicable) Prefix used when calling an international number.
    '''

    ituPhone: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Phone number according to ITU E.164.
    '''

    localNumber: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Main (local) part of this telephone number.
    '''

@dataclass(repr=False)
class TimeInterval(Identity):
    '''
    Interval between two times.
    '''

    end: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    End time of this interval.
    '''

    start: Optional[ str ] = field(
        default = None,
        metadata = {
            'type': 'Attribute',
            'minOccurs': '0',
            'maxOccurs': '1',
            'namespace': 'http://iec.ch/TC57/CIM100#'
        })
    '''
    Start time of this interval.
    '''

@dataclass(repr=False)
class TownDetail(Identity):
    '''
    Town details, in the context of address.
    '''

@dataclass(repr=False)
class Version(Identity):
    '''
    This is the version for a group of devices or objects. This could be used
    to track the version for any group of objects or devices over time. For
    example, for a DERGroup, the requesting system may want to get the details
    of a specific version of a DERGroup.
    '''
