from .common import Common
from .vocabulary import MalwareFamilies as mf
from .vocabulary import ThreatExchange as t
from .vocabulary import Connection as c


class MalwareFamily(Common):

    _URL = t.URL + t.VERSION + t.MALWARE_FAMILIES
    _DETAILS = t.URL + t.VERSION
    _RELATED = t.URL + t.VERSION

    _fields = [
        mf.ID,
        mf.ADDED_ON,
        mf.ALIASES,
        mf.DESCRIPTION,
        mf.FAMILY_TYPE,
        mf.MALICIOUS,
        mf.NAME,
        mf.PRIVACY_TYPE,
        mf.SAMPLE_COUNT,
        mf.SHARE_LEVEL,
    ]

    _default_fields = [
        mf.ID,
        mf.ADDED_ON,
        mf.ALIASES,
        mf.DESCRIPTION,
        mf.FAMILY_TYPE,
        mf.MALICIOUS,
        mf.NAME,
        mf.SAMPLE_COUNT,
        mf.SHARE_LEVEL,
    ]

    _connections = [
        c.VARIANTS,
    ]

    _unique = [
    ]
