from collections.abc import Callable
from dataclasses import dataclass
from dataclasses import field
import typing
from typing import Any
from typing import ClassVar


from dpgcontainers.base import DPGContainersBase



@dataclass(eq=False)
class TwoDHistogramSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    y: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    xbins: int = -1
    ybins: int = -1
    xmin_range: float = 0.0
    xmax_range: float = 0.0
    ymin_range: float = 0.0
    ymax_range: float = 0.0
    density: bool = False
    outliers: bool = False
    col_major: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_2d_histogram_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'xbins', 'ybins', 'xmin_range', 'xmax_range', 'ymin_range', 'ymax_range', 'density', 'outliers', 'col_major', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ThreeDSlider(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0, 0.0, 0.0)
    max_x: float = 100.0
    max_y: float = 100.0
    max_z: float = 100.0
    min_x: float = 0.0
    min_y: float = 0.0
    min_z: float = 0.0
    scale: float = 1.0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_3d_slider'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'max_x', 'max_y', 'max_z', 'min_x', 'min_y', 'min_z', 'scale', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Alias(DPGContainersBase):
    alias: str
    item: typing.Union[int, str]

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_alias'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('alias', 'item', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class AreaSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    y: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    fill: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, -255)
    contribute_to_bounds: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_area_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'fill', 'contribute_to_bounds', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class AxisTag(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    default_value: float = 0.0
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, -255)
    auto_rounding: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_axis_tag'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'default_value', 'color', 'auto_rounding', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class BarGroupSeries(DPGContainersBase):
    values: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label_ids: typing.Union[typing.List[str], typing.Tuple[str, ...]]
    group_size: int
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    group_width: float = 0.67
    shift: int = 0
    horizontal: bool = False
    stacked: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_bar_group_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('values', 'label_ids', 'group_size', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'group_width', 'shift', 'horizontal', 'stacked', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class BarSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    y: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    weight: float = 1.0
    horizontal: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_bar_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'weight', 'horizontal', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class BoolValue(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    default_value: bool = False
    parent: typing.Union[int, str] = 13

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_bool_value'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'source', 'default_value', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Button(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    small: bool = False
    arrow: bool = False
    direction: int = 0
    repeat: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_button'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'small', 'arrow', 'direction', 'repeat', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class CandleSeries(DPGContainersBase):
    dates: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    opens: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    closes: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    lows: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    highs: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    bull_color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 255, 113, 255)
    bear_color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (218, 13, 79, 255)
    weight: float = 0.25
    tooltip: bool = True
    time_unit: int = 5

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_candle_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('dates', 'opens', 'closes', 'lows', 'highs', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'bull_color', 'bear_color', 'weight', 'tooltip', 'time_unit', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class CharRemap(DPGContainersBase):
    source: int
    target: int
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_char_remap'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('source', 'target', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Checkbox(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_checkbox'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ChildWindow(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    delay_search: bool = False
    tracked: bool = False
    track_offset: float = 0.5
    border: bool = True
    autosize_x: bool = False
    autosize_y: bool = False
    no_scrollbar: bool = False
    horizontal_scrollbar: bool = False
    menubar: bool = False
    no_scroll_with_mouse: bool = False
    flattened_navigation: bool = True
    always_use_window_padding: bool = False
    resizable_x: bool = False
    resizable_y: bool = False
    always_auto_resize: bool = False
    frame_style: bool = False
    auto_resize_x: bool = False
    auto_resize_y: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_child_window'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'payload_type', 'drop_callback', 'show', 'pos', 'filter_key', 'delay_search', 'tracked', 'track_offset', 'border', 'autosize_x', 'autosize_y', 'no_scrollbar', 'horizontal_scrollbar', 'menubar', 'no_scroll_with_mouse', 'flattened_navigation', 'always_use_window_padding', 'resizable_x', 'resizable_y', 'always_auto_resize', 'frame_style', 'auto_resize_x', 'auto_resize_y', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Clipper(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    delay_search: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_clipper'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'show', 'delay_search', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class CollapsingHeader(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    delay_search: bool = False
    tracked: bool = False
    track_offset: float = 0.5
    closable: bool = False
    default_open: bool = False
    open_on_double_click: bool = False
    open_on_arrow: bool = False
    leaf: bool = False
    bullet: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_collapsing_header'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'payload_type', 'drag_callback', 'drop_callback', 'show', 'pos', 'filter_key', 'delay_search', 'tracked', 'track_offset', 'closable', 'default_open', 'open_on_double_click', 'open_on_arrow', 'leaf', 'bullet', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ColorButton(DPGContainersBase):
    default_value: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, 255)
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    no_alpha: bool = False
    no_border: bool = False
    no_drag_drop: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_color_button'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('default_value', 'label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'no_alpha', 'no_border', 'no_drag_drop', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ColorEdit(DPGContainersBase):
    default_value: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, 255)
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    no_alpha: bool = False
    no_picker: bool = False
    no_options: bool = False
    no_small_preview: bool = False
    no_inputs: bool = False
    no_tooltip: bool = False
    no_label: bool = False
    no_drag_drop: bool = False
    alpha_bar: bool = False
    alpha_preview: int = 0
    display_mode: int = 1048576
    display_type: int = 8388608
    input_mode: int = 134217728

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_color_edit'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('default_value', 'label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'no_alpha', 'no_picker', 'no_options', 'no_small_preview', 'no_inputs', 'no_tooltip', 'no_label', 'no_drag_drop', 'alpha_bar', 'alpha_preview', 'display_mode', 'display_type', 'input_mode', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ColorPicker(DPGContainersBase):
    default_value: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, 255)
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    no_alpha: bool = False
    no_side_preview: bool = False
    no_small_preview: bool = False
    no_inputs: bool = False
    no_tooltip: bool = False
    no_label: bool = False
    alpha_bar: bool = False
    display_rgb: bool = False
    display_hsv: bool = False
    display_hex: bool = False
    picker_mode: int = 33554432
    alpha_preview: int = 0
    display_type: int = 8388608
    input_mode: int = 134217728

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_color_picker'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('default_value', 'label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'no_alpha', 'no_side_preview', 'no_small_preview', 'no_inputs', 'no_tooltip', 'no_label', 'alpha_bar', 'display_rgb', 'display_hsv', 'display_hex', 'picker_mode', 'alpha_preview', 'display_type', 'input_mode', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ColorValue(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    default_value: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0, 0.0, 0.0)
    parent: typing.Union[int, str] = 13

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_color_value'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'source', 'default_value', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Colormap(DPGContainersBase):
    colors: typing.List[typing.Union[typing.List[int], typing.Tuple[int, ...]]]
    qualitative: bool
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    show: bool = True
    parent: typing.Union[int, str] = 14

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_colormap'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('colors', 'qualitative', 'label', 'user_data', 'use_internal_label', 'tag', 'show', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None
    dpg_bind_function_name: ClassVar[str | None] = None
    dpg_bind_item_function_name: ClassVar[str | None] = 'bind_colormap'



@dataclass(eq=False)
class ColormapButton(DPGContainersBase):
    default_value: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, 255)
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_colormap_button'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('default_value', 'label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ColormapRegistry(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    show: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_colormap_registry'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ColormapScale(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    colormap: typing.Union[int, str] = 0
    min_scale: float = 0.0
    max_scale: float = 1.0
    format: str = '%g'
    reverse_dir: bool = False
    mirror: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_colormap_scale'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'drop_callback', 'show', 'pos', 'colormap', 'min_scale', 'max_scale', 'format', 'reverse_dir', 'mirror', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ColormapSlider(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: float = 0.0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_colormap_slider'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'payload_type', 'callback', 'drop_callback', 'show', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Combo(DPGContainersBase):
    items: typing.Union[typing.List[str], typing.Tuple[str, ...]] = ()
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: str = ''
    popup_align_left: bool = False
    no_arrow_button: bool = False
    no_preview: bool = False
    fit_width: bool = False
    height_mode: int = 1

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_combo'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('items', 'label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'popup_align_left', 'no_arrow_button', 'no_preview', 'fit_width', 'height_mode', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class CustomSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    y: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    channel_count: int
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    y1: Any = field(default_factory=list)
    y2: Any = field(default_factory=list)
    y3: Any = field(default_factory=list)
    tooltip: bool = True
    no_fit: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_custom_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y', 'channel_count', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'callback', 'show', 'y1', 'y2', 'y3', 'tooltip', 'no_fit', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DatePicker(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: dict = field(default_factory=lambda: {'month_day': 14, 'year': 20, 'month': 5})
    level: int = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_date_picker'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'level', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DigitalSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    y: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_digital_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Double4Value(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    default_value: Any = (0.0, 0.0, 0.0, 0.0)
    parent: typing.Union[int, str] = 13

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_double4_value'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'source', 'default_value', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DoubleValue(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    default_value: float = 0.0
    parent: typing.Union[int, str] = 13

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_double_value'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'source', 'default_value', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DragDouble(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: float = 0.0
    format: str = '%0.3f'
    speed: float = 1.0
    min_value: float = 0.0
    max_value: float = 100.0
    no_input: bool = False
    clamped: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_drag_double'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'format', 'speed', 'min_value', 'max_value', 'no_input', 'clamped', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DragDoublex(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: Any = (0.0, 0.0, 0.0, 0.0)
    size: int = 4
    format: str = '%0.3f'
    speed: float = 1.0
    min_value: float = 0.0
    max_value: float = 100.0
    no_input: bool = False
    clamped: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_drag_doublex'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'size', 'format', 'speed', 'min_value', 'max_value', 'no_input', 'clamped', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DragFloat(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: float = 0.0
    format: str = '%0.3f'
    speed: float = 1.0
    min_value: float = 0.0
    max_value: float = 100.0
    no_input: bool = False
    clamped: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_drag_float'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'format', 'speed', 'min_value', 'max_value', 'no_input', 'clamped', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DragFloatx(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0, 0.0, 0.0)
    size: int = 4
    format: str = '%0.3f'
    speed: float = 1.0
    min_value: float = 0.0
    max_value: float = 100.0
    no_input: bool = False
    clamped: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_drag_floatx'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'size', 'format', 'speed', 'min_value', 'max_value', 'no_input', 'clamped', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DragInt(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: int = 0
    format: str = '%d'
    speed: float = 1.0
    min_value: int = 0
    max_value: int = 100
    no_input: bool = False
    clamped: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_drag_int'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'format', 'speed', 'min_value', 'max_value', 'no_input', 'clamped', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DragIntx(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, 0)
    size: int = 4
    format: str = '%d'
    speed: float = 1.0
    min_value: int = 0
    max_value: int = 100
    no_input: bool = False
    clamped: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_drag_intx'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'size', 'format', 'speed', 'min_value', 'max_value', 'no_input', 'clamped', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DragLine(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    default_value: float = 0.0
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, -255)
    thickness: float = 1.0
    show_label: bool = True
    vertical: bool = True
    delayed: bool = False
    no_cursor: bool = False
    no_fit: bool = False
    no_inputs: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_drag_line'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'callback', 'show', 'default_value', 'color', 'thickness', 'show_label', 'vertical', 'delayed', 'no_cursor', 'no_fit', 'no_inputs', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DragPayload(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    show: bool = True
    drag_data: Any | None = None
    drop_data: Any | None = None
    payload_type: str = '$$DPG_PAYLOAD'

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_drag_payload'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'show', 'drag_data', 'drop_data', 'payload_type', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DragPoint(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    default_value: Any = (0.0, 0.0)
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, -255)
    thickness: float = 1.0
    show_label: bool = True
    offset: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (16.0, 8.0)
    clamped: bool = True
    delayed: bool = False
    no_cursor: bool = False
    no_fit: bool = False
    no_inputs: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_drag_point'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'callback', 'show', 'default_value', 'color', 'thickness', 'show_label', 'offset', 'clamped', 'delayed', 'no_cursor', 'no_fit', 'no_inputs', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DragRect(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    default_value: Any = (0.0, 0.0, 0.0, 0.0)
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, -255)
    delayed: bool = False
    no_cursor: bool = False
    no_fit: bool = False
    no_inputs: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_drag_rect'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'callback', 'show', 'default_value', 'color', 'delayed', 'no_cursor', 'no_fit', 'no_inputs', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DrawLayer(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    perspective_divide: bool = False
    depth_clipping: bool = False
    cull_mode: int = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_draw_layer'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'perspective_divide', 'depth_clipping', 'cull_mode', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DrawNode(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_draw_node'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Drawlist(DPGContainersBase):
    width: int
    height: int
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    delay_search: bool = False
    tracked: bool = False
    track_offset: float = 0.5

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_drawlist'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('width', 'height', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'callback', 'show', 'pos', 'filter_key', 'delay_search', 'tracked', 'track_offset', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class DynamicTexture(DPGContainersBase):
    width: int
    height: int
    default_value: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 12

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_dynamic_texture'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('width', 'height', 'default_value', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ErrorSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    y: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    negative: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    positive: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    contribute_to_bounds: bool = True
    horizontal: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_error_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y', 'negative', 'positive', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'contribute_to_bounds', 'horizontal', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class FileDialog(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    callback: typing.Callable | None = None
    show: bool = True
    default_path: str = ''
    default_filename: str = '.'
    file_count: int = 0
    modal: bool = False
    directory_selector: bool = False
    min_size: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=lambda: [100, 100])
    max_size: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=lambda: [30000, 30000])
    cancel_callback: typing.Callable | None = None

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_file_dialog'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'callback', 'show', 'default_path', 'default_filename', 'file_count', 'modal', 'directory_selector', 'min_size', 'max_size', 'cancel_callback', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class FileExtension(DPGContainersBase):
    extension: str
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    custom_text: str = ''
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (-255, 0, 0, 255)

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_file_extension'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('extension', 'label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'parent', 'before', 'custom_text', 'color', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class FilterSet(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    delay_search: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_filter_set'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'show', 'delay_search', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Float4Value(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    default_value: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0, 0.0, 0.0)
    parent: typing.Union[int, str] = 13

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_float4_value'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'source', 'default_value', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class FloatValue(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    default_value: float = 0.0
    parent: typing.Union[int, str] = 13

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_float_value'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'source', 'default_value', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class FloatVectValue(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    default_value: typing.Union[typing.List[float], typing.Tuple[float, ...]] = ()
    parent: typing.Union[int, str] = 13

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_float_vect_value'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'source', 'default_value', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Font(DPGContainersBase):
    file: str
    size: int
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    pixel_snapH: bool = False
    parent: typing.Union[int, str] = 10

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_font'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('file', 'size', 'label', 'user_data', 'use_internal_label', 'tag', 'pixel_snapH', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None
    dpg_bind_function_name: ClassVar[str | None] = 'bind_font'
    dpg_bind_item_function_name: ClassVar[str | None] = 'bind_item_font'



@dataclass(eq=False)
class FontChars(DPGContainersBase):
    chars: typing.Union[typing.List[int], typing.Tuple[int, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_font_chars'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('chars', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class FontRange(DPGContainersBase):
    first_char: int
    last_char: int
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_font_range'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('first_char', 'last_char', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class FontRangeHint(DPGContainersBase):
    hint: int
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_font_range_hint'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('hint', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class FontRegistry(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_font_registry'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Group(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    delay_search: bool = False
    tracked: bool = False
    track_offset: float = 0.5
    horizontal: bool = False
    horizontal_spacing: float = -1
    xoffset: float = 0.0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_group'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'payload_type', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'delay_search', 'tracked', 'track_offset', 'horizontal', 'horizontal_spacing', 'xoffset', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class HandlerRegistry(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_handler_registry'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class HeatSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    rows: int
    cols: int
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    scale_min: float = 0.0
    scale_max: float = 1.0
    bounds_min: Any = (0.0, 0.0)
    bounds_max: Any = (1.0, 1.0)
    format: str = '%0.1f'
    contribute_to_bounds: bool = True
    col_major: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_heat_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'rows', 'cols', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'scale_min', 'scale_max', 'bounds_min', 'bounds_max', 'format', 'contribute_to_bounds', 'col_major', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class HistogramSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    bins: int = -1
    bar_scale: float = 1.0
    min_range: float = 0.0
    max_range: float = 0.0
    cumulative: bool = False
    density: bool = False
    outliers: bool = True
    horizontal: bool = False
    contribute_to_bounds: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_histogram_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'bins', 'bar_scale', 'min_range', 'max_range', 'cumulative', 'density', 'outliers', 'horizontal', 'contribute_to_bounds', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Image(DPGContainersBase):
    texture_tag: typing.Union[int, str]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    tint_color: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (255, 255, 255, 255)
    border_color: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0, 0, 0, 0)
    uv_min: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0)
    uv_max: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (1.0, 1.0)

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_image'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('texture_tag', 'label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'drag_callback', 'drop_callback', 'show', 'pos', 'filter_key', 'tracked', 'track_offset', 'tint_color', 'border_color', 'uv_min', 'uv_max', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ImageButton(DPGContainersBase):
    texture_tag: typing.Union[int, str]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    tint_color: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (255, 255, 255, 255)
    background_color: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0, 0, 0, 0)
    uv_min: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0)
    uv_max: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (1.0, 1.0)

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_image_button'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('texture_tag', 'label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'tint_color', 'background_color', 'uv_min', 'uv_max', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ImageSeries(DPGContainersBase):
    texture_tag: typing.Union[int, str]
    bounds_min: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    bounds_max: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    uv_min: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0)
    uv_max: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (1.0, 1.0)
    tint_color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_image_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('texture_tag', 'bounds_min', 'bounds_max', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'uv_min', 'uv_max', 'tint_color', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class InfLineSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    horizontal: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_inf_line_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'horizontal', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class InputDouble(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: float = 0.0
    format: str = '%.3f'
    min_value: float = 0.0
    max_value: float = 100.0
    step: float = 0.1
    step_fast: float = 1.0
    min_clamped: bool = False
    max_clamped: bool = False
    on_enter: bool = False
    readonly: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_input_double'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'format', 'min_value', 'max_value', 'step', 'step_fast', 'min_clamped', 'max_clamped', 'on_enter', 'readonly', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class InputDoublex(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: Any = (0.0, 0.0, 0.0, 0.0)
    format: str = '%.3f'
    min_value: float = 0.0
    max_value: float = 100.0
    size: int = 4
    min_clamped: bool = False
    max_clamped: bool = False
    on_enter: bool = False
    readonly: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_input_doublex'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'format', 'min_value', 'max_value', 'size', 'min_clamped', 'max_clamped', 'on_enter', 'readonly', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class InputFloat(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: float = 0.0
    format: str = '%.3f'
    min_value: float = 0.0
    max_value: float = 100.0
    step: float = 0.1
    step_fast: float = 1.0
    min_clamped: bool = False
    max_clamped: bool = False
    on_enter: bool = False
    readonly: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_input_float'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'format', 'min_value', 'max_value', 'step', 'step_fast', 'min_clamped', 'max_clamped', 'on_enter', 'readonly', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class InputFloatx(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0, 0.0, 0.0)
    format: str = '%.3f'
    min_value: float = 0.0
    max_value: float = 100.0
    size: int = 4
    min_clamped: bool = False
    max_clamped: bool = False
    on_enter: bool = False
    readonly: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_input_floatx'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'format', 'min_value', 'max_value', 'size', 'min_clamped', 'max_clamped', 'on_enter', 'readonly', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class InputInt(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: int = 0
    min_value: int = 0
    max_value: int = 100
    step: int = 1
    step_fast: int = 100
    min_clamped: bool = False
    max_clamped: bool = False
    on_enter: bool = False
    readonly: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_input_int'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'min_value', 'max_value', 'step', 'step_fast', 'min_clamped', 'max_clamped', 'on_enter', 'readonly', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class InputIntx(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, 0)
    min_value: int = 0
    max_value: int = 100
    size: int = 4
    min_clamped: bool = False
    max_clamped: bool = False
    on_enter: bool = False
    readonly: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_input_intx'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'min_value', 'max_value', 'size', 'min_clamped', 'max_clamped', 'on_enter', 'readonly', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class InputText(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: str = ''
    hint: str = ''
    multiline: bool = False
    no_spaces: bool = False
    uppercase: bool = False
    tab_input: bool = False
    decimal: bool = False
    hexadecimal: bool = False
    readonly: bool = False
    password: bool = False
    scientific: bool = False
    on_enter: bool = False
    auto_select_all: bool = False
    ctrl_enter_for_new_line: bool = False
    no_horizontal_scroll: bool = False
    always_overwrite: bool = False
    no_undo_redo: bool = False
    escape_clears_all: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_input_text'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'hint', 'multiline', 'no_spaces', 'uppercase', 'tab_input', 'decimal', 'hexadecimal', 'readonly', 'password', 'scientific', 'on_enter', 'auto_select_all', 'ctrl_enter_for_new_line', 'no_horizontal_scroll', 'always_overwrite', 'no_undo_redo', 'escape_clears_all', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Int4Value(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    default_value: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, 0)
    parent: typing.Union[int, str] = 13

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_int4_value'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'source', 'default_value', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class IntValue(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    default_value: int = 0
    parent: typing.Union[int, str] = 13

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_int_value'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'source', 'default_value', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ItemActivatedHandler(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_activated_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'callback', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ItemActiveHandler(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_active_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'callback', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ItemClickedHandler(DPGContainersBase):
    button: int = -1
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_clicked_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('button', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'callback', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ItemDeactivatedAfterEditHandler(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_deactivated_after_edit_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'callback', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ItemDeactivatedHandler(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_deactivated_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'callback', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ItemDoubleClickedHandler(DPGContainersBase):
    button: int = -1
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_double_clicked_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('button', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'callback', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ItemEditedHandler(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_edited_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'callback', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ItemFocusHandler(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_focus_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'callback', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ItemHandlerRegistry(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_handler_registry'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None
    dpg_bind_function_name: ClassVar[str | None] = None
    dpg_bind_item_function_name: ClassVar[str | None] = 'bind_item_handler_registry'



@dataclass(eq=False)
class ItemHoverHandler(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_hover_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'callback', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ItemResizeHandler(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_resize_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'callback', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ItemToggledOpenHandler(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_toggled_open_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'callback', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ItemVisibleHandler(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_item_visible_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'callback', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class KeyDownHandler(DPGContainersBase):
    key: int = 0
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    parent: typing.Union[int, str] = 11

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_key_down_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('key', 'label', 'user_data', 'use_internal_label', 'tag', 'callback', 'show', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class KeyPressHandler(DPGContainersBase):
    key: int = 0
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    parent: typing.Union[int, str] = 11

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_key_press_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('key', 'label', 'user_data', 'use_internal_label', 'tag', 'callback', 'show', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class KeyReleaseHandler(DPGContainersBase):
    key: int = 0
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    parent: typing.Union[int, str] = 11

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_key_release_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('key', 'label', 'user_data', 'use_internal_label', 'tag', 'callback', 'show', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class KnobFloat(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: float = 0.0
    min_value: float = 0.0
    max_value: float = 100.0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_knob_float'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'min_value', 'max_value', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class LineSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    y: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    segments: bool = False
    loop: bool = False
    skip_nan: bool = False
    no_clip: bool = False
    shaded: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_line_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'segments', 'loop', 'skip_nan', 'no_clip', 'shaded', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Listbox(DPGContainersBase):
    items: typing.Union[typing.List[str], typing.Tuple[str, ...]] = ()
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: str = ''
    num_items: int = 3

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_listbox'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('items', 'label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'num_items', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class LoadingIndicator(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    style: int = 0
    circle_count: int = 8
    speed: float = 1.0
    radius: float = 3.0
    thickness: float = 1.0
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (51, 51, 55, 255)
    secondary_color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (29, 151, 236, 103)

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_loading_indicator'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'payload_type', 'drop_callback', 'show', 'pos', 'style', 'circle_count', 'speed', 'radius', 'thickness', 'color', 'secondary_color', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Menu(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    filter_key: str = ''
    delay_search: bool = False
    tracked: bool = False
    track_offset: float = 0.5

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_menu'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'payload_type', 'drop_callback', 'show', 'enabled', 'filter_key', 'delay_search', 'tracked', 'track_offset', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class MenuBar(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    show: bool = True
    delay_search: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_menu_bar'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'show', 'delay_search', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class MenuItem(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: bool = False
    shortcut: str = ''
    check: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_menu_item'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'payload_type', 'callback', 'drop_callback', 'show', 'enabled', 'filter_key', 'tracked', 'track_offset', 'default_value', 'shortcut', 'check', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class MouseClickHandler(DPGContainersBase):
    button: int = -1
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    parent: typing.Union[int, str] = 11

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_mouse_click_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('button', 'label', 'user_data', 'use_internal_label', 'tag', 'callback', 'show', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class MouseDoubleClickHandler(DPGContainersBase):
    button: int = -1
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    parent: typing.Union[int, str] = 11

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_mouse_double_click_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('button', 'label', 'user_data', 'use_internal_label', 'tag', 'callback', 'show', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class MouseDownHandler(DPGContainersBase):
    button: int = -1
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    parent: typing.Union[int, str] = 11

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_mouse_down_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('button', 'label', 'user_data', 'use_internal_label', 'tag', 'callback', 'show', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class MouseDragHandler(DPGContainersBase):
    button: int = 10
    threshold: float = -1
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    parent: typing.Union[int, str] = 11

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_mouse_drag_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('button', 'threshold', 'label', 'user_data', 'use_internal_label', 'tag', 'callback', 'show', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class MouseMoveHandler(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    parent: typing.Union[int, str] = 11

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_mouse_move_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'callback', 'show', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class MouseReleaseHandler(DPGContainersBase):
    button: int = -1
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    parent: typing.Union[int, str] = 11

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_mouse_release_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('button', 'label', 'user_data', 'use_internal_label', 'tag', 'callback', 'show', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class MouseWheelHandler(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    parent: typing.Union[int, str] = 11

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_mouse_wheel_handler'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'callback', 'show', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Node(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    delay_search: bool = False
    tracked: bool = False
    track_offset: float = 0.5
    draggable: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_node'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'payload_type', 'drag_callback', 'drop_callback', 'show', 'pos', 'filter_key', 'delay_search', 'tracked', 'track_offset', 'draggable', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class NodeAttribute(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    attribute_type: int = 0
    shape: int = 1
    category: str = 'general'

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_node_attribute'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'show', 'filter_key', 'tracked', 'track_offset', 'attribute_type', 'shape', 'category', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class NodeEditor(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    filter_key: str = ''
    delay_search: bool = False
    tracked: bool = False
    track_offset: float = 0.5
    delink_callback: typing.Callable | None = None
    menubar: bool = False
    minimap: bool = False
    minimap_location: int = 2

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_node_editor'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'parent', 'before', 'callback', 'show', 'filter_key', 'delay_search', 'tracked', 'track_offset', 'delink_callback', 'menubar', 'minimap', 'minimap_location', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class NodeLink(DPGContainersBase):
    attr_1: typing.Union[int, str]
    attr_2: typing.Union[int, str]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    show: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_node_link'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('attr_1', 'attr_2', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class PieSeries(DPGContainersBase):
    x: float
    y: float
    radius: float
    values: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    labels: typing.Union[typing.List[str], typing.Tuple[str, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    format: str = '%0.2f'
    angle: float = 90.0
    normalize: bool = False
    ignore_hidden: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_pie_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y', 'radius', 'values', 'labels', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'format', 'angle', 'normalize', 'ignore_hidden', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Plot(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    delay_search: bool = False
    tracked: bool = False
    track_offset: float = 0.5
    no_title: bool = False
    no_menus: bool = False
    no_box_select: bool = False
    no_mouse_pos: bool = False
    query: bool = False
    query_color: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0, 255, 0, 255)
    min_query_rects: int = 1
    max_query_rects: int = 1
    crosshairs: bool = False
    equal_aspects: bool = False
    no_inputs: bool = False
    no_frame: bool = False
    use_local_time: bool = False
    use_ISO8601: bool = False
    use_24hour_clock: bool = False
    pan_button: int = 0
    pan_mod: int = 0
    context_menu_button: int = 1
    fit_button: int = 0
    box_select_button: int = 1
    box_select_mod: int = 0
    box_select_cancel_button: int = 0
    query_toggle_mod: int = 4096
    horizontal_mod: int = 16384
    vertical_mod: int = 8192
    override_mod: int = 4096
    zoom_mod: int = 0
    zoom_rate: int = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_plot'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'pos', 'filter_key', 'delay_search', 'tracked', 'track_offset', 'no_title', 'no_menus', 'no_box_select', 'no_mouse_pos', 'query', 'query_color', 'min_query_rects', 'max_query_rects', 'crosshairs', 'equal_aspects', 'no_inputs', 'no_frame', 'use_local_time', 'use_ISO8601', 'use_24hour_clock', 'pan_button', 'pan_mod', 'context_menu_button', 'fit_button', 'box_select_button', 'box_select_mod', 'box_select_cancel_button', 'query_toggle_mod', 'horizontal_mod', 'vertical_mod', 'override_mod', 'zoom_mod', 'zoom_rate', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class PlotAnnotation(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    default_value: Any = (0.0, 0.0)
    offset: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0)
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, -255)
    clamped: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_plot_annotation'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'default_value', 'offset', 'color', 'clamped', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class PlotAxis(DPGContainersBase):
    axis: int
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drop_callback: typing.Callable | None = None
    show: bool = True
    no_label: bool = False
    no_gridlines: bool = False
    no_tick_marks: bool = False
    no_tick_labels: bool = False
    no_initial_fit: bool = False
    no_menus: bool = False
    no_side_switch: bool = False
    no_highlight: bool = False
    opposite: bool = False
    foreground_grid: bool = False
    tick_format: str = ''
    scale: int = 0
    invert: bool = False
    auto_fit: bool = False
    range_fit: bool = False
    pan_stretch: bool = False
    lock_min: bool = False
    lock_max: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_plot_axis'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('axis', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'payload_type', 'drop_callback', 'show', 'no_label', 'no_gridlines', 'no_tick_marks', 'no_tick_labels', 'no_initial_fit', 'no_menus', 'no_side_switch', 'no_highlight', 'opposite', 'foreground_grid', 'tick_format', 'scale', 'invert', 'auto_fit', 'range_fit', 'pan_stretch', 'lock_min', 'lock_max', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class PlotLegend(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drop_callback: typing.Callable | None = None
    show: bool = True
    location: int = 5
    horizontal: bool = False
    sort: bool = False
    outside: bool = False
    no_highlight_item: bool = False
    no_highlight_axis: bool = False
    no_menus: bool = False
    no_buttons: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_plot_legend'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'parent', 'payload_type', 'drop_callback', 'show', 'location', 'horizontal', 'sort', 'outside', 'no_highlight_item', 'no_highlight_axis', 'no_menus', 'no_buttons', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ProgressBar(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    overlay: str = ''
    default_value: float = 0.0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_progress_bar'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'drag_callback', 'drop_callback', 'show', 'pos', 'filter_key', 'tracked', 'track_offset', 'overlay', 'default_value', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class RadioButton(DPGContainersBase):
    items: typing.Union[typing.List[str], typing.Tuple[str, ...]] = ()
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: str = ''
    horizontal: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_radio_button'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('items', 'label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'horizontal', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class RawTexture(DPGContainersBase):
    width: int
    height: int
    default_value: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    format: int = 0
    parent: typing.Union[int, str] = 12

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_raw_texture'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('width', 'height', 'default_value', 'label', 'user_data', 'use_internal_label', 'tag', 'format', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ScatterSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    y: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    no_clip: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_scatter_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'no_clip', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Selectable(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: bool = False
    span_columns: bool = False
    disable_popup_close: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_selectable'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'span_columns', 'disable_popup_close', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Separator(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_separator'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'show', 'pos', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class SeriesValue(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    default_value: Any = ()
    parent: typing.Union[int, str] = 13

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_series_value'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'source', 'default_value', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ShadeSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    y1: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    y2: Any = field(default_factory=list)

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_shade_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y1', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'y2', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class SimplePlot(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: typing.Union[typing.List[float], typing.Tuple[float, ...]] = ()
    overlay: str = ''
    histogram: bool = False
    autosize: bool = True
    min_scale: float = 0.0
    max_scale: float = 0.0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_simple_plot'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'drag_callback', 'drop_callback', 'show', 'filter_key', 'tracked', 'track_offset', 'default_value', 'overlay', 'histogram', 'autosize', 'min_scale', 'max_scale', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class SliderDouble(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: float = 0.0
    vertical: bool = False
    no_input: bool = False
    clamped: bool = False
    min_value: float = 0.0
    max_value: float = 100.0
    format: str = '%.3f'

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_slider_double'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'vertical', 'no_input', 'clamped', 'min_value', 'max_value', 'format', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class SliderDoublex(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: Any = (0.0, 0.0, 0.0, 0.0)
    size: int = 4
    no_input: bool = False
    clamped: bool = False
    min_value: float = 0.0
    max_value: float = 100.0
    format: str = '%.3f'

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_slider_doublex'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'size', 'no_input', 'clamped', 'min_value', 'max_value', 'format', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class SliderFloat(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: float = 0.0
    vertical: bool = False
    no_input: bool = False
    clamped: bool = False
    min_value: float = 0.0
    max_value: float = 100.0
    format: str = '%.3f'

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_slider_float'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'vertical', 'no_input', 'clamped', 'min_value', 'max_value', 'format', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class SliderFloatx(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0, 0.0, 0.0)
    size: int = 4
    no_input: bool = False
    clamped: bool = False
    min_value: float = 0.0
    max_value: float = 100.0
    format: str = '%.3f'

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_slider_floatx'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'size', 'no_input', 'clamped', 'min_value', 'max_value', 'format', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class SliderInt(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: int = 0
    vertical: bool = False
    no_input: bool = False
    clamped: bool = False
    min_value: int = 0
    max_value: int = 100
    format: str = '%d'

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_slider_int'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'vertical', 'no_input', 'clamped', 'min_value', 'max_value', 'format', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class SliderIntx(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    enabled: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, 0)
    size: int = 4
    no_input: bool = False
    clamped: bool = False
    min_value: int = 0
    max_value: int = 100
    format: str = '%d'

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_slider_intx'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'indent', 'parent', 'before', 'source', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'enabled', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'size', 'no_input', 'clamped', 'min_value', 'max_value', 'format', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Spacer(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_spacer'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'show', 'pos', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Stage(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_stage'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class StairSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    y: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    pre_step: bool = False
    shaded: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_stair_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'pre_step', 'shaded', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class StaticTexture(DPGContainersBase):
    width: int
    height: int
    default_value: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 12

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_static_texture'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('width', 'height', 'default_value', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class StemSeries(DPGContainersBase):
    x: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    y: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    horizontal: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_stem_series'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y', 'label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'source', 'show', 'horizontal', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class StringValue(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    default_value: str = ''
    parent: typing.Union[int, str] = 13

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_string_value'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'source', 'default_value', 'parent', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Subplots(DPGContainersBase):
    rows: int
    columns: int
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    delay_search: bool = False
    tracked: bool = False
    track_offset: float = 0.5
    row_ratios: typing.Union[typing.List[float], typing.Tuple[float, ...]] = field(default_factory=list)
    column_ratios: typing.Union[typing.List[float], typing.Tuple[float, ...]] = field(default_factory=list)
    no_title: bool = False
    no_menus: bool = False
    no_resize: bool = False
    no_align: bool = False
    share_series: bool = False
    link_rows: bool = False
    link_columns: bool = False
    link_all_x: bool = False
    link_all_y: bool = False
    column_major: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_subplots'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('rows', 'columns', 'label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'callback', 'show', 'pos', 'filter_key', 'delay_search', 'tracked', 'track_offset', 'row_ratios', 'column_ratios', 'no_title', 'no_menus', 'no_resize', 'no_align', 'share_series', 'link_rows', 'link_columns', 'link_all_x', 'link_all_y', 'column_major', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Tab(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drop_callback: typing.Callable | None = None
    show: bool = True
    filter_key: str = ''
    delay_search: bool = False
    tracked: bool = False
    track_offset: float = 0.5
    closable: bool = False
    no_tooltip: bool = False
    order_mode: int = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_tab'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'payload_type', 'drop_callback', 'show', 'filter_key', 'delay_search', 'tracked', 'track_offset', 'closable', 'no_tooltip', 'order_mode', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class TabBar(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    delay_search: bool = False
    tracked: bool = False
    track_offset: float = 0.5
    reorderable: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_tab_bar'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'callback', 'show', 'pos', 'filter_key', 'delay_search', 'tracked', 'track_offset', 'reorderable', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class TabButton(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    no_reorder: bool = False
    leading: bool = False
    trailing: bool = False
    no_tooltip: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_tab_button'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'filter_key', 'tracked', 'track_offset', 'no_reorder', 'leading', 'trailing', 'no_tooltip', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Table(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    delay_search: bool = False
    header_row: bool = True
    clipper: bool = False
    inner_width: int = 0
    policy: int = 0
    freeze_rows: int = 0
    freeze_columns: int = 0
    sort_multi: bool = False
    sort_tristate: bool = False
    resizable: bool = False
    reorderable: bool = False
    hideable: bool = False
    sortable: bool = False
    context_menu_in_body: bool = False
    row_background: bool = False
    borders_innerH: bool = False
    borders_outerH: bool = False
    borders_innerV: bool = False
    borders_outerV: bool = False
    no_host_extendX: bool = False
    no_host_extendY: bool = False
    no_keep_columns_visible: bool = False
    precise_widths: bool = False
    no_clip: bool = False
    pad_outerX: bool = False
    no_pad_outerX: bool = False
    no_pad_innerX: bool = False
    scrollX: bool = False
    scrollY: bool = False
    no_saved_settings: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_table'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'parent', 'before', 'source', 'callback', 'show', 'pos', 'filter_key', 'delay_search', 'header_row', 'clipper', 'inner_width', 'policy', 'freeze_rows', 'freeze_columns', 'sort_multi', 'sort_tristate', 'resizable', 'reorderable', 'hideable', 'sortable', 'context_menu_in_body', 'row_background', 'borders_innerH', 'borders_outerH', 'borders_innerV', 'borders_outerV', 'no_host_extendX', 'no_host_extendY', 'no_keep_columns_visible', 'precise_widths', 'no_clip', 'pad_outerX', 'no_pad_outerX', 'no_pad_innerX', 'scrollX', 'scrollY', 'no_saved_settings', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class TableCell(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    height: int = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    filter_key: str = ''

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_table_cell'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'height', 'parent', 'before', 'show', 'filter_key', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class TableColumn(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    enabled: bool = True
    init_width_or_weight: float = 0.0
    default_hide: bool = False
    default_sort: bool = False
    width_stretch: bool = False
    width_fixed: bool = False
    no_resize: bool = False
    no_reorder: bool = False
    no_hide: bool = False
    no_clip: bool = False
    no_sort: bool = False
    no_sort_ascending: bool = False
    no_sort_descending: bool = False
    no_header_width: bool = False
    prefer_sort_ascending: bool = True
    prefer_sort_descending: bool = False
    indent_enable: bool = False
    indent_disable: bool = False
    angled_header: bool = False
    no_header_label: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_table_column'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'parent', 'before', 'show', 'enabled', 'init_width_or_weight', 'default_hide', 'default_sort', 'width_stretch', 'width_fixed', 'no_resize', 'no_reorder', 'no_hide', 'no_clip', 'no_sort', 'no_sort_ascending', 'no_sort_descending', 'no_header_width', 'prefer_sort_ascending', 'prefer_sort_descending', 'indent_enable', 'indent_disable', 'angled_header', 'no_header_label', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class TableRow(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    height: int = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    filter_key: str = ''

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_table_row'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'height', 'parent', 'before', 'show', 'filter_key', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class TemplateRegistry(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_template_registry'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Text(DPGContainersBase):
    default_value: str = ''
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    wrap: int = -1
    bullet: bool = False
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (-255, 0, 0, 255)
    show_label: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_text'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('default_value', 'label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'source', 'payload_type', 'drag_callback', 'drop_callback', 'show', 'pos', 'filter_key', 'tracked', 'track_offset', 'wrap', 'bullet', 'color', 'show_label', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class TextPoint(DPGContainersBase):
    x: float
    y: float
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    source: typing.Union[int, str] = 0
    show: bool = True
    offset: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0)
    vertical: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_text_point'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('x', 'y', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'source', 'show', 'offset', 'vertical', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class TextureRegistry(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    show: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_texture_registry'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'show', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Theme(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_theme'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None
    dpg_bind_function_name: ClassVar[str | None] = 'bind_theme'
    dpg_bind_item_function_name: ClassVar[str | None] = 'bind_item_theme'



@dataclass(eq=False)
class ThemeColor(DPGContainersBase):
    target: int = 0
    value: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, 255)
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    category: int = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_theme_color'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('target', 'value', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'category', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ThemeComponent(DPGContainersBase):
    item_type: int = 0
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    enabled_state: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_theme_component'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('item_type', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'enabled_state', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ThemeStyle(DPGContainersBase):
    target: int = -1
    x: float = 1.0
    y: float = 0
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    category: int = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_theme_style'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('target', 'x', 'y', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'category', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class TimePicker(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    callback: typing.Callable | None = None
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    tracked: bool = False
    track_offset: float = 0.5
    default_value: dict = field(default_factory=lambda: {'hour': 14, 'min': 32, 'sec': 23})
    hour24: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_time_picker'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'payload_type', 'callback', 'drag_callback', 'drop_callback', 'show', 'pos', 'filter_key', 'tracked', 'track_offset', 'default_value', 'hour24', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Tooltip(DPGContainersBase):
    parent: typing.Union[int, str]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    show: bool = True
    delay: float = 0.0
    hide_on_activity: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_tooltip'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('parent', 'label', 'user_data', 'use_internal_label', 'tag', 'show', 'delay', 'hide_on_activity', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class TreeNode(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    payload_type: str = '$$DPG_PAYLOAD'
    drag_callback: typing.Callable | None = None
    drop_callback: typing.Callable | None = None
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    filter_key: str = ''
    delay_search: bool = False
    tracked: bool = False
    track_offset: float = 0.5
    default_open: bool = False
    open_on_double_click: bool = False
    open_on_arrow: bool = False
    leaf: bool = False
    bullet: bool = False
    selectable: bool = False
    span_text_width: bool = False
    span_full_width: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_tree_node'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'before', 'payload_type', 'drag_callback', 'drop_callback', 'show', 'pos', 'filter_key', 'delay_search', 'tracked', 'track_offset', 'default_open', 'open_on_double_click', 'open_on_arrow', 'leaf', 'bullet', 'selectable', 'span_text_width', 'span_full_width', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ValueRegistry(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_value_registry'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ViewportDrawlist(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    show: bool = True
    filter_key: str = ''
    delay_search: bool = False
    front: bool = True

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_viewport_drawlist'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'show', 'filter_key', 'delay_search', 'front', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class ViewportMenuBar(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    indent: int = -1
    parent: typing.Union[int, str] = 0
    show: bool = True
    delay_search: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_viewport_menu_bar'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'indent', 'parent', 'show', 'delay_search', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class Window(DPGContainersBase):
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    width: int = 0
    height: int = 0
    indent: int = -1
    show: bool = True
    pos: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=list)
    delay_search: bool = False
    min_size: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=lambda: [100, 100])
    max_size: typing.Union[typing.List[int], typing.Tuple[int, ...]] = field(default_factory=lambda: [30000, 30000])
    menubar: bool = False
    collapsed: bool = False
    autosize: bool = False
    no_resize: bool = False
    unsaved_document: bool = False
    no_title_bar: bool = False
    no_move: bool = False
    no_scrollbar: bool = False
    no_collapse: bool = False
    horizontal_scrollbar: bool = False
    no_focus_on_appearing: bool = False
    no_bring_to_front_on_focus: bool = False
    no_close: bool = False
    no_background: bool = False
    modal: bool = False
    popup: bool = False
    no_saved_settings: bool = False
    no_open_over_existing_popup: bool = True
    no_scroll_with_mouse: bool = False
    on_close: typing.Callable | None = None

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'add_window'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('label', 'user_data', 'use_internal_label', 'tag', 'width', 'height', 'indent', 'show', 'pos', 'delay_search', 'min_size', 'max_size', 'menubar', 'collapsed', 'autosize', 'no_resize', 'unsaved_document', 'no_title_bar', 'no_move', 'no_scrollbar', 'no_collapse', 'horizontal_scrollbar', 'no_focus_on_appearing', 'no_bring_to_front_on_focus', 'no_close', 'no_background', 'modal', 'popup', 'no_saved_settings', 'no_open_over_existing_popup', 'no_scroll_with_mouse', 'on_close', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dArrow(DPGContainersBase):
    p1: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p2: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)
    thickness: float = 1.0
    size: int = 4

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_arrow'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('p1', 'p2', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'color', 'thickness', 'size', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dBezierCubic(DPGContainersBase):
    p1: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p2: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p3: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p4: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)
    thickness: float = 1.0
    segments: int = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_bezier_cubic'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('p1', 'p2', 'p3', 'p4', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'color', 'thickness', 'segments', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dBezierQuadratic(DPGContainersBase):
    p1: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p2: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p3: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)
    thickness: float = 1.0
    segments: int = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_bezier_quadratic'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('p1', 'p2', 'p3', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'color', 'thickness', 'segments', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dCircle(DPGContainersBase):
    center: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    radius: float
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)
    fill: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, -255)
    thickness: float = 1.0
    segments: int = 0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_circle'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('center', 'radius', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'color', 'fill', 'thickness', 'segments', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dEllipse(DPGContainersBase):
    pmin: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    pmax: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)
    fill: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, -255)
    thickness: float = 1.0
    segments: int = 32

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_ellipse'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('pmin', 'pmax', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'color', 'fill', 'thickness', 'segments', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dImage(DPGContainersBase):
    texture_tag: typing.Union[int, str]
    pmin: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    pmax: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    uv_min: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0)
    uv_max: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (1.0, 1.0)
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_image'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('texture_tag', 'pmin', 'pmax', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'uv_min', 'uv_max', 'color', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dImageQuad(DPGContainersBase):
    texture_tag: typing.Union[int, str]
    p1: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p2: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p3: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p4: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    uv1: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 0.0)
    uv2: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (1.0, 0.0)
    uv3: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (1.0, 1.0)
    uv4: typing.Union[typing.List[float], typing.Tuple[float, ...]] = (0.0, 1.0)
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_image_quad'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('texture_tag', 'p1', 'p2', 'p3', 'p4', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'uv1', 'uv2', 'uv3', 'uv4', 'color', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dLayer(DPGContainersBase):


    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_layer'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dLine(DPGContainersBase):
    p1: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p2: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)
    thickness: float = 1.0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_line'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('p1', 'p2', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'color', 'thickness', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dPolygon(DPGContainersBase):
    points: typing.List[typing.List[float]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)
    fill: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, -255)
    thickness: float = 1.0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_polygon'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('points', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'color', 'fill', 'thickness', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dPolyline(DPGContainersBase):
    points: typing.List[typing.List[float]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    closed: bool = False
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)
    thickness: float = 1.0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_polyline'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('points', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'closed', 'color', 'thickness', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dQuad(DPGContainersBase):
    p1: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p2: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p3: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p4: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)
    fill: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, -255)
    thickness: float = 1.0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_quad'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('p1', 'p2', 'p3', 'p4', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'color', 'fill', 'thickness', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dRectangle(DPGContainersBase):
    pmin: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    pmax: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)
    fill: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, -255)
    multicolor: bool = False
    rounding: float = 0.0
    thickness: float = 1.0
    corner_colors: Any | None = None

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_rectangle'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('pmin', 'pmax', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'color', 'fill', 'multicolor', 'rounding', 'thickness', 'corner_colors', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dText(DPGContainersBase):
    pos: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    text: str
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)
    size: float = 10.0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_text'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('pos', 'text', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'color', 'size', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None



@dataclass(eq=False)
class dTriangle(DPGContainersBase):
    p1: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p2: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    p3: typing.Union[typing.List[float], typing.Tuple[float, ...]]
    label: str | None = None
    user_data: Any | None = None
    use_internal_label: bool = True
    tag: typing.Union[int, str] = 0
    parent: typing.Union[int, str] = 0
    before: typing.Union[int, str] = 0
    show: bool = True
    color: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (255, 255, 255, 255)
    fill: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (0, 0, 0, -255)
    thickness: float = 1.0

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'draw_triangle'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('p1', 'p2', 'p3', 'label', 'user_data', 'use_internal_label', 'tag', 'parent', 'before', 'show', 'color', 'fill', 'thickness', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None


@dataclass(eq=False)
class Popup(DPGContainersBase):
    parent: typing.Union[int, str]
    mousebutton: int = 0
    modal: bool = False
    tag: typing.Union[int, str] = 0
    min_size: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (100, 100)
    max_size: typing.Union[typing.List[int], typing.Tuple[int, ...]] = (30000, 30000)
    no_move: bool = False
    no_background: bool = False

    classes: typing.List[str] = field(default_factory=list)

    dpg_function_name: ClassVar[str] = 'popup'
    dpg_arguments: ClassVar[tuple[str, ...]] = ('parent', 'mousebutton', 'modal', 'tag', 'min_size', 'max_size', 'no_move', 'no_background', )
    dpg_function_cache: ClassVar[Callable | None] = None
    dpg_value_cast: ClassVar[type | None] = None
