**Prerequisites**

- Access to a CDF Project.
- Know how to install and setup `Python` using `uv` and `pyproject.toml`.
- Know how to use `git` for version control.
- Know how to use a terminal, so you can run `pygen` from the command line to
  generate the SDK.


When you are ready to develop a solution based on a data model, you can use `pygen` to genrate a SDK that you check
into version history. This SDK can be used by the developer team to interact with CDF.

This pages shows the recommended project structure for a CDF SDK project.

## Project Structure

The following is the recommended project structure for a CDF SDK project:
```
📦my_python_application
 ┣ 📂client - CDF SDK generated by pygen
 ┣ ┣ 📂_api
 ┣ ┣ 📂data_classes
 ┃ ┗ 📜__init__.py
 ┃ ┗ 📜_api_client.py
 ...
 ┣ 📜.gitignore - Git ignore file
 ┣ 📜.secret.toml -Secret configuration.
 ┣ 📜pyproject.toml - Project configuration file
 ...
```

=== ".gitignore"

    ```
    # The config contains secrets, thus we do not want
    # to commit it to version history
    .secret.toml
    ```


=== "pyproject.toml"

    We recommend keeping the configuration for `pygen` in the `pyproject.toml` file. This way, the configuration is
    versioned together with the generated SDK. Making it easy for any team member to regenerate the SDK.

    ```toml
    ...

    [tool.pygen]
    data_models = [
        ["IntegrationTestsImmutable", "Movie", "2"],
    ]
    tenant_id = "<cdf-project>"
    client_id = "<client-id>"
    cdf_cluster = "<cdf-cluster>"
    cdf_project = "<cdf-project>"
    top_level_package = "movie_domain.client"
    client_name = "MovieClient"
    output_dir = "."

    ...

    [dependency-groups]
    dev = [
        "cognite-pygen[all]",
        ```

=== ".secret.toml"

    **IMPORTANT:** The `.secret.toml` file contains secrets and must **NOT** be committed to version history.
    ``` bash
    [cognite]
      client_secret = "<client-secret>"
    ```

## Generating the SDK and Checking it into Version History

The instructions below assume you use `git` for version control.

**Prerequisites:** Instantiated a git repository and added the `pyproject.toml`, `.gitignore` and `.secret.toml`
in the root of the repository. (Create the files and run `git init && git add . &&  git commit -m "initial commit"`)

### Generating the SDK
1. Check out a new branch for the SDK generation. (e.g. `git checkout -b sdk-generation`)
2. Ensure that `pygen` is installed and configured. (See [Installation](#installation))
3. Run `pygen generate` to generate the SDK. (e.g. `pygen`). `pygen` will pick ut the configuration from the
   `pyproject.toml` and `.secret.toml` files.
4. Commit the generated SDK to version history. (e.g. `git add . && git commit -m "generated sdk"`)
5. Push the branch to the remote repository. (e.g. `git push origin sdk-generation`)
6. Create a pull request for the branch.
7. Merge the pull request.
