# coding: utf-8

# flake8: noqa

"""
    URLR API Reference

    API powering the features of URLR.<br><br>Note that in order to facilitate integration, we provide SDKs for various languages at https://github.com/URLR.<br><br>Key API principles:<br>         <ul><li>All dates follow **ISO-8601** format</li><li>Most errors follow **RFC 9457** standard</li><li>All responses are delivered in English</li></ul>

    The version of the OpenAPI document: 1.10
    Contact: contact@urlr.me
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "2.11.0"

# Define package exports
__all__ = [
    "AccessTokensApi",
    "DomainsApi",
    "FoldersApi",
    "LinksApi",
    "QRCodesApi",
    "StatisticsApi",
    "WorkspacesApi",
    "ApiResponse",
    "ApiClient",
    "Configuration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "BaseLinkRequest",
    "BaseLinkRequestMetatag",
    "BaseLinkRequestQrcode",
    "CreateAccessToken200Response",
    "CreateAccessToken401Response",
    "CreateAccessTokenRequest",
    "CreateDomain200Response",
    "CreateDomain409Response",
    "CreateDomainRequest",
    "CreateLink429Response",
    "CreateLinkRequest",
    "CreateQrCodeRequest",
    "CreateQrCodeRequestOneOf",
    "CreateQrCodeRequestOneOf1",
    "EditLink500Response",
    "EditLinkRequest",
    "GetFolders200Response",
    "GetFolders200ResponseFoldersInner",
    "GetLink200Response",
    "GetLink200ResponseGeolinksInner",
    "GetLink200ResponseGeolinksInnerConditionsInner",
    "GetLink200ResponseMetatag",
    "GetLink200ResponseQrcode",
    "GetLink200ResponseTagsInner",
    "GetLink200ResponseUtm",
    "GetLink401Response",
    "GetLink404Response",
    "GetLink422Response",
    "GetStatistics200Response",
    "GetStatisticsRequest",
    "GetTeams200Response",
    "GetTeams200ResponseTeamsInner",
    "RefreshAccessToken401Response",
    "RefreshAccessTokenRequest",
]

# import apis into sdk package
from urlr.api.access_tokens_api import AccessTokensApi as AccessTokensApi
from urlr.api.domains_api import DomainsApi as DomainsApi
from urlr.api.folders_api import FoldersApi as FoldersApi
from urlr.api.links_api import LinksApi as LinksApi
from urlr.api.qr_codes_api import QRCodesApi as QRCodesApi
from urlr.api.statistics_api import StatisticsApi as StatisticsApi
from urlr.api.workspaces_api import WorkspacesApi as WorkspacesApi

# import ApiClient
from urlr.api_response import ApiResponse as ApiResponse
from urlr.api_client import ApiClient as ApiClient
from urlr.configuration import Configuration as Configuration
from urlr.exceptions import OpenApiException as OpenApiException
from urlr.exceptions import ApiTypeError as ApiTypeError
from urlr.exceptions import ApiValueError as ApiValueError
from urlr.exceptions import ApiKeyError as ApiKeyError
from urlr.exceptions import ApiAttributeError as ApiAttributeError
from urlr.exceptions import ApiException as ApiException

# import models into sdk package
from urlr.models.base_link_request import BaseLinkRequest as BaseLinkRequest
from urlr.models.base_link_request_metatag import BaseLinkRequestMetatag as BaseLinkRequestMetatag
from urlr.models.base_link_request_qrcode import BaseLinkRequestQrcode as BaseLinkRequestQrcode
from urlr.models.create_access_token200_response import CreateAccessToken200Response as CreateAccessToken200Response
from urlr.models.create_access_token401_response import CreateAccessToken401Response as CreateAccessToken401Response
from urlr.models.create_access_token_request import CreateAccessTokenRequest as CreateAccessTokenRequest
from urlr.models.create_domain200_response import CreateDomain200Response as CreateDomain200Response
from urlr.models.create_domain409_response import CreateDomain409Response as CreateDomain409Response
from urlr.models.create_domain_request import CreateDomainRequest as CreateDomainRequest
from urlr.models.create_link429_response import CreateLink429Response as CreateLink429Response
from urlr.models.create_link_request import CreateLinkRequest as CreateLinkRequest
from urlr.models.create_qr_code_request import CreateQrCodeRequest as CreateQrCodeRequest
from urlr.models.create_qr_code_request_one_of import CreateQrCodeRequestOneOf as CreateQrCodeRequestOneOf
from urlr.models.create_qr_code_request_one_of1 import CreateQrCodeRequestOneOf1 as CreateQrCodeRequestOneOf1
from urlr.models.edit_link500_response import EditLink500Response as EditLink500Response
from urlr.models.edit_link_request import EditLinkRequest as EditLinkRequest
from urlr.models.get_folders200_response import GetFolders200Response as GetFolders200Response
from urlr.models.get_folders200_response_folders_inner import GetFolders200ResponseFoldersInner as GetFolders200ResponseFoldersInner
from urlr.models.get_link200_response import GetLink200Response as GetLink200Response
from urlr.models.get_link200_response_geolinks_inner import GetLink200ResponseGeolinksInner as GetLink200ResponseGeolinksInner
from urlr.models.get_link200_response_geolinks_inner_conditions_inner import GetLink200ResponseGeolinksInnerConditionsInner as GetLink200ResponseGeolinksInnerConditionsInner
from urlr.models.get_link200_response_metatag import GetLink200ResponseMetatag as GetLink200ResponseMetatag
from urlr.models.get_link200_response_qrcode import GetLink200ResponseQrcode as GetLink200ResponseQrcode
from urlr.models.get_link200_response_tags_inner import GetLink200ResponseTagsInner as GetLink200ResponseTagsInner
from urlr.models.get_link200_response_utm import GetLink200ResponseUtm as GetLink200ResponseUtm
from urlr.models.get_link401_response import GetLink401Response as GetLink401Response
from urlr.models.get_link404_response import GetLink404Response as GetLink404Response
from urlr.models.get_link422_response import GetLink422Response as GetLink422Response
from urlr.models.get_statistics200_response import GetStatistics200Response as GetStatistics200Response
from urlr.models.get_statistics_request import GetStatisticsRequest as GetStatisticsRequest
from urlr.models.get_teams200_response import GetTeams200Response as GetTeams200Response
from urlr.models.get_teams200_response_teams_inner import GetTeams200ResponseTeamsInner as GetTeams200ResponseTeamsInner
from urlr.models.refresh_access_token401_response import RefreshAccessToken401Response as RefreshAccessToken401Response
from urlr.models.refresh_access_token_request import RefreshAccessTokenRequest as RefreshAccessTokenRequest
