# coding: utf-8

"""
    URLR API Reference

    API powering the features of URLR.<br><br>Note that in order to facilitate integration, we provide SDKs for various languages at https://github.com/URLR.<br><br>Key API principles:<br>         <ul><li>All dates follow **ISO-8601** format</li><li>Most errors follow **RFC 9457** standard</li><li>All responses are delivered in English</li></ul>

    The version of the OpenAPI document: 1.10
    Contact: contact@urlr.me
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class BaseLinkRequestQrcode(BaseModel):
    """
    QR Code
    """ # noqa: E501
    size: Optional[Annotated[int, Field(le=1000, strict=True, ge=100)]] = Field(default=600, description="The size of the QR code (px)")
    format: Optional[StrictStr] = Field(default='png', description="The format of the QR code")
    margin: Optional[StrictInt] = Field(default=0, description="The margin around the QR code (px)")
    background_color: Optional[StrictStr] = Field(default='#ffffff', description="The background color of the QR code (hexadecimal)")
    foreground_color: Optional[StrictStr] = Field(default='#000000', description="The foreground color of the QR code (hexadecimal)")
    __properties: ClassVar[List[str]] = ["size", "format", "margin", "background_color", "foreground_color"]

    @field_validator('format')
    def format_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['png', 'webp', 'svg']):
            raise ValueError("must be one of enum values ('png', 'webp', 'svg')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BaseLinkRequestQrcode from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BaseLinkRequestQrcode from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "size": obj.get("size") if obj.get("size") is not None else 600,
            "format": obj.get("format") if obj.get("format") is not None else 'png',
            "margin": obj.get("margin") if obj.get("margin") is not None else 0,
            "background_color": obj.get("background_color") if obj.get("background_color") is not None else '#ffffff',
            "foreground_color": obj.get("foreground_color") if obj.get("foreground_color") is not None else '#000000'
        })
        return _obj


