# coding: utf-8

"""
    URLR API Reference

    API powering the features of URLR.<br><br>Note that in order to facilitate integration, we provide SDKs for various languages at https://github.com/URLR.<br><br>Key API principles:<br>         <ul><li>All dates follow **ISO-8601** format</li><li>Most errors follow **RFC 9457** standard</li><li>All responses are delivered in English</li></ul>

    The version of the OpenAPI document: 1.10
    Contact: contact@urlr.me
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from urlr.models.base_link_request_metatag import BaseLinkRequestMetatag
from urlr.models.base_link_request_qrcode import BaseLinkRequestQrcode
from urlr.models.get_link200_response_geolinks_inner import GetLink200ResponseGeolinksInner
from urlr.models.get_link200_response_utm import GetLink200ResponseUtm
from typing import Optional, Set
from typing_extensions import Self

class EditLinkRequest(BaseModel):
    """
    EditLinkRequest
    """ # noqa: E501
    url: Optional[Annotated[str, Field(strict=True, max_length=4096)]] = Field(default=None, description="URL to shorten")
    folder_id: Optional[StrictStr] = Field(default=None, description="Folder API ID")
    domain: Optional[StrictStr] = Field(default=None, description="Domain")
    code: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Custom short code")
    label: Optional[StrictStr] = Field(default=None, description="Label")
    tags: Optional[Annotated[List[StrictStr], Field(max_length=3)]] = Field(default=None, description="Tags")
    password: Optional[StrictStr] = Field(default=None, description="Password")
    qrcode: Optional[BaseLinkRequestQrcode] = None
    utm: Optional[GetLink200ResponseUtm] = None
    metatag: Optional[BaseLinkRequestMetatag] = None
    geolinks: Optional[List[GetLink200ResponseGeolinksInner]] = Field(default=None, description="Dynamic routing conditions")
    delete_at: Optional[datetime] = Field(default=None, description="Scheduled deletion date")
    expired_at: Optional[datetime] = Field(default=None, description="Scheduled expiration date")
    expired_url: Optional[StrictStr] = Field(default=None, description="Expiration URL")
    delete_after_expiration: Optional[StrictBool] = Field(default=False, description="Whether or not to remove the link after the expiry date")
    __properties: ClassVar[List[str]] = ["url", "folder_id", "domain", "code", "label", "tags", "password", "qrcode", "utm", "metatag", "geolinks", "delete_at", "expired_at", "expired_url", "delete_after_expiration"]

    @field_validator('code')
    def code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9!-]{2,50}$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9!-]{2,50}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EditLinkRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of qrcode
        if self.qrcode:
            _dict['qrcode'] = self.qrcode.to_dict()
        # override the default output from pydantic by calling `to_dict()` of utm
        if self.utm:
            _dict['utm'] = self.utm.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metatag
        if self.metatag:
            _dict['metatag'] = self.metatag.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in geolinks (list)
        _items = []
        if self.geolinks:
            for _item_geolinks in self.geolinks:
                if _item_geolinks:
                    _items.append(_item_geolinks.to_dict())
            _dict['geolinks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EditLinkRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "folder_id": obj.get("folder_id"),
            "domain": obj.get("domain"),
            "code": obj.get("code"),
            "label": obj.get("label"),
            "tags": obj.get("tags"),
            "password": obj.get("password"),
            "qrcode": BaseLinkRequestQrcode.from_dict(obj["qrcode"]) if obj.get("qrcode") is not None else None,
            "utm": GetLink200ResponseUtm.from_dict(obj["utm"]) if obj.get("utm") is not None else None,
            "metatag": BaseLinkRequestMetatag.from_dict(obj["metatag"]) if obj.get("metatag") is not None else None,
            "geolinks": [GetLink200ResponseGeolinksInner.from_dict(_item) for _item in obj["geolinks"]] if obj.get("geolinks") is not None else None,
            "delete_at": obj.get("delete_at"),
            "expired_at": obj.get("expired_at"),
            "expired_url": obj.get("expired_url"),
            "delete_after_expiration": obj.get("delete_after_expiration") if obj.get("delete_after_expiration") is not None else False
        })
        return _obj


