"""Full-screen plugin framework for terminal takeover.

This module provides a reusable framework for plugins to take complete
terminal control using the proven modal system architecture.
"""

from .manager import FullScreenManager
from .renderer import FullScreenRenderer
from .plugin import FullScreenPlugin
from .session import FullScreenSession
from .command_integration import FullScreenCommandIntegrator

__all__ = [
    "FullScreenManager",
    "FullScreenRenderer",
    "FullScreenPlugin",
    "FullScreenSession",
    "FullScreenCommandIntegrator"
]