## Архитектурный обзор релиза: Pre-Alpha

### 1. Назначение релиза

- Цель: техническая валидация конвейера «сбор → нормализация → хранение → доступ/поиск»
- Границы: один источник (Telegram), без UI, без шифрования, single-tenant

---
### 1.1 Целевой результат

- Получить рабочий end-to-end поток от источника данных до семантического поиска по нормализованному контенту
- Подтвердить масштабирование по типам контента (текст/изображения/аудио/видео/документы) и базовую наблюдаемость

### 1.2 Подход

- Модульная архитектура с разделением: коннекторы → очередь → обработчики → хранилища → API
- Минимально достаточные контракты взаимодействия, без UI и без криптографии на релизе

---
### 2. Состав компонентов и роли

- Connector.Telegram — сбор сообщений и публикация в ingest.messages
- Worker.Extract — извлечение текста из документов
- Worker.Vision — OCR/описание изображений
- Worker.STT — транскрибация аудио/видео
- Service.Embedding — генерация эмбеддингов
- Storage.SQL — хранение нормализованных записей (текст + метаданные)
- Storage.Vector — хранение векторов и k-NN поиск
- API.Query — фильтрация и семантический поиск

### 3. Публичные контракты (сводно)

- Очереди/события:
  - ingest.messages — входной поток сообщений от коннектора
  - normalize.results — результаты обработки
  - vector.upserts — публикация эмбеддингов
- HTTP API:
  - GET /items — фильтрация по дате, source, content_type, metadata, пагинация
  - GET /search — семантический поиск (q, k)

Примечание: детализация полей сообщений и правил — в спецификациях компонентов.


---
### 4. Последовательности (runtime)

1) Онлайн-сообщение (Telegram → Поиск)
- Connector.Telegram публикует IngestMessage → очередь ingest.messages
- По типу контента выбирается обработчик:
  - text → Storage.SQL (сохранение записи)
  - image → Worker.Vision → normalize.results → Storage.SQL
  - audio/video → Worker.STT → normalize.results → Storage.SQL
  - document → Worker.Extract → normalize.results → Storage.SQL
- Service.Embedding генерирует вектор → Storage.Vector
- Клиент вызывает API.Query /search → Storage.Vector (k-NN) → обогащение из Storage.SQL → ответ

2) Исторический импорт
- CLI/инструмент инициирует батч → Connector.Telegram (режим import)
- Публикация в ingest.messages → дальнейшие шаги как в (1)

3) Доступ к данным (фильтрация)
- Клиент → API.Query /items с фильтрами → Storage.SQL → пагинированный ответ

---
### 5. Объём работ (что делаем в релизе)

- Реализовать Connector.Telegram с online и историческим импортом
- Настроить пайплайн обработки для всех типов контента (text/image/audio/video/document)
- Обеспечить сохранение нормализованного текста и метаданных, генерацию эмбеддингов и поиск
- Предоставить API для фильтрации и семантического поиска
- Базовая наблюдаемость (логи, метрики), ручная конфигурация

---
### 6. Границы релиза (Scope)

In Scope
- Один источник: Telegram
- Текстовая нормализация контента и семантический поиск
- Очереди, обработчики, SQL+Vector хранилища, API без аутентификации

Out of Scope
- UI и пользовательские сценарии
- Многотенантность, шифрование, прод-эксплуатация
- Хранение оригинальных мультимедиа

---
### 7. Границы "Done" для Pre-Alpha

- End-to-end поток работает стабильно на тестовых данных
- Обработаны все заявленные типы контента
- Поиск по векторной базе возвращает релевантные результаты
- В наличии минимальные логи и метрики для диагностики


