# Product Vision: Kenoma

## 1. Vision (1–2 предложения)
- Kenoma — AI-powered "second brain" that автоматически превращает разрозненную цифровую информацию в actionable intelligence
- Мы создаем операционную систему для knowledge work, где AI понимает ваш полный контекст

## 2. Почему сейчас
- LLM революция: ChatGPT показал потенциал AI для knowledge work, но им не хватает персонального контекста
- Information overload: профессионалы тратят 28% времени на email, 20% на поиск информации
- Context switching кризис: каждое переключение между приложениями теряет контекст

## 3. Для кого (аудитория/персоны)
- Персоны: AI-forward knowledge workers, startup founders, software architects, product managers
- Сегменты: B2C (early adopters), готовые экспериментировать с AI-workflows

## 4. Проблема (Pain Points)
- Fragmentation Crisis: критическая информация разбросана по email, Slack, Notion, Google Docs
- Context Bankruptcy: каждое переключение приложений теряет контекст
- AI Opportunity Gap: LLMs мощные, но без персонального контекста требуют manual copy-paste

## 5. Ценность (Value Proposition)
- 20-25% рост продуктивности knowledge workers
- 35% сокращение времени на поиск информации
- Автоматическая организация knowledge без manual effort

## 6. Что мы строим (Capabilities)
- Automatic data aggregation из всех digital touchpoints
- AI processing для поиска связей и patterns в информации  
- Context-aware AI assistance на базе полного knowledge graph
- Privacy-by-design с шифрованием и изоляцией данных

## 7. Дифференциаторы
- Complete context understanding (не просто поиск или note-taking)
- AI-native workflows вместо manual information management
- Platform approach для building AI-powered knowledge applications

## 8. Принципы продукта
- Privacy-by-design: данные пользователя остаются его данными
- Zero manual effort: автоматическая организация без user input
- AI-augmented, not AI-replaced: AI усиливает человеческие возможности

## 14. Глоссарий
- Knowledge Graph — связанная структура данных с персональной информацией пользователя
- Context Switching — переключение между приложениями с потерей рабочего контекста
- AI-native Workflow — рабочий процесс, построенный вокруг возможностей AI