"""v9.0.1

Revision ID: 8f2835b87d6e
Revises: ddb65b675e43
Create Date: 2025-08-12 18:03:17.691230

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision: str = "8f2835b87d6e"
down_revision: Union[str, None] = "ddb65b675e43"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    # Add default value to BatteryType.tco_parameters
    op.alter_column(
        "BatteryType",
        "tco_parameters",
        server_default='{"useful_life": 7, "cost_escalation": -0.03, "procurement_cost": null}',
        existing_type=postgresql.JSONB(astext_type=sa.Text()),  # type: ignore
        existing_nullable=True,
    )

    # Add default value to ChargingPointType.tco_parameters
    op.alter_column(
        "ChargingPointType",
        "tco_parameters",
        server_default='{"useful_life": 20, "cost_escalation": 0.02, "procurement_cost": null}',
        existing_type=postgresql.JSONB(astext_type=sa.Text()),  # type: ignore
        existing_nullable=True,
    )

    # Add default value to Scenario.tco_parameters
    op.alter_column(
        "Scenario",
        "tco_parameters",
        server_default='{"taxes": 0, "insurance": 0, "pef_wages": 0.025, "maint_cost": null, "pef_energy": 0.038, "staff_cost": null, "energy_cost": null, "pef_general": 0.02, "interest_rate": 0.04, "pef_insurance": 0.02, "inflation_rate": 0.02, "maint_infr_cost": null, "project_duration": 20}',
        existing_type=postgresql.JSONB(astext_type=sa.Text()),  # type: ignore
        existing_nullable=True,
    )

    # Add default value to Station.tco_parameters
    op.alter_column(
        "Station",
        "tco_parameters",
        server_default='{"useful_life": 20, "cost_escalation": 0.02, "procurement_cost": null}',
        existing_type=postgresql.JSONB(astext_type=sa.Text()),  # type: ignore
        existing_nullable=True,
    )

    # Add default value to VehicleType.tco_parameters
    op.alter_column(
        "VehicleType",
        "tco_parameters",
        server_default='{"useful_life": 14, "cost_escalation": 0.02, "procurement_cost": null}',
        existing_type=postgresql.JSONB(astext_type=sa.Text()),  # type: ignore
        existing_nullable=True,
    )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    # Remove default value from BatteryType.tco_parameters
    op.alter_column(
        "BatteryType",
        "tco_parameters",
        server_default=None,
        existing_type=postgresql.JSONB(astext_type=sa.Text()),  # type: ignore
        existing_nullable=True,
    )

    # Remove default value from ChargingPointType.tco_parameters
    op.alter_column(
        "ChargingPointType",
        "tco_parameters",
        server_default=None,
        existing_type=postgresql.JSONB(astext_type=sa.Text()),  # type: ignore
        existing_nullable=True,
    )

    # Remove default value from Scenario.tco_parameters
    op.alter_column(
        "Scenario",
        "tco_parameters",
        server_default=None,
        existing_type=postgresql.JSONB(astext_type=sa.Text()),  # type: ignore
        existing_nullable=True,
    )

    # Remove default value from Station.tco_parameters
    op.alter_column(
        "Station",
        "tco_parameters",
        server_default=None,
        existing_type=postgresql.JSONB(astext_type=sa.Text()),  # type: ignore
        existing_nullable=True,
    )

    # Remove default value from VehicleType.tco_parameters
    op.alter_column(
        "VehicleType",
        "tco_parameters",
        server_default=None,
        existing_type=postgresql.JSONB(astext_type=sa.Text()),  # type: ignore
        existing_nullable=True,
    )

    # ### end Alembic commands ###
