"""9_0_0

Revision ID: ddb65b675e43
Revises: e8f748c14b93
Create Date: 2025-07-29 15:10:04.228371

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = "ddb65b675e43"
down_revision: Union[str, None] = "e8f748c14b93"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "ChargingPointType",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("scenario_id", sa.BigInteger(), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.Column("name_short", sa.Text(), nullable=True),
        sa.Column(
            "tco_parameters", postgresql.JSONB(astext_type=sa.Text()), nullable=True  # type: ignore
        ),
        sa.ForeignKeyConstraint(
            ["scenario_id"],
            ["Scenario.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.add_column(
        "Area", sa.Column("charging_point_type_id", sa.BigInteger(), nullable=True)
    )
    op.create_foreign_key(
        None, "Area", "ChargingPointType", ["charging_point_type_id"], ["id"]
    )
    op.add_column(
        "BatteryType",
        sa.Column(
            "tco_parameters", postgresql.JSONB(astext_type=sa.Text()), nullable=True  # type: ignore
        ),
    )
    op.add_column(
        "Scenario",
        sa.Column(
            "tco_parameters", postgresql.JSONB(astext_type=sa.Text()), nullable=True  # type: ignore
        ),
    )
    op.add_column(
        "Station", sa.Column("charging_point_type_id", sa.BigInteger(), nullable=True)
    )
    op.add_column(
        "Station",
        sa.Column(
            "tco_parameters", postgresql.JSONB(astext_type=sa.Text()), nullable=True  # type: ignore
        ),
    )
    op.create_foreign_key(
        None, "Station", "ChargingPointType", ["charging_point_type_id"], ["id"]
    )
    op.add_column(
        "VehicleType",
        sa.Column(
            "tco_parameters", postgresql.JSONB(astext_type=sa.Text()), nullable=True  # type: ignore
        ),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("VehicleType", "tco_parameters")
    op.drop_constraint(None, "Station", type_="foreignkey")  # type: ignore
    op.drop_column("Station", "tco_parameters")
    op.drop_column("Station", "charging_point_type_id")
    op.drop_column("Scenario", "tco_parameters")
    op.drop_column("BatteryType", "tco_parameters")
    op.drop_constraint(None, "Area", type_="foreignkey")  # type: ignore
    op.drop_column("Area", "charging_point_type_id")
    op.drop_table("ChargingPointType")
    # ### end Alembic commands ###
