from .list_of_practical import practical_list, subject_list
import os
import shutil

def choose_semester() -> int:
    while True:
        try:
            semester = int(input("Please choose your semester: \n1. Sem 1\n2. Sem 2\n3. Sem 3\n4. Sem 4\n"))
            if semester == 1 or semester == 3:
                return semester
            elif semester == 2 or semester == 4:
                print("🙇‍♂️ Sorry the data is not available.\n")
            else:
                print("❌ Please enter a valid semester number.\n")
        except ValueError:
            print("❌ Please enter a valid semester number.\n")


def choose_subject(semester: int) -> int | None:
    subjects = subject_list.get(str(semester), [])
    if subjects:
        print("\nPlease select one subject from Semester ", semester, ":\n")
        for sub in subjects:
            print(sub)
    else:
        print("🙇‍♂️ Sorry the data is not available.\n")
        return None

    while True:
        try:
            select_subject = int(input("Enter subject number: "))
            if semester == 1 and 1 <= select_subject <= 5:
                return select_subject
            elif semester == 3 and 1 <= select_subject <= 4:
                return select_subject
            else:
                print("❌ Please enter a valid subject number.\n")
        except ValueError:
            print("❌ Please enter a valid subject number.\n")


def choose_practical(semester: int, subject: int) -> tuple[str, str] | tuple[None, None]:
    sem_data = practical_list.get(str(semester), {})
    subject_data = sem_data.get(str(subject), {})

    if not subject_data:
        print("🙇‍♂️ Sorry the data is not available.\n")
        return None, None

    print("Please select which practical do you want: ")

    for key, value in subject_data.items():
        print(f"{key}. {value['name']}")

    while True:
        try:
            choice = int(input("Enter practical number: "))
            if str(choice) in subject_data:
                selected = subject_data[str(choice)]
                return selected['name'], selected['path']
            else:
                print("❌ Please enter a valid practical number.")
        except ValueError:
            print("❌ Please enter a valid practical number.")


def choose_action(path: str):
    print("\n\nPlease select the action you want to perform:")
    print("1. Print the practical text")
    print("2. Get the practical file path")
    print("3. Download the practical file (copy to current directory)")

    relative_path = path

    # Absolute path to the file
    base_dir = os.path.dirname(os.path.abspath(__file__))
    file_path = os.path.join(base_dir, relative_path)

    while True:
        try:
            action = int(input("Enter action number: "))

            if action == 1:
                if os.path.exists(file_path):
                    with open(file_path, 'r') as file:
                        print("\n--- Practical Content ---")
                        print(file.read())
                else:
                    print(f"❌ File not found: {file_path}")
                break

            elif action == 2:
                print(f"📁 Full File Path: {file_path}")
                break

            elif action == 3:
                if os.path.exists(file_path):
                    file_name = os.path.basename(file_path)
                    destination = os.path.join(os.getcwd(), file_name)
                    shutil.copy(file_path, destination)
                    print(f"✅ File copied to current folder: {destination}")
                else:
                    print(f"❌ File not found: {file_path}")
                break
            else:
                print("❌ Invalid action number.")
        except ValueError:
            print("❌ Invalid action number.")

def start():
    semester = choose_semester()

    subject = choose_subject(semester)

    practical_name, practical_path = choose_practical(semester, subject)

    if practical_path is None:
        return

    choose_action(practical_path)

# def start():
#     print("Hello, please select which practical you want:")
#
#     for item in practical_list:
#         print(list(item.keys())[0])
#
#     while True:
#         try:
#             practical_index = int(input("Enter practical number: "))
#             if 1 <= practical_index <= len(practical_list):
#                 selected = practical_list[practical_index - 1]
#                 title = list(selected.keys())[0]
#                 relative_path = selected[title]
#
#                 # Absolute path to the file
#                 base_dir = os.path.dirname(os.path.abspath(__file__))
#                 file_path = os.path.join(base_dir, relative_path)
#
#                 print(f"\nYou selected: {title}")
#
#                 print("\nPlease select the action you want to perform:")
#                 print("1. Print the practical text")
#                 print("2. Get the practical file path")
#                 print("3. Download the practical file (copy to current directory)")
#
#                 try:
#                     action = int(input("Enter action number: "))
#
#                     if action == 1:
#                         if os.path.exists(file_path):
#                             with open(file_path, 'r') as file:
#                                 print("\n--- Practical Content ---")
#                                 print(file.read())
#                         else:
#                             print(f"❌ File not found: {file_path}")
#
#                     elif action == 2:
#                         print(f"📁 Full File Path: {file_path}")
#
#                     elif action == 3:
#                         if os.path.exists(file_path):
#                             file_name = os.path.basename(file_path)
#                             destination = os.path.join(os.getcwd(), file_name)
#                             shutil.copy(file_path, destination)
#                             print(f"✅ File copied to current folder: {destination}")
#                         else:
#                             print(f"❌ File not found: {file_path}")
#
#                     else:
#                         print("❌ Invalid action number.")
#
#                 except ValueError:
#                     print("❌ Please enter a valid number.")
#                 break
#             else:
#                 print("❌ Please enter a number within range.")
#         except ValueError:
#             print("❌ Please enter a valid number.")
