/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */


export interface paths {
  "/admin/relation-tuples": {
    /**
     * Create a Relationship
     * @description Use this endpoint to create a relationship.
     */
    put: operations["createRelationship"];
    /**
     * Delete Relationships
     * @description Use this endpoint to delete relationships
     */
    delete: operations["deleteRelationships"];
    /**
     * Patch Multiple Relationships
     * @description Use this endpoint to patch one or more relationships.
     */
    patch: operations["patchRelationships"];
  };
  "/health/alive": {
    /**
     * Check HTTP Server Status
     * @description This endpoint returns a HTTP 200 status code when Ory Keto is accepting incoming
     * HTTP requests. This status does currently not include checks whether the database connection is working.
     *
     * If the service supports TLS Edge Termination, this endpoint does not require the
     * `X-Forwarded-Proto` header to be set.
     *
     * Be aware that if you are running multiple nodes of this service, the health status will never
     * refer to the cluster state, only to a single instance.
     */
    get: operations["isAlive"];
  };
  "/health/ready": {
    /**
     * Check HTTP Server and Database Status
     * @description This endpoint returns a HTTP 200 status code when Ory Keto is up running and the environment dependencies (e.g.
     * the database) are responsive as well.
     *
     * If the service supports TLS Edge Termination, this endpoint does not require the
     * `X-Forwarded-Proto` header to be set.
     *
     * Be aware that if you are running multiple nodes of Ory Keto, the health status will never
     * refer to the cluster state, only to a single instance.
     */
    get: operations["isReady"];
  };
  "/namespaces": {
    /**
     * Query namespaces
     * @description Get all namespaces
     */
    get: operations["listRelationshipNamespaces"];
  };
  "/opl/syntax/check": {
    /**
     * Check the syntax of an OPL file
     * @description The OPL file is expected in the body of the request.
     */
    post: operations["checkOplSyntax"];
  };
  "/relation-tuples": {
    /**
     * Query relationships
     * @description Get all relationships that match the query. Only the namespace field is required.
     */
    get: operations["getRelationships"];
  };
  "/relation-tuples/check": {
    /**
     * Check a permission
     * @description To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).
     */
    get: operations["checkPermissionOrError"];
    /**
     * Check a permission
     * @description To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).
     */
    post: operations["postCheckPermissionOrError"];
  };
  "/relation-tuples/check/openapi": {
    /**
     * Check a permission
     * @description To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).
     */
    get: operations["checkPermission"];
    /**
     * Check a permission
     * @description To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).
     */
    post: operations["postCheckPermission"];
  };
  "/relation-tuples/expand": {
    /**
     * Expand a Relationship into permissions.
     * @description Use this endpoint to expand a relationship tuple into permissions.
     */
    get: operations["expandPermissions"];
  };
  "/version": {
    /**
     * Return Running Software Version.
     * @description This endpoint returns the version of Ory Keto.
     *
     * If the service supports TLS Edge Termination, this endpoint does not require the
     * `X-Forwarded-Proto` header to be set.
     *
     * Be aware that if you are running multiple nodes of this service, the version will never
     * refer to the cluster state, only to a single instance.
     */
    get: operations["getVersion"];
  };
}

export type webhooks = Record<string, never>;

export interface components {
  schemas: {
    ParseError: {
      end?: components["schemas"]["SourcePosition"];
      message?: string;
      start?: components["schemas"]["SourcePosition"];
    };
    SourcePosition: {
      /** Format: int64 */
      Line?: number;
      /** Format: int64 */
      column?: number;
    };
    /** Format: uuid4 */
    UUID: string;
    /** @description Ory Permission Language Document */
    checkOplSyntaxBody: string;
    /** CheckOPLSyntaxResponse represents the response for an OPL syntax check request. */
    checkOplSyntaxResult: {
      /** @description The list of syntax errors */
      errors?: components["schemas"]["ParseError"][];
    };
    /**
     * Check Permission Result
     * @description The content of the allowed field is mirrored in the HTTP status code.
     */
    checkPermissionResult: {
      /** @description whether the relation tuple is allowed */
      allowed: boolean;
    };
    /** @description Create Relationship Request Body */
    createRelationshipBody: {
      /** @description Namespace to query */
      namespace?: string;
      /** @description Object to query */
      object?: string;
      /** @description Relation to query */
      relation?: string;
      /**
       * @description SubjectID to query
       *
       * Either SubjectSet or SubjectID can be provided.
       */
      subject_id?: string;
      subject_set?: components["schemas"]["subjectSet"];
    };
    /**
     * JSON API Error Response
     * @description The standard Ory JSON API error format.
     */
    errorGeneric: {
      error: components["schemas"]["genericError"];
    };
    expandedPermissionTree: {
      /** @description The children of the node, possibly none. */
      children?: components["schemas"]["expandedPermissionTree"][];
      tuple?: components["schemas"]["relationship"];
      /**
       * @description The type of the node.
       * union TreeNodeUnion
       * exclusion TreeNodeExclusion
       * intersection TreeNodeIntersection
       * leaf TreeNodeLeaf
       * tuple_to_subject_set TreeNodeTupleToSubjectSet
       * computed_subject_set TreeNodeComputedSubjectSet
       * not TreeNodeNot
       * unspecified TreeNodeUnspecified
       * @enum {string}
       */
      type: "union" | "exclusion" | "intersection" | "leaf" | "tuple_to_subject_set" | "computed_subject_set" | "not" | "unspecified";
    };
    genericError: {
      /**
       * Format: int64
       * @description The status code
       * @example 404
       */
      code?: number;
      /**
       * @description Debug information
       *
       * This field is often not exposed to protect against leaking
       * sensitive information.
       * @example SQL field "foo" is not a bool.
       */
      debug?: string;
      /** @description Further error details */
      details?: {
        [key: string]: unknown;
      };
      /**
       * @description The error ID
       *
       * Useful when trying to identify various errors in application logic.
       */
      id?: string;
      /**
       * @description Error message
       *
       * The error's message.
       * @example The resource could not be found
       */
      message: string;
      /**
       * @description A human-readable reason for the error
       * @example User with ID 1234 does not exist.
       */
      reason?: string;
      /**
       * @description The request ID
       *
       * The request ID is often exposed internally in order to trace
       * errors across service architectures. This is often a UUID.
       * @example d7ef54b1-ec15-46e6-bccb-524b82c035e6
       */
      request?: string;
      /**
       * @description The status description
       * @example Not Found
       */
      status?: string;
    };
    healthNotReadyStatus: {
      /** @description Errors contains a list of errors that caused the not ready status. */
      errors?: {
        [key: string]: string;
      };
    };
    healthStatus: {
      /** @description Status always contains "ok". */
      status?: string;
    };
    namespace: {
      /** @description Name of the namespace. */
      name?: string;
    };
    /** @description Check Permission using Post Request Body */
    postCheckPermissionBody: {
      /** @description Namespace to query */
      namespace?: string;
      /** @description Object to query */
      object?: string;
      /** @description Relation to query */
      relation?: string;
      /**
       * @description SubjectID to query
       *
       * Either SubjectSet or SubjectID can be provided.
       */
      subject_id?: string;
      subject_set?: components["schemas"]["subjectSet"];
    };
    /** @description Post Check Permission Or Error Body */
    postCheckPermissionOrErrorBody: {
      /** @description Namespace to query */
      namespace?: string;
      /** @description Object to query */
      object?: string;
      /** @description Relation to query */
      relation?: string;
      /**
       * @description SubjectID to query
       *
       * Either SubjectSet or SubjectID can be provided.
       */
      subject_id?: string;
      subject_set?: components["schemas"]["subjectSet"];
    };
    /** @description Relation Query */
    relationQuery: {
      /** @description Namespace to query */
      namespace?: string;
      /** @description Object to query */
      object?: string;
      /** @description Relation to query */
      relation?: string;
      /**
       * @description SubjectID to query
       *
       * Either SubjectSet or SubjectID can be provided.
       */
      subject_id?: string;
      subject_set?: components["schemas"]["subjectSet"];
    };
    /** @description Relationship */
    relationship: {
      /** @description Namespace of the Relation Tuple */
      namespace: string;
      /** @description Object of the Relation Tuple */
      object: string;
      /** @description Relation of the Relation Tuple */
      relation: string;
      /**
       * @description SubjectID of the Relation Tuple
       *
       * Either SubjectSet or SubjectID can be provided.
       */
      subject_id?: string;
      subject_set?: components["schemas"]["subjectSet"];
    };
    /** @description Relationship Namespace List */
    relationshipNamespaces: {
      namespaces?: components["schemas"]["namespace"][];
    };
    /** @description Payload for patching a relationship */
    relationshipPatch: {
      /** @enum {string} */
      action?: "insert" | "delete";
      relation_tuple?: components["schemas"]["relationship"];
    };
    /** @description Paginated Relationship List */
    relationships: {
      /**
       * @description The opaque token to provide in a subsequent request
       * to get the next page. It is the empty string iff this is
       * the last page.
       */
      next_page_token?: string;
      relation_tuples?: components["schemas"]["relationship"][];
    };
    subjectSet: {
      /** @description Namespace of the Subject Set */
      namespace: string;
      /** @description Object of the Subject Set */
      object: string;
      /** @description Relation of the Subject Set */
      relation: string;
    };
    version: {
      /** @description Version is the service's version. */
      version?: string;
    };
  };
  responses: {
    /** @description Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 204. */
    emptyResponse: {
      content: never;
    };
  };
  parameters: never;
  requestBodies: never;
  headers: never;
  pathItems: never;
}

export type $defs = Record<string, never>;

export type external = Record<string, never>;

export interface operations {

  /**
   * Create a Relationship
   * @description Use this endpoint to create a relationship.
   */
  createRelationship: {
    requestBody?: {
      content: {
        "application/json": components["schemas"]["createRelationshipBody"];
      };
    };
    responses: {
      /** @description relationship */
      201: {
        content: {
          "application/json": components["schemas"]["relationship"];
        };
      };
      /** @description errorGeneric */
      400: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
      /** @description errorGeneric */
      default: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
    };
  };
  /**
   * Delete Relationships
   * @description Use this endpoint to delete relationships
   */
  deleteRelationships: {
    parameters: {
      query?: {
        /** @description Namespace of the Relationship */
        namespace?: string;
        /** @description Object of the Relationship */
        object?: string;
        /** @description Relation of the Relationship */
        relation?: string;
        /** @description SubjectID of the Relationship */
        subject_id?: string;
        /** @description Namespace of the Subject Set */
        "subject_set.namespace"?: string;
        /** @description Object of the Subject Set */
        "subject_set.object"?: string;
        /** @description Relation of the Subject Set */
        "subject_set.relation"?: string;
      };
    };
    responses: {
      204: components["responses"]["emptyResponse"];
      /** @description errorGeneric */
      400: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
      /** @description errorGeneric */
      default: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
    };
  };
  /**
   * Patch Multiple Relationships
   * @description Use this endpoint to patch one or more relationships.
   */
  patchRelationships: {
    requestBody?: {
      content: {
        "application/json": components["schemas"]["relationshipPatch"][];
      };
    };
    responses: {
      204: components["responses"]["emptyResponse"];
      /** @description errorGeneric */
      400: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
      /** @description errorGeneric */
      404: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
      /** @description errorGeneric */
      default: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
    };
  };
  /**
   * Check HTTP Server Status
   * @description This endpoint returns a HTTP 200 status code when Ory Keto is accepting incoming
   * HTTP requests. This status does currently not include checks whether the database connection is working.
   *
   * If the service supports TLS Edge Termination, this endpoint does not require the
   * `X-Forwarded-Proto` header to be set.
   *
   * Be aware that if you are running multiple nodes of this service, the health status will never
   * refer to the cluster state, only to a single instance.
   */
  isAlive: {
    responses: {
      /** @description Ory Keto is ready to accept connections. */
      200: {
        content: {
          "application/json": {
            /** @description Always "ok". */
            status: string;
          };
        };
      };
      /** @description genericError */
      500: {
        content: {
          "application/json": components["schemas"]["genericError"];
        };
      };
    };
  };
  /**
   * Check HTTP Server and Database Status
   * @description This endpoint returns a HTTP 200 status code when Ory Keto is up running and the environment dependencies (e.g.
   * the database) are responsive as well.
   *
   * If the service supports TLS Edge Termination, this endpoint does not require the
   * `X-Forwarded-Proto` header to be set.
   *
   * Be aware that if you are running multiple nodes of Ory Keto, the health status will never
   * refer to the cluster state, only to a single instance.
   */
  isReady: {
    responses: {
      /** @description Ory Keto is ready to accept requests. */
      200: {
        content: {
          "application/json": {
            /** @description Always "ok". */
            status: string;
          };
        };
      };
      /** @description Ory Kratos is not yet ready to accept requests. */
      503: {
        content: {
          "application/json": {
            /** @description Errors contains a list of errors that caused the not ready status. */
            errors: {
              [key: string]: string;
            };
          };
        };
      };
    };
  };
  /**
   * Query namespaces
   * @description Get all namespaces
   */
  listRelationshipNamespaces: {
    responses: {
      /** @description relationshipNamespaces */
      200: {
        content: {
          "application/json": components["schemas"]["relationshipNamespaces"];
        };
      };
      /** @description errorGeneric */
      default: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
    };
  };
  /**
   * Check the syntax of an OPL file
   * @description The OPL file is expected in the body of the request.
   */
  checkOplSyntax: {
    requestBody?: {
      content: {
        "text/plain": components["schemas"]["checkOplSyntaxBody"];
      };
    };
    responses: {
      /** @description checkOplSyntaxResult */
      200: {
        content: {
          "application/json": components["schemas"]["checkOplSyntaxResult"];
        };
      };
      /** @description errorGeneric */
      400: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
      /** @description errorGeneric */
      default: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
    };
  };
  /**
   * Query relationships
   * @description Get all relationships that match the query. Only the namespace field is required.
   */
  getRelationships: {
    parameters: {
      query?: {
        page_token?: string;
        page_size?: number;
        /** @description Namespace of the Relationship */
        namespace?: string;
        /** @description Object of the Relationship */
        object?: string;
        /** @description Relation of the Relationship */
        relation?: string;
        /** @description SubjectID of the Relationship */
        subject_id?: string;
        /** @description Namespace of the Subject Set */
        "subject_set.namespace"?: string;
        /** @description Object of the Subject Set */
        "subject_set.object"?: string;
        /** @description Relation of the Subject Set */
        "subject_set.relation"?: string;
      };
    };
    responses: {
      /** @description relationships */
      200: {
        content: {
          "application/json": components["schemas"]["relationships"];
        };
      };
      /** @description errorGeneric */
      404: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
      /** @description errorGeneric */
      default: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
    };
  };
  /**
   * Check a permission
   * @description To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).
   */
  checkPermissionOrError: {
    parameters: {
      query?: {
        /** @description Namespace of the Relationship */
        namespace?: string;
        /** @description Object of the Relationship */
        object?: string;
        /** @description Relation of the Relationship */
        relation?: string;
        /** @description SubjectID of the Relationship */
        subject_id?: string;
        /** @description Namespace of the Subject Set */
        "subject_set.namespace"?: string;
        /** @description Object of the Subject Set */
        "subject_set.object"?: string;
        /** @description Relation of the Subject Set */
        "subject_set.relation"?: string;
        "max-depth"?: number;
      };
    };
    responses: {
      /** @description checkPermissionResult */
      200: {
        content: {
          "application/json": components["schemas"]["checkPermissionResult"];
        };
      };
      /** @description errorGeneric */
      400: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
      /** @description checkPermissionResult */
      403: {
        content: {
          "application/json": components["schemas"]["checkPermissionResult"];
        };
      };
      /** @description errorGeneric */
      default: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
    };
  };
  /**
   * Check a permission
   * @description To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).
   */
  postCheckPermissionOrError: {
    parameters: {
      query?: {
        /** @description nolint:deadcode,unused */
        "max-depth"?: number;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["postCheckPermissionOrErrorBody"];
      };
    };
    responses: {
      /** @description checkPermissionResult */
      200: {
        content: {
          "application/json": components["schemas"]["checkPermissionResult"];
        };
      };
      /** @description errorGeneric */
      400: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
      /** @description checkPermissionResult */
      403: {
        content: {
          "application/json": components["schemas"]["checkPermissionResult"];
        };
      };
      /** @description errorGeneric */
      default: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
    };
  };
  /**
   * Check a permission
   * @description To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).
   */
  checkPermission: {
    parameters: {
      query?: {
        /** @description Namespace of the Relationship */
        namespace?: string;
        /** @description Object of the Relationship */
        object?: string;
        /** @description Relation of the Relationship */
        relation?: string;
        /** @description SubjectID of the Relationship */
        subject_id?: string;
        /** @description Namespace of the Subject Set */
        "subject_set.namespace"?: string;
        /** @description Object of the Subject Set */
        "subject_set.object"?: string;
        /** @description Relation of the Subject Set */
        "subject_set.relation"?: string;
        "max-depth"?: number;
      };
    };
    responses: {
      /** @description checkPermissionResult */
      200: {
        content: {
          "application/json": components["schemas"]["checkPermissionResult"];
        };
      };
      /** @description errorGeneric */
      400: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
      /** @description errorGeneric */
      default: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
    };
  };
  /**
   * Check a permission
   * @description To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).
   */
  postCheckPermission: {
    parameters: {
      query?: {
        "max-depth"?: number;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["postCheckPermissionBody"];
      };
    };
    responses: {
      /** @description checkPermissionResult */
      200: {
        content: {
          "application/json": components["schemas"]["checkPermissionResult"];
        };
      };
      /** @description errorGeneric */
      400: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
      /** @description errorGeneric */
      default: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
    };
  };
  /**
   * Expand a Relationship into permissions.
   * @description Use this endpoint to expand a relationship tuple into permissions.
   */
  expandPermissions: {
    parameters: {
      query: {
        /** @description Namespace of the Subject Set */
        namespace: string;
        /** @description Object of the Subject Set */
        object: string;
        /** @description Relation of the Subject Set */
        relation: string;
        "max-depth"?: number;
      };
    };
    responses: {
      /** @description expandedPermissionTree */
      200: {
        content: {
          "application/json": components["schemas"]["expandedPermissionTree"];
        };
      };
      /** @description errorGeneric */
      400: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
      /** @description errorGeneric */
      404: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
      /** @description errorGeneric */
      default: {
        content: {
          "application/json": components["schemas"]["errorGeneric"];
        };
      };
    };
  };
  /**
   * Return Running Software Version.
   * @description This endpoint returns the version of Ory Keto.
   *
   * If the service supports TLS Edge Termination, this endpoint does not require the
   * `X-Forwarded-Proto` header to be set.
   *
   * Be aware that if you are running multiple nodes of this service, the version will never
   * refer to the cluster state, only to a single instance.
   */
  getVersion: {
    responses: {
      /** @description Returns the Ory Keto version. */
      200: {
        content: {
          "application/json": {
            /** @description The version of Ory Keto. */
            version: string;
          };
        };
      };
    };
  };
}
