/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
    "/.well-known/ory/webauthn.js": {
        /**
         * Get WebAuthn JavaScript
         * @description This endpoint provides JavaScript which is needed in order to perform WebAuthn login and registration.
         *
         * If you are building a JavaScript Browser App (e.g. in ReactJS or AngularJS) you will need to load this file:
         *
         * ```html
         * <script src="https://public-kratos.example.org/.well-known/ory/webauthn.js" type="script" async />
         * ```
         *
         * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
         */
        get: operations["getWebAuthnJavaScript"]
    }
    "/admin/courier/messages": {
        /**
         * List Messages
         * @description Lists all messages by given status and recipient.
         */
        get: operations["listCourierMessages"]
    }
    "/admin/courier/messages/{id}": {
        /**
         * Get a Message
         * @description Gets a specific messages by the given ID.
         */
        get: operations["getCourierMessage"]
    }
    "/admin/identities": {
        /**
         * List Identities
         * @description Lists all [identities](https://www.ory.sh/docs/kratos/concepts/identity-user-model) in the system.
         */
        get: operations["listIdentities"]
        /**
         * Create an Identity
         * @description Create an [identity](https://www.ory.sh/docs/kratos/concepts/identity-user-model).  This endpoint can also be used to
         * [import credentials](https://www.ory.sh/docs/kratos/manage-identities/import-user-accounts-identities)
         * for instance passwords, social sign in configurations or multifactor methods.
         */
        post: operations["createIdentity"]
        /**
         * Create and deletes multiple identities
         * @description Creates or delete multiple
         * [identities](https://www.ory.sh/docs/kratos/concepts/identity-user-model).
         * This endpoint can also be used to [import
         * credentials](https://www.ory.sh/docs/kratos/manage-identities/import-user-accounts-identities)
         * for instance passwords, social sign in configurations or multifactor methods.
         */
        patch: operations["batchPatchIdentities"]
    }
    "/admin/identities/{id}": {
        /**
         * Get an Identity
         * @description Return an [identity](https://www.ory.sh/docs/kratos/concepts/identity-user-model) by its ID. You can optionally
         * include credentials (e.g. social sign in connections) in the response by using the `include_credential` query parameter.
         */
        get: operations["getIdentity"]
        /**
         * Update an Identity
         * @description This endpoint updates an [identity](https://www.ory.sh/docs/kratos/concepts/identity-user-model). The full identity
         * payload (except credentials) is expected. It is possible to update the identity's credentials as well.
         */
        put: operations["updateIdentity"]
        /**
         * Delete an Identity
         * @description Calling this endpoint irrecoverably and permanently deletes the [identity](https://www.ory.sh/docs/kratos/concepts/identity-user-model) given its ID. This action can not be undone.
         * This endpoint returns 204 when the identity was deleted or when the identity was not found, in which case it is
         * assumed that is has been deleted already.
         */
        delete: operations["deleteIdentity"]
        /**
         * Patch an Identity
         * @description Partially updates an [identity's](https://www.ory.sh/docs/kratos/concepts/identity-user-model) field using [JSON Patch](https://jsonpatch.com/).
         * The fields `id`, `stateChangedAt` and `credentials` can not be updated using this method.
         */
        patch: operations["patchIdentity"]
    }
    "/admin/identities/{id}/credentials/{type}": {
        /**
         * Delete a credential for a specific identity
         * @description Delete an [identity](https://www.ory.sh/docs/kratos/concepts/identity-user-model) credential by its type
         * You can only delete second factor (aal2) credentials.
         */
        delete: operations["deleteIdentityCredentials"]
    }
    "/admin/identities/{id}/sessions": {
        /**
         * List an Identity's Sessions
         * @description This endpoint returns all sessions that belong to the given Identity.
         */
        get: operations["listIdentitySessions"]
        /**
         * Delete & Invalidate an Identity's Sessions
         * @description Calling this endpoint irrecoverably and permanently deletes and invalidates all sessions that belong to the given Identity.
         */
        delete: operations["deleteIdentitySessions"]
    }
    "/admin/recovery/code": {
        /**
         * Create a Recovery Code
         * @description This endpoint creates a recovery code which should be given to the user in order for them to recover
         * (or activate) their account.
         */
        post: operations["createRecoveryCodeForIdentity"]
    }
    "/admin/recovery/link": {
        /**
         * Create a Recovery Link
         * @description This endpoint creates a recovery link which should be given to the user in order for them to recover
         * (or activate) their account.
         */
        post: operations["createRecoveryLinkForIdentity"]
    }
    "/admin/sessions": {
        /**
         * List All Sessions
         * @description Listing all sessions that exist.
         */
        get: operations["listSessions"]
    }
    "/admin/sessions/{id}": {
        /**
         * Get Session
         * @description This endpoint is useful for:
         *
         * Getting a session object with all specified expandables that exist in an administrative context.
         */
        get: operations["getSession"]
        /**
         * Deactivate a Session
         * @description Calling this endpoint deactivates the specified session. Session data is not deleted.
         */
        delete: operations["disableSession"]
    }
    "/admin/sessions/{id}/extend": {
        /**
         * Extend a Session
         * @description Calling this endpoint extends the given session ID. If `session.earliest_possible_extend` is set it
         * will only extend the session after the specified time has passed.
         *
         * Retrieve the session ID from the `/sessions/whoami` endpoint / `toSession` SDK method.
         */
        patch: operations["extendSession"]
    }
    "/health/alive": {
        /**
         * Check HTTP Server Status
         * @description This endpoint returns a HTTP 200 status code when Ory Kratos is accepting incoming
         * HTTP requests. This status does currently not include checks whether the database connection is working.
         *
         * If the service supports TLS Edge Termination, this endpoint does not require the
         * `X-Forwarded-Proto` header to be set.
         *
         * Be aware that if you are running multiple nodes of this service, the health status will never
         * refer to the cluster state, only to a single instance.
         */
        get: operations["isAlive"]
    }
    "/health/ready": {
        /**
         * Check HTTP Server and Database Status
         * @description This endpoint returns a HTTP 200 status code when Ory Kratos is up running and the environment dependencies (e.g.
         * the database) are responsive as well.
         *
         * If the service supports TLS Edge Termination, this endpoint does not require the
         * `X-Forwarded-Proto` header to be set.
         *
         * Be aware that if you are running multiple nodes of Ory Kratos, the health status will never
         * refer to the cluster state, only to a single instance.
         */
        get: operations["isReady"]
    }
    "/schemas": {
        /**
         * Get all Identity Schemas
         * @description Returns a list of all identity schemas currently in use.
         */
        get: operations["listIdentitySchemas"]
    }
    "/schemas/{id}": {
        /**
         * Get Identity JSON Schema
         * @description Return a specific identity schema.
         */
        get: operations["getIdentitySchema"]
    }
    "/self-service/errors": {
        /**
         * Get User-Flow Errors
         * @description This endpoint returns the error associated with a user-facing self service errors.
         *
         * This endpoint supports stub values to help you implement the error UI:
         *
         * `?id=stub:500` - returns a stub 500 (Internal Server Error) error.
         *
         * More information can be found at [Ory Kratos User User Facing Error Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-facing-errors).
         */
        get: operations["getFlowError"]
    }
    "/self-service/login": {
        /**
         * Submit a Login Flow
         * @description :::info
         *
         * This endpoint is EXPERIMENTAL and subject to potential breaking changes in the future.
         *
         * :::
         *
         * Use this endpoint to complete a login flow. This endpoint
         * behaves differently for API and browser flows.
         *
         * API flows expect `application/json` to be sent in the body and responds with
         * HTTP 200 and a application/json body with the session token on success;
         * HTTP 410 if the original flow expired with the appropriate error messages set and optionally a `use_flow_id` parameter in the body;
         * HTTP 400 on form validation errors.
         *
         * Browser flows expect a Content-Type of `application/x-www-form-urlencoded` or `application/json` to be sent in the body and respond with
         * a HTTP 303 redirect to the post/after login URL or the `return_to` value if it was set and if the login succeeded;
         * a HTTP 303 redirect to the login UI URL with the flow ID containing the validation errors otherwise.
         *
         * Browser flows with an accept header of `application/json` will not redirect but instead respond with
         * HTTP 200 and a application/json body with the signed in identity and a `Set-Cookie` header on success;
         * HTTP 303 redirect to a fresh login flow if the original flow expired with the appropriate error messages set;
         * HTTP 400 on form validation errors.
         *
         * If this endpoint is called with `Accept: application/json` in the header, the response contains the flow without a redirect. In the
         * case of an error, the `error.id` of the JSON response body can be one of:
         *
         * `session_already_available`: The user is already signed in.
         * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
         * `security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
         * `browser_location_change_required`: Usually sent when an AJAX request indicates that the browser needs to open a specific URL.
         * Most likely used in Social Sign In flows.
         *
         * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
         */
        post: operations["updateLoginFlow"]
    }
    "/self-service/login/api": {
        /**
         * Create Login Flow for Native Apps
         * @description This endpoint initiates a login flow for native apps that do not use a browser, such as mobile devices, smart TVs, and so on.
         *
         * If a valid provided session cookie or session token is provided, a 400 Bad Request error
         * will be returned unless the URL query parameter `?refresh=true` is set.
         *
         * To fetch an existing login flow call `/self-service/login/flows?flow=<flow_id>`.
         *
         * You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
         * Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
         * you vulnerable to a variety of CSRF attacks, including CSRF login attacks.
         *
         * In the case of an error, the `error.id` of the JSON response body can be one of:
         *
         * `session_already_available`: The user is already signed in.
         * `session_aal1_required`: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet.
         * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
         *
         * This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).
         *
         * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
         */
        get: operations["createNativeLoginFlow"]
    }
    "/self-service/login/browser": {
        /**
         * Create Login Flow for Browsers
         * @description This endpoint initializes a browser-based user login flow. This endpoint will set the appropriate
         * cookies and anti-CSRF measures required for browser-based flows.
         *
         * If this endpoint is opened as a link in the browser, it will be redirected to
         * `selfservice.flows.login.ui_url` with the flow ID set as the query parameter `?flow=`. If a valid user session
         * exists already, the browser will be redirected to `urls.default_redirect_url` unless the query parameter
         * `?refresh=true` was set.
         *
         * If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
         * case of an error, the `error.id` of the JSON response body can be one of:
         *
         * `session_already_available`: The user is already signed in.
         * `session_aal1_required`: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet.
         * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
         * `security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
         *
         * The optional query parameter login_challenge is set when using Kratos with
         * Hydra in an OAuth2 flow. See the oauth2_provider.url configuration
         * option.
         *
         * This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.
         *
         * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
         */
        get: operations["createBrowserLoginFlow"]
    }
    "/self-service/login/flows": {
        /**
         * Get Login Flow
         * @description This endpoint returns a login flow's context with, for example, error details and other information.
         *
         * Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
         * For AJAX requests you must ensure that cookies are included in the request or requests will fail.
         *
         * If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
         * and you need to forward the incoming HTTP Cookie header to this endpoint:
         *
         * ```js
         * pseudo-code example
         * router.get('/login', async function (req, res) {
         * const flow = await client.getLoginFlow(req.header('cookie'), req.query['flow'])
         *
         * res.render('login', flow)
         * })
         * ```
         *
         * This request may fail due to several reasons. The `error.id` can be one of:
         *
         * `session_already_available`: The user is already signed in.
         * `self_service_flow_expired`: The flow is expired and you should request a new one.
         *
         * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
         */
        get: operations["getLoginFlow"]
    }
    "/self-service/logout": {
        /**
         * Update Logout Flow
         * @description This endpoint logs out an identity in a self-service manner.
         *
         * If the `Accept` HTTP header is not set to `application/json`, the browser will be redirected (HTTP 303 See Other)
         * to the `return_to` parameter of the initial request or fall back to `urls.default_return_to`.
         *
         * If the `Accept` HTTP header is set to `application/json`, a 204 No Content response
         * will be sent on successful logout instead.
         *
         * This endpoint is NOT INTENDED for API clients and only works
         * with browsers (Chrome, Firefox, ...). For API clients you can
         * call the `/self-service/logout/api` URL directly with the Ory Session Token.
         *
         * More information can be found at [Ory Kratos User Logout Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-logout).
         */
        get: operations["updateLogoutFlow"]
    }
    "/self-service/logout/api": {
        /**
         * Perform Logout for Native Apps
         * @description Use this endpoint to log out an identity using an Ory Session Token. If the Ory Session Token was successfully
         * revoked, the server returns a 204 No Content response. A 204 No Content response is also sent when
         * the Ory Session Token has been revoked already before.
         *
         * If the Ory Session Token is malformed or does not exist a 403 Forbidden response will be returned.
         *
         * This endpoint does not remove any HTTP
         * Cookies - use the Browser-Based Self-Service Logout Flow instead.
         */
        delete: operations["performNativeLogout"]
    }
    "/self-service/logout/browser": {
        /**
         * Create a Logout URL for Browsers
         * @description This endpoint initializes a browser-based user logout flow and a URL which can be used to log out the user.
         *
         * This endpoint is NOT INTENDED for API clients and only works
         * with browsers (Chrome, Firefox, ...). For API clients you can
         * call the `/self-service/logout/api` URL directly with the Ory Session Token.
         *
         * The URL is only valid for the currently signed in user. If no user is signed in, this endpoint returns
         * a 401 error.
         *
         * When calling this endpoint from a backend, please ensure to properly forward the HTTP cookies.
         */
        get: operations["createBrowserLogoutFlow"]
    }
    "/self-service/recovery": {
        /**
         * Complete Recovery Flow
         * @description Use this endpoint to complete a recovery flow. This endpoint
         * behaves differently for API and browser flows and has several states:
         *
         * `choose_method` expects `flow` (in the URL query) and `email` (in the body) to be sent
         * and works with API- and Browser-initiated flows.
         * For API clients and Browser clients with HTTP Header `Accept: application/json` it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid.
         * and a HTTP 303 See Other redirect with a fresh recovery flow if the flow was otherwise invalid (e.g. expired).
         * For Browser clients without HTTP Header `Accept` or with `Accept: text/*` it returns a HTTP 303 See Other redirect to the Recovery UI URL with the Recovery Flow ID appended.
         * `sent_email` is the success state after `choose_method` for the `link` method and allows the user to request another recovery email. It
         * works for both API and Browser-initiated flows and returns the same responses as the flow in `choose_method` state.
         * `passed_challenge` expects a `token` to be sent in the URL query and given the nature of the flow ("sending a recovery link")
         * does not have any API capabilities. The server responds with a HTTP 303 See Other redirect either to the Settings UI URL
         * (if the link was valid) and instructs the user to update their password, or a redirect to the Recover UI URL with
         * a new Recovery Flow ID which contains an error message that the recovery link was invalid.
         *
         * More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
         */
        post: operations["updateRecoveryFlow"]
    }
    "/self-service/recovery/api": {
        /**
         * Create Recovery Flow for Native Apps
         * @description This endpoint initiates a recovery flow for API clients such as mobile devices, smart TVs, and so on.
         *
         * If a valid provided session cookie or session token is provided, a 400 Bad Request error.
         *
         * To fetch an existing recovery flow call `/self-service/recovery/flows?flow=<flow_id>`.
         *
         * You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
         * Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
         * you vulnerable to a variety of CSRF attacks.
         *
         * This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).
         *
         * More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
         */
        get: operations["createNativeRecoveryFlow"]
    }
    "/self-service/recovery/browser": {
        /**
         * Create Recovery Flow for Browsers
         * @description This endpoint initializes a browser-based account recovery flow. Once initialized, the browser will be redirected to
         * `selfservice.flows.recovery.ui_url` with the flow ID set as the query parameter `?flow=`. If a valid user session
         * exists, the browser is returned to the configured return URL.
         *
         * If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects
         * or a 400 bad request error if the user is already authenticated.
         *
         * This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.
         *
         * More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
         */
        get: operations["createBrowserRecoveryFlow"]
    }
    "/self-service/recovery/flows": {
        /**
         * Get Recovery Flow
         * @description This endpoint returns a recovery flow's context with, for example, error details and other information.
         *
         * Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
         * For AJAX requests you must ensure that cookies are included in the request or requests will fail.
         *
         * If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
         * and you need to forward the incoming HTTP Cookie header to this endpoint:
         *
         * ```js
         * pseudo-code example
         * router.get('/recovery', async function (req, res) {
         * const flow = await client.getRecoveryFlow(req.header('Cookie'), req.query['flow'])
         *
         * res.render('recovery', flow)
         * })
         * ```
         *
         * More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
         */
        get: operations["getRecoveryFlow"]
    }
    "/self-service/registration": {
        /**
         * Update Registration Flow
         * @description Use this endpoint to complete a registration flow by sending an identity's traits and password. This endpoint
         * behaves differently for API and browser flows.
         *
         * API flows expect `application/json` to be sent in the body and respond with
         * HTTP 200 and a application/json body with the created identity success - if the session hook is configured the
         * `session` and `session_token` will also be included;
         * HTTP 410 if the original flow expired with the appropriate error messages set and optionally a `use_flow_id` parameter in the body;
         * HTTP 400 on form validation errors.
         *
         * Browser flows expect a Content-Type of `application/x-www-form-urlencoded` or `application/json` to be sent in the body and respond with
         * a HTTP 303 redirect to the post/after registration URL or the `return_to` value if it was set and if the registration succeeded;
         * a HTTP 303 redirect to the registration UI URL with the flow ID containing the validation errors otherwise.
         *
         * Browser flows with an accept header of `application/json` will not redirect but instead respond with
         * HTTP 200 and a application/json body with the signed in identity and a `Set-Cookie` header on success;
         * HTTP 303 redirect to a fresh login flow if the original flow expired with the appropriate error messages set;
         * HTTP 400 on form validation errors.
         *
         * If this endpoint is called with `Accept: application/json` in the header, the response contains the flow without a redirect. In the
         * case of an error, the `error.id` of the JSON response body can be one of:
         *
         * `session_already_available`: The user is already signed in.
         * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
         * `security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
         * `browser_location_change_required`: Usually sent when an AJAX request indicates that the browser needs to open a specific URL.
         * Most likely used in Social Sign In flows.
         *
         * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
         */
        post: operations["updateRegistrationFlow"]
    }
    "/self-service/registration/api": {
        /**
         * Create Registration Flow for Native Apps
         * @description This endpoint initiates a registration flow for API clients such as mobile devices, smart TVs, and so on.
         *
         * If a valid provided session cookie or session token is provided, a 400 Bad Request error
         * will be returned unless the URL query parameter `?refresh=true` is set.
         *
         * To fetch an existing registration flow call `/self-service/registration/flows?flow=<flow_id>`.
         *
         * You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
         * Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
         * you vulnerable to a variety of CSRF attacks.
         *
         * In the case of an error, the `error.id` of the JSON response body can be one of:
         *
         * `session_already_available`: The user is already signed in.
         * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
         *
         * This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).
         *
         * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
         */
        get: operations["createNativeRegistrationFlow"]
    }
    "/self-service/registration/browser": {
        /**
         * Create Registration Flow for Browsers
         * @description This endpoint initializes a browser-based user registration flow. This endpoint will set the appropriate
         * cookies and anti-CSRF measures required for browser-based flows.
         *
         * :::info
         *
         * This endpoint is EXPERIMENTAL and subject to potential breaking changes in the future.
         *
         * :::
         *
         * If this endpoint is opened as a link in the browser, it will be redirected to
         * `selfservice.flows.registration.ui_url` with the flow ID set as the query parameter `?flow=`. If a valid user session
         * exists already, the browser will be redirected to `urls.default_redirect_url`.
         *
         * If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
         * case of an error, the `error.id` of the JSON response body can be one of:
         *
         * `session_already_available`: The user is already signed in.
         * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
         * `security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
         *
         * If this endpoint is called via an AJAX request, the response contains the registration flow without a redirect.
         *
         * This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.
         *
         * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
         */
        get: operations["createBrowserRegistrationFlow"]
    }
    "/self-service/registration/flows": {
        /**
         * Get Registration Flow
         * @description This endpoint returns a registration flow's context with, for example, error details and other information.
         *
         * Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
         * For AJAX requests you must ensure that cookies are included in the request or requests will fail.
         *
         * If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
         * and you need to forward the incoming HTTP Cookie header to this endpoint:
         *
         * ```js
         * pseudo-code example
         * router.get('/registration', async function (req, res) {
         * const flow = await client.getRegistrationFlow(req.header('cookie'), req.query['flow'])
         *
         * res.render('registration', flow)
         * })
         * ```
         *
         * This request may fail due to several reasons. The `error.id` can be one of:
         *
         * `session_already_available`: The user is already signed in.
         * `self_service_flow_expired`: The flow is expired and you should request a new one.
         *
         * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
         */
        get: operations["getRegistrationFlow"]
    }
    "/self-service/settings": {
        /**
         * Complete Settings Flow
         * @description Use this endpoint to complete a settings flow by sending an identity's updated password. This endpoint
         * behaves differently for API and browser flows.
         *
         * API-initiated flows expect `application/json` to be sent in the body and respond with
         * HTTP 200 and an application/json body with the session token on success;
         * HTTP 303 redirect to a fresh settings flow if the original flow expired with the appropriate error messages set;
         * HTTP 400 on form validation errors.
         * HTTP 401 when the endpoint is called without a valid session token.
         * HTTP 403 when `selfservice.flows.settings.privileged_session_max_age` was reached or the session's AAL is too low.
         * Implies that the user needs to re-authenticate.
         *
         * Browser flows without HTTP Header `Accept` or with `Accept: text/*` respond with
         * a HTTP 303 redirect to the post/after settings URL or the `return_to` value if it was set and if the flow succeeded;
         * a HTTP 303 redirect to the Settings UI URL with the flow ID containing the validation errors otherwise.
         * a HTTP 303 redirect to the login endpoint when `selfservice.flows.settings.privileged_session_max_age` was reached or the session's AAL is too low.
         *
         * Browser flows with HTTP Header `Accept: application/json` respond with
         * HTTP 200 and a application/json body with the signed in identity and a `Set-Cookie` header on success;
         * HTTP 303 redirect to a fresh login flow if the original flow expired with the appropriate error messages set;
         * HTTP 401 when the endpoint is called without a valid session cookie.
         * HTTP 403 when the page is accessed without a session cookie or the session's AAL is too low.
         * HTTP 400 on form validation errors.
         *
         * Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
         * Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
         * credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
         * to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.
         *
         * If this endpoint is called with a `Accept: application/json` HTTP header, the response contains the flow without a redirect. In the
         * case of an error, the `error.id` of the JSON response body can be one of:
         *
         * `session_refresh_required`: The identity requested to change something that needs a privileged session. Redirect
         * the identity to the login init endpoint with query parameters `?refresh=true&return_to=<the-current-browser-url>`,
         * or initiate a refresh login flow otherwise.
         * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
         * `session_inactive`: No Ory Session was found - sign in a user first.
         * `security_identity_mismatch`: The flow was interrupted with `session_refresh_required` but apparently some other
         * identity logged in instead.
         * `security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
         * `browser_location_change_required`: Usually sent when an AJAX request indicates that the browser needs to open a specific URL.
         * Most likely used in Social Sign In flows.
         *
         * More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
         */
        post: operations["updateSettingsFlow"]
    }
    "/self-service/settings/api": {
        /**
         * Create Settings Flow for Native Apps
         * @description This endpoint initiates a settings flow for API clients such as mobile devices, smart TVs, and so on.
         * You must provide a valid Ory Kratos Session Token for this endpoint to respond with HTTP 200 OK.
         *
         * To fetch an existing settings flow call `/self-service/settings/flows?flow=<flow_id>`.
         *
         * You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
         * Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
         * you vulnerable to a variety of CSRF attacks.
         *
         * Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
         * Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
         * credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
         * to sign in with the second factor or change the configuration.
         *
         * In the case of an error, the `error.id` of the JSON response body can be one of:
         *
         * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
         * `session_inactive`: No Ory Session was found - sign in a user first.
         *
         * This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).
         *
         * More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
         */
        get: operations["createNativeSettingsFlow"]
    }
    "/self-service/settings/browser": {
        /**
         * Create Settings Flow for Browsers
         * @description This endpoint initializes a browser-based user settings flow. Once initialized, the browser will be redirected to
         * `selfservice.flows.settings.ui_url` with the flow ID set as the query parameter `?flow=`. If no valid
         * Ory Kratos Session Cookie is included in the request, a login flow will be initialized.
         *
         * If this endpoint is opened as a link in the browser, it will be redirected to
         * `selfservice.flows.settings.ui_url` with the flow ID set as the query parameter `?flow=`. If no valid user session
         * was set, the browser will be redirected to the login endpoint.
         *
         * If this endpoint is called via an AJAX request, the response contains the settings flow without any redirects
         * or a 401 forbidden error if no valid session was set.
         *
         * Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
         * Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
         * credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
         * to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.
         *
         * If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
         * case of an error, the `error.id` of the JSON response body can be one of:
         *
         * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
         * `session_inactive`: No Ory Session was found - sign in a user first.
         * `security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
         *
         * This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.
         *
         * More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
         */
        get: operations["createBrowserSettingsFlow"]
    }
    "/self-service/settings/flows": {
        /**
         * Get Settings Flow
         * @description When accessing this endpoint through Ory Kratos' Public API you must ensure that either the Ory Kratos Session Cookie
         * or the Ory Kratos Session Token are set.
         *
         * Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
         * Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
         * credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
         * to sign in with the second factor or change the configuration.
         *
         * You can access this endpoint without credentials when using Ory Kratos' Admin API.
         *
         * If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
         * case of an error, the `error.id` of the JSON response body can be one of:
         *
         * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
         * `session_inactive`: No Ory Session was found - sign in a user first.
         * `security_identity_mismatch`: The flow was interrupted with `session_refresh_required` but apparently some other
         * identity logged in instead.
         *
         * More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
         */
        get: operations["getSettingsFlow"]
    }
    "/self-service/verification": {
        /**
         * Complete Verification Flow
         * @description Use this endpoint to complete a verification flow. This endpoint
         * behaves differently for API and browser flows and has several states:
         *
         * `choose_method` expects `flow` (in the URL query) and `email` (in the body) to be sent
         * and works with API- and Browser-initiated flows.
         * For API clients and Browser clients with HTTP Header `Accept: application/json` it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid
         * and a HTTP 303 See Other redirect with a fresh verification flow if the flow was otherwise invalid (e.g. expired).
         * For Browser clients without HTTP Header `Accept` or with `Accept: text/*` it returns a HTTP 303 See Other redirect to the Verification UI URL with the Verification Flow ID appended.
         * `sent_email` is the success state after `choose_method` when using the `link` method and allows the user to request another verification email. It
         * works for both API and Browser-initiated flows and returns the same responses as the flow in `choose_method` state.
         * `passed_challenge` expects a `token` to be sent in the URL query and given the nature of the flow ("sending a verification link")
         * does not have any API capabilities. The server responds with a HTTP 303 See Other redirect either to the Settings UI URL
         * (if the link was valid) and instructs the user to update their password, or a redirect to the Verification UI URL with
         * a new Verification Flow ID which contains an error message that the verification link was invalid.
         *
         * More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
         */
        post: operations["updateVerificationFlow"]
    }
    "/self-service/verification/api": {
        /**
         * Create Verification Flow for Native Apps
         * @description This endpoint initiates a verification flow for API clients such as mobile devices, smart TVs, and so on.
         *
         * To fetch an existing verification flow call `/self-service/verification/flows?flow=<flow_id>`.
         *
         * You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
         * Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
         * you vulnerable to a variety of CSRF attacks.
         *
         * This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).
         *
         * More information can be found at [Ory Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
         */
        get: operations["createNativeVerificationFlow"]
    }
    "/self-service/verification/browser": {
        /**
         * Create Verification Flow for Browser Clients
         * @description This endpoint initializes a browser-based account verification flow. Once initialized, the browser will be redirected to
         * `selfservice.flows.verification.ui_url` with the flow ID set as the query parameter `?flow=`.
         *
         * If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects.
         *
         * This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...).
         *
         * More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
         */
        get: operations["createBrowserVerificationFlow"]
    }
    "/self-service/verification/flows": {
        /**
         * Get Verification Flow
         * @description This endpoint returns a verification flow's context with, for example, error details and other information.
         *
         * Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
         * For AJAX requests you must ensure that cookies are included in the request or requests will fail.
         *
         * If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
         * and you need to forward the incoming HTTP Cookie header to this endpoint:
         *
         * ```js
         * pseudo-code example
         * router.get('/recovery', async function (req, res) {
         * const flow = await client.getVerificationFlow(req.header('cookie'), req.query['flow'])
         *
         * res.render('verification', flow)
         * })
         * ```
         *
         * More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
         */
        get: operations["getVerificationFlow"]
    }
    "/sessions": {
        /**
         * Get My Active Sessions
         * @description This endpoints returns all other active sessions that belong to the logged-in user.
         * The current session can be retrieved by calling the `/sessions/whoami` endpoint.
         */
        get: operations["listMySessions"]
        /**
         * Disable my other sessions
         * @description Calling this endpoint invalidates all except the current session that belong to the logged-in user.
         * Session data are not deleted.
         */
        delete: operations["disableMyOtherSessions"]
    }
    "/sessions/token-exchange": {
        /** Exchange Session Token */
        get: operations["exchangeSessionToken"]
    }
    "/sessions/whoami": {
        /**
         * Check Who the Current HTTP Session Belongs To
         * @description Uses the HTTP Headers in the GET request to determine (e.g. by using checking the cookies) who is authenticated.
         * Returns a session object in the body or 401 if the credentials are invalid or no credentials were sent.
         * When the request it successful it adds the user ID to the 'X-Kratos-Authenticated-Identity-Id' header
         * in the response.
         *
         * If you call this endpoint from a server-side application, you must forward the HTTP Cookie Header to this endpoint:
         *
         * ```js
         * pseudo-code example
         * router.get('/protected-endpoint', async function (req, res) {
         * const session = await client.toSession(undefined, req.header('cookie'))
         *
         * console.log(session)
         * })
         * ```
         *
         * When calling this endpoint from a non-browser application (e.g. mobile app) you must include the session token:
         *
         * ```js
         * pseudo-code example
         * ...
         * const session = await client.toSession("the-session-token")
         *
         * console.log(session)
         * ```
         *
         * Depending on your configuration this endpoint might return a 403 status code if the session has a lower Authenticator
         * Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
         * credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
         * to sign in with the second factor or change the configuration.
         *
         * This endpoint is useful for:
         *
         * AJAX calls. Remember to send credentials and set up CORS correctly!
         * Reverse proxies and API Gateways
         * Server-side calls - use the `X-Session-Token` header!
         *
         * This endpoint authenticates users by checking:
         *
         * if the `Cookie` HTTP header was set containing an Ory Kratos Session Cookie;
         * if the `Authorization: bearer <ory-session-token>` HTTP header was set with a valid Ory Kratos Session Token;
         * if the `X-Session-Token` HTTP header was set with a valid Ory Kratos Session Token.
         *
         * If none of these headers are set or the cookie or token are invalid, the endpoint returns a HTTP 401 status code.
         *
         * As explained above, this request may fail due to several reasons. The `error.id` can be one of:
         *
         * `session_inactive`: No active session was found in the request (e.g. no Ory Session Cookie / Ory Session Token).
         * `session_aal2_required`: An active session was found but it does not fulfil the Authenticator Assurance Level, implying that the session must (e.g.) authenticate the second factor.
         */
        get: operations["toSession"]
    }
    "/sessions/{id}": {
        /**
         * Disable one of my sessions
         * @description Calling this endpoint invalidates the specified session. The current session cannot be revoked.
         * Session data are not deleted.
         */
        delete: operations["disableMySession"]
    }
    "/version": {
        /**
         * Return Running Software Version.
         * @description This endpoint returns the version of Ory Kratos.
         *
         * If the service supports TLS Edge Termination, this endpoint does not require the
         * `X-Forwarded-Proto` header to be set.
         *
         * Be aware that if you are running multiple nodes of this service, the version will never
         * refer to the cluster state, only to a single instance.
         */
        get: operations["getVersion"]
    }
}

export type webhooks = Record<string, never>

export interface components {
    schemas: {
        DefaultError: unknown
        /**
         * Format: int64
         * @description A Duration represents the elapsed time between two instants
         * as an int64 nanosecond count. The representation limits the
         * largest representable duration to approximately 290 years.
         */
        Duration: number
        /** Format: int64 */
        ID: number
        /** JSONRawMessage represents a json.RawMessage that works well with JSON, SQL, and Swagger. */
        JSONRawMessage: Record<string, never>
        NullBool: boolean | null
        NullInt: number | null
        NullString: string | null
        /** Format: date-time */
        NullTime: string | null
        /** Format: uuid4 */
        NullUUID: string | null
        /** OAuth2Client OAuth 2.0 Clients are used to perform OAuth 2.0 and OpenID Connect flows. Usually, OAuth 2.0 clients are generated for applications which want to consume your OAuth 2.0 or OpenID Connect capabilities. */
        OAuth2Client: {
            allowed_cors_origins?: string[]
            audience?: string[]
            /** @description Specify a time duration in milliseconds, seconds, minutes, hours. */
            authorization_code_grant_access_token_lifespan?: string
            /** @description Specify a time duration in milliseconds, seconds, minutes, hours. */
            authorization_code_grant_id_token_lifespan?: string
            /** @description Specify a time duration in milliseconds, seconds, minutes, hours. */
            authorization_code_grant_refresh_token_lifespan?: string
            /** @description OpenID Connect Back-Channel Logout Session Required  Boolean value specifying whether the RP requires that a sid (session ID) Claim be included in the Logout Token to identify the RP session with the OP when the backchannel_logout_uri is used. If omitted, the default value is false. */
            backchannel_logout_session_required?: boolean
            /** @description OpenID Connect Back-Channel Logout URI  RP URL that will cause the RP to log itself out when sent a Logout Token by the OP. */
            backchannel_logout_uri?: string
            /** @description Specify a time duration in milliseconds, seconds, minutes, hours. */
            client_credentials_grant_access_token_lifespan?: string
            /** @description OAuth 2.0 Client ID  The ID is autogenerated and immutable. */
            client_id?: string
            /** @description OAuth 2.0 Client Name  The human-readable name of the client to be presented to the end-user during authorization. */
            client_name?: string
            /** @description OAuth 2.0 Client Secret  The secret will be included in the create request as cleartext, and then never again. The secret is kept in hashed format and is not recoverable once lost. */
            client_secret?: string
            /**
             * Format: int64
             * @description OAuth 2.0 Client Secret Expires At  The field is currently not supported and its value is always 0.
             */
            client_secret_expires_at?: number
            /** @description OAuth 2.0 Client URI  ClientURI is a URL string of a web page providing information about the client. If present, the server SHOULD display this URL to the end-user in a clickable fashion. */
            client_uri?: string
            contacts?: string[]
            /**
             * Format: date-time
             * @description OAuth 2.0 Client Creation Date  CreatedAt returns the timestamp of the client's creation.
             */
            created_at?: string
            /** @description OpenID Connect Front-Channel Logout Session Required  Boolean value specifying whether the RP requires that iss (issuer) and sid (session ID) query parameters be included to identify the RP session with the OP when the frontchannel_logout_uri is used. If omitted, the default value is false. */
            frontchannel_logout_session_required?: boolean
            /** @description OpenID Connect Front-Channel Logout URI  RP URL that will cause the RP to log itself out when rendered in an iframe by the OP. An iss (issuer) query parameter and a sid (session ID) query parameter MAY be included by the OP to enable the RP to validate the request and to determine which of the potentially multiple sessions is to be logged out; if either is included, both MUST be. */
            frontchannel_logout_uri?: string
            grant_types?: string[]
            /** @description Specify a time duration in milliseconds, seconds, minutes, hours. */
            implicit_grant_access_token_lifespan?: string
            /** @description Specify a time duration in milliseconds, seconds, minutes, hours. */
            implicit_grant_id_token_lifespan?: string
            /** @description OAuth 2.0 Client JSON Web Key Set  Client's JSON Web Key Set [JWK] document, passed by value. The semantics of the jwks parameter are the same as the jwks_uri parameter, other than that the JWK Set is passed by value, rather than by reference. This parameter is intended only to be used by Clients that, for some reason, are unable to use the jwks_uri parameter, for instance, by native applications that might not have a location to host the contents of the JWK Set. If a Client can use jwks_uri, it MUST NOT use jwks. One significant downside of jwks is that it does not enable key rotation (which jwks_uri does, as described in Section 10 of OpenID Connect Core 1.0 [OpenID.Core]). The jwks_uri and jwks parameters MUST NOT be used together. */
            jwks?: unknown
            /** @description OAuth 2.0 Client JSON Web Key Set URL  URL for the Client's JSON Web Key Set [JWK] document. If the Client signs requests to the Server, it contains the signing key(s) the Server uses to validate signatures from the Client. The JWK Set MAY also contain the Client's encryption keys(s), which are used by the Server to encrypt responses to the Client. When both signing and encryption keys are made available, a use (Key Use) parameter value is REQUIRED for all keys in the referenced JWK Set to indicate each key's intended usage. Although some algorithms allow the same key to be used for both signatures and encryption, doing so is NOT RECOMMENDED, as it is less secure. The JWK x5c parameter MAY be used to provide X.509 representations of keys provided. When used, the bare key values MUST still be present and MUST match those in the certificate. */
            jwks_uri?: string
            /** @description Specify a time duration in milliseconds, seconds, minutes, hours. */
            jwt_bearer_grant_access_token_lifespan?: string
            /** @description OAuth 2.0 Client Logo URI  A URL string referencing the client's logo. */
            logo_uri?: string
            metadata?: unknown
            /** @description OAuth 2.0 Client Owner  Owner is a string identifying the owner of the OAuth 2.0 Client. */
            owner?: string
            /** @description OAuth 2.0 Client Policy URI  PolicyURI is a URL string that points to a human-readable privacy policy document that describes how the deployment organization collects, uses, retains, and discloses personal data. */
            policy_uri?: string
            post_logout_redirect_uris?: string[]
            redirect_uris?: string[]
            /** @description Specify a time duration in milliseconds, seconds, minutes, hours. */
            refresh_token_grant_access_token_lifespan?: string
            /** @description Specify a time duration in milliseconds, seconds, minutes, hours. */
            refresh_token_grant_id_token_lifespan?: string
            /** @description Specify a time duration in milliseconds, seconds, minutes, hours. */
            refresh_token_grant_refresh_token_lifespan?: string
            /** @description OpenID Connect Dynamic Client Registration Access Token  RegistrationAccessToken can be used to update, get, or delete the OAuth2 Client. It is sent when creating a client using Dynamic Client Registration. */
            registration_access_token?: string
            /** @description OpenID Connect Dynamic Client Registration URL  RegistrationClientURI is the URL used to update, get, or delete the OAuth2 Client. */
            registration_client_uri?: string
            /** @description OpenID Connect Request Object Signing Algorithm  JWS [JWS] alg algorithm [JWA] that MUST be used for signing Request Objects sent to the OP. All Request Objects from this Client MUST be rejected, if not signed with this algorithm. */
            request_object_signing_alg?: string
            request_uris?: string[]
            response_types?: string[]
            /** @description OAuth 2.0 Client Scope  Scope is a string containing a space-separated list of scope values (as described in Section 3.3 of OAuth 2.0 [RFC6749]) that the client can use when requesting access tokens. */
            scope?: string
            /** @description OpenID Connect Sector Identifier URI  URL using the https scheme to be used in calculating Pseudonymous Identifiers by the OP. The URL references a file with a single JSON array of redirect_uri values. */
            sector_identifier_uri?: string
            /** @description OpenID Connect Subject Type  The `subject_types_supported` Discovery parameter contains a list of the supported subject_type values for this server. Valid types include `pairwise` and `public`. */
            subject_type?: string
            /** @description OAuth 2.0 Token Endpoint Authentication Method  Requested Client Authentication method for the Token Endpoint. The options are:  `client_secret_post`: (default) Send `client_id` and `client_secret` as `application/x-www-form-urlencoded` in the HTTP body. `client_secret_basic`: Send `client_id` and `client_secret` as `application/x-www-form-urlencoded` encoded in the HTTP Authorization header. `private_key_jwt`: Use JSON Web Tokens to authenticate the client. `none`: Used for public clients (native apps, mobile apps) which can not have secrets. */
            token_endpoint_auth_method?: string
            /** @description OAuth 2.0 Token Endpoint Signing Algorithm  Requested Client Authentication signing algorithm for the Token Endpoint. */
            token_endpoint_auth_signing_alg?: string
            /** @description OAuth 2.0 Client Terms of Service URI  A URL string pointing to a human-readable terms of service document for the client that describes a contractual relationship between the end-user and the client that the end-user accepts when authorizing the client. */
            tos_uri?: string
            /**
             * Format: date-time
             * @description OAuth 2.0 Client Last Update Date  UpdatedAt returns the timestamp of the last update.
             */
            updated_at?: string
            /** @description OpenID Connect Request Userinfo Signed Response Algorithm  JWS alg algorithm [JWA] REQUIRED for signing UserInfo Responses. If this is specified, the response will be JWT [JWT] serialized, and signed using JWS. The default, if omitted, is for the UserInfo Response to return the Claims as a UTF-8 encoded JSON object using the application/json content-type. */
            userinfo_signed_response_alg?: string
        }
        /** @description OAuth2ConsentRequestOpenIDConnectContext struct for OAuth2ConsentRequestOpenIDConnectContext */
        OAuth2ConsentRequestOpenIDConnectContext: {
            /** @description ACRValues is the Authentication AuthorizationContext Class Reference requested in the OAuth 2.0 Authorization request. It is a parameter defined by OpenID Connect and expresses which level of authentication (e.g. 2FA) is required.  OpenID Connect defines it as follows: > Requested Authentication AuthorizationContext Class Reference values. Space-separated string that specifies the acr values that the Authorization Server is being requested to use for processing this Authentication Request, with the values appearing in order of preference. The Authentication AuthorizationContext Class satisfied by the authentication performed is returned as the acr Claim Value, as specified in Section 2. The acr Claim is requested as a Voluntary Claim by this parameter. */
            acr_values?: string[]
            /** @description Display is a string value that specifies how the Authorization Server displays the authentication and consent user interface pages to the End-User. The defined values are: page: The Authorization Server SHOULD display the authentication and consent UI consistent with a full User Agent page view. If the display parameter is not specified, this is the default display mode. popup: The Authorization Server SHOULD display the authentication and consent UI consistent with a popup User Agent window. The popup User Agent window should be of an appropriate size for a login-focused dialog and should not obscure the entire window that it is popping up over. touch: The Authorization Server SHOULD display the authentication and consent UI consistent with a device that leverages a touch interface. wap: The Authorization Server SHOULD display the authentication and consent UI consistent with a \"feature phone\" type display.  The Authorization Server MAY also attempt to detect the capabilities of the User Agent and present an appropriate display. */
            display?: string
            /** @description IDTokenHintClaims are the claims of the ID Token previously issued by the Authorization Server being passed as a hint about the End-User's current or past authenticated session with the Client. */
            id_token_hint_claims?: {
                [key: string]: unknown
            }
            /** @description LoginHint hints about the login identifier the End-User might use to log in (if necessary). This hint can be used by an RP if it first asks the End-User for their e-mail address (or other identifier) and then wants to pass that value as a hint to the discovered authorization service. This value MAY also be a phone number in the format specified for the phone_number Claim. The use of this parameter is optional. */
            login_hint?: string
            /** @description UILocales is the End-User'id preferred languages and scripts for the user interface, represented as a space-separated list of BCP47 [RFC5646] language tag values, ordered by preference. For instance, the value \"fr-CA fr en\" represents a preference for French as spoken in Canada, then French (without a region designation), followed by English (without a region designation). An error SHOULD NOT result if some or all of the requested locales are not supported by the OpenID Provider. */
            ui_locales?: string[]
        }
        /** @description OAuth2LoginRequest struct for OAuth2LoginRequest */
        OAuth2LoginRequest: {
            /** @description ID is the identifier (\"login challenge\") of the login request. It is used to identify the session. */
            challenge?: string
            client?: components["schemas"]["OAuth2Client"]
            oidc_context?: components["schemas"]["OAuth2ConsentRequestOpenIDConnectContext"]
            /** @description RequestURL is the original OAuth 2.0 Authorization URL requested by the OAuth 2.0 client. It is the URL which initiates the OAuth 2.0 Authorization Code or OAuth 2.0 Implicit flow. This URL is typically not needed, but might come in handy if you want to deal with additional request parameters. */
            request_url?: string
            requested_access_token_audience?: string[]
            requested_scope?: string[]
            /** @description SessionID is the login session ID. If the user-agent reuses a login session (via cookie / remember flag) this ID will remain the same. If the user-agent did not have an existing authentication session (e.g. remember is false) this will be a new random value. This value is used as the \"sid\" parameter in the ID Token and in OIDC Front-/Back- channel logout. It's value can generally be used to associate consecutive login requests by a certain user. */
            session_id?: string
            /** @description Skip, if true, implies that the client has requested the same scopes from the same user previously. If true, you can skip asking the user to grant the requested scopes, and simply forward the user to the redirect URL.  This feature allows you to update / set session information. */
            skip?: boolean
            /** @description Subject is the user ID of the end-user that authenticated. Now, that end user needs to grant or deny the scope requested by the OAuth 2.0 client. If this value is set and `skip` is true, you MUST include this subject type when accepting the login request, or the request will fail. */
            subject?: string
        }
        /** RecoveryAddressType must not exceed 16 characters as that is the limitation in the SQL Schema. */
        RecoveryAddressType: string
        /** Format: date-time */
        Time: string
        /** Format: uuid4 */
        UUID: string
        /**
         * Authenticator Assurance Level (AAL)
         * @description The authenticator assurance level can be one of "aal1", "aal2", or "aal3". A higher number means that it is harder
         * for an attacker to compromise the account.
         *
         * Generally, "aal1" implies that one authentication factor was used while AAL2 implies that two factors (e.g.
         * password + TOTP) have been used.
         *
         * To learn more about these levels please head over to: https://www.ory.sh/kratos/docs/concepts/credentials
         * @enum {string}
         */
        authenticatorAssuranceLevel: "aal0" | "aal1" | "aal2" | "aal3"
        /** @description Patch identities response */
        batchPatchIdentitiesResponse: {
            /** @description The patch responses for the individual identities. */
            identities?: components["schemas"]["identityPatchResponse"][]
        }
        continueWith:
            | components["schemas"]["continueWithVerificationUi"]
            | components["schemas"]["continueWithSetOrySessionToken"]
        /** @description Indicates that a session was issued, and the application should use this token for authenticated requests */
        continueWithSetOrySessionToken: {
            /**
             * @description Action will always be `set_ory_session_token`
             * set_ory_session_token ContinueWithActionSetOrySessionToken
             * show_verification_ui ContinueWithActionShowVerificationUI
             * @enum {string}
             */
            action: "set_ory_session_token" | "show_verification_ui"
            /** @description Token is the token of the session */
            ory_session_token: string
        }
        /** @description Indicates, that the UI flow could be continued by showing a verification ui */
        continueWithVerificationUi: {
            /**
             * @description Action will always be `show_verification_ui`
             * set_ory_session_token ContinueWithActionSetOrySessionToken
             * show_verification_ui ContinueWithActionShowVerificationUI
             * @enum {string}
             */
            action: "set_ory_session_token" | "show_verification_ui"
            flow: components["schemas"]["continueWithVerificationUiFlow"]
        }
        continueWithVerificationUiFlow: {
            /**
             * Format: uuid
             * @description The ID of the verification flow
             */
            id: string
            /** @description The URL of the verification flow */
            url?: string
            /** @description The address that should be verified in this flow */
            verifiable_address: string
        }
        /**
         * @description A Message's Status
         * @enum {string}
         */
        courierMessageStatus: "queued" | "sent" | "processing" | "abandoned"
        /**
         * A Message's Type
         * @description It can either be `email` or `phone`
         * @enum {string}
         */
        courierMessageType: "email" | "phone"
        /** @description Create Identity Body */
        createIdentityBody: {
            credentials?: components["schemas"]["identityWithCredentials"]
            /** @description Store metadata about the user which is only accessible through admin APIs such as `GET /admin/identities/<id>`. */
            metadata_admin?: unknown
            /**
             * @description Store metadata about the identity which the identity itself can see when calling for example the
             * session endpoint. Do not store sensitive information (e.g. credit score) about the identity in this field.
             */
            metadata_public?: unknown
            /**
             * @description RecoveryAddresses contains all the addresses that can be used to recover an identity.
             *
             * Use this structure to import recovery addresses for an identity. Please keep in mind
             * that the address needs to be represented in the Identity Schema or this field will be overwritten
             * on the next identity update.
             */
            recovery_addresses?: components["schemas"]["recoveryIdentityAddress"][]
            /** @description SchemaID is the ID of the JSON Schema to be used for validating the identity's traits. */
            schema_id: string
            state?: components["schemas"]["identityState"]
            /**
             * @description Traits represent an identity's traits. The identity is able to create, modify, and delete traits
             * in a self-service manner. The input will always be validated against the JSON Schema defined
             * in `schema_url`.
             */
            traits: Record<string, never>
            /**
             * @description VerifiableAddresses contains all the addresses that can be verified by the user.
             *
             * Use this structure to import verified addresses for an identity. Please keep in mind
             * that the address needs to be represented in the Identity Schema or this field will be overwritten
             * on the next identity update.
             */
            verifiable_addresses?: components["schemas"]["verifiableIdentityAddress"][]
        }
        /** @description Create Recovery Code for Identity Request Body */
        createRecoveryCodeForIdentityBody: {
            /**
             * @description Code Expires In
             *
             * The recovery code will expire after that amount of time has passed. Defaults to the configuration value of
             * `selfservice.methods.code.config.lifespan`.
             */
            expires_in?: string
            /**
             * Format: uuid
             * @description Identity to Recover
             *
             * The identity's ID you wish to recover.
             */
            identity_id: string
        }
        /** @description Create Recovery Link for Identity Request Body */
        createRecoveryLinkForIdentityBody: {
            /**
             * @description Link Expires In
             *
             * The recovery link will expire after that amount of time has passed. Defaults to the configuration value of
             * `selfservice.methods.code.config.lifespan`.
             */
            expires_in?: string
            /**
             * Format: uuid
             * @description Identity to Recover
             *
             * The identity's ID you wish to recover.
             */
            identity_id: string
        }
        /** @description Deleted Session Count */
        deleteMySessionsCount: {
            /**
             * Format: int64
             * @description The number of sessions that were revoked.
             */
            count?: number
        }
        /** Is returned when an active session was found but the requested AAL is not satisfied. */
        errorAuthenticatorAssuranceLevelNotSatisfied: {
            error?: components["schemas"]["genericError"]
            /** @description Points to where to redirect the user to next. */
            redirect_browser_to?: string
        }
        /** Is sent when a flow requires a browser to change its location. */
        errorBrowserLocationChangeRequired: {
            error?: components["schemas"]["errorGeneric"]
            /** @description Points to where to redirect the user to next. */
            redirect_browser_to?: string
        }
        /** @description Is sent when a flow is replaced by a different flow of the same class */
        errorFlowReplaced: {
            error?: components["schemas"]["genericError"]
            /**
             * Format: uuid
             * @description The flow ID that should be used for the new flow as it contains the correct messages.
             */
            use_flow_id?: string
        }
        /**
         * JSON API Error Response
         * @description The standard Ory JSON API error format.
         */
        errorGeneric: {
            error: components["schemas"]["genericError"]
        }
        flowError: {
            /**
             * Format: date-time
             * @description CreatedAt is a helper struct field for gobuffalo.pop.
             */
            created_at?: string
            error?: Record<string, never>
            /**
             * Format: uuid
             * @description ID of the error container.
             */
            id: string
            /**
             * Format: date-time
             * @description UpdatedAt is a helper struct field for gobuffalo.pop.
             */
            updated_at?: string
        }
        genericError: {
            /**
             * Format: int64
             * @description The status code
             * @example 404
             */
            code?: number
            /**
             * @description Debug information
             *
             * This field is often not exposed to protect against leaking
             * sensitive information.
             * @example SQL field "foo" is not a bool.
             */
            debug?: string
            /** @description Further error details */
            details?: Record<string, never>
            /**
             * @description The error ID
             *
             * Useful when trying to identify various errors in application logic.
             */
            id?: string
            /**
             * @description Error message
             *
             * The error's message.
             * @example The resource could not be found
             */
            message: string
            /**
             * @description A human-readable reason for the error
             * @example User with ID 1234 does not exist.
             */
            reason?: string
            /**
             * @description The request ID
             *
             * The request ID is often exposed internally in order to trace
             * errors across service architectures. This is often a UUID.
             * @example d7ef54b1-ec15-46e6-bccb-524b82c035e6
             */
            request?: string
            /**
             * @description The status description
             * @example Not Found
             */
            status?: string
        }
        healthNotReadyStatus: {
            /** @description Errors contains a list of errors that caused the not ready status. */
            errors?: {
                [key: string]: string
            }
        }
        healthStatus: {
            /** @description Status always contains "ok". */
            status?: string
        }
        /**
         * Identity represents an Ory Kratos identity
         * @description An [identity](https://www.ory.sh/docs/kratos/concepts/identity-user-model) represents a (human) user in Ory.
         */
        identity: {
            /**
             * Format: date-time
             * @description CreatedAt is a helper struct field for gobuffalo.pop.
             */
            created_at?: string
            /** @description Credentials represents all credentials that can be used for authenticating this identity. */
            credentials?: {
                [key: string]: components["schemas"]["identityCredentials"]
            }
            /**
             * Format: uuid
             * @description ID is the identity's unique identifier.
             *
             * The Identity ID can not be changed and can not be chosen. This ensures future
             * compatibility and optimization for distributed stores such as CockroachDB.
             */
            id: string
            metadata_admin?: components["schemas"]["nullJsonRawMessage"]
            metadata_public?: components["schemas"]["nullJsonRawMessage"]
            /** @description RecoveryAddresses contains all the addresses that can be used to recover an identity. */
            recovery_addresses?: components["schemas"]["recoveryIdentityAddress"][]
            /** @description SchemaID is the ID of the JSON Schema to be used for validating the identity's traits. */
            schema_id: string
            /**
             * @description SchemaURL is the URL of the endpoint where the identity's traits schema can be fetched from.
             *
             * format: url
             */
            schema_url: string
            state?: components["schemas"]["identityState"]
            state_changed_at?: components["schemas"]["nullTime"]
            traits: components["schemas"]["identityTraits"]
            /**
             * Format: date-time
             * @description UpdatedAt is a helper struct field for gobuffalo.pop.
             */
            updated_at?: string
            /** @description VerifiableAddresses contains all the addresses that can be verified by the user. */
            verifiable_addresses?: components["schemas"]["verifiableIdentityAddress"][]
        }
        /** @description Credentials represents a specific credential type */
        identityCredentials: {
            config?: components["schemas"]["JSONRawMessage"]
            /**
             * Format: date-time
             * @description CreatedAt is a helper struct field for gobuffalo.pop.
             */
            created_at?: string
            /** @description Identifiers represents a list of unique identifiers this credential type matches. */
            identifiers?: string[]
            type?: components["schemas"]["identityCredentialsType"]
            /**
             * Format: date-time
             * @description UpdatedAt is a helper struct field for gobuffalo.pop.
             */
            updated_at?: string
            /**
             * Format: int64
             * @description Version refers to the version of the credential. Useful when changing the config schema.
             */
            version?: number
        }
        /** CredentialsOIDC is contains the configuration for credentials of the type oidc. */
        identityCredentialsOidc: {
            providers?: components["schemas"]["identityCredentialsOidcProvider"][]
        }
        /** CredentialsOIDCProvider is contains a specific OpenID COnnect credential for a particular connection (e.g. Google). */
        identityCredentialsOidcProvider: {
            initial_access_token?: string
            initial_id_token?: string
            initial_refresh_token?: string
            provider?: string
            subject?: string
        }
        /** CredentialsPassword is contains the configuration for credentials of the type password. */
        identityCredentialsPassword: {
            /** @description HashedPassword is a hash-representation of the password. */
            hashed_password?: string
        }
        /**
         * CredentialsType  represents several different credential types, like password credentials, passwordless credentials,
         * @description and so on.
         * @enum {string}
         */
        identityCredentialsType: "password" | "totp" | "oidc" | "webauthn" | "lookup_secret"
        /** @description Payload for patching an identity */
        identityPatch: {
            create?: components["schemas"]["createIdentityBody"]
            /**
             * Format: uuid
             * @description The ID of this patch.
             *
             * The patch ID is optional. If specified, the ID will be returned in the
             * response, so consumers of this API can correlate the response with the
             * patch.
             */
            patch_id?: string
        }
        /** @description Response for a single identity patch */
        identityPatchResponse: {
            /**
             * @description The action for this specific patch
             * create ActionCreate  Create this identity.
             * @enum {string}
             */
            action?: "create"
            /**
             * Format: uuid
             * @description The identity ID payload of this patch
             */
            identity?: string
            /**
             * Format: uuid
             * @description The ID of this patch response, if an ID was specified in the patch.
             */
            patch_id?: string
        }
        /** @description Raw JSON Schema */
        identitySchema: Record<string, never>
        /** @description An Identity JSON Schema Container */
        identitySchemaContainer: {
            /** @description The ID of the Identity JSON Schema */
            id?: string
            /** @description The actual Identity JSON Schema */
            schema?: Record<string, never>
        }
        /** @description List of Identity JSON Schemas */
        identitySchemas: components["schemas"]["identitySchemaContainer"][]
        /**
         * An Identity's State
         * @description The state can either be `active` or `inactive`.
         * @enum {string}
         */
        identityState: "active" | "inactive"
        /**
         * @description Traits represent an identity's traits. The identity is able to create, modify, and delete traits
         * in a self-service manner. The input will always be validated against the JSON Schema defined
         * in `schema_url`.
         */
        identityTraits: unknown
        /** @description VerifiableAddressStatus must not exceed 16 characters as that is the limitation in the SQL Schema */
        identityVerifiableAddressStatus: string
        /** @description VerifiableAddressType must not exceed 16 characters as that is the limitation in the SQL Schema */
        identityVerifiableAddressType: string
        /** @description Create Identity and Import Credentials */
        identityWithCredentials: {
            oidc?: components["schemas"]["identityWithCredentialsOidc"]
            password?: components["schemas"]["identityWithCredentialsPassword"]
        }
        /** @description Create Identity and Import Social Sign In Credentials */
        identityWithCredentialsOidc: {
            config?: components["schemas"]["identityWithCredentialsOidcConfig"]
        }
        identityWithCredentialsOidcConfig: {
            config?: components["schemas"]["identityWithCredentialsPasswordConfig"]
            /** @description A list of OpenID Connect Providers */
            providers?: components["schemas"]["identityWithCredentialsOidcConfigProvider"][]
        }
        /** @description Create Identity and Import Social Sign In Credentials Configuration */
        identityWithCredentialsOidcConfigProvider: {
            /** @description The OpenID Connect provider to link the subject to. Usually something like `google` or `github`. */
            provider: string
            /** @description The subject (`sub`) of the OpenID Connect connection. Usually the `sub` field of the ID Token. */
            subject: string
        }
        /** @description Create Identity and Import Password Credentials */
        identityWithCredentialsPassword: {
            config?: components["schemas"]["identityWithCredentialsPasswordConfig"]
        }
        /** @description Create Identity and Import Password Credentials Configuration */
        identityWithCredentialsPasswordConfig: {
            /** @description The hashed password in [PHC format]( https://www.ory.sh/docs/kratos/concepts/credentials/username-email-password#hashed-password-format) */
            hashed_password?: string
            /** @description The password in plain text if no hash is available. */
            password?: string
        }
        /** @description A JSONPatch document as defined by RFC 6902 */
        jsonPatch: {
            /**
             * @description This field is used together with operation "move" and uses JSON Pointer notation.
             *
             * Learn more [about JSON Pointers](https://datatracker.ietf.org/doc/html/rfc6901#section-5).
             * @example /name
             */
            from?: string
            /**
             * @description The operation to be performed. One of "add", "remove", "replace", "move", "copy", or "test".
             * @example replace
             */
            op: string
            /**
             * @description The path to the target path. Uses JSON pointer notation.
             *
             * Learn more [about JSON Pointers](https://datatracker.ietf.org/doc/html/rfc6901#section-5).
             * @example /name
             */
            path: string
            /**
             * @description The value to be used within the operations.
             *
             * Learn more [about JSON Pointers](https://datatracker.ietf.org/doc/html/rfc6901#section-5).
             * @example foobar
             */
            value?: unknown
        }
        /** @description A JSONPatchDocument request */
        jsonPatchDocument: components["schemas"]["jsonPatch"][]
        /**
         * Login Flow
         * @description This object represents a login flow. A login flow is initiated at the "Initiate Login API / Browser Flow"
         * endpoint by a client.
         *
         * Once a login flow is completed successfully, a session cookie or session token will be issued.
         */
        loginFlow: {
            active?: components["schemas"]["identityCredentialsType"]
            /**
             * Format: date-time
             * @description CreatedAt is a helper struct field for gobuffalo.pop.
             */
            created_at?: string
            /**
             * Format: date-time
             * @description ExpiresAt is the time (UTC) when the flow expires. If the user still wishes to log in,
             * a new flow has to be initiated.
             */
            expires_at: string
            /**
             * Format: uuid
             * @description ID represents the flow's unique ID. When performing the login flow, this
             * represents the id in the login UI's query parameter: http://<selfservice.flows.login.ui_url>/?flow=<flow_id>
             */
            id: string
            /**
             * Format: date-time
             * @description IssuedAt is the time (UTC) when the flow started.
             */
            issued_at: string
            /**
             * @description Ory OAuth 2.0 Login Challenge.
             *
             * This value is set using the `login_challenge` query parameter of the registration and login endpoints.
             * If set will cooperate with Ory OAuth2 and OpenID to act as an OAuth2 server / OpenID Provider.
             */
            oauth2_login_challenge?: string
            oauth2_login_request?: components["schemas"]["OAuth2LoginRequest"]
            /** @description Refresh stores whether this login flow should enforce re-authentication. */
            refresh?: boolean
            /**
             * @description RequestURL is the initial URL that was requested from Ory Kratos. It can be used
             * to forward information contained in the URL's path or query for example.
             */
            request_url: string
            requested_aal?: components["schemas"]["authenticatorAssuranceLevel"]
            /** @description ReturnTo contains the requested return_to URL. */
            return_to?: string
            /**
             * @description SessionTokenExchangeCode holds the secret code that the client can use to retrieve a session token after the login flow has been completed.
             * This is only set if the client has requested a session token exchange code, and if the flow is of type "api",
             * and only on creating the login flow.
             */
            session_token_exchange_code?: string
            type: components["schemas"]["selfServiceFlowType"]
            ui: components["schemas"]["uiContainer"]
            /**
             * Format: date-time
             * @description UpdatedAt is a helper struct field for gobuffalo.pop.
             */
            updated_at?: string
        }
        /** @description Logout Flow */
        logoutFlow: {
            /** @description LogoutToken can be used to perform logout using AJAX. */
            logout_token: string
            /**
             * @description LogoutURL can be opened in a browser to sign the user out.
             *
             * format: uri
             */
            logout_url: string
        }
        message: {
            body: string
            /**
             * Format: date-time
             * @description CreatedAt is a helper struct field for gobuffalo.pop.
             */
            created_at: string
            /**
             * @description Dispatches store information about the attempts of delivering a message
             * May contain an error if any happened, or just the `success` state.
             */
            dispatches?: components["schemas"]["messageDispatch"][]
            /** Format: uuid */
            id: string
            recipient: string
            /** Format: int64 */
            send_count: number
            status: components["schemas"]["courierMessageStatus"]
            subject: string
            /**
             * @description
             * recovery_invalid TypeRecoveryInvalid
             * recovery_valid TypeRecoveryValid
             * recovery_code_invalid TypeRecoveryCodeInvalid
             * recovery_code_valid TypeRecoveryCodeValid
             * verification_invalid TypeVerificationInvalid
             * verification_valid TypeVerificationValid
             * verification_code_invalid TypeVerificationCodeInvalid
             * verification_code_valid TypeVerificationCodeValid
             * otp TypeOTP
             * stub TypeTestStub
             * @enum {string}
             */
            template_type:
                | "recovery_invalid"
                | "recovery_valid"
                | "recovery_code_invalid"
                | "recovery_code_valid"
                | "verification_invalid"
                | "verification_valid"
                | "verification_code_invalid"
                | "verification_code_valid"
                | "otp"
                | "stub"
            type: components["schemas"]["courierMessageType"]
            /**
             * Format: date-time
             * @description UpdatedAt is a helper struct field for gobuffalo.pop.
             */
            updated_at: string
        }
        /**
         * @description MessageDispatch represents an attempt of sending a courier message
         * It contains the status of the attempt (failed or successful) and the error if any occured
         */
        messageDispatch: {
            /**
             * Format: date-time
             * @description CreatedAt is a helper struct field for gobuffalo.pop.
             */
            created_at: string
            error?: components["schemas"]["JSONRawMessage"]
            /**
             * Format: uuid
             * @description The ID of this message dispatch
             */
            id: string
            /**
             * Format: uuid
             * @description The ID of the message being dispatched
             */
            message_id: string
            /**
             * @description The status of this dispatch
             * Either "failed" or "success"
             * failed CourierMessageDispatchStatusFailed
             * success CourierMessageDispatchStatusSuccess
             * @enum {string}
             */
            status: "failed" | "success"
            /**
             * Format: date-time
             * @description UpdatedAt is a helper struct field for gobuffalo.pop.
             */
            updated_at: string
        }
        /** Is sent when a privileged session is required to perform the settings update. */
        needsPrivilegedSessionError: {
            error?: components["schemas"]["genericError"]
            /** @description Points to where to redirect the user to next. */
            redirect_browser_to: string
        }
        nullDuration: string | null
        nullInt64: number | null
        /** @description NullJSONRawMessage represents a json.RawMessage that works well with JSON, SQL, and Swagger and is NULLable- */
        nullJsonRawMessage: Record<string, unknown> | null
        /**
         * NullTime implements sql.NullTime functionality.
         * Format: date-time
         */
        nullTime: string
        pagination: {
            /**
             * Format: int64
             * @description Pagination Page
             *
             * This value is currently an integer, but it is not sequential. The value is not the page number, but a
             * reference. The next page can be any number and some numbers might return an empty list.
             *
             * For example, page 2 might not follow after page 1. And even if page 3 and 5 exist, but page 4 might not exist.
             * @default 1
             */
            page?: number
            /**
             * Format: int64
             * @description Items per Page
             *
             * This is the number of items per page.
             * @default 250
             */
            per_page?: number
        }
        /** @description Patch Identities Body */
        patchIdentitiesBody: {
            /**
             * @description Identities holds the list of patches to apply
             *
             * required
             */
            identities?: components["schemas"]["identityPatch"][]
        }
        /** @description Perform Native Logout Request Body */
        performNativeLogoutBody: {
            /**
             * @description The Session Token
             *
             * Invalidate this session token.
             */
            session_token: string
        }
        /**
         * Recovery Code for Identity
         * @description Used when an administrator creates a recovery code for an identity.
         */
        recoveryCodeForIdentity: {
            /**
             * Format: date-time
             * @description Expires At is the timestamp of when the recovery flow expires
             *
             * The timestamp when the recovery link expires.
             */
            expires_at?: string
            /** @description RecoveryCode is the code that can be used to recover the account */
            recovery_code: string
            /**
             * @description RecoveryLink with flow
             *
             * This link opens the recovery UI with an empty `code` field.
             */
            recovery_link: string
        }
        /**
         * A Recovery Flow
         * @description This request is used when an identity wants to recover their account.
         *
         * We recommend reading the [Account Recovery Documentation](../self-service/flows/password-reset-account-recovery)
         */
        recoveryFlow: {
            /**
             * @description Active, if set, contains the recovery method that is being used. It is initially
             * not set.
             */
            active?: string
            /**
             * Format: date-time
             * @description ExpiresAt is the time (UTC) when the request expires. If the user still wishes to update the setting,
             * a new request has to be initiated.
             */
            expires_at: string
            /**
             * Format: uuid
             * @description ID represents the request's unique ID. When performing the recovery flow, this
             * represents the id in the recovery ui's query parameter: http://<selfservice.flows.recovery.ui_url>?request=<id>
             */
            id: string
            /**
             * Format: date-time
             * @description IssuedAt is the time (UTC) when the request occurred.
             */
            issued_at: string
            /**
             * @description RequestURL is the initial URL that was requested from Ory Kratos. It can be used
             * to forward information contained in the URL's path or query for example.
             */
            request_url: string
            /** @description ReturnTo contains the requested return_to URL. */
            return_to?: string
            state: components["schemas"]["recoveryFlowState"]
            type: components["schemas"]["selfServiceFlowType"]
            ui: components["schemas"]["uiContainer"]
        }
        /**
         * Recovery Flow State
         * @description The state represents the state of the recovery flow.
         *
         * choose_method: ask the user to choose a method (e.g. recover account via email)
         * sent_email: the email has been sent to the user
         * passed_challenge: the request was successful and the recovery challenge was passed.
         * @enum {string}
         */
        recoveryFlowState: "choose_method" | "sent_email" | "passed_challenge"
        recoveryIdentityAddress: {
            /**
             * Format: date-time
             * @description CreatedAt is a helper struct field for gobuffalo.pop.
             */
            created_at?: string
            /** Format: uuid */
            id: string
            /**
             * Format: date-time
             * @description UpdatedAt is a helper struct field for gobuffalo.pop.
             */
            updated_at?: string
            value: string
            via: components["schemas"]["RecoveryAddressType"]
        }
        /**
         * Identity Recovery Link
         * @description Used when an administrator creates a recovery link for an identity.
         */
        recoveryLinkForIdentity: {
            /**
             * Format: date-time
             * @description Recovery Link Expires At
             *
             * The timestamp when the recovery link expires.
             */
            expires_at?: string
            /**
             * @description Recovery Link
             *
             * This link can be used to recover the account.
             */
            recovery_link: string
        }
        registrationFlow: {
            active?: components["schemas"]["identityCredentialsType"]
            /**
             * Format: date-time
             * @description ExpiresAt is the time (UTC) when the flow expires. If the user still wishes to log in,
             * a new flow has to be initiated.
             */
            expires_at: string
            /**
             * Format: uuid
             * @description ID represents the flow's unique ID. When performing the registration flow, this
             * represents the id in the registration ui's query parameter: http://<selfservice.flows.registration.ui_url>/?flow=<id>
             */
            id: string
            /**
             * Format: date-time
             * @description IssuedAt is the time (UTC) when the flow occurred.
             */
            issued_at: string
            /**
             * @description Ory OAuth 2.0 Login Challenge.
             *
             * This value is set using the `login_challenge` query parameter of the registration and login endpoints.
             * If set will cooperate with Ory OAuth2 and OpenID to act as an OAuth2 server / OpenID Provider.
             */
            oauth2_login_challenge?: string
            oauth2_login_request?: components["schemas"]["OAuth2LoginRequest"]
            /**
             * @description RequestURL is the initial URL that was requested from Ory Kratos. It can be used
             * to forward information contained in the URL's path or query for example.
             */
            request_url: string
            /** @description ReturnTo contains the requested return_to URL. */
            return_to?: string
            /**
             * @description SessionTokenExchangeCode holds the secret code that the client can use to retrieve a session token after the flow has been completed.
             * This is only set if the client has requested a session token exchange code, and if the flow is of type "api",
             * and only on creating the flow.
             */
            session_token_exchange_code?: string
            /** @description TransientPayload is used to pass data from the registration to a webhook */
            transient_payload?: Record<string, never>
            type: components["schemas"]["selfServiceFlowType"]
            ui: components["schemas"]["uiContainer"]
        }
        /** @description Is sent when a flow is expired */
        selfServiceFlowExpiredError: {
            error?: components["schemas"]["genericError"]
            /**
             * Format: date-time
             * @description When the flow has expired
             */
            expired_at?: string
            since?: components["schemas"]["Duration"]
            /**
             * Format: uuid
             * @description The flow ID that should be used for the new flow as it contains the correct messages.
             */
            use_flow_id?: string
        }
        /**
         * Type is the flow type.
         * @description The flow type can either be `api` or `browser`.
         */
        selfServiceFlowType: string
        /** @description A Session */
        session: {
            /** @description Active state. If false the session is no longer active. */
            active?: boolean
            /**
             * Format: date-time
             * @description The Session Authentication Timestamp
             *
             * When this session was authenticated at. If multi-factor authentication was used this
             * is the time when the last factor was authenticated (e.g. the TOTP code challenge was completed).
             */
            authenticated_at?: string
            authentication_methods?: components["schemas"]["sessionAuthenticationMethods"]
            authenticator_assurance_level?: components["schemas"]["authenticatorAssuranceLevel"]
            /** @description Devices has history of all endpoints where the session was used */
            devices?: components["schemas"]["sessionDevice"][]
            /**
             * Format: date-time
             * @description The Session Expiry
             *
             * When this session expires at.
             */
            expires_at?: string
            /**
             * Format: uuid
             * @description Session ID
             */
            id: string
            identity: components["schemas"]["identity"]
            /**
             * Format: date-time
             * @description The Session Issuance Timestamp
             *
             * When this session was issued at. Usually equal or close to `authenticated_at`.
             */
            issued_at?: string
        }
        /**
         * AuthenticationMethod identifies an authentication method
         * @description A singular authenticator used during authentication / login.
         */
        sessionAuthenticationMethod: {
            aal?: components["schemas"]["authenticatorAssuranceLevel"]
            /**
             * Format: date-time
             * @description When the authentication challenge was completed.
             */
            completed_at?: string
            /**
             * The method used
             * @enum {string}
             */
            method?:
                | "link_recovery"
                | "code_recovery"
                | "password"
                | "totp"
                | "oidc"
                | "webauthn"
                | "lookup_secret"
                | "v0.6_legacy_session"
            /** @description OIDC or SAML provider id used for authentication */
            provider?: string
        }
        /**
         * List of (Used) AuthenticationMethods
         * @description A list of authenticators which were used to authenticate the session.
         */
        sessionAuthenticationMethods: components["schemas"]["sessionAuthenticationMethod"][]
        /** @description Device corresponding to a Session */
        sessionDevice: {
            /**
             * Format: uuid
             * @description Device record ID
             */
            id: string
            /** @description IPAddress of the client */
            ip_address?: string
            /** @description Geo Location corresponding to the IP Address */
            location?: string
            /** @description UserAgent of the client */
            user_agent?: string
        }
        /**
         * Flow represents a Settings Flow
         * @description This flow is used when an identity wants to update settings
         * (e.g. profile data, passwords, ...) in a selfservice manner.
         *
         * We recommend reading the [User Settings Documentation](../self-service/flows/user-settings)
         */
        settingsFlow: {
            /**
             * @description Active, if set, contains the registration method that is being used. It is initially
             * not set.
             */
            active?: string
            /**
             * @description Contains a list of actions, that could follow this flow
             *
             * It can, for example, contain a reference to the verification flow, created as part of the user's
             * registration.
             */
            continue_with?: components["schemas"]["continueWith"][]
            /**
             * Format: date-time
             * @description ExpiresAt is the time (UTC) when the flow expires. If the user still wishes to update the setting,
             * a new flow has to be initiated.
             */
            expires_at: string
            /**
             * Format: uuid
             * @description ID represents the flow's unique ID. When performing the settings flow, this
             * represents the id in the settings ui's query parameter: http://<selfservice.flows.settings.ui_url>?flow=<id>
             */
            id: string
            identity: components["schemas"]["identity"]
            /**
             * Format: date-time
             * @description IssuedAt is the time (UTC) when the flow occurred.
             */
            issued_at: string
            /**
             * @description RequestURL is the initial URL that was requested from Ory Kratos. It can be used
             * to forward information contained in the URL's path or query for example.
             */
            request_url: string
            /** @description ReturnTo contains the requested return_to URL. */
            return_to?: string
            state: components["schemas"]["settingsFlowState"]
            type: components["schemas"]["selfServiceFlowType"]
            ui: components["schemas"]["uiContainer"]
        }
        /**
         * State represents the state of this flow. It knows two states:
         * @description show_form: No user data has been collected, or it is invalid, and thus the form should be shown.
         * success: Indicates that the settings flow has been updated successfully with the provided data.
         * Done will stay true when repeatedly checking. If set to true, done will revert back to false only
         * when a flow with invalid (e.g. "please use a valid phone number") data was sent.
         * @enum {string}
         */
        settingsFlowState: "show_form" | "success"
        /** @description The Response for Registration Flows via API */
        successfulCodeExchangeResponse: {
            session: components["schemas"]["session"]
            /**
             * @description The Session Token
             *
             * A session token is equivalent to a session cookie, but it can be sent in the HTTP Authorization
             * Header:
             *
             * Authorization: bearer ${session-token}
             *
             * The session token is only issued for API flows, not for Browser flows!
             */
            session_token?: string
        }
        /** @description The Response for Login Flows via API */
        successfulNativeLogin: {
            session: components["schemas"]["session"]
            /**
             * @description The Session Token
             *
             * A session token is equivalent to a session cookie, but it can be sent in the HTTP Authorization
             * Header:
             *
             * Authorization: bearer ${session-token}
             *
             * The session token is only issued for API flows, not for Browser flows!
             */
            session_token?: string
        }
        /** @description The Response for Registration Flows via API */
        successfulNativeRegistration: {
            /**
             * @description Contains a list of actions, that could follow this flow
             *
             * It can, for example, this will contain a reference to the verification flow, created as part of the user's
             * registration or the token of the session.
             */
            continue_with?: components["schemas"]["continueWith"][]
            identity: components["schemas"]["identity"]
            session?: components["schemas"]["session"]
            /**
             * @description The Session Token
             *
             * This field is only set when the session hook is configured as a post-registration hook.
             *
             * A session token is equivalent to a session cookie, but it can be sent in the HTTP Authorization
             * Header:
             *
             * Authorization: bearer ${session-token}
             *
             * The session token is only issued for API flows, not for Browser flows!
             */
            session_token?: string
        }
        tokenPagination: {
            /**
             * Format: int64
             * @description Items per page
             *
             * This is the number of items per page to return.
             * For details on pagination please head over to the [pagination documentation](https://www.ory.sh/docs/ecosystem/api-design#pagination).
             * @default 250
             */
            page_size?: number
            /**
             * @description Next Page Token
             *
             * The next page token.
             * For details on pagination please head over to the [pagination documentation](https://www.ory.sh/docs/ecosystem/api-design#pagination).
             * @default 1
             */
            page_token?: string
        }
        tokenPaginationHeaders: {
            /**
             * @description The link header contains pagination links.
             *
             * For details on pagination please head over to the [pagination documentation](https://www.ory.sh/docs/ecosystem/api-design#pagination).
             *
             * in: header
             */
            link?: string
            /**
             * @description The total number of clients.
             *
             * in: header
             */
            "x-total-count"?: string
        }
        /** @description Container represents a HTML Form. The container can work with both HTTP Form and JSON requests */
        uiContainer: {
            /** @description Action should be used as the form action URL `<form action="{{ .Action }}" method="post">`. */
            action: string
            messages?: components["schemas"]["uiTexts"]
            /** @description Method is the form method (e.g. POST) */
            method: string
            nodes: components["schemas"]["uiNodes"]
        }
        /**
         * Node represents a flow's nodes
         * @description Nodes are represented as HTML elements or their native UI equivalents. For example,
         * a node can be an `<img>` tag, or an `<input element>` but also `some plain text`.
         */
        uiNode:
            | components["schemas"]["uiNodeText"]
            | components["schemas"]["uiNodeInput"]
            | components["schemas"]["uiNodeImage"]
            | components["schemas"]["uiNodeAnchor"]
            | components["schemas"]["uiNodeScript"]
        /** Anchor represents an anchor node. */
        uiNodeAnchor: {
            /**
             * @description Group specifies which group (e.g. password authenticator) this node belongs to.
             * default DefaultGroup
             * password PasswordGroup
             * oidc OpenIDConnectGroup
             * profile ProfileGroup
             * link LinkGroup
             * code CodeGroup
             * totp TOTPGroup
             * lookup_secret LookupGroup
             * webauthn WebAuthnGroup
             * @enum {string}
             */
            group: "default" | "password" | "oidc" | "profile" | "link" | "code" | "totp" | "lookup_secret" | "webauthn"
            messages: components["schemas"]["uiTexts"]
            meta: components["schemas"]["uiNodeMeta"]
            attributes: components["schemas"]["uiNodeAnchorAttributes"]
            type: "a"
        }
        /** AnchorAttributes represents the attributes of an anchor node. */
        uiNodeAnchorAttributes: {
            /**
             * @description The link's href (destination) URL.
             *
             * format: uri
             */
            href: string
            /** @description A unique identifier */
            id: string
            /**
             * @description NodeType represents this node's types. It is a mirror of `node.type` and
             * is primarily used to allow compatibility with OpenAPI 3.0.  In this struct it technically always is "a".
             */
            node_type: string
            title: components["schemas"]["uiText"]
        }
        /** Image represents an image node. */
        uiNodeImage: {
            /**
             * @description Group specifies which group (e.g. password authenticator) this node belongs to.
             * default DefaultGroup
             * password PasswordGroup
             * oidc OpenIDConnectGroup
             * profile ProfileGroup
             * link LinkGroup
             * code CodeGroup
             * totp TOTPGroup
             * lookup_secret LookupGroup
             * webauthn WebAuthnGroup
             * @enum {string}
             */
            group: "default" | "password" | "oidc" | "profile" | "link" | "code" | "totp" | "lookup_secret" | "webauthn"
            messages: components["schemas"]["uiTexts"]
            meta: components["schemas"]["uiNodeMeta"]
            attributes: components["schemas"]["uiNodeImageAttributes"]
            type: "img"
        }
        /** ImageAttributes represents the attributes of an image node. */
        uiNodeImageAttributes: {
            /**
             * Format: int64
             * @description Height of the image
             */
            height: number
            /** @description A unique identifier */
            id: string
            /**
             * @description NodeType represents this node's types. It is a mirror of `node.type` and
             * is primarily used to allow compatibility with OpenAPI 3.0.  In this struct it technically always is "img".
             */
            node_type: string
            /**
             * @description The image's source URL.
             *
             * format: uri
             */
            src: string
            /**
             * Format: int64
             * @description Width of the image
             */
            width: number
        }
        /** Input represents an input node. */
        uiNodeInput: {
            /**
             * @description Group specifies which group (e.g. password authenticator) this node belongs to.
             * default DefaultGroup
             * password PasswordGroup
             * oidc OpenIDConnectGroup
             * profile ProfileGroup
             * link LinkGroup
             * code CodeGroup
             * totp TOTPGroup
             * lookup_secret LookupGroup
             * webauthn WebAuthnGroup
             * @enum {string}
             */
            group: "default" | "password" | "oidc" | "profile" | "link" | "code" | "totp" | "lookup_secret" | "webauthn"
            messages: components["schemas"]["uiTexts"]
            meta: components["schemas"]["uiNodeMeta"]
            attributes: components["schemas"]["uiNodeInputAttributes"]
            type: "input"
        }
        /** @description InputAttributes represents the attributes of an input node */
        uiNodeInputAttributes: {
            /**
             * @description The autocomplete attribute for the input.
             * email InputAttributeAutocompleteEmail
             * tel InputAttributeAutocompleteTel
             * url InputAttributeAutocompleteUrl
             * current-password InputAttributeAutocompleteCurrentPassword
             * new-password InputAttributeAutocompleteNewPassword
             * one-time-code InputAttributeAutocompleteOneTimeCode
             * @enum {string}
             */
            autocomplete?: "email" | "tel" | "url" | "current-password" | "new-password" | "one-time-code"
            /** @description Sets the input's disabled field to true or false. */
            disabled: boolean
            label?: components["schemas"]["uiText"]
            /** @description The input's element name. */
            name: string
            /**
             * @description NodeType represents this node's types. It is a mirror of `node.type` and
             * is primarily used to allow compatibility with OpenAPI 3.0.  In this struct it technically always is "input".
             */
            node_type: string
            /**
             * @description OnClick may contain javascript which should be executed on click. This is primarily
             * used for WebAuthn.
             */
            onclick?: string
            /** @description The input's pattern. */
            pattern?: string
            /** @description Mark this input field as required. */
            required?: boolean
            /**
             * @description The input's element type.
             * text InputAttributeTypeText
             * password InputAttributeTypePassword
             * number InputAttributeTypeNumber
             * checkbox InputAttributeTypeCheckbox
             * hidden InputAttributeTypeHidden
             * email InputAttributeTypeEmail
             * tel InputAttributeTypeTel
             * submit InputAttributeTypeSubmit
             * button InputAttributeTypeButton
             * datetime-local InputAttributeTypeDateTimeLocal
             * date InputAttributeTypeDate
             * url InputAttributeTypeURI
             * @enum {string}
             */
            type:
                | "text"
                | "password"
                | "number"
                | "checkbox"
                | "hidden"
                | "email"
                | "tel"
                | "submit"
                | "button"
                | "datetime-local"
                | "date"
                | "url"
            /** @description The input's value. */
            value?: string
        }
        /**
         * A Node's Meta Information
         * @description This might include a label and other information that can optionally
         * be used to render UIs.
         */
        uiNodeMeta: {
            label?: components["schemas"]["uiText"]
        }
        /** Script represents a script node. */
        uiNodeScript: {
            /**
             * @description Group specifies which group (e.g. password authenticator) this node belongs to.
             * default DefaultGroup
             * password PasswordGroup
             * oidc OpenIDConnectGroup
             * profile ProfileGroup
             * link LinkGroup
             * code CodeGroup
             * totp TOTPGroup
             * lookup_secret LookupGroup
             * webauthn WebAuthnGroup
             * @enum {string}
             */
            group: "default" | "password" | "oidc" | "profile" | "link" | "code" | "totp" | "lookup_secret" | "webauthn"
            messages: components["schemas"]["uiTexts"]
            meta: components["schemas"]["uiNodeMeta"]
            attributes: components["schemas"]["uiNodeScriptAttributes"]
            type: "script"
        }
        /** ScriptAttributes represent script nodes which load javascript. */
        uiNodeScriptAttributes: {
            /** @description The script async type */
            async: boolean
            /** @description The script cross origin policy */
            crossorigin: string
            /** @description A unique identifier */
            id: string
            /** @description The script's integrity hash */
            integrity: string
            /**
             * @description NodeType represents this node's types. It is a mirror of `node.type` and
             * is primarily used to allow compatibility with OpenAPI 3.0. In this struct it technically always is "script".
             */
            node_type: string
            /**
             * @description Nonce for CSP
             *
             * A nonce you may want to use to improve your Content Security Policy.
             * You do not have to use this value but if you want to improve your CSP
             * policies you may use it. You can also choose to use your own nonce value!
             */
            nonce: string
            /** @description The script referrer policy */
            referrerpolicy: string
            /** @description The script source */
            src: string
            /** @description The script MIME type */
            type: string
        }
        /** Text represents a text node. */
        uiNodeText: {
            /**
             * @description Group specifies which group (e.g. password authenticator) this node belongs to.
             * default DefaultGroup
             * password PasswordGroup
             * oidc OpenIDConnectGroup
             * profile ProfileGroup
             * link LinkGroup
             * code CodeGroup
             * totp TOTPGroup
             * lookup_secret LookupGroup
             * webauthn WebAuthnGroup
             * @enum {string}
             */
            group: "default" | "password" | "oidc" | "profile" | "link" | "code" | "totp" | "lookup_secret" | "webauthn"
            messages: components["schemas"]["uiTexts"]
            meta: components["schemas"]["uiNodeMeta"]
            attributes: components["schemas"]["uiNodeTextAttributes"]
            type: "text"
        }
        /** TextAttributes represents the attributes of a text node. */
        uiNodeTextAttributes: {
            /** @description A unique identifier */
            id: string
            /**
             * @description NodeType represents this node's types. It is a mirror of `node.type` and
             * is primarily used to allow compatibility with OpenAPI 3.0.  In this struct it technically always is "text".
             */
            node_type: string
            text: components["schemas"]["uiText"]
        }
        uiNodes: components["schemas"]["uiNode"][]
        uiText: {
            /** @description The message's context. Useful when customizing messages. */
            context?: Record<string, never>
            id: components["schemas"]["ID"]
            /** @description The message text. Written in american english. */
            text: string
            /**
             * @description The message type.
             * info Info
             * error Error
             * success Success
             * @enum {string}
             */
            type: "info" | "error" | "success"
        }
        uiTexts: components["schemas"]["uiText"][]
        unexpectedError: string
        /** @description Update Identity Body */
        updateIdentityBody: {
            credentials?: components["schemas"]["identityWithCredentials"]
            /** @description Store metadata about the user which is only accessible through admin APIs such as `GET /admin/identities/<id>`. */
            metadata_admin?: unknown
            /**
             * @description Store metadata about the identity which the identity itself can see when calling for example the
             * session endpoint. Do not store sensitive information (e.g. credit score) about the identity in this field.
             */
            metadata_public?: unknown
            /**
             * @description SchemaID is the ID of the JSON Schema to be used for validating the identity's traits. If set
             * will update the Identity's SchemaID.
             */
            schema_id: string
            state: components["schemas"]["identityState"]
            /**
             * @description Traits represent an identity's traits. The identity is able to create, modify, and delete traits
             * in a self-service manner. The input will always be validated against the JSON Schema defined
             * in `schema_id`.
             */
            traits: Record<string, never>
        }
        updateLoginFlowBody:
            | components["schemas"]["updateLoginFlowWithPasswordMethod"]
            | components["schemas"]["updateLoginFlowWithOidcMethod"]
            | components["schemas"]["updateLoginFlowWithTotpMethod"]
            | components["schemas"]["updateLoginFlowWithWebAuthnMethod"]
            | components["schemas"]["updateLoginFlowWithLookupSecretMethod"]
        /** @description Update Login Flow with Lookup Secret Method */
        updateLoginFlowWithLookupSecretMethod: {
            /** @description Sending the anti-csrf token is only required for browser login flows. */
            csrf_token?: string
            /** @description The lookup secret. */
            lookup_secret: string
            /** @description Method should be set to "lookup_secret" when logging in using the lookup_secret strategy. */
            method: string
        }
        /** @description Update Login Flow with OpenID Connect Method */
        updateLoginFlowWithOidcMethod: {
            /** @description The CSRF Token */
            csrf_token?: string
            /**
             * @description Method to use
             *
             * This field must be set to `oidc` when using the oidc method.
             */
            method: string
            /** @description The provider to register with */
            provider: string
            /** @description The identity traits. This is a placeholder for the registration flow. */
            traits?: Record<string, never>
            /**
             * @description UpstreamParameters are the parameters that are passed to the upstream identity provider.
             *
             * These parameters are optional and depend on what the upstream identity provider supports.
             * Supported parameters are:
             * `login_hint` (string): The `login_hint` parameter suppresses the account chooser and either pre-fills the email box on the sign-in form, or selects the proper session.
             * `hd` (string): The `hd` parameter limits the login/registration process to a Google Organization, e.g. `mycollege.edu`.
             * `prompt` (string): The `prompt` specifies whether the Authorization Server prompts the End-User for reauthentication and consent, e.g. `select_account`.
             */
            upstream_parameters?: Record<string, never>
        }
        /** @description Update Login Flow with Password Method */
        updateLoginFlowWithPasswordMethod: {
            /** @description Sending the anti-csrf token is only required for browser login flows. */
            csrf_token?: string
            /** @description Identifier is the email or username of the user trying to log in. */
            identifier: string
            /** @description Method should be set to "password" when logging in using the identifier and password strategy. */
            method: string
            /** @description The user's password. */
            password: string
            /**
             * @description Identifier is the email or username of the user trying to log in.
             * This field is deprecated!
             */
            password_identifier?: string
        }
        /** @description Update Login Flow with TOTP Method */
        updateLoginFlowWithTotpMethod: {
            /** @description Sending the anti-csrf token is only required for browser login flows. */
            csrf_token?: string
            /** @description Method should be set to "totp" when logging in using the TOTP strategy. */
            method: string
            /** @description The TOTP code. */
            totp_code: string
        }
        /** @description Update Login Flow with WebAuthn Method */
        updateLoginFlowWithWebAuthnMethod: {
            /** @description Sending the anti-csrf token is only required for browser login flows. */
            csrf_token?: string
            /** @description Identifier is the email or username of the user trying to log in. */
            identifier: string
            /** @description Method should be set to "webAuthn" when logging in using the WebAuthn strategy. */
            method: string
            /**
             * @description Login a WebAuthn Security Key
             *
             * This must contain the ID of the WebAuthN connection.
             */
            webauthn_login?: string
        }
        /** @description Update Recovery Flow Request Body */
        updateRecoveryFlowBody:
            | components["schemas"]["updateRecoveryFlowWithLinkMethod"]
            | components["schemas"]["updateRecoveryFlowWithCodeMethod"]
        /** @description Update Recovery Flow with Code Method */
        updateRecoveryFlowWithCodeMethod: {
            /**
             * @description Code from the recovery email
             *
             * If you want to submit a code, use this field, but make sure to _not_ include the email field, as well.
             */
            code?: string
            /** @description Sending the anti-csrf token is only required for browser login flows. */
            csrf_token?: string
            /**
             * @description The email address of the account to recover
             *
             * If the email belongs to a valid account, a recovery email will be sent.
             *
             * If you want to notify the email address if the account does not exist, see
             * the [notify_unknown_recipients flag](https://www.ory.sh/docs/kratos/self-service/flows/account-recovery-password-reset#attempted-recovery-notifications)
             *
             * If a code was already sent, including this field in the payload will invalidate the sent code and re-send a new code.
             *
             * format: email
             */
            email?: string
            /**
             * @description Method is the method that should be used for this recovery flow
             *
             * Allowed values are `link` and `code`.
             * link RecoveryStrategyLink
             * code RecoveryStrategyCode
             * @enum {string}
             */
            method: "link" | "code"
        }
        /** @description Update Recovery Flow with Link Method */
        updateRecoveryFlowWithLinkMethod: {
            /** @description Sending the anti-csrf token is only required for browser login flows. */
            csrf_token?: string
            /**
             * @description Email to Recover
             *
             * Needs to be set when initiating the flow. If the email is a registered
             * recovery email, a recovery link will be sent. If the email is not known,
             * a email with details on what happened will be sent instead.
             *
             * format: email
             */
            email: string
            /**
             * @description Method is the method that should be used for this recovery flow
             *
             * Allowed values are `link` and `code`
             * link RecoveryStrategyLink
             * code RecoveryStrategyCode
             * @enum {string}
             */
            method: "link" | "code"
        }
        /** @description Update Registration Request Body */
        updateRegistrationFlowBody:
            | components["schemas"]["updateRegistrationFlowWithPasswordMethod"]
            | components["schemas"]["updateRegistrationFlowWithOidcMethod"]
            | components["schemas"]["updateRegistrationFlowWithWebAuthnMethod"]
        /** @description Update Registration Flow with OpenID Connect Method */
        updateRegistrationFlowWithOidcMethod: {
            /** @description The CSRF Token */
            csrf_token?: string
            /**
             * @description Method to use
             *
             * This field must be set to `oidc` when using the oidc method.
             */
            method: string
            /** @description The provider to register with */
            provider: string
            /** @description The identity traits */
            traits?: Record<string, never>
            /** @description Transient data to pass along to any webhooks */
            transient_payload?: Record<string, never>
            /**
             * @description UpstreamParameters are the parameters that are passed to the upstream identity provider.
             *
             * These parameters are optional and depend on what the upstream identity provider supports.
             * Supported parameters are:
             * `login_hint` (string): The `login_hint` parameter suppresses the account chooser and either pre-fills the email box on the sign-in form, or selects the proper session.
             * `hd` (string): The `hd` parameter limits the login/registration process to a Google Organization, e.g. `mycollege.edu`.
             * `prompt` (string): The `prompt` specifies whether the Authorization Server prompts the End-User for reauthentication and consent, e.g. `select_account`.
             */
            upstream_parameters?: Record<string, never>
        }
        /** @description Update Registration Flow with Password Method */
        updateRegistrationFlowWithPasswordMethod: {
            /** @description The CSRF Token */
            csrf_token?: string
            /**
             * @description Method to use
             *
             * This field must be set to `password` when using the password method.
             */
            method: string
            /** @description Password to sign the user up with */
            password: string
            /** @description The identity's traits */
            traits: Record<string, never>
            /** @description Transient data to pass along to any webhooks */
            transient_payload?: Record<string, never>
        }
        /** @description Update Registration Flow with WebAuthn Method */
        updateRegistrationFlowWithWebAuthnMethod: {
            /** @description CSRFToken is the anti-CSRF token */
            csrf_token?: string
            /**
             * @description Method
             *
             * Should be set to "webauthn" when trying to add, update, or remove a webAuthn pairing.
             */
            method: string
            /** @description The identity's traits */
            traits: Record<string, never>
            /** @description Transient data to pass along to any webhooks */
            transient_payload?: Record<string, never>
            /**
             * @description Register a WebAuthn Security Key
             *
             * It is expected that the JSON returned by the WebAuthn registration process
             * is included here.
             */
            webauthn_register?: string
            /**
             * @description Name of the WebAuthn Security Key to be Added
             *
             * A human-readable name for the security key which will be added.
             */
            webauthn_register_displayname?: string
        }
        /** @description Update Settings Flow Request Body */
        updateSettingsFlowBody:
            | components["schemas"]["updateSettingsFlowWithPasswordMethod"]
            | components["schemas"]["updateSettingsFlowWithProfileMethod"]
            | components["schemas"]["updateSettingsFlowWithOidcMethod"]
            | components["schemas"]["updateSettingsFlowWithTotpMethod"]
            | components["schemas"]["updateSettingsFlowWithWebAuthnMethod"]
            | components["schemas"]["updateSettingsFlowWithLookupMethod"]
        /** @description Update Settings Flow with Lookup Method */
        updateSettingsFlowWithLookupMethod: {
            /** @description CSRFToken is the anti-CSRF token */
            csrf_token?: string
            /** @description If set to true will save the regenerated lookup secrets */
            lookup_secret_confirm?: boolean
            /** @description Disables this method if true. */
            lookup_secret_disable?: boolean
            /** @description If set to true will regenerate the lookup secrets */
            lookup_secret_regenerate?: boolean
            /** @description If set to true will reveal the lookup secrets */
            lookup_secret_reveal?: boolean
            /**
             * @description Method
             *
             * Should be set to "lookup" when trying to add, update, or remove a lookup pairing.
             */
            method: string
        }
        /** @description Update Settings Flow with OpenID Connect Method */
        updateSettingsFlowWithOidcMethod: {
            /**
             * @description Flow ID is the flow's ID.
             *
             * in: query
             */
            flow?: string
            /**
             * @description Link this provider
             *
             * Either this or `unlink` must be set.
             *
             * type: string
             * in: body
             */
            link?: string
            /**
             * @description Method
             *
             * Should be set to profile when trying to update a profile.
             */
            method: string
            /**
             * @description The identity's traits
             *
             * in: body
             */
            traits?: Record<string, never>
            /**
             * @description Unlink this provider
             *
             * Either this or `link` must be set.
             *
             * type: string
             * in: body
             */
            unlink?: string
            /**
             * @description UpstreamParameters are the parameters that are passed to the upstream identity provider.
             *
             * These parameters are optional and depend on what the upstream identity provider supports.
             * Supported parameters are:
             * `login_hint` (string): The `login_hint` parameter suppresses the account chooser and either pre-fills the email box on the sign-in form, or selects the proper session.
             * `hd` (string): The `hd` parameter limits the login/registration process to a Google Organization, e.g. `mycollege.edu`.
             * `prompt` (string): The `prompt` specifies whether the Authorization Server prompts the End-User for reauthentication and consent, e.g. `select_account`.
             */
            upstream_parameters?: Record<string, never>
        }
        /** @description Update Settings Flow with Password Method */
        updateSettingsFlowWithPasswordMethod: {
            /** @description CSRFToken is the anti-CSRF token */
            csrf_token?: string
            /**
             * @description Method
             *
             * Should be set to password when trying to update a password.
             */
            method: string
            /** @description Password is the updated password */
            password: string
        }
        /** @description Update Settings Flow with Profile Method */
        updateSettingsFlowWithProfileMethod: {
            /**
             * @description The Anti-CSRF Token
             *
             * This token is only required when performing browser flows.
             */
            csrf_token?: string
            /**
             * @description Method
             *
             * Should be set to profile when trying to update a profile.
             */
            method: string
            /**
             * @description Traits
             *
             * The identity's traits.
             */
            traits: Record<string, never>
        }
        /** @description Update Settings Flow with TOTP Method */
        updateSettingsFlowWithTotpMethod: {
            /** @description CSRFToken is the anti-CSRF token */
            csrf_token?: string
            /**
             * @description Method
             *
             * Should be set to "totp" when trying to add, update, or remove a totp pairing.
             */
            method: string
            /** @description ValidationTOTP must contain a valid TOTP based on the */
            totp_code?: string
            /**
             * @description UnlinkTOTP if true will remove the TOTP pairing,
             * effectively removing the credential. This can be used
             * to set up a new TOTP device.
             */
            totp_unlink?: boolean
        }
        /** @description Update Settings Flow with WebAuthn Method */
        updateSettingsFlowWithWebAuthnMethod: {
            /** @description CSRFToken is the anti-CSRF token */
            csrf_token?: string
            /**
             * @description Method
             *
             * Should be set to "webauthn" when trying to add, update, or remove a webAuthn pairing.
             */
            method: string
            /**
             * @description Register a WebAuthn Security Key
             *
             * It is expected that the JSON returned by the WebAuthn registration process
             * is included here.
             */
            webauthn_register?: string
            /**
             * @description Name of the WebAuthn Security Key to be Added
             *
             * A human-readable name for the security key which will be added.
             */
            webauthn_register_displayname?: string
            /**
             * @description Remove a WebAuthn Security Key
             *
             * This must contain the ID of the WebAuthN connection.
             */
            webauthn_remove?: string
        }
        /** @description Update Verification Flow Request Body */
        updateVerificationFlowBody:
            | components["schemas"]["updateVerificationFlowWithLinkMethod"]
            | components["schemas"]["updateVerificationFlowWithCodeMethod"]
        updateVerificationFlowWithCodeMethod: {
            /**
             * @description Code from the recovery email
             *
             * If you want to submit a code, use this field, but make sure to _not_ include the email field, as well.
             */
            code?: string
            /** @description Sending the anti-csrf token is only required for browser login flows. */
            csrf_token?: string
            /**
             * @description The email address to verify
             *
             * If the email belongs to a valid account, a verifiation email will be sent.
             *
             * If you want to notify the email address if the account does not exist, see
             * the [notify_unknown_recipients flag](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation#attempted-verification-notifications)
             *
             * If a code was already sent, including this field in the payload will invalidate the sent code and re-send a new code.
             *
             * format: email
             */
            email?: string
            /**
             * @description Method is the method that should be used for this verification flow
             *
             * Allowed values are `link` and `code`.
             * link VerificationStrategyLink
             * code VerificationStrategyCode
             * @enum {string}
             */
            method: "link" | "code"
        }
        /** @description Update Verification Flow with Link Method */
        updateVerificationFlowWithLinkMethod: {
            /** @description Sending the anti-csrf token is only required for browser login flows. */
            csrf_token?: string
            /**
             * @description Email to Verify
             *
             * Needs to be set when initiating the flow. If the email is a registered
             * verification email, a verification link will be sent. If the email is not known,
             * a email with details on what happened will be sent instead.
             *
             * format: email
             */
            email: string
            /**
             * @description Method is the method that should be used for this verification flow
             *
             * Allowed values are `link` and `code`
             * link VerificationStrategyLink
             * code VerificationStrategyCode
             * @enum {string}
             */
            method: "link" | "code"
        }
        /** @description VerifiableAddress is an identity's verifiable address */
        verifiableIdentityAddress: {
            /**
             * Format: date-time
             * @description When this entry was created
             * @example 2014-01-01T23:28:56.782Z
             */
            created_at?: string
            /**
             * Format: uuid
             * @description The ID
             */
            id?: string
            status: components["schemas"]["identityVerifiableAddressStatus"]
            /**
             * Format: date-time
             * @description When this entry was last updated
             * @example 2014-01-01T23:28:56.782Z
             */
            updated_at?: string
            /**
             * @description The address value
             *
             * example foo@user.com
             */
            value: string
            /**
             * @description Indicates if the address has already been verified
             * @example true
             */
            verified: boolean
            verified_at?: components["schemas"]["nullTime"]
            via: components["schemas"]["identityVerifiableAddressType"]
        }
        /**
         * A Verification Flow
         * @description Used to verify an out-of-band communication
         * channel such as an email address or a phone number.
         *
         * For more information head over to: https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation
         */
        verificationFlow: {
            /**
             * @description Active, if set, contains the registration method that is being used. It is initially
             * not set.
             */
            active?: string
            /**
             * Format: date-time
             * @description ExpiresAt is the time (UTC) when the request expires. If the user still wishes to verify the address,
             * a new request has to be initiated.
             */
            expires_at?: string
            /**
             * Format: uuid
             * @description ID represents the request's unique ID. When performing the verification flow, this
             * represents the id in the verify ui's query parameter: http://<selfservice.flows.verification.ui_url>?request=<id>
             *
             * type: string
             * format: uuid
             */
            id: string
            /**
             * Format: date-time
             * @description IssuedAt is the time (UTC) when the request occurred.
             */
            issued_at?: string
            /**
             * @description RequestURL is the initial URL that was requested from Ory Kratos. It can be used
             * to forward information contained in the URL's path or query for example.
             */
            request_url?: string
            /** @description ReturnTo contains the requested return_to URL. */
            return_to?: string
            state: components["schemas"]["verificationFlowState"]
            type: components["schemas"]["selfServiceFlowType"]
            ui: components["schemas"]["uiContainer"]
        }
        /**
         * Verification Flow State
         * @description The state represents the state of the verification flow.
         *
         * choose_method: ask the user to choose a method (e.g. recover account via email)
         * sent_email: the email has been sent to the user
         * passed_challenge: the request was successful and the recovery challenge was passed.
         * @enum {string}
         */
        verificationFlowState: "choose_method" | "sent_email" | "passed_challenge"
        version: {
            /** @description Version is the service's version. */
            version?: string
        }
        webAuthnJavaScript: string
    }
    responses: {
        /** @description Empty responses are sent when, for example, resources are deleted. The HTTP status code for empty responses is typically 201. */
        emptyResponse: {
            content: never
        }
        /** @description List Identity JSON Schemas Response */
        identitySchemas: {
            content: {
                "application/json": components["schemas"]["identitySchemas"]
            }
        }
        /** @description Paginated Courier Message List Response */
        listCourierMessages: {
            content: {
                "application/json": components["schemas"]["message"][]
            }
        }
        /** @description Paginated Identity List Response */
        listIdentities: {
            content: {
                "application/json": components["schemas"]["identity"][]
            }
        }
        /** @description List Identity Sessions Response */
        listIdentitySessions: {
            content: {
                "application/json": components["schemas"]["session"][]
            }
        }
        /** @description List My Session Response */
        listMySessions: {
            content: {
                "application/json": components["schemas"]["session"][]
            }
        }
        /**
         * @description Session List Response
         *
         * The response given when listing sessions in an administrative context.
         */
        listSessions: {
            content: {
                "application/json": components["schemas"]["session"][]
            }
        }
    }
    parameters: never
    requestBodies: never
    headers: never
    pathItems: never
}

export type $defs = Record<string, never>

export type external = Record<string, never>

export interface operations {
    /**
     * Get WebAuthn JavaScript
     * @description This endpoint provides JavaScript which is needed in order to perform WebAuthn login and registration.
     *
     * If you are building a JavaScript Browser App (e.g. in ReactJS or AngularJS) you will need to load this file:
     *
     * ```html
     * <script src="https://public-kratos.example.org/.well-known/ory/webauthn.js" type="script" async />
     * ```
     *
     * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
     */
    getWebAuthnJavaScript: {
        responses: {
            /** @description webAuthnJavaScript */
            200: {
                content: {
                    "application/json": components["schemas"]["webAuthnJavaScript"]
                }
            }
        }
    }
    /**
     * List Messages
     * @description Lists all messages by given status and recipient.
     */
    listCourierMessages: {
        parameters: {
            query?: {
                /**
                 * @description Items per Page
                 *
                 * This is the number of items per page to return.
                 * For details on pagination please head over to the [pagination documentation](https://www.ory.sh/docs/ecosystem/api-design#pagination).
                 */
                page_size?: number
                /**
                 * @description Next Page Token
                 *
                 * The next page token.
                 * For details on pagination please head over to the [pagination documentation](https://www.ory.sh/docs/ecosystem/api-design#pagination).
                 */
                page_token?: string
                /**
                 * @description Status filters out messages based on status.
                 * If no value is provided, it doesn't take effect on filter.
                 */
                status?: components["schemas"]["courierMessageStatus"]
                /**
                 * @description Recipient filters out messages based on recipient.
                 * If no value is provided, it doesn't take effect on filter.
                 */
                recipient?: string
            }
        }
        responses: {
            200: components["responses"]["listCourierMessages"]
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Get a Message
     * @description Gets a specific messages by the given ID.
     */
    getCourierMessage: {
        parameters: {
            path: {
                /** @description MessageID is the ID of the message. */
                id: string
            }
        }
        responses: {
            /** @description message */
            200: {
                content: {
                    "application/json": components["schemas"]["message"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * List Identities
     * @description Lists all [identities](https://www.ory.sh/docs/kratos/concepts/identity-user-model) in the system.
     */
    listIdentities: {
        parameters: {
            query?: {
                /**
                 * @description Items per Page
                 *
                 * This is the number of items per page.
                 */
                per_page?: number
                /**
                 * @description Pagination Page
                 *
                 * This value is currently an integer, but it is not sequential. The value is not the page number, but a
                 * reference. The next page can be any number and some numbers might return an empty list.
                 *
                 * For example, page 2 might not follow after page 1. And even if page 3 and 5 exist, but page 4 might not exist.
                 */
                page?: number
                /** @description CredentialsIdentifier is the identifier (username, email) of the credentials to look up. */
                credentials_identifier?: string
            }
        }
        responses: {
            200: components["responses"]["listIdentities"]
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create an Identity
     * @description Create an [identity](https://www.ory.sh/docs/kratos/concepts/identity-user-model).  This endpoint can also be used to
     * [import credentials](https://www.ory.sh/docs/kratos/manage-identities/import-user-accounts-identities)
     * for instance passwords, social sign in configurations or multifactor methods.
     */
    createIdentity: {
        requestBody?: {
            content: {
                "application/json": components["schemas"]["createIdentityBody"]
            }
        }
        responses: {
            /** @description identity */
            201: {
                content: {
                    "application/json": components["schemas"]["identity"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            409: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create and deletes multiple identities
     * @description Creates or delete multiple
     * [identities](https://www.ory.sh/docs/kratos/concepts/identity-user-model).
     * This endpoint can also be used to [import
     * credentials](https://www.ory.sh/docs/kratos/manage-identities/import-user-accounts-identities)
     * for instance passwords, social sign in configurations or multifactor methods.
     */
    batchPatchIdentities: {
        requestBody?: {
            content: {
                "application/json": components["schemas"]["patchIdentitiesBody"]
            }
        }
        responses: {
            /** @description batchPatchIdentitiesResponse */
            200: {
                content: {
                    "application/json": components["schemas"]["batchPatchIdentitiesResponse"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            409: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Get an Identity
     * @description Return an [identity](https://www.ory.sh/docs/kratos/concepts/identity-user-model) by its ID. You can optionally
     * include credentials (e.g. social sign in connections) in the response by using the `include_credential` query parameter.
     */
    getIdentity: {
        parameters: {
            query?: {
                /**
                 * @description Include Credentials in Response
                 *
                 * Include any credential, for example `password` or `oidc`, in the response. When set to `oidc`, This will return
                 * the initial OAuth 2.0 Access Token, OAuth 2.0 Refresh Token and the OpenID Connect ID Token if available.
                 */
                include_credential?: ("password" | "totp" | "oidc" | "webauthn" | "lookup_secret")[]
            }
            path: {
                /** @description ID must be set to the ID of identity you want to get */
                id: string
            }
        }
        responses: {
            /** @description identity */
            200: {
                content: {
                    "application/json": components["schemas"]["identity"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Update an Identity
     * @description This endpoint updates an [identity](https://www.ory.sh/docs/kratos/concepts/identity-user-model). The full identity
     * payload (except credentials) is expected. It is possible to update the identity's credentials as well.
     */
    updateIdentity: {
        parameters: {
            path: {
                /** @description ID must be set to the ID of identity you want to update */
                id: string
            }
        }
        requestBody?: {
            content: {
                "application/json": components["schemas"]["updateIdentityBody"]
            }
        }
        responses: {
            /** @description identity */
            200: {
                content: {
                    "application/json": components["schemas"]["identity"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            409: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Delete an Identity
     * @description Calling this endpoint irrecoverably and permanently deletes the [identity](https://www.ory.sh/docs/kratos/concepts/identity-user-model) given its ID. This action can not be undone.
     * This endpoint returns 204 when the identity was deleted or when the identity was not found, in which case it is
     * assumed that is has been deleted already.
     */
    deleteIdentity: {
        parameters: {
            path: {
                /** @description ID is the identity's ID. */
                id: string
            }
        }
        responses: {
            204: components["responses"]["emptyResponse"]
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Patch an Identity
     * @description Partially updates an [identity's](https://www.ory.sh/docs/kratos/concepts/identity-user-model) field using [JSON Patch](https://jsonpatch.com/).
     * The fields `id`, `stateChangedAt` and `credentials` can not be updated using this method.
     */
    patchIdentity: {
        parameters: {
            path: {
                /** @description ID must be set to the ID of identity you want to update */
                id: string
            }
        }
        requestBody?: {
            content: {
                "application/json": components["schemas"]["jsonPatchDocument"]
            }
        }
        responses: {
            /** @description identity */
            200: {
                content: {
                    "application/json": components["schemas"]["identity"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            409: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Delete a credential for a specific identity
     * @description Delete an [identity](https://www.ory.sh/docs/kratos/concepts/identity-user-model) credential by its type
     * You can only delete second factor (aal2) credentials.
     */
    deleteIdentityCredentials: {
        parameters: {
            path: {
                /** @description ID is the identity's ID. */
                id: string
                /**
                 * @description Type is the credential's Type.
                 * One of totp, webauthn, lookup
                 */
                type: "totp" | "webauthn" | "lookup"
            }
        }
        responses: {
            204: components["responses"]["emptyResponse"]
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * List an Identity's Sessions
     * @description This endpoint returns all sessions that belong to the given Identity.
     */
    listIdentitySessions: {
        parameters: {
            query?: {
                /**
                 * @description Items per Page
                 *
                 * This is the number of items per page.
                 */
                per_page?: number
                /**
                 * @description Pagination Page
                 *
                 * This value is currently an integer, but it is not sequential. The value is not the page number, but a
                 * reference. The next page can be any number and some numbers might return an empty list.
                 *
                 * For example, page 2 might not follow after page 1. And even if page 3 and 5 exist, but page 4 might not exist.
                 */
                page?: number
                /** @description Active is a boolean flag that filters out sessions based on the state. If no value is provided, all sessions are returned. */
                active?: boolean
            }
            path: {
                /** @description ID is the identity's ID. */
                id: string
            }
        }
        responses: {
            200: components["responses"]["listIdentitySessions"]
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Delete & Invalidate an Identity's Sessions
     * @description Calling this endpoint irrecoverably and permanently deletes and invalidates all sessions that belong to the given Identity.
     */
    deleteIdentitySessions: {
        parameters: {
            path: {
                /** @description ID is the identity's ID. */
                id: string
            }
        }
        responses: {
            204: components["responses"]["emptyResponse"]
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            401: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create a Recovery Code
     * @description This endpoint creates a recovery code which should be given to the user in order for them to recover
     * (or activate) their account.
     */
    createRecoveryCodeForIdentity: {
        requestBody?: {
            content: {
                "application/json": components["schemas"]["createRecoveryCodeForIdentityBody"]
            }
        }
        responses: {
            /** @description recoveryCodeForIdentity */
            201: {
                content: {
                    "application/json": components["schemas"]["recoveryCodeForIdentity"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create a Recovery Link
     * @description This endpoint creates a recovery link which should be given to the user in order for them to recover
     * (or activate) their account.
     */
    createRecoveryLinkForIdentity: {
        requestBody?: {
            content: {
                "application/json": components["schemas"]["createRecoveryLinkForIdentityBody"]
            }
        }
        responses: {
            /** @description recoveryLinkForIdentity */
            200: {
                content: {
                    "application/json": components["schemas"]["recoveryLinkForIdentity"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * List All Sessions
     * @description Listing all sessions that exist.
     */
    listSessions: {
        parameters: {
            query?: {
                /**
                 * @description Items per Page
                 *
                 * This is the number of items per page to return.
                 * For details on pagination please head over to the [pagination documentation](https://www.ory.sh/docs/ecosystem/api-design#pagination).
                 */
                page_size?: number
                /**
                 * @description Next Page Token
                 *
                 * The next page token.
                 * For details on pagination please head over to the [pagination documentation](https://www.ory.sh/docs/ecosystem/api-design#pagination).
                 */
                page_token?: string
                /** @description Active is a boolean flag that filters out sessions based on the state. If no value is provided, all sessions are returned. */
                active?: boolean
                /**
                 * @description ExpandOptions is a query parameter encoded list of all properties that must be expanded in the Session.
                 * If no value is provided, the expandable properties are skipped.
                 */
                expand?: identity | devices
            }
        }
        responses: {
            200: components["responses"]["listSessions"]
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Get Session
     * @description This endpoint is useful for:
     *
     * Getting a session object with all specified expandables that exist in an administrative context.
     */
    getSession: {
        parameters: {
            query?: {
                /**
                 * @description ExpandOptions is a query parameter encoded list of all properties that must be expanded in the Session.
                 * Example - ?expand=Identity&expand=Devices
                 * If no value is provided, the expandable properties are skipped.
                 */
                expand?: identity | devices
            }
            path: {
                /** @description ID is the session's ID. */
                id: string
            }
        }
        responses: {
            /** @description session */
            200: {
                content: {
                    "application/json": components["schemas"]["session"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Deactivate a Session
     * @description Calling this endpoint deactivates the specified session. Session data is not deleted.
     */
    disableSession: {
        parameters: {
            path: {
                /** @description ID is the session's ID. */
                id: string
            }
        }
        responses: {
            204: components["responses"]["emptyResponse"]
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            401: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Extend a Session
     * @description Calling this endpoint extends the given session ID. If `session.earliest_possible_extend` is set it
     * will only extend the session after the specified time has passed.
     *
     * Retrieve the session ID from the `/sessions/whoami` endpoint / `toSession` SDK method.
     */
    extendSession: {
        parameters: {
            path: {
                /** @description ID is the session's ID. */
                id: string
            }
        }
        responses: {
            /** @description session */
            200: {
                content: {
                    "application/json": components["schemas"]["session"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Check HTTP Server Status
     * @description This endpoint returns a HTTP 200 status code when Ory Kratos is accepting incoming
     * HTTP requests. This status does currently not include checks whether the database connection is working.
     *
     * If the service supports TLS Edge Termination, this endpoint does not require the
     * `X-Forwarded-Proto` header to be set.
     *
     * Be aware that if you are running multiple nodes of this service, the health status will never
     * refer to the cluster state, only to a single instance.
     */
    isAlive: {
        responses: {
            /** @description Ory Kratos is ready to accept connections. */
            200: {
                content: {
                    "application/json": {
                        /** @description Always "ok". */
                        status: string
                    }
                }
            }
            /** @description Unexpected error */
            default: {
                content: {
                    "text/plain": string
                }
            }
        }
    }
    /**
     * Check HTTP Server and Database Status
     * @description This endpoint returns a HTTP 200 status code when Ory Kratos is up running and the environment dependencies (e.g.
     * the database) are responsive as well.
     *
     * If the service supports TLS Edge Termination, this endpoint does not require the
     * `X-Forwarded-Proto` header to be set.
     *
     * Be aware that if you are running multiple nodes of Ory Kratos, the health status will never
     * refer to the cluster state, only to a single instance.
     */
    isReady: {
        responses: {
            /** @description Ory Kratos is ready to accept requests. */
            200: {
                content: {
                    "application/json": {
                        /** @description Always "ok". */
                        status: string
                    }
                }
            }
            /** @description Ory Kratos is not yet ready to accept requests. */
            503: {
                content: {
                    "application/json": {
                        /** @description Errors contains a list of errors that caused the not ready status. */
                        errors: {
                            [key: string]: string
                        }
                    }
                }
            }
            /** @description Unexpected error */
            default: {
                content: {
                    "text/plain": string
                }
            }
        }
    }
    /**
     * Get all Identity Schemas
     * @description Returns a list of all identity schemas currently in use.
     */
    listIdentitySchemas: {
        parameters: {
            query?: {
                /**
                 * @description Items per Page
                 *
                 * This is the number of items per page.
                 */
                per_page?: number
                /**
                 * @description Pagination Page
                 *
                 * This value is currently an integer, but it is not sequential. The value is not the page number, but a
                 * reference. The next page can be any number and some numbers might return an empty list.
                 *
                 * For example, page 2 might not follow after page 1. And even if page 3 and 5 exist, but page 4 might not exist.
                 */
                page?: number
            }
        }
        responses: {
            200: components["responses"]["identitySchemas"]
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Get Identity JSON Schema
     * @description Return a specific identity schema.
     */
    getIdentitySchema: {
        parameters: {
            path: {
                /** @description ID must be set to the ID of schema you want to get */
                id: string
            }
        }
        responses: {
            /** @description identitySchema */
            200: {
                content: {
                    "application/json": components["schemas"]["identitySchema"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Get User-Flow Errors
     * @description This endpoint returns the error associated with a user-facing self service errors.
     *
     * This endpoint supports stub values to help you implement the error UI:
     *
     * `?id=stub:500` - returns a stub 500 (Internal Server Error) error.
     *
     * More information can be found at [Ory Kratos User User Facing Error Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-facing-errors).
     */
    getFlowError: {
        parameters: {
            query: {
                /** @description Error is the error's ID */
                id: string
            }
        }
        responses: {
            /** @description flowError */
            200: {
                content: {
                    "application/json": components["schemas"]["flowError"]
                }
            }
            /** @description errorGeneric */
            403: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            500: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Submit a Login Flow
     * @description :::info
     *
     * This endpoint is EXPERIMENTAL and subject to potential breaking changes in the future.
     *
     * :::
     *
     * Use this endpoint to complete a login flow. This endpoint
     * behaves differently for API and browser flows.
     *
     * API flows expect `application/json` to be sent in the body and responds with
     * HTTP 200 and a application/json body with the session token on success;
     * HTTP 410 if the original flow expired with the appropriate error messages set and optionally a `use_flow_id` parameter in the body;
     * HTTP 400 on form validation errors.
     *
     * Browser flows expect a Content-Type of `application/x-www-form-urlencoded` or `application/json` to be sent in the body and respond with
     * a HTTP 303 redirect to the post/after login URL or the `return_to` value if it was set and if the login succeeded;
     * a HTTP 303 redirect to the login UI URL with the flow ID containing the validation errors otherwise.
     *
     * Browser flows with an accept header of `application/json` will not redirect but instead respond with
     * HTTP 200 and a application/json body with the signed in identity and a `Set-Cookie` header on success;
     * HTTP 303 redirect to a fresh login flow if the original flow expired with the appropriate error messages set;
     * HTTP 400 on form validation errors.
     *
     * If this endpoint is called with `Accept: application/json` in the header, the response contains the flow without a redirect. In the
     * case of an error, the `error.id` of the JSON response body can be one of:
     *
     * `session_already_available`: The user is already signed in.
     * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
     * `security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
     * `browser_location_change_required`: Usually sent when an AJAX request indicates that the browser needs to open a specific URL.
     * Most likely used in Social Sign In flows.
     *
     * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
     */
    updateLoginFlow: {
        parameters: {
            query: {
                /**
                 * @description The Login Flow ID
                 *
                 * The value for this parameter comes from `flow` URL Query parameter sent to your
                 * application (e.g. `/login?flow=abcde`).
                 */
                flow: string
            }
            header?: {
                /** @description The Session Token of the Identity performing the settings flow. */
                "X-Session-Token"?: string
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK in a browser app, on the server side you must include the HTTP Cookie Header
                 * sent by the client to your server here. This ensures that CSRF and session cookies are respected.
                 */
                Cookie?: string
            }
        }
        requestBody: {
            content: {
                "application/json": components["schemas"]["updateLoginFlowBody"]
                "application/x-www-form-urlencoded": components["schemas"]["updateLoginFlowBody"]
            }
        }
        responses: {
            /** @description successfulNativeLogin */
            200: {
                content: {
                    "application/json": components["schemas"]["successfulNativeLogin"]
                }
            }
            303: components["responses"]["emptyResponse"]
            /** @description loginFlow */
            400: {
                content: {
                    "application/json": components["schemas"]["loginFlow"]
                }
            }
            /** @description errorGeneric */
            410: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorBrowserLocationChangeRequired */
            422: {
                content: {
                    "application/json": components["schemas"]["errorBrowserLocationChangeRequired"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create Login Flow for Native Apps
     * @description This endpoint initiates a login flow for native apps that do not use a browser, such as mobile devices, smart TVs, and so on.
     *
     * If a valid provided session cookie or session token is provided, a 400 Bad Request error
     * will be returned unless the URL query parameter `?refresh=true` is set.
     *
     * To fetch an existing login flow call `/self-service/login/flows?flow=<flow_id>`.
     *
     * You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
     * Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
     * you vulnerable to a variety of CSRF attacks, including CSRF login attacks.
     *
     * In the case of an error, the `error.id` of the JSON response body can be one of:
     *
     * `session_already_available`: The user is already signed in.
     * `session_aal1_required`: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet.
     * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
     *
     * This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).
     *
     * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
     */
    createNativeLoginFlow: {
        parameters: {
            query?: {
                /**
                 * @description Refresh a login session
                 *
                 * If set to true, this will refresh an existing login session by
                 * asking the user to sign in again. This will reset the
                 * authenticated_at time of the session.
                 */
                refresh?: boolean
                /**
                 * @description Request a Specific AuthenticationMethod Assurance Level
                 *
                 * Use this parameter to upgrade an existing session's authenticator assurance level (AAL). This
                 * allows you to ask for multi-factor authentication. When an identity sign in using e.g. username+password,
                 * the AAL is 1. If you wish to "upgrade" the session's security by asking the user to perform TOTP / WebAuth/ ...
                 * you would set this to "aal2".
                 */
                aal?: string
                /**
                 * @description EnableSessionTokenExchangeCode requests the login flow to include a code that can be used to retrieve the session token
                 * after the login flow has been completed.
                 */
                return_session_token_exchange_code?: boolean
                /** @description The URL to return the browser to after the flow was completed. */
                return_to?: string
            }
            header?: {
                /** @description The Session Token of the Identity performing the settings flow. */
                "X-Session-Token"?: string
            }
        }
        responses: {
            /** @description loginFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["loginFlow"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create Login Flow for Browsers
     * @description This endpoint initializes a browser-based user login flow. This endpoint will set the appropriate
     * cookies and anti-CSRF measures required for browser-based flows.
     *
     * If this endpoint is opened as a link in the browser, it will be redirected to
     * `selfservice.flows.login.ui_url` with the flow ID set as the query parameter `?flow=`. If a valid user session
     * exists already, the browser will be redirected to `urls.default_redirect_url` unless the query parameter
     * `?refresh=true` was set.
     *
     * If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
     * case of an error, the `error.id` of the JSON response body can be one of:
     *
     * `session_already_available`: The user is already signed in.
     * `session_aal1_required`: Multi-factor auth (e.g. 2fa) was requested but the user has no session yet.
     * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
     * `security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
     *
     * The optional query parameter login_challenge is set when using Kratos with
     * Hydra in an OAuth2 flow. See the oauth2_provider.url configuration
     * option.
     *
     * This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.
     *
     * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
     */
    createBrowserLoginFlow: {
        parameters: {
            query?: {
                /**
                 * @description Refresh a login session
                 *
                 * If set to true, this will refresh an existing login session by
                 * asking the user to sign in again. This will reset the
                 * authenticated_at time of the session.
                 */
                refresh?: boolean
                /**
                 * @description Request a Specific AuthenticationMethod Assurance Level
                 *
                 * Use this parameter to upgrade an existing session's authenticator assurance level (AAL). This
                 * allows you to ask for multi-factor authentication. When an identity sign in using e.g. username+password,
                 * the AAL is 1. If you wish to "upgrade" the session's security by asking the user to perform TOTP / WebAuth/ ...
                 * you would set this to "aal2".
                 */
                aal?: string
                /** @description The URL to return the browser to after the flow was completed. */
                return_to?: string
                /**
                 * @description An optional Hydra login challenge. If present, Kratos will cooperate with
                 * Ory Hydra to act as an OAuth2 identity provider.
                 *
                 * The value for this parameter comes from `login_challenge` URL Query parameter sent to your
                 * application (e.g. `/login?login_challenge=abcde`).
                 */
                login_challenge?: string
            }
            header?: {
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK in a browser app, on the server side you must include the HTTP Cookie Header
                 * sent by the client to your server here. This ensures that CSRF and session cookies are respected.
                 */
                Cookie?: string
            }
        }
        responses: {
            /** @description loginFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["loginFlow"]
                }
            }
            303: components["responses"]["emptyResponse"]
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Get Login Flow
     * @description This endpoint returns a login flow's context with, for example, error details and other information.
     *
     * Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
     * For AJAX requests you must ensure that cookies are included in the request or requests will fail.
     *
     * If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
     * and you need to forward the incoming HTTP Cookie header to this endpoint:
     *
     * ```js
     * pseudo-code example
     * router.get('/login', async function (req, res) {
     * const flow = await client.getLoginFlow(req.header('cookie'), req.query['flow'])
     *
     * res.render('login', flow)
     * })
     * ```
     *
     * This request may fail due to several reasons. The `error.id` can be one of:
     *
     * `session_already_available`: The user is already signed in.
     * `self_service_flow_expired`: The flow is expired and you should request a new one.
     *
     * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
     */
    getLoginFlow: {
        parameters: {
            query: {
                /**
                 * @description The Login Flow ID
                 *
                 * The value for this parameter comes from `flow` URL Query parameter sent to your
                 * application (e.g. `/login?flow=abcde`).
                 */
                id: string
            }
            header?: {
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK in a browser app, on the server side you must include the HTTP Cookie Header
                 * sent by the client to your server here. This ensures that CSRF and session cookies are respected.
                 */
                Cookie?: string
            }
        }
        responses: {
            /** @description loginFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["loginFlow"]
                }
            }
            /** @description errorGeneric */
            403: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            410: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Update Logout Flow
     * @description This endpoint logs out an identity in a self-service manner.
     *
     * If the `Accept` HTTP header is not set to `application/json`, the browser will be redirected (HTTP 303 See Other)
     * to the `return_to` parameter of the initial request or fall back to `urls.default_return_to`.
     *
     * If the `Accept` HTTP header is set to `application/json`, a 204 No Content response
     * will be sent on successful logout instead.
     *
     * This endpoint is NOT INTENDED for API clients and only works
     * with browsers (Chrome, Firefox, ...). For API clients you can
     * call the `/self-service/logout/api` URL directly with the Ory Session Token.
     *
     * More information can be found at [Ory Kratos User Logout Documentation](https://www.ory.sh/docs/next/kratos/self-service/flows/user-logout).
     */
    updateLogoutFlow: {
        parameters: {
            query?: {
                /**
                 * @description A Valid Logout Token
                 *
                 * If you do not have a logout token because you only have a session cookie,
                 * call `/self-service/logout/browser` to generate a URL for this endpoint.
                 */
                token?: string
                /** @description The URL to return to after the logout was completed. */
                return_to?: string
            }
            header?: {
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK in a browser app, on the server side you must include the HTTP Cookie Header
                 * sent by the client to your server here. This ensures that CSRF and session cookies are respected.
                 */
                Cookie?: string
            }
        }
        responses: {
            204: components["responses"]["emptyResponse"]
            303: components["responses"]["emptyResponse"]
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Perform Logout for Native Apps
     * @description Use this endpoint to log out an identity using an Ory Session Token. If the Ory Session Token was successfully
     * revoked, the server returns a 204 No Content response. A 204 No Content response is also sent when
     * the Ory Session Token has been revoked already before.
     *
     * If the Ory Session Token is malformed or does not exist a 403 Forbidden response will be returned.
     *
     * This endpoint does not remove any HTTP
     * Cookies - use the Browser-Based Self-Service Logout Flow instead.
     */
    performNativeLogout: {
        requestBody: {
            content: {
                "application/json": components["schemas"]["performNativeLogoutBody"]
            }
        }
        responses: {
            204: components["responses"]["emptyResponse"]
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create a Logout URL for Browsers
     * @description This endpoint initializes a browser-based user logout flow and a URL which can be used to log out the user.
     *
     * This endpoint is NOT INTENDED for API clients and only works
     * with browsers (Chrome, Firefox, ...). For API clients you can
     * call the `/self-service/logout/api` URL directly with the Ory Session Token.
     *
     * The URL is only valid for the currently signed in user. If no user is signed in, this endpoint returns
     * a 401 error.
     *
     * When calling this endpoint from a backend, please ensure to properly forward the HTTP cookies.
     */
    createBrowserLogoutFlow: {
        parameters: {
            query?: {
                /**
                 * @description Return to URL
                 *
                 * The URL to which the browser should be redirected to after the logout
                 * has been performed.
                 */
                return_to?: string
            }
            header?: {
                /**
                 * @description HTTP Cookies
                 *
                 * If you call this endpoint from a backend, please include the
                 * original Cookie header in the request.
                 */
                cookie?: string
            }
        }
        responses: {
            /** @description logoutFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["logoutFlow"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            401: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            500: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Complete Recovery Flow
     * @description Use this endpoint to complete a recovery flow. This endpoint
     * behaves differently for API and browser flows and has several states:
     *
     * `choose_method` expects `flow` (in the URL query) and `email` (in the body) to be sent
     * and works with API- and Browser-initiated flows.
     * For API clients and Browser clients with HTTP Header `Accept: application/json` it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid.
     * and a HTTP 303 See Other redirect with a fresh recovery flow if the flow was otherwise invalid (e.g. expired).
     * For Browser clients without HTTP Header `Accept` or with `Accept: text/*` it returns a HTTP 303 See Other redirect to the Recovery UI URL with the Recovery Flow ID appended.
     * `sent_email` is the success state after `choose_method` for the `link` method and allows the user to request another recovery email. It
     * works for both API and Browser-initiated flows and returns the same responses as the flow in `choose_method` state.
     * `passed_challenge` expects a `token` to be sent in the URL query and given the nature of the flow ("sending a recovery link")
     * does not have any API capabilities. The server responds with a HTTP 303 See Other redirect either to the Settings UI URL
     * (if the link was valid) and instructs the user to update their password, or a redirect to the Recover UI URL with
     * a new Recovery Flow ID which contains an error message that the recovery link was invalid.
     *
     * More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
     */
    updateRecoveryFlow: {
        parameters: {
            query: {
                /**
                 * @description The Recovery Flow ID
                 *
                 * The value for this parameter comes from `flow` URL Query parameter sent to your
                 * application (e.g. `/recovery?flow=abcde`).
                 */
                flow: string
                /**
                 * @description Recovery Token
                 *
                 * The recovery token which completes the recovery request. If the token
                 * is invalid (e.g. expired) an error will be shown to the end-user.
                 *
                 * This parameter is usually set in a link and not used by any direct API call.
                 */
                token?: string
            }
            header?: {
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK in a browser app, on the server side you must include the HTTP Cookie Header
                 * sent by the client to your server here. This ensures that CSRF and session cookies are respected.
                 */
                Cookie?: string
            }
        }
        requestBody: {
            content: {
                "application/json": components["schemas"]["updateRecoveryFlowBody"]
                "application/x-www-form-urlencoded": components["schemas"]["updateRecoveryFlowBody"]
            }
        }
        responses: {
            /** @description recoveryFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["recoveryFlow"]
                }
            }
            303: components["responses"]["emptyResponse"]
            /** @description recoveryFlow */
            400: {
                content: {
                    "application/json": components["schemas"]["recoveryFlow"]
                }
            }
            /** @description errorGeneric */
            410: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorBrowserLocationChangeRequired */
            422: {
                content: {
                    "application/json": components["schemas"]["errorBrowserLocationChangeRequired"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create Recovery Flow for Native Apps
     * @description This endpoint initiates a recovery flow for API clients such as mobile devices, smart TVs, and so on.
     *
     * If a valid provided session cookie or session token is provided, a 400 Bad Request error.
     *
     * To fetch an existing recovery flow call `/self-service/recovery/flows?flow=<flow_id>`.
     *
     * You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
     * Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
     * you vulnerable to a variety of CSRF attacks.
     *
     * This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).
     *
     * More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
     */
    createNativeRecoveryFlow: {
        responses: {
            /** @description recoveryFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["recoveryFlow"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create Recovery Flow for Browsers
     * @description This endpoint initializes a browser-based account recovery flow. Once initialized, the browser will be redirected to
     * `selfservice.flows.recovery.ui_url` with the flow ID set as the query parameter `?flow=`. If a valid user session
     * exists, the browser is returned to the configured return URL.
     *
     * If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects
     * or a 400 bad request error if the user is already authenticated.
     *
     * This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.
     *
     * More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
     */
    createBrowserRecoveryFlow: {
        parameters: {
            query?: {
                /** @description The URL to return the browser to after the flow was completed. */
                return_to?: string
            }
        }
        responses: {
            /** @description recoveryFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["recoveryFlow"]
                }
            }
            303: components["responses"]["emptyResponse"]
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Get Recovery Flow
     * @description This endpoint returns a recovery flow's context with, for example, error details and other information.
     *
     * Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
     * For AJAX requests you must ensure that cookies are included in the request or requests will fail.
     *
     * If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
     * and you need to forward the incoming HTTP Cookie header to this endpoint:
     *
     * ```js
     * pseudo-code example
     * router.get('/recovery', async function (req, res) {
     * const flow = await client.getRecoveryFlow(req.header('Cookie'), req.query['flow'])
     *
     * res.render('recovery', flow)
     * })
     * ```
     *
     * More information can be found at [Ory Kratos Account Recovery Documentation](../self-service/flows/account-recovery).
     */
    getRecoveryFlow: {
        parameters: {
            query: {
                /**
                 * @description The Flow ID
                 *
                 * The value for this parameter comes from `request` URL Query parameter sent to your
                 * application (e.g. `/recovery?flow=abcde`).
                 */
                id: string
            }
            header?: {
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK in a browser app, on the server side you must include the HTTP Cookie Header
                 * sent by the client to your server here. This ensures that CSRF and session cookies are respected.
                 */
                Cookie?: string
            }
        }
        responses: {
            /** @description recoveryFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["recoveryFlow"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            410: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Update Registration Flow
     * @description Use this endpoint to complete a registration flow by sending an identity's traits and password. This endpoint
     * behaves differently for API and browser flows.
     *
     * API flows expect `application/json` to be sent in the body and respond with
     * HTTP 200 and a application/json body with the created identity success - if the session hook is configured the
     * `session` and `session_token` will also be included;
     * HTTP 410 if the original flow expired with the appropriate error messages set and optionally a `use_flow_id` parameter in the body;
     * HTTP 400 on form validation errors.
     *
     * Browser flows expect a Content-Type of `application/x-www-form-urlencoded` or `application/json` to be sent in the body and respond with
     * a HTTP 303 redirect to the post/after registration URL or the `return_to` value if it was set and if the registration succeeded;
     * a HTTP 303 redirect to the registration UI URL with the flow ID containing the validation errors otherwise.
     *
     * Browser flows with an accept header of `application/json` will not redirect but instead respond with
     * HTTP 200 and a application/json body with the signed in identity and a `Set-Cookie` header on success;
     * HTTP 303 redirect to a fresh login flow if the original flow expired with the appropriate error messages set;
     * HTTP 400 on form validation errors.
     *
     * If this endpoint is called with `Accept: application/json` in the header, the response contains the flow without a redirect. In the
     * case of an error, the `error.id` of the JSON response body can be one of:
     *
     * `session_already_available`: The user is already signed in.
     * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
     * `security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
     * `browser_location_change_required`: Usually sent when an AJAX request indicates that the browser needs to open a specific URL.
     * Most likely used in Social Sign In flows.
     *
     * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
     */
    updateRegistrationFlow: {
        parameters: {
            query: {
                /**
                 * @description The Registration Flow ID
                 *
                 * The value for this parameter comes from `flow` URL Query parameter sent to your
                 * application (e.g. `/registration?flow=abcde`).
                 */
                flow: string
            }
            header?: {
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK in a browser app, on the server side you must include the HTTP Cookie Header
                 * sent by the client to your server here. This ensures that CSRF and session cookies are respected.
                 */
                Cookie?: string
            }
        }
        requestBody: {
            content: {
                "application/json": components["schemas"]["updateRegistrationFlowBody"]
                "application/x-www-form-urlencoded": components["schemas"]["updateRegistrationFlowBody"]
            }
        }
        responses: {
            /** @description successfulNativeRegistration */
            200: {
                content: {
                    "application/json": components["schemas"]["successfulNativeRegistration"]
                }
            }
            303: components["responses"]["emptyResponse"]
            /** @description registrationFlow */
            400: {
                content: {
                    "application/json": components["schemas"]["registrationFlow"]
                }
            }
            /** @description errorGeneric */
            410: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorBrowserLocationChangeRequired */
            422: {
                content: {
                    "application/json": components["schemas"]["errorBrowserLocationChangeRequired"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create Registration Flow for Native Apps
     * @description This endpoint initiates a registration flow for API clients such as mobile devices, smart TVs, and so on.
     *
     * If a valid provided session cookie or session token is provided, a 400 Bad Request error
     * will be returned unless the URL query parameter `?refresh=true` is set.
     *
     * To fetch an existing registration flow call `/self-service/registration/flows?flow=<flow_id>`.
     *
     * You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
     * Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
     * you vulnerable to a variety of CSRF attacks.
     *
     * In the case of an error, the `error.id` of the JSON response body can be one of:
     *
     * `session_already_available`: The user is already signed in.
     * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
     *
     * This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).
     *
     * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
     */
    createNativeRegistrationFlow: {
        parameters: {
            query?: {
                /**
                 * @description EnableSessionTokenExchangeCode requests the login flow to include a code that can be used to retrieve the session token
                 * after the login flow has been completed.
                 */
                return_session_token_exchange_code?: boolean
                /** @description The URL to return the browser to after the flow was completed. */
                return_to?: string
            }
        }
        responses: {
            /** @description registrationFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["registrationFlow"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create Registration Flow for Browsers
     * @description This endpoint initializes a browser-based user registration flow. This endpoint will set the appropriate
     * cookies and anti-CSRF measures required for browser-based flows.
     *
     * :::info
     *
     * This endpoint is EXPERIMENTAL and subject to potential breaking changes in the future.
     *
     * :::
     *
     * If this endpoint is opened as a link in the browser, it will be redirected to
     * `selfservice.flows.registration.ui_url` with the flow ID set as the query parameter `?flow=`. If a valid user session
     * exists already, the browser will be redirected to `urls.default_redirect_url`.
     *
     * If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
     * case of an error, the `error.id` of the JSON response body can be one of:
     *
     * `session_already_available`: The user is already signed in.
     * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
     * `security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
     *
     * If this endpoint is called via an AJAX request, the response contains the registration flow without a redirect.
     *
     * This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.
     *
     * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
     */
    createBrowserRegistrationFlow: {
        parameters: {
            query?: {
                /** @description The URL to return the browser to after the flow was completed. */
                return_to?: string
                /**
                 * @description Ory OAuth 2.0 Login Challenge.
                 *
                 * If set will cooperate with Ory OAuth2 and OpenID to act as an OAuth2 server / OpenID Provider.
                 *
                 * The value for this parameter comes from `login_challenge` URL Query parameter sent to your
                 * application (e.g. `/registration?login_challenge=abcde`).
                 *
                 * This feature is compatible with Ory Hydra when not running on the Ory Network.
                 */
                login_challenge?: string
                /**
                 * @description The URL to return the browser to after the verification flow was completed.
                 *
                 * After the registration flow is completed, the user will be sent a verification email.
                 * Upon completing the verification flow, this URL will be used to override the default
                 * `selfservice.flows.verification.after.default_redirect_to` value.
                 */
                after_verification_return_to?: string
            }
        }
        responses: {
            /** @description registrationFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["registrationFlow"]
                }
            }
            303: components["responses"]["emptyResponse"]
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Get Registration Flow
     * @description This endpoint returns a registration flow's context with, for example, error details and other information.
     *
     * Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
     * For AJAX requests you must ensure that cookies are included in the request or requests will fail.
     *
     * If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
     * and you need to forward the incoming HTTP Cookie header to this endpoint:
     *
     * ```js
     * pseudo-code example
     * router.get('/registration', async function (req, res) {
     * const flow = await client.getRegistrationFlow(req.header('cookie'), req.query['flow'])
     *
     * res.render('registration', flow)
     * })
     * ```
     *
     * This request may fail due to several reasons. The `error.id` can be one of:
     *
     * `session_already_available`: The user is already signed in.
     * `self_service_flow_expired`: The flow is expired and you should request a new one.
     *
     * More information can be found at [Ory Kratos User Login](https://www.ory.sh/docs/kratos/self-service/flows/user-login) and [User Registration Documentation](https://www.ory.sh/docs/kratos/self-service/flows/user-registration).
     */
    getRegistrationFlow: {
        parameters: {
            query: {
                /**
                 * @description The Registration Flow ID
                 *
                 * The value for this parameter comes from `flow` URL Query parameter sent to your
                 * application (e.g. `/registration?flow=abcde`).
                 */
                id: string
            }
            header?: {
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK in a browser app, on the server side you must include the HTTP Cookie Header
                 * sent by the client to your server here. This ensures that CSRF and session cookies are respected.
                 */
                Cookie?: string
            }
        }
        responses: {
            /** @description registrationFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["registrationFlow"]
                }
            }
            /** @description errorGeneric */
            403: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            410: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Complete Settings Flow
     * @description Use this endpoint to complete a settings flow by sending an identity's updated password. This endpoint
     * behaves differently for API and browser flows.
     *
     * API-initiated flows expect `application/json` to be sent in the body and respond with
     * HTTP 200 and an application/json body with the session token on success;
     * HTTP 303 redirect to a fresh settings flow if the original flow expired with the appropriate error messages set;
     * HTTP 400 on form validation errors.
     * HTTP 401 when the endpoint is called without a valid session token.
     * HTTP 403 when `selfservice.flows.settings.privileged_session_max_age` was reached or the session's AAL is too low.
     * Implies that the user needs to re-authenticate.
     *
     * Browser flows without HTTP Header `Accept` or with `Accept: text/*` respond with
     * a HTTP 303 redirect to the post/after settings URL or the `return_to` value if it was set and if the flow succeeded;
     * a HTTP 303 redirect to the Settings UI URL with the flow ID containing the validation errors otherwise.
     * a HTTP 303 redirect to the login endpoint when `selfservice.flows.settings.privileged_session_max_age` was reached or the session's AAL is too low.
     *
     * Browser flows with HTTP Header `Accept: application/json` respond with
     * HTTP 200 and a application/json body with the signed in identity and a `Set-Cookie` header on success;
     * HTTP 303 redirect to a fresh login flow if the original flow expired with the appropriate error messages set;
     * HTTP 401 when the endpoint is called without a valid session cookie.
     * HTTP 403 when the page is accessed without a session cookie or the session's AAL is too low.
     * HTTP 400 on form validation errors.
     *
     * Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
     * Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
     * credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
     * to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.
     *
     * If this endpoint is called with a `Accept: application/json` HTTP header, the response contains the flow without a redirect. In the
     * case of an error, the `error.id` of the JSON response body can be one of:
     *
     * `session_refresh_required`: The identity requested to change something that needs a privileged session. Redirect
     * the identity to the login init endpoint with query parameters `?refresh=true&return_to=<the-current-browser-url>`,
     * or initiate a refresh login flow otherwise.
     * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
     * `session_inactive`: No Ory Session was found - sign in a user first.
     * `security_identity_mismatch`: The flow was interrupted with `session_refresh_required` but apparently some other
     * identity logged in instead.
     * `security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
     * `browser_location_change_required`: Usually sent when an AJAX request indicates that the browser needs to open a specific URL.
     * Most likely used in Social Sign In flows.
     *
     * More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
     */
    updateSettingsFlow: {
        parameters: {
            query: {
                /**
                 * @description The Settings Flow ID
                 *
                 * The value for this parameter comes from `flow` URL Query parameter sent to your
                 * application (e.g. `/settings?flow=abcde`).
                 */
                flow: string
            }
            header?: {
                /** @description The Session Token of the Identity performing the settings flow. */
                "X-Session-Token"?: string
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK in a browser app, on the server side you must include the HTTP Cookie Header
                 * sent by the client to your server here. This ensures that CSRF and session cookies are respected.
                 */
                Cookie?: string
            }
        }
        requestBody: {
            content: {
                "application/json": components["schemas"]["updateSettingsFlowBody"]
                "application/x-www-form-urlencoded": components["schemas"]["updateSettingsFlowBody"]
            }
        }
        responses: {
            /** @description settingsFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["settingsFlow"]
                }
            }
            303: components["responses"]["emptyResponse"]
            /** @description settingsFlow */
            400: {
                content: {
                    "application/json": components["schemas"]["settingsFlow"]
                }
            }
            /** @description errorGeneric */
            401: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            403: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            410: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorBrowserLocationChangeRequired */
            422: {
                content: {
                    "application/json": components["schemas"]["errorBrowserLocationChangeRequired"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create Settings Flow for Native Apps
     * @description This endpoint initiates a settings flow for API clients such as mobile devices, smart TVs, and so on.
     * You must provide a valid Ory Kratos Session Token for this endpoint to respond with HTTP 200 OK.
     *
     * To fetch an existing settings flow call `/self-service/settings/flows?flow=<flow_id>`.
     *
     * You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
     * Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
     * you vulnerable to a variety of CSRF attacks.
     *
     * Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
     * Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
     * credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
     * to sign in with the second factor or change the configuration.
     *
     * In the case of an error, the `error.id` of the JSON response body can be one of:
     *
     * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
     * `session_inactive`: No Ory Session was found - sign in a user first.
     *
     * This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).
     *
     * More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
     */
    createNativeSettingsFlow: {
        parameters: {
            header?: {
                /** @description The Session Token of the Identity performing the settings flow. */
                "X-Session-Token"?: string
            }
        }
        responses: {
            /** @description settingsFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["settingsFlow"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create Settings Flow for Browsers
     * @description This endpoint initializes a browser-based user settings flow. Once initialized, the browser will be redirected to
     * `selfservice.flows.settings.ui_url` with the flow ID set as the query parameter `?flow=`. If no valid
     * Ory Kratos Session Cookie is included in the request, a login flow will be initialized.
     *
     * If this endpoint is opened as a link in the browser, it will be redirected to
     * `selfservice.flows.settings.ui_url` with the flow ID set as the query parameter `?flow=`. If no valid user session
     * was set, the browser will be redirected to the login endpoint.
     *
     * If this endpoint is called via an AJAX request, the response contains the settings flow without any redirects
     * or a 401 forbidden error if no valid session was set.
     *
     * Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
     * Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
     * credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
     * to sign in with the second factor (happens automatically for server-side browser flows) or change the configuration.
     *
     * If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
     * case of an error, the `error.id` of the JSON response body can be one of:
     *
     * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
     * `session_inactive`: No Ory Session was found - sign in a user first.
     * `security_identity_mismatch`: The requested `?return_to` address is not allowed to be used. Adjust this in the configuration!
     *
     * This endpoint is NOT INTENDED for clients that do not have a browser (Chrome, Firefox, ...) as cookies are needed.
     *
     * More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
     */
    createBrowserSettingsFlow: {
        parameters: {
            query?: {
                /** @description The URL to return the browser to after the flow was completed. */
                return_to?: string
            }
            header?: {
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK in a browser app, on the server side you must include the HTTP Cookie Header
                 * sent by the client to your server here. This ensures that CSRF and session cookies are respected.
                 */
                Cookie?: string
            }
        }
        responses: {
            /** @description settingsFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["settingsFlow"]
                }
            }
            303: components["responses"]["emptyResponse"]
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            401: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            403: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Get Settings Flow
     * @description When accessing this endpoint through Ory Kratos' Public API you must ensure that either the Ory Kratos Session Cookie
     * or the Ory Kratos Session Token are set.
     *
     * Depending on your configuration this endpoint might return a 403 error if the session has a lower Authenticator
     * Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
     * credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
     * to sign in with the second factor or change the configuration.
     *
     * You can access this endpoint without credentials when using Ory Kratos' Admin API.
     *
     * If this endpoint is called via an AJAX request, the response contains the flow without a redirect. In the
     * case of an error, the `error.id` of the JSON response body can be one of:
     *
     * `security_csrf_violation`: Unable to fetch the flow because a CSRF violation occurred.
     * `session_inactive`: No Ory Session was found - sign in a user first.
     * `security_identity_mismatch`: The flow was interrupted with `session_refresh_required` but apparently some other
     * identity logged in instead.
     *
     * More information can be found at [Ory Kratos User Settings & Profile Management Documentation](../self-service/flows/user-settings).
     */
    getSettingsFlow: {
        parameters: {
            query: {
                /**
                 * @description ID is the Settings Flow ID
                 *
                 * The value for this parameter comes from `flow` URL Query parameter sent to your
                 * application (e.g. `/settings?flow=abcde`).
                 */
                id: string
            }
            header?: {
                /**
                 * @description The Session Token
                 *
                 * When using the SDK in an app without a browser, please include the
                 * session token here.
                 */
                "X-Session-Token"?: string
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK in a browser app, on the server side you must include the HTTP Cookie Header
                 * sent by the client to your server here. This ensures that CSRF and session cookies are respected.
                 */
                Cookie?: string
            }
        }
        responses: {
            /** @description settingsFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["settingsFlow"]
                }
            }
            /** @description errorGeneric */
            401: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            403: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            410: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Complete Verification Flow
     * @description Use this endpoint to complete a verification flow. This endpoint
     * behaves differently for API and browser flows and has several states:
     *
     * `choose_method` expects `flow` (in the URL query) and `email` (in the body) to be sent
     * and works with API- and Browser-initiated flows.
     * For API clients and Browser clients with HTTP Header `Accept: application/json` it either returns a HTTP 200 OK when the form is valid and HTTP 400 OK when the form is invalid
     * and a HTTP 303 See Other redirect with a fresh verification flow if the flow was otherwise invalid (e.g. expired).
     * For Browser clients without HTTP Header `Accept` or with `Accept: text/*` it returns a HTTP 303 See Other redirect to the Verification UI URL with the Verification Flow ID appended.
     * `sent_email` is the success state after `choose_method` when using the `link` method and allows the user to request another verification email. It
     * works for both API and Browser-initiated flows and returns the same responses as the flow in `choose_method` state.
     * `passed_challenge` expects a `token` to be sent in the URL query and given the nature of the flow ("sending a verification link")
     * does not have any API capabilities. The server responds with a HTTP 303 See Other redirect either to the Settings UI URL
     * (if the link was valid) and instructs the user to update their password, or a redirect to the Verification UI URL with
     * a new Verification Flow ID which contains an error message that the verification link was invalid.
     *
     * More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
     */
    updateVerificationFlow: {
        parameters: {
            query: {
                /**
                 * @description The Verification Flow ID
                 *
                 * The value for this parameter comes from `flow` URL Query parameter sent to your
                 * application (e.g. `/verification?flow=abcde`).
                 */
                flow: string
                /**
                 * @description Verification Token
                 *
                 * The verification token which completes the verification request. If the token
                 * is invalid (e.g. expired) an error will be shown to the end-user.
                 *
                 * This parameter is usually set in a link and not used by any direct API call.
                 */
                token?: string
            }
            header?: {
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK in a browser app, on the server side you must include the HTTP Cookie Header
                 * sent by the client to your server here. This ensures that CSRF and session cookies are respected.
                 */
                Cookie?: string
            }
        }
        requestBody: {
            content: {
                "application/json": components["schemas"]["updateVerificationFlowBody"]
                "application/x-www-form-urlencoded": components["schemas"]["updateVerificationFlowBody"]
            }
        }
        responses: {
            /** @description verificationFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["verificationFlow"]
                }
            }
            303: components["responses"]["emptyResponse"]
            /** @description verificationFlow */
            400: {
                content: {
                    "application/json": components["schemas"]["verificationFlow"]
                }
            }
            /** @description errorGeneric */
            410: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create Verification Flow for Native Apps
     * @description This endpoint initiates a verification flow for API clients such as mobile devices, smart TVs, and so on.
     *
     * To fetch an existing verification flow call `/self-service/verification/flows?flow=<flow_id>`.
     *
     * You MUST NOT use this endpoint in client-side (Single Page Apps, ReactJS, AngularJS) nor server-side (Java Server
     * Pages, NodeJS, PHP, Golang, ...) browser applications. Using this endpoint in these applications will make
     * you vulnerable to a variety of CSRF attacks.
     *
     * This endpoint MUST ONLY be used in scenarios such as native mobile apps (React Native, Objective C, Swift, Java, ...).
     *
     * More information can be found at [Ory Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
     */
    createNativeVerificationFlow: {
        responses: {
            /** @description verificationFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["verificationFlow"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Create Verification Flow for Browser Clients
     * @description This endpoint initializes a browser-based account verification flow. Once initialized, the browser will be redirected to
     * `selfservice.flows.verification.ui_url` with the flow ID set as the query parameter `?flow=`.
     *
     * If this endpoint is called via an AJAX request, the response contains the recovery flow without any redirects.
     *
     * This endpoint is NOT INTENDED for API clients and only works with browsers (Chrome, Firefox, ...).
     *
     * More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
     */
    createBrowserVerificationFlow: {
        parameters: {
            query?: {
                /** @description The URL to return the browser to after the flow was completed. */
                return_to?: string
            }
        }
        responses: {
            /** @description verificationFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["verificationFlow"]
                }
            }
            303: components["responses"]["emptyResponse"]
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Get Verification Flow
     * @description This endpoint returns a verification flow's context with, for example, error details and other information.
     *
     * Browser flows expect the anti-CSRF cookie to be included in the request's HTTP Cookie Header.
     * For AJAX requests you must ensure that cookies are included in the request or requests will fail.
     *
     * If you use the browser-flow for server-side apps, the services need to run on a common top-level-domain
     * and you need to forward the incoming HTTP Cookie header to this endpoint:
     *
     * ```js
     * pseudo-code example
     * router.get('/recovery', async function (req, res) {
     * const flow = await client.getVerificationFlow(req.header('cookie'), req.query['flow'])
     *
     * res.render('verification', flow)
     * })
     * ```
     *
     * More information can be found at [Ory Kratos Email and Phone Verification Documentation](https://www.ory.sh/docs/kratos/self-service/flows/verify-email-account-activation).
     */
    getVerificationFlow: {
        parameters: {
            query: {
                /**
                 * @description The Flow ID
                 *
                 * The value for this parameter comes from `request` URL Query parameter sent to your
                 * application (e.g. `/verification?flow=abcde`).
                 */
                id: string
            }
            header?: {
                /**
                 * @description HTTP Cookies
                 *
                 * When using the SDK on the server side you must include the HTTP Cookie Header
                 * originally sent to your HTTP handler here.
                 */
                cookie?: string
            }
        }
        responses: {
            /** @description verificationFlow */
            200: {
                content: {
                    "application/json": components["schemas"]["verificationFlow"]
                }
            }
            /** @description errorGeneric */
            403: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Get My Active Sessions
     * @description This endpoints returns all other active sessions that belong to the logged-in user.
     * The current session can be retrieved by calling the `/sessions/whoami` endpoint.
     */
    listMySessions: {
        parameters: {
            query?: {
                /**
                 * @description Items per Page
                 *
                 * This is the number of items per page.
                 */
                per_page?: number
                /**
                 * @description Pagination Page
                 *
                 * This value is currently an integer, but it is not sequential. The value is not the page number, but a
                 * reference. The next page can be any number and some numbers might return an empty list.
                 *
                 * For example, page 2 might not follow after page 1. And even if page 3 and 5 exist, but page 4 might not exist.
                 */
                page?: number
            }
            header?: {
                /** @description Set the Session Token when calling from non-browser clients. A session token has a format of `MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj`. */
                "X-Session-Token"?: string
                /**
                 * @description Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that
                 * scenario you must include the HTTP Cookie Header which originally was included in the request to your server.
                 * An example of a session in the HTTP Cookie Header is: `ory_kratos_session=a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f==`.
                 *
                 * It is ok if more than one cookie are included here as all other cookies will be ignored.
                 */
                Cookie?: string
            }
        }
        responses: {
            200: components["responses"]["listMySessions"]
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            401: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Disable my other sessions
     * @description Calling this endpoint invalidates all except the current session that belong to the logged-in user.
     * Session data are not deleted.
     */
    disableMyOtherSessions: {
        parameters: {
            header?: {
                /** @description Set the Session Token when calling from non-browser clients. A session token has a format of `MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj`. */
                "X-Session-Token"?: string
                /**
                 * @description Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that
                 * scenario you must include the HTTP Cookie Header which originally was included in the request to your server.
                 * An example of a session in the HTTP Cookie Header is: `ory_kratos_session=a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f==`.
                 *
                 * It is ok if more than one cookie are included here as all other cookies will be ignored.
                 */
                Cookie?: string
            }
        }
        responses: {
            /** @description deleteMySessionsCount */
            200: {
                content: {
                    "application/json": components["schemas"]["deleteMySessionsCount"]
                }
            }
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            401: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /** Exchange Session Token */
    exchangeSessionToken: {
        parameters: {
            query: {
                /** @description The part of the code return when initializing the flow. */
                init_code: string
                /** @description The part of the code returned by the return_to URL. */
                return_to_code: string
            }
        }
        responses: {
            /** @description successfulNativeLogin */
            200: {
                content: {
                    "application/json": components["schemas"]["successfulNativeLogin"]
                }
            }
            /** @description errorGeneric */
            403: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            404: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            410: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Check Who the Current HTTP Session Belongs To
     * @description Uses the HTTP Headers in the GET request to determine (e.g. by using checking the cookies) who is authenticated.
     * Returns a session object in the body or 401 if the credentials are invalid or no credentials were sent.
     * When the request it successful it adds the user ID to the 'X-Kratos-Authenticated-Identity-Id' header
     * in the response.
     *
     * If you call this endpoint from a server-side application, you must forward the HTTP Cookie Header to this endpoint:
     *
     * ```js
     * pseudo-code example
     * router.get('/protected-endpoint', async function (req, res) {
     * const session = await client.toSession(undefined, req.header('cookie'))
     *
     * console.log(session)
     * })
     * ```
     *
     * When calling this endpoint from a non-browser application (e.g. mobile app) you must include the session token:
     *
     * ```js
     * pseudo-code example
     * ...
     * const session = await client.toSession("the-session-token")
     *
     * console.log(session)
     * ```
     *
     * Depending on your configuration this endpoint might return a 403 status code if the session has a lower Authenticator
     * Assurance Level (AAL) than is possible for the identity. This can happen if the identity has password + webauthn
     * credentials (which would result in AAL2) but the session has only AAL1. If this error occurs, ask the user
     * to sign in with the second factor or change the configuration.
     *
     * This endpoint is useful for:
     *
     * AJAX calls. Remember to send credentials and set up CORS correctly!
     * Reverse proxies and API Gateways
     * Server-side calls - use the `X-Session-Token` header!
     *
     * This endpoint authenticates users by checking:
     *
     * if the `Cookie` HTTP header was set containing an Ory Kratos Session Cookie;
     * if the `Authorization: bearer <ory-session-token>` HTTP header was set with a valid Ory Kratos Session Token;
     * if the `X-Session-Token` HTTP header was set with a valid Ory Kratos Session Token.
     *
     * If none of these headers are set or the cookie or token are invalid, the endpoint returns a HTTP 401 status code.
     *
     * As explained above, this request may fail due to several reasons. The `error.id` can be one of:
     *
     * `session_inactive`: No active session was found in the request (e.g. no Ory Session Cookie / Ory Session Token).
     * `session_aal2_required`: An active session was found but it does not fulfil the Authenticator Assurance Level, implying that the session must (e.g.) authenticate the second factor.
     */
    toSession: {
        parameters: {
            header?: {
                /**
                 * @description Set the Session Token when calling from non-browser clients. A session token has a format of `MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj`.
                 * @example MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj
                 */
                "X-Session-Token"?: string
                /**
                 * @description Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that
                 * scenario you must include the HTTP Cookie Header which originally was included in the request to your server.
                 * An example of a session in the HTTP Cookie Header is: `ory_kratos_session=a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f==`.
                 *
                 * It is ok if more than one cookie are included here as all other cookies will be ignored.
                 * @example ory_session=a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f==
                 */
                Cookie?: string
            }
        }
        responses: {
            /** @description session */
            200: {
                content: {
                    "application/json": components["schemas"]["session"]
                }
            }
            /** @description errorGeneric */
            401: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            403: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Disable one of my sessions
     * @description Calling this endpoint invalidates the specified session. The current session cannot be revoked.
     * Session data are not deleted.
     */
    disableMySession: {
        parameters: {
            header?: {
                /** @description Set the Session Token when calling from non-browser clients. A session token has a format of `MP2YWEMeM8MxjkGKpH4dqOQ4Q4DlSPaj`. */
                "X-Session-Token"?: string
                /**
                 * @description Set the Cookie Header. This is especially useful when calling this endpoint from a server-side application. In that
                 * scenario you must include the HTTP Cookie Header which originally was included in the request to your server.
                 * An example of a session in the HTTP Cookie Header is: `ory_kratos_session=a19iOVAbdzdgl70Rq1QZmrKmcjDtdsviCTZx7m9a9yHIUS8Wa9T7hvqyGTsLHi6Qifn2WUfpAKx9DWp0SJGleIn9vh2YF4A16id93kXFTgIgmwIOvbVAScyrx7yVl6bPZnCx27ec4WQDtaTewC1CpgudeDV2jQQnSaCP6ny3xa8qLH-QUgYqdQuoA_LF1phxgRCUfIrCLQOkolX5nv3ze_f==`.
                 *
                 * It is ok if more than one cookie are included here as all other cookies will be ignored.
                 */
                Cookie?: string
            }
            path: {
                /** @description ID is the session's ID. */
                id: string
            }
        }
        responses: {
            204: components["responses"]["emptyResponse"]
            /** @description errorGeneric */
            400: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            401: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
            /** @description errorGeneric */
            default: {
                content: {
                    "application/json": components["schemas"]["errorGeneric"]
                }
            }
        }
    }
    /**
     * Return Running Software Version.
     * @description This endpoint returns the version of Ory Kratos.
     *
     * If the service supports TLS Edge Termination, this endpoint does not require the
     * `X-Forwarded-Proto` header to be set.
     *
     * Be aware that if you are running multiple nodes of this service, the version will never
     * refer to the cluster state, only to a single instance.
     */
    getVersion: {
        responses: {
            /** @description Returns the Ory Kratos version. */
            200: {
                content: {
                    "application/json": {
                        /** @description The version of Ory Kratos. */
                        version: string
                    }
                }
            }
        }
    }
}
