# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import PinnacleEnvironment

if typing.TYPE_CHECKING:
    from .brands.client import AsyncBrandsClient, BrandsClient
    from .campaigns.client import AsyncCampaignsClient, CampaignsClient
    from .contacts.client import AsyncContactsClient, ContactsClient
    from .conversations.client import AsyncConversationsClient, ConversationsClient
    from .messages.client import AsyncMessagesClient, MessagesClient
    from .phone_numbers.client import AsyncPhoneNumbersClient, PhoneNumbersClient
    from .rcs.client import AsyncRcsClient, RcsClient
    from .status.client import AsyncStatusClient, StatusClient
    from .tools.client import AsyncToolsClient, ToolsClient
    from .webhooks.client import AsyncWebhooksClient, WebhooksClient


class PinnacleBase:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : PinnacleEnvironment
        The environment to use for requests from the client. from .environment import PinnacleEnvironment



        Defaults to PinnacleEnvironment.DEFAULT



    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from rcs import Pinnacle

    client = Pinnacle(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: PinnacleEnvironment = PinnacleEnvironment.DEFAULT,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._brands: typing.Optional[BrandsClient] = None
        self._contacts: typing.Optional[ContactsClient] = None
        self._conversations: typing.Optional[ConversationsClient] = None
        self._messages: typing.Optional[MessagesClient] = None
        self._phone_numbers: typing.Optional[PhoneNumbersClient] = None
        self._rcs: typing.Optional[RcsClient] = None
        self._webhooks: typing.Optional[WebhooksClient] = None
        self._campaigns: typing.Optional[CampaignsClient] = None
        self._status: typing.Optional[StatusClient] = None
        self._tools: typing.Optional[ToolsClient] = None

    @property
    def brands(self):
        if self._brands is None:
            from .brands.client import BrandsClient  # noqa: E402

            self._brands = BrandsClient(client_wrapper=self._client_wrapper)
        return self._brands

    @property
    def contacts(self):
        if self._contacts is None:
            from .contacts.client import ContactsClient  # noqa: E402

            self._contacts = ContactsClient(client_wrapper=self._client_wrapper)
        return self._contacts

    @property
    def conversations(self):
        if self._conversations is None:
            from .conversations.client import ConversationsClient  # noqa: E402

            self._conversations = ConversationsClient(client_wrapper=self._client_wrapper)
        return self._conversations

    @property
    def messages(self):
        if self._messages is None:
            from .messages.client import MessagesClient  # noqa: E402

            self._messages = MessagesClient(client_wrapper=self._client_wrapper)
        return self._messages

    @property
    def phone_numbers(self):
        if self._phone_numbers is None:
            from .phone_numbers.client import PhoneNumbersClient  # noqa: E402

            self._phone_numbers = PhoneNumbersClient(client_wrapper=self._client_wrapper)
        return self._phone_numbers

    @property
    def rcs(self):
        if self._rcs is None:
            from .rcs.client import RcsClient  # noqa: E402

            self._rcs = RcsClient(client_wrapper=self._client_wrapper)
        return self._rcs

    @property
    def webhooks(self):
        if self._webhooks is None:
            from .webhooks.client import WebhooksClient  # noqa: E402

            self._webhooks = WebhooksClient(client_wrapper=self._client_wrapper)
        return self._webhooks

    @property
    def campaigns(self):
        if self._campaigns is None:
            from .campaigns.client import CampaignsClient  # noqa: E402

            self._campaigns = CampaignsClient(client_wrapper=self._client_wrapper)
        return self._campaigns

    @property
    def status(self):
        if self._status is None:
            from .status.client import StatusClient  # noqa: E402

            self._status = StatusClient(client_wrapper=self._client_wrapper)
        return self._status

    @property
    def tools(self):
        if self._tools is None:
            from .tools.client import ToolsClient  # noqa: E402

            self._tools = ToolsClient(client_wrapper=self._client_wrapper)
        return self._tools


class AsyncPinnacleBase:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : PinnacleEnvironment
        The environment to use for requests from the client. from .environment import PinnacleEnvironment



        Defaults to PinnacleEnvironment.DEFAULT



    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from rcs import AsyncPinnacle

    client = AsyncPinnacle(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: PinnacleEnvironment = PinnacleEnvironment.DEFAULT,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._brands: typing.Optional[AsyncBrandsClient] = None
        self._contacts: typing.Optional[AsyncContactsClient] = None
        self._conversations: typing.Optional[AsyncConversationsClient] = None
        self._messages: typing.Optional[AsyncMessagesClient] = None
        self._phone_numbers: typing.Optional[AsyncPhoneNumbersClient] = None
        self._rcs: typing.Optional[AsyncRcsClient] = None
        self._webhooks: typing.Optional[AsyncWebhooksClient] = None
        self._campaigns: typing.Optional[AsyncCampaignsClient] = None
        self._status: typing.Optional[AsyncStatusClient] = None
        self._tools: typing.Optional[AsyncToolsClient] = None

    @property
    def brands(self):
        if self._brands is None:
            from .brands.client import AsyncBrandsClient  # noqa: E402

            self._brands = AsyncBrandsClient(client_wrapper=self._client_wrapper)
        return self._brands

    @property
    def contacts(self):
        if self._contacts is None:
            from .contacts.client import AsyncContactsClient  # noqa: E402

            self._contacts = AsyncContactsClient(client_wrapper=self._client_wrapper)
        return self._contacts

    @property
    def conversations(self):
        if self._conversations is None:
            from .conversations.client import AsyncConversationsClient  # noqa: E402

            self._conversations = AsyncConversationsClient(client_wrapper=self._client_wrapper)
        return self._conversations

    @property
    def messages(self):
        if self._messages is None:
            from .messages.client import AsyncMessagesClient  # noqa: E402

            self._messages = AsyncMessagesClient(client_wrapper=self._client_wrapper)
        return self._messages

    @property
    def phone_numbers(self):
        if self._phone_numbers is None:
            from .phone_numbers.client import AsyncPhoneNumbersClient  # noqa: E402

            self._phone_numbers = AsyncPhoneNumbersClient(client_wrapper=self._client_wrapper)
        return self._phone_numbers

    @property
    def rcs(self):
        if self._rcs is None:
            from .rcs.client import AsyncRcsClient  # noqa: E402

            self._rcs = AsyncRcsClient(client_wrapper=self._client_wrapper)
        return self._rcs

    @property
    def webhooks(self):
        if self._webhooks is None:
            from .webhooks.client import AsyncWebhooksClient  # noqa: E402

            self._webhooks = AsyncWebhooksClient(client_wrapper=self._client_wrapper)
        return self._webhooks

    @property
    def campaigns(self):
        if self._campaigns is None:
            from .campaigns.client import AsyncCampaignsClient  # noqa: E402

            self._campaigns = AsyncCampaignsClient(client_wrapper=self._client_wrapper)
        return self._campaigns

    @property
    def status(self):
        if self._status is None:
            from .status.client import AsyncStatusClient  # noqa: E402

            self._status = AsyncStatusClient(client_wrapper=self._client_wrapper)
        return self._status

    @property
    def tools(self):
        if self._tools is None:
            from .tools.client import AsyncToolsClient  # noqa: E402

            self._tools = AsyncToolsClient(client_wrapper=self._client_wrapper)
        return self._tools


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: PinnacleEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
