# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.company_sector_enum import CompanySectorEnum
from ..types.company_type_enum import CompanyTypeEnum
from ..types.extended_brand import ExtendedBrand
from ..types.extended_brand_with_vetting import ExtendedBrandWithVetting
from ..types.optional_brand_info import OptionalBrandInfo
from ..types.submission_results import SubmissionResults
from ..types.upsert_contact import UpsertContact
from ..types.validation_results import ValidationResults
from ..types.vetting_results import VettingResults
from .raw_client import AsyncRawBrandsClient, RawBrandsClient
from .types.autofill_brand_options import AutofillBrandOptions
from .types.brand_contact import BrandContact

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BrandsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBrandsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBrandsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBrandsClient
        """
        return self._raw_client

    def autofill(
        self,
        *,
        additional_info: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        options: typing.Optional[AutofillBrandOptions] = OMIT,
        website: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OptionalBrandInfo:
        """
        Automatically populate brand information based on partial input data you provide.

        Parameters
        ----------
        additional_info : typing.Optional[str]
            Any extra details about the brand to help improve data accuracy.

        name : typing.Optional[str]
            Name of the brand.

        options : typing.Optional[AutofillBrandOptions]

        website : typing.Optional[str]
            Brand's website URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OptionalBrandInfo
            Returns enriched brand information retrieved from the autofill service.

        Examples
        --------
        from rcs import Pinnacle
        from rcs.brands import AutofillBrandOptions

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.brands.autofill(
            additional_info="A developer-friendly, compliant API for SMS, MMS, and RCS, built to scale real conversations.",
            name="Pinnacle",
            options=AutofillBrandOptions(
                force_reload=True,
            ),
            website="https://www.pinnacle.sh",
        )
        """
        _response = self._raw_client.autofill(
            additional_info=additional_info,
            name=name,
            options=options,
            website=website,
            request_options=request_options,
        )
        return _response.data

    def upsert(
        self,
        *,
        address: typing.Optional[str] = OMIT,
        contact: typing.Optional[UpsertContact] = OMIT,
        dba: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        ein: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        sector: typing.Optional[CompanySectorEnum] = OMIT,
        type: typing.Optional[CompanyTypeEnum] = OMIT,
        website: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtendedBrand:
        """
        Create a new brand or update an existing brand by with the provided information.

        Parameters
        ----------
        address : typing.Optional[str]
            Primary brand address where the company is located.

        contact : typing.Optional[UpsertContact]
            Contact information for the brand.

        dba : typing.Optional[str]
            "Doing Business As" name - the public name the brand operates under.

        description : typing.Optional[str]
            Brief description of what the brand does.

        ein : typing.Optional[str]
            Brand's Employer Identification Number (EIN) assigned by the IRS.

        email : typing.Optional[str]
            Main contact email address for the brand.

        id : typing.Optional[str]
            The unique identifier of the brand you want to update.
            <br><br> This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        name : typing.Optional[str]
            Legal name of the brand as registered.

        sector : typing.Optional[CompanySectorEnum]
            Industry the brand operates in.

        type : typing.Optional[CompanyTypeEnum]
            Legal structure of the brand.

        website : typing.Optional[str]
            Brand website URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtendedBrand
            Successfully create/updated the brand.

        Examples
        --------
        from rcs import Pinnacle, UpsertContact

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.brands.upsert(
            address="500 Folsom St, San Francisco, CA 94105",
            contact=UpsertContact(
                email="michael.chen@trypinnacle.app",
                name="Michael Chen",
                phone="+14155551234",
                title="Customer Support Representative",
            ),
            dba="Pinnacle RCS",
            description="A developer-friendly, compliant API for SMS, MMS, and RCS, built to scale real conversations.",
            ein="88-1234567",
            email="founders@trypinnacle.app",
            id="b_1234567890",
            name="Pinnacle",
            sector="TECHNOLOGY",
            type="PRIVATE_PROFIT",
            website="https://www.pinnacle.sh",
        )
        """
        _response = self._raw_client.upsert(
            address=address,
            contact=contact,
            dba=dba,
            description=description,
            ein=ein,
            email=email,
            id=id,
            name=name,
            sector=sector,
            type=type,
            website=website,
            request_options=request_options,
        )
        return _response.data

    def get(
        self,
        id: str,
        *,
        hide_ein: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtendedBrandWithVetting:
        """
        Retrieve detailed information for a specific brand in your account by ID.

        Parameters
        ----------
        id : str
            The unique identifier of the brand you want to retrieve from your account.
            <br><br> This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        hide_ein : typing.Optional[bool]
            Optional flag to mask the Employer Identification Number in the response for security purposes.<br>

            When you set this to true, the EIN value will be replaced with a masked placeholder instead of the actual number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtendedBrandWithVetting
            Returns the brand.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.brands.get(
            id="b_1234567890",
        )
        """
        _response = self._raw_client.get(id, hide_ein=hide_ein, request_options=request_options)
        return _response.data

    def submit(self, brand_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> SubmissionResults:
        """
        Submit your brand for review and approval by the compliance team.

        Parameters
        ----------
        brand_id : str
            The unique identifier of the brand you want to submit for review. <br><br>
            This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890` and must correspond to an existing brand in your account that is ready for submission.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubmissionResults
            Successfully submitted brand information.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.brands.submit(
            brand_id="b_1234567890",
        )
        """
        _response = self._raw_client.submit(brand_id, request_options=request_options)
        return _response.data

    def validate(
        self,
        *,
        address: str,
        contact: BrandContact,
        description: str,
        email: str,
        name: str,
        sector: CompanySectorEnum,
        type: CompanyTypeEnum,
        website: str,
        dba: typing.Optional[str] = OMIT,
        ein: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ValidationResults:
        """
        Validate your brand information for compliance and correctness before submission or storage.

        Parameters
        ----------
        address : str
            Primary brand address where the brand is located.

        contact : BrandContact
            Contact information for the primary brand representative.

        description : str
            Brief description of what the brand does.

        email : str
            Main contact email address for the brand.

        name : str
            Legal name of the brand as registered.

        sector : CompanySectorEnum

        type : CompanyTypeEnum

        website : str
            Brand website URL.

        dba : typing.Optional[str]
            "Doing Business As" name - the public name the brand operates under.

        ein : typing.Optional[str]
            Employer Identification Number (EIN) assigned by the IRS.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ValidationResults
            Returns the brand validation result.

        Examples
        --------
        from rcs import Pinnacle
        from rcs.brands import BrandContact

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.brands.validate(
            address="500 Folsom St, San Francisco, CA 94105",
            contact=BrandContact(
                email="michael.chen@trypinnacle.app",
                name="Michael Chen",
                phone="+14155551234",
                title="Customer Support Representative",
            ),
            dba="Pinnacle Messaging",
            description="Pinnacle is an SMS, MMS, and RCS API for scaling conversations with customers you value.",
            ein="88-1234567",
            email="founders@trypinnacle.app",
            name="Pinnacle",
            sector="TECHNOLOGY",
            type="PRIVATE_PROFIT",
            website="https://www.pinnacle.sh",
        )
        """
        _response = self._raw_client.validate(
            address=address,
            contact=contact,
            description=description,
            email=email,
            name=name,
            sector=sector,
            type=type,
            website=website,
            dba=dba,
            ein=ein,
            request_options=request_options,
        )
        return _response.data

    def vet(self, brand_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> VettingResults:
        """
        Submit a brand for external vetting verification to enhance your brand's trust score and improved message delivery rates.

        Parameters
        ----------
        brand_id : str
            The unique identifier of the brand to vet. <br>

            This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890` and must correspond to an existing brand in your account that is ready for vetting.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VettingResults
            Successfully initiated brand vetting process.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.brands.vet(
            brand_id="b_1234567890",
        )
        """
        _response = self._raw_client.vet(brand_id, request_options=request_options)
        return _response.data


class AsyncBrandsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBrandsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBrandsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBrandsClient
        """
        return self._raw_client

    async def autofill(
        self,
        *,
        additional_info: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        options: typing.Optional[AutofillBrandOptions] = OMIT,
        website: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OptionalBrandInfo:
        """
        Automatically populate brand information based on partial input data you provide.

        Parameters
        ----------
        additional_info : typing.Optional[str]
            Any extra details about the brand to help improve data accuracy.

        name : typing.Optional[str]
            Name of the brand.

        options : typing.Optional[AutofillBrandOptions]

        website : typing.Optional[str]
            Brand's website URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OptionalBrandInfo
            Returns enriched brand information retrieved from the autofill service.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle
        from rcs.brands import AutofillBrandOptions

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.brands.autofill(
                additional_info="A developer-friendly, compliant API for SMS, MMS, and RCS, built to scale real conversations.",
                name="Pinnacle",
                options=AutofillBrandOptions(
                    force_reload=True,
                ),
                website="https://www.pinnacle.sh",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.autofill(
            additional_info=additional_info,
            name=name,
            options=options,
            website=website,
            request_options=request_options,
        )
        return _response.data

    async def upsert(
        self,
        *,
        address: typing.Optional[str] = OMIT,
        contact: typing.Optional[UpsertContact] = OMIT,
        dba: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        ein: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        sector: typing.Optional[CompanySectorEnum] = OMIT,
        type: typing.Optional[CompanyTypeEnum] = OMIT,
        website: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtendedBrand:
        """
        Create a new brand or update an existing brand by with the provided information.

        Parameters
        ----------
        address : typing.Optional[str]
            Primary brand address where the company is located.

        contact : typing.Optional[UpsertContact]
            Contact information for the brand.

        dba : typing.Optional[str]
            "Doing Business As" name - the public name the brand operates under.

        description : typing.Optional[str]
            Brief description of what the brand does.

        ein : typing.Optional[str]
            Brand's Employer Identification Number (EIN) assigned by the IRS.

        email : typing.Optional[str]
            Main contact email address for the brand.

        id : typing.Optional[str]
            The unique identifier of the brand you want to update.
            <br><br> This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        name : typing.Optional[str]
            Legal name of the brand as registered.

        sector : typing.Optional[CompanySectorEnum]
            Industry the brand operates in.

        type : typing.Optional[CompanyTypeEnum]
            Legal structure of the brand.

        website : typing.Optional[str]
            Brand website URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtendedBrand
            Successfully create/updated the brand.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle, UpsertContact

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.brands.upsert(
                address="500 Folsom St, San Francisco, CA 94105",
                contact=UpsertContact(
                    email="michael.chen@trypinnacle.app",
                    name="Michael Chen",
                    phone="+14155551234",
                    title="Customer Support Representative",
                ),
                dba="Pinnacle RCS",
                description="A developer-friendly, compliant API for SMS, MMS, and RCS, built to scale real conversations.",
                ein="88-1234567",
                email="founders@trypinnacle.app",
                id="b_1234567890",
                name="Pinnacle",
                sector="TECHNOLOGY",
                type="PRIVATE_PROFIT",
                website="https://www.pinnacle.sh",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upsert(
            address=address,
            contact=contact,
            dba=dba,
            description=description,
            ein=ein,
            email=email,
            id=id,
            name=name,
            sector=sector,
            type=type,
            website=website,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self,
        id: str,
        *,
        hide_ein: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtendedBrandWithVetting:
        """
        Retrieve detailed information for a specific brand in your account by ID.

        Parameters
        ----------
        id : str
            The unique identifier of the brand you want to retrieve from your account.
            <br><br> This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        hide_ein : typing.Optional[bool]
            Optional flag to mask the Employer Identification Number in the response for security purposes.<br>

            When you set this to true, the EIN value will be replaced with a masked placeholder instead of the actual number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtendedBrandWithVetting
            Returns the brand.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.brands.get(
                id="b_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, hide_ein=hide_ein, request_options=request_options)
        return _response.data

    async def submit(
        self, brand_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SubmissionResults:
        """
        Submit your brand for review and approval by the compliance team.

        Parameters
        ----------
        brand_id : str
            The unique identifier of the brand you want to submit for review. <br><br>
            This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890` and must correspond to an existing brand in your account that is ready for submission.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubmissionResults
            Successfully submitted brand information.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.brands.submit(
                brand_id="b_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.submit(brand_id, request_options=request_options)
        return _response.data

    async def validate(
        self,
        *,
        address: str,
        contact: BrandContact,
        description: str,
        email: str,
        name: str,
        sector: CompanySectorEnum,
        type: CompanyTypeEnum,
        website: str,
        dba: typing.Optional[str] = OMIT,
        ein: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ValidationResults:
        """
        Validate your brand information for compliance and correctness before submission or storage.

        Parameters
        ----------
        address : str
            Primary brand address where the brand is located.

        contact : BrandContact
            Contact information for the primary brand representative.

        description : str
            Brief description of what the brand does.

        email : str
            Main contact email address for the brand.

        name : str
            Legal name of the brand as registered.

        sector : CompanySectorEnum

        type : CompanyTypeEnum

        website : str
            Brand website URL.

        dba : typing.Optional[str]
            "Doing Business As" name - the public name the brand operates under.

        ein : typing.Optional[str]
            Employer Identification Number (EIN) assigned by the IRS.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ValidationResults
            Returns the brand validation result.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle
        from rcs.brands import BrandContact

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.brands.validate(
                address="500 Folsom St, San Francisco, CA 94105",
                contact=BrandContact(
                    email="michael.chen@trypinnacle.app",
                    name="Michael Chen",
                    phone="+14155551234",
                    title="Customer Support Representative",
                ),
                dba="Pinnacle Messaging",
                description="Pinnacle is an SMS, MMS, and RCS API for scaling conversations with customers you value.",
                ein="88-1234567",
                email="founders@trypinnacle.app",
                name="Pinnacle",
                sector="TECHNOLOGY",
                type="PRIVATE_PROFIT",
                website="https://www.pinnacle.sh",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.validate(
            address=address,
            contact=contact,
            description=description,
            email=email,
            name=name,
            sector=sector,
            type=type,
            website=website,
            dba=dba,
            ein=ein,
            request_options=request_options,
        )
        return _response.data

    async def vet(self, brand_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> VettingResults:
        """
        Submit a brand for external vetting verification to enhance your brand's trust score and improved message delivery rates.

        Parameters
        ----------
        brand_id : str
            The unique identifier of the brand to vet. <br>

            This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890` and must correspond to an existing brand in your account that is ready for vetting.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VettingResults
            Successfully initiated brand vetting process.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.brands.vet(
                brand_id="b_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.vet(brand_id, request_options=request_options)
        return _response.data
