# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.internal_server_error import InternalServerError
from ..errors.not_found_error import NotFoundError
from ..errors.not_implemented_error import NotImplementedError
from ..errors.payment_required_error import PaymentRequiredError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.company_sector_enum import CompanySectorEnum
from ..types.company_type_enum import CompanyTypeEnum
from ..types.error import Error
from ..types.extended_brand import ExtendedBrand
from ..types.extended_brand_with_vetting import ExtendedBrandWithVetting
from ..types.optional_brand_info import OptionalBrandInfo
from ..types.submission_results import SubmissionResults
from ..types.upsert_contact import UpsertContact
from ..types.validation_results import ValidationResults
from ..types.vetting_results import VettingResults
from .types.autofill_brand_options import AutofillBrandOptions
from .types.brand_contact import BrandContact

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawBrandsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def autofill(
        self,
        *,
        additional_info: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        options: typing.Optional[AutofillBrandOptions] = OMIT,
        website: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[OptionalBrandInfo]:
        """
        Automatically populate brand information based on partial input data you provide.

        Parameters
        ----------
        additional_info : typing.Optional[str]
            Any extra details about the brand to help improve data accuracy.

        name : typing.Optional[str]
            Name of the brand.

        options : typing.Optional[AutofillBrandOptions]

        website : typing.Optional[str]
            Brand's website URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[OptionalBrandInfo]
            Returns enriched brand information retrieved from the autofill service.
        """
        _response = self._client_wrapper.httpx_client.request(
            "brands/autofill",
            method="POST",
            json={
                "additional_info": additional_info,
                "name": name,
                "options": convert_and_respect_annotation_metadata(
                    object_=options, annotation=AutofillBrandOptions, direction="write"
                ),
                "website": website,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    OptionalBrandInfo,
                    parse_obj_as(
                        type_=OptionalBrandInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upsert(
        self,
        *,
        address: typing.Optional[str] = OMIT,
        contact: typing.Optional[UpsertContact] = OMIT,
        dba: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        ein: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        sector: typing.Optional[CompanySectorEnum] = OMIT,
        type: typing.Optional[CompanyTypeEnum] = OMIT,
        website: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ExtendedBrand]:
        """
        Create a new brand or update an existing brand by with the provided information.

        Parameters
        ----------
        address : typing.Optional[str]
            Primary brand address where the company is located.

        contact : typing.Optional[UpsertContact]
            Contact information for the brand.

        dba : typing.Optional[str]
            "Doing Business As" name - the public name the brand operates under.

        description : typing.Optional[str]
            Brief description of what the brand does.

        ein : typing.Optional[str]
            Brand's Employer Identification Number (EIN) assigned by the IRS.

        email : typing.Optional[str]
            Main contact email address for the brand.

        id : typing.Optional[str]
            The unique identifier of the brand you want to update.
            <br><br> This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        name : typing.Optional[str]
            Legal name of the brand as registered.

        sector : typing.Optional[CompanySectorEnum]
            Industry the brand operates in.

        type : typing.Optional[CompanyTypeEnum]
            Legal structure of the brand.

        website : typing.Optional[str]
            Brand website URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExtendedBrand]
            Successfully create/updated the brand.
        """
        _response = self._client_wrapper.httpx_client.request(
            "brands",
            method="POST",
            json={
                "address": address,
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact, annotation=typing.Optional[UpsertContact], direction="write"
                ),
                "dba": dba,
                "description": description,
                "ein": ein,
                "email": email,
                "id": id,
                "name": name,
                "sector": sector,
                "type": type,
                "website": website,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExtendedBrand,
                    parse_obj_as(
                        type_=ExtendedBrand,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self,
        id: str,
        *,
        hide_ein: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ExtendedBrandWithVetting]:
        """
        Retrieve detailed information for a specific brand in your account by ID.

        Parameters
        ----------
        id : str
            The unique identifier of the brand you want to retrieve from your account.
            <br><br> This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        hide_ein : typing.Optional[bool]
            Optional flag to mask the Employer Identification Number in the response for security purposes.<br>

            When you set this to true, the EIN value will be replaced with a masked placeholder instead of the actual number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExtendedBrandWithVetting]
            Returns the brand.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"brands/{jsonable_encoder(id)}",
            method="GET",
            params={
                "hideEIN": hide_ein,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExtendedBrandWithVetting,
                    parse_obj_as(
                        type_=ExtendedBrandWithVetting,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def submit(
        self, brand_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[SubmissionResults]:
        """
        Submit your brand for review and approval by the compliance team.

        Parameters
        ----------
        brand_id : str
            The unique identifier of the brand you want to submit for review. <br><br>
            This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890` and must correspond to an existing brand in your account that is ready for submission.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SubmissionResults]
            Successfully submitted brand information.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"brands/{jsonable_encoder(brand_id)}/submit",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SubmissionResults,
                    parse_obj_as(
                        type_=SubmissionResults,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def validate(
        self,
        *,
        address: str,
        contact: BrandContact,
        description: str,
        email: str,
        name: str,
        sector: CompanySectorEnum,
        type: CompanyTypeEnum,
        website: str,
        dba: typing.Optional[str] = OMIT,
        ein: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ValidationResults]:
        """
        Validate your brand information for compliance and correctness before submission or storage.

        Parameters
        ----------
        address : str
            Primary brand address where the brand is located.

        contact : BrandContact
            Contact information for the primary brand representative.

        description : str
            Brief description of what the brand does.

        email : str
            Main contact email address for the brand.

        name : str
            Legal name of the brand as registered.

        sector : CompanySectorEnum

        type : CompanyTypeEnum

        website : str
            Brand website URL.

        dba : typing.Optional[str]
            "Doing Business As" name - the public name the brand operates under.

        ein : typing.Optional[str]
            Employer Identification Number (EIN) assigned by the IRS.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ValidationResults]
            Returns the brand validation result.
        """
        _response = self._client_wrapper.httpx_client.request(
            "brands/validate",
            method="POST",
            json={
                "address": address,
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact, annotation=BrandContact, direction="write"
                ),
                "dba": dba,
                "description": description,
                "ein": ein,
                "email": email,
                "name": name,
                "sector": sector,
                "type": type,
                "website": website,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ValidationResults,
                    parse_obj_as(
                        type_=ValidationResults,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def vet(
        self, brand_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[VettingResults]:
        """
        Submit a brand for external vetting verification to enhance your brand's trust score and improved message delivery rates.

        Parameters
        ----------
        brand_id : str
            The unique identifier of the brand to vet. <br>

            This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890` and must correspond to an existing brand in your account that is ready for vetting.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[VettingResults]
            Successfully initiated brand vetting process.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"brands/{jsonable_encoder(brand_id)}/vet",
            method="POST",
            json={
                "type": "EXTERNAL",
                "provider": "AEGIS",
                "vettingClass": "STANDARD",
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    VettingResults,
                    parse_obj_as(
                        type_=VettingResults,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawBrandsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def autofill(
        self,
        *,
        additional_info: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        options: typing.Optional[AutofillBrandOptions] = OMIT,
        website: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[OptionalBrandInfo]:
        """
        Automatically populate brand information based on partial input data you provide.

        Parameters
        ----------
        additional_info : typing.Optional[str]
            Any extra details about the brand to help improve data accuracy.

        name : typing.Optional[str]
            Name of the brand.

        options : typing.Optional[AutofillBrandOptions]

        website : typing.Optional[str]
            Brand's website URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[OptionalBrandInfo]
            Returns enriched brand information retrieved from the autofill service.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "brands/autofill",
            method="POST",
            json={
                "additional_info": additional_info,
                "name": name,
                "options": convert_and_respect_annotation_metadata(
                    object_=options, annotation=AutofillBrandOptions, direction="write"
                ),
                "website": website,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    OptionalBrandInfo,
                    parse_obj_as(
                        type_=OptionalBrandInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upsert(
        self,
        *,
        address: typing.Optional[str] = OMIT,
        contact: typing.Optional[UpsertContact] = OMIT,
        dba: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        ein: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        sector: typing.Optional[CompanySectorEnum] = OMIT,
        type: typing.Optional[CompanyTypeEnum] = OMIT,
        website: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ExtendedBrand]:
        """
        Create a new brand or update an existing brand by with the provided information.

        Parameters
        ----------
        address : typing.Optional[str]
            Primary brand address where the company is located.

        contact : typing.Optional[UpsertContact]
            Contact information for the brand.

        dba : typing.Optional[str]
            "Doing Business As" name - the public name the brand operates under.

        description : typing.Optional[str]
            Brief description of what the brand does.

        ein : typing.Optional[str]
            Brand's Employer Identification Number (EIN) assigned by the IRS.

        email : typing.Optional[str]
            Main contact email address for the brand.

        id : typing.Optional[str]
            The unique identifier of the brand you want to update.
            <br><br> This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        name : typing.Optional[str]
            Legal name of the brand as registered.

        sector : typing.Optional[CompanySectorEnum]
            Industry the brand operates in.

        type : typing.Optional[CompanyTypeEnum]
            Legal structure of the brand.

        website : typing.Optional[str]
            Brand website URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExtendedBrand]
            Successfully create/updated the brand.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "brands",
            method="POST",
            json={
                "address": address,
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact, annotation=typing.Optional[UpsertContact], direction="write"
                ),
                "dba": dba,
                "description": description,
                "ein": ein,
                "email": email,
                "id": id,
                "name": name,
                "sector": sector,
                "type": type,
                "website": website,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExtendedBrand,
                    parse_obj_as(
                        type_=ExtendedBrand,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self,
        id: str,
        *,
        hide_ein: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ExtendedBrandWithVetting]:
        """
        Retrieve detailed information for a specific brand in your account by ID.

        Parameters
        ----------
        id : str
            The unique identifier of the brand you want to retrieve from your account.
            <br><br> This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        hide_ein : typing.Optional[bool]
            Optional flag to mask the Employer Identification Number in the response for security purposes.<br>

            When you set this to true, the EIN value will be replaced with a masked placeholder instead of the actual number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExtendedBrandWithVetting]
            Returns the brand.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"brands/{jsonable_encoder(id)}",
            method="GET",
            params={
                "hideEIN": hide_ein,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExtendedBrandWithVetting,
                    parse_obj_as(
                        type_=ExtendedBrandWithVetting,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def submit(
        self, brand_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[SubmissionResults]:
        """
        Submit your brand for review and approval by the compliance team.

        Parameters
        ----------
        brand_id : str
            The unique identifier of the brand you want to submit for review. <br><br>
            This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890` and must correspond to an existing brand in your account that is ready for submission.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SubmissionResults]
            Successfully submitted brand information.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"brands/{jsonable_encoder(brand_id)}/submit",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SubmissionResults,
                    parse_obj_as(
                        type_=SubmissionResults,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def validate(
        self,
        *,
        address: str,
        contact: BrandContact,
        description: str,
        email: str,
        name: str,
        sector: CompanySectorEnum,
        type: CompanyTypeEnum,
        website: str,
        dba: typing.Optional[str] = OMIT,
        ein: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ValidationResults]:
        """
        Validate your brand information for compliance and correctness before submission or storage.

        Parameters
        ----------
        address : str
            Primary brand address where the brand is located.

        contact : BrandContact
            Contact information for the primary brand representative.

        description : str
            Brief description of what the brand does.

        email : str
            Main contact email address for the brand.

        name : str
            Legal name of the brand as registered.

        sector : CompanySectorEnum

        type : CompanyTypeEnum

        website : str
            Brand website URL.

        dba : typing.Optional[str]
            "Doing Business As" name - the public name the brand operates under.

        ein : typing.Optional[str]
            Employer Identification Number (EIN) assigned by the IRS.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ValidationResults]
            Returns the brand validation result.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "brands/validate",
            method="POST",
            json={
                "address": address,
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact, annotation=BrandContact, direction="write"
                ),
                "dba": dba,
                "description": description,
                "ein": ein,
                "email": email,
                "name": name,
                "sector": sector,
                "type": type,
                "website": website,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ValidationResults,
                    parse_obj_as(
                        type_=ValidationResults,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def vet(
        self, brand_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[VettingResults]:
        """
        Submit a brand for external vetting verification to enhance your brand's trust score and improved message delivery rates.

        Parameters
        ----------
        brand_id : str
            The unique identifier of the brand to vet. <br>

            This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890` and must correspond to an existing brand in your account that is ready for vetting.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[VettingResults]
            Successfully initiated brand vetting process.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"brands/{jsonable_encoder(brand_id)}/vet",
            method="POST",
            json={
                "type": "EXTERNAL",
                "provider": "AEGIS",
                "vettingClass": "STANDARD",
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    VettingResults,
                    parse_obj_as(
                        type_=VettingResults,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
