# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class BrandContact(UniversalBaseModel):
    """
    Contact information for the primary brand representative.
    """

    email: str = pydantic.Field()
    """
    Email address of the contact person.
    """

    name: str = pydantic.Field()
    """
    Full name of the contact person.
    """

    phone: str = pydantic.Field()
    """
    Phone number of the contact person in E.164 format.
    """

    title: str = pydantic.Field()
    """
    Job title or position of the contact person.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
