# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawCampaignsClient, RawCampaignsClient

if typing.TYPE_CHECKING:
    from .dlc.client import AsyncDlcClient, DlcClient
    from .rcs.client import AsyncRcsClient, RcsClient
    from .toll_free.client import AsyncTollFreeClient, TollFreeClient


class CampaignsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCampaignsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._dlc: typing.Optional[DlcClient] = None
        self._toll_free: typing.Optional[TollFreeClient] = None
        self._rcs: typing.Optional[RcsClient] = None

    @property
    def with_raw_response(self) -> RawCampaignsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCampaignsClient
        """
        return self._raw_client

    @property
    def dlc(self):
        if self._dlc is None:
            from .dlc.client import DlcClient  # noqa: E402

            self._dlc = DlcClient(client_wrapper=self._client_wrapper)
        return self._dlc

    @property
    def toll_free(self):
        if self._toll_free is None:
            from .toll_free.client import TollFreeClient  # noqa: E402

            self._toll_free = TollFreeClient(client_wrapper=self._client_wrapper)
        return self._toll_free

    @property
    def rcs(self):
        if self._rcs is None:
            from .rcs.client import RcsClient  # noqa: E402

            self._rcs = RcsClient(client_wrapper=self._client_wrapper)
        return self._rcs


class AsyncCampaignsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCampaignsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._dlc: typing.Optional[AsyncDlcClient] = None
        self._toll_free: typing.Optional[AsyncTollFreeClient] = None
        self._rcs: typing.Optional[AsyncRcsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawCampaignsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCampaignsClient
        """
        return self._raw_client

    @property
    def dlc(self):
        if self._dlc is None:
            from .dlc.client import AsyncDlcClient  # noqa: E402

            self._dlc = AsyncDlcClient(client_wrapper=self._client_wrapper)
        return self._dlc

    @property
    def toll_free(self):
        if self._toll_free is None:
            from .toll_free.client import AsyncTollFreeClient  # noqa: E402

            self._toll_free = AsyncTollFreeClient(client_wrapper=self._client_wrapper)
        return self._toll_free

    @property
    def rcs(self):
        if self._rcs is None:
            from .rcs.client import AsyncRcsClient  # noqa: E402

            self._rcs = AsyncRcsClient(client_wrapper=self._client_wrapper)
        return self._rcs
