# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.autofill_dlc_campaign_response import AutofillDlcCampaignResponse
from ...types.campaign_submission_result import CampaignSubmissionResult
from ...types.campaign_validation_result import CampaignValidationResult
from ...types.dlc_campaign_with_extended_brand_and_status import DlcCampaignWithExtendedBrandAndStatus
from .raw_client import AsyncRawDlcClient, RawDlcClient
from .types.upsert_dlc_campaign_keywords import UpsertDlcCampaignKeywords
from .types.upsert_dlc_campaign_links import UpsertDlcCampaignLinks
from .types.upsert_dlc_campaign_options import UpsertDlcCampaignOptions
from .types.upsert_dlc_campaign_use_case import UpsertDlcCampaignUseCase

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DlcClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDlcClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDlcClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDlcClient
        """
        return self._raw_client

    def autofill(
        self,
        *,
        additional_info: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AutofillDlcCampaignResponse:
        """
        Generate campaign details based off existing campaign and the brand it's connected to.

        Parameters
        ----------
        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign.
            - When autofilling 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When autofilling Toll-Free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When autofilling RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutofillDlcCampaignResponse
            Returns autofilled 10DLC information.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.dlc.autofill(
            additional_info="Please autofill missing campaign fields using my brand profile",
            campaign_id="dlc_1234567890",
        )
        """
        _response = self._raw_client.autofill(
            additional_info=additional_info, campaign_id=campaign_id, request_options=request_options
        )
        return _response.data

    def get(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DlcCampaignWithExtendedBrandAndStatus:
        """
        Retrieve 10DLC campaign.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the 10DLC campaign. This identifier is a string that always begins with the prefix `dlc_`, for example: `dlc_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DlcCampaignWithExtendedBrandAndStatus
            Successfully retrieved.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.dlc.get(
            campaign_id="dlc_1234567890",
        )
        """
        _response = self._raw_client.get(campaign_id, request_options=request_options)
        return _response.data

    def submit(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CampaignSubmissionResult:
        """
        Submit your 10DLC campaign for approval and activation with carriers.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the 10DLC campaign to submit.
            <br><br> This identifier is a string that always begins with the prefix `dlc_`, for example: `dlc_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CampaignSubmissionResult
            Successfully submitted 10DLC campaign for approval.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.dlc.submit(
            campaign_id="dlc_1234567890",
        )
        """
        _response = self._raw_client.submit(campaign_id, request_options=request_options)
        return _response.data

    def upsert(
        self,
        *,
        auto_renew: typing.Optional[bool] = OMIT,
        brand: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        keywords: typing.Optional[UpsertDlcCampaignKeywords] = OMIT,
        links: typing.Optional[UpsertDlcCampaignLinks] = OMIT,
        message_flow: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        options: typing.Optional[UpsertDlcCampaignOptions] = OMIT,
        sample_messages: typing.Optional[typing.Sequence[str]] = OMIT,
        use_case: typing.Optional[UpsertDlcCampaignUseCase] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DlcCampaignWithExtendedBrandAndStatus:
        """
        Create a new 10DLC campaign or updates an existing one. <br>

        Omit campaignId to create a campaign.

        Parameters
        ----------
        auto_renew : typing.Optional[bool]
            Whether the campaign renews automatically.

        brand : typing.Optional[str]
            Brand id. This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign. This identifier is a string that always begins with the prefix `dlc_`, for example: `dlc_1234567890`.

        description : typing.Optional[str]
            Description of the campaign.

        keywords : typing.Optional[UpsertDlcCampaignKeywords]
            Keyword response configuration.

        links : typing.Optional[UpsertDlcCampaignLinks]
            Legal documentation links.

        message_flow : typing.Optional[str]
            Describe the flow of how users will opt in to this campaign.

        name : typing.Optional[str]
            Display name of the campaign.

        options : typing.Optional[UpsertDlcCampaignOptions]
            Campaign configuration options.

        sample_messages : typing.Optional[typing.Sequence[str]]
            Example messages for the campaign.

        use_case : typing.Optional[UpsertDlcCampaignUseCase]
            Use case for the campaign.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DlcCampaignWithExtendedBrandAndStatus
            Successfully created or updated DLC campaign.

        Examples
        --------
        from rcs import Pinnacle
        from rcs.campaigns.dlc import (
            UpsertDlcCampaignHelpKeywords,
            UpsertDlcCampaignKeywords,
            UpsertDlcCampaignLinks,
            UpsertDlcCampaignOptInKeywords,
            UpsertDlcCampaignOptions,
            UpsertDlcCampaignOptOutKeywords,
            UpsertDlcCampaignUseCase,
        )

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.dlc.upsert(
            auto_renew=True,
            brand="b_1234567890",
            campaign_id="dlc_1234567890",
            keywords=UpsertDlcCampaignKeywords(
                help=UpsertDlcCampaignHelpKeywords(
                    message="Reply HELP for assistance, STOP to opt-out",
                    values=["HELP", "INFO", "SUPPORT"],
                ),
                opt_in=UpsertDlcCampaignOptInKeywords(
                    message="Welcome. You are now subscribed to Pinnacle.",
                    values=["JOIN", "START", "SUBSCRIBE"],
                ),
                opt_out=UpsertDlcCampaignOptOutKeywords(
                    message="You have been unsubscribed. Reply START to rejoin.",
                    values=["STOP", "QUIT", "UNSUBSCRIBE"],
                ),
            ),
            links=UpsertDlcCampaignLinks(
                privacy_policy="https://www.pinnacle.sh/privacy",
                terms_of_service="https://www.pinnacle.sh/terms",
            ),
            message_flow="Customer initiates -> Automated response -> Agent follow-up if needed",
            name="Account Notifications",
            options=UpsertDlcCampaignOptions(
                affiliate_marketing=False,
                age_gated=False,
                direct_lending=False,
                embedded_link="https://www.pinnacle.sh/example",
                embedded_phone=False,
                number_pooling=False,
            ),
            sample_messages=["Security alert: Unusual login detected from new device."],
            use_case=UpsertDlcCampaignUseCase(
                sub=["FRAUD_ALERT"],
                value="ACCOUNT_NOTIFICATION",
            ),
        )
        """
        _response = self._raw_client.upsert(
            auto_renew=auto_renew,
            brand=brand,
            campaign_id=campaign_id,
            description=description,
            keywords=keywords,
            links=links,
            message_flow=message_flow,
            name=name,
            options=options,
            sample_messages=sample_messages,
            use_case=use_case,
            request_options=request_options,
        )
        return _response.data

    def validate(
        self,
        *,
        campaign_id: str,
        additional_info: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CampaignValidationResult:
        """
        Validate your 10DLC campaign configuration against carrier requirements and compliance rules.

        Parameters
        ----------
        campaign_id : str
            Unique identifier for the campaign.
            - When validating 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When validating toll-free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When validating RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CampaignValidationResult
            Returns validation results.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.dlc.validate(
            additional_info="Please validate this DLC campaign for 10DLC compliance",
            campaign_id="dlc_1234567890",
        )
        """
        _response = self._raw_client.validate(
            campaign_id=campaign_id, additional_info=additional_info, request_options=request_options
        )
        return _response.data


class AsyncDlcClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDlcClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDlcClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDlcClient
        """
        return self._raw_client

    async def autofill(
        self,
        *,
        additional_info: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AutofillDlcCampaignResponse:
        """
        Generate campaign details based off existing campaign and the brand it's connected to.

        Parameters
        ----------
        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign.
            - When autofilling 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When autofilling Toll-Free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When autofilling RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AutofillDlcCampaignResponse
            Returns autofilled 10DLC information.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.dlc.autofill(
                additional_info="Please autofill missing campaign fields using my brand profile",
                campaign_id="dlc_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.autofill(
            additional_info=additional_info, campaign_id=campaign_id, request_options=request_options
        )
        return _response.data

    async def get(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DlcCampaignWithExtendedBrandAndStatus:
        """
        Retrieve 10DLC campaign.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the 10DLC campaign. This identifier is a string that always begins with the prefix `dlc_`, for example: `dlc_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DlcCampaignWithExtendedBrandAndStatus
            Successfully retrieved.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.dlc.get(
                campaign_id="dlc_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(campaign_id, request_options=request_options)
        return _response.data

    async def submit(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CampaignSubmissionResult:
        """
        Submit your 10DLC campaign for approval and activation with carriers.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the 10DLC campaign to submit.
            <br><br> This identifier is a string that always begins with the prefix `dlc_`, for example: `dlc_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CampaignSubmissionResult
            Successfully submitted 10DLC campaign for approval.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.dlc.submit(
                campaign_id="dlc_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.submit(campaign_id, request_options=request_options)
        return _response.data

    async def upsert(
        self,
        *,
        auto_renew: typing.Optional[bool] = OMIT,
        brand: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        keywords: typing.Optional[UpsertDlcCampaignKeywords] = OMIT,
        links: typing.Optional[UpsertDlcCampaignLinks] = OMIT,
        message_flow: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        options: typing.Optional[UpsertDlcCampaignOptions] = OMIT,
        sample_messages: typing.Optional[typing.Sequence[str]] = OMIT,
        use_case: typing.Optional[UpsertDlcCampaignUseCase] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DlcCampaignWithExtendedBrandAndStatus:
        """
        Create a new 10DLC campaign or updates an existing one. <br>

        Omit campaignId to create a campaign.

        Parameters
        ----------
        auto_renew : typing.Optional[bool]
            Whether the campaign renews automatically.

        brand : typing.Optional[str]
            Brand id. This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign. This identifier is a string that always begins with the prefix `dlc_`, for example: `dlc_1234567890`.

        description : typing.Optional[str]
            Description of the campaign.

        keywords : typing.Optional[UpsertDlcCampaignKeywords]
            Keyword response configuration.

        links : typing.Optional[UpsertDlcCampaignLinks]
            Legal documentation links.

        message_flow : typing.Optional[str]
            Describe the flow of how users will opt in to this campaign.

        name : typing.Optional[str]
            Display name of the campaign.

        options : typing.Optional[UpsertDlcCampaignOptions]
            Campaign configuration options.

        sample_messages : typing.Optional[typing.Sequence[str]]
            Example messages for the campaign.

        use_case : typing.Optional[UpsertDlcCampaignUseCase]
            Use case for the campaign.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DlcCampaignWithExtendedBrandAndStatus
            Successfully created or updated DLC campaign.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle
        from rcs.campaigns.dlc import (
            UpsertDlcCampaignHelpKeywords,
            UpsertDlcCampaignKeywords,
            UpsertDlcCampaignLinks,
            UpsertDlcCampaignOptInKeywords,
            UpsertDlcCampaignOptions,
            UpsertDlcCampaignOptOutKeywords,
            UpsertDlcCampaignUseCase,
        )

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.dlc.upsert(
                auto_renew=True,
                brand="b_1234567890",
                campaign_id="dlc_1234567890",
                keywords=UpsertDlcCampaignKeywords(
                    help=UpsertDlcCampaignHelpKeywords(
                        message="Reply HELP for assistance, STOP to opt-out",
                        values=["HELP", "INFO", "SUPPORT"],
                    ),
                    opt_in=UpsertDlcCampaignOptInKeywords(
                        message="Welcome. You are now subscribed to Pinnacle.",
                        values=["JOIN", "START", "SUBSCRIBE"],
                    ),
                    opt_out=UpsertDlcCampaignOptOutKeywords(
                        message="You have been unsubscribed. Reply START to rejoin.",
                        values=["STOP", "QUIT", "UNSUBSCRIBE"],
                    ),
                ),
                links=UpsertDlcCampaignLinks(
                    privacy_policy="https://www.pinnacle.sh/privacy",
                    terms_of_service="https://www.pinnacle.sh/terms",
                ),
                message_flow="Customer initiates -> Automated response -> Agent follow-up if needed",
                name="Account Notifications",
                options=UpsertDlcCampaignOptions(
                    affiliate_marketing=False,
                    age_gated=False,
                    direct_lending=False,
                    embedded_link="https://www.pinnacle.sh/example",
                    embedded_phone=False,
                    number_pooling=False,
                ),
                sample_messages=[
                    "Security alert: Unusual login detected from new device."
                ],
                use_case=UpsertDlcCampaignUseCase(
                    sub=["FRAUD_ALERT"],
                    value="ACCOUNT_NOTIFICATION",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upsert(
            auto_renew=auto_renew,
            brand=brand,
            campaign_id=campaign_id,
            description=description,
            keywords=keywords,
            links=links,
            message_flow=message_flow,
            name=name,
            options=options,
            sample_messages=sample_messages,
            use_case=use_case,
            request_options=request_options,
        )
        return _response.data

    async def validate(
        self,
        *,
        campaign_id: str,
        additional_info: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CampaignValidationResult:
        """
        Validate your 10DLC campaign configuration against carrier requirements and compliance rules.

        Parameters
        ----------
        campaign_id : str
            Unique identifier for the campaign.
            - When validating 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When validating toll-free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When validating RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CampaignValidationResult
            Returns validation results.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.dlc.validate(
                additional_info="Please validate this DLC campaign for 10DLC compliance",
                campaign_id="dlc_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.validate(
            campaign_id=campaign_id, additional_info=additional_info, request_options=request_options
        )
        return _response.data
