# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.campaign_submission_result import CampaignSubmissionResult
from ...types.campaign_validation_result import CampaignValidationResult
from ...types.extended_rcs_campaign import ExtendedRcsCampaign
from .raw_client import AsyncRawRcsClient, RawRcsClient
from .types.rcs_autofill_response import RcsAutofillResponse
from .types.upsert_rcs_agent import UpsertRcsAgent
from .types.upsert_rcs_links import UpsertRcsLinks
from .types.upsert_rcs_opt_in import UpsertRcsOptIn
from .types.upsert_rcs_opt_out import UpsertRcsOptOut
from .types.upsert_rcs_use_case import UpsertRcsUseCase

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RcsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRcsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRcsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRcsClient
        """
        return self._raw_client

    def autofill(
        self,
        *,
        additional_info: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RcsAutofillResponse:
        """
        Generate campaign details based off existing campaign and the brand it's connected to.

        Parameters
        ----------
        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign.
            - When autofilling 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When autofilling Toll-Free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When autofilling RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsAutofillResponse
            Returns autofilled RCS information.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.rcs.autofill(
            additional_info="Please autofill missing campaign fields using my brand profile",
            campaign_id="dlc_1234567890",
        )
        """
        _response = self._raw_client.autofill(
            additional_info=additional_info, campaign_id=campaign_id, request_options=request_options
        )
        return _response.data

    def get(self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ExtendedRcsCampaign:
        """
        Retrieve RCS campaign.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the RCS campaign. Must begin with the prefix `rcs_`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtendedRcsCampaign
            Successfully retrieved.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.rcs.get(
            campaign_id="rcs_1234567890",
        )
        """
        _response = self._raw_client.get(campaign_id, request_options=request_options)
        return _response.data

    def submit(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CampaignSubmissionResult:
        """
        Submit your RCS campaign for approval and activation with carriers.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the RCS campaign to retrieve. Must begin with the prefix `rcs_`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CampaignSubmissionResult
            Successfully submitted RCS campaign for approval.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.rcs.submit(
            campaign_id="rcs_1234567890",
        )
        """
        _response = self._raw_client.submit(campaign_id, request_options=request_options)
        return _response.data

    def upsert(
        self,
        *,
        agent: typing.Optional[UpsertRcsAgent] = OMIT,
        brand_verification_url: typing.Optional[str] = OMIT,
        brand: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        expected_agent_responses: typing.Optional[typing.Sequence[str]] = OMIT,
        links: typing.Optional[UpsertRcsLinks] = OMIT,
        opt_in: typing.Optional[UpsertRcsOptIn] = OMIT,
        opt_out: typing.Optional[UpsertRcsOptOut] = OMIT,
        use_case: typing.Optional[UpsertRcsUseCase] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtendedRcsCampaign:
        """
        Create a new RCS campaign or updates an existing one. <br>

        Omit campaignId to create a campaign.

        Parameters
        ----------
        agent : typing.Optional[UpsertRcsAgent]
            Create an agent for the campaign.

        brand_verification_url : typing.Optional[str]
            Link to document verifying the brand's name. This may be the certificate of incorporation, business license, or other relevant document. You can typically find this on the Secretary of State website.

        brand : typing.Optional[str]
            Unique identifier for the brand.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign.

        expected_agent_responses : typing.Optional[typing.Sequence[str]]
            List of what the agent might say to users (1-5 required).

        links : typing.Optional[UpsertRcsLinks]
            Legal documentation links.

        opt_in : typing.Optional[UpsertRcsOptIn]
            Opt-in configuration.

        opt_out : typing.Optional[UpsertRcsOptOut]
            Opt-out configuration.

        use_case : typing.Optional[UpsertRcsUseCase]
            Use case classification for the campaign.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtendedRcsCampaign
            Successfully created or updated RCS campaign.

        Examples
        --------
        from rcs import Pinnacle
        from rcs.campaigns.rcs import (
            RcsAgentEmail,
            RcsAgentPhone,
            RcsAgentWebsite,
            UpsertRcsAgent,
            UpsertRcsLinks,
            UpsertRcsOptIn,
            UpsertRcsOptOut,
            UpsertRcsUseCase,
        )

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.rcs.upsert(
            agent=UpsertRcsAgent(
                color="#000000",
                description="Engaging campaigns with RBM – next-gen SMS marketing with rich content and better analytics.",
                emails=[
                    RcsAgentEmail(
                        email="founders@trypinnacle.app",
                        label="Email Us",
                    )
                ],
                hero_url="https://agent-logos.storage.googleapis.com/_/m0bk9mmw7kfynqiKSPfsaoc6",
                icon_url="https://agent-logos.storage.googleapis.com/_/m0bk9gvlDunZEw1krfruZmw3",
                name="Pinnacle Software Development",
                phones=[
                    RcsAgentPhone(
                        label="Contact us directly",
                        phone="+14154467821",
                    )
                ],
                websites=[
                    RcsAgentWebsite(
                        label="Get started with Pinnacle",
                        url="https://www.trypinnacle.app/",
                    )
                ],
            ),
            brand_verification_url="https://www.pinnacle.sh/articles-of-incorporation.pdf",
            brand="b_1234567890",
            campaign_id="rcs_1234567890",
            expected_agent_responses=[
                "Here are the things I can help you with.",
                "I can assist you with booking an appointment, or you may choose to book manually.",
                "Here are the available times to connect with a representative tomorrow.",
                "Your appointment has been scheduled.",
            ],
            links=UpsertRcsLinks(
                privacy_policy="https://www.trypinnacle.app/privacy",
                terms_of_service="https://www.trypinnacle.app/terms",
            ),
            opt_in=UpsertRcsOptIn(
                method="WEBSITE",
                terms_and_conditions="Would you like to subscribe to Pinnacle?",
            ),
            opt_out=UpsertRcsOptOut(
                description="Reply STOP to opt-out anytime.",
                keywords=["STOP", "UNSUBSCRIBE", "END"],
            ),
            use_case=UpsertRcsUseCase(
                behavior="Acts as a customer service representative.",
                value="OTHER",
            ),
        )
        """
        _response = self._raw_client.upsert(
            agent=agent,
            brand_verification_url=brand_verification_url,
            brand=brand,
            campaign_id=campaign_id,
            expected_agent_responses=expected_agent_responses,
            links=links,
            opt_in=opt_in,
            opt_out=opt_out,
            use_case=use_case,
            request_options=request_options,
        )
        return _response.data

    def validate(
        self,
        *,
        campaign_id: str,
        additional_info: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CampaignValidationResult:
        """
        Validate your RCS campaign configuration against carrier requirements and compliance rules.

        Parameters
        ----------
        campaign_id : str
            Unique identifier for the campaign.
            - When validating 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When validating toll-free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When validating RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CampaignValidationResult
            Returns validation results.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.rcs.validate(
            additional_info="Please validate this DLC campaign for 10DLC compliance",
            campaign_id="dlc_1234567890",
        )
        """
        _response = self._raw_client.validate(
            campaign_id=campaign_id, additional_info=additional_info, request_options=request_options
        )
        return _response.data


class AsyncRcsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRcsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRcsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRcsClient
        """
        return self._raw_client

    async def autofill(
        self,
        *,
        additional_info: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RcsAutofillResponse:
        """
        Generate campaign details based off existing campaign and the brand it's connected to.

        Parameters
        ----------
        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign.
            - When autofilling 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When autofilling Toll-Free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When autofilling RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsAutofillResponse
            Returns autofilled RCS information.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.rcs.autofill(
                additional_info="Please autofill missing campaign fields using my brand profile",
                campaign_id="dlc_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.autofill(
            additional_info=additional_info, campaign_id=campaign_id, request_options=request_options
        )
        return _response.data

    async def get(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ExtendedRcsCampaign:
        """
        Retrieve RCS campaign.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the RCS campaign. Must begin with the prefix `rcs_`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtendedRcsCampaign
            Successfully retrieved.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.rcs.get(
                campaign_id="rcs_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(campaign_id, request_options=request_options)
        return _response.data

    async def submit(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CampaignSubmissionResult:
        """
        Submit your RCS campaign for approval and activation with carriers.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the RCS campaign to retrieve. Must begin with the prefix `rcs_`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CampaignSubmissionResult
            Successfully submitted RCS campaign for approval.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.rcs.submit(
                campaign_id="rcs_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.submit(campaign_id, request_options=request_options)
        return _response.data

    async def upsert(
        self,
        *,
        agent: typing.Optional[UpsertRcsAgent] = OMIT,
        brand_verification_url: typing.Optional[str] = OMIT,
        brand: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        expected_agent_responses: typing.Optional[typing.Sequence[str]] = OMIT,
        links: typing.Optional[UpsertRcsLinks] = OMIT,
        opt_in: typing.Optional[UpsertRcsOptIn] = OMIT,
        opt_out: typing.Optional[UpsertRcsOptOut] = OMIT,
        use_case: typing.Optional[UpsertRcsUseCase] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtendedRcsCampaign:
        """
        Create a new RCS campaign or updates an existing one. <br>

        Omit campaignId to create a campaign.

        Parameters
        ----------
        agent : typing.Optional[UpsertRcsAgent]
            Create an agent for the campaign.

        brand_verification_url : typing.Optional[str]
            Link to document verifying the brand's name. This may be the certificate of incorporation, business license, or other relevant document. You can typically find this on the Secretary of State website.

        brand : typing.Optional[str]
            Unique identifier for the brand.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign.

        expected_agent_responses : typing.Optional[typing.Sequence[str]]
            List of what the agent might say to users (1-5 required).

        links : typing.Optional[UpsertRcsLinks]
            Legal documentation links.

        opt_in : typing.Optional[UpsertRcsOptIn]
            Opt-in configuration.

        opt_out : typing.Optional[UpsertRcsOptOut]
            Opt-out configuration.

        use_case : typing.Optional[UpsertRcsUseCase]
            Use case classification for the campaign.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtendedRcsCampaign
            Successfully created or updated RCS campaign.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle
        from rcs.campaigns.rcs import (
            RcsAgentEmail,
            RcsAgentPhone,
            RcsAgentWebsite,
            UpsertRcsAgent,
            UpsertRcsLinks,
            UpsertRcsOptIn,
            UpsertRcsOptOut,
            UpsertRcsUseCase,
        )

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.rcs.upsert(
                agent=UpsertRcsAgent(
                    color="#000000",
                    description="Engaging campaigns with RBM – next-gen SMS marketing with rich content and better analytics.",
                    emails=[
                        RcsAgentEmail(
                            email="founders@trypinnacle.app",
                            label="Email Us",
                        )
                    ],
                    hero_url="https://agent-logos.storage.googleapis.com/_/m0bk9mmw7kfynqiKSPfsaoc6",
                    icon_url="https://agent-logos.storage.googleapis.com/_/m0bk9gvlDunZEw1krfruZmw3",
                    name="Pinnacle Software Development",
                    phones=[
                        RcsAgentPhone(
                            label="Contact us directly",
                            phone="+14154467821",
                        )
                    ],
                    websites=[
                        RcsAgentWebsite(
                            label="Get started with Pinnacle",
                            url="https://www.trypinnacle.app/",
                        )
                    ],
                ),
                brand_verification_url="https://www.pinnacle.sh/articles-of-incorporation.pdf",
                brand="b_1234567890",
                campaign_id="rcs_1234567890",
                expected_agent_responses=[
                    "Here are the things I can help you with.",
                    "I can assist you with booking an appointment, or you may choose to book manually.",
                    "Here are the available times to connect with a representative tomorrow.",
                    "Your appointment has been scheduled.",
                ],
                links=UpsertRcsLinks(
                    privacy_policy="https://www.trypinnacle.app/privacy",
                    terms_of_service="https://www.trypinnacle.app/terms",
                ),
                opt_in=UpsertRcsOptIn(
                    method="WEBSITE",
                    terms_and_conditions="Would you like to subscribe to Pinnacle?",
                ),
                opt_out=UpsertRcsOptOut(
                    description="Reply STOP to opt-out anytime.",
                    keywords=["STOP", "UNSUBSCRIBE", "END"],
                ),
                use_case=UpsertRcsUseCase(
                    behavior="Acts as a customer service representative.",
                    value="OTHER",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upsert(
            agent=agent,
            brand_verification_url=brand_verification_url,
            brand=brand,
            campaign_id=campaign_id,
            expected_agent_responses=expected_agent_responses,
            links=links,
            opt_in=opt_in,
            opt_out=opt_out,
            use_case=use_case,
            request_options=request_options,
        )
        return _response.data

    async def validate(
        self,
        *,
        campaign_id: str,
        additional_info: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CampaignValidationResult:
        """
        Validate your RCS campaign configuration against carrier requirements and compliance rules.

        Parameters
        ----------
        campaign_id : str
            Unique identifier for the campaign.
            - When validating 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When validating toll-free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When validating RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CampaignValidationResult
            Returns validation results.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.rcs.validate(
                additional_info="Please validate this DLC campaign for 10DLC compliance",
                campaign_id="dlc_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.validate(
            campaign_id=campaign_id, additional_info=additional_info, request_options=request_options
        )
        return _response.data
