# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.internal_server_error import InternalServerError
from ...errors.not_found_error import NotFoundError
from ...errors.payment_required_error import PaymentRequiredError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.campaign_submission_result import CampaignSubmissionResult
from ...types.campaign_validation_result import CampaignValidationResult
from ...types.error import Error
from ...types.extended_rcs_campaign import ExtendedRcsCampaign
from .types.rcs_autofill_response import RcsAutofillResponse
from .types.upsert_rcs_agent import UpsertRcsAgent
from .types.upsert_rcs_links import UpsertRcsLinks
from .types.upsert_rcs_opt_in import UpsertRcsOptIn
from .types.upsert_rcs_opt_out import UpsertRcsOptOut
from .types.upsert_rcs_use_case import UpsertRcsUseCase

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawRcsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def autofill(
        self,
        *,
        additional_info: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[RcsAutofillResponse]:
        """
        Generate campaign details based off existing campaign and the brand it's connected to.

        Parameters
        ----------
        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign.
            - When autofilling 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When autofilling Toll-Free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When autofilling RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[RcsAutofillResponse]
            Returns autofilled RCS information.
        """
        _response = self._client_wrapper.httpx_client.request(
            "campaigns/rcs/autofill",
            method="POST",
            json={
                "additionalInfo": additional_info,
                "campaignId": campaign_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    RcsAutofillResponse,
                    parse_obj_as(
                        type_=RcsAutofillResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ExtendedRcsCampaign]:
        """
        Retrieve RCS campaign.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the RCS campaign. Must begin with the prefix `rcs_`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExtendedRcsCampaign]
            Successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"campaigns/rcs/{jsonable_encoder(campaign_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExtendedRcsCampaign,
                    parse_obj_as(
                        type_=ExtendedRcsCampaign,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def submit(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CampaignSubmissionResult]:
        """
        Submit your RCS campaign for approval and activation with carriers.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the RCS campaign to retrieve. Must begin with the prefix `rcs_`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CampaignSubmissionResult]
            Successfully submitted RCS campaign for approval.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"campaigns/rcs/submit/{jsonable_encoder(campaign_id)}",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CampaignSubmissionResult,
                    parse_obj_as(
                        type_=CampaignSubmissionResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upsert(
        self,
        *,
        agent: typing.Optional[UpsertRcsAgent] = OMIT,
        brand_verification_url: typing.Optional[str] = OMIT,
        brand: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        expected_agent_responses: typing.Optional[typing.Sequence[str]] = OMIT,
        links: typing.Optional[UpsertRcsLinks] = OMIT,
        opt_in: typing.Optional[UpsertRcsOptIn] = OMIT,
        opt_out: typing.Optional[UpsertRcsOptOut] = OMIT,
        use_case: typing.Optional[UpsertRcsUseCase] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ExtendedRcsCampaign]:
        """
        Create a new RCS campaign or updates an existing one. <br>

        Omit campaignId to create a campaign.

        Parameters
        ----------
        agent : typing.Optional[UpsertRcsAgent]
            Create an agent for the campaign.

        brand_verification_url : typing.Optional[str]
            Link to document verifying the brand's name. This may be the certificate of incorporation, business license, or other relevant document. You can typically find this on the Secretary of State website.

        brand : typing.Optional[str]
            Unique identifier for the brand.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign.

        expected_agent_responses : typing.Optional[typing.Sequence[str]]
            List of what the agent might say to users (1-5 required).

        links : typing.Optional[UpsertRcsLinks]
            Legal documentation links.

        opt_in : typing.Optional[UpsertRcsOptIn]
            Opt-in configuration.

        opt_out : typing.Optional[UpsertRcsOptOut]
            Opt-out configuration.

        use_case : typing.Optional[UpsertRcsUseCase]
            Use case classification for the campaign.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExtendedRcsCampaign]
            Successfully created or updated RCS campaign.
        """
        _response = self._client_wrapper.httpx_client.request(
            "campaigns/rcs",
            method="POST",
            json={
                "agent": convert_and_respect_annotation_metadata(
                    object_=agent, annotation=UpsertRcsAgent, direction="write"
                ),
                "brandVerificationUrl": brand_verification_url,
                "brand": brand,
                "campaignId": campaign_id,
                "expectedAgentResponses": expected_agent_responses,
                "links": convert_and_respect_annotation_metadata(
                    object_=links, annotation=UpsertRcsLinks, direction="write"
                ),
                "optIn": convert_and_respect_annotation_metadata(
                    object_=opt_in, annotation=UpsertRcsOptIn, direction="write"
                ),
                "optOut": convert_and_respect_annotation_metadata(
                    object_=opt_out, annotation=UpsertRcsOptOut, direction="write"
                ),
                "useCase": convert_and_respect_annotation_metadata(
                    object_=use_case, annotation=UpsertRcsUseCase, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExtendedRcsCampaign,
                    parse_obj_as(
                        type_=ExtendedRcsCampaign,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def validate(
        self,
        *,
        campaign_id: str,
        additional_info: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CampaignValidationResult]:
        """
        Validate your RCS campaign configuration against carrier requirements and compliance rules.

        Parameters
        ----------
        campaign_id : str
            Unique identifier for the campaign.
            - When validating 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When validating toll-free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When validating RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CampaignValidationResult]
            Returns validation results.
        """
        _response = self._client_wrapper.httpx_client.request(
            "campaigns/rcs/validate",
            method="POST",
            json={
                "additionalInfo": additional_info,
                "campaignId": campaign_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CampaignValidationResult,
                    parse_obj_as(
                        type_=CampaignValidationResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawRcsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def autofill(
        self,
        *,
        additional_info: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[RcsAutofillResponse]:
        """
        Generate campaign details based off existing campaign and the brand it's connected to.

        Parameters
        ----------
        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign.
            - When autofilling 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When autofilling Toll-Free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When autofilling RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[RcsAutofillResponse]
            Returns autofilled RCS information.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "campaigns/rcs/autofill",
            method="POST",
            json={
                "additionalInfo": additional_info,
                "campaignId": campaign_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    RcsAutofillResponse,
                    parse_obj_as(
                        type_=RcsAutofillResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ExtendedRcsCampaign]:
        """
        Retrieve RCS campaign.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the RCS campaign. Must begin with the prefix `rcs_`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExtendedRcsCampaign]
            Successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"campaigns/rcs/{jsonable_encoder(campaign_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExtendedRcsCampaign,
                    parse_obj_as(
                        type_=ExtendedRcsCampaign,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def submit(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CampaignSubmissionResult]:
        """
        Submit your RCS campaign for approval and activation with carriers.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the RCS campaign to retrieve. Must begin with the prefix `rcs_`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CampaignSubmissionResult]
            Successfully submitted RCS campaign for approval.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"campaigns/rcs/submit/{jsonable_encoder(campaign_id)}",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CampaignSubmissionResult,
                    parse_obj_as(
                        type_=CampaignSubmissionResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 402:
                raise PaymentRequiredError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upsert(
        self,
        *,
        agent: typing.Optional[UpsertRcsAgent] = OMIT,
        brand_verification_url: typing.Optional[str] = OMIT,
        brand: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        expected_agent_responses: typing.Optional[typing.Sequence[str]] = OMIT,
        links: typing.Optional[UpsertRcsLinks] = OMIT,
        opt_in: typing.Optional[UpsertRcsOptIn] = OMIT,
        opt_out: typing.Optional[UpsertRcsOptOut] = OMIT,
        use_case: typing.Optional[UpsertRcsUseCase] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ExtendedRcsCampaign]:
        """
        Create a new RCS campaign or updates an existing one. <br>

        Omit campaignId to create a campaign.

        Parameters
        ----------
        agent : typing.Optional[UpsertRcsAgent]
            Create an agent for the campaign.

        brand_verification_url : typing.Optional[str]
            Link to document verifying the brand's name. This may be the certificate of incorporation, business license, or other relevant document. You can typically find this on the Secretary of State website.

        brand : typing.Optional[str]
            Unique identifier for the brand.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign.

        expected_agent_responses : typing.Optional[typing.Sequence[str]]
            List of what the agent might say to users (1-5 required).

        links : typing.Optional[UpsertRcsLinks]
            Legal documentation links.

        opt_in : typing.Optional[UpsertRcsOptIn]
            Opt-in configuration.

        opt_out : typing.Optional[UpsertRcsOptOut]
            Opt-out configuration.

        use_case : typing.Optional[UpsertRcsUseCase]
            Use case classification for the campaign.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExtendedRcsCampaign]
            Successfully created or updated RCS campaign.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "campaigns/rcs",
            method="POST",
            json={
                "agent": convert_and_respect_annotation_metadata(
                    object_=agent, annotation=UpsertRcsAgent, direction="write"
                ),
                "brandVerificationUrl": brand_verification_url,
                "brand": brand,
                "campaignId": campaign_id,
                "expectedAgentResponses": expected_agent_responses,
                "links": convert_and_respect_annotation_metadata(
                    object_=links, annotation=UpsertRcsLinks, direction="write"
                ),
                "optIn": convert_and_respect_annotation_metadata(
                    object_=opt_in, annotation=UpsertRcsOptIn, direction="write"
                ),
                "optOut": convert_and_respect_annotation_metadata(
                    object_=opt_out, annotation=UpsertRcsOptOut, direction="write"
                ),
                "useCase": convert_and_respect_annotation_metadata(
                    object_=use_case, annotation=UpsertRcsUseCase, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExtendedRcsCampaign,
                    parse_obj_as(
                        type_=ExtendedRcsCampaign,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def validate(
        self,
        *,
        campaign_id: str,
        additional_info: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CampaignValidationResult]:
        """
        Validate your RCS campaign configuration against carrier requirements and compliance rules.

        Parameters
        ----------
        campaign_id : str
            Unique identifier for the campaign.
            - When validating 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When validating toll-free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When validating RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CampaignValidationResult]
            Returns validation results.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "campaigns/rcs/validate",
            method="POST",
            json={
                "additionalInfo": additional_info,
                "campaignId": campaign_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CampaignValidationResult,
                    parse_obj_as(
                        type_=CampaignValidationResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
