# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ....core.serialization import FieldMetadata
from .rcs_agent_email import RcsAgentEmail
from .rcs_agent_phone import RcsAgentPhone
from .rcs_agent_website import RcsAgentWebsite


class UpsertRcsAgent(UniversalBaseModel):
    """
    Create an agent for the campaign.
    """

    color: typing.Optional[str] = pydantic.Field(default=None)
    """
    Color of the agent's buttons. <br>
    
    Must have sufficient contrast with white.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the agent.
    """

    emails: typing.Optional[typing.List[RcsAgentEmail]] = pydantic.Field(default=None)
    """
    List of emails (1-3 required).
    """

    hero_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="heroUrl")] = pydantic.Field(
        default=None
    )
    """
    Link to the agent's hero. Hero must be an image file with dimensions 1440x448px.
    """

    icon_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="iconUrl")] = pydantic.Field(
        default=None
    )
    """
    Link to the agent's icon. Icon must be an image file with dimensions 224x224px.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the agent.
    """

    phones: typing.Optional[typing.List[RcsAgentPhone]] = pydantic.Field(default=None)
    """
    List of phone numbers (1-3 required).
    """

    websites: typing.Optional[typing.List[RcsAgentWebsite]] = pydantic.Field(default=None)
    """
    List of urls (1-3 required).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
