# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.campaign_submission_result import CampaignSubmissionResult
from ...types.campaign_validation_result import CampaignValidationResult
from ...types.message_volume_enum import MessageVolumeEnum
from ...types.toll_free_campaign_with_extended_brand_and_status import TollFreeCampaignWithExtendedBrandAndStatus
from .raw_client import AsyncRawTollFreeClient, RawTollFreeClient
from .types.toll_free_autofill_response import TollFreeAutofillResponse
from .types.upsert_toll_free_schema_opt_in import UpsertTollFreeSchemaOptIn
from .types.upsert_toll_free_schema_use_case import UpsertTollFreeSchemaUseCase

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TollFreeClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTollFreeClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTollFreeClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTollFreeClient
        """
        return self._raw_client

    def autofill(
        self,
        *,
        additional_info: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TollFreeAutofillResponse:
        """
        Generate campaign details based off existing campaign and the brand it's connected to.

        Parameters
        ----------
        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign.
            - When autofilling 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When autofilling Toll-Free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When autofilling RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TollFreeAutofillResponse
            Returns autofilled toll-free information.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.toll_free.autofill(
            additional_info="Please autofill missing campaign fields using my brand profile",
            campaign_id="dlc_1234567890",
        )
        """
        _response = self._raw_client.autofill(
            additional_info=additional_info, campaign_id=campaign_id, request_options=request_options
        )
        return _response.data

    def get(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TollFreeCampaignWithExtendedBrandAndStatus:
        """
        Retrieve Toll-Free campaign.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of toll-free campaign. Must begin with the prefix `tf_`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TollFreeCampaignWithExtendedBrandAndStatus
            Successfully retrieved.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.toll_free.get(
            campaign_id="tf_1234567890",
        )
        """
        _response = self._raw_client.get(campaign_id, request_options=request_options)
        return _response.data

    def submit(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CampaignSubmissionResult:
        """
        Submit your toll-free campaign for approval and activation with carriers.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the toll-free campaign to submit. Must begin with the prefix `tf_`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CampaignSubmissionResult
            Successfully submitted toll-free campaign for approval.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.toll_free.submit(
            campaign_id="tf_1234567890",
        )
        """
        _response = self._raw_client.submit(campaign_id, request_options=request_options)
        return _response.data

    def upsert(
        self,
        *,
        brand: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        monthly_volume: typing.Optional[MessageVolumeEnum] = OMIT,
        name: typing.Optional[str] = OMIT,
        opt_in: typing.Optional[UpsertTollFreeSchemaOptIn] = OMIT,
        production_message_content: typing.Optional[str] = OMIT,
        use_case: typing.Optional[UpsertTollFreeSchemaUseCase] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TollFreeCampaignWithExtendedBrandAndStatus:
        """
        Create a new toll-free campaign or updates an existing one.<br>

        Omit campaignId to create a campaign.

        Parameters
        ----------
        brand : typing.Optional[str]
            Brand id. This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign. This identifier is a string that always begins with the prefix `tf_`, for example: `tf_1234567890`.

        monthly_volume : typing.Optional[MessageVolumeEnum]

        name : typing.Optional[str]
            Display name of the campaign.

        opt_in : typing.Optional[UpsertTollFreeSchemaOptIn]
            Opt-in keyword settings.

        production_message_content : typing.Optional[str]
            Explain message that would be sent.

        use_case : typing.Optional[UpsertTollFreeSchemaUseCase]
            Use case classification for the campaign.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TollFreeCampaignWithExtendedBrandAndStatus
            Successfully created or updated toll-free campaign.

        Examples
        --------
        from rcs import Pinnacle
        from rcs.campaigns.toll_free import (
            UpsertTollFreeSchemaOptIn,
            UpsertTollFreeSchemaUseCase,
        )

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.toll_free.upsert(
            brand="b_1234567890",
            campaign_id="tf_1234567890",
            monthly_volume="1,000",
            name="Pinnacle",
            opt_in=UpsertTollFreeSchemaOptIn(
                method="DIGITAL",
                url="https://www.pinnacle.sh/",
                workflow_description="Visit https://www.pinnacle.sh/",
            ),
            production_message_content="Join the Pinnacle workshop tomorrow and send your first RCS!",
            use_case=UpsertTollFreeSchemaUseCase(
                summary="Alerts clients about any Pinnacle hosted workshops.",
                value="WORKSHOP_ALERTS",
            ),
        )
        """
        _response = self._raw_client.upsert(
            brand=brand,
            campaign_id=campaign_id,
            monthly_volume=monthly_volume,
            name=name,
            opt_in=opt_in,
            production_message_content=production_message_content,
            use_case=use_case,
            request_options=request_options,
        )
        return _response.data

    def validate(
        self,
        *,
        campaign_id: str,
        additional_info: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CampaignValidationResult:
        """
        Validate your toll-free campaign configuration against carrier requirements and compliance rules.

        Parameters
        ----------
        campaign_id : str
            Unique identifier for the campaign.
            - When validating 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When validating toll-free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When validating RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CampaignValidationResult
            Returns validation results.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.campaigns.toll_free.validate(
            additional_info="Please validate this DLC campaign for 10DLC compliance",
            campaign_id="dlc_1234567890",
        )
        """
        _response = self._raw_client.validate(
            campaign_id=campaign_id, additional_info=additional_info, request_options=request_options
        )
        return _response.data


class AsyncTollFreeClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTollFreeClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTollFreeClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTollFreeClient
        """
        return self._raw_client

    async def autofill(
        self,
        *,
        additional_info: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TollFreeAutofillResponse:
        """
        Generate campaign details based off existing campaign and the brand it's connected to.

        Parameters
        ----------
        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign.
            - When autofilling 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When autofilling Toll-Free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When autofilling RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TollFreeAutofillResponse
            Returns autofilled toll-free information.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.toll_free.autofill(
                additional_info="Please autofill missing campaign fields using my brand profile",
                campaign_id="dlc_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.autofill(
            additional_info=additional_info, campaign_id=campaign_id, request_options=request_options
        )
        return _response.data

    async def get(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TollFreeCampaignWithExtendedBrandAndStatus:
        """
        Retrieve Toll-Free campaign.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of toll-free campaign. Must begin with the prefix `tf_`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TollFreeCampaignWithExtendedBrandAndStatus
            Successfully retrieved.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.toll_free.get(
                campaign_id="tf_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(campaign_id, request_options=request_options)
        return _response.data

    async def submit(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CampaignSubmissionResult:
        """
        Submit your toll-free campaign for approval and activation with carriers.

        Parameters
        ----------
        campaign_id : str
            Unique identifier of the toll-free campaign to submit. Must begin with the prefix `tf_`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CampaignSubmissionResult
            Successfully submitted toll-free campaign for approval.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.toll_free.submit(
                campaign_id="tf_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.submit(campaign_id, request_options=request_options)
        return _response.data

    async def upsert(
        self,
        *,
        brand: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        monthly_volume: typing.Optional[MessageVolumeEnum] = OMIT,
        name: typing.Optional[str] = OMIT,
        opt_in: typing.Optional[UpsertTollFreeSchemaOptIn] = OMIT,
        production_message_content: typing.Optional[str] = OMIT,
        use_case: typing.Optional[UpsertTollFreeSchemaUseCase] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TollFreeCampaignWithExtendedBrandAndStatus:
        """
        Create a new toll-free campaign or updates an existing one.<br>

        Omit campaignId to create a campaign.

        Parameters
        ----------
        brand : typing.Optional[str]
            Brand id. This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        campaign_id : typing.Optional[str]
            Unique identifier for the campaign. This identifier is a string that always begins with the prefix `tf_`, for example: `tf_1234567890`.

        monthly_volume : typing.Optional[MessageVolumeEnum]

        name : typing.Optional[str]
            Display name of the campaign.

        opt_in : typing.Optional[UpsertTollFreeSchemaOptIn]
            Opt-in keyword settings.

        production_message_content : typing.Optional[str]
            Explain message that would be sent.

        use_case : typing.Optional[UpsertTollFreeSchemaUseCase]
            Use case classification for the campaign.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TollFreeCampaignWithExtendedBrandAndStatus
            Successfully created or updated toll-free campaign.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle
        from rcs.campaigns.toll_free import (
            UpsertTollFreeSchemaOptIn,
            UpsertTollFreeSchemaUseCase,
        )

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.toll_free.upsert(
                brand="b_1234567890",
                campaign_id="tf_1234567890",
                monthly_volume="1,000",
                name="Pinnacle",
                opt_in=UpsertTollFreeSchemaOptIn(
                    method="DIGITAL",
                    url="https://www.pinnacle.sh/",
                    workflow_description="Visit https://www.pinnacle.sh/",
                ),
                production_message_content="Join the Pinnacle workshop tomorrow and send your first RCS!",
                use_case=UpsertTollFreeSchemaUseCase(
                    summary="Alerts clients about any Pinnacle hosted workshops.",
                    value="WORKSHOP_ALERTS",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upsert(
            brand=brand,
            campaign_id=campaign_id,
            monthly_volume=monthly_volume,
            name=name,
            opt_in=opt_in,
            production_message_content=production_message_content,
            use_case=use_case,
            request_options=request_options,
        )
        return _response.data

    async def validate(
        self,
        *,
        campaign_id: str,
        additional_info: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CampaignValidationResult:
        """
        Validate your toll-free campaign configuration against carrier requirements and compliance rules.

        Parameters
        ----------
        campaign_id : str
            Unique identifier for the campaign.
            - When validating 10DLC campaigns, it must begin with the prefix `dlc_` (e.g., `dlc_1234567890`)
            - When validating toll-free campaigns, it must begin with the prefix `tf_` (e.g., `tf_1234567890`)
            - When validating RCS campaigns, it must begin with the prefix `rcs_` (e.g., `rcs_1234567890`)

        additional_info : typing.Optional[str]
            Any additional information you want to provide.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CampaignValidationResult
            Returns validation results.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.campaigns.toll_free.validate(
                additional_info="Please validate this DLC campaign for 10DLC compliance",
                campaign_id="dlc_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.validate(
            campaign_id=campaign_id, additional_info=additional_info, request_options=request_options
        )
        return _response.data
