# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.contact import Contact
from ..types.contact_id import ContactId
from ..types.updated_contact_id import UpdatedContactId
from .raw_client import AsyncRawContactsClient, RawContactsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ContactsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawContactsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawContactsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawContactsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        id: typing.Optional[str] = None,
        phone_number: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Contact:
        """
        Retrieve contact information for a given number.

        Parameters
        ----------
        id : typing.Optional[str]
            Unique identifier of a specific contact you want to retrieve. <br>

            Either this parameter or `phoneNumber` must be provided, but not both.

        phone_number : typing.Optional[str]
            Phone number you want to look up contact information for, provided in URL-encoded E.164 format with %2B prefix instead of +.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Contact
            Successfully retrieved.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.contacts.get(
            id="co_1234567890",
        )
        """
        _response = self._raw_client.get(id=id, phone_number=phone_number, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        phone_number: str,
        description: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContactId:
        """
        Create a new contact for a given phone number.

        Parameters
        ----------
        phone_number : str
            Phone number to save for your contact, in E.164 format.

        description : typing.Optional[str]
            New notes or details for your contact.

        email : typing.Optional[str]
            New email address for your contact.

        name : typing.Optional[str]
            New name for your contact.

        tags : typing.Optional[typing.Sequence[str]]
            New tags for your contact.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContactId
            Successfully created the contact.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.contacts.create(
            phone_number="phoneNumber",
        )
        """
        _response = self._raw_client.create(
            phone_number=phone_number,
            description=description,
            email=email,
            name=name,
            tags=tags,
            request_options=request_options,
        )
        return _response.data

    def update(
        self,
        *,
        id: str,
        description: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdatedContactId:
        """
        Update an existing contact.

        Parameters
        ----------
        id : str
            ID of the contact you want to update. This identifier is a string that always begins with the prefix `co_`, for example: `co_1234567890`.

        description : typing.Optional[str]
            New notes or details for your contact.

        email : typing.Optional[str]
            New email address for your contact.

        name : typing.Optional[str]
            New name for your contact.

        tags : typing.Optional[typing.Sequence[str]]
            New tags for your contact.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdatedContactId
            Successfully updated the contact.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.contacts.update(
            description="Retired",
            email="alvaroopedtech@pinnacle.sh",
            name="Retired Bestie",
            tags=["friend"],
            id="co_1234567890",
        )
        """
        _response = self._raw_client.update(
            id=id, description=description, email=email, name=name, tags=tags, request_options=request_options
        )
        return _response.data


class AsyncContactsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawContactsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawContactsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawContactsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        id: typing.Optional[str] = None,
        phone_number: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Contact:
        """
        Retrieve contact information for a given number.

        Parameters
        ----------
        id : typing.Optional[str]
            Unique identifier of a specific contact you want to retrieve. <br>

            Either this parameter or `phoneNumber` must be provided, but not both.

        phone_number : typing.Optional[str]
            Phone number you want to look up contact information for, provided in URL-encoded E.164 format with %2B prefix instead of +.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Contact
            Successfully retrieved.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.contacts.get(
                id="co_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id=id, phone_number=phone_number, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        phone_number: str,
        description: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContactId:
        """
        Create a new contact for a given phone number.

        Parameters
        ----------
        phone_number : str
            Phone number to save for your contact, in E.164 format.

        description : typing.Optional[str]
            New notes or details for your contact.

        email : typing.Optional[str]
            New email address for your contact.

        name : typing.Optional[str]
            New name for your contact.

        tags : typing.Optional[typing.Sequence[str]]
            New tags for your contact.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContactId
            Successfully created the contact.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.contacts.create(
                phone_number="phoneNumber",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            phone_number=phone_number,
            description=description,
            email=email,
            name=name,
            tags=tags,
            request_options=request_options,
        )
        return _response.data

    async def update(
        self,
        *,
        id: str,
        description: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdatedContactId:
        """
        Update an existing contact.

        Parameters
        ----------
        id : str
            ID of the contact you want to update. This identifier is a string that always begins with the prefix `co_`, for example: `co_1234567890`.

        description : typing.Optional[str]
            New notes or details for your contact.

        email : typing.Optional[str]
            New email address for your contact.

        name : typing.Optional[str]
            New name for your contact.

        tags : typing.Optional[typing.Sequence[str]]
            New tags for your contact.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdatedContactId
            Successfully updated the contact.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.contacts.update(
                description="Retired",
                email="alvaroopedtech@pinnacle.sh",
                name="Retired Bestie",
                tags=["friend"],
                id="co_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id=id, description=description, email=email, name=name, tags=tags, request_options=request_options
        )
        return _response.data
