# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.campaign_enum import CampaignEnum
from ..types.conversation import Conversation
from ..types.conversation_list import ConversationList
from ..types.get_conversation_params import GetConversationParams
from ..types.message_list import MessageList
from ..types.sender import Sender
from ..types.successful_conversation_update import SuccessfulConversationUpdate
from .raw_client import AsyncRawConversationsClient, RawConversationsClient
from .types.conversations_list_messages_request_direction import ConversationsListMessagesRequestDirection
from .types.conversations_list_messages_request_sort_order import ConversationsListMessagesRequestSortOrder
from .types.conversations_list_messages_request_status import ConversationsListMessagesRequestStatus
from .types.conversations_list_messages_request_type import ConversationsListMessagesRequestType

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ConversationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConversationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawConversationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConversationsClient
        """
        return self._raw_client

    def get(
        self, *, request: GetConversationParams, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[Conversation]:
        """
        Fetch a specific conversation using either its unique identifier or by matching sender and recipient details.

        Parameters
        ----------
        request : GetConversationParams

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[Conversation]
            Returns the full conversation details, or null if not found.

        Examples
        --------
        from rcs import ConversationByIdParams, Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.conversations.get(
            request=ConversationByIdParams(
                id="conv_1234567890",
            ),
        )
        """
        _response = self._raw_client.get(request=request, request_options=request_options)
        return _response.data

    def list(
        self,
        *,
        page_index: int,
        brand_id: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        campaign_type: typing.Optional[CampaignEnum] = OMIT,
        page_size: typing.Optional[int] = OMIT,
        receiver: typing.Optional[str] = OMIT,
        sender: typing.Optional[Sender] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConversationList:
        """
        Retrieves conversations by page with optional filtering based off provided parameters.

        Parameters
        ----------
        page_index : int
            Zero-based index for pagination.

        brand_id : typing.Optional[str]
            The unique identifier of the brand to filter conversations. This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        campaign_id : typing.Optional[str]
            The unique identifier of the campaign to filter conversations. This identifier is a string that begins with the prefix:
            - TOLL_FREE: `tf_` (e.g., `tf_1234567890`)
            - 10DLC: `dlc_` (e.g., `dlc_1234567890`)
            - RCS: `rcs_` (e.g., `rcs_1234567890`)

        campaign_type : typing.Optional[CampaignEnum]

        page_size : typing.Optional[int]
            Number of conversations to return per page.

        receiver : typing.Optional[str]
            Receiver's phone number in E.164 format.

        sender : typing.Optional[Sender]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConversationList
            Returns conversations that meets your filters.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.conversations.list(
            brand_id="b_1234567890",
            campaign_id="tf_1234567890",
            campaign_type="TOLL_FREE",
            page_index=0,
            page_size=20,
            receiver="+16509231662",
            sender="+18445551234",
        )
        """
        _response = self._raw_client.list(
            page_index=page_index,
            brand_id=brand_id,
            campaign_id=campaign_id,
            campaign_type=campaign_type,
            page_size=page_size,
            receiver=receiver,
            sender=sender,
            request_options=request_options,
        )
        return _response.data

    def update(
        self, *, id: str, notes: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessfulConversationUpdate:
        """
        Update the notes associated with a specific conversation.

        Parameters
        ----------
        id : str
            The unique identifier of the conversation to update. This identifier is a string that always begins with the prefix `conv_`, for example: `conv_1234567890`.

        notes : str
            New notes or comments for the conversation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessfulConversationUpdate
            Successfully updated the conversation.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.conversations.update(
            id="conv_1234567890",
            notes="Follow-up completed. Customer satisfied with resolution.",
        )
        """
        _response = self._raw_client.update(id=id, notes=notes, request_options=request_options)
        return _response.data

    def list_messages(
        self,
        id: str,
        *,
        page_index: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        sort_order: typing.Optional[ConversationsListMessagesRequestSortOrder] = None,
        direction: typing.Optional[ConversationsListMessagesRequestDirection] = None,
        status: typing.Optional[ConversationsListMessagesRequestStatus] = None,
        type: typing.Optional[ConversationsListMessagesRequestType] = None,
        date_from: typing.Optional[dt.datetime] = None,
        date_to: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MessageList:
        """
        Retrieve a paginated and filtered list of messages for a specific conversation.

        Parameters
        ----------
        id : str
            Unique identifier of the conversation. This identifier is a string that always begins with the prefix `conv_`, for example: `conv_1234567890`.

        page_index : typing.Optional[int]
            Zero-based index for pagination.

        page_size : typing.Optional[int]
            Number of messages to return per page.

        sort_order : typing.Optional[ConversationsListMessagesRequestSortOrder]
            Sort order for messages. <br>

            - `asc`: Oldest messages first
            - `desc`: Newest messages first (default)

        direction : typing.Optional[ConversationsListMessagesRequestDirection]
            Filter messages by direction. <br>

            - `INBOUND`: Messages received from contacts
            - `OUTBOUND`: Messages sent to contacts

        status : typing.Optional[ConversationsListMessagesRequestStatus]
            Filter messages by delivery status.

        type : typing.Optional[ConversationsListMessagesRequestType]
            Filter messages by protocol type.

        date_from : typing.Optional[dt.datetime]
            Filter messages sent on or after this date (ISO 8601 format).

        date_to : typing.Optional[dt.datetime]
            Filter messages sent on or before this date (ISO 8601 format).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageList
            Returns a paginated list of messages in the conversation.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.conversations.list_messages(
            id="id",
        )
        """
        _response = self._raw_client.list_messages(
            id,
            page_index=page_index,
            page_size=page_size,
            sort_order=sort_order,
            direction=direction,
            status=status,
            type=type,
            date_from=date_from,
            date_to=date_to,
            request_options=request_options,
        )
        return _response.data


class AsyncConversationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConversationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawConversationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConversationsClient
        """
        return self._raw_client

    async def get(
        self, *, request: GetConversationParams, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[Conversation]:
        """
        Fetch a specific conversation using either its unique identifier or by matching sender and recipient details.

        Parameters
        ----------
        request : GetConversationParams

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[Conversation]
            Returns the full conversation details, or null if not found.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle, ConversationByIdParams

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversations.get(
                request=ConversationByIdParams(
                    id="conv_1234567890",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request=request, request_options=request_options)
        return _response.data

    async def list(
        self,
        *,
        page_index: int,
        brand_id: typing.Optional[str] = OMIT,
        campaign_id: typing.Optional[str] = OMIT,
        campaign_type: typing.Optional[CampaignEnum] = OMIT,
        page_size: typing.Optional[int] = OMIT,
        receiver: typing.Optional[str] = OMIT,
        sender: typing.Optional[Sender] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConversationList:
        """
        Retrieves conversations by page with optional filtering based off provided parameters.

        Parameters
        ----------
        page_index : int
            Zero-based index for pagination.

        brand_id : typing.Optional[str]
            The unique identifier of the brand to filter conversations. This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        campaign_id : typing.Optional[str]
            The unique identifier of the campaign to filter conversations. This identifier is a string that begins with the prefix:
            - TOLL_FREE: `tf_` (e.g., `tf_1234567890`)
            - 10DLC: `dlc_` (e.g., `dlc_1234567890`)
            - RCS: `rcs_` (e.g., `rcs_1234567890`)

        campaign_type : typing.Optional[CampaignEnum]

        page_size : typing.Optional[int]
            Number of conversations to return per page.

        receiver : typing.Optional[str]
            Receiver's phone number in E.164 format.

        sender : typing.Optional[Sender]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConversationList
            Returns conversations that meets your filters.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversations.list(
                brand_id="b_1234567890",
                campaign_id="tf_1234567890",
                campaign_type="TOLL_FREE",
                page_index=0,
                page_size=20,
                receiver="+16509231662",
                sender="+18445551234",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            page_index=page_index,
            brand_id=brand_id,
            campaign_id=campaign_id,
            campaign_type=campaign_type,
            page_size=page_size,
            receiver=receiver,
            sender=sender,
            request_options=request_options,
        )
        return _response.data

    async def update(
        self, *, id: str, notes: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessfulConversationUpdate:
        """
        Update the notes associated with a specific conversation.

        Parameters
        ----------
        id : str
            The unique identifier of the conversation to update. This identifier is a string that always begins with the prefix `conv_`, for example: `conv_1234567890`.

        notes : str
            New notes or comments for the conversation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessfulConversationUpdate
            Successfully updated the conversation.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversations.update(
                id="conv_1234567890",
                notes="Follow-up completed. Customer satisfied with resolution.",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(id=id, notes=notes, request_options=request_options)
        return _response.data

    async def list_messages(
        self,
        id: str,
        *,
        page_index: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        sort_order: typing.Optional[ConversationsListMessagesRequestSortOrder] = None,
        direction: typing.Optional[ConversationsListMessagesRequestDirection] = None,
        status: typing.Optional[ConversationsListMessagesRequestStatus] = None,
        type: typing.Optional[ConversationsListMessagesRequestType] = None,
        date_from: typing.Optional[dt.datetime] = None,
        date_to: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MessageList:
        """
        Retrieve a paginated and filtered list of messages for a specific conversation.

        Parameters
        ----------
        id : str
            Unique identifier of the conversation. This identifier is a string that always begins with the prefix `conv_`, for example: `conv_1234567890`.

        page_index : typing.Optional[int]
            Zero-based index for pagination.

        page_size : typing.Optional[int]
            Number of messages to return per page.

        sort_order : typing.Optional[ConversationsListMessagesRequestSortOrder]
            Sort order for messages. <br>

            - `asc`: Oldest messages first
            - `desc`: Newest messages first (default)

        direction : typing.Optional[ConversationsListMessagesRequestDirection]
            Filter messages by direction. <br>

            - `INBOUND`: Messages received from contacts
            - `OUTBOUND`: Messages sent to contacts

        status : typing.Optional[ConversationsListMessagesRequestStatus]
            Filter messages by delivery status.

        type : typing.Optional[ConversationsListMessagesRequestType]
            Filter messages by protocol type.

        date_from : typing.Optional[dt.datetime]
            Filter messages sent on or after this date (ISO 8601 format).

        date_to : typing.Optional[dt.datetime]
            Filter messages sent on or before this date (ISO 8601 format).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageList
            Returns a paginated list of messages in the conversation.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.conversations.list_messages(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_messages(
            id,
            page_index=page_index,
            page_size=page_size,
            sort_order=sort_order,
            direction=direction,
            status=status,
            type=type,
            date_from=date_from,
            date_to=date_to,
            request_options=request_options,
        )
        return _response.data
