# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.message import Message
from ..types.reaction_result import ReactionResult
from .raw_client import AsyncRawMessagesClient, RawMessagesClient
from .types.react_message_options import ReactMessageOptions

if typing.TYPE_CHECKING:
    from .mms.client import AsyncMmsClient, MmsClient
    from .rcs.client import AsyncRcsClient, RcsClient
    from .sms.client import AsyncSmsClient, SmsClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MessagesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMessagesClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._sms: typing.Optional[SmsClient] = None
        self._mms: typing.Optional[MmsClient] = None
        self._rcs: typing.Optional[RcsClient] = None

    @property
    def with_raw_response(self) -> RawMessagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMessagesClient
        """
        return self._raw_client

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Message:
        """
        Retrieve a previously sent message.

        Parameters
        ----------
        id : str
            Unique identifier of the message. This identifier is a string that always begins with the prefix `msg_`, for example: `msg_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            Successfully retrieved the message.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.messages.get(
            id="msg_1234567890",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def react(
        self,
        *,
        message_id: str,
        options: typing.Optional[ReactMessageOptions] = OMIT,
        reaction: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReactionResult:
        """
        Add or remove an emoji reaction to a previously sent message.

        Parameters
        ----------
        message_id : str
            Unique identifier of the message. This identifier is a string that always begins with the prefix `msg_`, for example: `msg_1234567890`.

        options : typing.Optional[ReactMessageOptions]

        reaction : typing.Optional[str]
            Unicode emoji to add. <br>

            Use `null` to remove existing reaction.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReactionResult
            Successfully added or removed a reaction from the message.

        Examples
        --------
        from rcs import Pinnacle
        from rcs.messages import ReactMessageOptions

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.messages.react(
            message_id="msg_1234567890",
            options=ReactMessageOptions(
                force=True,
            ),
            reaction="👍",
        )
        """
        _response = self._raw_client.react(
            message_id=message_id, options=options, reaction=reaction, request_options=request_options
        )
        return _response.data

    @property
    def sms(self):
        if self._sms is None:
            from .sms.client import SmsClient  # noqa: E402

            self._sms = SmsClient(client_wrapper=self._client_wrapper)
        return self._sms

    @property
    def mms(self):
        if self._mms is None:
            from .mms.client import MmsClient  # noqa: E402

            self._mms = MmsClient(client_wrapper=self._client_wrapper)
        return self._mms

    @property
    def rcs(self):
        if self._rcs is None:
            from .rcs.client import RcsClient  # noqa: E402

            self._rcs = RcsClient(client_wrapper=self._client_wrapper)
        return self._rcs


class AsyncMessagesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMessagesClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._sms: typing.Optional[AsyncSmsClient] = None
        self._mms: typing.Optional[AsyncMmsClient] = None
        self._rcs: typing.Optional[AsyncRcsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawMessagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMessagesClient
        """
        return self._raw_client

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Message:
        """
        Retrieve a previously sent message.

        Parameters
        ----------
        id : str
            Unique identifier of the message. This identifier is a string that always begins with the prefix `msg_`, for example: `msg_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            Successfully retrieved the message.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.messages.get(
                id="msg_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def react(
        self,
        *,
        message_id: str,
        options: typing.Optional[ReactMessageOptions] = OMIT,
        reaction: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReactionResult:
        """
        Add or remove an emoji reaction to a previously sent message.

        Parameters
        ----------
        message_id : str
            Unique identifier of the message. This identifier is a string that always begins with the prefix `msg_`, for example: `msg_1234567890`.

        options : typing.Optional[ReactMessageOptions]

        reaction : typing.Optional[str]
            Unicode emoji to add. <br>

            Use `null` to remove existing reaction.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReactionResult
            Successfully added or removed a reaction from the message.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle
        from rcs.messages import ReactMessageOptions

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.messages.react(
                message_id="msg_1234567890",
                options=ReactMessageOptions(
                    force=True,
                ),
                reaction="👍",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.react(
            message_id=message_id, options=options, reaction=reaction, request_options=request_options
        )
        return _response.data

    @property
    def sms(self):
        if self._sms is None:
            from .sms.client import AsyncSmsClient  # noqa: E402

            self._sms = AsyncSmsClient(client_wrapper=self._client_wrapper)
        return self._sms

    @property
    def mms(self):
        if self._mms is None:
            from .mms.client import AsyncMmsClient  # noqa: E402

            self._mms = AsyncMmsClient(client_wrapper=self._client_wrapper)
        return self._mms

    @property
    def rcs(self):
        if self._rcs is None:
            from .rcs.client import AsyncRcsClient  # noqa: E402

            self._rcs = AsyncRcsClient(client_wrapper=self._client_wrapper)
        return self._rcs
