# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.mms_validation_result import MmsValidationResult
from .raw_client import AsyncRawMmsClient, RawMmsClient
from .types.mms_send_response import MmsSendResponse
from .types.send_mms_options import SendMmsOptions

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MmsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMmsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMmsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMmsClient
        """
        return self._raw_client

    def send(
        self,
        *,
        from_: str,
        media_urls: typing.Sequence[str],
        text: str,
        to: str,
        options: typing.Optional[SendMmsOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MmsSendResponse:
        """
        Send a MMS immediately or schedule it for future delivery.

        Parameters
        ----------
        from_ : str
            Phone number you want to send the message from in E.164 format.

        media_urls : typing.Sequence[str]
            Media file URLs to send.<br>

             See [supported media types](https://app.pinnacle.sh/supported-file-types?type=MMS).

        text : str
            Message text to accompany the media.

        to : str
            Recipient's phone number in E.164 format.

        options : typing.Optional[SendMmsOptions]
            Control how your MMS is processed and delivered.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MmsSendResponse
            Successfully sent or scheduled the message. <br>

            Each message part can be tracked independently using its unique message ID. Use our [/messages/:id](./get) endpoint to track your messages.

        Examples
        --------
        from rcs import Pinnacle
        from rcs.messages.mms import SendMmsOptions

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.messages.mms.send(
            from_="+14155164736",
            media_urls=[
                "https://fastly.picsum.photos/id/941/300/300.jpg?hmac=mDxM9PWSqRDjecwSCEpzU4bj35gqnG7yA25OL29uNv0"
            ],
            options=SendMmsOptions(
                multiple_messages=True,
                validate=True,
            ),
            text="Check out this image!",
            to="+14154746461",
        )
        """
        _response = self._raw_client.send(
            from_=from_, media_urls=media_urls, text=text, to=to, options=options, request_options=request_options
        )
        return _response.data

    def validate(
        self,
        *,
        media_urls: typing.Sequence[str],
        text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MmsValidationResult:
        """
        Validate MMS message content without sending it.

        Parameters
        ----------
        media_urls : typing.Sequence[str]
            URLs of media files in this message. <br>

            See [supported media types](https://app.pinnacle.sh/supported-file-types?type=MMS).

        text : typing.Optional[str]
            Text content that accompanies the media files.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MmsValidationResult
            Returns validation results.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.messages.mms.validate(
            media_urls=[
                "https://upload.wikimedia.org/wikipedia/commons/b/b9/Pizigani_1367_Chart_1MB.jpg",
                "https://fastly.picsum.photos/id/528/1000/1000.jpg?hmac=aTG0xNif9KbNryFN0ZNZ_nFK6aEpZxqUGCZF1KjOT8w",
                "https://file-examples.com/storage/fefdd7ab126835e7993bb1a/2017/10/file_example_JPG_500kB.jpg",
            ],
            text="Check out these images!",
        )
        """
        _response = self._raw_client.validate(media_urls=media_urls, text=text, request_options=request_options)
        return _response.data


class AsyncMmsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMmsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMmsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMmsClient
        """
        return self._raw_client

    async def send(
        self,
        *,
        from_: str,
        media_urls: typing.Sequence[str],
        text: str,
        to: str,
        options: typing.Optional[SendMmsOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MmsSendResponse:
        """
        Send a MMS immediately or schedule it for future delivery.

        Parameters
        ----------
        from_ : str
            Phone number you want to send the message from in E.164 format.

        media_urls : typing.Sequence[str]
            Media file URLs to send.<br>

             See [supported media types](https://app.pinnacle.sh/supported-file-types?type=MMS).

        text : str
            Message text to accompany the media.

        to : str
            Recipient's phone number in E.164 format.

        options : typing.Optional[SendMmsOptions]
            Control how your MMS is processed and delivered.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MmsSendResponse
            Successfully sent or scheduled the message. <br>

            Each message part can be tracked independently using its unique message ID. Use our [/messages/:id](./get) endpoint to track your messages.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle
        from rcs.messages.mms import SendMmsOptions

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.messages.mms.send(
                from_="+14155164736",
                media_urls=[
                    "https://fastly.picsum.photos/id/941/300/300.jpg?hmac=mDxM9PWSqRDjecwSCEpzU4bj35gqnG7yA25OL29uNv0"
                ],
                options=SendMmsOptions(
                    multiple_messages=True,
                    validate=True,
                ),
                text="Check out this image!",
                to="+14154746461",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.send(
            from_=from_, media_urls=media_urls, text=text, to=to, options=options, request_options=request_options
        )
        return _response.data

    async def validate(
        self,
        *,
        media_urls: typing.Sequence[str],
        text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MmsValidationResult:
        """
        Validate MMS message content without sending it.

        Parameters
        ----------
        media_urls : typing.Sequence[str]
            URLs of media files in this message. <br>

            See [supported media types](https://app.pinnacle.sh/supported-file-types?type=MMS).

        text : typing.Optional[str]
            Text content that accompanies the media files.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MmsValidationResult
            Returns validation results.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.messages.mms.validate(
                media_urls=[
                    "https://upload.wikimedia.org/wikipedia/commons/b/b9/Pizigani_1367_Chart_1MB.jpg",
                    "https://fastly.picsum.photos/id/528/1000/1000.jpg?hmac=aTG0xNif9KbNryFN0ZNZ_nFK6aEpZxqUGCZF1KjOT8w",
                    "https://file-examples.com/storage/fefdd7ab126835e7993bb1a/2017/10/file_example_JPG_500kB.jpg",
                ],
                text="Check out these images!",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.validate(media_urls=media_urls, text=text, request_options=request_options)
        return _response.data
