# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ....core.serialization import FieldMetadata
from ....types.message_schedule import MessageSchedule
from ....types.tracking import Tracking


class SendMmsOptions(UniversalBaseModel):
    """
    Control how your MMS is processed and delivered.
    """

    multiple_messages: bool = pydantic.Field()
    """
    Allow splitting large content into multiple MMS messages if size limits are exceeded. <br>
    
    If `false`, MMS over the limit will throw an error and won't be sent.
    """

    schedule: typing.Optional[MessageSchedule] = None
    tracking: typing.Optional[Tracking] = None
    validate_: typing_extensions.Annotated[bool, FieldMetadata(alias="validate")] = pydantic.Field()
    """
    Set to true to check this message and throw an error when validation fails. <br>
    
    If errors occur, the message is not sent. Otherwise message is sent after validation.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
