# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.rcs_validate_content import RcsValidateContent
from ...types.rcs_validation_result import RcsValidationResult
from ...types.rich_message import RichMessage
from .raw_client import AsyncRawRcsClient, RawRcsClient
from .types.rcs_send_response import RcsSendResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RcsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRcsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRcsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRcsClient
        """
        return self._raw_client

    def send(self, *, request: RichMessage, request_options: typing.Optional[RequestOptions] = None) -> RcsSendResponse:
        """
        Send a RCS message immediately or schedule it for future delivery. <br>

        Requires an active RCS agent and recipient devices that support RCS Business Messaging.

        Parameters
        ----------
        request : RichMessage

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsSendResponse
            Successfully sent or scheduled the message.

            Use our [/messages/:id](./get) endpoint to track your message.

        Examples
        --------
        from rcs import Pinnacle, RichButton_OpenUrl, RichTextMessage

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.messages.rcs.send(
            request=RichTextMessage(
                quick_replies=[
                    RichButton_OpenUrl(
                        payload="payload",
                        title="title",
                    )
                ],
                text="text",
                from_="from",
                to="to",
            ),
        )
        """
        _response = self._raw_client.send(request=request, request_options=request_options)
        return _response.data

    def validate(
        self, *, request: RcsValidateContent, request_options: typing.Optional[RequestOptions] = None
    ) -> RcsValidationResult:
        """
        Validate RCS message content without sending it.

        Parameters
        ----------
        request : RcsValidateContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsValidationResult
            Returns validation results.

        Examples
        --------
        from rcs import Pinnacle, RcsTextContent, RichButton_OpenUrl

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.messages.rcs.validate(
            request=RcsTextContent(
                quick_replies=[
                    RichButton_OpenUrl(
                        payload="payload",
                        title="title",
                    )
                ],
                text="text",
            ),
        )
        """
        _response = self._raw_client.validate(request=request, request_options=request_options)
        return _response.data


class AsyncRcsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRcsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRcsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRcsClient
        """
        return self._raw_client

    async def send(
        self, *, request: RichMessage, request_options: typing.Optional[RequestOptions] = None
    ) -> RcsSendResponse:
        """
        Send a RCS message immediately or schedule it for future delivery. <br>

        Requires an active RCS agent and recipient devices that support RCS Business Messaging.

        Parameters
        ----------
        request : RichMessage

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsSendResponse
            Successfully sent or scheduled the message.

            Use our [/messages/:id](./get) endpoint to track your message.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle, RichButton_OpenUrl, RichTextMessage

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.messages.rcs.send(
                request=RichTextMessage(
                    quick_replies=[
                        RichButton_OpenUrl(
                            payload="payload",
                            title="title",
                        )
                    ],
                    text="text",
                    from_="from",
                    to="to",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.send(request=request, request_options=request_options)
        return _response.data

    async def validate(
        self, *, request: RcsValidateContent, request_options: typing.Optional[RequestOptions] = None
    ) -> RcsValidationResult:
        """
        Validate RCS message content without sending it.

        Parameters
        ----------
        request : RcsValidateContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsValidationResult
            Returns validation results.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle, RcsTextContent, RichButton_OpenUrl

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.messages.rcs.validate(
                request=RcsTextContent(
                    quick_replies=[
                        RichButton_OpenUrl(
                            payload="payload",
                            title="title",
                        )
                    ],
                    text="text",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.validate(request=request, request_options=request_options)
        return _response.data
