# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.sms_validation_result import SmsValidationResult
from .raw_client import AsyncRawSmsClient, RawSmsClient
from .types.send_sms_options import SendSmsOptions
from .types.sms_send_response import SmsSendResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SmsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSmsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSmsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSmsClient
        """
        return self._raw_client

    def send(
        self,
        *,
        from_: str,
        text: str,
        to: str,
        options: typing.Optional[SendSmsOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SmsSendResponse:
        """
        Send a SMS message immediately or schedule it for future delivery.

        Parameters
        ----------
        from_ : str
            Phone number that sends the message in E.164 format.

        text : str
            Message content.

        to : str
            Recipient's phone number in E.164 format.

        options : typing.Optional[SendSmsOptions]
            Additional settings to customize SMS delivery.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SmsSendResponse
            Successfully sent or scheduled the message. <br>

            Use our [/messages/:id](./get) endpoint to track your message.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.messages.sms.send(
            from_="+14155164736",
            text="Hey!",
            to="+14154746461",
        )
        """
        _response = self._raw_client.send(
            from_=from_, text=text, to=to, options=options, request_options=request_options
        )
        return _response.data

    def validate(self, *, text: str, request_options: typing.Optional[RequestOptions] = None) -> SmsValidationResult:
        """
        Validate SMS message content without sending it.

        Parameters
        ----------
        text : str
            Message content.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SmsValidationResult
            Returns the validation results.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.messages.sms.validate(
            text="Hello from Pinnacle",
        )
        """
        _response = self._raw_client.validate(text=text, request_options=request_options)
        return _response.data


class AsyncSmsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSmsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSmsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSmsClient
        """
        return self._raw_client

    async def send(
        self,
        *,
        from_: str,
        text: str,
        to: str,
        options: typing.Optional[SendSmsOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SmsSendResponse:
        """
        Send a SMS message immediately or schedule it for future delivery.

        Parameters
        ----------
        from_ : str
            Phone number that sends the message in E.164 format.

        text : str
            Message content.

        to : str
            Recipient's phone number in E.164 format.

        options : typing.Optional[SendSmsOptions]
            Additional settings to customize SMS delivery.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SmsSendResponse
            Successfully sent or scheduled the message. <br>

            Use our [/messages/:id](./get) endpoint to track your message.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.messages.sms.send(
                from_="+14155164736",
                text="Hey!",
                to="+14154746461",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.send(
            from_=from_, text=text, to=to, options=options, request_options=request_options
        )
        return _response.data

    async def validate(
        self, *, text: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SmsValidationResult:
        """
        Validate SMS message content without sending it.

        Parameters
        ----------
        text : str
            Message content.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SmsValidationResult
            Returns the validation results.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.messages.sms.validate(
                text="Hello from Pinnacle",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.validate(text=text, request_options=request_options)
        return _response.data
