# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.attached_phone_number_result import AttachedPhoneNumberResult
from ...types.detached_phone_number_result import DetachedPhoneNumberResult
from ...types.messaging_profile_enum import MessagingProfileEnum
from .raw_client import AsyncRawCampaignClient, RawCampaignClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CampaignClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCampaignClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCampaignClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCampaignClient
        """
        return self._raw_client

    def attach(
        self,
        *,
        phones: typing.Sequence[str],
        campaign_type: MessagingProfileEnum,
        campaign_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AttachedPhoneNumberResult:
        """
        Link a phone number to a specific campaign. Phone numbers must be linked to a campaign to send messages.

        Parameters
        ----------
        phones : typing.Sequence[str]
            List of phone number (E.164 format).

        campaign_type : MessagingProfileEnum

        campaign_id : str
            Unique identifier for the campaign. <br>

             - **TOLL_FREE** campaigns:
               - Must begin with the prefix `tf_`
               - Example: `tf_1234567890`
             - **10DLC** campaigns:
               - Must begin with the prefix `dlc_`
               - Example: `dlc_1234567890`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AttachedPhoneNumberResult
            Successfully attached the campaign.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.phone_numbers.campaign.attach(
            phones=["+14155550123", "+14155559876", "+14155550111"],
            campaign_type="TOLL_FREE",
            campaign_id="tf_1234567890",
        )
        """
        _response = self._raw_client.attach(
            phones=phones, campaign_type=campaign_type, campaign_id=campaign_id, request_options=request_options
        )
        return _response.data

    def detach(
        self, *, phones: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> DetachedPhoneNumberResult:
        """
        Remove the association between a phone number and its attached campaign.

        Parameters
        ----------
        phones : typing.Sequence[str]
            List of phone numbers (E.164 format).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DetachedPhoneNumberResult
            Successfully detached the campaign.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.phone_numbers.campaign.detach(
            phones=["+14155559876", "14155550111"],
        )
        """
        _response = self._raw_client.detach(phones=phones, request_options=request_options)
        return _response.data


class AsyncCampaignClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCampaignClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCampaignClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCampaignClient
        """
        return self._raw_client

    async def attach(
        self,
        *,
        phones: typing.Sequence[str],
        campaign_type: MessagingProfileEnum,
        campaign_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AttachedPhoneNumberResult:
        """
        Link a phone number to a specific campaign. Phone numbers must be linked to a campaign to send messages.

        Parameters
        ----------
        phones : typing.Sequence[str]
            List of phone number (E.164 format).

        campaign_type : MessagingProfileEnum

        campaign_id : str
            Unique identifier for the campaign. <br>

             - **TOLL_FREE** campaigns:
               - Must begin with the prefix `tf_`
               - Example: `tf_1234567890`
             - **10DLC** campaigns:
               - Must begin with the prefix `dlc_`
               - Example: `dlc_1234567890`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AttachedPhoneNumberResult
            Successfully attached the campaign.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.phone_numbers.campaign.attach(
                phones=["+14155550123", "+14155559876", "+14155550111"],
                campaign_type="TOLL_FREE",
                campaign_id="tf_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.attach(
            phones=phones, campaign_type=campaign_type, campaign_id=campaign_id, request_options=request_options
        )
        return _response.data

    async def detach(
        self, *, phones: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> DetachedPhoneNumberResult:
        """
        Remove the association between a phone number and its attached campaign.

        Parameters
        ----------
        phones : typing.Sequence[str]
            List of phone numbers (E.164 format).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DetachedPhoneNumberResult
            Successfully detached the campaign.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.phone_numbers.campaign.detach(
                phones=["+14155559876", "14155550111"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.detach(phones=phones, request_options=request_options)
        return _response.data
