# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class SearchPhoneNumberByDigits(UniversalBaseModel):
    """
    Filter your search by digit pattern.
    """

    contains: typing.Optional[str] = pydantic.Field(default=None)
    """
    Your search will return only numbers that contain this digit sequence anywhere within them.
    """

    ends_with: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="endsWith")] = pydantic.Field(
        default=None
    )
    """
    Your search will return only numbers that end with these digits.
    """

    starts_with: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="startsWith")] = pydantic.Field(
        default=None
    )
    """
    Your search will return only numbers that begin with these digits.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
