# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class SearchPhoneNumberByLocation(UniversalBaseModel):
    """
    Filter your search by geographic location to find numbers in specific regions. <br>

    Toll-free numbers ignore city and state filters.
    """

    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    Search for numbers in your target city.
    """

    country_code: typing_extensions.Annotated[
        typing.Optional[typing.Literal["US"]], FieldMetadata(alias="countryCode")
    ] = pydantic.Field(default=None)
    """
    Currently, only US numbers are supported.
    """

    national_destination_code: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="nationalDestinationCode")
    ] = pydantic.Field(default=None)
    """
    Narrow your search to a specific area or exchange code. <br>
    
    For US numbers, this is usually the 3-digit area code.
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    Search for numbers in your target state or province using a two-letter code.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
