# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.attach_webhook_params import AttachWebhookParams
from ...types.configured_webhook import ConfiguredWebhook
from ...types.detached_webhook_info import DetachedWebhookInfo
from .raw_client import AsyncRawWebhookClient, RawWebhookClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WebhookClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWebhookClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWebhookClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWebhookClient
        """
        return self._raw_client

    def attach(
        self, phone: str, *, request: AttachWebhookParams, request_options: typing.Optional[RequestOptions] = None
    ) -> ConfiguredWebhook:
        """
        Connect a webhook to your phone number to receive real-time notifications for incoming messages, delivery status updates, and other communication events.

        Parameters
        ----------
        phone : str
            The phone number you want to attach the webhook to in E.164 format. Make sure it is url encoded (i.e. replace the leading + with %2B). <br>

            Must be a phone number that you own and have already [purchased](./buy) through the API. A phone number can have multiple webhooks attached to it.

        request : AttachWebhookParams

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfiguredWebhook
            Successfully updated/added webhook to the number. <br>

            To detach webhooks check out [Detach Webhook](./detach-webook).

        Examples
        --------
        from rcs import AttachWebhookByIdParams, Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.phone_numbers.webhook.attach(
            phone="%2B14155551234",
            request=AttachWebhookByIdParams(
                webhook_id="wh_1234567890",
                event="MESSAGE.STATUS",
            ),
        )
        """
        _response = self._raw_client.attach(phone, request=request, request_options=request_options)
        return _response.data

    def detach(
        self, phone: str, webhook_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DetachedWebhookInfo:
        """
        Disconnect a webhook from your phone number to stop receiving event notifications for that specific number. <br>

        The webhook configuration itself remains intact and available for use with other phone numbers.

        Parameters
        ----------
        phone : str
            The phone number you want to attach the webhook to in E.164 format. Make sure it is url encoded (i.e. replace the leading + with %2B). <br>

            Must be a phone number that you own and currently has the specified webhook attached.

        webhook_id : str
            The unique identifier of the webhook you want to detach from the phone number. <br>

            This must be a valid webhook ID that is currently attached to the specified phone number. This identifier is a string that always begins with the prefix `wh_`, for example: `wh_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DetachedWebhookInfo
            Successfully detached the webhook.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.phone_numbers.webhook.detach(
            phone="+14155551234",
            webhook_id="wh_1234567890",
        )
        """
        _response = self._raw_client.detach(phone, webhook_id, request_options=request_options)
        return _response.data


class AsyncWebhookClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWebhookClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWebhookClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWebhookClient
        """
        return self._raw_client

    async def attach(
        self, phone: str, *, request: AttachWebhookParams, request_options: typing.Optional[RequestOptions] = None
    ) -> ConfiguredWebhook:
        """
        Connect a webhook to your phone number to receive real-time notifications for incoming messages, delivery status updates, and other communication events.

        Parameters
        ----------
        phone : str
            The phone number you want to attach the webhook to in E.164 format. Make sure it is url encoded (i.e. replace the leading + with %2B). <br>

            Must be a phone number that you own and have already [purchased](./buy) through the API. A phone number can have multiple webhooks attached to it.

        request : AttachWebhookParams

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfiguredWebhook
            Successfully updated/added webhook to the number. <br>

            To detach webhooks check out [Detach Webhook](./detach-webook).

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle, AttachWebhookByIdParams

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.phone_numbers.webhook.attach(
                phone="%2B14155551234",
                request=AttachWebhookByIdParams(
                    webhook_id="wh_1234567890",
                    event="MESSAGE.STATUS",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.attach(phone, request=request, request_options=request_options)
        return _response.data

    async def detach(
        self, phone: str, webhook_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DetachedWebhookInfo:
        """
        Disconnect a webhook from your phone number to stop receiving event notifications for that specific number. <br>

        The webhook configuration itself remains intact and available for use with other phone numbers.

        Parameters
        ----------
        phone : str
            The phone number you want to attach the webhook to in E.164 format. Make sure it is url encoded (i.e. replace the leading + with %2B). <br>

            Must be a phone number that you own and currently has the specified webhook attached.

        webhook_id : str
            The unique identifier of the webhook you want to detach from the phone number. <br>

            This must be a valid webhook ID that is currently attached to the specified phone number. This identifier is a string that always begins with the prefix `wh_`, for example: `wh_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DetachedWebhookInfo
            Successfully detached the webhook.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.phone_numbers.webhook.detach(
                phone="+14155551234",
                webhook_id="wh_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.detach(phone, webhook_id, request_options=request_options)
        return _response.data
