# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.rcs_capabilities_result import RcsCapabilitiesResult
from ..types.rcs_link_result import RcsLinkResult
from ..types.rcs_whitelist_response import RcsWhitelistResponse
from .raw_client import AsyncRawRcsClient, RawRcsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RcsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRcsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRcsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRcsClient
        """
        return self._raw_client

    def get_capabilities(
        self, *, phone_numbers: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> RcsCapabilitiesResult:
        """
        Check RCS capabilities for one or more phone numbers.

        This endpoint allows you to verify which RCS features (cards, buttons, etc.) are supported
        on specific phone numbers before sending RCS messages to them.

        Parameters
        ----------
        phone_numbers : typing.Sequence[str]
            List of phone numbers to check RCS capabilities for (E.164 format)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsCapabilitiesResult
            Returns RCS capabilities for each requested phone number.

            The response is a map where keys are phone numbers and values are either:
            - `null` if the number doesn't support RCS
            - An object containing supported cards and actions if RCS is supported

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.rcs.get_capabilities(
            phone_numbers=["+12345678901", "+19876543210"],
        )
        """
        _response = self._raw_client.get_capabilities(phone_numbers=phone_numbers, request_options=request_options)
        return _response.data

    def whitelist(
        self, *, agent_id: str, phone_number: str, request_options: typing.Optional[RequestOptions] = None
    ) -> RcsWhitelistResponse:
        """
        Whitelist a phone number for testing with your test RCS agent.

        ## Overview
        During development and testing, RCS agents can only send messages to whitelisted phone numbers.
        Use this endpoint to whitelist specific phone numbers to send and receive messages from the test agent.

        ## Verification Process
        After whitelisting a number, you'll need to complete verification:

        1. Check the test device for message from "RBM Tester Management"
        2. Click the "Make me a tester" button
        3. Enter the separate 4-digit verification SMS code in the Pinnacle dashboard at:
           ```
           https://app.pinnacle.sh/dashboard/brands/{brandId}?campaignId={campaignId}&campaignType=RCS
           ```

         > **⚠️ Important: Re-whitelisting Numbers**
        >
        > If you whitelist a number that's already whitelisted, you'll receive a new message from "RBM Tester Management". **You must click the "Make me a tester" button again to continue sending and receiving messages.**

        > **Important Notes**
        >
        > - **Verification required:** Messages cannot be sent nor received until you have clicked the "Make me a tester" button on the test device.
        > - **Testing only:** This is only required for test agents. Production agents can message any RCS-enabled number.
        > - **Network limitations:** Whitelisting may be temporarily unavailable for some carriers but are usually restored shortly.

        Parameters
        ----------
        agent_id : str
            The RCS agent ID (must be prefixed with 'agent_')

        phone_number : str
            Phone number to whitelist for testing (E.164 format)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsWhitelistResponse
            Phone number successfully whitelisted

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.rcs.whitelist(
            agent_id="agent_XXXXXXXXXXXX",
            phone_number="+12345678901",
        )
        """
        _response = self._raw_client.whitelist(
            agent_id=agent_id, phone_number=phone_number, request_options=request_options
        )
        return _response.data

    def get_link(
        self,
        *,
        agent_id: str,
        test_mode: typing.Optional[bool] = OMIT,
        phone_number: typing.Optional[str] = OMIT,
        body: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RcsLinkResult:
        """
        Generate a link for initiating an RCS conversation with your agent.

        Users can click these links to start conversations with your RCS agent directly
        from websites, emails, or other applications.

        Parameters
        ----------
        agent_id : str
            The RCS agent ID (must be prefixed with 'agent_')

        test_mode : typing.Optional[bool]
            Link to the test agent or the production agent if false

        phone_number : typing.Optional[str]
            Fallback phone number (E.164 format) to use if the phone number does not support RCS. If not provided, no url will be generated.

        body : typing.Optional[str]
            Optional message body to pre-fill after the user clicks the link

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsLinkResult
            Response containing the generated RCS service id and/or url.

            You can always create a link with the service id that is returned using the format:
            ```
            sms://{PHONE_NUMBER}?service_id={SERVICE_ID}&body={URL_ENCODED_BODY}
            ```

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.rcs.get_link(
            agent_id="agent_XXXXXXXXXXXX",
            test_mode=False,
            phone_number="+12345678901",
            body="Hello, I need help with my order",
        )
        """
        _response = self._raw_client.get_link(
            agent_id=agent_id,
            test_mode=test_mode,
            phone_number=phone_number,
            body=body,
            request_options=request_options,
        )
        return _response.data


class AsyncRcsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRcsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRcsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRcsClient
        """
        return self._raw_client

    async def get_capabilities(
        self, *, phone_numbers: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> RcsCapabilitiesResult:
        """
        Check RCS capabilities for one or more phone numbers.

        This endpoint allows you to verify which RCS features (cards, buttons, etc.) are supported
        on specific phone numbers before sending RCS messages to them.

        Parameters
        ----------
        phone_numbers : typing.Sequence[str]
            List of phone numbers to check RCS capabilities for (E.164 format)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsCapabilitiesResult
            Returns RCS capabilities for each requested phone number.

            The response is a map where keys are phone numbers and values are either:
            - `null` if the number doesn't support RCS
            - An object containing supported cards and actions if RCS is supported

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.rcs.get_capabilities(
                phone_numbers=["+12345678901", "+19876543210"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_capabilities(
            phone_numbers=phone_numbers, request_options=request_options
        )
        return _response.data

    async def whitelist(
        self, *, agent_id: str, phone_number: str, request_options: typing.Optional[RequestOptions] = None
    ) -> RcsWhitelistResponse:
        """
        Whitelist a phone number for testing with your test RCS agent.

        ## Overview
        During development and testing, RCS agents can only send messages to whitelisted phone numbers.
        Use this endpoint to whitelist specific phone numbers to send and receive messages from the test agent.

        ## Verification Process
        After whitelisting a number, you'll need to complete verification:

        1. Check the test device for message from "RBM Tester Management"
        2. Click the "Make me a tester" button
        3. Enter the separate 4-digit verification SMS code in the Pinnacle dashboard at:
           ```
           https://app.pinnacle.sh/dashboard/brands/{brandId}?campaignId={campaignId}&campaignType=RCS
           ```

         > **⚠️ Important: Re-whitelisting Numbers**
        >
        > If you whitelist a number that's already whitelisted, you'll receive a new message from "RBM Tester Management". **You must click the "Make me a tester" button again to continue sending and receiving messages.**

        > **Important Notes**
        >
        > - **Verification required:** Messages cannot be sent nor received until you have clicked the "Make me a tester" button on the test device.
        > - **Testing only:** This is only required for test agents. Production agents can message any RCS-enabled number.
        > - **Network limitations:** Whitelisting may be temporarily unavailable for some carriers but are usually restored shortly.

        Parameters
        ----------
        agent_id : str
            The RCS agent ID (must be prefixed with 'agent_')

        phone_number : str
            Phone number to whitelist for testing (E.164 format)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsWhitelistResponse
            Phone number successfully whitelisted

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.rcs.whitelist(
                agent_id="agent_XXXXXXXXXXXX",
                phone_number="+12345678901",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.whitelist(
            agent_id=agent_id, phone_number=phone_number, request_options=request_options
        )
        return _response.data

    async def get_link(
        self,
        *,
        agent_id: str,
        test_mode: typing.Optional[bool] = OMIT,
        phone_number: typing.Optional[str] = OMIT,
        body: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RcsLinkResult:
        """
        Generate a link for initiating an RCS conversation with your agent.

        Users can click these links to start conversations with your RCS agent directly
        from websites, emails, or other applications.

        Parameters
        ----------
        agent_id : str
            The RCS agent ID (must be prefixed with 'agent_')

        test_mode : typing.Optional[bool]
            Link to the test agent or the production agent if false

        phone_number : typing.Optional[str]
            Fallback phone number (E.164 format) to use if the phone number does not support RCS. If not provided, no url will be generated.

        body : typing.Optional[str]
            Optional message body to pre-fill after the user clicks the link

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsLinkResult
            Response containing the generated RCS service id and/or url.

            You can always create a link with the service id that is returned using the format:
            ```
            sms://{PHONE_NUMBER}?service_id={SERVICE_ID}&body={URL_ENCODED_BODY}
            ```

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.rcs.get_link(
                agent_id="agent_XXXXXXXXXXXX",
                test_mode=False,
                phone_number="+12345678901",
                body="Hello, I need help with my order",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_link(
            agent_id=agent_id,
            test_mode=test_mode,
            phone_number=phone_number,
            body=body,
            request_options=request_options,
        )
        return _response.data
