# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawStatusClient, RawStatusClient

if typing.TYPE_CHECKING:
    from .get.client import AsyncGetClient, GetClient


class StatusClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawStatusClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._get: typing.Optional[GetClient] = None

    @property
    def with_raw_response(self) -> RawStatusClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawStatusClient
        """
        return self._raw_client

    @property
    def get(self):
        if self._get is None:
            from .get.client import GetClient  # noqa: E402

            self._get = GetClient(client_wrapper=self._client_wrapper)
        return self._get


class AsyncStatusClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawStatusClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._get: typing.Optional[AsyncGetClient] = None

    @property
    def with_raw_response(self) -> AsyncRawStatusClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawStatusClient
        """
        return self._raw_client

    @property
    def get(self):
        if self._get is None:
            from .get.client import AsyncGetClient  # noqa: E402

            self._get = AsyncGetClient(client_wrapper=self._client_wrapper)
        return self._get
