# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.brand_status import BrandStatus
from ...types.dlc_campaign_status import DlcCampaignStatus
from ...types.phone_number_status import PhoneNumberStatus
from ...types.rcs_campaign_status import RcsCampaignStatus
from ...types.toll_free_campaign_status import TollFreeCampaignStatus
from .raw_client import AsyncRawGetClient, RawGetClient


class GetClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawGetClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawGetClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawGetClient
        """
        return self._raw_client

    def brand(self, brand_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> BrandStatus:
        """
        Retrieve a brand's status.

        Parameters
        ----------
        brand_id : str
            The unique identifier of the brand you want to retrieve the status for. This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BrandStatus
            Successfully retrieved.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.status.get.brand(
            brand_id="b_1234567890",
        )
        """
        _response = self._raw_client.brand(brand_id, request_options=request_options)
        return _response.data

    def toll_free(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TollFreeCampaignStatus:
        """
        Retrieve a toll-free campaign's status.

        Parameters
        ----------
        campaign_id : str
            The unique identifier of the toll-free campaign you want to retrieve the status for. This identifier is a string that always begins with the prefix `tf_`, for example: `tf_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TollFreeCampaignStatus
            Successfully retrieved.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.status.get.toll_free(
            campaign_id="tf_1234567890",
        )
        """
        _response = self._raw_client.toll_free(campaign_id, request_options=request_options)
        return _response.data

    def dlc(self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DlcCampaignStatus:
        """
        Retrieve a 10DLC campaign's status.

        Parameters
        ----------
        campaign_id : str
            The unique identifier of the 10DLC campaign you want to retrieve the status for. This identifier is a string that always begins with the prefix `dlc_`, for example: `dlc_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DlcCampaignStatus
            Successfully retrieved.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.status.get.dlc(
            campaign_id="dlc_1234567890",
        )
        """
        _response = self._raw_client.dlc(campaign_id, request_options=request_options)
        return _response.data

    def rcs(self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> RcsCampaignStatus:
        """
        Retrieve a RCS campaign's status.

        Parameters
        ----------
        campaign_id : str
            The unique identifier of the RCS campaign you want to retrieve the status for. This identifier is a string that always begins with the prefix `rcs_`, for example: `rcs_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsCampaignStatus
            Successfully retrieved.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.status.get.rcs(
            campaign_id="rcs_1234567890",
        )
        """
        _response = self._raw_client.rcs(campaign_id, request_options=request_options)
        return _response.data

    def phone_number(
        self, phone_number: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PhoneNumberStatus:
        """
        Retrieve a phone number's order status and campaign attachment status. <br>

        Check if a number is active and ready to send messages.

        Parameters
        ----------
        phone_number : str
            Phone number in E164 format that is in review.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneNumberStatus
            Successfully retrieved.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.status.get.phone_number(
            phone_number="+14151234567",
        )
        """
        _response = self._raw_client.phone_number(phone_number, request_options=request_options)
        return _response.data


class AsyncGetClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawGetClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawGetClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawGetClient
        """
        return self._raw_client

    async def brand(self, brand_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> BrandStatus:
        """
        Retrieve a brand's status.

        Parameters
        ----------
        brand_id : str
            The unique identifier of the brand you want to retrieve the status for. This identifier is a string that always begins with the prefix `b_`, for example: `b_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BrandStatus
            Successfully retrieved.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.status.get.brand(
                brand_id="b_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.brand(brand_id, request_options=request_options)
        return _response.data

    async def toll_free(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TollFreeCampaignStatus:
        """
        Retrieve a toll-free campaign's status.

        Parameters
        ----------
        campaign_id : str
            The unique identifier of the toll-free campaign you want to retrieve the status for. This identifier is a string that always begins with the prefix `tf_`, for example: `tf_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TollFreeCampaignStatus
            Successfully retrieved.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.status.get.toll_free(
                campaign_id="tf_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.toll_free(campaign_id, request_options=request_options)
        return _response.data

    async def dlc(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DlcCampaignStatus:
        """
        Retrieve a 10DLC campaign's status.

        Parameters
        ----------
        campaign_id : str
            The unique identifier of the 10DLC campaign you want to retrieve the status for. This identifier is a string that always begins with the prefix `dlc_`, for example: `dlc_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DlcCampaignStatus
            Successfully retrieved.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.status.get.dlc(
                campaign_id="dlc_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.dlc(campaign_id, request_options=request_options)
        return _response.data

    async def rcs(
        self, campaign_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RcsCampaignStatus:
        """
        Retrieve a RCS campaign's status.

        Parameters
        ----------
        campaign_id : str
            The unique identifier of the RCS campaign you want to retrieve the status for. This identifier is a string that always begins with the prefix `rcs_`, for example: `rcs_1234567890`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RcsCampaignStatus
            Successfully retrieved.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.status.get.rcs(
                campaign_id="rcs_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.rcs(campaign_id, request_options=request_options)
        return _response.data

    async def phone_number(
        self, phone_number: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PhoneNumberStatus:
        """
        Retrieve a phone number's order status and campaign attachment status. <br>

        Check if a number is active and ready to send messages.

        Parameters
        ----------
        phone_number : str
            Phone number in E164 format that is in review.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneNumberStatus
            Successfully retrieved.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.status.get.phone_number(
                phone_number="+14151234567",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.phone_number(phone_number, request_options=request_options)
        return _response.data
