# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawToolsClient, RawToolsClient

if typing.TYPE_CHECKING:
    from .contact_card.client import AsyncContactCardClient, ContactCardClient
    from .file.client import AsyncFileClient, FileClient
    from .url.client import AsyncUrlClient, UrlClient


class ToolsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawToolsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._url: typing.Optional[UrlClient] = None
        self._file: typing.Optional[FileClient] = None
        self._contact_card: typing.Optional[ContactCardClient] = None

    @property
    def with_raw_response(self) -> RawToolsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawToolsClient
        """
        return self._raw_client

    @property
    def url(self):
        if self._url is None:
            from .url.client import UrlClient  # noqa: E402

            self._url = UrlClient(client_wrapper=self._client_wrapper)
        return self._url

    @property
    def file(self):
        if self._file is None:
            from .file.client import FileClient  # noqa: E402

            self._file = FileClient(client_wrapper=self._client_wrapper)
        return self._file

    @property
    def contact_card(self):
        if self._contact_card is None:
            from .contact_card.client import ContactCardClient  # noqa: E402

            self._contact_card = ContactCardClient(client_wrapper=self._client_wrapper)
        return self._contact_card


class AsyncToolsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawToolsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._url: typing.Optional[AsyncUrlClient] = None
        self._file: typing.Optional[AsyncFileClient] = None
        self._contact_card: typing.Optional[AsyncContactCardClient] = None

    @property
    def with_raw_response(self) -> AsyncRawToolsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawToolsClient
        """
        return self._raw_client

    @property
    def url(self):
        if self._url is None:
            from .url.client import AsyncUrlClient  # noqa: E402

            self._url = AsyncUrlClient(client_wrapper=self._client_wrapper)
        return self._url

    @property
    def file(self):
        if self._file is None:
            from .file.client import AsyncFileClient  # noqa: E402

            self._file = AsyncFileClient(client_wrapper=self._client_wrapper)
        return self._file

    @property
    def contact_card(self):
        if self._contact_card is None:
            from .contact_card.client import AsyncContactCardClient  # noqa: E402

            self._contact_card = AsyncContactCardClient(client_wrapper=self._client_wrapper)
        return self._contact_card
