# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.v_card_data import VCardData
from ...types.v_card_geo import VCardGeo
from ...types.v_card_name import VCardName
from ...types.v_card_organization import VCardOrganization
from ...types.vcard_address import VcardAddress
from ...types.vcard_email import VcardEmail
from ...types.vcard_phone import VcardPhone
from ...types.vcard_resource import VcardResource
from .raw_client import AsyncRawContactCardClient, RawContactCardClient
from .types.get_v_card_schema_options import GetVCardSchemaOptions

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ContactCardClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawContactCardClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawContactCardClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawContactCardClient
        """
        return self._raw_client

    def get(
        self,
        *,
        id: str,
        options: typing.Optional[GetVCardSchemaOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> VCardData:
        """
        Retrieve contact information as a vCard and get a presigned URL to download the file. Contact cards can be sent [via MMS](/api-reference/messages/send-mms) as a media file.

        Parameters
        ----------
        id : str
            The unique identifier of the contact. This identifier is a string that always begins with the prefix `cc_`, for example: `cc_1234567890`.

        options : typing.Optional[GetVCardSchemaOptions]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VCardData
            Returns complete contact information.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.tools.contact_card.get(
            id="cc_1234567890",
        )
        """
        _response = self._raw_client.get(id=id, options=options, request_options=request_options)
        return _response.data

    def upsert(
        self,
        *,
        photo: typing.Optional[str] = OMIT,
        id: typing.Optional[str] = OMIT,
        formatted_name: typing.Optional[str] = OMIT,
        name: typing.Optional[VCardName] = OMIT,
        nickname: typing.Optional[typing.Sequence[str]] = OMIT,
        birthday: typing.Optional[str] = OMIT,
        addresses: typing.Optional[typing.Sequence[VcardAddress]] = OMIT,
        url: typing.Optional[str] = OMIT,
        phones: typing.Optional[typing.Sequence[VcardPhone]] = OMIT,
        emails: typing.Optional[typing.Sequence[VcardEmail]] = OMIT,
        timezone: typing.Optional[str] = OMIT,
        geo: typing.Optional[VCardGeo] = OMIT,
        title: typing.Optional[str] = OMIT,
        role: typing.Optional[str] = OMIT,
        organization: typing.Optional[VCardOrganization] = OMIT,
        categories: typing.Optional[typing.Sequence[str]] = OMIT,
        note: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> VcardResource:
        """
        Create a new contact card or updates an existing one with full vCard data. Contact cards can be sent [via MMS](/api-reference/messages/send-mms) as a media file.

        Parameters
        ----------
        photo : typing.Optional[str]
            Contact's photo

        id : typing.Optional[str]
            The unique identifier of the contact. This identifier is a string that always begins with the prefix `cc_`, for example: `cc_1234567890`.

        formatted_name : typing.Optional[str]
            Full display name for the vCard.

        name : typing.Optional[VCardName]
            Structured name components.

        nickname : typing.Optional[typing.Sequence[str]]
            Nicknames or aliases.

        birthday : typing.Optional[str]
            Birthday in ISO 8601 date format (YYYY-MM-DD).

        addresses : typing.Optional[typing.Sequence[VcardAddress]]
            Physical addresses.

        url : typing.Optional[str]
            Website URL.

        phones : typing.Optional[typing.Sequence[VcardPhone]]
            Phone numbers.

        emails : typing.Optional[typing.Sequence[VcardEmail]]
            Email addresses.

        timezone : typing.Optional[str]
            Timezone (e.g., "America/New_York").

        geo : typing.Optional[VCardGeo]
            Geographic coordinates.

        title : typing.Optional[str]
            Job title or position.

        role : typing.Optional[str]
            Role or function within the organization.

        organization : typing.Optional[VCardOrganization]
            Organization or company information.

        categories : typing.Optional[typing.Sequence[str]]
            Categories or tags for organizing contacts.

        note : typing.Optional[str]
            Additional notes or comments.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VcardResource
            Successfully created/updated contact card.

        Examples
        --------
        from rcs import (
            Pinnacle,
            VcardAddress,
            VcardEmail,
            VCardGeo,
            VCardName,
            VCardOrganization,
            VcardPhone,
        )

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.tools.contact_card.upsert(
            id="cc_1234567890",
            formatted_name="Jane Smith",
            name=VCardName(
                family_name="Smith",
                given_name="Jane",
                additional_names=["A."],
                honorific_prefixes=["Dr."],
                honorific_suffixes=["PhD"],
            ),
            nickname=["Janie"],
            birthday="1990-02-15",
            addresses=[
                VcardAddress(
                    country_name="USA",
                    extended_address="Apt. 4B",
                    locality="Anytown",
                    postal_code="90210",
                    post_office_box="PO Box 123",
                    region="CA",
                    street_address="123 Main St",
                    type=["HOME", "PREF"],
                )
            ],
            url="https://app.pinnacle.sh",
            phones=[
                VcardPhone(
                    type=["CELL"],
                    value="+15551234567",
                )
            ],
            emails=[
                VcardEmail(
                    type=["INTERNET"],
                    value="jane.smith@example.com",
                )
            ],
            timezone="America/Los_Angeles",
            geo=VCardGeo(
                latitude=34.0522,
                longitude=-118.2437,
            ),
            title="Engineer",
            role="Developer",
            organization=VCardOrganization(
                name="Acme Co",
                units=["Engineering", "R&D"],
            ),
            categories=["Friend", "Colleague"],
            note="Test contact entry",
            photo="https://fastly.picsum.photos/id/853/200/200.jpg?hmac=f4LF-tVBBnJb9PQAVEO8GCTGWgLUnxQLw44rUofE6mQ",
        )
        """
        _response = self._raw_client.upsert(
            photo=photo,
            id=id,
            formatted_name=formatted_name,
            name=name,
            nickname=nickname,
            birthday=birthday,
            addresses=addresses,
            url=url,
            phones=phones,
            emails=emails,
            timezone=timezone,
            geo=geo,
            title=title,
            role=role,
            organization=organization,
            categories=categories,
            note=note,
            request_options=request_options,
        )
        return _response.data


class AsyncContactCardClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawContactCardClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawContactCardClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawContactCardClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        id: str,
        options: typing.Optional[GetVCardSchemaOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> VCardData:
        """
        Retrieve contact information as a vCard and get a presigned URL to download the file. Contact cards can be sent [via MMS](/api-reference/messages/send-mms) as a media file.

        Parameters
        ----------
        id : str
            The unique identifier of the contact. This identifier is a string that always begins with the prefix `cc_`, for example: `cc_1234567890`.

        options : typing.Optional[GetVCardSchemaOptions]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VCardData
            Returns complete contact information.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.contact_card.get(
                id="cc_1234567890",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id=id, options=options, request_options=request_options)
        return _response.data

    async def upsert(
        self,
        *,
        photo: typing.Optional[str] = OMIT,
        id: typing.Optional[str] = OMIT,
        formatted_name: typing.Optional[str] = OMIT,
        name: typing.Optional[VCardName] = OMIT,
        nickname: typing.Optional[typing.Sequence[str]] = OMIT,
        birthday: typing.Optional[str] = OMIT,
        addresses: typing.Optional[typing.Sequence[VcardAddress]] = OMIT,
        url: typing.Optional[str] = OMIT,
        phones: typing.Optional[typing.Sequence[VcardPhone]] = OMIT,
        emails: typing.Optional[typing.Sequence[VcardEmail]] = OMIT,
        timezone: typing.Optional[str] = OMIT,
        geo: typing.Optional[VCardGeo] = OMIT,
        title: typing.Optional[str] = OMIT,
        role: typing.Optional[str] = OMIT,
        organization: typing.Optional[VCardOrganization] = OMIT,
        categories: typing.Optional[typing.Sequence[str]] = OMIT,
        note: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> VcardResource:
        """
        Create a new contact card or updates an existing one with full vCard data. Contact cards can be sent [via MMS](/api-reference/messages/send-mms) as a media file.

        Parameters
        ----------
        photo : typing.Optional[str]
            Contact's photo

        id : typing.Optional[str]
            The unique identifier of the contact. This identifier is a string that always begins with the prefix `cc_`, for example: `cc_1234567890`.

        formatted_name : typing.Optional[str]
            Full display name for the vCard.

        name : typing.Optional[VCardName]
            Structured name components.

        nickname : typing.Optional[typing.Sequence[str]]
            Nicknames or aliases.

        birthday : typing.Optional[str]
            Birthday in ISO 8601 date format (YYYY-MM-DD).

        addresses : typing.Optional[typing.Sequence[VcardAddress]]
            Physical addresses.

        url : typing.Optional[str]
            Website URL.

        phones : typing.Optional[typing.Sequence[VcardPhone]]
            Phone numbers.

        emails : typing.Optional[typing.Sequence[VcardEmail]]
            Email addresses.

        timezone : typing.Optional[str]
            Timezone (e.g., "America/New_York").

        geo : typing.Optional[VCardGeo]
            Geographic coordinates.

        title : typing.Optional[str]
            Job title or position.

        role : typing.Optional[str]
            Role or function within the organization.

        organization : typing.Optional[VCardOrganization]
            Organization or company information.

        categories : typing.Optional[typing.Sequence[str]]
            Categories or tags for organizing contacts.

        note : typing.Optional[str]
            Additional notes or comments.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VcardResource
            Successfully created/updated contact card.

        Examples
        --------
        import asyncio

        from rcs import (
            AsyncPinnacle,
            VcardAddress,
            VcardEmail,
            VCardGeo,
            VCardName,
            VCardOrganization,
            VcardPhone,
        )

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.contact_card.upsert(
                id="cc_1234567890",
                formatted_name="Jane Smith",
                name=VCardName(
                    family_name="Smith",
                    given_name="Jane",
                    additional_names=["A."],
                    honorific_prefixes=["Dr."],
                    honorific_suffixes=["PhD"],
                ),
                nickname=["Janie"],
                birthday="1990-02-15",
                addresses=[
                    VcardAddress(
                        country_name="USA",
                        extended_address="Apt. 4B",
                        locality="Anytown",
                        postal_code="90210",
                        post_office_box="PO Box 123",
                        region="CA",
                        street_address="123 Main St",
                        type=["HOME", "PREF"],
                    )
                ],
                url="https://app.pinnacle.sh",
                phones=[
                    VcardPhone(
                        type=["CELL"],
                        value="+15551234567",
                    )
                ],
                emails=[
                    VcardEmail(
                        type=["INTERNET"],
                        value="jane.smith@example.com",
                    )
                ],
                timezone="America/Los_Angeles",
                geo=VCardGeo(
                    latitude=34.0522,
                    longitude=-118.2437,
                ),
                title="Engineer",
                role="Developer",
                organization=VCardOrganization(
                    name="Acme Co",
                    units=["Engineering", "R&D"],
                ),
                categories=["Friend", "Colleague"],
                note="Test contact entry",
                photo="https://fastly.picsum.photos/id/853/200/200.jpg?hmac=f4LF-tVBBnJb9PQAVEO8GCTGWgLUnxQLw44rUofE6mQ",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upsert(
            photo=photo,
            id=id,
            formatted_name=formatted_name,
            name=name,
            nickname=nickname,
            birthday=birthday,
            addresses=addresses,
            url=url,
            phones=phones,
            emails=emails,
            timezone=timezone,
            geo=geo,
            title=title,
            role=role,
            organization=organization,
            categories=categories,
            note=note,
            request_options=request_options,
        )
        return _response.data
