# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.internal_server_error import InternalServerError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.error import Error
from ...types.v_card_data import VCardData
from ...types.v_card_geo import VCardGeo
from ...types.v_card_name import VCardName
from ...types.v_card_organization import VCardOrganization
from ...types.vcard_address import VcardAddress
from ...types.vcard_email import VcardEmail
from ...types.vcard_phone import VcardPhone
from ...types.vcard_resource import VcardResource
from .types.get_v_card_schema_options import GetVCardSchemaOptions

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawContactCardClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        *,
        id: str,
        options: typing.Optional[GetVCardSchemaOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[VCardData]:
        """
        Retrieve contact information as a vCard and get a presigned URL to download the file. Contact cards can be sent [via MMS](/api-reference/messages/send-mms) as a media file.

        Parameters
        ----------
        id : str
            The unique identifier of the contact. This identifier is a string that always begins with the prefix `cc_`, for example: `cc_1234567890`.

        options : typing.Optional[GetVCardSchemaOptions]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[VCardData]
            Returns complete contact information.
        """
        _response = self._client_wrapper.httpx_client.request(
            "tools/contact-card",
            method="POST",
            json={
                "id": id,
                "options": convert_and_respect_annotation_metadata(
                    object_=options, annotation=GetVCardSchemaOptions, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    VCardData,
                    parse_obj_as(
                        type_=VCardData,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upsert(
        self,
        *,
        photo: typing.Optional[str] = OMIT,
        id: typing.Optional[str] = OMIT,
        formatted_name: typing.Optional[str] = OMIT,
        name: typing.Optional[VCardName] = OMIT,
        nickname: typing.Optional[typing.Sequence[str]] = OMIT,
        birthday: typing.Optional[str] = OMIT,
        addresses: typing.Optional[typing.Sequence[VcardAddress]] = OMIT,
        url: typing.Optional[str] = OMIT,
        phones: typing.Optional[typing.Sequence[VcardPhone]] = OMIT,
        emails: typing.Optional[typing.Sequence[VcardEmail]] = OMIT,
        timezone: typing.Optional[str] = OMIT,
        geo: typing.Optional[VCardGeo] = OMIT,
        title: typing.Optional[str] = OMIT,
        role: typing.Optional[str] = OMIT,
        organization: typing.Optional[VCardOrganization] = OMIT,
        categories: typing.Optional[typing.Sequence[str]] = OMIT,
        note: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[VcardResource]:
        """
        Create a new contact card or updates an existing one with full vCard data. Contact cards can be sent [via MMS](/api-reference/messages/send-mms) as a media file.

        Parameters
        ----------
        photo : typing.Optional[str]
            Contact's photo

        id : typing.Optional[str]
            The unique identifier of the contact. This identifier is a string that always begins with the prefix `cc_`, for example: `cc_1234567890`.

        formatted_name : typing.Optional[str]
            Full display name for the vCard.

        name : typing.Optional[VCardName]
            Structured name components.

        nickname : typing.Optional[typing.Sequence[str]]
            Nicknames or aliases.

        birthday : typing.Optional[str]
            Birthday in ISO 8601 date format (YYYY-MM-DD).

        addresses : typing.Optional[typing.Sequence[VcardAddress]]
            Physical addresses.

        url : typing.Optional[str]
            Website URL.

        phones : typing.Optional[typing.Sequence[VcardPhone]]
            Phone numbers.

        emails : typing.Optional[typing.Sequence[VcardEmail]]
            Email addresses.

        timezone : typing.Optional[str]
            Timezone (e.g., "America/New_York").

        geo : typing.Optional[VCardGeo]
            Geographic coordinates.

        title : typing.Optional[str]
            Job title or position.

        role : typing.Optional[str]
            Role or function within the organization.

        organization : typing.Optional[VCardOrganization]
            Organization or company information.

        categories : typing.Optional[typing.Sequence[str]]
            Categories or tags for organizing contacts.

        note : typing.Optional[str]
            Additional notes or comments.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[VcardResource]
            Successfully created/updated contact card.
        """
        _response = self._client_wrapper.httpx_client.request(
            "tools/contact-card/upsert",
            method="POST",
            json={
                "photo": photo,
                "id": id,
                "formattedName": formatted_name,
                "name": convert_and_respect_annotation_metadata(object_=name, annotation=VCardName, direction="write"),
                "nickname": nickname,
                "birthday": birthday,
                "addresses": convert_and_respect_annotation_metadata(
                    object_=addresses, annotation=typing.Sequence[VcardAddress], direction="write"
                ),
                "url": url,
                "phones": convert_and_respect_annotation_metadata(
                    object_=phones, annotation=typing.Sequence[VcardPhone], direction="write"
                ),
                "emails": convert_and_respect_annotation_metadata(
                    object_=emails, annotation=typing.Sequence[VcardEmail], direction="write"
                ),
                "timezone": timezone,
                "geo": convert_and_respect_annotation_metadata(
                    object_=geo, annotation=typing.Optional[VCardGeo], direction="write"
                ),
                "title": title,
                "role": role,
                "organization": convert_and_respect_annotation_metadata(
                    object_=organization, annotation=VCardOrganization, direction="write"
                ),
                "categories": categories,
                "note": note,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    VcardResource,
                    parse_obj_as(
                        type_=VcardResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawContactCardClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        *,
        id: str,
        options: typing.Optional[GetVCardSchemaOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[VCardData]:
        """
        Retrieve contact information as a vCard and get a presigned URL to download the file. Contact cards can be sent [via MMS](/api-reference/messages/send-mms) as a media file.

        Parameters
        ----------
        id : str
            The unique identifier of the contact. This identifier is a string that always begins with the prefix `cc_`, for example: `cc_1234567890`.

        options : typing.Optional[GetVCardSchemaOptions]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[VCardData]
            Returns complete contact information.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "tools/contact-card",
            method="POST",
            json={
                "id": id,
                "options": convert_and_respect_annotation_metadata(
                    object_=options, annotation=GetVCardSchemaOptions, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    VCardData,
                    parse_obj_as(
                        type_=VCardData,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upsert(
        self,
        *,
        photo: typing.Optional[str] = OMIT,
        id: typing.Optional[str] = OMIT,
        formatted_name: typing.Optional[str] = OMIT,
        name: typing.Optional[VCardName] = OMIT,
        nickname: typing.Optional[typing.Sequence[str]] = OMIT,
        birthday: typing.Optional[str] = OMIT,
        addresses: typing.Optional[typing.Sequence[VcardAddress]] = OMIT,
        url: typing.Optional[str] = OMIT,
        phones: typing.Optional[typing.Sequence[VcardPhone]] = OMIT,
        emails: typing.Optional[typing.Sequence[VcardEmail]] = OMIT,
        timezone: typing.Optional[str] = OMIT,
        geo: typing.Optional[VCardGeo] = OMIT,
        title: typing.Optional[str] = OMIT,
        role: typing.Optional[str] = OMIT,
        organization: typing.Optional[VCardOrganization] = OMIT,
        categories: typing.Optional[typing.Sequence[str]] = OMIT,
        note: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[VcardResource]:
        """
        Create a new contact card or updates an existing one with full vCard data. Contact cards can be sent [via MMS](/api-reference/messages/send-mms) as a media file.

        Parameters
        ----------
        photo : typing.Optional[str]
            Contact's photo

        id : typing.Optional[str]
            The unique identifier of the contact. This identifier is a string that always begins with the prefix `cc_`, for example: `cc_1234567890`.

        formatted_name : typing.Optional[str]
            Full display name for the vCard.

        name : typing.Optional[VCardName]
            Structured name components.

        nickname : typing.Optional[typing.Sequence[str]]
            Nicknames or aliases.

        birthday : typing.Optional[str]
            Birthday in ISO 8601 date format (YYYY-MM-DD).

        addresses : typing.Optional[typing.Sequence[VcardAddress]]
            Physical addresses.

        url : typing.Optional[str]
            Website URL.

        phones : typing.Optional[typing.Sequence[VcardPhone]]
            Phone numbers.

        emails : typing.Optional[typing.Sequence[VcardEmail]]
            Email addresses.

        timezone : typing.Optional[str]
            Timezone (e.g., "America/New_York").

        geo : typing.Optional[VCardGeo]
            Geographic coordinates.

        title : typing.Optional[str]
            Job title or position.

        role : typing.Optional[str]
            Role or function within the organization.

        organization : typing.Optional[VCardOrganization]
            Organization or company information.

        categories : typing.Optional[typing.Sequence[str]]
            Categories or tags for organizing contacts.

        note : typing.Optional[str]
            Additional notes or comments.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[VcardResource]
            Successfully created/updated contact card.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "tools/contact-card/upsert",
            method="POST",
            json={
                "photo": photo,
                "id": id,
                "formattedName": formatted_name,
                "name": convert_and_respect_annotation_metadata(object_=name, annotation=VCardName, direction="write"),
                "nickname": nickname,
                "birthday": birthday,
                "addresses": convert_and_respect_annotation_metadata(
                    object_=addresses, annotation=typing.Sequence[VcardAddress], direction="write"
                ),
                "url": url,
                "phones": convert_and_respect_annotation_metadata(
                    object_=phones, annotation=typing.Sequence[VcardPhone], direction="write"
                ),
                "emails": convert_and_respect_annotation_metadata(
                    object_=emails, annotation=typing.Sequence[VcardEmail], direction="write"
                ),
                "timezone": timezone,
                "geo": convert_and_respect_annotation_metadata(
                    object_=geo, annotation=typing.Optional[VCardGeo], direction="write"
                ),
                "title": title,
                "role": role,
                "organization": convert_and_respect_annotation_metadata(
                    object_=organization, annotation=VCardOrganization, direction="write"
                ),
                "categories": categories,
                "note": note,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    VcardResource,
                    parse_obj_as(
                        type_=VcardResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        parse_obj_as(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
