# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.refreshed_file import RefreshedFile
from ...types.upload_results import UploadResults
from .raw_client import AsyncRawFileClient, RawFileClient
from .types.upload_file_options import UploadFileOptions

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FileClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFileClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFileClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFileClient
        """
        return self._raw_client

    def upload(
        self,
        *,
        content_type: str,
        size: int,
        name: typing.Optional[str] = OMIT,
        options: typing.Optional[UploadFileOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UploadResults:
        """
        Generate presigned URLs that let you upload files directly to our storage and allow your users to download them securely.

        Parameters
        ----------
        content_type : str
            MIME type of your file. <br>

            Supported file types:
            - Audio: mp3, mp4, mpeg, ogg, aac, webm, wav, 3gpp, amr
            - Video: mp4, mpeg, quicktime, webm, 3gpp, H.264, m4v
            - Image: jpeg, png, gif, bmp, tiff, webp
            - Documents: pdf, csv, rtf, calendar, vcard

        size : int
            Size of your file in bytes. Should be less than 100 MB.

        name : typing.Optional[str]
            Name of your file.

        options : typing.Optional[UploadFileOptions]
            Additional configurations for your file.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UploadResults
            Successfully uploaded the file.

        Examples
        --------
        from rcs import Pinnacle
        from rcs.tools.file import DownloadOptions, UploadFileOptions

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.tools.file.upload(
            content_type="image/jpeg",
            size=1024,
            name="test.jpg",
            options=UploadFileOptions(
                delete_at="2025-12-31T23:59:59Z",
                download=DownloadOptions(
                    expires_at="2025-06-30T12:00:00.000Z",
                ),
            ),
        )
        """
        _response = self._raw_client.upload(
            content_type=content_type, size=size, name=name, options=options, request_options=request_options
        )
        return _response.data

    def refresh(
        self, *, urls: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[RefreshedFile]:
        """
        Refresh expiring presigned URLs for Pinnacle-hosted files to extend their access time.

        <Callout type="info">
          This only works for presigned download URLs. At this moment, you cannot refresh a presigned upload URL, generate a new one instead.
        </Callout>

        Parameters
        ----------
        urls : typing.Sequence[str]
            Array of file URLs to refresh for extended access. Provided URLs must be presigned URLs (i.e. `https://server.trypinnacle.app/storage/v1/object/sign/...`). Invalid or external URLs will be returned unchanged in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[RefreshedFile]
            Successfully refreshed file URLs.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.tools.file.refresh(
            urls=[
                "https://server.trypinnacle.app/storage/v1/object/sign/vault/3/test.jpg?token=oldtoken",
                "https://server.trypinnacle.app/storage/v1/object/sign/vault/3/document.pdf?token=oldtoken2",
                "invalid/url",
                "https://google.com",
            ],
        )
        """
        _response = self._raw_client.refresh(urls=urls, request_options=request_options)
        return _response.data


class AsyncFileClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFileClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFileClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFileClient
        """
        return self._raw_client

    async def upload(
        self,
        *,
        content_type: str,
        size: int,
        name: typing.Optional[str] = OMIT,
        options: typing.Optional[UploadFileOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UploadResults:
        """
        Generate presigned URLs that let you upload files directly to our storage and allow your users to download them securely.

        Parameters
        ----------
        content_type : str
            MIME type of your file. <br>

            Supported file types:
            - Audio: mp3, mp4, mpeg, ogg, aac, webm, wav, 3gpp, amr
            - Video: mp4, mpeg, quicktime, webm, 3gpp, H.264, m4v
            - Image: jpeg, png, gif, bmp, tiff, webp
            - Documents: pdf, csv, rtf, calendar, vcard

        size : int
            Size of your file in bytes. Should be less than 100 MB.

        name : typing.Optional[str]
            Name of your file.

        options : typing.Optional[UploadFileOptions]
            Additional configurations for your file.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UploadResults
            Successfully uploaded the file.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle
        from rcs.tools.file import DownloadOptions, UploadFileOptions

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.file.upload(
                content_type="image/jpeg",
                size=1024,
                name="test.jpg",
                options=UploadFileOptions(
                    delete_at="2025-12-31T23:59:59Z",
                    download=DownloadOptions(
                        expires_at="2025-06-30T12:00:00.000Z",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upload(
            content_type=content_type, size=size, name=name, options=options, request_options=request_options
        )
        return _response.data

    async def refresh(
        self, *, urls: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[RefreshedFile]:
        """
        Refresh expiring presigned URLs for Pinnacle-hosted files to extend their access time.

        <Callout type="info">
          This only works for presigned download URLs. At this moment, you cannot refresh a presigned upload URL, generate a new one instead.
        </Callout>

        Parameters
        ----------
        urls : typing.Sequence[str]
            Array of file URLs to refresh for extended access. Provided URLs must be presigned URLs (i.e. `https://server.trypinnacle.app/storage/v1/object/sign/...`). Invalid or external URLs will be returned unchanged in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[RefreshedFile]
            Successfully refreshed file URLs.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.file.refresh(
                urls=[
                    "https://server.trypinnacle.app/storage/v1/object/sign/vault/3/test.jpg?token=oldtoken",
                    "https://server.trypinnacle.app/storage/v1/object/sign/vault/3/document.pdf?token=oldtoken2",
                    "invalid/url",
                    "https://google.com",
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.refresh(urls=urls, request_options=request_options)
        return _response.data
